// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains the Amazon Resource Name (ARN) of the resource to publish to, such as an S3
/// bucket, and the ARN of the KMS key to use to encrypt published findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationProperties {
    /// <p>The ARN of the resource to publish to.</p>
    pub destination_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the KMS key to use for encryption.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DestinationProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationProperties");
        formatter.field("destination_arn", &self.destination_arn);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`DestinationProperties`](crate::model::DestinationProperties)
pub mod destination_properties {
    /// A builder for [`DestinationProperties`](crate::model::DestinationProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource to publish to.</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource to publish to.</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// <p>The ARN of the KMS key to use for encryption.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the KMS key to use for encryption.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationProperties`](crate::model::DestinationProperties)
        pub fn build(self) -> crate::model::DestinationProperties {
            crate::model::DestinationProperties {
                destination_arn: self.destination_arn,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl DestinationProperties {
    /// Creates a new builder-style object to manufacture [`DestinationProperties`](crate::model::DestinationProperties)
    pub fn builder() -> crate::model::destination_properties::Builder {
        crate::model::destination_properties::Builder::default()
    }
}

/// <p>An object that contains information on which data sources will be configured to be
/// automatically enabled for new members within the organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationDataSourceConfigurations {
    /// <p>Describes whether S3 data event logs are enabled for new members of the
    /// organization.</p>
    pub s3_logs: std::option::Option<crate::model::OrganizationS3LogsConfiguration>,
}
impl std::fmt::Debug for OrganizationDataSourceConfigurations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationDataSourceConfigurations");
        formatter.field("s3_logs", &self.s3_logs);
        formatter.finish()
    }
}
/// See [`OrganizationDataSourceConfigurations`](crate::model::OrganizationDataSourceConfigurations)
pub mod organization_data_source_configurations {
    /// A builder for [`OrganizationDataSourceConfigurations`](crate::model::OrganizationDataSourceConfigurations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_logs: std::option::Option<crate::model::OrganizationS3LogsConfiguration>,
    }
    impl Builder {
        /// <p>Describes whether S3 data event logs are enabled for new members of the
        /// organization.</p>
        pub fn s3_logs(mut self, input: crate::model::OrganizationS3LogsConfiguration) -> Self {
            self.s3_logs = Some(input);
            self
        }
        /// <p>Describes whether S3 data event logs are enabled for new members of the
        /// organization.</p>
        pub fn set_s3_logs(
            mut self,
            input: std::option::Option<crate::model::OrganizationS3LogsConfiguration>,
        ) -> Self {
            self.s3_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationDataSourceConfigurations`](crate::model::OrganizationDataSourceConfigurations)
        pub fn build(self) -> crate::model::OrganizationDataSourceConfigurations {
            crate::model::OrganizationDataSourceConfigurations {
                s3_logs: self.s3_logs,
            }
        }
    }
}
impl OrganizationDataSourceConfigurations {
    /// Creates a new builder-style object to manufacture [`OrganizationDataSourceConfigurations`](crate::model::OrganizationDataSourceConfigurations)
    pub fn builder() -> crate::model::organization_data_source_configurations::Builder {
        crate::model::organization_data_source_configurations::Builder::default()
    }
}

/// <p>Describes whether S3 data event logs will be automatically enabled for new members of the
/// organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationS3LogsConfiguration {
    /// <p>A value that contains information on whether S3 data event logs will be enabled
    /// automatically as a data source for the organization.</p>
    pub auto_enable: bool,
}
impl std::fmt::Debug for OrganizationS3LogsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationS3LogsConfiguration");
        formatter.field("auto_enable", &self.auto_enable);
        formatter.finish()
    }
}
/// See [`OrganizationS3LogsConfiguration`](crate::model::OrganizationS3LogsConfiguration)
pub mod organization_s3_logs_configuration {
    /// A builder for [`OrganizationS3LogsConfiguration`](crate::model::OrganizationS3LogsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_enable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A value that contains information on whether S3 data event logs will be enabled
        /// automatically as a data source for the organization.</p>
        pub fn auto_enable(mut self, input: bool) -> Self {
            self.auto_enable = Some(input);
            self
        }
        /// <p>A value that contains information on whether S3 data event logs will be enabled
        /// automatically as a data source for the organization.</p>
        pub fn set_auto_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_enable = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationS3LogsConfiguration`](crate::model::OrganizationS3LogsConfiguration)
        pub fn build(self) -> crate::model::OrganizationS3LogsConfiguration {
            crate::model::OrganizationS3LogsConfiguration {
                auto_enable: self.auto_enable.unwrap_or_default(),
            }
        }
    }
}
impl OrganizationS3LogsConfiguration {
    /// Creates a new builder-style object to manufacture [`OrganizationS3LogsConfiguration`](crate::model::OrganizationS3LogsConfiguration)
    pub fn builder() -> crate::model::organization_s3_logs_configuration::Builder {
        crate::model::organization_s3_logs_configuration::Builder::default()
    }
}

/// <p>Contains information about the accounts that weren't processed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessedAccount {
    /// <p>The AWS account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>A reason why the account hasn't been processed.</p>
    pub result: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnprocessedAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessedAccount");
        formatter.field("account_id", &self.account_id);
        formatter.field("result", &self.result);
        formatter.finish()
    }
}
/// See [`UnprocessedAccount`](crate::model::UnprocessedAccount)
pub mod unprocessed_account {
    /// A builder for [`UnprocessedAccount`](crate::model::UnprocessedAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) result: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>A reason why the account hasn't been processed.</p>
        pub fn result(mut self, input: impl Into<std::string::String>) -> Self {
            self.result = Some(input.into());
            self
        }
        /// <p>A reason why the account hasn't been processed.</p>
        pub fn set_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.result = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessedAccount`](crate::model::UnprocessedAccount)
        pub fn build(self) -> crate::model::UnprocessedAccount {
            crate::model::UnprocessedAccount {
                account_id: self.account_id,
                result: self.result,
            }
        }
    }
}
impl UnprocessedAccount {
    /// Creates a new builder-style object to manufacture [`UnprocessedAccount`](crate::model::UnprocessedAccount)
    pub fn builder() -> crate::model::unprocessed_account::Builder {
        crate::model::unprocessed_account::Builder::default()
    }
}

/// <p>Contains information about which data sources are enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceConfigurations {
    /// <p>Describes whether S3 data event logs are enabled as a data source.</p>
    pub s3_logs: std::option::Option<crate::model::S3LogsConfiguration>,
}
impl std::fmt::Debug for DataSourceConfigurations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceConfigurations");
        formatter.field("s3_logs", &self.s3_logs);
        formatter.finish()
    }
}
/// See [`DataSourceConfigurations`](crate::model::DataSourceConfigurations)
pub mod data_source_configurations {
    /// A builder for [`DataSourceConfigurations`](crate::model::DataSourceConfigurations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_logs: std::option::Option<crate::model::S3LogsConfiguration>,
    }
    impl Builder {
        /// <p>Describes whether S3 data event logs are enabled as a data source.</p>
        pub fn s3_logs(mut self, input: crate::model::S3LogsConfiguration) -> Self {
            self.s3_logs = Some(input);
            self
        }
        /// <p>Describes whether S3 data event logs are enabled as a data source.</p>
        pub fn set_s3_logs(
            mut self,
            input: std::option::Option<crate::model::S3LogsConfiguration>,
        ) -> Self {
            self.s3_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceConfigurations`](crate::model::DataSourceConfigurations)
        pub fn build(self) -> crate::model::DataSourceConfigurations {
            crate::model::DataSourceConfigurations {
                s3_logs: self.s3_logs,
            }
        }
    }
}
impl DataSourceConfigurations {
    /// Creates a new builder-style object to manufacture [`DataSourceConfigurations`](crate::model::DataSourceConfigurations)
    pub fn builder() -> crate::model::data_source_configurations::Builder {
        crate::model::data_source_configurations::Builder::default()
    }
}

/// <p>Describes whether S3 data event logs will be enabled as a data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3LogsConfiguration {
    /// <p> The status of S3 data event logs as a data source.</p>
    pub enable: bool,
}
impl std::fmt::Debug for S3LogsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3LogsConfiguration");
        formatter.field("enable", &self.enable);
        formatter.finish()
    }
}
/// See [`S3LogsConfiguration`](crate::model::S3LogsConfiguration)
pub mod s3_logs_configuration {
    /// A builder for [`S3LogsConfiguration`](crate::model::S3LogsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The status of S3 data event logs as a data source.</p>
        pub fn enable(mut self, input: bool) -> Self {
            self.enable = Some(input);
            self
        }
        /// <p> The status of S3 data event logs as a data source.</p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.enable = input;
            self
        }
        /// Consumes the builder and constructs a [`S3LogsConfiguration`](crate::model::S3LogsConfiguration)
        pub fn build(self) -> crate::model::S3LogsConfiguration {
            crate::model::S3LogsConfiguration {
                enable: self.enable.unwrap_or_default(),
            }
        }
    }
}
impl S3LogsConfiguration {
    /// Creates a new builder-style object to manufacture [`S3LogsConfiguration`](crate::model::S3LogsConfiguration)
    pub fn builder() -> crate::model::s3_logs_configuration::Builder {
        crate::model::s3_logs_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Feedback {
    #[allow(missing_docs)] // documentation missing in model
    NotUseful,
    #[allow(missing_docs)] // documentation missing in model
    Useful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Feedback {
    fn from(s: &str) -> Self {
        match s {
            "NOT_USEFUL" => Feedback::NotUseful,
            "USEFUL" => Feedback::Useful,
            other => Feedback::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Feedback {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Feedback::from(s))
    }
}
impl Feedback {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Feedback::NotUseful => "NOT_USEFUL",
            Feedback::Useful => "USEFUL",
            Feedback::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_USEFUL", "USEFUL"]
    }
}
impl AsRef<str> for Feedback {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the criteria used for querying findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingCriteria {
    /// <p>Represents a map of finding properties that match specified conditions and values when
    /// querying findings.</p>
    pub criterion: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Condition>,
    >,
}
impl std::fmt::Debug for FindingCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingCriteria");
        formatter.field("criterion", &self.criterion);
        formatter.finish()
    }
}
/// See [`FindingCriteria`](crate::model::FindingCriteria)
pub mod finding_criteria {
    /// A builder for [`FindingCriteria`](crate::model::FindingCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) criterion: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Condition>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `criterion`.
        ///
        /// To override the contents of this collection use [`set_criterion`](Self::set_criterion).
        ///
        /// <p>Represents a map of finding properties that match specified conditions and values when
        /// querying findings.</p>
        pub fn criterion(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Condition>,
        ) -> Self {
            let mut hash_map = self.criterion.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.criterion = Some(hash_map);
            self
        }
        /// <p>Represents a map of finding properties that match specified conditions and values when
        /// querying findings.</p>
        pub fn set_criterion(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Condition>,
            >,
        ) -> Self {
            self.criterion = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingCriteria`](crate::model::FindingCriteria)
        pub fn build(self) -> crate::model::FindingCriteria {
            crate::model::FindingCriteria {
                criterion: self.criterion,
            }
        }
    }
}
impl FindingCriteria {
    /// Creates a new builder-style object to manufacture [`FindingCriteria`](crate::model::FindingCriteria)
    pub fn builder() -> crate::model::finding_criteria::Builder {
        crate::model::finding_criteria::Builder::default()
    }
}

/// <p>Contains information about the condition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Condition {
    /// <p>Represents the <i>equal</i> condition to be applied to a single field when
    /// querying for findings.</p>
    pub eq: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Represents the <i>not equal</i> condition to be applied to a single field
    /// when querying for findings.</p>
    pub neq: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Represents a <i>greater than</i> condition to be applied to a single field
    /// when querying for findings.</p>
    pub gt: i32,
    /// <p>Represents a <i>greater than or equal</i> condition to be applied to a
    /// single field when querying for findings.</p>
    pub gte: i32,
    /// <p>Represents a <i>less than</i> condition to be applied to a single field when
    /// querying for findings.</p>
    pub lt: i32,
    /// <p>Represents a <i>less than or equal</i> condition to be applied to a single
    /// field when querying for findings.</p>
    pub lte: i32,
    /// <p>Represents an <i>equal</i>
    /// <b></b> condition to be applied to
    /// a single field when querying for findings.</p>
    pub equals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Represents a <i>not equal</i>
    /// <b></b> condition to be applied
    /// to a single field when querying for findings.</p>
    pub not_equals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Represents a <i>greater than</i> condition to be applied to a single field
    /// when querying for findings.</p>
    pub greater_than: i64,
    /// <p>Represents a <i>greater than or equal</i> condition to be applied to a
    /// single field when querying for findings.</p>
    pub greater_than_or_equal: i64,
    /// <p>Represents a <i>less than</i> condition to be applied to a single field when
    /// querying for findings.</p>
    pub less_than: i64,
    /// <p>Represents a <i>less than or equal</i> condition to be applied to a single
    /// field when querying for findings.</p>
    pub less_than_or_equal: i64,
}
impl std::fmt::Debug for Condition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Condition");
        formatter.field("eq", &self.eq);
        formatter.field("neq", &self.neq);
        formatter.field("gt", &self.gt);
        formatter.field("gte", &self.gte);
        formatter.field("lt", &self.lt);
        formatter.field("lte", &self.lte);
        formatter.field("equals", &self.equals);
        formatter.field("not_equals", &self.not_equals);
        formatter.field("greater_than", &self.greater_than);
        formatter.field("greater_than_or_equal", &self.greater_than_or_equal);
        formatter.field("less_than", &self.less_than);
        formatter.field("less_than_or_equal", &self.less_than_or_equal);
        formatter.finish()
    }
}
/// See [`Condition`](crate::model::Condition)
pub mod condition {
    /// A builder for [`Condition`](crate::model::Condition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eq: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) neq: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) gt: std::option::Option<i32>,
        pub(crate) gte: std::option::Option<i32>,
        pub(crate) lt: std::option::Option<i32>,
        pub(crate) lte: std::option::Option<i32>,
        pub(crate) equals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) not_equals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) greater_than: std::option::Option<i64>,
        pub(crate) greater_than_or_equal: std::option::Option<i64>,
        pub(crate) less_than: std::option::Option<i64>,
        pub(crate) less_than_or_equal: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `eq`.
        ///
        /// To override the contents of this collection use [`set_eq`](Self::set_eq).
        ///
        /// <p>Represents the <i>equal</i> condition to be applied to a single field when
        /// querying for findings.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.eq.unwrap_or_default();
            v.push(input.into());
            self.eq = Some(v);
            self
        }
        /// <p>Represents the <i>equal</i> condition to be applied to a single field when
        /// querying for findings.</p>
        pub fn set_eq(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.eq = input;
            self
        }
        /// Appends an item to `neq`.
        ///
        /// To override the contents of this collection use [`set_neq`](Self::set_neq).
        ///
        /// <p>Represents the <i>not equal</i> condition to be applied to a single field
        /// when querying for findings.</p>
        pub fn neq(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.neq.unwrap_or_default();
            v.push(input.into());
            self.neq = Some(v);
            self
        }
        /// <p>Represents the <i>not equal</i> condition to be applied to a single field
        /// when querying for findings.</p>
        pub fn set_neq(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.neq = input;
            self
        }
        /// <p>Represents a <i>greater than</i> condition to be applied to a single field
        /// when querying for findings.</p>
        pub fn gt(mut self, input: i32) -> Self {
            self.gt = Some(input);
            self
        }
        /// <p>Represents a <i>greater than</i> condition to be applied to a single field
        /// when querying for findings.</p>
        pub fn set_gt(mut self, input: std::option::Option<i32>) -> Self {
            self.gt = input;
            self
        }
        /// <p>Represents a <i>greater than or equal</i> condition to be applied to a
        /// single field when querying for findings.</p>
        pub fn gte(mut self, input: i32) -> Self {
            self.gte = Some(input);
            self
        }
        /// <p>Represents a <i>greater than or equal</i> condition to be applied to a
        /// single field when querying for findings.</p>
        pub fn set_gte(mut self, input: std::option::Option<i32>) -> Self {
            self.gte = input;
            self
        }
        /// <p>Represents a <i>less than</i> condition to be applied to a single field when
        /// querying for findings.</p>
        pub fn lt(mut self, input: i32) -> Self {
            self.lt = Some(input);
            self
        }
        /// <p>Represents a <i>less than</i> condition to be applied to a single field when
        /// querying for findings.</p>
        pub fn set_lt(mut self, input: std::option::Option<i32>) -> Self {
            self.lt = input;
            self
        }
        /// <p>Represents a <i>less than or equal</i> condition to be applied to a single
        /// field when querying for findings.</p>
        pub fn lte(mut self, input: i32) -> Self {
            self.lte = Some(input);
            self
        }
        /// <p>Represents a <i>less than or equal</i> condition to be applied to a single
        /// field when querying for findings.</p>
        pub fn set_lte(mut self, input: std::option::Option<i32>) -> Self {
            self.lte = input;
            self
        }
        /// Appends an item to `equals`.
        ///
        /// To override the contents of this collection use [`set_equals`](Self::set_equals).
        ///
        /// <p>Represents an <i>equal</i>
        /// <b></b> condition to be applied to
        /// a single field when querying for findings.</p>
        pub fn equals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.equals.unwrap_or_default();
            v.push(input.into());
            self.equals = Some(v);
            self
        }
        /// <p>Represents an <i>equal</i>
        /// <b></b> condition to be applied to
        /// a single field when querying for findings.</p>
        pub fn set_equals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.equals = input;
            self
        }
        /// Appends an item to `not_equals`.
        ///
        /// To override the contents of this collection use [`set_not_equals`](Self::set_not_equals).
        ///
        /// <p>Represents a <i>not equal</i>
        /// <b></b> condition to be applied
        /// to a single field when querying for findings.</p>
        pub fn not_equals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.not_equals.unwrap_or_default();
            v.push(input.into());
            self.not_equals = Some(v);
            self
        }
        /// <p>Represents a <i>not equal</i>
        /// <b></b> condition to be applied
        /// to a single field when querying for findings.</p>
        pub fn set_not_equals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.not_equals = input;
            self
        }
        /// <p>Represents a <i>greater than</i> condition to be applied to a single field
        /// when querying for findings.</p>
        pub fn greater_than(mut self, input: i64) -> Self {
            self.greater_than = Some(input);
            self
        }
        /// <p>Represents a <i>greater than</i> condition to be applied to a single field
        /// when querying for findings.</p>
        pub fn set_greater_than(mut self, input: std::option::Option<i64>) -> Self {
            self.greater_than = input;
            self
        }
        /// <p>Represents a <i>greater than or equal</i> condition to be applied to a
        /// single field when querying for findings.</p>
        pub fn greater_than_or_equal(mut self, input: i64) -> Self {
            self.greater_than_or_equal = Some(input);
            self
        }
        /// <p>Represents a <i>greater than or equal</i> condition to be applied to a
        /// single field when querying for findings.</p>
        pub fn set_greater_than_or_equal(mut self, input: std::option::Option<i64>) -> Self {
            self.greater_than_or_equal = input;
            self
        }
        /// <p>Represents a <i>less than</i> condition to be applied to a single field when
        /// querying for findings.</p>
        pub fn less_than(mut self, input: i64) -> Self {
            self.less_than = Some(input);
            self
        }
        /// <p>Represents a <i>less than</i> condition to be applied to a single field when
        /// querying for findings.</p>
        pub fn set_less_than(mut self, input: std::option::Option<i64>) -> Self {
            self.less_than = input;
            self
        }
        /// <p>Represents a <i>less than or equal</i> condition to be applied to a single
        /// field when querying for findings.</p>
        pub fn less_than_or_equal(mut self, input: i64) -> Self {
            self.less_than_or_equal = Some(input);
            self
        }
        /// <p>Represents a <i>less than or equal</i> condition to be applied to a single
        /// field when querying for findings.</p>
        pub fn set_less_than_or_equal(mut self, input: std::option::Option<i64>) -> Self {
            self.less_than_or_equal = input;
            self
        }
        /// Consumes the builder and constructs a [`Condition`](crate::model::Condition)
        pub fn build(self) -> crate::model::Condition {
            crate::model::Condition {
                eq: self.eq,
                neq: self.neq,
                gt: self.gt.unwrap_or_default(),
                gte: self.gte.unwrap_or_default(),
                lt: self.lt.unwrap_or_default(),
                lte: self.lte.unwrap_or_default(),
                equals: self.equals,
                not_equals: self.not_equals,
                greater_than: self.greater_than.unwrap_or_default(),
                greater_than_or_equal: self.greater_than_or_equal.unwrap_or_default(),
                less_than: self.less_than.unwrap_or_default(),
                less_than_or_equal: self.less_than_or_equal.unwrap_or_default(),
            }
        }
    }
}
impl Condition {
    /// Creates a new builder-style object to manufacture [`Condition`](crate::model::Condition)
    pub fn builder() -> crate::model::condition::Builder {
        crate::model::condition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterAction {
    #[allow(missing_docs)] // documentation missing in model
    Archive,
    #[allow(missing_docs)] // documentation missing in model
    Noop,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterAction {
    fn from(s: &str) -> Self {
        match s {
            "ARCHIVE" => FilterAction::Archive,
            "NOOP" => FilterAction::Noop,
            other => FilterAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterAction::from(s))
    }
}
impl FilterAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterAction::Archive => "ARCHIVE",
            FilterAction::Noop => "NOOP",
            FilterAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ARCHIVE", "NOOP"]
    }
}
impl AsRef<str> for FilterAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingPublishingFrequency {
    #[allow(missing_docs)] // documentation missing in model
    FifteenMinutes,
    #[allow(missing_docs)] // documentation missing in model
    OneHour,
    #[allow(missing_docs)] // documentation missing in model
    SixHours,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingPublishingFrequency {
    fn from(s: &str) -> Self {
        match s {
            "FIFTEEN_MINUTES" => FindingPublishingFrequency::FifteenMinutes,
            "ONE_HOUR" => FindingPublishingFrequency::OneHour,
            "SIX_HOURS" => FindingPublishingFrequency::SixHours,
            other => FindingPublishingFrequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingPublishingFrequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingPublishingFrequency::from(s))
    }
}
impl FindingPublishingFrequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingPublishingFrequency::FifteenMinutes => "FIFTEEN_MINUTES",
            FindingPublishingFrequency::OneHour => "ONE_HOUR",
            FindingPublishingFrequency::SixHours => "SIX_HOURS",
            FindingPublishingFrequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FIFTEEN_MINUTES", "ONE_HOUR", "SIX_HOURS"]
    }
}
impl AsRef<str> for FindingPublishingFrequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the publishing destination, including the ID, type, and
/// status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Destination {
    /// <p>The unique ID of the publishing destination.</p>
    pub destination_id: std::option::Option<std::string::String>,
    /// <p>The type of resource used for the publishing destination. Currently, only Amazon S3
    /// buckets are supported.</p>
    pub destination_type: std::option::Option<crate::model::DestinationType>,
    /// <p>The status of the publishing destination.</p>
    pub status: std::option::Option<crate::model::PublishingStatus>,
}
impl std::fmt::Debug for Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Destination");
        formatter.field("destination_id", &self.destination_id);
        formatter.field("destination_type", &self.destination_type);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`Destination`](crate::model::Destination)
pub mod destination {
    /// A builder for [`Destination`](crate::model::Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_id: std::option::Option<std::string::String>,
        pub(crate) destination_type: std::option::Option<crate::model::DestinationType>,
        pub(crate) status: std::option::Option<crate::model::PublishingStatus>,
    }
    impl Builder {
        /// <p>The unique ID of the publishing destination.</p>
        pub fn destination_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the publishing destination.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_id = input;
            self
        }
        /// <p>The type of resource used for the publishing destination. Currently, only Amazon S3
        /// buckets are supported.</p>
        pub fn destination_type(mut self, input: crate::model::DestinationType) -> Self {
            self.destination_type = Some(input);
            self
        }
        /// <p>The type of resource used for the publishing destination. Currently, only Amazon S3
        /// buckets are supported.</p>
        pub fn set_destination_type(
            mut self,
            input: std::option::Option<crate::model::DestinationType>,
        ) -> Self {
            self.destination_type = input;
            self
        }
        /// <p>The status of the publishing destination.</p>
        pub fn status(mut self, input: crate::model::PublishingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the publishing destination.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PublishingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`Destination`](crate::model::Destination)
        pub fn build(self) -> crate::model::Destination {
            crate::model::Destination {
                destination_id: self.destination_id,
                destination_type: self.destination_type,
                status: self.status,
            }
        }
    }
}
impl Destination {
    /// Creates a new builder-style object to manufacture [`Destination`](crate::model::Destination)
    pub fn builder() -> crate::model::destination::Builder {
        crate::model::destination::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PublishingStatus {
    #[allow(missing_docs)] // documentation missing in model
    PendingVerification,
    #[allow(missing_docs)] // documentation missing in model
    Publishing,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    UnableToPublishFixDestinationProperty,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PublishingStatus {
    fn from(s: &str) -> Self {
        match s {
            "PENDING_VERIFICATION" => PublishingStatus::PendingVerification,
            "PUBLISHING" => PublishingStatus::Publishing,
            "STOPPED" => PublishingStatus::Stopped,
            "UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY" => {
                PublishingStatus::UnableToPublishFixDestinationProperty
            }
            other => PublishingStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PublishingStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PublishingStatus::from(s))
    }
}
impl PublishingStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PublishingStatus::PendingVerification => "PENDING_VERIFICATION",
            PublishingStatus::Publishing => "PUBLISHING",
            PublishingStatus::Stopped => "STOPPED",
            PublishingStatus::UnableToPublishFixDestinationProperty => {
                "UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY"
            }
            PublishingStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "PENDING_VERIFICATION",
            "PUBLISHING",
            "STOPPED",
            "UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY",
        ]
    }
}
impl AsRef<str> for PublishingStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DestinationType {
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DestinationType {
    fn from(s: &str) -> Self {
        match s {
            "S3" => DestinationType::S3,
            other => DestinationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DestinationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DestinationType::from(s))
    }
}
impl DestinationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DestinationType::S3 => "S3",
            DestinationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["S3"]
    }
}
impl AsRef<str> for DestinationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The account within the organization specified as the GuardDuty delegated
/// administrator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminAccount {
    /// <p>The AWS account ID for the account.</p>
    pub admin_account_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the account is enabled as the delegated administrator.</p>
    pub admin_status: std::option::Option<crate::model::AdminStatus>,
}
impl std::fmt::Debug for AdminAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminAccount");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.field("admin_status", &self.admin_status);
        formatter.finish()
    }
}
/// See [`AdminAccount`](crate::model::AdminAccount)
pub mod admin_account {
    /// A builder for [`AdminAccount`](crate::model::AdminAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
        pub(crate) admin_status: std::option::Option<crate::model::AdminStatus>,
    }
    impl Builder {
        /// <p>The AWS account ID for the account.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID for the account.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// <p>Indicates whether the account is enabled as the delegated administrator.</p>
        pub fn admin_status(mut self, input: crate::model::AdminStatus) -> Self {
            self.admin_status = Some(input);
            self
        }
        /// <p>Indicates whether the account is enabled as the delegated administrator.</p>
        pub fn set_admin_status(
            mut self,
            input: std::option::Option<crate::model::AdminStatus>,
        ) -> Self {
            self.admin_status = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminAccount`](crate::model::AdminAccount)
        pub fn build(self) -> crate::model::AdminAccount {
            crate::model::AdminAccount {
                admin_account_id: self.admin_account_id,
                admin_status: self.admin_status,
            }
        }
    }
}
impl AdminAccount {
    /// Creates a new builder-style object to manufacture [`AdminAccount`](crate::model::AdminAccount)
    pub fn builder() -> crate::model::admin_account::Builder {
        crate::model::admin_account::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdminStatus {
    #[allow(missing_docs)] // documentation missing in model
    DisableInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdminStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLE_IN_PROGRESS" => AdminStatus::DisableInProgress,
            "ENABLED" => AdminStatus::Enabled,
            other => AdminStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdminStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdminStatus::from(s))
    }
}
impl AdminStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdminStatus::DisableInProgress => "DISABLE_IN_PROGRESS",
            AdminStatus::Enabled => "ENABLED",
            AdminStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLE_IN_PROGRESS", "ENABLED"]
    }
}
impl AsRef<str> for AdminStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the member account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Member {
    /// <p>The ID of the member account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The detector ID of the member account.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The administrator account ID.</p>
    pub master_id: std::option::Option<std::string::String>,
    /// <p>The email address of the member account.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The status of the relationship between the member and the administrator.</p>
    pub relationship_status: std::option::Option<std::string::String>,
    /// <p>The timestamp when the invitation was sent.</p>
    pub invited_at: std::option::Option<std::string::String>,
    /// <p>The last-updated timestamp of the member.</p>
    pub updated_at: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Member {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Member");
        formatter.field("account_id", &self.account_id);
        formatter.field("detector_id", &self.detector_id);
        formatter.field("master_id", &self.master_id);
        formatter.field("email", &self.email);
        formatter.field("relationship_status", &self.relationship_status);
        formatter.field("invited_at", &self.invited_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Member`](crate::model::Member)
pub mod member {
    /// A builder for [`Member`](crate::model::Member)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) master_id: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) relationship_status: std::option::Option<std::string::String>,
        pub(crate) invited_at: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the member account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The detector ID of the member account.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID of the member account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The administrator account ID.</p>
        pub fn master_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_id = Some(input.into());
            self
        }
        /// <p>The administrator account ID.</p>
        pub fn set_master_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.master_id = input;
            self
        }
        /// <p>The email address of the member account.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the member account.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The status of the relationship between the member and the administrator.</p>
        pub fn relationship_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.relationship_status = Some(input.into());
            self
        }
        /// <p>The status of the relationship between the member and the administrator.</p>
        pub fn set_relationship_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relationship_status = input;
            self
        }
        /// <p>The timestamp when the invitation was sent.</p>
        pub fn invited_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.invited_at = Some(input.into());
            self
        }
        /// <p>The timestamp when the invitation was sent.</p>
        pub fn set_invited_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.invited_at = input;
            self
        }
        /// <p>The last-updated timestamp of the member.</p>
        pub fn updated_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_at = Some(input.into());
            self
        }
        /// <p>The last-updated timestamp of the member.</p>
        pub fn set_updated_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Member`](crate::model::Member)
        pub fn build(self) -> crate::model::Member {
            crate::model::Member {
                account_id: self.account_id,
                detector_id: self.detector_id,
                master_id: self.master_id,
                email: self.email,
                relationship_status: self.relationship_status,
                invited_at: self.invited_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Member {
    /// Creates a new builder-style object to manufacture [`Member`](crate::model::Member)
    pub fn builder() -> crate::model::member::Builder {
        crate::model::member::Builder::default()
    }
}

/// <p>Contains information about the invitation to become a member account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Invitation {
    /// <p>The ID of the account that the invitation was sent from.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the invitation. This value is used to validate the inviter account to the member
    /// account.</p>
    pub invitation_id: std::option::Option<std::string::String>,
    /// <p>The status of the relationship between the inviter and invitee accounts.</p>
    pub relationship_status: std::option::Option<std::string::String>,
    /// <p>The timestamp when the invitation was sent.</p>
    pub invited_at: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Invitation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Invitation");
        formatter.field("account_id", &self.account_id);
        formatter.field("invitation_id", &self.invitation_id);
        formatter.field("relationship_status", &self.relationship_status);
        formatter.field("invited_at", &self.invited_at);
        formatter.finish()
    }
}
/// See [`Invitation`](crate::model::Invitation)
pub mod invitation {
    /// A builder for [`Invitation`](crate::model::Invitation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) invitation_id: std::option::Option<std::string::String>,
        pub(crate) relationship_status: std::option::Option<std::string::String>,
        pub(crate) invited_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the account that the invitation was sent from.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the account that the invitation was sent from.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID of the invitation. This value is used to validate the inviter account to the member
        /// account.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The ID of the invitation. This value is used to validate the inviter account to the member
        /// account.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// <p>The status of the relationship between the inviter and invitee accounts.</p>
        pub fn relationship_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.relationship_status = Some(input.into());
            self
        }
        /// <p>The status of the relationship between the inviter and invitee accounts.</p>
        pub fn set_relationship_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relationship_status = input;
            self
        }
        /// <p>The timestamp when the invitation was sent.</p>
        pub fn invited_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.invited_at = Some(input.into());
            self
        }
        /// <p>The timestamp when the invitation was sent.</p>
        pub fn set_invited_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.invited_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Invitation`](crate::model::Invitation)
        pub fn build(self) -> crate::model::Invitation {
            crate::model::Invitation {
                account_id: self.account_id,
                invitation_id: self.invitation_id,
                relationship_status: self.relationship_status,
                invited_at: self.invited_at,
            }
        }
    }
}
impl Invitation {
    /// Creates a new builder-style object to manufacture [`Invitation`](crate::model::Invitation)
    pub fn builder() -> crate::model::invitation::Builder {
        crate::model::invitation::Builder::default()
    }
}

/// <p>Contains information about the criteria used for sorting findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SortCriteria {
    /// <p>Represents the finding attribute (for example, accountId) to sort findings by.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The order by which the sorted findings are to be displayed.</p>
    pub order_by: std::option::Option<crate::model::OrderBy>,
}
impl std::fmt::Debug for SortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SortCriteria");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("order_by", &self.order_by);
        formatter.finish()
    }
}
/// See [`SortCriteria`](crate::model::SortCriteria)
pub mod sort_criteria {
    /// A builder for [`SortCriteria`](crate::model::SortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) order_by: std::option::Option<crate::model::OrderBy>,
    }
    impl Builder {
        /// <p>Represents the finding attribute (for example, accountId) to sort findings by.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>Represents the finding attribute (for example, accountId) to sort findings by.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The order by which the sorted findings are to be displayed.</p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.order_by = Some(input);
            self
        }
        /// <p>The order by which the sorted findings are to be displayed.</p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.order_by = input;
            self
        }
        /// Consumes the builder and constructs a [`SortCriteria`](crate::model::SortCriteria)
        pub fn build(self) -> crate::model::SortCriteria {
            crate::model::SortCriteria {
                attribute_name: self.attribute_name,
                order_by: self.order_by,
            }
        }
    }
}
impl SortCriteria {
    /// Creates a new builder-style object to manufacture [`SortCriteria`](crate::model::SortCriteria)
    pub fn builder() -> crate::model::sort_criteria::Builder {
        crate::model::sort_criteria::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderBy {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderBy {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => OrderBy::Asc,
            "DESC" => OrderBy::Desc,
            other => OrderBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderBy::from(s))
    }
}
impl OrderBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderBy::Asc => "ASC",
            OrderBy::Desc => "DESC",
            OrderBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for OrderBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the result of GuardDuty usage. If a UsageStatisticType is provided the result for
/// other types will be null. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageStatistics {
    /// <p>The usage statistic sum organized by account ID.</p>
    pub sum_by_account: std::option::Option<std::vec::Vec<crate::model::UsageAccountResult>>,
    /// <p>The usage statistic sum organized by on data source.</p>
    pub sum_by_data_source: std::option::Option<std::vec::Vec<crate::model::UsageDataSourceResult>>,
    /// <p>The usage statistic sum organized by resource.</p>
    pub sum_by_resource: std::option::Option<std::vec::Vec<crate::model::UsageResourceResult>>,
    /// <p>Lists the top 50 resources that have generated the most GuardDuty usage, in order from
    /// most to least expensive.</p>
    pub top_resources: std::option::Option<std::vec::Vec<crate::model::UsageResourceResult>>,
}
impl std::fmt::Debug for UsageStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageStatistics");
        formatter.field("sum_by_account", &self.sum_by_account);
        formatter.field("sum_by_data_source", &self.sum_by_data_source);
        formatter.field("sum_by_resource", &self.sum_by_resource);
        formatter.field("top_resources", &self.top_resources);
        formatter.finish()
    }
}
/// See [`UsageStatistics`](crate::model::UsageStatistics)
pub mod usage_statistics {
    /// A builder for [`UsageStatistics`](crate::model::UsageStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sum_by_account:
            std::option::Option<std::vec::Vec<crate::model::UsageAccountResult>>,
        pub(crate) sum_by_data_source:
            std::option::Option<std::vec::Vec<crate::model::UsageDataSourceResult>>,
        pub(crate) sum_by_resource:
            std::option::Option<std::vec::Vec<crate::model::UsageResourceResult>>,
        pub(crate) top_resources:
            std::option::Option<std::vec::Vec<crate::model::UsageResourceResult>>,
    }
    impl Builder {
        /// Appends an item to `sum_by_account`.
        ///
        /// To override the contents of this collection use [`set_sum_by_account`](Self::set_sum_by_account).
        ///
        /// <p>The usage statistic sum organized by account ID.</p>
        pub fn sum_by_account(
            mut self,
            input: impl Into<crate::model::UsageAccountResult>,
        ) -> Self {
            let mut v = self.sum_by_account.unwrap_or_default();
            v.push(input.into());
            self.sum_by_account = Some(v);
            self
        }
        /// <p>The usage statistic sum organized by account ID.</p>
        pub fn set_sum_by_account(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageAccountResult>>,
        ) -> Self {
            self.sum_by_account = input;
            self
        }
        /// Appends an item to `sum_by_data_source`.
        ///
        /// To override the contents of this collection use [`set_sum_by_data_source`](Self::set_sum_by_data_source).
        ///
        /// <p>The usage statistic sum organized by on data source.</p>
        pub fn sum_by_data_source(
            mut self,
            input: impl Into<crate::model::UsageDataSourceResult>,
        ) -> Self {
            let mut v = self.sum_by_data_source.unwrap_or_default();
            v.push(input.into());
            self.sum_by_data_source = Some(v);
            self
        }
        /// <p>The usage statistic sum organized by on data source.</p>
        pub fn set_sum_by_data_source(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageDataSourceResult>>,
        ) -> Self {
            self.sum_by_data_source = input;
            self
        }
        /// Appends an item to `sum_by_resource`.
        ///
        /// To override the contents of this collection use [`set_sum_by_resource`](Self::set_sum_by_resource).
        ///
        /// <p>The usage statistic sum organized by resource.</p>
        pub fn sum_by_resource(
            mut self,
            input: impl Into<crate::model::UsageResourceResult>,
        ) -> Self {
            let mut v = self.sum_by_resource.unwrap_or_default();
            v.push(input.into());
            self.sum_by_resource = Some(v);
            self
        }
        /// <p>The usage statistic sum organized by resource.</p>
        pub fn set_sum_by_resource(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageResourceResult>>,
        ) -> Self {
            self.sum_by_resource = input;
            self
        }
        /// Appends an item to `top_resources`.
        ///
        /// To override the contents of this collection use [`set_top_resources`](Self::set_top_resources).
        ///
        /// <p>Lists the top 50 resources that have generated the most GuardDuty usage, in order from
        /// most to least expensive.</p>
        pub fn top_resources(
            mut self,
            input: impl Into<crate::model::UsageResourceResult>,
        ) -> Self {
            let mut v = self.top_resources.unwrap_or_default();
            v.push(input.into());
            self.top_resources = Some(v);
            self
        }
        /// <p>Lists the top 50 resources that have generated the most GuardDuty usage, in order from
        /// most to least expensive.</p>
        pub fn set_top_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageResourceResult>>,
        ) -> Self {
            self.top_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageStatistics`](crate::model::UsageStatistics)
        pub fn build(self) -> crate::model::UsageStatistics {
            crate::model::UsageStatistics {
                sum_by_account: self.sum_by_account,
                sum_by_data_source: self.sum_by_data_source,
                sum_by_resource: self.sum_by_resource,
                top_resources: self.top_resources,
            }
        }
    }
}
impl UsageStatistics {
    /// Creates a new builder-style object to manufacture [`UsageStatistics`](crate::model::UsageStatistics)
    pub fn builder() -> crate::model::usage_statistics::Builder {
        crate::model::usage_statistics::Builder::default()
    }
}

/// <p>Contains information on the sum of usage based on an AWS resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageResourceResult {
    /// <p>The AWS resource that generated usage.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>Represents the sum total of usage for the specified resource type.</p>
    pub total: std::option::Option<crate::model::Total>,
}
impl std::fmt::Debug for UsageResourceResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageResourceResult");
        formatter.field("resource", &self.resource);
        formatter.field("total", &self.total);
        formatter.finish()
    }
}
/// See [`UsageResourceResult`](crate::model::UsageResourceResult)
pub mod usage_resource_result {
    /// A builder for [`UsageResourceResult`](crate::model::UsageResourceResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) total: std::option::Option<crate::model::Total>,
    }
    impl Builder {
        /// <p>The AWS resource that generated usage.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The AWS resource that generated usage.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>Represents the sum total of usage for the specified resource type.</p>
        pub fn total(mut self, input: crate::model::Total) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>Represents the sum total of usage for the specified resource type.</p>
        pub fn set_total(mut self, input: std::option::Option<crate::model::Total>) -> Self {
            self.total = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageResourceResult`](crate::model::UsageResourceResult)
        pub fn build(self) -> crate::model::UsageResourceResult {
            crate::model::UsageResourceResult {
                resource: self.resource,
                total: self.total,
            }
        }
    }
}
impl UsageResourceResult {
    /// Creates a new builder-style object to manufacture [`UsageResourceResult`](crate::model::UsageResourceResult)
    pub fn builder() -> crate::model::usage_resource_result::Builder {
        crate::model::usage_resource_result::Builder::default()
    }
}

/// <p>Contains the total usage with the corresponding currency unit for that value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Total {
    /// <p>The total usage.</p>
    pub amount: std::option::Option<std::string::String>,
    /// <p>The currency unit that the amount is given in.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Total {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Total");
        formatter.field("amount", &self.amount);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`Total`](crate::model::Total)
pub mod total {
    /// A builder for [`Total`](crate::model::Total)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amount: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The total usage.</p>
        pub fn amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.amount = Some(input.into());
            self
        }
        /// <p>The total usage.</p>
        pub fn set_amount(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.amount = input;
            self
        }
        /// <p>The currency unit that the amount is given in.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The currency unit that the amount is given in.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`Total`](crate::model::Total)
        pub fn build(self) -> crate::model::Total {
            crate::model::Total {
                amount: self.amount,
                unit: self.unit,
            }
        }
    }
}
impl Total {
    /// Creates a new builder-style object to manufacture [`Total`](crate::model::Total)
    pub fn builder() -> crate::model::total::Builder {
        crate::model::total::Builder::default()
    }
}

/// <p>Contains information on the result of usage based on data source type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageDataSourceResult {
    /// <p>The data source type that generated usage.</p>
    pub data_source: std::option::Option<crate::model::DataSource>,
    /// <p>Represents the total of usage for the specified data source.</p>
    pub total: std::option::Option<crate::model::Total>,
}
impl std::fmt::Debug for UsageDataSourceResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageDataSourceResult");
        formatter.field("data_source", &self.data_source);
        formatter.field("total", &self.total);
        formatter.finish()
    }
}
/// See [`UsageDataSourceResult`](crate::model::UsageDataSourceResult)
pub mod usage_data_source_result {
    /// A builder for [`UsageDataSourceResult`](crate::model::UsageDataSourceResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source: std::option::Option<crate::model::DataSource>,
        pub(crate) total: std::option::Option<crate::model::Total>,
    }
    impl Builder {
        /// <p>The data source type that generated usage.</p>
        pub fn data_source(mut self, input: crate::model::DataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The data source type that generated usage.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::DataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>Represents the total of usage for the specified data source.</p>
        pub fn total(mut self, input: crate::model::Total) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>Represents the total of usage for the specified data source.</p>
        pub fn set_total(mut self, input: std::option::Option<crate::model::Total>) -> Self {
            self.total = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageDataSourceResult`](crate::model::UsageDataSourceResult)
        pub fn build(self) -> crate::model::UsageDataSourceResult {
            crate::model::UsageDataSourceResult {
                data_source: self.data_source,
                total: self.total,
            }
        }
    }
}
impl UsageDataSourceResult {
    /// Creates a new builder-style object to manufacture [`UsageDataSourceResult`](crate::model::UsageDataSourceResult)
    pub fn builder() -> crate::model::usage_data_source_result::Builder {
        crate::model::usage_data_source_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSource {
    #[allow(missing_docs)] // documentation missing in model
    CloudTrail,
    #[allow(missing_docs)] // documentation missing in model
    DnsLogs,
    #[allow(missing_docs)] // documentation missing in model
    FlowLogs,
    #[allow(missing_docs)] // documentation missing in model
    S3Logs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSource {
    fn from(s: &str) -> Self {
        match s {
            "CLOUD_TRAIL" => DataSource::CloudTrail,
            "DNS_LOGS" => DataSource::DnsLogs,
            "FLOW_LOGS" => DataSource::FlowLogs,
            "S3_LOGS" => DataSource::S3Logs,
            other => DataSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSource::from(s))
    }
}
impl DataSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSource::CloudTrail => "CLOUD_TRAIL",
            DataSource::DnsLogs => "DNS_LOGS",
            DataSource::FlowLogs => "FLOW_LOGS",
            DataSource::S3Logs => "S3_LOGS",
            DataSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOUD_TRAIL", "DNS_LOGS", "FLOW_LOGS", "S3_LOGS"]
    }
}
impl AsRef<str> for DataSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information on the total of usage based on account IDs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageAccountResult {
    /// <p>The Account ID that generated usage.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Represents the total of usage for the Account ID.</p>
    pub total: std::option::Option<crate::model::Total>,
}
impl std::fmt::Debug for UsageAccountResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageAccountResult");
        formatter.field("account_id", &self.account_id);
        formatter.field("total", &self.total);
        formatter.finish()
    }
}
/// See [`UsageAccountResult`](crate::model::UsageAccountResult)
pub mod usage_account_result {
    /// A builder for [`UsageAccountResult`](crate::model::UsageAccountResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) total: std::option::Option<crate::model::Total>,
    }
    impl Builder {
        /// <p>The Account ID that generated usage.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Account ID that generated usage.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Represents the total of usage for the Account ID.</p>
        pub fn total(mut self, input: crate::model::Total) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>Represents the total of usage for the Account ID.</p>
        pub fn set_total(mut self, input: std::option::Option<crate::model::Total>) -> Self {
            self.total = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageAccountResult`](crate::model::UsageAccountResult)
        pub fn build(self) -> crate::model::UsageAccountResult {
            crate::model::UsageAccountResult {
                account_id: self.account_id,
                total: self.total,
            }
        }
    }
}
impl UsageAccountResult {
    /// Creates a new builder-style object to manufacture [`UsageAccountResult`](crate::model::UsageAccountResult)
    pub fn builder() -> crate::model::usage_account_result::Builder {
        crate::model::usage_account_result::Builder::default()
    }
}

/// <p>Contains information about the criteria used to query usage statistics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageCriteria {
    /// <p>The account IDs to aggregate usage statistics from.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The data sources to aggregate usage statistics from.</p>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
    /// <p>The resources to aggregate usage statistics from. Only accepts exact resource
    /// names.</p>
    pub resources: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UsageCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageCriteria");
        formatter.field("account_ids", &self.account_ids);
        formatter.field("data_sources", &self.data_sources);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`UsageCriteria`](crate::model::UsageCriteria)
pub mod usage_criteria {
    /// A builder for [`UsageCriteria`](crate::model::UsageCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        pub(crate) resources: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The account IDs to aggregate usage statistics from.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The account IDs to aggregate usage statistics from.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>The data sources to aggregate usage statistics from.</p>
        pub fn data_sources(mut self, input: impl Into<crate::model::DataSource>) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input.into());
            self.data_sources = Some(v);
            self
        }
        /// <p>The data sources to aggregate usage statistics from.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>The resources to aggregate usage statistics from. Only accepts exact resource
        /// names.</p>
        pub fn resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>The resources to aggregate usage statistics from. Only accepts exact resource
        /// names.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageCriteria`](crate::model::UsageCriteria)
        pub fn build(self) -> crate::model::UsageCriteria {
            crate::model::UsageCriteria {
                account_ids: self.account_ids,
                data_sources: self.data_sources,
                resources: self.resources,
            }
        }
    }
}
impl UsageCriteria {
    /// Creates a new builder-style object to manufacture [`UsageCriteria`](crate::model::UsageCriteria)
    pub fn builder() -> crate::model::usage_criteria::Builder {
        crate::model::usage_criteria::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageStatisticType {
    #[allow(missing_docs)] // documentation missing in model
    SumByAccount,
    #[allow(missing_docs)] // documentation missing in model
    SumByDataSource,
    #[allow(missing_docs)] // documentation missing in model
    SumByResource,
    #[allow(missing_docs)] // documentation missing in model
    TopResources,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageStatisticType {
    fn from(s: &str) -> Self {
        match s {
            "SUM_BY_ACCOUNT" => UsageStatisticType::SumByAccount,
            "SUM_BY_DATA_SOURCE" => UsageStatisticType::SumByDataSource,
            "SUM_BY_RESOURCE" => UsageStatisticType::SumByResource,
            "TOP_RESOURCES" => UsageStatisticType::TopResources,
            other => UsageStatisticType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageStatisticType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageStatisticType::from(s))
    }
}
impl UsageStatisticType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageStatisticType::SumByAccount => "SUM_BY_ACCOUNT",
            UsageStatisticType::SumByDataSource => "SUM_BY_DATA_SOURCE",
            UsageStatisticType::SumByResource => "SUM_BY_RESOURCE",
            UsageStatisticType::TopResources => "TOP_RESOURCES",
            UsageStatisticType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "SUM_BY_ACCOUNT",
            "SUM_BY_DATA_SOURCE",
            "SUM_BY_RESOURCE",
            "TOP_RESOURCES",
        ]
    }
}
impl AsRef<str> for UsageStatisticType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThreatIntelSetStatus {
    #[allow(missing_docs)] // documentation missing in model
    Activating,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deactivating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeletePending,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThreatIntelSetStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATING" => ThreatIntelSetStatus::Activating,
            "ACTIVE" => ThreatIntelSetStatus::Active,
            "DEACTIVATING" => ThreatIntelSetStatus::Deactivating,
            "DELETED" => ThreatIntelSetStatus::Deleted,
            "DELETE_PENDING" => ThreatIntelSetStatus::DeletePending,
            "ERROR" => ThreatIntelSetStatus::Error,
            "INACTIVE" => ThreatIntelSetStatus::Inactive,
            other => ThreatIntelSetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThreatIntelSetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThreatIntelSetStatus::from(s))
    }
}
impl ThreatIntelSetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThreatIntelSetStatus::Activating => "ACTIVATING",
            ThreatIntelSetStatus::Active => "ACTIVE",
            ThreatIntelSetStatus::Deactivating => "DEACTIVATING",
            ThreatIntelSetStatus::Deleted => "DELETED",
            ThreatIntelSetStatus::DeletePending => "DELETE_PENDING",
            ThreatIntelSetStatus::Error => "ERROR",
            ThreatIntelSetStatus::Inactive => "INACTIVE",
            ThreatIntelSetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVATING",
            "ACTIVE",
            "DEACTIVATING",
            "DELETED",
            "DELETE_PENDING",
            "ERROR",
            "INACTIVE",
        ]
    }
}
impl AsRef<str> for ThreatIntelSetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThreatIntelSetFormat {
    #[allow(missing_docs)] // documentation missing in model
    AlienVault,
    #[allow(missing_docs)] // documentation missing in model
    FireEye,
    #[allow(missing_docs)] // documentation missing in model
    OtxCsv,
    #[allow(missing_docs)] // documentation missing in model
    ProofPoint,
    #[allow(missing_docs)] // documentation missing in model
    Stix,
    #[allow(missing_docs)] // documentation missing in model
    Txt,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThreatIntelSetFormat {
    fn from(s: &str) -> Self {
        match s {
            "ALIEN_VAULT" => ThreatIntelSetFormat::AlienVault,
            "FIRE_EYE" => ThreatIntelSetFormat::FireEye,
            "OTX_CSV" => ThreatIntelSetFormat::OtxCsv,
            "PROOF_POINT" => ThreatIntelSetFormat::ProofPoint,
            "STIX" => ThreatIntelSetFormat::Stix,
            "TXT" => ThreatIntelSetFormat::Txt,
            other => ThreatIntelSetFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThreatIntelSetFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThreatIntelSetFormat::from(s))
    }
}
impl ThreatIntelSetFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThreatIntelSetFormat::AlienVault => "ALIEN_VAULT",
            ThreatIntelSetFormat::FireEye => "FIRE_EYE",
            ThreatIntelSetFormat::OtxCsv => "OTX_CSV",
            ThreatIntelSetFormat::ProofPoint => "PROOF_POINT",
            ThreatIntelSetFormat::Stix => "STIX",
            ThreatIntelSetFormat::Txt => "TXT",
            ThreatIntelSetFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALIEN_VAULT",
            "FIRE_EYE",
            "OTX_CSV",
            "PROOF_POINT",
            "STIX",
            "TXT",
        ]
    }
}
impl AsRef<str> for ThreatIntelSetFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information on which data sources are enabled for a member account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberDataSourceConfiguration {
    /// <p>The account ID for the member account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Contains information on the status of data sources for the account.</p>
    pub data_sources: std::option::Option<crate::model::DataSourceConfigurationsResult>,
}
impl std::fmt::Debug for MemberDataSourceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberDataSourceConfiguration");
        formatter.field("account_id", &self.account_id);
        formatter.field("data_sources", &self.data_sources);
        formatter.finish()
    }
}
/// See [`MemberDataSourceConfiguration`](crate::model::MemberDataSourceConfiguration)
pub mod member_data_source_configuration {
    /// A builder for [`MemberDataSourceConfiguration`](crate::model::MemberDataSourceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) data_sources: std::option::Option<crate::model::DataSourceConfigurationsResult>,
    }
    impl Builder {
        /// <p>The account ID for the member account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Contains information on the status of data sources for the account.</p>
        pub fn data_sources(mut self, input: crate::model::DataSourceConfigurationsResult) -> Self {
            self.data_sources = Some(input);
            self
        }
        /// <p>Contains information on the status of data sources for the account.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfigurationsResult>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberDataSourceConfiguration`](crate::model::MemberDataSourceConfiguration)
        pub fn build(self) -> crate::model::MemberDataSourceConfiguration {
            crate::model::MemberDataSourceConfiguration {
                account_id: self.account_id,
                data_sources: self.data_sources,
            }
        }
    }
}
impl MemberDataSourceConfiguration {
    /// Creates a new builder-style object to manufacture [`MemberDataSourceConfiguration`](crate::model::MemberDataSourceConfiguration)
    pub fn builder() -> crate::model::member_data_source_configuration::Builder {
        crate::model::member_data_source_configuration::Builder::default()
    }
}

/// <p>Contains information on the status of data sources for the detector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceConfigurationsResult {
    /// <p>An object that contains information on the status of CloudTrail as a data source.</p>
    pub cloud_trail: std::option::Option<crate::model::CloudTrailConfigurationResult>,
    /// <p>An object that contains information on the status of DNS logs as a data source.</p>
    pub dns_logs: std::option::Option<crate::model::DnsLogsConfigurationResult>,
    /// <p>An object that contains information on the status of VPC flow logs as a data
    /// source.</p>
    pub flow_logs: std::option::Option<crate::model::FlowLogsConfigurationResult>,
    /// <p>An object that contains information on the status of S3 Data event logs as a data
    /// source.</p>
    pub s3_logs: std::option::Option<crate::model::S3LogsConfigurationResult>,
}
impl std::fmt::Debug for DataSourceConfigurationsResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceConfigurationsResult");
        formatter.field("cloud_trail", &self.cloud_trail);
        formatter.field("dns_logs", &self.dns_logs);
        formatter.field("flow_logs", &self.flow_logs);
        formatter.field("s3_logs", &self.s3_logs);
        formatter.finish()
    }
}
/// See [`DataSourceConfigurationsResult`](crate::model::DataSourceConfigurationsResult)
pub mod data_source_configurations_result {
    /// A builder for [`DataSourceConfigurationsResult`](crate::model::DataSourceConfigurationsResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_trail: std::option::Option<crate::model::CloudTrailConfigurationResult>,
        pub(crate) dns_logs: std::option::Option<crate::model::DnsLogsConfigurationResult>,
        pub(crate) flow_logs: std::option::Option<crate::model::FlowLogsConfigurationResult>,
        pub(crate) s3_logs: std::option::Option<crate::model::S3LogsConfigurationResult>,
    }
    impl Builder {
        /// <p>An object that contains information on the status of CloudTrail as a data source.</p>
        pub fn cloud_trail(mut self, input: crate::model::CloudTrailConfigurationResult) -> Self {
            self.cloud_trail = Some(input);
            self
        }
        /// <p>An object that contains information on the status of CloudTrail as a data source.</p>
        pub fn set_cloud_trail(
            mut self,
            input: std::option::Option<crate::model::CloudTrailConfigurationResult>,
        ) -> Self {
            self.cloud_trail = input;
            self
        }
        /// <p>An object that contains information on the status of DNS logs as a data source.</p>
        pub fn dns_logs(mut self, input: crate::model::DnsLogsConfigurationResult) -> Self {
            self.dns_logs = Some(input);
            self
        }
        /// <p>An object that contains information on the status of DNS logs as a data source.</p>
        pub fn set_dns_logs(
            mut self,
            input: std::option::Option<crate::model::DnsLogsConfigurationResult>,
        ) -> Self {
            self.dns_logs = input;
            self
        }
        /// <p>An object that contains information on the status of VPC flow logs as a data
        /// source.</p>
        pub fn flow_logs(mut self, input: crate::model::FlowLogsConfigurationResult) -> Self {
            self.flow_logs = Some(input);
            self
        }
        /// <p>An object that contains information on the status of VPC flow logs as a data
        /// source.</p>
        pub fn set_flow_logs(
            mut self,
            input: std::option::Option<crate::model::FlowLogsConfigurationResult>,
        ) -> Self {
            self.flow_logs = input;
            self
        }
        /// <p>An object that contains information on the status of S3 Data event logs as a data
        /// source.</p>
        pub fn s3_logs(mut self, input: crate::model::S3LogsConfigurationResult) -> Self {
            self.s3_logs = Some(input);
            self
        }
        /// <p>An object that contains information on the status of S3 Data event logs as a data
        /// source.</p>
        pub fn set_s3_logs(
            mut self,
            input: std::option::Option<crate::model::S3LogsConfigurationResult>,
        ) -> Self {
            self.s3_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceConfigurationsResult`](crate::model::DataSourceConfigurationsResult)
        pub fn build(self) -> crate::model::DataSourceConfigurationsResult {
            crate::model::DataSourceConfigurationsResult {
                cloud_trail: self.cloud_trail,
                dns_logs: self.dns_logs,
                flow_logs: self.flow_logs,
                s3_logs: self.s3_logs,
            }
        }
    }
}
impl DataSourceConfigurationsResult {
    /// Creates a new builder-style object to manufacture [`DataSourceConfigurationsResult`](crate::model::DataSourceConfigurationsResult)
    pub fn builder() -> crate::model::data_source_configurations_result::Builder {
        crate::model::data_source_configurations_result::Builder::default()
    }
}

/// <p>Describes whether S3 data event logs will be enabled as a data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3LogsConfigurationResult {
    /// <p>A value that describes whether S3 data event logs are automatically enabled for new
    /// members of the organization.</p>
    pub status: std::option::Option<crate::model::DataSourceStatus>,
}
impl std::fmt::Debug for S3LogsConfigurationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3LogsConfigurationResult");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`S3LogsConfigurationResult`](crate::model::S3LogsConfigurationResult)
pub mod s3_logs_configuration_result {
    /// A builder for [`S3LogsConfigurationResult`](crate::model::S3LogsConfigurationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::DataSourceStatus>,
    }
    impl Builder {
        /// <p>A value that describes whether S3 data event logs are automatically enabled for new
        /// members of the organization.</p>
        pub fn status(mut self, input: crate::model::DataSourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A value that describes whether S3 data event logs are automatically enabled for new
        /// members of the organization.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataSourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`S3LogsConfigurationResult`](crate::model::S3LogsConfigurationResult)
        pub fn build(self) -> crate::model::S3LogsConfigurationResult {
            crate::model::S3LogsConfigurationResult {
                status: self.status,
            }
        }
    }
}
impl S3LogsConfigurationResult {
    /// Creates a new builder-style object to manufacture [`S3LogsConfigurationResult`](crate::model::S3LogsConfigurationResult)
    pub fn builder() -> crate::model::s3_logs_configuration_result::Builder {
        crate::model::s3_logs_configuration_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSourceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSourceStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => DataSourceStatus::Disabled,
            "ENABLED" => DataSourceStatus::Enabled,
            other => DataSourceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSourceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSourceStatus::from(s))
    }
}
impl DataSourceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSourceStatus::Disabled => "DISABLED",
            DataSourceStatus::Enabled => "ENABLED",
            DataSourceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for DataSourceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information on the status of VPC flow logs as a data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FlowLogsConfigurationResult {
    /// <p>Denotes whether VPC flow logs is enabled as a data source.</p>
    pub status: std::option::Option<crate::model::DataSourceStatus>,
}
impl std::fmt::Debug for FlowLogsConfigurationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FlowLogsConfigurationResult");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`FlowLogsConfigurationResult`](crate::model::FlowLogsConfigurationResult)
pub mod flow_logs_configuration_result {
    /// A builder for [`FlowLogsConfigurationResult`](crate::model::FlowLogsConfigurationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::DataSourceStatus>,
    }
    impl Builder {
        /// <p>Denotes whether VPC flow logs is enabled as a data source.</p>
        pub fn status(mut self, input: crate::model::DataSourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Denotes whether VPC flow logs is enabled as a data source.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataSourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`FlowLogsConfigurationResult`](crate::model::FlowLogsConfigurationResult)
        pub fn build(self) -> crate::model::FlowLogsConfigurationResult {
            crate::model::FlowLogsConfigurationResult {
                status: self.status,
            }
        }
    }
}
impl FlowLogsConfigurationResult {
    /// Creates a new builder-style object to manufacture [`FlowLogsConfigurationResult`](crate::model::FlowLogsConfigurationResult)
    pub fn builder() -> crate::model::flow_logs_configuration_result::Builder {
        crate::model::flow_logs_configuration_result::Builder::default()
    }
}

/// <p>Contains information on the status of DNS logs as a data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsLogsConfigurationResult {
    /// <p>Denotes whether DNS logs is enabled as a data source.</p>
    pub status: std::option::Option<crate::model::DataSourceStatus>,
}
impl std::fmt::Debug for DnsLogsConfigurationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsLogsConfigurationResult");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DnsLogsConfigurationResult`](crate::model::DnsLogsConfigurationResult)
pub mod dns_logs_configuration_result {
    /// A builder for [`DnsLogsConfigurationResult`](crate::model::DnsLogsConfigurationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::DataSourceStatus>,
    }
    impl Builder {
        /// <p>Denotes whether DNS logs is enabled as a data source.</p>
        pub fn status(mut self, input: crate::model::DataSourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Denotes whether DNS logs is enabled as a data source.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataSourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsLogsConfigurationResult`](crate::model::DnsLogsConfigurationResult)
        pub fn build(self) -> crate::model::DnsLogsConfigurationResult {
            crate::model::DnsLogsConfigurationResult {
                status: self.status,
            }
        }
    }
}
impl DnsLogsConfigurationResult {
    /// Creates a new builder-style object to manufacture [`DnsLogsConfigurationResult`](crate::model::DnsLogsConfigurationResult)
    pub fn builder() -> crate::model::dns_logs_configuration_result::Builder {
        crate::model::dns_logs_configuration_result::Builder::default()
    }
}

/// <p>Contains information on the status of CloudTrail as a data source for the detector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudTrailConfigurationResult {
    /// <p>Describes whether CloudTrail is enabled as a data source for the detector.</p>
    pub status: std::option::Option<crate::model::DataSourceStatus>,
}
impl std::fmt::Debug for CloudTrailConfigurationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudTrailConfigurationResult");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CloudTrailConfigurationResult`](crate::model::CloudTrailConfigurationResult)
pub mod cloud_trail_configuration_result {
    /// A builder for [`CloudTrailConfigurationResult`](crate::model::CloudTrailConfigurationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::DataSourceStatus>,
    }
    impl Builder {
        /// <p>Describes whether CloudTrail is enabled as a data source for the detector.</p>
        pub fn status(mut self, input: crate::model::DataSourceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Describes whether CloudTrail is enabled as a data source for the detector.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataSourceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudTrailConfigurationResult`](crate::model::CloudTrailConfigurationResult)
        pub fn build(self) -> crate::model::CloudTrailConfigurationResult {
            crate::model::CloudTrailConfigurationResult {
                status: self.status,
            }
        }
    }
}
impl CloudTrailConfigurationResult {
    /// Creates a new builder-style object to manufacture [`CloudTrailConfigurationResult`](crate::model::CloudTrailConfigurationResult)
    pub fn builder() -> crate::model::cloud_trail_configuration_result::Builder {
        crate::model::cloud_trail_configuration_result::Builder::default()
    }
}

/// <p>Contains information about the administrator account and invitation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Master {
    /// <p>The ID of the account used as the administrator account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The value used to validate the administrator account to the member account.</p>
    pub invitation_id: std::option::Option<std::string::String>,
    /// <p>The status of the relationship between the administrator and member accounts.</p>
    pub relationship_status: std::option::Option<std::string::String>,
    /// <p>The timestamp when the invitation was sent.</p>
    pub invited_at: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Master {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Master");
        formatter.field("account_id", &self.account_id);
        formatter.field("invitation_id", &self.invitation_id);
        formatter.field("relationship_status", &self.relationship_status);
        formatter.field("invited_at", &self.invited_at);
        formatter.finish()
    }
}
/// See [`Master`](crate::model::Master)
pub mod master {
    /// A builder for [`Master`](crate::model::Master)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) invitation_id: std::option::Option<std::string::String>,
        pub(crate) relationship_status: std::option::Option<std::string::String>,
        pub(crate) invited_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the account used as the administrator account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the account used as the administrator account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The value used to validate the administrator account to the member account.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The value used to validate the administrator account to the member account.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// <p>The status of the relationship between the administrator and member accounts.</p>
        pub fn relationship_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.relationship_status = Some(input.into());
            self
        }
        /// <p>The status of the relationship between the administrator and member accounts.</p>
        pub fn set_relationship_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relationship_status = input;
            self
        }
        /// <p>The timestamp when the invitation was sent.</p>
        pub fn invited_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.invited_at = Some(input.into());
            self
        }
        /// <p>The timestamp when the invitation was sent.</p>
        pub fn set_invited_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.invited_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Master`](crate::model::Master)
        pub fn build(self) -> crate::model::Master {
            crate::model::Master {
                account_id: self.account_id,
                invitation_id: self.invitation_id,
                relationship_status: self.relationship_status,
                invited_at: self.invited_at,
            }
        }
    }
}
impl Master {
    /// Creates a new builder-style object to manufacture [`Master`](crate::model::Master)
    pub fn builder() -> crate::model::master::Builder {
        crate::model::master::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IpSetStatus {
    #[allow(missing_docs)] // documentation missing in model
    Activating,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deactivating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeletePending,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IpSetStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATING" => IpSetStatus::Activating,
            "ACTIVE" => IpSetStatus::Active,
            "DEACTIVATING" => IpSetStatus::Deactivating,
            "DELETED" => IpSetStatus::Deleted,
            "DELETE_PENDING" => IpSetStatus::DeletePending,
            "ERROR" => IpSetStatus::Error,
            "INACTIVE" => IpSetStatus::Inactive,
            other => IpSetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IpSetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IpSetStatus::from(s))
    }
}
impl IpSetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IpSetStatus::Activating => "ACTIVATING",
            IpSetStatus::Active => "ACTIVE",
            IpSetStatus::Deactivating => "DEACTIVATING",
            IpSetStatus::Deleted => "DELETED",
            IpSetStatus::DeletePending => "DELETE_PENDING",
            IpSetStatus::Error => "ERROR",
            IpSetStatus::Inactive => "INACTIVE",
            IpSetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVATING",
            "ACTIVE",
            "DEACTIVATING",
            "DELETED",
            "DELETE_PENDING",
            "ERROR",
            "INACTIVE",
        ]
    }
}
impl AsRef<str> for IpSetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IpSetFormat {
    #[allow(missing_docs)] // documentation missing in model
    AlienVault,
    #[allow(missing_docs)] // documentation missing in model
    FireEye,
    #[allow(missing_docs)] // documentation missing in model
    OtxCsv,
    #[allow(missing_docs)] // documentation missing in model
    ProofPoint,
    #[allow(missing_docs)] // documentation missing in model
    Stix,
    #[allow(missing_docs)] // documentation missing in model
    Txt,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IpSetFormat {
    fn from(s: &str) -> Self {
        match s {
            "ALIEN_VAULT" => IpSetFormat::AlienVault,
            "FIRE_EYE" => IpSetFormat::FireEye,
            "OTX_CSV" => IpSetFormat::OtxCsv,
            "PROOF_POINT" => IpSetFormat::ProofPoint,
            "STIX" => IpSetFormat::Stix,
            "TXT" => IpSetFormat::Txt,
            other => IpSetFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IpSetFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IpSetFormat::from(s))
    }
}
impl IpSetFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IpSetFormat::AlienVault => "ALIEN_VAULT",
            IpSetFormat::FireEye => "FIRE_EYE",
            IpSetFormat::OtxCsv => "OTX_CSV",
            IpSetFormat::ProofPoint => "PROOF_POINT",
            IpSetFormat::Stix => "STIX",
            IpSetFormat::Txt => "TXT",
            IpSetFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALIEN_VAULT",
            "FIRE_EYE",
            "OTX_CSV",
            "PROOF_POINT",
            "STIX",
            "TXT",
        ]
    }
}
impl AsRef<str> for IpSetFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about finding statistics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingStatistics {
    /// <p>Represents a map of severity to count statistics for a set of findings.</p>
    pub count_by_severity: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
}
impl std::fmt::Debug for FindingStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingStatistics");
        formatter.field("count_by_severity", &self.count_by_severity);
        formatter.finish()
    }
}
/// See [`FindingStatistics`](crate::model::FindingStatistics)
pub mod finding_statistics {
    /// A builder for [`FindingStatistics`](crate::model::FindingStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count_by_severity:
            std::option::Option<std::collections::HashMap<std::string::String, i32>>,
    }
    impl Builder {
        /// Adds a key-value pair to `count_by_severity`.
        ///
        /// To override the contents of this collection use [`set_count_by_severity`](Self::set_count_by_severity).
        ///
        /// <p>Represents a map of severity to count statistics for a set of findings.</p>
        pub fn count_by_severity(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<i32>,
        ) -> Self {
            let mut hash_map = self.count_by_severity.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.count_by_severity = Some(hash_map);
            self
        }
        /// <p>Represents a map of severity to count statistics for a set of findings.</p>
        pub fn set_count_by_severity(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        ) -> Self {
            self.count_by_severity = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingStatistics`](crate::model::FindingStatistics)
        pub fn build(self) -> crate::model::FindingStatistics {
            crate::model::FindingStatistics {
                count_by_severity: self.count_by_severity,
            }
        }
    }
}
impl FindingStatistics {
    /// Creates a new builder-style object to manufacture [`FindingStatistics`](crate::model::FindingStatistics)
    pub fn builder() -> crate::model::finding_statistics::Builder {
        crate::model::finding_statistics::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingStatisticType {
    #[allow(missing_docs)] // documentation missing in model
    CountBySeverity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingStatisticType {
    fn from(s: &str) -> Self {
        match s {
            "COUNT_BY_SEVERITY" => FindingStatisticType::CountBySeverity,
            other => FindingStatisticType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingStatisticType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingStatisticType::from(s))
    }
}
impl FindingStatisticType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingStatisticType::CountBySeverity => "COUNT_BY_SEVERITY",
            FindingStatisticType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COUNT_BY_SEVERITY"]
    }
}
impl AsRef<str> for FindingStatisticType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the finding, which is generated when abnormal or suspicious
/// activity is detected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Finding {
    /// <p>The ID of the account in which the finding was generated.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the finding.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The confidence score for the finding.</p>
    pub confidence: f64,
    /// <p>The time and date when the finding was created.</p>
    pub created_at: std::option::Option<std::string::String>,
    /// <p>The description of the finding.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of the finding.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The partition associated with the finding.</p>
    pub partition: std::option::Option<std::string::String>,
    /// <p>The Region where the finding was generated.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Contains information about the AWS resource associated with the activity that prompted
    /// GuardDuty to generate a finding.</p>
    pub resource: std::option::Option<crate::model::Resource>,
    /// <p>The version of the schema used for the finding.</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>Contains additional information about the generated finding.</p>
    pub service: std::option::Option<crate::model::Service>,
    /// <p>The severity of the finding.</p>
    pub severity: f64,
    /// <p>The title of the finding.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The type of finding.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The time and date when the finding was last updated.</p>
    pub updated_at: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Finding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Finding");
        formatter.field("account_id", &self.account_id);
        formatter.field("arn", &self.arn);
        formatter.field("confidence", &self.confidence);
        formatter.field("created_at", &self.created_at);
        formatter.field("description", &self.description);
        formatter.field("id", &self.id);
        formatter.field("partition", &self.partition);
        formatter.field("region", &self.region);
        formatter.field("resource", &self.resource);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("service", &self.service);
        formatter.field("severity", &self.severity);
        formatter.field("title", &self.title);
        formatter.field("r#type", &self.r#type);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Finding`](crate::model::Finding)
pub mod finding {
    /// A builder for [`Finding`](crate::model::Finding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) confidence: std::option::Option<f64>,
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) partition: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<crate::model::Resource>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<crate::model::Service>,
        pub(crate) severity: std::option::Option<f64>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the account in which the finding was generated.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the account in which the finding was generated.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ARN of the finding.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the finding.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The confidence score for the finding.</p>
        pub fn confidence(mut self, input: f64) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence score for the finding.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f64>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>The time and date when the finding was created.</p>
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// <p>The time and date when the finding was created.</p>
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The description of the finding.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the finding.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The ID of the finding.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the finding.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The partition associated with the finding.</p>
        pub fn partition(mut self, input: impl Into<std::string::String>) -> Self {
            self.partition = Some(input.into());
            self
        }
        /// <p>The partition associated with the finding.</p>
        pub fn set_partition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partition = input;
            self
        }
        /// <p>The Region where the finding was generated.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the finding was generated.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>Contains information about the AWS resource associated with the activity that prompted
        /// GuardDuty to generate a finding.</p>
        pub fn resource(mut self, input: crate::model::Resource) -> Self {
            self.resource = Some(input);
            self
        }
        /// <p>Contains information about the AWS resource associated with the activity that prompted
        /// GuardDuty to generate a finding.</p>
        pub fn set_resource(mut self, input: std::option::Option<crate::model::Resource>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The version of the schema used for the finding.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The version of the schema used for the finding.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>Contains additional information about the generated finding.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>Contains additional information about the generated finding.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// <p>The severity of the finding.</p>
        pub fn severity(mut self, input: f64) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity of the finding.</p>
        pub fn set_severity(mut self, input: std::option::Option<f64>) -> Self {
            self.severity = input;
            self
        }
        /// <p>The title of the finding.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the finding.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The type of finding.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of finding.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The time and date when the finding was last updated.</p>
        pub fn updated_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_at = Some(input.into());
            self
        }
        /// <p>The time and date when the finding was last updated.</p>
        pub fn set_updated_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Finding`](crate::model::Finding)
        pub fn build(self) -> crate::model::Finding {
            crate::model::Finding {
                account_id: self.account_id,
                arn: self.arn,
                confidence: self.confidence.unwrap_or_default(),
                created_at: self.created_at,
                description: self.description,
                id: self.id,
                partition: self.partition,
                region: self.region,
                resource: self.resource,
                schema_version: self.schema_version,
                service: self.service,
                severity: self.severity.unwrap_or_default(),
                title: self.title,
                r#type: self.r#type,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Finding {
    /// Creates a new builder-style object to manufacture [`Finding`](crate::model::Finding)
    pub fn builder() -> crate::model::finding::Builder {
        crate::model::finding::Builder::default()
    }
}

/// <p>Contains additional information about the generated finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Service {
    /// <p>Information about the activity that is described in a finding.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>An evidence object associated with the service.</p>
    pub evidence: std::option::Option<crate::model::Evidence>,
    /// <p>Indicates whether this finding is archived.</p>
    pub archived: bool,
    /// <p>The total count of the occurrences of this finding type.</p>
    pub count: i32,
    /// <p>The detector ID for the GuardDuty service.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The first-seen timestamp of the activity that prompted GuardDuty to generate this
    /// finding.</p>
    pub event_first_seen: std::option::Option<std::string::String>,
    /// <p>The last-seen timestamp of the activity that prompted GuardDuty to generate this
    /// finding.</p>
    pub event_last_seen: std::option::Option<std::string::String>,
    /// <p>The resource role information for this finding.</p>
    pub resource_role: std::option::Option<std::string::String>,
    /// <p>The name of the AWS service (GuardDuty) that generated a finding.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>Feedback that was submitted about the finding.</p>
    pub user_feedback: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Service {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Service");
        formatter.field("action", &self.action);
        formatter.field("evidence", &self.evidence);
        formatter.field("archived", &self.archived);
        formatter.field("count", &self.count);
        formatter.field("detector_id", &self.detector_id);
        formatter.field("event_first_seen", &self.event_first_seen);
        formatter.field("event_last_seen", &self.event_last_seen);
        formatter.field("resource_role", &self.resource_role);
        formatter.field("service_name", &self.service_name);
        formatter.field("user_feedback", &self.user_feedback);
        formatter.finish()
    }
}
/// See [`Service`](crate::model::Service)
pub mod service {
    /// A builder for [`Service`](crate::model::Service)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) evidence: std::option::Option<crate::model::Evidence>,
        pub(crate) archived: std::option::Option<bool>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) event_first_seen: std::option::Option<std::string::String>,
        pub(crate) event_last_seen: std::option::Option<std::string::String>,
        pub(crate) resource_role: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) user_feedback: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the activity that is described in a finding.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Information about the activity that is described in a finding.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>An evidence object associated with the service.</p>
        pub fn evidence(mut self, input: crate::model::Evidence) -> Self {
            self.evidence = Some(input);
            self
        }
        /// <p>An evidence object associated with the service.</p>
        pub fn set_evidence(mut self, input: std::option::Option<crate::model::Evidence>) -> Self {
            self.evidence = input;
            self
        }
        /// <p>Indicates whether this finding is archived.</p>
        pub fn archived(mut self, input: bool) -> Self {
            self.archived = Some(input);
            self
        }
        /// <p>Indicates whether this finding is archived.</p>
        pub fn set_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.archived = input;
            self
        }
        /// <p>The total count of the occurrences of this finding type.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The total count of the occurrences of this finding type.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>The detector ID for the GuardDuty service.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID for the GuardDuty service.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The first-seen timestamp of the activity that prompted GuardDuty to generate this
        /// finding.</p>
        pub fn event_first_seen(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_first_seen = Some(input.into());
            self
        }
        /// <p>The first-seen timestamp of the activity that prompted GuardDuty to generate this
        /// finding.</p>
        pub fn set_event_first_seen(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_first_seen = input;
            self
        }
        /// <p>The last-seen timestamp of the activity that prompted GuardDuty to generate this
        /// finding.</p>
        pub fn event_last_seen(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_last_seen = Some(input.into());
            self
        }
        /// <p>The last-seen timestamp of the activity that prompted GuardDuty to generate this
        /// finding.</p>
        pub fn set_event_last_seen(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_last_seen = input;
            self
        }
        /// <p>The resource role information for this finding.</p>
        pub fn resource_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_role = Some(input.into());
            self
        }
        /// <p>The resource role information for this finding.</p>
        pub fn set_resource_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_role = input;
            self
        }
        /// <p>The name of the AWS service (GuardDuty) that generated a finding.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the AWS service (GuardDuty) that generated a finding.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>Feedback that was submitted about the finding.</p>
        pub fn user_feedback(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_feedback = Some(input.into());
            self
        }
        /// <p>Feedback that was submitted about the finding.</p>
        pub fn set_user_feedback(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`Service`](crate::model::Service)
        pub fn build(self) -> crate::model::Service {
            crate::model::Service {
                action: self.action,
                evidence: self.evidence,
                archived: self.archived.unwrap_or_default(),
                count: self.count.unwrap_or_default(),
                detector_id: self.detector_id,
                event_first_seen: self.event_first_seen,
                event_last_seen: self.event_last_seen,
                resource_role: self.resource_role,
                service_name: self.service_name,
                user_feedback: self.user_feedback,
            }
        }
    }
}
impl Service {
    /// Creates a new builder-style object to manufacture [`Service`](crate::model::Service)
    pub fn builder() -> crate::model::service::Builder {
        crate::model::service::Builder::default()
    }
}

/// <p>Contains information about the reason that the finding was generated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Evidence {
    /// <p>A list of threat intelligence details related to the evidence.</p>
    pub threat_intelligence_details:
        std::option::Option<std::vec::Vec<crate::model::ThreatIntelligenceDetail>>,
}
impl std::fmt::Debug for Evidence {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Evidence");
        formatter.field(
            "threat_intelligence_details",
            &self.threat_intelligence_details,
        );
        formatter.finish()
    }
}
/// See [`Evidence`](crate::model::Evidence)
pub mod evidence {
    /// A builder for [`Evidence`](crate::model::Evidence)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) threat_intelligence_details:
            std::option::Option<std::vec::Vec<crate::model::ThreatIntelligenceDetail>>,
    }
    impl Builder {
        /// Appends an item to `threat_intelligence_details`.
        ///
        /// To override the contents of this collection use [`set_threat_intelligence_details`](Self::set_threat_intelligence_details).
        ///
        /// <p>A list of threat intelligence details related to the evidence.</p>
        pub fn threat_intelligence_details(
            mut self,
            input: impl Into<crate::model::ThreatIntelligenceDetail>,
        ) -> Self {
            let mut v = self.threat_intelligence_details.unwrap_or_default();
            v.push(input.into());
            self.threat_intelligence_details = Some(v);
            self
        }
        /// <p>A list of threat intelligence details related to the evidence.</p>
        pub fn set_threat_intelligence_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ThreatIntelligenceDetail>>,
        ) -> Self {
            self.threat_intelligence_details = input;
            self
        }
        /// Consumes the builder and constructs a [`Evidence`](crate::model::Evidence)
        pub fn build(self) -> crate::model::Evidence {
            crate::model::Evidence {
                threat_intelligence_details: self.threat_intelligence_details,
            }
        }
    }
}
impl Evidence {
    /// Creates a new builder-style object to manufacture [`Evidence`](crate::model::Evidence)
    pub fn builder() -> crate::model::evidence::Builder {
        crate::model::evidence::Builder::default()
    }
}

/// <p>An instance of a threat intelligence detail that constitutes evidence for the
/// finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThreatIntelligenceDetail {
    /// <p>The name of the threat intelligence list that triggered the finding.</p>
    pub threat_list_name: std::option::Option<std::string::String>,
    /// <p>A list of names of the threats in the threat intelligence list that triggered the
    /// finding.</p>
    pub threat_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ThreatIntelligenceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThreatIntelligenceDetail");
        formatter.field("threat_list_name", &self.threat_list_name);
        formatter.field("threat_names", &self.threat_names);
        formatter.finish()
    }
}
/// See [`ThreatIntelligenceDetail`](crate::model::ThreatIntelligenceDetail)
pub mod threat_intelligence_detail {
    /// A builder for [`ThreatIntelligenceDetail`](crate::model::ThreatIntelligenceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) threat_list_name: std::option::Option<std::string::String>,
        pub(crate) threat_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the threat intelligence list that triggered the finding.</p>
        pub fn threat_list_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.threat_list_name = Some(input.into());
            self
        }
        /// <p>The name of the threat intelligence list that triggered the finding.</p>
        pub fn set_threat_list_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.threat_list_name = input;
            self
        }
        /// Appends an item to `threat_names`.
        ///
        /// To override the contents of this collection use [`set_threat_names`](Self::set_threat_names).
        ///
        /// <p>A list of names of the threats in the threat intelligence list that triggered the
        /// finding.</p>
        pub fn threat_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.threat_names.unwrap_or_default();
            v.push(input.into());
            self.threat_names = Some(v);
            self
        }
        /// <p>A list of names of the threats in the threat intelligence list that triggered the
        /// finding.</p>
        pub fn set_threat_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.threat_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ThreatIntelligenceDetail`](crate::model::ThreatIntelligenceDetail)
        pub fn build(self) -> crate::model::ThreatIntelligenceDetail {
            crate::model::ThreatIntelligenceDetail {
                threat_list_name: self.threat_list_name,
                threat_names: self.threat_names,
            }
        }
    }
}
impl ThreatIntelligenceDetail {
    /// Creates a new builder-style object to manufacture [`ThreatIntelligenceDetail`](crate::model::ThreatIntelligenceDetail)
    pub fn builder() -> crate::model::threat_intelligence_detail::Builder {
        crate::model::threat_intelligence_detail::Builder::default()
    }
}

/// <p>Contains information about actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Action {
    /// <p>The GuardDuty finding activity type.</p>
    pub action_type: std::option::Option<std::string::String>,
    /// <p>Information about the AWS_API_CALL action described in this finding.</p>
    pub aws_api_call_action: std::option::Option<crate::model::AwsApiCallAction>,
    /// <p>Information about the DNS_REQUEST action described in this finding.</p>
    pub dns_request_action: std::option::Option<crate::model::DnsRequestAction>,
    /// <p>Information about the NETWORK_CONNECTION action described in this finding.</p>
    pub network_connection_action: std::option::Option<crate::model::NetworkConnectionAction>,
    /// <p>Information about the PORT_PROBE action described in this finding.</p>
    pub port_probe_action: std::option::Option<crate::model::PortProbeAction>,
}
impl std::fmt::Debug for Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Action");
        formatter.field("action_type", &self.action_type);
        formatter.field("aws_api_call_action", &self.aws_api_call_action);
        formatter.field("dns_request_action", &self.dns_request_action);
        formatter.field("network_connection_action", &self.network_connection_action);
        formatter.field("port_probe_action", &self.port_probe_action);
        formatter.finish()
    }
}
/// See [`Action`](crate::model::Action)
pub mod action {
    /// A builder for [`Action`](crate::model::Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type: std::option::Option<std::string::String>,
        pub(crate) aws_api_call_action: std::option::Option<crate::model::AwsApiCallAction>,
        pub(crate) dns_request_action: std::option::Option<crate::model::DnsRequestAction>,
        pub(crate) network_connection_action:
            std::option::Option<crate::model::NetworkConnectionAction>,
        pub(crate) port_probe_action: std::option::Option<crate::model::PortProbeAction>,
    }
    impl Builder {
        /// <p>The GuardDuty finding activity type.</p>
        pub fn action_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_type = Some(input.into());
            self
        }
        /// <p>The GuardDuty finding activity type.</p>
        pub fn set_action_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_type = input;
            self
        }
        /// <p>Information about the AWS_API_CALL action described in this finding.</p>
        pub fn aws_api_call_action(mut self, input: crate::model::AwsApiCallAction) -> Self {
            self.aws_api_call_action = Some(input);
            self
        }
        /// <p>Information about the AWS_API_CALL action described in this finding.</p>
        pub fn set_aws_api_call_action(
            mut self,
            input: std::option::Option<crate::model::AwsApiCallAction>,
        ) -> Self {
            self.aws_api_call_action = input;
            self
        }
        /// <p>Information about the DNS_REQUEST action described in this finding.</p>
        pub fn dns_request_action(mut self, input: crate::model::DnsRequestAction) -> Self {
            self.dns_request_action = Some(input);
            self
        }
        /// <p>Information about the DNS_REQUEST action described in this finding.</p>
        pub fn set_dns_request_action(
            mut self,
            input: std::option::Option<crate::model::DnsRequestAction>,
        ) -> Self {
            self.dns_request_action = input;
            self
        }
        /// <p>Information about the NETWORK_CONNECTION action described in this finding.</p>
        pub fn network_connection_action(
            mut self,
            input: crate::model::NetworkConnectionAction,
        ) -> Self {
            self.network_connection_action = Some(input);
            self
        }
        /// <p>Information about the NETWORK_CONNECTION action described in this finding.</p>
        pub fn set_network_connection_action(
            mut self,
            input: std::option::Option<crate::model::NetworkConnectionAction>,
        ) -> Self {
            self.network_connection_action = input;
            self
        }
        /// <p>Information about the PORT_PROBE action described in this finding.</p>
        pub fn port_probe_action(mut self, input: crate::model::PortProbeAction) -> Self {
            self.port_probe_action = Some(input);
            self
        }
        /// <p>Information about the PORT_PROBE action described in this finding.</p>
        pub fn set_port_probe_action(
            mut self,
            input: std::option::Option<crate::model::PortProbeAction>,
        ) -> Self {
            self.port_probe_action = input;
            self
        }
        /// Consumes the builder and constructs a [`Action`](crate::model::Action)
        pub fn build(self) -> crate::model::Action {
            crate::model::Action {
                action_type: self.action_type,
                aws_api_call_action: self.aws_api_call_action,
                dns_request_action: self.dns_request_action,
                network_connection_action: self.network_connection_action,
                port_probe_action: self.port_probe_action,
            }
        }
    }
}
impl Action {
    /// Creates a new builder-style object to manufacture [`Action`](crate::model::Action)
    pub fn builder() -> crate::model::action::Builder {
        crate::model::action::Builder::default()
    }
}

/// <p>Contains information about the PORT_PROBE action described in the finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortProbeAction {
    /// <p>Indicates whether EC2 blocked the port probe to the instance, such as with an ACL.</p>
    pub blocked: bool,
    /// <p>A list of objects related to port probe details.</p>
    pub port_probe_details: std::option::Option<std::vec::Vec<crate::model::PortProbeDetail>>,
}
impl std::fmt::Debug for PortProbeAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortProbeAction");
        formatter.field("blocked", &self.blocked);
        formatter.field("port_probe_details", &self.port_probe_details);
        formatter.finish()
    }
}
/// See [`PortProbeAction`](crate::model::PortProbeAction)
pub mod port_probe_action {
    /// A builder for [`PortProbeAction`](crate::model::PortProbeAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blocked: std::option::Option<bool>,
        pub(crate) port_probe_details:
            std::option::Option<std::vec::Vec<crate::model::PortProbeDetail>>,
    }
    impl Builder {
        /// <p>Indicates whether EC2 blocked the port probe to the instance, such as with an ACL.</p>
        pub fn blocked(mut self, input: bool) -> Self {
            self.blocked = Some(input);
            self
        }
        /// <p>Indicates whether EC2 blocked the port probe to the instance, such as with an ACL.</p>
        pub fn set_blocked(mut self, input: std::option::Option<bool>) -> Self {
            self.blocked = input;
            self
        }
        /// Appends an item to `port_probe_details`.
        ///
        /// To override the contents of this collection use [`set_port_probe_details`](Self::set_port_probe_details).
        ///
        /// <p>A list of objects related to port probe details.</p>
        pub fn port_probe_details(
            mut self,
            input: impl Into<crate::model::PortProbeDetail>,
        ) -> Self {
            let mut v = self.port_probe_details.unwrap_or_default();
            v.push(input.into());
            self.port_probe_details = Some(v);
            self
        }
        /// <p>A list of objects related to port probe details.</p>
        pub fn set_port_probe_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortProbeDetail>>,
        ) -> Self {
            self.port_probe_details = input;
            self
        }
        /// Consumes the builder and constructs a [`PortProbeAction`](crate::model::PortProbeAction)
        pub fn build(self) -> crate::model::PortProbeAction {
            crate::model::PortProbeAction {
                blocked: self.blocked.unwrap_or_default(),
                port_probe_details: self.port_probe_details,
            }
        }
    }
}
impl PortProbeAction {
    /// Creates a new builder-style object to manufacture [`PortProbeAction`](crate::model::PortProbeAction)
    pub fn builder() -> crate::model::port_probe_action::Builder {
        crate::model::port_probe_action::Builder::default()
    }
}

/// <p>Contains information about the port probe details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortProbeDetail {
    /// <p>The local port information of the connection.</p>
    pub local_port_details: std::option::Option<crate::model::LocalPortDetails>,
    /// <p>The local IP information of the connection.</p>
    pub local_ip_details: std::option::Option<crate::model::LocalIpDetails>,
    /// <p>The remote IP information of the connection.</p>
    pub remote_ip_details: std::option::Option<crate::model::RemoteIpDetails>,
}
impl std::fmt::Debug for PortProbeDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortProbeDetail");
        formatter.field("local_port_details", &self.local_port_details);
        formatter.field("local_ip_details", &self.local_ip_details);
        formatter.field("remote_ip_details", &self.remote_ip_details);
        formatter.finish()
    }
}
/// See [`PortProbeDetail`](crate::model::PortProbeDetail)
pub mod port_probe_detail {
    /// A builder for [`PortProbeDetail`](crate::model::PortProbeDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) local_port_details: std::option::Option<crate::model::LocalPortDetails>,
        pub(crate) local_ip_details: std::option::Option<crate::model::LocalIpDetails>,
        pub(crate) remote_ip_details: std::option::Option<crate::model::RemoteIpDetails>,
    }
    impl Builder {
        /// <p>The local port information of the connection.</p>
        pub fn local_port_details(mut self, input: crate::model::LocalPortDetails) -> Self {
            self.local_port_details = Some(input);
            self
        }
        /// <p>The local port information of the connection.</p>
        pub fn set_local_port_details(
            mut self,
            input: std::option::Option<crate::model::LocalPortDetails>,
        ) -> Self {
            self.local_port_details = input;
            self
        }
        /// <p>The local IP information of the connection.</p>
        pub fn local_ip_details(mut self, input: crate::model::LocalIpDetails) -> Self {
            self.local_ip_details = Some(input);
            self
        }
        /// <p>The local IP information of the connection.</p>
        pub fn set_local_ip_details(
            mut self,
            input: std::option::Option<crate::model::LocalIpDetails>,
        ) -> Self {
            self.local_ip_details = input;
            self
        }
        /// <p>The remote IP information of the connection.</p>
        pub fn remote_ip_details(mut self, input: crate::model::RemoteIpDetails) -> Self {
            self.remote_ip_details = Some(input);
            self
        }
        /// <p>The remote IP information of the connection.</p>
        pub fn set_remote_ip_details(
            mut self,
            input: std::option::Option<crate::model::RemoteIpDetails>,
        ) -> Self {
            self.remote_ip_details = input;
            self
        }
        /// Consumes the builder and constructs a [`PortProbeDetail`](crate::model::PortProbeDetail)
        pub fn build(self) -> crate::model::PortProbeDetail {
            crate::model::PortProbeDetail {
                local_port_details: self.local_port_details,
                local_ip_details: self.local_ip_details,
                remote_ip_details: self.remote_ip_details,
            }
        }
    }
}
impl PortProbeDetail {
    /// Creates a new builder-style object to manufacture [`PortProbeDetail`](crate::model::PortProbeDetail)
    pub fn builder() -> crate::model::port_probe_detail::Builder {
        crate::model::port_probe_detail::Builder::default()
    }
}

/// <p>Contains information about the remote IP address of the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoteIpDetails {
    /// <p>The city information of the remote IP address.</p>
    pub city: std::option::Option<crate::model::City>,
    /// <p>The country code of the remote IP address.</p>
    pub country: std::option::Option<crate::model::Country>,
    /// <p>The location information of the remote IP address.</p>
    pub geo_location: std::option::Option<crate::model::GeoLocation>,
    /// <p>The IPv4 remote address of the connection.</p>
    pub ip_address_v4: std::option::Option<std::string::String>,
    /// <p>The ISP organization information of the remote IP address.</p>
    pub organization: std::option::Option<crate::model::Organization>,
}
impl std::fmt::Debug for RemoteIpDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoteIpDetails");
        formatter.field("city", &self.city);
        formatter.field("country", &self.country);
        formatter.field("geo_location", &self.geo_location);
        formatter.field("ip_address_v4", &self.ip_address_v4);
        formatter.field("organization", &self.organization);
        formatter.finish()
    }
}
/// See [`RemoteIpDetails`](crate::model::RemoteIpDetails)
pub mod remote_ip_details {
    /// A builder for [`RemoteIpDetails`](crate::model::RemoteIpDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) city: std::option::Option<crate::model::City>,
        pub(crate) country: std::option::Option<crate::model::Country>,
        pub(crate) geo_location: std::option::Option<crate::model::GeoLocation>,
        pub(crate) ip_address_v4: std::option::Option<std::string::String>,
        pub(crate) organization: std::option::Option<crate::model::Organization>,
    }
    impl Builder {
        /// <p>The city information of the remote IP address.</p>
        pub fn city(mut self, input: crate::model::City) -> Self {
            self.city = Some(input);
            self
        }
        /// <p>The city information of the remote IP address.</p>
        pub fn set_city(mut self, input: std::option::Option<crate::model::City>) -> Self {
            self.city = input;
            self
        }
        /// <p>The country code of the remote IP address.</p>
        pub fn country(mut self, input: crate::model::Country) -> Self {
            self.country = Some(input);
            self
        }
        /// <p>The country code of the remote IP address.</p>
        pub fn set_country(mut self, input: std::option::Option<crate::model::Country>) -> Self {
            self.country = input;
            self
        }
        /// <p>The location information of the remote IP address.</p>
        pub fn geo_location(mut self, input: crate::model::GeoLocation) -> Self {
            self.geo_location = Some(input);
            self
        }
        /// <p>The location information of the remote IP address.</p>
        pub fn set_geo_location(
            mut self,
            input: std::option::Option<crate::model::GeoLocation>,
        ) -> Self {
            self.geo_location = input;
            self
        }
        /// <p>The IPv4 remote address of the connection.</p>
        pub fn ip_address_v4(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address_v4 = Some(input.into());
            self
        }
        /// <p>The IPv4 remote address of the connection.</p>
        pub fn set_ip_address_v4(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ip_address_v4 = input;
            self
        }
        /// <p>The ISP organization information of the remote IP address.</p>
        pub fn organization(mut self, input: crate::model::Organization) -> Self {
            self.organization = Some(input);
            self
        }
        /// <p>The ISP organization information of the remote IP address.</p>
        pub fn set_organization(
            mut self,
            input: std::option::Option<crate::model::Organization>,
        ) -> Self {
            self.organization = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoteIpDetails`](crate::model::RemoteIpDetails)
        pub fn build(self) -> crate::model::RemoteIpDetails {
            crate::model::RemoteIpDetails {
                city: self.city,
                country: self.country,
                geo_location: self.geo_location,
                ip_address_v4: self.ip_address_v4,
                organization: self.organization,
            }
        }
    }
}
impl RemoteIpDetails {
    /// Creates a new builder-style object to manufacture [`RemoteIpDetails`](crate::model::RemoteIpDetails)
    pub fn builder() -> crate::model::remote_ip_details::Builder {
        crate::model::remote_ip_details::Builder::default()
    }
}

/// <p>Contains information about the ISP organization of the remote IP address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Organization {
    /// <p>The Autonomous System Number (ASN) of the internet provider of the remote IP
    /// address.</p>
    pub asn: std::option::Option<std::string::String>,
    /// <p>The organization that registered this ASN.</p>
    pub asn_org: std::option::Option<std::string::String>,
    /// <p>The ISP information for the internet provider.</p>
    pub isp: std::option::Option<std::string::String>,
    /// <p>The name of the internet provider.</p>
    pub org: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Organization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Organization");
        formatter.field("asn", &self.asn);
        formatter.field("asn_org", &self.asn_org);
        formatter.field("isp", &self.isp);
        formatter.field("org", &self.org);
        formatter.finish()
    }
}
/// See [`Organization`](crate::model::Organization)
pub mod organization {
    /// A builder for [`Organization`](crate::model::Organization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asn: std::option::Option<std::string::String>,
        pub(crate) asn_org: std::option::Option<std::string::String>,
        pub(crate) isp: std::option::Option<std::string::String>,
        pub(crate) org: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Autonomous System Number (ASN) of the internet provider of the remote IP
        /// address.</p>
        pub fn asn(mut self, input: impl Into<std::string::String>) -> Self {
            self.asn = Some(input.into());
            self
        }
        /// <p>The Autonomous System Number (ASN) of the internet provider of the remote IP
        /// address.</p>
        pub fn set_asn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The organization that registered this ASN.</p>
        pub fn asn_org(mut self, input: impl Into<std::string::String>) -> Self {
            self.asn_org = Some(input.into());
            self
        }
        /// <p>The organization that registered this ASN.</p>
        pub fn set_asn_org(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asn_org = input;
            self
        }
        /// <p>The ISP information for the internet provider.</p>
        pub fn isp(mut self, input: impl Into<std::string::String>) -> Self {
            self.isp = Some(input.into());
            self
        }
        /// <p>The ISP information for the internet provider.</p>
        pub fn set_isp(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.isp = input;
            self
        }
        /// <p>The name of the internet provider.</p>
        pub fn org(mut self, input: impl Into<std::string::String>) -> Self {
            self.org = Some(input.into());
            self
        }
        /// <p>The name of the internet provider.</p>
        pub fn set_org(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.org = input;
            self
        }
        /// Consumes the builder and constructs a [`Organization`](crate::model::Organization)
        pub fn build(self) -> crate::model::Organization {
            crate::model::Organization {
                asn: self.asn,
                asn_org: self.asn_org,
                isp: self.isp,
                org: self.org,
            }
        }
    }
}
impl Organization {
    /// Creates a new builder-style object to manufacture [`Organization`](crate::model::Organization)
    pub fn builder() -> crate::model::organization::Builder {
        crate::model::organization::Builder::default()
    }
}

/// <p>Contains information about the location of the remote IP address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeoLocation {
    /// <p>The latitude information of the remote IP address.</p>
    pub lat: f64,
    /// <p>The longitude information of the remote IP address.</p>
    pub lon: f64,
}
impl std::fmt::Debug for GeoLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeoLocation");
        formatter.field("lat", &self.lat);
        formatter.field("lon", &self.lon);
        formatter.finish()
    }
}
/// See [`GeoLocation`](crate::model::GeoLocation)
pub mod geo_location {
    /// A builder for [`GeoLocation`](crate::model::GeoLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lat: std::option::Option<f64>,
        pub(crate) lon: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The latitude information of the remote IP address.</p>
        pub fn lat(mut self, input: f64) -> Self {
            self.lat = Some(input);
            self
        }
        /// <p>The latitude information of the remote IP address.</p>
        pub fn set_lat(mut self, input: std::option::Option<f64>) -> Self {
            self.lat = input;
            self
        }
        /// <p>The longitude information of the remote IP address.</p>
        pub fn lon(mut self, input: f64) -> Self {
            self.lon = Some(input);
            self
        }
        /// <p>The longitude information of the remote IP address.</p>
        pub fn set_lon(mut self, input: std::option::Option<f64>) -> Self {
            self.lon = input;
            self
        }
        /// Consumes the builder and constructs a [`GeoLocation`](crate::model::GeoLocation)
        pub fn build(self) -> crate::model::GeoLocation {
            crate::model::GeoLocation {
                lat: self.lat.unwrap_or_default(),
                lon: self.lon.unwrap_or_default(),
            }
        }
    }
}
impl GeoLocation {
    /// Creates a new builder-style object to manufacture [`GeoLocation`](crate::model::GeoLocation)
    pub fn builder() -> crate::model::geo_location::Builder {
        crate::model::geo_location::Builder::default()
    }
}

/// <p>Contains information about the country where the remote IP address is located.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Country {
    /// <p>The country code of the remote IP address.</p>
    pub country_code: std::option::Option<std::string::String>,
    /// <p>The country name of the remote IP address.</p>
    pub country_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Country {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Country");
        formatter.field("country_code", &self.country_code);
        formatter.field("country_name", &self.country_name);
        formatter.finish()
    }
}
/// See [`Country`](crate::model::Country)
pub mod country {
    /// A builder for [`Country`](crate::model::Country)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) country_code: std::option::Option<std::string::String>,
        pub(crate) country_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The country code of the remote IP address.</p>
        pub fn country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.country_code = Some(input.into());
            self
        }
        /// <p>The country code of the remote IP address.</p>
        pub fn set_country_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country_code = input;
            self
        }
        /// <p>The country name of the remote IP address.</p>
        pub fn country_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.country_name = Some(input.into());
            self
        }
        /// <p>The country name of the remote IP address.</p>
        pub fn set_country_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Country`](crate::model::Country)
        pub fn build(self) -> crate::model::Country {
            crate::model::Country {
                country_code: self.country_code,
                country_name: self.country_name,
            }
        }
    }
}
impl Country {
    /// Creates a new builder-style object to manufacture [`Country`](crate::model::Country)
    pub fn builder() -> crate::model::country::Builder {
        crate::model::country::Builder::default()
    }
}

/// <p>Contains information about the city associated with the IP address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct City {
    /// <p>The city name of the remote IP address.</p>
    pub city_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for City {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("City");
        formatter.field("city_name", &self.city_name);
        formatter.finish()
    }
}
/// See [`City`](crate::model::City)
pub mod city {
    /// A builder for [`City`](crate::model::City)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) city_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The city name of the remote IP address.</p>
        pub fn city_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.city_name = Some(input.into());
            self
        }
        /// <p>The city name of the remote IP address.</p>
        pub fn set_city_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.city_name = input;
            self
        }
        /// Consumes the builder and constructs a [`City`](crate::model::City)
        pub fn build(self) -> crate::model::City {
            crate::model::City {
                city_name: self.city_name,
            }
        }
    }
}
impl City {
    /// Creates a new builder-style object to manufacture [`City`](crate::model::City)
    pub fn builder() -> crate::model::city::Builder {
        crate::model::city::Builder::default()
    }
}

/// <p>Contains information about the local IP address of the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocalIpDetails {
    /// <p>The IPv4 local address of the connection.</p>
    pub ip_address_v4: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LocalIpDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocalIpDetails");
        formatter.field("ip_address_v4", &self.ip_address_v4);
        formatter.finish()
    }
}
/// See [`LocalIpDetails`](crate::model::LocalIpDetails)
pub mod local_ip_details {
    /// A builder for [`LocalIpDetails`](crate::model::LocalIpDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address_v4: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IPv4 local address of the connection.</p>
        pub fn ip_address_v4(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address_v4 = Some(input.into());
            self
        }
        /// <p>The IPv4 local address of the connection.</p>
        pub fn set_ip_address_v4(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ip_address_v4 = input;
            self
        }
        /// Consumes the builder and constructs a [`LocalIpDetails`](crate::model::LocalIpDetails)
        pub fn build(self) -> crate::model::LocalIpDetails {
            crate::model::LocalIpDetails {
                ip_address_v4: self.ip_address_v4,
            }
        }
    }
}
impl LocalIpDetails {
    /// Creates a new builder-style object to manufacture [`LocalIpDetails`](crate::model::LocalIpDetails)
    pub fn builder() -> crate::model::local_ip_details::Builder {
        crate::model::local_ip_details::Builder::default()
    }
}

/// <p>Contains information about the port for the local connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocalPortDetails {
    /// <p>The port number of the local connection.</p>
    pub port: i32,
    /// <p>The port name of the local connection.</p>
    pub port_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LocalPortDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocalPortDetails");
        formatter.field("port", &self.port);
        formatter.field("port_name", &self.port_name);
        formatter.finish()
    }
}
/// See [`LocalPortDetails`](crate::model::LocalPortDetails)
pub mod local_port_details {
    /// A builder for [`LocalPortDetails`](crate::model::LocalPortDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port: std::option::Option<i32>,
        pub(crate) port_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The port number of the local connection.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number of the local connection.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The port name of the local connection.</p>
        pub fn port_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_name = Some(input.into());
            self
        }
        /// <p>The port name of the local connection.</p>
        pub fn set_port_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.port_name = input;
            self
        }
        /// Consumes the builder and constructs a [`LocalPortDetails`](crate::model::LocalPortDetails)
        pub fn build(self) -> crate::model::LocalPortDetails {
            crate::model::LocalPortDetails {
                port: self.port.unwrap_or_default(),
                port_name: self.port_name,
            }
        }
    }
}
impl LocalPortDetails {
    /// Creates a new builder-style object to manufacture [`LocalPortDetails`](crate::model::LocalPortDetails)
    pub fn builder() -> crate::model::local_port_details::Builder {
        crate::model::local_port_details::Builder::default()
    }
}

/// <p>Contains information about the NETWORK_CONNECTION action described in the finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkConnectionAction {
    /// <p>Indicates whether EC2 blocked the network connection to your instance.</p>
    pub blocked: bool,
    /// <p>The network connection direction.</p>
    pub connection_direction: std::option::Option<std::string::String>,
    /// <p>The local port information of the connection.</p>
    pub local_port_details: std::option::Option<crate::model::LocalPortDetails>,
    /// <p>The network connection protocol.</p>
    pub protocol: std::option::Option<std::string::String>,
    /// <p>The local IP information of the connection.</p>
    pub local_ip_details: std::option::Option<crate::model::LocalIpDetails>,
    /// <p>The remote IP information of the connection.</p>
    pub remote_ip_details: std::option::Option<crate::model::RemoteIpDetails>,
    /// <p>The remote port information of the connection.</p>
    pub remote_port_details: std::option::Option<crate::model::RemotePortDetails>,
}
impl std::fmt::Debug for NetworkConnectionAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkConnectionAction");
        formatter.field("blocked", &self.blocked);
        formatter.field("connection_direction", &self.connection_direction);
        formatter.field("local_port_details", &self.local_port_details);
        formatter.field("protocol", &self.protocol);
        formatter.field("local_ip_details", &self.local_ip_details);
        formatter.field("remote_ip_details", &self.remote_ip_details);
        formatter.field("remote_port_details", &self.remote_port_details);
        formatter.finish()
    }
}
/// See [`NetworkConnectionAction`](crate::model::NetworkConnectionAction)
pub mod network_connection_action {
    /// A builder for [`NetworkConnectionAction`](crate::model::NetworkConnectionAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blocked: std::option::Option<bool>,
        pub(crate) connection_direction: std::option::Option<std::string::String>,
        pub(crate) local_port_details: std::option::Option<crate::model::LocalPortDetails>,
        pub(crate) protocol: std::option::Option<std::string::String>,
        pub(crate) local_ip_details: std::option::Option<crate::model::LocalIpDetails>,
        pub(crate) remote_ip_details: std::option::Option<crate::model::RemoteIpDetails>,
        pub(crate) remote_port_details: std::option::Option<crate::model::RemotePortDetails>,
    }
    impl Builder {
        /// <p>Indicates whether EC2 blocked the network connection to your instance.</p>
        pub fn blocked(mut self, input: bool) -> Self {
            self.blocked = Some(input);
            self
        }
        /// <p>Indicates whether EC2 blocked the network connection to your instance.</p>
        pub fn set_blocked(mut self, input: std::option::Option<bool>) -> Self {
            self.blocked = input;
            self
        }
        /// <p>The network connection direction.</p>
        pub fn connection_direction(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_direction = Some(input.into());
            self
        }
        /// <p>The network connection direction.</p>
        pub fn set_connection_direction(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_direction = input;
            self
        }
        /// <p>The local port information of the connection.</p>
        pub fn local_port_details(mut self, input: crate::model::LocalPortDetails) -> Self {
            self.local_port_details = Some(input);
            self
        }
        /// <p>The local port information of the connection.</p>
        pub fn set_local_port_details(
            mut self,
            input: std::option::Option<crate::model::LocalPortDetails>,
        ) -> Self {
            self.local_port_details = input;
            self
        }
        /// <p>The network connection protocol.</p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The network connection protocol.</p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The local IP information of the connection.</p>
        pub fn local_ip_details(mut self, input: crate::model::LocalIpDetails) -> Self {
            self.local_ip_details = Some(input);
            self
        }
        /// <p>The local IP information of the connection.</p>
        pub fn set_local_ip_details(
            mut self,
            input: std::option::Option<crate::model::LocalIpDetails>,
        ) -> Self {
            self.local_ip_details = input;
            self
        }
        /// <p>The remote IP information of the connection.</p>
        pub fn remote_ip_details(mut self, input: crate::model::RemoteIpDetails) -> Self {
            self.remote_ip_details = Some(input);
            self
        }
        /// <p>The remote IP information of the connection.</p>
        pub fn set_remote_ip_details(
            mut self,
            input: std::option::Option<crate::model::RemoteIpDetails>,
        ) -> Self {
            self.remote_ip_details = input;
            self
        }
        /// <p>The remote port information of the connection.</p>
        pub fn remote_port_details(mut self, input: crate::model::RemotePortDetails) -> Self {
            self.remote_port_details = Some(input);
            self
        }
        /// <p>The remote port information of the connection.</p>
        pub fn set_remote_port_details(
            mut self,
            input: std::option::Option<crate::model::RemotePortDetails>,
        ) -> Self {
            self.remote_port_details = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkConnectionAction`](crate::model::NetworkConnectionAction)
        pub fn build(self) -> crate::model::NetworkConnectionAction {
            crate::model::NetworkConnectionAction {
                blocked: self.blocked.unwrap_or_default(),
                connection_direction: self.connection_direction,
                local_port_details: self.local_port_details,
                protocol: self.protocol,
                local_ip_details: self.local_ip_details,
                remote_ip_details: self.remote_ip_details,
                remote_port_details: self.remote_port_details,
            }
        }
    }
}
impl NetworkConnectionAction {
    /// Creates a new builder-style object to manufacture [`NetworkConnectionAction`](crate::model::NetworkConnectionAction)
    pub fn builder() -> crate::model::network_connection_action::Builder {
        crate::model::network_connection_action::Builder::default()
    }
}

/// <p>Contains information about the remote port.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemotePortDetails {
    /// <p>The port number of the remote connection.</p>
    pub port: i32,
    /// <p>The port name of the remote connection.</p>
    pub port_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemotePortDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemotePortDetails");
        formatter.field("port", &self.port);
        formatter.field("port_name", &self.port_name);
        formatter.finish()
    }
}
/// See [`RemotePortDetails`](crate::model::RemotePortDetails)
pub mod remote_port_details {
    /// A builder for [`RemotePortDetails`](crate::model::RemotePortDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port: std::option::Option<i32>,
        pub(crate) port_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The port number of the remote connection.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number of the remote connection.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The port name of the remote connection.</p>
        pub fn port_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.port_name = Some(input.into());
            self
        }
        /// <p>The port name of the remote connection.</p>
        pub fn set_port_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.port_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RemotePortDetails`](crate::model::RemotePortDetails)
        pub fn build(self) -> crate::model::RemotePortDetails {
            crate::model::RemotePortDetails {
                port: self.port.unwrap_or_default(),
                port_name: self.port_name,
            }
        }
    }
}
impl RemotePortDetails {
    /// Creates a new builder-style object to manufacture [`RemotePortDetails`](crate::model::RemotePortDetails)
    pub fn builder() -> crate::model::remote_port_details::Builder {
        crate::model::remote_port_details::Builder::default()
    }
}

/// <p>Contains information about the DNS_REQUEST action described in this finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsRequestAction {
    /// <p>The domain information for the API request.</p>
    pub domain: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DnsRequestAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsRequestAction");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`DnsRequestAction`](crate::model::DnsRequestAction)
pub mod dns_request_action {
    /// A builder for [`DnsRequestAction`](crate::model::DnsRequestAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain information for the API request.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain information for the API request.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsRequestAction`](crate::model::DnsRequestAction)
        pub fn build(self) -> crate::model::DnsRequestAction {
            crate::model::DnsRequestAction {
                domain: self.domain,
            }
        }
    }
}
impl DnsRequestAction {
    /// Creates a new builder-style object to manufacture [`DnsRequestAction`](crate::model::DnsRequestAction)
    pub fn builder() -> crate::model::dns_request_action::Builder {
        crate::model::dns_request_action::Builder::default()
    }
}

/// <p>Contains information about the API action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsApiCallAction {
    /// <p>The AWS API name.</p>
    pub api: std::option::Option<std::string::String>,
    /// <p>The AWS API caller type.</p>
    pub caller_type: std::option::Option<std::string::String>,
    /// <p>The domain information for the AWS API call.</p>
    pub domain_details: std::option::Option<crate::model::DomainDetails>,
    /// <p>The error code of the failed AWS API action.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The remote IP information of the connection that initiated the AWS API call.</p>
    pub remote_ip_details: std::option::Option<crate::model::RemoteIpDetails>,
    /// <p>The AWS service name whose API was invoked.</p>
    pub service_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsApiCallAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsApiCallAction");
        formatter.field("api", &self.api);
        formatter.field("caller_type", &self.caller_type);
        formatter.field("domain_details", &self.domain_details);
        formatter.field("error_code", &self.error_code);
        formatter.field("remote_ip_details", &self.remote_ip_details);
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}
/// See [`AwsApiCallAction`](crate::model::AwsApiCallAction)
pub mod aws_api_call_action {
    /// A builder for [`AwsApiCallAction`](crate::model::AwsApiCallAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api: std::option::Option<std::string::String>,
        pub(crate) caller_type: std::option::Option<std::string::String>,
        pub(crate) domain_details: std::option::Option<crate::model::DomainDetails>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) remote_ip_details: std::option::Option<crate::model::RemoteIpDetails>,
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS API name.</p>
        pub fn api(mut self, input: impl Into<std::string::String>) -> Self {
            self.api = Some(input.into());
            self
        }
        /// <p>The AWS API name.</p>
        pub fn set_api(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api = input;
            self
        }
        /// <p>The AWS API caller type.</p>
        pub fn caller_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_type = Some(input.into());
            self
        }
        /// <p>The AWS API caller type.</p>
        pub fn set_caller_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.caller_type = input;
            self
        }
        /// <p>The domain information for the AWS API call.</p>
        pub fn domain_details(mut self, input: crate::model::DomainDetails) -> Self {
            self.domain_details = Some(input);
            self
        }
        /// <p>The domain information for the AWS API call.</p>
        pub fn set_domain_details(
            mut self,
            input: std::option::Option<crate::model::DomainDetails>,
        ) -> Self {
            self.domain_details = input;
            self
        }
        /// <p>The error code of the failed AWS API action.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code of the failed AWS API action.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The remote IP information of the connection that initiated the AWS API call.</p>
        pub fn remote_ip_details(mut self, input: crate::model::RemoteIpDetails) -> Self {
            self.remote_ip_details = Some(input);
            self
        }
        /// <p>The remote IP information of the connection that initiated the AWS API call.</p>
        pub fn set_remote_ip_details(
            mut self,
            input: std::option::Option<crate::model::RemoteIpDetails>,
        ) -> Self {
            self.remote_ip_details = input;
            self
        }
        /// <p>The AWS service name whose API was invoked.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The AWS service name whose API was invoked.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsApiCallAction`](crate::model::AwsApiCallAction)
        pub fn build(self) -> crate::model::AwsApiCallAction {
            crate::model::AwsApiCallAction {
                api: self.api,
                caller_type: self.caller_type,
                domain_details: self.domain_details,
                error_code: self.error_code,
                remote_ip_details: self.remote_ip_details,
                service_name: self.service_name,
            }
        }
    }
}
impl AwsApiCallAction {
    /// Creates a new builder-style object to manufacture [`AwsApiCallAction`](crate::model::AwsApiCallAction)
    pub fn builder() -> crate::model::aws_api_call_action::Builder {
        crate::model::aws_api_call_action::Builder::default()
    }
}

/// <p>Contains information about the domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainDetails {
    /// <p>The domain information for the AWS API call.</p>
    pub domain: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DomainDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainDetails");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`DomainDetails`](crate::model::DomainDetails)
pub mod domain_details {
    /// A builder for [`DomainDetails`](crate::model::DomainDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain information for the AWS API call.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The domain information for the AWS API call.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainDetails`](crate::model::DomainDetails)
        pub fn build(self) -> crate::model::DomainDetails {
            crate::model::DomainDetails {
                domain: self.domain,
            }
        }
    }
}
impl DomainDetails {
    /// Creates a new builder-style object to manufacture [`DomainDetails`](crate::model::DomainDetails)
    pub fn builder() -> crate::model::domain_details::Builder {
        crate::model::domain_details::Builder::default()
    }
}

/// <p>Contains information about the AWS resource associated with the activity that prompted
/// GuardDuty to generate a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The IAM access key details (IAM user information) of a user that engaged in the activity
    /// that prompted GuardDuty to generate a finding.</p>
    pub access_key_details: std::option::Option<crate::model::AccessKeyDetails>,
    /// <p>Contains information on the S3 bucket.</p>
    pub s3_bucket_details: std::option::Option<std::vec::Vec<crate::model::S3BucketDetail>>,
    /// <p>The information about the EC2 instance associated with the activity that prompted
    /// GuardDuty to generate a finding.</p>
    pub instance_details: std::option::Option<crate::model::InstanceDetails>,
    /// <p>The type of AWS resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("access_key_details", &self.access_key_details);
        formatter.field("s3_bucket_details", &self.s3_bucket_details);
        formatter.field("instance_details", &self.instance_details);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_details: std::option::Option<crate::model::AccessKeyDetails>,
        pub(crate) s3_bucket_details:
            std::option::Option<std::vec::Vec<crate::model::S3BucketDetail>>,
        pub(crate) instance_details: std::option::Option<crate::model::InstanceDetails>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM access key details (IAM user information) of a user that engaged in the activity
        /// that prompted GuardDuty to generate a finding.</p>
        pub fn access_key_details(mut self, input: crate::model::AccessKeyDetails) -> Self {
            self.access_key_details = Some(input);
            self
        }
        /// <p>The IAM access key details (IAM user information) of a user that engaged in the activity
        /// that prompted GuardDuty to generate a finding.</p>
        pub fn set_access_key_details(
            mut self,
            input: std::option::Option<crate::model::AccessKeyDetails>,
        ) -> Self {
            self.access_key_details = input;
            self
        }
        /// Appends an item to `s3_bucket_details`.
        ///
        /// To override the contents of this collection use [`set_s3_bucket_details`](Self::set_s3_bucket_details).
        ///
        /// <p>Contains information on the S3 bucket.</p>
        pub fn s3_bucket_details(mut self, input: impl Into<crate::model::S3BucketDetail>) -> Self {
            let mut v = self.s3_bucket_details.unwrap_or_default();
            v.push(input.into());
            self.s3_bucket_details = Some(v);
            self
        }
        /// <p>Contains information on the S3 bucket.</p>
        pub fn set_s3_bucket_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3BucketDetail>>,
        ) -> Self {
            self.s3_bucket_details = input;
            self
        }
        /// <p>The information about the EC2 instance associated with the activity that prompted
        /// GuardDuty to generate a finding.</p>
        pub fn instance_details(mut self, input: crate::model::InstanceDetails) -> Self {
            self.instance_details = Some(input);
            self
        }
        /// <p>The information about the EC2 instance associated with the activity that prompted
        /// GuardDuty to generate a finding.</p>
        pub fn set_instance_details(
            mut self,
            input: std::option::Option<crate::model::InstanceDetails>,
        ) -> Self {
            self.instance_details = input;
            self
        }
        /// <p>The type of AWS resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of AWS resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                access_key_details: self.access_key_details,
                s3_bucket_details: self.s3_bucket_details,
                instance_details: self.instance_details,
                resource_type: self.resource_type,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p>Contains information about the details of an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceDetails {
    /// <p>The Availability Zone of the EC2 instance.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The profile information of the EC2 instance.</p>
    pub iam_instance_profile: std::option::Option<crate::model::IamInstanceProfile>,
    /// <p>The image description of the EC2 instance.</p>
    pub image_description: std::option::Option<std::string::String>,
    /// <p>The image ID of the EC2 instance.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The ID of the EC2 instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The state of the EC2 instance.</p>
    pub instance_state: std::option::Option<std::string::String>,
    /// <p>The type of the EC2 instance.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Outpost. Only applicable to AWS Outposts
    /// instances.</p>
    pub outpost_arn: std::option::Option<std::string::String>,
    /// <p>The launch time of the EC2 instance.</p>
    pub launch_time: std::option::Option<std::string::String>,
    /// <p>The elastic network interface information of the EC2 instance.</p>
    pub network_interfaces: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
    /// <p>The platform of the EC2 instance.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The product code of the EC2 instance.</p>
    pub product_codes: std::option::Option<std::vec::Vec<crate::model::ProductCode>>,
    /// <p>The tags of the EC2 instance.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for InstanceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceDetails");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("iam_instance_profile", &self.iam_instance_profile);
        formatter.field("image_description", &self.image_description);
        formatter.field("image_id", &self.image_id);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("instance_state", &self.instance_state);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("outpost_arn", &self.outpost_arn);
        formatter.field("launch_time", &self.launch_time);
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.field("platform", &self.platform);
        formatter.field("product_codes", &self.product_codes);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`InstanceDetails`](crate::model::InstanceDetails)
pub mod instance_details {
    /// A builder for [`InstanceDetails`](crate::model::InstanceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) iam_instance_profile: std::option::Option<crate::model::IamInstanceProfile>,
        pub(crate) image_description: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) instance_state: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) outpost_arn: std::option::Option<std::string::String>,
        pub(crate) launch_time: std::option::Option<std::string::String>,
        pub(crate) network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) product_codes: std::option::Option<std::vec::Vec<crate::model::ProductCode>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Availability Zone of the EC2 instance.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone of the EC2 instance.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The profile information of the EC2 instance.</p>
        pub fn iam_instance_profile(mut self, input: crate::model::IamInstanceProfile) -> Self {
            self.iam_instance_profile = Some(input);
            self
        }
        /// <p>The profile information of the EC2 instance.</p>
        pub fn set_iam_instance_profile(
            mut self,
            input: std::option::Option<crate::model::IamInstanceProfile>,
        ) -> Self {
            self.iam_instance_profile = input;
            self
        }
        /// <p>The image description of the EC2 instance.</p>
        pub fn image_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_description = Some(input.into());
            self
        }
        /// <p>The image description of the EC2 instance.</p>
        pub fn set_image_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_description = input;
            self
        }
        /// <p>The image ID of the EC2 instance.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The image ID of the EC2 instance.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The ID of the EC2 instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the EC2 instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The state of the EC2 instance.</p>
        pub fn instance_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_state = Some(input.into());
            self
        }
        /// <p>The state of the EC2 instance.</p>
        pub fn set_instance_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_state = input;
            self
        }
        /// <p>The type of the EC2 instance.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The type of the EC2 instance.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Outpost. Only applicable to AWS Outposts
        /// instances.</p>
        pub fn outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Outpost. Only applicable to AWS Outposts
        /// instances.</p>
        pub fn set_outpost_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_arn = input;
            self
        }
        /// <p>The launch time of the EC2 instance.</p>
        pub fn launch_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_time = Some(input.into());
            self
        }
        /// <p>The launch time of the EC2 instance.</p>
        pub fn set_launch_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch_time = input;
            self
        }
        /// Appends an item to `network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_network_interfaces`](Self::set_network_interfaces).
        ///
        /// <p>The elastic network interface information of the EC2 instance.</p>
        pub fn network_interfaces(
            mut self,
            input: impl Into<crate::model::NetworkInterface>,
        ) -> Self {
            let mut v = self.network_interfaces.unwrap_or_default();
            v.push(input.into());
            self.network_interfaces = Some(v);
            self
        }
        /// <p>The elastic network interface information of the EC2 instance.</p>
        pub fn set_network_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        ) -> Self {
            self.network_interfaces = input;
            self
        }
        /// <p>The platform of the EC2 instance.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The platform of the EC2 instance.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// Appends an item to `product_codes`.
        ///
        /// To override the contents of this collection use [`set_product_codes`](Self::set_product_codes).
        ///
        /// <p>The product code of the EC2 instance.</p>
        pub fn product_codes(mut self, input: impl Into<crate::model::ProductCode>) -> Self {
            let mut v = self.product_codes.unwrap_or_default();
            v.push(input.into());
            self.product_codes = Some(v);
            self
        }
        /// <p>The product code of the EC2 instance.</p>
        pub fn set_product_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductCode>>,
        ) -> Self {
            self.product_codes = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the EC2 instance.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags of the EC2 instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceDetails`](crate::model::InstanceDetails)
        pub fn build(self) -> crate::model::InstanceDetails {
            crate::model::InstanceDetails {
                availability_zone: self.availability_zone,
                iam_instance_profile: self.iam_instance_profile,
                image_description: self.image_description,
                image_id: self.image_id,
                instance_id: self.instance_id,
                instance_state: self.instance_state,
                instance_type: self.instance_type,
                outpost_arn: self.outpost_arn,
                launch_time: self.launch_time,
                network_interfaces: self.network_interfaces,
                platform: self.platform,
                product_codes: self.product_codes,
                tags: self.tags,
            }
        }
    }
}
impl InstanceDetails {
    /// Creates a new builder-style object to manufacture [`InstanceDetails`](crate::model::InstanceDetails)
    pub fn builder() -> crate::model::instance_details::Builder {
        crate::model::instance_details::Builder::default()
    }
}

/// <p>Contains information about a tag associated with the EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The EC2 instance tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The EC2 instance tag value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The EC2 instance tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The EC2 instance tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The EC2 instance tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The EC2 instance tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Contains information about the product code for the EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductCode {
    /// <p>The product code information.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The product code type.</p>
    pub product_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProductCode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductCode");
        formatter.field("code", &self.code);
        formatter.field("product_type", &self.product_type);
        formatter.finish()
    }
}
/// See [`ProductCode`](crate::model::ProductCode)
pub mod product_code {
    /// A builder for [`ProductCode`](crate::model::ProductCode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) product_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The product code information.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The product code information.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The product code type.</p>
        pub fn product_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_type = Some(input.into());
            self
        }
        /// <p>The product code type.</p>
        pub fn set_product_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductCode`](crate::model::ProductCode)
        pub fn build(self) -> crate::model::ProductCode {
            crate::model::ProductCode {
                code: self.code,
                product_type: self.product_type,
            }
        }
    }
}
impl ProductCode {
    /// Creates a new builder-style object to manufacture [`ProductCode`](crate::model::ProductCode)
    pub fn builder() -> crate::model::product_code::Builder {
        crate::model::product_code::Builder::default()
    }
}

/// <p>Contains information about the elastic network interface of the EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterface {
    /// <p>A list of IPv6 addresses for the EC2 instance.</p>
    pub ipv6_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The private DNS name of the EC2 instance.</p>
    pub private_dns_name: std::option::Option<std::string::String>,
    /// <p>The private IP address of the EC2 instance.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>Other private IP address information of the EC2 instance.</p>
    pub private_ip_addresses:
        std::option::Option<std::vec::Vec<crate::model::PrivateIpAddressDetails>>,
    /// <p>The public DNS name of the EC2 instance.</p>
    pub public_dns_name: std::option::Option<std::string::String>,
    /// <p>The public IP address of the EC2 instance.</p>
    pub public_ip: std::option::Option<std::string::String>,
    /// <p>The security groups associated with the EC2 instance.</p>
    pub security_groups: std::option::Option<std::vec::Vec<crate::model::SecurityGroup>>,
    /// <p>The subnet ID of the EC2 instance.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The VPC ID of the EC2 instance.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterface");
        formatter.field("ipv6_addresses", &self.ipv6_addresses);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("private_dns_name", &self.private_dns_name);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("private_ip_addresses", &self.private_ip_addresses);
        formatter.field("public_dns_name", &self.public_dns_name);
        formatter.field("public_ip", &self.public_ip);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`NetworkInterface`](crate::model::NetworkInterface)
pub mod network_interface {
    /// A builder for [`NetworkInterface`](crate::model::NetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ipv6_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) private_dns_name: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) private_ip_addresses:
            std::option::Option<std::vec::Vec<crate::model::PrivateIpAddressDetails>>,
        pub(crate) public_dns_name: std::option::Option<std::string::String>,
        pub(crate) public_ip: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<crate::model::SecurityGroup>>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ipv6_addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv6_addresses`](Self::set_ipv6_addresses).
        ///
        /// <p>A list of IPv6 addresses for the EC2 instance.</p>
        pub fn ipv6_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ipv6_addresses.unwrap_or_default();
            v.push(input.into());
            self.ipv6_addresses = Some(v);
            self
        }
        /// <p>A list of IPv6 addresses for the EC2 instance.</p>
        pub fn set_ipv6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ipv6_addresses = input;
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The private DNS name of the EC2 instance.</p>
        pub fn private_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_dns_name = Some(input.into());
            self
        }
        /// <p>The private DNS name of the EC2 instance.</p>
        pub fn set_private_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_dns_name = input;
            self
        }
        /// <p>The private IP address of the EC2 instance.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IP address of the EC2 instance.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Appends an item to `private_ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_private_ip_addresses`](Self::set_private_ip_addresses).
        ///
        /// <p>Other private IP address information of the EC2 instance.</p>
        pub fn private_ip_addresses(
            mut self,
            input: impl Into<crate::model::PrivateIpAddressDetails>,
        ) -> Self {
            let mut v = self.private_ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.private_ip_addresses = Some(v);
            self
        }
        /// <p>Other private IP address information of the EC2 instance.</p>
        pub fn set_private_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrivateIpAddressDetails>>,
        ) -> Self {
            self.private_ip_addresses = input;
            self
        }
        /// <p>The public DNS name of the EC2 instance.</p>
        pub fn public_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_dns_name = Some(input.into());
            self
        }
        /// <p>The public DNS name of the EC2 instance.</p>
        pub fn set_public_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_dns_name = input;
            self
        }
        /// <p>The public IP address of the EC2 instance.</p>
        pub fn public_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip = Some(input.into());
            self
        }
        /// <p>The public IP address of the EC2 instance.</p>
        pub fn set_public_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_ip = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups associated with the EC2 instance.</p>
        pub fn security_groups(mut self, input: impl Into<crate::model::SecurityGroup>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups associated with the EC2 instance.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityGroup>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The subnet ID of the EC2 instance.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID of the EC2 instance.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The VPC ID of the EC2 instance.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC ID of the EC2 instance.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterface`](crate::model::NetworkInterface)
        pub fn build(self) -> crate::model::NetworkInterface {
            crate::model::NetworkInterface {
                ipv6_addresses: self.ipv6_addresses,
                network_interface_id: self.network_interface_id,
                private_dns_name: self.private_dns_name,
                private_ip_address: self.private_ip_address,
                private_ip_addresses: self.private_ip_addresses,
                public_dns_name: self.public_dns_name,
                public_ip: self.public_ip,
                security_groups: self.security_groups,
                subnet_id: self.subnet_id,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl NetworkInterface {
    /// Creates a new builder-style object to manufacture [`NetworkInterface`](crate::model::NetworkInterface)
    pub fn builder() -> crate::model::network_interface::Builder {
        crate::model::network_interface::Builder::default()
    }
}

/// <p>Contains information about the security groups associated with the EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroup {
    /// <p>The security group ID of the EC2 instance.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The security group name of the EC2 instance.</p>
    pub group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SecurityGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroup");
        formatter.field("group_id", &self.group_id);
        formatter.field("group_name", &self.group_name);
        formatter.finish()
    }
}
/// See [`SecurityGroup`](crate::model::SecurityGroup)
pub mod security_group {
    /// A builder for [`SecurityGroup`](crate::model::SecurityGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The security group ID of the EC2 instance.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The security group ID of the EC2 instance.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The security group name of the EC2 instance.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The security group name of the EC2 instance.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroup`](crate::model::SecurityGroup)
        pub fn build(self) -> crate::model::SecurityGroup {
            crate::model::SecurityGroup {
                group_id: self.group_id,
                group_name: self.group_name,
            }
        }
    }
}
impl SecurityGroup {
    /// Creates a new builder-style object to manufacture [`SecurityGroup`](crate::model::SecurityGroup)
    pub fn builder() -> crate::model::security_group::Builder {
        crate::model::security_group::Builder::default()
    }
}

/// <p>Contains other private IP address information of the EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrivateIpAddressDetails {
    /// <p>The private DNS name of the EC2 instance.</p>
    pub private_dns_name: std::option::Option<std::string::String>,
    /// <p>The private IP address of the EC2 instance.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PrivateIpAddressDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrivateIpAddressDetails");
        formatter.field("private_dns_name", &self.private_dns_name);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.finish()
    }
}
/// See [`PrivateIpAddressDetails`](crate::model::PrivateIpAddressDetails)
pub mod private_ip_address_details {
    /// A builder for [`PrivateIpAddressDetails`](crate::model::PrivateIpAddressDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) private_dns_name: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The private DNS name of the EC2 instance.</p>
        pub fn private_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_dns_name = Some(input.into());
            self
        }
        /// <p>The private DNS name of the EC2 instance.</p>
        pub fn set_private_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_dns_name = input;
            self
        }
        /// <p>The private IP address of the EC2 instance.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IP address of the EC2 instance.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`PrivateIpAddressDetails`](crate::model::PrivateIpAddressDetails)
        pub fn build(self) -> crate::model::PrivateIpAddressDetails {
            crate::model::PrivateIpAddressDetails {
                private_dns_name: self.private_dns_name,
                private_ip_address: self.private_ip_address,
            }
        }
    }
}
impl PrivateIpAddressDetails {
    /// Creates a new builder-style object to manufacture [`PrivateIpAddressDetails`](crate::model::PrivateIpAddressDetails)
    pub fn builder() -> crate::model::private_ip_address_details::Builder {
        crate::model::private_ip_address_details::Builder::default()
    }
}

/// <p>Contains information about the EC2 instance profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamInstanceProfile {
    /// <p>The profile ARN of the EC2 instance.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The profile ID of the EC2 instance.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IamInstanceProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamInstanceProfile");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`IamInstanceProfile`](crate::model::IamInstanceProfile)
pub mod iam_instance_profile {
    /// A builder for [`IamInstanceProfile`](crate::model::IamInstanceProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The profile ARN of the EC2 instance.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The profile ARN of the EC2 instance.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The profile ID of the EC2 instance.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The profile ID of the EC2 instance.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`IamInstanceProfile`](crate::model::IamInstanceProfile)
        pub fn build(self) -> crate::model::IamInstanceProfile {
            crate::model::IamInstanceProfile {
                arn: self.arn,
                id: self.id,
            }
        }
    }
}
impl IamInstanceProfile {
    /// Creates a new builder-style object to manufacture [`IamInstanceProfile`](crate::model::IamInstanceProfile)
    pub fn builder() -> crate::model::iam_instance_profile::Builder {
        crate::model::iam_instance_profile::Builder::default()
    }
}

/// <p>Contains information on the S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3BucketDetail {
    /// <p>The Amazon Resource Name (ARN) of the S3 bucket.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the S3 bucket.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Describes whether the bucket is a source or destination bucket.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The date and time the bucket was created at.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The owner of the S3 bucket.</p>
    pub owner: std::option::Option<crate::model::Owner>,
    /// <p>All tags attached to the S3 bucket</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Describes the server side encryption method used in the S3 bucket.</p>
    pub default_server_side_encryption:
        std::option::Option<crate::model::DefaultServerSideEncryption>,
    /// <p>Describes the public access policies that apply to the S3 bucket.</p>
    pub public_access: std::option::Option<crate::model::PublicAccess>,
}
impl std::fmt::Debug for S3BucketDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3BucketDetail");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("created_at", &self.created_at);
        formatter.field("owner", &self.owner);
        formatter.field("tags", &self.tags);
        formatter.field(
            "default_server_side_encryption",
            &self.default_server_side_encryption,
        );
        formatter.field("public_access", &self.public_access);
        formatter.finish()
    }
}
/// See [`S3BucketDetail`](crate::model::S3BucketDetail)
pub mod s3_bucket_detail {
    /// A builder for [`S3BucketDetail`](crate::model::S3BucketDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) owner: std::option::Option<crate::model::Owner>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) default_server_side_encryption:
            std::option::Option<crate::model::DefaultServerSideEncryption>,
        pub(crate) public_access: std::option::Option<crate::model::PublicAccess>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the S3 bucket.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 bucket.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Describes whether the bucket is a source or destination bucket.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Describes whether the bucket is a source or destination bucket.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date and time the bucket was created at.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time the bucket was created at.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The owner of the S3 bucket.</p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>The owner of the S3 bucket.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>All tags attached to the S3 bucket</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>All tags attached to the S3 bucket</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Describes the server side encryption method used in the S3 bucket.</p>
        pub fn default_server_side_encryption(
            mut self,
            input: crate::model::DefaultServerSideEncryption,
        ) -> Self {
            self.default_server_side_encryption = Some(input);
            self
        }
        /// <p>Describes the server side encryption method used in the S3 bucket.</p>
        pub fn set_default_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::DefaultServerSideEncryption>,
        ) -> Self {
            self.default_server_side_encryption = input;
            self
        }
        /// <p>Describes the public access policies that apply to the S3 bucket.</p>
        pub fn public_access(mut self, input: crate::model::PublicAccess) -> Self {
            self.public_access = Some(input);
            self
        }
        /// <p>Describes the public access policies that apply to the S3 bucket.</p>
        pub fn set_public_access(
            mut self,
            input: std::option::Option<crate::model::PublicAccess>,
        ) -> Self {
            self.public_access = input;
            self
        }
        /// Consumes the builder and constructs a [`S3BucketDetail`](crate::model::S3BucketDetail)
        pub fn build(self) -> crate::model::S3BucketDetail {
            crate::model::S3BucketDetail {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                created_at: self.created_at,
                owner: self.owner,
                tags: self.tags,
                default_server_side_encryption: self.default_server_side_encryption,
                public_access: self.public_access,
            }
        }
    }
}
impl S3BucketDetail {
    /// Creates a new builder-style object to manufacture [`S3BucketDetail`](crate::model::S3BucketDetail)
    pub fn builder() -> crate::model::s3_bucket_detail::Builder {
        crate::model::s3_bucket_detail::Builder::default()
    }
}

/// <p>Describes the public access policies that apply to the S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicAccess {
    /// <p>Contains information about how permissions are configured for the S3 bucket.</p>
    pub permission_configuration: std::option::Option<crate::model::PermissionConfiguration>,
    /// <p>Describes the effective permission on this bucket after factoring all attached
    /// policies.</p>
    pub effective_permission: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PublicAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicAccess");
        formatter.field("permission_configuration", &self.permission_configuration);
        formatter.field("effective_permission", &self.effective_permission);
        formatter.finish()
    }
}
/// See [`PublicAccess`](crate::model::PublicAccess)
pub mod public_access {
    /// A builder for [`PublicAccess`](crate::model::PublicAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission_configuration:
            std::option::Option<crate::model::PermissionConfiguration>,
        pub(crate) effective_permission: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains information about how permissions are configured for the S3 bucket.</p>
        pub fn permission_configuration(
            mut self,
            input: crate::model::PermissionConfiguration,
        ) -> Self {
            self.permission_configuration = Some(input);
            self
        }
        /// <p>Contains information about how permissions are configured for the S3 bucket.</p>
        pub fn set_permission_configuration(
            mut self,
            input: std::option::Option<crate::model::PermissionConfiguration>,
        ) -> Self {
            self.permission_configuration = input;
            self
        }
        /// <p>Describes the effective permission on this bucket after factoring all attached
        /// policies.</p>
        pub fn effective_permission(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_permission = Some(input.into());
            self
        }
        /// <p>Describes the effective permission on this bucket after factoring all attached
        /// policies.</p>
        pub fn set_effective_permission(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_permission = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicAccess`](crate::model::PublicAccess)
        pub fn build(self) -> crate::model::PublicAccess {
            crate::model::PublicAccess {
                permission_configuration: self.permission_configuration,
                effective_permission: self.effective_permission,
            }
        }
    }
}
impl PublicAccess {
    /// Creates a new builder-style object to manufacture [`PublicAccess`](crate::model::PublicAccess)
    pub fn builder() -> crate::model::public_access::Builder {
        crate::model::public_access::Builder::default()
    }
}

/// <p>Contains information about how permissions are configured for the S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PermissionConfiguration {
    /// <p>Contains information about the bucket level permissions for the S3 bucket.</p>
    pub bucket_level_permissions: std::option::Option<crate::model::BucketLevelPermissions>,
    /// <p>Contains information about the account level permissions on the S3 bucket.</p>
    pub account_level_permissions: std::option::Option<crate::model::AccountLevelPermissions>,
}
impl std::fmt::Debug for PermissionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PermissionConfiguration");
        formatter.field("bucket_level_permissions", &self.bucket_level_permissions);
        formatter.field("account_level_permissions", &self.account_level_permissions);
        formatter.finish()
    }
}
/// See [`PermissionConfiguration`](crate::model::PermissionConfiguration)
pub mod permission_configuration {
    /// A builder for [`PermissionConfiguration`](crate::model::PermissionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_level_permissions:
            std::option::Option<crate::model::BucketLevelPermissions>,
        pub(crate) account_level_permissions:
            std::option::Option<crate::model::AccountLevelPermissions>,
    }
    impl Builder {
        /// <p>Contains information about the bucket level permissions for the S3 bucket.</p>
        pub fn bucket_level_permissions(
            mut self,
            input: crate::model::BucketLevelPermissions,
        ) -> Self {
            self.bucket_level_permissions = Some(input);
            self
        }
        /// <p>Contains information about the bucket level permissions for the S3 bucket.</p>
        pub fn set_bucket_level_permissions(
            mut self,
            input: std::option::Option<crate::model::BucketLevelPermissions>,
        ) -> Self {
            self.bucket_level_permissions = input;
            self
        }
        /// <p>Contains information about the account level permissions on the S3 bucket.</p>
        pub fn account_level_permissions(
            mut self,
            input: crate::model::AccountLevelPermissions,
        ) -> Self {
            self.account_level_permissions = Some(input);
            self
        }
        /// <p>Contains information about the account level permissions on the S3 bucket.</p>
        pub fn set_account_level_permissions(
            mut self,
            input: std::option::Option<crate::model::AccountLevelPermissions>,
        ) -> Self {
            self.account_level_permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`PermissionConfiguration`](crate::model::PermissionConfiguration)
        pub fn build(self) -> crate::model::PermissionConfiguration {
            crate::model::PermissionConfiguration {
                bucket_level_permissions: self.bucket_level_permissions,
                account_level_permissions: self.account_level_permissions,
            }
        }
    }
}
impl PermissionConfiguration {
    /// Creates a new builder-style object to manufacture [`PermissionConfiguration`](crate::model::PermissionConfiguration)
    pub fn builder() -> crate::model::permission_configuration::Builder {
        crate::model::permission_configuration::Builder::default()
    }
}

/// <p>Contains information about the account level permissions on the S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountLevelPermissions {
    /// <p>Describes the S3 Block Public Access settings of the bucket's parent account.</p>
    pub block_public_access: std::option::Option<crate::model::BlockPublicAccess>,
}
impl std::fmt::Debug for AccountLevelPermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountLevelPermissions");
        formatter.field("block_public_access", &self.block_public_access);
        formatter.finish()
    }
}
/// See [`AccountLevelPermissions`](crate::model::AccountLevelPermissions)
pub mod account_level_permissions {
    /// A builder for [`AccountLevelPermissions`](crate::model::AccountLevelPermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_public_access: std::option::Option<crate::model::BlockPublicAccess>,
    }
    impl Builder {
        /// <p>Describes the S3 Block Public Access settings of the bucket's parent account.</p>
        pub fn block_public_access(mut self, input: crate::model::BlockPublicAccess) -> Self {
            self.block_public_access = Some(input);
            self
        }
        /// <p>Describes the S3 Block Public Access settings of the bucket's parent account.</p>
        pub fn set_block_public_access(
            mut self,
            input: std::option::Option<crate::model::BlockPublicAccess>,
        ) -> Self {
            self.block_public_access = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountLevelPermissions`](crate::model::AccountLevelPermissions)
        pub fn build(self) -> crate::model::AccountLevelPermissions {
            crate::model::AccountLevelPermissions {
                block_public_access: self.block_public_access,
            }
        }
    }
}
impl AccountLevelPermissions {
    /// Creates a new builder-style object to manufacture [`AccountLevelPermissions`](crate::model::AccountLevelPermissions)
    pub fn builder() -> crate::model::account_level_permissions::Builder {
        crate::model::account_level_permissions::Builder::default()
    }
}

/// <p>Contains information on how the bucker owner's S3 Block Public Access settings are being
/// applied to the S3 bucket. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">S3 Block Public
/// Access</a> for more information. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlockPublicAccess {
    /// <p>Indicates if S3 Block Public Access is set to <code>IgnorePublicAcls</code>.</p>
    pub ignore_public_acls: bool,
    /// <p>Indicates if S3 Block Public Access is set to <code>RestrictPublicBuckets</code>.</p>
    pub restrict_public_buckets: bool,
    /// <p>Indicates if S3 Block Public Access is set to <code>BlockPublicAcls</code>.</p>
    pub block_public_acls: bool,
    /// <p>Indicates if S3 Block Public Access is set to <code>BlockPublicPolicy</code>.</p>
    pub block_public_policy: bool,
}
impl std::fmt::Debug for BlockPublicAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlockPublicAccess");
        formatter.field("ignore_public_acls", &self.ignore_public_acls);
        formatter.field("restrict_public_buckets", &self.restrict_public_buckets);
        formatter.field("block_public_acls", &self.block_public_acls);
        formatter.field("block_public_policy", &self.block_public_policy);
        formatter.finish()
    }
}
/// See [`BlockPublicAccess`](crate::model::BlockPublicAccess)
pub mod block_public_access {
    /// A builder for [`BlockPublicAccess`](crate::model::BlockPublicAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ignore_public_acls: std::option::Option<bool>,
        pub(crate) restrict_public_buckets: std::option::Option<bool>,
        pub(crate) block_public_acls: std::option::Option<bool>,
        pub(crate) block_public_policy: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates if S3 Block Public Access is set to <code>IgnorePublicAcls</code>.</p>
        pub fn ignore_public_acls(mut self, input: bool) -> Self {
            self.ignore_public_acls = Some(input);
            self
        }
        /// <p>Indicates if S3 Block Public Access is set to <code>IgnorePublicAcls</code>.</p>
        pub fn set_ignore_public_acls(mut self, input: std::option::Option<bool>) -> Self {
            self.ignore_public_acls = input;
            self
        }
        /// <p>Indicates if S3 Block Public Access is set to <code>RestrictPublicBuckets</code>.</p>
        pub fn restrict_public_buckets(mut self, input: bool) -> Self {
            self.restrict_public_buckets = Some(input);
            self
        }
        /// <p>Indicates if S3 Block Public Access is set to <code>RestrictPublicBuckets</code>.</p>
        pub fn set_restrict_public_buckets(mut self, input: std::option::Option<bool>) -> Self {
            self.restrict_public_buckets = input;
            self
        }
        /// <p>Indicates if S3 Block Public Access is set to <code>BlockPublicAcls</code>.</p>
        pub fn block_public_acls(mut self, input: bool) -> Self {
            self.block_public_acls = Some(input);
            self
        }
        /// <p>Indicates if S3 Block Public Access is set to <code>BlockPublicAcls</code>.</p>
        pub fn set_block_public_acls(mut self, input: std::option::Option<bool>) -> Self {
            self.block_public_acls = input;
            self
        }
        /// <p>Indicates if S3 Block Public Access is set to <code>BlockPublicPolicy</code>.</p>
        pub fn block_public_policy(mut self, input: bool) -> Self {
            self.block_public_policy = Some(input);
            self
        }
        /// <p>Indicates if S3 Block Public Access is set to <code>BlockPublicPolicy</code>.</p>
        pub fn set_block_public_policy(mut self, input: std::option::Option<bool>) -> Self {
            self.block_public_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`BlockPublicAccess`](crate::model::BlockPublicAccess)
        pub fn build(self) -> crate::model::BlockPublicAccess {
            crate::model::BlockPublicAccess {
                ignore_public_acls: self.ignore_public_acls.unwrap_or_default(),
                restrict_public_buckets: self.restrict_public_buckets.unwrap_or_default(),
                block_public_acls: self.block_public_acls.unwrap_or_default(),
                block_public_policy: self.block_public_policy.unwrap_or_default(),
            }
        }
    }
}
impl BlockPublicAccess {
    /// Creates a new builder-style object to manufacture [`BlockPublicAccess`](crate::model::BlockPublicAccess)
    pub fn builder() -> crate::model::block_public_access::Builder {
        crate::model::block_public_access::Builder::default()
    }
}

/// <p>Contains information about the bucket level permissions for the S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketLevelPermissions {
    /// <p>Contains information on how Access Control Policies are applied to the bucket.</p>
    pub access_control_list: std::option::Option<crate::model::AccessControlList>,
    /// <p>Contains information on the bucket policies for the S3 bucket.</p>
    pub bucket_policy: std::option::Option<crate::model::BucketPolicy>,
    /// <p>Contains information on which account level S3 Block Public Access settings are applied to
    /// the S3 bucket.</p>
    pub block_public_access: std::option::Option<crate::model::BlockPublicAccess>,
}
impl std::fmt::Debug for BucketLevelPermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketLevelPermissions");
        formatter.field("access_control_list", &self.access_control_list);
        formatter.field("bucket_policy", &self.bucket_policy);
        formatter.field("block_public_access", &self.block_public_access);
        formatter.finish()
    }
}
/// See [`BucketLevelPermissions`](crate::model::BucketLevelPermissions)
pub mod bucket_level_permissions {
    /// A builder for [`BucketLevelPermissions`](crate::model::BucketLevelPermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_control_list: std::option::Option<crate::model::AccessControlList>,
        pub(crate) bucket_policy: std::option::Option<crate::model::BucketPolicy>,
        pub(crate) block_public_access: std::option::Option<crate::model::BlockPublicAccess>,
    }
    impl Builder {
        /// <p>Contains information on how Access Control Policies are applied to the bucket.</p>
        pub fn access_control_list(mut self, input: crate::model::AccessControlList) -> Self {
            self.access_control_list = Some(input);
            self
        }
        /// <p>Contains information on how Access Control Policies are applied to the bucket.</p>
        pub fn set_access_control_list(
            mut self,
            input: std::option::Option<crate::model::AccessControlList>,
        ) -> Self {
            self.access_control_list = input;
            self
        }
        /// <p>Contains information on the bucket policies for the S3 bucket.</p>
        pub fn bucket_policy(mut self, input: crate::model::BucketPolicy) -> Self {
            self.bucket_policy = Some(input);
            self
        }
        /// <p>Contains information on the bucket policies for the S3 bucket.</p>
        pub fn set_bucket_policy(
            mut self,
            input: std::option::Option<crate::model::BucketPolicy>,
        ) -> Self {
            self.bucket_policy = input;
            self
        }
        /// <p>Contains information on which account level S3 Block Public Access settings are applied to
        /// the S3 bucket.</p>
        pub fn block_public_access(mut self, input: crate::model::BlockPublicAccess) -> Self {
            self.block_public_access = Some(input);
            self
        }
        /// <p>Contains information on which account level S3 Block Public Access settings are applied to
        /// the S3 bucket.</p>
        pub fn set_block_public_access(
            mut self,
            input: std::option::Option<crate::model::BlockPublicAccess>,
        ) -> Self {
            self.block_public_access = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketLevelPermissions`](crate::model::BucketLevelPermissions)
        pub fn build(self) -> crate::model::BucketLevelPermissions {
            crate::model::BucketLevelPermissions {
                access_control_list: self.access_control_list,
                bucket_policy: self.bucket_policy,
                block_public_access: self.block_public_access,
            }
        }
    }
}
impl BucketLevelPermissions {
    /// Creates a new builder-style object to manufacture [`BucketLevelPermissions`](crate::model::BucketLevelPermissions)
    pub fn builder() -> crate::model::bucket_level_permissions::Builder {
        crate::model::bucket_level_permissions::Builder::default()
    }
}

/// <p>Contains information on the current bucket policies for the S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketPolicy {
    /// <p>A value that indicates whether public read access for the bucket is enabled through a
    /// bucket policy.</p>
    pub allows_public_read_access: bool,
    /// <p>A value that indicates whether public write access for the bucket is enabled through a
    /// bucket policy.</p>
    pub allows_public_write_access: bool,
}
impl std::fmt::Debug for BucketPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketPolicy");
        formatter.field("allows_public_read_access", &self.allows_public_read_access);
        formatter.field(
            "allows_public_write_access",
            &self.allows_public_write_access,
        );
        formatter.finish()
    }
}
/// See [`BucketPolicy`](crate::model::BucketPolicy)
pub mod bucket_policy {
    /// A builder for [`BucketPolicy`](crate::model::BucketPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allows_public_read_access: std::option::Option<bool>,
        pub(crate) allows_public_write_access: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A value that indicates whether public read access for the bucket is enabled through a
        /// bucket policy.</p>
        pub fn allows_public_read_access(mut self, input: bool) -> Self {
            self.allows_public_read_access = Some(input);
            self
        }
        /// <p>A value that indicates whether public read access for the bucket is enabled through a
        /// bucket policy.</p>
        pub fn set_allows_public_read_access(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_public_read_access = input;
            self
        }
        /// <p>A value that indicates whether public write access for the bucket is enabled through a
        /// bucket policy.</p>
        pub fn allows_public_write_access(mut self, input: bool) -> Self {
            self.allows_public_write_access = Some(input);
            self
        }
        /// <p>A value that indicates whether public write access for the bucket is enabled through a
        /// bucket policy.</p>
        pub fn set_allows_public_write_access(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_public_write_access = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketPolicy`](crate::model::BucketPolicy)
        pub fn build(self) -> crate::model::BucketPolicy {
            crate::model::BucketPolicy {
                allows_public_read_access: self.allows_public_read_access.unwrap_or_default(),
                allows_public_write_access: self.allows_public_write_access.unwrap_or_default(),
            }
        }
    }
}
impl BucketPolicy {
    /// Creates a new builder-style object to manufacture [`BucketPolicy`](crate::model::BucketPolicy)
    pub fn builder() -> crate::model::bucket_policy::Builder {
        crate::model::bucket_policy::Builder::default()
    }
}

/// <p>Contains information on the current access control policies for the bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessControlList {
    /// <p>A value that indicates whether public read access for the bucket is enabled through an
    /// Access Control List (ACL).</p>
    pub allows_public_read_access: bool,
    /// <p>A value that indicates whether public write access for the bucket is enabled through an
    /// Access Control List (ACL).</p>
    pub allows_public_write_access: bool,
}
impl std::fmt::Debug for AccessControlList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessControlList");
        formatter.field("allows_public_read_access", &self.allows_public_read_access);
        formatter.field(
            "allows_public_write_access",
            &self.allows_public_write_access,
        );
        formatter.finish()
    }
}
/// See [`AccessControlList`](crate::model::AccessControlList)
pub mod access_control_list {
    /// A builder for [`AccessControlList`](crate::model::AccessControlList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allows_public_read_access: std::option::Option<bool>,
        pub(crate) allows_public_write_access: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A value that indicates whether public read access for the bucket is enabled through an
        /// Access Control List (ACL).</p>
        pub fn allows_public_read_access(mut self, input: bool) -> Self {
            self.allows_public_read_access = Some(input);
            self
        }
        /// <p>A value that indicates whether public read access for the bucket is enabled through an
        /// Access Control List (ACL).</p>
        pub fn set_allows_public_read_access(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_public_read_access = input;
            self
        }
        /// <p>A value that indicates whether public write access for the bucket is enabled through an
        /// Access Control List (ACL).</p>
        pub fn allows_public_write_access(mut self, input: bool) -> Self {
            self.allows_public_write_access = Some(input);
            self
        }
        /// <p>A value that indicates whether public write access for the bucket is enabled through an
        /// Access Control List (ACL).</p>
        pub fn set_allows_public_write_access(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_public_write_access = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessControlList`](crate::model::AccessControlList)
        pub fn build(self) -> crate::model::AccessControlList {
            crate::model::AccessControlList {
                allows_public_read_access: self.allows_public_read_access.unwrap_or_default(),
                allows_public_write_access: self.allows_public_write_access.unwrap_or_default(),
            }
        }
    }
}
impl AccessControlList {
    /// Creates a new builder-style object to manufacture [`AccessControlList`](crate::model::AccessControlList)
    pub fn builder() -> crate::model::access_control_list::Builder {
        crate::model::access_control_list::Builder::default()
    }
}

/// <p>Contains information on the server side encryption method used in the S3 bucket. See
/// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">S3
/// Server-Side Encryption</a> for more information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultServerSideEncryption {
    /// <p>The type of encryption used for objects within the S3 bucket.</p>
    pub encryption_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the bucket
    /// <code>EncryptionType</code> is <code>aws:kms</code>.</p>
    pub kms_master_key_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DefaultServerSideEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultServerSideEncryption");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("kms_master_key_arn", &self.kms_master_key_arn);
        formatter.finish()
    }
}
/// See [`DefaultServerSideEncryption`](crate::model::DefaultServerSideEncryption)
pub mod default_server_side_encryption {
    /// A builder for [`DefaultServerSideEncryption`](crate::model::DefaultServerSideEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_type: std::option::Option<std::string::String>,
        pub(crate) kms_master_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of encryption used for objects within the S3 bucket.</p>
        pub fn encryption_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_type = Some(input.into());
            self
        }
        /// <p>The type of encryption used for objects within the S3 bucket.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the bucket
        /// <code>EncryptionType</code> is <code>aws:kms</code>.</p>
        pub fn kms_master_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_master_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the bucket
        /// <code>EncryptionType</code> is <code>aws:kms</code>.</p>
        pub fn set_kms_master_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_master_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultServerSideEncryption`](crate::model::DefaultServerSideEncryption)
        pub fn build(self) -> crate::model::DefaultServerSideEncryption {
            crate::model::DefaultServerSideEncryption {
                encryption_type: self.encryption_type,
                kms_master_key_arn: self.kms_master_key_arn,
            }
        }
    }
}
impl DefaultServerSideEncryption {
    /// Creates a new builder-style object to manufacture [`DefaultServerSideEncryption`](crate::model::DefaultServerSideEncryption)
    pub fn builder() -> crate::model::default_server_side_encryption::Builder {
        crate::model::default_server_side_encryption::Builder::default()
    }
}

/// <p>Contains information on the owner of the bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Owner {
    /// <p>The canonical user ID of the bucket owner. For information about locating your canonical
    /// user ID see <a href="https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId">Finding Your Account
    /// Canonical User ID.</a>
    /// </p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Owner {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Owner");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`Owner`](crate::model::Owner)
pub mod owner {
    /// A builder for [`Owner`](crate::model::Owner)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canonical user ID of the bucket owner. For information about locating your canonical
        /// user ID see <a href="https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId">Finding Your Account
        /// Canonical User ID.</a>
        /// </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The canonical user ID of the bucket owner. For information about locating your canonical
        /// user ID see <a href="https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId">Finding Your Account
        /// Canonical User ID.</a>
        /// </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`Owner`](crate::model::Owner)
        pub fn build(self) -> crate::model::Owner {
            crate::model::Owner { id: self.id }
        }
    }
}
impl Owner {
    /// Creates a new builder-style object to manufacture [`Owner`](crate::model::Owner)
    pub fn builder() -> crate::model::owner::Builder {
        crate::model::owner::Builder::default()
    }
}

/// <p>Contains information about the access keys.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessKeyDetails {
    /// <p>The access key ID of the user.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The principal ID of the user.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The name of the user.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The type of the user.</p>
    pub user_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessKeyDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessKeyDetails");
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("user_name", &self.user_name);
        formatter.field("user_type", &self.user_type);
        formatter.finish()
    }
}
/// See [`AccessKeyDetails`](crate::model::AccessKeyDetails)
pub mod access_key_details {
    /// A builder for [`AccessKeyDetails`](crate::model::AccessKeyDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) user_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access key ID of the user.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The access key ID of the user.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The principal ID of the user.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The principal ID of the user.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The name of the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The type of the user.</p>
        pub fn user_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_type = Some(input.into());
            self
        }
        /// <p>The type of the user.</p>
        pub fn set_user_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessKeyDetails`](crate::model::AccessKeyDetails)
        pub fn build(self) -> crate::model::AccessKeyDetails {
            crate::model::AccessKeyDetails {
                access_key_id: self.access_key_id,
                principal_id: self.principal_id,
                user_name: self.user_name,
                user_type: self.user_type,
            }
        }
    }
}
impl AccessKeyDetails {
    /// Creates a new builder-style object to manufacture [`AccessKeyDetails`](crate::model::AccessKeyDetails)
    pub fn builder() -> crate::model::access_key_details::Builder {
        crate::model::access_key_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DetectorStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DetectorStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => DetectorStatus::Disabled,
            "ENABLED" => DetectorStatus::Enabled,
            other => DetectorStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DetectorStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DetectorStatus::from(s))
    }
}
impl DetectorStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DetectorStatus::Disabled => "DISABLED",
            DetectorStatus::Enabled => "ENABLED",
            DetectorStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for DetectorStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains information on which data sources are automatically enabled for
/// new members within the organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationDataSourceConfigurationsResult {
    /// <p>Describes whether S3 data event logs are enabled as a data source.</p>
    pub s3_logs: std::option::Option<crate::model::OrganizationS3LogsConfigurationResult>,
}
impl std::fmt::Debug for OrganizationDataSourceConfigurationsResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationDataSourceConfigurationsResult");
        formatter.field("s3_logs", &self.s3_logs);
        formatter.finish()
    }
}
/// See [`OrganizationDataSourceConfigurationsResult`](crate::model::OrganizationDataSourceConfigurationsResult)
pub mod organization_data_source_configurations_result {
    /// A builder for [`OrganizationDataSourceConfigurationsResult`](crate::model::OrganizationDataSourceConfigurationsResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_logs:
            std::option::Option<crate::model::OrganizationS3LogsConfigurationResult>,
    }
    impl Builder {
        /// <p>Describes whether S3 data event logs are enabled as a data source.</p>
        pub fn s3_logs(
            mut self,
            input: crate::model::OrganizationS3LogsConfigurationResult,
        ) -> Self {
            self.s3_logs = Some(input);
            self
        }
        /// <p>Describes whether S3 data event logs are enabled as a data source.</p>
        pub fn set_s3_logs(
            mut self,
            input: std::option::Option<crate::model::OrganizationS3LogsConfigurationResult>,
        ) -> Self {
            self.s3_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationDataSourceConfigurationsResult`](crate::model::OrganizationDataSourceConfigurationsResult)
        pub fn build(self) -> crate::model::OrganizationDataSourceConfigurationsResult {
            crate::model::OrganizationDataSourceConfigurationsResult {
                s3_logs: self.s3_logs,
            }
        }
    }
}
impl OrganizationDataSourceConfigurationsResult {
    /// Creates a new builder-style object to manufacture [`OrganizationDataSourceConfigurationsResult`](crate::model::OrganizationDataSourceConfigurationsResult)
    pub fn builder() -> crate::model::organization_data_source_configurations_result::Builder {
        crate::model::organization_data_source_configurations_result::Builder::default()
    }
}

/// <p>The current configuration of S3 data event logs as a data source for the
/// organization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationS3LogsConfigurationResult {
    /// <p>A value that describes whether S3 data event logs are automatically enabled for new
    /// members of the organization.</p>
    pub auto_enable: bool,
}
impl std::fmt::Debug for OrganizationS3LogsConfigurationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationS3LogsConfigurationResult");
        formatter.field("auto_enable", &self.auto_enable);
        formatter.finish()
    }
}
/// See [`OrganizationS3LogsConfigurationResult`](crate::model::OrganizationS3LogsConfigurationResult)
pub mod organization_s3_logs_configuration_result {
    /// A builder for [`OrganizationS3LogsConfigurationResult`](crate::model::OrganizationS3LogsConfigurationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_enable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A value that describes whether S3 data event logs are automatically enabled for new
        /// members of the organization.</p>
        pub fn auto_enable(mut self, input: bool) -> Self {
            self.auto_enable = Some(input);
            self
        }
        /// <p>A value that describes whether S3 data event logs are automatically enabled for new
        /// members of the organization.</p>
        pub fn set_auto_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_enable = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationS3LogsConfigurationResult`](crate::model::OrganizationS3LogsConfigurationResult)
        pub fn build(self) -> crate::model::OrganizationS3LogsConfigurationResult {
            crate::model::OrganizationS3LogsConfigurationResult {
                auto_enable: self.auto_enable.unwrap_or_default(),
            }
        }
    }
}
impl OrganizationS3LogsConfigurationResult {
    /// Creates a new builder-style object to manufacture [`OrganizationS3LogsConfigurationResult`](crate::model::OrganizationS3LogsConfigurationResult)
    pub fn builder() -> crate::model::organization_s3_logs_configuration_result::Builder {
        crate::model::organization_s3_logs_configuration_result::Builder::default()
    }
}

/// <p>Contains information about the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountDetail {
    /// <p>The member account ID.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The email address of the member account.</p>
    pub email: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountDetail");
        formatter.field("account_id", &self.account_id);
        formatter.field("email", &self.email);
        formatter.finish()
    }
}
/// See [`AccountDetail`](crate::model::AccountDetail)
pub mod account_detail {
    /// A builder for [`AccountDetail`](crate::model::AccountDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The member account ID.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The member account ID.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The email address of the member account.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the member account.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountDetail`](crate::model::AccountDetail)
        pub fn build(self) -> crate::model::AccountDetail {
            crate::model::AccountDetail {
                account_id: self.account_id,
                email: self.email,
            }
        }
    }
}
impl AccountDetail {
    /// Creates a new builder-style object to manufacture [`AccountDetail`](crate::model::AccountDetail)
    pub fn builder() -> crate::model::account_detail::Builder {
        crate::model::account_detail::Builder::default()
    }
}
