// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptInvitationError {
    /// Kind of error that occurred.
    pub kind: AcceptInvitationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptInvitationErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptInvitationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptInvitationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            AcceptInvitationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            AcceptInvitationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptInvitationError {
    fn code(&self) -> Option<&str> {
        AcceptInvitationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptInvitationError {
    /// Creates a new `AcceptInvitationError`.
    pub fn new(kind: AcceptInvitationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptInvitationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptInvitationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptInvitationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptInvitationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptInvitationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInvitationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInvitationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInvitationErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for AcceptInvitationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptInvitationErrorKind::BadRequestException(_inner) => Some(_inner),
            AcceptInvitationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            AcceptInvitationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ArchiveFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ArchiveFindingsError {
    /// Kind of error that occurred.
    pub kind: ArchiveFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ArchiveFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ArchiveFindingsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ArchiveFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ArchiveFindingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ArchiveFindingsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ArchiveFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ArchiveFindingsError {
    fn code(&self) -> Option<&str> {
        ArchiveFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ArchiveFindingsError {
    /// Creates a new `ArchiveFindingsError`.
    pub fn new(kind: ArchiveFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ArchiveFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ArchiveFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ArchiveFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ArchiveFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ArchiveFindingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ArchiveFindingsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ArchiveFindingsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ArchiveFindingsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ArchiveFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ArchiveFindingsErrorKind::BadRequestException(_inner) => Some(_inner),
            ArchiveFindingsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ArchiveFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDetectorError {
    /// Kind of error that occurred.
    pub kind: CreateDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDetectorErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDetectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDetectorErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDetectorError {
    fn code(&self) -> Option<&str> {
        CreateDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDetectorError {
    /// Creates a new `CreateDetectorError`.
    pub fn new(kind: CreateDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDetectorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDetectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateDetectorErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateDetectorErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDetectorErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for CreateDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDetectorErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDetectorErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFilterError {
    /// Kind of error that occurred.
    pub kind: CreateFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFilterErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFilterErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFilterError {
    fn code(&self) -> Option<&str> {
        CreateFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFilterError {
    /// Creates a new `CreateFilterError`.
    pub fn new(kind: CreateFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateFilterErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateFilterErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFilterErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for CreateFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFilterErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateFilterErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIPSetError {
    /// Kind of error that occurred.
    pub kind: CreateIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIPSetErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIPSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIPSetError {
    fn code(&self) -> Option<&str> {
        CreateIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIPSetError {
    /// Creates a new `CreateIPSetError`.
    pub fn new(kind: CreateIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIPSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateIPSetErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateIPSetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIPSetErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for CreateIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIPSetErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateIPSetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMembersError {
    /// Kind of error that occurred.
    pub kind: CreateMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMembersErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMembersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMembersError {
    fn code(&self) -> Option<&str> {
        CreateMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMembersError {
    /// Creates a new `CreateMembersError`.
    pub fn new(kind: CreateMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMembersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateMembersErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMembersErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for CreateMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMembersErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePublishingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePublishingDestinationError {
    /// Kind of error that occurred.
    pub kind: CreatePublishingDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePublishingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePublishingDestinationErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePublishingDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePublishingDestinationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreatePublishingDestinationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreatePublishingDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePublishingDestinationError {
    fn code(&self) -> Option<&str> {
        CreatePublishingDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePublishingDestinationError {
    /// Creates a new `CreatePublishingDestinationError`.
    pub fn new(kind: CreatePublishingDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePublishingDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePublishingDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePublishingDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePublishingDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePublishingDestinationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublishingDestinationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePublishingDestinationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePublishingDestinationErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for CreatePublishingDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePublishingDestinationErrorKind::BadRequestException(_inner) => Some(_inner),
            CreatePublishingDestinationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            CreatePublishingDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSampleFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSampleFindingsError {
    /// Kind of error that occurred.
    pub kind: CreateSampleFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSampleFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSampleFindingsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSampleFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSampleFindingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateSampleFindingsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateSampleFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSampleFindingsError {
    fn code(&self) -> Option<&str> {
        CreateSampleFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSampleFindingsError {
    /// Creates a new `CreateSampleFindingsError`.
    pub fn new(kind: CreateSampleFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSampleFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSampleFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSampleFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSampleFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSampleFindingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSampleFindingsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSampleFindingsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSampleFindingsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for CreateSampleFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSampleFindingsErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateSampleFindingsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateSampleFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateThreatIntelSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateThreatIntelSetError {
    /// Kind of error that occurred.
    pub kind: CreateThreatIntelSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateThreatIntelSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateThreatIntelSetErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateThreatIntelSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateThreatIntelSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateThreatIntelSetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateThreatIntelSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateThreatIntelSetError {
    fn code(&self) -> Option<&str> {
        CreateThreatIntelSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateThreatIntelSetError {
    /// Creates a new `CreateThreatIntelSetError`.
    pub fn new(kind: CreateThreatIntelSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateThreatIntelSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateThreatIntelSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateThreatIntelSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateThreatIntelSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateThreatIntelSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThreatIntelSetErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateThreatIntelSetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateThreatIntelSetErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for CreateThreatIntelSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateThreatIntelSetErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateThreatIntelSetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateThreatIntelSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeclineInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeclineInvitationsError {
    /// Kind of error that occurred.
    pub kind: DeclineInvitationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeclineInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeclineInvitationsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeclineInvitationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeclineInvitationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeclineInvitationsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeclineInvitationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeclineInvitationsError {
    fn code(&self) -> Option<&str> {
        DeclineInvitationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeclineInvitationsError {
    /// Creates a new `DeclineInvitationsError`.
    pub fn new(kind: DeclineInvitationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeclineInvitationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeclineInvitationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeclineInvitationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeclineInvitationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeclineInvitationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineInvitationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineInvitationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineInvitationsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DeclineInvitationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeclineInvitationsErrorKind::BadRequestException(_inner) => Some(_inner),
            DeclineInvitationsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeclineInvitationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDetectorError {
    /// Kind of error that occurred.
    pub kind: DeleteDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDetectorErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDetectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDetectorErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDetectorError {
    fn code(&self) -> Option<&str> {
        DeleteDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDetectorError {
    /// Creates a new `DeleteDetectorError`.
    pub fn new(kind: DeleteDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDetectorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDetectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteDetectorErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteDetectorErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDetectorErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DeleteDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDetectorErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDetectorErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFilterError {
    /// Kind of error that occurred.
    pub kind: DeleteFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFilterErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFilterErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteFilterErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFilterError {
    fn code(&self) -> Option<&str> {
        DeleteFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFilterError {
    /// Creates a new `DeleteFilterError`.
    pub fn new(kind: DeleteFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFilterErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteFilterErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteFilterErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFilterErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DeleteFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFilterErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteFilterErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInvitationsError {
    /// Kind of error that occurred.
    pub kind: DeleteInvitationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInvitationsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInvitationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInvitationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteInvitationsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteInvitationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInvitationsError {
    fn code(&self) -> Option<&str> {
        DeleteInvitationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInvitationsError {
    /// Creates a new `DeleteInvitationsError`.
    pub fn new(kind: DeleteInvitationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInvitationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInvitationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInvitationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInvitationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInvitationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInvitationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInvitationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInvitationsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DeleteInvitationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInvitationsErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteInvitationsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteInvitationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIPSetError {
    /// Kind of error that occurred.
    pub kind: DeleteIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIPSetErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIPSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIPSetError {
    fn code(&self) -> Option<&str> {
        DeleteIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIPSetError {
    /// Creates a new `DeleteIPSetError`.
    pub fn new(kind: DeleteIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIPSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteIPSetErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteIPSetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIPSetErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DeleteIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIPSetErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMembersError {
    /// Kind of error that occurred.
    pub kind: DeleteMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMembersErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMembersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMembersError {
    fn code(&self) -> Option<&str> {
        DeleteMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMembersError {
    /// Creates a new `DeleteMembersError`.
    pub fn new(kind: DeleteMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMembersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteMembersErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMembersErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DeleteMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMembersErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePublishingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePublishingDestinationError {
    /// Kind of error that occurred.
    pub kind: DeletePublishingDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePublishingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePublishingDestinationErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePublishingDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePublishingDestinationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeletePublishingDestinationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeletePublishingDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePublishingDestinationError {
    fn code(&self) -> Option<&str> {
        DeletePublishingDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePublishingDestinationError {
    /// Creates a new `DeletePublishingDestinationError`.
    pub fn new(kind: DeletePublishingDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePublishingDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePublishingDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePublishingDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePublishingDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePublishingDestinationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePublishingDestinationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePublishingDestinationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePublishingDestinationErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DeletePublishingDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePublishingDestinationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeletePublishingDestinationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DeletePublishingDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteThreatIntelSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteThreatIntelSetError {
    /// Kind of error that occurred.
    pub kind: DeleteThreatIntelSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteThreatIntelSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteThreatIntelSetErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteThreatIntelSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteThreatIntelSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteThreatIntelSetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteThreatIntelSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteThreatIntelSetError {
    fn code(&self) -> Option<&str> {
        DeleteThreatIntelSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteThreatIntelSetError {
    /// Creates a new `DeleteThreatIntelSetError`.
    pub fn new(kind: DeleteThreatIntelSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteThreatIntelSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteThreatIntelSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteThreatIntelSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteThreatIntelSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteThreatIntelSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThreatIntelSetErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteThreatIntelSetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteThreatIntelSetErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DeleteThreatIntelSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteThreatIntelSetErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteThreatIntelSetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteThreatIntelSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrganizationConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeOrganizationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrganizationConfigurationErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrganizationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrganizationConfigurationErrorKind::BadRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrganizationConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeOrganizationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrganizationConfigurationError {
    /// Creates a new `DescribeOrganizationConfigurationError`.
    pub fn new(
        kind: DescribeOrganizationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrganizationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrganizationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrganizationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrganizationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DescribeOrganizationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrganizationConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeOrganizationConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePublishingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePublishingDestinationError {
    /// Kind of error that occurred.
    pub kind: DescribePublishingDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePublishingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePublishingDestinationErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePublishingDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePublishingDestinationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribePublishingDestinationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribePublishingDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePublishingDestinationError {
    fn code(&self) -> Option<&str> {
        DescribePublishingDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePublishingDestinationError {
    /// Creates a new `DescribePublishingDestinationError`.
    pub fn new(
        kind: DescribePublishingDestinationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePublishingDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePublishingDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePublishingDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePublishingDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePublishingDestinationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePublishingDestinationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePublishingDestinationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePublishingDestinationErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DescribePublishingDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePublishingDestinationErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribePublishingDestinationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DescribePublishingDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableOrganizationAdminAccountError {
    /// Kind of error that occurred.
    pub kind: DisableOrganizationAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableOrganizationAdminAccountErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableOrganizationAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableOrganizationAdminAccountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DisableOrganizationAdminAccountErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DisableOrganizationAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableOrganizationAdminAccountError {
    fn code(&self) -> Option<&str> {
        DisableOrganizationAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableOrganizationAdminAccountError {
    /// Creates a new `DisableOrganizationAdminAccountError`.
    pub fn new(
        kind: DisableOrganizationAdminAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableOrganizationAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableOrganizationAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableOrganizationAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableOrganizationAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableOrganizationAdminAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableOrganizationAdminAccountErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableOrganizationAdminAccountErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableOrganizationAdminAccountErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DisableOrganizationAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableOrganizationAdminAccountErrorKind::BadRequestException(_inner) => Some(_inner),
            DisableOrganizationAdminAccountErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DisableOrganizationAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateFromMasterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateFromMasterAccountError {
    /// Kind of error that occurred.
    pub kind: DisassociateFromMasterAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateFromMasterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateFromMasterAccountErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateFromMasterAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateFromMasterAccountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DisassociateFromMasterAccountErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFromMasterAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateFromMasterAccountError {
    fn code(&self) -> Option<&str> {
        DisassociateFromMasterAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateFromMasterAccountError {
    /// Creates a new `DisassociateFromMasterAccountError`.
    pub fn new(
        kind: DisassociateFromMasterAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateFromMasterAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateFromMasterAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateFromMasterAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateFromMasterAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateFromMasterAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromMasterAccountErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromMasterAccountErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromMasterAccountErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DisassociateFromMasterAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateFromMasterAccountErrorKind::BadRequestException(_inner) => Some(_inner),
            DisassociateFromMasterAccountErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            DisassociateFromMasterAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateMembersError {
    /// Kind of error that occurred.
    pub kind: DisassociateMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateMembersErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateMembersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DisassociateMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DisassociateMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateMembersError {
    fn code(&self) -> Option<&str> {
        DisassociateMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateMembersError {
    /// Creates a new `DisassociateMembersError`.
    pub fn new(kind: DisassociateMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateMembersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMembersErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMembersErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for DisassociateMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateMembersErrorKind::BadRequestException(_inner) => Some(_inner),
            DisassociateMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DisassociateMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableOrganizationAdminAccountError {
    /// Kind of error that occurred.
    pub kind: EnableOrganizationAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableOrganizationAdminAccountErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableOrganizationAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableOrganizationAdminAccountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            EnableOrganizationAdminAccountErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            EnableOrganizationAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableOrganizationAdminAccountError {
    fn code(&self) -> Option<&str> {
        EnableOrganizationAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableOrganizationAdminAccountError {
    /// Creates a new `EnableOrganizationAdminAccountError`.
    pub fn new(
        kind: EnableOrganizationAdminAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableOrganizationAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableOrganizationAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableOrganizationAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableOrganizationAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableOrganizationAdminAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableOrganizationAdminAccountErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableOrganizationAdminAccountErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableOrganizationAdminAccountErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for EnableOrganizationAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableOrganizationAdminAccountErrorKind::BadRequestException(_inner) => Some(_inner),
            EnableOrganizationAdminAccountErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            EnableOrganizationAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDetectorError {
    /// Kind of error that occurred.
    pub kind: GetDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDetectorErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDetectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDetectorErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDetectorError {
    fn code(&self) -> Option<&str> {
        GetDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDetectorError {
    /// Creates a new `GetDetectorError`.
    pub fn new(kind: GetDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDetectorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDetectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDetectorErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetDetectorErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDetectorErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDetectorErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDetectorErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFilterError {
    /// Kind of error that occurred.
    pub kind: GetFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFilterErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFilterErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetFilterErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFilterError {
    fn code(&self) -> Option<&str> {
        GetFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFilterError {
    /// Creates a new `GetFilterError`.
    pub fn new(kind: GetFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFilterErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetFilterErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetFilterErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFilterErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFilterErrorKind::BadRequestException(_inner) => Some(_inner),
            GetFilterErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFindingsError {
    /// Kind of error that occurred.
    pub kind: GetFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFindingsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFindingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetFindingsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFindingsError {
    fn code(&self) -> Option<&str> {
        GetFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFindingsError {
    /// Creates a new `GetFindingsError`.
    pub fn new(kind: GetFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFindingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetFindingsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetFindingsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFindingsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetFindingsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFindingsStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFindingsStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetFindingsStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFindingsStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFindingsStatisticsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFindingsStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFindingsStatisticsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetFindingsStatisticsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetFindingsStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFindingsStatisticsError {
    fn code(&self) -> Option<&str> {
        GetFindingsStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFindingsStatisticsError {
    /// Creates a new `GetFindingsStatisticsError`.
    pub fn new(kind: GetFindingsStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFindingsStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFindingsStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFindingsStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFindingsStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFindingsStatisticsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsStatisticsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsStatisticsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsStatisticsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetFindingsStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFindingsStatisticsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetFindingsStatisticsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetFindingsStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInvitationsCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInvitationsCountError {
    /// Kind of error that occurred.
    pub kind: GetInvitationsCountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInvitationsCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInvitationsCountErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInvitationsCountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInvitationsCountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetInvitationsCountErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetInvitationsCountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInvitationsCountError {
    fn code(&self) -> Option<&str> {
        GetInvitationsCountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInvitationsCountError {
    /// Creates a new `GetInvitationsCountError`.
    pub fn new(kind: GetInvitationsCountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInvitationsCountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInvitationsCountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInvitationsCountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInvitationsCountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInvitationsCountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInvitationsCountErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInvitationsCountErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInvitationsCountErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetInvitationsCountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInvitationsCountErrorKind::BadRequestException(_inner) => Some(_inner),
            GetInvitationsCountErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetInvitationsCountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIPSetError {
    /// Kind of error that occurred.
    pub kind: GetIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIPSetErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIPSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetIPSetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIPSetError {
    fn code(&self) -> Option<&str> {
        GetIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIPSetError {
    /// Creates a new `GetIPSetError`.
    pub fn new(kind: GetIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIPSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetIPSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetIPSetErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetIPSetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIPSetErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIPSetErrorKind::BadRequestException(_inner) => Some(_inner),
            GetIPSetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMasterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMasterAccountError {
    /// Kind of error that occurred.
    pub kind: GetMasterAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMasterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMasterAccountErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMasterAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMasterAccountErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetMasterAccountErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetMasterAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMasterAccountError {
    fn code(&self) -> Option<&str> {
        GetMasterAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMasterAccountError {
    /// Creates a new `GetMasterAccountError`.
    pub fn new(kind: GetMasterAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMasterAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMasterAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMasterAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMasterAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMasterAccountErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMasterAccountErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMasterAccountErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMasterAccountErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetMasterAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMasterAccountErrorKind::BadRequestException(_inner) => Some(_inner),
            GetMasterAccountErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetMasterAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMemberDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMemberDetectorsError {
    /// Kind of error that occurred.
    pub kind: GetMemberDetectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMemberDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMemberDetectorsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMemberDetectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMemberDetectorsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetMemberDetectorsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetMemberDetectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMemberDetectorsError {
    fn code(&self) -> Option<&str> {
        GetMemberDetectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMemberDetectorsError {
    /// Creates a new `GetMemberDetectorsError`.
    pub fn new(kind: GetMemberDetectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMemberDetectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMemberDetectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMemberDetectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMemberDetectorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMemberDetectorsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMemberDetectorsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMemberDetectorsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMemberDetectorsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetMemberDetectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMemberDetectorsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetMemberDetectorsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetMemberDetectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMembersError {
    /// Kind of error that occurred.
    pub kind: GetMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMembersErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMembersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMembersError {
    fn code(&self) -> Option<&str> {
        GetMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMembersError {
    /// Creates a new `GetMembersError`.
    pub fn new(kind: GetMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMembersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetMembersErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMembersErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMembersErrorKind::BadRequestException(_inner) => Some(_inner),
            GetMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetThreatIntelSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetThreatIntelSetError {
    /// Kind of error that occurred.
    pub kind: GetThreatIntelSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetThreatIntelSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetThreatIntelSetErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetThreatIntelSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetThreatIntelSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetThreatIntelSetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetThreatIntelSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetThreatIntelSetError {
    fn code(&self) -> Option<&str> {
        GetThreatIntelSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetThreatIntelSetError {
    /// Creates a new `GetThreatIntelSetError`.
    pub fn new(kind: GetThreatIntelSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetThreatIntelSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetThreatIntelSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetThreatIntelSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetThreatIntelSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetThreatIntelSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThreatIntelSetErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetThreatIntelSetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetThreatIntelSetErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetThreatIntelSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetThreatIntelSetErrorKind::BadRequestException(_inner) => Some(_inner),
            GetThreatIntelSetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetThreatIntelSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUsageStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUsageStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetUsageStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUsageStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUsageStatisticsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUsageStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUsageStatisticsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetUsageStatisticsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetUsageStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUsageStatisticsError {
    fn code(&self) -> Option<&str> {
        GetUsageStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUsageStatisticsError {
    /// Creates a new `GetUsageStatisticsError`.
    pub fn new(kind: GetUsageStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUsageStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUsageStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUsageStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUsageStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUsageStatisticsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageStatisticsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageStatisticsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageStatisticsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for GetUsageStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUsageStatisticsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetUsageStatisticsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetUsageStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InviteMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InviteMembersError {
    /// Kind of error that occurred.
    pub kind: InviteMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InviteMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InviteMembersErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InviteMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InviteMembersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            InviteMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            InviteMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InviteMembersError {
    fn code(&self) -> Option<&str> {
        InviteMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InviteMembersError {
    /// Creates a new `InviteMembersError`.
    pub fn new(kind: InviteMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InviteMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InviteMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InviteMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InviteMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InviteMembersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, InviteMembersErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `InviteMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            InviteMembersErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for InviteMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InviteMembersErrorKind::BadRequestException(_inner) => Some(_inner),
            InviteMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            InviteMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDetectorsError {
    /// Kind of error that occurred.
    pub kind: ListDetectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDetectorsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDetectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDetectorsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListDetectorsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListDetectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDetectorsError {
    fn code(&self) -> Option<&str> {
        ListDetectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDetectorsError {
    /// Creates a new `ListDetectorsError`.
    pub fn new(kind: ListDetectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDetectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDetectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDetectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDetectorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDetectorsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListDetectorsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListDetectorsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDetectorsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListDetectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDetectorsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListDetectorsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListDetectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFiltersError {
    /// Kind of error that occurred.
    pub kind: ListFiltersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFiltersErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFiltersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFiltersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListFiltersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListFiltersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFiltersError {
    fn code(&self) -> Option<&str> {
        ListFiltersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFiltersError {
    /// Creates a new `ListFiltersError`.
    pub fn new(kind: ListFiltersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFiltersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFiltersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFiltersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFiltersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFiltersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListFiltersErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListFiltersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFiltersErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListFiltersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFiltersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListFiltersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListFiltersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFindingsError {
    /// Kind of error that occurred.
    pub kind: ListFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFindingsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFindingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFindingsError {
    fn code(&self) -> Option<&str> {
        ListFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFindingsError {
    /// Creates a new `ListFindingsError`.
    pub fn new(kind: ListFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFindingsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListFindingsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInvitationsError {
    /// Kind of error that occurred.
    pub kind: ListInvitationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInvitationsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInvitationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInvitationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInvitationsError {
    fn code(&self) -> Option<&str> {
        ListInvitationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInvitationsError {
    /// Creates a new `ListInvitationsError`.
    pub fn new(kind: ListInvitationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInvitationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInvitationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInvitationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInvitationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListInvitationsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInvitationsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListInvitationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInvitationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListInvitationsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListInvitationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIPSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIPSetsError {
    /// Kind of error that occurred.
    pub kind: ListIPSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIPSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIPSetsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIPSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIPSetsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListIPSetsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListIPSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIPSetsError {
    fn code(&self) -> Option<&str> {
        ListIPSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIPSetsError {
    /// Creates a new `ListIPSetsError`.
    pub fn new(kind: ListIPSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIPSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIPSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIPSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIPSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIPSetsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListIPSetsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListIPSetsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIPSetsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListIPSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIPSetsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListIPSetsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListIPSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMembersError {
    /// Kind of error that occurred.
    pub kind: ListMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMembersErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMembersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMembersError {
    fn code(&self) -> Option<&str> {
        ListMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMembersError {
    /// Creates a new `ListMembersError`.
    pub fn new(kind: ListMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMembersErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMembersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOrganizationAdminAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOrganizationAdminAccountsError {
    /// Kind of error that occurred.
    pub kind: ListOrganizationAdminAccountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOrganizationAdminAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOrganizationAdminAccountsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOrganizationAdminAccountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOrganizationAdminAccountsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListOrganizationAdminAccountsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationAdminAccountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOrganizationAdminAccountsError {
    fn code(&self) -> Option<&str> {
        ListOrganizationAdminAccountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOrganizationAdminAccountsError {
    /// Creates a new `ListOrganizationAdminAccountsError`.
    pub fn new(
        kind: ListOrganizationAdminAccountsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOrganizationAdminAccountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOrganizationAdminAccountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOrganizationAdminAccountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOrganizationAdminAccountsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOrganizationAdminAccountsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationAdminAccountsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationAdminAccountsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationAdminAccountsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListOrganizationAdminAccountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOrganizationAdminAccountsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListOrganizationAdminAccountsErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            ListOrganizationAdminAccountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPublishingDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPublishingDestinationsError {
    /// Kind of error that occurred.
    pub kind: ListPublishingDestinationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPublishingDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPublishingDestinationsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPublishingDestinationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPublishingDestinationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListPublishingDestinationsErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListPublishingDestinationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPublishingDestinationsError {
    fn code(&self) -> Option<&str> {
        ListPublishingDestinationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPublishingDestinationsError {
    /// Creates a new `ListPublishingDestinationsError`.
    pub fn new(kind: ListPublishingDestinationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPublishingDestinationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPublishingDestinationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPublishingDestinationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPublishingDestinationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPublishingDestinationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublishingDestinationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPublishingDestinationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPublishingDestinationsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListPublishingDestinationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPublishingDestinationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListPublishingDestinationsErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            ListPublishingDestinationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListThreatIntelSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListThreatIntelSetsError {
    /// Kind of error that occurred.
    pub kind: ListThreatIntelSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListThreatIntelSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListThreatIntelSetsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListThreatIntelSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListThreatIntelSetsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListThreatIntelSetsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListThreatIntelSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListThreatIntelSetsError {
    fn code(&self) -> Option<&str> {
        ListThreatIntelSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListThreatIntelSetsError {
    /// Creates a new `ListThreatIntelSetsError`.
    pub fn new(kind: ListThreatIntelSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListThreatIntelSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListThreatIntelSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListThreatIntelSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListThreatIntelSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListThreatIntelSetsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThreatIntelSetsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListThreatIntelSetsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListThreatIntelSetsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for ListThreatIntelSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListThreatIntelSetsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListThreatIntelSetsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListThreatIntelSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMonitoringMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMonitoringMembersError {
    /// Kind of error that occurred.
    pub kind: StartMonitoringMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMonitoringMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMonitoringMembersErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMonitoringMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMonitoringMembersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartMonitoringMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            StartMonitoringMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMonitoringMembersError {
    fn code(&self) -> Option<&str> {
        StartMonitoringMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMonitoringMembersError {
    /// Creates a new `StartMonitoringMembersError`.
    pub fn new(kind: StartMonitoringMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMonitoringMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMonitoringMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMonitoringMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMonitoringMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMonitoringMembersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMonitoringMembersErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMonitoringMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMonitoringMembersErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for StartMonitoringMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMonitoringMembersErrorKind::BadRequestException(_inner) => Some(_inner),
            StartMonitoringMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            StartMonitoringMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopMonitoringMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopMonitoringMembersError {
    /// Kind of error that occurred.
    pub kind: StopMonitoringMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopMonitoringMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopMonitoringMembersErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopMonitoringMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopMonitoringMembersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StopMonitoringMembersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            StopMonitoringMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopMonitoringMembersError {
    fn code(&self) -> Option<&str> {
        StopMonitoringMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopMonitoringMembersError {
    /// Creates a new `StopMonitoringMembersError`.
    pub fn new(kind: StopMonitoringMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopMonitoringMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopMonitoringMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopMonitoringMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopMonitoringMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopMonitoringMembersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMonitoringMembersErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMonitoringMembersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMonitoringMembersErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for StopMonitoringMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopMonitoringMembersErrorKind::BadRequestException(_inner) => Some(_inner),
            StopMonitoringMembersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            StopMonitoringMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UnarchiveFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UnarchiveFindingsError {
    /// Kind of error that occurred.
    pub kind: UnarchiveFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UnarchiveFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UnarchiveFindingsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UnarchiveFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UnarchiveFindingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UnarchiveFindingsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UnarchiveFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UnarchiveFindingsError {
    fn code(&self) -> Option<&str> {
        UnarchiveFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UnarchiveFindingsError {
    /// Creates a new `UnarchiveFindingsError`.
    pub fn new(kind: UnarchiveFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UnarchiveFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UnarchiveFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UnarchiveFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UnarchiveFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UnarchiveFindingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnarchiveFindingsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UnarchiveFindingsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UnarchiveFindingsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for UnarchiveFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UnarchiveFindingsErrorKind::BadRequestException(_inner) => Some(_inner),
            UnarchiveFindingsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UnarchiveFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDetectorError {
    /// Kind of error that occurred.
    pub kind: UpdateDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDetectorErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDetectorErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDetectorErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDetectorError {
    fn code(&self) -> Option<&str> {
        UpdateDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDetectorError {
    /// Creates a new `UpdateDetectorError`.
    pub fn new(kind: UpdateDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDetectorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDetectorErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateDetectorErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateDetectorErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDetectorErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for UpdateDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDetectorErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDetectorErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFilterError {
    /// Kind of error that occurred.
    pub kind: UpdateFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFilterErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFilterErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateFilterErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFilterError {
    fn code(&self) -> Option<&str> {
        UpdateFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFilterError {
    /// Creates a new `UpdateFilterError`.
    pub fn new(kind: UpdateFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFilterErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateFilterErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateFilterErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFilterErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for UpdateFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFilterErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateFilterErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFindingsFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFindingsFeedbackError {
    /// Kind of error that occurred.
    pub kind: UpdateFindingsFeedbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFindingsFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFindingsFeedbackErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFindingsFeedbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFindingsFeedbackErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateFindingsFeedbackErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateFindingsFeedbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFindingsFeedbackError {
    fn code(&self) -> Option<&str> {
        UpdateFindingsFeedbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFindingsFeedbackError {
    /// Creates a new `UpdateFindingsFeedbackError`.
    pub fn new(kind: UpdateFindingsFeedbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFindingsFeedbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFindingsFeedbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFindingsFeedbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFindingsFeedbackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFindingsFeedbackErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFindingsFeedbackErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFindingsFeedbackErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFindingsFeedbackErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for UpdateFindingsFeedbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFindingsFeedbackErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateFindingsFeedbackErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateFindingsFeedbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIPSetError {
    /// Kind of error that occurred.
    pub kind: UpdateIPSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIPSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIPSetErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIPSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIPSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateIPSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIPSetError {
    fn code(&self) -> Option<&str> {
        UpdateIPSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIPSetError {
    /// Creates a new `UpdateIPSetError`.
    pub fn new(kind: UpdateIPSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIPSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIPSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIPSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIPSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateIPSetErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateIPSetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIPSetErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for UpdateIPSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIPSetErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateIPSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMemberDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMemberDetectorsError {
    /// Kind of error that occurred.
    pub kind: UpdateMemberDetectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMemberDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMemberDetectorsErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMemberDetectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMemberDetectorsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateMemberDetectorsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateMemberDetectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMemberDetectorsError {
    fn code(&self) -> Option<&str> {
        UpdateMemberDetectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMemberDetectorsError {
    /// Creates a new `UpdateMemberDetectorsError`.
    pub fn new(kind: UpdateMemberDetectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMemberDetectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMemberDetectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMemberDetectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMemberDetectorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMemberDetectorsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberDetectorsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMemberDetectorsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberDetectorsErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for UpdateMemberDetectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMemberDetectorsErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateMemberDetectorsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateMemberDetectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateOrganizationConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateOrganizationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateOrganizationConfigurationErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateOrganizationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateOrganizationConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateOrganizationConfigurationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateOrganizationConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateOrganizationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateOrganizationConfigurationError {
    /// Creates a new `UpdateOrganizationConfigurationError`.
    pub fn new(
        kind: UpdateOrganizationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateOrganizationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateOrganizationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateOrganizationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateOrganizationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for UpdateOrganizationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateOrganizationConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateOrganizationConfigurationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdateOrganizationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePublishingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePublishingDestinationError {
    /// Kind of error that occurred.
    pub kind: UpdatePublishingDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePublishingDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePublishingDestinationErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePublishingDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePublishingDestinationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdatePublishingDestinationErrorKind::InternalServerErrorException(_inner) => {
                _inner.fmt(f)
            }
            UpdatePublishingDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePublishingDestinationError {
    fn code(&self) -> Option<&str> {
        UpdatePublishingDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePublishingDestinationError {
    /// Creates a new `UpdatePublishingDestinationError`.
    pub fn new(kind: UpdatePublishingDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePublishingDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePublishingDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePublishingDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePublishingDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePublishingDestinationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePublishingDestinationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePublishingDestinationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePublishingDestinationErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for UpdatePublishingDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePublishingDestinationErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdatePublishingDestinationErrorKind::InternalServerErrorException(_inner) => {
                Some(_inner)
            }
            UpdatePublishingDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateThreatIntelSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateThreatIntelSetError {
    /// Kind of error that occurred.
    pub kind: UpdateThreatIntelSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateThreatIntelSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateThreatIntelSetErrorKind {
    /// <p>A bad request exception object.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal server error exception object.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateThreatIntelSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateThreatIntelSetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateThreatIntelSetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateThreatIntelSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateThreatIntelSetError {
    fn code(&self) -> Option<&str> {
        UpdateThreatIntelSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateThreatIntelSetError {
    /// Creates a new `UpdateThreatIntelSetError`.
    pub fn new(kind: UpdateThreatIntelSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateThreatIntelSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateThreatIntelSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateThreatIntelSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateThreatIntelSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateThreatIntelSetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThreatIntelSetErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateThreatIntelSetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateThreatIntelSetErrorKind::InternalServerErrorException(_)
        )
    }
}
impl std::error::Error for UpdateThreatIntelSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateThreatIntelSetErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateThreatIntelSetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateThreatIntelSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An internal server error exception object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The error type.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The error type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The error type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
                r#type: self.r#type,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// <p>A bad request exception object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// <p>The error message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The error type.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The error type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The error type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
                r#type: self.r#type,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}
