// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Ground Station
///
/// Client for invoking operations on AWS Ground Station. Each operation on AWS Ground Station is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_groundstation::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_groundstation::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_groundstation::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CancelContact` operation.
    ///
    /// See [`CancelContact`](crate::client::fluent_builders::CancelContact) for more information about the
    /// operation and its arguments.
    pub fn cancel_contact(&self) -> fluent_builders::CancelContact<C, M, R> {
        fluent_builders::CancelContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConfig` operation.
    ///
    /// See [`CreateConfig`](crate::client::fluent_builders::CreateConfig) for more information about the
    /// operation and its arguments.
    pub fn create_config(&self) -> fluent_builders::CreateConfig<C, M, R> {
        fluent_builders::CreateConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataflowEndpointGroup` operation.
    ///
    /// See [`CreateDataflowEndpointGroup`](crate::client::fluent_builders::CreateDataflowEndpointGroup) for more information about the
    /// operation and its arguments.
    pub fn create_dataflow_endpoint_group(
        &self,
    ) -> fluent_builders::CreateDataflowEndpointGroup<C, M, R> {
        fluent_builders::CreateDataflowEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMissionProfile` operation.
    ///
    /// See [`CreateMissionProfile`](crate::client::fluent_builders::CreateMissionProfile) for more information about the
    /// operation and its arguments.
    pub fn create_mission_profile(&self) -> fluent_builders::CreateMissionProfile<C, M, R> {
        fluent_builders::CreateMissionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConfig` operation.
    ///
    /// See [`DeleteConfig`](crate::client::fluent_builders::DeleteConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_config(&self) -> fluent_builders::DeleteConfig<C, M, R> {
        fluent_builders::DeleteConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataflowEndpointGroup` operation.
    ///
    /// See [`DeleteDataflowEndpointGroup`](crate::client::fluent_builders::DeleteDataflowEndpointGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_dataflow_endpoint_group(
        &self,
    ) -> fluent_builders::DeleteDataflowEndpointGroup<C, M, R> {
        fluent_builders::DeleteDataflowEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMissionProfile` operation.
    ///
    /// See [`DeleteMissionProfile`](crate::client::fluent_builders::DeleteMissionProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_mission_profile(&self) -> fluent_builders::DeleteMissionProfile<C, M, R> {
        fluent_builders::DeleteMissionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeContact` operation.
    ///
    /// See [`DescribeContact`](crate::client::fluent_builders::DescribeContact) for more information about the
    /// operation and its arguments.
    pub fn describe_contact(&self) -> fluent_builders::DescribeContact<C, M, R> {
        fluent_builders::DescribeContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConfig` operation.
    ///
    /// See [`GetConfig`](crate::client::fluent_builders::GetConfig) for more information about the
    /// operation and its arguments.
    pub fn get_config(&self) -> fluent_builders::GetConfig<C, M, R> {
        fluent_builders::GetConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDataflowEndpointGroup` operation.
    ///
    /// See [`GetDataflowEndpointGroup`](crate::client::fluent_builders::GetDataflowEndpointGroup) for more information about the
    /// operation and its arguments.
    pub fn get_dataflow_endpoint_group(
        &self,
    ) -> fluent_builders::GetDataflowEndpointGroup<C, M, R> {
        fluent_builders::GetDataflowEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMinuteUsage` operation.
    ///
    /// See [`GetMinuteUsage`](crate::client::fluent_builders::GetMinuteUsage) for more information about the
    /// operation and its arguments.
    pub fn get_minute_usage(&self) -> fluent_builders::GetMinuteUsage<C, M, R> {
        fluent_builders::GetMinuteUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMissionProfile` operation.
    ///
    /// See [`GetMissionProfile`](crate::client::fluent_builders::GetMissionProfile) for more information about the
    /// operation and its arguments.
    pub fn get_mission_profile(&self) -> fluent_builders::GetMissionProfile<C, M, R> {
        fluent_builders::GetMissionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSatellite` operation.
    ///
    /// See [`GetSatellite`](crate::client::fluent_builders::GetSatellite) for more information about the
    /// operation and its arguments.
    pub fn get_satellite(&self) -> fluent_builders::GetSatellite<C, M, R> {
        fluent_builders::GetSatellite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConfigs` operation.
    ///
    /// See [`ListConfigs`](crate::client::fluent_builders::ListConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_configs(&self) -> fluent_builders::ListConfigs<C, M, R> {
        fluent_builders::ListConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContacts` operation.
    ///
    /// See [`ListContacts`](crate::client::fluent_builders::ListContacts) for more information about the
    /// operation and its arguments.
    pub fn list_contacts(&self) -> fluent_builders::ListContacts<C, M, R> {
        fluent_builders::ListContacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDataflowEndpointGroups` operation.
    ///
    /// See [`ListDataflowEndpointGroups`](crate::client::fluent_builders::ListDataflowEndpointGroups) for more information about the
    /// operation and its arguments.
    pub fn list_dataflow_endpoint_groups(
        &self,
    ) -> fluent_builders::ListDataflowEndpointGroups<C, M, R> {
        fluent_builders::ListDataflowEndpointGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroundStations` operation.
    ///
    /// See [`ListGroundStations`](crate::client::fluent_builders::ListGroundStations) for more information about the
    /// operation and its arguments.
    pub fn list_ground_stations(&self) -> fluent_builders::ListGroundStations<C, M, R> {
        fluent_builders::ListGroundStations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMissionProfiles` operation.
    ///
    /// See [`ListMissionProfiles`](crate::client::fluent_builders::ListMissionProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_mission_profiles(&self) -> fluent_builders::ListMissionProfiles<C, M, R> {
        fluent_builders::ListMissionProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSatellites` operation.
    ///
    /// See [`ListSatellites`](crate::client::fluent_builders::ListSatellites) for more information about the
    /// operation and its arguments.
    pub fn list_satellites(&self) -> fluent_builders::ListSatellites<C, M, R> {
        fluent_builders::ListSatellites::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReserveContact` operation.
    ///
    /// See [`ReserveContact`](crate::client::fluent_builders::ReserveContact) for more information about the
    /// operation and its arguments.
    pub fn reserve_contact(&self) -> fluent_builders::ReserveContact<C, M, R> {
        fluent_builders::ReserveContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConfig` operation.
    ///
    /// See [`UpdateConfig`](crate::client::fluent_builders::UpdateConfig) for more information about the
    /// operation and its arguments.
    pub fn update_config(&self) -> fluent_builders::UpdateConfig<C, M, R> {
        fluent_builders::UpdateConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMissionProfile` operation.
    ///
    /// See [`UpdateMissionProfile`](crate::client::fluent_builders::UpdateMissionProfile) for more information about the
    /// operation and its arguments.
    pub fn update_mission_profile(&self) -> fluent_builders::UpdateMissionProfile<C, M, R> {
        fluent_builders::UpdateMissionProfile::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelContact`.
    ///
    /// <p>Cancels a contact with a specified contact ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_contact_input::Builder,
    }
    impl<C, M, R> CancelContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelContactOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelContactInputOperationOutputAlias,
                crate::output::CancelContactOutput,
                crate::error::CancelContactError,
                crate::input::CancelContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a contact.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>UUID of a contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfig`.
    ///
    /// <p>Creates a <code>Config</code> with the specified <code>configData</code> parameters.</p>
    /// <p>Only one type of <code>configData</code> can be specified.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_config_input::Builder,
    }
    impl<C, M, R> CreateConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConfigInputOperationOutputAlias,
                crate::output::CreateConfigOutput,
                crate::error::CreateConfigError,
                crate::input::CreateConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn config_data(mut self, inp: crate::model::ConfigTypeData) -> Self {
            self.inner = self.inner.config_data(inp);
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn set_config_data(
            mut self,
            input: std::option::Option<crate::model::ConfigTypeData>,
        ) -> Self {
            self.inner = self.inner.set_config_data(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a <code>Config</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags assigned to a <code>Config</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataflowEndpointGroup`.
    ///
    /// <p>Creates a <code>DataflowEndpoint</code> group containing the specified list of <code>DataflowEndpoint</code> objects.</p>
    /// <p>The <code>name</code> field in each endpoint is used in your mission profile <code>DataflowEndpointConfig</code>
    /// to specify which endpoints to use during a contact.</p>
    /// <p>When a contact uses multiple <code>DataflowEndpointConfig</code> objects, each <code>Config</code>
    /// must match a <code>DataflowEndpoint</code> in the same group.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataflowEndpointGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataflow_endpoint_group_input::Builder,
    }
    impl<C, M, R> CreateDataflowEndpointGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataflowEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataflowEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataflowEndpointGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataflowEndpointGroupInputOperationOutputAlias,
                crate::output::CreateDataflowEndpointGroupOutput,
                crate::error::CreateDataflowEndpointGroupError,
                crate::input::CreateDataflowEndpointGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `endpointDetails`.
        ///
        /// To override the contents of this collection use [`set_endpoint_details`](Self::set_endpoint_details).
        ///
        /// <p>Endpoint details of each endpoint in the dataflow endpoint group.</p>
        pub fn endpoint_details(mut self, inp: impl Into<crate::model::EndpointDetails>) -> Self {
            self.inner = self.inner.endpoint_details(inp);
            self
        }
        /// <p>Endpoint details of each endpoint in the dataflow endpoint group.</p>
        pub fn set_endpoint_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointDetails>>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_details(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags of a dataflow endpoint group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags of a dataflow endpoint group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMissionProfile`.
    ///
    /// <p>Creates a mission profile.</p>
    /// <p>
    /// <code>dataflowEdges</code> is a list of lists of strings. Each lower level list of strings
    /// has two elements: a <i>from</i> ARN and a <i>to</i> ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMissionProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_mission_profile_input::Builder,
    }
    impl<C, M, R> CreateMissionProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMissionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMissionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMissionProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMissionProfileInputOperationOutputAlias,
                crate::output::CreateMissionProfileOutput,
                crate::error::CreateMissionProfileError,
                crate::input::CreateMissionProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a mission profile.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn contact_pre_pass_duration_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.contact_pre_pass_duration_seconds(inp);
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn set_contact_pre_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_contact_pre_pass_duration_seconds(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn contact_post_pass_duration_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.contact_post_pass_duration_seconds(inp);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_contact_post_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_contact_post_pass_duration_seconds(input);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn minimum_viable_contact_duration_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.minimum_viable_contact_duration_seconds(inp);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn set_minimum_viable_contact_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self
                .inner
                .set_minimum_viable_contact_duration_seconds(input);
            self
        }
        /// Appends an item to `dataflowEdges`.
        ///
        /// To override the contents of this collection use [`set_dataflow_edges`](Self::set_dataflow_edges).
        ///
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
        /// <code>Config</code> and a <i>to</i>
        /// <code>Config</code>.</p>
        pub fn dataflow_edges(
            mut self,
            inp: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.dataflow_edges(inp);
            self
        }
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
        /// <code>Config</code> and a <i>to</i>
        /// <code>Config</code>.</p>
        pub fn set_dataflow_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.inner = self.inner.set_dataflow_edges(input);
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn tracking_config_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracking_config_arn(inp);
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn set_tracking_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tracking_config_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a mission profile.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags assigned to a mission profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfig`.
    ///
    /// <p>Deletes a <code>Config</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_config_input::Builder,
    }
    impl<C, M, R> DeleteConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConfigInputOperationOutputAlias,
                crate::output::DeleteConfigOutput,
                crate::error::DeleteConfigError,
                crate::input::DeleteConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(inp);
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, inp: crate::model::ConfigCapabilityType) -> Self {
            self.inner = self.inner.config_type(inp);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.inner = self.inner.set_config_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataflowEndpointGroup`.
    ///
    /// <p>Deletes a dataflow endpoint group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataflowEndpointGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataflow_endpoint_group_input::Builder,
    }
    impl<C, M, R> DeleteDataflowEndpointGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataflowEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataflowEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataflowEndpointGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataflowEndpointGroupInputOperationOutputAlias,
                crate::output::DeleteDataflowEndpointGroupOutput,
                crate::error::DeleteDataflowEndpointGroupError,
                crate::input::DeleteDataflowEndpointGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataflow_endpoint_group_id(inp);
            self
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataflow_endpoint_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMissionProfile`.
    ///
    /// <p>Deletes a mission profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMissionProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_mission_profile_input::Builder,
    }
    impl<C, M, R> DeleteMissionProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMissionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMissionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMissionProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMissionProfileInputOperationOutputAlias,
                crate::output::DeleteMissionProfileOutput,
                crate::error::DeleteMissionProfileError,
                crate::input::DeleteMissionProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mission_profile_id(inp);
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mission_profile_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContact`.
    ///
    /// <p>Describes an existing contact.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_contact_input::Builder,
    }
    impl<C, M, R> DescribeContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContactOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContactInputOperationOutputAlias,
                crate::output::DescribeContactOutput,
                crate::error::DescribeContactError,
                crate::input::DescribeContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a contact.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>UUID of a contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfig`.
    ///
    /// <p>Returns <code>Config</code> information.</p>
    /// <p>Only one <code>Config</code> response can be returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_config_input::Builder,
    }
    impl<C, M, R> GetConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConfigInputOperationOutputAlias,
                crate::output::GetConfigOutput,
                crate::error::GetConfigError,
                crate::input::GetConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(inp);
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, inp: crate::model::ConfigCapabilityType) -> Self {
            self.inner = self.inner.config_type(inp);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.inner = self.inner.set_config_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataflowEndpointGroup`.
    ///
    /// <p>Returns the dataflow endpoint group.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDataflowEndpointGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dataflow_endpoint_group_input::Builder,
    }
    impl<C, M, R> GetDataflowEndpointGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDataflowEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataflowEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataflowEndpointGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDataflowEndpointGroupInputOperationOutputAlias,
                crate::output::GetDataflowEndpointGroupOutput,
                crate::error::GetDataflowEndpointGroupError,
                crate::input::GetDataflowEndpointGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataflow_endpoint_group_id(inp);
            self
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataflow_endpoint_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMinuteUsage`.
    ///
    /// <p>Returns the number of minutes used by account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMinuteUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_minute_usage_input::Builder,
    }
    impl<C, M, R> GetMinuteUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMinuteUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMinuteUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMinuteUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMinuteUsageInputOperationOutputAlias,
                crate::output::GetMinuteUsageOutput,
                crate::error::GetMinuteUsageError,
                crate::input::GetMinuteUsageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The month being requested, with a value of 1-12.</p>
        pub fn month(mut self, inp: i32) -> Self {
            self.inner = self.inner.month(inp);
            self
        }
        /// <p>The month being requested, with a value of 1-12.</p>
        pub fn set_month(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_month(input);
            self
        }
        /// <p>The year being requested, in the format of YYYY.</p>
        pub fn year(mut self, inp: i32) -> Self {
            self.inner = self.inner.year(inp);
            self
        }
        /// <p>The year being requested, in the format of YYYY.</p>
        pub fn set_year(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_year(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMissionProfile`.
    ///
    /// <p>Returns a mission profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMissionProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_mission_profile_input::Builder,
    }
    impl<C, M, R> GetMissionProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMissionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMissionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMissionProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMissionProfileInputOperationOutputAlias,
                crate::output::GetMissionProfileOutput,
                crate::error::GetMissionProfileError,
                crate::input::GetMissionProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mission_profile_id(inp);
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mission_profile_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSatellite`.
    ///
    /// <p>Returns a satellite.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSatellite<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_satellite_input::Builder,
    }
    impl<C, M, R> GetSatellite<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSatellite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSatelliteOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSatelliteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSatelliteInputOperationOutputAlias,
                crate::output::GetSatelliteOutput,
                crate::error::GetSatelliteError,
                crate::input::GetSatelliteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a satellite.</p>
        pub fn satellite_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.satellite_id(inp);
            self
        }
        /// <p>UUID of a satellite.</p>
        pub fn set_satellite_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_satellite_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigs`.
    ///
    /// <p>Returns a list of <code>Config</code> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_configs_input::Builder,
    }
    impl<C, M, R> ListConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConfigsInputOperationOutputAlias,
                crate::output::ListConfigsOutput,
                crate::error::ListConfigsError,
                crate::input::ListConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of <code>Configs</code> returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of <code>Configs</code> returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContacts`.
    ///
    /// <p>Returns a list of contacts.</p>
    /// <p>If <code>statusList</code> contains AVAILABLE, the request must include
    /// <code>groundStation</code>, <code>missionprofileArn</code>, and <code>satelliteArn</code>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListContacts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contacts_input::Builder,
    }
    impl<C, M, R> ListContacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactsInputOperationOutputAlias,
                crate::output::ListContactsOutput,
                crate::error::ListContactsError,
                crate::input::ListContactsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of contacts returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of contacts returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `statusList`.
        ///
        /// To override the contents of this collection use [`set_status_list`](Self::set_status_list).
        ///
        /// <p>Status of a contact reservation.</p>
        pub fn status_list(mut self, inp: impl Into<crate::model::ContactStatus>) -> Self {
            self.inner = self.inner.status_list(inp);
            self
        }
        /// <p>Status of a contact reservation.</p>
        pub fn set_status_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactStatus>>,
        ) -> Self {
            self.inner = self.inner.set_status_list(input);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn ground_station(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ground_station(inp);
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn set_ground_station(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ground_station(input);
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn satellite_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.satellite_arn(inp);
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn set_satellite_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_satellite_arn(input);
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn mission_profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mission_profile_arn(inp);
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn set_mission_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mission_profile_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataflowEndpointGroups`.
    ///
    /// <p>Returns a list of <code>DataflowEndpoint</code> groups.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDataflowEndpointGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dataflow_endpoint_groups_input::Builder,
    }
    impl<C, M, R> ListDataflowEndpointGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataflowEndpointGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataflowEndpointGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataflowEndpointGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataflowEndpointGroupsInputOperationOutputAlias,
                crate::output::ListDataflowEndpointGroupsOutput,
                crate::error::ListDataflowEndpointGroupsError,
                crate::input::ListDataflowEndpointGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of dataflow endpoint groups returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of dataflow endpoint groups returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroundStations`.
    ///
    /// <p>Returns a list of ground stations. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListGroundStations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ground_stations_input::Builder,
    }
    impl<C, M, R> ListGroundStations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroundStations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroundStationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroundStationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroundStationsInputOperationOutputAlias,
                crate::output::ListGroundStationsOutput,
                crate::error::ListGroundStationsError,
                crate::input::ListGroundStationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Satellite ID to retrieve on-boarded ground stations.</p>
        pub fn satellite_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.satellite_id(inp);
            self
        }
        /// <p>Satellite ID to retrieve on-boarded ground stations.</p>
        pub fn set_satellite_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_satellite_id(input);
            self
        }
        /// <p>Maximum number of ground stations returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of ground stations returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMissionProfiles`.
    ///
    /// <p>Returns a list of mission profiles.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMissionProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_mission_profiles_input::Builder,
    }
    impl<C, M, R> ListMissionProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMissionProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMissionProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMissionProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMissionProfilesInputOperationOutputAlias,
                crate::output::ListMissionProfilesOutput,
                crate::error::ListMissionProfilesError,
                crate::input::ListMissionProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of mission profiles returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of mission profiles returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSatellites`.
    ///
    /// <p>Returns a list of satellites.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSatellites<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_satellites_input::Builder,
    }
    impl<C, M, R> ListSatellites<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSatellites`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSatellitesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSatellitesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSatellitesInputOperationOutputAlias,
                crate::output::ListSatellitesOutput,
                crate::error::ListSatellitesError,
                crate::input::ListSatellitesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of satellites returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of satellites returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags for a specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of a resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>ARN of a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReserveContact`.
    ///
    /// <p>Reserves a contact using specified parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ReserveContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reserve_contact_input::Builder,
    }
    impl<C, M, R> ReserveContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ReserveContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReserveContactOutput,
            aws_smithy_http::result::SdkError<crate::error::ReserveContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ReserveContactInputOperationOutputAlias,
                crate::output::ReserveContactOutput,
                crate::error::ReserveContactError,
                crate::input::ReserveContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of a mission profile.</p>
        pub fn mission_profile_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mission_profile_arn(inp);
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn set_mission_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mission_profile_arn(input);
            self
        }
        /// <p>ARN of a satellite</p>
        pub fn satellite_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.satellite_arn(inp);
            self
        }
        /// <p>ARN of a satellite</p>
        pub fn set_satellite_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_satellite_arn(input);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn ground_station(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ground_station(inp);
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn set_ground_station(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ground_station(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a contact.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags assigned to a contact.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns a tag to a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of a resource tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>ARN of a resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags assigned to a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deassigns a resource tag.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of a resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>ARN of a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys of a resource tag.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>Keys of a resource tag.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfig`.
    ///
    /// <p>Updates the <code>Config</code> used when scheduling contacts.</p>
    /// <p>Updating a <code>Config</code> will not update the execution parameters
    /// for existing future contacts scheduled with this <code>Config</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_config_input::Builder,
    }
    impl<C, M, R> UpdateConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConfigInputOperationOutputAlias,
                crate::output::UpdateConfigOutput,
                crate::error::UpdateConfigError,
                crate::input::UpdateConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(inp);
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, inp: crate::model::ConfigCapabilityType) -> Self {
            self.inner = self.inner.config_type(inp);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.inner = self.inner.set_config_type(input);
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn config_data(mut self, inp: crate::model::ConfigTypeData) -> Self {
            self.inner = self.inner.config_data(inp);
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn set_config_data(
            mut self,
            input: std::option::Option<crate::model::ConfigTypeData>,
        ) -> Self {
            self.inner = self.inner.set_config_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMissionProfile`.
    ///
    /// <p>Updates a mission profile.</p>
    /// <p>Updating a mission profile will not update the execution parameters
    /// for existing future contacts.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMissionProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_mission_profile_input::Builder,
    }
    impl<C, M, R> UpdateMissionProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMissionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMissionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMissionProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMissionProfileInputOperationOutputAlias,
                crate::output::UpdateMissionProfileOutput,
                crate::error::UpdateMissionProfileError,
                crate::input::UpdateMissionProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mission_profile_id(inp);
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mission_profile_id(input);
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn contact_pre_pass_duration_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.contact_pre_pass_duration_seconds(inp);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_contact_pre_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_contact_pre_pass_duration_seconds(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn contact_post_pass_duration_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.contact_post_pass_duration_seconds(inp);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_contact_post_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_contact_post_pass_duration_seconds(input);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn minimum_viable_contact_duration_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.minimum_viable_contact_duration_seconds(inp);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn set_minimum_viable_contact_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self
                .inner
                .set_minimum_viable_contact_duration_seconds(input);
            self
        }
        /// Appends an item to `dataflowEdges`.
        ///
        /// To override the contents of this collection use [`set_dataflow_edges`](Self::set_dataflow_edges).
        ///
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
        /// <code>Config</code> and a <i>to</i>
        /// <code>Config</code>.</p>
        pub fn dataflow_edges(
            mut self,
            inp: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.dataflow_edges(inp);
            self
        }
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
        /// <code>Config</code> and a <i>to</i>
        /// <code>Config</code>.</p>
        pub fn set_dataflow_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.inner = self.inner.set_dataflow_edges(input);
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn tracking_config_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracking_config_arn(inp);
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn set_tracking_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tracking_config_arn(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
