// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Ground Station
///
/// Client for invoking operations on AWS Ground Station. Each operation on AWS Ground Station is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_groundstation::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_groundstation::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_groundstation::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CancelContact`](crate::client::fluent_builders::CancelContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::CancelContact::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::CancelContact::set_contact_id): <p>UUID of a contact.</p>
    /// - On success, responds with [`CancelContactOutput`](crate::output::CancelContactOutput) with field(s):
    ///   - [`contact_id(Option<String>)`](crate::output::CancelContactOutput::contact_id): <p>UUID of a contact.</p>
    /// - On failure, responds with [`SdkError<CancelContactError>`](crate::error::CancelContactError)
    pub fn cancel_contact(&self) -> fluent_builders::CancelContact {
        fluent_builders::CancelContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateConfig`](crate::client::fluent_builders::CreateConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateConfig::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateConfig::set_name): <p>Name of a <code>Config</code>.</p>
    ///   - [`config_data(ConfigTypeData)`](crate::client::fluent_builders::CreateConfig::config_data) / [`set_config_data(Option<ConfigTypeData>)`](crate::client::fluent_builders::CreateConfig::set_config_data): <p>Parameters of a <code>Config</code>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateConfig::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateConfig::set_tags): <p>Tags assigned to a <code>Config</code>.</p>
    /// - On success, responds with [`CreateConfigOutput`](crate::output::CreateConfigOutput) with field(s):
    ///   - [`config_id(Option<String>)`](crate::output::CreateConfigOutput::config_id): <p>UUID of a <code>Config</code>.</p>
    ///   - [`config_type(Option<ConfigCapabilityType>)`](crate::output::CreateConfigOutput::config_type): <p>Type of a <code>Config</code>.</p>
    ///   - [`config_arn(Option<String>)`](crate::output::CreateConfigOutput::config_arn): <p>ARN of a <code>Config</code>.</p>
    /// - On failure, responds with [`SdkError<CreateConfigError>`](crate::error::CreateConfigError)
    pub fn create_config(&self) -> fluent_builders::CreateConfig {
        fluent_builders::CreateConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataflowEndpointGroup`](crate::client::fluent_builders::CreateDataflowEndpointGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_details(Vec<EndpointDetails>)`](crate::client::fluent_builders::CreateDataflowEndpointGroup::endpoint_details) / [`set_endpoint_details(Option<Vec<EndpointDetails>>)`](crate::client::fluent_builders::CreateDataflowEndpointGroup::set_endpoint_details): <p>Endpoint details of each endpoint in the dataflow endpoint group.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDataflowEndpointGroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDataflowEndpointGroup::set_tags): <p>Tags of a dataflow endpoint group.</p>
    /// - On success, responds with [`CreateDataflowEndpointGroupOutput`](crate::output::CreateDataflowEndpointGroupOutput) with field(s):
    ///   - [`dataflow_endpoint_group_id(Option<String>)`](crate::output::CreateDataflowEndpointGroupOutput::dataflow_endpoint_group_id): <p>UUID of a dataflow endpoint group.</p>
    /// - On failure, responds with [`SdkError<CreateDataflowEndpointGroupError>`](crate::error::CreateDataflowEndpointGroupError)
    pub fn create_dataflow_endpoint_group(&self) -> fluent_builders::CreateDataflowEndpointGroup {
        fluent_builders::CreateDataflowEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMissionProfile`](crate::client::fluent_builders::CreateMissionProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateMissionProfile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateMissionProfile::set_name): <p>Name of a mission profile.</p>
    ///   - [`contact_pre_pass_duration_seconds(i32)`](crate::client::fluent_builders::CreateMissionProfile::contact_pre_pass_duration_seconds) / [`set_contact_pre_pass_duration_seconds(Option<i32>)`](crate::client::fluent_builders::CreateMissionProfile::set_contact_pre_pass_duration_seconds): <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
    ///   - [`contact_post_pass_duration_seconds(i32)`](crate::client::fluent_builders::CreateMissionProfile::contact_post_pass_duration_seconds) / [`set_contact_post_pass_duration_seconds(Option<i32>)`](crate::client::fluent_builders::CreateMissionProfile::set_contact_post_pass_duration_seconds): <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    ///   - [`minimum_viable_contact_duration_seconds(i32)`](crate::client::fluent_builders::CreateMissionProfile::minimum_viable_contact_duration_seconds) / [`set_minimum_viable_contact_duration_seconds(Option<i32>)`](crate::client::fluent_builders::CreateMissionProfile::set_minimum_viable_contact_duration_seconds): <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
    ///   - [`dataflow_edges(Vec<Vec<String>>)`](crate::client::fluent_builders::CreateMissionProfile::dataflow_edges) / [`set_dataflow_edges(Option<Vec<Vec<String>>>)`](crate::client::fluent_builders::CreateMissionProfile::set_dataflow_edges): <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i> <code>Config</code>.</p>
    ///   - [`tracking_config_arn(impl Into<String>)`](crate::client::fluent_builders::CreateMissionProfile::tracking_config_arn) / [`set_tracking_config_arn(Option<String>)`](crate::client::fluent_builders::CreateMissionProfile::set_tracking_config_arn): <p>ARN of a tracking <code>Config</code>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateMissionProfile::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateMissionProfile::set_tags): <p>Tags assigned to a mission profile.</p>
    /// - On success, responds with [`CreateMissionProfileOutput`](crate::output::CreateMissionProfileOutput) with field(s):
    ///   - [`mission_profile_id(Option<String>)`](crate::output::CreateMissionProfileOutput::mission_profile_id): <p>UUID of a mission profile.</p>
    /// - On failure, responds with [`SdkError<CreateMissionProfileError>`](crate::error::CreateMissionProfileError)
    pub fn create_mission_profile(&self) -> fluent_builders::CreateMissionProfile {
        fluent_builders::CreateMissionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteConfig`](crate::client::fluent_builders::DeleteConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`config_id(impl Into<String>)`](crate::client::fluent_builders::DeleteConfig::config_id) / [`set_config_id(Option<String>)`](crate::client::fluent_builders::DeleteConfig::set_config_id): <p>UUID of a <code>Config</code>.</p>
    ///   - [`config_type(ConfigCapabilityType)`](crate::client::fluent_builders::DeleteConfig::config_type) / [`set_config_type(Option<ConfigCapabilityType>)`](crate::client::fluent_builders::DeleteConfig::set_config_type): <p>Type of a <code>Config</code>.</p>
    /// - On success, responds with [`DeleteConfigOutput`](crate::output::DeleteConfigOutput) with field(s):
    ///   - [`config_id(Option<String>)`](crate::output::DeleteConfigOutput::config_id): <p>UUID of a <code>Config</code>.</p>
    ///   - [`config_type(Option<ConfigCapabilityType>)`](crate::output::DeleteConfigOutput::config_type): <p>Type of a <code>Config</code>.</p>
    ///   - [`config_arn(Option<String>)`](crate::output::DeleteConfigOutput::config_arn): <p>ARN of a <code>Config</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteConfigError>`](crate::error::DeleteConfigError)
    pub fn delete_config(&self) -> fluent_builders::DeleteConfig {
        fluent_builders::DeleteConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataflowEndpointGroup`](crate::client::fluent_builders::DeleteDataflowEndpointGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataflow_endpoint_group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataflowEndpointGroup::dataflow_endpoint_group_id) / [`set_dataflow_endpoint_group_id(Option<String>)`](crate::client::fluent_builders::DeleteDataflowEndpointGroup::set_dataflow_endpoint_group_id): <p>UUID of a dataflow endpoint group.</p>
    /// - On success, responds with [`DeleteDataflowEndpointGroupOutput`](crate::output::DeleteDataflowEndpointGroupOutput) with field(s):
    ///   - [`dataflow_endpoint_group_id(Option<String>)`](crate::output::DeleteDataflowEndpointGroupOutput::dataflow_endpoint_group_id): <p>UUID of a dataflow endpoint group.</p>
    /// - On failure, responds with [`SdkError<DeleteDataflowEndpointGroupError>`](crate::error::DeleteDataflowEndpointGroupError)
    pub fn delete_dataflow_endpoint_group(&self) -> fluent_builders::DeleteDataflowEndpointGroup {
        fluent_builders::DeleteDataflowEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMissionProfile`](crate::client::fluent_builders::DeleteMissionProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mission_profile_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMissionProfile::mission_profile_id) / [`set_mission_profile_id(Option<String>)`](crate::client::fluent_builders::DeleteMissionProfile::set_mission_profile_id): <p>UUID of a mission profile.</p>
    /// - On success, responds with [`DeleteMissionProfileOutput`](crate::output::DeleteMissionProfileOutput) with field(s):
    ///   - [`mission_profile_id(Option<String>)`](crate::output::DeleteMissionProfileOutput::mission_profile_id): <p>UUID of a mission profile.</p>
    /// - On failure, responds with [`SdkError<DeleteMissionProfileError>`](crate::error::DeleteMissionProfileError)
    pub fn delete_mission_profile(&self) -> fluent_builders::DeleteMissionProfile {
        fluent_builders::DeleteMissionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeContact`](crate::client::fluent_builders::DescribeContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::DescribeContact::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::DescribeContact::set_contact_id): <p>UUID of a contact.</p>
    /// - On success, responds with [`DescribeContactOutput`](crate::output::DescribeContactOutput) with field(s):
    ///   - [`contact_id(Option<String>)`](crate::output::DescribeContactOutput::contact_id): <p>UUID of a contact.</p>
    ///   - [`mission_profile_arn(Option<String>)`](crate::output::DescribeContactOutput::mission_profile_arn): <p>ARN of a mission profile.</p>
    ///   - [`satellite_arn(Option<String>)`](crate::output::DescribeContactOutput::satellite_arn): <p>ARN of a satellite.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::DescribeContactOutput::start_time): <p>Start time of a contact.</p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::DescribeContactOutput::end_time): <p>End time of a contact.</p>
    ///   - [`pre_pass_start_time(Option<DateTime>)`](crate::output::DescribeContactOutput::pre_pass_start_time): <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
    ///   - [`post_pass_end_time(Option<DateTime>)`](crate::output::DescribeContactOutput::post_pass_end_time): <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    ///   - [`ground_station(Option<String>)`](crate::output::DescribeContactOutput::ground_station): <p>Ground station for a contact.</p>
    ///   - [`contact_status(Option<ContactStatus>)`](crate::output::DescribeContactOutput::contact_status): <p>Status of a contact.</p>
    ///   - [`error_message(Option<String>)`](crate::output::DescribeContactOutput::error_message): <p>Error message for a contact.</p>
    ///   - [`maximum_elevation(Option<Elevation>)`](crate::output::DescribeContactOutput::maximum_elevation): <p>Maximum elevation angle of a contact.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeContactOutput::tags): <p>Tags assigned to a contact.</p>
    ///   - [`region(Option<String>)`](crate::output::DescribeContactOutput::region): <p>Region of a contact.</p>
    ///   - [`dataflow_list(Option<Vec<DataflowDetail>>)`](crate::output::DescribeContactOutput::dataflow_list): <p>List describing source and destination details for each dataflow edge.</p>
    /// - On failure, responds with [`SdkError<DescribeContactError>`](crate::error::DescribeContactError)
    pub fn describe_contact(&self) -> fluent_builders::DescribeContact {
        fluent_builders::DescribeContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConfig`](crate::client::fluent_builders::GetConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`config_id(impl Into<String>)`](crate::client::fluent_builders::GetConfig::config_id) / [`set_config_id(Option<String>)`](crate::client::fluent_builders::GetConfig::set_config_id): <p>UUID of a <code>Config</code>.</p>
    ///   - [`config_type(ConfigCapabilityType)`](crate::client::fluent_builders::GetConfig::config_type) / [`set_config_type(Option<ConfigCapabilityType>)`](crate::client::fluent_builders::GetConfig::set_config_type): <p>Type of a <code>Config</code>.</p>
    /// - On success, responds with [`GetConfigOutput`](crate::output::GetConfigOutput) with field(s):
    ///   - [`config_id(Option<String>)`](crate::output::GetConfigOutput::config_id): <p>UUID of a <code>Config</code>.</p>
    ///   - [`config_arn(Option<String>)`](crate::output::GetConfigOutput::config_arn): <p>ARN of a <code>Config</code> </p>
    ///   - [`name(Option<String>)`](crate::output::GetConfigOutput::name): <p>Name of a <code>Config</code>.</p>
    ///   - [`config_type(Option<ConfigCapabilityType>)`](crate::output::GetConfigOutput::config_type): <p>Type of a <code>Config</code>.</p>
    ///   - [`config_data(Option<ConfigTypeData>)`](crate::output::GetConfigOutput::config_data): <p>Data elements in a <code>Config</code>.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetConfigOutput::tags): <p>Tags assigned to a <code>Config</code>.</p>
    /// - On failure, responds with [`SdkError<GetConfigError>`](crate::error::GetConfigError)
    pub fn get_config(&self) -> fluent_builders::GetConfig {
        fluent_builders::GetConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDataflowEndpointGroup`](crate::client::fluent_builders::GetDataflowEndpointGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataflow_endpoint_group_id(impl Into<String>)`](crate::client::fluent_builders::GetDataflowEndpointGroup::dataflow_endpoint_group_id) / [`set_dataflow_endpoint_group_id(Option<String>)`](crate::client::fluent_builders::GetDataflowEndpointGroup::set_dataflow_endpoint_group_id): <p>UUID of a dataflow endpoint group.</p>
    /// - On success, responds with [`GetDataflowEndpointGroupOutput`](crate::output::GetDataflowEndpointGroupOutput) with field(s):
    ///   - [`dataflow_endpoint_group_id(Option<String>)`](crate::output::GetDataflowEndpointGroupOutput::dataflow_endpoint_group_id): <p>UUID of a dataflow endpoint group.</p>
    ///   - [`dataflow_endpoint_group_arn(Option<String>)`](crate::output::GetDataflowEndpointGroupOutput::dataflow_endpoint_group_arn): <p>ARN of a dataflow endpoint group.</p>
    ///   - [`endpoints_details(Option<Vec<EndpointDetails>>)`](crate::output::GetDataflowEndpointGroupOutput::endpoints_details): <p>Details of a dataflow endpoint.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetDataflowEndpointGroupOutput::tags): <p>Tags assigned to a dataflow endpoint group.</p>
    /// - On failure, responds with [`SdkError<GetDataflowEndpointGroupError>`](crate::error::GetDataflowEndpointGroupError)
    pub fn get_dataflow_endpoint_group(&self) -> fluent_builders::GetDataflowEndpointGroup {
        fluent_builders::GetDataflowEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMinuteUsage`](crate::client::fluent_builders::GetMinuteUsage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`month(i32)`](crate::client::fluent_builders::GetMinuteUsage::month) / [`set_month(Option<i32>)`](crate::client::fluent_builders::GetMinuteUsage::set_month): <p>The month being requested, with a value of 1-12.</p>
    ///   - [`year(i32)`](crate::client::fluent_builders::GetMinuteUsage::year) / [`set_year(Option<i32>)`](crate::client::fluent_builders::GetMinuteUsage::set_year): <p>The year being requested, in the format of YYYY.</p>
    /// - On success, responds with [`GetMinuteUsageOutput`](crate::output::GetMinuteUsageOutput) with field(s):
    ///   - [`is_reserved_minutes_customer(Option<bool>)`](crate::output::GetMinuteUsageOutput::is_reserved_minutes_customer): <p>Returns whether or not an account has signed up for the reserved minutes pricing plan, specific to the month being requested.</p>
    ///   - [`total_reserved_minute_allocation(Option<i32>)`](crate::output::GetMinuteUsageOutput::total_reserved_minute_allocation): <p>Total number of reserved minutes allocated, specific to the month being requested.</p>
    ///   - [`upcoming_minutes_scheduled(Option<i32>)`](crate::output::GetMinuteUsageOutput::upcoming_minutes_scheduled): <p>Upcoming minutes scheduled for an account, specific to the month being requested.</p>
    ///   - [`total_scheduled_minutes(Option<i32>)`](crate::output::GetMinuteUsageOutput::total_scheduled_minutes): <p>Total scheduled minutes for an account, specific to the month being requested.</p>
    ///   - [`estimated_minutes_remaining(Option<i32>)`](crate::output::GetMinuteUsageOutput::estimated_minutes_remaining): <p>Estimated number of minutes remaining for an account, specific to the month being requested.</p>
    /// - On failure, responds with [`SdkError<GetMinuteUsageError>`](crate::error::GetMinuteUsageError)
    pub fn get_minute_usage(&self) -> fluent_builders::GetMinuteUsage {
        fluent_builders::GetMinuteUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMissionProfile`](crate::client::fluent_builders::GetMissionProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mission_profile_id(impl Into<String>)`](crate::client::fluent_builders::GetMissionProfile::mission_profile_id) / [`set_mission_profile_id(Option<String>)`](crate::client::fluent_builders::GetMissionProfile::set_mission_profile_id): <p>UUID of a mission profile.</p>
    /// - On success, responds with [`GetMissionProfileOutput`](crate::output::GetMissionProfileOutput) with field(s):
    ///   - [`mission_profile_id(Option<String>)`](crate::output::GetMissionProfileOutput::mission_profile_id): <p>UUID of a mission profile.</p>
    ///   - [`mission_profile_arn(Option<String>)`](crate::output::GetMissionProfileOutput::mission_profile_arn): <p>ARN of a mission profile.</p>
    ///   - [`name(Option<String>)`](crate::output::GetMissionProfileOutput::name): <p>Name of a mission profile.</p>
    ///   - [`region(Option<String>)`](crate::output::GetMissionProfileOutput::region): <p>Region of a mission profile.</p>
    ///   - [`contact_pre_pass_duration_seconds(Option<i32>)`](crate::output::GetMissionProfileOutput::contact_pre_pass_duration_seconds): <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
    ///   - [`contact_post_pass_duration_seconds(Option<i32>)`](crate::output::GetMissionProfileOutput::contact_post_pass_duration_seconds): <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    ///   - [`minimum_viable_contact_duration_seconds(Option<i32>)`](crate::output::GetMissionProfileOutput::minimum_viable_contact_duration_seconds): <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
    ///   - [`dataflow_edges(Option<Vec<Vec<String>>>)`](crate::output::GetMissionProfileOutput::dataflow_edges): <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i> <code>Config</code>.</p>
    ///   - [`tracking_config_arn(Option<String>)`](crate::output::GetMissionProfileOutput::tracking_config_arn): <p>ARN of a tracking <code>Config</code>.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetMissionProfileOutput::tags): <p>Tags assigned to a mission profile.</p>
    /// - On failure, responds with [`SdkError<GetMissionProfileError>`](crate::error::GetMissionProfileError)
    pub fn get_mission_profile(&self) -> fluent_builders::GetMissionProfile {
        fluent_builders::GetMissionProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSatellite`](crate::client::fluent_builders::GetSatellite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`satellite_id(impl Into<String>)`](crate::client::fluent_builders::GetSatellite::satellite_id) / [`set_satellite_id(Option<String>)`](crate::client::fluent_builders::GetSatellite::set_satellite_id): <p>UUID of a satellite.</p>
    /// - On success, responds with [`GetSatelliteOutput`](crate::output::GetSatelliteOutput) with field(s):
    ///   - [`satellite_id(Option<String>)`](crate::output::GetSatelliteOutput::satellite_id): <p>UUID of a satellite.</p>
    ///   - [`satellite_arn(Option<String>)`](crate::output::GetSatelliteOutput::satellite_arn): <p>ARN of a satellite.</p>
    ///   - [`norad_satellite_id(i32)`](crate::output::GetSatelliteOutput::norad_satellite_id): <p>NORAD satellite ID number.</p>
    ///   - [`ground_stations(Option<Vec<String>>)`](crate::output::GetSatelliteOutput::ground_stations): <p>A list of ground stations to which the satellite is on-boarded.</p>
    /// - On failure, responds with [`SdkError<GetSatelliteError>`](crate::error::GetSatelliteError)
    pub fn get_satellite(&self) -> fluent_builders::GetSatellite {
        fluent_builders::GetSatellite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListConfigs`](crate::client::fluent_builders::ListConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListConfigs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListConfigs::set_max_results): <p>Maximum number of <code>Configs</code> returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListConfigs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListConfigs::set_next_token): <p>Next token returned in the request of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
    /// - On success, responds with [`ListConfigsOutput`](crate::output::ListConfigsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListConfigsOutput::next_token): <p>Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
    ///   - [`config_list(Option<Vec<ConfigListItem>>)`](crate::output::ListConfigsOutput::config_list): <p>List of <code>Config</code> items.</p>
    /// - On failure, responds with [`SdkError<ListConfigsError>`](crate::error::ListConfigsError)
    pub fn list_configs(&self) -> fluent_builders::ListConfigs {
        fluent_builders::ListConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContacts`](crate::client::fluent_builders::ListContacts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContacts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListContacts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListContacts::set_max_results): <p>Maximum number of contacts returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContacts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContacts::set_next_token): <p>Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
    ///   - [`status_list(Vec<ContactStatus>)`](crate::client::fluent_builders::ListContacts::status_list) / [`set_status_list(Option<Vec<ContactStatus>>)`](crate::client::fluent_builders::ListContacts::set_status_list): <p>Status of a contact reservation.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ListContacts::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ListContacts::set_start_time): <p>Start time of a contact.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ListContacts::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ListContacts::set_end_time): <p>End time of a contact.</p>
    ///   - [`ground_station(impl Into<String>)`](crate::client::fluent_builders::ListContacts::ground_station) / [`set_ground_station(Option<String>)`](crate::client::fluent_builders::ListContacts::set_ground_station): <p>Name of a ground station.</p>
    ///   - [`satellite_arn(impl Into<String>)`](crate::client::fluent_builders::ListContacts::satellite_arn) / [`set_satellite_arn(Option<String>)`](crate::client::fluent_builders::ListContacts::set_satellite_arn): <p>ARN of a satellite.</p>
    ///   - [`mission_profile_arn(impl Into<String>)`](crate::client::fluent_builders::ListContacts::mission_profile_arn) / [`set_mission_profile_arn(Option<String>)`](crate::client::fluent_builders::ListContacts::set_mission_profile_arn): <p>ARN of a mission profile.</p>
    /// - On success, responds with [`ListContactsOutput`](crate::output::ListContactsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListContactsOutput::next_token): <p>Next token returned in the response of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
    ///   - [`contact_list(Option<Vec<ContactData>>)`](crate::output::ListContactsOutput::contact_list): <p>List of contacts.</p>
    /// - On failure, responds with [`SdkError<ListContactsError>`](crate::error::ListContactsError)
    pub fn list_contacts(&self) -> fluent_builders::ListContacts {
        fluent_builders::ListContacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDataflowEndpointGroups`](crate::client::fluent_builders::ListDataflowEndpointGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDataflowEndpointGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDataflowEndpointGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDataflowEndpointGroups::set_max_results): <p>Maximum number of dataflow endpoint groups returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDataflowEndpointGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDataflowEndpointGroups::set_next_token): <p>Next token returned in the request of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
    /// - On success, responds with [`ListDataflowEndpointGroupsOutput`](crate::output::ListDataflowEndpointGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListDataflowEndpointGroupsOutput::next_token): <p>Next token returned in the response of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
    ///   - [`dataflow_endpoint_group_list(Option<Vec<DataflowEndpointListItem>>)`](crate::output::ListDataflowEndpointGroupsOutput::dataflow_endpoint_group_list): <p>A list of dataflow endpoint groups.</p>
    /// - On failure, responds with [`SdkError<ListDataflowEndpointGroupsError>`](crate::error::ListDataflowEndpointGroupsError)
    pub fn list_dataflow_endpoint_groups(&self) -> fluent_builders::ListDataflowEndpointGroups {
        fluent_builders::ListDataflowEndpointGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGroundStations`](crate::client::fluent_builders::ListGroundStations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGroundStations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`satellite_id(impl Into<String>)`](crate::client::fluent_builders::ListGroundStations::satellite_id) / [`set_satellite_id(Option<String>)`](crate::client::fluent_builders::ListGroundStations::set_satellite_id): <p>Satellite ID to retrieve on-boarded ground stations.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGroundStations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGroundStations::set_max_results): <p>Maximum number of ground stations returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGroundStations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGroundStations::set_next_token): <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
    /// - On success, responds with [`ListGroundStationsOutput`](crate::output::ListGroundStationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListGroundStationsOutput::next_token): <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
    ///   - [`ground_station_list(Option<Vec<GroundStationData>>)`](crate::output::ListGroundStationsOutput::ground_station_list): <p>List of ground stations.</p>
    /// - On failure, responds with [`SdkError<ListGroundStationsError>`](crate::error::ListGroundStationsError)
    pub fn list_ground_stations(&self) -> fluent_builders::ListGroundStations {
        fluent_builders::ListGroundStations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMissionProfiles`](crate::client::fluent_builders::ListMissionProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMissionProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMissionProfiles::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMissionProfiles::set_max_results): <p>Maximum number of mission profiles returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMissionProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMissionProfiles::set_next_token): <p>Next token returned in the request of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
    /// - On success, responds with [`ListMissionProfilesOutput`](crate::output::ListMissionProfilesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListMissionProfilesOutput::next_token): <p>Next token returned in the response of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
    ///   - [`mission_profile_list(Option<Vec<MissionProfileListItem>>)`](crate::output::ListMissionProfilesOutput::mission_profile_list): <p>List of mission profiles.</p>
    /// - On failure, responds with [`SdkError<ListMissionProfilesError>`](crate::error::ListMissionProfilesError)
    pub fn list_mission_profiles(&self) -> fluent_builders::ListMissionProfiles {
        fluent_builders::ListMissionProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSatellites`](crate::client::fluent_builders::ListSatellites) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSatellites::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSatellites::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSatellites::set_max_results): <p>Maximum number of satellites returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSatellites::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSatellites::set_next_token): <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
    /// - On success, responds with [`ListSatellitesOutput`](crate::output::ListSatellitesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListSatellitesOutput::next_token): <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
    ///   - [`satellites(Option<Vec<SatelliteListItem>>)`](crate::output::ListSatellitesOutput::satellites): <p>List of satellites.</p>
    /// - On failure, responds with [`SdkError<ListSatellitesError>`](crate::error::ListSatellitesError)
    pub fn list_satellites(&self) -> fluent_builders::ListSatellites {
        fluent_builders::ListSatellites::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>ARN of a resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Tags assigned to a resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ReserveContact`](crate::client::fluent_builders::ReserveContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mission_profile_arn(impl Into<String>)`](crate::client::fluent_builders::ReserveContact::mission_profile_arn) / [`set_mission_profile_arn(Option<String>)`](crate::client::fluent_builders::ReserveContact::set_mission_profile_arn): <p>ARN of a mission profile.</p>
    ///   - [`satellite_arn(impl Into<String>)`](crate::client::fluent_builders::ReserveContact::satellite_arn) / [`set_satellite_arn(Option<String>)`](crate::client::fluent_builders::ReserveContact::set_satellite_arn): <p>ARN of a satellite</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ReserveContact::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ReserveContact::set_start_time): <p>Start time of a contact.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ReserveContact::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ReserveContact::set_end_time): <p>End time of a contact.</p>
    ///   - [`ground_station(impl Into<String>)`](crate::client::fluent_builders::ReserveContact::ground_station) / [`set_ground_station(Option<String>)`](crate::client::fluent_builders::ReserveContact::set_ground_station): <p>Name of a ground station.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::ReserveContact::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ReserveContact::set_tags): <p>Tags assigned to a contact.</p>
    /// - On success, responds with [`ReserveContactOutput`](crate::output::ReserveContactOutput) with field(s):
    ///   - [`contact_id(Option<String>)`](crate::output::ReserveContactOutput::contact_id): <p>UUID of a contact.</p>
    /// - On failure, responds with [`SdkError<ReserveContactError>`](crate::error::ReserveContactError)
    pub fn reserve_contact(&self) -> fluent_builders::ReserveContact {
        fluent_builders::ReserveContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>ARN of a resource tag.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Tags assigned to a resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>ARN of a resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Keys of a resource tag.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConfig`](crate::client::fluent_builders::UpdateConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`config_id(impl Into<String>)`](crate::client::fluent_builders::UpdateConfig::config_id) / [`set_config_id(Option<String>)`](crate::client::fluent_builders::UpdateConfig::set_config_id): <p>UUID of a <code>Config</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateConfig::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateConfig::set_name): <p>Name of a <code>Config</code>.</p>
    ///   - [`config_type(ConfigCapabilityType)`](crate::client::fluent_builders::UpdateConfig::config_type) / [`set_config_type(Option<ConfigCapabilityType>)`](crate::client::fluent_builders::UpdateConfig::set_config_type): <p>Type of a <code>Config</code>.</p>
    ///   - [`config_data(ConfigTypeData)`](crate::client::fluent_builders::UpdateConfig::config_data) / [`set_config_data(Option<ConfigTypeData>)`](crate::client::fluent_builders::UpdateConfig::set_config_data): <p>Parameters of a <code>Config</code>.</p>
    /// - On success, responds with [`UpdateConfigOutput`](crate::output::UpdateConfigOutput) with field(s):
    ///   - [`config_id(Option<String>)`](crate::output::UpdateConfigOutput::config_id): <p>UUID of a <code>Config</code>.</p>
    ///   - [`config_type(Option<ConfigCapabilityType>)`](crate::output::UpdateConfigOutput::config_type): <p>Type of a <code>Config</code>.</p>
    ///   - [`config_arn(Option<String>)`](crate::output::UpdateConfigOutput::config_arn): <p>ARN of a <code>Config</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateConfigError>`](crate::error::UpdateConfigError)
    pub fn update_config(&self) -> fluent_builders::UpdateConfig {
        fluent_builders::UpdateConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMissionProfile`](crate::client::fluent_builders::UpdateMissionProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mission_profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMissionProfile::mission_profile_id) / [`set_mission_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateMissionProfile::set_mission_profile_id): <p>UUID of a mission profile.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateMissionProfile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateMissionProfile::set_name): <p>Name of a mission profile.</p>
    ///   - [`contact_pre_pass_duration_seconds(i32)`](crate::client::fluent_builders::UpdateMissionProfile::contact_pre_pass_duration_seconds) / [`set_contact_pre_pass_duration_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateMissionProfile::set_contact_pre_pass_duration_seconds): <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    ///   - [`contact_post_pass_duration_seconds(i32)`](crate::client::fluent_builders::UpdateMissionProfile::contact_post_pass_duration_seconds) / [`set_contact_post_pass_duration_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateMissionProfile::set_contact_post_pass_duration_seconds): <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    ///   - [`minimum_viable_contact_duration_seconds(i32)`](crate::client::fluent_builders::UpdateMissionProfile::minimum_viable_contact_duration_seconds) / [`set_minimum_viable_contact_duration_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateMissionProfile::set_minimum_viable_contact_duration_seconds): <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
    ///   - [`dataflow_edges(Vec<Vec<String>>)`](crate::client::fluent_builders::UpdateMissionProfile::dataflow_edges) / [`set_dataflow_edges(Option<Vec<Vec<String>>>)`](crate::client::fluent_builders::UpdateMissionProfile::set_dataflow_edges): <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i> <code>Config</code>.</p>
    ///   - [`tracking_config_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateMissionProfile::tracking_config_arn) / [`set_tracking_config_arn(Option<String>)`](crate::client::fluent_builders::UpdateMissionProfile::set_tracking_config_arn): <p>ARN of a tracking <code>Config</code>.</p>
    /// - On success, responds with [`UpdateMissionProfileOutput`](crate::output::UpdateMissionProfileOutput) with field(s):
    ///   - [`mission_profile_id(Option<String>)`](crate::output::UpdateMissionProfileOutput::mission_profile_id): <p>UUID of a mission profile.</p>
    /// - On failure, responds with [`SdkError<UpdateMissionProfileError>`](crate::error::UpdateMissionProfileError)
    pub fn update_mission_profile(&self) -> fluent_builders::UpdateMissionProfile {
        fluent_builders::UpdateMissionProfile::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelContact`.
    ///
    /// <p>Cancels a contact with a specified contact ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelContact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_contact_input::Builder,
    }
    impl CancelContact {
        /// Creates a new `CancelContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelContactOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelContactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>UUID of a contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConfig`.
    ///
    /// <p>Creates a <code>Config</code> with the specified <code>configData</code> parameters.</p>
    /// <p>Only one type of <code>configData</code> can be specified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_config_input::Builder,
    }
    impl CreateConfig {
        /// Creates a new `CreateConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn config_data(mut self, input: crate::model::ConfigTypeData) -> Self {
            self.inner = self.inner.config_data(input);
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn set_config_data(
            mut self,
            input: std::option::Option<crate::model::ConfigTypeData>,
        ) -> Self {
            self.inner = self.inner.set_config_data(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a <code>Config</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags assigned to a <code>Config</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataflowEndpointGroup`.
    ///
    /// <p>Creates a <code>DataflowEndpoint</code> group containing the specified list of <code>DataflowEndpoint</code> objects.</p>
    /// <p>The <code>name</code> field in each endpoint is used in your mission profile <code>DataflowEndpointConfig</code> to specify which endpoints to use during a contact.</p>
    /// <p>When a contact uses multiple <code>DataflowEndpointConfig</code> objects, each <code>Config</code> must match a <code>DataflowEndpoint</code> in the same group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataflowEndpointGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_dataflow_endpoint_group_input::Builder,
    }
    impl CreateDataflowEndpointGroup {
        /// Creates a new `CreateDataflowEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataflowEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataflowEndpointGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `endpointDetails`.
        ///
        /// To override the contents of this collection use [`set_endpoint_details`](Self::set_endpoint_details).
        ///
        /// <p>Endpoint details of each endpoint in the dataflow endpoint group.</p>
        pub fn endpoint_details(mut self, input: crate::model::EndpointDetails) -> Self {
            self.inner = self.inner.endpoint_details(input);
            self
        }
        /// <p>Endpoint details of each endpoint in the dataflow endpoint group.</p>
        pub fn set_endpoint_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointDetails>>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_details(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags of a dataflow endpoint group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags of a dataflow endpoint group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMissionProfile`.
    ///
    /// <p>Creates a mission profile.</p>
    /// <p> <code>dataflowEdges</code> is a list of lists of strings. Each lower level list of strings has two elements: a <i>from</i> ARN and a <i>to</i> ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMissionProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_mission_profile_input::Builder,
    }
    impl CreateMissionProfile {
        /// Creates a new `CreateMissionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMissionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMissionProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a mission profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn contact_pre_pass_duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.contact_pre_pass_duration_seconds(input);
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn set_contact_pre_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_contact_pre_pass_duration_seconds(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn contact_post_pass_duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.contact_post_pass_duration_seconds(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_contact_post_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_contact_post_pass_duration_seconds(input);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn minimum_viable_contact_duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.minimum_viable_contact_duration_seconds(input);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn set_minimum_viable_contact_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self
                .inner
                .set_minimum_viable_contact_duration_seconds(input);
            self
        }
        /// Appends an item to `dataflowEdges`.
        ///
        /// To override the contents of this collection use [`set_dataflow_edges`](Self::set_dataflow_edges).
        ///
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i> <code>Config</code>.</p>
        pub fn dataflow_edges(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.dataflow_edges(input);
            self
        }
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i> <code>Config</code>.</p>
        pub fn set_dataflow_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.inner = self.inner.set_dataflow_edges(input);
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn tracking_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracking_config_arn(input.into());
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn set_tracking_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tracking_config_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a mission profile.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags assigned to a mission profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConfig`.
    ///
    /// <p>Deletes a <code>Config</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_config_input::Builder,
    }
    impl DeleteConfig {
        /// Creates a new `DeleteConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.inner = self.inner.config_type(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.inner = self.inner.set_config_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataflowEndpointGroup`.
    ///
    /// <p>Deletes a dataflow endpoint group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataflowEndpointGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_dataflow_endpoint_group_input::Builder,
    }
    impl DeleteDataflowEndpointGroup {
        /// Creates a new `DeleteDataflowEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataflowEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataflowEndpointGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataflow_endpoint_group_id(input.into());
            self
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataflow_endpoint_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMissionProfile`.
    ///
    /// <p>Deletes a mission profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMissionProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_mission_profile_input::Builder,
    }
    impl DeleteMissionProfile {
        /// Creates a new `DeleteMissionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMissionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMissionProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mission_profile_id(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mission_profile_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContact`.
    ///
    /// <p>Describes an existing contact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeContact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_contact_input::Builder,
    }
    impl DescribeContact {
        /// Creates a new `DescribeContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContactOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>UUID of a contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConfig`.
    ///
    /// <p>Returns <code>Config</code> information.</p>
    /// <p>Only one <code>Config</code> response can be returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_config_input::Builder,
    }
    impl GetConfig {
        /// Creates a new `GetConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.inner = self.inner.config_type(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.inner = self.inner.set_config_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataflowEndpointGroup`.
    ///
    /// <p>Returns the dataflow endpoint group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDataflowEndpointGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_dataflow_endpoint_group_input::Builder,
    }
    impl GetDataflowEndpointGroup {
        /// Creates a new `GetDataflowEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataflowEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataflowEndpointGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataflow_endpoint_group_id(input.into());
            self
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dataflow_endpoint_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMinuteUsage`.
    ///
    /// <p>Returns the number of minutes used by account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMinuteUsage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_minute_usage_input::Builder,
    }
    impl GetMinuteUsage {
        /// Creates a new `GetMinuteUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMinuteUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMinuteUsageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The month being requested, with a value of 1-12.</p>
        pub fn month(mut self, input: i32) -> Self {
            self.inner = self.inner.month(input);
            self
        }
        /// <p>The month being requested, with a value of 1-12.</p>
        pub fn set_month(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_month(input);
            self
        }
        /// <p>The year being requested, in the format of YYYY.</p>
        pub fn year(mut self, input: i32) -> Self {
            self.inner = self.inner.year(input);
            self
        }
        /// <p>The year being requested, in the format of YYYY.</p>
        pub fn set_year(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_year(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMissionProfile`.
    ///
    /// <p>Returns a mission profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMissionProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_mission_profile_input::Builder,
    }
    impl GetMissionProfile {
        /// Creates a new `GetMissionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMissionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMissionProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mission_profile_id(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mission_profile_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSatellite`.
    ///
    /// <p>Returns a satellite.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSatellite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_satellite_input::Builder,
    }
    impl GetSatellite {
        /// Creates a new `GetSatellite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSatelliteOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSatelliteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a satellite.</p>
        pub fn satellite_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.satellite_id(input.into());
            self
        }
        /// <p>UUID of a satellite.</p>
        pub fn set_satellite_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_satellite_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConfigs`.
    ///
    /// <p>Returns a list of <code>Config</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_configs_input::Builder,
    }
    impl ListConfigs {
        /// Creates a new `ListConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListConfigsPaginator {
            crate::paginator::ListConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>Maximum number of <code>Configs</code> returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of <code>Configs</code> returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContacts`.
    ///
    /// <p>Returns a list of contacts.</p>
    /// <p>If <code>statusList</code> contains AVAILABLE, the request must include <code>groundStation</code>, <code>missionprofileArn</code>, and <code>satelliteArn</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContacts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_contacts_input::Builder,
    }
    impl ListContacts {
        /// Creates a new `ListContacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContactsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContactsPaginator {
            crate::paginator::ListContactsPaginator::new(self.handle, self.inner)
        }
        /// <p>Maximum number of contacts returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of contacts returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `statusList`.
        ///
        /// To override the contents of this collection use [`set_status_list`](Self::set_status_list).
        ///
        /// <p>Status of a contact reservation.</p>
        pub fn status_list(mut self, input: crate::model::ContactStatus) -> Self {
            self.inner = self.inner.status_list(input);
            self
        }
        /// <p>Status of a contact reservation.</p>
        pub fn set_status_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactStatus>>,
        ) -> Self {
            self.inner = self.inner.set_status_list(input);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn ground_station(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ground_station(input.into());
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn set_ground_station(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ground_station(input);
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn satellite_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.satellite_arn(input.into());
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn set_satellite_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_satellite_arn(input);
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn mission_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mission_profile_arn(input.into());
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn set_mission_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mission_profile_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataflowEndpointGroups`.
    ///
    /// <p>Returns a list of <code>DataflowEndpoint</code> groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataflowEndpointGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_dataflow_endpoint_groups_input::Builder,
    }
    impl ListDataflowEndpointGroups {
        /// Creates a new `ListDataflowEndpointGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataflowEndpointGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataflowEndpointGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDataflowEndpointGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDataflowEndpointGroupsPaginator {
            crate::paginator::ListDataflowEndpointGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>Maximum number of dataflow endpoint groups returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of dataflow endpoint groups returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroundStations`.
    ///
    /// <p>Returns a list of ground stations. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGroundStations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_ground_stations_input::Builder,
    }
    impl ListGroundStations {
        /// Creates a new `ListGroundStations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroundStationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroundStationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGroundStationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGroundStationsPaginator {
            crate::paginator::ListGroundStationsPaginator::new(self.handle, self.inner)
        }
        /// <p>Satellite ID to retrieve on-boarded ground stations.</p>
        pub fn satellite_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.satellite_id(input.into());
            self
        }
        /// <p>Satellite ID to retrieve on-boarded ground stations.</p>
        pub fn set_satellite_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_satellite_id(input);
            self
        }
        /// <p>Maximum number of ground stations returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of ground stations returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMissionProfiles`.
    ///
    /// <p>Returns a list of mission profiles.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMissionProfiles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_mission_profiles_input::Builder,
    }
    impl ListMissionProfiles {
        /// Creates a new `ListMissionProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMissionProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMissionProfilesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMissionProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMissionProfilesPaginator {
            crate::paginator::ListMissionProfilesPaginator::new(self.handle, self.inner)
        }
        /// <p>Maximum number of mission profiles returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of mission profiles returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSatellites`.
    ///
    /// <p>Returns a list of satellites.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSatellites {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_satellites_input::Builder,
    }
    impl ListSatellites {
        /// Creates a new `ListSatellites`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSatellitesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSatellitesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSatellitesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSatellitesPaginator {
            crate::paginator::ListSatellitesPaginator::new(self.handle, self.inner)
        }
        /// <p>Maximum number of satellites returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of satellites returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags for a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>ARN of a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReserveContact`.
    ///
    /// <p>Reserves a contact using specified parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ReserveContact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reserve_contact_input::Builder,
    }
    impl ReserveContact {
        /// Creates a new `ReserveContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReserveContactOutput,
            aws_smithy_http::result::SdkError<crate::error::ReserveContactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of a mission profile.</p>
        pub fn mission_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mission_profile_arn(input.into());
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn set_mission_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mission_profile_arn(input);
            self
        }
        /// <p>ARN of a satellite</p>
        pub fn satellite_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.satellite_arn(input.into());
            self
        }
        /// <p>ARN of a satellite</p>
        pub fn set_satellite_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_satellite_arn(input);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn ground_station(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ground_station(input.into());
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn set_ground_station(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ground_station(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a contact.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags assigned to a contact.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns a tag to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of a resource tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>ARN of a resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags assigned to a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deassigns a resource tag.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ARN of a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>ARN of a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys of a resource tag.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Keys of a resource tag.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConfig`.
    ///
    /// <p>Updates the <code>Config</code> used when scheduling contacts.</p>
    /// <p>Updating a <code>Config</code> will not update the execution parameters for existing future contacts scheduled with this <code>Config</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_config_input::Builder,
    }
    impl UpdateConfig {
        /// Creates a new `UpdateConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.inner = self.inner.config_type(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.inner = self.inner.set_config_type(input);
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn config_data(mut self, input: crate::model::ConfigTypeData) -> Self {
            self.inner = self.inner.config_data(input);
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn set_config_data(
            mut self,
            input: std::option::Option<crate::model::ConfigTypeData>,
        ) -> Self {
            self.inner = self.inner.set_config_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMissionProfile`.
    ///
    /// <p>Updates a mission profile.</p>
    /// <p>Updating a mission profile will not update the execution parameters for existing future contacts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMissionProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_mission_profile_input::Builder,
    }
    impl UpdateMissionProfile {
        /// Creates a new `UpdateMissionProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMissionProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMissionProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mission_profile_id(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mission_profile_id(input);
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn contact_pre_pass_duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.contact_pre_pass_duration_seconds(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_contact_pre_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_contact_pre_pass_duration_seconds(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn contact_post_pass_duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.contact_post_pass_duration_seconds(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_contact_post_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_contact_post_pass_duration_seconds(input);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn minimum_viable_contact_duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.minimum_viable_contact_duration_seconds(input);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn set_minimum_viable_contact_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self
                .inner
                .set_minimum_viable_contact_duration_seconds(input);
            self
        }
        /// Appends an item to `dataflowEdges`.
        ///
        /// To override the contents of this collection use [`set_dataflow_edges`](Self::set_dataflow_edges).
        ///
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i> <code>Config</code>.</p>
        pub fn dataflow_edges(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            self.inner = self.inner.dataflow_edges(input);
            self
        }
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i> <code>Config</code>.</p>
        pub fn set_dataflow_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.inner = self.inner.set_dataflow_edges(input);
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn tracking_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracking_config_arn(input.into());
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn set_tracking_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_tracking_config_arn(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
