// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSatellitesOutput {
    /// <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>List of satellites.</p>
    pub satellites: std::option::Option<std::vec::Vec<crate::model::SatelliteListItem>>,
}
impl std::fmt::Debug for ListSatellitesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSatellitesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("satellites", &self.satellites);
        formatter.finish()
    }
}
/// See [`ListSatellitesOutput`](crate::output::ListSatellitesOutput)
pub mod list_satellites_output {
    /// A builder for [`ListSatellitesOutput`](crate::output::ListSatellitesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) satellites: std::option::Option<std::vec::Vec<crate::model::SatelliteListItem>>,
    }
    impl Builder {
        /// <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `satellites`.
        ///
        /// To override the contents of this collection use [`set_satellites`](Self::set_satellites).
        ///
        /// <p>List of satellites.</p>
        pub fn satellites(mut self, input: impl Into<crate::model::SatelliteListItem>) -> Self {
            let mut v = self.satellites.unwrap_or_default();
            v.push(input.into());
            self.satellites = Some(v);
            self
        }
        /// <p>List of satellites.</p>
        pub fn set_satellites(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SatelliteListItem>>,
        ) -> Self {
            self.satellites = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSatellitesOutput`](crate::output::ListSatellitesOutput)
        pub fn build(self) -> crate::output::ListSatellitesOutput {
            crate::output::ListSatellitesOutput {
                next_token: self.next_token,
                satellites: self.satellites,
            }
        }
    }
}
impl ListSatellitesOutput {
    /// Creates a new builder-style object to manufacture [`ListSatellitesOutput`](crate::output::ListSatellitesOutput)
    pub fn builder() -> crate::output::list_satellites_output::Builder {
        crate::output::list_satellites_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSatelliteOutput {
    /// <p>UUID of a satellite.</p>
    pub satellite_id: std::option::Option<std::string::String>,
    /// <p>ARN of a satellite.</p>
    pub satellite_arn: std::option::Option<std::string::String>,
    /// <p>NORAD satellite ID number.</p>
    pub norad_satellite_id: i32,
    /// <p>A list of ground stations to which the satellite is on-boarded.</p>
    pub ground_stations: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for GetSatelliteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSatelliteOutput");
        formatter.field("satellite_id", &self.satellite_id);
        formatter.field("satellite_arn", &self.satellite_arn);
        formatter.field("norad_satellite_id", &self.norad_satellite_id);
        formatter.field("ground_stations", &self.ground_stations);
        formatter.finish()
    }
}
/// See [`GetSatelliteOutput`](crate::output::GetSatelliteOutput)
pub mod get_satellite_output {
    /// A builder for [`GetSatelliteOutput`](crate::output::GetSatelliteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) satellite_id: std::option::Option<std::string::String>,
        pub(crate) satellite_arn: std::option::Option<std::string::String>,
        pub(crate) norad_satellite_id: std::option::Option<i32>,
        pub(crate) ground_stations: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>UUID of a satellite.</p>
        pub fn satellite_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.satellite_id = Some(input.into());
            self
        }
        /// <p>UUID of a satellite.</p>
        pub fn set_satellite_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.satellite_id = input;
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn satellite_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.satellite_arn = Some(input.into());
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn set_satellite_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.satellite_arn = input;
            self
        }
        /// <p>NORAD satellite ID number.</p>
        pub fn norad_satellite_id(mut self, input: i32) -> Self {
            self.norad_satellite_id = Some(input);
            self
        }
        /// <p>NORAD satellite ID number.</p>
        pub fn set_norad_satellite_id(mut self, input: std::option::Option<i32>) -> Self {
            self.norad_satellite_id = input;
            self
        }
        /// Appends an item to `ground_stations`.
        ///
        /// To override the contents of this collection use [`set_ground_stations`](Self::set_ground_stations).
        ///
        /// <p>A list of ground stations to which the satellite is on-boarded.</p>
        pub fn ground_stations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ground_stations.unwrap_or_default();
            v.push(input.into());
            self.ground_stations = Some(v);
            self
        }
        /// <p>A list of ground stations to which the satellite is on-boarded.</p>
        pub fn set_ground_stations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ground_stations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSatelliteOutput`](crate::output::GetSatelliteOutput)
        pub fn build(self) -> crate::output::GetSatelliteOutput {
            crate::output::GetSatelliteOutput {
                satellite_id: self.satellite_id,
                satellite_arn: self.satellite_arn,
                norad_satellite_id: self.norad_satellite_id.unwrap_or_default(),
                ground_stations: self.ground_stations,
            }
        }
    }
}
impl GetSatelliteOutput {
    /// Creates a new builder-style object to manufacture [`GetSatelliteOutput`](crate::output::GetSatelliteOutput)
    pub fn builder() -> crate::output::get_satellite_output::Builder {
        crate::output::get_satellite_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMissionProfilesOutput {
    /// <p>Next token returned in the response of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>List of mission profiles.</p>
    pub mission_profile_list:
        std::option::Option<std::vec::Vec<crate::model::MissionProfileListItem>>,
}
impl std::fmt::Debug for ListMissionProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMissionProfilesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("mission_profile_list", &self.mission_profile_list);
        formatter.finish()
    }
}
/// See [`ListMissionProfilesOutput`](crate::output::ListMissionProfilesOutput)
pub mod list_mission_profiles_output {
    /// A builder for [`ListMissionProfilesOutput`](crate::output::ListMissionProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) mission_profile_list:
            std::option::Option<std::vec::Vec<crate::model::MissionProfileListItem>>,
    }
    impl Builder {
        /// <p>Next token returned in the response of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token returned in the response of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `mission_profile_list`.
        ///
        /// To override the contents of this collection use [`set_mission_profile_list`](Self::set_mission_profile_list).
        ///
        /// <p>List of mission profiles.</p>
        pub fn mission_profile_list(
            mut self,
            input: impl Into<crate::model::MissionProfileListItem>,
        ) -> Self {
            let mut v = self.mission_profile_list.unwrap_or_default();
            v.push(input.into());
            self.mission_profile_list = Some(v);
            self
        }
        /// <p>List of mission profiles.</p>
        pub fn set_mission_profile_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MissionProfileListItem>>,
        ) -> Self {
            self.mission_profile_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMissionProfilesOutput`](crate::output::ListMissionProfilesOutput)
        pub fn build(self) -> crate::output::ListMissionProfilesOutput {
            crate::output::ListMissionProfilesOutput {
                next_token: self.next_token,
                mission_profile_list: self.mission_profile_list,
            }
        }
    }
}
impl ListMissionProfilesOutput {
    /// Creates a new builder-style object to manufacture [`ListMissionProfilesOutput`](crate::output::ListMissionProfilesOutput)
    pub fn builder() -> crate::output::list_mission_profiles_output::Builder {
        crate::output::list_mission_profiles_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMissionProfileOutput {
    /// <p>UUID of a mission profile.</p>
    pub mission_profile_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateMissionProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMissionProfileOutput");
        formatter.field("mission_profile_id", &self.mission_profile_id);
        formatter.finish()
    }
}
/// See [`CreateMissionProfileOutput`](crate::output::CreateMissionProfileOutput)
pub mod create_mission_profile_output {
    /// A builder for [`CreateMissionProfileOutput`](crate::output::CreateMissionProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mission_profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_id = Some(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMissionProfileOutput`](crate::output::CreateMissionProfileOutput)
        pub fn build(self) -> crate::output::CreateMissionProfileOutput {
            crate::output::CreateMissionProfileOutput {
                mission_profile_id: self.mission_profile_id,
            }
        }
    }
}
impl CreateMissionProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateMissionProfileOutput`](crate::output::CreateMissionProfileOutput)
    pub fn builder() -> crate::output::create_mission_profile_output::Builder {
        crate::output::create_mission_profile_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMissionProfileOutput {
    /// <p>UUID of a mission profile.</p>
    pub mission_profile_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteMissionProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMissionProfileOutput");
        formatter.field("mission_profile_id", &self.mission_profile_id);
        formatter.finish()
    }
}
/// See [`DeleteMissionProfileOutput`](crate::output::DeleteMissionProfileOutput)
pub mod delete_mission_profile_output {
    /// A builder for [`DeleteMissionProfileOutput`](crate::output::DeleteMissionProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mission_profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_id = Some(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMissionProfileOutput`](crate::output::DeleteMissionProfileOutput)
        pub fn build(self) -> crate::output::DeleteMissionProfileOutput {
            crate::output::DeleteMissionProfileOutput {
                mission_profile_id: self.mission_profile_id,
            }
        }
    }
}
impl DeleteMissionProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMissionProfileOutput`](crate::output::DeleteMissionProfileOutput)
    pub fn builder() -> crate::output::delete_mission_profile_output::Builder {
        crate::output::delete_mission_profile_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMissionProfileOutput {
    /// <p>UUID of a mission profile.</p>
    pub mission_profile_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateMissionProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMissionProfileOutput");
        formatter.field("mission_profile_id", &self.mission_profile_id);
        formatter.finish()
    }
}
/// See [`UpdateMissionProfileOutput`](crate::output::UpdateMissionProfileOutput)
pub mod update_mission_profile_output {
    /// A builder for [`UpdateMissionProfileOutput`](crate::output::UpdateMissionProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mission_profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_id = Some(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMissionProfileOutput`](crate::output::UpdateMissionProfileOutput)
        pub fn build(self) -> crate::output::UpdateMissionProfileOutput {
            crate::output::UpdateMissionProfileOutput {
                mission_profile_id: self.mission_profile_id,
            }
        }
    }
}
impl UpdateMissionProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMissionProfileOutput`](crate::output::UpdateMissionProfileOutput)
    pub fn builder() -> crate::output::update_mission_profile_output::Builder {
        crate::output::update_mission_profile_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMissionProfileOutput {
    /// <p>UUID of a mission profile.</p>
    pub mission_profile_id: std::option::Option<std::string::String>,
    /// <p>ARN of a mission profile.</p>
    pub mission_profile_arn: std::option::Option<std::string::String>,
    /// <p>Name of a mission profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Region of a mission profile.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
    pub contact_pre_pass_duration_seconds: std::option::Option<i32>,
    /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    pub contact_post_pass_duration_seconds: std::option::Option<i32>,
    /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
    pub minimum_viable_contact_duration_seconds: std::option::Option<i32>,
    /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
    /// <code>Config</code> and a <i>to</i>
    /// <code>Config</code>.</p>
    pub dataflow_edges: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
    /// <p>ARN of a tracking <code>Config</code>.</p>
    pub tracking_config_arn: std::option::Option<std::string::String>,
    /// <p>Tags assigned to a mission profile.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetMissionProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMissionProfileOutput");
        formatter.field("mission_profile_id", &self.mission_profile_id);
        formatter.field("mission_profile_arn", &self.mission_profile_arn);
        formatter.field("name", &self.name);
        formatter.field("region", &self.region);
        formatter.field(
            "contact_pre_pass_duration_seconds",
            &self.contact_pre_pass_duration_seconds,
        );
        formatter.field(
            "contact_post_pass_duration_seconds",
            &self.contact_post_pass_duration_seconds,
        );
        formatter.field(
            "minimum_viable_contact_duration_seconds",
            &self.minimum_viable_contact_duration_seconds,
        );
        formatter.field("dataflow_edges", &self.dataflow_edges);
        formatter.field("tracking_config_arn", &self.tracking_config_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetMissionProfileOutput`](crate::output::GetMissionProfileOutput)
pub mod get_mission_profile_output {
    /// A builder for [`GetMissionProfileOutput`](crate::output::GetMissionProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mission_profile_id: std::option::Option<std::string::String>,
        pub(crate) mission_profile_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) contact_pre_pass_duration_seconds: std::option::Option<i32>,
        pub(crate) contact_post_pass_duration_seconds: std::option::Option<i32>,
        pub(crate) minimum_viable_contact_duration_seconds: std::option::Option<i32>,
        pub(crate) dataflow_edges:
            std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        pub(crate) tracking_config_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_id = Some(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_id = input;
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn mission_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_arn = Some(input.into());
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn set_mission_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_arn = input;
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Region of a mission profile.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>Region of a mission profile.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn contact_pre_pass_duration_seconds(mut self, input: i32) -> Self {
            self.contact_pre_pass_duration_seconds = Some(input);
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn set_contact_pre_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.contact_pre_pass_duration_seconds = input;
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn contact_post_pass_duration_seconds(mut self, input: i32) -> Self {
            self.contact_post_pass_duration_seconds = Some(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_contact_post_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.contact_post_pass_duration_seconds = input;
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn minimum_viable_contact_duration_seconds(mut self, input: i32) -> Self {
            self.minimum_viable_contact_duration_seconds = Some(input);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn set_minimum_viable_contact_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.minimum_viable_contact_duration_seconds = input;
            self
        }
        /// Appends an item to `dataflow_edges`.
        ///
        /// To override the contents of this collection use [`set_dataflow_edges`](Self::set_dataflow_edges).
        ///
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
        /// <code>Config</code> and a <i>to</i>
        /// <code>Config</code>.</p>
        pub fn dataflow_edges(
            mut self,
            input: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut v = self.dataflow_edges.unwrap_or_default();
            v.push(input.into());
            self.dataflow_edges = Some(v);
            self
        }
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
        /// <code>Config</code> and a <i>to</i>
        /// <code>Config</code>.</p>
        pub fn set_dataflow_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.dataflow_edges = input;
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn tracking_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracking_config_arn = Some(input.into());
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn set_tracking_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tracking_config_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a mission profile.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to a mission profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMissionProfileOutput`](crate::output::GetMissionProfileOutput)
        pub fn build(self) -> crate::output::GetMissionProfileOutput {
            crate::output::GetMissionProfileOutput {
                mission_profile_id: self.mission_profile_id,
                mission_profile_arn: self.mission_profile_arn,
                name: self.name,
                region: self.region,
                contact_pre_pass_duration_seconds: self.contact_pre_pass_duration_seconds,
                contact_post_pass_duration_seconds: self.contact_post_pass_duration_seconds,
                minimum_viable_contact_duration_seconds: self
                    .minimum_viable_contact_duration_seconds,
                dataflow_edges: self.dataflow_edges,
                tracking_config_arn: self.tracking_config_arn,
                tags: self.tags,
            }
        }
    }
}
impl GetMissionProfileOutput {
    /// Creates a new builder-style object to manufacture [`GetMissionProfileOutput`](crate::output::GetMissionProfileOutput)
    pub fn builder() -> crate::output::get_mission_profile_output::Builder {
        crate::output::get_mission_profile_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroundStationsOutput {
    /// <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>List of ground stations.</p>
    pub ground_station_list: std::option::Option<std::vec::Vec<crate::model::GroundStationData>>,
}
impl std::fmt::Debug for ListGroundStationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroundStationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("ground_station_list", &self.ground_station_list);
        formatter.finish()
    }
}
/// See [`ListGroundStationsOutput`](crate::output::ListGroundStationsOutput)
pub mod list_ground_stations_output {
    /// A builder for [`ListGroundStationsOutput`](crate::output::ListGroundStationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) ground_station_list:
            std::option::Option<std::vec::Vec<crate::model::GroundStationData>>,
    }
    impl Builder {
        /// <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `ground_station_list`.
        ///
        /// To override the contents of this collection use [`set_ground_station_list`](Self::set_ground_station_list).
        ///
        /// <p>List of ground stations.</p>
        pub fn ground_station_list(
            mut self,
            input: impl Into<crate::model::GroundStationData>,
        ) -> Self {
            let mut v = self.ground_station_list.unwrap_or_default();
            v.push(input.into());
            self.ground_station_list = Some(v);
            self
        }
        /// <p>List of ground stations.</p>
        pub fn set_ground_station_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroundStationData>>,
        ) -> Self {
            self.ground_station_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroundStationsOutput`](crate::output::ListGroundStationsOutput)
        pub fn build(self) -> crate::output::ListGroundStationsOutput {
            crate::output::ListGroundStationsOutput {
                next_token: self.next_token,
                ground_station_list: self.ground_station_list,
            }
        }
    }
}
impl ListGroundStationsOutput {
    /// Creates a new builder-style object to manufacture [`ListGroundStationsOutput`](crate::output::ListGroundStationsOutput)
    pub fn builder() -> crate::output::list_ground_stations_output::Builder {
        crate::output::list_ground_stations_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataflowEndpointGroupsOutput {
    /// <p>Next token returned in the response of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of dataflow endpoint groups.</p>
    pub dataflow_endpoint_group_list:
        std::option::Option<std::vec::Vec<crate::model::DataflowEndpointListItem>>,
}
impl std::fmt::Debug for ListDataflowEndpointGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataflowEndpointGroupsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "dataflow_endpoint_group_list",
            &self.dataflow_endpoint_group_list,
        );
        formatter.finish()
    }
}
/// See [`ListDataflowEndpointGroupsOutput`](crate::output::ListDataflowEndpointGroupsOutput)
pub mod list_dataflow_endpoint_groups_output {
    /// A builder for [`ListDataflowEndpointGroupsOutput`](crate::output::ListDataflowEndpointGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) dataflow_endpoint_group_list:
            std::option::Option<std::vec::Vec<crate::model::DataflowEndpointListItem>>,
    }
    impl Builder {
        /// <p>Next token returned in the response of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token returned in the response of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `dataflow_endpoint_group_list`.
        ///
        /// To override the contents of this collection use [`set_dataflow_endpoint_group_list`](Self::set_dataflow_endpoint_group_list).
        ///
        /// <p>A list of dataflow endpoint groups.</p>
        pub fn dataflow_endpoint_group_list(
            mut self,
            input: impl Into<crate::model::DataflowEndpointListItem>,
        ) -> Self {
            let mut v = self.dataflow_endpoint_group_list.unwrap_or_default();
            v.push(input.into());
            self.dataflow_endpoint_group_list = Some(v);
            self
        }
        /// <p>A list of dataflow endpoint groups.</p>
        pub fn set_dataflow_endpoint_group_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataflowEndpointListItem>>,
        ) -> Self {
            self.dataflow_endpoint_group_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataflowEndpointGroupsOutput`](crate::output::ListDataflowEndpointGroupsOutput)
        pub fn build(self) -> crate::output::ListDataflowEndpointGroupsOutput {
            crate::output::ListDataflowEndpointGroupsOutput {
                next_token: self.next_token,
                dataflow_endpoint_group_list: self.dataflow_endpoint_group_list,
            }
        }
    }
}
impl ListDataflowEndpointGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListDataflowEndpointGroupsOutput`](crate::output::ListDataflowEndpointGroupsOutput)
    pub fn builder() -> crate::output::list_dataflow_endpoint_groups_output::Builder {
        crate::output::list_dataflow_endpoint_groups_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataflowEndpointGroupOutput {
    /// <p>UUID of a dataflow endpoint group.</p>
    pub dataflow_endpoint_group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateDataflowEndpointGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataflowEndpointGroupOutput");
        formatter.field(
            "dataflow_endpoint_group_id",
            &self.dataflow_endpoint_group_id,
        );
        formatter.finish()
    }
}
/// See [`CreateDataflowEndpointGroupOutput`](crate::output::CreateDataflowEndpointGroupOutput)
pub mod create_dataflow_endpoint_group_output {
    /// A builder for [`CreateDataflowEndpointGroupOutput`](crate::output::CreateDataflowEndpointGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataflow_endpoint_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataflow_endpoint_group_id = Some(input.into());
            self
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataflowEndpointGroupOutput`](crate::output::CreateDataflowEndpointGroupOutput)
        pub fn build(self) -> crate::output::CreateDataflowEndpointGroupOutput {
            crate::output::CreateDataflowEndpointGroupOutput {
                dataflow_endpoint_group_id: self.dataflow_endpoint_group_id,
            }
        }
    }
}
impl CreateDataflowEndpointGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDataflowEndpointGroupOutput`](crate::output::CreateDataflowEndpointGroupOutput)
    pub fn builder() -> crate::output::create_dataflow_endpoint_group_output::Builder {
        crate::output::create_dataflow_endpoint_group_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataflowEndpointGroupOutput {
    /// <p>UUID of a dataflow endpoint group.</p>
    pub dataflow_endpoint_group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDataflowEndpointGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataflowEndpointGroupOutput");
        formatter.field(
            "dataflow_endpoint_group_id",
            &self.dataflow_endpoint_group_id,
        );
        formatter.finish()
    }
}
/// See [`DeleteDataflowEndpointGroupOutput`](crate::output::DeleteDataflowEndpointGroupOutput)
pub mod delete_dataflow_endpoint_group_output {
    /// A builder for [`DeleteDataflowEndpointGroupOutput`](crate::output::DeleteDataflowEndpointGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataflow_endpoint_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataflow_endpoint_group_id = Some(input.into());
            self
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataflowEndpointGroupOutput`](crate::output::DeleteDataflowEndpointGroupOutput)
        pub fn build(self) -> crate::output::DeleteDataflowEndpointGroupOutput {
            crate::output::DeleteDataflowEndpointGroupOutput {
                dataflow_endpoint_group_id: self.dataflow_endpoint_group_id,
            }
        }
    }
}
impl DeleteDataflowEndpointGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDataflowEndpointGroupOutput`](crate::output::DeleteDataflowEndpointGroupOutput)
    pub fn builder() -> crate::output::delete_dataflow_endpoint_group_output::Builder {
        crate::output::delete_dataflow_endpoint_group_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataflowEndpointGroupOutput {
    /// <p>UUID of a dataflow endpoint group.</p>
    pub dataflow_endpoint_group_id: std::option::Option<std::string::String>,
    /// <p>ARN of a dataflow endpoint group.</p>
    pub dataflow_endpoint_group_arn: std::option::Option<std::string::String>,
    /// <p>Details of a dataflow endpoint.</p>
    pub endpoints_details: std::option::Option<std::vec::Vec<crate::model::EndpointDetails>>,
    /// <p>Tags assigned to a dataflow endpoint group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetDataflowEndpointGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataflowEndpointGroupOutput");
        formatter.field(
            "dataflow_endpoint_group_id",
            &self.dataflow_endpoint_group_id,
        );
        formatter.field(
            "dataflow_endpoint_group_arn",
            &self.dataflow_endpoint_group_arn,
        );
        formatter.field("endpoints_details", &self.endpoints_details);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetDataflowEndpointGroupOutput`](crate::output::GetDataflowEndpointGroupOutput)
pub mod get_dataflow_endpoint_group_output {
    /// A builder for [`GetDataflowEndpointGroupOutput`](crate::output::GetDataflowEndpointGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataflow_endpoint_group_id: std::option::Option<std::string::String>,
        pub(crate) dataflow_endpoint_group_arn: std::option::Option<std::string::String>,
        pub(crate) endpoints_details:
            std::option::Option<std::vec::Vec<crate::model::EndpointDetails>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataflow_endpoint_group_id = Some(input.into());
            self
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_group_id = input;
            self
        }
        /// <p>ARN of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>ARN of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_group_arn = input;
            self
        }
        /// Appends an item to `endpoints_details`.
        ///
        /// To override the contents of this collection use [`set_endpoints_details`](Self::set_endpoints_details).
        ///
        /// <p>Details of a dataflow endpoint.</p>
        pub fn endpoints_details(
            mut self,
            input: impl Into<crate::model::EndpointDetails>,
        ) -> Self {
            let mut v = self.endpoints_details.unwrap_or_default();
            v.push(input.into());
            self.endpoints_details = Some(v);
            self
        }
        /// <p>Details of a dataflow endpoint.</p>
        pub fn set_endpoints_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointDetails>>,
        ) -> Self {
            self.endpoints_details = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a dataflow endpoint group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to a dataflow endpoint group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataflowEndpointGroupOutput`](crate::output::GetDataflowEndpointGroupOutput)
        pub fn build(self) -> crate::output::GetDataflowEndpointGroupOutput {
            crate::output::GetDataflowEndpointGroupOutput {
                dataflow_endpoint_group_id: self.dataflow_endpoint_group_id,
                dataflow_endpoint_group_arn: self.dataflow_endpoint_group_arn,
                endpoints_details: self.endpoints_details,
                tags: self.tags,
            }
        }
    }
}
impl GetDataflowEndpointGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetDataflowEndpointGroupOutput`](crate::output::GetDataflowEndpointGroupOutput)
    pub fn builder() -> crate::output::get_dataflow_endpoint_group_output::Builder {
        crate::output::get_dataflow_endpoint_group_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContactsOutput {
    /// <p>Next token returned in the response of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>List of contacts.</p>
    pub contact_list: std::option::Option<std::vec::Vec<crate::model::ContactData>>,
}
impl std::fmt::Debug for ListContactsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContactsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("contact_list", &self.contact_list);
        formatter.finish()
    }
}
/// See [`ListContactsOutput`](crate::output::ListContactsOutput)
pub mod list_contacts_output {
    /// A builder for [`ListContactsOutput`](crate::output::ListContactsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) contact_list: std::option::Option<std::vec::Vec<crate::model::ContactData>>,
    }
    impl Builder {
        /// <p>Next token returned in the response of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token returned in the response of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `contact_list`.
        ///
        /// To override the contents of this collection use [`set_contact_list`](Self::set_contact_list).
        ///
        /// <p>List of contacts.</p>
        pub fn contact_list(mut self, input: impl Into<crate::model::ContactData>) -> Self {
            let mut v = self.contact_list.unwrap_or_default();
            v.push(input.into());
            self.contact_list = Some(v);
            self
        }
        /// <p>List of contacts.</p>
        pub fn set_contact_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactData>>,
        ) -> Self {
            self.contact_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactsOutput`](crate::output::ListContactsOutput)
        pub fn build(self) -> crate::output::ListContactsOutput {
            crate::output::ListContactsOutput {
                next_token: self.next_token,
                contact_list: self.contact_list,
            }
        }
    }
}
impl ListContactsOutput {
    /// Creates a new builder-style object to manufacture [`ListContactsOutput`](crate::output::ListContactsOutput)
    pub fn builder() -> crate::output::list_contacts_output::Builder {
        crate::output::list_contacts_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReserveContactOutput {
    /// <p>UUID of a contact.</p>
    pub contact_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReserveContactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReserveContactOutput");
        formatter.field("contact_id", &self.contact_id);
        formatter.finish()
    }
}
/// See [`ReserveContactOutput`](crate::output::ReserveContactOutput)
pub mod reserve_contact_output {
    /// A builder for [`ReserveContactOutput`](crate::output::ReserveContactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>UUID of a contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ReserveContactOutput`](crate::output::ReserveContactOutput)
        pub fn build(self) -> crate::output::ReserveContactOutput {
            crate::output::ReserveContactOutput {
                contact_id: self.contact_id,
            }
        }
    }
}
impl ReserveContactOutput {
    /// Creates a new builder-style object to manufacture [`ReserveContactOutput`](crate::output::ReserveContactOutput)
    pub fn builder() -> crate::output::reserve_contact_output::Builder {
        crate::output::reserve_contact_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelContactOutput {
    /// <p>UUID of a contact.</p>
    pub contact_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelContactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelContactOutput");
        formatter.field("contact_id", &self.contact_id);
        formatter.finish()
    }
}
/// See [`CancelContactOutput`](crate::output::CancelContactOutput)
pub mod cancel_contact_output {
    /// A builder for [`CancelContactOutput`](crate::output::CancelContactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>UUID of a contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelContactOutput`](crate::output::CancelContactOutput)
        pub fn build(self) -> crate::output::CancelContactOutput {
            crate::output::CancelContactOutput {
                contact_id: self.contact_id,
            }
        }
    }
}
impl CancelContactOutput {
    /// Creates a new builder-style object to manufacture [`CancelContactOutput`](crate::output::CancelContactOutput)
    pub fn builder() -> crate::output::cancel_contact_output::Builder {
        crate::output::cancel_contact_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeContactOutput {
    /// <p>UUID of a contact.</p>
    pub contact_id: std::option::Option<std::string::String>,
    /// <p>ARN of a mission profile.</p>
    pub mission_profile_arn: std::option::Option<std::string::String>,
    /// <p>ARN of a satellite.</p>
    pub satellite_arn: std::option::Option<std::string::String>,
    /// <p>Start time of a contact.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>End time of a contact.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
    pub pre_pass_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    pub post_pass_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Ground station for a contact.</p>
    pub ground_station: std::option::Option<std::string::String>,
    /// <p>Status of a contact.</p>
    pub contact_status: std::option::Option<crate::model::ContactStatus>,
    /// <p>Error message for a contact.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>Maximum elevation angle of a contact.</p>
    pub maximum_elevation: std::option::Option<crate::model::Elevation>,
    /// <p>Tags assigned to a contact.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Region of a contact.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>List describing source and destination details for each dataflow edge.</p>
    pub dataflow_list: std::option::Option<std::vec::Vec<crate::model::DataflowDetail>>,
}
impl std::fmt::Debug for DescribeContactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeContactOutput");
        formatter.field("contact_id", &self.contact_id);
        formatter.field("mission_profile_arn", &self.mission_profile_arn);
        formatter.field("satellite_arn", &self.satellite_arn);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("pre_pass_start_time", &self.pre_pass_start_time);
        formatter.field("post_pass_end_time", &self.post_pass_end_time);
        formatter.field("ground_station", &self.ground_station);
        formatter.field("contact_status", &self.contact_status);
        formatter.field("error_message", &self.error_message);
        formatter.field("maximum_elevation", &self.maximum_elevation);
        formatter.field("tags", &self.tags);
        formatter.field("region", &self.region);
        formatter.field("dataflow_list", &self.dataflow_list);
        formatter.finish()
    }
}
/// See [`DescribeContactOutput`](crate::output::DescribeContactOutput)
pub mod describe_contact_output {
    /// A builder for [`DescribeContactOutput`](crate::output::DescribeContactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) mission_profile_arn: std::option::Option<std::string::String>,
        pub(crate) satellite_arn: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) pre_pass_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) post_pass_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ground_station: std::option::Option<std::string::String>,
        pub(crate) contact_status: std::option::Option<crate::model::ContactStatus>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) maximum_elevation: std::option::Option<crate::model::Elevation>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) dataflow_list: std::option::Option<std::vec::Vec<crate::model::DataflowDetail>>,
    }
    impl Builder {
        /// <p>UUID of a contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>UUID of a contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn mission_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_arn = Some(input.into());
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn set_mission_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_arn = input;
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn satellite_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.satellite_arn = Some(input.into());
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn set_satellite_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.satellite_arn = input;
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>End time of a contact.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn pre_pass_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.pre_pass_start_time = Some(input);
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn set_pre_pass_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.pre_pass_start_time = input;
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn post_pass_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.post_pass_end_time = Some(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_post_pass_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.post_pass_end_time = input;
            self
        }
        /// <p>Ground station for a contact.</p>
        pub fn ground_station(mut self, input: impl Into<std::string::String>) -> Self {
            self.ground_station = Some(input.into());
            self
        }
        /// <p>Ground station for a contact.</p>
        pub fn set_ground_station(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ground_station = input;
            self
        }
        /// <p>Status of a contact.</p>
        pub fn contact_status(mut self, input: crate::model::ContactStatus) -> Self {
            self.contact_status = Some(input);
            self
        }
        /// <p>Status of a contact.</p>
        pub fn set_contact_status(
            mut self,
            input: std::option::Option<crate::model::ContactStatus>,
        ) -> Self {
            self.contact_status = input;
            self
        }
        /// <p>Error message for a contact.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Error message for a contact.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>Maximum elevation angle of a contact.</p>
        pub fn maximum_elevation(mut self, input: crate::model::Elevation) -> Self {
            self.maximum_elevation = Some(input);
            self
        }
        /// <p>Maximum elevation angle of a contact.</p>
        pub fn set_maximum_elevation(
            mut self,
            input: std::option::Option<crate::model::Elevation>,
        ) -> Self {
            self.maximum_elevation = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a contact.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to a contact.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Region of a contact.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>Region of a contact.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Appends an item to `dataflow_list`.
        ///
        /// To override the contents of this collection use [`set_dataflow_list`](Self::set_dataflow_list).
        ///
        /// <p>List describing source and destination details for each dataflow edge.</p>
        pub fn dataflow_list(mut self, input: impl Into<crate::model::DataflowDetail>) -> Self {
            let mut v = self.dataflow_list.unwrap_or_default();
            v.push(input.into());
            self.dataflow_list = Some(v);
            self
        }
        /// <p>List describing source and destination details for each dataflow edge.</p>
        pub fn set_dataflow_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataflowDetail>>,
        ) -> Self {
            self.dataflow_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContactOutput`](crate::output::DescribeContactOutput)
        pub fn build(self) -> crate::output::DescribeContactOutput {
            crate::output::DescribeContactOutput {
                contact_id: self.contact_id,
                mission_profile_arn: self.mission_profile_arn,
                satellite_arn: self.satellite_arn,
                start_time: self.start_time,
                end_time: self.end_time,
                pre_pass_start_time: self.pre_pass_start_time,
                post_pass_end_time: self.post_pass_end_time,
                ground_station: self.ground_station,
                contact_status: self.contact_status,
                error_message: self.error_message,
                maximum_elevation: self.maximum_elevation,
                tags: self.tags,
                region: self.region,
                dataflow_list: self.dataflow_list,
            }
        }
    }
}
impl DescribeContactOutput {
    /// Creates a new builder-style object to manufacture [`DescribeContactOutput`](crate::output::DescribeContactOutput)
    pub fn builder() -> crate::output::describe_contact_output::Builder {
        crate::output::describe_contact_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigsOutput {
    /// <p>Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>List of <code>Config</code> items.</p>
    pub config_list: std::option::Option<std::vec::Vec<crate::model::ConfigListItem>>,
}
impl std::fmt::Debug for ListConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("config_list", &self.config_list);
        formatter.finish()
    }
}
/// See [`ListConfigsOutput`](crate::output::ListConfigsOutput)
pub mod list_configs_output {
    /// A builder for [`ListConfigsOutput`](crate::output::ListConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) config_list: std::option::Option<std::vec::Vec<crate::model::ConfigListItem>>,
    }
    impl Builder {
        /// <p>Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `config_list`.
        ///
        /// To override the contents of this collection use [`set_config_list`](Self::set_config_list).
        ///
        /// <p>List of <code>Config</code> items.</p>
        pub fn config_list(mut self, input: impl Into<crate::model::ConfigListItem>) -> Self {
            let mut v = self.config_list.unwrap_or_default();
            v.push(input.into());
            self.config_list = Some(v);
            self
        }
        /// <p>List of <code>Config</code> items.</p>
        pub fn set_config_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigListItem>>,
        ) -> Self {
            self.config_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigsOutput`](crate::output::ListConfigsOutput)
        pub fn build(self) -> crate::output::ListConfigsOutput {
            crate::output::ListConfigsOutput {
                next_token: self.next_token,
                config_list: self.config_list,
            }
        }
    }
}
impl ListConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListConfigsOutput`](crate::output::ListConfigsOutput)
    pub fn builder() -> crate::output::list_configs_output::Builder {
        crate::output::list_configs_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigOutput {
    /// <p>UUID of a <code>Config</code>.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>Type of a <code>Config</code>.</p>
    pub config_type: std::option::Option<crate::model::ConfigCapabilityType>,
    /// <p>ARN of a <code>Config</code>.</p>
    pub config_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigOutput");
        formatter.field("config_id", &self.config_id);
        formatter.field("config_type", &self.config_type);
        formatter.field("config_arn", &self.config_arn);
        formatter.finish()
    }
}
/// See [`CreateConfigOutput`](crate::output::CreateConfigOutput)
pub mod create_config_output {
    /// A builder for [`CreateConfigOutput`](crate::output::CreateConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) config_type: std::option::Option<crate::model::ConfigCapabilityType>,
        pub(crate) config_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.config_type = Some(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.config_type = input;
            self
        }
        /// <p>ARN of a <code>Config</code>.</p>
        pub fn config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_arn = Some(input.into());
            self
        }
        /// <p>ARN of a <code>Config</code>.</p>
        pub fn set_config_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigOutput`](crate::output::CreateConfigOutput)
        pub fn build(self) -> crate::output::CreateConfigOutput {
            crate::output::CreateConfigOutput {
                config_id: self.config_id,
                config_type: self.config_type,
                config_arn: self.config_arn,
            }
        }
    }
}
impl CreateConfigOutput {
    /// Creates a new builder-style object to manufacture [`CreateConfigOutput`](crate::output::CreateConfigOutput)
    pub fn builder() -> crate::output::create_config_output::Builder {
        crate::output::create_config_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigOutput {
    /// <p>UUID of a <code>Config</code>.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>Type of a <code>Config</code>.</p>
    pub config_type: std::option::Option<crate::model::ConfigCapabilityType>,
    /// <p>ARN of a <code>Config</code>.</p>
    pub config_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigOutput");
        formatter.field("config_id", &self.config_id);
        formatter.field("config_type", &self.config_type);
        formatter.field("config_arn", &self.config_arn);
        formatter.finish()
    }
}
/// See [`DeleteConfigOutput`](crate::output::DeleteConfigOutput)
pub mod delete_config_output {
    /// A builder for [`DeleteConfigOutput`](crate::output::DeleteConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) config_type: std::option::Option<crate::model::ConfigCapabilityType>,
        pub(crate) config_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.config_type = Some(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.config_type = input;
            self
        }
        /// <p>ARN of a <code>Config</code>.</p>
        pub fn config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_arn = Some(input.into());
            self
        }
        /// <p>ARN of a <code>Config</code>.</p>
        pub fn set_config_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigOutput`](crate::output::DeleteConfigOutput)
        pub fn build(self) -> crate::output::DeleteConfigOutput {
            crate::output::DeleteConfigOutput {
                config_id: self.config_id,
                config_type: self.config_type,
                config_arn: self.config_arn,
            }
        }
    }
}
impl DeleteConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConfigOutput`](crate::output::DeleteConfigOutput)
    pub fn builder() -> crate::output::delete_config_output::Builder {
        crate::output::delete_config_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigOutput {
    /// <p>UUID of a <code>Config</code>.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>Type of a <code>Config</code>.</p>
    pub config_type: std::option::Option<crate::model::ConfigCapabilityType>,
    /// <p>ARN of a <code>Config</code>.</p>
    pub config_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigOutput");
        formatter.field("config_id", &self.config_id);
        formatter.field("config_type", &self.config_type);
        formatter.field("config_arn", &self.config_arn);
        formatter.finish()
    }
}
/// See [`UpdateConfigOutput`](crate::output::UpdateConfigOutput)
pub mod update_config_output {
    /// A builder for [`UpdateConfigOutput`](crate::output::UpdateConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) config_type: std::option::Option<crate::model::ConfigCapabilityType>,
        pub(crate) config_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.config_type = Some(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.config_type = input;
            self
        }
        /// <p>ARN of a <code>Config</code>.</p>
        pub fn config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_arn = Some(input.into());
            self
        }
        /// <p>ARN of a <code>Config</code>.</p>
        pub fn set_config_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigOutput`](crate::output::UpdateConfigOutput)
        pub fn build(self) -> crate::output::UpdateConfigOutput {
            crate::output::UpdateConfigOutput {
                config_id: self.config_id,
                config_type: self.config_type,
                config_arn: self.config_arn,
            }
        }
    }
}
impl UpdateConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConfigOutput`](crate::output::UpdateConfigOutput)
    pub fn builder() -> crate::output::update_config_output::Builder {
        crate::output::update_config_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigOutput {
    /// <p>UUID of a <code>Config</code>.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>ARN of a <code>Config</code>
    /// </p>
    pub config_arn: std::option::Option<std::string::String>,
    /// <p>Name of a <code>Config</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Type of a <code>Config</code>.</p>
    pub config_type: std::option::Option<crate::model::ConfigCapabilityType>,
    /// <p>Data elements in a <code>Config</code>.</p>
    pub config_data: std::option::Option<crate::model::ConfigTypeData>,
    /// <p>Tags assigned to a <code>Config</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigOutput");
        formatter.field("config_id", &self.config_id);
        formatter.field("config_arn", &self.config_arn);
        formatter.field("name", &self.name);
        formatter.field("config_type", &self.config_type);
        formatter.field("config_data", &self.config_data);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetConfigOutput`](crate::output::GetConfigOutput)
pub mod get_config_output {
    /// A builder for [`GetConfigOutput`](crate::output::GetConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) config_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) config_type: std::option::Option<crate::model::ConfigCapabilityType>,
        pub(crate) config_data: std::option::Option<crate::model::ConfigTypeData>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>ARN of a <code>Config</code>
        /// </p>
        pub fn config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_arn = Some(input.into());
            self
        }
        /// <p>ARN of a <code>Config</code>
        /// </p>
        pub fn set_config_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_arn = input;
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.config_type = Some(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.config_type = input;
            self
        }
        /// <p>Data elements in a <code>Config</code>.</p>
        pub fn config_data(mut self, input: crate::model::ConfigTypeData) -> Self {
            self.config_data = Some(input);
            self
        }
        /// <p>Data elements in a <code>Config</code>.</p>
        pub fn set_config_data(
            mut self,
            input: std::option::Option<crate::model::ConfigTypeData>,
        ) -> Self {
            self.config_data = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a <code>Config</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to a <code>Config</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigOutput`](crate::output::GetConfigOutput)
        pub fn build(self) -> crate::output::GetConfigOutput {
            crate::output::GetConfigOutput {
                config_id: self.config_id,
                config_arn: self.config_arn,
                name: self.name,
                config_type: self.config_type,
                config_data: self.config_data,
                tags: self.tags,
            }
        }
    }
}
impl GetConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetConfigOutput`](crate::output::GetConfigOutput)
    pub fn builder() -> crate::output::get_config_output::Builder {
        crate::output::get_config_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Tags assigned to a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMinuteUsageOutput {
    /// <p>Returns whether or not an account has signed up for the reserved minutes pricing plan, specific to the month being requested.</p>
    pub is_reserved_minutes_customer: std::option::Option<bool>,
    /// <p>Total number of reserved minutes allocated, specific to the month being requested.</p>
    pub total_reserved_minute_allocation: std::option::Option<i32>,
    /// <p>Upcoming minutes scheduled for an account, specific to the month being requested.</p>
    pub upcoming_minutes_scheduled: std::option::Option<i32>,
    /// <p>Total scheduled minutes for an account, specific to the month being requested.</p>
    pub total_scheduled_minutes: std::option::Option<i32>,
    /// <p>Estimated number of minutes remaining for an account, specific to the month being requested.</p>
    pub estimated_minutes_remaining: std::option::Option<i32>,
}
impl std::fmt::Debug for GetMinuteUsageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMinuteUsageOutput");
        formatter.field(
            "is_reserved_minutes_customer",
            &self.is_reserved_minutes_customer,
        );
        formatter.field(
            "total_reserved_minute_allocation",
            &self.total_reserved_minute_allocation,
        );
        formatter.field(
            "upcoming_minutes_scheduled",
            &self.upcoming_minutes_scheduled,
        );
        formatter.field("total_scheduled_minutes", &self.total_scheduled_minutes);
        formatter.field(
            "estimated_minutes_remaining",
            &self.estimated_minutes_remaining,
        );
        formatter.finish()
    }
}
/// See [`GetMinuteUsageOutput`](crate::output::GetMinuteUsageOutput)
pub mod get_minute_usage_output {
    /// A builder for [`GetMinuteUsageOutput`](crate::output::GetMinuteUsageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_reserved_minutes_customer: std::option::Option<bool>,
        pub(crate) total_reserved_minute_allocation: std::option::Option<i32>,
        pub(crate) upcoming_minutes_scheduled: std::option::Option<i32>,
        pub(crate) total_scheduled_minutes: std::option::Option<i32>,
        pub(crate) estimated_minutes_remaining: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Returns whether or not an account has signed up for the reserved minutes pricing plan, specific to the month being requested.</p>
        pub fn is_reserved_minutes_customer(mut self, input: bool) -> Self {
            self.is_reserved_minutes_customer = Some(input);
            self
        }
        /// <p>Returns whether or not an account has signed up for the reserved minutes pricing plan, specific to the month being requested.</p>
        pub fn set_is_reserved_minutes_customer(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_reserved_minutes_customer = input;
            self
        }
        /// <p>Total number of reserved minutes allocated, specific to the month being requested.</p>
        pub fn total_reserved_minute_allocation(mut self, input: i32) -> Self {
            self.total_reserved_minute_allocation = Some(input);
            self
        }
        /// <p>Total number of reserved minutes allocated, specific to the month being requested.</p>
        pub fn set_total_reserved_minute_allocation(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.total_reserved_minute_allocation = input;
            self
        }
        /// <p>Upcoming minutes scheduled for an account, specific to the month being requested.</p>
        pub fn upcoming_minutes_scheduled(mut self, input: i32) -> Self {
            self.upcoming_minutes_scheduled = Some(input);
            self
        }
        /// <p>Upcoming minutes scheduled for an account, specific to the month being requested.</p>
        pub fn set_upcoming_minutes_scheduled(mut self, input: std::option::Option<i32>) -> Self {
            self.upcoming_minutes_scheduled = input;
            self
        }
        /// <p>Total scheduled minutes for an account, specific to the month being requested.</p>
        pub fn total_scheduled_minutes(mut self, input: i32) -> Self {
            self.total_scheduled_minutes = Some(input);
            self
        }
        /// <p>Total scheduled minutes for an account, specific to the month being requested.</p>
        pub fn set_total_scheduled_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.total_scheduled_minutes = input;
            self
        }
        /// <p>Estimated number of minutes remaining for an account, specific to the month being requested.</p>
        pub fn estimated_minutes_remaining(mut self, input: i32) -> Self {
            self.estimated_minutes_remaining = Some(input);
            self
        }
        /// <p>Estimated number of minutes remaining for an account, specific to the month being requested.</p>
        pub fn set_estimated_minutes_remaining(mut self, input: std::option::Option<i32>) -> Self {
            self.estimated_minutes_remaining = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMinuteUsageOutput`](crate::output::GetMinuteUsageOutput)
        pub fn build(self) -> crate::output::GetMinuteUsageOutput {
            crate::output::GetMinuteUsageOutput {
                is_reserved_minutes_customer: self.is_reserved_minutes_customer,
                total_reserved_minute_allocation: self.total_reserved_minute_allocation,
                upcoming_minutes_scheduled: self.upcoming_minutes_scheduled,
                total_scheduled_minutes: self.total_scheduled_minutes,
                estimated_minutes_remaining: self.estimated_minutes_remaining,
            }
        }
    }
}
impl GetMinuteUsageOutput {
    /// Creates a new builder-style object to manufacture [`GetMinuteUsageOutput`](crate::output::GetMinuteUsageOutput)
    pub fn builder() -> crate::output::get_minute_usage_output::Builder {
        crate::output::get_minute_usage_output::Builder::default()
    }
}
