// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Item in a list of satellites.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SatelliteListItem {
    /// <p>UUID of a satellite.</p>
    pub satellite_id: std::option::Option<std::string::String>,
    /// <p>ARN of a satellite.</p>
    pub satellite_arn: std::option::Option<std::string::String>,
    /// <p>NORAD satellite ID number.</p>
    pub norad_satellite_id: i32,
    /// <p>A list of ground stations to which the satellite is on-boarded.</p>
    pub ground_stations: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for SatelliteListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SatelliteListItem");
        formatter.field("satellite_id", &self.satellite_id);
        formatter.field("satellite_arn", &self.satellite_arn);
        formatter.field("norad_satellite_id", &self.norad_satellite_id);
        formatter.field("ground_stations", &self.ground_stations);
        formatter.finish()
    }
}
/// See [`SatelliteListItem`](crate::model::SatelliteListItem)
pub mod satellite_list_item {
    /// A builder for [`SatelliteListItem`](crate::model::SatelliteListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) satellite_id: std::option::Option<std::string::String>,
        pub(crate) satellite_arn: std::option::Option<std::string::String>,
        pub(crate) norad_satellite_id: std::option::Option<i32>,
        pub(crate) ground_stations: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>UUID of a satellite.</p>
        pub fn satellite_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.satellite_id = Some(input.into());
            self
        }
        /// <p>UUID of a satellite.</p>
        pub fn set_satellite_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.satellite_id = input;
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn satellite_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.satellite_arn = Some(input.into());
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn set_satellite_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.satellite_arn = input;
            self
        }
        /// <p>NORAD satellite ID number.</p>
        pub fn norad_satellite_id(mut self, input: i32) -> Self {
            self.norad_satellite_id = Some(input);
            self
        }
        /// <p>NORAD satellite ID number.</p>
        pub fn set_norad_satellite_id(mut self, input: std::option::Option<i32>) -> Self {
            self.norad_satellite_id = input;
            self
        }
        /// Appends an item to `ground_stations`.
        ///
        /// To override the contents of this collection use [`set_ground_stations`](Self::set_ground_stations).
        ///
        /// <p>A list of ground stations to which the satellite is on-boarded.</p>
        pub fn ground_stations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ground_stations.unwrap_or_default();
            v.push(input.into());
            self.ground_stations = Some(v);
            self
        }
        /// <p>A list of ground stations to which the satellite is on-boarded.</p>
        pub fn set_ground_stations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ground_stations = input;
            self
        }
        /// Consumes the builder and constructs a [`SatelliteListItem`](crate::model::SatelliteListItem)
        pub fn build(self) -> crate::model::SatelliteListItem {
            crate::model::SatelliteListItem {
                satellite_id: self.satellite_id,
                satellite_arn: self.satellite_arn,
                norad_satellite_id: self.norad_satellite_id.unwrap_or_default(),
                ground_stations: self.ground_stations,
            }
        }
    }
}
impl SatelliteListItem {
    /// Creates a new builder-style object to manufacture [`SatelliteListItem`](crate::model::SatelliteListItem)
    pub fn builder() -> crate::model::satellite_list_item::Builder {
        crate::model::satellite_list_item::Builder::default()
    }
}

/// <p>Item in a list of mission profiles.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissionProfileListItem {
    /// <p>UUID of a mission profile.</p>
    pub mission_profile_id: std::option::Option<std::string::String>,
    /// <p>ARN of a mission profile.</p>
    pub mission_profile_arn: std::option::Option<std::string::String>,
    /// <p>Region of a mission profile.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Name of a mission profile.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissionProfileListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissionProfileListItem");
        formatter.field("mission_profile_id", &self.mission_profile_id);
        formatter.field("mission_profile_arn", &self.mission_profile_arn);
        formatter.field("region", &self.region);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`MissionProfileListItem`](crate::model::MissionProfileListItem)
pub mod mission_profile_list_item {
    /// A builder for [`MissionProfileListItem`](crate::model::MissionProfileListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mission_profile_id: std::option::Option<std::string::String>,
        pub(crate) mission_profile_arn: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_id = Some(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_id = input;
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn mission_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_arn = Some(input.into());
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn set_mission_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_arn = input;
            self
        }
        /// <p>Region of a mission profile.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>Region of a mission profile.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`MissionProfileListItem`](crate::model::MissionProfileListItem)
        pub fn build(self) -> crate::model::MissionProfileListItem {
            crate::model::MissionProfileListItem {
                mission_profile_id: self.mission_profile_id,
                mission_profile_arn: self.mission_profile_arn,
                region: self.region,
                name: self.name,
            }
        }
    }
}
impl MissionProfileListItem {
    /// Creates a new builder-style object to manufacture [`MissionProfileListItem`](crate::model::MissionProfileListItem)
    pub fn builder() -> crate::model::mission_profile_list_item::Builder {
        crate::model::mission_profile_list_item::Builder::default()
    }
}

/// <p>Information about the ground station data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroundStationData {
    /// <p>UUID of a ground station.</p>
    pub ground_station_id: std::option::Option<std::string::String>,
    /// <p>Name of a ground station.</p>
    pub ground_station_name: std::option::Option<std::string::String>,
    /// <p>Ground station Region.</p>
    pub region: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GroundStationData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroundStationData");
        formatter.field("ground_station_id", &self.ground_station_id);
        formatter.field("ground_station_name", &self.ground_station_name);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`GroundStationData`](crate::model::GroundStationData)
pub mod ground_station_data {
    /// A builder for [`GroundStationData`](crate::model::GroundStationData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ground_station_id: std::option::Option<std::string::String>,
        pub(crate) ground_station_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a ground station.</p>
        pub fn ground_station_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ground_station_id = Some(input.into());
            self
        }
        /// <p>UUID of a ground station.</p>
        pub fn set_ground_station_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ground_station_id = input;
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn ground_station_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ground_station_name = Some(input.into());
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn set_ground_station_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ground_station_name = input;
            self
        }
        /// <p>Ground station Region.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>Ground station Region.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`GroundStationData`](crate::model::GroundStationData)
        pub fn build(self) -> crate::model::GroundStationData {
            crate::model::GroundStationData {
                ground_station_id: self.ground_station_id,
                ground_station_name: self.ground_station_name,
                region: self.region,
            }
        }
    }
}
impl GroundStationData {
    /// Creates a new builder-style object to manufacture [`GroundStationData`](crate::model::GroundStationData)
    pub fn builder() -> crate::model::ground_station_data::Builder {
        crate::model::ground_station_data::Builder::default()
    }
}

/// <p>Item in a list of <code>DataflowEndpoint</code> groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataflowEndpointListItem {
    /// <p>UUID of a dataflow endpoint group.</p>
    pub dataflow_endpoint_group_id: std::option::Option<std::string::String>,
    /// <p>ARN of a dataflow endpoint group.</p>
    pub dataflow_endpoint_group_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DataflowEndpointListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataflowEndpointListItem");
        formatter.field(
            "dataflow_endpoint_group_id",
            &self.dataflow_endpoint_group_id,
        );
        formatter.field(
            "dataflow_endpoint_group_arn",
            &self.dataflow_endpoint_group_arn,
        );
        formatter.finish()
    }
}
/// See [`DataflowEndpointListItem`](crate::model::DataflowEndpointListItem)
pub mod dataflow_endpoint_list_item {
    /// A builder for [`DataflowEndpointListItem`](crate::model::DataflowEndpointListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataflow_endpoint_group_id: std::option::Option<std::string::String>,
        pub(crate) dataflow_endpoint_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataflow_endpoint_group_id = Some(input.into());
            self
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_group_id = input;
            self
        }
        /// <p>ARN of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>ARN of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DataflowEndpointListItem`](crate::model::DataflowEndpointListItem)
        pub fn build(self) -> crate::model::DataflowEndpointListItem {
            crate::model::DataflowEndpointListItem {
                dataflow_endpoint_group_id: self.dataflow_endpoint_group_id,
                dataflow_endpoint_group_arn: self.dataflow_endpoint_group_arn,
            }
        }
    }
}
impl DataflowEndpointListItem {
    /// Creates a new builder-style object to manufacture [`DataflowEndpointListItem`](crate::model::DataflowEndpointListItem)
    pub fn builder() -> crate::model::dataflow_endpoint_list_item::Builder {
        crate::model::dataflow_endpoint_list_item::Builder::default()
    }
}

/// <p>Information about the endpoint details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointDetails {
    /// <p>Endpoint security details.</p>
    pub security_details: std::option::Option<crate::model::SecurityDetails>,
    /// <p>A dataflow endpoint.</p>
    pub endpoint: std::option::Option<crate::model::DataflowEndpoint>,
}
impl std::fmt::Debug for EndpointDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointDetails");
        formatter.field("security_details", &self.security_details);
        formatter.field("endpoint", &self.endpoint);
        formatter.finish()
    }
}
/// See [`EndpointDetails`](crate::model::EndpointDetails)
pub mod endpoint_details {
    /// A builder for [`EndpointDetails`](crate::model::EndpointDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_details: std::option::Option<crate::model::SecurityDetails>,
        pub(crate) endpoint: std::option::Option<crate::model::DataflowEndpoint>,
    }
    impl Builder {
        /// <p>Endpoint security details.</p>
        pub fn security_details(mut self, input: crate::model::SecurityDetails) -> Self {
            self.security_details = Some(input);
            self
        }
        /// <p>Endpoint security details.</p>
        pub fn set_security_details(
            mut self,
            input: std::option::Option<crate::model::SecurityDetails>,
        ) -> Self {
            self.security_details = input;
            self
        }
        /// <p>A dataflow endpoint.</p>
        pub fn endpoint(mut self, input: crate::model::DataflowEndpoint) -> Self {
            self.endpoint = Some(input);
            self
        }
        /// <p>A dataflow endpoint.</p>
        pub fn set_endpoint(
            mut self,
            input: std::option::Option<crate::model::DataflowEndpoint>,
        ) -> Self {
            self.endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointDetails`](crate::model::EndpointDetails)
        pub fn build(self) -> crate::model::EndpointDetails {
            crate::model::EndpointDetails {
                security_details: self.security_details,
                endpoint: self.endpoint,
            }
        }
    }
}
impl EndpointDetails {
    /// Creates a new builder-style object to manufacture [`EndpointDetails`](crate::model::EndpointDetails)
    pub fn builder() -> crate::model::endpoint_details::Builder {
        crate::model::endpoint_details::Builder::default()
    }
}

/// <p>Information about a dataflow endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataflowEndpoint {
    /// <p>Name of a dataflow endpoint.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Socket address of a dataflow endpoint.</p>
    pub address: std::option::Option<crate::model::SocketAddress>,
    /// <p>Status of a dataflow endpoint.</p>
    pub status: std::option::Option<crate::model::EndpointStatus>,
    /// <p>Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.</p>
    pub mtu: std::option::Option<i32>,
}
impl std::fmt::Debug for DataflowEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataflowEndpoint");
        formatter.field("name", &self.name);
        formatter.field("address", &self.address);
        formatter.field("status", &self.status);
        formatter.field("mtu", &self.mtu);
        formatter.finish()
    }
}
/// See [`DataflowEndpoint`](crate::model::DataflowEndpoint)
pub mod dataflow_endpoint {
    /// A builder for [`DataflowEndpoint`](crate::model::DataflowEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) address: std::option::Option<crate::model::SocketAddress>,
        pub(crate) status: std::option::Option<crate::model::EndpointStatus>,
        pub(crate) mtu: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Name of a dataflow endpoint.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a dataflow endpoint.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Socket address of a dataflow endpoint.</p>
        pub fn address(mut self, input: crate::model::SocketAddress) -> Self {
            self.address = Some(input);
            self
        }
        /// <p>Socket address of a dataflow endpoint.</p>
        pub fn set_address(
            mut self,
            input: std::option::Option<crate::model::SocketAddress>,
        ) -> Self {
            self.address = input;
            self
        }
        /// <p>Status of a dataflow endpoint.</p>
        pub fn status(mut self, input: crate::model::EndpointStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of a dataflow endpoint.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EndpointStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.</p>
        pub fn mtu(mut self, input: i32) -> Self {
            self.mtu = Some(input);
            self
        }
        /// <p>Maximum transmission unit (MTU) size in bytes of a dataflow endpoint.</p>
        pub fn set_mtu(mut self, input: std::option::Option<i32>) -> Self {
            self.mtu = input;
            self
        }
        /// Consumes the builder and constructs a [`DataflowEndpoint`](crate::model::DataflowEndpoint)
        pub fn build(self) -> crate::model::DataflowEndpoint {
            crate::model::DataflowEndpoint {
                name: self.name,
                address: self.address,
                status: self.status,
                mtu: self.mtu,
            }
        }
    }
}
impl DataflowEndpoint {
    /// Creates a new builder-style object to manufacture [`DataflowEndpoint`](crate::model::DataflowEndpoint)
    pub fn builder() -> crate::model::dataflow_endpoint::Builder {
        crate::model::dataflow_endpoint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointStatus {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointStatus {
    fn from(s: &str) -> Self {
        match s {
            "created" => EndpointStatus::Created,
            "creating" => EndpointStatus::Creating,
            "deleted" => EndpointStatus::Deleted,
            "deleting" => EndpointStatus::Deleting,
            "failed" => EndpointStatus::Failed,
            other => EndpointStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointStatus::from(s))
    }
}
impl EndpointStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointStatus::Created => "created",
            EndpointStatus::Creating => "creating",
            EndpointStatus::Deleted => "deleted",
            EndpointStatus::Deleting => "deleting",
            EndpointStatus::Failed => "failed",
            EndpointStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["created", "creating", "deleted", "deleting", "failed"]
    }
}
impl AsRef<str> for EndpointStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the socket address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SocketAddress {
    /// <p>Name of a socket address.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Port of a socket address.</p>
    pub port: std::option::Option<i32>,
}
impl std::fmt::Debug for SocketAddress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SocketAddress");
        formatter.field("name", &self.name);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`SocketAddress`](crate::model::SocketAddress)
pub mod socket_address {
    /// A builder for [`SocketAddress`](crate::model::SocketAddress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Name of a socket address.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a socket address.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Port of a socket address.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Port of a socket address.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`SocketAddress`](crate::model::SocketAddress)
        pub fn build(self) -> crate::model::SocketAddress {
            crate::model::SocketAddress {
                name: self.name,
                port: self.port,
            }
        }
    }
}
impl SocketAddress {
    /// Creates a new builder-style object to manufacture [`SocketAddress`](crate::model::SocketAddress)
    pub fn builder() -> crate::model::socket_address::Builder {
        crate::model::socket_address::Builder::default()
    }
}

/// <p>Information about endpoints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityDetails {
    /// <p>A list of subnets where AWS Ground Station places elastic network interfaces to send streams to your instances.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The security groups to attach to the elastic network interfaces.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>ARN to a role needed for connecting streams to your instances. </p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SecurityDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityDetails");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`SecurityDetails`](crate::model::SecurityDetails)
pub mod security_details {
    /// A builder for [`SecurityDetails`](crate::model::SecurityDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnets where AWS Ground Station places elastic network interfaces to send streams to your instances.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnets where AWS Ground Station places elastic network interfaces to send streams to your instances.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security groups to attach to the elastic network interfaces.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The security groups to attach to the elastic network interfaces.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>ARN to a role needed for connecting streams to your instances. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN to a role needed for connecting streams to your instances. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityDetails`](crate::model::SecurityDetails)
        pub fn build(self) -> crate::model::SecurityDetails {
            crate::model::SecurityDetails {
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
                role_arn: self.role_arn,
            }
        }
    }
}
impl SecurityDetails {
    /// Creates a new builder-style object to manufacture [`SecurityDetails`](crate::model::SecurityDetails)
    pub fn builder() -> crate::model::security_details::Builder {
        crate::model::security_details::Builder::default()
    }
}

/// <p>Data describing a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactData {
    /// <p>UUID of a contact.</p>
    pub contact_id: std::option::Option<std::string::String>,
    /// <p>ARN of a mission profile.</p>
    pub mission_profile_arn: std::option::Option<std::string::String>,
    /// <p>ARN of a satellite.</p>
    pub satellite_arn: std::option::Option<std::string::String>,
    /// <p>Start time of a contact.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>End time of a contact.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
    pub pre_pass_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    pub post_pass_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Name of a ground station.</p>
    pub ground_station: std::option::Option<std::string::String>,
    /// <p>Status of a contact.</p>
    pub contact_status: std::option::Option<crate::model::ContactStatus>,
    /// <p>Error message of a contact.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>Maximum elevation angle of a contact.</p>
    pub maximum_elevation: std::option::Option<crate::model::Elevation>,
    /// <p>Region of a contact.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Tags assigned to a contact.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ContactData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactData");
        formatter.field("contact_id", &self.contact_id);
        formatter.field("mission_profile_arn", &self.mission_profile_arn);
        formatter.field("satellite_arn", &self.satellite_arn);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("pre_pass_start_time", &self.pre_pass_start_time);
        formatter.field("post_pass_end_time", &self.post_pass_end_time);
        formatter.field("ground_station", &self.ground_station);
        formatter.field("contact_status", &self.contact_status);
        formatter.field("error_message", &self.error_message);
        formatter.field("maximum_elevation", &self.maximum_elevation);
        formatter.field("region", &self.region);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ContactData`](crate::model::ContactData)
pub mod contact_data {
    /// A builder for [`ContactData`](crate::model::ContactData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) mission_profile_arn: std::option::Option<std::string::String>,
        pub(crate) satellite_arn: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) pre_pass_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) post_pass_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ground_station: std::option::Option<std::string::String>,
        pub(crate) contact_status: std::option::Option<crate::model::ContactStatus>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) maximum_elevation: std::option::Option<crate::model::Elevation>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>UUID of a contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>UUID of a contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn mission_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_arn = Some(input.into());
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn set_mission_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_arn = input;
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn satellite_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.satellite_arn = Some(input.into());
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn set_satellite_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.satellite_arn = input;
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>End time of a contact.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn pre_pass_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.pre_pass_start_time = Some(input);
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn set_pre_pass_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.pre_pass_start_time = input;
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn post_pass_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.post_pass_end_time = Some(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_post_pass_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.post_pass_end_time = input;
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn ground_station(mut self, input: impl Into<std::string::String>) -> Self {
            self.ground_station = Some(input.into());
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn set_ground_station(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ground_station = input;
            self
        }
        /// <p>Status of a contact.</p>
        pub fn contact_status(mut self, input: crate::model::ContactStatus) -> Self {
            self.contact_status = Some(input);
            self
        }
        /// <p>Status of a contact.</p>
        pub fn set_contact_status(
            mut self,
            input: std::option::Option<crate::model::ContactStatus>,
        ) -> Self {
            self.contact_status = input;
            self
        }
        /// <p>Error message of a contact.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Error message of a contact.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>Maximum elevation angle of a contact.</p>
        pub fn maximum_elevation(mut self, input: crate::model::Elevation) -> Self {
            self.maximum_elevation = Some(input);
            self
        }
        /// <p>Maximum elevation angle of a contact.</p>
        pub fn set_maximum_elevation(
            mut self,
            input: std::option::Option<crate::model::Elevation>,
        ) -> Self {
            self.maximum_elevation = input;
            self
        }
        /// <p>Region of a contact.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>Region of a contact.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a contact.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to a contact.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactData`](crate::model::ContactData)
        pub fn build(self) -> crate::model::ContactData {
            crate::model::ContactData {
                contact_id: self.contact_id,
                mission_profile_arn: self.mission_profile_arn,
                satellite_arn: self.satellite_arn,
                start_time: self.start_time,
                end_time: self.end_time,
                pre_pass_start_time: self.pre_pass_start_time,
                post_pass_end_time: self.post_pass_end_time,
                ground_station: self.ground_station,
                contact_status: self.contact_status,
                error_message: self.error_message,
                maximum_elevation: self.maximum_elevation,
                region: self.region,
                tags: self.tags,
            }
        }
    }
}
impl ContactData {
    /// Creates a new builder-style object to manufacture [`ContactData`](crate::model::ContactData)
    pub fn builder() -> crate::model::contact_data::Builder {
        crate::model::contact_data::Builder::default()
    }
}

/// <p>Elevation angle of the satellite in the sky during a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Elevation {
    /// <p>Elevation angle value.</p>
    pub value: std::option::Option<f64>,
    /// <p>Elevation angle units.</p>
    pub unit: std::option::Option<crate::model::AngleUnits>,
}
impl std::fmt::Debug for Elevation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Elevation");
        formatter.field("value", &self.value);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`Elevation`](crate::model::Elevation)
pub mod elevation {
    /// A builder for [`Elevation`](crate::model::Elevation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<f64>,
        pub(crate) unit: std::option::Option<crate::model::AngleUnits>,
    }
    impl Builder {
        /// <p>Elevation angle value.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Elevation angle value.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// <p>Elevation angle units.</p>
        pub fn unit(mut self, input: crate::model::AngleUnits) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>Elevation angle units.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::AngleUnits>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`Elevation`](crate::model::Elevation)
        pub fn build(self) -> crate::model::Elevation {
            crate::model::Elevation {
                value: self.value,
                unit: self.unit,
            }
        }
    }
}
impl Elevation {
    /// Creates a new builder-style object to manufacture [`Elevation`](crate::model::Elevation)
    pub fn builder() -> crate::model::elevation::Builder {
        crate::model::elevation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AngleUnits {
    #[allow(missing_docs)] // documentation missing in model
    DegreeAngle,
    #[allow(missing_docs)] // documentation missing in model
    Radian,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AngleUnits {
    fn from(s: &str) -> Self {
        match s {
            "DEGREE_ANGLE" => AngleUnits::DegreeAngle,
            "RADIAN" => AngleUnits::Radian,
            other => AngleUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AngleUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AngleUnits::from(s))
    }
}
impl AngleUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AngleUnits::DegreeAngle => "DEGREE_ANGLE",
            AngleUnits::Radian => "RADIAN",
            AngleUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEGREE_ANGLE", "RADIAN"]
    }
}
impl AsRef<str> for AngleUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContactStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    AwsCancelled,
    #[allow(missing_docs)] // documentation missing in model
    AwsFailed,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    FailedToSchedule,
    #[allow(missing_docs)] // documentation missing in model
    Pass,
    #[allow(missing_docs)] // documentation missing in model
    Postpass,
    #[allow(missing_docs)] // documentation missing in model
    Prepass,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    #[allow(missing_docs)] // documentation missing in model
    Scheduling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContactStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ContactStatus::Available,
            "AWS_CANCELLED" => ContactStatus::AwsCancelled,
            "AWS_FAILED" => ContactStatus::AwsFailed,
            "CANCELLED" => ContactStatus::Cancelled,
            "CANCELLING" => ContactStatus::Cancelling,
            "COMPLETED" => ContactStatus::Completed,
            "FAILED" => ContactStatus::Failed,
            "FAILED_TO_SCHEDULE" => ContactStatus::FailedToSchedule,
            "PASS" => ContactStatus::Pass,
            "POSTPASS" => ContactStatus::Postpass,
            "PREPASS" => ContactStatus::Prepass,
            "SCHEDULED" => ContactStatus::Scheduled,
            "SCHEDULING" => ContactStatus::Scheduling,
            other => ContactStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContactStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContactStatus::from(s))
    }
}
impl ContactStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContactStatus::Available => "AVAILABLE",
            ContactStatus::AwsCancelled => "AWS_CANCELLED",
            ContactStatus::AwsFailed => "AWS_FAILED",
            ContactStatus::Cancelled => "CANCELLED",
            ContactStatus::Cancelling => "CANCELLING",
            ContactStatus::Completed => "COMPLETED",
            ContactStatus::Failed => "FAILED",
            ContactStatus::FailedToSchedule => "FAILED_TO_SCHEDULE",
            ContactStatus::Pass => "PASS",
            ContactStatus::Postpass => "POSTPASS",
            ContactStatus::Prepass => "PREPASS",
            ContactStatus::Scheduled => "SCHEDULED",
            ContactStatus::Scheduling => "SCHEDULING",
            ContactStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "AWS_CANCELLED",
            "AWS_FAILED",
            "CANCELLED",
            "CANCELLING",
            "COMPLETED",
            "FAILED",
            "FAILED_TO_SCHEDULE",
            "PASS",
            "POSTPASS",
            "PREPASS",
            "SCHEDULED",
            "SCHEDULING",
        ]
    }
}
impl AsRef<str> for ContactStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a dataflow edge used in a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataflowDetail {
    /// <p>Dataflow details for the source side.</p>
    pub source: std::option::Option<crate::model::Source>,
    /// <p>Dataflow details for the destination side.</p>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>Error message for a dataflow.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DataflowDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataflowDetail");
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`DataflowDetail`](crate::model::DataflowDetail)
pub mod dataflow_detail {
    /// A builder for [`DataflowDetail`](crate::model::DataflowDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::Source>,
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Dataflow details for the source side.</p>
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>Dataflow details for the source side.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// <p>Dataflow details for the destination side.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>Dataflow details for the destination side.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>Error message for a dataflow.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Error message for a dataflow.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataflowDetail`](crate::model::DataflowDetail)
        pub fn build(self) -> crate::model::DataflowDetail {
            crate::model::DataflowDetail {
                source: self.source,
                destination: self.destination,
                error_message: self.error_message,
            }
        }
    }
}
impl DataflowDetail {
    /// Creates a new builder-style object to manufacture [`DataflowDetail`](crate::model::DataflowDetail)
    pub fn builder() -> crate::model::dataflow_detail::Builder {
        crate::model::dataflow_detail::Builder::default()
    }
}

/// <p>Dataflow details for the destination side.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Destination {
    /// <p>Type of a <code>Config</code>.</p>
    pub config_type: std::option::Option<crate::model::ConfigCapabilityType>,
    /// <p>UUID of a <code>Config</code>.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.</p>
    pub config_details: std::option::Option<crate::model::ConfigDetails>,
    /// <p>Region of a dataflow destination.</p>
    pub dataflow_destination_region: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Destination");
        formatter.field("config_type", &self.config_type);
        formatter.field("config_id", &self.config_id);
        formatter.field("config_details", &self.config_details);
        formatter.field(
            "dataflow_destination_region",
            &self.dataflow_destination_region,
        );
        formatter.finish()
    }
}
/// See [`Destination`](crate::model::Destination)
pub mod destination {
    /// A builder for [`Destination`](crate::model::Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_type: std::option::Option<crate::model::ConfigCapabilityType>,
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) config_details: std::option::Option<crate::model::ConfigDetails>,
        pub(crate) dataflow_destination_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.config_type = Some(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.config_type = input;
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.</p>
        pub fn config_details(mut self, input: crate::model::ConfigDetails) -> Self {
            self.config_details = Some(input);
            self
        }
        /// <p>Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.</p>
        pub fn set_config_details(
            mut self,
            input: std::option::Option<crate::model::ConfigDetails>,
        ) -> Self {
            self.config_details = input;
            self
        }
        /// <p>Region of a dataflow destination.</p>
        pub fn dataflow_destination_region(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.dataflow_destination_region = Some(input.into());
            self
        }
        /// <p>Region of a dataflow destination.</p>
        pub fn set_dataflow_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_destination_region = input;
            self
        }
        /// Consumes the builder and constructs a [`Destination`](crate::model::Destination)
        pub fn build(self) -> crate::model::Destination {
            crate::model::Destination {
                config_type: self.config_type,
                config_id: self.config_id,
                config_details: self.config_details,
                dataflow_destination_region: self.dataflow_destination_region,
            }
        }
    }
}
impl Destination {
    /// Creates a new builder-style object to manufacture [`Destination`](crate::model::Destination)
    pub fn builder() -> crate::model::destination::Builder {
        crate::model::destination::Builder::default()
    }
}

/// <p>Details for certain <code>Config</code> object types in a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ConfigDetails {
    /// <p>Details for antenna demod decode <code>Config</code> in a contact.</p>
    AntennaDemodDecodeDetails(crate::model::AntennaDemodDecodeDetails),
    /// <p>Information about the endpoint details.</p>
    EndpointDetails(crate::model::EndpointDetails),
    /// <p>Details for an S3 recording <code>Config</code> in a contact.</p>
    S3RecordingDetails(crate::model::S3RecordingDetails),
}
impl ConfigDetails {
    /// Tries to convert the enum instance into [`AntennaDemodDecodeDetails`](crate::model::ConfigDetails::AntennaDemodDecodeDetails), extracting the inner [`AntennaDemodDecodeDetails`](crate::model::AntennaDemodDecodeDetails).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_antenna_demod_decode_details(
        &self,
    ) -> std::result::Result<&crate::model::AntennaDemodDecodeDetails, &Self> {
        if let ConfigDetails::AntennaDemodDecodeDetails(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AntennaDemodDecodeDetails`](crate::model::ConfigDetails::AntennaDemodDecodeDetails).
    pub fn is_antenna_demod_decode_details(&self) -> bool {
        self.as_antenna_demod_decode_details().is_ok()
    }
    /// Tries to convert the enum instance into [`EndpointDetails`](crate::model::ConfigDetails::EndpointDetails), extracting the inner [`EndpointDetails`](crate::model::EndpointDetails).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_endpoint_details(
        &self,
    ) -> std::result::Result<&crate::model::EndpointDetails, &Self> {
        if let ConfigDetails::EndpointDetails(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`EndpointDetails`](crate::model::ConfigDetails::EndpointDetails).
    pub fn is_endpoint_details(&self) -> bool {
        self.as_endpoint_details().is_ok()
    }
    /// Tries to convert the enum instance into [`S3RecordingDetails`](crate::model::ConfigDetails::S3RecordingDetails), extracting the inner [`S3RecordingDetails`](crate::model::S3RecordingDetails).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s3_recording_details(
        &self,
    ) -> std::result::Result<&crate::model::S3RecordingDetails, &Self> {
        if let ConfigDetails::S3RecordingDetails(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`S3RecordingDetails`](crate::model::ConfigDetails::S3RecordingDetails).
    pub fn is_s3_recording_details(&self) -> bool {
        self.as_s3_recording_details().is_ok()
    }
}

/// <p>Details about an S3 recording <code>Config</code> used in a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3RecordingDetails {
    /// <p>ARN of the bucket used.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>Template of the S3 key used.</p>
    pub key_template: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3RecordingDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3RecordingDetails");
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("key_template", &self.key_template);
        formatter.finish()
    }
}
/// See [`S3RecordingDetails`](crate::model::S3RecordingDetails)
pub mod s3_recording_details {
    /// A builder for [`S3RecordingDetails`](crate::model::S3RecordingDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) key_template: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of the bucket used.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>ARN of the bucket used.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>Template of the S3 key used.</p>
        pub fn key_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_template = Some(input.into());
            self
        }
        /// <p>Template of the S3 key used.</p>
        pub fn set_key_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_template = input;
            self
        }
        /// Consumes the builder and constructs a [`S3RecordingDetails`](crate::model::S3RecordingDetails)
        pub fn build(self) -> crate::model::S3RecordingDetails {
            crate::model::S3RecordingDetails {
                bucket_arn: self.bucket_arn,
                key_template: self.key_template,
            }
        }
    }
}
impl S3RecordingDetails {
    /// Creates a new builder-style object to manufacture [`S3RecordingDetails`](crate::model::S3RecordingDetails)
    pub fn builder() -> crate::model::s3_recording_details::Builder {
        crate::model::s3_recording_details::Builder::default()
    }
}

/// <p>Details about an antenna demod decode <code>Config</code> used in a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AntennaDemodDecodeDetails {
    /// <p>Name of an antenna demod decode output node used in a contact.</p>
    pub output_node: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AntennaDemodDecodeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AntennaDemodDecodeDetails");
        formatter.field("output_node", &self.output_node);
        formatter.finish()
    }
}
/// See [`AntennaDemodDecodeDetails`](crate::model::AntennaDemodDecodeDetails)
pub mod antenna_demod_decode_details {
    /// A builder for [`AntennaDemodDecodeDetails`](crate::model::AntennaDemodDecodeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_node: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of an antenna demod decode output node used in a contact.</p>
        pub fn output_node(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_node = Some(input.into());
            self
        }
        /// <p>Name of an antenna demod decode output node used in a contact.</p>
        pub fn set_output_node(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_node = input;
            self
        }
        /// Consumes the builder and constructs a [`AntennaDemodDecodeDetails`](crate::model::AntennaDemodDecodeDetails)
        pub fn build(self) -> crate::model::AntennaDemodDecodeDetails {
            crate::model::AntennaDemodDecodeDetails {
                output_node: self.output_node,
            }
        }
    }
}
impl AntennaDemodDecodeDetails {
    /// Creates a new builder-style object to manufacture [`AntennaDemodDecodeDetails`](crate::model::AntennaDemodDecodeDetails)
    pub fn builder() -> crate::model::antenna_demod_decode_details::Builder {
        crate::model::antenna_demod_decode_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigCapabilityType {
    #[allow(missing_docs)] // documentation missing in model
    AntennaDownlink,
    #[allow(missing_docs)] // documentation missing in model
    AntennaDownlinkDemodDecode,
    #[allow(missing_docs)] // documentation missing in model
    AntennaUplink,
    #[allow(missing_docs)] // documentation missing in model
    DataflowEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    S3Recording,
    #[allow(missing_docs)] // documentation missing in model
    Tracking,
    #[allow(missing_docs)] // documentation missing in model
    UplinkEcho,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigCapabilityType {
    fn from(s: &str) -> Self {
        match s {
            "antenna-downlink" => ConfigCapabilityType::AntennaDownlink,
            "antenna-downlink-demod-decode" => ConfigCapabilityType::AntennaDownlinkDemodDecode,
            "antenna-uplink" => ConfigCapabilityType::AntennaUplink,
            "dataflow-endpoint" => ConfigCapabilityType::DataflowEndpoint,
            "s3-recording" => ConfigCapabilityType::S3Recording,
            "tracking" => ConfigCapabilityType::Tracking,
            "uplink-echo" => ConfigCapabilityType::UplinkEcho,
            other => ConfigCapabilityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigCapabilityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigCapabilityType::from(s))
    }
}
impl ConfigCapabilityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigCapabilityType::AntennaDownlink => "antenna-downlink",
            ConfigCapabilityType::AntennaDownlinkDemodDecode => "antenna-downlink-demod-decode",
            ConfigCapabilityType::AntennaUplink => "antenna-uplink",
            ConfigCapabilityType::DataflowEndpoint => "dataflow-endpoint",
            ConfigCapabilityType::S3Recording => "s3-recording",
            ConfigCapabilityType::Tracking => "tracking",
            ConfigCapabilityType::UplinkEcho => "uplink-echo",
            ConfigCapabilityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "antenna-downlink",
            "antenna-downlink-demod-decode",
            "antenna-uplink",
            "dataflow-endpoint",
            "s3-recording",
            "tracking",
            "uplink-echo",
        ]
    }
}
impl AsRef<str> for ConfigCapabilityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Dataflow details for the source side.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Source {
    /// <p>Type of a <code>Config</code>.</p>
    pub config_type: std::option::Option<crate::model::ConfigCapabilityType>,
    /// <p>UUID of a <code>Config</code>.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.</p>
    pub config_details: std::option::Option<crate::model::ConfigDetails>,
    /// <p>Region of a dataflow source.</p>
    pub dataflow_source_region: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Source {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Source");
        formatter.field("config_type", &self.config_type);
        formatter.field("config_id", &self.config_id);
        formatter.field("config_details", &self.config_details);
        formatter.field("dataflow_source_region", &self.dataflow_source_region);
        formatter.finish()
    }
}
/// See [`Source`](crate::model::Source)
pub mod source {
    /// A builder for [`Source`](crate::model::Source)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_type: std::option::Option<crate::model::ConfigCapabilityType>,
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) config_details: std::option::Option<crate::model::ConfigDetails>,
        pub(crate) dataflow_source_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.config_type = Some(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.config_type = input;
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.</p>
        pub fn config_details(mut self, input: crate::model::ConfigDetails) -> Self {
            self.config_details = Some(input);
            self
        }
        /// <p>Additional details for a <code>Config</code>, if type is dataflow endpoint or antenna demod decode.</p>
        pub fn set_config_details(
            mut self,
            input: std::option::Option<crate::model::ConfigDetails>,
        ) -> Self {
            self.config_details = input;
            self
        }
        /// <p>Region of a dataflow source.</p>
        pub fn dataflow_source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataflow_source_region = Some(input.into());
            self
        }
        /// <p>Region of a dataflow source.</p>
        pub fn set_dataflow_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_source_region = input;
            self
        }
        /// Consumes the builder and constructs a [`Source`](crate::model::Source)
        pub fn build(self) -> crate::model::Source {
            crate::model::Source {
                config_type: self.config_type,
                config_id: self.config_id,
                config_details: self.config_details,
                dataflow_source_region: self.dataflow_source_region,
            }
        }
    }
}
impl Source {
    /// Creates a new builder-style object to manufacture [`Source`](crate::model::Source)
    pub fn builder() -> crate::model::source::Builder {
        crate::model::source::Builder::default()
    }
}

/// <p>An item in a list of <code>Config</code> objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigListItem {
    /// <p>UUID of a <code>Config</code>.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>Type of a <code>Config</code>.</p>
    pub config_type: std::option::Option<crate::model::ConfigCapabilityType>,
    /// <p>ARN of a <code>Config</code>.</p>
    pub config_arn: std::option::Option<std::string::String>,
    /// <p>Name of a <code>Config</code>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConfigListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigListItem");
        formatter.field("config_id", &self.config_id);
        formatter.field("config_type", &self.config_type);
        formatter.field("config_arn", &self.config_arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`ConfigListItem`](crate::model::ConfigListItem)
pub mod config_list_item {
    /// A builder for [`ConfigListItem`](crate::model::ConfigListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) config_type: std::option::Option<crate::model::ConfigCapabilityType>,
        pub(crate) config_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.config_type = Some(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.config_type = input;
            self
        }
        /// <p>ARN of a <code>Config</code>.</p>
        pub fn config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_arn = Some(input.into());
            self
        }
        /// <p>ARN of a <code>Config</code>.</p>
        pub fn set_config_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_arn = input;
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigListItem`](crate::model::ConfigListItem)
        pub fn build(self) -> crate::model::ConfigListItem {
            crate::model::ConfigListItem {
                config_id: self.config_id,
                config_type: self.config_type,
                config_arn: self.config_arn,
                name: self.name,
            }
        }
    }
}
impl ConfigListItem {
    /// Creates a new builder-style object to manufacture [`ConfigListItem`](crate::model::ConfigListItem)
    pub fn builder() -> crate::model::config_list_item::Builder {
        crate::model::config_list_item::Builder::default()
    }
}

/// <p>Object containing the parameters of a <code>Config</code>.</p>
/// <p>See the subtype definitions for what each type of <code>Config</code> contains.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ConfigTypeData {
    /// <p>Information about how AWS Ground Station should configure an antenna for downlink during a contact.</p>
    AntennaDownlinkConfig(crate::model::AntennaDownlinkConfig),
    /// <p>Information about how AWS Ground Station should conﬁgure an antenna for downlink demod decode during a contact.</p>
    AntennaDownlinkDemodDecodeConfig(crate::model::AntennaDownlinkDemodDecodeConfig),
    /// <p>Information about how AWS Ground Station should conﬁgure an antenna for uplink during a contact.</p>
    AntennaUplinkConfig(crate::model::AntennaUplinkConfig),
    /// <p>Information about the dataflow endpoint <code>Config</code>.</p>
    DataflowEndpointConfig(crate::model::DataflowEndpointConfig),
    /// <p>Information about an S3 recording <code>Config</code>.</p>
    S3RecordingConfig(crate::model::S3RecordingConfig),
    /// <p>Object that determines whether tracking should be used during a contact executed with this <code>Config</code> in the mission profile. </p>
    TrackingConfig(crate::model::TrackingConfig),
    /// <p>Information about an uplink echo <code>Config</code>.</p>
    /// <p>Parameters from the <code>AntennaUplinkConfig</code>, corresponding to the specified <code>AntennaUplinkConfigArn</code>, are used when this <code>UplinkEchoConfig</code> is used in a contact.</p>
    UplinkEchoConfig(crate::model::UplinkEchoConfig),
}
impl ConfigTypeData {
    /// Tries to convert the enum instance into [`AntennaDownlinkConfig`](crate::model::ConfigTypeData::AntennaDownlinkConfig), extracting the inner [`AntennaDownlinkConfig`](crate::model::AntennaDownlinkConfig).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_antenna_downlink_config(
        &self,
    ) -> std::result::Result<&crate::model::AntennaDownlinkConfig, &Self> {
        if let ConfigTypeData::AntennaDownlinkConfig(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AntennaDownlinkConfig`](crate::model::ConfigTypeData::AntennaDownlinkConfig).
    pub fn is_antenna_downlink_config(&self) -> bool {
        self.as_antenna_downlink_config().is_ok()
    }
    /// Tries to convert the enum instance into [`AntennaDownlinkDemodDecodeConfig`](crate::model::ConfigTypeData::AntennaDownlinkDemodDecodeConfig), extracting the inner [`AntennaDownlinkDemodDecodeConfig`](crate::model::AntennaDownlinkDemodDecodeConfig).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_antenna_downlink_demod_decode_config(
        &self,
    ) -> std::result::Result<&crate::model::AntennaDownlinkDemodDecodeConfig, &Self> {
        if let ConfigTypeData::AntennaDownlinkDemodDecodeConfig(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AntennaDownlinkDemodDecodeConfig`](crate::model::ConfigTypeData::AntennaDownlinkDemodDecodeConfig).
    pub fn is_antenna_downlink_demod_decode_config(&self) -> bool {
        self.as_antenna_downlink_demod_decode_config().is_ok()
    }
    /// Tries to convert the enum instance into [`AntennaUplinkConfig`](crate::model::ConfigTypeData::AntennaUplinkConfig), extracting the inner [`AntennaUplinkConfig`](crate::model::AntennaUplinkConfig).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_antenna_uplink_config(
        &self,
    ) -> std::result::Result<&crate::model::AntennaUplinkConfig, &Self> {
        if let ConfigTypeData::AntennaUplinkConfig(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`AntennaUplinkConfig`](crate::model::ConfigTypeData::AntennaUplinkConfig).
    pub fn is_antenna_uplink_config(&self) -> bool {
        self.as_antenna_uplink_config().is_ok()
    }
    /// Tries to convert the enum instance into [`DataflowEndpointConfig`](crate::model::ConfigTypeData::DataflowEndpointConfig), extracting the inner [`DataflowEndpointConfig`](crate::model::DataflowEndpointConfig).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_dataflow_endpoint_config(
        &self,
    ) -> std::result::Result<&crate::model::DataflowEndpointConfig, &Self> {
        if let ConfigTypeData::DataflowEndpointConfig(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`DataflowEndpointConfig`](crate::model::ConfigTypeData::DataflowEndpointConfig).
    pub fn is_dataflow_endpoint_config(&self) -> bool {
        self.as_dataflow_endpoint_config().is_ok()
    }
    /// Tries to convert the enum instance into [`S3RecordingConfig`](crate::model::ConfigTypeData::S3RecordingConfig), extracting the inner [`S3RecordingConfig`](crate::model::S3RecordingConfig).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s3_recording_config(
        &self,
    ) -> std::result::Result<&crate::model::S3RecordingConfig, &Self> {
        if let ConfigTypeData::S3RecordingConfig(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`S3RecordingConfig`](crate::model::ConfigTypeData::S3RecordingConfig).
    pub fn is_s3_recording_config(&self) -> bool {
        self.as_s3_recording_config().is_ok()
    }
    /// Tries to convert the enum instance into [`TrackingConfig`](crate::model::ConfigTypeData::TrackingConfig), extracting the inner [`TrackingConfig`](crate::model::TrackingConfig).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tracking_config(&self) -> std::result::Result<&crate::model::TrackingConfig, &Self> {
        if let ConfigTypeData::TrackingConfig(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`TrackingConfig`](crate::model::ConfigTypeData::TrackingConfig).
    pub fn is_tracking_config(&self) -> bool {
        self.as_tracking_config().is_ok()
    }
    /// Tries to convert the enum instance into [`UplinkEchoConfig`](crate::model::ConfigTypeData::UplinkEchoConfig), extracting the inner [`UplinkEchoConfig`](crate::model::UplinkEchoConfig).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_uplink_echo_config(
        &self,
    ) -> std::result::Result<&crate::model::UplinkEchoConfig, &Self> {
        if let ConfigTypeData::UplinkEchoConfig(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`UplinkEchoConfig`](crate::model::ConfigTypeData::UplinkEchoConfig).
    pub fn is_uplink_echo_config(&self) -> bool {
        self.as_uplink_echo_config().is_ok()
    }
}

/// <p>Information about an S3 recording <code>Config</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3RecordingConfig {
    /// <p>ARN of the bucket to record to.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the role Ground Station assumes to write data to the bucket.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>S3 Key prefix to prefice data files.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3RecordingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3RecordingConfig");
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`S3RecordingConfig`](crate::model::S3RecordingConfig)
pub mod s3_recording_config {
    /// A builder for [`S3RecordingConfig`](crate::model::S3RecordingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of the bucket to record to.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>ARN of the bucket to record to.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>ARN of the role Ground Station assumes to write data to the bucket.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the role Ground Station assumes to write data to the bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>S3 Key prefix to prefice data files.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>S3 Key prefix to prefice data files.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3RecordingConfig`](crate::model::S3RecordingConfig)
        pub fn build(self) -> crate::model::S3RecordingConfig {
            crate::model::S3RecordingConfig {
                bucket_arn: self.bucket_arn,
                role_arn: self.role_arn,
                prefix: self.prefix,
            }
        }
    }
}
impl S3RecordingConfig {
    /// Creates a new builder-style object to manufacture [`S3RecordingConfig`](crate::model::S3RecordingConfig)
    pub fn builder() -> crate::model::s3_recording_config::Builder {
        crate::model::s3_recording_config::Builder::default()
    }
}

/// <p>Information about an uplink echo <code>Config</code>.</p>
/// <p>Parameters from the <code>AntennaUplinkConfig</code>, corresponding to the
/// specified <code>AntennaUplinkConfigArn</code>, are used when this <code>UplinkEchoConfig</code>
/// is used in a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UplinkEchoConfig {
    /// <p>Whether or not an uplink <code>Config</code> is enabled.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>ARN of an uplink <code>Config</code>.</p>
    pub antenna_uplink_config_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UplinkEchoConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UplinkEchoConfig");
        formatter.field("enabled", &self.enabled);
        formatter.field("antenna_uplink_config_arn", &self.antenna_uplink_config_arn);
        formatter.finish()
    }
}
/// See [`UplinkEchoConfig`](crate::model::UplinkEchoConfig)
pub mod uplink_echo_config {
    /// A builder for [`UplinkEchoConfig`](crate::model::UplinkEchoConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) antenna_uplink_config_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether or not an uplink <code>Config</code> is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Whether or not an uplink <code>Config</code> is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>ARN of an uplink <code>Config</code>.</p>
        pub fn antenna_uplink_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.antenna_uplink_config_arn = Some(input.into());
            self
        }
        /// <p>ARN of an uplink <code>Config</code>.</p>
        pub fn set_antenna_uplink_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.antenna_uplink_config_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UplinkEchoConfig`](crate::model::UplinkEchoConfig)
        pub fn build(self) -> crate::model::UplinkEchoConfig {
            crate::model::UplinkEchoConfig {
                enabled: self.enabled,
                antenna_uplink_config_arn: self.antenna_uplink_config_arn,
            }
        }
    }
}
impl UplinkEchoConfig {
    /// Creates a new builder-style object to manufacture [`UplinkEchoConfig`](crate::model::UplinkEchoConfig)
    pub fn builder() -> crate::model::uplink_echo_config::Builder {
        crate::model::uplink_echo_config::Builder::default()
    }
}

/// <p>Information about the uplink <code>Config</code> of an antenna.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AntennaUplinkConfig {
    /// <p>Whether or not uplink transmit is disabled.</p>
    pub transmit_disabled: std::option::Option<bool>,
    /// <p>Information about the uplink spectral <code>Config</code>.</p>
    pub spectrum_config: std::option::Option<crate::model::UplinkSpectrumConfig>,
    /// <p>EIRP of the target.</p>
    pub target_eirp: std::option::Option<crate::model::Eirp>,
}
impl std::fmt::Debug for AntennaUplinkConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AntennaUplinkConfig");
        formatter.field("transmit_disabled", &self.transmit_disabled);
        formatter.field("spectrum_config", &self.spectrum_config);
        formatter.field("target_eirp", &self.target_eirp);
        formatter.finish()
    }
}
/// See [`AntennaUplinkConfig`](crate::model::AntennaUplinkConfig)
pub mod antenna_uplink_config {
    /// A builder for [`AntennaUplinkConfig`](crate::model::AntennaUplinkConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transmit_disabled: std::option::Option<bool>,
        pub(crate) spectrum_config: std::option::Option<crate::model::UplinkSpectrumConfig>,
        pub(crate) target_eirp: std::option::Option<crate::model::Eirp>,
    }
    impl Builder {
        /// <p>Whether or not uplink transmit is disabled.</p>
        pub fn transmit_disabled(mut self, input: bool) -> Self {
            self.transmit_disabled = Some(input);
            self
        }
        /// <p>Whether or not uplink transmit is disabled.</p>
        pub fn set_transmit_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.transmit_disabled = input;
            self
        }
        /// <p>Information about the uplink spectral <code>Config</code>.</p>
        pub fn spectrum_config(mut self, input: crate::model::UplinkSpectrumConfig) -> Self {
            self.spectrum_config = Some(input);
            self
        }
        /// <p>Information about the uplink spectral <code>Config</code>.</p>
        pub fn set_spectrum_config(
            mut self,
            input: std::option::Option<crate::model::UplinkSpectrumConfig>,
        ) -> Self {
            self.spectrum_config = input;
            self
        }
        /// <p>EIRP of the target.</p>
        pub fn target_eirp(mut self, input: crate::model::Eirp) -> Self {
            self.target_eirp = Some(input);
            self
        }
        /// <p>EIRP of the target.</p>
        pub fn set_target_eirp(mut self, input: std::option::Option<crate::model::Eirp>) -> Self {
            self.target_eirp = input;
            self
        }
        /// Consumes the builder and constructs a [`AntennaUplinkConfig`](crate::model::AntennaUplinkConfig)
        pub fn build(self) -> crate::model::AntennaUplinkConfig {
            crate::model::AntennaUplinkConfig {
                transmit_disabled: self.transmit_disabled,
                spectrum_config: self.spectrum_config,
                target_eirp: self.target_eirp,
            }
        }
    }
}
impl AntennaUplinkConfig {
    /// Creates a new builder-style object to manufacture [`AntennaUplinkConfig`](crate::model::AntennaUplinkConfig)
    pub fn builder() -> crate::model::antenna_uplink_config::Builder {
        crate::model::antenna_uplink_config::Builder::default()
    }
}

/// <p>Object that represents EIRP.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Eirp {
    /// <p>Value of an EIRP. Valid values are between 20.0 to 50.0 dBW.</p>
    pub value: std::option::Option<f64>,
    /// <p>Units of an EIRP.</p>
    pub units: std::option::Option<crate::model::EirpUnits>,
}
impl std::fmt::Debug for Eirp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Eirp");
        formatter.field("value", &self.value);
        formatter.field("units", &self.units);
        formatter.finish()
    }
}
/// See [`Eirp`](crate::model::Eirp)
pub mod eirp {
    /// A builder for [`Eirp`](crate::model::Eirp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<f64>,
        pub(crate) units: std::option::Option<crate::model::EirpUnits>,
    }
    impl Builder {
        /// <p>Value of an EIRP. Valid values are between 20.0 to 50.0 dBW.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Value of an EIRP. Valid values are between 20.0 to 50.0 dBW.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// <p>Units of an EIRP.</p>
        pub fn units(mut self, input: crate::model::EirpUnits) -> Self {
            self.units = Some(input);
            self
        }
        /// <p>Units of an EIRP.</p>
        pub fn set_units(mut self, input: std::option::Option<crate::model::EirpUnits>) -> Self {
            self.units = input;
            self
        }
        /// Consumes the builder and constructs a [`Eirp`](crate::model::Eirp)
        pub fn build(self) -> crate::model::Eirp {
            crate::model::Eirp {
                value: self.value,
                units: self.units,
            }
        }
    }
}
impl Eirp {
    /// Creates a new builder-style object to manufacture [`Eirp`](crate::model::Eirp)
    pub fn builder() -> crate::model::eirp::Builder {
        crate::model::eirp::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EirpUnits {
    #[allow(missing_docs)] // documentation missing in model
    Dbw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EirpUnits {
    fn from(s: &str) -> Self {
        match s {
            "dBW" => EirpUnits::Dbw,
            other => EirpUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EirpUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EirpUnits::from(s))
    }
}
impl EirpUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EirpUnits::Dbw => "dBW",
            EirpUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["dBW"]
    }
}
impl AsRef<str> for EirpUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the uplink spectral <code>Config</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UplinkSpectrumConfig {
    /// <p>Center frequency of an uplink spectral <code>Config</code>. Valid values are between 2025 to 2120 MHz.</p>
    pub center_frequency: std::option::Option<crate::model::Frequency>,
    /// <p>Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and <code>"LEFT_HAND"</code> polarization requires two separate configs.</p>
    pub polarization: std::option::Option<crate::model::Polarization>,
}
impl std::fmt::Debug for UplinkSpectrumConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UplinkSpectrumConfig");
        formatter.field("center_frequency", &self.center_frequency);
        formatter.field("polarization", &self.polarization);
        formatter.finish()
    }
}
/// See [`UplinkSpectrumConfig`](crate::model::UplinkSpectrumConfig)
pub mod uplink_spectrum_config {
    /// A builder for [`UplinkSpectrumConfig`](crate::model::UplinkSpectrumConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) center_frequency: std::option::Option<crate::model::Frequency>,
        pub(crate) polarization: std::option::Option<crate::model::Polarization>,
    }
    impl Builder {
        /// <p>Center frequency of an uplink spectral <code>Config</code>. Valid values are between 2025 to 2120 MHz.</p>
        pub fn center_frequency(mut self, input: crate::model::Frequency) -> Self {
            self.center_frequency = Some(input);
            self
        }
        /// <p>Center frequency of an uplink spectral <code>Config</code>. Valid values are between 2025 to 2120 MHz.</p>
        pub fn set_center_frequency(
            mut self,
            input: std::option::Option<crate::model::Frequency>,
        ) -> Self {
            self.center_frequency = input;
            self
        }
        /// <p>Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and <code>"LEFT_HAND"</code> polarization requires two separate configs.</p>
        pub fn polarization(mut self, input: crate::model::Polarization) -> Self {
            self.polarization = Some(input);
            self
        }
        /// <p>Polarization of an uplink spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and <code>"LEFT_HAND"</code> polarization requires two separate configs.</p>
        pub fn set_polarization(
            mut self,
            input: std::option::Option<crate::model::Polarization>,
        ) -> Self {
            self.polarization = input;
            self
        }
        /// Consumes the builder and constructs a [`UplinkSpectrumConfig`](crate::model::UplinkSpectrumConfig)
        pub fn build(self) -> crate::model::UplinkSpectrumConfig {
            crate::model::UplinkSpectrumConfig {
                center_frequency: self.center_frequency,
                polarization: self.polarization,
            }
        }
    }
}
impl UplinkSpectrumConfig {
    /// Creates a new builder-style object to manufacture [`UplinkSpectrumConfig`](crate::model::UplinkSpectrumConfig)
    pub fn builder() -> crate::model::uplink_spectrum_config::Builder {
        crate::model::uplink_spectrum_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Polarization {
    #[allow(missing_docs)] // documentation missing in model
    LeftHand,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    RightHand,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Polarization {
    fn from(s: &str) -> Self {
        match s {
            "LEFT_HAND" => Polarization::LeftHand,
            "NONE" => Polarization::None,
            "RIGHT_HAND" => Polarization::RightHand,
            other => Polarization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Polarization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Polarization::from(s))
    }
}
impl Polarization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Polarization::LeftHand => "LEFT_HAND",
            Polarization::None => "NONE",
            Polarization::RightHand => "RIGHT_HAND",
            Polarization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LEFT_HAND", "NONE", "RIGHT_HAND"]
    }
}
impl AsRef<str> for Polarization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Object that describes the frequency.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Frequency {
    /// <p>Frequency value. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.</p>
    pub value: std::option::Option<f64>,
    /// <p>Frequency units.</p>
    pub units: std::option::Option<crate::model::FrequencyUnits>,
}
impl std::fmt::Debug for Frequency {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Frequency");
        formatter.field("value", &self.value);
        formatter.field("units", &self.units);
        formatter.finish()
    }
}
/// See [`Frequency`](crate::model::Frequency)
pub mod frequency {
    /// A builder for [`Frequency`](crate::model::Frequency)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<f64>,
        pub(crate) units: std::option::Option<crate::model::FrequencyUnits>,
    }
    impl Builder {
        /// <p>Frequency value. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Frequency value. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// <p>Frequency units.</p>
        pub fn units(mut self, input: crate::model::FrequencyUnits) -> Self {
            self.units = Some(input);
            self
        }
        /// <p>Frequency units.</p>
        pub fn set_units(
            mut self,
            input: std::option::Option<crate::model::FrequencyUnits>,
        ) -> Self {
            self.units = input;
            self
        }
        /// Consumes the builder and constructs a [`Frequency`](crate::model::Frequency)
        pub fn build(self) -> crate::model::Frequency {
            crate::model::Frequency {
                value: self.value,
                units: self.units,
            }
        }
    }
}
impl Frequency {
    /// Creates a new builder-style object to manufacture [`Frequency`](crate::model::Frequency)
    pub fn builder() -> crate::model::frequency::Builder {
        crate::model::frequency::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FrequencyUnits {
    #[allow(missing_docs)] // documentation missing in model
    Ghz,
    #[allow(missing_docs)] // documentation missing in model
    Mhz,
    #[allow(missing_docs)] // documentation missing in model
    Khz,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FrequencyUnits {
    fn from(s: &str) -> Self {
        match s {
            "GHz" => FrequencyUnits::Ghz,
            "MHz" => FrequencyUnits::Mhz,
            "kHz" => FrequencyUnits::Khz,
            other => FrequencyUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FrequencyUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FrequencyUnits::from(s))
    }
}
impl FrequencyUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FrequencyUnits::Ghz => "GHz",
            FrequencyUnits::Mhz => "MHz",
            FrequencyUnits::Khz => "kHz",
            FrequencyUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GHz", "MHz", "kHz"]
    }
}
impl AsRef<str> for FrequencyUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about how AWS Ground Station should conﬁgure an antenna for downlink demod decode during a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AntennaDownlinkDemodDecodeConfig {
    /// <p>Information about the spectral <code>Config</code>.</p>
    pub spectrum_config: std::option::Option<crate::model::SpectrumConfig>,
    /// <p>Information about the demodulation <code>Config</code>.</p>
    pub demodulation_config: std::option::Option<crate::model::DemodulationConfig>,
    /// <p>Information about the decode <code>Config</code>.</p>
    pub decode_config: std::option::Option<crate::model::DecodeConfig>,
}
impl std::fmt::Debug for AntennaDownlinkDemodDecodeConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AntennaDownlinkDemodDecodeConfig");
        formatter.field("spectrum_config", &self.spectrum_config);
        formatter.field("demodulation_config", &self.demodulation_config);
        formatter.field("decode_config", &self.decode_config);
        formatter.finish()
    }
}
/// See [`AntennaDownlinkDemodDecodeConfig`](crate::model::AntennaDownlinkDemodDecodeConfig)
pub mod antenna_downlink_demod_decode_config {
    /// A builder for [`AntennaDownlinkDemodDecodeConfig`](crate::model::AntennaDownlinkDemodDecodeConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) spectrum_config: std::option::Option<crate::model::SpectrumConfig>,
        pub(crate) demodulation_config: std::option::Option<crate::model::DemodulationConfig>,
        pub(crate) decode_config: std::option::Option<crate::model::DecodeConfig>,
    }
    impl Builder {
        /// <p>Information about the spectral <code>Config</code>.</p>
        pub fn spectrum_config(mut self, input: crate::model::SpectrumConfig) -> Self {
            self.spectrum_config = Some(input);
            self
        }
        /// <p>Information about the spectral <code>Config</code>.</p>
        pub fn set_spectrum_config(
            mut self,
            input: std::option::Option<crate::model::SpectrumConfig>,
        ) -> Self {
            self.spectrum_config = input;
            self
        }
        /// <p>Information about the demodulation <code>Config</code>.</p>
        pub fn demodulation_config(mut self, input: crate::model::DemodulationConfig) -> Self {
            self.demodulation_config = Some(input);
            self
        }
        /// <p>Information about the demodulation <code>Config</code>.</p>
        pub fn set_demodulation_config(
            mut self,
            input: std::option::Option<crate::model::DemodulationConfig>,
        ) -> Self {
            self.demodulation_config = input;
            self
        }
        /// <p>Information about the decode <code>Config</code>.</p>
        pub fn decode_config(mut self, input: crate::model::DecodeConfig) -> Self {
            self.decode_config = Some(input);
            self
        }
        /// <p>Information about the decode <code>Config</code>.</p>
        pub fn set_decode_config(
            mut self,
            input: std::option::Option<crate::model::DecodeConfig>,
        ) -> Self {
            self.decode_config = input;
            self
        }
        /// Consumes the builder and constructs a [`AntennaDownlinkDemodDecodeConfig`](crate::model::AntennaDownlinkDemodDecodeConfig)
        pub fn build(self) -> crate::model::AntennaDownlinkDemodDecodeConfig {
            crate::model::AntennaDownlinkDemodDecodeConfig {
                spectrum_config: self.spectrum_config,
                demodulation_config: self.demodulation_config,
                decode_config: self.decode_config,
            }
        }
    }
}
impl AntennaDownlinkDemodDecodeConfig {
    /// Creates a new builder-style object to manufacture [`AntennaDownlinkDemodDecodeConfig`](crate::model::AntennaDownlinkDemodDecodeConfig)
    pub fn builder() -> crate::model::antenna_downlink_demod_decode_config::Builder {
        crate::model::antenna_downlink_demod_decode_config::Builder::default()
    }
}

/// <p>Information about the decode <code>Config</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecodeConfig {
    /// <p>Unvalidated JSON of a decode <code>Config</code>.</p>
    pub unvalidated_json: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DecodeConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecodeConfig");
        formatter.field("unvalidated_json", &self.unvalidated_json);
        formatter.finish()
    }
}
/// See [`DecodeConfig`](crate::model::DecodeConfig)
pub mod decode_config {
    /// A builder for [`DecodeConfig`](crate::model::DecodeConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unvalidated_json: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unvalidated JSON of a decode <code>Config</code>.</p>
        pub fn unvalidated_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.unvalidated_json = Some(input.into());
            self
        }
        /// <p>Unvalidated JSON of a decode <code>Config</code>.</p>
        pub fn set_unvalidated_json(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.unvalidated_json = input;
            self
        }
        /// Consumes the builder and constructs a [`DecodeConfig`](crate::model::DecodeConfig)
        pub fn build(self) -> crate::model::DecodeConfig {
            crate::model::DecodeConfig {
                unvalidated_json: self.unvalidated_json,
            }
        }
    }
}
impl DecodeConfig {
    /// Creates a new builder-style object to manufacture [`DecodeConfig`](crate::model::DecodeConfig)
    pub fn builder() -> crate::model::decode_config::Builder {
        crate::model::decode_config::Builder::default()
    }
}

/// <p>Information about the demodulation <code>Config</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DemodulationConfig {
    /// <p>Unvalidated JSON of a demodulation <code>Config</code>.</p>
    pub unvalidated_json: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DemodulationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DemodulationConfig");
        formatter.field("unvalidated_json", &self.unvalidated_json);
        formatter.finish()
    }
}
/// See [`DemodulationConfig`](crate::model::DemodulationConfig)
pub mod demodulation_config {
    /// A builder for [`DemodulationConfig`](crate::model::DemodulationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unvalidated_json: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unvalidated JSON of a demodulation <code>Config</code>.</p>
        pub fn unvalidated_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.unvalidated_json = Some(input.into());
            self
        }
        /// <p>Unvalidated JSON of a demodulation <code>Config</code>.</p>
        pub fn set_unvalidated_json(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.unvalidated_json = input;
            self
        }
        /// Consumes the builder and constructs a [`DemodulationConfig`](crate::model::DemodulationConfig)
        pub fn build(self) -> crate::model::DemodulationConfig {
            crate::model::DemodulationConfig {
                unvalidated_json: self.unvalidated_json,
            }
        }
    }
}
impl DemodulationConfig {
    /// Creates a new builder-style object to manufacture [`DemodulationConfig`](crate::model::DemodulationConfig)
    pub fn builder() -> crate::model::demodulation_config::Builder {
        crate::model::demodulation_config::Builder::default()
    }
}

/// <p>Object that describes a spectral <code>Config</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SpectrumConfig {
    /// <p>Center frequency of a spectral <code>Config</code>. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.</p>
    pub center_frequency: std::option::Option<crate::model::Frequency>,
    /// <p>Bandwidth of a spectral <code>Config</code>. AWS Ground Station currently has the following bandwidth limitations:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.</p>
    /// </li>
    /// <li>
    /// <p>For <code>AntennaDownlinkconfig</code> valid values are between 10 kHz to 54 MHz.</p>
    /// </li>
    /// <li>
    /// <p>For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.</p>
    /// </li>
    /// </ul>
    pub bandwidth: std::option::Option<crate::model::FrequencyBandwidth>,
    /// <p>Polarization of a spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and <code>"LEFT_HAND"</code> polarization requires two separate configs.</p>
    pub polarization: std::option::Option<crate::model::Polarization>,
}
impl std::fmt::Debug for SpectrumConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SpectrumConfig");
        formatter.field("center_frequency", &self.center_frequency);
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("polarization", &self.polarization);
        formatter.finish()
    }
}
/// See [`SpectrumConfig`](crate::model::SpectrumConfig)
pub mod spectrum_config {
    /// A builder for [`SpectrumConfig`](crate::model::SpectrumConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) center_frequency: std::option::Option<crate::model::Frequency>,
        pub(crate) bandwidth: std::option::Option<crate::model::FrequencyBandwidth>,
        pub(crate) polarization: std::option::Option<crate::model::Polarization>,
    }
    impl Builder {
        /// <p>Center frequency of a spectral <code>Config</code>. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.</p>
        pub fn center_frequency(mut self, input: crate::model::Frequency) -> Self {
            self.center_frequency = Some(input);
            self
        }
        /// <p>Center frequency of a spectral <code>Config</code>. Valid values are between 2200 to 2300 MHz and 7750 to 8400 MHz for downlink and 2025 to 2120 MHz for uplink.</p>
        pub fn set_center_frequency(
            mut self,
            input: std::option::Option<crate::model::Frequency>,
        ) -> Self {
            self.center_frequency = input;
            self
        }
        /// <p>Bandwidth of a spectral <code>Config</code>. AWS Ground Station currently has the following bandwidth limitations:</p>
        /// <ul>
        /// <li>
        /// <p>For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.</p>
        /// </li>
        /// <li>
        /// <p>For <code>AntennaDownlinkconfig</code> valid values are between 10 kHz to 54 MHz.</p>
        /// </li>
        /// <li>
        /// <p>For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.</p>
        /// </li>
        /// </ul>
        pub fn bandwidth(mut self, input: crate::model::FrequencyBandwidth) -> Self {
            self.bandwidth = Some(input);
            self
        }
        /// <p>Bandwidth of a spectral <code>Config</code>. AWS Ground Station currently has the following bandwidth limitations:</p>
        /// <ul>
        /// <li>
        /// <p>For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.</p>
        /// </li>
        /// <li>
        /// <p>For <code>AntennaDownlinkconfig</code> valid values are between 10 kHz to 54 MHz.</p>
        /// </li>
        /// <li>
        /// <p>For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.</p>
        /// </li>
        /// </ul>
        pub fn set_bandwidth(
            mut self,
            input: std::option::Option<crate::model::FrequencyBandwidth>,
        ) -> Self {
            self.bandwidth = input;
            self
        }
        /// <p>Polarization of a spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and <code>"LEFT_HAND"</code> polarization requires two separate configs.</p>
        pub fn polarization(mut self, input: crate::model::Polarization) -> Self {
            self.polarization = Some(input);
            self
        }
        /// <p>Polarization of a spectral <code>Config</code>. Capturing both <code>"RIGHT_HAND"</code> and <code>"LEFT_HAND"</code> polarization requires two separate configs.</p>
        pub fn set_polarization(
            mut self,
            input: std::option::Option<crate::model::Polarization>,
        ) -> Self {
            self.polarization = input;
            self
        }
        /// Consumes the builder and constructs a [`SpectrumConfig`](crate::model::SpectrumConfig)
        pub fn build(self) -> crate::model::SpectrumConfig {
            crate::model::SpectrumConfig {
                center_frequency: self.center_frequency,
                bandwidth: self.bandwidth,
                polarization: self.polarization,
            }
        }
    }
}
impl SpectrumConfig {
    /// Creates a new builder-style object to manufacture [`SpectrumConfig`](crate::model::SpectrumConfig)
    pub fn builder() -> crate::model::spectrum_config::Builder {
        crate::model::spectrum_config::Builder::default()
    }
}

/// <p>Object that describes the frequency bandwidth. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FrequencyBandwidth {
    /// <p>Frequency bandwidth value. AWS Ground Station currently has the following bandwidth limitations:</p>
    /// <ul>
    /// <li>
    /// <p>For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.</p>
    /// </li>
    /// <li>
    /// <p>For <code>AntennaDownlinkconfig</code>, valid values are between 10 kHz to 54 MHz.</p>
    /// </li>
    /// <li>
    /// <p>For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.</p>
    /// </li>
    /// </ul>
    pub value: std::option::Option<f64>,
    /// <p>Frequency bandwidth units.</p>
    pub units: std::option::Option<crate::model::BandwidthUnits>,
}
impl std::fmt::Debug for FrequencyBandwidth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FrequencyBandwidth");
        formatter.field("value", &self.value);
        formatter.field("units", &self.units);
        formatter.finish()
    }
}
/// See [`FrequencyBandwidth`](crate::model::FrequencyBandwidth)
pub mod frequency_bandwidth {
    /// A builder for [`FrequencyBandwidth`](crate::model::FrequencyBandwidth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<f64>,
        pub(crate) units: std::option::Option<crate::model::BandwidthUnits>,
    }
    impl Builder {
        /// <p>Frequency bandwidth value. AWS Ground Station currently has the following bandwidth limitations:</p>
        /// <ul>
        /// <li>
        /// <p>For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.</p>
        /// </li>
        /// <li>
        /// <p>For <code>AntennaDownlinkconfig</code>, valid values are between 10 kHz to 54 MHz.</p>
        /// </li>
        /// <li>
        /// <p>For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.</p>
        /// </li>
        /// </ul>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Frequency bandwidth value. AWS Ground Station currently has the following bandwidth limitations:</p>
        /// <ul>
        /// <li>
        /// <p>For <code>AntennaDownlinkDemodDecodeconfig</code>, valid values are between 125 kHz to 650 MHz.</p>
        /// </li>
        /// <li>
        /// <p>For <code>AntennaDownlinkconfig</code>, valid values are between 10 kHz to 54 MHz.</p>
        /// </li>
        /// <li>
        /// <p>For <code>AntennaUplinkConfig</code>, valid values are between 10 kHz to 54 MHz.</p>
        /// </li>
        /// </ul>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// <p>Frequency bandwidth units.</p>
        pub fn units(mut self, input: crate::model::BandwidthUnits) -> Self {
            self.units = Some(input);
            self
        }
        /// <p>Frequency bandwidth units.</p>
        pub fn set_units(
            mut self,
            input: std::option::Option<crate::model::BandwidthUnits>,
        ) -> Self {
            self.units = input;
            self
        }
        /// Consumes the builder and constructs a [`FrequencyBandwidth`](crate::model::FrequencyBandwidth)
        pub fn build(self) -> crate::model::FrequencyBandwidth {
            crate::model::FrequencyBandwidth {
                value: self.value,
                units: self.units,
            }
        }
    }
}
impl FrequencyBandwidth {
    /// Creates a new builder-style object to manufacture [`FrequencyBandwidth`](crate::model::FrequencyBandwidth)
    pub fn builder() -> crate::model::frequency_bandwidth::Builder {
        crate::model::frequency_bandwidth::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BandwidthUnits {
    #[allow(missing_docs)] // documentation missing in model
    Ghz,
    #[allow(missing_docs)] // documentation missing in model
    Mhz,
    #[allow(missing_docs)] // documentation missing in model
    Khz,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BandwidthUnits {
    fn from(s: &str) -> Self {
        match s {
            "GHz" => BandwidthUnits::Ghz,
            "MHz" => BandwidthUnits::Mhz,
            "kHz" => BandwidthUnits::Khz,
            other => BandwidthUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BandwidthUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BandwidthUnits::from(s))
    }
}
impl BandwidthUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BandwidthUnits::Ghz => "GHz",
            BandwidthUnits::Mhz => "MHz",
            BandwidthUnits::Khz => "kHz",
            BandwidthUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GHz", "MHz", "kHz"]
    }
}
impl AsRef<str> for BandwidthUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the dataflow endpoint <code>Config</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataflowEndpointConfig {
    /// <p>Name of a dataflow endpoint.</p>
    pub dataflow_endpoint_name: std::option::Option<std::string::String>,
    /// <p>Region of a dataflow endpoint.</p>
    pub dataflow_endpoint_region: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DataflowEndpointConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataflowEndpointConfig");
        formatter.field("dataflow_endpoint_name", &self.dataflow_endpoint_name);
        formatter.field("dataflow_endpoint_region", &self.dataflow_endpoint_region);
        formatter.finish()
    }
}
/// See [`DataflowEndpointConfig`](crate::model::DataflowEndpointConfig)
pub mod dataflow_endpoint_config {
    /// A builder for [`DataflowEndpointConfig`](crate::model::DataflowEndpointConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataflow_endpoint_name: std::option::Option<std::string::String>,
        pub(crate) dataflow_endpoint_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of a dataflow endpoint.</p>
        pub fn dataflow_endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataflow_endpoint_name = Some(input.into());
            self
        }
        /// <p>Name of a dataflow endpoint.</p>
        pub fn set_dataflow_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_name = input;
            self
        }
        /// <p>Region of a dataflow endpoint.</p>
        pub fn dataflow_endpoint_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataflow_endpoint_region = Some(input.into());
            self
        }
        /// <p>Region of a dataflow endpoint.</p>
        pub fn set_dataflow_endpoint_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_region = input;
            self
        }
        /// Consumes the builder and constructs a [`DataflowEndpointConfig`](crate::model::DataflowEndpointConfig)
        pub fn build(self) -> crate::model::DataflowEndpointConfig {
            crate::model::DataflowEndpointConfig {
                dataflow_endpoint_name: self.dataflow_endpoint_name,
                dataflow_endpoint_region: self.dataflow_endpoint_region,
            }
        }
    }
}
impl DataflowEndpointConfig {
    /// Creates a new builder-style object to manufacture [`DataflowEndpointConfig`](crate::model::DataflowEndpointConfig)
    pub fn builder() -> crate::model::dataflow_endpoint_config::Builder {
        crate::model::dataflow_endpoint_config::Builder::default()
    }
}

/// <p>Object that determines whether tracking should be used during a contact
/// executed with this <code>Config</code> in the mission profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrackingConfig {
    /// <p>Current setting for autotrack.</p>
    pub autotrack: std::option::Option<crate::model::Criticality>,
}
impl std::fmt::Debug for TrackingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrackingConfig");
        formatter.field("autotrack", &self.autotrack);
        formatter.finish()
    }
}
/// See [`TrackingConfig`](crate::model::TrackingConfig)
pub mod tracking_config {
    /// A builder for [`TrackingConfig`](crate::model::TrackingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) autotrack: std::option::Option<crate::model::Criticality>,
    }
    impl Builder {
        /// <p>Current setting for autotrack.</p>
        pub fn autotrack(mut self, input: crate::model::Criticality) -> Self {
            self.autotrack = Some(input);
            self
        }
        /// <p>Current setting for autotrack.</p>
        pub fn set_autotrack(
            mut self,
            input: std::option::Option<crate::model::Criticality>,
        ) -> Self {
            self.autotrack = input;
            self
        }
        /// Consumes the builder and constructs a [`TrackingConfig`](crate::model::TrackingConfig)
        pub fn build(self) -> crate::model::TrackingConfig {
            crate::model::TrackingConfig {
                autotrack: self.autotrack,
            }
        }
    }
}
impl TrackingConfig {
    /// Creates a new builder-style object to manufacture [`TrackingConfig`](crate::model::TrackingConfig)
    pub fn builder() -> crate::model::tracking_config::Builder {
        crate::model::tracking_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Criticality {
    #[allow(missing_docs)] // documentation missing in model
    Preferred,
    #[allow(missing_docs)] // documentation missing in model
    Removed,
    #[allow(missing_docs)] // documentation missing in model
    Required,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Criticality {
    fn from(s: &str) -> Self {
        match s {
            "PREFERRED" => Criticality::Preferred,
            "REMOVED" => Criticality::Removed,
            "REQUIRED" => Criticality::Required,
            other => Criticality::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Criticality {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Criticality::from(s))
    }
}
impl Criticality {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Criticality::Preferred => "PREFERRED",
            Criticality::Removed => "REMOVED",
            Criticality::Required => "REQUIRED",
            Criticality::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PREFERRED", "REMOVED", "REQUIRED"]
    }
}
impl AsRef<str> for Criticality {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about how AWS Ground Station should configure an
/// antenna for downlink during a contact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AntennaDownlinkConfig {
    /// <p>Object that describes a spectral <code>Config</code>.</p>
    pub spectrum_config: std::option::Option<crate::model::SpectrumConfig>,
}
impl std::fmt::Debug for AntennaDownlinkConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AntennaDownlinkConfig");
        formatter.field("spectrum_config", &self.spectrum_config);
        formatter.finish()
    }
}
/// See [`AntennaDownlinkConfig`](crate::model::AntennaDownlinkConfig)
pub mod antenna_downlink_config {
    /// A builder for [`AntennaDownlinkConfig`](crate::model::AntennaDownlinkConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) spectrum_config: std::option::Option<crate::model::SpectrumConfig>,
    }
    impl Builder {
        /// <p>Object that describes a spectral <code>Config</code>.</p>
        pub fn spectrum_config(mut self, input: crate::model::SpectrumConfig) -> Self {
            self.spectrum_config = Some(input);
            self
        }
        /// <p>Object that describes a spectral <code>Config</code>.</p>
        pub fn set_spectrum_config(
            mut self,
            input: std::option::Option<crate::model::SpectrumConfig>,
        ) -> Self {
            self.spectrum_config = input;
            self
        }
        /// Consumes the builder and constructs a [`AntennaDownlinkConfig`](crate::model::AntennaDownlinkConfig)
        pub fn build(self) -> crate::model::AntennaDownlinkConfig {
            crate::model::AntennaDownlinkConfig {
                spectrum_config: self.spectrum_config,
            }
        }
    }
}
impl AntennaDownlinkConfig {
    /// Creates a new builder-style object to manufacture [`AntennaDownlinkConfig`](crate::model::AntennaDownlinkConfig)
    pub fn builder() -> crate::model::antenna_downlink_config::Builder {
        crate::model::antenna_downlink_config::Builder::default()
    }
}
