// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CancelContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelContactError {
    /// Kind of error that occurred.
    pub kind: CancelContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelContactErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelContactErrorKind::DependencyException(_inner) => _inner.fmt(f),
            CancelContactErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CancelContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelContactError {
    fn code(&self) -> Option<&str> {
        CancelContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelContactError {
    /// Creates a new `CancelContactError`.
    pub fn new(kind: CancelContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelContactErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, CancelContactErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `CancelContactErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelContactErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelContactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CancelContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelContactErrorKind::DependencyException(_inner) => Some(_inner),
            CancelContactErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CancelContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConfigError {
    /// Kind of error that occurred.
    pub kind: CreateConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConfigErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Account limits for this resource have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConfigErrorKind::DependencyException(_inner) => _inner.fmt(f),
            CreateConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateConfigErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConfigError {
    fn code(&self) -> Option<&str> {
        CreateConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConfigError {
    /// Creates a new `CreateConfigError`.
    pub fn new(kind: CreateConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConfigErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, CreateConfigErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `CreateConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConfigErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConfigErrorKind::DependencyException(_inner) => Some(_inner),
            CreateConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateConfigErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataflowEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataflowEndpointGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDataflowEndpointGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataflowEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataflowEndpointGroupErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataflowEndpointGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataflowEndpointGroupErrorKind::DependencyException(_inner) => _inner.fmt(f),
            CreateDataflowEndpointGroupErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            CreateDataflowEndpointGroupErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateDataflowEndpointGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataflowEndpointGroupError {
    fn code(&self) -> Option<&str> {
        CreateDataflowEndpointGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataflowEndpointGroupError {
    /// Creates a new `CreateDataflowEndpointGroupError`.
    pub fn new(kind: CreateDataflowEndpointGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataflowEndpointGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataflowEndpointGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataflowEndpointGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataflowEndpointGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataflowEndpointGroupErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataflowEndpointGroupErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataflowEndpointGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataflowEndpointGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataflowEndpointGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataflowEndpointGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateDataflowEndpointGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataflowEndpointGroupErrorKind::DependencyException(_inner) => Some(_inner),
            CreateDataflowEndpointGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateDataflowEndpointGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDataflowEndpointGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMissionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMissionProfileError {
    /// Kind of error that occurred.
    pub kind: CreateMissionProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMissionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMissionProfileErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMissionProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMissionProfileErrorKind::DependencyException(_inner) => _inner.fmt(f),
            CreateMissionProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateMissionProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateMissionProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMissionProfileError {
    fn code(&self) -> Option<&str> {
        CreateMissionProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMissionProfileError {
    /// Creates a new `CreateMissionProfileError`.
    pub fn new(kind: CreateMissionProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMissionProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMissionProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMissionProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMissionProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMissionProfileErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMissionProfileErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMissionProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMissionProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMissionProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMissionProfileErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateMissionProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMissionProfileErrorKind::DependencyException(_inner) => Some(_inner),
            CreateMissionProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateMissionProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateMissionProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConfigErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConfigErrorKind::DependencyException(_inner) => _inner.fmt(f),
            DeleteConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConfigError {
    fn code(&self) -> Option<&str> {
        DeleteConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConfigError {
    /// Creates a new `DeleteConfigError`.
    pub fn new(kind: DeleteConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConfigErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, DeleteConfigErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `DeleteConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConfigErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConfigErrorKind::DependencyException(_inner) => Some(_inner),
            DeleteConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataflowEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDataflowEndpointGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDataflowEndpointGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataflowEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDataflowEndpointGroupErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDataflowEndpointGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDataflowEndpointGroupErrorKind::DependencyException(_inner) => _inner.fmt(f),
            DeleteDataflowEndpointGroupErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDataflowEndpointGroupErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDataflowEndpointGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDataflowEndpointGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDataflowEndpointGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDataflowEndpointGroupError {
    /// Creates a new `DeleteDataflowEndpointGroupError`.
    pub fn new(kind: DeleteDataflowEndpointGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDataflowEndpointGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDataflowEndpointGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDataflowEndpointGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDataflowEndpointGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDataflowEndpointGroupErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataflowEndpointGroupErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataflowEndpointGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataflowEndpointGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataflowEndpointGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataflowEndpointGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDataflowEndpointGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDataflowEndpointGroupErrorKind::DependencyException(_inner) => Some(_inner),
            DeleteDataflowEndpointGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteDataflowEndpointGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDataflowEndpointGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMissionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMissionProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteMissionProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMissionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMissionProfileErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMissionProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMissionProfileErrorKind::DependencyException(_inner) => _inner.fmt(f),
            DeleteMissionProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteMissionProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteMissionProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMissionProfileError {
    fn code(&self) -> Option<&str> {
        DeleteMissionProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMissionProfileError {
    /// Creates a new `DeleteMissionProfileError`.
    pub fn new(kind: DeleteMissionProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMissionProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMissionProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMissionProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMissionProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMissionProfileErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMissionProfileErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMissionProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMissionProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMissionProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMissionProfileErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteMissionProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMissionProfileErrorKind::DependencyException(_inner) => Some(_inner),
            DeleteMissionProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteMissionProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteMissionProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeContactError {
    /// Kind of error that occurred.
    pub kind: DescribeContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeContactErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeContactErrorKind::DependencyException(_inner) => _inner.fmt(f),
            DescribeContactErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeContactError {
    fn code(&self) -> Option<&str> {
        DescribeContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeContactError {
    /// Creates a new `DescribeContactError`.
    pub fn new(kind: DescribeContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeContactErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, DescribeContactErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `DescribeContactErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeContactErrorKind::DependencyException(_inner) => Some(_inner),
            DescribeContactErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConfigError {
    /// Kind of error that occurred.
    pub kind: GetConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConfigErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConfigErrorKind::DependencyException(_inner) => _inner.fmt(f),
            GetConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConfigError {
    fn code(&self) -> Option<&str> {
        GetConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConfigError {
    /// Creates a new `GetConfigError`.
    pub fn new(kind: GetConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConfigErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, GetConfigErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `GetConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, GetConfigErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `GetConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetConfigErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for GetConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConfigErrorKind::DependencyException(_inner) => Some(_inner),
            GetConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataflowEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataflowEndpointGroupError {
    /// Kind of error that occurred.
    pub kind: GetDataflowEndpointGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataflowEndpointGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataflowEndpointGroupErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataflowEndpointGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataflowEndpointGroupErrorKind::DependencyException(_inner) => _inner.fmt(f),
            GetDataflowEndpointGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetDataflowEndpointGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDataflowEndpointGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataflowEndpointGroupError {
    fn code(&self) -> Option<&str> {
        GetDataflowEndpointGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataflowEndpointGroupError {
    /// Creates a new `GetDataflowEndpointGroupError`.
    pub fn new(kind: GetDataflowEndpointGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataflowEndpointGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataflowEndpointGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataflowEndpointGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataflowEndpointGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDataflowEndpointGroupErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataflowEndpointGroupErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataflowEndpointGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataflowEndpointGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataflowEndpointGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataflowEndpointGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetDataflowEndpointGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataflowEndpointGroupErrorKind::DependencyException(_inner) => Some(_inner),
            GetDataflowEndpointGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetDataflowEndpointGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDataflowEndpointGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMinuteUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMinuteUsageError {
    /// Kind of error that occurred.
    pub kind: GetMinuteUsageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMinuteUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMinuteUsageErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMinuteUsageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMinuteUsageErrorKind::DependencyException(_inner) => _inner.fmt(f),
            GetMinuteUsageErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetMinuteUsageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMinuteUsageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMinuteUsageError {
    fn code(&self) -> Option<&str> {
        GetMinuteUsageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMinuteUsageError {
    /// Creates a new `GetMinuteUsageError`.
    pub fn new(kind: GetMinuteUsageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMinuteUsageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMinuteUsageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMinuteUsageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMinuteUsageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMinuteUsageErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, GetMinuteUsageErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `GetMinuteUsageErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMinuteUsageErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMinuteUsageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMinuteUsageErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetMinuteUsageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMinuteUsageErrorKind::DependencyException(_inner) => Some(_inner),
            GetMinuteUsageErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetMinuteUsageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMinuteUsageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMissionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMissionProfileError {
    /// Kind of error that occurred.
    pub kind: GetMissionProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMissionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMissionProfileErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMissionProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMissionProfileErrorKind::DependencyException(_inner) => _inner.fmt(f),
            GetMissionProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetMissionProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMissionProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMissionProfileError {
    fn code(&self) -> Option<&str> {
        GetMissionProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMissionProfileError {
    /// Creates a new `GetMissionProfileError`.
    pub fn new(kind: GetMissionProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMissionProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMissionProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMissionProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMissionProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMissionProfileErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMissionProfileErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMissionProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMissionProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMissionProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMissionProfileErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetMissionProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMissionProfileErrorKind::DependencyException(_inner) => Some(_inner),
            GetMissionProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetMissionProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMissionProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSatellite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSatelliteError {
    /// Kind of error that occurred.
    pub kind: GetSatelliteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSatellite` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSatelliteErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSatelliteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSatelliteErrorKind::DependencyException(_inner) => _inner.fmt(f),
            GetSatelliteErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetSatelliteErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSatelliteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSatelliteError {
    fn code(&self) -> Option<&str> {
        GetSatelliteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSatelliteError {
    /// Creates a new `GetSatelliteError`.
    pub fn new(kind: GetSatelliteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSatelliteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSatelliteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSatelliteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSatelliteErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSatelliteErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, GetSatelliteErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `GetSatelliteErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSatelliteErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSatelliteErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSatelliteErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetSatelliteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSatelliteErrorKind::DependencyException(_inner) => Some(_inner),
            GetSatelliteErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetSatelliteErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSatelliteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConfigsError {
    /// Kind of error that occurred.
    pub kind: ListConfigsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConfigsErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConfigsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConfigsErrorKind::DependencyException(_inner) => _inner.fmt(f),
            ListConfigsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListConfigsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListConfigsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConfigsError {
    fn code(&self) -> Option<&str> {
        ListConfigsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConfigsError {
    /// Creates a new `ListConfigsError`.
    pub fn new(kind: ListConfigsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConfigsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConfigsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConfigsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConfigsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConfigsErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, ListConfigsErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `ListConfigsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListConfigsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConfigsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListConfigsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConfigsErrorKind::DependencyException(_inner) => Some(_inner),
            ListConfigsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListConfigsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListConfigsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListContacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListContactsError {
    /// Kind of error that occurred.
    pub kind: ListContactsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListContacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListContactsErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListContactsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListContactsErrorKind::DependencyException(_inner) => _inner.fmt(f),
            ListContactsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListContactsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListContactsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListContactsError {
    fn code(&self) -> Option<&str> {
        ListContactsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListContactsError {
    /// Creates a new `ListContactsError`.
    pub fn new(kind: ListContactsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListContactsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListContactsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListContactsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListContactsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListContactsErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, ListContactsErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `ListContactsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListContactsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListContactsErrorKind::DependencyException(_inner) => Some(_inner),
            ListContactsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListContactsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListContactsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataflowEndpointGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataflowEndpointGroupsError {
    /// Kind of error that occurred.
    pub kind: ListDataflowEndpointGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataflowEndpointGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataflowEndpointGroupsErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataflowEndpointGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataflowEndpointGroupsErrorKind::DependencyException(_inner) => _inner.fmt(f),
            ListDataflowEndpointGroupsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListDataflowEndpointGroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDataflowEndpointGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataflowEndpointGroupsError {
    fn code(&self) -> Option<&str> {
        ListDataflowEndpointGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataflowEndpointGroupsError {
    /// Creates a new `ListDataflowEndpointGroupsError`.
    pub fn new(kind: ListDataflowEndpointGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataflowEndpointGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataflowEndpointGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataflowEndpointGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataflowEndpointGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDataflowEndpointGroupsErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataflowEndpointGroupsErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataflowEndpointGroupsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataflowEndpointGroupsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDataflowEndpointGroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataflowEndpointGroupsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListDataflowEndpointGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataflowEndpointGroupsErrorKind::DependencyException(_inner) => Some(_inner),
            ListDataflowEndpointGroupsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListDataflowEndpointGroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDataflowEndpointGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroundStations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroundStationsError {
    /// Kind of error that occurred.
    pub kind: ListGroundStationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroundStations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroundStationsErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroundStationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroundStationsErrorKind::DependencyException(_inner) => _inner.fmt(f),
            ListGroundStationsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListGroundStationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListGroundStationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroundStationsError {
    fn code(&self) -> Option<&str> {
        ListGroundStationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroundStationsError {
    /// Creates a new `ListGroundStationsError`.
    pub fn new(kind: ListGroundStationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroundStationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroundStationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroundStationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroundStationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGroundStationsErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroundStationsErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroundStationsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroundStationsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroundStationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroundStationsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListGroundStationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroundStationsErrorKind::DependencyException(_inner) => Some(_inner),
            ListGroundStationsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListGroundStationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListGroundStationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMissionProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMissionProfilesError {
    /// Kind of error that occurred.
    pub kind: ListMissionProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMissionProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMissionProfilesErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMissionProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMissionProfilesErrorKind::DependencyException(_inner) => _inner.fmt(f),
            ListMissionProfilesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListMissionProfilesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListMissionProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMissionProfilesError {
    fn code(&self) -> Option<&str> {
        ListMissionProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMissionProfilesError {
    /// Creates a new `ListMissionProfilesError`.
    pub fn new(kind: ListMissionProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMissionProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMissionProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMissionProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMissionProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMissionProfilesErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMissionProfilesErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMissionProfilesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMissionProfilesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMissionProfilesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMissionProfilesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListMissionProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMissionProfilesErrorKind::DependencyException(_inner) => Some(_inner),
            ListMissionProfilesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListMissionProfilesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListMissionProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSatellites` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSatellitesError {
    /// Kind of error that occurred.
    pub kind: ListSatellitesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSatellites` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSatellitesErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSatellitesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSatellitesErrorKind::DependencyException(_inner) => _inner.fmt(f),
            ListSatellitesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListSatellitesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListSatellitesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSatellitesError {
    fn code(&self) -> Option<&str> {
        ListSatellitesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSatellitesError {
    /// Creates a new `ListSatellitesError`.
    pub fn new(kind: ListSatellitesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSatellitesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSatellitesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSatellitesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSatellitesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSatellitesErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, ListSatellitesErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `ListSatellitesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSatellitesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSatellitesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSatellitesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListSatellitesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSatellitesErrorKind::DependencyException(_inner) => Some(_inner),
            ListSatellitesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListSatellitesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListSatellitesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::DependencyException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::DependencyException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReserveContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReserveContactError {
    /// Kind of error that occurred.
    pub kind: ReserveContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReserveContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReserveContactErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReserveContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReserveContactErrorKind::DependencyException(_inner) => _inner.fmt(f),
            ReserveContactErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ReserveContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ReserveContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReserveContactError {
    fn code(&self) -> Option<&str> {
        ReserveContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReserveContactError {
    /// Creates a new `ReserveContactError`.
    pub fn new(kind: ReserveContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReserveContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReserveContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReserveContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReserveContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReserveContactErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, ReserveContactErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `ReserveContactErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReserveContactErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ReserveContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReserveContactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ReserveContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReserveContactErrorKind::DependencyException(_inner) => Some(_inner),
            ReserveContactErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ReserveContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ReserveContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::DependencyException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::DependencyException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::DependencyException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::DependencyException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConfigErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConfigErrorKind::DependencyException(_inner) => _inner.fmt(f),
            UpdateConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConfigError {
    fn code(&self) -> Option<&str> {
        UpdateConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConfigError {
    /// Creates a new `UpdateConfigError`.
    pub fn new(kind: UpdateConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConfigErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(&self.kind, UpdateConfigErrorKind::DependencyException(_))
    }
    /// Returns `true` if the error kind is `UpdateConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConfigErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConfigErrorKind::DependencyException(_inner) => Some(_inner),
            UpdateConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMissionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMissionProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateMissionProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMissionProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMissionProfileErrorKind {
    /// <p>Dependency encountered an error.</p>
    DependencyException(crate::error::DependencyException),
    /// <p>One or more parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMissionProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMissionProfileErrorKind::DependencyException(_inner) => _inner.fmt(f),
            UpdateMissionProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateMissionProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateMissionProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMissionProfileError {
    fn code(&self) -> Option<&str> {
        UpdateMissionProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMissionProfileError {
    /// Creates a new `UpdateMissionProfileError`.
    pub fn new(kind: UpdateMissionProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMissionProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMissionProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMissionProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMissionProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMissionProfileErrorKind::DependencyException`.
    pub fn is_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMissionProfileErrorKind::DependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMissionProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMissionProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMissionProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMissionProfileErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateMissionProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMissionProfileErrorKind::DependencyException(_inner) => Some(_inner),
            UpdateMissionProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateMissionProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateMissionProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>One or more parameters are not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p/>
    pub parameter_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.field("parameter_name", &self.parameter_name);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) parameter_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p/>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p/>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
                parameter_name: self.parameter_name,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>Dependency encountered an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependencyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p/>
    pub parameter_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DependencyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependencyException");
        formatter.field("message", &self.message);
        formatter.field("parameter_name", &self.parameter_name);
        formatter.finish()
    }
}
impl DependencyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependencyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependencyException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependencyException {}
/// See [`DependencyException`](crate::error::DependencyException)
pub mod dependency_exception {
    /// A builder for [`DependencyException`](crate::error::DependencyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) parameter_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p/>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p/>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DependencyException`](crate::error::DependencyException)
        pub fn build(self) -> crate::error::DependencyException {
            crate::error::DependencyException {
                message: self.message,
                parameter_name: self.parameter_name,
            }
        }
    }
}
impl DependencyException {
    /// Creates a new builder-style object to manufacture [`DependencyException`](crate::error::DependencyException)
    pub fn builder() -> crate::error::dependency_exception::Builder {
        crate::error::dependency_exception::Builder::default()
    }
}

/// <p>Account limits for this resource have been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p/>
    pub parameter_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("parameter_name", &self.parameter_name);
        formatter.finish()
    }
}
impl ResourceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceLimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceLimitExceededException {}
/// See [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
pub mod resource_limit_exceeded_exception {
    /// A builder for [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) parameter_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p/>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p/>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
        pub fn build(self) -> crate::error::ResourceLimitExceededException {
            crate::error::ResourceLimitExceededException {
                message: self.message,
                parameter_name: self.parameter_name,
            }
        }
    }
}
impl ResourceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    pub fn builder() -> crate::error::resource_limit_exceeded_exception::Builder {
        crate::error::resource_limit_exceeded_exception::Builder::default()
    }
}
