// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CancelContactInput`](crate::input::CancelContactInput)
pub mod cancel_contact_input {
    /// A builder for [`CancelContactInput`](crate::input::CancelContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>UUID of a contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelContactInput`](crate::input::CancelContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelContactInput {
                contact_id: self.contact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelContactInputOperationOutputAlias = crate::operation::CancelContact;
#[doc(hidden)]
pub type CancelContactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelContactInput {
    /// Consumes the builder and constructs an Operation<[`CancelContact`](crate::operation::CancelContact)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelContact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.contact_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_id",
                        details: "cannot be empty or unset",
                    })?;
            let contact_id = aws_smithy_http::label::fmt_string(input_1, false);
            if contact_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "contact_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/contact/{contactId}", contactId = contact_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelContact",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelContactInput`](crate::input::CancelContactInput)
    pub fn builder() -> crate::input::cancel_contact_input::Builder {
        crate::input::cancel_contact_input::Builder::default()
    }
}

/// See [`CreateConfigInput`](crate::input::CreateConfigInput)
pub mod create_config_input {
    /// A builder for [`CreateConfigInput`](crate::input::CreateConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) config_data: std::option::Option<crate::model::ConfigTypeData>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Name of a <code>Config</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn config_data(mut self, input: crate::model::ConfigTypeData) -> Self {
            self.config_data = Some(input);
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn set_config_data(
            mut self,
            input: std::option::Option<crate::model::ConfigTypeData>,
        ) -> Self {
            self.config_data = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a <code>Config</code>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to a <code>Config</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConfigInput`](crate::input::CreateConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConfigInput {
                name: self.name,
                config_data: self.config_data,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConfigInputOperationOutputAlias = crate::operation::CreateConfig;
#[doc(hidden)]
pub type CreateConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateConfig`](crate::operation::CreateConfig)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/config").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_config(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConfig",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConfigInput`](crate::input::CreateConfigInput)
    pub fn builder() -> crate::input::create_config_input::Builder {
        crate::input::create_config_input::Builder::default()
    }
}

/// See [`CreateDataflowEndpointGroupInput`](crate::input::CreateDataflowEndpointGroupInput)
pub mod create_dataflow_endpoint_group_input {
    /// A builder for [`CreateDataflowEndpointGroupInput`](crate::input::CreateDataflowEndpointGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_details:
            std::option::Option<std::vec::Vec<crate::model::EndpointDetails>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `endpoint_details`.
        ///
        /// To override the contents of this collection use [`set_endpoint_details`](Self::set_endpoint_details).
        ///
        /// <p>Endpoint details of each endpoint in the dataflow endpoint group.</p>
        pub fn endpoint_details(mut self, input: impl Into<crate::model::EndpointDetails>) -> Self {
            let mut v = self.endpoint_details.unwrap_or_default();
            v.push(input.into());
            self.endpoint_details = Some(v);
            self
        }
        /// <p>Endpoint details of each endpoint in the dataflow endpoint group.</p>
        pub fn set_endpoint_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointDetails>>,
        ) -> Self {
            self.endpoint_details = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags of a dataflow endpoint group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags of a dataflow endpoint group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataflowEndpointGroupInput`](crate::input::CreateDataflowEndpointGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataflowEndpointGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataflowEndpointGroupInput {
                endpoint_details: self.endpoint_details,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataflowEndpointGroupInputOperationOutputAlias =
    crate::operation::CreateDataflowEndpointGroup;
#[doc(hidden)]
pub type CreateDataflowEndpointGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDataflowEndpointGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataflowEndpointGroup`](crate::operation::CreateDataflowEndpointGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataflowEndpointGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataflowEndpointGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/dataflowEndpointGroup").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataflowEndpointGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataflowEndpointGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_dataflow_endpoint_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataflowEndpointGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataflowEndpointGroup",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataflowEndpointGroupInput`](crate::input::CreateDataflowEndpointGroupInput)
    pub fn builder() -> crate::input::create_dataflow_endpoint_group_input::Builder {
        crate::input::create_dataflow_endpoint_group_input::Builder::default()
    }
}

/// See [`CreateMissionProfileInput`](crate::input::CreateMissionProfileInput)
pub mod create_mission_profile_input {
    /// A builder for [`CreateMissionProfileInput`](crate::input::CreateMissionProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) contact_pre_pass_duration_seconds: std::option::Option<i32>,
        pub(crate) contact_post_pass_duration_seconds: std::option::Option<i32>,
        pub(crate) minimum_viable_contact_duration_seconds: std::option::Option<i32>,
        pub(crate) dataflow_edges:
            std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        pub(crate) tracking_config_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Name of a mission profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn contact_pre_pass_duration_seconds(mut self, input: i32) -> Self {
            self.contact_pre_pass_duration_seconds = Some(input);
            self
        }
        /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
        pub fn set_contact_pre_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.contact_pre_pass_duration_seconds = input;
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn contact_post_pass_duration_seconds(mut self, input: i32) -> Self {
            self.contact_post_pass_duration_seconds = Some(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_contact_post_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.contact_post_pass_duration_seconds = input;
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn minimum_viable_contact_duration_seconds(mut self, input: i32) -> Self {
            self.minimum_viable_contact_duration_seconds = Some(input);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn set_minimum_viable_contact_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.minimum_viable_contact_duration_seconds = input;
            self
        }
        /// Appends an item to `dataflow_edges`.
        ///
        /// To override the contents of this collection use [`set_dataflow_edges`](Self::set_dataflow_edges).
        ///
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
        /// <code>Config</code> and a <i>to</i>
        /// <code>Config</code>.</p>
        pub fn dataflow_edges(
            mut self,
            input: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut v = self.dataflow_edges.unwrap_or_default();
            v.push(input.into());
            self.dataflow_edges = Some(v);
            self
        }
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
        /// <code>Config</code> and a <i>to</i>
        /// <code>Config</code>.</p>
        pub fn set_dataflow_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.dataflow_edges = input;
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn tracking_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracking_config_arn = Some(input.into());
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn set_tracking_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tracking_config_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a mission profile.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to a mission profile.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMissionProfileInput`](crate::input::CreateMissionProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMissionProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMissionProfileInput {
                name: self.name,
                contact_pre_pass_duration_seconds: self.contact_pre_pass_duration_seconds,
                contact_post_pass_duration_seconds: self.contact_post_pass_duration_seconds,
                minimum_viable_contact_duration_seconds: self
                    .minimum_viable_contact_duration_seconds,
                dataflow_edges: self.dataflow_edges,
                tracking_config_arn: self.tracking_config_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMissionProfileInputOperationOutputAlias = crate::operation::CreateMissionProfile;
#[doc(hidden)]
pub type CreateMissionProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateMissionProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateMissionProfile`](crate::operation::CreateMissionProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMissionProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMissionProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/missionprofile").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMissionProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMissionProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_mission_profile(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMissionProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMissionProfile",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMissionProfileInput`](crate::input::CreateMissionProfileInput)
    pub fn builder() -> crate::input::create_mission_profile_input::Builder {
        crate::input::create_mission_profile_input::Builder::default()
    }
}

/// See [`DeleteConfigInput`](crate::input::DeleteConfigInput)
pub mod delete_config_input {
    /// A builder for [`DeleteConfigInput`](crate::input::DeleteConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) config_type: std::option::Option<crate::model::ConfigCapabilityType>,
    }
    impl Builder {
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.config_type = Some(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.config_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConfigInput`](crate::input::DeleteConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConfigInput {
                config_id: self.config_id,
                config_type: self.config_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConfigInputOperationOutputAlias = crate::operation::DeleteConfig;
#[doc(hidden)]
pub type DeleteConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConfig`](crate::operation::DeleteConfig)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.config_type;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_type",
                        details: "cannot be empty or unset",
                    })?;
            let config_type = aws_smithy_http::label::fmt_string(input_2, false);
            if config_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_type",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.config_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_id",
                        details: "cannot be empty or unset",
                    })?;
            let config_id = aws_smithy_http::label::fmt_string(input_3, false);
            if config_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/config/{configType}/{configId}",
                configType = config_type,
                configId = config_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConfig",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConfigInput`](crate::input::DeleteConfigInput)
    pub fn builder() -> crate::input::delete_config_input::Builder {
        crate::input::delete_config_input::Builder::default()
    }
}

/// See [`DeleteDataflowEndpointGroupInput`](crate::input::DeleteDataflowEndpointGroupInput)
pub mod delete_dataflow_endpoint_group_input {
    /// A builder for [`DeleteDataflowEndpointGroupInput`](crate::input::DeleteDataflowEndpointGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataflow_endpoint_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataflow_endpoint_group_id = Some(input.into());
            self
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataflowEndpointGroupInput`](crate::input::DeleteDataflowEndpointGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDataflowEndpointGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDataflowEndpointGroupInput {
                dataflow_endpoint_group_id: self.dataflow_endpoint_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDataflowEndpointGroupInputOperationOutputAlias =
    crate::operation::DeleteDataflowEndpointGroup;
#[doc(hidden)]
pub type DeleteDataflowEndpointGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDataflowEndpointGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataflowEndpointGroup`](crate::operation::DeleteDataflowEndpointGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataflowEndpointGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDataflowEndpointGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.dataflow_endpoint_group_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataflow_endpoint_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let dataflow_endpoint_group_id = aws_smithy_http::label::fmt_string(input_4, false);
            if dataflow_endpoint_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dataflow_endpoint_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/dataflowEndpointGroup/{dataflowEndpointGroupId}",
                dataflowEndpointGroupId = dataflow_endpoint_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDataflowEndpointGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDataflowEndpointGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataflowEndpointGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataflowEndpointGroup",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDataflowEndpointGroupInput`](crate::input::DeleteDataflowEndpointGroupInput)
    pub fn builder() -> crate::input::delete_dataflow_endpoint_group_input::Builder {
        crate::input::delete_dataflow_endpoint_group_input::Builder::default()
    }
}

/// See [`DeleteMissionProfileInput`](crate::input::DeleteMissionProfileInput)
pub mod delete_mission_profile_input {
    /// A builder for [`DeleteMissionProfileInput`](crate::input::DeleteMissionProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mission_profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_id = Some(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMissionProfileInput`](crate::input::DeleteMissionProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMissionProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMissionProfileInput {
                mission_profile_id: self.mission_profile_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMissionProfileInputOperationOutputAlias = crate::operation::DeleteMissionProfile;
#[doc(hidden)]
pub type DeleteMissionProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteMissionProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMissionProfile`](crate::operation::DeleteMissionProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMissionProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMissionProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.mission_profile_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mission_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let mission_profile_id = aws_smithy_http::label::fmt_string(input_5, false);
            if mission_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "mission_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/missionprofile/{missionProfileId}",
                missionProfileId = mission_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMissionProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMissionProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMissionProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMissionProfile",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMissionProfileInput`](crate::input::DeleteMissionProfileInput)
    pub fn builder() -> crate::input::delete_mission_profile_input::Builder {
        crate::input::delete_mission_profile_input::Builder::default()
    }
}

/// See [`DescribeContactInput`](crate::input::DescribeContactInput)
pub mod describe_contact_input {
    /// A builder for [`DescribeContactInput`](crate::input::DescribeContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>UUID of a contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContactInput`](crate::input::DescribeContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeContactInput {
                contact_id: self.contact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeContactInputOperationOutputAlias = crate::operation::DescribeContact;
#[doc(hidden)]
pub type DescribeContactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeContactInput {
    /// Consumes the builder and constructs an Operation<[`DescribeContact`](crate::operation::DescribeContact)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeContact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.contact_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_id",
                        details: "cannot be empty or unset",
                    })?;
            let contact_id = aws_smithy_http::label::fmt_string(input_6, false);
            if contact_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "contact_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/contact/{contactId}", contactId = contact_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeContact",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeContactInput`](crate::input::DescribeContactInput)
    pub fn builder() -> crate::input::describe_contact_input::Builder {
        crate::input::describe_contact_input::Builder::default()
    }
}

/// See [`GetConfigInput`](crate::input::GetConfigInput)
pub mod get_config_input {
    /// A builder for [`GetConfigInput`](crate::input::GetConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) config_type: std::option::Option<crate::model::ConfigCapabilityType>,
    }
    impl Builder {
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.config_type = Some(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.config_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConfigInput`](crate::input::GetConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetConfigInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetConfigInput {
                config_id: self.config_id,
                config_type: self.config_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConfigInputOperationOutputAlias = crate::operation::GetConfig;
#[doc(hidden)]
pub type GetConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetConfig`](crate::operation::GetConfig)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.config_type;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_type",
                        details: "cannot be empty or unset",
                    })?;
            let config_type = aws_smithy_http::label::fmt_string(input_7, false);
            if config_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_type",
                    details: "cannot be empty or unset",
                });
            }
            let input_8 = &_input.config_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_id",
                        details: "cannot be empty or unset",
                    })?;
            let config_id = aws_smithy_http::label::fmt_string(input_8, false);
            if config_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/config/{configType}/{configId}",
                configType = config_type,
                configId = config_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetConfig::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetConfig",
                    "groundstation",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConfigInput`](crate::input::GetConfigInput)
    pub fn builder() -> crate::input::get_config_input::Builder {
        crate::input::get_config_input::Builder::default()
    }
}

/// See [`GetDataflowEndpointGroupInput`](crate::input::GetDataflowEndpointGroupInput)
pub mod get_dataflow_endpoint_group_input {
    /// A builder for [`GetDataflowEndpointGroupInput`](crate::input::GetDataflowEndpointGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataflow_endpoint_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn dataflow_endpoint_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataflow_endpoint_group_id = Some(input.into());
            self
        }
        /// <p>UUID of a dataflow endpoint group.</p>
        pub fn set_dataflow_endpoint_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dataflow_endpoint_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataflowEndpointGroupInput`](crate::input::GetDataflowEndpointGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDataflowEndpointGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDataflowEndpointGroupInput {
                dataflow_endpoint_group_id: self.dataflow_endpoint_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDataflowEndpointGroupInputOperationOutputAlias =
    crate::operation::GetDataflowEndpointGroup;
#[doc(hidden)]
pub type GetDataflowEndpointGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDataflowEndpointGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetDataflowEndpointGroup`](crate::operation::GetDataflowEndpointGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDataflowEndpointGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDataflowEndpointGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.dataflow_endpoint_group_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataflow_endpoint_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let dataflow_endpoint_group_id = aws_smithy_http::label::fmt_string(input_9, false);
            if dataflow_endpoint_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "dataflow_endpoint_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/dataflowEndpointGroup/{dataflowEndpointGroupId}",
                dataflowEndpointGroupId = dataflow_endpoint_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDataflowEndpointGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDataflowEndpointGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDataflowEndpointGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDataflowEndpointGroup",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDataflowEndpointGroupInput`](crate::input::GetDataflowEndpointGroupInput)
    pub fn builder() -> crate::input::get_dataflow_endpoint_group_input::Builder {
        crate::input::get_dataflow_endpoint_group_input::Builder::default()
    }
}

/// See [`GetMinuteUsageInput`](crate::input::GetMinuteUsageInput)
pub mod get_minute_usage_input {
    /// A builder for [`GetMinuteUsageInput`](crate::input::GetMinuteUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) month: std::option::Option<i32>,
        pub(crate) year: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The month being requested, with a value of 1-12.</p>
        pub fn month(mut self, input: i32) -> Self {
            self.month = Some(input);
            self
        }
        /// <p>The month being requested, with a value of 1-12.</p>
        pub fn set_month(mut self, input: std::option::Option<i32>) -> Self {
            self.month = input;
            self
        }
        /// <p>The year being requested, in the format of YYYY.</p>
        pub fn year(mut self, input: i32) -> Self {
            self.year = Some(input);
            self
        }
        /// <p>The year being requested, in the format of YYYY.</p>
        pub fn set_year(mut self, input: std::option::Option<i32>) -> Self {
            self.year = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMinuteUsageInput`](crate::input::GetMinuteUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMinuteUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMinuteUsageInput {
                month: self.month,
                year: self.year,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMinuteUsageInputOperationOutputAlias = crate::operation::GetMinuteUsage;
#[doc(hidden)]
pub type GetMinuteUsageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMinuteUsageInput {
    /// Consumes the builder and constructs an Operation<[`GetMinuteUsage`](crate::operation::GetMinuteUsage)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMinuteUsage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMinuteUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/minute-usage").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMinuteUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMinuteUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_minute_usage(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMinuteUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMinuteUsage",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMinuteUsageInput`](crate::input::GetMinuteUsageInput)
    pub fn builder() -> crate::input::get_minute_usage_input::Builder {
        crate::input::get_minute_usage_input::Builder::default()
    }
}

/// See [`GetMissionProfileInput`](crate::input::GetMissionProfileInput)
pub mod get_mission_profile_input {
    /// A builder for [`GetMissionProfileInput`](crate::input::GetMissionProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mission_profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_id = Some(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMissionProfileInput`](crate::input::GetMissionProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMissionProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMissionProfileInput {
                mission_profile_id: self.mission_profile_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMissionProfileInputOperationOutputAlias = crate::operation::GetMissionProfile;
#[doc(hidden)]
pub type GetMissionProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMissionProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetMissionProfile`](crate::operation::GetMissionProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMissionProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMissionProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.mission_profile_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mission_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let mission_profile_id = aws_smithy_http::label::fmt_string(input_10, false);
            if mission_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "mission_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/missionprofile/{missionProfileId}",
                missionProfileId = mission_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMissionProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMissionProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMissionProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMissionProfile",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMissionProfileInput`](crate::input::GetMissionProfileInput)
    pub fn builder() -> crate::input::get_mission_profile_input::Builder {
        crate::input::get_mission_profile_input::Builder::default()
    }
}

/// See [`GetSatelliteInput`](crate::input::GetSatelliteInput)
pub mod get_satellite_input {
    /// A builder for [`GetSatelliteInput`](crate::input::GetSatelliteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) satellite_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a satellite.</p>
        pub fn satellite_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.satellite_id = Some(input.into());
            self
        }
        /// <p>UUID of a satellite.</p>
        pub fn set_satellite_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.satellite_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSatelliteInput`](crate::input::GetSatelliteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSatelliteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSatelliteInput {
                satellite_id: self.satellite_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSatelliteInputOperationOutputAlias = crate::operation::GetSatellite;
#[doc(hidden)]
pub type GetSatelliteInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSatelliteInput {
    /// Consumes the builder and constructs an Operation<[`GetSatellite`](crate::operation::GetSatellite)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSatellite,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSatelliteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.satellite_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "satellite_id",
                        details: "cannot be empty or unset",
                    })?;
            let satellite_id = aws_smithy_http::label::fmt_string(input_11, false);
            if satellite_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "satellite_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/satellite/{satelliteId}",
                satelliteId = satellite_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSatelliteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSatelliteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSatellite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSatellite",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSatelliteInput`](crate::input::GetSatelliteInput)
    pub fn builder() -> crate::input::get_satellite_input::Builder {
        crate::input::get_satellite_input::Builder::default()
    }
}

/// See [`ListConfigsInput`](crate::input::ListConfigsInput)
pub mod list_configs_input {
    /// A builder for [`ListConfigsInput`](crate::input::ListConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Maximum number of <code>Configs</code> returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of <code>Configs</code> returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConfigsInput`](crate::input::ListConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConfigsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConfigsInputOperationOutputAlias = crate::operation::ListConfigs;
#[doc(hidden)]
pub type ListConfigsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListConfigs`](crate::operation::ListConfigs)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConfigs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConfigsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/config").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListConfigsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_12) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_12).encode(),
                );
            }
            if let Some(inner_13) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_13));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConfigsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConfigsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConfigs",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConfigsInput`](crate::input::ListConfigsInput)
    pub fn builder() -> crate::input::list_configs_input::Builder {
        crate::input::list_configs_input::Builder::default()
    }
}

/// See [`ListContactsInput`](crate::input::ListContactsInput)
pub mod list_contacts_input {
    /// A builder for [`ListContactsInput`](crate::input::ListContactsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) status_list: std::option::Option<std::vec::Vec<crate::model::ContactStatus>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ground_station: std::option::Option<std::string::String>,
        pub(crate) satellite_arn: std::option::Option<std::string::String>,
        pub(crate) mission_profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Maximum number of contacts returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of contacts returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `status_list`.
        ///
        /// To override the contents of this collection use [`set_status_list`](Self::set_status_list).
        ///
        /// <p>Status of a contact reservation.</p>
        pub fn status_list(mut self, input: impl Into<crate::model::ContactStatus>) -> Self {
            let mut v = self.status_list.unwrap_or_default();
            v.push(input.into());
            self.status_list = Some(v);
            self
        }
        /// <p>Status of a contact reservation.</p>
        pub fn set_status_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactStatus>>,
        ) -> Self {
            self.status_list = input;
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>End time of a contact.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn ground_station(mut self, input: impl Into<std::string::String>) -> Self {
            self.ground_station = Some(input.into());
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn set_ground_station(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ground_station = input;
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn satellite_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.satellite_arn = Some(input.into());
            self
        }
        /// <p>ARN of a satellite.</p>
        pub fn set_satellite_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.satellite_arn = input;
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn mission_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_arn = Some(input.into());
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn set_mission_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactsInput`](crate::input::ListContactsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContactsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContactsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                status_list: self.status_list,
                start_time: self.start_time,
                end_time: self.end_time,
                ground_station: self.ground_station,
                satellite_arn: self.satellite_arn,
                mission_profile_arn: self.mission_profile_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListContactsInputOperationOutputAlias = crate::operation::ListContacts;
#[doc(hidden)]
pub type ListContactsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListContactsInput {
    /// Consumes the builder and constructs an Operation<[`ListContacts`](crate::operation::ListContacts)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContacts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListContactsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contacts").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListContactsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListContactsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_contacts(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContacts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContacts",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListContactsInput`](crate::input::ListContactsInput)
    pub fn builder() -> crate::input::list_contacts_input::Builder {
        crate::input::list_contacts_input::Builder::default()
    }
}

/// See [`ListDataflowEndpointGroupsInput`](crate::input::ListDataflowEndpointGroupsInput)
pub mod list_dataflow_endpoint_groups_input {
    /// A builder for [`ListDataflowEndpointGroupsInput`](crate::input::ListDataflowEndpointGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Maximum number of dataflow endpoint groups returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of dataflow endpoint groups returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataflowEndpointGroupsInput`](crate::input::ListDataflowEndpointGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataflowEndpointGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataflowEndpointGroupsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataflowEndpointGroupsInputOperationOutputAlias =
    crate::operation::ListDataflowEndpointGroups;
#[doc(hidden)]
pub type ListDataflowEndpointGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDataflowEndpointGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListDataflowEndpointGroups`](crate::operation::ListDataflowEndpointGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataflowEndpointGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDataflowEndpointGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/dataflowEndpointGroup").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDataflowEndpointGroupsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_14) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_14).encode(),
                );
            }
            if let Some(inner_15) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_15));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDataflowEndpointGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDataflowEndpointGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataflowEndpointGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataflowEndpointGroups",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDataflowEndpointGroupsInput`](crate::input::ListDataflowEndpointGroupsInput)
    pub fn builder() -> crate::input::list_dataflow_endpoint_groups_input::Builder {
        crate::input::list_dataflow_endpoint_groups_input::Builder::default()
    }
}

/// See [`ListGroundStationsInput`](crate::input::ListGroundStationsInput)
pub mod list_ground_stations_input {
    /// A builder for [`ListGroundStationsInput`](crate::input::ListGroundStationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) satellite_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Satellite ID to retrieve on-boarded ground stations.</p>
        pub fn satellite_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.satellite_id = Some(input.into());
            self
        }
        /// <p>Satellite ID to retrieve on-boarded ground stations.</p>
        pub fn set_satellite_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.satellite_id = input;
            self
        }
        /// <p>Maximum number of ground stations returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of ground stations returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroundStationsInput`](crate::input::ListGroundStationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroundStationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroundStationsInput {
                satellite_id: self.satellite_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroundStationsInputOperationOutputAlias = crate::operation::ListGroundStations;
#[doc(hidden)]
pub type ListGroundStationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGroundStationsInput {
    /// Consumes the builder and constructs an Operation<[`ListGroundStations`](crate::operation::ListGroundStations)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroundStations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroundStationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/groundstation").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListGroundStationsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_16) = &_input.satellite_id {
                query.push_kv(
                    "satelliteId",
                    &aws_smithy_http::query::fmt_string(&inner_16),
                );
            }
            if let Some(inner_17) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_17).encode(),
                );
            }
            if let Some(inner_18) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_18));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroundStationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroundStationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroundStations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroundStations",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroundStationsInput`](crate::input::ListGroundStationsInput)
    pub fn builder() -> crate::input::list_ground_stations_input::Builder {
        crate::input::list_ground_stations_input::Builder::default()
    }
}

/// See [`ListMissionProfilesInput`](crate::input::ListMissionProfilesInput)
pub mod list_mission_profiles_input {
    /// A builder for [`ListMissionProfilesInput`](crate::input::ListMissionProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Maximum number of mission profiles returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of mission profiles returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token returned in the request of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMissionProfilesInput`](crate::input::ListMissionProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMissionProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMissionProfilesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMissionProfilesInputOperationOutputAlias = crate::operation::ListMissionProfiles;
#[doc(hidden)]
pub type ListMissionProfilesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListMissionProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListMissionProfiles`](crate::operation::ListMissionProfiles)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMissionProfiles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMissionProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/missionprofile").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListMissionProfilesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_19) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_19).encode(),
                );
            }
            if let Some(inner_20) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_20));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMissionProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMissionProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMissionProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMissionProfiles",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMissionProfilesInput`](crate::input::ListMissionProfilesInput)
    pub fn builder() -> crate::input::list_mission_profiles_input::Builder {
        crate::input::list_mission_profiles_input::Builder::default()
    }
}

/// See [`ListSatellitesInput`](crate::input::ListSatellitesInput)
pub mod list_satellites_input {
    /// A builder for [`ListSatellitesInput`](crate::input::ListSatellitesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Maximum number of satellites returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of satellites returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSatellitesInput`](crate::input::ListSatellitesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSatellitesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSatellitesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSatellitesInputOperationOutputAlias = crate::operation::ListSatellites;
#[doc(hidden)]
pub type ListSatellitesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSatellitesInput {
    /// Consumes the builder and constructs an Operation<[`ListSatellites`](crate::operation::ListSatellites)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSatellites,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSatellitesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/satellite").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListSatellitesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_21) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_21).encode(),
                );
            }
            if let Some(inner_22) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_22));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSatellitesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSatellitesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSatellites::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSatellites",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSatellitesInput`](crate::input::ListSatellitesInput)
    pub fn builder() -> crate::input::list_satellites_input::Builder {
        crate::input::list_satellites_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>ARN of a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.resource_arn;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_23, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ReserveContactInput`](crate::input::ReserveContactInput)
pub mod reserve_contact_input {
    /// A builder for [`ReserveContactInput`](crate::input::ReserveContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mission_profile_arn: std::option::Option<std::string::String>,
        pub(crate) satellite_arn: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ground_station: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>ARN of a mission profile.</p>
        pub fn mission_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_arn = Some(input.into());
            self
        }
        /// <p>ARN of a mission profile.</p>
        pub fn set_mission_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_arn = input;
            self
        }
        /// <p>ARN of a satellite</p>
        pub fn satellite_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.satellite_arn = Some(input.into());
            self
        }
        /// <p>ARN of a satellite</p>
        pub fn set_satellite_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.satellite_arn = input;
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>Start time of a contact.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>End time of a contact.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>End time of a contact.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn ground_station(mut self, input: impl Into<std::string::String>) -> Self {
            self.ground_station = Some(input.into());
            self
        }
        /// <p>Name of a ground station.</p>
        pub fn set_ground_station(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ground_station = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a contact.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to a contact.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ReserveContactInput`](crate::input::ReserveContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ReserveContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ReserveContactInput {
                mission_profile_arn: self.mission_profile_arn,
                satellite_arn: self.satellite_arn,
                start_time: self.start_time,
                end_time: self.end_time,
                ground_station: self.ground_station,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type ReserveContactInputOperationOutputAlias = crate::operation::ReserveContact;
#[doc(hidden)]
pub type ReserveContactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ReserveContactInput {
    /// Consumes the builder and constructs an Operation<[`ReserveContact`](crate::operation::ReserveContact)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ReserveContact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ReserveContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ReserveContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ReserveContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_reserve_contact(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ReserveContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ReserveContact",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ReserveContactInput`](crate::input::ReserveContactInput)
    pub fn builder() -> crate::input::reserve_contact_input::Builder {
        crate::input::reserve_contact_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>ARN of a resource tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>ARN of a resource tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.resource_arn;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_24, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>ARN of a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>ARN of a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys of a resource tag.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Keys of a resource tag.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.resource_arn;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_25, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_26) = &_input.tag_keys {
                for inner_27 in inner_26 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_27));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateConfigInput`](crate::input::UpdateConfigInput)
pub mod update_config_input {
    /// A builder for [`UpdateConfigInput`](crate::input::UpdateConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) config_type: std::option::Option<crate::model::ConfigCapabilityType>,
        pub(crate) config_data: std::option::Option<crate::model::ConfigTypeData>,
    }
    impl Builder {
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>UUID of a <code>Config</code>.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a <code>Config</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn config_type(mut self, input: crate::model::ConfigCapabilityType) -> Self {
            self.config_type = Some(input);
            self
        }
        /// <p>Type of a <code>Config</code>.</p>
        pub fn set_config_type(
            mut self,
            input: std::option::Option<crate::model::ConfigCapabilityType>,
        ) -> Self {
            self.config_type = input;
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn config_data(mut self, input: crate::model::ConfigTypeData) -> Self {
            self.config_data = Some(input);
            self
        }
        /// <p>Parameters of a <code>Config</code>.</p>
        pub fn set_config_data(
            mut self,
            input: std::option::Option<crate::model::ConfigTypeData>,
        ) -> Self {
            self.config_data = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConfigInput`](crate::input::UpdateConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConfigInput {
                config_id: self.config_id,
                name: self.name,
                config_type: self.config_type,
                config_data: self.config_data,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConfigInputOperationOutputAlias = crate::operation::UpdateConfig;
#[doc(hidden)]
pub type UpdateConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConfig`](crate::operation::UpdateConfig)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.config_type;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_type",
                        details: "cannot be empty or unset",
                    })?;
            let config_type = aws_smithy_http::label::fmt_string(input_28, false);
            if config_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_type",
                    details: "cannot be empty or unset",
                });
            }
            let input_29 = &_input.config_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_id",
                        details: "cannot be empty or unset",
                    })?;
            let config_id = aws_smithy_http::label::fmt_string(input_29, false);
            if config_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/config/{configType}/{configId}",
                configType = config_type,
                configId = config_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_config(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConfig",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConfigInput`](crate::input::UpdateConfigInput)
    pub fn builder() -> crate::input::update_config_input::Builder {
        crate::input::update_config_input::Builder::default()
    }
}

/// See [`UpdateMissionProfileInput`](crate::input::UpdateMissionProfileInput)
pub mod update_mission_profile_input {
    /// A builder for [`UpdateMissionProfileInput`](crate::input::UpdateMissionProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mission_profile_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) contact_pre_pass_duration_seconds: std::option::Option<i32>,
        pub(crate) contact_post_pass_duration_seconds: std::option::Option<i32>,
        pub(crate) minimum_viable_contact_duration_seconds: std::option::Option<i32>,
        pub(crate) dataflow_edges:
            std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        pub(crate) tracking_config_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>UUID of a mission profile.</p>
        pub fn mission_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mission_profile_id = Some(input.into());
            self
        }
        /// <p>UUID of a mission profile.</p>
        pub fn set_mission_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mission_profile_id = input;
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of a mission profile.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn contact_pre_pass_duration_seconds(mut self, input: i32) -> Self {
            self.contact_pre_pass_duration_seconds = Some(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_contact_pre_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.contact_pre_pass_duration_seconds = input;
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn contact_post_pass_duration_seconds(mut self, input: i32) -> Self {
            self.contact_post_pass_duration_seconds = Some(input);
            self
        }
        /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
        pub fn set_contact_post_pass_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.contact_post_pass_duration_seconds = input;
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn minimum_viable_contact_duration_seconds(mut self, input: i32) -> Self {
            self.minimum_viable_contact_duration_seconds = Some(input);
            self
        }
        /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
        pub fn set_minimum_viable_contact_duration_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.minimum_viable_contact_duration_seconds = input;
            self
        }
        /// Appends an item to `dataflow_edges`.
        ///
        /// To override the contents of this collection use [`set_dataflow_edges`](Self::set_dataflow_edges).
        ///
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
        /// <code>Config</code> and a <i>to</i>
        /// <code>Config</code>.</p>
        pub fn dataflow_edges(
            mut self,
            input: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut v = self.dataflow_edges.unwrap_or_default();
            v.push(input.into());
            self.dataflow_edges = Some(v);
            self
        }
        /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
        /// <code>Config</code> and a <i>to</i>
        /// <code>Config</code>.</p>
        pub fn set_dataflow_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.dataflow_edges = input;
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn tracking_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracking_config_arn = Some(input.into());
            self
        }
        /// <p>ARN of a tracking <code>Config</code>.</p>
        pub fn set_tracking_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tracking_config_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMissionProfileInput`](crate::input::UpdateMissionProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMissionProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMissionProfileInput {
                mission_profile_id: self.mission_profile_id,
                name: self.name,
                contact_pre_pass_duration_seconds: self.contact_pre_pass_duration_seconds,
                contact_post_pass_duration_seconds: self.contact_post_pass_duration_seconds,
                minimum_viable_contact_duration_seconds: self
                    .minimum_viable_contact_duration_seconds,
                dataflow_edges: self.dataflow_edges,
                tracking_config_arn: self.tracking_config_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMissionProfileInputOperationOutputAlias = crate::operation::UpdateMissionProfile;
#[doc(hidden)]
pub type UpdateMissionProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateMissionProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMissionProfile`](crate::operation::UpdateMissionProfile)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMissionProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMissionProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.mission_profile_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mission_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let mission_profile_id = aws_smithy_http::label::fmt_string(input_30, false);
            if mission_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "mission_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/missionprofile/{missionProfileId}",
                missionProfileId = mission_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMissionProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMissionProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_mission_profile(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMissionProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMissionProfile",
            "groundstation",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMissionProfileInput`](crate::input::UpdateMissionProfileInput)
    pub fn builder() -> crate::input::update_mission_profile_input::Builder {
        crate::input::update_mission_profile_input::Builder::default()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSatellitesInput {
    /// <p>Maximum number of satellites returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Next token that can be supplied in the next call to get the next page of satellites.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSatellitesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSatellitesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSatelliteInput {
    /// <p>UUID of a satellite.</p>
    pub satellite_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSatelliteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSatelliteInput");
        formatter.field("satellite_id", &self.satellite_id);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMissionProfilesInput {
    /// <p>Maximum number of mission profiles returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Next token returned in the request of a previous <code>ListMissionProfiles</code> call. Used to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListMissionProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMissionProfilesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMissionProfileInput {
    /// <p>Name of a mission profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.</p>
    pub contact_pre_pass_duration_seconds: std::option::Option<i32>,
    /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    pub contact_post_pass_duration_seconds: std::option::Option<i32>,
    /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
    pub minimum_viable_contact_duration_seconds: std::option::Option<i32>,
    /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
    /// <code>Config</code> and a <i>to</i>
    /// <code>Config</code>.</p>
    pub dataflow_edges: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
    /// <p>ARN of a tracking <code>Config</code>.</p>
    pub tracking_config_arn: std::option::Option<std::string::String>,
    /// <p>Tags assigned to a mission profile.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateMissionProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMissionProfileInput");
        formatter.field("name", &self.name);
        formatter.field(
            "contact_pre_pass_duration_seconds",
            &self.contact_pre_pass_duration_seconds,
        );
        formatter.field(
            "contact_post_pass_duration_seconds",
            &self.contact_post_pass_duration_seconds,
        );
        formatter.field(
            "minimum_viable_contact_duration_seconds",
            &self.minimum_viable_contact_duration_seconds,
        );
        formatter.field("dataflow_edges", &self.dataflow_edges);
        formatter.field("tracking_config_arn", &self.tracking_config_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMissionProfileInput {
    /// <p>UUID of a mission profile.</p>
    pub mission_profile_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteMissionProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMissionProfileInput");
        formatter.field("mission_profile_id", &self.mission_profile_id);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMissionProfileInput {
    /// <p>UUID of a mission profile.</p>
    pub mission_profile_id: std::option::Option<std::string::String>,
    /// <p>Name of a mission profile.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    pub contact_pre_pass_duration_seconds: std::option::Option<i32>,
    /// <p>Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has finished.</p>
    pub contact_post_pass_duration_seconds: std::option::Option<i32>,
    /// <p>Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not present you with contacts shorter than this duration.</p>
    pub minimum_viable_contact_duration_seconds: std::option::Option<i32>,
    /// <p>A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i>
    /// <code>Config</code> and a <i>to</i>
    /// <code>Config</code>.</p>
    pub dataflow_edges: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
    /// <p>ARN of a tracking <code>Config</code>.</p>
    pub tracking_config_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateMissionProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMissionProfileInput");
        formatter.field("mission_profile_id", &self.mission_profile_id);
        formatter.field("name", &self.name);
        formatter.field(
            "contact_pre_pass_duration_seconds",
            &self.contact_pre_pass_duration_seconds,
        );
        formatter.field(
            "contact_post_pass_duration_seconds",
            &self.contact_post_pass_duration_seconds,
        );
        formatter.field(
            "minimum_viable_contact_duration_seconds",
            &self.minimum_viable_contact_duration_seconds,
        );
        formatter.field("dataflow_edges", &self.dataflow_edges);
        formatter.field("tracking_config_arn", &self.tracking_config_arn);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMissionProfileInput {
    /// <p>UUID of a mission profile.</p>
    pub mission_profile_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetMissionProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMissionProfileInput");
        formatter.field("mission_profile_id", &self.mission_profile_id);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroundStationsInput {
    /// <p>Satellite ID to retrieve on-boarded ground stations.</p>
    pub satellite_id: std::option::Option<std::string::String>,
    /// <p>Maximum number of ground stations returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Next token that can be supplied in the next call to get the next page of ground stations.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListGroundStationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroundStationsInput");
        formatter.field("satellite_id", &self.satellite_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataflowEndpointGroupsInput {
    /// <p>Maximum number of dataflow endpoint groups returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Next token returned in the request of a previous <code>ListDataflowEndpointGroups</code> call. Used to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDataflowEndpointGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataflowEndpointGroupsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataflowEndpointGroupInput {
    /// <p>Endpoint details of each endpoint in the dataflow endpoint group.</p>
    pub endpoint_details: std::option::Option<std::vec::Vec<crate::model::EndpointDetails>>,
    /// <p>Tags of a dataflow endpoint group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateDataflowEndpointGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataflowEndpointGroupInput");
        formatter.field("endpoint_details", &self.endpoint_details);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataflowEndpointGroupInput {
    /// <p>UUID of a dataflow endpoint group.</p>
    pub dataflow_endpoint_group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDataflowEndpointGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataflowEndpointGroupInput");
        formatter.field(
            "dataflow_endpoint_group_id",
            &self.dataflow_endpoint_group_id,
        );
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataflowEndpointGroupInput {
    /// <p>UUID of a dataflow endpoint group.</p>
    pub dataflow_endpoint_group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDataflowEndpointGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataflowEndpointGroupInput");
        formatter.field(
            "dataflow_endpoint_group_id",
            &self.dataflow_endpoint_group_id,
        );
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContactsInput {
    /// <p>Maximum number of contacts returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Next token returned in the request of a previous <code>ListContacts</code> call. Used to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Status of a contact reservation.</p>
    pub status_list: std::option::Option<std::vec::Vec<crate::model::ContactStatus>>,
    /// <p>Start time of a contact.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>End time of a contact.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Name of a ground station.</p>
    pub ground_station: std::option::Option<std::string::String>,
    /// <p>ARN of a satellite.</p>
    pub satellite_arn: std::option::Option<std::string::String>,
    /// <p>ARN of a mission profile.</p>
    pub mission_profile_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListContactsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContactsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("status_list", &self.status_list);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("ground_station", &self.ground_station);
        formatter.field("satellite_arn", &self.satellite_arn);
        formatter.field("mission_profile_arn", &self.mission_profile_arn);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReserveContactInput {
    /// <p>ARN of a mission profile.</p>
    pub mission_profile_arn: std::option::Option<std::string::String>,
    /// <p>ARN of a satellite</p>
    pub satellite_arn: std::option::Option<std::string::String>,
    /// <p>Start time of a contact.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>End time of a contact.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Name of a ground station.</p>
    pub ground_station: std::option::Option<std::string::String>,
    /// <p>Tags assigned to a contact.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ReserveContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReserveContactInput");
        formatter.field("mission_profile_arn", &self.mission_profile_arn);
        formatter.field("satellite_arn", &self.satellite_arn);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("ground_station", &self.ground_station);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelContactInput {
    /// <p>UUID of a contact.</p>
    pub contact_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelContactInput");
        formatter.field("contact_id", &self.contact_id);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeContactInput {
    /// <p>UUID of a contact.</p>
    pub contact_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeContactInput");
        formatter.field("contact_id", &self.contact_id);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConfigsInput {
    /// <p>Maximum number of <code>Configs</code> returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Next token returned in the request of a previous <code>ListConfigs</code> call. Used to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConfigsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConfigInput {
    /// <p>Name of a <code>Config</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Parameters of a <code>Config</code>.</p>
    pub config_data: std::option::Option<crate::model::ConfigTypeData>,
    /// <p>Tags assigned to a <code>Config</code>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConfigInput");
        formatter.field("name", &self.name);
        formatter.field("config_data", &self.config_data);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConfigInput {
    /// <p>UUID of a <code>Config</code>.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>Type of a <code>Config</code>.</p>
    pub config_type: std::option::Option<crate::model::ConfigCapabilityType>,
}
impl std::fmt::Debug for DeleteConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConfigInput");
        formatter.field("config_id", &self.config_id);
        formatter.field("config_type", &self.config_type);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConfigInput {
    /// <p>UUID of a <code>Config</code>.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>Name of a <code>Config</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Type of a <code>Config</code>.</p>
    pub config_type: std::option::Option<crate::model::ConfigCapabilityType>,
    /// <p>Parameters of a <code>Config</code>.</p>
    pub config_data: std::option::Option<crate::model::ConfigTypeData>,
}
impl std::fmt::Debug for UpdateConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConfigInput");
        formatter.field("config_id", &self.config_id);
        formatter.field("name", &self.name);
        formatter.field("config_type", &self.config_type);
        formatter.field("config_data", &self.config_data);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConfigInput {
    /// <p>UUID of a <code>Config</code>.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>Type of a <code>Config</code>.</p>
    pub config_type: std::option::Option<crate::model::ConfigCapabilityType>,
}
impl std::fmt::Debug for GetConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConfigInput");
        formatter.field("config_id", &self.config_id);
        formatter.field("config_type", &self.config_type);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>ARN of a resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Keys of a resource tag.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>ARN of a resource tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Tags assigned to a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>ARN of a resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

/// <p/>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMinuteUsageInput {
    /// <p>The month being requested, with a value of 1-12.</p>
    pub month: std::option::Option<i32>,
    /// <p>The year being requested, in the format of YYYY.</p>
    pub year: std::option::Option<i32>,
}
impl std::fmt::Debug for GetMinuteUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMinuteUsageInput");
        formatter.field("month", &self.month);
        formatter.field("year", &self.year);
        formatter.finish()
    }
}
