// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS IoT Greengrass V2
///
/// Client for invoking operations on AWS IoT Greengrass V2. Each operation on AWS IoT Greengrass V2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_greengrassv2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_greengrassv2::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_greengrassv2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateServiceRoleToAccount`](crate::client::fluent_builders::AssociateServiceRoleToAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateServiceRoleToAccount::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::AssociateServiceRoleToAccount::set_role_arn): <p>The Amazon Resource Name (ARN) of the service role to associate with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>
    /// - On success, responds with [`AssociateServiceRoleToAccountOutput`](crate::output::AssociateServiceRoleToAccountOutput) with field(s):
    ///   - [`associated_at(Option<String>)`](crate::output::AssociateServiceRoleToAccountOutput::associated_at): <p>The time when the service role was associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<AssociateServiceRoleToAccountError>`](crate::error::AssociateServiceRoleToAccountError)
    pub fn associate_service_role_to_account(
        &self,
    ) -> fluent_builders::AssociateServiceRoleToAccount {
        fluent_builders::AssociateServiceRoleToAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchAssociateClientDeviceWithCoreDevice`](crate::client::fluent_builders::BatchAssociateClientDeviceWithCoreDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entries(Vec<AssociateClientDeviceWithCoreDeviceEntry>)`](crate::client::fluent_builders::BatchAssociateClientDeviceWithCoreDevice::entries) / [`set_entries(Option<Vec<AssociateClientDeviceWithCoreDeviceEntry>>)`](crate::client::fluent_builders::BatchAssociateClientDeviceWithCoreDevice::set_entries): <p>The list of client devices to associate.</p>
    ///   - [`core_device_thing_name(impl Into<String>)`](crate::client::fluent_builders::BatchAssociateClientDeviceWithCoreDevice::core_device_thing_name) / [`set_core_device_thing_name(Option<String>)`](crate::client::fluent_builders::BatchAssociateClientDeviceWithCoreDevice::set_core_device_thing_name): <p>The name of the core device. This is also the name of the IoT thing.</p>
    /// - On success, responds with [`BatchAssociateClientDeviceWithCoreDeviceOutput`](crate::output::BatchAssociateClientDeviceWithCoreDeviceOutput) with field(s):
    ///   - [`error_entries(Option<Vec<AssociateClientDeviceWithCoreDeviceErrorEntry>>)`](crate::output::BatchAssociateClientDeviceWithCoreDeviceOutput::error_entries): <p>The list of any errors for the entries in the request. Each error entry contains the name of the IoT thing that failed to associate.</p>
    /// - On failure, responds with [`SdkError<BatchAssociateClientDeviceWithCoreDeviceError>`](crate::error::BatchAssociateClientDeviceWithCoreDeviceError)
    pub fn batch_associate_client_device_with_core_device(
        &self,
    ) -> fluent_builders::BatchAssociateClientDeviceWithCoreDevice {
        fluent_builders::BatchAssociateClientDeviceWithCoreDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDisassociateClientDeviceFromCoreDevice`](crate::client::fluent_builders::BatchDisassociateClientDeviceFromCoreDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entries(Vec<DisassociateClientDeviceFromCoreDeviceEntry>)`](crate::client::fluent_builders::BatchDisassociateClientDeviceFromCoreDevice::entries) / [`set_entries(Option<Vec<DisassociateClientDeviceFromCoreDeviceEntry>>)`](crate::client::fluent_builders::BatchDisassociateClientDeviceFromCoreDevice::set_entries): <p>The list of client devices to disassociate.</p>
    ///   - [`core_device_thing_name(impl Into<String>)`](crate::client::fluent_builders::BatchDisassociateClientDeviceFromCoreDevice::core_device_thing_name) / [`set_core_device_thing_name(Option<String>)`](crate::client::fluent_builders::BatchDisassociateClientDeviceFromCoreDevice::set_core_device_thing_name): <p>The name of the core device. This is also the name of the IoT thing.</p>
    /// - On success, responds with [`BatchDisassociateClientDeviceFromCoreDeviceOutput`](crate::output::BatchDisassociateClientDeviceFromCoreDeviceOutput) with field(s):
    ///   - [`error_entries(Option<Vec<DisassociateClientDeviceFromCoreDeviceErrorEntry>>)`](crate::output::BatchDisassociateClientDeviceFromCoreDeviceOutput::error_entries): <p>The list of any errors for the entries in the request. Each error entry contains the name of the IoT thing that failed to disassociate.</p>
    /// - On failure, responds with [`SdkError<BatchDisassociateClientDeviceFromCoreDeviceError>`](crate::error::BatchDisassociateClientDeviceFromCoreDeviceError)
    pub fn batch_disassociate_client_device_from_core_device(
        &self,
    ) -> fluent_builders::BatchDisassociateClientDeviceFromCoreDevice {
        fluent_builders::BatchDisassociateClientDeviceFromCoreDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelDeployment`](crate::client::fluent_builders::CancelDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::CancelDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::CancelDeployment::set_deployment_id): <p>The ID of the deployment.</p>
    /// - On success, responds with [`CancelDeploymentOutput`](crate::output::CancelDeploymentOutput) with field(s):
    ///   - [`message(Option<String>)`](crate::output::CancelDeploymentOutput::message): <p>A message that communicates if the cancel was successful.</p>
    /// - On failure, responds with [`SdkError<CancelDeploymentError>`](crate::error::CancelDeploymentError)
    pub fn cancel_deployment(&self) -> fluent_builders::CancelDeployment {
        fluent_builders::CancelDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateComponentVersion`](crate::client::fluent_builders::CreateComponentVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`inline_recipe(Blob)`](crate::client::fluent_builders::CreateComponentVersion::inline_recipe) / [`set_inline_recipe(Option<Blob>)`](crate::client::fluent_builders::CreateComponentVersion::set_inline_recipe): <p>The recipe to use to create the component. The recipe defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility.</p>  <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
    ///   - [`lambda_function(LambdaFunctionRecipeSource)`](crate::client::fluent_builders::CreateComponentVersion::lambda_function) / [`set_lambda_function(Option<LambdaFunctionRecipeSource>)`](crate::client::fluent_builders::CreateComponentVersion::set_lambda_function): <p>The parameters to create a component from a Lambda function.</p>  <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateComponentVersion::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateComponentVersion::set_tags): <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateComponentVersion::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateComponentVersion::set_client_token): <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.</p>
    /// - On success, responds with [`CreateComponentVersionOutput`](crate::output::CreateComponentVersionOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateComponentVersionOutput::arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    ///   - [`component_name(Option<String>)`](crate::output::CreateComponentVersionOutput::component_name): <p>The name of the component.</p>
    ///   - [`component_version(Option<String>)`](crate::output::CreateComponentVersionOutput::component_version): <p>The version of the component.</p>
    ///   - [`creation_timestamp(Option<DateTime>)`](crate::output::CreateComponentVersionOutput::creation_timestamp): <p>The time at which the component was created, expressed in ISO 8601 format.</p>
    ///   - [`status(Option<CloudComponentStatus>)`](crate::output::CreateComponentVersionOutput::status): <p>The status of the component version in IoT Greengrass V2. This status is different from the status of the component on a core device.</p>
    /// - On failure, responds with [`SdkError<CreateComponentVersionError>`](crate::error::CreateComponentVersionError)
    pub fn create_component_version(&self) -> fluent_builders::CreateComponentVersion {
        fluent_builders::CreateComponentVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDeployment`](crate::client::fluent_builders::CreateDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_target_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    ///   - [`deployment_name(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::deployment_name) / [`set_deployment_name(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_deployment_name): <p>The name of the deployment.</p>
    ///   - [`components(HashMap<String, ComponentDeploymentSpecification>)`](crate::client::fluent_builders::CreateDeployment::components) / [`set_components(Option<HashMap<String, ComponentDeploymentSpecification>>)`](crate::client::fluent_builders::CreateDeployment::set_components): <p>The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.</p>
    ///   - [`iot_job_configuration(DeploymentIoTJobConfiguration)`](crate::client::fluent_builders::CreateDeployment::iot_job_configuration) / [`set_iot_job_configuration(Option<DeploymentIoTJobConfiguration>)`](crate::client::fluent_builders::CreateDeployment::set_iot_job_configuration): <p>The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.</p>
    ///   - [`deployment_policies(DeploymentPolicies)`](crate::client::fluent_builders::CreateDeployment::deployment_policies) / [`set_deployment_policies(Option<DeploymentPolicies>)`](crate::client::fluent_builders::CreateDeployment::set_deployment_policies): <p>The deployment policies for the deployment. These policies define how the deployment updates components and handles failure.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDeployment::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDeployment::set_tags): <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateDeployment::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateDeployment::set_client_token): <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.</p>
    /// - On success, responds with [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput) with field(s):
    ///   - [`deployment_id(Option<String>)`](crate::output::CreateDeploymentOutput::deployment_id): <p>The ID of the deployment.</p>
    ///   - [`iot_job_id(Option<String>)`](crate::output::CreateDeploymentOutput::iot_job_id): <p>The ID of the IoT job that applies the deployment to target devices.</p>
    ///   - [`iot_job_arn(Option<String>)`](crate::output::CreateDeploymentOutput::iot_job_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
    /// - On failure, responds with [`SdkError<CreateDeploymentError>`](crate::error::CreateDeploymentError)
    pub fn create_deployment(&self) -> fluent_builders::CreateDeployment {
        fluent_builders::CreateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteComponent`](crate::client::fluent_builders::DeleteComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteComponent::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteComponent::set_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    /// - On success, responds with [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)

    /// - On failure, responds with [`SdkError<DeleteComponentError>`](crate::error::DeleteComponentError)
    pub fn delete_component(&self) -> fluent_builders::DeleteComponent {
        fluent_builders::DeleteComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCoreDevice`](crate::client::fluent_builders::DeleteCoreDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_device_thing_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCoreDevice::core_device_thing_name) / [`set_core_device_thing_name(Option<String>)`](crate::client::fluent_builders::DeleteCoreDevice::set_core_device_thing_name): <p>The name of the core device. This is also the name of the IoT thing.</p>
    /// - On success, responds with [`DeleteCoreDeviceOutput`](crate::output::DeleteCoreDeviceOutput)

    /// - On failure, responds with [`SdkError<DeleteCoreDeviceError>`](crate::error::DeleteCoreDeviceError)
    pub fn delete_core_device(&self) -> fluent_builders::DeleteCoreDevice {
        fluent_builders::DeleteCoreDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeComponent`](crate::client::fluent_builders::DescribeComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DescribeComponent::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DescribeComponent::set_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    /// - On success, responds with [`DescribeComponentOutput`](crate::output::DescribeComponentOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DescribeComponentOutput::arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    ///   - [`component_name(Option<String>)`](crate::output::DescribeComponentOutput::component_name): <p>The name of the component.</p>
    ///   - [`component_version(Option<String>)`](crate::output::DescribeComponentOutput::component_version): <p>The version of the component.</p>
    ///   - [`creation_timestamp(Option<DateTime>)`](crate::output::DescribeComponentOutput::creation_timestamp): <p>The time at which the component was created, expressed in ISO 8601 format.</p>
    ///   - [`publisher(Option<String>)`](crate::output::DescribeComponentOutput::publisher): <p>The publisher of the component version.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeComponentOutput::description): <p>The description of the component version.</p>
    ///   - [`status(Option<CloudComponentStatus>)`](crate::output::DescribeComponentOutput::status): <p>The status of the component version in IoT Greengrass V2. This status is different from the status of the component on a core device.</p>
    ///   - [`platforms(Option<Vec<ComponentPlatform>>)`](crate::output::DescribeComponentOutput::platforms): <p>The platforms that the component version supports.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeComponentOutput::tags): <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<DescribeComponentError>`](crate::error::DescribeComponentError)
    pub fn describe_component(&self) -> fluent_builders::DescribeComponent {
        fluent_builders::DescribeComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateServiceRoleFromAccount`](crate::client::fluent_builders::DisassociateServiceRoleFromAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisassociateServiceRoleFromAccount::send) it.

    /// - On success, responds with [`DisassociateServiceRoleFromAccountOutput`](crate::output::DisassociateServiceRoleFromAccountOutput) with field(s):
    ///   - [`disassociated_at(Option<String>)`](crate::output::DisassociateServiceRoleFromAccountOutput::disassociated_at): <p>The time when the service role was disassociated from IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<DisassociateServiceRoleFromAccountError>`](crate::error::DisassociateServiceRoleFromAccountError)
    pub fn disassociate_service_role_from_account(
        &self,
    ) -> fluent_builders::DisassociateServiceRoleFromAccount {
        fluent_builders::DisassociateServiceRoleFromAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetComponent`](crate::client::fluent_builders::GetComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recipe_output_format(RecipeOutputFormat)`](crate::client::fluent_builders::GetComponent::recipe_output_format) / [`set_recipe_output_format(Option<RecipeOutputFormat>)`](crate::client::fluent_builders::GetComponent::set_recipe_output_format): <p>The format of the recipe.</p>
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetComponent::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetComponent::set_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    /// - On success, responds with [`GetComponentOutput`](crate::output::GetComponentOutput) with field(s):
    ///   - [`recipe_output_format(Option<RecipeOutputFormat>)`](crate::output::GetComponentOutput::recipe_output_format): <p>The format of the recipe.</p>
    ///   - [`recipe(Option<Blob>)`](crate::output::GetComponentOutput::recipe): <p>The recipe of the component version.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetComponentOutput::tags): <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<GetComponentError>`](crate::error::GetComponentError)
    pub fn get_component(&self) -> fluent_builders::GetComponent {
        fluent_builders::GetComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetComponentVersionArtifact`](crate::client::fluent_builders::GetComponentVersionArtifact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetComponentVersionArtifact::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetComponentVersionArtifact::set_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version. Specify the ARN of a public component version.</p>
    ///   - [`artifact_name(impl Into<String>)`](crate::client::fluent_builders::GetComponentVersionArtifact::artifact_name) / [`set_artifact_name(Option<String>)`](crate::client::fluent_builders::GetComponentVersionArtifact::set_artifact_name): <p>The name of the artifact.</p>  <p>You can use the <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a> operation to download the component recipe, which includes the URI of the artifact. The artifact name is the section of the URI after the scheme. For example, in the artifact URI <code>greengrass:SomeArtifact.zip</code>, the artifact name is <code>SomeArtifact.zip</code>.</p>
    /// - On success, responds with [`GetComponentVersionArtifactOutput`](crate::output::GetComponentVersionArtifactOutput) with field(s):
    ///   - [`pre_signed_url(Option<String>)`](crate::output::GetComponentVersionArtifactOutput::pre_signed_url): <p>The URL of the artifact.</p>
    /// - On failure, responds with [`SdkError<GetComponentVersionArtifactError>`](crate::error::GetComponentVersionArtifactError)
    pub fn get_component_version_artifact(&self) -> fluent_builders::GetComponentVersionArtifact {
        fluent_builders::GetComponentVersionArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetConnectivityInfo`](crate::client::fluent_builders::GetConnectivityInfo) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::GetConnectivityInfo::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::GetConnectivityInfo::set_thing_name): <p>The name of the core device. This is also the name of the IoT thing.</p>
    /// - On success, responds with [`GetConnectivityInfoOutput`](crate::output::GetConnectivityInfoOutput) with field(s):
    ///   - [`connectivity_info(Option<Vec<ConnectivityInfo>>)`](crate::output::GetConnectivityInfoOutput::connectivity_info): <p>The connectivity information for the core device.</p>
    ///   - [`message(Option<String>)`](crate::output::GetConnectivityInfoOutput::message): <p>A message about the connectivity information request.</p>
    /// - On failure, responds with [`SdkError<GetConnectivityInfoError>`](crate::error::GetConnectivityInfoError)
    pub fn get_connectivity_info(&self) -> fluent_builders::GetConnectivityInfo {
        fluent_builders::GetConnectivityInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCoreDevice`](crate::client::fluent_builders::GetCoreDevice) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_device_thing_name(impl Into<String>)`](crate::client::fluent_builders::GetCoreDevice::core_device_thing_name) / [`set_core_device_thing_name(Option<String>)`](crate::client::fluent_builders::GetCoreDevice::set_core_device_thing_name): <p>The name of the core device. This is also the name of the IoT thing.</p>
    /// - On success, responds with [`GetCoreDeviceOutput`](crate::output::GetCoreDeviceOutput) with field(s):
    ///   - [`core_device_thing_name(Option<String>)`](crate::output::GetCoreDeviceOutput::core_device_thing_name): <p>The name of the core device. This is also the name of the IoT thing.</p>
    ///   - [`core_version(Option<String>)`](crate::output::GetCoreDeviceOutput::core_version): <p>The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to the version of the Greengrass nucleus component that runs on the core device. For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    ///   - [`platform(Option<String>)`](crate::output::GetCoreDeviceOutput::platform): <p>The operating system platform that the core device runs.</p>
    ///   - [`architecture(Option<String>)`](crate::output::GetCoreDeviceOutput::architecture): <p>The computer architecture of the core device.</p>
    ///   - [`status(Option<CoreDeviceStatus>)`](crate::output::GetCoreDeviceOutput::status): <p>The status of the core device. The core device status can be:</p>  <ul>   <li> <p> <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p> </li>   <li> <p> <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core device.</p> </li>  </ul>
    ///   - [`last_status_update_timestamp(Option<DateTime>)`](crate::output::GetCoreDeviceOutput::last_status_update_timestamp): <p>The time at which the core device's status last updated, expressed in ISO 8601 format.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetCoreDeviceOutput::tags): <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<GetCoreDeviceError>`](crate::error::GetCoreDeviceError)
    pub fn get_core_device(&self) -> fluent_builders::GetCoreDevice {
        fluent_builders::GetCoreDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDeployment`](crate::client::fluent_builders::GetDeployment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`deployment_id(impl Into<String>)`](crate::client::fluent_builders::GetDeployment::deployment_id) / [`set_deployment_id(Option<String>)`](crate::client::fluent_builders::GetDeployment::set_deployment_id): <p>The ID of the deployment.</p>
    /// - On success, responds with [`GetDeploymentOutput`](crate::output::GetDeploymentOutput) with field(s):
    ///   - [`target_arn(Option<String>)`](crate::output::GetDeploymentOutput::target_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::GetDeploymentOutput::revision_id): <p>The revision number of the deployment.</p>
    ///   - [`deployment_id(Option<String>)`](crate::output::GetDeploymentOutput::deployment_id): <p>The ID of the deployment.</p>
    ///   - [`deployment_name(Option<String>)`](crate::output::GetDeploymentOutput::deployment_name): <p>The name of the deployment.</p>
    ///   - [`deployment_status(Option<DeploymentStatus>)`](crate::output::GetDeploymentOutput::deployment_status): <p>The status of the deployment.</p>
    ///   - [`iot_job_id(Option<String>)`](crate::output::GetDeploymentOutput::iot_job_id): <p>The ID of the IoT job that applies the deployment to target devices.</p>
    ///   - [`iot_job_arn(Option<String>)`](crate::output::GetDeploymentOutput::iot_job_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
    ///   - [`components(Option<HashMap<String, ComponentDeploymentSpecification>>)`](crate::output::GetDeploymentOutput::components): <p>The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.</p>
    ///   - [`deployment_policies(Option<DeploymentPolicies>)`](crate::output::GetDeploymentOutput::deployment_policies): <p>The deployment policies for the deployment. These policies define how the deployment updates components and handles failure.</p>
    ///   - [`iot_job_configuration(Option<DeploymentIoTJobConfiguration>)`](crate::output::GetDeploymentOutput::iot_job_configuration): <p>The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.</p>
    ///   - [`creation_timestamp(Option<DateTime>)`](crate::output::GetDeploymentOutput::creation_timestamp): <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
    ///   - [`is_latest_for_target(bool)`](crate::output::GetDeploymentOutput::is_latest_for_target): <p>Whether or not the deployment is the latest revision for its target.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetDeploymentOutput::tags): <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<GetDeploymentError>`](crate::error::GetDeploymentError)
    pub fn get_deployment(&self) -> fluent_builders::GetDeployment {
        fluent_builders::GetDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServiceRoleForAccount`](crate::client::fluent_builders::GetServiceRoleForAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetServiceRoleForAccount::send) it.

    /// - On success, responds with [`GetServiceRoleForAccountOutput`](crate::output::GetServiceRoleForAccountOutput) with field(s):
    ///   - [`associated_at(Option<String>)`](crate::output::GetServiceRoleForAccountOutput::associated_at): <p>The time when the service role was associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::GetServiceRoleForAccountOutput::role_arn): <p>The ARN of the service role that is associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<GetServiceRoleForAccountError>`](crate::error::GetServiceRoleForAccountError)
    pub fn get_service_role_for_account(&self) -> fluent_builders::GetServiceRoleForAccount {
        fluent_builders::GetServiceRoleForAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListClientDevicesAssociatedWithCoreDevice`](crate::client::fluent_builders::ListClientDevicesAssociatedWithCoreDevice) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListClientDevicesAssociatedWithCoreDevice::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_device_thing_name(impl Into<String>)`](crate::client::fluent_builders::ListClientDevicesAssociatedWithCoreDevice::core_device_thing_name) / [`set_core_device_thing_name(Option<String>)`](crate::client::fluent_builders::ListClientDevicesAssociatedWithCoreDevice::set_core_device_thing_name): <p>The name of the core device. This is also the name of the IoT thing.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListClientDevicesAssociatedWithCoreDevice::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListClientDevicesAssociatedWithCoreDevice::set_max_results): <p>The maximum number of results to be returned per paginated request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListClientDevicesAssociatedWithCoreDevice::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListClientDevicesAssociatedWithCoreDevice::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    /// - On success, responds with [`ListClientDevicesAssociatedWithCoreDeviceOutput`](crate::output::ListClientDevicesAssociatedWithCoreDeviceOutput) with field(s):
    ///   - [`associated_client_devices(Option<Vec<AssociatedClientDevice>>)`](crate::output::ListClientDevicesAssociatedWithCoreDeviceOutput::associated_client_devices): <p>A list that describes the client devices that are associated with the core device.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListClientDevicesAssociatedWithCoreDeviceOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListClientDevicesAssociatedWithCoreDeviceError>`](crate::error::ListClientDevicesAssociatedWithCoreDeviceError)
    pub fn list_client_devices_associated_with_core_device(
        &self,
    ) -> fluent_builders::ListClientDevicesAssociatedWithCoreDevice {
        fluent_builders::ListClientDevicesAssociatedWithCoreDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListComponents`](crate::client::fluent_builders::ListComponents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListComponents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`scope(ComponentVisibilityScope)`](crate::client::fluent_builders::ListComponents::scope) / [`set_scope(Option<ComponentVisibilityScope>)`](crate::client::fluent_builders::ListComponents::set_scope): <p>The scope of the components to list.</p>  <p>Default: <code>PRIVATE</code> </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListComponents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListComponents::set_max_results): <p>The maximum number of results to be returned per paginated request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListComponents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListComponents::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    /// - On success, responds with [`ListComponentsOutput`](crate::output::ListComponentsOutput) with field(s):
    ///   - [`components(Option<Vec<Component>>)`](crate::output::ListComponentsOutput::components): <p>A list that summarizes each component.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListComponentsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListComponentsError>`](crate::error::ListComponentsError)
    pub fn list_components(&self) -> fluent_builders::ListComponents {
        fluent_builders::ListComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListComponentVersions`](crate::client::fluent_builders::ListComponentVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListComponentVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::ListComponentVersions::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::ListComponentVersions::set_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListComponentVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListComponentVersions::set_max_results): <p>The maximum number of results to be returned per paginated request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListComponentVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListComponentVersions::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    /// - On success, responds with [`ListComponentVersionsOutput`](crate::output::ListComponentVersionsOutput) with field(s):
    ///   - [`component_versions(Option<Vec<ComponentVersionListItem>>)`](crate::output::ListComponentVersionsOutput::component_versions): <p>A list of versions that exist for the component.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListComponentVersionsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListComponentVersionsError>`](crate::error::ListComponentVersionsError)
    pub fn list_component_versions(&self) -> fluent_builders::ListComponentVersions {
        fluent_builders::ListComponentVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCoreDevices`](crate::client::fluent_builders::ListCoreDevices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCoreDevices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_group_arn(impl Into<String>)`](crate::client::fluent_builders::ListCoreDevices::thing_group_arn) / [`set_thing_group_arn(Option<String>)`](crate::client::fluent_builders::ListCoreDevices::set_thing_group_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT thing group by which to filter. If you specify this parameter, the list includes only core devices that are members of this thing group.</p>
    ///   - [`status(CoreDeviceStatus)`](crate::client::fluent_builders::ListCoreDevices::status) / [`set_status(Option<CoreDeviceStatus>)`](crate::client::fluent_builders::ListCoreDevices::set_status): <p>The core device status by which to filter. If you specify this parameter, the list includes only core devices that have this status. Choose one of the following options:</p>  <ul>   <li> <p> <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p> </li>   <li> <p> <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core device.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCoreDevices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCoreDevices::set_max_results): <p>The maximum number of results to be returned per paginated request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCoreDevices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCoreDevices::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    /// - On success, responds with [`ListCoreDevicesOutput`](crate::output::ListCoreDevicesOutput) with field(s):
    ///   - [`core_devices(Option<Vec<CoreDevice>>)`](crate::output::ListCoreDevicesOutput::core_devices): <p>A list that summarizes each core device.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCoreDevicesOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListCoreDevicesError>`](crate::error::ListCoreDevicesError)
    pub fn list_core_devices(&self) -> fluent_builders::ListCoreDevices {
        fluent_builders::ListCoreDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDeployments`](crate::client::fluent_builders::ListDeployments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDeployments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::ListDeployments::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::ListDeployments::set_target_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    ///   - [`history_filter(DeploymentHistoryFilter)`](crate::client::fluent_builders::ListDeployments::history_filter) / [`set_history_filter(Option<DeploymentHistoryFilter>)`](crate::client::fluent_builders::ListDeployments::set_history_filter): <p>The filter for the list of deployments. Choose one of the following options:</p>  <ul>   <li> <p> <code>ALL</code> – The list includes all deployments.</p> </li>   <li> <p> <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.</p> </li>  </ul>  <p>Default: <code>LATEST_ONLY</code> </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDeployments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDeployments::set_max_results): <p>The maximum number of results to be returned per paginated request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDeployments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDeployments::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    /// - On success, responds with [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput) with field(s):
    ///   - [`deployments(Option<Vec<Deployment>>)`](crate::output::ListDeploymentsOutput::deployments): <p>A list that summarizes each deployment.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDeploymentsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListDeploymentsError>`](crate::error::ListDeploymentsError)
    pub fn list_deployments(&self) -> fluent_builders::ListDeployments {
        fluent_builders::ListDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEffectiveDeployments`](crate::client::fluent_builders::ListEffectiveDeployments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEffectiveDeployments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_device_thing_name(impl Into<String>)`](crate::client::fluent_builders::ListEffectiveDeployments::core_device_thing_name) / [`set_core_device_thing_name(Option<String>)`](crate::client::fluent_builders::ListEffectiveDeployments::set_core_device_thing_name): <p>The name of the core device. This is also the name of the IoT thing.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEffectiveDeployments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEffectiveDeployments::set_max_results): <p>The maximum number of results to be returned per paginated request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEffectiveDeployments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEffectiveDeployments::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    /// - On success, responds with [`ListEffectiveDeploymentsOutput`](crate::output::ListEffectiveDeploymentsOutput) with field(s):
    ///   - [`effective_deployments(Option<Vec<EffectiveDeployment>>)`](crate::output::ListEffectiveDeploymentsOutput::effective_deployments): <p>A list that summarizes each deployment on the core device.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEffectiveDeploymentsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListEffectiveDeploymentsError>`](crate::error::ListEffectiveDeploymentsError)
    pub fn list_effective_deployments(&self) -> fluent_builders::ListEffectiveDeployments {
        fluent_builders::ListEffectiveDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInstalledComponents`](crate::client::fluent_builders::ListInstalledComponents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInstalledComponents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`core_device_thing_name(impl Into<String>)`](crate::client::fluent_builders::ListInstalledComponents::core_device_thing_name) / [`set_core_device_thing_name(Option<String>)`](crate::client::fluent_builders::ListInstalledComponents::set_core_device_thing_name): <p>The name of the core device. This is also the name of the IoT thing.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInstalledComponents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInstalledComponents::set_max_results): <p>The maximum number of results to be returned per paginated request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInstalledComponents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInstalledComponents::set_next_token): <p>The token to be used for the next set of paginated results.</p>
    /// - On success, responds with [`ListInstalledComponentsOutput`](crate::output::ListInstalledComponentsOutput) with field(s):
    ///   - [`installed_components(Option<Vec<InstalledComponent>>)`](crate::output::ListInstalledComponentsOutput::installed_components): <p>A list that summarizes each component on the core device.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInstalledComponentsOutput::next_token): <p>The token for the next set of results, or null if there are no additional results.</p>
    /// - On failure, responds with [`SdkError<ListInstalledComponentsError>`](crate::error::ListInstalledComponentsError)
    pub fn list_installed_components(&self) -> fluent_builders::ListInstalledComponents {
        fluent_builders::ListInstalledComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResolveComponentCandidates`](crate::client::fluent_builders::ResolveComponentCandidates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`platform(ComponentPlatform)`](crate::client::fluent_builders::ResolveComponentCandidates::platform) / [`set_platform(Option<ComponentPlatform>)`](crate::client::fluent_builders::ResolveComponentCandidates::set_platform): <p>The platform to use to resolve compatible components.</p>
    ///   - [`component_candidates(Vec<ComponentCandidate>)`](crate::client::fluent_builders::ResolveComponentCandidates::component_candidates) / [`set_component_candidates(Option<Vec<ComponentCandidate>>)`](crate::client::fluent_builders::ResolveComponentCandidates::set_component_candidates): <p>The list of components to resolve.</p>
    /// - On success, responds with [`ResolveComponentCandidatesOutput`](crate::output::ResolveComponentCandidatesOutput) with field(s):
    ///   - [`resolved_component_versions(Option<Vec<ResolvedComponentVersion>>)`](crate::output::ResolveComponentCandidatesOutput::resolved_component_versions): <p>A list of components that meet the requirements that you specify in the request. This list includes each component's recipe that you can use to install the component.</p>
    /// - On failure, responds with [`SdkError<ResolveComponentCandidatesError>`](crate::error::ResolveComponentCandidatesError)
    pub fn resolve_component_candidates(&self) -> fluent_builders::ResolveComponentCandidates {
        fluent_builders::ResolveComponentCandidates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of keys for tags to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateConnectivityInfo`](crate::client::fluent_builders::UpdateConnectivityInfo) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`thing_name(impl Into<String>)`](crate::client::fluent_builders::UpdateConnectivityInfo::thing_name) / [`set_thing_name(Option<String>)`](crate::client::fluent_builders::UpdateConnectivityInfo::set_thing_name): <p>The name of the core device. This is also the name of the IoT thing.</p>
    ///   - [`connectivity_info(Vec<ConnectivityInfo>)`](crate::client::fluent_builders::UpdateConnectivityInfo::connectivity_info) / [`set_connectivity_info(Option<Vec<ConnectivityInfo>>)`](crate::client::fluent_builders::UpdateConnectivityInfo::set_connectivity_info): <p>The connectivity information for the core device.</p>
    /// - On success, responds with [`UpdateConnectivityInfoOutput`](crate::output::UpdateConnectivityInfoOutput) with field(s):
    ///   - [`version(Option<String>)`](crate::output::UpdateConnectivityInfoOutput::version): <p>The new version of the connectivity information for the core device.</p>
    ///   - [`message(Option<String>)`](crate::output::UpdateConnectivityInfoOutput::message): <p>A message about the connectivity information update request.</p>
    /// - On failure, responds with [`SdkError<UpdateConnectivityInfoError>`](crate::error::UpdateConnectivityInfoError)
    pub fn update_connectivity_info(&self) -> fluent_builders::UpdateConnectivityInfo {
        fluent_builders::UpdateConnectivityInfo::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateServiceRoleToAccount`.
    ///
    /// <p>Associates a Greengrass service role with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device connectivity information. The role must include the <a href="https://console.aws.amazon.com/iam/home#/policies/arn:awsiam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy">AWSGreengrassResourceAccessRolePolicy</a> managed policy or a custom policy that defines equivalent permissions for the IoT Greengrass features that you use. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateServiceRoleToAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_service_role_to_account_input::Builder,
    }
    impl AssociateServiceRoleToAccount {
        /// Creates a new `AssociateServiceRoleToAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateServiceRoleToAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateServiceRoleToAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the service role to associate with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service role to associate with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateClientDeviceWithCoreDevice`.
    ///
    /// <p>Associates a list of client devices with a core device. Use this API operation to specify which client devices can discover a core device through cloud discovery. With cloud discovery, client devices connect to IoT Greengrass to retrieve associated core devices' connectivity information and certificates. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-cloud-discovery.html">Configure cloud discovery</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p> <note>
    /// <p>Client devices are local IoT devices that connect to and communicate with an IoT Greengrass core device over MQTT. You can connect client devices to a core device to sync MQTT messages and data to Amazon Web Services IoT Core and interact with client devices in Greengrass components. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interact-with-local-iot-devices.html">Interact with local IoT devices</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchAssociateClientDeviceWithCoreDevice {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_associate_client_device_with_core_device_input::Builder,
    }
    impl BatchAssociateClientDeviceWithCoreDevice {
        /// Creates a new `BatchAssociateClientDeviceWithCoreDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchAssociateClientDeviceWithCoreDeviceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchAssociateClientDeviceWithCoreDeviceError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of client devices to associate.</p>
        pub fn entries(
            mut self,
            input: crate::model::AssociateClientDeviceWithCoreDeviceEntry,
        ) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>The list of client devices to associate.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssociateClientDeviceWithCoreDeviceEntry>,
            >,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_device_thing_name(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_device_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateClientDeviceFromCoreDevice`.
    ///
    /// <p>Disassociates a list of client devices from a core device. After you disassociate a client device from a core device, the client device won't be able to use cloud discovery to retrieve the core device's connectivity information and certificates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDisassociateClientDeviceFromCoreDevice {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_disassociate_client_device_from_core_device_input::Builder,
    }
    impl BatchDisassociateClientDeviceFromCoreDevice {
        /// Creates a new `BatchDisassociateClientDeviceFromCoreDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisassociateClientDeviceFromCoreDeviceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchDisassociateClientDeviceFromCoreDeviceError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of client devices to disassociate.</p>
        pub fn entries(
            mut self,
            input: crate::model::DisassociateClientDeviceFromCoreDeviceEntry,
        ) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>The list of client devices to disassociate.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DisassociateClientDeviceFromCoreDeviceEntry>,
            >,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_device_thing_name(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_device_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelDeployment`.
    ///
    /// <p>Cancels a deployment. This operation cancels the deployment for devices that haven't yet received it. If a device already received the deployment, this operation doesn't change anything for that device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_deployment_input::Builder,
    }
    impl CancelDeployment {
        /// Creates a new `CancelDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateComponentVersion`.
    ///
    /// <p>Creates a component. Components are software that run on Greengrass core devices. After you develop and test a component on your core device, you can use this operation to upload your component to IoT Greengrass. Then, you can deploy the component to other core devices.</p>
    /// <p>You can use this operation to do the following:</p>
    /// <ul>
    /// <li> <p> <b>Create components from recipes</b> </p> <p>Create a component from a recipe, which is a file that defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform capability. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/component-recipe-reference.html">IoT Greengrass component recipe reference</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p> <p>To create a component from a recipe, specify <code>inlineRecipe</code> when you call this operation.</p> </li>
    /// <li> <p> <b>Create components from Lambda functions</b> </p> <p>Create a component from an Lambda function that runs on IoT Greengrass. This creates a recipe and artifacts from the Lambda function's deployment package. You can use this operation to migrate Lambda functions from IoT Greengrass V1 to IoT Greengrass V2.</p> <p>This function only accepts Lambda functions that use the following runtimes:</p>
    /// <ul>
    /// <li> <p>Python 2.7 – <code>python2.7</code> </p> </li>
    /// <li> <p>Python 3.7 – <code>python3.7</code> </p> </li>
    /// <li> <p>Python 3.8 – <code>python3.8</code> </p> </li>
    /// <li> <p>Java 8 – <code>java8</code> </p> </li>
    /// <li> <p>Node.js 10 – <code>nodejs10.x</code> </p> </li>
    /// <li> <p>Node.js 12 – <code>nodejs12.x</code> </p> </li>
    /// </ul> <p>To create a component from a Lambda function, specify <code>lambdaFunction</code> when you call this operation.</p> <note>
    /// <p>IoT Greengrass currently supports Lambda functions on only Linux core devices.</p>
    /// </note> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateComponentVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_component_version_input::Builder,
    }
    impl CreateComponentVersion {
        /// Creates a new `CreateComponentVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComponentVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComponentVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The recipe to use to create the component. The recipe defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility.</p>
        /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
        pub fn inline_recipe(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.inline_recipe(input);
            self
        }
        /// <p>The recipe to use to create the component. The recipe defines the component's metadata, parameters, dependencies, lifecycle, artifacts, and platform compatibility.</p>
        /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
        pub fn set_inline_recipe(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_inline_recipe(input);
            self
        }
        /// <p>The parameters to create a component from a Lambda function.</p>
        /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
        pub fn lambda_function(mut self, input: crate::model::LambdaFunctionRecipeSource) -> Self {
            self.inner = self.inner.lambda_function(input);
            self
        }
        /// <p>The parameters to create a component from a Lambda function.</p>
        /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
        pub fn set_lambda_function(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionRecipeSource>,
        ) -> Self {
            self.inner = self.inner.set_lambda_function(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeployment`.
    ///
    /// <p>Creates a continuous deployment for a target, which is a Greengrass core device or group of core devices. When you add a new core device to a group of core devices that has a deployment, IoT Greengrass deploys that group's deployment to the new device.</p>
    /// <p>You can define one deployment for each target. When you create a new deployment for a target that has an existing deployment, you replace the previous deployment. IoT Greengrass applies the new deployment to the target devices.</p>
    /// <p>Every deployment has a revision number that indicates how many deployment revisions you define for a target. Use this operation to create a new revision of an existing deployment.</p>
    /// <p>For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_deployment_input::Builder,
    }
    impl CreateDeployment {
        /// Creates a new `CreateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The name of the deployment.</p>
        pub fn deployment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_name(input.into());
            self
        }
        /// <p>The name of the deployment.</p>
        pub fn set_deployment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_name(input);
            self
        }
        /// Adds a key-value pair to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.</p>
        pub fn components(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ComponentDeploymentSpecification,
        ) -> Self {
            self.inner = self.inner.components(k.into(), v);
            self
        }
        /// <p>The components to deploy. This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentDeploymentSpecification,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_components(input);
            self
        }
        /// <p>The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.</p>
        pub fn iot_job_configuration(
            mut self,
            input: crate::model::DeploymentIoTJobConfiguration,
        ) -> Self {
            self.inner = self.inner.iot_job_configuration(input);
            self
        }
        /// <p>The job configuration for the deployment configuration. The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.</p>
        pub fn set_iot_job_configuration(
            mut self,
            input: std::option::Option<crate::model::DeploymentIoTJobConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_iot_job_configuration(input);
            self
        }
        /// <p>The deployment policies for the deployment. These policies define how the deployment updates components and handles failure.</p>
        pub fn deployment_policies(mut self, input: crate::model::DeploymentPolicies) -> Self {
            self.inner = self.inner.deployment_policies(input);
            self
        }
        /// <p>The deployment policies for the deployment. These policies define how the deployment updates components and handles failure.</p>
        pub fn set_deployment_policies(
            mut self,
            input: std::option::Option<crate::model::DeploymentPolicies>,
        ) -> Self {
            self.inner = self.inner.set_deployment_policies(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent. Idempotency means that the request is successfully processed only once, even if you send the request multiple times. When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteComponent`.
    ///
    /// <p>Deletes a version of a component from IoT Greengrass.</p> <note>
    /// <p>This operation deletes the component's recipe and artifacts. As a result, deployments that refer to this component version will fail. If you have deployments that use this component version, you can remove the component from the deployment or update the deployment to use a valid version.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_component_input::Builder,
    }
    impl DeleteComponent {
        /// Creates a new `DeleteComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCoreDevice`.
    ///
    /// <p>Deletes a Greengrass core device, which is an IoT thing. This operation removes the core device from the list of core devices. This operation doesn't delete the IoT thing. For more information about how to delete the IoT thing, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html">DeleteThing</a> in the <i>IoT API Reference</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCoreDevice {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_core_device_input::Builder,
    }
    impl DeleteCoreDevice {
        /// Creates a new `DeleteCoreDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCoreDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCoreDeviceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_device_thing_name(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_device_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeComponent`.
    ///
    /// <p>Retrieves metadata for a version of a component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_component_input::Builder,
    }
    impl DescribeComponent {
        /// Creates a new `DescribeComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateServiceRoleFromAccount`.
    ///
    /// <p>Disassociates the Greengrass service role from IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. Without a service role, IoT Greengrass can't verify the identity of client devices or manage core device connectivity information. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateServiceRoleFromAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_service_role_from_account_input::Builder,
    }
    impl DisassociateServiceRoleFromAccount {
        /// Creates a new `DisassociateServiceRoleFromAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateServiceRoleFromAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateServiceRoleFromAccountError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetComponent`.
    ///
    /// <p>Gets the recipe for a version of a component. Core devices can call this operation to identify the artifacts and requirements to install a component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_component_input::Builder,
    }
    impl GetComponent {
        /// Creates a new `GetComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The format of the recipe.</p>
        pub fn recipe_output_format(mut self, input: crate::model::RecipeOutputFormat) -> Self {
            self.inner = self.inner.recipe_output_format(input);
            self
        }
        /// <p>The format of the recipe.</p>
        pub fn set_recipe_output_format(
            mut self,
            input: std::option::Option<crate::model::RecipeOutputFormat>,
        ) -> Self {
            self.inner = self.inner.set_recipe_output_format(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComponentVersionArtifact`.
    ///
    /// <p>Gets the pre-signed URL to download a public component artifact. Core devices call this operation to identify the URL that they can use to download an artifact to install.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComponentVersionArtifact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_component_version_artifact_input::Builder,
    }
    impl GetComponentVersionArtifact {
        /// Creates a new `GetComponentVersionArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComponentVersionArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComponentVersionArtifactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version. Specify the ARN of a public component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version. Specify the ARN of a public component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The name of the artifact.</p>
        /// <p>You can use the <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a> operation to download the component recipe, which includes the URI of the artifact. The artifact name is the section of the URI after the scheme. For example, in the artifact URI <code>greengrass:SomeArtifact.zip</code>, the artifact name is <code>SomeArtifact.zip</code>.</p>
        pub fn artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.artifact_name(input.into());
            self
        }
        /// <p>The name of the artifact.</p>
        /// <p>You can use the <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a> operation to download the component recipe, which includes the URI of the artifact. The artifact name is the section of the URI after the scheme. For example, in the artifact URI <code>greengrass:SomeArtifact.zip</code>, the artifact name is <code>SomeArtifact.zip</code>.</p>
        pub fn set_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_artifact_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectivityInfo`.
    ///
    /// <p>Retrieves connectivity information for a Greengrass core device.</p>
    /// <p>Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the core device. When a client device calls the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html">IoT Greengrass discovery API</a>, IoT Greengrass returns connectivity information for all of the core devices where the client device can connect. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html">Connect client devices to core devices</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetConnectivityInfo {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_connectivity_info_input::Builder,
    }
    impl GetConnectivityInfo {
        /// Creates a new `GetConnectivityInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectivityInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectivityInfoError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCoreDevice`.
    ///
    /// <p>Retrieves metadata for a Greengrass core device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCoreDevice {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_core_device_input::Builder,
    }
    impl GetCoreDevice {
        /// Creates a new `GetCoreDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCoreDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCoreDeviceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_device_thing_name(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_device_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeployment`.
    ///
    /// <p>Gets a deployment. Deployments define the components that run on Greengrass core devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeployment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_deployment_input::Builder,
    }
    impl GetDeployment {
        /// Creates a new `GetDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(input.into());
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceRoleForAccount`.
    ///
    /// <p>Gets the service role associated with IoT Greengrass for your Amazon Web Services account in this Amazon Web Services Region. IoT Greengrass uses this role to verify the identity of client devices and manage core device connectivity information. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-service-role.html">Greengrass service role</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServiceRoleForAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_service_role_for_account_input::Builder,
    }
    impl GetServiceRoleForAccount {
        /// Creates a new `GetServiceRoleForAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceRoleForAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceRoleForAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListClientDevicesAssociatedWithCoreDevice`.
    ///
    /// <p>Retrieves a paginated list of client devices that are associated with a core device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListClientDevicesAssociatedWithCoreDevice {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_client_devices_associated_with_core_device_input::Builder,
    }
    impl ListClientDevicesAssociatedWithCoreDevice {
        /// Creates a new `ListClientDevicesAssociatedWithCoreDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClientDevicesAssociatedWithCoreDeviceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListClientDevicesAssociatedWithCoreDeviceError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListClientDevicesAssociatedWithCoreDevicePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListClientDevicesAssociatedWithCoreDevicePaginator {
            crate::paginator::ListClientDevicesAssociatedWithCoreDevicePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_device_thing_name(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_device_thing_name(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponents`.
    ///
    /// <p>Retrieves a paginated list of component summaries. This list includes components that you have permission to view.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComponents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_components_input::Builder,
    }
    impl ListComponents {
        /// Creates a new `ListComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComponentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComponentsPaginator {
            crate::paginator::ListComponentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The scope of the components to list.</p>
        /// <p>Default: <code>PRIVATE</code> </p>
        pub fn scope(mut self, input: crate::model::ComponentVisibilityScope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p>The scope of the components to list.</p>
        /// <p>Default: <code>PRIVATE</code> </p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<crate::model::ComponentVisibilityScope>,
        ) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponentVersions`.
    ///
    /// <p>Retrieves a paginated list of all versions for a component. Greater versions are listed first.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComponentVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_component_versions_input::Builder,
    }
    impl ListComponentVersions {
        /// Creates a new `ListComponentVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComponentVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComponentVersionsPaginator {
            crate::paginator::ListComponentVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoreDevices`.
    ///
    /// <p>Retrieves a paginated list of Greengrass core devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCoreDevices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_core_devices_input::Builder,
    }
    impl ListCoreDevices {
        /// Creates a new `ListCoreDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoreDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoreDevicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCoreDevicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCoreDevicesPaginator {
            crate::paginator::ListCoreDevicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT thing group by which to filter. If you specify this parameter, the list includes only core devices that are members of this thing group.</p>
        pub fn thing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_group_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT thing group by which to filter. If you specify this parameter, the list includes only core devices that are members of this thing group.</p>
        pub fn set_thing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_thing_group_arn(input);
            self
        }
        /// <p>The core device status by which to filter. If you specify this parameter, the list includes only core devices that have this status. Choose one of the following options:</p>
        /// <ul>
        /// <li> <p> <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p> </li>
        /// <li> <p> <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core device.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::CoreDeviceStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The core device status by which to filter. If you specify this parameter, the list includes only core devices that have this status. Choose one of the following options:</p>
        /// <ul>
        /// <li> <p> <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p> </li>
        /// <li> <p> <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state on the core device.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CoreDeviceStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeployments`.
    ///
    /// <p>Retrieves a paginated list of deployments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeployments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_deployments_input::Builder,
    }
    impl ListDeployments {
        /// Creates a new `ListDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeploymentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeploymentsPaginator {
            crate::paginator::ListDeploymentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The filter for the list of deployments. Choose one of the following options:</p>
        /// <ul>
        /// <li> <p> <code>ALL</code> – The list includes all deployments.</p> </li>
        /// <li> <p> <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.</p> </li>
        /// </ul>
        /// <p>Default: <code>LATEST_ONLY</code> </p>
        pub fn history_filter(mut self, input: crate::model::DeploymentHistoryFilter) -> Self {
            self.inner = self.inner.history_filter(input);
            self
        }
        /// <p>The filter for the list of deployments. Choose one of the following options:</p>
        /// <ul>
        /// <li> <p> <code>ALL</code> – The list includes all deployments.</p> </li>
        /// <li> <p> <code>LATEST_ONLY</code> – The list includes only the latest revision of each deployment.</p> </li>
        /// </ul>
        /// <p>Default: <code>LATEST_ONLY</code> </p>
        pub fn set_history_filter(
            mut self,
            input: std::option::Option<crate::model::DeploymentHistoryFilter>,
        ) -> Self {
            self.inner = self.inner.set_history_filter(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEffectiveDeployments`.
    ///
    /// <p>Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEffectiveDeployments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_effective_deployments_input::Builder,
    }
    impl ListEffectiveDeployments {
        /// Creates a new `ListEffectiveDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEffectiveDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEffectiveDeploymentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEffectiveDeploymentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEffectiveDeploymentsPaginator {
            crate::paginator::ListEffectiveDeploymentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_device_thing_name(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_device_thing_name(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstalledComponents`.
    ///
    /// <p>Retrieves a paginated list of the components that a Greengrass core device runs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInstalledComponents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_installed_components_input::Builder,
    }
    impl ListInstalledComponents {
        /// Creates a new `ListInstalledComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstalledComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstalledComponentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInstalledComponentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInstalledComponentsPaginator {
            crate::paginator::ListInstalledComponentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_device_thing_name(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_device_thing_name(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the list of tags for an IoT Greengrass resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResolveComponentCandidates`.
    ///
    /// <p>Retrieves a list of components that meet the component, version, and platform requirements of a deployment. Greengrass core devices call this operation when they receive a deployment to identify the components to install.</p>
    /// <p>This operation identifies components that meet all dependency requirements for a deployment. If the requirements conflict, then this operation returns an error and the deployment fails. For example, this occurs if component <code>A</code> requires version <code>&gt;2.0.0</code> and component <code>B</code> requires version <code>&lt;2.0.0</code> of a component dependency.</p>
    /// <p>When you specify the component candidates to resolve, IoT Greengrass compares each component's digest from the core device with the component's digest in the Amazon Web Services Cloud. If the digests don't match, then IoT Greengrass specifies to use the version from the Amazon Web Services Cloud.</p> <important>
    /// <p>To use this operation, you must use the data plane API endpoint and authenticate with an IoT device certificate. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/greengrass.html">IoT Greengrass endpoints and quotas</a>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResolveComponentCandidates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::resolve_component_candidates_input::Builder,
    }
    impl ResolveComponentCandidates {
        /// Creates a new `ResolveComponentCandidates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResolveComponentCandidatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ResolveComponentCandidatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The platform to use to resolve compatible components.</p>
        pub fn platform(mut self, input: crate::model::ComponentPlatform) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p>The platform to use to resolve compatible components.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::ComponentPlatform>,
        ) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// Appends an item to `componentCandidates`.
        ///
        /// To override the contents of this collection use [`set_component_candidates`](Self::set_component_candidates).
        ///
        /// <p>The list of components to resolve.</p>
        pub fn component_candidates(mut self, input: crate::model::ComponentCandidate) -> Self {
            self.inner = self.inner.component_candidates(input);
            self
        }
        /// <p>The list of components to resolve.</p>
        pub fn set_component_candidates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentCandidate>>,
        ) -> Self {
            self.inner = self.inner.set_component_candidates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to an IoT Greengrass resource. If a tag already exists for the resource, this operation updates the tag's value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from an IoT Greengrass resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of keys for tags to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of keys for tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnectivityInfo`.
    ///
    /// <p>Updates connectivity information for a Greengrass core device.</p>
    /// <p>Connectivity information includes endpoints and ports where client devices can connect to an MQTT broker on the core device. When a client device calls the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-discover-api.html">IoT Greengrass discovery API</a>, IoT Greengrass returns connectivity information for all of the core devices where the client device can connect. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/connect-client-devices.html">Connect client devices to core devices</a> in the <i>IoT Greengrass Version 2 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnectivityInfo {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_connectivity_info_input::Builder,
    }
    impl UpdateConnectivityInfo {
        /// Creates a new `UpdateConnectivityInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectivityInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectivityInfoError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
        /// Appends an item to `connectivityInfo`.
        ///
        /// To override the contents of this collection use [`set_connectivity_info`](Self::set_connectivity_info).
        ///
        /// <p>The connectivity information for the core device.</p>
        pub fn connectivity_info(mut self, input: crate::model::ConnectivityInfo) -> Self {
            self.inner = self.inner.connectivity_info(input);
            self
        }
        /// <p>The connectivity information for the core device.</p>
        pub fn set_connectivity_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectivityInfo>>,
        ) -> Self {
            self.inner = self.inner.set_connectivity_info(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
