// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolveComponentCandidatesOutput {
    /// <p>A list of components that meet the requirements that you specify in the request. This list
    /// includes each component's recipe that you can use to install the component.</p>
    pub resolved_component_versions:
        std::option::Option<std::vec::Vec<crate::model::ResolvedComponentVersion>>,
}
impl ResolveComponentCandidatesOutput {
    /// <p>A list of components that meet the requirements that you specify in the request. This list
    /// includes each component's recipe that you can use to install the component.</p>
    pub fn resolved_component_versions(
        &self,
    ) -> std::option::Option<&[crate::model::ResolvedComponentVersion]> {
        self.resolved_component_versions.as_deref()
    }
}
impl std::fmt::Debug for ResolveComponentCandidatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolveComponentCandidatesOutput");
        formatter.field(
            "resolved_component_versions",
            &self.resolved_component_versions,
        );
        formatter.finish()
    }
}
/// See [`ResolveComponentCandidatesOutput`](crate::output::ResolveComponentCandidatesOutput)
pub mod resolve_component_candidates_output {
    /// A builder for [`ResolveComponentCandidatesOutput`](crate::output::ResolveComponentCandidatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolved_component_versions:
            std::option::Option<std::vec::Vec<crate::model::ResolvedComponentVersion>>,
    }
    impl Builder {
        /// Appends an item to `resolved_component_versions`.
        ///
        /// To override the contents of this collection use [`set_resolved_component_versions`](Self::set_resolved_component_versions).
        ///
        /// <p>A list of components that meet the requirements that you specify in the request. This list
        /// includes each component's recipe that you can use to install the component.</p>
        pub fn resolved_component_versions(
            mut self,
            input: impl Into<crate::model::ResolvedComponentVersion>,
        ) -> Self {
            let mut v = self.resolved_component_versions.unwrap_or_default();
            v.push(input.into());
            self.resolved_component_versions = Some(v);
            self
        }
        /// <p>A list of components that meet the requirements that you specify in the request. This list
        /// includes each component's recipe that you can use to install the component.</p>
        pub fn set_resolved_component_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResolvedComponentVersion>>,
        ) -> Self {
            self.resolved_component_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolveComponentCandidatesOutput`](crate::output::ResolveComponentCandidatesOutput)
        pub fn build(self) -> crate::output::ResolveComponentCandidatesOutput {
            crate::output::ResolveComponentCandidatesOutput {
                resolved_component_versions: self.resolved_component_versions,
            }
        }
    }
}
impl ResolveComponentCandidatesOutput {
    /// Creates a new builder-style object to manufacture [`ResolveComponentCandidatesOutput`](crate::output::ResolveComponentCandidatesOutput)
    pub fn builder() -> crate::output::resolve_component_candidates_output::Builder {
        crate::output::resolve_component_candidates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstalledComponentsOutput {
    /// <p>A list that summarizes each component on the core device.</p>
    pub installed_components: std::option::Option<std::vec::Vec<crate::model::InstalledComponent>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInstalledComponentsOutput {
    /// <p>A list that summarizes each component on the core device.</p>
    pub fn installed_components(&self) -> std::option::Option<&[crate::model::InstalledComponent]> {
        self.installed_components.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInstalledComponentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstalledComponentsOutput");
        formatter.field("installed_components", &self.installed_components);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInstalledComponentsOutput`](crate::output::ListInstalledComponentsOutput)
pub mod list_installed_components_output {
    /// A builder for [`ListInstalledComponentsOutput`](crate::output::ListInstalledComponentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) installed_components:
            std::option::Option<std::vec::Vec<crate::model::InstalledComponent>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `installed_components`.
        ///
        /// To override the contents of this collection use [`set_installed_components`](Self::set_installed_components).
        ///
        /// <p>A list that summarizes each component on the core device.</p>
        pub fn installed_components(
            mut self,
            input: impl Into<crate::model::InstalledComponent>,
        ) -> Self {
            let mut v = self.installed_components.unwrap_or_default();
            v.push(input.into());
            self.installed_components = Some(v);
            self
        }
        /// <p>A list that summarizes each component on the core device.</p>
        pub fn set_installed_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstalledComponent>>,
        ) -> Self {
            self.installed_components = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstalledComponentsOutput`](crate::output::ListInstalledComponentsOutput)
        pub fn build(self) -> crate::output::ListInstalledComponentsOutput {
            crate::output::ListInstalledComponentsOutput {
                installed_components: self.installed_components,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInstalledComponentsOutput {
    /// Creates a new builder-style object to manufacture [`ListInstalledComponentsOutput`](crate::output::ListInstalledComponentsOutput)
    pub fn builder() -> crate::output::list_installed_components_output::Builder {
        crate::output::list_installed_components_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEffectiveDeploymentsOutput {
    /// <p>A list that summarizes each deployment on the core device.</p>
    pub effective_deployments:
        std::option::Option<std::vec::Vec<crate::model::EffectiveDeployment>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEffectiveDeploymentsOutput {
    /// <p>A list that summarizes each deployment on the core device.</p>
    pub fn effective_deployments(
        &self,
    ) -> std::option::Option<&[crate::model::EffectiveDeployment]> {
        self.effective_deployments.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEffectiveDeploymentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEffectiveDeploymentsOutput");
        formatter.field("effective_deployments", &self.effective_deployments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEffectiveDeploymentsOutput`](crate::output::ListEffectiveDeploymentsOutput)
pub mod list_effective_deployments_output {
    /// A builder for [`ListEffectiveDeploymentsOutput`](crate::output::ListEffectiveDeploymentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) effective_deployments:
            std::option::Option<std::vec::Vec<crate::model::EffectiveDeployment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `effective_deployments`.
        ///
        /// To override the contents of this collection use [`set_effective_deployments`](Self::set_effective_deployments).
        ///
        /// <p>A list that summarizes each deployment on the core device.</p>
        pub fn effective_deployments(
            mut self,
            input: impl Into<crate::model::EffectiveDeployment>,
        ) -> Self {
            let mut v = self.effective_deployments.unwrap_or_default();
            v.push(input.into());
            self.effective_deployments = Some(v);
            self
        }
        /// <p>A list that summarizes each deployment on the core device.</p>
        pub fn set_effective_deployments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EffectiveDeployment>>,
        ) -> Self {
            self.effective_deployments = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEffectiveDeploymentsOutput`](crate::output::ListEffectiveDeploymentsOutput)
        pub fn build(self) -> crate::output::ListEffectiveDeploymentsOutput {
            crate::output::ListEffectiveDeploymentsOutput {
                effective_deployments: self.effective_deployments,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEffectiveDeploymentsOutput {
    /// Creates a new builder-style object to manufacture [`ListEffectiveDeploymentsOutput`](crate::output::ListEffectiveDeploymentsOutput)
    pub fn builder() -> crate::output::list_effective_deployments_output::Builder {
        crate::output::list_effective_deployments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentsOutput {
    /// <p>A list that summarizes each deployment.</p>
    pub deployments: std::option::Option<std::vec::Vec<crate::model::Deployment>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeploymentsOutput {
    /// <p>A list that summarizes each deployment.</p>
    pub fn deployments(&self) -> std::option::Option<&[crate::model::Deployment]> {
        self.deployments.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeploymentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentsOutput");
        formatter.field("deployments", &self.deployments);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
pub mod list_deployments_output {
    /// A builder for [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployments: std::option::Option<std::vec::Vec<crate::model::Deployment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `deployments`.
        ///
        /// To override the contents of this collection use [`set_deployments`](Self::set_deployments).
        ///
        /// <p>A list that summarizes each deployment.</p>
        pub fn deployments(mut self, input: impl Into<crate::model::Deployment>) -> Self {
            let mut v = self.deployments.unwrap_or_default();
            v.push(input.into());
            self.deployments = Some(v);
            self
        }
        /// <p>A list that summarizes each deployment.</p>
        pub fn set_deployments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Deployment>>,
        ) -> Self {
            self.deployments = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
        pub fn build(self) -> crate::output::ListDeploymentsOutput {
            crate::output::ListDeploymentsOutput {
                deployments: self.deployments,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeploymentsOutput {
    /// Creates a new builder-style object to manufacture [`ListDeploymentsOutput`](crate::output::ListDeploymentsOutput)
    pub fn builder() -> crate::output::list_deployments_output::Builder {
        crate::output::list_deployments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCoreDevicesOutput {
    /// <p>A list that summarizes each core device.</p>
    pub core_devices: std::option::Option<std::vec::Vec<crate::model::CoreDevice>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCoreDevicesOutput {
    /// <p>A list that summarizes each core device.</p>
    pub fn core_devices(&self) -> std::option::Option<&[crate::model::CoreDevice]> {
        self.core_devices.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCoreDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCoreDevicesOutput");
        formatter.field("core_devices", &self.core_devices);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCoreDevicesOutput`](crate::output::ListCoreDevicesOutput)
pub mod list_core_devices_output {
    /// A builder for [`ListCoreDevicesOutput`](crate::output::ListCoreDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_devices: std::option::Option<std::vec::Vec<crate::model::CoreDevice>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `core_devices`.
        ///
        /// To override the contents of this collection use [`set_core_devices`](Self::set_core_devices).
        ///
        /// <p>A list that summarizes each core device.</p>
        pub fn core_devices(mut self, input: impl Into<crate::model::CoreDevice>) -> Self {
            let mut v = self.core_devices.unwrap_or_default();
            v.push(input.into());
            self.core_devices = Some(v);
            self
        }
        /// <p>A list that summarizes each core device.</p>
        pub fn set_core_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoreDevice>>,
        ) -> Self {
            self.core_devices = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCoreDevicesOutput`](crate::output::ListCoreDevicesOutput)
        pub fn build(self) -> crate::output::ListCoreDevicesOutput {
            crate::output::ListCoreDevicesOutput {
                core_devices: self.core_devices,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCoreDevicesOutput {
    /// Creates a new builder-style object to manufacture [`ListCoreDevicesOutput`](crate::output::ListCoreDevicesOutput)
    pub fn builder() -> crate::output::list_core_devices_output::Builder {
        crate::output::list_core_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentVersionsOutput {
    /// <p>A list of versions that exist for the component.</p>
    pub component_versions:
        std::option::Option<std::vec::Vec<crate::model::ComponentVersionListItem>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListComponentVersionsOutput {
    /// <p>A list of versions that exist for the component.</p>
    pub fn component_versions(
        &self,
    ) -> std::option::Option<&[crate::model::ComponentVersionListItem]> {
        self.component_versions.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListComponentVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentVersionsOutput");
        formatter.field("component_versions", &self.component_versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListComponentVersionsOutput`](crate::output::ListComponentVersionsOutput)
pub mod list_component_versions_output {
    /// A builder for [`ListComponentVersionsOutput`](crate::output::ListComponentVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_versions:
            std::option::Option<std::vec::Vec<crate::model::ComponentVersionListItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `component_versions`.
        ///
        /// To override the contents of this collection use [`set_component_versions`](Self::set_component_versions).
        ///
        /// <p>A list of versions that exist for the component.</p>
        pub fn component_versions(
            mut self,
            input: impl Into<crate::model::ComponentVersionListItem>,
        ) -> Self {
            let mut v = self.component_versions.unwrap_or_default();
            v.push(input.into());
            self.component_versions = Some(v);
            self
        }
        /// <p>A list of versions that exist for the component.</p>
        pub fn set_component_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentVersionListItem>>,
        ) -> Self {
            self.component_versions = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentVersionsOutput`](crate::output::ListComponentVersionsOutput)
        pub fn build(self) -> crate::output::ListComponentVersionsOutput {
            crate::output::ListComponentVersionsOutput {
                component_versions: self.component_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListComponentVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListComponentVersionsOutput`](crate::output::ListComponentVersionsOutput)
    pub fn builder() -> crate::output::list_component_versions_output::Builder {
        crate::output::list_component_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentsOutput {
    /// <p>A list that summarizes each component.</p>
    pub components: std::option::Option<std::vec::Vec<crate::model::Component>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListComponentsOutput {
    /// <p>A list that summarizes each component.</p>
    pub fn components(&self) -> std::option::Option<&[crate::model::Component]> {
        self.components.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListComponentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentsOutput");
        formatter.field("components", &self.components);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListComponentsOutput`](crate::output::ListComponentsOutput)
pub mod list_components_output {
    /// A builder for [`ListComponentsOutput`](crate::output::ListComponentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) components: std::option::Option<std::vec::Vec<crate::model::Component>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>A list that summarizes each component.</p>
        pub fn components(mut self, input: impl Into<crate::model::Component>) -> Self {
            let mut v = self.components.unwrap_or_default();
            v.push(input.into());
            self.components = Some(v);
            self
        }
        /// <p>A list that summarizes each component.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Component>>,
        ) -> Self {
            self.components = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentsOutput`](crate::output::ListComponentsOutput)
        pub fn build(self) -> crate::output::ListComponentsOutput {
            crate::output::ListComponentsOutput {
                components: self.components,
                next_token: self.next_token,
            }
        }
    }
}
impl ListComponentsOutput {
    /// Creates a new builder-style object to manufacture [`ListComponentsOutput`](crate::output::ListComponentsOutput)
    pub fn builder() -> crate::output::list_components_output::Builder {
        crate::output::list_components_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClientDevicesAssociatedWithCoreDeviceOutput {
    /// <p>A list that describes the client devices that are associated with the core device.</p>
    pub associated_client_devices:
        std::option::Option<std::vec::Vec<crate::model::AssociatedClientDevice>>,
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListClientDevicesAssociatedWithCoreDeviceOutput {
    /// <p>A list that describes the client devices that are associated with the core device.</p>
    pub fn associated_client_devices(
        &self,
    ) -> std::option::Option<&[crate::model::AssociatedClientDevice]> {
        self.associated_client_devices.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListClientDevicesAssociatedWithCoreDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClientDevicesAssociatedWithCoreDeviceOutput");
        formatter.field("associated_client_devices", &self.associated_client_devices);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListClientDevicesAssociatedWithCoreDeviceOutput`](crate::output::ListClientDevicesAssociatedWithCoreDeviceOutput)
pub mod list_client_devices_associated_with_core_device_output {
    /// A builder for [`ListClientDevicesAssociatedWithCoreDeviceOutput`](crate::output::ListClientDevicesAssociatedWithCoreDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) associated_client_devices:
            std::option::Option<std::vec::Vec<crate::model::AssociatedClientDevice>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `associated_client_devices`.
        ///
        /// To override the contents of this collection use [`set_associated_client_devices`](Self::set_associated_client_devices).
        ///
        /// <p>A list that describes the client devices that are associated with the core device.</p>
        pub fn associated_client_devices(
            mut self,
            input: impl Into<crate::model::AssociatedClientDevice>,
        ) -> Self {
            let mut v = self.associated_client_devices.unwrap_or_default();
            v.push(input.into());
            self.associated_client_devices = Some(v);
            self
        }
        /// <p>A list that describes the client devices that are associated with the core device.</p>
        pub fn set_associated_client_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociatedClientDevice>>,
        ) -> Self {
            self.associated_client_devices = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClientDevicesAssociatedWithCoreDeviceOutput`](crate::output::ListClientDevicesAssociatedWithCoreDeviceOutput)
        pub fn build(self) -> crate::output::ListClientDevicesAssociatedWithCoreDeviceOutput {
            crate::output::ListClientDevicesAssociatedWithCoreDeviceOutput {
                associated_client_devices: self.associated_client_devices,
                next_token: self.next_token,
            }
        }
    }
}
impl ListClientDevicesAssociatedWithCoreDeviceOutput {
    /// Creates a new builder-style object to manufacture [`ListClientDevicesAssociatedWithCoreDeviceOutput`](crate::output::ListClientDevicesAssociatedWithCoreDeviceOutput)
    pub fn builder(
    ) -> crate::output::list_client_devices_associated_with_core_device_output::Builder {
        crate::output::list_client_devices_associated_with_core_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentOutput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The revision number of the deployment.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The ID of the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The name of the deployment.</p>
    pub deployment_name: std::option::Option<std::string::String>,
    /// <p>The status of the deployment.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
    pub iot_job_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
    pub iot_job_arn: std::option::Option<std::string::String>,
    /// <p>The components to deploy. This is a dictionary, where each key is the name of a component,
    /// and each key's value is the version and configuration to deploy for that component.</p>
    pub components: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::ComponentDeploymentSpecification,
        >,
    >,
    /// <p>The deployment policies for the deployment. These policies define how the deployment
    /// updates components and handles failure.</p>
    pub deployment_policies: std::option::Option<crate::model::DeploymentPolicies>,
    /// <p>The job configuration for the deployment configuration. The job configuration specifies
    /// the rollout, timeout, and stop configurations for the deployment configuration.</p>
    pub iot_job_configuration: std::option::Option<crate::model::DeploymentIoTJobConfiguration>,
    /// <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Whether or not the deployment is the latest revision for its target.</p>
    pub is_latest_for_target: bool,
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetDeploymentOutput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The revision number of the deployment.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The ID of the deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The name of the deployment.</p>
    pub fn deployment_name(&self) -> std::option::Option<&str> {
        self.deployment_name.as_deref()
    }
    /// <p>The status of the deployment.</p>
    pub fn deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.deployment_status.as_ref()
    }
    /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
    pub fn iot_job_id(&self) -> std::option::Option<&str> {
        self.iot_job_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
    pub fn iot_job_arn(&self) -> std::option::Option<&str> {
        self.iot_job_arn.as_deref()
    }
    /// <p>The components to deploy. This is a dictionary, where each key is the name of a component,
    /// and each key's value is the version and configuration to deploy for that component.</p>
    pub fn components(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::ComponentDeploymentSpecification,
        >,
    > {
        self.components.as_ref()
    }
    /// <p>The deployment policies for the deployment. These policies define how the deployment
    /// updates components and handles failure.</p>
    pub fn deployment_policies(&self) -> std::option::Option<&crate::model::DeploymentPolicies> {
        self.deployment_policies.as_ref()
    }
    /// <p>The job configuration for the deployment configuration. The job configuration specifies
    /// the rollout, timeout, and stop configurations for the deployment configuration.</p>
    pub fn iot_job_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DeploymentIoTJobConfiguration> {
        self.iot_job_configuration.as_ref()
    }
    /// <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_timestamp.as_ref()
    }
    /// <p>Whether or not the deployment is the latest revision for its target.</p>
    pub fn is_latest_for_target(&self) -> bool {
        self.is_latest_for_target
    }
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentOutput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_name", &self.deployment_name);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("iot_job_id", &self.iot_job_id);
        formatter.field("iot_job_arn", &self.iot_job_arn);
        formatter.field("components", &self.components);
        formatter.field("deployment_policies", &self.deployment_policies);
        formatter.field("iot_job_configuration", &self.iot_job_configuration);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("is_latest_for_target", &self.is_latest_for_target);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
pub mod get_deployment_output {
    /// A builder for [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_name: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) iot_job_id: std::option::Option<std::string::String>,
        pub(crate) iot_job_arn: std::option::Option<std::string::String>,
        pub(crate) components: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::ComponentDeploymentSpecification,
            >,
        >,
        pub(crate) deployment_policies: std::option::Option<crate::model::DeploymentPolicies>,
        pub(crate) iot_job_configuration:
            std::option::Option<crate::model::DeploymentIoTJobConfiguration>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) is_latest_for_target: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The revision number of the deployment.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision number of the deployment.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The name of the deployment.</p>
        pub fn deployment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_name = Some(input.into());
            self
        }
        /// <p>The name of the deployment.</p>
        pub fn set_deployment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_name = input;
            self
        }
        /// <p>The status of the deployment.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The status of the deployment.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
        pub fn iot_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.iot_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
        pub fn set_iot_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iot_job_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
        pub fn iot_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iot_job_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
        pub fn set_iot_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iot_job_arn = input;
            self
        }
        /// Adds a key-value pair to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>The components to deploy. This is a dictionary, where each key is the name of a component,
        /// and each key's value is the version and configuration to deploy for that component.</p>
        pub fn components(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ComponentDeploymentSpecification>,
        ) -> Self {
            let mut hash_map = self.components.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.components = Some(hash_map);
            self
        }
        /// <p>The components to deploy. This is a dictionary, where each key is the name of a component,
        /// and each key's value is the version and configuration to deploy for that component.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentDeploymentSpecification,
                >,
            >,
        ) -> Self {
            self.components = input;
            self
        }
        /// <p>The deployment policies for the deployment. These policies define how the deployment
        /// updates components and handles failure.</p>
        pub fn deployment_policies(mut self, input: crate::model::DeploymentPolicies) -> Self {
            self.deployment_policies = Some(input);
            self
        }
        /// <p>The deployment policies for the deployment. These policies define how the deployment
        /// updates components and handles failure.</p>
        pub fn set_deployment_policies(
            mut self,
            input: std::option::Option<crate::model::DeploymentPolicies>,
        ) -> Self {
            self.deployment_policies = input;
            self
        }
        /// <p>The job configuration for the deployment configuration. The job configuration specifies
        /// the rollout, timeout, and stop configurations for the deployment configuration.</p>
        pub fn iot_job_configuration(
            mut self,
            input: crate::model::DeploymentIoTJobConfiguration,
        ) -> Self {
            self.iot_job_configuration = Some(input);
            self
        }
        /// <p>The job configuration for the deployment configuration. The job configuration specifies
        /// the rollout, timeout, and stop configurations for the deployment configuration.</p>
        pub fn set_iot_job_configuration(
            mut self,
            input: std::option::Option<crate::model::DeploymentIoTJobConfiguration>,
        ) -> Self {
            self.iot_job_configuration = input;
            self
        }
        /// <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>Whether or not the deployment is the latest revision for its target.</p>
        pub fn is_latest_for_target(mut self, input: bool) -> Self {
            self.is_latest_for_target = Some(input);
            self
        }
        /// <p>Whether or not the deployment is the latest revision for its target.</p>
        pub fn set_is_latest_for_target(mut self, input: std::option::Option<bool>) -> Self {
            self.is_latest_for_target = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
        pub fn build(self) -> crate::output::GetDeploymentOutput {
            crate::output::GetDeploymentOutput {
                target_arn: self.target_arn,
                revision_id: self.revision_id,
                deployment_id: self.deployment_id,
                deployment_name: self.deployment_name,
                deployment_status: self.deployment_status,
                iot_job_id: self.iot_job_id,
                iot_job_arn: self.iot_job_arn,
                components: self.components,
                deployment_policies: self.deployment_policies,
                iot_job_configuration: self.iot_job_configuration,
                creation_timestamp: self.creation_timestamp,
                is_latest_for_target: self.is_latest_for_target.unwrap_or_default(),
                tags: self.tags,
            }
        }
    }
}
impl GetDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`GetDeploymentOutput`](crate::output::GetDeploymentOutput)
    pub fn builder() -> crate::output::get_deployment_output::Builder {
        crate::output::get_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCoreDeviceOutput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub core_device_thing_name: std::option::Option<std::string::String>,
    /// <p>The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to
    /// the version of the Greengrass nucleus component that runs on the core device. For more information,
    /// see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
    /// component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub core_version: std::option::Option<std::string::String>,
    /// <p>The operating system platform that the core device runs.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The computer architecture of the core device.</p>
    pub architecture: std::option::Option<std::string::String>,
    /// <p>The status of the core device. The core device status can be:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
    /// on the core device.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::CoreDeviceStatus>,
    /// <p>The time at which the core device's status last updated, expressed in ISO 8601
    /// format.</p>
    pub last_status_update_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetCoreDeviceOutput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub fn core_device_thing_name(&self) -> std::option::Option<&str> {
        self.core_device_thing_name.as_deref()
    }
    /// <p>The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to
    /// the version of the Greengrass nucleus component that runs on the core device. For more information,
    /// see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
    /// component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub fn core_version(&self) -> std::option::Option<&str> {
        self.core_version.as_deref()
    }
    /// <p>The operating system platform that the core device runs.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The computer architecture of the core device.</p>
    pub fn architecture(&self) -> std::option::Option<&str> {
        self.architecture.as_deref()
    }
    /// <p>The status of the core device. The core device status can be:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
    /// on the core device.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::CoreDeviceStatus> {
        self.status.as_ref()
    }
    /// <p>The time at which the core device's status last updated, expressed in ISO 8601
    /// format.</p>
    pub fn last_status_update_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_status_update_timestamp.as_ref()
    }
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetCoreDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCoreDeviceOutput");
        formatter.field("core_device_thing_name", &self.core_device_thing_name);
        formatter.field("core_version", &self.core_version);
        formatter.field("platform", &self.platform);
        formatter.field("architecture", &self.architecture);
        formatter.field("status", &self.status);
        formatter.field(
            "last_status_update_timestamp",
            &self.last_status_update_timestamp,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetCoreDeviceOutput`](crate::output::GetCoreDeviceOutput)
pub mod get_core_device_output {
    /// A builder for [`GetCoreDeviceOutput`](crate::output::GetCoreDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_device_thing_name: std::option::Option<std::string::String>,
        pub(crate) core_version: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CoreDeviceStatus>,
        pub(crate) last_status_update_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_device_thing_name = Some(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_device_thing_name = input;
            self
        }
        /// <p>The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to
        /// the version of the Greengrass nucleus component that runs on the core device. For more information,
        /// see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
        /// component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn core_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_version = Some(input.into());
            self
        }
        /// <p>The version of the IoT Greengrass Core software that the core device runs. This version is equivalent to
        /// the version of the Greengrass nucleus component that runs on the core device. For more information,
        /// see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
        /// component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_core_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.core_version = input;
            self
        }
        /// <p>The operating system platform that the core device runs.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The operating system platform that the core device runs.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The computer architecture of the core device.</p>
        pub fn architecture(mut self, input: impl Into<std::string::String>) -> Self {
            self.architecture = Some(input.into());
            self
        }
        /// <p>The computer architecture of the core device.</p>
        pub fn set_architecture(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.architecture = input;
            self
        }
        /// <p>The status of the core device. The core device status can be:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
        /// on the core device.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::CoreDeviceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the core device. The core device status can be:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
        /// on the core device.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CoreDeviceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time at which the core device's status last updated, expressed in ISO 8601
        /// format.</p>
        pub fn last_status_update_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_status_update_timestamp = Some(input);
            self
        }
        /// <p>The time at which the core device's status last updated, expressed in ISO 8601
        /// format.</p>
        pub fn set_last_status_update_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_status_update_timestamp = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCoreDeviceOutput`](crate::output::GetCoreDeviceOutput)
        pub fn build(self) -> crate::output::GetCoreDeviceOutput {
            crate::output::GetCoreDeviceOutput {
                core_device_thing_name: self.core_device_thing_name,
                core_version: self.core_version,
                platform: self.platform,
                architecture: self.architecture,
                status: self.status,
                last_status_update_timestamp: self.last_status_update_timestamp,
                tags: self.tags,
            }
        }
    }
}
impl GetCoreDeviceOutput {
    /// Creates a new builder-style object to manufacture [`GetCoreDeviceOutput`](crate::output::GetCoreDeviceOutput)
    pub fn builder() -> crate::output::get_core_device_output::Builder {
        crate::output::get_core_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentVersionArtifactOutput {
    /// <p>The URL of the artifact.</p>
    pub pre_signed_url: std::option::Option<std::string::String>,
}
impl GetComponentVersionArtifactOutput {
    /// <p>The URL of the artifact.</p>
    pub fn pre_signed_url(&self) -> std::option::Option<&str> {
        self.pre_signed_url.as_deref()
    }
}
impl std::fmt::Debug for GetComponentVersionArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentVersionArtifactOutput");
        formatter.field("pre_signed_url", &self.pre_signed_url);
        formatter.finish()
    }
}
/// See [`GetComponentVersionArtifactOutput`](crate::output::GetComponentVersionArtifactOutput)
pub mod get_component_version_artifact_output {
    /// A builder for [`GetComponentVersionArtifactOutput`](crate::output::GetComponentVersionArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The URL of the artifact.</p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>The URL of the artifact.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentVersionArtifactOutput`](crate::output::GetComponentVersionArtifactOutput)
        pub fn build(self) -> crate::output::GetComponentVersionArtifactOutput {
            crate::output::GetComponentVersionArtifactOutput {
                pre_signed_url: self.pre_signed_url,
            }
        }
    }
}
impl GetComponentVersionArtifactOutput {
    /// Creates a new builder-style object to manufacture [`GetComponentVersionArtifactOutput`](crate::output::GetComponentVersionArtifactOutput)
    pub fn builder() -> crate::output::get_component_version_artifact_output::Builder {
        crate::output::get_component_version_artifact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentOutput {
    /// <p>The format of the recipe.</p>
    pub recipe_output_format: std::option::Option<crate::model::RecipeOutputFormat>,
    /// <p>The recipe of the component version.</p>
    pub recipe: std::option::Option<aws_smithy_types::Blob>,
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetComponentOutput {
    /// <p>The format of the recipe.</p>
    pub fn recipe_output_format(&self) -> std::option::Option<&crate::model::RecipeOutputFormat> {
        self.recipe_output_format.as_ref()
    }
    /// <p>The recipe of the component version.</p>
    pub fn recipe(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.recipe.as_ref()
    }
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentOutput");
        formatter.field("recipe_output_format", &self.recipe_output_format);
        formatter.field("recipe", &self.recipe);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetComponentOutput`](crate::output::GetComponentOutput)
pub mod get_component_output {
    /// A builder for [`GetComponentOutput`](crate::output::GetComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recipe_output_format: std::option::Option<crate::model::RecipeOutputFormat>,
        pub(crate) recipe: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The format of the recipe.</p>
        pub fn recipe_output_format(mut self, input: crate::model::RecipeOutputFormat) -> Self {
            self.recipe_output_format = Some(input);
            self
        }
        /// <p>The format of the recipe.</p>
        pub fn set_recipe_output_format(
            mut self,
            input: std::option::Option<crate::model::RecipeOutputFormat>,
        ) -> Self {
            self.recipe_output_format = input;
            self
        }
        /// <p>The recipe of the component version.</p>
        pub fn recipe(mut self, input: aws_smithy_types::Blob) -> Self {
            self.recipe = Some(input);
            self
        }
        /// <p>The recipe of the component version.</p>
        pub fn set_recipe(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.recipe = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentOutput`](crate::output::GetComponentOutput)
        pub fn build(self) -> crate::output::GetComponentOutput {
            crate::output::GetComponentOutput {
                recipe_output_format: self.recipe_output_format,
                recipe: self.recipe,
                tags: self.tags,
            }
        }
    }
}
impl GetComponentOutput {
    /// Creates a new builder-style object to manufacture [`GetComponentOutput`](crate::output::GetComponentOutput)
    pub fn builder() -> crate::output::get_component_output::Builder {
        crate::output::get_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeComponentOutput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The version of the component.</p>
    pub component_version: std::option::Option<std::string::String>,
    /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The publisher of the component version.</p>
    pub publisher: std::option::Option<std::string::String>,
    /// <p>The description of the component version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the component version in IoT Greengrass V2. This status
    /// is different from the status of the component on a core device.</p>
    pub status: std::option::Option<crate::model::CloudComponentStatus>,
    /// <p>The platforms that the component version supports.</p>
    pub platforms: std::option::Option<std::vec::Vec<crate::model::ComponentPlatform>>,
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeComponentOutput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>The version of the component.</p>
    pub fn component_version(&self) -> std::option::Option<&str> {
        self.component_version.as_deref()
    }
    /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_timestamp.as_ref()
    }
    /// <p>The publisher of the component version.</p>
    pub fn publisher(&self) -> std::option::Option<&str> {
        self.publisher.as_deref()
    }
    /// <p>The description of the component version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The status of the component version in IoT Greengrass V2. This status
    /// is different from the status of the component on a core device.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CloudComponentStatus> {
        self.status.as_ref()
    }
    /// <p>The platforms that the component version supports.</p>
    pub fn platforms(&self) -> std::option::Option<&[crate::model::ComponentPlatform]> {
        self.platforms.as_deref()
    }
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeComponentOutput");
        formatter.field("arn", &self.arn);
        formatter.field("component_name", &self.component_name);
        formatter.field("component_version", &self.component_version);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("publisher", &self.publisher);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("platforms", &self.platforms);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeComponentOutput`](crate::output::DescribeComponentOutput)
pub mod describe_component_output {
    /// A builder for [`DescribeComponentOutput`](crate::output::DescribeComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) component_version: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) publisher: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CloudComponentStatus>,
        pub(crate) platforms: std::option::Option<std::vec::Vec<crate::model::ComponentPlatform>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The version of the component.</p>
        pub fn component_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        pub fn set_component_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_version = input;
            self
        }
        /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The publisher of the component version.</p>
        pub fn publisher(mut self, input: impl Into<std::string::String>) -> Self {
            self.publisher = Some(input.into());
            self
        }
        /// <p>The publisher of the component version.</p>
        pub fn set_publisher(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.publisher = input;
            self
        }
        /// <p>The description of the component version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the component version in IoT Greengrass V2. This status
        /// is different from the status of the component on a core device.</p>
        pub fn status(mut self, input: crate::model::CloudComponentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the component version in IoT Greengrass V2. This status
        /// is different from the status of the component on a core device.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CloudComponentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `platforms`.
        ///
        /// To override the contents of this collection use [`set_platforms`](Self::set_platforms).
        ///
        /// <p>The platforms that the component version supports.</p>
        pub fn platforms(mut self, input: impl Into<crate::model::ComponentPlatform>) -> Self {
            let mut v = self.platforms.unwrap_or_default();
            v.push(input.into());
            self.platforms = Some(v);
            self
        }
        /// <p>The platforms that the component version supports.</p>
        pub fn set_platforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentPlatform>>,
        ) -> Self {
            self.platforms = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeComponentOutput`](crate::output::DescribeComponentOutput)
        pub fn build(self) -> crate::output::DescribeComponentOutput {
            crate::output::DescribeComponentOutput {
                arn: self.arn,
                component_name: self.component_name,
                component_version: self.component_version,
                creation_timestamp: self.creation_timestamp,
                publisher: self.publisher,
                description: self.description,
                status: self.status,
                platforms: self.platforms,
                tags: self.tags,
            }
        }
    }
}
impl DescribeComponentOutput {
    /// Creates a new builder-style object to manufacture [`DescribeComponentOutput`](crate::output::DescribeComponentOutput)
    pub fn builder() -> crate::output::describe_component_output::Builder {
        crate::output::describe_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCoreDeviceOutput {}
impl std::fmt::Debug for DeleteCoreDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCoreDeviceOutput");
        formatter.finish()
    }
}
/// See [`DeleteCoreDeviceOutput`](crate::output::DeleteCoreDeviceOutput)
pub mod delete_core_device_output {
    /// A builder for [`DeleteCoreDeviceOutput`](crate::output::DeleteCoreDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCoreDeviceOutput`](crate::output::DeleteCoreDeviceOutput)
        pub fn build(self) -> crate::output::DeleteCoreDeviceOutput {
            crate::output::DeleteCoreDeviceOutput {}
        }
    }
}
impl DeleteCoreDeviceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCoreDeviceOutput`](crate::output::DeleteCoreDeviceOutput)
    pub fn builder() -> crate::output::delete_core_device_output::Builder {
        crate::output::delete_core_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteComponentOutput {}
impl std::fmt::Debug for DeleteComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteComponentOutput");
        formatter.finish()
    }
}
/// See [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
pub mod delete_component_output {
    /// A builder for [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
        pub fn build(self) -> crate::output::DeleteComponentOutput {
            crate::output::DeleteComponentOutput {}
        }
    }
}
impl DeleteComponentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
    pub fn builder() -> crate::output::delete_component_output::Builder {
        crate::output::delete_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentOutput {
    /// <p>The ID of the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
    pub iot_job_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
    pub iot_job_arn: std::option::Option<std::string::String>,
}
impl CreateDeploymentOutput {
    /// <p>The ID of the deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
    pub fn iot_job_id(&self) -> std::option::Option<&str> {
        self.iot_job_id.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
    pub fn iot_job_arn(&self) -> std::option::Option<&str> {
        self.iot_job_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentOutput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("iot_job_id", &self.iot_job_id);
        formatter.field("iot_job_arn", &self.iot_job_arn);
        formatter.finish()
    }
}
/// See [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
pub mod create_deployment_output {
    /// A builder for [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) iot_job_id: std::option::Option<std::string::String>,
        pub(crate) iot_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
        pub fn iot_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.iot_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
        pub fn set_iot_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iot_job_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
        pub fn iot_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iot_job_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
        pub fn set_iot_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iot_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
        pub fn build(self) -> crate::output::CreateDeploymentOutput {
            crate::output::CreateDeploymentOutput {
                deployment_id: self.deployment_id,
                iot_job_id: self.iot_job_id,
                iot_job_arn: self.iot_job_arn,
            }
        }
    }
}
impl CreateDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentOutput`](crate::output::CreateDeploymentOutput)
    pub fn builder() -> crate::output::create_deployment_output::Builder {
        crate::output::create_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentVersionOutput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The version of the component.</p>
    pub component_version: std::option::Option<std::string::String>,
    /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the component version in IoT Greengrass V2. This status
    /// is different from the status of the component on a core device.</p>
    pub status: std::option::Option<crate::model::CloudComponentStatus>,
}
impl CreateComponentVersionOutput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the component.</p>
    pub fn component_name(&self) -> std::option::Option<&str> {
        self.component_name.as_deref()
    }
    /// <p>The version of the component.</p>
    pub fn component_version(&self) -> std::option::Option<&str> {
        self.component_version.as_deref()
    }
    /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_timestamp.as_ref()
    }
    /// <p>The status of the component version in IoT Greengrass V2. This status
    /// is different from the status of the component on a core device.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CloudComponentStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CreateComponentVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentVersionOutput");
        formatter.field("arn", &self.arn);
        formatter.field("component_name", &self.component_name);
        formatter.field("component_version", &self.component_version);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CreateComponentVersionOutput`](crate::output::CreateComponentVersionOutput)
pub mod create_component_version_output {
    /// A builder for [`CreateComponentVersionOutput`](crate::output::CreateComponentVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) component_version: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::CloudComponentStatus>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The version of the component.</p>
        pub fn component_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        pub fn set_component_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_version = input;
            self
        }
        /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The status of the component version in IoT Greengrass V2. This status
        /// is different from the status of the component on a core device.</p>
        pub fn status(mut self, input: crate::model::CloudComponentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the component version in IoT Greengrass V2. This status
        /// is different from the status of the component on a core device.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CloudComponentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComponentVersionOutput`](crate::output::CreateComponentVersionOutput)
        pub fn build(self) -> crate::output::CreateComponentVersionOutput {
            crate::output::CreateComponentVersionOutput {
                arn: self.arn,
                component_name: self.component_name,
                component_version: self.component_version,
                creation_timestamp: self.creation_timestamp,
                status: self.status,
            }
        }
    }
}
impl CreateComponentVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateComponentVersionOutput`](crate::output::CreateComponentVersionOutput)
    pub fn builder() -> crate::output::create_component_version_output::Builder {
        crate::output::create_component_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelDeploymentOutput {
    /// <p>A message that communicates if the cancel was successful.</p>
    pub message: std::option::Option<std::string::String>,
}
impl CancelDeploymentOutput {
    /// <p>A message that communicates if the cancel was successful.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for CancelDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelDeploymentOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`CancelDeploymentOutput`](crate::output::CancelDeploymentOutput)
pub mod cancel_deployment_output {
    /// A builder for [`CancelDeploymentOutput`](crate::output::CancelDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that communicates if the cancel was successful.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that communicates if the cancel was successful.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelDeploymentOutput`](crate::output::CancelDeploymentOutput)
        pub fn build(self) -> crate::output::CancelDeploymentOutput {
            crate::output::CancelDeploymentOutput {
                message: self.message,
            }
        }
    }
}
impl CancelDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`CancelDeploymentOutput`](crate::output::CancelDeploymentOutput)
    pub fn builder() -> crate::output::cancel_deployment_output::Builder {
        crate::output::cancel_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateClientDeviceFromCoreDeviceOutput {
    /// <p>The list of errors (if any) for the entries in the request. Each error entry contains the
    /// name of the IoT thing that failed to disassociate.</p>
    pub error_entries: std::option::Option<
        std::vec::Vec<crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry>,
    >,
}
impl BatchDisassociateClientDeviceFromCoreDeviceOutput {
    /// <p>The list of errors (if any) for the entries in the request. Each error entry contains the
    /// name of the IoT thing that failed to disassociate.</p>
    pub fn error_entries(
        &self,
    ) -> std::option::Option<&[crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry]>
    {
        self.error_entries.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateClientDeviceFromCoreDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisassociateClientDeviceFromCoreDeviceOutput");
        formatter.field("error_entries", &self.error_entries);
        formatter.finish()
    }
}
/// See [`BatchDisassociateClientDeviceFromCoreDeviceOutput`](crate::output::BatchDisassociateClientDeviceFromCoreDeviceOutput)
pub mod batch_disassociate_client_device_from_core_device_output {
    /// A builder for [`BatchDisassociateClientDeviceFromCoreDeviceOutput`](crate::output::BatchDisassociateClientDeviceFromCoreDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_entries: std::option::Option<
            std::vec::Vec<crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry>,
        >,
    }
    impl Builder {
        /// Appends an item to `error_entries`.
        ///
        /// To override the contents of this collection use [`set_error_entries`](Self::set_error_entries).
        ///
        /// <p>The list of errors (if any) for the entries in the request. Each error entry contains the
        /// name of the IoT thing that failed to disassociate.</p>
        pub fn error_entries(
            mut self,
            input: impl Into<crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry>,
        ) -> Self {
            let mut v = self.error_entries.unwrap_or_default();
            v.push(input.into());
            self.error_entries = Some(v);
            self
        }
        /// <p>The list of errors (if any) for the entries in the request. Each error entry contains the
        /// name of the IoT thing that failed to disassociate.</p>
        pub fn set_error_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry>,
            >,
        ) -> Self {
            self.error_entries = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateClientDeviceFromCoreDeviceOutput`](crate::output::BatchDisassociateClientDeviceFromCoreDeviceOutput)
        pub fn build(self) -> crate::output::BatchDisassociateClientDeviceFromCoreDeviceOutput {
            crate::output::BatchDisassociateClientDeviceFromCoreDeviceOutput {
                error_entries: self.error_entries,
            }
        }
    }
}
impl BatchDisassociateClientDeviceFromCoreDeviceOutput {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateClientDeviceFromCoreDeviceOutput`](crate::output::BatchDisassociateClientDeviceFromCoreDeviceOutput)
    pub fn builder(
    ) -> crate::output::batch_disassociate_client_device_from_core_device_output::Builder {
        crate::output::batch_disassociate_client_device_from_core_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateClientDeviceWithCoreDeviceOutput {
    /// <p>The list of any errors for the entries in the request. Each error entry contains the name
    /// of the IoT thing that failed to associate.</p>
    pub error_entries: std::option::Option<
        std::vec::Vec<crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry>,
    >,
}
impl BatchAssociateClientDeviceWithCoreDeviceOutput {
    /// <p>The list of any errors for the entries in the request. Each error entry contains the name
    /// of the IoT thing that failed to associate.</p>
    pub fn error_entries(
        &self,
    ) -> std::option::Option<&[crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry]> {
        self.error_entries.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateClientDeviceWithCoreDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAssociateClientDeviceWithCoreDeviceOutput");
        formatter.field("error_entries", &self.error_entries);
        formatter.finish()
    }
}
/// See [`BatchAssociateClientDeviceWithCoreDeviceOutput`](crate::output::BatchAssociateClientDeviceWithCoreDeviceOutput)
pub mod batch_associate_client_device_with_core_device_output {
    /// A builder for [`BatchAssociateClientDeviceWithCoreDeviceOutput`](crate::output::BatchAssociateClientDeviceWithCoreDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_entries: std::option::Option<
            std::vec::Vec<crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry>,
        >,
    }
    impl Builder {
        /// Appends an item to `error_entries`.
        ///
        /// To override the contents of this collection use [`set_error_entries`](Self::set_error_entries).
        ///
        /// <p>The list of any errors for the entries in the request. Each error entry contains the name
        /// of the IoT thing that failed to associate.</p>
        pub fn error_entries(
            mut self,
            input: impl Into<crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry>,
        ) -> Self {
            let mut v = self.error_entries.unwrap_or_default();
            v.push(input.into());
            self.error_entries = Some(v);
            self
        }
        /// <p>The list of any errors for the entries in the request. Each error entry contains the name
        /// of the IoT thing that failed to associate.</p>
        pub fn set_error_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry>,
            >,
        ) -> Self {
            self.error_entries = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateClientDeviceWithCoreDeviceOutput`](crate::output::BatchAssociateClientDeviceWithCoreDeviceOutput)
        pub fn build(self) -> crate::output::BatchAssociateClientDeviceWithCoreDeviceOutput {
            crate::output::BatchAssociateClientDeviceWithCoreDeviceOutput {
                error_entries: self.error_entries,
            }
        }
    }
}
impl BatchAssociateClientDeviceWithCoreDeviceOutput {
    /// Creates a new builder-style object to manufacture [`BatchAssociateClientDeviceWithCoreDeviceOutput`](crate::output::BatchAssociateClientDeviceWithCoreDeviceOutput)
    pub fn builder() -> crate::output::batch_associate_client_device_with_core_device_output::Builder
    {
        crate::output::batch_associate_client_device_with_core_device_output::Builder::default()
    }
}
