// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchAssociateClientDeviceWithCoreDeviceInput`](crate::input::BatchAssociateClientDeviceWithCoreDeviceInput)
pub mod batch_associate_client_device_with_core_device_input {
    /// A builder for [`BatchAssociateClientDeviceWithCoreDeviceInput`](crate::input::BatchAssociateClientDeviceWithCoreDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries: std::option::Option<
            std::vec::Vec<crate::model::AssociateClientDeviceWithCoreDeviceEntry>,
        >,
        pub(crate) core_device_thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of client devices to associate.</p>
        pub fn entries(
            mut self,
            input: impl Into<crate::model::AssociateClientDeviceWithCoreDeviceEntry>,
        ) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input.into());
            self.entries = Some(v);
            self
        }
        /// <p>The list of client devices to associate.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssociateClientDeviceWithCoreDeviceEntry>,
            >,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_device_thing_name = Some(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_device_thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateClientDeviceWithCoreDeviceInput`](crate::input::BatchAssociateClientDeviceWithCoreDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchAssociateClientDeviceWithCoreDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::BatchAssociateClientDeviceWithCoreDeviceInput {
                    entries: self.entries,
                    core_device_thing_name: self.core_device_thing_name,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type BatchAssociateClientDeviceWithCoreDeviceInputOperationOutputAlias =
    crate::operation::BatchAssociateClientDeviceWithCoreDevice;
#[doc(hidden)]
pub type BatchAssociateClientDeviceWithCoreDeviceInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl BatchAssociateClientDeviceWithCoreDeviceInput {
    /// Consumes the builder and constructs an Operation<[`BatchAssociateClientDeviceWithCoreDevice`](crate::operation::BatchAssociateClientDeviceWithCoreDevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchAssociateClientDeviceWithCoreDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchAssociateClientDeviceWithCoreDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.core_device_thing_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_device_thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let core_device_thing_name = aws_smithy_http::label::fmt_string(input_1, false);
            if core_device_thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_device_thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/coreDevices/{coreDeviceThingName}/associateClientDevices",
                coreDeviceThingName = core_device_thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchAssociateClientDeviceWithCoreDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchAssociateClientDeviceWithCoreDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_associate_client_device_with_core_device(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchAssociateClientDeviceWithCoreDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchAssociateClientDeviceWithCoreDevice",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchAssociateClientDeviceWithCoreDeviceInput`](crate::input::BatchAssociateClientDeviceWithCoreDeviceInput)
    pub fn builder() -> crate::input::batch_associate_client_device_with_core_device_input::Builder
    {
        crate::input::batch_associate_client_device_with_core_device_input::Builder::default()
    }
}

/// See [`BatchDisassociateClientDeviceFromCoreDeviceInput`](crate::input::BatchDisassociateClientDeviceFromCoreDeviceInput)
pub mod batch_disassociate_client_device_from_core_device_input {
    /// A builder for [`BatchDisassociateClientDeviceFromCoreDeviceInput`](crate::input::BatchDisassociateClientDeviceFromCoreDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries: std::option::Option<
            std::vec::Vec<crate::model::DisassociateClientDeviceFromCoreDeviceEntry>,
        >,
        pub(crate) core_device_thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of client devices to disassociate.</p>
        pub fn entries(
            mut self,
            input: impl Into<crate::model::DisassociateClientDeviceFromCoreDeviceEntry>,
        ) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input.into());
            self.entries = Some(v);
            self
        }
        /// <p>The list of client devices to disassociate.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DisassociateClientDeviceFromCoreDeviceEntry>,
            >,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_device_thing_name = Some(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_device_thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateClientDeviceFromCoreDeviceInput`](crate::input::BatchDisassociateClientDeviceFromCoreDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDisassociateClientDeviceFromCoreDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::BatchDisassociateClientDeviceFromCoreDeviceInput {
                    entries: self.entries,
                    core_device_thing_name: self.core_device_thing_name,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type BatchDisassociateClientDeviceFromCoreDeviceInputOperationOutputAlias =
    crate::operation::BatchDisassociateClientDeviceFromCoreDevice;
#[doc(hidden)]
pub type BatchDisassociateClientDeviceFromCoreDeviceInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl BatchDisassociateClientDeviceFromCoreDeviceInput {
    /// Consumes the builder and constructs an Operation<[`BatchDisassociateClientDeviceFromCoreDevice`](crate::operation::BatchDisassociateClientDeviceFromCoreDevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDisassociateClientDeviceFromCoreDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDisassociateClientDeviceFromCoreDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.core_device_thing_name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_device_thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let core_device_thing_name = aws_smithy_http::label::fmt_string(input_2, false);
            if core_device_thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_device_thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/coreDevices/{coreDeviceThingName}/disassociateClientDevices",
                coreDeviceThingName = core_device_thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDisassociateClientDeviceFromCoreDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDisassociateClientDeviceFromCoreDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_disassociate_client_device_from_core_device(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDisassociateClientDeviceFromCoreDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDisassociateClientDeviceFromCoreDevice",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDisassociateClientDeviceFromCoreDeviceInput`](crate::input::BatchDisassociateClientDeviceFromCoreDeviceInput)
    pub fn builder(
    ) -> crate::input::batch_disassociate_client_device_from_core_device_input::Builder {
        crate::input::batch_disassociate_client_device_from_core_device_input::Builder::default()
    }
}

/// See [`CancelDeploymentInput`](crate::input::CancelDeploymentInput)
pub mod cancel_deployment_input {
    /// A builder for [`CancelDeploymentInput`](crate::input::CancelDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelDeploymentInput`](crate::input::CancelDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelDeploymentInput {
                deployment_id: self.deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelDeploymentInputOperationOutputAlias = crate::operation::CancelDeployment;
#[doc(hidden)]
pub type CancelDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CancelDeployment`](crate::operation::CancelDeployment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.deployment_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    })?;
            let deployment_id = aws_smithy_http::label::fmt_string(input_3, false);
            if deployment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "deployment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/deployments/{deploymentId}/cancel",
                deploymentId = deployment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelDeployment",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelDeploymentInput`](crate::input::CancelDeploymentInput)
    pub fn builder() -> crate::input::cancel_deployment_input::Builder {
        crate::input::cancel_deployment_input::Builder::default()
    }
}

/// See [`CreateComponentVersionInput`](crate::input::CreateComponentVersionInput)
pub mod create_component_version_input {
    /// A builder for [`CreateComponentVersionInput`](crate::input::CreateComponentVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inline_recipe: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) lambda_function: std::option::Option<crate::model::LambdaFunctionRecipeSource>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The recipe to use to create the component. The recipe defines the component's metadata,
        /// parameters, dependencies, lifecycle, artifacts, and platform compatibility.</p>
        /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
        pub fn inline_recipe(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inline_recipe = Some(input);
            self
        }
        /// <p>The recipe to use to create the component. The recipe defines the component's metadata,
        /// parameters, dependencies, lifecycle, artifacts, and platform compatibility.</p>
        /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
        pub fn set_inline_recipe(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inline_recipe = input;
            self
        }
        /// <p>The parameters to create a component from a Lambda function.</p>
        /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
        pub fn lambda_function(mut self, input: crate::model::LambdaFunctionRecipeSource) -> Self {
            self.lambda_function = Some(input);
            self
        }
        /// <p>The parameters to create a component from a Lambda function.</p>
        /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
        pub fn set_lambda_function(
            mut self,
            input: std::option::Option<crate::model::LambdaFunctionRecipeSource>,
        ) -> Self {
            self.lambda_function = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
        /// Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
        /// When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
        /// returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
        /// idempotent requests for up to 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
        /// Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
        /// When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
        /// returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
        /// idempotent requests for up to 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComponentVersionInput`](crate::input::CreateComponentVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateComponentVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateComponentVersionInput {
                inline_recipe: self.inline_recipe,
                lambda_function: self.lambda_function,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateComponentVersionInputOperationOutputAlias = crate::operation::CreateComponentVersion;
#[doc(hidden)]
pub type CreateComponentVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateComponentVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateComponentVersion`](crate::operation::CreateComponentVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateComponentVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateComponentVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/v2/createComponentVersion")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateComponentVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateComponentVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_component_version(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateComponentVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateComponentVersion",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateComponentVersionInput`](crate::input::CreateComponentVersionInput)
    pub fn builder() -> crate::input::create_component_version_input::Builder {
        crate::input::create_component_version_input::Builder::default()
    }
}

/// See [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
pub mod create_deployment_input {
    /// A builder for [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) deployment_name: std::option::Option<std::string::String>,
        pub(crate) components: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::ComponentDeploymentSpecification,
            >,
        >,
        pub(crate) iot_job_configuration:
            std::option::Option<crate::model::DeploymentIoTJobConfiguration>,
        pub(crate) deployment_policies: std::option::Option<crate::model::DeploymentPolicies>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The name of the deployment.</p>
        pub fn deployment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_name = Some(input.into());
            self
        }
        /// <p>The name of the deployment.</p>
        pub fn set_deployment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_name = input;
            self
        }
        /// Adds a key-value pair to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>The components to deploy. This is a dictionary, where each key is the name of a component,
        /// and each key's value is the version and configuration to deploy for that component.</p>
        pub fn components(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ComponentDeploymentSpecification>,
        ) -> Self {
            let mut hash_map = self.components.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.components = Some(hash_map);
            self
        }
        /// <p>The components to deploy. This is a dictionary, where each key is the name of a component,
        /// and each key's value is the version and configuration to deploy for that component.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentDeploymentSpecification,
                >,
            >,
        ) -> Self {
            self.components = input;
            self
        }
        /// <p>The job configuration for the deployment configuration. The job configuration specifies
        /// the rollout, timeout, and stop configurations for the deployment configuration.</p>
        pub fn iot_job_configuration(
            mut self,
            input: crate::model::DeploymentIoTJobConfiguration,
        ) -> Self {
            self.iot_job_configuration = Some(input);
            self
        }
        /// <p>The job configuration for the deployment configuration. The job configuration specifies
        /// the rollout, timeout, and stop configurations for the deployment configuration.</p>
        pub fn set_iot_job_configuration(
            mut self,
            input: std::option::Option<crate::model::DeploymentIoTJobConfiguration>,
        ) -> Self {
            self.iot_job_configuration = input;
            self
        }
        /// <p>The deployment policies for the deployment. These policies define how the deployment
        /// updates components and handles failure.</p>
        pub fn deployment_policies(mut self, input: crate::model::DeploymentPolicies) -> Self {
            self.deployment_policies = Some(input);
            self
        }
        /// <p>The deployment policies for the deployment. These policies define how the deployment
        /// updates components and handles failure.</p>
        pub fn set_deployment_policies(
            mut self,
            input: std::option::Option<crate::model::DeploymentPolicies>,
        ) -> Self {
            self.deployment_policies = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
        /// Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
        /// When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
        /// returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
        /// idempotent requests for up to 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
        /// Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
        /// When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
        /// returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
        /// idempotent requests for up to 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentInput {
                target_arn: self.target_arn,
                deployment_name: self.deployment_name,
                components: self.components,
                iot_job_configuration: self.iot_job_configuration,
                deployment_policies: self.deployment_policies,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentInputOperationOutputAlias = crate::operation::CreateDeployment;
#[doc(hidden)]
pub type CreateDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeployment`](crate::operation::CreateDeployment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/v2/deployments").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_deployment(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeployment",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
}

/// See [`DeleteComponentInput`](crate::input::DeleteComponentInput)
pub mod delete_component_input {
    /// A builder for [`DeleteComponentInput`](crate::input::DeleteComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteComponentInput`](crate::input::DeleteComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteComponentInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DeleteComponentInputOperationOutputAlias = crate::operation::DeleteComponent;
#[doc(hidden)]
pub type DeleteComponentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteComponentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteComponent`](crate::operation::DeleteComponent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteComponent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteComponentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.arn;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    })?;
            let arn = aws_smithy_http::label::fmt_string(input_4, false);
            if arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/v2/components/{arn}", arn = arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteComponentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteComponentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteComponent",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteComponentInput`](crate::input::DeleteComponentInput)
    pub fn builder() -> crate::input::delete_component_input::Builder {
        crate::input::delete_component_input::Builder::default()
    }
}

/// See [`DeleteCoreDeviceInput`](crate::input::DeleteCoreDeviceInput)
pub mod delete_core_device_input {
    /// A builder for [`DeleteCoreDeviceInput`](crate::input::DeleteCoreDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_device_thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_device_thing_name = Some(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_device_thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCoreDeviceInput`](crate::input::DeleteCoreDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCoreDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCoreDeviceInput {
                core_device_thing_name: self.core_device_thing_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCoreDeviceInputOperationOutputAlias = crate::operation::DeleteCoreDevice;
#[doc(hidden)]
pub type DeleteCoreDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCoreDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCoreDevice`](crate::operation::DeleteCoreDevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCoreDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCoreDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.core_device_thing_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_device_thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let core_device_thing_name = aws_smithy_http::label::fmt_string(input_5, false);
            if core_device_thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_device_thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/coreDevices/{coreDeviceThingName}",
                coreDeviceThingName = core_device_thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCoreDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCoreDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCoreDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCoreDevice",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCoreDeviceInput`](crate::input::DeleteCoreDeviceInput)
    pub fn builder() -> crate::input::delete_core_device_input::Builder {
        crate::input::delete_core_device_input::Builder::default()
    }
}

/// See [`DescribeComponentInput`](crate::input::DescribeComponentInput)
pub mod describe_component_input {
    /// A builder for [`DescribeComponentInput`](crate::input::DescribeComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeComponentInput`](crate::input::DescribeComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeComponentInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type DescribeComponentInputOperationOutputAlias = crate::operation::DescribeComponent;
#[doc(hidden)]
pub type DescribeComponentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeComponentInput {
    /// Consumes the builder and constructs an Operation<[`DescribeComponent`](crate::operation::DescribeComponent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeComponent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeComponentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.arn;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    })?;
            let arn = aws_smithy_http::label::fmt_string(input_6, false);
            if arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/components/{arn}/metadata",
                arn = arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeComponentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeComponentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeComponent",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeComponentInput`](crate::input::DescribeComponentInput)
    pub fn builder() -> crate::input::describe_component_input::Builder {
        crate::input::describe_component_input::Builder::default()
    }
}

/// See [`GetComponentInput`](crate::input::GetComponentInput)
pub mod get_component_input {
    /// A builder for [`GetComponentInput`](crate::input::GetComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recipe_output_format: std::option::Option<crate::model::RecipeOutputFormat>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The format of the recipe.</p>
        pub fn recipe_output_format(mut self, input: crate::model::RecipeOutputFormat) -> Self {
            self.recipe_output_format = Some(input);
            self
        }
        /// <p>The format of the recipe.</p>
        pub fn set_recipe_output_format(
            mut self,
            input: std::option::Option<crate::model::RecipeOutputFormat>,
        ) -> Self {
            self.recipe_output_format = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentInput`](crate::input::GetComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetComponentInput {
                recipe_output_format: self.recipe_output_format,
                arn: self.arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetComponentInputOperationOutputAlias = crate::operation::GetComponent;
#[doc(hidden)]
pub type GetComponentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetComponentInput {
    /// Consumes the builder and constructs an Operation<[`GetComponent`](crate::operation::GetComponent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComponent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetComponentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.arn;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    })?;
            let arn = aws_smithy_http::label::fmt_string(input_7, false);
            if arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/v2/components/{arn}", arn = arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetComponentInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_8) = &_input.recipe_output_format {
                query.push_kv(
                    "recipeOutputFormat",
                    &aws_smithy_http::query::fmt_string(&inner_8),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetComponentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetComponentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComponent",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetComponentInput`](crate::input::GetComponentInput)
    pub fn builder() -> crate::input::get_component_input::Builder {
        crate::input::get_component_input::Builder::default()
    }
}

/// See [`GetComponentVersionArtifactInput`](crate::input::GetComponentVersionArtifactInput)
pub mod get_component_version_artifact_input {
    /// A builder for [`GetComponentVersionArtifactInput`](crate::input::GetComponentVersionArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) artifact_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version. Specify the ARN of a public component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version. Specify the ARN of a public component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the artifact.</p>
        /// <p>You can use the <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a> operation to
        /// download the component recipe, which includes the URI of the artifact. The artifact name is
        /// the section of the URI after the scheme. For example, in the artifact URI
        /// <code>greengrass:SomeArtifact.zip</code>, the artifact name is
        /// <code>SomeArtifact.zip</code>.</p>
        pub fn artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_name = Some(input.into());
            self
        }
        /// <p>The name of the artifact.</p>
        /// <p>You can use the <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a> operation to
        /// download the component recipe, which includes the URI of the artifact. The artifact name is
        /// the section of the URI after the scheme. For example, in the artifact URI
        /// <code>greengrass:SomeArtifact.zip</code>, the artifact name is
        /// <code>SomeArtifact.zip</code>.</p>
        pub fn set_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentVersionArtifactInput`](crate::input::GetComponentVersionArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetComponentVersionArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetComponentVersionArtifactInput {
                arn: self.arn,
                artifact_name: self.artifact_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetComponentVersionArtifactInputOperationOutputAlias =
    crate::operation::GetComponentVersionArtifact;
#[doc(hidden)]
pub type GetComponentVersionArtifactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetComponentVersionArtifactInput {
    /// Consumes the builder and constructs an Operation<[`GetComponentVersionArtifact`](crate::operation::GetComponentVersionArtifact)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComponentVersionArtifact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetComponentVersionArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.arn;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    })?;
            let arn = aws_smithy_http::label::fmt_string(input_9, false);
            if arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.artifact_name;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "artifact_name",
                        details: "cannot be empty or unset",
                    })?;
            let artifact_name = aws_smithy_http::label::fmt_string(input_10, true);
            if artifact_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "artifact_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/components/{arn}/artifacts/{artifactName}",
                arn = arn,
                artifactName = artifact_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetComponentVersionArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetComponentVersionArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComponentVersionArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComponentVersionArtifact",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetComponentVersionArtifactInput`](crate::input::GetComponentVersionArtifactInput)
    pub fn builder() -> crate::input::get_component_version_artifact_input::Builder {
        crate::input::get_component_version_artifact_input::Builder::default()
    }
}

/// See [`GetCoreDeviceInput`](crate::input::GetCoreDeviceInput)
pub mod get_core_device_input {
    /// A builder for [`GetCoreDeviceInput`](crate::input::GetCoreDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_device_thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_device_thing_name = Some(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_device_thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCoreDeviceInput`](crate::input::GetCoreDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCoreDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCoreDeviceInput {
                core_device_thing_name: self.core_device_thing_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCoreDeviceInputOperationOutputAlias = crate::operation::GetCoreDevice;
#[doc(hidden)]
pub type GetCoreDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCoreDeviceInput {
    /// Consumes the builder and constructs an Operation<[`GetCoreDevice`](crate::operation::GetCoreDevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCoreDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCoreDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.core_device_thing_name;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_device_thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let core_device_thing_name = aws_smithy_http::label::fmt_string(input_11, false);
            if core_device_thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_device_thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/coreDevices/{coreDeviceThingName}",
                coreDeviceThingName = core_device_thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCoreDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCoreDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCoreDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCoreDevice",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCoreDeviceInput`](crate::input::GetCoreDeviceInput)
    pub fn builder() -> crate::input::get_core_device_input::Builder {
        crate::input::get_core_device_input::Builder::default()
    }
}

/// See [`GetDeploymentInput`](crate::input::GetDeploymentInput)
pub mod get_deployment_input {
    /// A builder for [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentInput`](crate::input::GetDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentInput {
                deployment_id: self.deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentInputOperationOutputAlias = crate::operation::GetDeployment;
#[doc(hidden)]
pub type GetDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`GetDeployment`](crate::operation::GetDeployment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.deployment_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    })?;
            let deployment_id = aws_smithy_http::label::fmt_string(input_12, false);
            if deployment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "deployment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/deployments/{deploymentId}",
                deploymentId = deployment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeployment",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentInput`](crate::input::GetDeploymentInput)
    pub fn builder() -> crate::input::get_deployment_input::Builder {
        crate::input::get_deployment_input::Builder::default()
    }
}

/// See [`ListClientDevicesAssociatedWithCoreDeviceInput`](crate::input::ListClientDevicesAssociatedWithCoreDeviceInput)
pub mod list_client_devices_associated_with_core_device_input {
    /// A builder for [`ListClientDevicesAssociatedWithCoreDeviceInput`](crate::input::ListClientDevicesAssociatedWithCoreDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_device_thing_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_device_thing_name = Some(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_device_thing_name = input;
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClientDevicesAssociatedWithCoreDeviceInput`](crate::input::ListClientDevicesAssociatedWithCoreDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListClientDevicesAssociatedWithCoreDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListClientDevicesAssociatedWithCoreDeviceInput {
                    core_device_thing_name: self.core_device_thing_name,
                    max_results: self.max_results,
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListClientDevicesAssociatedWithCoreDeviceInputOperationOutputAlias =
    crate::operation::ListClientDevicesAssociatedWithCoreDevice;
#[doc(hidden)]
pub type ListClientDevicesAssociatedWithCoreDeviceInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ListClientDevicesAssociatedWithCoreDeviceInput {
    /// Consumes the builder and constructs an Operation<[`ListClientDevicesAssociatedWithCoreDevice`](crate::operation::ListClientDevicesAssociatedWithCoreDevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListClientDevicesAssociatedWithCoreDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListClientDevicesAssociatedWithCoreDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.core_device_thing_name;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_device_thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let core_device_thing_name = aws_smithy_http::label::fmt_string(input_13, false);
            if core_device_thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_device_thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/coreDevices/{coreDeviceThingName}/associatedClientDevices",
                coreDeviceThingName = core_device_thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListClientDevicesAssociatedWithCoreDeviceInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_14) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_14).encode(),
                );
            }
            if let Some(inner_15) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_15));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListClientDevicesAssociatedWithCoreDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListClientDevicesAssociatedWithCoreDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListClientDevicesAssociatedWithCoreDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListClientDevicesAssociatedWithCoreDevice",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListClientDevicesAssociatedWithCoreDeviceInput`](crate::input::ListClientDevicesAssociatedWithCoreDeviceInput)
    pub fn builder() -> crate::input::list_client_devices_associated_with_core_device_input::Builder
    {
        crate::input::list_client_devices_associated_with_core_device_input::Builder::default()
    }
}

/// See [`ListComponentsInput`](crate::input::ListComponentsInput)
pub mod list_components_input {
    /// A builder for [`ListComponentsInput`](crate::input::ListComponentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scope: std::option::Option<crate::model::ComponentVisibilityScope>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The scope of the components to list.</p>
        /// <p>Default: <code>PRIVATE</code>
        /// </p>
        pub fn scope(mut self, input: crate::model::ComponentVisibilityScope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p>The scope of the components to list.</p>
        /// <p>Default: <code>PRIVATE</code>
        /// </p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<crate::model::ComponentVisibilityScope>,
        ) -> Self {
            self.scope = input;
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentsInput`](crate::input::ListComponentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListComponentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListComponentsInput {
                scope: self.scope,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListComponentsInputOperationOutputAlias = crate::operation::ListComponents;
#[doc(hidden)]
pub type ListComponentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListComponentsInput {
    /// Consumes the builder and constructs an Operation<[`ListComponents`](crate::operation::ListComponents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListComponents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListComponentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/v2/components").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListComponentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_16) = &_input.scope {
                query.push_kv("scope", &aws_smithy_http::query::fmt_string(&inner_16));
            }
            if let Some(inner_17) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_17).encode(),
                );
            }
            if let Some(inner_18) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_18));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListComponentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListComponentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListComponents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListComponents",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListComponentsInput`](crate::input::ListComponentsInput)
    pub fn builder() -> crate::input::list_components_input::Builder {
        crate::input::list_components_input::Builder::default()
    }
}

/// See [`ListComponentVersionsInput`](crate::input::ListComponentVersionsInput)
pub mod list_component_versions_input {
    /// A builder for [`ListComponentVersionsInput`](crate::input::ListComponentVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentVersionsInput`](crate::input::ListComponentVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListComponentVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListComponentVersionsInput {
                arn: self.arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListComponentVersionsInputOperationOutputAlias = crate::operation::ListComponentVersions;
#[doc(hidden)]
pub type ListComponentVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListComponentVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListComponentVersions`](crate::operation::ListComponentVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListComponentVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListComponentVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.arn;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    })?;
            let arn = aws_smithy_http::label::fmt_string(input_19, false);
            if arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/components/{arn}/versions",
                arn = arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListComponentVersionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_20) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_20).encode(),
                );
            }
            if let Some(inner_21) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_21));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListComponentVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListComponentVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListComponentVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListComponentVersions",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListComponentVersionsInput`](crate::input::ListComponentVersionsInput)
    pub fn builder() -> crate::input::list_component_versions_input::Builder {
        crate::input::list_component_versions_input::Builder::default()
    }
}

/// See [`ListCoreDevicesInput`](crate::input::ListCoreDevicesInput)
pub mod list_core_devices_input {
    /// A builder for [`ListCoreDevicesInput`](crate::input::ListCoreDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_group_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CoreDeviceStatus>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT thing group by which to filter. If you specify this parameter, the
        /// list includes only core devices that are members of this thing group.</p>
        pub fn thing_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_group_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT thing group by which to filter. If you specify this parameter, the
        /// list includes only core devices that are members of this thing group.</p>
        pub fn set_thing_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.thing_group_arn = input;
            self
        }
        /// <p>The core device status by which to filter. If you specify this parameter, the list
        /// includes only core devices that have this status. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
        /// on the core device.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::CoreDeviceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The core device status by which to filter. If you specify this parameter, the list
        /// includes only core devices that have this status. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
        /// on the core device.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CoreDeviceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCoreDevicesInput`](crate::input::ListCoreDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCoreDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCoreDevicesInput {
                thing_group_arn: self.thing_group_arn,
                status: self.status,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCoreDevicesInputOperationOutputAlias = crate::operation::ListCoreDevices;
#[doc(hidden)]
pub type ListCoreDevicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCoreDevicesInput {
    /// Consumes the builder and constructs an Operation<[`ListCoreDevices`](crate::operation::ListCoreDevices)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCoreDevices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCoreDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/v2/coreDevices").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListCoreDevicesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_22) = &_input.thing_group_arn {
                query.push_kv(
                    "thingGroupArn",
                    &aws_smithy_http::query::fmt_string(&inner_22),
                );
            }
            if let Some(inner_23) = &_input.status {
                query.push_kv("status", &aws_smithy_http::query::fmt_string(&inner_23));
            }
            if let Some(inner_24) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_24).encode(),
                );
            }
            if let Some(inner_25) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCoreDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCoreDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCoreDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCoreDevices",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCoreDevicesInput`](crate::input::ListCoreDevicesInput)
    pub fn builder() -> crate::input::list_core_devices_input::Builder {
        crate::input::list_core_devices_input::Builder::default()
    }
}

/// See [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
pub mod list_deployments_input {
    /// A builder for [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) history_filter: std::option::Option<crate::model::DeploymentHistoryFilter>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The filter for the list of deployments. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL</code> – The list includes all deployments.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATEST_ONLY</code> – The list includes only the latest revision of each
        /// deployment.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>LATEST_ONLY</code>
        /// </p>
        pub fn history_filter(mut self, input: crate::model::DeploymentHistoryFilter) -> Self {
            self.history_filter = Some(input);
            self
        }
        /// <p>The filter for the list of deployments. Choose one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL</code> – The list includes all deployments.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LATEST_ONLY</code> – The list includes only the latest revision of each
        /// deployment.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>LATEST_ONLY</code>
        /// </p>
        pub fn set_history_filter(
            mut self,
            input: std::option::Option<crate::model::DeploymentHistoryFilter>,
        ) -> Self {
            self.history_filter = input;
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeploymentsInput {
                target_arn: self.target_arn,
                history_filter: self.history_filter,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeploymentsInputOperationOutputAlias = crate::operation::ListDeployments;
#[doc(hidden)]
pub type ListDeploymentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeployments`](crate::operation::ListDeployments)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeployments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeploymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/v2/deployments").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListDeploymentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_26) = &_input.target_arn {
                query.push_kv("targetArn", &aws_smithy_http::query::fmt_string(&inner_26));
            }
            if let Some(inner_27) = &_input.history_filter {
                query.push_kv(
                    "historyFilter",
                    &aws_smithy_http::query::fmt_string(&inner_27),
                );
            }
            if let Some(inner_28) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_28).encode(),
                );
            }
            if let Some(inner_29) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_29));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeploymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeploymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeployments",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
    pub fn builder() -> crate::input::list_deployments_input::Builder {
        crate::input::list_deployments_input::Builder::default()
    }
}

/// See [`ListEffectiveDeploymentsInput`](crate::input::ListEffectiveDeploymentsInput)
pub mod list_effective_deployments_input {
    /// A builder for [`ListEffectiveDeploymentsInput`](crate::input::ListEffectiveDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_device_thing_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_device_thing_name = Some(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_device_thing_name = input;
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEffectiveDeploymentsInput`](crate::input::ListEffectiveDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEffectiveDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEffectiveDeploymentsInput {
                core_device_thing_name: self.core_device_thing_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEffectiveDeploymentsInputOperationOutputAlias =
    crate::operation::ListEffectiveDeployments;
#[doc(hidden)]
pub type ListEffectiveDeploymentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEffectiveDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`ListEffectiveDeployments`](crate::operation::ListEffectiveDeployments)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEffectiveDeployments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEffectiveDeploymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.core_device_thing_name;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_device_thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let core_device_thing_name = aws_smithy_http::label::fmt_string(input_30, false);
            if core_device_thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_device_thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/coreDevices/{coreDeviceThingName}/effectiveDeployments",
                coreDeviceThingName = core_device_thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListEffectiveDeploymentsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_31) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_31).encode(),
                );
            }
            if let Some(inner_32) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_32));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEffectiveDeploymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEffectiveDeploymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEffectiveDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEffectiveDeployments",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEffectiveDeploymentsInput`](crate::input::ListEffectiveDeploymentsInput)
    pub fn builder() -> crate::input::list_effective_deployments_input::Builder {
        crate::input::list_effective_deployments_input::Builder::default()
    }
}

/// See [`ListInstalledComponentsInput`](crate::input::ListInstalledComponentsInput)
pub mod list_installed_components_input {
    /// A builder for [`ListInstalledComponentsInput`](crate::input::ListInstalledComponentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_device_thing_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_device_thing_name = Some(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_device_thing_name = input;
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per paginated request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to be used for the next set of paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstalledComponentsInput`](crate::input::ListInstalledComponentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstalledComponentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstalledComponentsInput {
                core_device_thing_name: self.core_device_thing_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstalledComponentsInputOperationOutputAlias =
    crate::operation::ListInstalledComponents;
#[doc(hidden)]
pub type ListInstalledComponentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInstalledComponentsInput {
    /// Consumes the builder and constructs an Operation<[`ListInstalledComponents`](crate::operation::ListInstalledComponents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstalledComponents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstalledComponentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.core_device_thing_name;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_device_thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let core_device_thing_name = aws_smithy_http::label::fmt_string(input_33, false);
            if core_device_thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_device_thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/v2/coreDevices/{coreDeviceThingName}/installedComponents",
                coreDeviceThingName = core_device_thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListInstalledComponentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_34) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_34).encode(),
                );
            }
            if let Some(inner_35) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_35));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstalledComponentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstalledComponentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstalledComponents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstalledComponents",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstalledComponentsInput`](crate::input::ListInstalledComponentsInput)
    pub fn builder() -> crate::input::list_installed_components_input::Builder {
        crate::input::list_installed_components_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.resource_arn;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_36, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ResolveComponentCandidatesInput`](crate::input::ResolveComponentCandidatesInput)
pub mod resolve_component_candidates_input {
    /// A builder for [`ResolveComponentCandidatesInput`](crate::input::ResolveComponentCandidatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform: std::option::Option<crate::model::ComponentPlatform>,
        pub(crate) component_candidates:
            std::option::Option<std::vec::Vec<crate::model::ComponentCandidate>>,
    }
    impl Builder {
        /// <p>The platform to use to resolve compatible components.</p>
        pub fn platform(mut self, input: crate::model::ComponentPlatform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform to use to resolve compatible components.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::ComponentPlatform>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// Appends an item to `component_candidates`.
        ///
        /// To override the contents of this collection use [`set_component_candidates`](Self::set_component_candidates).
        ///
        /// <p>The list of components to resolve.</p>
        pub fn component_candidates(
            mut self,
            input: impl Into<crate::model::ComponentCandidate>,
        ) -> Self {
            let mut v = self.component_candidates.unwrap_or_default();
            v.push(input.into());
            self.component_candidates = Some(v);
            self
        }
        /// <p>The list of components to resolve.</p>
        pub fn set_component_candidates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentCandidate>>,
        ) -> Self {
            self.component_candidates = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolveComponentCandidatesInput`](crate::input::ResolveComponentCandidatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResolveComponentCandidatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResolveComponentCandidatesInput {
                platform: self.platform,
                component_candidates: self.component_candidates,
            })
        }
    }
}
#[doc(hidden)]
pub type ResolveComponentCandidatesInputOperationOutputAlias =
    crate::operation::ResolveComponentCandidates;
#[doc(hidden)]
pub type ResolveComponentCandidatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResolveComponentCandidatesInput {
    /// Consumes the builder and constructs an Operation<[`ResolveComponentCandidates`](crate::operation::ResolveComponentCandidates)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResolveComponentCandidates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResolveComponentCandidatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/v2/resolveComponentCandidates")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResolveComponentCandidatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResolveComponentCandidatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_resolve_component_candidates(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResolveComponentCandidates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResolveComponentCandidates",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResolveComponentCandidatesInput`](crate::input::ResolveComponentCandidatesInput)
    pub fn builder() -> crate::input::resolve_component_candidates_input::Builder {
        crate::input::resolve_component_candidates_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of key-value pairs that contain metadata for the resource. For more
        /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
        /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.resource_arn;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_37, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of keys for tags to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of keys for tags to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.resource_arn;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_38, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_39) = &_input.tag_keys {
                for inner_40 in inner_39 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_40));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "greengrassv2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of keys for tags to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to untag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of keys for tags to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource to tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolveComponentCandidatesInput {
    /// <p>The platform to use to resolve compatible components.</p>
    pub platform: std::option::Option<crate::model::ComponentPlatform>,
    /// <p>The list of components to resolve.</p>
    pub component_candidates: std::option::Option<std::vec::Vec<crate::model::ComponentCandidate>>,
}
impl ResolveComponentCandidatesInput {
    /// <p>The platform to use to resolve compatible components.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::ComponentPlatform> {
        self.platform.as_ref()
    }
    /// <p>The list of components to resolve.</p>
    pub fn component_candidates(&self) -> std::option::Option<&[crate::model::ComponentCandidate]> {
        self.component_candidates.as_deref()
    }
}
impl std::fmt::Debug for ResolveComponentCandidatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolveComponentCandidatesInput");
        formatter.field("platform", &self.platform);
        formatter.field("component_candidates", &self.component_candidates);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstalledComponentsInput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub core_device_thing_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInstalledComponentsInput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub fn core_device_thing_name(&self) -> std::option::Option<&str> {
        self.core_device_thing_name.as_deref()
    }
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInstalledComponentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstalledComponentsInput");
        formatter.field("core_device_thing_name", &self.core_device_thing_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEffectiveDeploymentsInput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub core_device_thing_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEffectiveDeploymentsInput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub fn core_device_thing_name(&self) -> std::option::Option<&str> {
        self.core_device_thing_name.as_deref()
    }
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEffectiveDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEffectiveDeploymentsInput");
        formatter.field("core_device_thing_name", &self.core_device_thing_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentsInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The filter for the list of deployments. Choose one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL</code> – The list includes all deployments.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LATEST_ONLY</code> – The list includes only the latest revision of each
    /// deployment.</p>
    /// </li>
    /// </ul>
    /// <p>Default: <code>LATEST_ONLY</code>
    /// </p>
    pub history_filter: std::option::Option<crate::model::DeploymentHistoryFilter>,
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeploymentsInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The filter for the list of deployments. Choose one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL</code> – The list includes all deployments.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LATEST_ONLY</code> – The list includes only the latest revision of each
    /// deployment.</p>
    /// </li>
    /// </ul>
    /// <p>Default: <code>LATEST_ONLY</code>
    /// </p>
    pub fn history_filter(&self) -> std::option::Option<&crate::model::DeploymentHistoryFilter> {
        self.history_filter.as_ref()
    }
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentsInput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("history_filter", &self.history_filter);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCoreDevicesInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT thing group by which to filter. If you specify this parameter, the
    /// list includes only core devices that are members of this thing group.</p>
    pub thing_group_arn: std::option::Option<std::string::String>,
    /// <p>The core device status by which to filter. If you specify this parameter, the list
    /// includes only core devices that have this status. Choose one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
    /// on the core device.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::CoreDeviceStatus>,
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCoreDevicesInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT thing group by which to filter. If you specify this parameter, the
    /// list includes only core devices that are members of this thing group.</p>
    pub fn thing_group_arn(&self) -> std::option::Option<&str> {
        self.thing_group_arn.as_deref()
    }
    /// <p>The core device status by which to filter. If you specify this parameter, the list
    /// includes only core devices that have this status. Choose one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
    /// on the core device.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::CoreDeviceStatus> {
        self.status.as_ref()
    }
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCoreDevicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCoreDevicesInput");
        formatter.field("thing_group_arn", &self.thing_group_arn);
        formatter.field("status", &self.status);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentVersionsInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListComponentVersionsInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListComponentVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentVersionsInput");
        formatter.field("arn", &self.arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentsInput {
    /// <p>The scope of the components to list.</p>
    /// <p>Default: <code>PRIVATE</code>
    /// </p>
    pub scope: std::option::Option<crate::model::ComponentVisibilityScope>,
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListComponentsInput {
    /// <p>The scope of the components to list.</p>
    /// <p>Default: <code>PRIVATE</code>
    /// </p>
    pub fn scope(&self) -> std::option::Option<&crate::model::ComponentVisibilityScope> {
        self.scope.as_ref()
    }
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListComponentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentsInput");
        formatter.field("scope", &self.scope);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClientDevicesAssociatedWithCoreDeviceInput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub core_device_thing_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to be used for the next set of paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListClientDevicesAssociatedWithCoreDeviceInput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub fn core_device_thing_name(&self) -> std::option::Option<&str> {
        self.core_device_thing_name.as_deref()
    }
    /// <p>The maximum number of results to be returned per paginated request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to be used for the next set of paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListClientDevicesAssociatedWithCoreDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClientDevicesAssociatedWithCoreDeviceInput");
        formatter.field("core_device_thing_name", &self.core_device_thing_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentInput {
    /// <p>The ID of the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
}
impl GetDeploymentInput {
    /// <p>The ID of the deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
}
impl std::fmt::Debug for GetDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCoreDeviceInput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub core_device_thing_name: std::option::Option<std::string::String>,
}
impl GetCoreDeviceInput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub fn core_device_thing_name(&self) -> std::option::Option<&str> {
        self.core_device_thing_name.as_deref()
    }
}
impl std::fmt::Debug for GetCoreDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCoreDeviceInput");
        formatter.field("core_device_thing_name", &self.core_device_thing_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentVersionArtifactInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version. Specify the ARN of a public component version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the artifact.</p>
    /// <p>You can use the <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a> operation to
    /// download the component recipe, which includes the URI of the artifact. The artifact name is
    /// the section of the URI after the scheme. For example, in the artifact URI
    /// <code>greengrass:SomeArtifact.zip</code>, the artifact name is
    /// <code>SomeArtifact.zip</code>.</p>
    pub artifact_name: std::option::Option<std::string::String>,
}
impl GetComponentVersionArtifactInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version. Specify the ARN of a public component version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the artifact.</p>
    /// <p>You can use the <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html">GetComponent</a> operation to
    /// download the component recipe, which includes the URI of the artifact. The artifact name is
    /// the section of the URI after the scheme. For example, in the artifact URI
    /// <code>greengrass:SomeArtifact.zip</code>, the artifact name is
    /// <code>SomeArtifact.zip</code>.</p>
    pub fn artifact_name(&self) -> std::option::Option<&str> {
        self.artifact_name.as_deref()
    }
}
impl std::fmt::Debug for GetComponentVersionArtifactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentVersionArtifactInput");
        formatter.field("arn", &self.arn);
        formatter.field("artifact_name", &self.artifact_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentInput {
    /// <p>The format of the recipe.</p>
    pub recipe_output_format: std::option::Option<crate::model::RecipeOutputFormat>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetComponentInput {
    /// <p>The format of the recipe.</p>
    pub fn recipe_output_format(&self) -> std::option::Option<&crate::model::RecipeOutputFormat> {
        self.recipe_output_format.as_ref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentInput");
        formatter.field("recipe_output_format", &self.recipe_output_format);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeComponentInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DescribeComponentInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeComponentInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCoreDeviceInput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub core_device_thing_name: std::option::Option<std::string::String>,
}
impl DeleteCoreDeviceInput {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub fn core_device_thing_name(&self) -> std::option::Option<&str> {
        self.core_device_thing_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteCoreDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCoreDeviceInput");
        formatter.field("core_device_thing_name", &self.core_device_thing_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteComponentInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl DeleteComponentInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteComponentInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The name of the deployment.</p>
    pub deployment_name: std::option::Option<std::string::String>,
    /// <p>The components to deploy. This is a dictionary, where each key is the name of a component,
    /// and each key's value is the version and configuration to deploy for that component.</p>
    pub components: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::ComponentDeploymentSpecification,
        >,
    >,
    /// <p>The job configuration for the deployment configuration. The job configuration specifies
    /// the rollout, timeout, and stop configurations for the deployment configuration.</p>
    pub iot_job_configuration: std::option::Option<crate::model::DeploymentIoTJobConfiguration>,
    /// <p>The deployment policies for the deployment. These policies define how the deployment
    /// updates components and handles failure.</p>
    pub deployment_policies: std::option::Option<crate::model::DeploymentPolicies>,
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
    /// Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
    /// When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
    /// returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
    /// idempotent requests for up to 8 hours.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateDeploymentInput {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The name of the deployment.</p>
    pub fn deployment_name(&self) -> std::option::Option<&str> {
        self.deployment_name.as_deref()
    }
    /// <p>The components to deploy. This is a dictionary, where each key is the name of a component,
    /// and each key's value is the version and configuration to deploy for that component.</p>
    pub fn components(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::ComponentDeploymentSpecification,
        >,
    > {
        self.components.as_ref()
    }
    /// <p>The job configuration for the deployment configuration. The job configuration specifies
    /// the rollout, timeout, and stop configurations for the deployment configuration.</p>
    pub fn iot_job_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DeploymentIoTJobConfiguration> {
        self.iot_job_configuration.as_ref()
    }
    /// <p>The deployment policies for the deployment. These policies define how the deployment
    /// updates components and handles failure.</p>
    pub fn deployment_policies(&self) -> std::option::Option<&crate::model::DeploymentPolicies> {
        self.deployment_policies.as_ref()
    }
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
    /// Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
    /// When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
    /// returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
    /// idempotent requests for up to 8 hours.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentInput");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("deployment_name", &self.deployment_name);
        formatter.field("components", &self.components);
        formatter.field("iot_job_configuration", &self.iot_job_configuration);
        formatter.field("deployment_policies", &self.deployment_policies);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentVersionInput {
    /// <p>The recipe to use to create the component. The recipe defines the component's metadata,
    /// parameters, dependencies, lifecycle, artifacts, and platform compatibility.</p>
    /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
    pub inline_recipe: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The parameters to create a component from a Lambda function.</p>
    /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
    pub lambda_function: std::option::Option<crate::model::LambdaFunctionRecipeSource>,
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
    /// Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
    /// When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
    /// returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
    /// idempotent requests for up to 8 hours.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateComponentVersionInput {
    /// <p>The recipe to use to create the component. The recipe defines the component's metadata,
    /// parameters, dependencies, lifecycle, artifacts, and platform compatibility.</p>
    /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
    pub fn inline_recipe(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.inline_recipe.as_ref()
    }
    /// <p>The parameters to create a component from a Lambda function.</p>
    /// <p>You must specify either <code>inlineRecipe</code> or <code>lambdaFunction</code>.</p>
    pub fn lambda_function(
        &self,
    ) -> std::option::Option<&crate::model::LambdaFunctionRecipeSource> {
        self.lambda_function.as_ref()
    }
    /// <p>A list of key-value pairs that contain metadata for the resource. For more
    /// information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
    /// resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you can provide to ensure that the request is idempotent.
    /// Idempotency means that the request is successfully processed only once, even if you send the request multiple times.
    /// When a request succeeds, and you specify the same client token for subsequent successful requests, the IoT Greengrass V2 service
    /// returns the successful response that it caches from the previous request. IoT Greengrass V2 caches successful responses for
    /// idempotent requests for up to 8 hours.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateComponentVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentVersionInput");
        formatter.field("inline_recipe", &self.inline_recipe);
        formatter.field("lambda_function", &self.lambda_function);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelDeploymentInput {
    /// <p>The ID of the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
}
impl CancelDeploymentInput {
    /// <p>The ID of the deployment.</p>
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
}
impl std::fmt::Debug for CancelDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelDeploymentInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateClientDeviceFromCoreDeviceInput {
    /// <p>The list of client devices to disassociate.</p>
    pub entries: std::option::Option<
        std::vec::Vec<crate::model::DisassociateClientDeviceFromCoreDeviceEntry>,
    >,
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub core_device_thing_name: std::option::Option<std::string::String>,
}
impl BatchDisassociateClientDeviceFromCoreDeviceInput {
    /// <p>The list of client devices to disassociate.</p>
    pub fn entries(
        &self,
    ) -> std::option::Option<&[crate::model::DisassociateClientDeviceFromCoreDeviceEntry]> {
        self.entries.as_deref()
    }
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub fn core_device_thing_name(&self) -> std::option::Option<&str> {
        self.core_device_thing_name.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateClientDeviceFromCoreDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisassociateClientDeviceFromCoreDeviceInput");
        formatter.field("entries", &self.entries);
        formatter.field("core_device_thing_name", &self.core_device_thing_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateClientDeviceWithCoreDeviceInput {
    /// <p>The list of client devices to associate.</p>
    pub entries:
        std::option::Option<std::vec::Vec<crate::model::AssociateClientDeviceWithCoreDeviceEntry>>,
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub core_device_thing_name: std::option::Option<std::string::String>,
}
impl BatchAssociateClientDeviceWithCoreDeviceInput {
    /// <p>The list of client devices to associate.</p>
    pub fn entries(
        &self,
    ) -> std::option::Option<&[crate::model::AssociateClientDeviceWithCoreDeviceEntry]> {
        self.entries.as_deref()
    }
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub fn core_device_thing_name(&self) -> std::option::Option<&str> {
        self.core_device_thing_name.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateClientDeviceWithCoreDeviceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAssociateClientDeviceWithCoreDeviceInput");
        formatter.field("entries", &self.entries);
        formatter.field("core_device_thing_name", &self.core_device_thing_name);
        formatter.finish()
    }
}
