// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchAssociateClientDeviceWithCoreDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchAssociateClientDeviceWithCoreDeviceError {
    /// Kind of error that occurred.
    pub kind: BatchAssociateClientDeviceWithCoreDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchAssociateClientDeviceWithCoreDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchAssociateClientDeviceWithCoreDeviceErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchAssociateClientDeviceWithCoreDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchAssociateClientDeviceWithCoreDeviceError {
    fn code(&self) -> Option<&str> {
        BatchAssociateClientDeviceWithCoreDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchAssociateClientDeviceWithCoreDeviceError {
    /// Creates a new `BatchAssociateClientDeviceWithCoreDeviceError`.
    pub fn new(
        kind: BatchAssociateClientDeviceWithCoreDeviceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchAssociateClientDeviceWithCoreDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchAssociateClientDeviceWithCoreDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchAssociateClientDeviceWithCoreDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchAssociateClientDeviceWithCoreDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchAssociateClientDeviceWithCoreDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateClientDeviceWithCoreDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateClientDeviceWithCoreDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateClientDeviceWithCoreDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateClientDeviceWithCoreDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchAssociateClientDeviceWithCoreDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            BatchAssociateClientDeviceWithCoreDeviceErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `BatchDisassociateClientDeviceFromCoreDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDisassociateClientDeviceFromCoreDeviceError {
    /// Kind of error that occurred.
    pub kind: BatchDisassociateClientDeviceFromCoreDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDisassociateClientDeviceFromCoreDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDisassociateClientDeviceFromCoreDeviceErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDisassociateClientDeviceFromCoreDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::InternalServerException(
                _inner,
            ) => _inner.fmt(f),
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for BatchDisassociateClientDeviceFromCoreDeviceError
{
    fn code(&self) -> Option<&str> {
        BatchDisassociateClientDeviceFromCoreDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDisassociateClientDeviceFromCoreDeviceError {
    /// Creates a new `BatchDisassociateClientDeviceFromCoreDeviceError`.
    pub fn new(
        kind: BatchDisassociateClientDeviceFromCoreDeviceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDisassociateClientDeviceFromCoreDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDisassociateClientDeviceFromCoreDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDisassociateClientDeviceFromCoreDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDisassociateClientDeviceFromCoreDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDisassociateClientDeviceFromCoreDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateClientDeviceFromCoreDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchDisassociateClientDeviceFromCoreDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::InternalServerException(
                _inner,
            ) => Some(_inner),
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateClientDeviceFromCoreDeviceErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CancelDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelDeploymentError {
    /// Kind of error that occurred.
    pub kind: CancelDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelDeploymentErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelDeploymentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CancelDeploymentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CancelDeploymentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CancelDeploymentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelDeploymentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CancelDeploymentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelDeploymentError {
    fn code(&self) -> Option<&str> {
        CancelDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelDeploymentError {
    /// Creates a new `CancelDeploymentError`.
    pub fn new(kind: CancelDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelDeploymentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelDeploymentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDeploymentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CancelDeploymentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CancelDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDeploymentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelDeploymentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDeploymentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelDeploymentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CancelDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelDeploymentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CancelDeploymentErrorKind::ConflictException(_inner) => Some(_inner),
            CancelDeploymentErrorKind::InternalServerException(_inner) => Some(_inner),
            CancelDeploymentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelDeploymentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CancelDeploymentErrorKind::ValidationException(_inner) => Some(_inner),
            CancelDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateComponentVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateComponentVersionError {
    /// Kind of error that occurred.
    pub kind: CreateComponentVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateComponentVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateComponentVersionErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is already in progress. This exception occurs when you use a client token for
    /// multiple requests while IoT Greengrass is still processing an earlier request that uses the same client
    /// token.</p>
    RequestAlreadyInProgressException(crate::error::RequestAlreadyInProgressException),
    /// <p>Your request exceeds a service quota. For example, you might have the maximum number of
    /// components that you can create.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateComponentVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateComponentVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateComponentVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateComponentVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateComponentVersionErrorKind::RequestAlreadyInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CreateComponentVersionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateComponentVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateComponentVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateComponentVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateComponentVersionError {
    fn code(&self) -> Option<&str> {
        CreateComponentVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateComponentVersionError {
    /// Creates a new `CreateComponentVersionError`.
    pub fn new(kind: CreateComponentVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateComponentVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateComponentVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateComponentVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateComponentVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateComponentVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentVersionErrorKind::RequestAlreadyInProgressException`.
    pub fn is_request_already_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentVersionErrorKind::RequestAlreadyInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentVersionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentVersionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateComponentVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateComponentVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateComponentVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateComponentVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateComponentVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateComponentVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateComponentVersionErrorKind::RequestAlreadyInProgressException(_inner) => {
                Some(_inner)
            }
            CreateComponentVersionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateComponentVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateComponentVersionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateComponentVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDeploymentError {
    /// Kind of error that occurred.
    pub kind: CreateDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDeploymentErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request is already in progress. This exception occurs when you use a client token for
    /// multiple requests while IoT Greengrass is still processing an earlier request that uses the same client
    /// token.</p>
    RequestAlreadyInProgressException(crate::error::RequestAlreadyInProgressException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDeploymentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::RequestAlreadyInProgressException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDeploymentError {
    fn code(&self) -> Option<&str> {
        CreateDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDeploymentError {
    /// Creates a new `CreateDeploymentError`.
    pub fn new(kind: CreateDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDeploymentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeploymentErrorKind::RequestAlreadyInProgressException`.
    pub fn is_request_already_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::RequestAlreadyInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeploymentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDeploymentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDeploymentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDeploymentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::RequestAlreadyInProgressException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteComponentError {
    /// Kind of error that occurred.
    pub kind: DeleteComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteComponentErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteComponentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteComponentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteComponentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteComponentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteComponentError {
    fn code(&self) -> Option<&str> {
        DeleteComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteComponentError {
    /// Creates a new `DeleteComponentError`.
    pub fn new(kind: DeleteComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteComponentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteComponentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComponentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteComponentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteComponentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteComponentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComponentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteComponentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteComponentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteComponentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteComponentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteComponentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteComponentErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteComponentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteComponentErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCoreDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCoreDeviceError {
    /// Kind of error that occurred.
    pub kind: DeleteCoreDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCoreDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCoreDeviceErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCoreDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCoreDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteCoreDeviceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteCoreDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteCoreDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteCoreDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteCoreDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteCoreDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCoreDeviceError {
    fn code(&self) -> Option<&str> {
        DeleteCoreDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCoreDeviceError {
    /// Creates a new `DeleteCoreDeviceError`.
    pub fn new(kind: DeleteCoreDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCoreDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCoreDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCoreDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCoreDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCoreDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreDeviceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreDeviceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteCoreDeviceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteCoreDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreDeviceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCoreDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCoreDeviceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteCoreDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCoreDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteCoreDeviceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteCoreDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteCoreDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteCoreDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteCoreDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteCoreDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeComponentError {
    /// Kind of error that occurred.
    pub kind: DescribeComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeComponentErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeComponentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeComponentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeComponentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeComponentError {
    fn code(&self) -> Option<&str> {
        DescribeComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeComponentError {
    /// Creates a new `DescribeComponentError`.
    pub fn new(kind: DescribeComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeComponentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeComponentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComponentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComponentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeComponentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeComponentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeComponentErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeComponentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeComponentErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetComponentError {
    /// Kind of error that occurred.
    pub kind: GetComponentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetComponent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetComponentErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetComponentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetComponentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetComponentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetComponentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetComponentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetComponentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetComponentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetComponentError {
    fn code(&self) -> Option<&str> {
        GetComponentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetComponentError {
    /// Creates a new `GetComponentError`.
    pub fn new(kind: GetComponentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetComponentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetComponentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetComponentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetComponentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetComponentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetComponentErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetComponentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComponentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComponentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetComponentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetComponentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetComponentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetComponentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetComponentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetComponentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetComponentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetComponentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetComponentErrorKind::ValidationException(_inner) => Some(_inner),
            GetComponentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetComponentVersionArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetComponentVersionArtifactError {
    /// Kind of error that occurred.
    pub kind: GetComponentVersionArtifactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetComponentVersionArtifact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetComponentVersionArtifactErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetComponentVersionArtifactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetComponentVersionArtifactErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetComponentVersionArtifactErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetComponentVersionArtifactErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetComponentVersionArtifactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetComponentVersionArtifactErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetComponentVersionArtifactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetComponentVersionArtifactError {
    fn code(&self) -> Option<&str> {
        GetComponentVersionArtifactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetComponentVersionArtifactError {
    /// Creates a new `GetComponentVersionArtifactError`.
    pub fn new(kind: GetComponentVersionArtifactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetComponentVersionArtifactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetComponentVersionArtifactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetComponentVersionArtifactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetComponentVersionArtifactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetComponentVersionArtifactErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentVersionArtifactErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComponentVersionArtifactErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentVersionArtifactErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComponentVersionArtifactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentVersionArtifactErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComponentVersionArtifactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentVersionArtifactErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetComponentVersionArtifactErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetComponentVersionArtifactErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetComponentVersionArtifactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetComponentVersionArtifactErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetComponentVersionArtifactErrorKind::InternalServerException(_inner) => Some(_inner),
            GetComponentVersionArtifactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetComponentVersionArtifactErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetComponentVersionArtifactErrorKind::ValidationException(_inner) => Some(_inner),
            GetComponentVersionArtifactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCoreDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCoreDeviceError {
    /// Kind of error that occurred.
    pub kind: GetCoreDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCoreDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCoreDeviceErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCoreDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCoreDeviceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCoreDeviceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetCoreDeviceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCoreDeviceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCoreDeviceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetCoreDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCoreDeviceError {
    fn code(&self) -> Option<&str> {
        GetCoreDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCoreDeviceError {
    /// Creates a new `GetCoreDeviceError`.
    pub fn new(kind: GetCoreDeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCoreDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCoreDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCoreDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCoreDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCoreDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetCoreDeviceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetCoreDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCoreDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCoreDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetCoreDeviceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetCoreDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetCoreDeviceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetCoreDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCoreDeviceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCoreDeviceErrorKind::InternalServerException(_inner) => Some(_inner),
            GetCoreDeviceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCoreDeviceErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCoreDeviceErrorKind::ValidationException(_inner) => Some(_inner),
            GetCoreDeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDeploymentError {
    /// Kind of error that occurred.
    pub kind: GetDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDeploymentErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDeploymentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDeploymentError {
    fn code(&self) -> Option<&str> {
        GetDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDeploymentError {
    /// Creates a new `GetDeploymentError`.
    pub fn new(kind: GetDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDeploymentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetDeploymentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDeploymentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetDeploymentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetDeploymentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDeploymentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDeploymentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDeploymentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDeploymentErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDeploymentErrorKind::ValidationException(_inner) => Some(_inner),
            GetDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListClientDevicesAssociatedWithCoreDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListClientDevicesAssociatedWithCoreDeviceError {
    /// Kind of error that occurred.
    pub kind: ListClientDevicesAssociatedWithCoreDeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListClientDevicesAssociatedWithCoreDevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListClientDevicesAssociatedWithCoreDeviceErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListClientDevicesAssociatedWithCoreDeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListClientDevicesAssociatedWithCoreDeviceError {
    fn code(&self) -> Option<&str> {
        ListClientDevicesAssociatedWithCoreDeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListClientDevicesAssociatedWithCoreDeviceError {
    /// Creates a new `ListClientDevicesAssociatedWithCoreDeviceError`.
    pub fn new(
        kind: ListClientDevicesAssociatedWithCoreDeviceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListClientDevicesAssociatedWithCoreDeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListClientDevicesAssociatedWithCoreDeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListClientDevicesAssociatedWithCoreDeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListClientDevicesAssociatedWithCoreDeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListClientDevicesAssociatedWithCoreDeviceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClientDevicesAssociatedWithCoreDeviceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClientDevicesAssociatedWithCoreDeviceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClientDevicesAssociatedWithCoreDeviceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClientDevicesAssociatedWithCoreDeviceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListClientDevicesAssociatedWithCoreDeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListClientDevicesAssociatedWithCoreDeviceErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListComponents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListComponentsError {
    /// Kind of error that occurred.
    pub kind: ListComponentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListComponents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListComponentsErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListComponentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListComponentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListComponentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListComponentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListComponentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListComponentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListComponentsError {
    fn code(&self) -> Option<&str> {
        ListComponentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListComponentsError {
    /// Creates a new `ListComponentsError`.
    pub fn new(kind: ListComponentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListComponentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListComponentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListComponentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListComponentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListComponentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListComponentsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListComponentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListComponentsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListComponentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListComponentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListComponentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListComponentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListComponentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListComponentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListComponentVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListComponentVersionsError {
    /// Kind of error that occurred.
    pub kind: ListComponentVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListComponentVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListComponentVersionsErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListComponentVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListComponentVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListComponentVersionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListComponentVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListComponentVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListComponentVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListComponentVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListComponentVersionsError {
    fn code(&self) -> Option<&str> {
        ListComponentVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListComponentVersionsError {
    /// Creates a new `ListComponentVersionsError`.
    pub fn new(kind: ListComponentVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListComponentVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListComponentVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListComponentVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListComponentVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListComponentVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListComponentVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListComponentVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListComponentVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListComponentVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListComponentVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListComponentVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListComponentVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListComponentVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListComponentVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCoreDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCoreDevicesError {
    /// Kind of error that occurred.
    pub kind: ListCoreDevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCoreDevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCoreDevicesErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCoreDevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCoreDevicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListCoreDevicesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListCoreDevicesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCoreDevicesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListCoreDevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCoreDevicesError {
    fn code(&self) -> Option<&str> {
        ListCoreDevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCoreDevicesError {
    /// Creates a new `ListCoreDevicesError`.
    pub fn new(kind: ListCoreDevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCoreDevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCoreDevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCoreDevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCoreDevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCoreDevicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreDevicesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoreDevicesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCoreDevicesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCoreDevicesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListCoreDevicesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListCoreDevicesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListCoreDevicesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListCoreDevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCoreDevicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListCoreDevicesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListCoreDevicesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCoreDevicesErrorKind::ValidationException(_inner) => Some(_inner),
            ListCoreDevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDeploymentsError {
    /// Kind of error that occurred.
    pub kind: ListDeploymentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDeploymentsErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDeploymentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDeploymentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDeploymentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDeploymentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDeploymentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDeploymentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDeploymentsError {
    fn code(&self) -> Option<&str> {
        ListDeploymentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDeploymentsError {
    /// Creates a new `ListDeploymentsError`.
    pub fn new(kind: ListDeploymentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDeploymentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDeploymentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDeploymentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDeploymentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDeploymentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeploymentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeploymentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDeploymentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDeploymentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDeploymentsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListDeploymentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDeploymentsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDeploymentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDeploymentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDeploymentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDeploymentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDeploymentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDeploymentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEffectiveDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEffectiveDeploymentsError {
    /// Kind of error that occurred.
    pub kind: ListEffectiveDeploymentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEffectiveDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEffectiveDeploymentsErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEffectiveDeploymentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEffectiveDeploymentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListEffectiveDeploymentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEffectiveDeploymentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEffectiveDeploymentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListEffectiveDeploymentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListEffectiveDeploymentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEffectiveDeploymentsError {
    fn code(&self) -> Option<&str> {
        ListEffectiveDeploymentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEffectiveDeploymentsError {
    /// Creates a new `ListEffectiveDeploymentsError`.
    pub fn new(kind: ListEffectiveDeploymentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEffectiveDeploymentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEffectiveDeploymentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEffectiveDeploymentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEffectiveDeploymentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEffectiveDeploymentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEffectiveDeploymentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEffectiveDeploymentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEffectiveDeploymentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEffectiveDeploymentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEffectiveDeploymentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEffectiveDeploymentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEffectiveDeploymentsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEffectiveDeploymentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEffectiveDeploymentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListEffectiveDeploymentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEffectiveDeploymentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListEffectiveDeploymentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEffectiveDeploymentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEffectiveDeploymentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListEffectiveDeploymentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListEffectiveDeploymentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstalledComponents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstalledComponentsError {
    /// Kind of error that occurred.
    pub kind: ListInstalledComponentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstalledComponents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstalledComponentsErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstalledComponentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstalledComponentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListInstalledComponentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListInstalledComponentsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListInstalledComponentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListInstalledComponentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListInstalledComponentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstalledComponentsError {
    fn code(&self) -> Option<&str> {
        ListInstalledComponentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstalledComponentsError {
    /// Creates a new `ListInstalledComponentsError`.
    pub fn new(kind: ListInstalledComponentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstalledComponentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstalledComponentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstalledComponentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstalledComponentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstalledComponentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstalledComponentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstalledComponentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstalledComponentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstalledComponentsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstalledComponentsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstalledComponentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstalledComponentsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstalledComponentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstalledComponentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListInstalledComponentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstalledComponentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListInstalledComponentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListInstalledComponentsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListInstalledComponentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListInstalledComponentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListInstalledComponentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResolveComponentCandidates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResolveComponentCandidatesError {
    /// Kind of error that occurred.
    pub kind: ResolveComponentCandidatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResolveComponentCandidates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResolveComponentCandidatesErrorKind {
    /// <p>You don't have permission to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your request has conflicting operations. This can occur if you're trying to perform more
    /// than one operation on the same resource at the same time.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
    /// amount of times that you can retrieve device or deployment status per second.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResolveComponentCandidatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResolveComponentCandidatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ResolveComponentCandidatesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ResolveComponentCandidatesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ResolveComponentCandidatesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ResolveComponentCandidatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ResolveComponentCandidatesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ResolveComponentCandidatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResolveComponentCandidatesError {
    fn code(&self) -> Option<&str> {
        ResolveComponentCandidatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResolveComponentCandidatesError {
    /// Creates a new `ResolveComponentCandidatesError`.
    pub fn new(kind: ResolveComponentCandidatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResolveComponentCandidatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResolveComponentCandidatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResolveComponentCandidatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResolveComponentCandidatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResolveComponentCandidatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResolveComponentCandidatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ResolveComponentCandidatesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResolveComponentCandidatesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ResolveComponentCandidatesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResolveComponentCandidatesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ResolveComponentCandidatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResolveComponentCandidatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResolveComponentCandidatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResolveComponentCandidatesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ResolveComponentCandidatesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResolveComponentCandidatesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ResolveComponentCandidatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResolveComponentCandidatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ResolveComponentCandidatesErrorKind::ConflictException(_inner) => Some(_inner),
            ResolveComponentCandidatesErrorKind::InternalServerException(_inner) => Some(_inner),
            ResolveComponentCandidatesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ResolveComponentCandidatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ResolveComponentCandidatesErrorKind::ValidationException(_inner) => Some(_inner),
            ResolveComponentCandidatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>IoT Greengrass can't process your request right now. Try again later.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource can't be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request isn't valid. This can occur if your request contains malformed JSON or
    /// unsupported characters.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request isn't valid. This can occur if your request contains malformed JSON or
/// unsupported characters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the validation exception.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>The list of fields that failed to validate.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>The reason for the validation exception.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>The list of fields that failed to validate.</p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the validation exception.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the validation exception.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>The list of fields that failed to validate.</p>
        pub fn fields(mut self, input: impl Into<crate::model::ValidationExceptionField>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p>The list of fields that failed to validate.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The requested resource can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that isn't found.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource that isn't found.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>The ID of the resource that isn't found.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource that isn't found.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that isn't found.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that isn't found.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource that isn't found.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource that isn't found.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>IoT Greengrass can't process your request right now. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The amount of time to wait before you retry the request.</p>
    pub retry_after_seconds: i32,
}
impl InternalServerException {
    /// <p>The amount of time to wait before you retry the request.</p>
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The amount of time to wait before you retry the request.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The amount of time to wait before you retry the request.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Your request exceeded a request rate quota. For example, you might have exceeded the
/// amount of times that you can retrieve device or deployment status per second.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The amount of time to wait before you retry the request.</p>
    pub retry_after_seconds: i32,
}
impl ThrottlingException {
    /// <p>The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The amount of time to wait before you retry the request.</p>
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The amount of time to wait before you retry the request.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The amount of time to wait before you retry the request.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                quota_code: self.quota_code,
                service_code: self.service_code,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Your request has conflicting operations. This can occur if you're trying to perform more
/// than one operation on the same resource at the same time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that conflicts with the request.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource that conflicts with the request.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>The ID of the resource that conflicts with the request.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource that conflicts with the request.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that conflicts with the request.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that conflicts with the request.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource that conflicts with the request.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource that conflicts with the request.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You don't have permission to perform the action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request is already in progress. This exception occurs when you use a client token for
/// multiple requests while IoT Greengrass is still processing an earlier request that uses the same client
/// token.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestAlreadyInProgressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestAlreadyInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestAlreadyInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestAlreadyInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestAlreadyInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestAlreadyInProgressException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestAlreadyInProgressException {}
/// See [`RequestAlreadyInProgressException`](crate::error::RequestAlreadyInProgressException)
pub mod request_already_in_progress_exception {
    /// A builder for [`RequestAlreadyInProgressException`](crate::error::RequestAlreadyInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestAlreadyInProgressException`](crate::error::RequestAlreadyInProgressException)
        pub fn build(self) -> crate::error::RequestAlreadyInProgressException {
            crate::error::RequestAlreadyInProgressException {
                message: self.message,
            }
        }
    }
}
impl RequestAlreadyInProgressException {
    /// Creates a new builder-style object to manufacture [`RequestAlreadyInProgressException`](crate::error::RequestAlreadyInProgressException)
    pub fn builder() -> crate::error::request_already_in_progress_exception::Builder {
        crate::error::request_already_in_progress_exception::Builder::default()
    }
}

/// <p>Your request exceeds a service quota. For example, you might have the maximum number of
/// components that you can create.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that exceeds the service quota.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource that exceeds the service quota.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
    pub service_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// <p>The ID of the resource that exceeds the service quota.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource that exceeds the service quota.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that exceeds the service quota.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that exceeds the service quota.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource that exceeds the service quota.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource that exceeds the service quota.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The code for the quota in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The code for the service in <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a>.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                quota_code: self.quota_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
