// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains information about a validation exception field.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the exception field.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The message of the exception field.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the exception field.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the exception field.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The message of the exception field.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message of the exception field.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_PARSE",
            "FIELD_VALIDATION_FAILED",
            "OTHER",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a component version that is compatible to run on a Greengrass core
/// device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolvedComponentVersion {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The version of the component.</p>
    pub component_version: std::option::Option<std::string::String>,
    /// <p>The recipe of the component version.</p>
    pub recipe: std::option::Option<aws_smithy_types::Blob>,
}
impl std::fmt::Debug for ResolvedComponentVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolvedComponentVersion");
        formatter.field("arn", &self.arn);
        formatter.field("component_name", &self.component_name);
        formatter.field("component_version", &self.component_version);
        formatter.field("recipe", &self.recipe);
        formatter.finish()
    }
}
/// See [`ResolvedComponentVersion`](crate::model::ResolvedComponentVersion)
pub mod resolved_component_version {
    /// A builder for [`ResolvedComponentVersion`](crate::model::ResolvedComponentVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) component_version: std::option::Option<std::string::String>,
        pub(crate) recipe: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The version of the component.</p>
        pub fn component_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        pub fn set_component_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_version = input;
            self
        }
        /// <p>The recipe of the component version.</p>
        pub fn recipe(mut self, input: aws_smithy_types::Blob) -> Self {
            self.recipe = Some(input);
            self
        }
        /// <p>The recipe of the component version.</p>
        pub fn set_recipe(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.recipe = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolvedComponentVersion`](crate::model::ResolvedComponentVersion)
        pub fn build(self) -> crate::model::ResolvedComponentVersion {
            crate::model::ResolvedComponentVersion {
                arn: self.arn,
                component_name: self.component_name,
                component_version: self.component_version,
                recipe: self.recipe,
            }
        }
    }
}
impl ResolvedComponentVersion {
    /// Creates a new builder-style object to manufacture [`ResolvedComponentVersion`](crate::model::ResolvedComponentVersion)
    pub fn builder() -> crate::model::resolved_component_version::Builder {
        crate::model::resolved_component_version::Builder::default()
    }
}

/// <p>Contains information about a component that is a candidate to deploy to a Greengrass core
/// device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentCandidate {
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The version of the component.</p>
    pub component_version: std::option::Option<std::string::String>,
    /// <p>The version requirements for the component's dependencies. Greengrass core devices get the
    /// version requirements from component recipes.</p>
    /// <p>IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning</a>.</p>
    pub version_requirements:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ComponentCandidate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentCandidate");
        formatter.field("component_name", &self.component_name);
        formatter.field("component_version", &self.component_version);
        formatter.field("version_requirements", &self.version_requirements);
        formatter.finish()
    }
}
/// See [`ComponentCandidate`](crate::model::ComponentCandidate)
pub mod component_candidate {
    /// A builder for [`ComponentCandidate`](crate::model::ComponentCandidate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) component_version: std::option::Option<std::string::String>,
        pub(crate) version_requirements: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The version of the component.</p>
        pub fn component_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        pub fn set_component_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_version = input;
            self
        }
        /// Adds a key-value pair to `version_requirements`.
        ///
        /// To override the contents of this collection use [`set_version_requirements`](Self::set_version_requirements).
        ///
        /// <p>The version requirements for the component's dependencies. Greengrass core devices get the
        /// version requirements from component recipes.</p>
        /// <p>IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning</a>.</p>
        pub fn version_requirements(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.version_requirements.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.version_requirements = Some(hash_map);
            self
        }
        /// <p>The version requirements for the component's dependencies. Greengrass core devices get the
        /// version requirements from component recipes.</p>
        /// <p>IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning</a>.</p>
        pub fn set_version_requirements(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.version_requirements = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentCandidate`](crate::model::ComponentCandidate)
        pub fn build(self) -> crate::model::ComponentCandidate {
            crate::model::ComponentCandidate {
                component_name: self.component_name,
                component_version: self.component_version,
                version_requirements: self.version_requirements,
            }
        }
    }
}
impl ComponentCandidate {
    /// Creates a new builder-style object to manufacture [`ComponentCandidate`](crate::model::ComponentCandidate)
    pub fn builder() -> crate::model::component_candidate::Builder {
        crate::model::component_candidate::Builder::default()
    }
}

/// <p>Contains information about a platform that a component supports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentPlatform {
    /// <p>The friendly name of the platform. This name helps you identify the platform.</p>
    /// <p>If you omit this parameter, IoT Greengrass creates a friendly name from the <code>os</code> and
    /// <code>architecture</code> of the platform.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A dictionary of attributes for the platform. The IoT Greengrass Core software defines the
    /// <code>os</code> and <code>platform</code> by default. You can specify additional platform
    /// attributes for a core device when you deploy the Greengrass nucleus component. For more information,
    /// see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
    /// component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ComponentPlatform {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentPlatform");
        formatter.field("name", &self.name);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`ComponentPlatform`](crate::model::ComponentPlatform)
pub mod component_platform {
    /// A builder for [`ComponentPlatform`](crate::model::ComponentPlatform)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The friendly name of the platform. This name helps you identify the platform.</p>
        /// <p>If you omit this parameter, IoT Greengrass creates a friendly name from the <code>os</code> and
        /// <code>architecture</code> of the platform.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the platform. This name helps you identify the platform.</p>
        /// <p>If you omit this parameter, IoT Greengrass creates a friendly name from the <code>os</code> and
        /// <code>architecture</code> of the platform.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A dictionary of attributes for the platform. The IoT Greengrass Core software defines the
        /// <code>os</code> and <code>platform</code> by default. You can specify additional platform
        /// attributes for a core device when you deploy the Greengrass nucleus component. For more information,
        /// see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
        /// component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A dictionary of attributes for the platform. The IoT Greengrass Core software defines the
        /// <code>os</code> and <code>platform</code> by default. You can specify additional platform
        /// attributes for a core device when you deploy the Greengrass nucleus component. For more information,
        /// see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/greengrass-nucleus-component.html">Greengrass nucleus
        /// component</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentPlatform`](crate::model::ComponentPlatform)
        pub fn build(self) -> crate::model::ComponentPlatform {
            crate::model::ComponentPlatform {
                name: self.name,
                attributes: self.attributes,
            }
        }
    }
}
impl ComponentPlatform {
    /// Creates a new builder-style object to manufacture [`ComponentPlatform`](crate::model::ComponentPlatform)
    pub fn builder() -> crate::model::component_platform::Builder {
        crate::model::component_platform::Builder::default()
    }
}

/// <p>Contains information about a component on a Greengrass core device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstalledComponent {
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The version of the component.</p>
    pub component_version: std::option::Option<std::string::String>,
    /// <p>The lifecycle state of the component.</p>
    pub lifecycle_state: std::option::Option<crate::model::InstalledComponentLifecycleState>,
    /// <p>The details about the lifecycle state of the component.</p>
    pub lifecycle_state_details: std::option::Option<std::string::String>,
    /// <p>Whether or not the component is a root component.</p>
    pub is_root: bool,
}
impl std::fmt::Debug for InstalledComponent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstalledComponent");
        formatter.field("component_name", &self.component_name);
        formatter.field("component_version", &self.component_version);
        formatter.field("lifecycle_state", &self.lifecycle_state);
        formatter.field("lifecycle_state_details", &self.lifecycle_state_details);
        formatter.field("is_root", &self.is_root);
        formatter.finish()
    }
}
/// See [`InstalledComponent`](crate::model::InstalledComponent)
pub mod installed_component {
    /// A builder for [`InstalledComponent`](crate::model::InstalledComponent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) component_version: std::option::Option<std::string::String>,
        pub(crate) lifecycle_state:
            std::option::Option<crate::model::InstalledComponentLifecycleState>,
        pub(crate) lifecycle_state_details: std::option::Option<std::string::String>,
        pub(crate) is_root: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The version of the component.</p>
        pub fn component_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        pub fn set_component_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_version = input;
            self
        }
        /// <p>The lifecycle state of the component.</p>
        pub fn lifecycle_state(
            mut self,
            input: crate::model::InstalledComponentLifecycleState,
        ) -> Self {
            self.lifecycle_state = Some(input);
            self
        }
        /// <p>The lifecycle state of the component.</p>
        pub fn set_lifecycle_state(
            mut self,
            input: std::option::Option<crate::model::InstalledComponentLifecycleState>,
        ) -> Self {
            self.lifecycle_state = input;
            self
        }
        /// <p>The details about the lifecycle state of the component.</p>
        pub fn lifecycle_state_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_state_details = Some(input.into());
            self
        }
        /// <p>The details about the lifecycle state of the component.</p>
        pub fn set_lifecycle_state_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_state_details = input;
            self
        }
        /// <p>Whether or not the component is a root component.</p>
        pub fn is_root(mut self, input: bool) -> Self {
            self.is_root = Some(input);
            self
        }
        /// <p>Whether or not the component is a root component.</p>
        pub fn set_is_root(mut self, input: std::option::Option<bool>) -> Self {
            self.is_root = input;
            self
        }
        /// Consumes the builder and constructs a [`InstalledComponent`](crate::model::InstalledComponent)
        pub fn build(self) -> crate::model::InstalledComponent {
            crate::model::InstalledComponent {
                component_name: self.component_name,
                component_version: self.component_version,
                lifecycle_state: self.lifecycle_state,
                lifecycle_state_details: self.lifecycle_state_details,
                is_root: self.is_root.unwrap_or_default(),
            }
        }
    }
}
impl InstalledComponent {
    /// Creates a new builder-style object to manufacture [`InstalledComponent`](crate::model::InstalledComponent)
    pub fn builder() -> crate::model::installed_component::Builder {
        crate::model::installed_component::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstalledComponentLifecycleState {
    #[allow(missing_docs)] // documentation missing in model
    Broken,
    #[allow(missing_docs)] // documentation missing in model
    Errored,
    #[allow(missing_docs)] // documentation missing in model
    Finished,
    #[allow(missing_docs)] // documentation missing in model
    Installed,
    #[allow(missing_docs)] // documentation missing in model
    New,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstalledComponentLifecycleState {
    fn from(s: &str) -> Self {
        match s {
            "BROKEN" => InstalledComponentLifecycleState::Broken,
            "ERRORED" => InstalledComponentLifecycleState::Errored,
            "FINISHED" => InstalledComponentLifecycleState::Finished,
            "INSTALLED" => InstalledComponentLifecycleState::Installed,
            "NEW" => InstalledComponentLifecycleState::New,
            "RUNNING" => InstalledComponentLifecycleState::Running,
            "STARTING" => InstalledComponentLifecycleState::Starting,
            "STOPPING" => InstalledComponentLifecycleState::Stopping,
            other => InstalledComponentLifecycleState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstalledComponentLifecycleState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstalledComponentLifecycleState::from(s))
    }
}
impl InstalledComponentLifecycleState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstalledComponentLifecycleState::Broken => "BROKEN",
            InstalledComponentLifecycleState::Errored => "ERRORED",
            InstalledComponentLifecycleState::Finished => "FINISHED",
            InstalledComponentLifecycleState::Installed => "INSTALLED",
            InstalledComponentLifecycleState::New => "NEW",
            InstalledComponentLifecycleState::Running => "RUNNING",
            InstalledComponentLifecycleState::Starting => "STARTING",
            InstalledComponentLifecycleState::Stopping => "STOPPING",
            InstalledComponentLifecycleState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BROKEN",
            "ERRORED",
            "FINISHED",
            "INSTALLED",
            "NEW",
            "RUNNING",
            "STARTING",
            "STOPPING",
        ]
    }
}
impl AsRef<str> for InstalledComponentLifecycleState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a deployment job that IoT Greengrass sends to a Greengrass core device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EffectiveDeployment {
    /// <p>The ID of the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The name of the deployment.</p>
    pub deployment_name: std::option::Option<std::string::String>,
    /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
    pub iot_job_id: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
    pub iot_job_arn: std::option::Option<std::string::String>,
    /// <p>The description of the deployment job.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The status of the deployment job on the Greengrass core device.</p>
    pub core_device_execution_status:
        std::option::Option<crate::model::EffectiveDeploymentExecutionStatus>,
    /// <p>The reason code for the update, if the job was updated.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time at which the deployment job was last modified, expressed in ISO 8601
    /// format.</p>
    pub modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for EffectiveDeployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EffectiveDeployment");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_name", &self.deployment_name);
        formatter.field("iot_job_id", &self.iot_job_id);
        formatter.field("iot_job_arn", &self.iot_job_arn);
        formatter.field("description", &self.description);
        formatter.field("target_arn", &self.target_arn);
        formatter.field(
            "core_device_execution_status",
            &self.core_device_execution_status,
        );
        formatter.field("reason", &self.reason);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("modified_timestamp", &self.modified_timestamp);
        formatter.finish()
    }
}
/// See [`EffectiveDeployment`](crate::model::EffectiveDeployment)
pub mod effective_deployment {
    /// A builder for [`EffectiveDeployment`](crate::model::EffectiveDeployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_name: std::option::Option<std::string::String>,
        pub(crate) iot_job_id: std::option::Option<std::string::String>,
        pub(crate) iot_job_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) core_device_execution_status:
            std::option::Option<crate::model::EffectiveDeploymentExecutionStatus>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ID of the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The name of the deployment.</p>
        pub fn deployment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_name = Some(input.into());
            self
        }
        /// <p>The name of the deployment.</p>
        pub fn set_deployment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_name = input;
            self
        }
        /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
        pub fn iot_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.iot_job_id = Some(input.into());
            self
        }
        /// <p>The ID of the IoT job that applies the deployment to target devices.</p>
        pub fn set_iot_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iot_job_id = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
        pub fn iot_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iot_job_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IoT job that applies the deployment to target devices.</p>
        pub fn set_iot_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iot_job_arn = input;
            self
        }
        /// <p>The description of the deployment job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the deployment job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The status of the deployment job on the Greengrass core device.</p>
        pub fn core_device_execution_status(
            mut self,
            input: crate::model::EffectiveDeploymentExecutionStatus,
        ) -> Self {
            self.core_device_execution_status = Some(input);
            self
        }
        /// <p>The status of the deployment job on the Greengrass core device.</p>
        pub fn set_core_device_execution_status(
            mut self,
            input: std::option::Option<crate::model::EffectiveDeploymentExecutionStatus>,
        ) -> Self {
            self.core_device_execution_status = input;
            self
        }
        /// <p>The reason code for the update, if the job was updated.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason code for the update, if the job was updated.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The time at which the deployment job was last modified, expressed in ISO 8601
        /// format.</p>
        pub fn modified_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.modified_timestamp = Some(input);
            self
        }
        /// <p>The time at which the deployment job was last modified, expressed in ISO 8601
        /// format.</p>
        pub fn set_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.modified_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`EffectiveDeployment`](crate::model::EffectiveDeployment)
        pub fn build(self) -> crate::model::EffectiveDeployment {
            crate::model::EffectiveDeployment {
                deployment_id: self.deployment_id,
                deployment_name: self.deployment_name,
                iot_job_id: self.iot_job_id,
                iot_job_arn: self.iot_job_arn,
                description: self.description,
                target_arn: self.target_arn,
                core_device_execution_status: self.core_device_execution_status,
                reason: self.reason,
                creation_timestamp: self.creation_timestamp,
                modified_timestamp: self.modified_timestamp,
            }
        }
    }
}
impl EffectiveDeployment {
    /// Creates a new builder-style object to manufacture [`EffectiveDeployment`](crate::model::EffectiveDeployment)
    pub fn builder() -> crate::model::effective_deployment::Builder {
        crate::model::effective_deployment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EffectiveDeploymentExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EffectiveDeploymentExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => EffectiveDeploymentExecutionStatus::Canceled,
            "COMPLETED" => EffectiveDeploymentExecutionStatus::Completed,
            "FAILED" => EffectiveDeploymentExecutionStatus::Failed,
            "IN_PROGRESS" => EffectiveDeploymentExecutionStatus::InProgress,
            "QUEUED" => EffectiveDeploymentExecutionStatus::Queued,
            "REJECTED" => EffectiveDeploymentExecutionStatus::Rejected,
            "TIMED_OUT" => EffectiveDeploymentExecutionStatus::TimedOut,
            other => EffectiveDeploymentExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EffectiveDeploymentExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EffectiveDeploymentExecutionStatus::from(s))
    }
}
impl EffectiveDeploymentExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EffectiveDeploymentExecutionStatus::Canceled => "CANCELED",
            EffectiveDeploymentExecutionStatus::Completed => "COMPLETED",
            EffectiveDeploymentExecutionStatus::Failed => "FAILED",
            EffectiveDeploymentExecutionStatus::InProgress => "IN_PROGRESS",
            EffectiveDeploymentExecutionStatus::Queued => "QUEUED",
            EffectiveDeploymentExecutionStatus::Rejected => "REJECTED",
            EffectiveDeploymentExecutionStatus::TimedOut => "TIMED_OUT",
            EffectiveDeploymentExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELED",
            "COMPLETED",
            "FAILED",
            "IN_PROGRESS",
            "QUEUED",
            "REJECTED",
            "TIMED_OUT",
        ]
    }
}
impl AsRef<str> for EffectiveDeploymentExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Deployment {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The revision number of the deployment.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The ID of the deployment.</p>
    pub deployment_id: std::option::Option<std::string::String>,
    /// <p>The name of the deployment.</p>
    pub deployment_name: std::option::Option<std::string::String>,
    /// <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the deployment.</p>
    pub deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>Whether or not the deployment is the latest revision for its target.</p>
    pub is_latest_for_target: bool,
}
impl std::fmt::Debug for Deployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Deployment");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_name", &self.deployment_name);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("is_latest_for_target", &self.is_latest_for_target);
        formatter.finish()
    }
}
/// See [`Deployment`](crate::model::Deployment)
pub mod deployment {
    /// A builder for [`Deployment`](crate::model::Deployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_name: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) is_latest_for_target: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the target IoT thing or thing group.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The revision number of the deployment.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision number of the deployment.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// <p>The name of the deployment.</p>
        pub fn deployment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_name = Some(input.into());
            self
        }
        /// <p>The name of the deployment.</p>
        pub fn set_deployment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_name = input;
            self
        }
        /// <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The time at which the deployment was created, expressed in ISO 8601 format.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The status of the deployment.</p>
        pub fn deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.deployment_status = Some(input);
            self
        }
        /// <p>The status of the deployment.</p>
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// <p>Whether or not the deployment is the latest revision for its target.</p>
        pub fn is_latest_for_target(mut self, input: bool) -> Self {
            self.is_latest_for_target = Some(input);
            self
        }
        /// <p>Whether or not the deployment is the latest revision for its target.</p>
        pub fn set_is_latest_for_target(mut self, input: std::option::Option<bool>) -> Self {
            self.is_latest_for_target = input;
            self
        }
        /// Consumes the builder and constructs a [`Deployment`](crate::model::Deployment)
        pub fn build(self) -> crate::model::Deployment {
            crate::model::Deployment {
                target_arn: self.target_arn,
                revision_id: self.revision_id,
                deployment_id: self.deployment_id,
                deployment_name: self.deployment_name,
                creation_timestamp: self.creation_timestamp,
                deployment_status: self.deployment_status,
                is_latest_for_target: self.is_latest_for_target.unwrap_or_default(),
            }
        }
    }
}
impl Deployment {
    /// Creates a new builder-style object to manufacture [`Deployment`](crate::model::Deployment)
    pub fn builder() -> crate::model::deployment::Builder {
        crate::model::deployment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DeploymentStatus::Active,
            "CANCELED" => DeploymentStatus::Canceled,
            "COMPLETED" => DeploymentStatus::Completed,
            "FAILED" => DeploymentStatus::Failed,
            "INACTIVE" => DeploymentStatus::Inactive,
            other => DeploymentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentStatus::from(s))
    }
}
impl DeploymentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentStatus::Active => "ACTIVE",
            DeploymentStatus::Canceled => "CANCELED",
            DeploymentStatus::Completed => "COMPLETED",
            DeploymentStatus::Failed => "FAILED",
            DeploymentStatus::Inactive => "INACTIVE",
            DeploymentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CANCELED", "COMPLETED", "FAILED", "INACTIVE"]
    }
}
impl AsRef<str> for DeploymentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentHistoryFilter {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    LatestOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentHistoryFilter {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => DeploymentHistoryFilter::All,
            "LATEST_ONLY" => DeploymentHistoryFilter::LatestOnly,
            other => DeploymentHistoryFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentHistoryFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentHistoryFilter::from(s))
    }
}
impl DeploymentHistoryFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentHistoryFilter::All => "ALL",
            DeploymentHistoryFilter::LatestOnly => "LATEST_ONLY",
            DeploymentHistoryFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "LATEST_ONLY"]
    }
}
impl AsRef<str> for DeploymentHistoryFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a Greengrass core device, which is an IoT thing that runs the IoT Greengrass
/// Core software.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreDevice {
    /// <p>The name of the core device. This is also the name of the IoT thing.</p>
    pub core_device_thing_name: std::option::Option<std::string::String>,
    /// <p>The status of the core device. Core devices can have the following statuses:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
    /// on the core device.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::CoreDeviceStatus>,
    /// <p>The time at which the core device's status last updated, expressed in ISO 8601
    /// format.</p>
    pub last_status_update_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for CoreDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreDevice");
        formatter.field("core_device_thing_name", &self.core_device_thing_name);
        formatter.field("status", &self.status);
        formatter.field(
            "last_status_update_timestamp",
            &self.last_status_update_timestamp,
        );
        formatter.finish()
    }
}
/// See [`CoreDevice`](crate::model::CoreDevice)
pub mod core_device {
    /// A builder for [`CoreDevice`](crate::model::CoreDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_device_thing_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CoreDeviceStatus>,
        pub(crate) last_status_update_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn core_device_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_device_thing_name = Some(input.into());
            self
        }
        /// <p>The name of the core device. This is also the name of the IoT thing.</p>
        pub fn set_core_device_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_device_thing_name = input;
            self
        }
        /// <p>The status of the core device. Core devices can have the following statuses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
        /// on the core device.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::CoreDeviceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the core device. Core devices can have the following statuses:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HEALTHY</code> – The IoT Greengrass Core software and all components run on the core device without issue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNHEALTHY</code> – The IoT Greengrass Core software or a component is in a failed state
        /// on the core device.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CoreDeviceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time at which the core device's status last updated, expressed in ISO 8601
        /// format.</p>
        pub fn last_status_update_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_status_update_timestamp = Some(input);
            self
        }
        /// <p>The time at which the core device's status last updated, expressed in ISO 8601
        /// format.</p>
        pub fn set_last_status_update_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_status_update_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreDevice`](crate::model::CoreDevice)
        pub fn build(self) -> crate::model::CoreDevice {
            crate::model::CoreDevice {
                core_device_thing_name: self.core_device_thing_name,
                status: self.status,
                last_status_update_timestamp: self.last_status_update_timestamp,
            }
        }
    }
}
impl CoreDevice {
    /// Creates a new builder-style object to manufacture [`CoreDevice`](crate::model::CoreDevice)
    pub fn builder() -> crate::model::core_device::Builder {
        crate::model::core_device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CoreDeviceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CoreDeviceStatus {
    fn from(s: &str) -> Self {
        match s {
            "HEALTHY" => CoreDeviceStatus::Healthy,
            "UNHEALTHY" => CoreDeviceStatus::Unhealthy,
            other => CoreDeviceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CoreDeviceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CoreDeviceStatus::from(s))
    }
}
impl CoreDeviceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CoreDeviceStatus::Healthy => "HEALTHY",
            CoreDeviceStatus::Unhealthy => "UNHEALTHY",
            CoreDeviceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEALTHY", "UNHEALTHY"]
    }
}
impl AsRef<str> for CoreDeviceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a component version in a list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentVersionListItem {
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The version of the component.</p>
    pub component_version: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ComponentVersionListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentVersionListItem");
        formatter.field("component_name", &self.component_name);
        formatter.field("component_version", &self.component_version);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ComponentVersionListItem`](crate::model::ComponentVersionListItem)
pub mod component_version_list_item {
    /// A builder for [`ComponentVersionListItem`](crate::model::ComponentVersionListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) component_version: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The version of the component.</p>
        pub fn component_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        pub fn set_component_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_version = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentVersionListItem`](crate::model::ComponentVersionListItem)
        pub fn build(self) -> crate::model::ComponentVersionListItem {
            crate::model::ComponentVersionListItem {
                component_name: self.component_name,
                component_version: self.component_version,
                arn: self.arn,
            }
        }
    }
}
impl ComponentVersionListItem {
    /// Creates a new builder-style object to manufacture [`ComponentVersionListItem`](crate::model::ComponentVersionListItem)
    pub fn builder() -> crate::model::component_version_list_item::Builder {
        crate::model::component_version_list_item::Builder::default()
    }
}

/// <p>Contains information about a component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Component {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The latest version of the component and its details.</p>
    pub latest_version: std::option::Option<crate::model::ComponentLatestVersion>,
}
impl std::fmt::Debug for Component {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Component");
        formatter.field("arn", &self.arn);
        formatter.field("component_name", &self.component_name);
        formatter.field("latest_version", &self.latest_version);
        formatter.finish()
    }
}
/// See [`Component`](crate::model::Component)
pub mod component {
    /// A builder for [`Component`](crate::model::Component)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) latest_version: std::option::Option<crate::model::ComponentLatestVersion>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The latest version of the component and its details.</p>
        pub fn latest_version(mut self, input: crate::model::ComponentLatestVersion) -> Self {
            self.latest_version = Some(input);
            self
        }
        /// <p>The latest version of the component and its details.</p>
        pub fn set_latest_version(
            mut self,
            input: std::option::Option<crate::model::ComponentLatestVersion>,
        ) -> Self {
            self.latest_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Component`](crate::model::Component)
        pub fn build(self) -> crate::model::Component {
            crate::model::Component {
                arn: self.arn,
                component_name: self.component_name,
                latest_version: self.latest_version,
            }
        }
    }
}
impl Component {
    /// Creates a new builder-style object to manufacture [`Component`](crate::model::Component)
    pub fn builder() -> crate::model::component::Builder {
        crate::model::component::Builder::default()
    }
}

/// <p>Contains information about the latest version of a component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentLatestVersion {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the component.</p>
    pub component_version: std::option::Option<std::string::String>,
    /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description of the component version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The publisher of the component version.</p>
    pub publisher: std::option::Option<std::string::String>,
    /// <p>The platforms that the component version supports.</p>
    pub platforms: std::option::Option<std::vec::Vec<crate::model::ComponentPlatform>>,
}
impl std::fmt::Debug for ComponentLatestVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentLatestVersion");
        formatter.field("arn", &self.arn);
        formatter.field("component_version", &self.component_version);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("description", &self.description);
        formatter.field("publisher", &self.publisher);
        formatter.field("platforms", &self.platforms);
        formatter.finish()
    }
}
/// See [`ComponentLatestVersion`](crate::model::ComponentLatestVersion)
pub mod component_latest_version {
    /// A builder for [`ComponentLatestVersion`](crate::model::ComponentLatestVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) component_version: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) publisher: std::option::Option<std::string::String>,
        pub(crate) platforms: std::option::Option<std::vec::Vec<crate::model::ComponentPlatform>>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the component.</p>
        pub fn component_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        pub fn set_component_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_version = input;
            self
        }
        /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The time at which the component was created, expressed in ISO 8601 format.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The description of the component version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The publisher of the component version.</p>
        pub fn publisher(mut self, input: impl Into<std::string::String>) -> Self {
            self.publisher = Some(input.into());
            self
        }
        /// <p>The publisher of the component version.</p>
        pub fn set_publisher(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.publisher = input;
            self
        }
        /// Appends an item to `platforms`.
        ///
        /// To override the contents of this collection use [`set_platforms`](Self::set_platforms).
        ///
        /// <p>The platforms that the component version supports.</p>
        pub fn platforms(mut self, input: impl Into<crate::model::ComponentPlatform>) -> Self {
            let mut v = self.platforms.unwrap_or_default();
            v.push(input.into());
            self.platforms = Some(v);
            self
        }
        /// <p>The platforms that the component version supports.</p>
        pub fn set_platforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentPlatform>>,
        ) -> Self {
            self.platforms = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentLatestVersion`](crate::model::ComponentLatestVersion)
        pub fn build(self) -> crate::model::ComponentLatestVersion {
            crate::model::ComponentLatestVersion {
                arn: self.arn,
                component_version: self.component_version,
                creation_timestamp: self.creation_timestamp,
                description: self.description,
                publisher: self.publisher,
                platforms: self.platforms,
            }
        }
    }
}
impl ComponentLatestVersion {
    /// Creates a new builder-style object to manufacture [`ComponentLatestVersion`](crate::model::ComponentLatestVersion)
    pub fn builder() -> crate::model::component_latest_version::Builder {
        crate::model::component_latest_version::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComponentVisibilityScope {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComponentVisibilityScope {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE" => ComponentVisibilityScope::Private,
            "PUBLIC" => ComponentVisibilityScope::Public,
            other => ComponentVisibilityScope::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComponentVisibilityScope {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComponentVisibilityScope::from(s))
    }
}
impl ComponentVisibilityScope {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComponentVisibilityScope::Private => "PRIVATE",
            ComponentVisibilityScope::Public => "PUBLIC",
            ComponentVisibilityScope::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE", "PUBLIC"]
    }
}
impl AsRef<str> for ComponentVisibilityScope {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a client device that is associated to a core device for cloud
/// discovery.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociatedClientDevice {
    /// <p>The name of the IoT thing that represents the associated client device.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The time that the client device was associated, expressed in ISO 8601 format.</p>
    pub association_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for AssociatedClientDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociatedClientDevice");
        formatter.field("thing_name", &self.thing_name);
        formatter.field("association_timestamp", &self.association_timestamp);
        formatter.finish()
    }
}
/// See [`AssociatedClientDevice`](crate::model::AssociatedClientDevice)
pub mod associated_client_device {
    /// A builder for [`AssociatedClientDevice`](crate::model::AssociatedClientDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) association_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the IoT thing that represents the associated client device.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT thing that represents the associated client device.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The time that the client device was associated, expressed in ISO 8601 format.</p>
        pub fn association_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.association_timestamp = Some(input);
            self
        }
        /// <p>The time that the client device was associated, expressed in ISO 8601 format.</p>
        pub fn set_association_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.association_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociatedClientDevice`](crate::model::AssociatedClientDevice)
        pub fn build(self) -> crate::model::AssociatedClientDevice {
            crate::model::AssociatedClientDevice {
                thing_name: self.thing_name,
                association_timestamp: self.association_timestamp,
            }
        }
    }
}
impl AssociatedClientDevice {
    /// Creates a new builder-style object to manufacture [`AssociatedClientDevice`](crate::model::AssociatedClientDevice)
    pub fn builder() -> crate::model::associated_client_device::Builder {
        crate::model::associated_client_device::Builder::default()
    }
}

/// <p>Contains information about an IoT job configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentIoTJobConfiguration {
    /// <p>The rollout configuration for the job. This configuration defines the rate at which the
    /// job rolls out to the fleet of target devices.</p>
    pub job_executions_rollout_config:
        std::option::Option<crate::model::IoTJobExecutionsRolloutConfig>,
    /// <p>The stop configuration for the job. This configuration defines when and how to stop a job
    /// rollout.</p>
    pub abort_config: std::option::Option<crate::model::IoTJobAbortConfig>,
    /// <p>The timeout configuration for the job. This configuration defines the amount of time each
    /// device has to complete the job.</p>
    pub timeout_config: std::option::Option<crate::model::IoTJobTimeoutConfig>,
}
impl std::fmt::Debug for DeploymentIoTJobConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentIoTJobConfiguration");
        formatter.field(
            "job_executions_rollout_config",
            &self.job_executions_rollout_config,
        );
        formatter.field("abort_config", &self.abort_config);
        formatter.field("timeout_config", &self.timeout_config);
        formatter.finish()
    }
}
/// See [`DeploymentIoTJobConfiguration`](crate::model::DeploymentIoTJobConfiguration)
pub mod deployment_io_t_job_configuration {
    /// A builder for [`DeploymentIoTJobConfiguration`](crate::model::DeploymentIoTJobConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_executions_rollout_config:
            std::option::Option<crate::model::IoTJobExecutionsRolloutConfig>,
        pub(crate) abort_config: std::option::Option<crate::model::IoTJobAbortConfig>,
        pub(crate) timeout_config: std::option::Option<crate::model::IoTJobTimeoutConfig>,
    }
    impl Builder {
        /// <p>The rollout configuration for the job. This configuration defines the rate at which the
        /// job rolls out to the fleet of target devices.</p>
        pub fn job_executions_rollout_config(
            mut self,
            input: crate::model::IoTJobExecutionsRolloutConfig,
        ) -> Self {
            self.job_executions_rollout_config = Some(input);
            self
        }
        /// <p>The rollout configuration for the job. This configuration defines the rate at which the
        /// job rolls out to the fleet of target devices.</p>
        pub fn set_job_executions_rollout_config(
            mut self,
            input: std::option::Option<crate::model::IoTJobExecutionsRolloutConfig>,
        ) -> Self {
            self.job_executions_rollout_config = input;
            self
        }
        /// <p>The stop configuration for the job. This configuration defines when and how to stop a job
        /// rollout.</p>
        pub fn abort_config(mut self, input: crate::model::IoTJobAbortConfig) -> Self {
            self.abort_config = Some(input);
            self
        }
        /// <p>The stop configuration for the job. This configuration defines when and how to stop a job
        /// rollout.</p>
        pub fn set_abort_config(
            mut self,
            input: std::option::Option<crate::model::IoTJobAbortConfig>,
        ) -> Self {
            self.abort_config = input;
            self
        }
        /// <p>The timeout configuration for the job. This configuration defines the amount of time each
        /// device has to complete the job.</p>
        pub fn timeout_config(mut self, input: crate::model::IoTJobTimeoutConfig) -> Self {
            self.timeout_config = Some(input);
            self
        }
        /// <p>The timeout configuration for the job. This configuration defines the amount of time each
        /// device has to complete the job.</p>
        pub fn set_timeout_config(
            mut self,
            input: std::option::Option<crate::model::IoTJobTimeoutConfig>,
        ) -> Self {
            self.timeout_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentIoTJobConfiguration`](crate::model::DeploymentIoTJobConfiguration)
        pub fn build(self) -> crate::model::DeploymentIoTJobConfiguration {
            crate::model::DeploymentIoTJobConfiguration {
                job_executions_rollout_config: self.job_executions_rollout_config,
                abort_config: self.abort_config,
                timeout_config: self.timeout_config,
            }
        }
    }
}
impl DeploymentIoTJobConfiguration {
    /// Creates a new builder-style object to manufacture [`DeploymentIoTJobConfiguration`](crate::model::DeploymentIoTJobConfiguration)
    pub fn builder() -> crate::model::deployment_io_t_job_configuration::Builder {
        crate::model::deployment_io_t_job_configuration::Builder::default()
    }
}

/// <p>Contains information about the timeout configuration for a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IoTJobTimeoutConfig {
    /// <p>The amount of time, in minutes, that devices have to complete the job. The timer starts
    /// when the job status is set to <code>IN_PROGRESS</code>. If the job status doesn't change to a
    /// terminal state before the time expires, then the job status is set to
    /// <code>TIMED_OUT</code>.</p>
    /// <p>The timeout interval must be between 1 minute and 7 days (10080 minutes).</p>
    pub in_progress_timeout_in_minutes: std::option::Option<i64>,
}
impl std::fmt::Debug for IoTJobTimeoutConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IoTJobTimeoutConfig");
        formatter.field(
            "in_progress_timeout_in_minutes",
            &self.in_progress_timeout_in_minutes,
        );
        formatter.finish()
    }
}
/// See [`IoTJobTimeoutConfig`](crate::model::IoTJobTimeoutConfig)
pub mod io_t_job_timeout_config {
    /// A builder for [`IoTJobTimeoutConfig`](crate::model::IoTJobTimeoutConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) in_progress_timeout_in_minutes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The amount of time, in minutes, that devices have to complete the job. The timer starts
        /// when the job status is set to <code>IN_PROGRESS</code>. If the job status doesn't change to a
        /// terminal state before the time expires, then the job status is set to
        /// <code>TIMED_OUT</code>.</p>
        /// <p>The timeout interval must be between 1 minute and 7 days (10080 minutes).</p>
        pub fn in_progress_timeout_in_minutes(mut self, input: i64) -> Self {
            self.in_progress_timeout_in_minutes = Some(input);
            self
        }
        /// <p>The amount of time, in minutes, that devices have to complete the job. The timer starts
        /// when the job status is set to <code>IN_PROGRESS</code>. If the job status doesn't change to a
        /// terminal state before the time expires, then the job status is set to
        /// <code>TIMED_OUT</code>.</p>
        /// <p>The timeout interval must be between 1 minute and 7 days (10080 minutes).</p>
        pub fn set_in_progress_timeout_in_minutes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.in_progress_timeout_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`IoTJobTimeoutConfig`](crate::model::IoTJobTimeoutConfig)
        pub fn build(self) -> crate::model::IoTJobTimeoutConfig {
            crate::model::IoTJobTimeoutConfig {
                in_progress_timeout_in_minutes: self.in_progress_timeout_in_minutes,
            }
        }
    }
}
impl IoTJobTimeoutConfig {
    /// Creates a new builder-style object to manufacture [`IoTJobTimeoutConfig`](crate::model::IoTJobTimeoutConfig)
    pub fn builder() -> crate::model::io_t_job_timeout_config::Builder {
        crate::model::io_t_job_timeout_config::Builder::default()
    }
}

/// <p>Contains a list of criteria that define when and how to cancel a configuration
/// deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IoTJobAbortConfig {
    /// <p>The list of criteria that define when and how to cancel the configuration deployment.</p>
    pub criteria_list: std::option::Option<std::vec::Vec<crate::model::IoTJobAbortCriteria>>,
}
impl std::fmt::Debug for IoTJobAbortConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IoTJobAbortConfig");
        formatter.field("criteria_list", &self.criteria_list);
        formatter.finish()
    }
}
/// See [`IoTJobAbortConfig`](crate::model::IoTJobAbortConfig)
pub mod io_t_job_abort_config {
    /// A builder for [`IoTJobAbortConfig`](crate::model::IoTJobAbortConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) criteria_list:
            std::option::Option<std::vec::Vec<crate::model::IoTJobAbortCriteria>>,
    }
    impl Builder {
        /// Appends an item to `criteria_list`.
        ///
        /// To override the contents of this collection use [`set_criteria_list`](Self::set_criteria_list).
        ///
        /// <p>The list of criteria that define when and how to cancel the configuration deployment.</p>
        pub fn criteria_list(
            mut self,
            input: impl Into<crate::model::IoTJobAbortCriteria>,
        ) -> Self {
            let mut v = self.criteria_list.unwrap_or_default();
            v.push(input.into());
            self.criteria_list = Some(v);
            self
        }
        /// <p>The list of criteria that define when and how to cancel the configuration deployment.</p>
        pub fn set_criteria_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IoTJobAbortCriteria>>,
        ) -> Self {
            self.criteria_list = input;
            self
        }
        /// Consumes the builder and constructs a [`IoTJobAbortConfig`](crate::model::IoTJobAbortConfig)
        pub fn build(self) -> crate::model::IoTJobAbortConfig {
            crate::model::IoTJobAbortConfig {
                criteria_list: self.criteria_list,
            }
        }
    }
}
impl IoTJobAbortConfig {
    /// Creates a new builder-style object to manufacture [`IoTJobAbortConfig`](crate::model::IoTJobAbortConfig)
    pub fn builder() -> crate::model::io_t_job_abort_config::Builder {
        crate::model::io_t_job_abort_config::Builder::default()
    }
}

/// <p>Contains criteria that define when and how to cancel a job.</p>
/// <p>The deployment stops if the following conditions are true:</p>
/// <ol>
/// <li>
/// <p>The number of things that receive the deployment exceeds the
/// <code>minNumberOfExecutedThings</code>.</p>
/// </li>
/// <li>
/// <p>The percentage of failures with type <code>failureType</code> exceeds the
/// <code>thresholdPercentage</code>.</p>
/// </li>
/// </ol>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IoTJobAbortCriteria {
    /// <p>The type of job deployment failure that can cancel a job.</p>
    pub failure_type: std::option::Option<crate::model::IoTJobExecutionFailureType>,
    /// <p>The action to perform when the criteria are met.</p>
    pub action: std::option::Option<crate::model::IoTJobAbortAction>,
    /// <p>The minimum percentage of <code>failureType</code> failures that occur before the job can
    /// cancel.</p>
    /// <p>This parameter supports up to two digits after the decimal (for example, you can specify
    /// <code>10.9</code> or <code>10.99</code>, but not <code>10.999</code>).</p>
    pub threshold_percentage: f64,
    /// <p>The minimum number of things that receive the configuration before the job can
    /// cancel.</p>
    pub min_number_of_executed_things: i32,
}
impl std::fmt::Debug for IoTJobAbortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IoTJobAbortCriteria");
        formatter.field("failure_type", &self.failure_type);
        formatter.field("action", &self.action);
        formatter.field("threshold_percentage", &self.threshold_percentage);
        formatter.field(
            "min_number_of_executed_things",
            &self.min_number_of_executed_things,
        );
        formatter.finish()
    }
}
/// See [`IoTJobAbortCriteria`](crate::model::IoTJobAbortCriteria)
pub mod io_t_job_abort_criteria {
    /// A builder for [`IoTJobAbortCriteria`](crate::model::IoTJobAbortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_type: std::option::Option<crate::model::IoTJobExecutionFailureType>,
        pub(crate) action: std::option::Option<crate::model::IoTJobAbortAction>,
        pub(crate) threshold_percentage: std::option::Option<f64>,
        pub(crate) min_number_of_executed_things: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of job deployment failure that can cancel a job.</p>
        pub fn failure_type(mut self, input: crate::model::IoTJobExecutionFailureType) -> Self {
            self.failure_type = Some(input);
            self
        }
        /// <p>The type of job deployment failure that can cancel a job.</p>
        pub fn set_failure_type(
            mut self,
            input: std::option::Option<crate::model::IoTJobExecutionFailureType>,
        ) -> Self {
            self.failure_type = input;
            self
        }
        /// <p>The action to perform when the criteria are met.</p>
        pub fn action(mut self, input: crate::model::IoTJobAbortAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to perform when the criteria are met.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::IoTJobAbortAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The minimum percentage of <code>failureType</code> failures that occur before the job can
        /// cancel.</p>
        /// <p>This parameter supports up to two digits after the decimal (for example, you can specify
        /// <code>10.9</code> or <code>10.99</code>, but not <code>10.999</code>).</p>
        pub fn threshold_percentage(mut self, input: f64) -> Self {
            self.threshold_percentage = Some(input);
            self
        }
        /// <p>The minimum percentage of <code>failureType</code> failures that occur before the job can
        /// cancel.</p>
        /// <p>This parameter supports up to two digits after the decimal (for example, you can specify
        /// <code>10.9</code> or <code>10.99</code>, but not <code>10.999</code>).</p>
        pub fn set_threshold_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold_percentage = input;
            self
        }
        /// <p>The minimum number of things that receive the configuration before the job can
        /// cancel.</p>
        pub fn min_number_of_executed_things(mut self, input: i32) -> Self {
            self.min_number_of_executed_things = Some(input);
            self
        }
        /// <p>The minimum number of things that receive the configuration before the job can
        /// cancel.</p>
        pub fn set_min_number_of_executed_things(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.min_number_of_executed_things = input;
            self
        }
        /// Consumes the builder and constructs a [`IoTJobAbortCriteria`](crate::model::IoTJobAbortCriteria)
        pub fn build(self) -> crate::model::IoTJobAbortCriteria {
            crate::model::IoTJobAbortCriteria {
                failure_type: self.failure_type,
                action: self.action,
                threshold_percentage: self.threshold_percentage.unwrap_or_default(),
                min_number_of_executed_things: self
                    .min_number_of_executed_things
                    .unwrap_or_default(),
            }
        }
    }
}
impl IoTJobAbortCriteria {
    /// Creates a new builder-style object to manufacture [`IoTJobAbortCriteria`](crate::model::IoTJobAbortCriteria)
    pub fn builder() -> crate::model::io_t_job_abort_criteria::Builder {
        crate::model::io_t_job_abort_criteria::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IoTJobAbortAction {
    #[allow(missing_docs)] // documentation missing in model
    Cancel,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IoTJobAbortAction {
    fn from(s: &str) -> Self {
        match s {
            "CANCEL" => IoTJobAbortAction::Cancel,
            other => IoTJobAbortAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IoTJobAbortAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IoTJobAbortAction::from(s))
    }
}
impl IoTJobAbortAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IoTJobAbortAction::Cancel => "CANCEL",
            IoTJobAbortAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCEL"]
    }
}
impl AsRef<str> for IoTJobAbortAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IoTJobExecutionFailureType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IoTJobExecutionFailureType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => IoTJobExecutionFailureType::All,
            "FAILED" => IoTJobExecutionFailureType::Failed,
            "REJECTED" => IoTJobExecutionFailureType::Rejected,
            "TIMED_OUT" => IoTJobExecutionFailureType::TimedOut,
            other => IoTJobExecutionFailureType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IoTJobExecutionFailureType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IoTJobExecutionFailureType::from(s))
    }
}
impl IoTJobExecutionFailureType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IoTJobExecutionFailureType::All => "ALL",
            IoTJobExecutionFailureType::Failed => "FAILED",
            IoTJobExecutionFailureType::Rejected => "REJECTED",
            IoTJobExecutionFailureType::TimedOut => "TIMED_OUT",
            IoTJobExecutionFailureType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "FAILED", "REJECTED", "TIMED_OUT"]
    }
}
impl AsRef<str> for IoTJobExecutionFailureType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the rollout configuration for a job. This configuration defines
/// the rate at which the job deploys a configuration to a fleet of target devices.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IoTJobExecutionsRolloutConfig {
    /// <p>The exponential rate to increase the job rollout rate.</p>
    pub exponential_rate: std::option::Option<crate::model::IoTJobExponentialRolloutRate>,
    /// <p>The maximum number of devices that receive a pending job notification, per minute.</p>
    pub maximum_per_minute: std::option::Option<i32>,
}
impl std::fmt::Debug for IoTJobExecutionsRolloutConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IoTJobExecutionsRolloutConfig");
        formatter.field("exponential_rate", &self.exponential_rate);
        formatter.field("maximum_per_minute", &self.maximum_per_minute);
        formatter.finish()
    }
}
/// See [`IoTJobExecutionsRolloutConfig`](crate::model::IoTJobExecutionsRolloutConfig)
pub mod io_t_job_executions_rollout_config {
    /// A builder for [`IoTJobExecutionsRolloutConfig`](crate::model::IoTJobExecutionsRolloutConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exponential_rate:
            std::option::Option<crate::model::IoTJobExponentialRolloutRate>,
        pub(crate) maximum_per_minute: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The exponential rate to increase the job rollout rate.</p>
        pub fn exponential_rate(
            mut self,
            input: crate::model::IoTJobExponentialRolloutRate,
        ) -> Self {
            self.exponential_rate = Some(input);
            self
        }
        /// <p>The exponential rate to increase the job rollout rate.</p>
        pub fn set_exponential_rate(
            mut self,
            input: std::option::Option<crate::model::IoTJobExponentialRolloutRate>,
        ) -> Self {
            self.exponential_rate = input;
            self
        }
        /// <p>The maximum number of devices that receive a pending job notification, per minute.</p>
        pub fn maximum_per_minute(mut self, input: i32) -> Self {
            self.maximum_per_minute = Some(input);
            self
        }
        /// <p>The maximum number of devices that receive a pending job notification, per minute.</p>
        pub fn set_maximum_per_minute(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_per_minute = input;
            self
        }
        /// Consumes the builder and constructs a [`IoTJobExecutionsRolloutConfig`](crate::model::IoTJobExecutionsRolloutConfig)
        pub fn build(self) -> crate::model::IoTJobExecutionsRolloutConfig {
            crate::model::IoTJobExecutionsRolloutConfig {
                exponential_rate: self.exponential_rate,
                maximum_per_minute: self.maximum_per_minute,
            }
        }
    }
}
impl IoTJobExecutionsRolloutConfig {
    /// Creates a new builder-style object to manufacture [`IoTJobExecutionsRolloutConfig`](crate::model::IoTJobExecutionsRolloutConfig)
    pub fn builder() -> crate::model::io_t_job_executions_rollout_config::Builder {
        crate::model::io_t_job_executions_rollout_config::Builder::default()
    }
}

/// <p>Contains information about an exponential rollout rate for a configuration deployment
/// job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IoTJobExponentialRolloutRate {
    /// <p>The minimum number of devices that receive a pending job notification, per minute, when
    /// the job starts. This parameter defines the initial rollout rate of the job.</p>
    pub base_rate_per_minute: i32,
    /// <p>The exponential factor to increase the rollout rate for the job.</p>
    /// <p>This parameter supports up to one digit after the decimal (for example, you can specify
    /// <code>1.5</code>, but not <code>1.55</code>).</p>
    pub increment_factor: f64,
    /// <p>The criteria to increase the rollout rate for the job.</p>
    pub rate_increase_criteria: std::option::Option<crate::model::IoTJobRateIncreaseCriteria>,
}
impl std::fmt::Debug for IoTJobExponentialRolloutRate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IoTJobExponentialRolloutRate");
        formatter.field("base_rate_per_minute", &self.base_rate_per_minute);
        formatter.field("increment_factor", &self.increment_factor);
        formatter.field("rate_increase_criteria", &self.rate_increase_criteria);
        formatter.finish()
    }
}
/// See [`IoTJobExponentialRolloutRate`](crate::model::IoTJobExponentialRolloutRate)
pub mod io_t_job_exponential_rollout_rate {
    /// A builder for [`IoTJobExponentialRolloutRate`](crate::model::IoTJobExponentialRolloutRate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_rate_per_minute: std::option::Option<i32>,
        pub(crate) increment_factor: std::option::Option<f64>,
        pub(crate) rate_increase_criteria:
            std::option::Option<crate::model::IoTJobRateIncreaseCriteria>,
    }
    impl Builder {
        /// <p>The minimum number of devices that receive a pending job notification, per minute, when
        /// the job starts. This parameter defines the initial rollout rate of the job.</p>
        pub fn base_rate_per_minute(mut self, input: i32) -> Self {
            self.base_rate_per_minute = Some(input);
            self
        }
        /// <p>The minimum number of devices that receive a pending job notification, per minute, when
        /// the job starts. This parameter defines the initial rollout rate of the job.</p>
        pub fn set_base_rate_per_minute(mut self, input: std::option::Option<i32>) -> Self {
            self.base_rate_per_minute = input;
            self
        }
        /// <p>The exponential factor to increase the rollout rate for the job.</p>
        /// <p>This parameter supports up to one digit after the decimal (for example, you can specify
        /// <code>1.5</code>, but not <code>1.55</code>).</p>
        pub fn increment_factor(mut self, input: f64) -> Self {
            self.increment_factor = Some(input);
            self
        }
        /// <p>The exponential factor to increase the rollout rate for the job.</p>
        /// <p>This parameter supports up to one digit after the decimal (for example, you can specify
        /// <code>1.5</code>, but not <code>1.55</code>).</p>
        pub fn set_increment_factor(mut self, input: std::option::Option<f64>) -> Self {
            self.increment_factor = input;
            self
        }
        /// <p>The criteria to increase the rollout rate for the job.</p>
        pub fn rate_increase_criteria(
            mut self,
            input: crate::model::IoTJobRateIncreaseCriteria,
        ) -> Self {
            self.rate_increase_criteria = Some(input);
            self
        }
        /// <p>The criteria to increase the rollout rate for the job.</p>
        pub fn set_rate_increase_criteria(
            mut self,
            input: std::option::Option<crate::model::IoTJobRateIncreaseCriteria>,
        ) -> Self {
            self.rate_increase_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`IoTJobExponentialRolloutRate`](crate::model::IoTJobExponentialRolloutRate)
        pub fn build(self) -> crate::model::IoTJobExponentialRolloutRate {
            crate::model::IoTJobExponentialRolloutRate {
                base_rate_per_minute: self.base_rate_per_minute.unwrap_or_default(),
                increment_factor: self.increment_factor.unwrap_or_default(),
                rate_increase_criteria: self.rate_increase_criteria,
            }
        }
    }
}
impl IoTJobExponentialRolloutRate {
    /// Creates a new builder-style object to manufacture [`IoTJobExponentialRolloutRate`](crate::model::IoTJobExponentialRolloutRate)
    pub fn builder() -> crate::model::io_t_job_exponential_rollout_rate::Builder {
        crate::model::io_t_job_exponential_rollout_rate::Builder::default()
    }
}

/// <p>Contains information about criteria to meet before a job increases its rollout rate.
/// Specify either <code>numberOfNotifiedThings</code> or
/// <code>numberOfSucceededThings</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IoTJobRateIncreaseCriteria {
    /// <p>The number of devices to receive the job notification before the rollout rate
    /// increases.</p>
    pub number_of_notified_things: std::option::Option<i32>,
    /// <p>The number of devices to successfully run the configuration job before the rollout rate
    /// increases.</p>
    pub number_of_succeeded_things: std::option::Option<i32>,
}
impl std::fmt::Debug for IoTJobRateIncreaseCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IoTJobRateIncreaseCriteria");
        formatter.field("number_of_notified_things", &self.number_of_notified_things);
        formatter.field(
            "number_of_succeeded_things",
            &self.number_of_succeeded_things,
        );
        formatter.finish()
    }
}
/// See [`IoTJobRateIncreaseCriteria`](crate::model::IoTJobRateIncreaseCriteria)
pub mod io_t_job_rate_increase_criteria {
    /// A builder for [`IoTJobRateIncreaseCriteria`](crate::model::IoTJobRateIncreaseCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_of_notified_things: std::option::Option<i32>,
        pub(crate) number_of_succeeded_things: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of devices to receive the job notification before the rollout rate
        /// increases.</p>
        pub fn number_of_notified_things(mut self, input: i32) -> Self {
            self.number_of_notified_things = Some(input);
            self
        }
        /// <p>The number of devices to receive the job notification before the rollout rate
        /// increases.</p>
        pub fn set_number_of_notified_things(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_notified_things = input;
            self
        }
        /// <p>The number of devices to successfully run the configuration job before the rollout rate
        /// increases.</p>
        pub fn number_of_succeeded_things(mut self, input: i32) -> Self {
            self.number_of_succeeded_things = Some(input);
            self
        }
        /// <p>The number of devices to successfully run the configuration job before the rollout rate
        /// increases.</p>
        pub fn set_number_of_succeeded_things(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_succeeded_things = input;
            self
        }
        /// Consumes the builder and constructs a [`IoTJobRateIncreaseCriteria`](crate::model::IoTJobRateIncreaseCriteria)
        pub fn build(self) -> crate::model::IoTJobRateIncreaseCriteria {
            crate::model::IoTJobRateIncreaseCriteria {
                number_of_notified_things: self.number_of_notified_things,
                number_of_succeeded_things: self.number_of_succeeded_things,
            }
        }
    }
}
impl IoTJobRateIncreaseCriteria {
    /// Creates a new builder-style object to manufacture [`IoTJobRateIncreaseCriteria`](crate::model::IoTJobRateIncreaseCriteria)
    pub fn builder() -> crate::model::io_t_job_rate_increase_criteria::Builder {
        crate::model::io_t_job_rate_increase_criteria::Builder::default()
    }
}

/// <p>Contains information about policies that define how a deployment updates components and
/// handles failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentPolicies {
    /// <p>The failure handling policy for the configuration deployment. This policy defines what to
    /// do if the deployment fails.</p>
    /// <p>Default: <code>ROLLBACK</code>
    /// </p>
    pub failure_handling_policy: std::option::Option<crate::model::DeploymentFailureHandlingPolicy>,
    /// <p>The component update policy for the configuration deployment. This policy defines when
    /// it's safe to deploy the configuration to devices.</p>
    pub component_update_policy: std::option::Option<crate::model::DeploymentComponentUpdatePolicy>,
    /// <p>The configuration validation policy for the configuration deployment. This policy defines
    /// how long each component has to validate its configure updates.</p>
    pub configuration_validation_policy:
        std::option::Option<crate::model::DeploymentConfigurationValidationPolicy>,
}
impl std::fmt::Debug for DeploymentPolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentPolicies");
        formatter.field("failure_handling_policy", &self.failure_handling_policy);
        formatter.field("component_update_policy", &self.component_update_policy);
        formatter.field(
            "configuration_validation_policy",
            &self.configuration_validation_policy,
        );
        formatter.finish()
    }
}
/// See [`DeploymentPolicies`](crate::model::DeploymentPolicies)
pub mod deployment_policies {
    /// A builder for [`DeploymentPolicies`](crate::model::DeploymentPolicies)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_handling_policy:
            std::option::Option<crate::model::DeploymentFailureHandlingPolicy>,
        pub(crate) component_update_policy:
            std::option::Option<crate::model::DeploymentComponentUpdatePolicy>,
        pub(crate) configuration_validation_policy:
            std::option::Option<crate::model::DeploymentConfigurationValidationPolicy>,
    }
    impl Builder {
        /// <p>The failure handling policy for the configuration deployment. This policy defines what to
        /// do if the deployment fails.</p>
        /// <p>Default: <code>ROLLBACK</code>
        /// </p>
        pub fn failure_handling_policy(
            mut self,
            input: crate::model::DeploymentFailureHandlingPolicy,
        ) -> Self {
            self.failure_handling_policy = Some(input);
            self
        }
        /// <p>The failure handling policy for the configuration deployment. This policy defines what to
        /// do if the deployment fails.</p>
        /// <p>Default: <code>ROLLBACK</code>
        /// </p>
        pub fn set_failure_handling_policy(
            mut self,
            input: std::option::Option<crate::model::DeploymentFailureHandlingPolicy>,
        ) -> Self {
            self.failure_handling_policy = input;
            self
        }
        /// <p>The component update policy for the configuration deployment. This policy defines when
        /// it's safe to deploy the configuration to devices.</p>
        pub fn component_update_policy(
            mut self,
            input: crate::model::DeploymentComponentUpdatePolicy,
        ) -> Self {
            self.component_update_policy = Some(input);
            self
        }
        /// <p>The component update policy for the configuration deployment. This policy defines when
        /// it's safe to deploy the configuration to devices.</p>
        pub fn set_component_update_policy(
            mut self,
            input: std::option::Option<crate::model::DeploymentComponentUpdatePolicy>,
        ) -> Self {
            self.component_update_policy = input;
            self
        }
        /// <p>The configuration validation policy for the configuration deployment. This policy defines
        /// how long each component has to validate its configure updates.</p>
        pub fn configuration_validation_policy(
            mut self,
            input: crate::model::DeploymentConfigurationValidationPolicy,
        ) -> Self {
            self.configuration_validation_policy = Some(input);
            self
        }
        /// <p>The configuration validation policy for the configuration deployment. This policy defines
        /// how long each component has to validate its configure updates.</p>
        pub fn set_configuration_validation_policy(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfigurationValidationPolicy>,
        ) -> Self {
            self.configuration_validation_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentPolicies`](crate::model::DeploymentPolicies)
        pub fn build(self) -> crate::model::DeploymentPolicies {
            crate::model::DeploymentPolicies {
                failure_handling_policy: self.failure_handling_policy,
                component_update_policy: self.component_update_policy,
                configuration_validation_policy: self.configuration_validation_policy,
            }
        }
    }
}
impl DeploymentPolicies {
    /// Creates a new builder-style object to manufacture [`DeploymentPolicies`](crate::model::DeploymentPolicies)
    pub fn builder() -> crate::model::deployment_policies::Builder {
        crate::model::deployment_policies::Builder::default()
    }
}

/// <p>Contains information about how long a component on a core device can validate its
/// configuration updates before it times out. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetovalidateconfigurationupdates">SubscribeToValidateConfigurationUpdates</a> IPC operation to receive notifications when
/// a deployment specifies a configuration update. Then, components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-sendconfigurationvalidityreport">SendConfigurationValidityReport</a> IPC operation. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentConfigurationValidationPolicy {
    /// <p>The amount of time in seconds that a component can validate its configuration updates. If
    /// the validation time exceeds this timeout, then the deployment proceeds for the device.</p>
    /// <p>Default: <code>30</code>
    /// </p>
    pub timeout_in_seconds: std::option::Option<i32>,
}
impl std::fmt::Debug for DeploymentConfigurationValidationPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentConfigurationValidationPolicy");
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.finish()
    }
}
/// See [`DeploymentConfigurationValidationPolicy`](crate::model::DeploymentConfigurationValidationPolicy)
pub mod deployment_configuration_validation_policy {
    /// A builder for [`DeploymentConfigurationValidationPolicy`](crate::model::DeploymentConfigurationValidationPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The amount of time in seconds that a component can validate its configuration updates. If
        /// the validation time exceeds this timeout, then the deployment proceeds for the device.</p>
        /// <p>Default: <code>30</code>
        /// </p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time in seconds that a component can validate its configuration updates. If
        /// the validation time exceeds this timeout, then the deployment proceeds for the device.</p>
        /// <p>Default: <code>30</code>
        /// </p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentConfigurationValidationPolicy`](crate::model::DeploymentConfigurationValidationPolicy)
        pub fn build(self) -> crate::model::DeploymentConfigurationValidationPolicy {
            crate::model::DeploymentConfigurationValidationPolicy {
                timeout_in_seconds: self.timeout_in_seconds,
            }
        }
    }
}
impl DeploymentConfigurationValidationPolicy {
    /// Creates a new builder-style object to manufacture [`DeploymentConfigurationValidationPolicy`](crate::model::DeploymentConfigurationValidationPolicy)
    pub fn builder() -> crate::model::deployment_configuration_validation_policy::Builder {
        crate::model::deployment_configuration_validation_policy::Builder::default()
    }
}

/// <p>Contains information about a deployment's policy that defines when components are safe to
/// update.</p>
/// <p>Each component on a device can report whether or not it's ready to update. After a
/// component and its dependencies are ready, they can apply the update in the deployment. You can
/// configure whether or not the deployment notifies components of an update and waits for a
/// response. You specify the amount of time each component has to respond to the update
/// notification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentComponentUpdatePolicy {
    /// <p>The amount of time in seconds that each component on a device has to report that it's safe
    /// to update. If the component waits for longer than this timeout, then the deployment proceeds
    /// on the device.</p>
    /// <p>Default: <code>60</code>
    /// </p>
    pub timeout_in_seconds: std::option::Option<i32>,
    /// <p>Whether or not to notify components and wait for components to become safe to update.
    /// Choose from the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NOTIFY_COMPONENTS</code> – The deployment notifies each component before
    /// it stops and updates that component. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates">SubscribeToComponentUpdates</a> IPC operation to receive these notifications. Then,
    /// components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate">DeferComponentUpdate</a> IPC operation. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIP_NOTIFY_COMPONENTS</code> – The deployment doesn't notify components
    /// or wait for them to be safe to update.</p>
    /// </li>
    /// </ul>
    /// <p>Default: <code>NOTIFY_COMPONENTS</code>
    /// </p>
    pub action: std::option::Option<crate::model::DeploymentComponentUpdatePolicyAction>,
}
impl std::fmt::Debug for DeploymentComponentUpdatePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentComponentUpdatePolicy");
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}
/// See [`DeploymentComponentUpdatePolicy`](crate::model::DeploymentComponentUpdatePolicy)
pub mod deployment_component_update_policy {
    /// A builder for [`DeploymentComponentUpdatePolicy`](crate::model::DeploymentComponentUpdatePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
        pub(crate) action: std::option::Option<crate::model::DeploymentComponentUpdatePolicyAction>,
    }
    impl Builder {
        /// <p>The amount of time in seconds that each component on a device has to report that it's safe
        /// to update. If the component waits for longer than this timeout, then the deployment proceeds
        /// on the device.</p>
        /// <p>Default: <code>60</code>
        /// </p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time in seconds that each component on a device has to report that it's safe
        /// to update. If the component waits for longer than this timeout, then the deployment proceeds
        /// on the device.</p>
        /// <p>Default: <code>60</code>
        /// </p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// <p>Whether or not to notify components and wait for components to become safe to update.
        /// Choose from the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NOTIFY_COMPONENTS</code> – The deployment notifies each component before
        /// it stops and updates that component. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates">SubscribeToComponentUpdates</a> IPC operation to receive these notifications. Then,
        /// components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate">DeferComponentUpdate</a> IPC operation. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIP_NOTIFY_COMPONENTS</code> – The deployment doesn't notify components
        /// or wait for them to be safe to update.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>NOTIFY_COMPONENTS</code>
        /// </p>
        pub fn action(
            mut self,
            input: crate::model::DeploymentComponentUpdatePolicyAction,
        ) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Whether or not to notify components and wait for components to become safe to update.
        /// Choose from the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NOTIFY_COMPONENTS</code> – The deployment notifies each component before
        /// it stops and updates that component. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates">SubscribeToComponentUpdates</a> IPC operation to receive these notifications. Then,
        /// components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate">DeferComponentUpdate</a> IPC operation. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIP_NOTIFY_COMPONENTS</code> – The deployment doesn't notify components
        /// or wait for them to be safe to update.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>NOTIFY_COMPONENTS</code>
        /// </p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::DeploymentComponentUpdatePolicyAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentComponentUpdatePolicy`](crate::model::DeploymentComponentUpdatePolicy)
        pub fn build(self) -> crate::model::DeploymentComponentUpdatePolicy {
            crate::model::DeploymentComponentUpdatePolicy {
                timeout_in_seconds: self.timeout_in_seconds,
                action: self.action,
            }
        }
    }
}
impl DeploymentComponentUpdatePolicy {
    /// Creates a new builder-style object to manufacture [`DeploymentComponentUpdatePolicy`](crate::model::DeploymentComponentUpdatePolicy)
    pub fn builder() -> crate::model::deployment_component_update_policy::Builder {
        crate::model::deployment_component_update_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentComponentUpdatePolicyAction {
    #[allow(missing_docs)] // documentation missing in model
    NotifyComponents,
    #[allow(missing_docs)] // documentation missing in model
    SkipNotifyComponents,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentComponentUpdatePolicyAction {
    fn from(s: &str) -> Self {
        match s {
            "NOTIFY_COMPONENTS" => DeploymentComponentUpdatePolicyAction::NotifyComponents,
            "SKIP_NOTIFY_COMPONENTS" => DeploymentComponentUpdatePolicyAction::SkipNotifyComponents,
            other => DeploymentComponentUpdatePolicyAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentComponentUpdatePolicyAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentComponentUpdatePolicyAction::from(s))
    }
}
impl DeploymentComponentUpdatePolicyAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentComponentUpdatePolicyAction::NotifyComponents => "NOTIFY_COMPONENTS",
            DeploymentComponentUpdatePolicyAction::SkipNotifyComponents => "SKIP_NOTIFY_COMPONENTS",
            DeploymentComponentUpdatePolicyAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOTIFY_COMPONENTS", "SKIP_NOTIFY_COMPONENTS"]
    }
}
impl AsRef<str> for DeploymentComponentUpdatePolicyAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentFailureHandlingPolicy {
    #[allow(missing_docs)] // documentation missing in model
    DoNothing,
    #[allow(missing_docs)] // documentation missing in model
    Rollback,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentFailureHandlingPolicy {
    fn from(s: &str) -> Self {
        match s {
            "DO_NOTHING" => DeploymentFailureHandlingPolicy::DoNothing,
            "ROLLBACK" => DeploymentFailureHandlingPolicy::Rollback,
            other => DeploymentFailureHandlingPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentFailureHandlingPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentFailureHandlingPolicy::from(s))
    }
}
impl DeploymentFailureHandlingPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentFailureHandlingPolicy::DoNothing => "DO_NOTHING",
            DeploymentFailureHandlingPolicy::Rollback => "ROLLBACK",
            DeploymentFailureHandlingPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DO_NOTHING", "ROLLBACK"]
    }
}
impl AsRef<str> for DeploymentFailureHandlingPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a component to deploy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentDeploymentSpecification {
    /// <p>The version of the component.</p>
    pub component_version: std::option::Option<std::string::String>,
    /// <p>The configuration updates to deploy for the component. You can define
    /// <i>reset</i> updates and <i>merge</i> updates. A reset updates
    /// the keys that you specify to the default configuration for the component. A merge updates the
    /// core device's component configuration with the keys and values that you specify. The IoT Greengrass Core
    /// software applies reset updates before it applies merge updates. For more information, see
    /// <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component
    /// configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
    pub configuration_update: std::option::Option<crate::model::ComponentConfigurationUpdate>,
    /// <p>The system user and group that the IoT Greengrass Core software uses to run component processes on the
    /// core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group
    /// that you configure for the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer
    /// Guide</i>.</p>
    pub run_with: std::option::Option<crate::model::ComponentRunWith>,
}
impl std::fmt::Debug for ComponentDeploymentSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentDeploymentSpecification");
        formatter.field("component_version", &self.component_version);
        formatter.field("configuration_update", &self.configuration_update);
        formatter.field("run_with", &self.run_with);
        formatter.finish()
    }
}
/// See [`ComponentDeploymentSpecification`](crate::model::ComponentDeploymentSpecification)
pub mod component_deployment_specification {
    /// A builder for [`ComponentDeploymentSpecification`](crate::model::ComponentDeploymentSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_version: std::option::Option<std::string::String>,
        pub(crate) configuration_update:
            std::option::Option<crate::model::ComponentConfigurationUpdate>,
        pub(crate) run_with: std::option::Option<crate::model::ComponentRunWith>,
    }
    impl Builder {
        /// <p>The version of the component.</p>
        pub fn component_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        pub fn set_component_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_version = input;
            self
        }
        /// <p>The configuration updates to deploy for the component. You can define
        /// <i>reset</i> updates and <i>merge</i> updates. A reset updates
        /// the keys that you specify to the default configuration for the component. A merge updates the
        /// core device's component configuration with the keys and values that you specify. The IoT Greengrass Core
        /// software applies reset updates before it applies merge updates. For more information, see
        /// <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component
        /// configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn configuration_update(
            mut self,
            input: crate::model::ComponentConfigurationUpdate,
        ) -> Self {
            self.configuration_update = Some(input);
            self
        }
        /// <p>The configuration updates to deploy for the component. You can define
        /// <i>reset</i> updates and <i>merge</i> updates. A reset updates
        /// the keys that you specify to the default configuration for the component. A merge updates the
        /// core device's component configuration with the keys and values that you specify. The IoT Greengrass Core
        /// software applies reset updates before it applies merge updates. For more information, see
        /// <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component
        /// configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
        pub fn set_configuration_update(
            mut self,
            input: std::option::Option<crate::model::ComponentConfigurationUpdate>,
        ) -> Self {
            self.configuration_update = input;
            self
        }
        /// <p>The system user and group that the IoT Greengrass Core software uses to run component processes on the
        /// core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group
        /// that you configure for the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer
        /// Guide</i>.</p>
        pub fn run_with(mut self, input: crate::model::ComponentRunWith) -> Self {
            self.run_with = Some(input);
            self
        }
        /// <p>The system user and group that the IoT Greengrass Core software uses to run component processes on the
        /// core device. If you omit this parameter, the IoT Greengrass Core software uses the system user and group
        /// that you configure for the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer
        /// Guide</i>.</p>
        pub fn set_run_with(
            mut self,
            input: std::option::Option<crate::model::ComponentRunWith>,
        ) -> Self {
            self.run_with = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentDeploymentSpecification`](crate::model::ComponentDeploymentSpecification)
        pub fn build(self) -> crate::model::ComponentDeploymentSpecification {
            crate::model::ComponentDeploymentSpecification {
                component_version: self.component_version,
                configuration_update: self.configuration_update,
                run_with: self.run_with,
            }
        }
    }
}
impl ComponentDeploymentSpecification {
    /// Creates a new builder-style object to manufacture [`ComponentDeploymentSpecification`](crate::model::ComponentDeploymentSpecification)
    pub fn builder() -> crate::model::component_deployment_specification::Builder {
        crate::model::component_deployment_specification::Builder::default()
    }
}

/// <p>Contains information system user and group that the IoT Greengrass Core software uses to run component
/// processes on the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> in the <i>IoT Greengrass V2 Developer
/// Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentRunWith {
    /// <p>The POSIX system user and (optional) group to use to run this component. Specify the user
    /// and group separated by a colon (<code>:</code>) in the following format:
    /// <code>user:group</code>. The group is optional. If you don't specify a group, the IoT Greengrass Core
    /// software uses the primary user for the group.</p>
    /// <p>If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that
    /// you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a>.</p>
    pub posix_user: std::option::Option<std::string::String>,
    /// <p>The system resource limits to apply to this component's process on the core device.</p>
    /// <p>If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits
    /// that you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a>.</p>
    pub system_resource_limits: std::option::Option<crate::model::SystemResourceLimits>,
}
impl std::fmt::Debug for ComponentRunWith {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentRunWith");
        formatter.field("posix_user", &self.posix_user);
        formatter.field("system_resource_limits", &self.system_resource_limits);
        formatter.finish()
    }
}
/// See [`ComponentRunWith`](crate::model::ComponentRunWith)
pub mod component_run_with {
    /// A builder for [`ComponentRunWith`](crate::model::ComponentRunWith)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) posix_user: std::option::Option<std::string::String>,
        pub(crate) system_resource_limits: std::option::Option<crate::model::SystemResourceLimits>,
    }
    impl Builder {
        /// <p>The POSIX system user and (optional) group to use to run this component. Specify the user
        /// and group separated by a colon (<code>:</code>) in the following format:
        /// <code>user:group</code>. The group is optional. If you don't specify a group, the IoT Greengrass Core
        /// software uses the primary user for the group.</p>
        /// <p>If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that
        /// you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a>.</p>
        pub fn posix_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.posix_user = Some(input.into());
            self
        }
        /// <p>The POSIX system user and (optional) group to use to run this component. Specify the user
        /// and group separated by a colon (<code>:</code>) in the following format:
        /// <code>user:group</code>. The group is optional. If you don't specify a group, the IoT Greengrass Core
        /// software uses the primary user for the group.</p>
        /// <p>If you omit this parameter, the IoT Greengrass Core software uses the default system user and group that
        /// you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a>.</p>
        pub fn set_posix_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.posix_user = input;
            self
        }
        /// <p>The system resource limits to apply to this component's process on the core device.</p>
        /// <p>If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits
        /// that you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a>.</p>
        pub fn system_resource_limits(mut self, input: crate::model::SystemResourceLimits) -> Self {
            self.system_resource_limits = Some(input);
            self
        }
        /// <p>The system resource limits to apply to this component's process on the core device.</p>
        /// <p>If you omit this parameter, the IoT Greengrass Core software uses the default system resource limits
        /// that you configure on the Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a>.</p>
        pub fn set_system_resource_limits(
            mut self,
            input: std::option::Option<crate::model::SystemResourceLimits>,
        ) -> Self {
            self.system_resource_limits = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentRunWith`](crate::model::ComponentRunWith)
        pub fn build(self) -> crate::model::ComponentRunWith {
            crate::model::ComponentRunWith {
                posix_user: self.posix_user,
                system_resource_limits: self.system_resource_limits,
            }
        }
    }
}
impl ComponentRunWith {
    /// Creates a new builder-style object to manufacture [`ComponentRunWith`](crate::model::ComponentRunWith)
    pub fn builder() -> crate::model::component_run_with::Builder {
        crate::model::component_run_with::Builder::default()
    }
}

/// <p>Contains information about system resource limits that the IoT Greengrass Core software applies to a
/// component's processes. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemResourceLimits {
    /// <p>The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on
    /// the core device.</p>
    pub memory: i64,
    /// <p>The maximum amount of CPU time that a component's processes can use on the core device. A
    /// core device's total CPU time is equivalent to the device's number of CPU cores. For example,
    /// on a core device with 4 CPU cores, you can set this value to <code>2</code> to limit the
    /// component's processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you
    /// can set this value to <code>0.25</code> to limit the component's processes to 25 percent usage
    /// of the CPU. If you set this value to a number greater than the number of CPU cores, the IoT Greengrass Core
    /// software doesn't limit the component's CPU usage.</p>
    pub cpus: f64,
}
impl std::fmt::Debug for SystemResourceLimits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemResourceLimits");
        formatter.field("memory", &self.memory);
        formatter.field("cpus", &self.cpus);
        formatter.finish()
    }
}
/// See [`SystemResourceLimits`](crate::model::SystemResourceLimits)
pub mod system_resource_limits {
    /// A builder for [`SystemResourceLimits`](crate::model::SystemResourceLimits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) memory: std::option::Option<i64>,
        pub(crate) cpus: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on
        /// the core device.</p>
        pub fn memory(mut self, input: i64) -> Self {
            self.memory = Some(input);
            self
        }
        /// <p>The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on
        /// the core device.</p>
        pub fn set_memory(mut self, input: std::option::Option<i64>) -> Self {
            self.memory = input;
            self
        }
        /// <p>The maximum amount of CPU time that a component's processes can use on the core device. A
        /// core device's total CPU time is equivalent to the device's number of CPU cores. For example,
        /// on a core device with 4 CPU cores, you can set this value to <code>2</code> to limit the
        /// component's processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you
        /// can set this value to <code>0.25</code> to limit the component's processes to 25 percent usage
        /// of the CPU. If you set this value to a number greater than the number of CPU cores, the IoT Greengrass Core
        /// software doesn't limit the component's CPU usage.</p>
        pub fn cpus(mut self, input: f64) -> Self {
            self.cpus = Some(input);
            self
        }
        /// <p>The maximum amount of CPU time that a component's processes can use on the core device. A
        /// core device's total CPU time is equivalent to the device's number of CPU cores. For example,
        /// on a core device with 4 CPU cores, you can set this value to <code>2</code> to limit the
        /// component's processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you
        /// can set this value to <code>0.25</code> to limit the component's processes to 25 percent usage
        /// of the CPU. If you set this value to a number greater than the number of CPU cores, the IoT Greengrass Core
        /// software doesn't limit the component's CPU usage.</p>
        pub fn set_cpus(mut self, input: std::option::Option<f64>) -> Self {
            self.cpus = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemResourceLimits`](crate::model::SystemResourceLimits)
        pub fn build(self) -> crate::model::SystemResourceLimits {
            crate::model::SystemResourceLimits {
                memory: self.memory.unwrap_or_default(),
                cpus: self.cpus.unwrap_or_default(),
            }
        }
    }
}
impl SystemResourceLimits {
    /// Creates a new builder-style object to manufacture [`SystemResourceLimits`](crate::model::SystemResourceLimits)
    pub fn builder() -> crate::model::system_resource_limits::Builder {
        crate::model::system_resource_limits::Builder::default()
    }
}

/// <p>Contains information about a deployment's update to a component's configuration on
/// Greengrass core devices. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component
/// configurations</a> in the <i>IoT Greengrass V2 Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentConfigurationUpdate {
    /// <p>A serialized JSON string that contains the configuration object to merge to target
    /// devices. The core device merges this configuration with the component's existing
    /// configuration. If this is the first time a component deploys on a device, the core device
    /// merges this configuration with the component's default configuration. This means that the core
    /// device keeps it's existing configuration for keys and values that you don't specify in this
    /// object. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update">Merge configuration updates</a> in the <i>IoT Greengrass V2 Developer
    /// Guide</i>.</p>
    pub merge: std::option::Option<std::string::String>,
    /// <p>The list of configuration nodes to reset to default values on target devices. Use JSON
    /// pointers to specify each node to reset. JSON pointers start with a forward slash
    /// (<code>/</code>) and use forward slashes to separate the key for each level in the object.
    /// For more information, see the <a href="https://tools.ietf.org/html/rfc6901">JSON pointer
    /// specification</a> and <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update">Reset configuration updates</a> in the <i>IoT Greengrass V2 Developer
    /// Guide</i>.</p>
    pub reset: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ComponentConfigurationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentConfigurationUpdate");
        formatter.field("merge", &self.merge);
        formatter.field("reset", &self.reset);
        formatter.finish()
    }
}
/// See [`ComponentConfigurationUpdate`](crate::model::ComponentConfigurationUpdate)
pub mod component_configuration_update {
    /// A builder for [`ComponentConfigurationUpdate`](crate::model::ComponentConfigurationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) merge: std::option::Option<std::string::String>,
        pub(crate) reset: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A serialized JSON string that contains the configuration object to merge to target
        /// devices. The core device merges this configuration with the component's existing
        /// configuration. If this is the first time a component deploys on a device, the core device
        /// merges this configuration with the component's default configuration. This means that the core
        /// device keeps it's existing configuration for keys and values that you don't specify in this
        /// object. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update">Merge configuration updates</a> in the <i>IoT Greengrass V2 Developer
        /// Guide</i>.</p>
        pub fn merge(mut self, input: impl Into<std::string::String>) -> Self {
            self.merge = Some(input.into());
            self
        }
        /// <p>A serialized JSON string that contains the configuration object to merge to target
        /// devices. The core device merges this configuration with the component's existing
        /// configuration. If this is the first time a component deploys on a device, the core device
        /// merges this configuration with the component's default configuration. This means that the core
        /// device keeps it's existing configuration for keys and values that you don't specify in this
        /// object. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update">Merge configuration updates</a> in the <i>IoT Greengrass V2 Developer
        /// Guide</i>.</p>
        pub fn set_merge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.merge = input;
            self
        }
        /// Appends an item to `reset`.
        ///
        /// To override the contents of this collection use [`set_reset`](Self::set_reset).
        ///
        /// <p>The list of configuration nodes to reset to default values on target devices. Use JSON
        /// pointers to specify each node to reset. JSON pointers start with a forward slash
        /// (<code>/</code>) and use forward slashes to separate the key for each level in the object.
        /// For more information, see the <a href="https://tools.ietf.org/html/rfc6901">JSON pointer
        /// specification</a> and <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update">Reset configuration updates</a> in the <i>IoT Greengrass V2 Developer
        /// Guide</i>.</p>
        pub fn reset(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reset.unwrap_or_default();
            v.push(input.into());
            self.reset = Some(v);
            self
        }
        /// <p>The list of configuration nodes to reset to default values on target devices. Use JSON
        /// pointers to specify each node to reset. JSON pointers start with a forward slash
        /// (<code>/</code>) and use forward slashes to separate the key for each level in the object.
        /// For more information, see the <a href="https://tools.ietf.org/html/rfc6901">JSON pointer
        /// specification</a> and <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update">Reset configuration updates</a> in the <i>IoT Greengrass V2 Developer
        /// Guide</i>.</p>
        pub fn set_reset(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reset = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentConfigurationUpdate`](crate::model::ComponentConfigurationUpdate)
        pub fn build(self) -> crate::model::ComponentConfigurationUpdate {
            crate::model::ComponentConfigurationUpdate {
                merge: self.merge,
                reset: self.reset,
            }
        }
    }
}
impl ComponentConfigurationUpdate {
    /// Creates a new builder-style object to manufacture [`ComponentConfigurationUpdate`](crate::model::ComponentConfigurationUpdate)
    pub fn builder() -> crate::model::component_configuration_update::Builder {
        crate::model::component_configuration_update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecipeOutputFormat {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Yaml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecipeOutputFormat {
    fn from(s: &str) -> Self {
        match s {
            "JSON" => RecipeOutputFormat::Json,
            "YAML" => RecipeOutputFormat::Yaml,
            other => RecipeOutputFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecipeOutputFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecipeOutputFormat::from(s))
    }
}
impl RecipeOutputFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecipeOutputFormat::Json => "JSON",
            RecipeOutputFormat::Yaml => "YAML",
            RecipeOutputFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON", "YAML"]
    }
}
impl AsRef<str> for RecipeOutputFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the status of a component in the IoT Greengrass service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudComponentStatus {
    /// <p>The state of the component.</p>
    pub component_state: std::option::Option<crate::model::CloudComponentState>,
    /// <p>A message that communicates details, such as errors, about the status of the component.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>A dictionary of errors that communicate why the component is in an error state. For
    /// example, if IoT Greengrass can't access an artifact for the component, then <code>errors</code> contains
    /// the artifact's URI as a key, and the error message as the value for that key.</p>
    pub errors:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CloudComponentStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudComponentStatus");
        formatter.field("component_state", &self.component_state);
        formatter.field("message", &self.message);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`CloudComponentStatus`](crate::model::CloudComponentStatus)
pub mod cloud_component_status {
    /// A builder for [`CloudComponentStatus`](crate::model::CloudComponentStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_state: std::option::Option<crate::model::CloudComponentState>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) errors: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The state of the component.</p>
        pub fn component_state(mut self, input: crate::model::CloudComponentState) -> Self {
            self.component_state = Some(input);
            self
        }
        /// <p>The state of the component.</p>
        pub fn set_component_state(
            mut self,
            input: std::option::Option<crate::model::CloudComponentState>,
        ) -> Self {
            self.component_state = input;
            self
        }
        /// <p>A message that communicates details, such as errors, about the status of the component.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that communicates details, such as errors, about the status of the component.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Adds a key-value pair to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A dictionary of errors that communicate why the component is in an error state. For
        /// example, if IoT Greengrass can't access an artifact for the component, then <code>errors</code> contains
        /// the artifact's URI as a key, and the error message as the value for that key.</p>
        pub fn errors(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.errors.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.errors = Some(hash_map);
            self
        }
        /// <p>A dictionary of errors that communicate why the component is in an error state. For
        /// example, if IoT Greengrass can't access an artifact for the component, then <code>errors</code> contains
        /// the artifact's URI as a key, and the error message as the value for that key.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudComponentStatus`](crate::model::CloudComponentStatus)
        pub fn build(self) -> crate::model::CloudComponentStatus {
            crate::model::CloudComponentStatus {
                component_state: self.component_state,
                message: self.message,
                errors: self.errors,
            }
        }
    }
}
impl CloudComponentStatus {
    /// Creates a new builder-style object to manufacture [`CloudComponentStatus`](crate::model::CloudComponentStatus)
    pub fn builder() -> crate::model::cloud_component_status::Builder {
        crate::model::cloud_component_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloudComponentState {
    #[allow(missing_docs)] // documentation missing in model
    Deployable,
    #[allow(missing_docs)] // documentation missing in model
    Deprecated,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Initiated,
    #[allow(missing_docs)] // documentation missing in model
    Requested,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloudComponentState {
    fn from(s: &str) -> Self {
        match s {
            "DEPLOYABLE" => CloudComponentState::Deployable,
            "DEPRECATED" => CloudComponentState::Deprecated,
            "FAILED" => CloudComponentState::Failed,
            "INITIATED" => CloudComponentState::Initiated,
            "REQUESTED" => CloudComponentState::Requested,
            other => CloudComponentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloudComponentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloudComponentState::from(s))
    }
}
impl CloudComponentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloudComponentState::Deployable => "DEPLOYABLE",
            CloudComponentState::Deprecated => "DEPRECATED",
            CloudComponentState::Failed => "FAILED",
            CloudComponentState::Initiated => "INITIATED",
            CloudComponentState::Requested => "REQUESTED",
            CloudComponentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEPLOYABLE",
            "DEPRECATED",
            "FAILED",
            "INITIATED",
            "REQUESTED",
        ]
    }
}
impl AsRef<str> for CloudComponentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an Lambda function to import to create a component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionRecipeSource {
    /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda function. The ARN must include the version of the function to
    /// import. You can't use version aliases like <code>$LATEST</code>.</p>
    pub lambda_arn: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    /// <p>Defaults to the name of the Lambda function.</p>
    pub component_name: std::option::Option<std::string::String>,
    /// <p>The version of the component.</p>
    /// <p>Defaults to the version of the Lambda function as a semantic version. For example, if your
    /// function version is <code>3</code>, the component version becomes <code>3.0.0</code>.</p>
    pub component_version: std::option::Option<std::string::String>,
    /// <p>The platforms that the component version supports.</p>
    pub component_platforms: std::option::Option<std::vec::Vec<crate::model::ComponentPlatform>>,
    /// <p>The component versions on which this Lambda function component depends.</p>
    pub component_dependencies: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::ComponentDependencyRequirement,
        >,
    >,
    /// <p>The system and runtime parameters for the Lambda function as it runs on the Greengrass core
    /// device.</p>
    pub component_lambda_parameters: std::option::Option<crate::model::LambdaExecutionParameters>,
}
impl std::fmt::Debug for LambdaFunctionRecipeSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionRecipeSource");
        formatter.field("lambda_arn", &self.lambda_arn);
        formatter.field("component_name", &self.component_name);
        formatter.field("component_version", &self.component_version);
        formatter.field("component_platforms", &self.component_platforms);
        formatter.field("component_dependencies", &self.component_dependencies);
        formatter.field(
            "component_lambda_parameters",
            &self.component_lambda_parameters,
        );
        formatter.finish()
    }
}
/// See [`LambdaFunctionRecipeSource`](crate::model::LambdaFunctionRecipeSource)
pub mod lambda_function_recipe_source {
    /// A builder for [`LambdaFunctionRecipeSource`](crate::model::LambdaFunctionRecipeSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_arn: std::option::Option<std::string::String>,
        pub(crate) component_name: std::option::Option<std::string::String>,
        pub(crate) component_version: std::option::Option<std::string::String>,
        pub(crate) component_platforms:
            std::option::Option<std::vec::Vec<crate::model::ComponentPlatform>>,
        pub(crate) component_dependencies: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::ComponentDependencyRequirement,
            >,
        >,
        pub(crate) component_lambda_parameters:
            std::option::Option<crate::model::LambdaExecutionParameters>,
    }
    impl Builder {
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda function. The ARN must include the version of the function to
        /// import. You can't use version aliases like <code>$LATEST</code>.</p>
        pub fn lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_arn = Some(input.into());
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda function. The ARN must include the version of the function to
        /// import. You can't use version aliases like <code>$LATEST</code>.</p>
        pub fn set_lambda_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_arn = input;
            self
        }
        /// <p>The name of the component.</p>
        /// <p>Defaults to the name of the Lambda function.</p>
        pub fn component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        /// <p>Defaults to the name of the Lambda function.</p>
        pub fn set_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_name = input;
            self
        }
        /// <p>The version of the component.</p>
        /// <p>Defaults to the version of the Lambda function as a semantic version. For example, if your
        /// function version is <code>3</code>, the component version becomes <code>3.0.0</code>.</p>
        pub fn component_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        /// <p>Defaults to the version of the Lambda function as a semantic version. For example, if your
        /// function version is <code>3</code>, the component version becomes <code>3.0.0</code>.</p>
        pub fn set_component_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_version = input;
            self
        }
        /// Appends an item to `component_platforms`.
        ///
        /// To override the contents of this collection use [`set_component_platforms`](Self::set_component_platforms).
        ///
        /// <p>The platforms that the component version supports.</p>
        pub fn component_platforms(
            mut self,
            input: impl Into<crate::model::ComponentPlatform>,
        ) -> Self {
            let mut v = self.component_platforms.unwrap_or_default();
            v.push(input.into());
            self.component_platforms = Some(v);
            self
        }
        /// <p>The platforms that the component version supports.</p>
        pub fn set_component_platforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentPlatform>>,
        ) -> Self {
            self.component_platforms = input;
            self
        }
        /// Adds a key-value pair to `component_dependencies`.
        ///
        /// To override the contents of this collection use [`set_component_dependencies`](Self::set_component_dependencies).
        ///
        /// <p>The component versions on which this Lambda function component depends.</p>
        pub fn component_dependencies(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ComponentDependencyRequirement>,
        ) -> Self {
            let mut hash_map = self.component_dependencies.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.component_dependencies = Some(hash_map);
            self
        }
        /// <p>The component versions on which this Lambda function component depends.</p>
        pub fn set_component_dependencies(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ComponentDependencyRequirement,
                >,
            >,
        ) -> Self {
            self.component_dependencies = input;
            self
        }
        /// <p>The system and runtime parameters for the Lambda function as it runs on the Greengrass core
        /// device.</p>
        pub fn component_lambda_parameters(
            mut self,
            input: crate::model::LambdaExecutionParameters,
        ) -> Self {
            self.component_lambda_parameters = Some(input);
            self
        }
        /// <p>The system and runtime parameters for the Lambda function as it runs on the Greengrass core
        /// device.</p>
        pub fn set_component_lambda_parameters(
            mut self,
            input: std::option::Option<crate::model::LambdaExecutionParameters>,
        ) -> Self {
            self.component_lambda_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionRecipeSource`](crate::model::LambdaFunctionRecipeSource)
        pub fn build(self) -> crate::model::LambdaFunctionRecipeSource {
            crate::model::LambdaFunctionRecipeSource {
                lambda_arn: self.lambda_arn,
                component_name: self.component_name,
                component_version: self.component_version,
                component_platforms: self.component_platforms,
                component_dependencies: self.component_dependencies,
                component_lambda_parameters: self.component_lambda_parameters,
            }
        }
    }
}
impl LambdaFunctionRecipeSource {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionRecipeSource`](crate::model::LambdaFunctionRecipeSource)
    pub fn builder() -> crate::model::lambda_function_recipe_source::Builder {
        crate::model::lambda_function_recipe_source::Builder::default()
    }
}

/// <p>Contains parameters for a Lambda function that runs on IoT Greengrass.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaExecutionParameters {
    /// <p>The list of event sources to which to subscribe to receive work messages. The Lambda
    /// function runs when it receives a message from an event source. You can subscribe this function
    /// to local publish/subscribe messages and Amazon Web Services IoT Core MQTT messages.</p>
    pub event_sources: std::option::Option<std::vec::Vec<crate::model::LambdaEventSource>>,
    /// <p>The maximum size of the message queue for the Lambda function component. The IoT Greengrass core
    /// stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to
    /// consume each message.</p>
    pub max_queue_size: std::option::Option<i32>,
    /// <p>The maximum number of instances that a non-pinned Lambda function can run at the same
    /// time.</p>
    pub max_instances_count: std::option::Option<i32>,
    /// <p>The maximum amount of time in seconds that a non-pinned Lambda function can idle before the
    /// IoT Greengrass Core software stops its process.</p>
    pub max_idle_time_in_seconds: std::option::Option<i32>,
    /// <p>The maximum amount of time in seconds that the Lambda function can process a work
    /// item.</p>
    pub timeout_in_seconds: std::option::Option<i32>,
    /// <p>The interval in seconds at which a pinned (also known as long-lived) Lambda function
    /// component sends status updates to the Lambda manager component.</p>
    pub status_timeout_in_seconds: std::option::Option<i32>,
    /// <p>Whether or not the Lambda function is pinned, or long-lived.</p>
    /// <ul>
    /// <li>
    /// <p>A pinned Lambda function starts
    /// when IoT Greengrass starts and keeps running in its own container.</p>
    /// </li>
    /// <li>
    /// <p>A non-pinned Lambda function starts only when it receives a work item and exists after
    /// it idles for <code>maxIdleTimeInSeconds</code>. If the function has multiple work items,
    /// the IoT Greengrass Core software creates multiple instances of the function.</p>
    /// </li>
    /// </ul>
    /// <p>Default: <code>true</code>
    /// </p>
    pub pinned: std::option::Option<bool>,
    /// <p>The encoding type that the Lambda function supports.</p>
    /// <p>Default: <code>json</code>
    /// </p>
    pub input_payload_encoding_type:
        std::option::Option<crate::model::LambdaInputPayloadEncodingType>,
    /// <p>The list of arguments to pass to the Lambda function when it runs.</p>
    pub exec_args: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The map of environment variables that are available to the Lambda function when it runs.</p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The parameters for the Linux process that contains the Lambda function.</p>
    pub linux_process_params: std::option::Option<crate::model::LambdaLinuxProcessParams>,
}
impl std::fmt::Debug for LambdaExecutionParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaExecutionParameters");
        formatter.field("event_sources", &self.event_sources);
        formatter.field("max_queue_size", &self.max_queue_size);
        formatter.field("max_instances_count", &self.max_instances_count);
        formatter.field("max_idle_time_in_seconds", &self.max_idle_time_in_seconds);
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("status_timeout_in_seconds", &self.status_timeout_in_seconds);
        formatter.field("pinned", &self.pinned);
        formatter.field(
            "input_payload_encoding_type",
            &self.input_payload_encoding_type,
        );
        formatter.field("exec_args", &self.exec_args);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.field("linux_process_params", &self.linux_process_params);
        formatter.finish()
    }
}
/// See [`LambdaExecutionParameters`](crate::model::LambdaExecutionParameters)
pub mod lambda_execution_parameters {
    /// A builder for [`LambdaExecutionParameters`](crate::model::LambdaExecutionParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_sources:
            std::option::Option<std::vec::Vec<crate::model::LambdaEventSource>>,
        pub(crate) max_queue_size: std::option::Option<i32>,
        pub(crate) max_instances_count: std::option::Option<i32>,
        pub(crate) max_idle_time_in_seconds: std::option::Option<i32>,
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
        pub(crate) status_timeout_in_seconds: std::option::Option<i32>,
        pub(crate) pinned: std::option::Option<bool>,
        pub(crate) input_payload_encoding_type:
            std::option::Option<crate::model::LambdaInputPayloadEncodingType>,
        pub(crate) exec_args: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) linux_process_params:
            std::option::Option<crate::model::LambdaLinuxProcessParams>,
    }
    impl Builder {
        /// Appends an item to `event_sources`.
        ///
        /// To override the contents of this collection use [`set_event_sources`](Self::set_event_sources).
        ///
        /// <p>The list of event sources to which to subscribe to receive work messages. The Lambda
        /// function runs when it receives a message from an event source. You can subscribe this function
        /// to local publish/subscribe messages and Amazon Web Services IoT Core MQTT messages.</p>
        pub fn event_sources(mut self, input: impl Into<crate::model::LambdaEventSource>) -> Self {
            let mut v = self.event_sources.unwrap_or_default();
            v.push(input.into());
            self.event_sources = Some(v);
            self
        }
        /// <p>The list of event sources to which to subscribe to receive work messages. The Lambda
        /// function runs when it receives a message from an event source. You can subscribe this function
        /// to local publish/subscribe messages and Amazon Web Services IoT Core MQTT messages.</p>
        pub fn set_event_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LambdaEventSource>>,
        ) -> Self {
            self.event_sources = input;
            self
        }
        /// <p>The maximum size of the message queue for the Lambda function component. The IoT Greengrass core
        /// stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to
        /// consume each message.</p>
        pub fn max_queue_size(mut self, input: i32) -> Self {
            self.max_queue_size = Some(input);
            self
        }
        /// <p>The maximum size of the message queue for the Lambda function component. The IoT Greengrass core
        /// stores messages in a FIFO (first-in-first-out) queue until it can run the Lambda function to
        /// consume each message.</p>
        pub fn set_max_queue_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_queue_size = input;
            self
        }
        /// <p>The maximum number of instances that a non-pinned Lambda function can run at the same
        /// time.</p>
        pub fn max_instances_count(mut self, input: i32) -> Self {
            self.max_instances_count = Some(input);
            self
        }
        /// <p>The maximum number of instances that a non-pinned Lambda function can run at the same
        /// time.</p>
        pub fn set_max_instances_count(mut self, input: std::option::Option<i32>) -> Self {
            self.max_instances_count = input;
            self
        }
        /// <p>The maximum amount of time in seconds that a non-pinned Lambda function can idle before the
        /// IoT Greengrass Core software stops its process.</p>
        pub fn max_idle_time_in_seconds(mut self, input: i32) -> Self {
            self.max_idle_time_in_seconds = Some(input);
            self
        }
        /// <p>The maximum amount of time in seconds that a non-pinned Lambda function can idle before the
        /// IoT Greengrass Core software stops its process.</p>
        pub fn set_max_idle_time_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.max_idle_time_in_seconds = input;
            self
        }
        /// <p>The maximum amount of time in seconds that the Lambda function can process a work
        /// item.</p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The maximum amount of time in seconds that the Lambda function can process a work
        /// item.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// <p>The interval in seconds at which a pinned (also known as long-lived) Lambda function
        /// component sends status updates to the Lambda manager component.</p>
        pub fn status_timeout_in_seconds(mut self, input: i32) -> Self {
            self.status_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The interval in seconds at which a pinned (also known as long-lived) Lambda function
        /// component sends status updates to the Lambda manager component.</p>
        pub fn set_status_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.status_timeout_in_seconds = input;
            self
        }
        /// <p>Whether or not the Lambda function is pinned, or long-lived.</p>
        /// <ul>
        /// <li>
        /// <p>A pinned Lambda function starts
        /// when IoT Greengrass starts and keeps running in its own container.</p>
        /// </li>
        /// <li>
        /// <p>A non-pinned Lambda function starts only when it receives a work item and exists after
        /// it idles for <code>maxIdleTimeInSeconds</code>. If the function has multiple work items,
        /// the IoT Greengrass Core software creates multiple instances of the function.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn pinned(mut self, input: bool) -> Self {
            self.pinned = Some(input);
            self
        }
        /// <p>Whether or not the Lambda function is pinned, or long-lived.</p>
        /// <ul>
        /// <li>
        /// <p>A pinned Lambda function starts
        /// when IoT Greengrass starts and keeps running in its own container.</p>
        /// </li>
        /// <li>
        /// <p>A non-pinned Lambda function starts only when it receives a work item and exists after
        /// it idles for <code>maxIdleTimeInSeconds</code>. If the function has multiple work items,
        /// the IoT Greengrass Core software creates multiple instances of the function.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_pinned(mut self, input: std::option::Option<bool>) -> Self {
            self.pinned = input;
            self
        }
        /// <p>The encoding type that the Lambda function supports.</p>
        /// <p>Default: <code>json</code>
        /// </p>
        pub fn input_payload_encoding_type(
            mut self,
            input: crate::model::LambdaInputPayloadEncodingType,
        ) -> Self {
            self.input_payload_encoding_type = Some(input);
            self
        }
        /// <p>The encoding type that the Lambda function supports.</p>
        /// <p>Default: <code>json</code>
        /// </p>
        pub fn set_input_payload_encoding_type(
            mut self,
            input: std::option::Option<crate::model::LambdaInputPayloadEncodingType>,
        ) -> Self {
            self.input_payload_encoding_type = input;
            self
        }
        /// Appends an item to `exec_args`.
        ///
        /// To override the contents of this collection use [`set_exec_args`](Self::set_exec_args).
        ///
        /// <p>The list of arguments to pass to the Lambda function when it runs.</p>
        pub fn exec_args(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exec_args.unwrap_or_default();
            v.push(input.into());
            self.exec_args = Some(v);
            self
        }
        /// <p>The list of arguments to pass to the Lambda function when it runs.</p>
        pub fn set_exec_args(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exec_args = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p>The map of environment variables that are available to the Lambda function when it runs.</p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p>The map of environment variables that are available to the Lambda function when it runs.</p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// <p>The parameters for the Linux process that contains the Lambda function.</p>
        pub fn linux_process_params(
            mut self,
            input: crate::model::LambdaLinuxProcessParams,
        ) -> Self {
            self.linux_process_params = Some(input);
            self
        }
        /// <p>The parameters for the Linux process that contains the Lambda function.</p>
        pub fn set_linux_process_params(
            mut self,
            input: std::option::Option<crate::model::LambdaLinuxProcessParams>,
        ) -> Self {
            self.linux_process_params = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaExecutionParameters`](crate::model::LambdaExecutionParameters)
        pub fn build(self) -> crate::model::LambdaExecutionParameters {
            crate::model::LambdaExecutionParameters {
                event_sources: self.event_sources,
                max_queue_size: self.max_queue_size,
                max_instances_count: self.max_instances_count,
                max_idle_time_in_seconds: self.max_idle_time_in_seconds,
                timeout_in_seconds: self.timeout_in_seconds,
                status_timeout_in_seconds: self.status_timeout_in_seconds,
                pinned: self.pinned,
                input_payload_encoding_type: self.input_payload_encoding_type,
                exec_args: self.exec_args,
                environment_variables: self.environment_variables,
                linux_process_params: self.linux_process_params,
            }
        }
    }
}
impl LambdaExecutionParameters {
    /// Creates a new builder-style object to manufacture [`LambdaExecutionParameters`](crate::model::LambdaExecutionParameters)
    pub fn builder() -> crate::model::lambda_execution_parameters::Builder {
        crate::model::lambda_execution_parameters::Builder::default()
    }
}

/// <p>Contains parameters for a Linux process that contains an Lambda function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaLinuxProcessParams {
    /// <p>The isolation mode for the process that contains the Lambda function. The process can run
    /// in an isolated runtime environment inside the IoT Greengrass container, or as a regular process outside
    /// any container.</p>
    /// <p>Default: <code>GreengrassContainer</code>
    /// </p>
    pub isolation_mode: std::option::Option<crate::model::LambdaIsolationMode>,
    /// <p>The parameters for the container in which the Lambda function runs.</p>
    pub container_params: std::option::Option<crate::model::LambdaContainerParams>,
}
impl std::fmt::Debug for LambdaLinuxProcessParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaLinuxProcessParams");
        formatter.field("isolation_mode", &self.isolation_mode);
        formatter.field("container_params", &self.container_params);
        formatter.finish()
    }
}
/// See [`LambdaLinuxProcessParams`](crate::model::LambdaLinuxProcessParams)
pub mod lambda_linux_process_params {
    /// A builder for [`LambdaLinuxProcessParams`](crate::model::LambdaLinuxProcessParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) isolation_mode: std::option::Option<crate::model::LambdaIsolationMode>,
        pub(crate) container_params: std::option::Option<crate::model::LambdaContainerParams>,
    }
    impl Builder {
        /// <p>The isolation mode for the process that contains the Lambda function. The process can run
        /// in an isolated runtime environment inside the IoT Greengrass container, or as a regular process outside
        /// any container.</p>
        /// <p>Default: <code>GreengrassContainer</code>
        /// </p>
        pub fn isolation_mode(mut self, input: crate::model::LambdaIsolationMode) -> Self {
            self.isolation_mode = Some(input);
            self
        }
        /// <p>The isolation mode for the process that contains the Lambda function. The process can run
        /// in an isolated runtime environment inside the IoT Greengrass container, or as a regular process outside
        /// any container.</p>
        /// <p>Default: <code>GreengrassContainer</code>
        /// </p>
        pub fn set_isolation_mode(
            mut self,
            input: std::option::Option<crate::model::LambdaIsolationMode>,
        ) -> Self {
            self.isolation_mode = input;
            self
        }
        /// <p>The parameters for the container in which the Lambda function runs.</p>
        pub fn container_params(mut self, input: crate::model::LambdaContainerParams) -> Self {
            self.container_params = Some(input);
            self
        }
        /// <p>The parameters for the container in which the Lambda function runs.</p>
        pub fn set_container_params(
            mut self,
            input: std::option::Option<crate::model::LambdaContainerParams>,
        ) -> Self {
            self.container_params = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaLinuxProcessParams`](crate::model::LambdaLinuxProcessParams)
        pub fn build(self) -> crate::model::LambdaLinuxProcessParams {
            crate::model::LambdaLinuxProcessParams {
                isolation_mode: self.isolation_mode,
                container_params: self.container_params,
            }
        }
    }
}
impl LambdaLinuxProcessParams {
    /// Creates a new builder-style object to manufacture [`LambdaLinuxProcessParams`](crate::model::LambdaLinuxProcessParams)
    pub fn builder() -> crate::model::lambda_linux_process_params::Builder {
        crate::model::lambda_linux_process_params::Builder::default()
    }
}

/// <p>Contains information about a container in which Lambda functions run on Greengrass core
/// devices.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaContainerParams {
    /// <p>The memory size of the container, expressed in kilobytes.</p>
    /// <p>Default: <code>16384</code> (16 MB)</p>
    pub memory_size_in_kb: std::option::Option<i32>,
    /// <p>Whether or not the container can read information from the device's <code>/sys</code>
    /// folder.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub mount_ro_sysfs: std::option::Option<bool>,
    /// <p>The list of volumes that the container can access.</p>
    pub volumes: std::option::Option<std::vec::Vec<crate::model::LambdaVolumeMount>>,
    /// <p>The list of system devices that the container can access.</p>
    pub devices: std::option::Option<std::vec::Vec<crate::model::LambdaDeviceMount>>,
}
impl std::fmt::Debug for LambdaContainerParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaContainerParams");
        formatter.field("memory_size_in_kb", &self.memory_size_in_kb);
        formatter.field("mount_ro_sysfs", &self.mount_ro_sysfs);
        formatter.field("volumes", &self.volumes);
        formatter.field("devices", &self.devices);
        formatter.finish()
    }
}
/// See [`LambdaContainerParams`](crate::model::LambdaContainerParams)
pub mod lambda_container_params {
    /// A builder for [`LambdaContainerParams`](crate::model::LambdaContainerParams)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) memory_size_in_kb: std::option::Option<i32>,
        pub(crate) mount_ro_sysfs: std::option::Option<bool>,
        pub(crate) volumes: std::option::Option<std::vec::Vec<crate::model::LambdaVolumeMount>>,
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::LambdaDeviceMount>>,
    }
    impl Builder {
        /// <p>The memory size of the container, expressed in kilobytes.</p>
        /// <p>Default: <code>16384</code> (16 MB)</p>
        pub fn memory_size_in_kb(mut self, input: i32) -> Self {
            self.memory_size_in_kb = Some(input);
            self
        }
        /// <p>The memory size of the container, expressed in kilobytes.</p>
        /// <p>Default: <code>16384</code> (16 MB)</p>
        pub fn set_memory_size_in_kb(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size_in_kb = input;
            self
        }
        /// <p>Whether or not the container can read information from the device's <code>/sys</code>
        /// folder.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn mount_ro_sysfs(mut self, input: bool) -> Self {
            self.mount_ro_sysfs = Some(input);
            self
        }
        /// <p>Whether or not the container can read information from the device's <code>/sys</code>
        /// folder.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_mount_ro_sysfs(mut self, input: std::option::Option<bool>) -> Self {
            self.mount_ro_sysfs = input;
            self
        }
        /// Appends an item to `volumes`.
        ///
        /// To override the contents of this collection use [`set_volumes`](Self::set_volumes).
        ///
        /// <p>The list of volumes that the container can access.</p>
        pub fn volumes(mut self, input: impl Into<crate::model::LambdaVolumeMount>) -> Self {
            let mut v = self.volumes.unwrap_or_default();
            v.push(input.into());
            self.volumes = Some(v);
            self
        }
        /// <p>The list of volumes that the container can access.</p>
        pub fn set_volumes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LambdaVolumeMount>>,
        ) -> Self {
            self.volumes = input;
            self
        }
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>The list of system devices that the container can access.</p>
        pub fn devices(mut self, input: impl Into<crate::model::LambdaDeviceMount>) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input.into());
            self.devices = Some(v);
            self
        }
        /// <p>The list of system devices that the container can access.</p>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LambdaDeviceMount>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaContainerParams`](crate::model::LambdaContainerParams)
        pub fn build(self) -> crate::model::LambdaContainerParams {
            crate::model::LambdaContainerParams {
                memory_size_in_kb: self.memory_size_in_kb,
                mount_ro_sysfs: self.mount_ro_sysfs,
                volumes: self.volumes,
                devices: self.devices,
            }
        }
    }
}
impl LambdaContainerParams {
    /// Creates a new builder-style object to manufacture [`LambdaContainerParams`](crate::model::LambdaContainerParams)
    pub fn builder() -> crate::model::lambda_container_params::Builder {
        crate::model::lambda_container_params::Builder::default()
    }
}

/// <p>Contains information about a device that Linux processes in a container can access.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaDeviceMount {
    /// <p>The mount path for the device in the file system.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The permission to access the device: read/only (<code>ro</code>) or read/write
    /// (<code>rw</code>).</p>
    /// <p>Default: <code>ro</code>
    /// </p>
    pub permission: std::option::Option<crate::model::LambdaFilesystemPermission>,
    /// <p>Whether or not to add the component's system user as an owner of the device.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub add_group_owner: std::option::Option<bool>,
}
impl std::fmt::Debug for LambdaDeviceMount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaDeviceMount");
        formatter.field("path", &self.path);
        formatter.field("permission", &self.permission);
        formatter.field("add_group_owner", &self.add_group_owner);
        formatter.finish()
    }
}
/// See [`LambdaDeviceMount`](crate::model::LambdaDeviceMount)
pub mod lambda_device_mount {
    /// A builder for [`LambdaDeviceMount`](crate::model::LambdaDeviceMount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) permission: std::option::Option<crate::model::LambdaFilesystemPermission>,
        pub(crate) add_group_owner: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The mount path for the device in the file system.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The mount path for the device in the file system.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The permission to access the device: read/only (<code>ro</code>) or read/write
        /// (<code>rw</code>).</p>
        /// <p>Default: <code>ro</code>
        /// </p>
        pub fn permission(mut self, input: crate::model::LambdaFilesystemPermission) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p>The permission to access the device: read/only (<code>ro</code>) or read/write
        /// (<code>rw</code>).</p>
        /// <p>Default: <code>ro</code>
        /// </p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::LambdaFilesystemPermission>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// <p>Whether or not to add the component's system user as an owner of the device.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn add_group_owner(mut self, input: bool) -> Self {
            self.add_group_owner = Some(input);
            self
        }
        /// <p>Whether or not to add the component's system user as an owner of the device.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_add_group_owner(mut self, input: std::option::Option<bool>) -> Self {
            self.add_group_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaDeviceMount`](crate::model::LambdaDeviceMount)
        pub fn build(self) -> crate::model::LambdaDeviceMount {
            crate::model::LambdaDeviceMount {
                path: self.path,
                permission: self.permission,
                add_group_owner: self.add_group_owner,
            }
        }
    }
}
impl LambdaDeviceMount {
    /// Creates a new builder-style object to manufacture [`LambdaDeviceMount`](crate::model::LambdaDeviceMount)
    pub fn builder() -> crate::model::lambda_device_mount::Builder {
        crate::model::lambda_device_mount::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaFilesystemPermission {
    #[allow(missing_docs)] // documentation missing in model
    Ro,
    #[allow(missing_docs)] // documentation missing in model
    Rw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaFilesystemPermission {
    fn from(s: &str) -> Self {
        match s {
            "ro" => LambdaFilesystemPermission::Ro,
            "rw" => LambdaFilesystemPermission::Rw,
            other => LambdaFilesystemPermission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaFilesystemPermission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaFilesystemPermission::from(s))
    }
}
impl LambdaFilesystemPermission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaFilesystemPermission::Ro => "ro",
            LambdaFilesystemPermission::Rw => "rw",
            LambdaFilesystemPermission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ro", "rw"]
    }
}
impl AsRef<str> for LambdaFilesystemPermission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a volume that Linux processes in a container can access. When
/// you define a volume, the IoT Greengrass Core software mounts the source files to the destination inside the
/// container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaVolumeMount {
    /// <p>The path to the physical volume in the file system.</p>
    pub source_path: std::option::Option<std::string::String>,
    /// <p>The path to the logical volume in the file system.</p>
    pub destination_path: std::option::Option<std::string::String>,
    /// <p>The permission to access the volume: read/only (<code>ro</code>) or read/write
    /// (<code>rw</code>).</p>
    /// <p>Default: <code>ro</code>
    /// </p>
    pub permission: std::option::Option<crate::model::LambdaFilesystemPermission>,
    /// <p>Whether or not to add the IoT Greengrass user group as an owner of the volume.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub add_group_owner: std::option::Option<bool>,
}
impl std::fmt::Debug for LambdaVolumeMount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaVolumeMount");
        formatter.field("source_path", &self.source_path);
        formatter.field("destination_path", &self.destination_path);
        formatter.field("permission", &self.permission);
        formatter.field("add_group_owner", &self.add_group_owner);
        formatter.finish()
    }
}
/// See [`LambdaVolumeMount`](crate::model::LambdaVolumeMount)
pub mod lambda_volume_mount {
    /// A builder for [`LambdaVolumeMount`](crate::model::LambdaVolumeMount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_path: std::option::Option<std::string::String>,
        pub(crate) destination_path: std::option::Option<std::string::String>,
        pub(crate) permission: std::option::Option<crate::model::LambdaFilesystemPermission>,
        pub(crate) add_group_owner: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The path to the physical volume in the file system.</p>
        pub fn source_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_path = Some(input.into());
            self
        }
        /// <p>The path to the physical volume in the file system.</p>
        pub fn set_source_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_path = input;
            self
        }
        /// <p>The path to the logical volume in the file system.</p>
        pub fn destination_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_path = Some(input.into());
            self
        }
        /// <p>The path to the logical volume in the file system.</p>
        pub fn set_destination_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_path = input;
            self
        }
        /// <p>The permission to access the volume: read/only (<code>ro</code>) or read/write
        /// (<code>rw</code>).</p>
        /// <p>Default: <code>ro</code>
        /// </p>
        pub fn permission(mut self, input: crate::model::LambdaFilesystemPermission) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p>The permission to access the volume: read/only (<code>ro</code>) or read/write
        /// (<code>rw</code>).</p>
        /// <p>Default: <code>ro</code>
        /// </p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::LambdaFilesystemPermission>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// <p>Whether or not to add the IoT Greengrass user group as an owner of the volume.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn add_group_owner(mut self, input: bool) -> Self {
            self.add_group_owner = Some(input);
            self
        }
        /// <p>Whether or not to add the IoT Greengrass user group as an owner of the volume.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_add_group_owner(mut self, input: std::option::Option<bool>) -> Self {
            self.add_group_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaVolumeMount`](crate::model::LambdaVolumeMount)
        pub fn build(self) -> crate::model::LambdaVolumeMount {
            crate::model::LambdaVolumeMount {
                source_path: self.source_path,
                destination_path: self.destination_path,
                permission: self.permission,
                add_group_owner: self.add_group_owner,
            }
        }
    }
}
impl LambdaVolumeMount {
    /// Creates a new builder-style object to manufacture [`LambdaVolumeMount`](crate::model::LambdaVolumeMount)
    pub fn builder() -> crate::model::lambda_volume_mount::Builder {
        crate::model::lambda_volume_mount::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaIsolationMode {
    #[allow(missing_docs)] // documentation missing in model
    GreengrassContainer,
    #[allow(missing_docs)] // documentation missing in model
    NoContainer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaIsolationMode {
    fn from(s: &str) -> Self {
        match s {
            "GreengrassContainer" => LambdaIsolationMode::GreengrassContainer,
            "NoContainer" => LambdaIsolationMode::NoContainer,
            other => LambdaIsolationMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaIsolationMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaIsolationMode::from(s))
    }
}
impl LambdaIsolationMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaIsolationMode::GreengrassContainer => "GreengrassContainer",
            LambdaIsolationMode::NoContainer => "NoContainer",
            LambdaIsolationMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GreengrassContainer", "NoContainer"]
    }
}
impl AsRef<str> for LambdaIsolationMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaInputPayloadEncodingType {
    #[allow(missing_docs)] // documentation missing in model
    Binary,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaInputPayloadEncodingType {
    fn from(s: &str) -> Self {
        match s {
            "binary" => LambdaInputPayloadEncodingType::Binary,
            "json" => LambdaInputPayloadEncodingType::Json,
            other => LambdaInputPayloadEncodingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaInputPayloadEncodingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaInputPayloadEncodingType::from(s))
    }
}
impl LambdaInputPayloadEncodingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaInputPayloadEncodingType::Binary => "binary",
            LambdaInputPayloadEncodingType::Json => "json",
            LambdaInputPayloadEncodingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["binary", "json"]
    }
}
impl AsRef<str> for LambdaInputPayloadEncodingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an event source for an Lambda function. The event source
/// defines the topics on which this Lambda function subscribes to receive messages that run the
/// function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaEventSource {
    /// <p>The topic to which to subscribe to receive event messages.</p>
    pub topic: std::option::Option<std::string::String>,
    /// <p>The type of event source. Choose from the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PUB_SUB</code> – Subscribe to local publish/subscribe messages. This event
    /// source type doesn't support MQTT wildcards (<code>+</code> and <code>#</code>) in the
    /// event source topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IOT_CORE</code> – Subscribe to Amazon Web Services IoT Core MQTT messages. This event source
    /// type supports MQTT wildcards (<code>+</code> and <code>#</code>) in the event source
    /// topic.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::LambdaEventSourceType>,
}
impl std::fmt::Debug for LambdaEventSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaEventSource");
        formatter.field("topic", &self.topic);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`LambdaEventSource`](crate::model::LambdaEventSource)
pub mod lambda_event_source {
    /// A builder for [`LambdaEventSource`](crate::model::LambdaEventSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::LambdaEventSourceType>,
    }
    impl Builder {
        /// <p>The topic to which to subscribe to receive event messages.</p>
        pub fn topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic = Some(input.into());
            self
        }
        /// <p>The topic to which to subscribe to receive event messages.</p>
        pub fn set_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic = input;
            self
        }
        /// <p>The type of event source. Choose from the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PUB_SUB</code> – Subscribe to local publish/subscribe messages. This event
        /// source type doesn't support MQTT wildcards (<code>+</code> and <code>#</code>) in the
        /// event source topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IOT_CORE</code> – Subscribe to Amazon Web Services IoT Core MQTT messages. This event source
        /// type supports MQTT wildcards (<code>+</code> and <code>#</code>) in the event source
        /// topic.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::LambdaEventSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of event source. Choose from the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PUB_SUB</code> – Subscribe to local publish/subscribe messages. This event
        /// source type doesn't support MQTT wildcards (<code>+</code> and <code>#</code>) in the
        /// event source topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IOT_CORE</code> – Subscribe to Amazon Web Services IoT Core MQTT messages. This event source
        /// type supports MQTT wildcards (<code>+</code> and <code>#</code>) in the event source
        /// topic.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::LambdaEventSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaEventSource`](crate::model::LambdaEventSource)
        pub fn build(self) -> crate::model::LambdaEventSource {
            crate::model::LambdaEventSource {
                topic: self.topic,
                r#type: self.r#type,
            }
        }
    }
}
impl LambdaEventSource {
    /// Creates a new builder-style object to manufacture [`LambdaEventSource`](crate::model::LambdaEventSource)
    pub fn builder() -> crate::model::lambda_event_source::Builder {
        crate::model::lambda_event_source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LambdaEventSourceType {
    #[allow(missing_docs)] // documentation missing in model
    IotCore,
    #[allow(missing_docs)] // documentation missing in model
    PubSub,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LambdaEventSourceType {
    fn from(s: &str) -> Self {
        match s {
            "IOT_CORE" => LambdaEventSourceType::IotCore,
            "PUB_SUB" => LambdaEventSourceType::PubSub,
            other => LambdaEventSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LambdaEventSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LambdaEventSourceType::from(s))
    }
}
impl LambdaEventSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LambdaEventSourceType::IotCore => "IOT_CORE",
            LambdaEventSourceType::PubSub => "PUB_SUB",
            LambdaEventSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IOT_CORE", "PUB_SUB"]
    }
}
impl AsRef<str> for LambdaEventSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a component dependency for a Lambda function component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentDependencyRequirement {
    /// <p>The component version requirement for the component dependency.</p>
    /// <p>IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning</a>.</p>
    pub version_requirement: std::option::Option<std::string::String>,
    /// <p>The type of this dependency. Choose from the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SOFT</code> – The component doesn't restart if the dependency changes
    /// state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HARD</code> – The component restarts if the dependency changes
    /// state.</p>
    /// </li>
    /// </ul>
    /// <p>Default: <code>HARD</code>
    /// </p>
    pub dependency_type: std::option::Option<crate::model::ComponentDependencyType>,
}
impl std::fmt::Debug for ComponentDependencyRequirement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentDependencyRequirement");
        formatter.field("version_requirement", &self.version_requirement);
        formatter.field("dependency_type", &self.dependency_type);
        formatter.finish()
    }
}
/// See [`ComponentDependencyRequirement`](crate::model::ComponentDependencyRequirement)
pub mod component_dependency_requirement {
    /// A builder for [`ComponentDependencyRequirement`](crate::model::ComponentDependencyRequirement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_requirement: std::option::Option<std::string::String>,
        pub(crate) dependency_type: std::option::Option<crate::model::ComponentDependencyType>,
    }
    impl Builder {
        /// <p>The component version requirement for the component dependency.</p>
        /// <p>IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning</a>.</p>
        pub fn version_requirement(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_requirement = Some(input.into());
            self
        }
        /// <p>The component version requirement for the component dependency.</p>
        /// <p>IoT Greengrass V2 uses semantic version constraints. For more information, see <a href="https://semver.org/">Semantic Versioning</a>.</p>
        pub fn set_version_requirement(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_requirement = input;
            self
        }
        /// <p>The type of this dependency. Choose from the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SOFT</code> – The component doesn't restart if the dependency changes
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HARD</code> – The component restarts if the dependency changes
        /// state.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>HARD</code>
        /// </p>
        pub fn dependency_type(mut self, input: crate::model::ComponentDependencyType) -> Self {
            self.dependency_type = Some(input);
            self
        }
        /// <p>The type of this dependency. Choose from the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SOFT</code> – The component doesn't restart if the dependency changes
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HARD</code> – The component restarts if the dependency changes
        /// state.</p>
        /// </li>
        /// </ul>
        /// <p>Default: <code>HARD</code>
        /// </p>
        pub fn set_dependency_type(
            mut self,
            input: std::option::Option<crate::model::ComponentDependencyType>,
        ) -> Self {
            self.dependency_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentDependencyRequirement`](crate::model::ComponentDependencyRequirement)
        pub fn build(self) -> crate::model::ComponentDependencyRequirement {
            crate::model::ComponentDependencyRequirement {
                version_requirement: self.version_requirement,
                dependency_type: self.dependency_type,
            }
        }
    }
}
impl ComponentDependencyRequirement {
    /// Creates a new builder-style object to manufacture [`ComponentDependencyRequirement`](crate::model::ComponentDependencyRequirement)
    pub fn builder() -> crate::model::component_dependency_requirement::Builder {
        crate::model::component_dependency_requirement::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComponentDependencyType {
    #[allow(missing_docs)] // documentation missing in model
    Hard,
    #[allow(missing_docs)] // documentation missing in model
    Soft,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComponentDependencyType {
    fn from(s: &str) -> Self {
        match s {
            "HARD" => ComponentDependencyType::Hard,
            "SOFT" => ComponentDependencyType::Soft,
            other => ComponentDependencyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComponentDependencyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComponentDependencyType::from(s))
    }
}
impl ComponentDependencyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComponentDependencyType::Hard => "HARD",
            ComponentDependencyType::Soft => "SOFT",
            ComponentDependencyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HARD", "SOFT"]
    }
}
impl AsRef<str> for ComponentDependencyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains an error that occurs from a request to disassociate a client device from a core
/// device. The <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchDisassociateClientDeviceWithCoreDevice.html">BatchDisassociateClientDeviceWithCoreDevice</a> operation returns a list of these
/// errors.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateClientDeviceFromCoreDeviceErrorEntry {
    /// <p>The name of the IoT thing whose disassociate request failed.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The error code for the request.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A message that provides additional information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateClientDeviceFromCoreDeviceErrorEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateClientDeviceFromCoreDeviceErrorEntry");
        formatter.field("thing_name", &self.thing_name);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DisassociateClientDeviceFromCoreDeviceErrorEntry`](crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry)
pub mod disassociate_client_device_from_core_device_error_entry {
    /// A builder for [`DisassociateClientDeviceFromCoreDeviceErrorEntry`](crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IoT thing whose disassociate request failed.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT thing whose disassociate request failed.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The error code for the request.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code for the request.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A message that provides additional information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides additional information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateClientDeviceFromCoreDeviceErrorEntry`](crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry)
        pub fn build(self) -> crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry {
            crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry {
                thing_name: self.thing_name,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl DisassociateClientDeviceFromCoreDeviceErrorEntry {
    /// Creates a new builder-style object to manufacture [`DisassociateClientDeviceFromCoreDeviceErrorEntry`](crate::model::DisassociateClientDeviceFromCoreDeviceErrorEntry)
    pub fn builder(
    ) -> crate::model::disassociate_client_device_from_core_device_error_entry::Builder {
        crate::model::disassociate_client_device_from_core_device_error_entry::Builder::default()
    }
}

/// <p>Contains a request to disassociate a client device from a core device. The <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchDisassociateClientDeviceWithCoreDevice.html">BatchDisassociateClientDeviceWithCoreDevice</a> operation consumes a list of these
/// requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateClientDeviceFromCoreDeviceEntry {
    /// <p>The name of the IoT thing that represents the client device to disassociate.</p>
    pub thing_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateClientDeviceFromCoreDeviceEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateClientDeviceFromCoreDeviceEntry");
        formatter.field("thing_name", &self.thing_name);
        formatter.finish()
    }
}
/// See [`DisassociateClientDeviceFromCoreDeviceEntry`](crate::model::DisassociateClientDeviceFromCoreDeviceEntry)
pub mod disassociate_client_device_from_core_device_entry {
    /// A builder for [`DisassociateClientDeviceFromCoreDeviceEntry`](crate::model::DisassociateClientDeviceFromCoreDeviceEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IoT thing that represents the client device to disassociate.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT thing that represents the client device to disassociate.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateClientDeviceFromCoreDeviceEntry`](crate::model::DisassociateClientDeviceFromCoreDeviceEntry)
        pub fn build(self) -> crate::model::DisassociateClientDeviceFromCoreDeviceEntry {
            crate::model::DisassociateClientDeviceFromCoreDeviceEntry {
                thing_name: self.thing_name,
            }
        }
    }
}
impl DisassociateClientDeviceFromCoreDeviceEntry {
    /// Creates a new builder-style object to manufacture [`DisassociateClientDeviceFromCoreDeviceEntry`](crate::model::DisassociateClientDeviceFromCoreDeviceEntry)
    pub fn builder() -> crate::model::disassociate_client_device_from_core_device_entry::Builder {
        crate::model::disassociate_client_device_from_core_device_entry::Builder::default()
    }
}

/// <p>Contains an error that occurs from a request to associate a client device with a core
/// device. The <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchAssociateClientDeviceWithCoreDevice.html">BatchAssociateClientDeviceWithCoreDevice</a> operation returns a list of these
/// errors.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateClientDeviceWithCoreDeviceErrorEntry {
    /// <p>The name of the IoT thing whose associate request failed.</p>
    pub thing_name: std::option::Option<std::string::String>,
    /// <p>The error code for the request.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A message that provides additional information about the error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateClientDeviceWithCoreDeviceErrorEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateClientDeviceWithCoreDeviceErrorEntry");
        formatter.field("thing_name", &self.thing_name);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`AssociateClientDeviceWithCoreDeviceErrorEntry`](crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry)
pub mod associate_client_device_with_core_device_error_entry {
    /// A builder for [`AssociateClientDeviceWithCoreDeviceErrorEntry`](crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IoT thing whose associate request failed.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT thing whose associate request failed.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// <p>The error code for the request.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code for the request.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A message that provides additional information about the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides additional information about the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateClientDeviceWithCoreDeviceErrorEntry`](crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry)
        pub fn build(self) -> crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry {
            crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry {
                thing_name: self.thing_name,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl AssociateClientDeviceWithCoreDeviceErrorEntry {
    /// Creates a new builder-style object to manufacture [`AssociateClientDeviceWithCoreDeviceErrorEntry`](crate::model::AssociateClientDeviceWithCoreDeviceErrorEntry)
    pub fn builder() -> crate::model::associate_client_device_with_core_device_error_entry::Builder
    {
        crate::model::associate_client_device_with_core_device_error_entry::Builder::default()
    }
}

/// <p>Contains a request to associate a client device with a core device. The <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_BatchAssociateClientDeviceWithCoreDevice.html">BatchAssociateClientDeviceWithCoreDevice</a> operation consumes a list of these
/// requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateClientDeviceWithCoreDeviceEntry {
    /// <p>The name of the IoT thing that represents the client device to associate.</p>
    pub thing_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateClientDeviceWithCoreDeviceEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateClientDeviceWithCoreDeviceEntry");
        formatter.field("thing_name", &self.thing_name);
        formatter.finish()
    }
}
/// See [`AssociateClientDeviceWithCoreDeviceEntry`](crate::model::AssociateClientDeviceWithCoreDeviceEntry)
pub mod associate_client_device_with_core_device_entry {
    /// A builder for [`AssociateClientDeviceWithCoreDeviceEntry`](crate::model::AssociateClientDeviceWithCoreDeviceEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IoT thing that represents the client device to associate.</p>
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// <p>The name of the IoT thing that represents the client device to associate.</p>
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateClientDeviceWithCoreDeviceEntry`](crate::model::AssociateClientDeviceWithCoreDeviceEntry)
        pub fn build(self) -> crate::model::AssociateClientDeviceWithCoreDeviceEntry {
            crate::model::AssociateClientDeviceWithCoreDeviceEntry {
                thing_name: self.thing_name,
            }
        }
    }
}
impl AssociateClientDeviceWithCoreDeviceEntry {
    /// Creates a new builder-style object to manufacture [`AssociateClientDeviceWithCoreDeviceEntry`](crate::model::AssociateClientDeviceWithCoreDeviceEntry)
    pub fn builder() -> crate::model::associate_client_device_with_core_device_entry::Builder {
        crate::model::associate_client_device_with_core_device_entry::Builder::default()
    }
}
