// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateRoleToGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_role_to_group`](crate::client::Client::associate_role_to_group).
///
/// See [`crate::client::fluent_builders::AssociateRoleToGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateRoleToGroup {
    _private: (),
}
impl AssociateRoleToGroup {
    /// Creates a new builder-style object to manufacture [`AssociateRoleToGroupInput`](crate::input::AssociateRoleToGroupInput)
    pub fn builder() -> crate::input::associate_role_to_group_input::Builder {
        crate::input::associate_role_to_group_input::Builder::default()
    }
    /// Creates a new `AssociateRoleToGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateRoleToGroup {
    type Output = std::result::Result<
        crate::output::AssociateRoleToGroupOutput,
        crate::error::AssociateRoleToGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_role_to_group_error(response)
        } else {
            crate::operation_deser::parse_associate_role_to_group_response(response)
        }
    }
}

/// Operation shape for `AssociateServiceRoleToAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_service_role_to_account`](crate::client::Client::associate_service_role_to_account).
///
/// See [`crate::client::fluent_builders::AssociateServiceRoleToAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateServiceRoleToAccount {
    _private: (),
}
impl AssociateServiceRoleToAccount {
    /// Creates a new builder-style object to manufacture [`AssociateServiceRoleToAccountInput`](crate::input::AssociateServiceRoleToAccountInput)
    pub fn builder() -> crate::input::associate_service_role_to_account_input::Builder {
        crate::input::associate_service_role_to_account_input::Builder::default()
    }
    /// Creates a new `AssociateServiceRoleToAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateServiceRoleToAccount {
    type Output = std::result::Result<
        crate::output::AssociateServiceRoleToAccountOutput,
        crate::error::AssociateServiceRoleToAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_service_role_to_account_error(response)
        } else {
            crate::operation_deser::parse_associate_service_role_to_account_response(response)
        }
    }
}

/// Operation shape for `CreateConnectorDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connector_definition`](crate::client::Client::create_connector_definition).
///
/// See [`crate::client::fluent_builders::CreateConnectorDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnectorDefinition {
    _private: (),
}
impl CreateConnectorDefinition {
    /// Creates a new builder-style object to manufacture [`CreateConnectorDefinitionInput`](crate::input::CreateConnectorDefinitionInput)
    pub fn builder() -> crate::input::create_connector_definition_input::Builder {
        crate::input::create_connector_definition_input::Builder::default()
    }
    /// Creates a new `CreateConnectorDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnectorDefinition {
    type Output = std::result::Result<
        crate::output::CreateConnectorDefinitionOutput,
        crate::error::CreateConnectorDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connector_definition_error(response)
        } else {
            crate::operation_deser::parse_create_connector_definition_response(response)
        }
    }
}

/// Operation shape for `CreateConnectorDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connector_definition_version`](crate::client::Client::create_connector_definition_version).
///
/// See [`crate::client::fluent_builders::CreateConnectorDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnectorDefinitionVersion {
    _private: (),
}
impl CreateConnectorDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`CreateConnectorDefinitionVersionInput`](crate::input::CreateConnectorDefinitionVersionInput)
    pub fn builder() -> crate::input::create_connector_definition_version_input::Builder {
        crate::input::create_connector_definition_version_input::Builder::default()
    }
    /// Creates a new `CreateConnectorDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnectorDefinitionVersion {
    type Output = std::result::Result<
        crate::output::CreateConnectorDefinitionVersionOutput,
        crate::error::CreateConnectorDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connector_definition_version_error(response)
        } else {
            crate::operation_deser::parse_create_connector_definition_version_response(response)
        }
    }
}

/// Operation shape for `CreateCoreDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_core_definition`](crate::client::Client::create_core_definition).
///
/// See [`crate::client::fluent_builders::CreateCoreDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCoreDefinition {
    _private: (),
}
impl CreateCoreDefinition {
    /// Creates a new builder-style object to manufacture [`CreateCoreDefinitionInput`](crate::input::CreateCoreDefinitionInput)
    pub fn builder() -> crate::input::create_core_definition_input::Builder {
        crate::input::create_core_definition_input::Builder::default()
    }
    /// Creates a new `CreateCoreDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCoreDefinition {
    type Output = std::result::Result<
        crate::output::CreateCoreDefinitionOutput,
        crate::error::CreateCoreDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_core_definition_error(response)
        } else {
            crate::operation_deser::parse_create_core_definition_response(response)
        }
    }
}

/// Operation shape for `CreateCoreDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_core_definition_version`](crate::client::Client::create_core_definition_version).
///
/// See [`crate::client::fluent_builders::CreateCoreDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCoreDefinitionVersion {
    _private: (),
}
impl CreateCoreDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`CreateCoreDefinitionVersionInput`](crate::input::CreateCoreDefinitionVersionInput)
    pub fn builder() -> crate::input::create_core_definition_version_input::Builder {
        crate::input::create_core_definition_version_input::Builder::default()
    }
    /// Creates a new `CreateCoreDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCoreDefinitionVersion {
    type Output = std::result::Result<
        crate::output::CreateCoreDefinitionVersionOutput,
        crate::error::CreateCoreDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_core_definition_version_error(response)
        } else {
            crate::operation_deser::parse_create_core_definition_version_response(response)
        }
    }
}

/// Operation shape for `CreateDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_deployment`](crate::client::Client::create_deployment).
///
/// See [`crate::client::fluent_builders::CreateDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeployment {
    _private: (),
}
impl CreateDeployment {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
    /// Creates a new `CreateDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeployment {
    type Output = std::result::Result<
        crate::output::CreateDeploymentOutput,
        crate::error::CreateDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_deployment_error(response)
        } else {
            crate::operation_deser::parse_create_deployment_response(response)
        }
    }
}

/// Operation shape for `CreateDeviceDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_device_definition`](crate::client::Client::create_device_definition).
///
/// See [`crate::client::fluent_builders::CreateDeviceDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeviceDefinition {
    _private: (),
}
impl CreateDeviceDefinition {
    /// Creates a new builder-style object to manufacture [`CreateDeviceDefinitionInput`](crate::input::CreateDeviceDefinitionInput)
    pub fn builder() -> crate::input::create_device_definition_input::Builder {
        crate::input::create_device_definition_input::Builder::default()
    }
    /// Creates a new `CreateDeviceDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeviceDefinition {
    type Output = std::result::Result<
        crate::output::CreateDeviceDefinitionOutput,
        crate::error::CreateDeviceDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_device_definition_error(response)
        } else {
            crate::operation_deser::parse_create_device_definition_response(response)
        }
    }
}

/// Operation shape for `CreateDeviceDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_device_definition_version`](crate::client::Client::create_device_definition_version).
///
/// See [`crate::client::fluent_builders::CreateDeviceDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeviceDefinitionVersion {
    _private: (),
}
impl CreateDeviceDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`CreateDeviceDefinitionVersionInput`](crate::input::CreateDeviceDefinitionVersionInput)
    pub fn builder() -> crate::input::create_device_definition_version_input::Builder {
        crate::input::create_device_definition_version_input::Builder::default()
    }
    /// Creates a new `CreateDeviceDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeviceDefinitionVersion {
    type Output = std::result::Result<
        crate::output::CreateDeviceDefinitionVersionOutput,
        crate::error::CreateDeviceDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_device_definition_version_error(response)
        } else {
            crate::operation_deser::parse_create_device_definition_version_response(response)
        }
    }
}

/// Operation shape for `CreateFunctionDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_function_definition`](crate::client::Client::create_function_definition).
///
/// See [`crate::client::fluent_builders::CreateFunctionDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFunctionDefinition {
    _private: (),
}
impl CreateFunctionDefinition {
    /// Creates a new builder-style object to manufacture [`CreateFunctionDefinitionInput`](crate::input::CreateFunctionDefinitionInput)
    pub fn builder() -> crate::input::create_function_definition_input::Builder {
        crate::input::create_function_definition_input::Builder::default()
    }
    /// Creates a new `CreateFunctionDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFunctionDefinition {
    type Output = std::result::Result<
        crate::output::CreateFunctionDefinitionOutput,
        crate::error::CreateFunctionDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_function_definition_error(response)
        } else {
            crate::operation_deser::parse_create_function_definition_response(response)
        }
    }
}

/// Operation shape for `CreateFunctionDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_function_definition_version`](crate::client::Client::create_function_definition_version).
///
/// See [`crate::client::fluent_builders::CreateFunctionDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFunctionDefinitionVersion {
    _private: (),
}
impl CreateFunctionDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`CreateFunctionDefinitionVersionInput`](crate::input::CreateFunctionDefinitionVersionInput)
    pub fn builder() -> crate::input::create_function_definition_version_input::Builder {
        crate::input::create_function_definition_version_input::Builder::default()
    }
    /// Creates a new `CreateFunctionDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFunctionDefinitionVersion {
    type Output = std::result::Result<
        crate::output::CreateFunctionDefinitionVersionOutput,
        crate::error::CreateFunctionDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_function_definition_version_error(response)
        } else {
            crate::operation_deser::parse_create_function_definition_version_response(response)
        }
    }
}

/// Operation shape for `CreateGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_group`](crate::client::Client::create_group).
///
/// See [`crate::client::fluent_builders::CreateGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGroup {
    _private: (),
}
impl CreateGroup {
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
    /// Creates a new `CreateGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGroup {
    type Output =
        std::result::Result<crate::output::CreateGroupOutput, crate::error::CreateGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_group_error(response)
        } else {
            crate::operation_deser::parse_create_group_response(response)
        }
    }
}

/// Operation shape for `CreateGroupCertificateAuthority`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_group_certificate_authority`](crate::client::Client::create_group_certificate_authority).
///
/// See [`crate::client::fluent_builders::CreateGroupCertificateAuthority`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGroupCertificateAuthority {
    _private: (),
}
impl CreateGroupCertificateAuthority {
    /// Creates a new builder-style object to manufacture [`CreateGroupCertificateAuthorityInput`](crate::input::CreateGroupCertificateAuthorityInput)
    pub fn builder() -> crate::input::create_group_certificate_authority_input::Builder {
        crate::input::create_group_certificate_authority_input::Builder::default()
    }
    /// Creates a new `CreateGroupCertificateAuthority` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGroupCertificateAuthority {
    type Output = std::result::Result<
        crate::output::CreateGroupCertificateAuthorityOutput,
        crate::error::CreateGroupCertificateAuthorityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_group_certificate_authority_error(response)
        } else {
            crate::operation_deser::parse_create_group_certificate_authority_response(response)
        }
    }
}

/// Operation shape for `CreateGroupVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_group_version`](crate::client::Client::create_group_version).
///
/// See [`crate::client::fluent_builders::CreateGroupVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGroupVersion {
    _private: (),
}
impl CreateGroupVersion {
    /// Creates a new builder-style object to manufacture [`CreateGroupVersionInput`](crate::input::CreateGroupVersionInput)
    pub fn builder() -> crate::input::create_group_version_input::Builder {
        crate::input::create_group_version_input::Builder::default()
    }
    /// Creates a new `CreateGroupVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGroupVersion {
    type Output = std::result::Result<
        crate::output::CreateGroupVersionOutput,
        crate::error::CreateGroupVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_group_version_error(response)
        } else {
            crate::operation_deser::parse_create_group_version_response(response)
        }
    }
}

/// Operation shape for `CreateLoggerDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_logger_definition`](crate::client::Client::create_logger_definition).
///
/// See [`crate::client::fluent_builders::CreateLoggerDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLoggerDefinition {
    _private: (),
}
impl CreateLoggerDefinition {
    /// Creates a new builder-style object to manufacture [`CreateLoggerDefinitionInput`](crate::input::CreateLoggerDefinitionInput)
    pub fn builder() -> crate::input::create_logger_definition_input::Builder {
        crate::input::create_logger_definition_input::Builder::default()
    }
    /// Creates a new `CreateLoggerDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLoggerDefinition {
    type Output = std::result::Result<
        crate::output::CreateLoggerDefinitionOutput,
        crate::error::CreateLoggerDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_logger_definition_error(response)
        } else {
            crate::operation_deser::parse_create_logger_definition_response(response)
        }
    }
}

/// Operation shape for `CreateLoggerDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_logger_definition_version`](crate::client::Client::create_logger_definition_version).
///
/// See [`crate::client::fluent_builders::CreateLoggerDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLoggerDefinitionVersion {
    _private: (),
}
impl CreateLoggerDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`CreateLoggerDefinitionVersionInput`](crate::input::CreateLoggerDefinitionVersionInput)
    pub fn builder() -> crate::input::create_logger_definition_version_input::Builder {
        crate::input::create_logger_definition_version_input::Builder::default()
    }
    /// Creates a new `CreateLoggerDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLoggerDefinitionVersion {
    type Output = std::result::Result<
        crate::output::CreateLoggerDefinitionVersionOutput,
        crate::error::CreateLoggerDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_logger_definition_version_error(response)
        } else {
            crate::operation_deser::parse_create_logger_definition_version_response(response)
        }
    }
}

/// Operation shape for `CreateResourceDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resource_definition`](crate::client::Client::create_resource_definition).
///
/// See [`crate::client::fluent_builders::CreateResourceDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResourceDefinition {
    _private: (),
}
impl CreateResourceDefinition {
    /// Creates a new builder-style object to manufacture [`CreateResourceDefinitionInput`](crate::input::CreateResourceDefinitionInput)
    pub fn builder() -> crate::input::create_resource_definition_input::Builder {
        crate::input::create_resource_definition_input::Builder::default()
    }
    /// Creates a new `CreateResourceDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResourceDefinition {
    type Output = std::result::Result<
        crate::output::CreateResourceDefinitionOutput,
        crate::error::CreateResourceDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resource_definition_error(response)
        } else {
            crate::operation_deser::parse_create_resource_definition_response(response)
        }
    }
}

/// Operation shape for `CreateResourceDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resource_definition_version`](crate::client::Client::create_resource_definition_version).
///
/// See [`crate::client::fluent_builders::CreateResourceDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResourceDefinitionVersion {
    _private: (),
}
impl CreateResourceDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`CreateResourceDefinitionVersionInput`](crate::input::CreateResourceDefinitionVersionInput)
    pub fn builder() -> crate::input::create_resource_definition_version_input::Builder {
        crate::input::create_resource_definition_version_input::Builder::default()
    }
    /// Creates a new `CreateResourceDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResourceDefinitionVersion {
    type Output = std::result::Result<
        crate::output::CreateResourceDefinitionVersionOutput,
        crate::error::CreateResourceDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resource_definition_version_error(response)
        } else {
            crate::operation_deser::parse_create_resource_definition_version_response(response)
        }
    }
}

/// Operation shape for `CreateSoftwareUpdateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_software_update_job`](crate::client::Client::create_software_update_job).
///
/// See [`crate::client::fluent_builders::CreateSoftwareUpdateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSoftwareUpdateJob {
    _private: (),
}
impl CreateSoftwareUpdateJob {
    /// Creates a new builder-style object to manufacture [`CreateSoftwareUpdateJobInput`](crate::input::CreateSoftwareUpdateJobInput)
    pub fn builder() -> crate::input::create_software_update_job_input::Builder {
        crate::input::create_software_update_job_input::Builder::default()
    }
    /// Creates a new `CreateSoftwareUpdateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSoftwareUpdateJob {
    type Output = std::result::Result<
        crate::output::CreateSoftwareUpdateJobOutput,
        crate::error::CreateSoftwareUpdateJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_software_update_job_error(response)
        } else {
            crate::operation_deser::parse_create_software_update_job_response(response)
        }
    }
}

/// Operation shape for `CreateSubscriptionDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_subscription_definition`](crate::client::Client::create_subscription_definition).
///
/// See [`crate::client::fluent_builders::CreateSubscriptionDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSubscriptionDefinition {
    _private: (),
}
impl CreateSubscriptionDefinition {
    /// Creates a new builder-style object to manufacture [`CreateSubscriptionDefinitionInput`](crate::input::CreateSubscriptionDefinitionInput)
    pub fn builder() -> crate::input::create_subscription_definition_input::Builder {
        crate::input::create_subscription_definition_input::Builder::default()
    }
    /// Creates a new `CreateSubscriptionDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSubscriptionDefinition {
    type Output = std::result::Result<
        crate::output::CreateSubscriptionDefinitionOutput,
        crate::error::CreateSubscriptionDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_subscription_definition_error(response)
        } else {
            crate::operation_deser::parse_create_subscription_definition_response(response)
        }
    }
}

/// Operation shape for `CreateSubscriptionDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_subscription_definition_version`](crate::client::Client::create_subscription_definition_version).
///
/// See [`crate::client::fluent_builders::CreateSubscriptionDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSubscriptionDefinitionVersion {
    _private: (),
}
impl CreateSubscriptionDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`CreateSubscriptionDefinitionVersionInput`](crate::input::CreateSubscriptionDefinitionVersionInput)
    pub fn builder() -> crate::input::create_subscription_definition_version_input::Builder {
        crate::input::create_subscription_definition_version_input::Builder::default()
    }
    /// Creates a new `CreateSubscriptionDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSubscriptionDefinitionVersion {
    type Output = std::result::Result<
        crate::output::CreateSubscriptionDefinitionVersionOutput,
        crate::error::CreateSubscriptionDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_subscription_definition_version_error(response)
        } else {
            crate::operation_deser::parse_create_subscription_definition_version_response(response)
        }
    }
}

/// Operation shape for `DeleteConnectorDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connector_definition`](crate::client::Client::delete_connector_definition).
///
/// See [`crate::client::fluent_builders::DeleteConnectorDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnectorDefinition {
    _private: (),
}
impl DeleteConnectorDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteConnectorDefinitionInput`](crate::input::DeleteConnectorDefinitionInput)
    pub fn builder() -> crate::input::delete_connector_definition_input::Builder {
        crate::input::delete_connector_definition_input::Builder::default()
    }
    /// Creates a new `DeleteConnectorDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnectorDefinition {
    type Output = std::result::Result<
        crate::output::DeleteConnectorDefinitionOutput,
        crate::error::DeleteConnectorDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connector_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_connector_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteCoreDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_core_definition`](crate::client::Client::delete_core_definition).
///
/// See [`crate::client::fluent_builders::DeleteCoreDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCoreDefinition {
    _private: (),
}
impl DeleteCoreDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteCoreDefinitionInput`](crate::input::DeleteCoreDefinitionInput)
    pub fn builder() -> crate::input::delete_core_definition_input::Builder {
        crate::input::delete_core_definition_input::Builder::default()
    }
    /// Creates a new `DeleteCoreDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCoreDefinition {
    type Output = std::result::Result<
        crate::output::DeleteCoreDefinitionOutput,
        crate::error::DeleteCoreDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_core_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_core_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteDeviceDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_device_definition`](crate::client::Client::delete_device_definition).
///
/// See [`crate::client::fluent_builders::DeleteDeviceDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDeviceDefinition {
    _private: (),
}
impl DeleteDeviceDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceDefinitionInput`](crate::input::DeleteDeviceDefinitionInput)
    pub fn builder() -> crate::input::delete_device_definition_input::Builder {
        crate::input::delete_device_definition_input::Builder::default()
    }
    /// Creates a new `DeleteDeviceDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDeviceDefinition {
    type Output = std::result::Result<
        crate::output::DeleteDeviceDefinitionOutput,
        crate::error::DeleteDeviceDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_device_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_device_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteFunctionDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_function_definition`](crate::client::Client::delete_function_definition).
///
/// See [`crate::client::fluent_builders::DeleteFunctionDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFunctionDefinition {
    _private: (),
}
impl DeleteFunctionDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionDefinitionInput`](crate::input::DeleteFunctionDefinitionInput)
    pub fn builder() -> crate::input::delete_function_definition_input::Builder {
        crate::input::delete_function_definition_input::Builder::default()
    }
    /// Creates a new `DeleteFunctionDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFunctionDefinition {
    type Output = std::result::Result<
        crate::output::DeleteFunctionDefinitionOutput,
        crate::error::DeleteFunctionDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_function_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_function_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_group`](crate::client::Client::delete_group).
///
/// See [`crate::client::fluent_builders::DeleteGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGroup {
    _private: (),
}
impl DeleteGroup {
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
    /// Creates a new `DeleteGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGroup {
    type Output =
        std::result::Result<crate::output::DeleteGroupOutput, crate::error::DeleteGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_group_error(response)
        } else {
            crate::operation_deser::parse_delete_group_response(response)
        }
    }
}

/// Operation shape for `DeleteLoggerDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_logger_definition`](crate::client::Client::delete_logger_definition).
///
/// See [`crate::client::fluent_builders::DeleteLoggerDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLoggerDefinition {
    _private: (),
}
impl DeleteLoggerDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteLoggerDefinitionInput`](crate::input::DeleteLoggerDefinitionInput)
    pub fn builder() -> crate::input::delete_logger_definition_input::Builder {
        crate::input::delete_logger_definition_input::Builder::default()
    }
    /// Creates a new `DeleteLoggerDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLoggerDefinition {
    type Output = std::result::Result<
        crate::output::DeleteLoggerDefinitionOutput,
        crate::error::DeleteLoggerDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_logger_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_logger_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteResourceDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_definition`](crate::client::Client::delete_resource_definition).
///
/// See [`crate::client::fluent_builders::DeleteResourceDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourceDefinition {
    _private: (),
}
impl DeleteResourceDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteResourceDefinitionInput`](crate::input::DeleteResourceDefinitionInput)
    pub fn builder() -> crate::input::delete_resource_definition_input::Builder {
        crate::input::delete_resource_definition_input::Builder::default()
    }
    /// Creates a new `DeleteResourceDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourceDefinition {
    type Output = std::result::Result<
        crate::output::DeleteResourceDefinitionOutput,
        crate::error::DeleteResourceDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteSubscriptionDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_subscription_definition`](crate::client::Client::delete_subscription_definition).
///
/// See [`crate::client::fluent_builders::DeleteSubscriptionDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSubscriptionDefinition {
    _private: (),
}
impl DeleteSubscriptionDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteSubscriptionDefinitionInput`](crate::input::DeleteSubscriptionDefinitionInput)
    pub fn builder() -> crate::input::delete_subscription_definition_input::Builder {
        crate::input::delete_subscription_definition_input::Builder::default()
    }
    /// Creates a new `DeleteSubscriptionDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSubscriptionDefinition {
    type Output = std::result::Result<
        crate::output::DeleteSubscriptionDefinitionOutput,
        crate::error::DeleteSubscriptionDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_subscription_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_subscription_definition_response(response)
        }
    }
}

/// Operation shape for `DisassociateRoleFromGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_role_from_group`](crate::client::Client::disassociate_role_from_group).
///
/// See [`crate::client::fluent_builders::DisassociateRoleFromGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateRoleFromGroup {
    _private: (),
}
impl DisassociateRoleFromGroup {
    /// Creates a new builder-style object to manufacture [`DisassociateRoleFromGroupInput`](crate::input::DisassociateRoleFromGroupInput)
    pub fn builder() -> crate::input::disassociate_role_from_group_input::Builder {
        crate::input::disassociate_role_from_group_input::Builder::default()
    }
    /// Creates a new `DisassociateRoleFromGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateRoleFromGroup {
    type Output = std::result::Result<
        crate::output::DisassociateRoleFromGroupOutput,
        crate::error::DisassociateRoleFromGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_role_from_group_error(response)
        } else {
            crate::operation_deser::parse_disassociate_role_from_group_response(response)
        }
    }
}

/// Operation shape for `DisassociateServiceRoleFromAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_service_role_from_account`](crate::client::Client::disassociate_service_role_from_account).
///
/// See [`crate::client::fluent_builders::DisassociateServiceRoleFromAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateServiceRoleFromAccount {
    _private: (),
}
impl DisassociateServiceRoleFromAccount {
    /// Creates a new builder-style object to manufacture [`DisassociateServiceRoleFromAccountInput`](crate::input::DisassociateServiceRoleFromAccountInput)
    pub fn builder() -> crate::input::disassociate_service_role_from_account_input::Builder {
        crate::input::disassociate_service_role_from_account_input::Builder::default()
    }
    /// Creates a new `DisassociateServiceRoleFromAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateServiceRoleFromAccount {
    type Output = std::result::Result<
        crate::output::DisassociateServiceRoleFromAccountOutput,
        crate::error::DisassociateServiceRoleFromAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_service_role_from_account_error(response)
        } else {
            crate::operation_deser::parse_disassociate_service_role_from_account_response(response)
        }
    }
}

/// Operation shape for `GetAssociatedRole`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_associated_role`](crate::client::Client::get_associated_role).
///
/// See [`crate::client::fluent_builders::GetAssociatedRole`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssociatedRole {
    _private: (),
}
impl GetAssociatedRole {
    /// Creates a new builder-style object to manufacture [`GetAssociatedRoleInput`](crate::input::GetAssociatedRoleInput)
    pub fn builder() -> crate::input::get_associated_role_input::Builder {
        crate::input::get_associated_role_input::Builder::default()
    }
    /// Creates a new `GetAssociatedRole` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssociatedRole {
    type Output = std::result::Result<
        crate::output::GetAssociatedRoleOutput,
        crate::error::GetAssociatedRoleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_associated_role_error(response)
        } else {
            crate::operation_deser::parse_get_associated_role_response(response)
        }
    }
}

/// Operation shape for `GetBulkDeploymentStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bulk_deployment_status`](crate::client::Client::get_bulk_deployment_status).
///
/// See [`crate::client::fluent_builders::GetBulkDeploymentStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBulkDeploymentStatus {
    _private: (),
}
impl GetBulkDeploymentStatus {
    /// Creates a new builder-style object to manufacture [`GetBulkDeploymentStatusInput`](crate::input::GetBulkDeploymentStatusInput)
    pub fn builder() -> crate::input::get_bulk_deployment_status_input::Builder {
        crate::input::get_bulk_deployment_status_input::Builder::default()
    }
    /// Creates a new `GetBulkDeploymentStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBulkDeploymentStatus {
    type Output = std::result::Result<
        crate::output::GetBulkDeploymentStatusOutput,
        crate::error::GetBulkDeploymentStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bulk_deployment_status_error(response)
        } else {
            crate::operation_deser::parse_get_bulk_deployment_status_response(response)
        }
    }
}

/// Operation shape for `GetConnectivityInfo`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connectivity_info`](crate::client::Client::get_connectivity_info).
///
/// See [`crate::client::fluent_builders::GetConnectivityInfo`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnectivityInfo {
    _private: (),
}
impl GetConnectivityInfo {
    /// Creates a new builder-style object to manufacture [`GetConnectivityInfoInput`](crate::input::GetConnectivityInfoInput)
    pub fn builder() -> crate::input::get_connectivity_info_input::Builder {
        crate::input::get_connectivity_info_input::Builder::default()
    }
    /// Creates a new `GetConnectivityInfo` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnectivityInfo {
    type Output = std::result::Result<
        crate::output::GetConnectivityInfoOutput,
        crate::error::GetConnectivityInfoError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connectivity_info_error(response)
        } else {
            crate::operation_deser::parse_get_connectivity_info_response(response)
        }
    }
}

/// Operation shape for `GetConnectorDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connector_definition`](crate::client::Client::get_connector_definition).
///
/// See [`crate::client::fluent_builders::GetConnectorDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnectorDefinition {
    _private: (),
}
impl GetConnectorDefinition {
    /// Creates a new builder-style object to manufacture [`GetConnectorDefinitionInput`](crate::input::GetConnectorDefinitionInput)
    pub fn builder() -> crate::input::get_connector_definition_input::Builder {
        crate::input::get_connector_definition_input::Builder::default()
    }
    /// Creates a new `GetConnectorDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnectorDefinition {
    type Output = std::result::Result<
        crate::output::GetConnectorDefinitionOutput,
        crate::error::GetConnectorDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connector_definition_error(response)
        } else {
            crate::operation_deser::parse_get_connector_definition_response(response)
        }
    }
}

/// Operation shape for `GetConnectorDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connector_definition_version`](crate::client::Client::get_connector_definition_version).
///
/// See [`crate::client::fluent_builders::GetConnectorDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnectorDefinitionVersion {
    _private: (),
}
impl GetConnectorDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`GetConnectorDefinitionVersionInput`](crate::input::GetConnectorDefinitionVersionInput)
    pub fn builder() -> crate::input::get_connector_definition_version_input::Builder {
        crate::input::get_connector_definition_version_input::Builder::default()
    }
    /// Creates a new `GetConnectorDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnectorDefinitionVersion {
    type Output = std::result::Result<
        crate::output::GetConnectorDefinitionVersionOutput,
        crate::error::GetConnectorDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connector_definition_version_error(response)
        } else {
            crate::operation_deser::parse_get_connector_definition_version_response(response)
        }
    }
}

/// Operation shape for `GetCoreDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_core_definition`](crate::client::Client::get_core_definition).
///
/// See [`crate::client::fluent_builders::GetCoreDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCoreDefinition {
    _private: (),
}
impl GetCoreDefinition {
    /// Creates a new builder-style object to manufacture [`GetCoreDefinitionInput`](crate::input::GetCoreDefinitionInput)
    pub fn builder() -> crate::input::get_core_definition_input::Builder {
        crate::input::get_core_definition_input::Builder::default()
    }
    /// Creates a new `GetCoreDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCoreDefinition {
    type Output = std::result::Result<
        crate::output::GetCoreDefinitionOutput,
        crate::error::GetCoreDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_core_definition_error(response)
        } else {
            crate::operation_deser::parse_get_core_definition_response(response)
        }
    }
}

/// Operation shape for `GetCoreDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_core_definition_version`](crate::client::Client::get_core_definition_version).
///
/// See [`crate::client::fluent_builders::GetCoreDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCoreDefinitionVersion {
    _private: (),
}
impl GetCoreDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`GetCoreDefinitionVersionInput`](crate::input::GetCoreDefinitionVersionInput)
    pub fn builder() -> crate::input::get_core_definition_version_input::Builder {
        crate::input::get_core_definition_version_input::Builder::default()
    }
    /// Creates a new `GetCoreDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCoreDefinitionVersion {
    type Output = std::result::Result<
        crate::output::GetCoreDefinitionVersionOutput,
        crate::error::GetCoreDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_core_definition_version_error(response)
        } else {
            crate::operation_deser::parse_get_core_definition_version_response(response)
        }
    }
}

/// Operation shape for `GetDeploymentStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_deployment_status`](crate::client::Client::get_deployment_status).
///
/// See [`crate::client::fluent_builders::GetDeploymentStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeploymentStatus {
    _private: (),
}
impl GetDeploymentStatus {
    /// Creates a new builder-style object to manufacture [`GetDeploymentStatusInput`](crate::input::GetDeploymentStatusInput)
    pub fn builder() -> crate::input::get_deployment_status_input::Builder {
        crate::input::get_deployment_status_input::Builder::default()
    }
    /// Creates a new `GetDeploymentStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeploymentStatus {
    type Output = std::result::Result<
        crate::output::GetDeploymentStatusOutput,
        crate::error::GetDeploymentStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_deployment_status_error(response)
        } else {
            crate::operation_deser::parse_get_deployment_status_response(response)
        }
    }
}

/// Operation shape for `GetDeviceDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_definition`](crate::client::Client::get_device_definition).
///
/// See [`crate::client::fluent_builders::GetDeviceDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeviceDefinition {
    _private: (),
}
impl GetDeviceDefinition {
    /// Creates a new builder-style object to manufacture [`GetDeviceDefinitionInput`](crate::input::GetDeviceDefinitionInput)
    pub fn builder() -> crate::input::get_device_definition_input::Builder {
        crate::input::get_device_definition_input::Builder::default()
    }
    /// Creates a new `GetDeviceDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeviceDefinition {
    type Output = std::result::Result<
        crate::output::GetDeviceDefinitionOutput,
        crate::error::GetDeviceDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_definition_error(response)
        } else {
            crate::operation_deser::parse_get_device_definition_response(response)
        }
    }
}

/// Operation shape for `GetDeviceDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_definition_version`](crate::client::Client::get_device_definition_version).
///
/// See [`crate::client::fluent_builders::GetDeviceDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeviceDefinitionVersion {
    _private: (),
}
impl GetDeviceDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`GetDeviceDefinitionVersionInput`](crate::input::GetDeviceDefinitionVersionInput)
    pub fn builder() -> crate::input::get_device_definition_version_input::Builder {
        crate::input::get_device_definition_version_input::Builder::default()
    }
    /// Creates a new `GetDeviceDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeviceDefinitionVersion {
    type Output = std::result::Result<
        crate::output::GetDeviceDefinitionVersionOutput,
        crate::error::GetDeviceDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_definition_version_error(response)
        } else {
            crate::operation_deser::parse_get_device_definition_version_response(response)
        }
    }
}

/// Operation shape for `GetFunctionDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_function_definition`](crate::client::Client::get_function_definition).
///
/// See [`crate::client::fluent_builders::GetFunctionDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFunctionDefinition {
    _private: (),
}
impl GetFunctionDefinition {
    /// Creates a new builder-style object to manufacture [`GetFunctionDefinitionInput`](crate::input::GetFunctionDefinitionInput)
    pub fn builder() -> crate::input::get_function_definition_input::Builder {
        crate::input::get_function_definition_input::Builder::default()
    }
    /// Creates a new `GetFunctionDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFunctionDefinition {
    type Output = std::result::Result<
        crate::output::GetFunctionDefinitionOutput,
        crate::error::GetFunctionDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_function_definition_error(response)
        } else {
            crate::operation_deser::parse_get_function_definition_response(response)
        }
    }
}

/// Operation shape for `GetFunctionDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_function_definition_version`](crate::client::Client::get_function_definition_version).
///
/// See [`crate::client::fluent_builders::GetFunctionDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFunctionDefinitionVersion {
    _private: (),
}
impl GetFunctionDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`GetFunctionDefinitionVersionInput`](crate::input::GetFunctionDefinitionVersionInput)
    pub fn builder() -> crate::input::get_function_definition_version_input::Builder {
        crate::input::get_function_definition_version_input::Builder::default()
    }
    /// Creates a new `GetFunctionDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFunctionDefinitionVersion {
    type Output = std::result::Result<
        crate::output::GetFunctionDefinitionVersionOutput,
        crate::error::GetFunctionDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_function_definition_version_error(response)
        } else {
            crate::operation_deser::parse_get_function_definition_version_response(response)
        }
    }
}

/// Operation shape for `GetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_group`](crate::client::Client::get_group).
///
/// See [`crate::client::fluent_builders::GetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGroup {
    _private: (),
}
impl GetGroup {
    /// Creates a new builder-style object to manufacture [`GetGroupInput`](crate::input::GetGroupInput)
    pub fn builder() -> crate::input::get_group_input::Builder {
        crate::input::get_group_input::Builder::default()
    }
    /// Creates a new `GetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGroup {
    type Output = std::result::Result<crate::output::GetGroupOutput, crate::error::GetGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_group_error(response)
        } else {
            crate::operation_deser::parse_get_group_response(response)
        }
    }
}

/// Operation shape for `GetGroupCertificateAuthority`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_group_certificate_authority`](crate::client::Client::get_group_certificate_authority).
///
/// See [`crate::client::fluent_builders::GetGroupCertificateAuthority`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGroupCertificateAuthority {
    _private: (),
}
impl GetGroupCertificateAuthority {
    /// Creates a new builder-style object to manufacture [`GetGroupCertificateAuthorityInput`](crate::input::GetGroupCertificateAuthorityInput)
    pub fn builder() -> crate::input::get_group_certificate_authority_input::Builder {
        crate::input::get_group_certificate_authority_input::Builder::default()
    }
    /// Creates a new `GetGroupCertificateAuthority` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGroupCertificateAuthority {
    type Output = std::result::Result<
        crate::output::GetGroupCertificateAuthorityOutput,
        crate::error::GetGroupCertificateAuthorityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_group_certificate_authority_error(response)
        } else {
            crate::operation_deser::parse_get_group_certificate_authority_response(response)
        }
    }
}

/// Operation shape for `GetGroupCertificateConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_group_certificate_configuration`](crate::client::Client::get_group_certificate_configuration).
///
/// See [`crate::client::fluent_builders::GetGroupCertificateConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGroupCertificateConfiguration {
    _private: (),
}
impl GetGroupCertificateConfiguration {
    /// Creates a new builder-style object to manufacture [`GetGroupCertificateConfigurationInput`](crate::input::GetGroupCertificateConfigurationInput)
    pub fn builder() -> crate::input::get_group_certificate_configuration_input::Builder {
        crate::input::get_group_certificate_configuration_input::Builder::default()
    }
    /// Creates a new `GetGroupCertificateConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGroupCertificateConfiguration {
    type Output = std::result::Result<
        crate::output::GetGroupCertificateConfigurationOutput,
        crate::error::GetGroupCertificateConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_group_certificate_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_group_certificate_configuration_response(response)
        }
    }
}

/// Operation shape for `GetGroupVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_group_version`](crate::client::Client::get_group_version).
///
/// See [`crate::client::fluent_builders::GetGroupVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGroupVersion {
    _private: (),
}
impl GetGroupVersion {
    /// Creates a new builder-style object to manufacture [`GetGroupVersionInput`](crate::input::GetGroupVersionInput)
    pub fn builder() -> crate::input::get_group_version_input::Builder {
        crate::input::get_group_version_input::Builder::default()
    }
    /// Creates a new `GetGroupVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGroupVersion {
    type Output = std::result::Result<
        crate::output::GetGroupVersionOutput,
        crate::error::GetGroupVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_group_version_error(response)
        } else {
            crate::operation_deser::parse_get_group_version_response(response)
        }
    }
}

/// Operation shape for `GetLoggerDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_logger_definition`](crate::client::Client::get_logger_definition).
///
/// See [`crate::client::fluent_builders::GetLoggerDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLoggerDefinition {
    _private: (),
}
impl GetLoggerDefinition {
    /// Creates a new builder-style object to manufacture [`GetLoggerDefinitionInput`](crate::input::GetLoggerDefinitionInput)
    pub fn builder() -> crate::input::get_logger_definition_input::Builder {
        crate::input::get_logger_definition_input::Builder::default()
    }
    /// Creates a new `GetLoggerDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLoggerDefinition {
    type Output = std::result::Result<
        crate::output::GetLoggerDefinitionOutput,
        crate::error::GetLoggerDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_logger_definition_error(response)
        } else {
            crate::operation_deser::parse_get_logger_definition_response(response)
        }
    }
}

/// Operation shape for `GetLoggerDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_logger_definition_version`](crate::client::Client::get_logger_definition_version).
///
/// See [`crate::client::fluent_builders::GetLoggerDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLoggerDefinitionVersion {
    _private: (),
}
impl GetLoggerDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`GetLoggerDefinitionVersionInput`](crate::input::GetLoggerDefinitionVersionInput)
    pub fn builder() -> crate::input::get_logger_definition_version_input::Builder {
        crate::input::get_logger_definition_version_input::Builder::default()
    }
    /// Creates a new `GetLoggerDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLoggerDefinitionVersion {
    type Output = std::result::Result<
        crate::output::GetLoggerDefinitionVersionOutput,
        crate::error::GetLoggerDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_logger_definition_version_error(response)
        } else {
            crate::operation_deser::parse_get_logger_definition_version_response(response)
        }
    }
}

/// Operation shape for `GetResourceDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_definition`](crate::client::Client::get_resource_definition).
///
/// See [`crate::client::fluent_builders::GetResourceDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourceDefinition {
    _private: (),
}
impl GetResourceDefinition {
    /// Creates a new builder-style object to manufacture [`GetResourceDefinitionInput`](crate::input::GetResourceDefinitionInput)
    pub fn builder() -> crate::input::get_resource_definition_input::Builder {
        crate::input::get_resource_definition_input::Builder::default()
    }
    /// Creates a new `GetResourceDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourceDefinition {
    type Output = std::result::Result<
        crate::output::GetResourceDefinitionOutput,
        crate::error::GetResourceDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_definition_error(response)
        } else {
            crate::operation_deser::parse_get_resource_definition_response(response)
        }
    }
}

/// Operation shape for `GetResourceDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_definition_version`](crate::client::Client::get_resource_definition_version).
///
/// See [`crate::client::fluent_builders::GetResourceDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourceDefinitionVersion {
    _private: (),
}
impl GetResourceDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`GetResourceDefinitionVersionInput`](crate::input::GetResourceDefinitionVersionInput)
    pub fn builder() -> crate::input::get_resource_definition_version_input::Builder {
        crate::input::get_resource_definition_version_input::Builder::default()
    }
    /// Creates a new `GetResourceDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourceDefinitionVersion {
    type Output = std::result::Result<
        crate::output::GetResourceDefinitionVersionOutput,
        crate::error::GetResourceDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_definition_version_error(response)
        } else {
            crate::operation_deser::parse_get_resource_definition_version_response(response)
        }
    }
}

/// Operation shape for `GetServiceRoleForAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_service_role_for_account`](crate::client::Client::get_service_role_for_account).
///
/// See [`crate::client::fluent_builders::GetServiceRoleForAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetServiceRoleForAccount {
    _private: (),
}
impl GetServiceRoleForAccount {
    /// Creates a new builder-style object to manufacture [`GetServiceRoleForAccountInput`](crate::input::GetServiceRoleForAccountInput)
    pub fn builder() -> crate::input::get_service_role_for_account_input::Builder {
        crate::input::get_service_role_for_account_input::Builder::default()
    }
    /// Creates a new `GetServiceRoleForAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetServiceRoleForAccount {
    type Output = std::result::Result<
        crate::output::GetServiceRoleForAccountOutput,
        crate::error::GetServiceRoleForAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_service_role_for_account_error(response)
        } else {
            crate::operation_deser::parse_get_service_role_for_account_response(response)
        }
    }
}

/// Operation shape for `GetSubscriptionDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_subscription_definition`](crate::client::Client::get_subscription_definition).
///
/// See [`crate::client::fluent_builders::GetSubscriptionDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSubscriptionDefinition {
    _private: (),
}
impl GetSubscriptionDefinition {
    /// Creates a new builder-style object to manufacture [`GetSubscriptionDefinitionInput`](crate::input::GetSubscriptionDefinitionInput)
    pub fn builder() -> crate::input::get_subscription_definition_input::Builder {
        crate::input::get_subscription_definition_input::Builder::default()
    }
    /// Creates a new `GetSubscriptionDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSubscriptionDefinition {
    type Output = std::result::Result<
        crate::output::GetSubscriptionDefinitionOutput,
        crate::error::GetSubscriptionDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_subscription_definition_error(response)
        } else {
            crate::operation_deser::parse_get_subscription_definition_response(response)
        }
    }
}

/// Operation shape for `GetSubscriptionDefinitionVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_subscription_definition_version`](crate::client::Client::get_subscription_definition_version).
///
/// See [`crate::client::fluent_builders::GetSubscriptionDefinitionVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSubscriptionDefinitionVersion {
    _private: (),
}
impl GetSubscriptionDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`GetSubscriptionDefinitionVersionInput`](crate::input::GetSubscriptionDefinitionVersionInput)
    pub fn builder() -> crate::input::get_subscription_definition_version_input::Builder {
        crate::input::get_subscription_definition_version_input::Builder::default()
    }
    /// Creates a new `GetSubscriptionDefinitionVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSubscriptionDefinitionVersion {
    type Output = std::result::Result<
        crate::output::GetSubscriptionDefinitionVersionOutput,
        crate::error::GetSubscriptionDefinitionVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_subscription_definition_version_error(response)
        } else {
            crate::operation_deser::parse_get_subscription_definition_version_response(response)
        }
    }
}

/// Operation shape for `GetThingRuntimeConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_thing_runtime_configuration`](crate::client::Client::get_thing_runtime_configuration).
///
/// See [`crate::client::fluent_builders::GetThingRuntimeConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetThingRuntimeConfiguration {
    _private: (),
}
impl GetThingRuntimeConfiguration {
    /// Creates a new builder-style object to manufacture [`GetThingRuntimeConfigurationInput`](crate::input::GetThingRuntimeConfigurationInput)
    pub fn builder() -> crate::input::get_thing_runtime_configuration_input::Builder {
        crate::input::get_thing_runtime_configuration_input::Builder::default()
    }
    /// Creates a new `GetThingRuntimeConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetThingRuntimeConfiguration {
    type Output = std::result::Result<
        crate::output::GetThingRuntimeConfigurationOutput,
        crate::error::GetThingRuntimeConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_thing_runtime_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_thing_runtime_configuration_response(response)
        }
    }
}

/// Operation shape for `ListBulkDeploymentDetailedReports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bulk_deployment_detailed_reports`](crate::client::Client::list_bulk_deployment_detailed_reports).
///
/// See [`crate::client::fluent_builders::ListBulkDeploymentDetailedReports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBulkDeploymentDetailedReports {
    _private: (),
}
impl ListBulkDeploymentDetailedReports {
    /// Creates a new builder-style object to manufacture [`ListBulkDeploymentDetailedReportsInput`](crate::input::ListBulkDeploymentDetailedReportsInput)
    pub fn builder() -> crate::input::list_bulk_deployment_detailed_reports_input::Builder {
        crate::input::list_bulk_deployment_detailed_reports_input::Builder::default()
    }
    /// Creates a new `ListBulkDeploymentDetailedReports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBulkDeploymentDetailedReports {
    type Output = std::result::Result<
        crate::output::ListBulkDeploymentDetailedReportsOutput,
        crate::error::ListBulkDeploymentDetailedReportsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bulk_deployment_detailed_reports_error(response)
        } else {
            crate::operation_deser::parse_list_bulk_deployment_detailed_reports_response(response)
        }
    }
}

/// Operation shape for `ListBulkDeployments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bulk_deployments`](crate::client::Client::list_bulk_deployments).
///
/// See [`crate::client::fluent_builders::ListBulkDeployments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBulkDeployments {
    _private: (),
}
impl ListBulkDeployments {
    /// Creates a new builder-style object to manufacture [`ListBulkDeploymentsInput`](crate::input::ListBulkDeploymentsInput)
    pub fn builder() -> crate::input::list_bulk_deployments_input::Builder {
        crate::input::list_bulk_deployments_input::Builder::default()
    }
    /// Creates a new `ListBulkDeployments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBulkDeployments {
    type Output = std::result::Result<
        crate::output::ListBulkDeploymentsOutput,
        crate::error::ListBulkDeploymentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bulk_deployments_error(response)
        } else {
            crate::operation_deser::parse_list_bulk_deployments_response(response)
        }
    }
}

/// Operation shape for `ListConnectorDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_connector_definitions`](crate::client::Client::list_connector_definitions).
///
/// See [`crate::client::fluent_builders::ListConnectorDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConnectorDefinitions {
    _private: (),
}
impl ListConnectorDefinitions {
    /// Creates a new builder-style object to manufacture [`ListConnectorDefinitionsInput`](crate::input::ListConnectorDefinitionsInput)
    pub fn builder() -> crate::input::list_connector_definitions_input::Builder {
        crate::input::list_connector_definitions_input::Builder::default()
    }
    /// Creates a new `ListConnectorDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConnectorDefinitions {
    type Output = std::result::Result<
        crate::output::ListConnectorDefinitionsOutput,
        crate::error::ListConnectorDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_connector_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_connector_definitions_response(response)
        }
    }
}

/// Operation shape for `ListConnectorDefinitionVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_connector_definition_versions`](crate::client::Client::list_connector_definition_versions).
///
/// See [`crate::client::fluent_builders::ListConnectorDefinitionVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConnectorDefinitionVersions {
    _private: (),
}
impl ListConnectorDefinitionVersions {
    /// Creates a new builder-style object to manufacture [`ListConnectorDefinitionVersionsInput`](crate::input::ListConnectorDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_connector_definition_versions_input::Builder {
        crate::input::list_connector_definition_versions_input::Builder::default()
    }
    /// Creates a new `ListConnectorDefinitionVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConnectorDefinitionVersions {
    type Output = std::result::Result<
        crate::output::ListConnectorDefinitionVersionsOutput,
        crate::error::ListConnectorDefinitionVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_connector_definition_versions_error(response)
        } else {
            crate::operation_deser::parse_list_connector_definition_versions_response(response)
        }
    }
}

/// Operation shape for `ListCoreDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_core_definitions`](crate::client::Client::list_core_definitions).
///
/// See [`crate::client::fluent_builders::ListCoreDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCoreDefinitions {
    _private: (),
}
impl ListCoreDefinitions {
    /// Creates a new builder-style object to manufacture [`ListCoreDefinitionsInput`](crate::input::ListCoreDefinitionsInput)
    pub fn builder() -> crate::input::list_core_definitions_input::Builder {
        crate::input::list_core_definitions_input::Builder::default()
    }
    /// Creates a new `ListCoreDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCoreDefinitions {
    type Output = std::result::Result<
        crate::output::ListCoreDefinitionsOutput,
        crate::error::ListCoreDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_core_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_core_definitions_response(response)
        }
    }
}

/// Operation shape for `ListCoreDefinitionVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_core_definition_versions`](crate::client::Client::list_core_definition_versions).
///
/// See [`crate::client::fluent_builders::ListCoreDefinitionVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCoreDefinitionVersions {
    _private: (),
}
impl ListCoreDefinitionVersions {
    /// Creates a new builder-style object to manufacture [`ListCoreDefinitionVersionsInput`](crate::input::ListCoreDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_core_definition_versions_input::Builder {
        crate::input::list_core_definition_versions_input::Builder::default()
    }
    /// Creates a new `ListCoreDefinitionVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCoreDefinitionVersions {
    type Output = std::result::Result<
        crate::output::ListCoreDefinitionVersionsOutput,
        crate::error::ListCoreDefinitionVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_core_definition_versions_error(response)
        } else {
            crate::operation_deser::parse_list_core_definition_versions_response(response)
        }
    }
}

/// Operation shape for `ListDeployments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_deployments`](crate::client::Client::list_deployments).
///
/// See [`crate::client::fluent_builders::ListDeployments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeployments {
    _private: (),
}
impl ListDeployments {
    /// Creates a new builder-style object to manufacture [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
    pub fn builder() -> crate::input::list_deployments_input::Builder {
        crate::input::list_deployments_input::Builder::default()
    }
    /// Creates a new `ListDeployments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeployments {
    type Output = std::result::Result<
        crate::output::ListDeploymentsOutput,
        crate::error::ListDeploymentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_deployments_error(response)
        } else {
            crate::operation_deser::parse_list_deployments_response(response)
        }
    }
}

/// Operation shape for `ListDeviceDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_device_definitions`](crate::client::Client::list_device_definitions).
///
/// See [`crate::client::fluent_builders::ListDeviceDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeviceDefinitions {
    _private: (),
}
impl ListDeviceDefinitions {
    /// Creates a new builder-style object to manufacture [`ListDeviceDefinitionsInput`](crate::input::ListDeviceDefinitionsInput)
    pub fn builder() -> crate::input::list_device_definitions_input::Builder {
        crate::input::list_device_definitions_input::Builder::default()
    }
    /// Creates a new `ListDeviceDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeviceDefinitions {
    type Output = std::result::Result<
        crate::output::ListDeviceDefinitionsOutput,
        crate::error::ListDeviceDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_device_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_device_definitions_response(response)
        }
    }
}

/// Operation shape for `ListDeviceDefinitionVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_device_definition_versions`](crate::client::Client::list_device_definition_versions).
///
/// See [`crate::client::fluent_builders::ListDeviceDefinitionVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeviceDefinitionVersions {
    _private: (),
}
impl ListDeviceDefinitionVersions {
    /// Creates a new builder-style object to manufacture [`ListDeviceDefinitionVersionsInput`](crate::input::ListDeviceDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_device_definition_versions_input::Builder {
        crate::input::list_device_definition_versions_input::Builder::default()
    }
    /// Creates a new `ListDeviceDefinitionVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeviceDefinitionVersions {
    type Output = std::result::Result<
        crate::output::ListDeviceDefinitionVersionsOutput,
        crate::error::ListDeviceDefinitionVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_device_definition_versions_error(response)
        } else {
            crate::operation_deser::parse_list_device_definition_versions_response(response)
        }
    }
}

/// Operation shape for `ListFunctionDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_function_definitions`](crate::client::Client::list_function_definitions).
///
/// See [`crate::client::fluent_builders::ListFunctionDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFunctionDefinitions {
    _private: (),
}
impl ListFunctionDefinitions {
    /// Creates a new builder-style object to manufacture [`ListFunctionDefinitionsInput`](crate::input::ListFunctionDefinitionsInput)
    pub fn builder() -> crate::input::list_function_definitions_input::Builder {
        crate::input::list_function_definitions_input::Builder::default()
    }
    /// Creates a new `ListFunctionDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFunctionDefinitions {
    type Output = std::result::Result<
        crate::output::ListFunctionDefinitionsOutput,
        crate::error::ListFunctionDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_function_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_function_definitions_response(response)
        }
    }
}

/// Operation shape for `ListFunctionDefinitionVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_function_definition_versions`](crate::client::Client::list_function_definition_versions).
///
/// See [`crate::client::fluent_builders::ListFunctionDefinitionVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFunctionDefinitionVersions {
    _private: (),
}
impl ListFunctionDefinitionVersions {
    /// Creates a new builder-style object to manufacture [`ListFunctionDefinitionVersionsInput`](crate::input::ListFunctionDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_function_definition_versions_input::Builder {
        crate::input::list_function_definition_versions_input::Builder::default()
    }
    /// Creates a new `ListFunctionDefinitionVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFunctionDefinitionVersions {
    type Output = std::result::Result<
        crate::output::ListFunctionDefinitionVersionsOutput,
        crate::error::ListFunctionDefinitionVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_function_definition_versions_error(response)
        } else {
            crate::operation_deser::parse_list_function_definition_versions_response(response)
        }
    }
}

/// Operation shape for `ListGroupCertificateAuthorities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_group_certificate_authorities`](crate::client::Client::list_group_certificate_authorities).
///
/// See [`crate::client::fluent_builders::ListGroupCertificateAuthorities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGroupCertificateAuthorities {
    _private: (),
}
impl ListGroupCertificateAuthorities {
    /// Creates a new builder-style object to manufacture [`ListGroupCertificateAuthoritiesInput`](crate::input::ListGroupCertificateAuthoritiesInput)
    pub fn builder() -> crate::input::list_group_certificate_authorities_input::Builder {
        crate::input::list_group_certificate_authorities_input::Builder::default()
    }
    /// Creates a new `ListGroupCertificateAuthorities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGroupCertificateAuthorities {
    type Output = std::result::Result<
        crate::output::ListGroupCertificateAuthoritiesOutput,
        crate::error::ListGroupCertificateAuthoritiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_group_certificate_authorities_error(response)
        } else {
            crate::operation_deser::parse_list_group_certificate_authorities_response(response)
        }
    }
}

/// Operation shape for `ListGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_groups`](crate::client::Client::list_groups).
///
/// See [`crate::client::fluent_builders::ListGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGroups {
    _private: (),
}
impl ListGroups {
    /// Creates a new builder-style object to manufacture [`ListGroupsInput`](crate::input::ListGroupsInput)
    pub fn builder() -> crate::input::list_groups_input::Builder {
        crate::input::list_groups_input::Builder::default()
    }
    /// Creates a new `ListGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGroups {
    type Output =
        std::result::Result<crate::output::ListGroupsOutput, crate::error::ListGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_groups_error(response)
        } else {
            crate::operation_deser::parse_list_groups_response(response)
        }
    }
}

/// Operation shape for `ListGroupVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_group_versions`](crate::client::Client::list_group_versions).
///
/// See [`crate::client::fluent_builders::ListGroupVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGroupVersions {
    _private: (),
}
impl ListGroupVersions {
    /// Creates a new builder-style object to manufacture [`ListGroupVersionsInput`](crate::input::ListGroupVersionsInput)
    pub fn builder() -> crate::input::list_group_versions_input::Builder {
        crate::input::list_group_versions_input::Builder::default()
    }
    /// Creates a new `ListGroupVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGroupVersions {
    type Output = std::result::Result<
        crate::output::ListGroupVersionsOutput,
        crate::error::ListGroupVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_group_versions_error(response)
        } else {
            crate::operation_deser::parse_list_group_versions_response(response)
        }
    }
}

/// Operation shape for `ListLoggerDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_logger_definitions`](crate::client::Client::list_logger_definitions).
///
/// See [`crate::client::fluent_builders::ListLoggerDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLoggerDefinitions {
    _private: (),
}
impl ListLoggerDefinitions {
    /// Creates a new builder-style object to manufacture [`ListLoggerDefinitionsInput`](crate::input::ListLoggerDefinitionsInput)
    pub fn builder() -> crate::input::list_logger_definitions_input::Builder {
        crate::input::list_logger_definitions_input::Builder::default()
    }
    /// Creates a new `ListLoggerDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLoggerDefinitions {
    type Output = std::result::Result<
        crate::output::ListLoggerDefinitionsOutput,
        crate::error::ListLoggerDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_logger_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_logger_definitions_response(response)
        }
    }
}

/// Operation shape for `ListLoggerDefinitionVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_logger_definition_versions`](crate::client::Client::list_logger_definition_versions).
///
/// See [`crate::client::fluent_builders::ListLoggerDefinitionVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLoggerDefinitionVersions {
    _private: (),
}
impl ListLoggerDefinitionVersions {
    /// Creates a new builder-style object to manufacture [`ListLoggerDefinitionVersionsInput`](crate::input::ListLoggerDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_logger_definition_versions_input::Builder {
        crate::input::list_logger_definition_versions_input::Builder::default()
    }
    /// Creates a new `ListLoggerDefinitionVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLoggerDefinitionVersions {
    type Output = std::result::Result<
        crate::output::ListLoggerDefinitionVersionsOutput,
        crate::error::ListLoggerDefinitionVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_logger_definition_versions_error(response)
        } else {
            crate::operation_deser::parse_list_logger_definition_versions_response(response)
        }
    }
}

/// Operation shape for `ListResourceDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resource_definitions`](crate::client::Client::list_resource_definitions).
///
/// See [`crate::client::fluent_builders::ListResourceDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourceDefinitions {
    _private: (),
}
impl ListResourceDefinitions {
    /// Creates a new builder-style object to manufacture [`ListResourceDefinitionsInput`](crate::input::ListResourceDefinitionsInput)
    pub fn builder() -> crate::input::list_resource_definitions_input::Builder {
        crate::input::list_resource_definitions_input::Builder::default()
    }
    /// Creates a new `ListResourceDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourceDefinitions {
    type Output = std::result::Result<
        crate::output::ListResourceDefinitionsOutput,
        crate::error::ListResourceDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resource_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_resource_definitions_response(response)
        }
    }
}

/// Operation shape for `ListResourceDefinitionVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resource_definition_versions`](crate::client::Client::list_resource_definition_versions).
///
/// See [`crate::client::fluent_builders::ListResourceDefinitionVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourceDefinitionVersions {
    _private: (),
}
impl ListResourceDefinitionVersions {
    /// Creates a new builder-style object to manufacture [`ListResourceDefinitionVersionsInput`](crate::input::ListResourceDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_resource_definition_versions_input::Builder {
        crate::input::list_resource_definition_versions_input::Builder::default()
    }
    /// Creates a new `ListResourceDefinitionVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourceDefinitionVersions {
    type Output = std::result::Result<
        crate::output::ListResourceDefinitionVersionsOutput,
        crate::error::ListResourceDefinitionVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resource_definition_versions_error(response)
        } else {
            crate::operation_deser::parse_list_resource_definition_versions_response(response)
        }
    }
}

/// Operation shape for `ListSubscriptionDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_subscription_definitions`](crate::client::Client::list_subscription_definitions).
///
/// See [`crate::client::fluent_builders::ListSubscriptionDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSubscriptionDefinitions {
    _private: (),
}
impl ListSubscriptionDefinitions {
    /// Creates a new builder-style object to manufacture [`ListSubscriptionDefinitionsInput`](crate::input::ListSubscriptionDefinitionsInput)
    pub fn builder() -> crate::input::list_subscription_definitions_input::Builder {
        crate::input::list_subscription_definitions_input::Builder::default()
    }
    /// Creates a new `ListSubscriptionDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSubscriptionDefinitions {
    type Output = std::result::Result<
        crate::output::ListSubscriptionDefinitionsOutput,
        crate::error::ListSubscriptionDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_subscription_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_subscription_definitions_response(response)
        }
    }
}

/// Operation shape for `ListSubscriptionDefinitionVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_subscription_definition_versions`](crate::client::Client::list_subscription_definition_versions).
///
/// See [`crate::client::fluent_builders::ListSubscriptionDefinitionVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSubscriptionDefinitionVersions {
    _private: (),
}
impl ListSubscriptionDefinitionVersions {
    /// Creates a new builder-style object to manufacture [`ListSubscriptionDefinitionVersionsInput`](crate::input::ListSubscriptionDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_subscription_definition_versions_input::Builder {
        crate::input::list_subscription_definition_versions_input::Builder::default()
    }
    /// Creates a new `ListSubscriptionDefinitionVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSubscriptionDefinitionVersions {
    type Output = std::result::Result<
        crate::output::ListSubscriptionDefinitionVersionsOutput,
        crate::error::ListSubscriptionDefinitionVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_subscription_definition_versions_error(response)
        } else {
            crate::operation_deser::parse_list_subscription_definition_versions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ResetDeployments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_deployments`](crate::client::Client::reset_deployments).
///
/// See [`crate::client::fluent_builders::ResetDeployments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetDeployments {
    _private: (),
}
impl ResetDeployments {
    /// Creates a new builder-style object to manufacture [`ResetDeploymentsInput`](crate::input::ResetDeploymentsInput)
    pub fn builder() -> crate::input::reset_deployments_input::Builder {
        crate::input::reset_deployments_input::Builder::default()
    }
    /// Creates a new `ResetDeployments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetDeployments {
    type Output = std::result::Result<
        crate::output::ResetDeploymentsOutput,
        crate::error::ResetDeploymentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_deployments_error(response)
        } else {
            crate::operation_deser::parse_reset_deployments_response(response)
        }
    }
}

/// Operation shape for `StartBulkDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_bulk_deployment`](crate::client::Client::start_bulk_deployment).
///
/// See [`crate::client::fluent_builders::StartBulkDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartBulkDeployment {
    _private: (),
}
impl StartBulkDeployment {
    /// Creates a new builder-style object to manufacture [`StartBulkDeploymentInput`](crate::input::StartBulkDeploymentInput)
    pub fn builder() -> crate::input::start_bulk_deployment_input::Builder {
        crate::input::start_bulk_deployment_input::Builder::default()
    }
    /// Creates a new `StartBulkDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartBulkDeployment {
    type Output = std::result::Result<
        crate::output::StartBulkDeploymentOutput,
        crate::error::StartBulkDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_bulk_deployment_error(response)
        } else {
            crate::operation_deser::parse_start_bulk_deployment_response(response)
        }
    }
}

/// Operation shape for `StopBulkDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_bulk_deployment`](crate::client::Client::stop_bulk_deployment).
///
/// See [`crate::client::fluent_builders::StopBulkDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopBulkDeployment {
    _private: (),
}
impl StopBulkDeployment {
    /// Creates a new builder-style object to manufacture [`StopBulkDeploymentInput`](crate::input::StopBulkDeploymentInput)
    pub fn builder() -> crate::input::stop_bulk_deployment_input::Builder {
        crate::input::stop_bulk_deployment_input::Builder::default()
    }
    /// Creates a new `StopBulkDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopBulkDeployment {
    type Output = std::result::Result<
        crate::output::StopBulkDeploymentOutput,
        crate::error::StopBulkDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_bulk_deployment_error(response)
        } else {
            crate::operation_deser::parse_stop_bulk_deployment_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateConnectivityInfo`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_connectivity_info`](crate::client::Client::update_connectivity_info).
///
/// See [`crate::client::fluent_builders::UpdateConnectivityInfo`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConnectivityInfo {
    _private: (),
}
impl UpdateConnectivityInfo {
    /// Creates a new builder-style object to manufacture [`UpdateConnectivityInfoInput`](crate::input::UpdateConnectivityInfoInput)
    pub fn builder() -> crate::input::update_connectivity_info_input::Builder {
        crate::input::update_connectivity_info_input::Builder::default()
    }
    /// Creates a new `UpdateConnectivityInfo` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConnectivityInfo {
    type Output = std::result::Result<
        crate::output::UpdateConnectivityInfoOutput,
        crate::error::UpdateConnectivityInfoError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_connectivity_info_error(response)
        } else {
            crate::operation_deser::parse_update_connectivity_info_response(response)
        }
    }
}

/// Operation shape for `UpdateConnectorDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_connector_definition`](crate::client::Client::update_connector_definition).
///
/// See [`crate::client::fluent_builders::UpdateConnectorDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConnectorDefinition {
    _private: (),
}
impl UpdateConnectorDefinition {
    /// Creates a new builder-style object to manufacture [`UpdateConnectorDefinitionInput`](crate::input::UpdateConnectorDefinitionInput)
    pub fn builder() -> crate::input::update_connector_definition_input::Builder {
        crate::input::update_connector_definition_input::Builder::default()
    }
    /// Creates a new `UpdateConnectorDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConnectorDefinition {
    type Output = std::result::Result<
        crate::output::UpdateConnectorDefinitionOutput,
        crate::error::UpdateConnectorDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_connector_definition_error(response)
        } else {
            crate::operation_deser::parse_update_connector_definition_response(response)
        }
    }
}

/// Operation shape for `UpdateCoreDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_core_definition`](crate::client::Client::update_core_definition).
///
/// See [`crate::client::fluent_builders::UpdateCoreDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCoreDefinition {
    _private: (),
}
impl UpdateCoreDefinition {
    /// Creates a new builder-style object to manufacture [`UpdateCoreDefinitionInput`](crate::input::UpdateCoreDefinitionInput)
    pub fn builder() -> crate::input::update_core_definition_input::Builder {
        crate::input::update_core_definition_input::Builder::default()
    }
    /// Creates a new `UpdateCoreDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCoreDefinition {
    type Output = std::result::Result<
        crate::output::UpdateCoreDefinitionOutput,
        crate::error::UpdateCoreDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_core_definition_error(response)
        } else {
            crate::operation_deser::parse_update_core_definition_response(response)
        }
    }
}

/// Operation shape for `UpdateDeviceDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device_definition`](crate::client::Client::update_device_definition).
///
/// See [`crate::client::fluent_builders::UpdateDeviceDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDeviceDefinition {
    _private: (),
}
impl UpdateDeviceDefinition {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceDefinitionInput`](crate::input::UpdateDeviceDefinitionInput)
    pub fn builder() -> crate::input::update_device_definition_input::Builder {
        crate::input::update_device_definition_input::Builder::default()
    }
    /// Creates a new `UpdateDeviceDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDeviceDefinition {
    type Output = std::result::Result<
        crate::output::UpdateDeviceDefinitionOutput,
        crate::error::UpdateDeviceDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_definition_error(response)
        } else {
            crate::operation_deser::parse_update_device_definition_response(response)
        }
    }
}

/// Operation shape for `UpdateFunctionDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_function_definition`](crate::client::Client::update_function_definition).
///
/// See [`crate::client::fluent_builders::UpdateFunctionDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFunctionDefinition {
    _private: (),
}
impl UpdateFunctionDefinition {
    /// Creates a new builder-style object to manufacture [`UpdateFunctionDefinitionInput`](crate::input::UpdateFunctionDefinitionInput)
    pub fn builder() -> crate::input::update_function_definition_input::Builder {
        crate::input::update_function_definition_input::Builder::default()
    }
    /// Creates a new `UpdateFunctionDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFunctionDefinition {
    type Output = std::result::Result<
        crate::output::UpdateFunctionDefinitionOutput,
        crate::error::UpdateFunctionDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_function_definition_error(response)
        } else {
            crate::operation_deser::parse_update_function_definition_response(response)
        }
    }
}

/// Operation shape for `UpdateGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_group`](crate::client::Client::update_group).
///
/// See [`crate::client::fluent_builders::UpdateGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGroup {
    _private: (),
}
impl UpdateGroup {
    /// Creates a new builder-style object to manufacture [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    pub fn builder() -> crate::input::update_group_input::Builder {
        crate::input::update_group_input::Builder::default()
    }
    /// Creates a new `UpdateGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGroup {
    type Output =
        std::result::Result<crate::output::UpdateGroupOutput, crate::error::UpdateGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_group_error(response)
        } else {
            crate::operation_deser::parse_update_group_response(response)
        }
    }
}

/// Operation shape for `UpdateGroupCertificateConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_group_certificate_configuration`](crate::client::Client::update_group_certificate_configuration).
///
/// See [`crate::client::fluent_builders::UpdateGroupCertificateConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGroupCertificateConfiguration {
    _private: (),
}
impl UpdateGroupCertificateConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateGroupCertificateConfigurationInput`](crate::input::UpdateGroupCertificateConfigurationInput)
    pub fn builder() -> crate::input::update_group_certificate_configuration_input::Builder {
        crate::input::update_group_certificate_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateGroupCertificateConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGroupCertificateConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateGroupCertificateConfigurationOutput,
        crate::error::UpdateGroupCertificateConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_group_certificate_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_group_certificate_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateLoggerDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_logger_definition`](crate::client::Client::update_logger_definition).
///
/// See [`crate::client::fluent_builders::UpdateLoggerDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLoggerDefinition {
    _private: (),
}
impl UpdateLoggerDefinition {
    /// Creates a new builder-style object to manufacture [`UpdateLoggerDefinitionInput`](crate::input::UpdateLoggerDefinitionInput)
    pub fn builder() -> crate::input::update_logger_definition_input::Builder {
        crate::input::update_logger_definition_input::Builder::default()
    }
    /// Creates a new `UpdateLoggerDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLoggerDefinition {
    type Output = std::result::Result<
        crate::output::UpdateLoggerDefinitionOutput,
        crate::error::UpdateLoggerDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_logger_definition_error(response)
        } else {
            crate::operation_deser::parse_update_logger_definition_response(response)
        }
    }
}

/// Operation shape for `UpdateResourceDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resource_definition`](crate::client::Client::update_resource_definition).
///
/// See [`crate::client::fluent_builders::UpdateResourceDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResourceDefinition {
    _private: (),
}
impl UpdateResourceDefinition {
    /// Creates a new builder-style object to manufacture [`UpdateResourceDefinitionInput`](crate::input::UpdateResourceDefinitionInput)
    pub fn builder() -> crate::input::update_resource_definition_input::Builder {
        crate::input::update_resource_definition_input::Builder::default()
    }
    /// Creates a new `UpdateResourceDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResourceDefinition {
    type Output = std::result::Result<
        crate::output::UpdateResourceDefinitionOutput,
        crate::error::UpdateResourceDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resource_definition_error(response)
        } else {
            crate::operation_deser::parse_update_resource_definition_response(response)
        }
    }
}

/// Operation shape for `UpdateSubscriptionDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_subscription_definition`](crate::client::Client::update_subscription_definition).
///
/// See [`crate::client::fluent_builders::UpdateSubscriptionDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSubscriptionDefinition {
    _private: (),
}
impl UpdateSubscriptionDefinition {
    /// Creates a new builder-style object to manufacture [`UpdateSubscriptionDefinitionInput`](crate::input::UpdateSubscriptionDefinitionInput)
    pub fn builder() -> crate::input::update_subscription_definition_input::Builder {
        crate::input::update_subscription_definition_input::Builder::default()
    }
    /// Creates a new `UpdateSubscriptionDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSubscriptionDefinition {
    type Output = std::result::Result<
        crate::output::UpdateSubscriptionDefinitionOutput,
        crate::error::UpdateSubscriptionDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_subscription_definition_error(response)
        } else {
            crate::operation_deser::parse_update_subscription_definition_response(response)
        }
    }
}

/// Operation shape for `UpdateThingRuntimeConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_thing_runtime_configuration`](crate::client::Client::update_thing_runtime_configuration).
///
/// See [`crate::client::fluent_builders::UpdateThingRuntimeConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateThingRuntimeConfiguration {
    _private: (),
}
impl UpdateThingRuntimeConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateThingRuntimeConfigurationInput`](crate::input::UpdateThingRuntimeConfigurationInput)
    pub fn builder() -> crate::input::update_thing_runtime_configuration_input::Builder {
        crate::input::update_thing_runtime_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateThingRuntimeConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateThingRuntimeConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateThingRuntimeConfigurationOutput,
        crate::error::UpdateThingRuntimeConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_thing_runtime_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_thing_runtime_configuration_response(response)
        }
    }
}
