// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Details about the error.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDetail {
    /// A detailed error code.
    pub detailed_error_code: std::option::Option<std::string::String>,
    /// A detailed error message.
    pub detailed_error_message: std::option::Option<std::string::String>,
}
impl ErrorDetail {
    /// A detailed error code.
    pub fn detailed_error_code(&self) -> std::option::Option<&str> {
        self.detailed_error_code.as_deref()
    }
    /// A detailed error message.
    pub fn detailed_error_message(&self) -> std::option::Option<&str> {
        self.detailed_error_message.as_deref()
    }
}
impl std::fmt::Debug for ErrorDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDetail");
        formatter.field("detailed_error_code", &self.detailed_error_code);
        formatter.field("detailed_error_message", &self.detailed_error_message);
        formatter.finish()
    }
}
/// See [`ErrorDetail`](crate::model::ErrorDetail)
pub mod error_detail {
    /// A builder for [`ErrorDetail`](crate::model::ErrorDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detailed_error_code: std::option::Option<std::string::String>,
        pub(crate) detailed_error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A detailed error code.
        pub fn detailed_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.detailed_error_code = Some(input.into());
            self
        }
        /// A detailed error code.
        pub fn set_detailed_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detailed_error_code = input;
            self
        }
        /// A detailed error message.
        pub fn detailed_error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.detailed_error_message = Some(input.into());
            self
        }
        /// A detailed error message.
        pub fn set_detailed_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detailed_error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDetail`](crate::model::ErrorDetail)
        pub fn build(self) -> crate::model::ErrorDetail {
            crate::model::ErrorDetail {
                detailed_error_code: self.detailed_error_code,
                detailed_error_message: self.detailed_error_message,
            }
        }
    }
}
impl ErrorDetail {
    /// Creates a new builder-style object to manufacture [`ErrorDetail`](crate::model::ErrorDetail)
    pub fn builder() -> crate::model::error_detail::Builder {
        crate::model::error_detail::Builder::default()
    }
}

/// Configuration settings for running telemetry.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TelemetryConfigurationUpdate {
    /// Configure telemetry to be on or off.
    pub telemetry: std::option::Option<crate::model::Telemetry>,
}
impl TelemetryConfigurationUpdate {
    /// Configure telemetry to be on or off.
    pub fn telemetry(&self) -> std::option::Option<&crate::model::Telemetry> {
        self.telemetry.as_ref()
    }
}
impl std::fmt::Debug for TelemetryConfigurationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TelemetryConfigurationUpdate");
        formatter.field("telemetry", &self.telemetry);
        formatter.finish()
    }
}
/// See [`TelemetryConfigurationUpdate`](crate::model::TelemetryConfigurationUpdate)
pub mod telemetry_configuration_update {
    /// A builder for [`TelemetryConfigurationUpdate`](crate::model::TelemetryConfigurationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) telemetry: std::option::Option<crate::model::Telemetry>,
    }
    impl Builder {
        /// Configure telemetry to be on or off.
        pub fn telemetry(mut self, input: crate::model::Telemetry) -> Self {
            self.telemetry = Some(input);
            self
        }
        /// Configure telemetry to be on or off.
        pub fn set_telemetry(
            mut self,
            input: std::option::Option<crate::model::Telemetry>,
        ) -> Self {
            self.telemetry = input;
            self
        }
        /// Consumes the builder and constructs a [`TelemetryConfigurationUpdate`](crate::model::TelemetryConfigurationUpdate)
        pub fn build(self) -> crate::model::TelemetryConfigurationUpdate {
            crate::model::TelemetryConfigurationUpdate {
                telemetry: self.telemetry,
            }
        }
    }
}
impl TelemetryConfigurationUpdate {
    /// Creates a new builder-style object to manufacture [`TelemetryConfigurationUpdate`](crate::model::TelemetryConfigurationUpdate)
    pub fn builder() -> crate::model::telemetry_configuration_update::Builder {
        crate::model::telemetry_configuration_update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Telemetry {
    #[allow(missing_docs)] // documentation missing in model
    Off,
    #[allow(missing_docs)] // documentation missing in model
    On,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Telemetry {
    fn from(s: &str) -> Self {
        match s {
            "Off" => Telemetry::Off,
            "On" => Telemetry::On,
            other => Telemetry::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Telemetry {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Telemetry::from(s))
    }
}
impl Telemetry {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Telemetry::Off => "Off",
            Telemetry::On => "On",
            Telemetry::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Off", "On"]
    }
}
impl AsRef<str> for Telemetry {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Information about a Greengrass core's connectivity.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectivityInfo {
    /// The endpoint for the Greengrass core. Can be an IP address or DNS.
    pub host_address: std::option::Option<std::string::String>,
    /// The ID of the connectivity information.
    pub id: std::option::Option<std::string::String>,
    /// Metadata for this endpoint.
    pub metadata: std::option::Option<std::string::String>,
    /// The port of the Greengrass core. Usually 8883.
    pub port_number: i32,
}
impl ConnectivityInfo {
    /// The endpoint for the Greengrass core. Can be an IP address or DNS.
    pub fn host_address(&self) -> std::option::Option<&str> {
        self.host_address.as_deref()
    }
    /// The ID of the connectivity information.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// Metadata for this endpoint.
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// The port of the Greengrass core. Usually 8883.
    pub fn port_number(&self) -> i32 {
        self.port_number
    }
}
impl std::fmt::Debug for ConnectivityInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectivityInfo");
        formatter.field("host_address", &self.host_address);
        formatter.field("id", &self.id);
        formatter.field("metadata", &self.metadata);
        formatter.field("port_number", &self.port_number);
        formatter.finish()
    }
}
/// See [`ConnectivityInfo`](crate::model::ConnectivityInfo)
pub mod connectivity_info {
    /// A builder for [`ConnectivityInfo`](crate::model::ConnectivityInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host_address: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) port_number: std::option::Option<i32>,
    }
    impl Builder {
        /// The endpoint for the Greengrass core. Can be an IP address or DNS.
        pub fn host_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_address = Some(input.into());
            self
        }
        /// The endpoint for the Greengrass core. Can be an IP address or DNS.
        pub fn set_host_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_address = input;
            self
        }
        /// The ID of the connectivity information.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the connectivity information.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Metadata for this endpoint.
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// Metadata for this endpoint.
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// The port of the Greengrass core. Usually 8883.
        pub fn port_number(mut self, input: i32) -> Self {
            self.port_number = Some(input);
            self
        }
        /// The port of the Greengrass core. Usually 8883.
        pub fn set_port_number(mut self, input: std::option::Option<i32>) -> Self {
            self.port_number = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectivityInfo`](crate::model::ConnectivityInfo)
        pub fn build(self) -> crate::model::ConnectivityInfo {
            crate::model::ConnectivityInfo {
                host_address: self.host_address,
                id: self.id,
                metadata: self.metadata,
                port_number: self.port_number.unwrap_or_default(),
            }
        }
    }
}
impl ConnectivityInfo {
    /// Creates a new builder-style object to manufacture [`ConnectivityInfo`](crate::model::ConnectivityInfo)
    pub fn builder() -> crate::model::connectivity_info::Builder {
        crate::model::connectivity_info::Builder::default()
    }
}

/// Information about a version.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VersionInformation {
    /// The ARN of the version.
    pub arn: std::option::Option<std::string::String>,
    /// The time, in milliseconds since the epoch, when the version was created.
    pub creation_timestamp: std::option::Option<std::string::String>,
    /// The ID of the parent definition that the version is associated with.
    pub id: std::option::Option<std::string::String>,
    /// The ID of the version.
    pub version: std::option::Option<std::string::String>,
}
impl VersionInformation {
    /// The ARN of the version.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The time, in milliseconds since the epoch, when the version was created.
    pub fn creation_timestamp(&self) -> std::option::Option<&str> {
        self.creation_timestamp.as_deref()
    }
    /// The ID of the parent definition that the version is associated with.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The ID of the version.
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for VersionInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VersionInformation");
        formatter.field("arn", &self.arn);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("id", &self.id);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`VersionInformation`](crate::model::VersionInformation)
pub mod version_information {
    /// A builder for [`VersionInformation`](crate::model::VersionInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the version.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the version.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The time, in milliseconds since the epoch, when the version was created.
        pub fn creation_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_timestamp = Some(input.into());
            self
        }
        /// The time, in milliseconds since the epoch, when the version was created.
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// The ID of the parent definition that the version is associated with.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the parent definition that the version is associated with.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The ID of the version.
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// The ID of the version.
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`VersionInformation`](crate::model::VersionInformation)
        pub fn build(self) -> crate::model::VersionInformation {
            crate::model::VersionInformation {
                arn: self.arn,
                creation_timestamp: self.creation_timestamp,
                id: self.id,
                version: self.version,
            }
        }
    }
}
impl VersionInformation {
    /// Creates a new builder-style object to manufacture [`VersionInformation`](crate::model::VersionInformation)
    pub fn builder() -> crate::model::version_information::Builder {
        crate::model::version_information::Builder::default()
    }
}

/// Information about a definition.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefinitionInformation {
    /// The ARN of the definition.
    pub arn: std::option::Option<std::string::String>,
    /// The time, in milliseconds since the epoch, when the definition was created.
    pub creation_timestamp: std::option::Option<std::string::String>,
    /// The ID of the definition.
    pub id: std::option::Option<std::string::String>,
    /// The time, in milliseconds since the epoch, when the definition was last updated.
    pub last_updated_timestamp: std::option::Option<std::string::String>,
    /// The ID of the latest version associated with the definition.
    pub latest_version: std::option::Option<std::string::String>,
    /// The ARN of the latest version associated with the definition.
    pub latest_version_arn: std::option::Option<std::string::String>,
    /// The name of the definition.
    pub name: std::option::Option<std::string::String>,
    /// Tag(s) attached to the resource arn.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DefinitionInformation {
    /// The ARN of the definition.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The time, in milliseconds since the epoch, when the definition was created.
    pub fn creation_timestamp(&self) -> std::option::Option<&str> {
        self.creation_timestamp.as_deref()
    }
    /// The ID of the definition.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The time, in milliseconds since the epoch, when the definition was last updated.
    pub fn last_updated_timestamp(&self) -> std::option::Option<&str> {
        self.last_updated_timestamp.as_deref()
    }
    /// The ID of the latest version associated with the definition.
    pub fn latest_version(&self) -> std::option::Option<&str> {
        self.latest_version.as_deref()
    }
    /// The ARN of the latest version associated with the definition.
    pub fn latest_version_arn(&self) -> std::option::Option<&str> {
        self.latest_version_arn.as_deref()
    }
    /// The name of the definition.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Tag(s) attached to the resource arn.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DefinitionInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefinitionInformation");
        formatter.field("arn", &self.arn);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("id", &self.id);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("latest_version", &self.latest_version);
        formatter.field("latest_version_arn", &self.latest_version_arn);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DefinitionInformation`](crate::model::DefinitionInformation)
pub mod definition_information {
    /// A builder for [`DefinitionInformation`](crate::model::DefinitionInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) last_updated_timestamp: std::option::Option<std::string::String>,
        pub(crate) latest_version: std::option::Option<std::string::String>,
        pub(crate) latest_version_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the definition.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the definition.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The time, in milliseconds since the epoch, when the definition was created.
        pub fn creation_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_timestamp = Some(input.into());
            self
        }
        /// The time, in milliseconds since the epoch, when the definition was created.
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// The ID of the definition.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the definition.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The time, in milliseconds since the epoch, when the definition was last updated.
        pub fn last_updated_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_timestamp = Some(input.into());
            self
        }
        /// The time, in milliseconds since the epoch, when the definition was last updated.
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// The ID of the latest version associated with the definition.
        pub fn latest_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_version = Some(input.into());
            self
        }
        /// The ID of the latest version associated with the definition.
        pub fn set_latest_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_version = input;
            self
        }
        /// The ARN of the latest version associated with the definition.
        pub fn latest_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_version_arn = Some(input.into());
            self
        }
        /// The ARN of the latest version associated with the definition.
        pub fn set_latest_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_version_arn = input;
            self
        }
        /// The name of the definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) attached to the resource arn.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Tag(s) attached to the resource arn.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DefinitionInformation`](crate::model::DefinitionInformation)
        pub fn build(self) -> crate::model::DefinitionInformation {
            crate::model::DefinitionInformation {
                arn: self.arn,
                creation_timestamp: self.creation_timestamp,
                id: self.id,
                last_updated_timestamp: self.last_updated_timestamp,
                latest_version: self.latest_version,
                latest_version_arn: self.latest_version_arn,
                name: self.name,
                tags: self.tags,
            }
        }
    }
}
impl DefinitionInformation {
    /// Creates a new builder-style object to manufacture [`DefinitionInformation`](crate::model::DefinitionInformation)
    pub fn builder() -> crate::model::definition_information::Builder {
        crate::model::definition_information::Builder::default()
    }
}

/// Information about a group.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupInformation {
    /// The ARN of the group.
    pub arn: std::option::Option<std::string::String>,
    /// The time, in milliseconds since the epoch, when the group was created.
    pub creation_timestamp: std::option::Option<std::string::String>,
    /// The ID of the group.
    pub id: std::option::Option<std::string::String>,
    /// The time, in milliseconds since the epoch, when the group was last updated.
    pub last_updated_timestamp: std::option::Option<std::string::String>,
    /// The ID of the latest version associated with the group.
    pub latest_version: std::option::Option<std::string::String>,
    /// The ARN of the latest version associated with the group.
    pub latest_version_arn: std::option::Option<std::string::String>,
    /// The name of the group.
    pub name: std::option::Option<std::string::String>,
}
impl GroupInformation {
    /// The ARN of the group.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The time, in milliseconds since the epoch, when the group was created.
    pub fn creation_timestamp(&self) -> std::option::Option<&str> {
        self.creation_timestamp.as_deref()
    }
    /// The ID of the group.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The time, in milliseconds since the epoch, when the group was last updated.
    pub fn last_updated_timestamp(&self) -> std::option::Option<&str> {
        self.last_updated_timestamp.as_deref()
    }
    /// The ID of the latest version associated with the group.
    pub fn latest_version(&self) -> std::option::Option<&str> {
        self.latest_version.as_deref()
    }
    /// The ARN of the latest version associated with the group.
    pub fn latest_version_arn(&self) -> std::option::Option<&str> {
        self.latest_version_arn.as_deref()
    }
    /// The name of the group.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GroupInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupInformation");
        formatter.field("arn", &self.arn);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("id", &self.id);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("latest_version", &self.latest_version);
        formatter.field("latest_version_arn", &self.latest_version_arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`GroupInformation`](crate::model::GroupInformation)
pub mod group_information {
    /// A builder for [`GroupInformation`](crate::model::GroupInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) last_updated_timestamp: std::option::Option<std::string::String>,
        pub(crate) latest_version: std::option::Option<std::string::String>,
        pub(crate) latest_version_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the group.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the group.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The time, in milliseconds since the epoch, when the group was created.
        pub fn creation_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_timestamp = Some(input.into());
            self
        }
        /// The time, in milliseconds since the epoch, when the group was created.
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// The ID of the group.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The ID of the group.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The time, in milliseconds since the epoch, when the group was last updated.
        pub fn last_updated_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_timestamp = Some(input.into());
            self
        }
        /// The time, in milliseconds since the epoch, when the group was last updated.
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// The ID of the latest version associated with the group.
        pub fn latest_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_version = Some(input.into());
            self
        }
        /// The ID of the latest version associated with the group.
        pub fn set_latest_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_version = input;
            self
        }
        /// The ARN of the latest version associated with the group.
        pub fn latest_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_version_arn = Some(input.into());
            self
        }
        /// The ARN of the latest version associated with the group.
        pub fn set_latest_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_version_arn = input;
            self
        }
        /// The name of the group.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the group.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupInformation`](crate::model::GroupInformation)
        pub fn build(self) -> crate::model::GroupInformation {
            crate::model::GroupInformation {
                arn: self.arn,
                creation_timestamp: self.creation_timestamp,
                id: self.id,
                last_updated_timestamp: self.last_updated_timestamp,
                latest_version: self.latest_version,
                latest_version_arn: self.latest_version_arn,
                name: self.name,
            }
        }
    }
}
impl GroupInformation {
    /// Creates a new builder-style object to manufacture [`GroupInformation`](crate::model::GroupInformation)
    pub fn builder() -> crate::model::group_information::Builder {
        crate::model::group_information::Builder::default()
    }
}

/// Information about a certificate authority for a group.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupCertificateAuthorityProperties {
    /// The ARN of the certificate authority for the group.
    pub group_certificate_authority_arn: std::option::Option<std::string::String>,
    /// The ID of the certificate authority for the group.
    pub group_certificate_authority_id: std::option::Option<std::string::String>,
}
impl GroupCertificateAuthorityProperties {
    /// The ARN of the certificate authority for the group.
    pub fn group_certificate_authority_arn(&self) -> std::option::Option<&str> {
        self.group_certificate_authority_arn.as_deref()
    }
    /// The ID of the certificate authority for the group.
    pub fn group_certificate_authority_id(&self) -> std::option::Option<&str> {
        self.group_certificate_authority_id.as_deref()
    }
}
impl std::fmt::Debug for GroupCertificateAuthorityProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupCertificateAuthorityProperties");
        formatter.field(
            "group_certificate_authority_arn",
            &self.group_certificate_authority_arn,
        );
        formatter.field(
            "group_certificate_authority_id",
            &self.group_certificate_authority_id,
        );
        formatter.finish()
    }
}
/// See [`GroupCertificateAuthorityProperties`](crate::model::GroupCertificateAuthorityProperties)
pub mod group_certificate_authority_properties {
    /// A builder for [`GroupCertificateAuthorityProperties`](crate::model::GroupCertificateAuthorityProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_certificate_authority_arn: std::option::Option<std::string::String>,
        pub(crate) group_certificate_authority_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the certificate authority for the group.
        pub fn group_certificate_authority_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.group_certificate_authority_arn = Some(input.into());
            self
        }
        /// The ARN of the certificate authority for the group.
        pub fn set_group_certificate_authority_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_certificate_authority_arn = input;
            self
        }
        /// The ID of the certificate authority for the group.
        pub fn group_certificate_authority_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.group_certificate_authority_id = Some(input.into());
            self
        }
        /// The ID of the certificate authority for the group.
        pub fn set_group_certificate_authority_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_certificate_authority_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupCertificateAuthorityProperties`](crate::model::GroupCertificateAuthorityProperties)
        pub fn build(self) -> crate::model::GroupCertificateAuthorityProperties {
            crate::model::GroupCertificateAuthorityProperties {
                group_certificate_authority_arn: self.group_certificate_authority_arn,
                group_certificate_authority_id: self.group_certificate_authority_id,
            }
        }
    }
}
impl GroupCertificateAuthorityProperties {
    /// Creates a new builder-style object to manufacture [`GroupCertificateAuthorityProperties`](crate::model::GroupCertificateAuthorityProperties)
    pub fn builder() -> crate::model::group_certificate_authority_properties::Builder {
        crate::model::group_certificate_authority_properties::Builder::default()
    }
}

/// Information about a deployment.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Deployment {
    /// The time, in milliseconds since the epoch, when the deployment was created.
    pub created_at: std::option::Option<std::string::String>,
    /// The ARN of the deployment.
    pub deployment_arn: std::option::Option<std::string::String>,
    /// The ID of the deployment.
    pub deployment_id: std::option::Option<std::string::String>,
    /// The type of the deployment.
    pub deployment_type: std::option::Option<crate::model::DeploymentType>,
    /// The ARN of the group for this deployment.
    pub group_arn: std::option::Option<std::string::String>,
}
impl Deployment {
    /// The time, in milliseconds since the epoch, when the deployment was created.
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
    /// The ARN of the deployment.
    pub fn deployment_arn(&self) -> std::option::Option<&str> {
        self.deployment_arn.as_deref()
    }
    /// The ID of the deployment.
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// The type of the deployment.
    pub fn deployment_type(&self) -> std::option::Option<&crate::model::DeploymentType> {
        self.deployment_type.as_ref()
    }
    /// The ARN of the group for this deployment.
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
}
impl std::fmt::Debug for Deployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Deployment");
        formatter.field("created_at", &self.created_at);
        formatter.field("deployment_arn", &self.deployment_arn);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("group_arn", &self.group_arn);
        formatter.finish()
    }
}
/// See [`Deployment`](crate::model::Deployment)
pub mod deployment {
    /// A builder for [`Deployment`](crate::model::Deployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) deployment_arn: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_type: std::option::Option<crate::model::DeploymentType>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The time, in milliseconds since the epoch, when the deployment was created.
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// The time, in milliseconds since the epoch, when the deployment was created.
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// The ARN of the deployment.
        pub fn deployment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_arn = Some(input.into());
            self
        }
        /// The ARN of the deployment.
        pub fn set_deployment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_arn = input;
            self
        }
        /// The ID of the deployment.
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// The ID of the deployment.
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// The type of the deployment.
        pub fn deployment_type(mut self, input: crate::model::DeploymentType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// The type of the deployment.
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// The ARN of the group for this deployment.
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// The ARN of the group for this deployment.
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Deployment`](crate::model::Deployment)
        pub fn build(self) -> crate::model::Deployment {
            crate::model::Deployment {
                created_at: self.created_at,
                deployment_arn: self.deployment_arn,
                deployment_id: self.deployment_id,
                deployment_type: self.deployment_type,
                group_arn: self.group_arn,
            }
        }
    }
}
impl Deployment {
    /// Creates a new builder-style object to manufacture [`Deployment`](crate::model::Deployment)
    pub fn builder() -> crate::model::deployment::Builder {
        crate::model::deployment::Builder::default()
    }
}

/// The type of deployment. When used for ''CreateDeployment'', only ''NewDeployment'' and ''Redeployment'' are valid.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentType {
    #[allow(missing_docs)] // documentation missing in model
    ForceResetDeployment,
    #[allow(missing_docs)] // documentation missing in model
    NewDeployment,
    #[allow(missing_docs)] // documentation missing in model
    Redeployment,
    #[allow(missing_docs)] // documentation missing in model
    ResetDeployment,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentType {
    fn from(s: &str) -> Self {
        match s {
            "ForceResetDeployment" => DeploymentType::ForceResetDeployment,
            "NewDeployment" => DeploymentType::NewDeployment,
            "Redeployment" => DeploymentType::Redeployment,
            "ResetDeployment" => DeploymentType::ResetDeployment,
            other => DeploymentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentType::from(s))
    }
}
impl DeploymentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentType::ForceResetDeployment => "ForceResetDeployment",
            DeploymentType::NewDeployment => "NewDeployment",
            DeploymentType::Redeployment => "Redeployment",
            DeploymentType::ResetDeployment => "ResetDeployment",
            DeploymentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ForceResetDeployment",
            "NewDeployment",
            "Redeployment",
            "ResetDeployment",
        ]
    }
}
impl AsRef<str> for DeploymentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Information about a bulk deployment. You cannot start a new bulk deployment while another one is still running or in a non-terminal state.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BulkDeployment {
    /// The ARN of the bulk deployment.
    pub bulk_deployment_arn: std::option::Option<std::string::String>,
    /// The ID of the bulk deployment.
    pub bulk_deployment_id: std::option::Option<std::string::String>,
    /// The time, in ISO format, when the deployment was created.
    pub created_at: std::option::Option<std::string::String>,
}
impl BulkDeployment {
    /// The ARN of the bulk deployment.
    pub fn bulk_deployment_arn(&self) -> std::option::Option<&str> {
        self.bulk_deployment_arn.as_deref()
    }
    /// The ID of the bulk deployment.
    pub fn bulk_deployment_id(&self) -> std::option::Option<&str> {
        self.bulk_deployment_id.as_deref()
    }
    /// The time, in ISO format, when the deployment was created.
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
}
impl std::fmt::Debug for BulkDeployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BulkDeployment");
        formatter.field("bulk_deployment_arn", &self.bulk_deployment_arn);
        formatter.field("bulk_deployment_id", &self.bulk_deployment_id);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`BulkDeployment`](crate::model::BulkDeployment)
pub mod bulk_deployment {
    /// A builder for [`BulkDeployment`](crate::model::BulkDeployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bulk_deployment_arn: std::option::Option<std::string::String>,
        pub(crate) bulk_deployment_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the bulk deployment.
        pub fn bulk_deployment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bulk_deployment_arn = Some(input.into());
            self
        }
        /// The ARN of the bulk deployment.
        pub fn set_bulk_deployment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bulk_deployment_arn = input;
            self
        }
        /// The ID of the bulk deployment.
        pub fn bulk_deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bulk_deployment_id = Some(input.into());
            self
        }
        /// The ID of the bulk deployment.
        pub fn set_bulk_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bulk_deployment_id = input;
            self
        }
        /// The time, in ISO format, when the deployment was created.
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// The time, in ISO format, when the deployment was created.
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`BulkDeployment`](crate::model::BulkDeployment)
        pub fn build(self) -> crate::model::BulkDeployment {
            crate::model::BulkDeployment {
                bulk_deployment_arn: self.bulk_deployment_arn,
                bulk_deployment_id: self.bulk_deployment_id,
                created_at: self.created_at,
            }
        }
    }
}
impl BulkDeployment {
    /// Creates a new builder-style object to manufacture [`BulkDeployment`](crate::model::BulkDeployment)
    pub fn builder() -> crate::model::bulk_deployment::Builder {
        crate::model::bulk_deployment::Builder::default()
    }
}

/// Information about an individual group deployment in a bulk deployment operation.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BulkDeploymentResult {
    /// The time, in ISO format, when the deployment was created.
    pub created_at: std::option::Option<std::string::String>,
    /// The ARN of the group deployment.
    pub deployment_arn: std::option::Option<std::string::String>,
    /// The ID of the group deployment.
    pub deployment_id: std::option::Option<std::string::String>,
    /// The current status of the group deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
    pub deployment_status: std::option::Option<std::string::String>,
    /// The type of the deployment.
    pub deployment_type: std::option::Option<crate::model::DeploymentType>,
    /// Details about the error.
    pub error_details: std::option::Option<std::vec::Vec<crate::model::ErrorDetail>>,
    /// The error message for a failed deployment
    pub error_message: std::option::Option<std::string::String>,
    /// The ARN of the Greengrass group.
    pub group_arn: std::option::Option<std::string::String>,
}
impl BulkDeploymentResult {
    /// The time, in ISO format, when the deployment was created.
    pub fn created_at(&self) -> std::option::Option<&str> {
        self.created_at.as_deref()
    }
    /// The ARN of the group deployment.
    pub fn deployment_arn(&self) -> std::option::Option<&str> {
        self.deployment_arn.as_deref()
    }
    /// The ID of the group deployment.
    pub fn deployment_id(&self) -> std::option::Option<&str> {
        self.deployment_id.as_deref()
    }
    /// The current status of the group deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
    pub fn deployment_status(&self) -> std::option::Option<&str> {
        self.deployment_status.as_deref()
    }
    /// The type of the deployment.
    pub fn deployment_type(&self) -> std::option::Option<&crate::model::DeploymentType> {
        self.deployment_type.as_ref()
    }
    /// Details about the error.
    pub fn error_details(&self) -> std::option::Option<&[crate::model::ErrorDetail]> {
        self.error_details.as_deref()
    }
    /// The error message for a failed deployment
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// The ARN of the Greengrass group.
    pub fn group_arn(&self) -> std::option::Option<&str> {
        self.group_arn.as_deref()
    }
}
impl std::fmt::Debug for BulkDeploymentResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BulkDeploymentResult");
        formatter.field("created_at", &self.created_at);
        formatter.field("deployment_arn", &self.deployment_arn);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_status", &self.deployment_status);
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("error_details", &self.error_details);
        formatter.field("error_message", &self.error_message);
        formatter.field("group_arn", &self.group_arn);
        formatter.finish()
    }
}
/// See [`BulkDeploymentResult`](crate::model::BulkDeploymentResult)
pub mod bulk_deployment_result {
    /// A builder for [`BulkDeploymentResult`](crate::model::BulkDeploymentResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_at: std::option::Option<std::string::String>,
        pub(crate) deployment_arn: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_status: std::option::Option<std::string::String>,
        pub(crate) deployment_type: std::option::Option<crate::model::DeploymentType>,
        pub(crate) error_details: std::option::Option<std::vec::Vec<crate::model::ErrorDetail>>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The time, in ISO format, when the deployment was created.
        pub fn created_at(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_at = Some(input.into());
            self
        }
        /// The time, in ISO format, when the deployment was created.
        pub fn set_created_at(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_at = input;
            self
        }
        /// The ARN of the group deployment.
        pub fn deployment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_arn = Some(input.into());
            self
        }
        /// The ARN of the group deployment.
        pub fn set_deployment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_arn = input;
            self
        }
        /// The ID of the group deployment.
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// The ID of the group deployment.
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// The current status of the group deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
        pub fn deployment_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_status = Some(input.into());
            self
        }
        /// The current status of the group deployment: ''InProgress'', ''Building'', ''Success'', or ''Failure''.
        pub fn set_deployment_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_status = input;
            self
        }
        /// The type of the deployment.
        pub fn deployment_type(mut self, input: crate::model::DeploymentType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// The type of the deployment.
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// Appends an item to `error_details`.
        ///
        /// To override the contents of this collection use [`set_error_details`](Self::set_error_details).
        ///
        /// Details about the error.
        pub fn error_details(mut self, input: crate::model::ErrorDetail) -> Self {
            let mut v = self.error_details.unwrap_or_default();
            v.push(input);
            self.error_details = Some(v);
            self
        }
        /// Details about the error.
        pub fn set_error_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ErrorDetail>>,
        ) -> Self {
            self.error_details = input;
            self
        }
        /// The error message for a failed deployment
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// The error message for a failed deployment
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// The ARN of the Greengrass group.
        pub fn group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_arn = Some(input.into());
            self
        }
        /// The ARN of the Greengrass group.
        pub fn set_group_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BulkDeploymentResult`](crate::model::BulkDeploymentResult)
        pub fn build(self) -> crate::model::BulkDeploymentResult {
            crate::model::BulkDeploymentResult {
                created_at: self.created_at,
                deployment_arn: self.deployment_arn,
                deployment_id: self.deployment_id,
                deployment_status: self.deployment_status,
                deployment_type: self.deployment_type,
                error_details: self.error_details,
                error_message: self.error_message,
                group_arn: self.group_arn,
            }
        }
    }
}
impl BulkDeploymentResult {
    /// Creates a new builder-style object to manufacture [`BulkDeploymentResult`](crate::model::BulkDeploymentResult)
    pub fn builder() -> crate::model::bulk_deployment_result::Builder {
        crate::model::bulk_deployment_result::Builder::default()
    }
}

/// Runtime configuration for a thing.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuntimeConfiguration {
    /// Configuration for telemetry service.
    pub telemetry_configuration: std::option::Option<crate::model::TelemetryConfiguration>,
}
impl RuntimeConfiguration {
    /// Configuration for telemetry service.
    pub fn telemetry_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TelemetryConfiguration> {
        self.telemetry_configuration.as_ref()
    }
}
impl std::fmt::Debug for RuntimeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuntimeConfiguration");
        formatter.field("telemetry_configuration", &self.telemetry_configuration);
        formatter.finish()
    }
}
/// See [`RuntimeConfiguration`](crate::model::RuntimeConfiguration)
pub mod runtime_configuration {
    /// A builder for [`RuntimeConfiguration`](crate::model::RuntimeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) telemetry_configuration:
            std::option::Option<crate::model::TelemetryConfiguration>,
    }
    impl Builder {
        /// Configuration for telemetry service.
        pub fn telemetry_configuration(
            mut self,
            input: crate::model::TelemetryConfiguration,
        ) -> Self {
            self.telemetry_configuration = Some(input);
            self
        }
        /// Configuration for telemetry service.
        pub fn set_telemetry_configuration(
            mut self,
            input: std::option::Option<crate::model::TelemetryConfiguration>,
        ) -> Self {
            self.telemetry_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`RuntimeConfiguration`](crate::model::RuntimeConfiguration)
        pub fn build(self) -> crate::model::RuntimeConfiguration {
            crate::model::RuntimeConfiguration {
                telemetry_configuration: self.telemetry_configuration,
            }
        }
    }
}
impl RuntimeConfiguration {
    /// Creates a new builder-style object to manufacture [`RuntimeConfiguration`](crate::model::RuntimeConfiguration)
    pub fn builder() -> crate::model::runtime_configuration::Builder {
        crate::model::runtime_configuration::Builder::default()
    }
}

/// Configuration settings for running telemetry.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TelemetryConfiguration {
    /// Synchronization status of the device reported configuration with the desired configuration.
    pub configuration_sync_status: std::option::Option<crate::model::ConfigurationSyncStatus>,
    /// Configure telemetry to be on or off.
    pub telemetry: std::option::Option<crate::model::Telemetry>,
}
impl TelemetryConfiguration {
    /// Synchronization status of the device reported configuration with the desired configuration.
    pub fn configuration_sync_status(
        &self,
    ) -> std::option::Option<&crate::model::ConfigurationSyncStatus> {
        self.configuration_sync_status.as_ref()
    }
    /// Configure telemetry to be on or off.
    pub fn telemetry(&self) -> std::option::Option<&crate::model::Telemetry> {
        self.telemetry.as_ref()
    }
}
impl std::fmt::Debug for TelemetryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TelemetryConfiguration");
        formatter.field("configuration_sync_status", &self.configuration_sync_status);
        formatter.field("telemetry", &self.telemetry);
        formatter.finish()
    }
}
/// See [`TelemetryConfiguration`](crate::model::TelemetryConfiguration)
pub mod telemetry_configuration {
    /// A builder for [`TelemetryConfiguration`](crate::model::TelemetryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_sync_status:
            std::option::Option<crate::model::ConfigurationSyncStatus>,
        pub(crate) telemetry: std::option::Option<crate::model::Telemetry>,
    }
    impl Builder {
        /// Synchronization status of the device reported configuration with the desired configuration.
        pub fn configuration_sync_status(
            mut self,
            input: crate::model::ConfigurationSyncStatus,
        ) -> Self {
            self.configuration_sync_status = Some(input);
            self
        }
        /// Synchronization status of the device reported configuration with the desired configuration.
        pub fn set_configuration_sync_status(
            mut self,
            input: std::option::Option<crate::model::ConfigurationSyncStatus>,
        ) -> Self {
            self.configuration_sync_status = input;
            self
        }
        /// Configure telemetry to be on or off.
        pub fn telemetry(mut self, input: crate::model::Telemetry) -> Self {
            self.telemetry = Some(input);
            self
        }
        /// Configure telemetry to be on or off.
        pub fn set_telemetry(
            mut self,
            input: std::option::Option<crate::model::Telemetry>,
        ) -> Self {
            self.telemetry = input;
            self
        }
        /// Consumes the builder and constructs a [`TelemetryConfiguration`](crate::model::TelemetryConfiguration)
        pub fn build(self) -> crate::model::TelemetryConfiguration {
            crate::model::TelemetryConfiguration {
                configuration_sync_status: self.configuration_sync_status,
                telemetry: self.telemetry,
            }
        }
    }
}
impl TelemetryConfiguration {
    /// Creates a new builder-style object to manufacture [`TelemetryConfiguration`](crate::model::TelemetryConfiguration)
    pub fn builder() -> crate::model::telemetry_configuration::Builder {
        crate::model::telemetry_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationSyncStatus {
    #[allow(missing_docs)] // documentation missing in model
    InSync,
    #[allow(missing_docs)] // documentation missing in model
    OutOfSync,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationSyncStatus {
    fn from(s: &str) -> Self {
        match s {
            "InSync" => ConfigurationSyncStatus::InSync,
            "OutOfSync" => ConfigurationSyncStatus::OutOfSync,
            other => ConfigurationSyncStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationSyncStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationSyncStatus::from(s))
    }
}
impl ConfigurationSyncStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationSyncStatus::InSync => "InSync",
            ConfigurationSyncStatus::OutOfSync => "OutOfSync",
            ConfigurationSyncStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["InSync", "OutOfSync"]
    }
}
impl AsRef<str> for ConfigurationSyncStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Information about a subscription definition version.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionDefinitionVersion {
    /// A list of subscriptions.
    pub subscriptions: std::option::Option<std::vec::Vec<crate::model::Subscription>>,
}
impl SubscriptionDefinitionVersion {
    /// A list of subscriptions.
    pub fn subscriptions(&self) -> std::option::Option<&[crate::model::Subscription]> {
        self.subscriptions.as_deref()
    }
}
impl std::fmt::Debug for SubscriptionDefinitionVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionDefinitionVersion");
        formatter.field("subscriptions", &self.subscriptions);
        formatter.finish()
    }
}
/// See [`SubscriptionDefinitionVersion`](crate::model::SubscriptionDefinitionVersion)
pub mod subscription_definition_version {
    /// A builder for [`SubscriptionDefinitionVersion`](crate::model::SubscriptionDefinitionVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscriptions: std::option::Option<std::vec::Vec<crate::model::Subscription>>,
    }
    impl Builder {
        /// Appends an item to `subscriptions`.
        ///
        /// To override the contents of this collection use [`set_subscriptions`](Self::set_subscriptions).
        ///
        /// A list of subscriptions.
        pub fn subscriptions(mut self, input: crate::model::Subscription) -> Self {
            let mut v = self.subscriptions.unwrap_or_default();
            v.push(input);
            self.subscriptions = Some(v);
            self
        }
        /// A list of subscriptions.
        pub fn set_subscriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscription>>,
        ) -> Self {
            self.subscriptions = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionDefinitionVersion`](crate::model::SubscriptionDefinitionVersion)
        pub fn build(self) -> crate::model::SubscriptionDefinitionVersion {
            crate::model::SubscriptionDefinitionVersion {
                subscriptions: self.subscriptions,
            }
        }
    }
}
impl SubscriptionDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`SubscriptionDefinitionVersion`](crate::model::SubscriptionDefinitionVersion)
    pub fn builder() -> crate::model::subscription_definition_version::Builder {
        crate::model::subscription_definition_version::Builder::default()
    }
}

/// Information about a subscription.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subscription {
    /// A descriptive or arbitrary ID for the subscription. This value must be unique within the subscription definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
    pub id: std::option::Option<std::string::String>,
    /// The source of the subscription. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
    pub source: std::option::Option<std::string::String>,
    /// The MQTT topic used to route the message.
    pub subject: std::option::Option<std::string::String>,
    /// Where the message is sent to. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
    pub target: std::option::Option<std::string::String>,
}
impl Subscription {
    /// A descriptive or arbitrary ID for the subscription. This value must be unique within the subscription definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The source of the subscription. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// The MQTT topic used to route the message.
    pub fn subject(&self) -> std::option::Option<&str> {
        self.subject.as_deref()
    }
    /// Where the message is sent to. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
    pub fn target(&self) -> std::option::Option<&str> {
        self.target.as_deref()
    }
}
impl std::fmt::Debug for Subscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subscription");
        formatter.field("id", &self.id);
        formatter.field("source", &self.source);
        formatter.field("subject", &self.subject);
        formatter.field("target", &self.target);
        formatter.finish()
    }
}
/// See [`Subscription`](crate::model::Subscription)
pub mod subscription {
    /// A builder for [`Subscription`](crate::model::Subscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A descriptive or arbitrary ID for the subscription. This value must be unique within the subscription definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// A descriptive or arbitrary ID for the subscription. This value must be unique within the subscription definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The source of the subscription. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// The source of the subscription. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// The MQTT topic used to route the message.
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// The MQTT topic used to route the message.
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// Where the message is sent to. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// Where the message is sent to. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`Subscription`](crate::model::Subscription)
        pub fn build(self) -> crate::model::Subscription {
            crate::model::Subscription {
                id: self.id,
                source: self.source,
                subject: self.subject,
                target: self.target,
            }
        }
    }
}
impl Subscription {
    /// Creates a new builder-style object to manufacture [`Subscription`](crate::model::Subscription)
    pub fn builder() -> crate::model::subscription::Builder {
        crate::model::subscription::Builder::default()
    }
}

/// Information about a resource definition version.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDefinitionVersion {
    /// A list of resources.
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
}
impl ResourceDefinitionVersion {
    /// A list of resources.
    pub fn resources(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.resources.as_deref()
    }
}
impl std::fmt::Debug for ResourceDefinitionVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDefinitionVersion");
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`ResourceDefinitionVersion`](crate::model::ResourceDefinitionVersion)
pub mod resource_definition_version {
    /// A builder for [`ResourceDefinitionVersion`](crate::model::ResourceDefinitionVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// A list of resources.
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// A list of resources.
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDefinitionVersion`](crate::model::ResourceDefinitionVersion)
        pub fn build(self) -> crate::model::ResourceDefinitionVersion {
            crate::model::ResourceDefinitionVersion {
                resources: self.resources,
            }
        }
    }
}
impl ResourceDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`ResourceDefinitionVersion`](crate::model::ResourceDefinitionVersion)
    pub fn builder() -> crate::model::resource_definition_version::Builder {
        crate::model::resource_definition_version::Builder::default()
    }
}

/// Information about a resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// The resource ID, used to refer to a resource in the Lambda function configuration. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
    pub id: std::option::Option<std::string::String>,
    /// The descriptive resource name, which is displayed on the AWS IoT Greengrass console. Max length 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
    pub name: std::option::Option<std::string::String>,
    /// A container of data for all resource types.
    pub resource_data_container: std::option::Option<crate::model::ResourceDataContainer>,
}
impl Resource {
    /// The resource ID, used to refer to a resource in the Lambda function configuration. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The descriptive resource name, which is displayed on the AWS IoT Greengrass console. Max length 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// A container of data for all resource types.
    pub fn resource_data_container(
        &self,
    ) -> std::option::Option<&crate::model::ResourceDataContainer> {
        self.resource_data_container.as_ref()
    }
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("resource_data_container", &self.resource_data_container);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_data_container:
            std::option::Option<crate::model::ResourceDataContainer>,
    }
    impl Builder {
        /// The resource ID, used to refer to a resource in the Lambda function configuration. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The resource ID, used to refer to a resource in the Lambda function configuration. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The descriptive resource name, which is displayed on the AWS IoT Greengrass console. Max length 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The descriptive resource name, which is displayed on the AWS IoT Greengrass console. Max length 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This must be unique within a Greengrass group.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// A container of data for all resource types.
        pub fn resource_data_container(
            mut self,
            input: crate::model::ResourceDataContainer,
        ) -> Self {
            self.resource_data_container = Some(input);
            self
        }
        /// A container of data for all resource types.
        pub fn set_resource_data_container(
            mut self,
            input: std::option::Option<crate::model::ResourceDataContainer>,
        ) -> Self {
            self.resource_data_container = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                id: self.id,
                name: self.name,
                resource_data_container: self.resource_data_container,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// A container for resource data. The container takes only one of the following supported resource data types: ''LocalDeviceResourceData'', ''LocalVolumeResourceData'', ''SageMakerMachineLearningModelResourceData'', ''S3MachineLearningModelResourceData'', ''SecretsManagerSecretResourceData''.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDataContainer {
    /// Attributes that define the local device resource.
    pub local_device_resource_data: std::option::Option<crate::model::LocalDeviceResourceData>,
    /// Attributes that define the local volume resource.
    pub local_volume_resource_data: std::option::Option<crate::model::LocalVolumeResourceData>,
    /// Attributes that define an Amazon S3 machine learning resource.
    pub s3_machine_learning_model_resource_data:
        std::option::Option<crate::model::S3MachineLearningModelResourceData>,
    /// Attributes that define an Amazon SageMaker machine learning resource.
    pub sage_maker_machine_learning_model_resource_data:
        std::option::Option<crate::model::SageMakerMachineLearningModelResourceData>,
    /// Attributes that define a secret resource, which references a secret from AWS Secrets Manager.
    pub secrets_manager_secret_resource_data:
        std::option::Option<crate::model::SecretsManagerSecretResourceData>,
}
impl ResourceDataContainer {
    /// Attributes that define the local device resource.
    pub fn local_device_resource_data(
        &self,
    ) -> std::option::Option<&crate::model::LocalDeviceResourceData> {
        self.local_device_resource_data.as_ref()
    }
    /// Attributes that define the local volume resource.
    pub fn local_volume_resource_data(
        &self,
    ) -> std::option::Option<&crate::model::LocalVolumeResourceData> {
        self.local_volume_resource_data.as_ref()
    }
    /// Attributes that define an Amazon S3 machine learning resource.
    pub fn s3_machine_learning_model_resource_data(
        &self,
    ) -> std::option::Option<&crate::model::S3MachineLearningModelResourceData> {
        self.s3_machine_learning_model_resource_data.as_ref()
    }
    /// Attributes that define an Amazon SageMaker machine learning resource.
    pub fn sage_maker_machine_learning_model_resource_data(
        &self,
    ) -> std::option::Option<&crate::model::SageMakerMachineLearningModelResourceData> {
        self.sage_maker_machine_learning_model_resource_data
            .as_ref()
    }
    /// Attributes that define a secret resource, which references a secret from AWS Secrets Manager.
    pub fn secrets_manager_secret_resource_data(
        &self,
    ) -> std::option::Option<&crate::model::SecretsManagerSecretResourceData> {
        self.secrets_manager_secret_resource_data.as_ref()
    }
}
impl std::fmt::Debug for ResourceDataContainer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDataContainer");
        formatter.field(
            "local_device_resource_data",
            &self.local_device_resource_data,
        );
        formatter.field(
            "local_volume_resource_data",
            &self.local_volume_resource_data,
        );
        formatter.field(
            "s3_machine_learning_model_resource_data",
            &self.s3_machine_learning_model_resource_data,
        );
        formatter.field(
            "sage_maker_machine_learning_model_resource_data",
            &self.sage_maker_machine_learning_model_resource_data,
        );
        formatter.field(
            "secrets_manager_secret_resource_data",
            &self.secrets_manager_secret_resource_data,
        );
        formatter.finish()
    }
}
/// See [`ResourceDataContainer`](crate::model::ResourceDataContainer)
pub mod resource_data_container {
    /// A builder for [`ResourceDataContainer`](crate::model::ResourceDataContainer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) local_device_resource_data:
            std::option::Option<crate::model::LocalDeviceResourceData>,
        pub(crate) local_volume_resource_data:
            std::option::Option<crate::model::LocalVolumeResourceData>,
        pub(crate) s3_machine_learning_model_resource_data:
            std::option::Option<crate::model::S3MachineLearningModelResourceData>,
        pub(crate) sage_maker_machine_learning_model_resource_data:
            std::option::Option<crate::model::SageMakerMachineLearningModelResourceData>,
        pub(crate) secrets_manager_secret_resource_data:
            std::option::Option<crate::model::SecretsManagerSecretResourceData>,
    }
    impl Builder {
        /// Attributes that define the local device resource.
        pub fn local_device_resource_data(
            mut self,
            input: crate::model::LocalDeviceResourceData,
        ) -> Self {
            self.local_device_resource_data = Some(input);
            self
        }
        /// Attributes that define the local device resource.
        pub fn set_local_device_resource_data(
            mut self,
            input: std::option::Option<crate::model::LocalDeviceResourceData>,
        ) -> Self {
            self.local_device_resource_data = input;
            self
        }
        /// Attributes that define the local volume resource.
        pub fn local_volume_resource_data(
            mut self,
            input: crate::model::LocalVolumeResourceData,
        ) -> Self {
            self.local_volume_resource_data = Some(input);
            self
        }
        /// Attributes that define the local volume resource.
        pub fn set_local_volume_resource_data(
            mut self,
            input: std::option::Option<crate::model::LocalVolumeResourceData>,
        ) -> Self {
            self.local_volume_resource_data = input;
            self
        }
        /// Attributes that define an Amazon S3 machine learning resource.
        pub fn s3_machine_learning_model_resource_data(
            mut self,
            input: crate::model::S3MachineLearningModelResourceData,
        ) -> Self {
            self.s3_machine_learning_model_resource_data = Some(input);
            self
        }
        /// Attributes that define an Amazon S3 machine learning resource.
        pub fn set_s3_machine_learning_model_resource_data(
            mut self,
            input: std::option::Option<crate::model::S3MachineLearningModelResourceData>,
        ) -> Self {
            self.s3_machine_learning_model_resource_data = input;
            self
        }
        /// Attributes that define an Amazon SageMaker machine learning resource.
        pub fn sage_maker_machine_learning_model_resource_data(
            mut self,
            input: crate::model::SageMakerMachineLearningModelResourceData,
        ) -> Self {
            self.sage_maker_machine_learning_model_resource_data = Some(input);
            self
        }
        /// Attributes that define an Amazon SageMaker machine learning resource.
        pub fn set_sage_maker_machine_learning_model_resource_data(
            mut self,
            input: std::option::Option<crate::model::SageMakerMachineLearningModelResourceData>,
        ) -> Self {
            self.sage_maker_machine_learning_model_resource_data = input;
            self
        }
        /// Attributes that define a secret resource, which references a secret from AWS Secrets Manager.
        pub fn secrets_manager_secret_resource_data(
            mut self,
            input: crate::model::SecretsManagerSecretResourceData,
        ) -> Self {
            self.secrets_manager_secret_resource_data = Some(input);
            self
        }
        /// Attributes that define a secret resource, which references a secret from AWS Secrets Manager.
        pub fn set_secrets_manager_secret_resource_data(
            mut self,
            input: std::option::Option<crate::model::SecretsManagerSecretResourceData>,
        ) -> Self {
            self.secrets_manager_secret_resource_data = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDataContainer`](crate::model::ResourceDataContainer)
        pub fn build(self) -> crate::model::ResourceDataContainer {
            crate::model::ResourceDataContainer {
                local_device_resource_data: self.local_device_resource_data,
                local_volume_resource_data: self.local_volume_resource_data,
                s3_machine_learning_model_resource_data: self
                    .s3_machine_learning_model_resource_data,
                sage_maker_machine_learning_model_resource_data: self
                    .sage_maker_machine_learning_model_resource_data,
                secrets_manager_secret_resource_data: self.secrets_manager_secret_resource_data,
            }
        }
    }
}
impl ResourceDataContainer {
    /// Creates a new builder-style object to manufacture [`ResourceDataContainer`](crate::model::ResourceDataContainer)
    pub fn builder() -> crate::model::resource_data_container::Builder {
        crate::model::resource_data_container::Builder::default()
    }
}

/// Attributes that define a secret resource, which references a secret from AWS Secrets Manager. AWS IoT Greengrass stores a local, encrypted copy of the secret on the Greengrass core, where it can be securely accessed by connectors and Lambda functions.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecretsManagerSecretResourceData {
    /// The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest version (represented by the ''AWSCURRENT'' staging label) is included by default.
    pub arn: std::option::Option<std::string::String>,
    /// Optional. The staging labels whose values you want to make available on the core, in addition to ''AWSCURRENT''.
    pub additional_staging_labels_to_download:
        std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SecretsManagerSecretResourceData {
    /// The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest version (represented by the ''AWSCURRENT'' staging label) is included by default.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// Optional. The staging labels whose values you want to make available on the core, in addition to ''AWSCURRENT''.
    pub fn additional_staging_labels_to_download(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.additional_staging_labels_to_download.as_deref()
    }
}
impl std::fmt::Debug for SecretsManagerSecretResourceData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecretsManagerSecretResourceData");
        formatter.field("arn", &self.arn);
        formatter.field(
            "additional_staging_labels_to_download",
            &self.additional_staging_labels_to_download,
        );
        formatter.finish()
    }
}
/// See [`SecretsManagerSecretResourceData`](crate::model::SecretsManagerSecretResourceData)
pub mod secrets_manager_secret_resource_data {
    /// A builder for [`SecretsManagerSecretResourceData`](crate::model::SecretsManagerSecretResourceData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) additional_staging_labels_to_download:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest version (represented by the ''AWSCURRENT'' staging label) is included by default.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The ARN of the Secrets Manager secret to make available on the core. The value of the secret's latest version (represented by the ''AWSCURRENT'' staging label) is included by default.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `additional_staging_labels_to_download`.
        ///
        /// To override the contents of this collection use [`set_additional_staging_labels_to_download`](Self::set_additional_staging_labels_to_download).
        ///
        /// Optional. The staging labels whose values you want to make available on the core, in addition to ''AWSCURRENT''.
        pub fn additional_staging_labels_to_download(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .additional_staging_labels_to_download
                .unwrap_or_default();
            v.push(input.into());
            self.additional_staging_labels_to_download = Some(v);
            self
        }
        /// Optional. The staging labels whose values you want to make available on the core, in addition to ''AWSCURRENT''.
        pub fn set_additional_staging_labels_to_download(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_staging_labels_to_download = input;
            self
        }
        /// Consumes the builder and constructs a [`SecretsManagerSecretResourceData`](crate::model::SecretsManagerSecretResourceData)
        pub fn build(self) -> crate::model::SecretsManagerSecretResourceData {
            crate::model::SecretsManagerSecretResourceData {
                arn: self.arn,
                additional_staging_labels_to_download: self.additional_staging_labels_to_download,
            }
        }
    }
}
impl SecretsManagerSecretResourceData {
    /// Creates a new builder-style object to manufacture [`SecretsManagerSecretResourceData`](crate::model::SecretsManagerSecretResourceData)
    pub fn builder() -> crate::model::secrets_manager_secret_resource_data::Builder {
        crate::model::secrets_manager_secret_resource_data::Builder::default()
    }
}

/// Attributes that define an Amazon SageMaker machine learning resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SageMakerMachineLearningModelResourceData {
    /// The absolute local path of the resource inside the Lambda environment.
    pub destination_path: std::option::Option<std::string::String>,
    /// The owner setting for downloaded machine learning resources.
    pub owner_setting: std::option::Option<crate::model::ResourceDownloadOwnerSetting>,
    /// The ARN of the Amazon SageMaker training job that represents the source model.
    pub sage_maker_job_arn: std::option::Option<std::string::String>,
}
impl SageMakerMachineLearningModelResourceData {
    /// The absolute local path of the resource inside the Lambda environment.
    pub fn destination_path(&self) -> std::option::Option<&str> {
        self.destination_path.as_deref()
    }
    /// The owner setting for downloaded machine learning resources.
    pub fn owner_setting(
        &self,
    ) -> std::option::Option<&crate::model::ResourceDownloadOwnerSetting> {
        self.owner_setting.as_ref()
    }
    /// The ARN of the Amazon SageMaker training job that represents the source model.
    pub fn sage_maker_job_arn(&self) -> std::option::Option<&str> {
        self.sage_maker_job_arn.as_deref()
    }
}
impl std::fmt::Debug for SageMakerMachineLearningModelResourceData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SageMakerMachineLearningModelResourceData");
        formatter.field("destination_path", &self.destination_path);
        formatter.field("owner_setting", &self.owner_setting);
        formatter.field("sage_maker_job_arn", &self.sage_maker_job_arn);
        formatter.finish()
    }
}
/// See [`SageMakerMachineLearningModelResourceData`](crate::model::SageMakerMachineLearningModelResourceData)
pub mod sage_maker_machine_learning_model_resource_data {
    /// A builder for [`SageMakerMachineLearningModelResourceData`](crate::model::SageMakerMachineLearningModelResourceData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_path: std::option::Option<std::string::String>,
        pub(crate) owner_setting: std::option::Option<crate::model::ResourceDownloadOwnerSetting>,
        pub(crate) sage_maker_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The absolute local path of the resource inside the Lambda environment.
        pub fn destination_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_path = Some(input.into());
            self
        }
        /// The absolute local path of the resource inside the Lambda environment.
        pub fn set_destination_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_path = input;
            self
        }
        /// The owner setting for downloaded machine learning resources.
        pub fn owner_setting(mut self, input: crate::model::ResourceDownloadOwnerSetting) -> Self {
            self.owner_setting = Some(input);
            self
        }
        /// The owner setting for downloaded machine learning resources.
        pub fn set_owner_setting(
            mut self,
            input: std::option::Option<crate::model::ResourceDownloadOwnerSetting>,
        ) -> Self {
            self.owner_setting = input;
            self
        }
        /// The ARN of the Amazon SageMaker training job that represents the source model.
        pub fn sage_maker_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sage_maker_job_arn = Some(input.into());
            self
        }
        /// The ARN of the Amazon SageMaker training job that represents the source model.
        pub fn set_sage_maker_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sage_maker_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SageMakerMachineLearningModelResourceData`](crate::model::SageMakerMachineLearningModelResourceData)
        pub fn build(self) -> crate::model::SageMakerMachineLearningModelResourceData {
            crate::model::SageMakerMachineLearningModelResourceData {
                destination_path: self.destination_path,
                owner_setting: self.owner_setting,
                sage_maker_job_arn: self.sage_maker_job_arn,
            }
        }
    }
}
impl SageMakerMachineLearningModelResourceData {
    /// Creates a new builder-style object to manufacture [`SageMakerMachineLearningModelResourceData`](crate::model::SageMakerMachineLearningModelResourceData)
    pub fn builder() -> crate::model::sage_maker_machine_learning_model_resource_data::Builder {
        crate::model::sage_maker_machine_learning_model_resource_data::Builder::default()
    }
}

/// The owner setting for downloaded machine learning resources.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDownloadOwnerSetting {
    /// The group owner of the resource. This is the name of an existing Linux OS group on the system or a GID. The group's permissions are added to the Lambda process.
    pub group_owner: std::option::Option<std::string::String>,
    /// The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or ''ro'' (read-only).
    pub group_permission: std::option::Option<crate::model::Permission>,
}
impl ResourceDownloadOwnerSetting {
    /// The group owner of the resource. This is the name of an existing Linux OS group on the system or a GID. The group's permissions are added to the Lambda process.
    pub fn group_owner(&self) -> std::option::Option<&str> {
        self.group_owner.as_deref()
    }
    /// The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or ''ro'' (read-only).
    pub fn group_permission(&self) -> std::option::Option<&crate::model::Permission> {
        self.group_permission.as_ref()
    }
}
impl std::fmt::Debug for ResourceDownloadOwnerSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDownloadOwnerSetting");
        formatter.field("group_owner", &self.group_owner);
        formatter.field("group_permission", &self.group_permission);
        formatter.finish()
    }
}
/// See [`ResourceDownloadOwnerSetting`](crate::model::ResourceDownloadOwnerSetting)
pub mod resource_download_owner_setting {
    /// A builder for [`ResourceDownloadOwnerSetting`](crate::model::ResourceDownloadOwnerSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_owner: std::option::Option<std::string::String>,
        pub(crate) group_permission: std::option::Option<crate::model::Permission>,
    }
    impl Builder {
        /// The group owner of the resource. This is the name of an existing Linux OS group on the system or a GID. The group's permissions are added to the Lambda process.
        pub fn group_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_owner = Some(input.into());
            self
        }
        /// The group owner of the resource. This is the name of an existing Linux OS group on the system or a GID. The group's permissions are added to the Lambda process.
        pub fn set_group_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_owner = input;
            self
        }
        /// The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or ''ro'' (read-only).
        pub fn group_permission(mut self, input: crate::model::Permission) -> Self {
            self.group_permission = Some(input);
            self
        }
        /// The permissions that the group owner has to the resource. Valid values are ''rw'' (read/write) or ''ro'' (read-only).
        pub fn set_group_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.group_permission = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDownloadOwnerSetting`](crate::model::ResourceDownloadOwnerSetting)
        pub fn build(self) -> crate::model::ResourceDownloadOwnerSetting {
            crate::model::ResourceDownloadOwnerSetting {
                group_owner: self.group_owner,
                group_permission: self.group_permission,
            }
        }
    }
}
impl ResourceDownloadOwnerSetting {
    /// Creates a new builder-style object to manufacture [`ResourceDownloadOwnerSetting`](crate::model::ResourceDownloadOwnerSetting)
    pub fn builder() -> crate::model::resource_download_owner_setting::Builder {
        crate::model::resource_download_owner_setting::Builder::default()
    }
}

/// The type of permission a function has to access a resource.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Permission {
    #[allow(missing_docs)] // documentation missing in model
    Ro,
    #[allow(missing_docs)] // documentation missing in model
    Rw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Permission {
    fn from(s: &str) -> Self {
        match s {
            "ro" => Permission::Ro,
            "rw" => Permission::Rw,
            other => Permission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Permission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Permission::from(s))
    }
}
impl Permission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Permission::Ro => "ro",
            Permission::Rw => "rw",
            Permission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ro", "rw"]
    }
}
impl AsRef<str> for Permission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Attributes that define an Amazon S3 machine learning resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3MachineLearningModelResourceData {
    /// The absolute local path of the resource inside the Lambda environment.
    pub destination_path: std::option::Option<std::string::String>,
    /// The owner setting for downloaded machine learning resources.
    pub owner_setting: std::option::Option<crate::model::ResourceDownloadOwnerSetting>,
    /// The URI of the source model in an S3 bucket. The model package must be in tar.gz or .zip format.
    pub s3_uri: std::option::Option<std::string::String>,
}
impl S3MachineLearningModelResourceData {
    /// The absolute local path of the resource inside the Lambda environment.
    pub fn destination_path(&self) -> std::option::Option<&str> {
        self.destination_path.as_deref()
    }
    /// The owner setting for downloaded machine learning resources.
    pub fn owner_setting(
        &self,
    ) -> std::option::Option<&crate::model::ResourceDownloadOwnerSetting> {
        self.owner_setting.as_ref()
    }
    /// The URI of the source model in an S3 bucket. The model package must be in tar.gz or .zip format.
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
}
impl std::fmt::Debug for S3MachineLearningModelResourceData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3MachineLearningModelResourceData");
        formatter.field("destination_path", &self.destination_path);
        formatter.field("owner_setting", &self.owner_setting);
        formatter.field("s3_uri", &self.s3_uri);
        formatter.finish()
    }
}
/// See [`S3MachineLearningModelResourceData`](crate::model::S3MachineLearningModelResourceData)
pub mod s3_machine_learning_model_resource_data {
    /// A builder for [`S3MachineLearningModelResourceData`](crate::model::S3MachineLearningModelResourceData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_path: std::option::Option<std::string::String>,
        pub(crate) owner_setting: std::option::Option<crate::model::ResourceDownloadOwnerSetting>,
        pub(crate) s3_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The absolute local path of the resource inside the Lambda environment.
        pub fn destination_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_path = Some(input.into());
            self
        }
        /// The absolute local path of the resource inside the Lambda environment.
        pub fn set_destination_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_path = input;
            self
        }
        /// The owner setting for downloaded machine learning resources.
        pub fn owner_setting(mut self, input: crate::model::ResourceDownloadOwnerSetting) -> Self {
            self.owner_setting = Some(input);
            self
        }
        /// The owner setting for downloaded machine learning resources.
        pub fn set_owner_setting(
            mut self,
            input: std::option::Option<crate::model::ResourceDownloadOwnerSetting>,
        ) -> Self {
            self.owner_setting = input;
            self
        }
        /// The URI of the source model in an S3 bucket. The model package must be in tar.gz or .zip format.
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// The URI of the source model in an S3 bucket. The model package must be in tar.gz or .zip format.
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`S3MachineLearningModelResourceData`](crate::model::S3MachineLearningModelResourceData)
        pub fn build(self) -> crate::model::S3MachineLearningModelResourceData {
            crate::model::S3MachineLearningModelResourceData {
                destination_path: self.destination_path,
                owner_setting: self.owner_setting,
                s3_uri: self.s3_uri,
            }
        }
    }
}
impl S3MachineLearningModelResourceData {
    /// Creates a new builder-style object to manufacture [`S3MachineLearningModelResourceData`](crate::model::S3MachineLearningModelResourceData)
    pub fn builder() -> crate::model::s3_machine_learning_model_resource_data::Builder {
        crate::model::s3_machine_learning_model_resource_data::Builder::default()
    }
}

/// Attributes that define a local volume resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocalVolumeResourceData {
    /// The absolute local path of the resource inside the Lambda environment.
    pub destination_path: std::option::Option<std::string::String>,
    /// Allows you to configure additional group privileges for the Lambda process. This field is optional.
    pub group_owner_setting: std::option::Option<crate::model::GroupOwnerSetting>,
    /// The local absolute path of the volume resource on the host. The source path for a volume resource type cannot start with ''/sys''.
    pub source_path: std::option::Option<std::string::String>,
}
impl LocalVolumeResourceData {
    /// The absolute local path of the resource inside the Lambda environment.
    pub fn destination_path(&self) -> std::option::Option<&str> {
        self.destination_path.as_deref()
    }
    /// Allows you to configure additional group privileges for the Lambda process. This field is optional.
    pub fn group_owner_setting(&self) -> std::option::Option<&crate::model::GroupOwnerSetting> {
        self.group_owner_setting.as_ref()
    }
    /// The local absolute path of the volume resource on the host. The source path for a volume resource type cannot start with ''/sys''.
    pub fn source_path(&self) -> std::option::Option<&str> {
        self.source_path.as_deref()
    }
}
impl std::fmt::Debug for LocalVolumeResourceData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocalVolumeResourceData");
        formatter.field("destination_path", &self.destination_path);
        formatter.field("group_owner_setting", &self.group_owner_setting);
        formatter.field("source_path", &self.source_path);
        formatter.finish()
    }
}
/// See [`LocalVolumeResourceData`](crate::model::LocalVolumeResourceData)
pub mod local_volume_resource_data {
    /// A builder for [`LocalVolumeResourceData`](crate::model::LocalVolumeResourceData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_path: std::option::Option<std::string::String>,
        pub(crate) group_owner_setting: std::option::Option<crate::model::GroupOwnerSetting>,
        pub(crate) source_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The absolute local path of the resource inside the Lambda environment.
        pub fn destination_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_path = Some(input.into());
            self
        }
        /// The absolute local path of the resource inside the Lambda environment.
        pub fn set_destination_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_path = input;
            self
        }
        /// Allows you to configure additional group privileges for the Lambda process. This field is optional.
        pub fn group_owner_setting(mut self, input: crate::model::GroupOwnerSetting) -> Self {
            self.group_owner_setting = Some(input);
            self
        }
        /// Allows you to configure additional group privileges for the Lambda process. This field is optional.
        pub fn set_group_owner_setting(
            mut self,
            input: std::option::Option<crate::model::GroupOwnerSetting>,
        ) -> Self {
            self.group_owner_setting = input;
            self
        }
        /// The local absolute path of the volume resource on the host. The source path for a volume resource type cannot start with ''/sys''.
        pub fn source_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_path = Some(input.into());
            self
        }
        /// The local absolute path of the volume resource on the host. The source path for a volume resource type cannot start with ''/sys''.
        pub fn set_source_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_path = input;
            self
        }
        /// Consumes the builder and constructs a [`LocalVolumeResourceData`](crate::model::LocalVolumeResourceData)
        pub fn build(self) -> crate::model::LocalVolumeResourceData {
            crate::model::LocalVolumeResourceData {
                destination_path: self.destination_path,
                group_owner_setting: self.group_owner_setting,
                source_path: self.source_path,
            }
        }
    }
}
impl LocalVolumeResourceData {
    /// Creates a new builder-style object to manufacture [`LocalVolumeResourceData`](crate::model::LocalVolumeResourceData)
    pub fn builder() -> crate::model::local_volume_resource_data::Builder {
        crate::model::local_volume_resource_data::Builder::default()
    }
}

/// Group owner related settings for local resources.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupOwnerSetting {
    /// If true, AWS IoT Greengrass automatically adds the specified Linux OS group owner of the resource to the Lambda process privileges. Thus the Lambda process will have the file access permissions of the added Linux group.
    pub auto_add_group_owner: bool,
    /// The name of the Linux OS group whose privileges will be added to the Lambda process. This field is optional.
    pub group_owner: std::option::Option<std::string::String>,
}
impl GroupOwnerSetting {
    /// If true, AWS IoT Greengrass automatically adds the specified Linux OS group owner of the resource to the Lambda process privileges. Thus the Lambda process will have the file access permissions of the added Linux group.
    pub fn auto_add_group_owner(&self) -> bool {
        self.auto_add_group_owner
    }
    /// The name of the Linux OS group whose privileges will be added to the Lambda process. This field is optional.
    pub fn group_owner(&self) -> std::option::Option<&str> {
        self.group_owner.as_deref()
    }
}
impl std::fmt::Debug for GroupOwnerSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupOwnerSetting");
        formatter.field("auto_add_group_owner", &self.auto_add_group_owner);
        formatter.field("group_owner", &self.group_owner);
        formatter.finish()
    }
}
/// See [`GroupOwnerSetting`](crate::model::GroupOwnerSetting)
pub mod group_owner_setting {
    /// A builder for [`GroupOwnerSetting`](crate::model::GroupOwnerSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_add_group_owner: std::option::Option<bool>,
        pub(crate) group_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// If true, AWS IoT Greengrass automatically adds the specified Linux OS group owner of the resource to the Lambda process privileges. Thus the Lambda process will have the file access permissions of the added Linux group.
        pub fn auto_add_group_owner(mut self, input: bool) -> Self {
            self.auto_add_group_owner = Some(input);
            self
        }
        /// If true, AWS IoT Greengrass automatically adds the specified Linux OS group owner of the resource to the Lambda process privileges. Thus the Lambda process will have the file access permissions of the added Linux group.
        pub fn set_auto_add_group_owner(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_add_group_owner = input;
            self
        }
        /// The name of the Linux OS group whose privileges will be added to the Lambda process. This field is optional.
        pub fn group_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_owner = Some(input.into());
            self
        }
        /// The name of the Linux OS group whose privileges will be added to the Lambda process. This field is optional.
        pub fn set_group_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupOwnerSetting`](crate::model::GroupOwnerSetting)
        pub fn build(self) -> crate::model::GroupOwnerSetting {
            crate::model::GroupOwnerSetting {
                auto_add_group_owner: self.auto_add_group_owner.unwrap_or_default(),
                group_owner: self.group_owner,
            }
        }
    }
}
impl GroupOwnerSetting {
    /// Creates a new builder-style object to manufacture [`GroupOwnerSetting`](crate::model::GroupOwnerSetting)
    pub fn builder() -> crate::model::group_owner_setting::Builder {
        crate::model::group_owner_setting::Builder::default()
    }
}

/// Attributes that define a local device resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LocalDeviceResourceData {
    /// Group/owner related settings for local resources.
    pub group_owner_setting: std::option::Option<crate::model::GroupOwnerSetting>,
    /// The local absolute path of the device resource. The source path for a device resource can refer only to a character device or block device under ''/dev''.
    pub source_path: std::option::Option<std::string::String>,
}
impl LocalDeviceResourceData {
    /// Group/owner related settings for local resources.
    pub fn group_owner_setting(&self) -> std::option::Option<&crate::model::GroupOwnerSetting> {
        self.group_owner_setting.as_ref()
    }
    /// The local absolute path of the device resource. The source path for a device resource can refer only to a character device or block device under ''/dev''.
    pub fn source_path(&self) -> std::option::Option<&str> {
        self.source_path.as_deref()
    }
}
impl std::fmt::Debug for LocalDeviceResourceData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LocalDeviceResourceData");
        formatter.field("group_owner_setting", &self.group_owner_setting);
        formatter.field("source_path", &self.source_path);
        formatter.finish()
    }
}
/// See [`LocalDeviceResourceData`](crate::model::LocalDeviceResourceData)
pub mod local_device_resource_data {
    /// A builder for [`LocalDeviceResourceData`](crate::model::LocalDeviceResourceData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_owner_setting: std::option::Option<crate::model::GroupOwnerSetting>,
        pub(crate) source_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Group/owner related settings for local resources.
        pub fn group_owner_setting(mut self, input: crate::model::GroupOwnerSetting) -> Self {
            self.group_owner_setting = Some(input);
            self
        }
        /// Group/owner related settings for local resources.
        pub fn set_group_owner_setting(
            mut self,
            input: std::option::Option<crate::model::GroupOwnerSetting>,
        ) -> Self {
            self.group_owner_setting = input;
            self
        }
        /// The local absolute path of the device resource. The source path for a device resource can refer only to a character device or block device under ''/dev''.
        pub fn source_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_path = Some(input.into());
            self
        }
        /// The local absolute path of the device resource. The source path for a device resource can refer only to a character device or block device under ''/dev''.
        pub fn set_source_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_path = input;
            self
        }
        /// Consumes the builder and constructs a [`LocalDeviceResourceData`](crate::model::LocalDeviceResourceData)
        pub fn build(self) -> crate::model::LocalDeviceResourceData {
            crate::model::LocalDeviceResourceData {
                group_owner_setting: self.group_owner_setting,
                source_path: self.source_path,
            }
        }
    }
}
impl LocalDeviceResourceData {
    /// Creates a new builder-style object to manufacture [`LocalDeviceResourceData`](crate::model::LocalDeviceResourceData)
    pub fn builder() -> crate::model::local_device_resource_data::Builder {
        crate::model::local_device_resource_data::Builder::default()
    }
}

/// Information about a logger definition version.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggerDefinitionVersion {
    /// A list of loggers.
    pub loggers: std::option::Option<std::vec::Vec<crate::model::Logger>>,
}
impl LoggerDefinitionVersion {
    /// A list of loggers.
    pub fn loggers(&self) -> std::option::Option<&[crate::model::Logger]> {
        self.loggers.as_deref()
    }
}
impl std::fmt::Debug for LoggerDefinitionVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggerDefinitionVersion");
        formatter.field("loggers", &self.loggers);
        formatter.finish()
    }
}
/// See [`LoggerDefinitionVersion`](crate::model::LoggerDefinitionVersion)
pub mod logger_definition_version {
    /// A builder for [`LoggerDefinitionVersion`](crate::model::LoggerDefinitionVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) loggers: std::option::Option<std::vec::Vec<crate::model::Logger>>,
    }
    impl Builder {
        /// Appends an item to `loggers`.
        ///
        /// To override the contents of this collection use [`set_loggers`](Self::set_loggers).
        ///
        /// A list of loggers.
        pub fn loggers(mut self, input: crate::model::Logger) -> Self {
            let mut v = self.loggers.unwrap_or_default();
            v.push(input);
            self.loggers = Some(v);
            self
        }
        /// A list of loggers.
        pub fn set_loggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Logger>>,
        ) -> Self {
            self.loggers = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggerDefinitionVersion`](crate::model::LoggerDefinitionVersion)
        pub fn build(self) -> crate::model::LoggerDefinitionVersion {
            crate::model::LoggerDefinitionVersion {
                loggers: self.loggers,
            }
        }
    }
}
impl LoggerDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`LoggerDefinitionVersion`](crate::model::LoggerDefinitionVersion)
    pub fn builder() -> crate::model::logger_definition_version::Builder {
        crate::model::logger_definition_version::Builder::default()
    }
}

/// Information about a logger
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Logger {
    /// The component that will be subject to logging.
    pub component: std::option::Option<crate::model::LoggerComponent>,
    /// A descriptive or arbitrary ID for the logger. This value must be unique within the logger definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
    pub id: std::option::Option<std::string::String>,
    /// The level of the logs.
    pub level: std::option::Option<crate::model::LoggerLevel>,
    /// The amount of file space, in KB, to use if the local file system is used for logging purposes.
    pub space: i32,
    /// The type of log output which will be used.
    pub r#type: std::option::Option<crate::model::LoggerType>,
}
impl Logger {
    /// The component that will be subject to logging.
    pub fn component(&self) -> std::option::Option<&crate::model::LoggerComponent> {
        self.component.as_ref()
    }
    /// A descriptive or arbitrary ID for the logger. This value must be unique within the logger definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The level of the logs.
    pub fn level(&self) -> std::option::Option<&crate::model::LoggerLevel> {
        self.level.as_ref()
    }
    /// The amount of file space, in KB, to use if the local file system is used for logging purposes.
    pub fn space(&self) -> i32 {
        self.space
    }
    /// The type of log output which will be used.
    pub fn r#type(&self) -> std::option::Option<&crate::model::LoggerType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Logger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Logger");
        formatter.field("component", &self.component);
        formatter.field("id", &self.id);
        formatter.field("level", &self.level);
        formatter.field("space", &self.space);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Logger`](crate::model::Logger)
pub mod logger {
    /// A builder for [`Logger`](crate::model::Logger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component: std::option::Option<crate::model::LoggerComponent>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) level: std::option::Option<crate::model::LoggerLevel>,
        pub(crate) space: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<crate::model::LoggerType>,
    }
    impl Builder {
        /// The component that will be subject to logging.
        pub fn component(mut self, input: crate::model::LoggerComponent) -> Self {
            self.component = Some(input);
            self
        }
        /// The component that will be subject to logging.
        pub fn set_component(
            mut self,
            input: std::option::Option<crate::model::LoggerComponent>,
        ) -> Self {
            self.component = input;
            self
        }
        /// A descriptive or arbitrary ID for the logger. This value must be unique within the logger definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// A descriptive or arbitrary ID for the logger. This value must be unique within the logger definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// The level of the logs.
        pub fn level(mut self, input: crate::model::LoggerLevel) -> Self {
            self.level = Some(input);
            self
        }
        /// The level of the logs.
        pub fn set_level(mut self, input: std::option::Option<crate::model::LoggerLevel>) -> Self {
            self.level = input;
            self
        }
        /// The amount of file space, in KB, to use if the local file system is used for logging purposes.
        pub fn space(mut self, input: i32) -> Self {
            self.space = Some(input);
            self
        }
        /// The amount of file space, in KB, to use if the local file system is used for logging purposes.
        pub fn set_space(mut self, input: std::option::Option<i32>) -> Self {
            self.space = input;
            self
        }
        /// The type of log output which will be used.
        pub fn r#type(mut self, input: crate::model::LoggerType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// The type of log output which will be used.
        pub fn set_type(mut self, input: std::option::Option<crate::model::LoggerType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Logger`](crate::model::Logger)
        pub fn build(self) -> crate::model::Logger {
            crate::model::Logger {
                component: self.component,
                id: self.id,
                level: self.level,
                space: self.space.unwrap_or_default(),
                r#type: self.r#type,
            }
        }
    }
}
impl Logger {
    /// Creates a new builder-style object to manufacture [`Logger`](crate::model::Logger)
    pub fn builder() -> crate::model::logger::Builder {
        crate::model::logger::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoggerType {
    #[allow(missing_docs)] // documentation missing in model
    AwsCloudWatch,
    #[allow(missing_docs)] // documentation missing in model
    FileSystem,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoggerType {
    fn from(s: &str) -> Self {
        match s {
            "AWSCloudWatch" => LoggerType::AwsCloudWatch,
            "FileSystem" => LoggerType::FileSystem,
            other => LoggerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoggerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoggerType::from(s))
    }
}
impl LoggerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoggerType::AwsCloudWatch => "AWSCloudWatch",
            LoggerType::FileSystem => "FileSystem",
            LoggerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWSCloudWatch", "FileSystem"]
    }
}
impl AsRef<str> for LoggerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoggerLevel {
    #[allow(missing_docs)] // documentation missing in model
    Debug,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Fatal,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Warn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoggerLevel {
    fn from(s: &str) -> Self {
        match s {
            "DEBUG" => LoggerLevel::Debug,
            "ERROR" => LoggerLevel::Error,
            "FATAL" => LoggerLevel::Fatal,
            "INFO" => LoggerLevel::Info,
            "WARN" => LoggerLevel::Warn,
            other => LoggerLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoggerLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoggerLevel::from(s))
    }
}
impl LoggerLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoggerLevel::Debug => "DEBUG",
            LoggerLevel::Error => "ERROR",
            LoggerLevel::Fatal => "FATAL",
            LoggerLevel::Info => "INFO",
            LoggerLevel::Warn => "WARN",
            LoggerLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEBUG", "ERROR", "FATAL", "INFO", "WARN"]
    }
}
impl AsRef<str> for LoggerLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoggerComponent {
    #[allow(missing_docs)] // documentation missing in model
    GreengrassSystem,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoggerComponent {
    fn from(s: &str) -> Self {
        match s {
            "GreengrassSystem" => LoggerComponent::GreengrassSystem,
            "Lambda" => LoggerComponent::Lambda,
            other => LoggerComponent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoggerComponent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoggerComponent::from(s))
    }
}
impl LoggerComponent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoggerComponent::GreengrassSystem => "GreengrassSystem",
            LoggerComponent::Lambda => "Lambda",
            LoggerComponent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GreengrassSystem", "Lambda"]
    }
}
impl AsRef<str> for LoggerComponent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Information about a group version.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupVersion {
    /// The ARN of the connector definition version for this group.
    pub connector_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the core definition version for this group.
    pub core_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the device definition version for this group.
    pub device_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the function definition version for this group.
    pub function_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the logger definition version for this group.
    pub logger_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the resource definition version for this group.
    pub resource_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the subscription definition version for this group.
    pub subscription_definition_version_arn: std::option::Option<std::string::String>,
}
impl GroupVersion {
    /// The ARN of the connector definition version for this group.
    pub fn connector_definition_version_arn(&self) -> std::option::Option<&str> {
        self.connector_definition_version_arn.as_deref()
    }
    /// The ARN of the core definition version for this group.
    pub fn core_definition_version_arn(&self) -> std::option::Option<&str> {
        self.core_definition_version_arn.as_deref()
    }
    /// The ARN of the device definition version for this group.
    pub fn device_definition_version_arn(&self) -> std::option::Option<&str> {
        self.device_definition_version_arn.as_deref()
    }
    /// The ARN of the function definition version for this group.
    pub fn function_definition_version_arn(&self) -> std::option::Option<&str> {
        self.function_definition_version_arn.as_deref()
    }
    /// The ARN of the logger definition version for this group.
    pub fn logger_definition_version_arn(&self) -> std::option::Option<&str> {
        self.logger_definition_version_arn.as_deref()
    }
    /// The ARN of the resource definition version for this group.
    pub fn resource_definition_version_arn(&self) -> std::option::Option<&str> {
        self.resource_definition_version_arn.as_deref()
    }
    /// The ARN of the subscription definition version for this group.
    pub fn subscription_definition_version_arn(&self) -> std::option::Option<&str> {
        self.subscription_definition_version_arn.as_deref()
    }
}
impl std::fmt::Debug for GroupVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupVersion");
        formatter.field(
            "connector_definition_version_arn",
            &self.connector_definition_version_arn,
        );
        formatter.field(
            "core_definition_version_arn",
            &self.core_definition_version_arn,
        );
        formatter.field(
            "device_definition_version_arn",
            &self.device_definition_version_arn,
        );
        formatter.field(
            "function_definition_version_arn",
            &self.function_definition_version_arn,
        );
        formatter.field(
            "logger_definition_version_arn",
            &self.logger_definition_version_arn,
        );
        formatter.field(
            "resource_definition_version_arn",
            &self.resource_definition_version_arn,
        );
        formatter.field(
            "subscription_definition_version_arn",
            &self.subscription_definition_version_arn,
        );
        formatter.finish()
    }
}
/// See [`GroupVersion`](crate::model::GroupVersion)
pub mod group_version {
    /// A builder for [`GroupVersion`](crate::model::GroupVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) core_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) device_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) function_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) logger_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) resource_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) subscription_definition_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the connector definition version for this group.
        pub fn connector_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.connector_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the connector definition version for this group.
        pub fn set_connector_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_definition_version_arn = input;
            self
        }
        /// The ARN of the core definition version for this group.
        pub fn core_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.core_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the core definition version for this group.
        pub fn set_core_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_definition_version_arn = input;
            self
        }
        /// The ARN of the device definition version for this group.
        pub fn device_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.device_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the device definition version for this group.
        pub fn set_device_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_definition_version_arn = input;
            self
        }
        /// The ARN of the function definition version for this group.
        pub fn function_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.function_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the function definition version for this group.
        pub fn set_function_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_definition_version_arn = input;
            self
        }
        /// The ARN of the logger definition version for this group.
        pub fn logger_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.logger_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the logger definition version for this group.
        pub fn set_logger_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logger_definition_version_arn = input;
            self
        }
        /// The ARN of the resource definition version for this group.
        pub fn resource_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resource_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the resource definition version for this group.
        pub fn set_resource_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_definition_version_arn = input;
            self
        }
        /// The ARN of the subscription definition version for this group.
        pub fn subscription_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.subscription_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the subscription definition version for this group.
        pub fn set_subscription_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_definition_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupVersion`](crate::model::GroupVersion)
        pub fn build(self) -> crate::model::GroupVersion {
            crate::model::GroupVersion {
                connector_definition_version_arn: self.connector_definition_version_arn,
                core_definition_version_arn: self.core_definition_version_arn,
                device_definition_version_arn: self.device_definition_version_arn,
                function_definition_version_arn: self.function_definition_version_arn,
                logger_definition_version_arn: self.logger_definition_version_arn,
                resource_definition_version_arn: self.resource_definition_version_arn,
                subscription_definition_version_arn: self.subscription_definition_version_arn,
            }
        }
    }
}
impl GroupVersion {
    /// Creates a new builder-style object to manufacture [`GroupVersion`](crate::model::GroupVersion)
    pub fn builder() -> crate::model::group_version::Builder {
        crate::model::group_version::Builder::default()
    }
}

/// Information about a function definition version.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionDefinitionVersion {
    /// The default configuration that applies to all Lambda functions in this function definition version. Individual Lambda functions can override these settings.
    pub default_config: std::option::Option<crate::model::FunctionDefaultConfig>,
    /// A list of Lambda functions in this function definition version.
    pub functions: std::option::Option<std::vec::Vec<crate::model::Function>>,
}
impl FunctionDefinitionVersion {
    /// The default configuration that applies to all Lambda functions in this function definition version. Individual Lambda functions can override these settings.
    pub fn default_config(&self) -> std::option::Option<&crate::model::FunctionDefaultConfig> {
        self.default_config.as_ref()
    }
    /// A list of Lambda functions in this function definition version.
    pub fn functions(&self) -> std::option::Option<&[crate::model::Function]> {
        self.functions.as_deref()
    }
}
impl std::fmt::Debug for FunctionDefinitionVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionDefinitionVersion");
        formatter.field("default_config", &self.default_config);
        formatter.field("functions", &self.functions);
        formatter.finish()
    }
}
/// See [`FunctionDefinitionVersion`](crate::model::FunctionDefinitionVersion)
pub mod function_definition_version {
    /// A builder for [`FunctionDefinitionVersion`](crate::model::FunctionDefinitionVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_config: std::option::Option<crate::model::FunctionDefaultConfig>,
        pub(crate) functions: std::option::Option<std::vec::Vec<crate::model::Function>>,
    }
    impl Builder {
        /// The default configuration that applies to all Lambda functions in this function definition version. Individual Lambda functions can override these settings.
        pub fn default_config(mut self, input: crate::model::FunctionDefaultConfig) -> Self {
            self.default_config = Some(input);
            self
        }
        /// The default configuration that applies to all Lambda functions in this function definition version. Individual Lambda functions can override these settings.
        pub fn set_default_config(
            mut self,
            input: std::option::Option<crate::model::FunctionDefaultConfig>,
        ) -> Self {
            self.default_config = input;
            self
        }
        /// Appends an item to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// A list of Lambda functions in this function definition version.
        pub fn functions(mut self, input: crate::model::Function) -> Self {
            let mut v = self.functions.unwrap_or_default();
            v.push(input);
            self.functions = Some(v);
            self
        }
        /// A list of Lambda functions in this function definition version.
        pub fn set_functions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Function>>,
        ) -> Self {
            self.functions = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionDefinitionVersion`](crate::model::FunctionDefinitionVersion)
        pub fn build(self) -> crate::model::FunctionDefinitionVersion {
            crate::model::FunctionDefinitionVersion {
                default_config: self.default_config,
                functions: self.functions,
            }
        }
    }
}
impl FunctionDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`FunctionDefinitionVersion`](crate::model::FunctionDefinitionVersion)
    pub fn builder() -> crate::model::function_definition_version::Builder {
        crate::model::function_definition_version::Builder::default()
    }
}

/// Information about a Lambda function.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Function {
    /// The ARN of the Lambda function.
    pub function_arn: std::option::Option<std::string::String>,
    /// The configuration of the Lambda function.
    pub function_configuration: std::option::Option<crate::model::FunctionConfiguration>,
    /// A descriptive or arbitrary ID for the function. This value must be unique within the function definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
    pub id: std::option::Option<std::string::String>,
}
impl Function {
    /// The ARN of the Lambda function.
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// The configuration of the Lambda function.
    pub fn function_configuration(
        &self,
    ) -> std::option::Option<&crate::model::FunctionConfiguration> {
        self.function_configuration.as_ref()
    }
    /// A descriptive or arbitrary ID for the function. This value must be unique within the function definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for Function {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Function");
        formatter.field("function_arn", &self.function_arn);
        formatter.field("function_configuration", &self.function_configuration);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`Function`](crate::model::Function)
pub mod function {
    /// A builder for [`Function`](crate::model::Function)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) function_configuration: std::option::Option<crate::model::FunctionConfiguration>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the Lambda function.
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// The ARN of the Lambda function.
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// The configuration of the Lambda function.
        pub fn function_configuration(
            mut self,
            input: crate::model::FunctionConfiguration,
        ) -> Self {
            self.function_configuration = Some(input);
            self
        }
        /// The configuration of the Lambda function.
        pub fn set_function_configuration(
            mut self,
            input: std::option::Option<crate::model::FunctionConfiguration>,
        ) -> Self {
            self.function_configuration = input;
            self
        }
        /// A descriptive or arbitrary ID for the function. This value must be unique within the function definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// A descriptive or arbitrary ID for the function. This value must be unique within the function definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`Function`](crate::model::Function)
        pub fn build(self) -> crate::model::Function {
            crate::model::Function {
                function_arn: self.function_arn,
                function_configuration: self.function_configuration,
                id: self.id,
            }
        }
    }
}
impl Function {
    /// Creates a new builder-style object to manufacture [`Function`](crate::model::Function)
    pub fn builder() -> crate::model::function::Builder {
        crate::model::function::Builder::default()
    }
}

/// The configuration of the Lambda function.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionConfiguration {
    /// The expected encoding type of the input payload for the function. The default is ''json''.
    pub encoding_type: std::option::Option<crate::model::EncodingType>,
    /// The environment configuration of the function.
    pub environment: std::option::Option<crate::model::FunctionConfigurationEnvironment>,
    /// The execution arguments.
    pub exec_args: std::option::Option<std::string::String>,
    /// The name of the function executable.
    pub executable: std::option::Option<std::string::String>,
    /// The memory size, in KB, which the function requires. This setting is not applicable and should be cleared when you run the Lambda function without containerization.
    pub memory_size: i32,
    /// True if the function is pinned. Pinned means the function is long-lived and starts when the core starts.
    pub pinned: bool,
    /// The allowed function execution time, after which Lambda should terminate the function. This timeout still applies to pinned Lambda functions for each request.
    pub timeout: i32,
}
impl FunctionConfiguration {
    /// The expected encoding type of the input payload for the function. The default is ''json''.
    pub fn encoding_type(&self) -> std::option::Option<&crate::model::EncodingType> {
        self.encoding_type.as_ref()
    }
    /// The environment configuration of the function.
    pub fn environment(
        &self,
    ) -> std::option::Option<&crate::model::FunctionConfigurationEnvironment> {
        self.environment.as_ref()
    }
    /// The execution arguments.
    pub fn exec_args(&self) -> std::option::Option<&str> {
        self.exec_args.as_deref()
    }
    /// The name of the function executable.
    pub fn executable(&self) -> std::option::Option<&str> {
        self.executable.as_deref()
    }
    /// The memory size, in KB, which the function requires. This setting is not applicable and should be cleared when you run the Lambda function without containerization.
    pub fn memory_size(&self) -> i32 {
        self.memory_size
    }
    /// True if the function is pinned. Pinned means the function is long-lived and starts when the core starts.
    pub fn pinned(&self) -> bool {
        self.pinned
    }
    /// The allowed function execution time, after which Lambda should terminate the function. This timeout still applies to pinned Lambda functions for each request.
    pub fn timeout(&self) -> i32 {
        self.timeout
    }
}
impl std::fmt::Debug for FunctionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionConfiguration");
        formatter.field("encoding_type", &self.encoding_type);
        formatter.field("environment", &self.environment);
        formatter.field("exec_args", &self.exec_args);
        formatter.field("executable", &self.executable);
        formatter.field("memory_size", &self.memory_size);
        formatter.field("pinned", &self.pinned);
        formatter.field("timeout", &self.timeout);
        formatter.finish()
    }
}
/// See [`FunctionConfiguration`](crate::model::FunctionConfiguration)
pub mod function_configuration {
    /// A builder for [`FunctionConfiguration`](crate::model::FunctionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
        pub(crate) environment: std::option::Option<crate::model::FunctionConfigurationEnvironment>,
        pub(crate) exec_args: std::option::Option<std::string::String>,
        pub(crate) executable: std::option::Option<std::string::String>,
        pub(crate) memory_size: std::option::Option<i32>,
        pub(crate) pinned: std::option::Option<bool>,
        pub(crate) timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// The expected encoding type of the input payload for the function. The default is ''json''.
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// The expected encoding type of the input payload for the function. The default is ''json''.
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// The environment configuration of the function.
        pub fn environment(
            mut self,
            input: crate::model::FunctionConfigurationEnvironment,
        ) -> Self {
            self.environment = Some(input);
            self
        }
        /// The environment configuration of the function.
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::FunctionConfigurationEnvironment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// The execution arguments.
        pub fn exec_args(mut self, input: impl Into<std::string::String>) -> Self {
            self.exec_args = Some(input.into());
            self
        }
        /// The execution arguments.
        pub fn set_exec_args(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.exec_args = input;
            self
        }
        /// The name of the function executable.
        pub fn executable(mut self, input: impl Into<std::string::String>) -> Self {
            self.executable = Some(input.into());
            self
        }
        /// The name of the function executable.
        pub fn set_executable(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.executable = input;
            self
        }
        /// The memory size, in KB, which the function requires. This setting is not applicable and should be cleared when you run the Lambda function without containerization.
        pub fn memory_size(mut self, input: i32) -> Self {
            self.memory_size = Some(input);
            self
        }
        /// The memory size, in KB, which the function requires. This setting is not applicable and should be cleared when you run the Lambda function without containerization.
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size = input;
            self
        }
        /// True if the function is pinned. Pinned means the function is long-lived and starts when the core starts.
        pub fn pinned(mut self, input: bool) -> Self {
            self.pinned = Some(input);
            self
        }
        /// True if the function is pinned. Pinned means the function is long-lived and starts when the core starts.
        pub fn set_pinned(mut self, input: std::option::Option<bool>) -> Self {
            self.pinned = input;
            self
        }
        /// The allowed function execution time, after which Lambda should terminate the function. This timeout still applies to pinned Lambda functions for each request.
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// The allowed function execution time, after which Lambda should terminate the function. This timeout still applies to pinned Lambda functions for each request.
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionConfiguration`](crate::model::FunctionConfiguration)
        pub fn build(self) -> crate::model::FunctionConfiguration {
            crate::model::FunctionConfiguration {
                encoding_type: self.encoding_type,
                environment: self.environment,
                exec_args: self.exec_args,
                executable: self.executable,
                memory_size: self.memory_size.unwrap_or_default(),
                pinned: self.pinned.unwrap_or_default(),
                timeout: self.timeout.unwrap_or_default(),
            }
        }
    }
}
impl FunctionConfiguration {
    /// Creates a new builder-style object to manufacture [`FunctionConfiguration`](crate::model::FunctionConfiguration)
    pub fn builder() -> crate::model::function_configuration::Builder {
        crate::model::function_configuration::Builder::default()
    }
}

/// The environment configuration of the function.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionConfigurationEnvironment {
    /// If true, the Lambda function is allowed to access the host's /sys folder. Use this when the Lambda function needs to read device information from /sys. This setting applies only when you run the Lambda function in a Greengrass container.
    pub access_sysfs: bool,
    /// Configuration related to executing the Lambda function
    pub execution: std::option::Option<crate::model::FunctionExecutionConfig>,
    /// A list of the resources, with their permissions, to which the Lambda function will be granted access. A Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda function in a Greengrass container.
    pub resource_access_policies:
        std::option::Option<std::vec::Vec<crate::model::ResourceAccessPolicy>>,
    /// Environment variables for the Lambda function's configuration.
    pub variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl FunctionConfigurationEnvironment {
    /// If true, the Lambda function is allowed to access the host's /sys folder. Use this when the Lambda function needs to read device information from /sys. This setting applies only when you run the Lambda function in a Greengrass container.
    pub fn access_sysfs(&self) -> bool {
        self.access_sysfs
    }
    /// Configuration related to executing the Lambda function
    pub fn execution(&self) -> std::option::Option<&crate::model::FunctionExecutionConfig> {
        self.execution.as_ref()
    }
    /// A list of the resources, with their permissions, to which the Lambda function will be granted access. A Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda function in a Greengrass container.
    pub fn resource_access_policies(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceAccessPolicy]> {
        self.resource_access_policies.as_deref()
    }
    /// Environment variables for the Lambda function's configuration.
    pub fn variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.variables.as_ref()
    }
}
impl std::fmt::Debug for FunctionConfigurationEnvironment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionConfigurationEnvironment");
        formatter.field("access_sysfs", &self.access_sysfs);
        formatter.field("execution", &self.execution);
        formatter.field("resource_access_policies", &self.resource_access_policies);
        formatter.field("variables", &self.variables);
        formatter.finish()
    }
}
/// See [`FunctionConfigurationEnvironment`](crate::model::FunctionConfigurationEnvironment)
pub mod function_configuration_environment {
    /// A builder for [`FunctionConfigurationEnvironment`](crate::model::FunctionConfigurationEnvironment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_sysfs: std::option::Option<bool>,
        pub(crate) execution: std::option::Option<crate::model::FunctionExecutionConfig>,
        pub(crate) resource_access_policies:
            std::option::Option<std::vec::Vec<crate::model::ResourceAccessPolicy>>,
        pub(crate) variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// If true, the Lambda function is allowed to access the host's /sys folder. Use this when the Lambda function needs to read device information from /sys. This setting applies only when you run the Lambda function in a Greengrass container.
        pub fn access_sysfs(mut self, input: bool) -> Self {
            self.access_sysfs = Some(input);
            self
        }
        /// If true, the Lambda function is allowed to access the host's /sys folder. Use this when the Lambda function needs to read device information from /sys. This setting applies only when you run the Lambda function in a Greengrass container.
        pub fn set_access_sysfs(mut self, input: std::option::Option<bool>) -> Self {
            self.access_sysfs = input;
            self
        }
        /// Configuration related to executing the Lambda function
        pub fn execution(mut self, input: crate::model::FunctionExecutionConfig) -> Self {
            self.execution = Some(input);
            self
        }
        /// Configuration related to executing the Lambda function
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::FunctionExecutionConfig>,
        ) -> Self {
            self.execution = input;
            self
        }
        /// Appends an item to `resource_access_policies`.
        ///
        /// To override the contents of this collection use [`set_resource_access_policies`](Self::set_resource_access_policies).
        ///
        /// A list of the resources, with their permissions, to which the Lambda function will be granted access. A Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda function in a Greengrass container.
        pub fn resource_access_policies(
            mut self,
            input: crate::model::ResourceAccessPolicy,
        ) -> Self {
            let mut v = self.resource_access_policies.unwrap_or_default();
            v.push(input);
            self.resource_access_policies = Some(v);
            self
        }
        /// A list of the resources, with their permissions, to which the Lambda function will be granted access. A Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda function in a Greengrass container.
        pub fn set_resource_access_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceAccessPolicy>>,
        ) -> Self {
            self.resource_access_policies = input;
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// Environment variables for the Lambda function's configuration.
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.variables = Some(hash_map);
            self
        }
        /// Environment variables for the Lambda function's configuration.
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.variables = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionConfigurationEnvironment`](crate::model::FunctionConfigurationEnvironment)
        pub fn build(self) -> crate::model::FunctionConfigurationEnvironment {
            crate::model::FunctionConfigurationEnvironment {
                access_sysfs: self.access_sysfs.unwrap_or_default(),
                execution: self.execution,
                resource_access_policies: self.resource_access_policies,
                variables: self.variables,
            }
        }
    }
}
impl FunctionConfigurationEnvironment {
    /// Creates a new builder-style object to manufacture [`FunctionConfigurationEnvironment`](crate::model::FunctionConfigurationEnvironment)
    pub fn builder() -> crate::model::function_configuration_environment::Builder {
        crate::model::function_configuration_environment::Builder::default()
    }
}

/// A policy used by the function to access a resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAccessPolicy {
    /// The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or ''ro'' (read-only).
    pub permission: std::option::Option<crate::model::Permission>,
    /// The ID of the resource. (This ID is assigned to the resource when you create the resource definiton.)
    pub resource_id: std::option::Option<std::string::String>,
}
impl ResourceAccessPolicy {
    /// The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or ''ro'' (read-only).
    pub fn permission(&self) -> std::option::Option<&crate::model::Permission> {
        self.permission.as_ref()
    }
    /// The ID of the resource. (This ID is assigned to the resource when you create the resource definiton.)
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceAccessPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAccessPolicy");
        formatter.field("permission", &self.permission);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
/// See [`ResourceAccessPolicy`](crate::model::ResourceAccessPolicy)
pub mod resource_access_policy {
    /// A builder for [`ResourceAccessPolicy`](crate::model::ResourceAccessPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permission: std::option::Option<crate::model::Permission>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or ''ro'' (read-only).
        pub fn permission(mut self, input: crate::model::Permission) -> Self {
            self.permission = Some(input);
            self
        }
        /// The permissions that the Lambda function has to the resource. Can be one of ''rw'' (read/write) or ''ro'' (read-only).
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// The ID of the resource. (This ID is assigned to the resource when you create the resource definiton.)
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// The ID of the resource. (This ID is assigned to the resource when you create the resource definiton.)
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAccessPolicy`](crate::model::ResourceAccessPolicy)
        pub fn build(self) -> crate::model::ResourceAccessPolicy {
            crate::model::ResourceAccessPolicy {
                permission: self.permission,
                resource_id: self.resource_id,
            }
        }
    }
}
impl ResourceAccessPolicy {
    /// Creates a new builder-style object to manufacture [`ResourceAccessPolicy`](crate::model::ResourceAccessPolicy)
    pub fn builder() -> crate::model::resource_access_policy::Builder {
        crate::model::resource_access_policy::Builder::default()
    }
}

/// Configuration information that specifies how a Lambda function runs.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionExecutionConfig {
    /// Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
    pub isolation_mode: std::option::Option<crate::model::FunctionIsolationMode>,
    /// Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
    pub run_as: std::option::Option<crate::model::FunctionRunAsConfig>,
}
impl FunctionExecutionConfig {
    /// Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
    pub fn isolation_mode(&self) -> std::option::Option<&crate::model::FunctionIsolationMode> {
        self.isolation_mode.as_ref()
    }
    /// Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
    pub fn run_as(&self) -> std::option::Option<&crate::model::FunctionRunAsConfig> {
        self.run_as.as_ref()
    }
}
impl std::fmt::Debug for FunctionExecutionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionExecutionConfig");
        formatter.field("isolation_mode", &self.isolation_mode);
        formatter.field("run_as", &self.run_as);
        formatter.finish()
    }
}
/// See [`FunctionExecutionConfig`](crate::model::FunctionExecutionConfig)
pub mod function_execution_config {
    /// A builder for [`FunctionExecutionConfig`](crate::model::FunctionExecutionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) isolation_mode: std::option::Option<crate::model::FunctionIsolationMode>,
        pub(crate) run_as: std::option::Option<crate::model::FunctionRunAsConfig>,
    }
    impl Builder {
        /// Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
        pub fn isolation_mode(mut self, input: crate::model::FunctionIsolationMode) -> Self {
            self.isolation_mode = Some(input);
            self
        }
        /// Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
        pub fn set_isolation_mode(
            mut self,
            input: std::option::Option<crate::model::FunctionIsolationMode>,
        ) -> Self {
            self.isolation_mode = input;
            self
        }
        /// Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
        pub fn run_as(mut self, input: crate::model::FunctionRunAsConfig) -> Self {
            self.run_as = Some(input);
            self
        }
        /// Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
        pub fn set_run_as(
            mut self,
            input: std::option::Option<crate::model::FunctionRunAsConfig>,
        ) -> Self {
            self.run_as = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionExecutionConfig`](crate::model::FunctionExecutionConfig)
        pub fn build(self) -> crate::model::FunctionExecutionConfig {
            crate::model::FunctionExecutionConfig {
                isolation_mode: self.isolation_mode,
                run_as: self.run_as,
            }
        }
    }
}
impl FunctionExecutionConfig {
    /// Creates a new builder-style object to manufacture [`FunctionExecutionConfig`](crate::model::FunctionExecutionConfig)
    pub fn builder() -> crate::model::function_execution_config::Builder {
        crate::model::function_execution_config::Builder::default()
    }
}

/// Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionRunAsConfig {
    /// The group ID whose permissions are used to run a Lambda function.
    pub gid: i32,
    /// The user ID whose permissions are used to run a Lambda function.
    pub uid: i32,
}
impl FunctionRunAsConfig {
    /// The group ID whose permissions are used to run a Lambda function.
    pub fn gid(&self) -> i32 {
        self.gid
    }
    /// The user ID whose permissions are used to run a Lambda function.
    pub fn uid(&self) -> i32 {
        self.uid
    }
}
impl std::fmt::Debug for FunctionRunAsConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionRunAsConfig");
        formatter.field("gid", &self.gid);
        formatter.field("uid", &self.uid);
        formatter.finish()
    }
}
/// See [`FunctionRunAsConfig`](crate::model::FunctionRunAsConfig)
pub mod function_run_as_config {
    /// A builder for [`FunctionRunAsConfig`](crate::model::FunctionRunAsConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gid: std::option::Option<i32>,
        pub(crate) uid: std::option::Option<i32>,
    }
    impl Builder {
        /// The group ID whose permissions are used to run a Lambda function.
        pub fn gid(mut self, input: i32) -> Self {
            self.gid = Some(input);
            self
        }
        /// The group ID whose permissions are used to run a Lambda function.
        pub fn set_gid(mut self, input: std::option::Option<i32>) -> Self {
            self.gid = input;
            self
        }
        /// The user ID whose permissions are used to run a Lambda function.
        pub fn uid(mut self, input: i32) -> Self {
            self.uid = Some(input);
            self
        }
        /// The user ID whose permissions are used to run a Lambda function.
        pub fn set_uid(mut self, input: std::option::Option<i32>) -> Self {
            self.uid = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionRunAsConfig`](crate::model::FunctionRunAsConfig)
        pub fn build(self) -> crate::model::FunctionRunAsConfig {
            crate::model::FunctionRunAsConfig {
                gid: self.gid.unwrap_or_default(),
                uid: self.uid.unwrap_or_default(),
            }
        }
    }
}
impl FunctionRunAsConfig {
    /// Creates a new builder-style object to manufacture [`FunctionRunAsConfig`](crate::model::FunctionRunAsConfig)
    pub fn builder() -> crate::model::function_run_as_config::Builder {
        crate::model::function_run_as_config::Builder::default()
    }
}

/// Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FunctionIsolationMode {
    #[allow(missing_docs)] // documentation missing in model
    GreengrassContainer,
    #[allow(missing_docs)] // documentation missing in model
    NoContainer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FunctionIsolationMode {
    fn from(s: &str) -> Self {
        match s {
            "GreengrassContainer" => FunctionIsolationMode::GreengrassContainer,
            "NoContainer" => FunctionIsolationMode::NoContainer,
            other => FunctionIsolationMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FunctionIsolationMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FunctionIsolationMode::from(s))
    }
}
impl FunctionIsolationMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FunctionIsolationMode::GreengrassContainer => "GreengrassContainer",
            FunctionIsolationMode::NoContainer => "NoContainer",
            FunctionIsolationMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GreengrassContainer", "NoContainer"]
    }
}
impl AsRef<str> for FunctionIsolationMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncodingType {
    #[allow(missing_docs)] // documentation missing in model
    Binary,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncodingType {
    fn from(s: &str) -> Self {
        match s {
            "binary" => EncodingType::Binary,
            "json" => EncodingType::Json,
            other => EncodingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncodingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncodingType::from(s))
    }
}
impl EncodingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncodingType::Binary => "binary",
            EncodingType::Json => "json",
            EncodingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["binary", "json"]
    }
}
impl AsRef<str> for EncodingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The default configuration that applies to all Lambda functions in the group. Individual Lambda functions can override these settings.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionDefaultConfig {
    /// Configuration information that specifies how a Lambda function runs.
    pub execution: std::option::Option<crate::model::FunctionDefaultExecutionConfig>,
}
impl FunctionDefaultConfig {
    /// Configuration information that specifies how a Lambda function runs.
    pub fn execution(&self) -> std::option::Option<&crate::model::FunctionDefaultExecutionConfig> {
        self.execution.as_ref()
    }
}
impl std::fmt::Debug for FunctionDefaultConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionDefaultConfig");
        formatter.field("execution", &self.execution);
        formatter.finish()
    }
}
/// See [`FunctionDefaultConfig`](crate::model::FunctionDefaultConfig)
pub mod function_default_config {
    /// A builder for [`FunctionDefaultConfig`](crate::model::FunctionDefaultConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution: std::option::Option<crate::model::FunctionDefaultExecutionConfig>,
    }
    impl Builder {
        /// Configuration information that specifies how a Lambda function runs.
        pub fn execution(mut self, input: crate::model::FunctionDefaultExecutionConfig) -> Self {
            self.execution = Some(input);
            self
        }
        /// Configuration information that specifies how a Lambda function runs.
        pub fn set_execution(
            mut self,
            input: std::option::Option<crate::model::FunctionDefaultExecutionConfig>,
        ) -> Self {
            self.execution = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionDefaultConfig`](crate::model::FunctionDefaultConfig)
        pub fn build(self) -> crate::model::FunctionDefaultConfig {
            crate::model::FunctionDefaultConfig {
                execution: self.execution,
            }
        }
    }
}
impl FunctionDefaultConfig {
    /// Creates a new builder-style object to manufacture [`FunctionDefaultConfig`](crate::model::FunctionDefaultConfig)
    pub fn builder() -> crate::model::function_default_config::Builder {
        crate::model::function_default_config::Builder::default()
    }
}

/// Configuration information that specifies how a Lambda function runs.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionDefaultExecutionConfig {
    /// Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
    pub isolation_mode: std::option::Option<crate::model::FunctionIsolationMode>,
    /// Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
    pub run_as: std::option::Option<crate::model::FunctionRunAsConfig>,
}
impl FunctionDefaultExecutionConfig {
    /// Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
    pub fn isolation_mode(&self) -> std::option::Option<&crate::model::FunctionIsolationMode> {
        self.isolation_mode.as_ref()
    }
    /// Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
    pub fn run_as(&self) -> std::option::Option<&crate::model::FunctionRunAsConfig> {
        self.run_as.as_ref()
    }
}
impl std::fmt::Debug for FunctionDefaultExecutionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionDefaultExecutionConfig");
        formatter.field("isolation_mode", &self.isolation_mode);
        formatter.field("run_as", &self.run_as);
        formatter.finish()
    }
}
/// See [`FunctionDefaultExecutionConfig`](crate::model::FunctionDefaultExecutionConfig)
pub mod function_default_execution_config {
    /// A builder for [`FunctionDefaultExecutionConfig`](crate::model::FunctionDefaultExecutionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) isolation_mode: std::option::Option<crate::model::FunctionIsolationMode>,
        pub(crate) run_as: std::option::Option<crate::model::FunctionRunAsConfig>,
    }
    impl Builder {
        /// Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
        pub fn isolation_mode(mut self, input: crate::model::FunctionIsolationMode) -> Self {
            self.isolation_mode = Some(input);
            self
        }
        /// Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
        pub fn set_isolation_mode(
            mut self,
            input: std::option::Option<crate::model::FunctionIsolationMode>,
        ) -> Self {
            self.isolation_mode = input;
            self
        }
        /// Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
        pub fn run_as(mut self, input: crate::model::FunctionRunAsConfig) -> Self {
            self.run_as = Some(input);
            self
        }
        /// Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
        pub fn set_run_as(
            mut self,
            input: std::option::Option<crate::model::FunctionRunAsConfig>,
        ) -> Self {
            self.run_as = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionDefaultExecutionConfig`](crate::model::FunctionDefaultExecutionConfig)
        pub fn build(self) -> crate::model::FunctionDefaultExecutionConfig {
            crate::model::FunctionDefaultExecutionConfig {
                isolation_mode: self.isolation_mode,
                run_as: self.run_as,
            }
        }
    }
}
impl FunctionDefaultExecutionConfig {
    /// Creates a new builder-style object to manufacture [`FunctionDefaultExecutionConfig`](crate::model::FunctionDefaultExecutionConfig)
    pub fn builder() -> crate::model::function_default_execution_config::Builder {
        crate::model::function_default_execution_config::Builder::default()
    }
}

/// Information about a device definition version.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeviceDefinitionVersion {
    /// A list of devices in the definition version.
    pub devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
}
impl DeviceDefinitionVersion {
    /// A list of devices in the definition version.
    pub fn devices(&self) -> std::option::Option<&[crate::model::Device]> {
        self.devices.as_deref()
    }
}
impl std::fmt::Debug for DeviceDefinitionVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeviceDefinitionVersion");
        formatter.field("devices", &self.devices);
        formatter.finish()
    }
}
/// See [`DeviceDefinitionVersion`](crate::model::DeviceDefinitionVersion)
pub mod device_definition_version {
    /// A builder for [`DeviceDefinitionVersion`](crate::model::DeviceDefinitionVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
    }
    impl Builder {
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// A list of devices in the definition version.
        pub fn devices(mut self, input: crate::model::Device) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input);
            self.devices = Some(v);
            self
        }
        /// A list of devices in the definition version.
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Device>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// Consumes the builder and constructs a [`DeviceDefinitionVersion`](crate::model::DeviceDefinitionVersion)
        pub fn build(self) -> crate::model::DeviceDefinitionVersion {
            crate::model::DeviceDefinitionVersion {
                devices: self.devices,
            }
        }
    }
}
impl DeviceDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`DeviceDefinitionVersion`](crate::model::DeviceDefinitionVersion)
    pub fn builder() -> crate::model::device_definition_version::Builder {
        crate::model::device_definition_version::Builder::default()
    }
}

/// Information about a device.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Device {
    /// The ARN of the certificate associated with the device.
    pub certificate_arn: std::option::Option<std::string::String>,
    /// A descriptive or arbitrary ID for the device. This value must be unique within the device definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
    pub id: std::option::Option<std::string::String>,
    /// If true, the device's local shadow will be automatically synced with the cloud.
    pub sync_shadow: bool,
    /// The thing ARN of the device.
    pub thing_arn: std::option::Option<std::string::String>,
}
impl Device {
    /// The ARN of the certificate associated with the device.
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// A descriptive or arbitrary ID for the device. This value must be unique within the device definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// If true, the device's local shadow will be automatically synced with the cloud.
    pub fn sync_shadow(&self) -> bool {
        self.sync_shadow
    }
    /// The thing ARN of the device.
    pub fn thing_arn(&self) -> std::option::Option<&str> {
        self.thing_arn.as_deref()
    }
}
impl std::fmt::Debug for Device {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Device");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("id", &self.id);
        formatter.field("sync_shadow", &self.sync_shadow);
        formatter.field("thing_arn", &self.thing_arn);
        formatter.finish()
    }
}
/// See [`Device`](crate::model::Device)
pub mod device {
    /// A builder for [`Device`](crate::model::Device)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) sync_shadow: std::option::Option<bool>,
        pub(crate) thing_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the certificate associated with the device.
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// The ARN of the certificate associated with the device.
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// A descriptive or arbitrary ID for the device. This value must be unique within the device definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// A descriptive or arbitrary ID for the device. This value must be unique within the device definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// If true, the device's local shadow will be automatically synced with the cloud.
        pub fn sync_shadow(mut self, input: bool) -> Self {
            self.sync_shadow = Some(input);
            self
        }
        /// If true, the device's local shadow will be automatically synced with the cloud.
        pub fn set_sync_shadow(mut self, input: std::option::Option<bool>) -> Self {
            self.sync_shadow = input;
            self
        }
        /// The thing ARN of the device.
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// The thing ARN of the device.
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Device`](crate::model::Device)
        pub fn build(self) -> crate::model::Device {
            crate::model::Device {
                certificate_arn: self.certificate_arn,
                id: self.id,
                sync_shadow: self.sync_shadow.unwrap_or_default(),
                thing_arn: self.thing_arn,
            }
        }
    }
}
impl Device {
    /// Creates a new builder-style object to manufacture [`Device`](crate::model::Device)
    pub fn builder() -> crate::model::device::Builder {
        crate::model::device::Builder::default()
    }
}

/// Information about a core definition version.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoreDefinitionVersion {
    /// A list of cores in the core definition version.
    pub cores: std::option::Option<std::vec::Vec<crate::model::Core>>,
}
impl CoreDefinitionVersion {
    /// A list of cores in the core definition version.
    pub fn cores(&self) -> std::option::Option<&[crate::model::Core]> {
        self.cores.as_deref()
    }
}
impl std::fmt::Debug for CoreDefinitionVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoreDefinitionVersion");
        formatter.field("cores", &self.cores);
        formatter.finish()
    }
}
/// See [`CoreDefinitionVersion`](crate::model::CoreDefinitionVersion)
pub mod core_definition_version {
    /// A builder for [`CoreDefinitionVersion`](crate::model::CoreDefinitionVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cores: std::option::Option<std::vec::Vec<crate::model::Core>>,
    }
    impl Builder {
        /// Appends an item to `cores`.
        ///
        /// To override the contents of this collection use [`set_cores`](Self::set_cores).
        ///
        /// A list of cores in the core definition version.
        pub fn cores(mut self, input: crate::model::Core) -> Self {
            let mut v = self.cores.unwrap_or_default();
            v.push(input);
            self.cores = Some(v);
            self
        }
        /// A list of cores in the core definition version.
        pub fn set_cores(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Core>>,
        ) -> Self {
            self.cores = input;
            self
        }
        /// Consumes the builder and constructs a [`CoreDefinitionVersion`](crate::model::CoreDefinitionVersion)
        pub fn build(self) -> crate::model::CoreDefinitionVersion {
            crate::model::CoreDefinitionVersion { cores: self.cores }
        }
    }
}
impl CoreDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`CoreDefinitionVersion`](crate::model::CoreDefinitionVersion)
    pub fn builder() -> crate::model::core_definition_version::Builder {
        crate::model::core_definition_version::Builder::default()
    }
}

/// Information about a core.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Core {
    /// The ARN of the certificate associated with the core.
    pub certificate_arn: std::option::Option<std::string::String>,
    /// A descriptive or arbitrary ID for the core. This value must be unique within the core definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
    pub id: std::option::Option<std::string::String>,
    /// If true, the core's local shadow is automatically synced with the cloud.
    pub sync_shadow: bool,
    /// The ARN of the thing which is the core.
    pub thing_arn: std::option::Option<std::string::String>,
}
impl Core {
    /// The ARN of the certificate associated with the core.
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// A descriptive or arbitrary ID for the core. This value must be unique within the core definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// If true, the core's local shadow is automatically synced with the cloud.
    pub fn sync_shadow(&self) -> bool {
        self.sync_shadow
    }
    /// The ARN of the thing which is the core.
    pub fn thing_arn(&self) -> std::option::Option<&str> {
        self.thing_arn.as_deref()
    }
}
impl std::fmt::Debug for Core {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Core");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("id", &self.id);
        formatter.field("sync_shadow", &self.sync_shadow);
        formatter.field("thing_arn", &self.thing_arn);
        formatter.finish()
    }
}
/// See [`Core`](crate::model::Core)
pub mod core {
    /// A builder for [`Core`](crate::model::Core)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) sync_shadow: std::option::Option<bool>,
        pub(crate) thing_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the certificate associated with the core.
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// The ARN of the certificate associated with the core.
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// A descriptive or arbitrary ID for the core. This value must be unique within the core definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// A descriptive or arbitrary ID for the core. This value must be unique within the core definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// If true, the core's local shadow is automatically synced with the cloud.
        pub fn sync_shadow(mut self, input: bool) -> Self {
            self.sync_shadow = Some(input);
            self
        }
        /// If true, the core's local shadow is automatically synced with the cloud.
        pub fn set_sync_shadow(mut self, input: std::option::Option<bool>) -> Self {
            self.sync_shadow = input;
            self
        }
        /// The ARN of the thing which is the core.
        pub fn thing_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_arn = Some(input.into());
            self
        }
        /// The ARN of the thing which is the core.
        pub fn set_thing_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Core`](crate::model::Core)
        pub fn build(self) -> crate::model::Core {
            crate::model::Core {
                certificate_arn: self.certificate_arn,
                id: self.id,
                sync_shadow: self.sync_shadow.unwrap_or_default(),
                thing_arn: self.thing_arn,
            }
        }
    }
}
impl Core {
    /// Creates a new builder-style object to manufacture [`Core`](crate::model::Core)
    pub fn builder() -> crate::model::core::Builder {
        crate::model::core::Builder::default()
    }
}

/// Information about the connector definition version, which is a container for connectors.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorDefinitionVersion {
    /// A list of references to connectors in this version, with their corresponding configuration settings.
    pub connectors: std::option::Option<std::vec::Vec<crate::model::Connector>>,
}
impl ConnectorDefinitionVersion {
    /// A list of references to connectors in this version, with their corresponding configuration settings.
    pub fn connectors(&self) -> std::option::Option<&[crate::model::Connector]> {
        self.connectors.as_deref()
    }
}
impl std::fmt::Debug for ConnectorDefinitionVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorDefinitionVersion");
        formatter.field("connectors", &self.connectors);
        formatter.finish()
    }
}
/// See [`ConnectorDefinitionVersion`](crate::model::ConnectorDefinitionVersion)
pub mod connector_definition_version {
    /// A builder for [`ConnectorDefinitionVersion`](crate::model::ConnectorDefinitionVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connectors: std::option::Option<std::vec::Vec<crate::model::Connector>>,
    }
    impl Builder {
        /// Appends an item to `connectors`.
        ///
        /// To override the contents of this collection use [`set_connectors`](Self::set_connectors).
        ///
        /// A list of references to connectors in this version, with their corresponding configuration settings.
        pub fn connectors(mut self, input: crate::model::Connector) -> Self {
            let mut v = self.connectors.unwrap_or_default();
            v.push(input);
            self.connectors = Some(v);
            self
        }
        /// A list of references to connectors in this version, with their corresponding configuration settings.
        pub fn set_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connector>>,
        ) -> Self {
            self.connectors = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorDefinitionVersion`](crate::model::ConnectorDefinitionVersion)
        pub fn build(self) -> crate::model::ConnectorDefinitionVersion {
            crate::model::ConnectorDefinitionVersion {
                connectors: self.connectors,
            }
        }
    }
}
impl ConnectorDefinitionVersion {
    /// Creates a new builder-style object to manufacture [`ConnectorDefinitionVersion`](crate::model::ConnectorDefinitionVersion)
    pub fn builder() -> crate::model::connector_definition_version::Builder {
        crate::model::connector_definition_version::Builder::default()
    }
}

/// Information about a connector. Connectors run on the Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other cloud services.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Connector {
    /// The ARN of the connector.
    pub connector_arn: std::option::Option<std::string::String>,
    /// A descriptive or arbitrary ID for the connector. This value must be unique within the connector definition version. Max length is 128 characters with pattern [a-zA-Z0-9:_-]+.
    pub id: std::option::Option<std::string::String>,
    /// The parameters or configuration that the connector uses.
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Connector {
    /// The ARN of the connector.
    pub fn connector_arn(&self) -> std::option::Option<&str> {
        self.connector_arn.as_deref()
    }
    /// A descriptive or arbitrary ID for the connector. This value must be unique within the connector definition version. Max length is 128 characters with pattern [a-zA-Z0-9:_-]+.
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// The parameters or configuration that the connector uses.
    pub fn parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parameters.as_ref()
    }
}
impl std::fmt::Debug for Connector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Connector");
        formatter.field("connector_arn", &self.connector_arn);
        formatter.field("id", &self.id);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`Connector`](crate::model::Connector)
pub mod connector {
    /// A builder for [`Connector`](crate::model::Connector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The ARN of the connector.
        pub fn connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_arn = Some(input.into());
            self
        }
        /// The ARN of the connector.
        pub fn set_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_arn = input;
            self
        }
        /// A descriptive or arbitrary ID for the connector. This value must be unique within the connector definition version. Max length is 128 characters with pattern [a-zA-Z0-9:_-]+.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// A descriptive or arbitrary ID for the connector. This value must be unique within the connector definition version. Max length is 128 characters with pattern [a-zA-Z0-9:_-]+.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// The parameters or configuration that the connector uses.
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// The parameters or configuration that the connector uses.
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`Connector`](crate::model::Connector)
        pub fn build(self) -> crate::model::Connector {
            crate::model::Connector {
                connector_arn: self.connector_arn,
                id: self.id,
                parameters: self.parameters,
            }
        }
    }
}
impl Connector {
    /// Creates a new builder-style object to manufacture [`Connector`](crate::model::Connector)
    pub fn builder() -> crate::model::connector::Builder {
        crate::model::connector::Builder::default()
    }
}

/// The current status of the bulk deployment.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BulkDeploymentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Initializing,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BulkDeploymentStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => BulkDeploymentStatus::Completed,
            "Failed" => BulkDeploymentStatus::Failed,
            "Initializing" => BulkDeploymentStatus::Initializing,
            "Running" => BulkDeploymentStatus::Running,
            "Stopped" => BulkDeploymentStatus::Stopped,
            "Stopping" => BulkDeploymentStatus::Stopping,
            other => BulkDeploymentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BulkDeploymentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BulkDeploymentStatus::from(s))
    }
}
impl BulkDeploymentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BulkDeploymentStatus::Completed => "Completed",
            BulkDeploymentStatus::Failed => "Failed",
            BulkDeploymentStatus::Initializing => "Initializing",
            BulkDeploymentStatus::Running => "Running",
            BulkDeploymentStatus::Stopped => "Stopped",
            BulkDeploymentStatus::Stopping => "Stopping",
            BulkDeploymentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Completed",
            "Failed",
            "Initializing",
            "Running",
            "Stopped",
            "Stopping",
        ]
    }
}
impl AsRef<str> for BulkDeploymentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Relevant metrics on input records processed during bulk deployment.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BulkDeploymentMetrics {
    /// The total number of records that returned a non-retryable error. For example, this can occur if a group record from the input file uses an invalid format or specifies a nonexistent group version, or if the execution role doesn't grant permission to deploy a group or group version.
    pub invalid_input_records: i32,
    /// The total number of group records from the input file that have been processed so far, or attempted.
    pub records_processed: i32,
    /// The total number of deployment attempts that returned a retryable error. For example, a retry is triggered if the attempt to deploy a group returns a throttling error. ''StartBulkDeployment'' retries a group deployment up to five times.
    pub retry_attempts: i32,
}
impl BulkDeploymentMetrics {
    /// The total number of records that returned a non-retryable error. For example, this can occur if a group record from the input file uses an invalid format or specifies a nonexistent group version, or if the execution role doesn't grant permission to deploy a group or group version.
    pub fn invalid_input_records(&self) -> i32 {
        self.invalid_input_records
    }
    /// The total number of group records from the input file that have been processed so far, or attempted.
    pub fn records_processed(&self) -> i32 {
        self.records_processed
    }
    /// The total number of deployment attempts that returned a retryable error. For example, a retry is triggered if the attempt to deploy a group returns a throttling error. ''StartBulkDeployment'' retries a group deployment up to five times.
    pub fn retry_attempts(&self) -> i32 {
        self.retry_attempts
    }
}
impl std::fmt::Debug for BulkDeploymentMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BulkDeploymentMetrics");
        formatter.field("invalid_input_records", &self.invalid_input_records);
        formatter.field("records_processed", &self.records_processed);
        formatter.field("retry_attempts", &self.retry_attempts);
        formatter.finish()
    }
}
/// See [`BulkDeploymentMetrics`](crate::model::BulkDeploymentMetrics)
pub mod bulk_deployment_metrics {
    /// A builder for [`BulkDeploymentMetrics`](crate::model::BulkDeploymentMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invalid_input_records: std::option::Option<i32>,
        pub(crate) records_processed: std::option::Option<i32>,
        pub(crate) retry_attempts: std::option::Option<i32>,
    }
    impl Builder {
        /// The total number of records that returned a non-retryable error. For example, this can occur if a group record from the input file uses an invalid format or specifies a nonexistent group version, or if the execution role doesn't grant permission to deploy a group or group version.
        pub fn invalid_input_records(mut self, input: i32) -> Self {
            self.invalid_input_records = Some(input);
            self
        }
        /// The total number of records that returned a non-retryable error. For example, this can occur if a group record from the input file uses an invalid format or specifies a nonexistent group version, or if the execution role doesn't grant permission to deploy a group or group version.
        pub fn set_invalid_input_records(mut self, input: std::option::Option<i32>) -> Self {
            self.invalid_input_records = input;
            self
        }
        /// The total number of group records from the input file that have been processed so far, or attempted.
        pub fn records_processed(mut self, input: i32) -> Self {
            self.records_processed = Some(input);
            self
        }
        /// The total number of group records from the input file that have been processed so far, or attempted.
        pub fn set_records_processed(mut self, input: std::option::Option<i32>) -> Self {
            self.records_processed = input;
            self
        }
        /// The total number of deployment attempts that returned a retryable error. For example, a retry is triggered if the attempt to deploy a group returns a throttling error. ''StartBulkDeployment'' retries a group deployment up to five times.
        pub fn retry_attempts(mut self, input: i32) -> Self {
            self.retry_attempts = Some(input);
            self
        }
        /// The total number of deployment attempts that returned a retryable error. For example, a retry is triggered if the attempt to deploy a group returns a throttling error. ''StartBulkDeployment'' retries a group deployment up to five times.
        pub fn set_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_attempts = input;
            self
        }
        /// Consumes the builder and constructs a [`BulkDeploymentMetrics`](crate::model::BulkDeploymentMetrics)
        pub fn build(self) -> crate::model::BulkDeploymentMetrics {
            crate::model::BulkDeploymentMetrics {
                invalid_input_records: self.invalid_input_records.unwrap_or_default(),
                records_processed: self.records_processed.unwrap_or_default(),
                retry_attempts: self.retry_attempts.unwrap_or_default(),
            }
        }
    }
}
impl BulkDeploymentMetrics {
    /// Creates a new builder-style object to manufacture [`BulkDeploymentMetrics`](crate::model::BulkDeploymentMetrics)
    pub fn builder() -> crate::model::bulk_deployment_metrics::Builder {
        crate::model::bulk_deployment_metrics::Builder::default()
    }
}

/// The operating system of the cores which are the targets of an update.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateTargetsOperatingSystem {
    #[allow(missing_docs)] // documentation missing in model
    AmazonLinux,
    #[allow(missing_docs)] // documentation missing in model
    Openwrt,
    #[allow(missing_docs)] // documentation missing in model
    Raspbian,
    #[allow(missing_docs)] // documentation missing in model
    Ubuntu,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateTargetsOperatingSystem {
    fn from(s: &str) -> Self {
        match s {
            "amazon_linux" => UpdateTargetsOperatingSystem::AmazonLinux,
            "openwrt" => UpdateTargetsOperatingSystem::Openwrt,
            "raspbian" => UpdateTargetsOperatingSystem::Raspbian,
            "ubuntu" => UpdateTargetsOperatingSystem::Ubuntu,
            other => UpdateTargetsOperatingSystem::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateTargetsOperatingSystem {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateTargetsOperatingSystem::from(s))
    }
}
impl UpdateTargetsOperatingSystem {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateTargetsOperatingSystem::AmazonLinux => "amazon_linux",
            UpdateTargetsOperatingSystem::Openwrt => "openwrt",
            UpdateTargetsOperatingSystem::Raspbian => "raspbian",
            UpdateTargetsOperatingSystem::Ubuntu => "ubuntu",
            UpdateTargetsOperatingSystem::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["amazon_linux", "openwrt", "raspbian", "ubuntu"]
    }
}
impl AsRef<str> for UpdateTargetsOperatingSystem {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The architecture of the cores which are the targets of an update.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateTargetsArchitecture {
    #[allow(missing_docs)] // documentation missing in model
    Aarch64,
    #[allow(missing_docs)] // documentation missing in model
    Armv6l,
    #[allow(missing_docs)] // documentation missing in model
    Armv7l,
    #[allow(missing_docs)] // documentation missing in model
    X8664,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateTargetsArchitecture {
    fn from(s: &str) -> Self {
        match s {
            "aarch64" => UpdateTargetsArchitecture::Aarch64,
            "armv6l" => UpdateTargetsArchitecture::Armv6l,
            "armv7l" => UpdateTargetsArchitecture::Armv7l,
            "x86_64" => UpdateTargetsArchitecture::X8664,
            other => UpdateTargetsArchitecture::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateTargetsArchitecture {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateTargetsArchitecture::from(s))
    }
}
impl UpdateTargetsArchitecture {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateTargetsArchitecture::Aarch64 => "aarch64",
            UpdateTargetsArchitecture::Armv6l => "armv6l",
            UpdateTargetsArchitecture::Armv7l => "armv7l",
            UpdateTargetsArchitecture::X8664 => "x86_64",
            UpdateTargetsArchitecture::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["aarch64", "armv6l", "armv7l", "x86_64"]
    }
}
impl AsRef<str> for UpdateTargetsArchitecture {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The minimum level of log statements that should be logged by the OTA Agent during an update.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateAgentLogLevel {
    #[allow(missing_docs)] // documentation missing in model
    Debug,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Fatal,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Trace,
    #[allow(missing_docs)] // documentation missing in model
    Verbose,
    #[allow(missing_docs)] // documentation missing in model
    Warn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateAgentLogLevel {
    fn from(s: &str) -> Self {
        match s {
            "DEBUG" => UpdateAgentLogLevel::Debug,
            "ERROR" => UpdateAgentLogLevel::Error,
            "FATAL" => UpdateAgentLogLevel::Fatal,
            "INFO" => UpdateAgentLogLevel::Info,
            "NONE" => UpdateAgentLogLevel::None,
            "TRACE" => UpdateAgentLogLevel::Trace,
            "VERBOSE" => UpdateAgentLogLevel::Verbose,
            "WARN" => UpdateAgentLogLevel::Warn,
            other => UpdateAgentLogLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateAgentLogLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateAgentLogLevel::from(s))
    }
}
impl UpdateAgentLogLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateAgentLogLevel::Debug => "DEBUG",
            UpdateAgentLogLevel::Error => "ERROR",
            UpdateAgentLogLevel::Fatal => "FATAL",
            UpdateAgentLogLevel::Info => "INFO",
            UpdateAgentLogLevel::None => "NONE",
            UpdateAgentLogLevel::Trace => "TRACE",
            UpdateAgentLogLevel::Verbose => "VERBOSE",
            UpdateAgentLogLevel::Warn => "WARN",
            UpdateAgentLogLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEBUG", "ERROR", "FATAL", "INFO", "NONE", "TRACE", "VERBOSE", "WARN",
        ]
    }
}
impl AsRef<str> for UpdateAgentLogLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The piece of software on the Greengrass core that will be updated.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SoftwareToUpdate {
    #[allow(missing_docs)] // documentation missing in model
    Core,
    #[allow(missing_docs)] // documentation missing in model
    OtaAgent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SoftwareToUpdate {
    fn from(s: &str) -> Self {
        match s {
            "core" => SoftwareToUpdate::Core,
            "ota_agent" => SoftwareToUpdate::OtaAgent,
            other => SoftwareToUpdate::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SoftwareToUpdate {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SoftwareToUpdate::from(s))
    }
}
impl SoftwareToUpdate {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SoftwareToUpdate::Core => "core",
            SoftwareToUpdate::OtaAgent => "ota_agent",
            SoftwareToUpdate::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["core", "ota_agent"]
    }
}
impl AsRef<str> for SoftwareToUpdate {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
