// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `Greengrass`.
///
/// This client allows ergonomic access to a `Greengrass`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateRoleToGroup` operation.
    ///
    /// See [`AssociateRoleToGroup`](crate::client::fluent_builders::AssociateRoleToGroup) for more information about the
    /// operation and its arguments.
    pub fn associate_role_to_group(&self) -> fluent_builders::AssociateRoleToGroup<C, M, R> {
        fluent_builders::AssociateRoleToGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateServiceRoleToAccount` operation.
    ///
    /// See [`AssociateServiceRoleToAccount`](crate::client::fluent_builders::AssociateServiceRoleToAccount) for more information about the
    /// operation and its arguments.
    pub fn associate_service_role_to_account(
        &self,
    ) -> fluent_builders::AssociateServiceRoleToAccount<C, M, R> {
        fluent_builders::AssociateServiceRoleToAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConnectorDefinition` operation.
    ///
    /// See [`CreateConnectorDefinition`](crate::client::fluent_builders::CreateConnectorDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_connector_definition(
        &self,
    ) -> fluent_builders::CreateConnectorDefinition<C, M, R> {
        fluent_builders::CreateConnectorDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConnectorDefinitionVersion` operation.
    ///
    /// See [`CreateConnectorDefinitionVersion`](crate::client::fluent_builders::CreateConnectorDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn create_connector_definition_version(
        &self,
    ) -> fluent_builders::CreateConnectorDefinitionVersion<C, M, R> {
        fluent_builders::CreateConnectorDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCoreDefinition` operation.
    ///
    /// See [`CreateCoreDefinition`](crate::client::fluent_builders::CreateCoreDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_core_definition(&self) -> fluent_builders::CreateCoreDefinition<C, M, R> {
        fluent_builders::CreateCoreDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCoreDefinitionVersion` operation.
    ///
    /// See [`CreateCoreDefinitionVersion`](crate::client::fluent_builders::CreateCoreDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn create_core_definition_version(
        &self,
    ) -> fluent_builders::CreateCoreDefinitionVersion<C, M, R> {
        fluent_builders::CreateCoreDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeployment` operation.
    ///
    /// See [`CreateDeployment`](crate::client::fluent_builders::CreateDeployment) for more information about the
    /// operation and its arguments.
    pub fn create_deployment(&self) -> fluent_builders::CreateDeployment<C, M, R> {
        fluent_builders::CreateDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeviceDefinition` operation.
    ///
    /// See [`CreateDeviceDefinition`](crate::client::fluent_builders::CreateDeviceDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_device_definition(&self) -> fluent_builders::CreateDeviceDefinition<C, M, R> {
        fluent_builders::CreateDeviceDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeviceDefinitionVersion` operation.
    ///
    /// See [`CreateDeviceDefinitionVersion`](crate::client::fluent_builders::CreateDeviceDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn create_device_definition_version(
        &self,
    ) -> fluent_builders::CreateDeviceDefinitionVersion<C, M, R> {
        fluent_builders::CreateDeviceDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFunctionDefinition` operation.
    ///
    /// See [`CreateFunctionDefinition`](crate::client::fluent_builders::CreateFunctionDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_function_definition(&self) -> fluent_builders::CreateFunctionDefinition<C, M, R> {
        fluent_builders::CreateFunctionDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFunctionDefinitionVersion` operation.
    ///
    /// See [`CreateFunctionDefinitionVersion`](crate::client::fluent_builders::CreateFunctionDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn create_function_definition_version(
        &self,
    ) -> fluent_builders::CreateFunctionDefinitionVersion<C, M, R> {
        fluent_builders::CreateFunctionDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGroup` operation.
    ///
    /// See [`CreateGroup`](crate::client::fluent_builders::CreateGroup) for more information about the
    /// operation and its arguments.
    pub fn create_group(&self) -> fluent_builders::CreateGroup<C, M, R> {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGroupCertificateAuthority` operation.
    ///
    /// See [`CreateGroupCertificateAuthority`](crate::client::fluent_builders::CreateGroupCertificateAuthority) for more information about the
    /// operation and its arguments.
    pub fn create_group_certificate_authority(
        &self,
    ) -> fluent_builders::CreateGroupCertificateAuthority<C, M, R> {
        fluent_builders::CreateGroupCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGroupVersion` operation.
    ///
    /// See [`CreateGroupVersion`](crate::client::fluent_builders::CreateGroupVersion) for more information about the
    /// operation and its arguments.
    pub fn create_group_version(&self) -> fluent_builders::CreateGroupVersion<C, M, R> {
        fluent_builders::CreateGroupVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLoggerDefinition` operation.
    ///
    /// See [`CreateLoggerDefinition`](crate::client::fluent_builders::CreateLoggerDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_logger_definition(&self) -> fluent_builders::CreateLoggerDefinition<C, M, R> {
        fluent_builders::CreateLoggerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLoggerDefinitionVersion` operation.
    ///
    /// See [`CreateLoggerDefinitionVersion`](crate::client::fluent_builders::CreateLoggerDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn create_logger_definition_version(
        &self,
    ) -> fluent_builders::CreateLoggerDefinitionVersion<C, M, R> {
        fluent_builders::CreateLoggerDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResourceDefinition` operation.
    ///
    /// See [`CreateResourceDefinition`](crate::client::fluent_builders::CreateResourceDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_resource_definition(&self) -> fluent_builders::CreateResourceDefinition<C, M, R> {
        fluent_builders::CreateResourceDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResourceDefinitionVersion` operation.
    ///
    /// See [`CreateResourceDefinitionVersion`](crate::client::fluent_builders::CreateResourceDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn create_resource_definition_version(
        &self,
    ) -> fluent_builders::CreateResourceDefinitionVersion<C, M, R> {
        fluent_builders::CreateResourceDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSoftwareUpdateJob` operation.
    ///
    /// See [`CreateSoftwareUpdateJob`](crate::client::fluent_builders::CreateSoftwareUpdateJob) for more information about the
    /// operation and its arguments.
    pub fn create_software_update_job(&self) -> fluent_builders::CreateSoftwareUpdateJob<C, M, R> {
        fluent_builders::CreateSoftwareUpdateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSubscriptionDefinition` operation.
    ///
    /// See [`CreateSubscriptionDefinition`](crate::client::fluent_builders::CreateSubscriptionDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_subscription_definition(
        &self,
    ) -> fluent_builders::CreateSubscriptionDefinition<C, M, R> {
        fluent_builders::CreateSubscriptionDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSubscriptionDefinitionVersion` operation.
    ///
    /// See [`CreateSubscriptionDefinitionVersion`](crate::client::fluent_builders::CreateSubscriptionDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn create_subscription_definition_version(
        &self,
    ) -> fluent_builders::CreateSubscriptionDefinitionVersion<C, M, R> {
        fluent_builders::CreateSubscriptionDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnectorDefinition` operation.
    ///
    /// See [`DeleteConnectorDefinition`](crate::client::fluent_builders::DeleteConnectorDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_connector_definition(
        &self,
    ) -> fluent_builders::DeleteConnectorDefinition<C, M, R> {
        fluent_builders::DeleteConnectorDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCoreDefinition` operation.
    ///
    /// See [`DeleteCoreDefinition`](crate::client::fluent_builders::DeleteCoreDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_core_definition(&self) -> fluent_builders::DeleteCoreDefinition<C, M, R> {
        fluent_builders::DeleteCoreDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDeviceDefinition` operation.
    ///
    /// See [`DeleteDeviceDefinition`](crate::client::fluent_builders::DeleteDeviceDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_device_definition(&self) -> fluent_builders::DeleteDeviceDefinition<C, M, R> {
        fluent_builders::DeleteDeviceDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFunctionDefinition` operation.
    ///
    /// See [`DeleteFunctionDefinition`](crate::client::fluent_builders::DeleteFunctionDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_function_definition(&self) -> fluent_builders::DeleteFunctionDefinition<C, M, R> {
        fluent_builders::DeleteFunctionDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGroup` operation.
    ///
    /// See [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup<C, M, R> {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLoggerDefinition` operation.
    ///
    /// See [`DeleteLoggerDefinition`](crate::client::fluent_builders::DeleteLoggerDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_logger_definition(&self) -> fluent_builders::DeleteLoggerDefinition<C, M, R> {
        fluent_builders::DeleteLoggerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourceDefinition` operation.
    ///
    /// See [`DeleteResourceDefinition`](crate::client::fluent_builders::DeleteResourceDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_definition(&self) -> fluent_builders::DeleteResourceDefinition<C, M, R> {
        fluent_builders::DeleteResourceDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSubscriptionDefinition` operation.
    ///
    /// See [`DeleteSubscriptionDefinition`](crate::client::fluent_builders::DeleteSubscriptionDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_subscription_definition(
        &self,
    ) -> fluent_builders::DeleteSubscriptionDefinition<C, M, R> {
        fluent_builders::DeleteSubscriptionDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateRoleFromGroup` operation.
    ///
    /// See [`DisassociateRoleFromGroup`](crate::client::fluent_builders::DisassociateRoleFromGroup) for more information about the
    /// operation and its arguments.
    pub fn disassociate_role_from_group(
        &self,
    ) -> fluent_builders::DisassociateRoleFromGroup<C, M, R> {
        fluent_builders::DisassociateRoleFromGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateServiceRoleFromAccount` operation.
    ///
    /// See [`DisassociateServiceRoleFromAccount`](crate::client::fluent_builders::DisassociateServiceRoleFromAccount) for more information about the
    /// operation and its arguments.
    pub fn disassociate_service_role_from_account(
        &self,
    ) -> fluent_builders::DisassociateServiceRoleFromAccount<C, M, R> {
        fluent_builders::DisassociateServiceRoleFromAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssociatedRole` operation.
    ///
    /// See [`GetAssociatedRole`](crate::client::fluent_builders::GetAssociatedRole) for more information about the
    /// operation and its arguments.
    pub fn get_associated_role(&self) -> fluent_builders::GetAssociatedRole<C, M, R> {
        fluent_builders::GetAssociatedRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBulkDeploymentStatus` operation.
    ///
    /// See [`GetBulkDeploymentStatus`](crate::client::fluent_builders::GetBulkDeploymentStatus) for more information about the
    /// operation and its arguments.
    pub fn get_bulk_deployment_status(&self) -> fluent_builders::GetBulkDeploymentStatus<C, M, R> {
        fluent_builders::GetBulkDeploymentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnectivityInfo` operation.
    ///
    /// See [`GetConnectivityInfo`](crate::client::fluent_builders::GetConnectivityInfo) for more information about the
    /// operation and its arguments.
    pub fn get_connectivity_info(&self) -> fluent_builders::GetConnectivityInfo<C, M, R> {
        fluent_builders::GetConnectivityInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnectorDefinition` operation.
    ///
    /// See [`GetConnectorDefinition`](crate::client::fluent_builders::GetConnectorDefinition) for more information about the
    /// operation and its arguments.
    pub fn get_connector_definition(&self) -> fluent_builders::GetConnectorDefinition<C, M, R> {
        fluent_builders::GetConnectorDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnectorDefinitionVersion` operation.
    ///
    /// See [`GetConnectorDefinitionVersion`](crate::client::fluent_builders::GetConnectorDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn get_connector_definition_version(
        &self,
    ) -> fluent_builders::GetConnectorDefinitionVersion<C, M, R> {
        fluent_builders::GetConnectorDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCoreDefinition` operation.
    ///
    /// See [`GetCoreDefinition`](crate::client::fluent_builders::GetCoreDefinition) for more information about the
    /// operation and its arguments.
    pub fn get_core_definition(&self) -> fluent_builders::GetCoreDefinition<C, M, R> {
        fluent_builders::GetCoreDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCoreDefinitionVersion` operation.
    ///
    /// See [`GetCoreDefinitionVersion`](crate::client::fluent_builders::GetCoreDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn get_core_definition_version(
        &self,
    ) -> fluent_builders::GetCoreDefinitionVersion<C, M, R> {
        fluent_builders::GetCoreDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeploymentStatus` operation.
    ///
    /// See [`GetDeploymentStatus`](crate::client::fluent_builders::GetDeploymentStatus) for more information about the
    /// operation and its arguments.
    pub fn get_deployment_status(&self) -> fluent_builders::GetDeploymentStatus<C, M, R> {
        fluent_builders::GetDeploymentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeviceDefinition` operation.
    ///
    /// See [`GetDeviceDefinition`](crate::client::fluent_builders::GetDeviceDefinition) for more information about the
    /// operation and its arguments.
    pub fn get_device_definition(&self) -> fluent_builders::GetDeviceDefinition<C, M, R> {
        fluent_builders::GetDeviceDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeviceDefinitionVersion` operation.
    ///
    /// See [`GetDeviceDefinitionVersion`](crate::client::fluent_builders::GetDeviceDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn get_device_definition_version(
        &self,
    ) -> fluent_builders::GetDeviceDefinitionVersion<C, M, R> {
        fluent_builders::GetDeviceDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFunctionDefinition` operation.
    ///
    /// See [`GetFunctionDefinition`](crate::client::fluent_builders::GetFunctionDefinition) for more information about the
    /// operation and its arguments.
    pub fn get_function_definition(&self) -> fluent_builders::GetFunctionDefinition<C, M, R> {
        fluent_builders::GetFunctionDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFunctionDefinitionVersion` operation.
    ///
    /// See [`GetFunctionDefinitionVersion`](crate::client::fluent_builders::GetFunctionDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn get_function_definition_version(
        &self,
    ) -> fluent_builders::GetFunctionDefinitionVersion<C, M, R> {
        fluent_builders::GetFunctionDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroup` operation.
    ///
    /// See [`GetGroup`](crate::client::fluent_builders::GetGroup) for more information about the
    /// operation and its arguments.
    pub fn get_group(&self) -> fluent_builders::GetGroup<C, M, R> {
        fluent_builders::GetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroupCertificateAuthority` operation.
    ///
    /// See [`GetGroupCertificateAuthority`](crate::client::fluent_builders::GetGroupCertificateAuthority) for more information about the
    /// operation and its arguments.
    pub fn get_group_certificate_authority(
        &self,
    ) -> fluent_builders::GetGroupCertificateAuthority<C, M, R> {
        fluent_builders::GetGroupCertificateAuthority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroupCertificateConfiguration` operation.
    ///
    /// See [`GetGroupCertificateConfiguration`](crate::client::fluent_builders::GetGroupCertificateConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_group_certificate_configuration(
        &self,
    ) -> fluent_builders::GetGroupCertificateConfiguration<C, M, R> {
        fluent_builders::GetGroupCertificateConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroupVersion` operation.
    ///
    /// See [`GetGroupVersion`](crate::client::fluent_builders::GetGroupVersion) for more information about the
    /// operation and its arguments.
    pub fn get_group_version(&self) -> fluent_builders::GetGroupVersion<C, M, R> {
        fluent_builders::GetGroupVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLoggerDefinition` operation.
    ///
    /// See [`GetLoggerDefinition`](crate::client::fluent_builders::GetLoggerDefinition) for more information about the
    /// operation and its arguments.
    pub fn get_logger_definition(&self) -> fluent_builders::GetLoggerDefinition<C, M, R> {
        fluent_builders::GetLoggerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLoggerDefinitionVersion` operation.
    ///
    /// See [`GetLoggerDefinitionVersion`](crate::client::fluent_builders::GetLoggerDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn get_logger_definition_version(
        &self,
    ) -> fluent_builders::GetLoggerDefinitionVersion<C, M, R> {
        fluent_builders::GetLoggerDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceDefinition` operation.
    ///
    /// See [`GetResourceDefinition`](crate::client::fluent_builders::GetResourceDefinition) for more information about the
    /// operation and its arguments.
    pub fn get_resource_definition(&self) -> fluent_builders::GetResourceDefinition<C, M, R> {
        fluent_builders::GetResourceDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceDefinitionVersion` operation.
    ///
    /// See [`GetResourceDefinitionVersion`](crate::client::fluent_builders::GetResourceDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn get_resource_definition_version(
        &self,
    ) -> fluent_builders::GetResourceDefinitionVersion<C, M, R> {
        fluent_builders::GetResourceDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceRoleForAccount` operation.
    ///
    /// See [`GetServiceRoleForAccount`](crate::client::fluent_builders::GetServiceRoleForAccount) for more information about the
    /// operation and its arguments.
    pub fn get_service_role_for_account(
        &self,
    ) -> fluent_builders::GetServiceRoleForAccount<C, M, R> {
        fluent_builders::GetServiceRoleForAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSubscriptionDefinition` operation.
    ///
    /// See [`GetSubscriptionDefinition`](crate::client::fluent_builders::GetSubscriptionDefinition) for more information about the
    /// operation and its arguments.
    pub fn get_subscription_definition(
        &self,
    ) -> fluent_builders::GetSubscriptionDefinition<C, M, R> {
        fluent_builders::GetSubscriptionDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSubscriptionDefinitionVersion` operation.
    ///
    /// See [`GetSubscriptionDefinitionVersion`](crate::client::fluent_builders::GetSubscriptionDefinitionVersion) for more information about the
    /// operation and its arguments.
    pub fn get_subscription_definition_version(
        &self,
    ) -> fluent_builders::GetSubscriptionDefinitionVersion<C, M, R> {
        fluent_builders::GetSubscriptionDefinitionVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetThingRuntimeConfiguration` operation.
    ///
    /// See [`GetThingRuntimeConfiguration`](crate::client::fluent_builders::GetThingRuntimeConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_thing_runtime_configuration(
        &self,
    ) -> fluent_builders::GetThingRuntimeConfiguration<C, M, R> {
        fluent_builders::GetThingRuntimeConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBulkDeploymentDetailedReports` operation.
    ///
    /// See [`ListBulkDeploymentDetailedReports`](crate::client::fluent_builders::ListBulkDeploymentDetailedReports) for more information about the
    /// operation and its arguments.
    pub fn list_bulk_deployment_detailed_reports(
        &self,
    ) -> fluent_builders::ListBulkDeploymentDetailedReports<C, M, R> {
        fluent_builders::ListBulkDeploymentDetailedReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBulkDeployments` operation.
    ///
    /// See [`ListBulkDeployments`](crate::client::fluent_builders::ListBulkDeployments) for more information about the
    /// operation and its arguments.
    pub fn list_bulk_deployments(&self) -> fluent_builders::ListBulkDeployments<C, M, R> {
        fluent_builders::ListBulkDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConnectorDefinitions` operation.
    ///
    /// See [`ListConnectorDefinitions`](crate::client::fluent_builders::ListConnectorDefinitions) for more information about the
    /// operation and its arguments.
    pub fn list_connector_definitions(&self) -> fluent_builders::ListConnectorDefinitions<C, M, R> {
        fluent_builders::ListConnectorDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConnectorDefinitionVersions` operation.
    ///
    /// See [`ListConnectorDefinitionVersions`](crate::client::fluent_builders::ListConnectorDefinitionVersions) for more information about the
    /// operation and its arguments.
    pub fn list_connector_definition_versions(
        &self,
    ) -> fluent_builders::ListConnectorDefinitionVersions<C, M, R> {
        fluent_builders::ListConnectorDefinitionVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCoreDefinitions` operation.
    ///
    /// See [`ListCoreDefinitions`](crate::client::fluent_builders::ListCoreDefinitions) for more information about the
    /// operation and its arguments.
    pub fn list_core_definitions(&self) -> fluent_builders::ListCoreDefinitions<C, M, R> {
        fluent_builders::ListCoreDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCoreDefinitionVersions` operation.
    ///
    /// See [`ListCoreDefinitionVersions`](crate::client::fluent_builders::ListCoreDefinitionVersions) for more information about the
    /// operation and its arguments.
    pub fn list_core_definition_versions(
        &self,
    ) -> fluent_builders::ListCoreDefinitionVersions<C, M, R> {
        fluent_builders::ListCoreDefinitionVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeployments` operation.
    ///
    /// See [`ListDeployments`](crate::client::fluent_builders::ListDeployments) for more information about the
    /// operation and its arguments.
    pub fn list_deployments(&self) -> fluent_builders::ListDeployments<C, M, R> {
        fluent_builders::ListDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeviceDefinitions` operation.
    ///
    /// See [`ListDeviceDefinitions`](crate::client::fluent_builders::ListDeviceDefinitions) for more information about the
    /// operation and its arguments.
    pub fn list_device_definitions(&self) -> fluent_builders::ListDeviceDefinitions<C, M, R> {
        fluent_builders::ListDeviceDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeviceDefinitionVersions` operation.
    ///
    /// See [`ListDeviceDefinitionVersions`](crate::client::fluent_builders::ListDeviceDefinitionVersions) for more information about the
    /// operation and its arguments.
    pub fn list_device_definition_versions(
        &self,
    ) -> fluent_builders::ListDeviceDefinitionVersions<C, M, R> {
        fluent_builders::ListDeviceDefinitionVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFunctionDefinitions` operation.
    ///
    /// See [`ListFunctionDefinitions`](crate::client::fluent_builders::ListFunctionDefinitions) for more information about the
    /// operation and its arguments.
    pub fn list_function_definitions(&self) -> fluent_builders::ListFunctionDefinitions<C, M, R> {
        fluent_builders::ListFunctionDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFunctionDefinitionVersions` operation.
    ///
    /// See [`ListFunctionDefinitionVersions`](crate::client::fluent_builders::ListFunctionDefinitionVersions) for more information about the
    /// operation and its arguments.
    pub fn list_function_definition_versions(
        &self,
    ) -> fluent_builders::ListFunctionDefinitionVersions<C, M, R> {
        fluent_builders::ListFunctionDefinitionVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroupCertificateAuthorities` operation.
    ///
    /// See [`ListGroupCertificateAuthorities`](crate::client::fluent_builders::ListGroupCertificateAuthorities) for more information about the
    /// operation and its arguments.
    pub fn list_group_certificate_authorities(
        &self,
    ) -> fluent_builders::ListGroupCertificateAuthorities<C, M, R> {
        fluent_builders::ListGroupCertificateAuthorities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroups` operation.
    ///
    /// See [`ListGroups`](crate::client::fluent_builders::ListGroups) for more information about the
    /// operation and its arguments.
    pub fn list_groups(&self) -> fluent_builders::ListGroups<C, M, R> {
        fluent_builders::ListGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroupVersions` operation.
    ///
    /// See [`ListGroupVersions`](crate::client::fluent_builders::ListGroupVersions) for more information about the
    /// operation and its arguments.
    pub fn list_group_versions(&self) -> fluent_builders::ListGroupVersions<C, M, R> {
        fluent_builders::ListGroupVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLoggerDefinitions` operation.
    ///
    /// See [`ListLoggerDefinitions`](crate::client::fluent_builders::ListLoggerDefinitions) for more information about the
    /// operation and its arguments.
    pub fn list_logger_definitions(&self) -> fluent_builders::ListLoggerDefinitions<C, M, R> {
        fluent_builders::ListLoggerDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLoggerDefinitionVersions` operation.
    ///
    /// See [`ListLoggerDefinitionVersions`](crate::client::fluent_builders::ListLoggerDefinitionVersions) for more information about the
    /// operation and its arguments.
    pub fn list_logger_definition_versions(
        &self,
    ) -> fluent_builders::ListLoggerDefinitionVersions<C, M, R> {
        fluent_builders::ListLoggerDefinitionVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourceDefinitions` operation.
    ///
    /// See [`ListResourceDefinitions`](crate::client::fluent_builders::ListResourceDefinitions) for more information about the
    /// operation and its arguments.
    pub fn list_resource_definitions(&self) -> fluent_builders::ListResourceDefinitions<C, M, R> {
        fluent_builders::ListResourceDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourceDefinitionVersions` operation.
    ///
    /// See [`ListResourceDefinitionVersions`](crate::client::fluent_builders::ListResourceDefinitionVersions) for more information about the
    /// operation and its arguments.
    pub fn list_resource_definition_versions(
        &self,
    ) -> fluent_builders::ListResourceDefinitionVersions<C, M, R> {
        fluent_builders::ListResourceDefinitionVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSubscriptionDefinitions` operation.
    ///
    /// See [`ListSubscriptionDefinitions`](crate::client::fluent_builders::ListSubscriptionDefinitions) for more information about the
    /// operation and its arguments.
    pub fn list_subscription_definitions(
        &self,
    ) -> fluent_builders::ListSubscriptionDefinitions<C, M, R> {
        fluent_builders::ListSubscriptionDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSubscriptionDefinitionVersions` operation.
    ///
    /// See [`ListSubscriptionDefinitionVersions`](crate::client::fluent_builders::ListSubscriptionDefinitionVersions) for more information about the
    /// operation and its arguments.
    pub fn list_subscription_definition_versions(
        &self,
    ) -> fluent_builders::ListSubscriptionDefinitionVersions<C, M, R> {
        fluent_builders::ListSubscriptionDefinitionVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetDeployments` operation.
    ///
    /// See [`ResetDeployments`](crate::client::fluent_builders::ResetDeployments) for more information about the
    /// operation and its arguments.
    pub fn reset_deployments(&self) -> fluent_builders::ResetDeployments<C, M, R> {
        fluent_builders::ResetDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartBulkDeployment` operation.
    ///
    /// See [`StartBulkDeployment`](crate::client::fluent_builders::StartBulkDeployment) for more information about the
    /// operation and its arguments.
    pub fn start_bulk_deployment(&self) -> fluent_builders::StartBulkDeployment<C, M, R> {
        fluent_builders::StartBulkDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopBulkDeployment` operation.
    ///
    /// See [`StopBulkDeployment`](crate::client::fluent_builders::StopBulkDeployment) for more information about the
    /// operation and its arguments.
    pub fn stop_bulk_deployment(&self) -> fluent_builders::StopBulkDeployment<C, M, R> {
        fluent_builders::StopBulkDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConnectivityInfo` operation.
    ///
    /// See [`UpdateConnectivityInfo`](crate::client::fluent_builders::UpdateConnectivityInfo) for more information about the
    /// operation and its arguments.
    pub fn update_connectivity_info(&self) -> fluent_builders::UpdateConnectivityInfo<C, M, R> {
        fluent_builders::UpdateConnectivityInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConnectorDefinition` operation.
    ///
    /// See [`UpdateConnectorDefinition`](crate::client::fluent_builders::UpdateConnectorDefinition) for more information about the
    /// operation and its arguments.
    pub fn update_connector_definition(
        &self,
    ) -> fluent_builders::UpdateConnectorDefinition<C, M, R> {
        fluent_builders::UpdateConnectorDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCoreDefinition` operation.
    ///
    /// See [`UpdateCoreDefinition`](crate::client::fluent_builders::UpdateCoreDefinition) for more information about the
    /// operation and its arguments.
    pub fn update_core_definition(&self) -> fluent_builders::UpdateCoreDefinition<C, M, R> {
        fluent_builders::UpdateCoreDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDeviceDefinition` operation.
    ///
    /// See [`UpdateDeviceDefinition`](crate::client::fluent_builders::UpdateDeviceDefinition) for more information about the
    /// operation and its arguments.
    pub fn update_device_definition(&self) -> fluent_builders::UpdateDeviceDefinition<C, M, R> {
        fluent_builders::UpdateDeviceDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFunctionDefinition` operation.
    ///
    /// See [`UpdateFunctionDefinition`](crate::client::fluent_builders::UpdateFunctionDefinition) for more information about the
    /// operation and its arguments.
    pub fn update_function_definition(&self) -> fluent_builders::UpdateFunctionDefinition<C, M, R> {
        fluent_builders::UpdateFunctionDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGroup` operation.
    ///
    /// See [`UpdateGroup`](crate::client::fluent_builders::UpdateGroup) for more information about the
    /// operation and its arguments.
    pub fn update_group(&self) -> fluent_builders::UpdateGroup<C, M, R> {
        fluent_builders::UpdateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGroupCertificateConfiguration` operation.
    ///
    /// See [`UpdateGroupCertificateConfiguration`](crate::client::fluent_builders::UpdateGroupCertificateConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_group_certificate_configuration(
        &self,
    ) -> fluent_builders::UpdateGroupCertificateConfiguration<C, M, R> {
        fluent_builders::UpdateGroupCertificateConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLoggerDefinition` operation.
    ///
    /// See [`UpdateLoggerDefinition`](crate::client::fluent_builders::UpdateLoggerDefinition) for more information about the
    /// operation and its arguments.
    pub fn update_logger_definition(&self) -> fluent_builders::UpdateLoggerDefinition<C, M, R> {
        fluent_builders::UpdateLoggerDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResourceDefinition` operation.
    ///
    /// See [`UpdateResourceDefinition`](crate::client::fluent_builders::UpdateResourceDefinition) for more information about the
    /// operation and its arguments.
    pub fn update_resource_definition(&self) -> fluent_builders::UpdateResourceDefinition<C, M, R> {
        fluent_builders::UpdateResourceDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSubscriptionDefinition` operation.
    ///
    /// See [`UpdateSubscriptionDefinition`](crate::client::fluent_builders::UpdateSubscriptionDefinition) for more information about the
    /// operation and its arguments.
    pub fn update_subscription_definition(
        &self,
    ) -> fluent_builders::UpdateSubscriptionDefinition<C, M, R> {
        fluent_builders::UpdateSubscriptionDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateThingRuntimeConfiguration` operation.
    ///
    /// See [`UpdateThingRuntimeConfiguration`](crate::client::fluent_builders::UpdateThingRuntimeConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_thing_runtime_configuration(
        &self,
    ) -> fluent_builders::UpdateThingRuntimeConfiguration<C, M, R> {
        fluent_builders::UpdateThingRuntimeConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateRoleToGroup`.
    ///
    /// Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's permissions should allow Greengrass core Lambda functions to perform actions against the cloud.
    #[derive(std::fmt::Debug)]
    pub struct AssociateRoleToGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_role_to_group_input::Builder,
    }
    impl<C, M, R> AssociateRoleToGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateRoleToGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateRoleToGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateRoleToGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateRoleToGroupInputOperationOutputAlias,
                crate::output::AssociateRoleToGroupOutput,
                crate::error::AssociateRoleToGroupError,
                crate::input::AssociateRoleToGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// The ARN of the role you wish to associate with this group. The existence of the role is not validated.
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// The ARN of the role you wish to associate with this group. The existence of the role is not validated.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateServiceRoleToAccount`.
    ///
    /// Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in the policy ''AWSGreengrassResourceAccessRolePolicy''.
    #[derive(std::fmt::Debug)]
    pub struct AssociateServiceRoleToAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_service_role_to_account_input::Builder,
    }
    impl<C, M, R> AssociateServiceRoleToAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateServiceRoleToAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateServiceRoleToAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateServiceRoleToAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateServiceRoleToAccountInputOperationOutputAlias,
                crate::output::AssociateServiceRoleToAccountOutput,
                crate::error::AssociateServiceRoleToAccountError,
                crate::input::AssociateServiceRoleToAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the service role you wish to associate with your account.
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// The ARN of the service role you wish to associate with your account.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnectorDefinition`.
    ///
    /// Creates a connector definition. You may provide the initial version of the connector definition now or use ''CreateConnectorDefinitionVersion'' at a later time.
    #[derive(std::fmt::Debug)]
    pub struct CreateConnectorDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connector_definition_input::Builder,
    }
    impl<C, M, R> CreateConnectorDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnectorDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectorDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectorDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectorDefinitionInputOperationOutputAlias,
                crate::output::CreateConnectorDefinitionOutput,
                crate::error::CreateConnectorDefinitionError,
                crate::input::CreateConnectorDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// Information about the initial version of the connector definition.
        pub fn initial_version(mut self, inp: crate::model::ConnectorDefinitionVersion) -> Self {
            self.inner = self.inner.initial_version(inp);
            self
        }
        /// Information about the initial version of the connector definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::ConnectorDefinitionVersion>,
        ) -> Self {
            self.inner = self.inner.set_initial_version(input);
            self
        }
        /// The name of the connector definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the connector definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnectorDefinitionVersion`.
    ///
    /// Creates a version of a connector definition which has already been defined.
    #[derive(std::fmt::Debug)]
    pub struct CreateConnectorDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connector_definition_version_input::Builder,
    }
    impl<C, M, R> CreateConnectorDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnectorDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectorDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectorDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectorDefinitionVersionInputOperationOutputAlias,
                crate::output::CreateConnectorDefinitionVersionOutput,
                crate::error::CreateConnectorDefinitionVersionError,
                crate::input::CreateConnectorDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_definition_id(inp);
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_definition_id(input);
            self
        }
        /// Appends an item to `Connectors`.
        ///
        /// To override the contents of this collection use [`set_connectors`](Self::set_connectors).
        ///
        /// A list of references to connectors in this version, with their corresponding configuration settings.
        pub fn connectors(mut self, inp: impl Into<crate::model::Connector>) -> Self {
            self.inner = self.inner.connectors(inp);
            self
        }
        /// A list of references to connectors in this version, with their corresponding configuration settings.
        pub fn set_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connector>>,
        ) -> Self {
            self.inner = self.inner.set_connectors(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCoreDefinition`.
    ///
    /// Creates a core definition. You may provide the initial version of the core definition now or use ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.
    #[derive(std::fmt::Debug)]
    pub struct CreateCoreDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_core_definition_input::Builder,
    }
    impl<C, M, R> CreateCoreDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCoreDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCoreDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCoreDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCoreDefinitionInputOperationOutputAlias,
                crate::output::CreateCoreDefinitionOutput,
                crate::error::CreateCoreDefinitionError,
                crate::input::CreateCoreDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// Information about the initial version of the core definition.
        pub fn initial_version(mut self, inp: crate::model::CoreDefinitionVersion) -> Self {
            self.inner = self.inner.initial_version(inp);
            self
        }
        /// Information about the initial version of the core definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::CoreDefinitionVersion>,
        ) -> Self {
            self.inner = self.inner.set_initial_version(input);
            self
        }
        /// The name of the core definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the core definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCoreDefinitionVersion`.
    ///
    /// Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly one Greengrass core.
    #[derive(std::fmt::Debug)]
    pub struct CreateCoreDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_core_definition_version_input::Builder,
    }
    impl<C, M, R> CreateCoreDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCoreDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCoreDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCoreDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCoreDefinitionVersionInputOperationOutputAlias,
                crate::output::CreateCoreDefinitionVersionOutput,
                crate::error::CreateCoreDefinitionVersionError,
                crate::input::CreateCoreDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_definition_id(inp);
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_definition_id(input);
            self
        }
        /// Appends an item to `Cores`.
        ///
        /// To override the contents of this collection use [`set_cores`](Self::set_cores).
        ///
        /// A list of cores in the core definition version.
        pub fn cores(mut self, inp: impl Into<crate::model::Core>) -> Self {
            self.inner = self.inner.cores(inp);
            self
        }
        /// A list of cores in the core definition version.
        pub fn set_cores(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Core>>,
        ) -> Self {
            self.inner = self.inner.set_cores(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeployment`.
    ///
    /// Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token'' token and the request parameters.
    #[derive(std::fmt::Debug)]
    pub struct CreateDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_deployment_input::Builder,
    }
    impl<C, M, R> CreateDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeploymentInputOperationOutputAlias,
                crate::output::CreateDeploymentOutput,
                crate::error::CreateDeploymentError,
                crate::input::CreateDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The ID of the deployment if you wish to redeploy a previous deployment.
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// The ID of the deployment if you wish to redeploy a previous deployment.
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// The type of deployment. When used for ''CreateDeployment'', only ''NewDeployment'' and ''Redeployment'' are valid.
        pub fn deployment_type(mut self, inp: crate::model::DeploymentType) -> Self {
            self.inner = self.inner.deployment_type(inp);
            self
        }
        /// The type of deployment. When used for ''CreateDeployment'', only ''NewDeployment'' and ''Redeployment'' are valid.
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentType>,
        ) -> Self {
            self.inner = self.inner.set_deployment_type(input);
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// The ID of the group version to be deployed.
        pub fn group_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_version_id(inp);
            self
        }
        /// The ID of the group version to be deployed.
        pub fn set_group_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_group_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeviceDefinition`.
    ///
    /// Creates a device definition. You may provide the initial version of the device definition now or use ''CreateDeviceDefinitionVersion'' at a later time.
    #[derive(std::fmt::Debug)]
    pub struct CreateDeviceDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_device_definition_input::Builder,
    }
    impl<C, M, R> CreateDeviceDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeviceDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeviceDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeviceDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeviceDefinitionInputOperationOutputAlias,
                crate::output::CreateDeviceDefinitionOutput,
                crate::error::CreateDeviceDefinitionError,
                crate::input::CreateDeviceDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// Information about the initial version of the device definition.
        pub fn initial_version(mut self, inp: crate::model::DeviceDefinitionVersion) -> Self {
            self.inner = self.inner.initial_version(inp);
            self
        }
        /// Information about the initial version of the device definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::DeviceDefinitionVersion>,
        ) -> Self {
            self.inner = self.inner.set_initial_version(input);
            self
        }
        /// The name of the device definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the device definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeviceDefinitionVersion`.
    ///
    /// Creates a version of a device definition that has already been defined.
    #[derive(std::fmt::Debug)]
    pub struct CreateDeviceDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_device_definition_version_input::Builder,
    }
    impl<C, M, R> CreateDeviceDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeviceDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeviceDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeviceDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeviceDefinitionVersionInputOperationOutputAlias,
                crate::output::CreateDeviceDefinitionVersionOutput,
                crate::error::CreateDeviceDefinitionVersionError,
                crate::input::CreateDeviceDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_definition_id(inp);
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_definition_id(input);
            self
        }
        /// Appends an item to `Devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// A list of devices in the definition version.
        pub fn devices(mut self, inp: impl Into<crate::model::Device>) -> Self {
            self.inner = self.inner.devices(inp);
            self
        }
        /// A list of devices in the definition version.
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Device>>,
        ) -> Self {
            self.inner = self.inner.set_devices(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFunctionDefinition`.
    ///
    /// Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be used in a group. You can create an initial version of the definition by providing a list of Lambda functions and their configurations now, or use ''CreateFunctionDefinitionVersion'' later.
    #[derive(std::fmt::Debug)]
    pub struct CreateFunctionDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_function_definition_input::Builder,
    }
    impl<C, M, R> CreateFunctionDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFunctionDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFunctionDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFunctionDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFunctionDefinitionInputOperationOutputAlias,
                crate::output::CreateFunctionDefinitionOutput,
                crate::error::CreateFunctionDefinitionError,
                crate::input::CreateFunctionDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// Information about the initial version of the function definition.
        pub fn initial_version(mut self, inp: crate::model::FunctionDefinitionVersion) -> Self {
            self.inner = self.inner.initial_version(inp);
            self
        }
        /// Information about the initial version of the function definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::FunctionDefinitionVersion>,
        ) -> Self {
            self.inner = self.inner.set_initial_version(input);
            self
        }
        /// The name of the function definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the function definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFunctionDefinitionVersion`.
    ///
    /// Creates a version of a Lambda function definition that has already been defined.
    #[derive(std::fmt::Debug)]
    pub struct CreateFunctionDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_function_definition_version_input::Builder,
    }
    impl<C, M, R> CreateFunctionDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFunctionDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFunctionDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFunctionDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFunctionDefinitionVersionInputOperationOutputAlias,
                crate::output::CreateFunctionDefinitionVersionOutput,
                crate::error::CreateFunctionDefinitionVersionError,
                crate::input::CreateFunctionDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The default configuration that applies to all Lambda functions in this function definition version. Individual Lambda functions can override these settings.
        pub fn default_config(mut self, inp: crate::model::FunctionDefaultConfig) -> Self {
            self.inner = self.inner.default_config(inp);
            self
        }
        /// The default configuration that applies to all Lambda functions in this function definition version. Individual Lambda functions can override these settings.
        pub fn set_default_config(
            mut self,
            input: std::option::Option<crate::model::FunctionDefaultConfig>,
        ) -> Self {
            self.inner = self.inner.set_default_config(input);
            self
        }
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_definition_id(inp);
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_definition_id(input);
            self
        }
        /// Appends an item to `Functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// A list of Lambda functions in this function definition version.
        pub fn functions(mut self, inp: impl Into<crate::model::Function>) -> Self {
            self.inner = self.inner.functions(inp);
            self
        }
        /// A list of Lambda functions in this function definition version.
        pub fn set_functions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Function>>,
        ) -> Self {
            self.inner = self.inner.set_functions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time. Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a library or command-line application to create and deploy Greengrass groups.
    #[derive(std::fmt::Debug)]
    pub struct CreateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_input::Builder,
    }
    impl<C, M, R> CreateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupInputOperationOutputAlias,
                crate::output::CreateGroupOutput,
                crate::error::CreateGroupError,
                crate::input::CreateGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// Information about the initial version of the group.
        pub fn initial_version(mut self, inp: crate::model::GroupVersion) -> Self {
            self.inner = self.inner.initial_version(inp);
            self
        }
        /// Information about the initial version of the group.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::GroupVersion>,
        ) -> Self {
            self.inner = self.inner.set_initial_version(input);
            self
        }
        /// The name of the group.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the group.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroupCertificateAuthority`.
    ///
    /// Creates a CA for the group. If a CA already exists, it will rotate the existing CA.
    #[derive(std::fmt::Debug)]
    pub struct CreateGroupCertificateAuthority<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_certificate_authority_input::Builder,
    }
    impl<C, M, R> CreateGroupCertificateAuthority<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroupCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupCertificateAuthorityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupCertificateAuthorityInputOperationOutputAlias,
                crate::output::CreateGroupCertificateAuthorityOutput,
                crate::error::CreateGroupCertificateAuthorityError,
                crate::input::CreateGroupCertificateAuthorityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroupVersion`.
    ///
    /// Creates a version of a group which has already been defined.
    #[derive(std::fmt::Debug)]
    pub struct CreateGroupVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_version_input::Builder,
    }
    impl<C, M, R> CreateGroupVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroupVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupVersionInputOperationOutputAlias,
                crate::output::CreateGroupVersionOutput,
                crate::error::CreateGroupVersionError,
                crate::input::CreateGroupVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The ARN of the connector definition version for this group.
        pub fn connector_definition_version_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.connector_definition_version_arn(inp);
            self
        }
        /// The ARN of the connector definition version for this group.
        pub fn set_connector_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_definition_version_arn(input);
            self
        }
        /// The ARN of the core definition version for this group.
        pub fn core_definition_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_definition_version_arn(inp);
            self
        }
        /// The ARN of the core definition version for this group.
        pub fn set_core_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_definition_version_arn(input);
            self
        }
        /// The ARN of the device definition version for this group.
        pub fn device_definition_version_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.device_definition_version_arn(inp);
            self
        }
        /// The ARN of the device definition version for this group.
        pub fn set_device_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_definition_version_arn(input);
            self
        }
        /// The ARN of the function definition version for this group.
        pub fn function_definition_version_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.function_definition_version_arn(inp);
            self
        }
        /// The ARN of the function definition version for this group.
        pub fn set_function_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_definition_version_arn(input);
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// The ARN of the logger definition version for this group.
        pub fn logger_definition_version_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.logger_definition_version_arn(inp);
            self
        }
        /// The ARN of the logger definition version for this group.
        pub fn set_logger_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logger_definition_version_arn(input);
            self
        }
        /// The ARN of the resource definition version for this group.
        pub fn resource_definition_version_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_definition_version_arn(inp);
            self
        }
        /// The ARN of the resource definition version for this group.
        pub fn set_resource_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_definition_version_arn(input);
            self
        }
        /// The ARN of the subscription definition version for this group.
        pub fn subscription_definition_version_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.subscription_definition_version_arn(inp);
            self
        }
        /// The ARN of the subscription definition version for this group.
        pub fn set_subscription_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_definition_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLoggerDefinition`.
    ///
    /// Creates a logger definition. You may provide the initial version of the logger definition now or use ''CreateLoggerDefinitionVersion'' at a later time.
    #[derive(std::fmt::Debug)]
    pub struct CreateLoggerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_logger_definition_input::Builder,
    }
    impl<C, M, R> CreateLoggerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLoggerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLoggerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLoggerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLoggerDefinitionInputOperationOutputAlias,
                crate::output::CreateLoggerDefinitionOutput,
                crate::error::CreateLoggerDefinitionError,
                crate::input::CreateLoggerDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// Information about the initial version of the logger definition.
        pub fn initial_version(mut self, inp: crate::model::LoggerDefinitionVersion) -> Self {
            self.inner = self.inner.initial_version(inp);
            self
        }
        /// Information about the initial version of the logger definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::LoggerDefinitionVersion>,
        ) -> Self {
            self.inner = self.inner.set_initial_version(input);
            self
        }
        /// The name of the logger definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the logger definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLoggerDefinitionVersion`.
    ///
    /// Creates a version of a logger definition that has already been defined.
    #[derive(std::fmt::Debug)]
    pub struct CreateLoggerDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_logger_definition_version_input::Builder,
    }
    impl<C, M, R> CreateLoggerDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLoggerDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLoggerDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLoggerDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLoggerDefinitionVersionInputOperationOutputAlias,
                crate::output::CreateLoggerDefinitionVersionOutput,
                crate::error::CreateLoggerDefinitionVersionError,
                crate::input::CreateLoggerDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logger_definition_id(inp);
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logger_definition_id(input);
            self
        }
        /// Appends an item to `Loggers`.
        ///
        /// To override the contents of this collection use [`set_loggers`](Self::set_loggers).
        ///
        /// A list of loggers.
        pub fn loggers(mut self, inp: impl Into<crate::model::Logger>) -> Self {
            self.inner = self.inner.loggers(inp);
            self
        }
        /// A list of loggers.
        pub fn set_loggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Logger>>,
        ) -> Self {
            self.inner = self.inner.set_loggers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceDefinition`.
    ///
    /// Creates a resource definition which contains a list of resources to be used in a group. You can create an initial version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.
    #[derive(std::fmt::Debug)]
    pub struct CreateResourceDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_definition_input::Builder,
    }
    impl<C, M, R> CreateResourceDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResourceDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceDefinitionInputOperationOutputAlias,
                crate::output::CreateResourceDefinitionOutput,
                crate::error::CreateResourceDefinitionError,
                crate::input::CreateResourceDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// Information about the initial version of the resource definition.
        pub fn initial_version(mut self, inp: crate::model::ResourceDefinitionVersion) -> Self {
            self.inner = self.inner.initial_version(inp);
            self
        }
        /// Information about the initial version of the resource definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::ResourceDefinitionVersion>,
        ) -> Self {
            self.inner = self.inner.set_initial_version(input);
            self
        }
        /// The name of the resource definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the resource definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceDefinitionVersion`.
    ///
    /// Creates a version of a resource definition that has already been defined.
    #[derive(std::fmt::Debug)]
    pub struct CreateResourceDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_definition_version_input::Builder,
    }
    impl<C, M, R> CreateResourceDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResourceDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceDefinitionVersionInputOperationOutputAlias,
                crate::output::CreateResourceDefinitionVersionOutput,
                crate::error::CreateResourceDefinitionVersionError,
                crate::input::CreateResourceDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_definition_id(inp);
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_definition_id(input);
            self
        }
        /// Appends an item to `Resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// A list of resources.
        pub fn resources(mut self, inp: impl Into<crate::model::Resource>) -> Self {
            self.inner = self.inner.resources(inp);
            self
        }
        /// A list of resources.
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSoftwareUpdateJob`.
    ///
    /// Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional commands to manage a Greengrass core software update job.
    #[derive(std::fmt::Debug)]
    pub struct CreateSoftwareUpdateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_software_update_job_input::Builder,
    }
    impl<C, M, R> CreateSoftwareUpdateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSoftwareUpdateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSoftwareUpdateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSoftwareUpdateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSoftwareUpdateJobInputOperationOutputAlias,
                crate::output::CreateSoftwareUpdateJobOutput,
                crate::error::CreateSoftwareUpdateJobError,
                crate::input::CreateSoftwareUpdateJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The IAM Role that Greengrass will use to create pre-signed URLs pointing towards the update artifact.
        pub fn s3_url_signer_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_url_signer_role(inp);
            self
        }
        /// The IAM Role that Greengrass will use to create pre-signed URLs pointing towards the update artifact.
        pub fn set_s3_url_signer_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_url_signer_role(input);
            self
        }
        /// The piece of software on the Greengrass core that will be updated.
        pub fn software_to_update(mut self, inp: crate::model::SoftwareToUpdate) -> Self {
            self.inner = self.inner.software_to_update(inp);
            self
        }
        /// The piece of software on the Greengrass core that will be updated.
        pub fn set_software_to_update(
            mut self,
            input: std::option::Option<crate::model::SoftwareToUpdate>,
        ) -> Self {
            self.inner = self.inner.set_software_to_update(input);
            self
        }
        /// The minimum level of log statements that should be logged by the OTA Agent during an update.
        pub fn update_agent_log_level(mut self, inp: crate::model::UpdateAgentLogLevel) -> Self {
            self.inner = self.inner.update_agent_log_level(inp);
            self
        }
        /// The minimum level of log statements that should be logged by the OTA Agent during an update.
        pub fn set_update_agent_log_level(
            mut self,
            input: std::option::Option<crate::model::UpdateAgentLogLevel>,
        ) -> Self {
            self.inner = self.inner.set_update_agent_log_level(input);
            self
        }
        /// Appends an item to `UpdateTargets`.
        ///
        /// To override the contents of this collection use [`set_update_targets`](Self::set_update_targets).
        ///
        /// The ARNs of the targets (IoT things or IoT thing groups) that this update will be applied to.
        pub fn update_targets(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_targets(inp);
            self
        }
        /// The ARNs of the targets (IoT things or IoT thing groups) that this update will be applied to.
        pub fn set_update_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_update_targets(input);
            self
        }
        /// The architecture of the cores which are the targets of an update.
        pub fn update_targets_architecture(
            mut self,
            inp: crate::model::UpdateTargetsArchitecture,
        ) -> Self {
            self.inner = self.inner.update_targets_architecture(inp);
            self
        }
        /// The architecture of the cores which are the targets of an update.
        pub fn set_update_targets_architecture(
            mut self,
            input: std::option::Option<crate::model::UpdateTargetsArchitecture>,
        ) -> Self {
            self.inner = self.inner.set_update_targets_architecture(input);
            self
        }
        /// The operating system of the cores which are the targets of an update.
        pub fn update_targets_operating_system(
            mut self,
            inp: crate::model::UpdateTargetsOperatingSystem,
        ) -> Self {
            self.inner = self.inner.update_targets_operating_system(inp);
            self
        }
        /// The operating system of the cores which are the targets of an update.
        pub fn set_update_targets_operating_system(
            mut self,
            input: std::option::Option<crate::model::UpdateTargetsOperatingSystem>,
        ) -> Self {
            self.inner = self.inner.set_update_targets_operating_system(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubscriptionDefinition`.
    ///
    /// Creates a subscription definition. You may provide the initial version of the subscription definition now or use ''CreateSubscriptionDefinitionVersion'' at a later time.
    #[derive(std::fmt::Debug)]
    pub struct CreateSubscriptionDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_subscription_definition_input::Builder,
    }
    impl<C, M, R> CreateSubscriptionDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSubscriptionDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubscriptionDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSubscriptionDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSubscriptionDefinitionInputOperationOutputAlias,
                crate::output::CreateSubscriptionDefinitionOutput,
                crate::error::CreateSubscriptionDefinitionError,
                crate::input::CreateSubscriptionDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// Information about the initial version of the subscription definition.
        pub fn initial_version(mut self, inp: crate::model::SubscriptionDefinitionVersion) -> Self {
            self.inner = self.inner.initial_version(inp);
            self
        }
        /// Information about the initial version of the subscription definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::SubscriptionDefinitionVersion>,
        ) -> Self {
            self.inner = self.inner.set_initial_version(input);
            self
        }
        /// The name of the subscription definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the subscription definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSubscriptionDefinitionVersion`.
    ///
    /// Creates a version of a subscription definition which has already been defined.
    #[derive(std::fmt::Debug)]
    pub struct CreateSubscriptionDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_subscription_definition_version_input::Builder,
    }
    impl<C, M, R> CreateSubscriptionDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSubscriptionDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSubscriptionDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateSubscriptionDefinitionVersionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSubscriptionDefinitionVersionInputOperationOutputAlias,
                crate::output::CreateSubscriptionDefinitionVersionOutput,
                crate::error::CreateSubscriptionDefinitionVersionError,
                crate::input::CreateSubscriptionDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_definition_id(inp);
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_definition_id(input);
            self
        }
        /// Appends an item to `Subscriptions`.
        ///
        /// To override the contents of this collection use [`set_subscriptions`](Self::set_subscriptions).
        ///
        /// A list of subscriptions.
        pub fn subscriptions(mut self, inp: impl Into<crate::model::Subscription>) -> Self {
            self.inner = self.inner.subscriptions(inp);
            self
        }
        /// A list of subscriptions.
        pub fn set_subscriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscription>>,
        ) -> Self {
            self.inner = self.inner.set_subscriptions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnectorDefinition`.
    ///
    /// Deletes a connector definition.
    #[derive(std::fmt::Debug)]
    pub struct DeleteConnectorDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connector_definition_input::Builder,
    }
    impl<C, M, R> DeleteConnectorDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnectorDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectorDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectorDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectorDefinitionInputOperationOutputAlias,
                crate::output::DeleteConnectorDefinitionOutput,
                crate::error::DeleteConnectorDefinitionError,
                crate::input::DeleteConnectorDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_definition_id(inp);
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCoreDefinition`.
    ///
    /// Deletes a core definition.
    #[derive(std::fmt::Debug)]
    pub struct DeleteCoreDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_core_definition_input::Builder,
    }
    impl<C, M, R> DeleteCoreDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCoreDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCoreDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCoreDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCoreDefinitionInputOperationOutputAlias,
                crate::output::DeleteCoreDefinitionOutput,
                crate::error::DeleteCoreDefinitionError,
                crate::input::DeleteCoreDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_definition_id(inp);
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeviceDefinition`.
    ///
    /// Deletes a device definition.
    #[derive(std::fmt::Debug)]
    pub struct DeleteDeviceDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_device_definition_input::Builder,
    }
    impl<C, M, R> DeleteDeviceDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeviceDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeviceDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeviceDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeviceDefinitionInputOperationOutputAlias,
                crate::output::DeleteDeviceDefinitionOutput,
                crate::error::DeleteDeviceDefinitionError,
                crate::input::DeleteDeviceDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_definition_id(inp);
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunctionDefinition`.
    ///
    /// Deletes a Lambda function definition.
    #[derive(std::fmt::Debug)]
    pub struct DeleteFunctionDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_function_definition_input::Builder,
    }
    impl<C, M, R> DeleteFunctionDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFunctionDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFunctionDefinitionInputOperationOutputAlias,
                crate::output::DeleteFunctionDefinitionOutput,
                crate::error::DeleteFunctionDefinitionError,
                crate::input::DeleteFunctionDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_definition_id(inp);
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// Deletes a group.
    #[derive(std::fmt::Debug)]
    pub struct DeleteGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl<C, M, R> DeleteGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupInputOperationOutputAlias,
                crate::output::DeleteGroupOutput,
                crate::error::DeleteGroupError,
                crate::input::DeleteGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoggerDefinition`.
    ///
    /// Deletes a logger definition.
    #[derive(std::fmt::Debug)]
    pub struct DeleteLoggerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_logger_definition_input::Builder,
    }
    impl<C, M, R> DeleteLoggerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLoggerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoggerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoggerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLoggerDefinitionInputOperationOutputAlias,
                crate::output::DeleteLoggerDefinitionOutput,
                crate::error::DeleteLoggerDefinitionError,
                crate::input::DeleteLoggerDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logger_definition_id(inp);
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logger_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceDefinition`.
    ///
    /// Deletes a resource definition.
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourceDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_definition_input::Builder,
    }
    impl<C, M, R> DeleteResourceDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourceDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceDefinitionInputOperationOutputAlias,
                crate::output::DeleteResourceDefinitionOutput,
                crate::error::DeleteResourceDefinitionError,
                crate::input::DeleteResourceDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_definition_id(inp);
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSubscriptionDefinition`.
    ///
    /// Deletes a subscription definition.
    #[derive(std::fmt::Debug)]
    pub struct DeleteSubscriptionDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_subscription_definition_input::Builder,
    }
    impl<C, M, R> DeleteSubscriptionDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSubscriptionDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSubscriptionDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSubscriptionDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSubscriptionDefinitionInputOperationOutputAlias,
                crate::output::DeleteSubscriptionDefinitionOutput,
                crate::error::DeleteSubscriptionDefinitionError,
                crate::input::DeleteSubscriptionDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_definition_id(inp);
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateRoleFromGroup`.
    ///
    /// Disassociates the role from a group.
    #[derive(std::fmt::Debug)]
    pub struct DisassociateRoleFromGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_role_from_group_input::Builder,
    }
    impl<C, M, R> DisassociateRoleFromGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateRoleFromGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateRoleFromGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateRoleFromGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateRoleFromGroupInputOperationOutputAlias,
                crate::output::DisassociateRoleFromGroupOutput,
                crate::error::DisassociateRoleFromGroupError,
                crate::input::DisassociateRoleFromGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateServiceRoleFromAccount`.
    ///
    /// Disassociates the service role from your account. Without a service role, deployments will not work.
    #[derive(std::fmt::Debug)]
    pub struct DisassociateServiceRoleFromAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_service_role_from_account_input::Builder,
    }
    impl<C, M, R> DisassociateServiceRoleFromAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateServiceRoleFromAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateServiceRoleFromAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateServiceRoleFromAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateServiceRoleFromAccountInputOperationOutputAlias,
                crate::output::DisassociateServiceRoleFromAccountOutput,
                crate::error::DisassociateServiceRoleFromAccountError,
                crate::input::DisassociateServiceRoleFromAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAssociatedRole`.
    ///
    /// Retrieves the role associated with a particular group.
    #[derive(std::fmt::Debug)]
    pub struct GetAssociatedRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_associated_role_input::Builder,
    }
    impl<C, M, R> GetAssociatedRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssociatedRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssociatedRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssociatedRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssociatedRoleInputOperationOutputAlias,
                crate::output::GetAssociatedRoleOutput,
                crate::error::GetAssociatedRoleError,
                crate::input::GetAssociatedRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBulkDeploymentStatus`.
    ///
    /// Returns the status of a bulk deployment.
    #[derive(std::fmt::Debug)]
    pub struct GetBulkDeploymentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bulk_deployment_status_input::Builder,
    }
    impl<C, M, R> GetBulkDeploymentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBulkDeploymentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBulkDeploymentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBulkDeploymentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBulkDeploymentStatusInputOperationOutputAlias,
                crate::output::GetBulkDeploymentStatusOutput,
                crate::error::GetBulkDeploymentStatusError,
                crate::input::GetBulkDeploymentStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the bulk deployment.
        pub fn bulk_deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bulk_deployment_id(inp);
            self
        }
        /// The ID of the bulk deployment.
        pub fn set_bulk_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bulk_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectivityInfo`.
    ///
    /// Retrieves the connectivity information for a core.
    #[derive(std::fmt::Debug)]
    pub struct GetConnectivityInfo<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connectivity_info_input::Builder,
    }
    impl<C, M, R> GetConnectivityInfo<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnectivityInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectivityInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectivityInfoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectivityInfoInputOperationOutputAlias,
                crate::output::GetConnectivityInfoOutput,
                crate::error::GetConnectivityInfoError,
                crate::input::GetConnectivityInfoInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The thing name.
        pub fn thing_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(inp);
            self
        }
        /// The thing name.
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectorDefinition`.
    ///
    /// Retrieves information about a connector definition.
    #[derive(std::fmt::Debug)]
    pub struct GetConnectorDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connector_definition_input::Builder,
    }
    impl<C, M, R> GetConnectorDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnectorDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectorDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectorDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectorDefinitionInputOperationOutputAlias,
                crate::output::GetConnectorDefinitionOutput,
                crate::error::GetConnectorDefinitionError,
                crate::input::GetConnectorDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_definition_id(inp);
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnectorDefinitionVersion`.
    ///
    /// Retrieves information about a connector definition version, including the connectors that the version contains. Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud services.
    #[derive(std::fmt::Debug)]
    pub struct GetConnectorDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connector_definition_version_input::Builder,
    }
    impl<C, M, R> GetConnectorDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnectorDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectorDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectorDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectorDefinitionVersionInputOperationOutputAlias,
                crate::output::GetConnectorDefinitionVersionOutput,
                crate::error::GetConnectorDefinitionVersionError,
                crate::input::GetConnectorDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_definition_id(inp);
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_definition_id(input);
            self
        }
        /// The ID of the connector definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListConnectorDefinitionVersions'' requests. If the version is the last one that was associated with a connector definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn connector_definition_version_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.connector_definition_version_id(inp);
            self
        }
        /// The ID of the connector definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListConnectorDefinitionVersions'' requests. If the version is the last one that was associated with a connector definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_connector_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_definition_version_id(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCoreDefinition`.
    ///
    /// Retrieves information about a core definition version.
    #[derive(std::fmt::Debug)]
    pub struct GetCoreDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_core_definition_input::Builder,
    }
    impl<C, M, R> GetCoreDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCoreDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCoreDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCoreDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCoreDefinitionInputOperationOutputAlias,
                crate::output::GetCoreDefinitionOutput,
                crate::error::GetCoreDefinitionError,
                crate::input::GetCoreDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_definition_id(inp);
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCoreDefinitionVersion`.
    ///
    /// Retrieves information about a core definition version.
    #[derive(std::fmt::Debug)]
    pub struct GetCoreDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_core_definition_version_input::Builder,
    }
    impl<C, M, R> GetCoreDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCoreDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCoreDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCoreDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCoreDefinitionVersionInputOperationOutputAlias,
                crate::output::GetCoreDefinitionVersionOutput,
                crate::error::GetCoreDefinitionVersionError,
                crate::input::GetCoreDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_definition_id(inp);
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_definition_id(input);
            self
        }
        /// The ID of the core definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListCoreDefinitionVersions'' requests. If the version is the last one that was associated with a core definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn core_definition_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_definition_version_id(inp);
            self
        }
        /// The ID of the core definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListCoreDefinitionVersions'' requests. If the version is the last one that was associated with a core definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_core_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_definition_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeploymentStatus`.
    ///
    /// Returns the status of a deployment.
    #[derive(std::fmt::Debug)]
    pub struct GetDeploymentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_deployment_status_input::Builder,
    }
    impl<C, M, R> GetDeploymentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeploymentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeploymentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeploymentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeploymentStatusInputOperationOutputAlias,
                crate::output::GetDeploymentStatusOutput,
                crate::error::GetDeploymentStatusError,
                crate::input::GetDeploymentStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the deployment.
        pub fn deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deployment_id(inp);
            self
        }
        /// The ID of the deployment.
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deployment_id(input);
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeviceDefinition`.
    ///
    /// Retrieves information about a device definition.
    #[derive(std::fmt::Debug)]
    pub struct GetDeviceDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_definition_input::Builder,
    }
    impl<C, M, R> GetDeviceDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeviceDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceDefinitionInputOperationOutputAlias,
                crate::output::GetDeviceDefinitionOutput,
                crate::error::GetDeviceDefinitionError,
                crate::input::GetDeviceDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_definition_id(inp);
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDeviceDefinitionVersion`.
    ///
    /// Retrieves information about a device definition version.
    #[derive(std::fmt::Debug)]
    pub struct GetDeviceDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_definition_version_input::Builder,
    }
    impl<C, M, R> GetDeviceDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeviceDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceDefinitionVersionInputOperationOutputAlias,
                crate::output::GetDeviceDefinitionVersionOutput,
                crate::error::GetDeviceDefinitionVersionError,
                crate::input::GetDeviceDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_definition_id(inp);
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_definition_id(input);
            self
        }
        /// The ID of the device definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListDeviceDefinitionVersions'' requests. If the version is the last one that was associated with a device definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn device_definition_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_definition_version_id(inp);
            self
        }
        /// The ID of the device definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListDeviceDefinitionVersions'' requests. If the version is the last one that was associated with a device definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_device_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_definition_version_id(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunctionDefinition`.
    ///
    /// Retrieves information about a Lambda function definition, including its creation time and latest version.
    #[derive(std::fmt::Debug)]
    pub struct GetFunctionDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_function_definition_input::Builder,
    }
    impl<C, M, R> GetFunctionDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFunctionDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFunctionDefinitionInputOperationOutputAlias,
                crate::output::GetFunctionDefinitionOutput,
                crate::error::GetFunctionDefinitionError,
                crate::input::GetFunctionDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_definition_id(inp);
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunctionDefinitionVersion`.
    ///
    /// Retrieves information about a Lambda function definition version, including which Lambda functions are included in the version and their configurations.
    #[derive(std::fmt::Debug)]
    pub struct GetFunctionDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_function_definition_version_input::Builder,
    }
    impl<C, M, R> GetFunctionDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFunctionDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFunctionDefinitionVersionInputOperationOutputAlias,
                crate::output::GetFunctionDefinitionVersionOutput,
                crate::error::GetFunctionDefinitionVersionError,
                crate::input::GetFunctionDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_definition_id(inp);
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_definition_id(input);
            self
        }
        /// The ID of the function definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListFunctionDefinitionVersions'' requests. If the version is the last one that was associated with a function definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn function_definition_version_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.function_definition_version_id(inp);
            self
        }
        /// The ID of the function definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListFunctionDefinitionVersions'' requests. If the version is the last one that was associated with a function definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_function_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_definition_version_id(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroup`.
    ///
    /// Retrieves information about a group.
    #[derive(std::fmt::Debug)]
    pub struct GetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_input::Builder,
    }
    impl<C, M, R> GetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupInputOperationOutputAlias,
                crate::output::GetGroupOutput,
                crate::error::GetGroupError,
                crate::input::GetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroupCertificateAuthority`.
    ///
    /// Retreives the CA associated with a group. Returns the public key of the CA.
    #[derive(std::fmt::Debug)]
    pub struct GetGroupCertificateAuthority<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_certificate_authority_input::Builder,
    }
    impl<C, M, R> GetGroupCertificateAuthority<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroupCertificateAuthority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupCertificateAuthorityOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupCertificateAuthorityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupCertificateAuthorityInputOperationOutputAlias,
                crate::output::GetGroupCertificateAuthorityOutput,
                crate::error::GetGroupCertificateAuthorityError,
                crate::input::GetGroupCertificateAuthorityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the certificate authority.
        pub fn certificate_authority_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_authority_id(inp);
            self
        }
        /// The ID of the certificate authority.
        pub fn set_certificate_authority_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_authority_id(input);
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroupCertificateConfiguration`.
    ///
    /// Retrieves the current configuration for the CA used by the group.
    #[derive(std::fmt::Debug)]
    pub struct GetGroupCertificateConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_certificate_configuration_input::Builder,
    }
    impl<C, M, R> GetGroupCertificateConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroupCertificateConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupCertificateConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupCertificateConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupCertificateConfigurationInputOperationOutputAlias,
                crate::output::GetGroupCertificateConfigurationOutput,
                crate::error::GetGroupCertificateConfigurationError,
                crate::input::GetGroupCertificateConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroupVersion`.
    ///
    /// Retrieves information about a group version.
    #[derive(std::fmt::Debug)]
    pub struct GetGroupVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_version_input::Builder,
    }
    impl<C, M, R> GetGroupVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroupVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupVersionInputOperationOutputAlias,
                crate::output::GetGroupVersionOutput,
                crate::error::GetGroupVersionError,
                crate::input::GetGroupVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// The ID of the group version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListGroupVersions'' requests. If the version is the last one that was associated with a group, the value also maps to the ''LatestVersion'' property of the corresponding ''GroupInformation'' object.
        pub fn group_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_version_id(inp);
            self
        }
        /// The ID of the group version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListGroupVersions'' requests. If the version is the last one that was associated with a group, the value also maps to the ''LatestVersion'' property of the corresponding ''GroupInformation'' object.
        pub fn set_group_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_group_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoggerDefinition`.
    ///
    /// Retrieves information about a logger definition.
    #[derive(std::fmt::Debug)]
    pub struct GetLoggerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_logger_definition_input::Builder,
    }
    impl<C, M, R> GetLoggerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLoggerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoggerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoggerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLoggerDefinitionInputOperationOutputAlias,
                crate::output::GetLoggerDefinitionOutput,
                crate::error::GetLoggerDefinitionError,
                crate::input::GetLoggerDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logger_definition_id(inp);
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logger_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoggerDefinitionVersion`.
    ///
    /// Retrieves information about a logger definition version.
    #[derive(std::fmt::Debug)]
    pub struct GetLoggerDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_logger_definition_version_input::Builder,
    }
    impl<C, M, R> GetLoggerDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLoggerDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoggerDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoggerDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLoggerDefinitionVersionInputOperationOutputAlias,
                crate::output::GetLoggerDefinitionVersionOutput,
                crate::error::GetLoggerDefinitionVersionError,
                crate::input::GetLoggerDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logger_definition_id(inp);
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logger_definition_id(input);
            self
        }
        /// The ID of the logger definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListLoggerDefinitionVersions'' requests. If the version is the last one that was associated with a logger definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn logger_definition_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logger_definition_version_id(inp);
            self
        }
        /// The ID of the logger definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListLoggerDefinitionVersions'' requests. If the version is the last one that was associated with a logger definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_logger_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logger_definition_version_id(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceDefinition`.
    ///
    /// Retrieves information about a resource definition, including its creation time and latest version.
    #[derive(std::fmt::Debug)]
    pub struct GetResourceDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_definition_input::Builder,
    }
    impl<C, M, R> GetResourceDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceDefinitionInputOperationOutputAlias,
                crate::output::GetResourceDefinitionOutput,
                crate::error::GetResourceDefinitionError,
                crate::input::GetResourceDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_definition_id(inp);
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceDefinitionVersion`.
    ///
    /// Retrieves information about a resource definition version, including which resources are included in the version.
    #[derive(std::fmt::Debug)]
    pub struct GetResourceDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_definition_version_input::Builder,
    }
    impl<C, M, R> GetResourceDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceDefinitionVersionInputOperationOutputAlias,
                crate::output::GetResourceDefinitionVersionOutput,
                crate::error::GetResourceDefinitionVersionError,
                crate::input::GetResourceDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_definition_id(inp);
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_definition_id(input);
            self
        }
        /// The ID of the resource definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListResourceDefinitionVersions'' requests. If the version is the last one that was associated with a resource definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn resource_definition_version_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_definition_version_id(inp);
            self
        }
        /// The ID of the resource definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListResourceDefinitionVersions'' requests. If the version is the last one that was associated with a resource definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_resource_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_definition_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceRoleForAccount`.
    ///
    /// Retrieves the service role that is attached to your account.
    #[derive(std::fmt::Debug)]
    pub struct GetServiceRoleForAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_role_for_account_input::Builder,
    }
    impl<C, M, R> GetServiceRoleForAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceRoleForAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceRoleForAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceRoleForAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceRoleForAccountInputOperationOutputAlias,
                crate::output::GetServiceRoleForAccountOutput,
                crate::error::GetServiceRoleForAccountError,
                crate::input::GetServiceRoleForAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSubscriptionDefinition`.
    ///
    /// Retrieves information about a subscription definition.
    #[derive(std::fmt::Debug)]
    pub struct GetSubscriptionDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_subscription_definition_input::Builder,
    }
    impl<C, M, R> GetSubscriptionDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSubscriptionDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSubscriptionDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSubscriptionDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSubscriptionDefinitionInputOperationOutputAlias,
                crate::output::GetSubscriptionDefinitionOutput,
                crate::error::GetSubscriptionDefinitionError,
                crate::input::GetSubscriptionDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_definition_id(inp);
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSubscriptionDefinitionVersion`.
    ///
    /// Retrieves information about a subscription definition version.
    #[derive(std::fmt::Debug)]
    pub struct GetSubscriptionDefinitionVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_subscription_definition_version_input::Builder,
    }
    impl<C, M, R> GetSubscriptionDefinitionVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSubscriptionDefinitionVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSubscriptionDefinitionVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSubscriptionDefinitionVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSubscriptionDefinitionVersionInputOperationOutputAlias,
                crate::output::GetSubscriptionDefinitionVersionOutput,
                crate::error::GetSubscriptionDefinitionVersionError,
                crate::input::GetSubscriptionDefinitionVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_definition_id(inp);
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_definition_id(input);
            self
        }
        /// The ID of the subscription definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListSubscriptionDefinitionVersions'' requests. If the version is the last one that was associated with a subscription definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn subscription_definition_version_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.subscription_definition_version_id(inp);
            self
        }
        /// The ID of the subscription definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListSubscriptionDefinitionVersions'' requests. If the version is the last one that was associated with a subscription definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_subscription_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_definition_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetThingRuntimeConfiguration`.
    ///
    /// Get the runtime configuration of a thing.
    #[derive(std::fmt::Debug)]
    pub struct GetThingRuntimeConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_thing_runtime_configuration_input::Builder,
    }
    impl<C, M, R> GetThingRuntimeConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetThingRuntimeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetThingRuntimeConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetThingRuntimeConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetThingRuntimeConfigurationInputOperationOutputAlias,
                crate::output::GetThingRuntimeConfigurationOutput,
                crate::error::GetThingRuntimeConfigurationError,
                crate::input::GetThingRuntimeConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The thing name.
        pub fn thing_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(inp);
            self
        }
        /// The thing name.
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBulkDeploymentDetailedReports`.
    ///
    /// Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current deployment status.
    #[derive(std::fmt::Debug)]
    pub struct ListBulkDeploymentDetailedReports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bulk_deployment_detailed_reports_input::Builder,
    }
    impl<C, M, R> ListBulkDeploymentDetailedReports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBulkDeploymentDetailedReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBulkDeploymentDetailedReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBulkDeploymentDetailedReportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBulkDeploymentDetailedReportsInputOperationOutputAlias,
                crate::output::ListBulkDeploymentDetailedReportsOutput,
                crate::error::ListBulkDeploymentDetailedReportsError,
                crate::input::ListBulkDeploymentDetailedReportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the bulk deployment.
        pub fn bulk_deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bulk_deployment_id(inp);
            self
        }
        /// The ID of the bulk deployment.
        pub fn set_bulk_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bulk_deployment_id(input);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBulkDeployments`.
    ///
    /// Returns a list of bulk deployments.
    #[derive(std::fmt::Debug)]
    pub struct ListBulkDeployments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bulk_deployments_input::Builder,
    }
    impl<C, M, R> ListBulkDeployments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBulkDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBulkDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBulkDeploymentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBulkDeploymentsInputOperationOutputAlias,
                crate::output::ListBulkDeploymentsOutput,
                crate::error::ListBulkDeploymentsError,
                crate::input::ListBulkDeploymentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnectorDefinitions`.
    ///
    /// Retrieves a list of connector definitions.
    #[derive(std::fmt::Debug)]
    pub struct ListConnectorDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_connector_definitions_input::Builder,
    }
    impl<C, M, R> ListConnectorDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConnectorDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectorDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectorDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConnectorDefinitionsInputOperationOutputAlias,
                crate::output::ListConnectorDefinitionsOutput,
                crate::error::ListConnectorDefinitionsError,
                crate::input::ListConnectorDefinitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnectorDefinitionVersions`.
    ///
    /// Lists the versions of a connector definition, which are containers for connectors. Connectors run on the Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other cloud services.
    #[derive(std::fmt::Debug)]
    pub struct ListConnectorDefinitionVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_connector_definition_versions_input::Builder,
    }
    impl<C, M, R> ListConnectorDefinitionVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConnectorDefinitionVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectorDefinitionVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectorDefinitionVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConnectorDefinitionVersionsInputOperationOutputAlias,
                crate::output::ListConnectorDefinitionVersionsOutput,
                crate::error::ListConnectorDefinitionVersionsError,
                crate::input::ListConnectorDefinitionVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_definition_id(inp);
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_definition_id(input);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoreDefinitions`.
    ///
    /// Retrieves a list of core definitions.
    #[derive(std::fmt::Debug)]
    pub struct ListCoreDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_core_definitions_input::Builder,
    }
    impl<C, M, R> ListCoreDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCoreDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoreDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoreDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCoreDefinitionsInputOperationOutputAlias,
                crate::output::ListCoreDefinitionsOutput,
                crate::error::ListCoreDefinitionsError,
                crate::input::ListCoreDefinitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCoreDefinitionVersions`.
    ///
    /// Lists the versions of a core definition.
    #[derive(std::fmt::Debug)]
    pub struct ListCoreDefinitionVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_core_definition_versions_input::Builder,
    }
    impl<C, M, R> ListCoreDefinitionVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCoreDefinitionVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCoreDefinitionVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCoreDefinitionVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCoreDefinitionVersionsInputOperationOutputAlias,
                crate::output::ListCoreDefinitionVersionsOutput,
                crate::error::ListCoreDefinitionVersionsError,
                crate::input::ListCoreDefinitionVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_definition_id(inp);
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_definition_id(input);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeployments`.
    ///
    /// Returns a history of deployments for the group.
    #[derive(std::fmt::Debug)]
    pub struct ListDeployments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_deployments_input::Builder,
    }
    impl<C, M, R> ListDeployments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeploymentsInputOperationOutputAlias,
                crate::output::ListDeploymentsOutput,
                crate::error::ListDeploymentsError,
                crate::input::ListDeploymentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeviceDefinitions`.
    ///
    /// Retrieves a list of device definitions.
    #[derive(std::fmt::Debug)]
    pub struct ListDeviceDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_device_definitions_input::Builder,
    }
    impl<C, M, R> ListDeviceDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeviceDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeviceDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeviceDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeviceDefinitionsInputOperationOutputAlias,
                crate::output::ListDeviceDefinitionsOutput,
                crate::error::ListDeviceDefinitionsError,
                crate::input::ListDeviceDefinitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeviceDefinitionVersions`.
    ///
    /// Lists the versions of a device definition.
    #[derive(std::fmt::Debug)]
    pub struct ListDeviceDefinitionVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_device_definition_versions_input::Builder,
    }
    impl<C, M, R> ListDeviceDefinitionVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeviceDefinitionVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeviceDefinitionVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeviceDefinitionVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeviceDefinitionVersionsInputOperationOutputAlias,
                crate::output::ListDeviceDefinitionVersionsOutput,
                crate::error::ListDeviceDefinitionVersionsError,
                crate::input::ListDeviceDefinitionVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_definition_id(inp);
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_definition_id(input);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctionDefinitions`.
    ///
    /// Retrieves a list of Lambda function definitions.
    #[derive(std::fmt::Debug)]
    pub struct ListFunctionDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_function_definitions_input::Builder,
    }
    impl<C, M, R> ListFunctionDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFunctionDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFunctionDefinitionsInputOperationOutputAlias,
                crate::output::ListFunctionDefinitionsOutput,
                crate::error::ListFunctionDefinitionsError,
                crate::input::ListFunctionDefinitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctionDefinitionVersions`.
    ///
    /// Lists the versions of a Lambda function definition.
    #[derive(std::fmt::Debug)]
    pub struct ListFunctionDefinitionVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_function_definition_versions_input::Builder,
    }
    impl<C, M, R> ListFunctionDefinitionVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFunctionDefinitionVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionDefinitionVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionDefinitionVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFunctionDefinitionVersionsInputOperationOutputAlias,
                crate::output::ListFunctionDefinitionVersionsOutput,
                crate::error::ListFunctionDefinitionVersionsError,
                crate::input::ListFunctionDefinitionVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_definition_id(inp);
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_definition_id(input);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupCertificateAuthorities`.
    ///
    /// Retrieves the current CAs for a group.
    #[derive(std::fmt::Debug)]
    pub struct ListGroupCertificateAuthorities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_group_certificate_authorities_input::Builder,
    }
    impl<C, M, R> ListGroupCertificateAuthorities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroupCertificateAuthorities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupCertificateAuthoritiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupCertificateAuthoritiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupCertificateAuthoritiesInputOperationOutputAlias,
                crate::output::ListGroupCertificateAuthoritiesOutput,
                crate::error::ListGroupCertificateAuthoritiesError,
                crate::input::ListGroupCertificateAuthoritiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroups`.
    ///
    /// Retrieves a list of groups.
    #[derive(std::fmt::Debug)]
    pub struct ListGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_groups_input::Builder,
    }
    impl<C, M, R> ListGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupsInputOperationOutputAlias,
                crate::output::ListGroupsOutput,
                crate::error::ListGroupsError,
                crate::input::ListGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupVersions`.
    ///
    /// Lists the versions of a group.
    #[derive(std::fmt::Debug)]
    pub struct ListGroupVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_group_versions_input::Builder,
    }
    impl<C, M, R> ListGroupVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroupVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupVersionsInputOperationOutputAlias,
                crate::output::ListGroupVersionsOutput,
                crate::error::ListGroupVersionsError,
                crate::input::ListGroupVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLoggerDefinitions`.
    ///
    /// Retrieves a list of logger definitions.
    #[derive(std::fmt::Debug)]
    pub struct ListLoggerDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_logger_definitions_input::Builder,
    }
    impl<C, M, R> ListLoggerDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLoggerDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLoggerDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLoggerDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLoggerDefinitionsInputOperationOutputAlias,
                crate::output::ListLoggerDefinitionsOutput,
                crate::error::ListLoggerDefinitionsError,
                crate::input::ListLoggerDefinitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLoggerDefinitionVersions`.
    ///
    /// Lists the versions of a logger definition.
    #[derive(std::fmt::Debug)]
    pub struct ListLoggerDefinitionVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_logger_definition_versions_input::Builder,
    }
    impl<C, M, R> ListLoggerDefinitionVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLoggerDefinitionVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLoggerDefinitionVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLoggerDefinitionVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLoggerDefinitionVersionsInputOperationOutputAlias,
                crate::output::ListLoggerDefinitionVersionsOutput,
                crate::error::ListLoggerDefinitionVersionsError,
                crate::input::ListLoggerDefinitionVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logger_definition_id(inp);
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logger_definition_id(input);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceDefinitions`.
    ///
    /// Retrieves a list of resource definitions.
    #[derive(std::fmt::Debug)]
    pub struct ListResourceDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_definitions_input::Builder,
    }
    impl<C, M, R> ListResourceDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceDefinitionsInputOperationOutputAlias,
                crate::output::ListResourceDefinitionsOutput,
                crate::error::ListResourceDefinitionsError,
                crate::input::ListResourceDefinitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceDefinitionVersions`.
    ///
    /// Lists the versions of a resource definition.
    #[derive(std::fmt::Debug)]
    pub struct ListResourceDefinitionVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_definition_versions_input::Builder,
    }
    impl<C, M, R> ListResourceDefinitionVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceDefinitionVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceDefinitionVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceDefinitionVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceDefinitionVersionsInputOperationOutputAlias,
                crate::output::ListResourceDefinitionVersionsOutput,
                crate::error::ListResourceDefinitionVersionsError,
                crate::input::ListResourceDefinitionVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_definition_id(inp);
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSubscriptionDefinitions`.
    ///
    /// Retrieves a list of subscription definitions.
    #[derive(std::fmt::Debug)]
    pub struct ListSubscriptionDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_subscription_definitions_input::Builder,
    }
    impl<C, M, R> ListSubscriptionDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSubscriptionDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSubscriptionDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSubscriptionDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSubscriptionDefinitionsInputOperationOutputAlias,
                crate::output::ListSubscriptionDefinitionsOutput,
                crate::error::ListSubscriptionDefinitionsError,
                crate::input::ListSubscriptionDefinitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSubscriptionDefinitionVersions`.
    ///
    /// Lists the versions of a subscription definition.
    #[derive(std::fmt::Debug)]
    pub struct ListSubscriptionDefinitionVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_subscription_definition_versions_input::Builder,
    }
    impl<C, M, R> ListSubscriptionDefinitionVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSubscriptionDefinitionVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSubscriptionDefinitionVersionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListSubscriptionDefinitionVersionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSubscriptionDefinitionVersionsInputOperationOutputAlias,
                crate::output::ListSubscriptionDefinitionVersionsOutput,
                crate::error::ListSubscriptionDefinitionVersionsError,
                crate::input::ListSubscriptionDefinitionVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_definition_id(inp);
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// Retrieves a list of resource tags for a resource arn.
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetDeployments`.
    ///
    /// Resets a group's deployments.
    #[derive(std::fmt::Debug)]
    pub struct ResetDeployments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_deployments_input::Builder,
    }
    impl<C, M, R> ResetDeployments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetDeploymentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetDeploymentsInputOperationOutputAlias,
                crate::output::ResetDeploymentsOutput,
                crate::error::ResetDeploymentsError,
                crate::input::ResetDeploymentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// If true, performs a best-effort only core reset.
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// If true, performs a best-effort only core reset.
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBulkDeployment`.
    ///
    /// Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These requests are idempotent with respect to the token and the request parameters.
    #[derive(std::fmt::Debug)]
    pub struct StartBulkDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_bulk_deployment_input::Builder,
    }
    impl<C, M, R> StartBulkDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartBulkDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartBulkDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartBulkDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartBulkDeploymentInputOperationOutputAlias,
                crate::output::StartBulkDeploymentOutput,
                crate::error::StartBulkDeploymentError,
                crate::input::StartBulkDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.amzn_client_token(inp);
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_amzn_client_token(input);
            self
        }
        /// The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow the ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This IAM role must have access to the S3 bucket containing the input file.
        pub fn execution_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(inp);
            self
        }
        /// The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow the ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This IAM role must have access to the S3 bucket containing the input file.
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// The URI of the input file contained in the S3 bucket. The execution role must have ''getObject'' permissions on this bucket to access the input file. The input file is a JSON-serialized, line delimited file with UTF-8 encoding that provides a list of group and version IDs and the deployment type. This file must be less than 100 MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
        pub fn input_file_uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_file_uri(inp);
            self
        }
        /// The URI of the input file contained in the S3 bucket. The execution role must have ''getObject'' permissions on this bucket to access the input file. The input file is a JSON-serialized, line delimited file with UTF-8 encoding that provides a list of group and version IDs and the deployment type. This file must be less than 100 MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
        pub fn set_input_file_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_file_uri(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopBulkDeployment`.
    ///
    /// Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This action doesn't rollback completed deployments or cancel pending deployments.
    #[derive(std::fmt::Debug)]
    pub struct StopBulkDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_bulk_deployment_input::Builder,
    }
    impl<C, M, R> StopBulkDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopBulkDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopBulkDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::StopBulkDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopBulkDeploymentInputOperationOutputAlias,
                crate::output::StopBulkDeploymentOutput,
                crate::error::StopBulkDeploymentError,
                crate::input::StopBulkDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the bulk deployment.
        pub fn bulk_deployment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bulk_deployment_id(inp);
            self
        }
        /// The ID of the bulk deployment.
        pub fn set_bulk_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bulk_deployment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// Adds tags to a Greengrass resource. Valid resources are 'Group', 'ConnectorDefinition', 'CoreDefinition', 'DeviceDefinition', 'FunctionDefinition', 'LoggerDefinition', 'SubscriptionDefinition', 'ResourceDefinition', and 'BulkDeployment'.
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The key-value pair for the resource tag.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// The key-value pair for the resource tag.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// Remove resource tags from a Greengrass Resource.
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// An array of tag keys to delete
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// An array of tag keys to delete
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnectivityInfo`.
    ///
    /// Updates the connectivity information for the core. Any devices that belong to the group which has this core will receive this information in order to find the location of the core and connect to it.
    #[derive(std::fmt::Debug)]
    pub struct UpdateConnectivityInfo<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_connectivity_info_input::Builder,
    }
    impl<C, M, R> UpdateConnectivityInfo<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConnectivityInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectivityInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectivityInfoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConnectivityInfoInputOperationOutputAlias,
                crate::output::UpdateConnectivityInfoOutput,
                crate::error::UpdateConnectivityInfoError,
                crate::input::UpdateConnectivityInfoInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ConnectivityInfo`.
        ///
        /// To override the contents of this collection use [`set_connectivity_info`](Self::set_connectivity_info).
        ///
        /// A list of connectivity info.
        pub fn connectivity_info(mut self, inp: impl Into<crate::model::ConnectivityInfo>) -> Self {
            self.inner = self.inner.connectivity_info(inp);
            self
        }
        /// A list of connectivity info.
        pub fn set_connectivity_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectivityInfo>>,
        ) -> Self {
            self.inner = self.inner.set_connectivity_info(input);
            self
        }
        /// The thing name.
        pub fn thing_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(inp);
            self
        }
        /// The thing name.
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnectorDefinition`.
    ///
    /// Updates a connector definition.
    #[derive(std::fmt::Debug)]
    pub struct UpdateConnectorDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_connector_definition_input::Builder,
    }
    impl<C, M, R> UpdateConnectorDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConnectorDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectorDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectorDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConnectorDefinitionInputOperationOutputAlias,
                crate::output::UpdateConnectorDefinitionOutput,
                crate::error::UpdateConnectorDefinitionError,
                crate::input::UpdateConnectorDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connector_definition_id(inp);
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connector_definition_id(input);
            self
        }
        /// The name of the definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCoreDefinition`.
    ///
    /// Updates a core definition.
    #[derive(std::fmt::Debug)]
    pub struct UpdateCoreDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_core_definition_input::Builder,
    }
    impl<C, M, R> UpdateCoreDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCoreDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCoreDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCoreDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCoreDefinitionInputOperationOutputAlias,
                crate::output::UpdateCoreDefinitionOutput,
                crate::error::UpdateCoreDefinitionError,
                crate::input::UpdateCoreDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.core_definition_id(inp);
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_core_definition_id(input);
            self
        }
        /// The name of the definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDeviceDefinition`.
    ///
    /// Updates a device definition.
    #[derive(std::fmt::Debug)]
    pub struct UpdateDeviceDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_device_definition_input::Builder,
    }
    impl<C, M, R> UpdateDeviceDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDeviceDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDeviceDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDeviceDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDeviceDefinitionInputOperationOutputAlias,
                crate::output::UpdateDeviceDefinitionOutput,
                crate::error::UpdateDeviceDefinitionError,
                crate::input::UpdateDeviceDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_definition_id(inp);
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_definition_id(input);
            self
        }
        /// The name of the definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunctionDefinition`.
    ///
    /// Updates a Lambda function definition.
    #[derive(std::fmt::Debug)]
    pub struct UpdateFunctionDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_function_definition_input::Builder,
    }
    impl<C, M, R> UpdateFunctionDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFunctionDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFunctionDefinitionInputOperationOutputAlias,
                crate::output::UpdateFunctionDefinitionOutput,
                crate::error::UpdateFunctionDefinitionError,
                crate::input::UpdateFunctionDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_definition_id(inp);
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_definition_id(input);
            self
        }
        /// The name of the definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroup`.
    ///
    /// Updates a group.
    #[derive(std::fmt::Debug)]
    pub struct UpdateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_group_input::Builder,
    }
    impl<C, M, R> UpdateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGroupInputOperationOutputAlias,
                crate::output::UpdateGroupOutput,
                crate::error::UpdateGroupError,
                crate::input::UpdateGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// The name of the definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroupCertificateConfiguration`.
    ///
    /// Updates the Certificate expiry time for a group.
    #[derive(std::fmt::Debug)]
    pub struct UpdateGroupCertificateConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_group_certificate_configuration_input::Builder,
    }
    impl<C, M, R> UpdateGroupCertificateConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGroupCertificateConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupCertificateConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateGroupCertificateConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGroupCertificateConfigurationInputOperationOutputAlias,
                crate::output::UpdateGroupCertificateConfigurationOutput,
                crate::error::UpdateGroupCertificateConfigurationError,
                crate::input::UpdateGroupCertificateConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The amount of time remaining before the certificate expires, in milliseconds.
        pub fn certificate_expiry_in_milliseconds(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.certificate_expiry_in_milliseconds(inp);
            self
        }
        /// The amount of time remaining before the certificate expires, in milliseconds.
        pub fn set_certificate_expiry_in_milliseconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_expiry_in_milliseconds(input);
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(inp);
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLoggerDefinition`.
    ///
    /// Updates a logger definition.
    #[derive(std::fmt::Debug)]
    pub struct UpdateLoggerDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_logger_definition_input::Builder,
    }
    impl<C, M, R> UpdateLoggerDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLoggerDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLoggerDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLoggerDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLoggerDefinitionInputOperationOutputAlias,
                crate::output::UpdateLoggerDefinitionOutput,
                crate::error::UpdateLoggerDefinitionError,
                crate::input::UpdateLoggerDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logger_definition_id(inp);
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_logger_definition_id(input);
            self
        }
        /// The name of the definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceDefinition`.
    ///
    /// Updates a resource definition.
    #[derive(std::fmt::Debug)]
    pub struct UpdateResourceDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_definition_input::Builder,
    }
    impl<C, M, R> UpdateResourceDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResourceDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceDefinitionInputOperationOutputAlias,
                crate::output::UpdateResourceDefinitionOutput,
                crate::error::UpdateResourceDefinitionError,
                crate::input::UpdateResourceDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_definition_id(inp);
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSubscriptionDefinition`.
    ///
    /// Updates a subscription definition.
    #[derive(std::fmt::Debug)]
    pub struct UpdateSubscriptionDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_subscription_definition_input::Builder,
    }
    impl<C, M, R> UpdateSubscriptionDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSubscriptionDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSubscriptionDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSubscriptionDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSubscriptionDefinitionInputOperationOutputAlias,
                crate::output::UpdateSubscriptionDefinitionOutput,
                crate::error::UpdateSubscriptionDefinitionError,
                crate::input::UpdateSubscriptionDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the definition.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_definition_id(inp);
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateThingRuntimeConfiguration`.
    ///
    /// Updates the runtime configuration of a thing.
    #[derive(std::fmt::Debug)]
    pub struct UpdateThingRuntimeConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_thing_runtime_configuration_input::Builder,
    }
    impl<C, M, R> UpdateThingRuntimeConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateThingRuntimeConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThingRuntimeConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThingRuntimeConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateThingRuntimeConfigurationInputOperationOutputAlias,
                crate::output::UpdateThingRuntimeConfigurationOutput,
                crate::error::UpdateThingRuntimeConfigurationError,
                crate::input::UpdateThingRuntimeConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Configuration for telemetry service.
        pub fn telemetry_configuration(
            mut self,
            inp: crate::model::TelemetryConfigurationUpdate,
        ) -> Self {
            self.inner = self.inner.telemetry_configuration(inp);
            self
        }
        /// Configuration for telemetry service.
        pub fn set_telemetry_configuration(
            mut self,
            input: std::option::Option<crate::model::TelemetryConfigurationUpdate>,
        ) -> Self {
            self.inner = self.inner.set_telemetry_configuration(input);
            self
        }
        /// The thing name.
        pub fn thing_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thing_name(inp);
            self
        }
        /// The thing name.
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_thing_name(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
