// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateRoleToGroupInput`](crate::input::AssociateRoleToGroupInput)
pub mod associate_role_to_group_input {
    /// A builder for [`AssociateRoleToGroupInput`](crate::input::AssociateRoleToGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// The ARN of the role you wish to associate with this group. The existence of the role is not validated.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The ARN of the role you wish to associate with this group. The existence of the role is not validated.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateRoleToGroupInput`](crate::input::AssociateRoleToGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateRoleToGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateRoleToGroupInput {
                group_id: self.group_id,
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateRoleToGroupInputOperationOutputAlias = crate::operation::AssociateRoleToGroup;
#[doc(hidden)]
pub type AssociateRoleToGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateRoleToGroupInput {
    /// Consumes the builder and constructs an Operation<[`AssociateRoleToGroup`](crate::operation::AssociateRoleToGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateRoleToGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateRoleToGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.group_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_1, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/role",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateRoleToGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateRoleToGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_role_to_group(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateRoleToGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateRoleToGroup",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateRoleToGroupInput`](crate::input::AssociateRoleToGroupInput)
    pub fn builder() -> crate::input::associate_role_to_group_input::Builder {
        crate::input::associate_role_to_group_input::Builder::default()
    }
}

/// See [`AssociateServiceRoleToAccountInput`](crate::input::AssociateServiceRoleToAccountInput)
pub mod associate_service_role_to_account_input {
    /// A builder for [`AssociateServiceRoleToAccountInput`](crate::input::AssociateServiceRoleToAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the service role you wish to associate with your account.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The ARN of the service role you wish to associate with your account.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateServiceRoleToAccountInput`](crate::input::AssociateServiceRoleToAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateServiceRoleToAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateServiceRoleToAccountInput {
                role_arn: self.role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateServiceRoleToAccountInputOperationOutputAlias =
    crate::operation::AssociateServiceRoleToAccount;
#[doc(hidden)]
pub type AssociateServiceRoleToAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateServiceRoleToAccountInput {
    /// Consumes the builder and constructs an Operation<[`AssociateServiceRoleToAccount`](crate::operation::AssociateServiceRoleToAccount)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateServiceRoleToAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateServiceRoleToAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/servicerole").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateServiceRoleToAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateServiceRoleToAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_service_role_to_account(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateServiceRoleToAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateServiceRoleToAccount",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateServiceRoleToAccountInput`](crate::input::AssociateServiceRoleToAccountInput)
    pub fn builder() -> crate::input::associate_service_role_to_account_input::Builder {
        crate::input::associate_service_role_to_account_input::Builder::default()
    }
}

/// See [`CreateConnectorDefinitionInput`](crate::input::CreateConnectorDefinitionInput)
pub mod create_connector_definition_input {
    /// A builder for [`CreateConnectorDefinitionInput`](crate::input::CreateConnectorDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) initial_version: std::option::Option<crate::model::ConnectorDefinitionVersion>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// Information about the initial version of the connector definition.
        pub fn initial_version(mut self, input: crate::model::ConnectorDefinitionVersion) -> Self {
            self.initial_version = Some(input);
            self
        }
        /// Information about the initial version of the connector definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::ConnectorDefinitionVersion>,
        ) -> Self {
            self.initial_version = input;
            self
        }
        /// The name of the connector definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the connector definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectorDefinitionInput`](crate::input::CreateConnectorDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConnectorDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConnectorDefinitionInput {
                amzn_client_token: self.amzn_client_token,
                initial_version: self.initial_version,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConnectorDefinitionInputOperationOutputAlias =
    crate::operation::CreateConnectorDefinition;
#[doc(hidden)]
pub type CreateConnectorDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConnectorDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateConnectorDefinition`](crate::operation::CreateConnectorDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConnectorDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConnectorDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/connectors").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateConnectorDefinitionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_2) = &_input.amzn_client_token {
                let formatted_3 = AsRef::<str>::as_ref(inner_2);
                if !formatted_3.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_3;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConnectorDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConnectorDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_connector_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConnectorDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConnectorDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConnectorDefinitionInput`](crate::input::CreateConnectorDefinitionInput)
    pub fn builder() -> crate::input::create_connector_definition_input::Builder {
        crate::input::create_connector_definition_input::Builder::default()
    }
}

/// See [`CreateConnectorDefinitionVersionInput`](crate::input::CreateConnectorDefinitionVersionInput)
pub mod create_connector_definition_version_input {
    /// A builder for [`CreateConnectorDefinitionVersionInput`](crate::input::CreateConnectorDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) connector_definition_id: std::option::Option<std::string::String>,
        pub(crate) connectors: std::option::Option<std::vec::Vec<crate::model::Connector>>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_definition_id = Some(input.into());
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_definition_id = input;
            self
        }
        /// Appends an item to `connectors`.
        ///
        /// To override the contents of this collection use [`set_connectors`](Self::set_connectors).
        ///
        /// A list of references to connectors in this version, with their corresponding configuration settings.
        pub fn connectors(mut self, input: impl Into<crate::model::Connector>) -> Self {
            let mut v = self.connectors.unwrap_or_default();
            v.push(input.into());
            self.connectors = Some(v);
            self
        }
        /// A list of references to connectors in this version, with their corresponding configuration settings.
        pub fn set_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connector>>,
        ) -> Self {
            self.connectors = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectorDefinitionVersionInput`](crate::input::CreateConnectorDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateConnectorDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateConnectorDefinitionVersionInput {
                amzn_client_token: self.amzn_client_token,
                connector_definition_id: self.connector_definition_id,
                connectors: self.connectors,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateConnectorDefinitionVersionInputOperationOutputAlias =
    crate::operation::CreateConnectorDefinitionVersion;
#[doc(hidden)]
pub type CreateConnectorDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateConnectorDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateConnectorDefinitionVersion`](crate::operation::CreateConnectorDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateConnectorDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateConnectorDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.connector_definition_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connector_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let connector_definition_id = aws_smithy_http::label::fmt_string(input_4, false);
            if connector_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connector_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/connectors/{ConnectorDefinitionId}/versions",
                ConnectorDefinitionId = connector_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateConnectorDefinitionVersionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_5) = &_input.amzn_client_token {
                let formatted_6 = AsRef::<str>::as_ref(inner_5);
                if !formatted_6.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_6;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateConnectorDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateConnectorDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_connector_definition_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateConnectorDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateConnectorDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateConnectorDefinitionVersionInput`](crate::input::CreateConnectorDefinitionVersionInput)
    pub fn builder() -> crate::input::create_connector_definition_version_input::Builder {
        crate::input::create_connector_definition_version_input::Builder::default()
    }
}

/// See [`CreateCoreDefinitionInput`](crate::input::CreateCoreDefinitionInput)
pub mod create_core_definition_input {
    /// A builder for [`CreateCoreDefinitionInput`](crate::input::CreateCoreDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) initial_version: std::option::Option<crate::model::CoreDefinitionVersion>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// Information about the initial version of the core definition.
        pub fn initial_version(mut self, input: crate::model::CoreDefinitionVersion) -> Self {
            self.initial_version = Some(input);
            self
        }
        /// Information about the initial version of the core definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::CoreDefinitionVersion>,
        ) -> Self {
            self.initial_version = input;
            self
        }
        /// The name of the core definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the core definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCoreDefinitionInput`](crate::input::CreateCoreDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCoreDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCoreDefinitionInput {
                amzn_client_token: self.amzn_client_token,
                initial_version: self.initial_version,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCoreDefinitionInputOperationOutputAlias = crate::operation::CreateCoreDefinition;
#[doc(hidden)]
pub type CreateCoreDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCoreDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateCoreDefinition`](crate::operation::CreateCoreDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCoreDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCoreDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/cores").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateCoreDefinitionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_7) = &_input.amzn_client_token {
                let formatted_8 = AsRef::<str>::as_ref(inner_7);
                if !formatted_8.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_8;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCoreDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCoreDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_core_definition(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCoreDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCoreDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCoreDefinitionInput`](crate::input::CreateCoreDefinitionInput)
    pub fn builder() -> crate::input::create_core_definition_input::Builder {
        crate::input::create_core_definition_input::Builder::default()
    }
}

/// See [`CreateCoreDefinitionVersionInput`](crate::input::CreateCoreDefinitionVersionInput)
pub mod create_core_definition_version_input {
    /// A builder for [`CreateCoreDefinitionVersionInput`](crate::input::CreateCoreDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) core_definition_id: std::option::Option<std::string::String>,
        pub(crate) cores: std::option::Option<std::vec::Vec<crate::model::Core>>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_definition_id = Some(input.into());
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_definition_id = input;
            self
        }
        /// Appends an item to `cores`.
        ///
        /// To override the contents of this collection use [`set_cores`](Self::set_cores).
        ///
        /// A list of cores in the core definition version.
        pub fn cores(mut self, input: impl Into<crate::model::Core>) -> Self {
            let mut v = self.cores.unwrap_or_default();
            v.push(input.into());
            self.cores = Some(v);
            self
        }
        /// A list of cores in the core definition version.
        pub fn set_cores(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Core>>,
        ) -> Self {
            self.cores = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCoreDefinitionVersionInput`](crate::input::CreateCoreDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCoreDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCoreDefinitionVersionInput {
                amzn_client_token: self.amzn_client_token,
                core_definition_id: self.core_definition_id,
                cores: self.cores,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCoreDefinitionVersionInputOperationOutputAlias =
    crate::operation::CreateCoreDefinitionVersion;
#[doc(hidden)]
pub type CreateCoreDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCoreDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateCoreDefinitionVersion`](crate::operation::CreateCoreDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCoreDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCoreDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.core_definition_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let core_definition_id = aws_smithy_http::label::fmt_string(input_9, false);
            if core_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/cores/{CoreDefinitionId}/versions",
                CoreDefinitionId = core_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateCoreDefinitionVersionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_10) = &_input.amzn_client_token {
                let formatted_11 = AsRef::<str>::as_ref(inner_10);
                if !formatted_11.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_11;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCoreDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCoreDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_core_definition_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCoreDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCoreDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCoreDefinitionVersionInput`](crate::input::CreateCoreDefinitionVersionInput)
    pub fn builder() -> crate::input::create_core_definition_version_input::Builder {
        crate::input::create_core_definition_version_input::Builder::default()
    }
}

/// See [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
pub mod create_deployment_input {
    /// A builder for [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) deployment_type: std::option::Option<crate::model::DeploymentType>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) group_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The ID of the deployment if you wish to redeploy a previous deployment.
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// The ID of the deployment if you wish to redeploy a previous deployment.
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// The type of deployment. When used for ''CreateDeployment'', only ''NewDeployment'' and ''Redeployment'' are valid.
        pub fn deployment_type(mut self, input: crate::model::DeploymentType) -> Self {
            self.deployment_type = Some(input);
            self
        }
        /// The type of deployment. When used for ''CreateDeployment'', only ''NewDeployment'' and ''Redeployment'' are valid.
        pub fn set_deployment_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentType>,
        ) -> Self {
            self.deployment_type = input;
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// The ID of the group version to be deployed.
        pub fn group_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_version_id = Some(input.into());
            self
        }
        /// The ID of the group version to be deployed.
        pub fn set_group_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentInput {
                amzn_client_token: self.amzn_client_token,
                deployment_id: self.deployment_id,
                deployment_type: self.deployment_type,
                group_id: self.group_id,
                group_version_id: self.group_version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentInputOperationOutputAlias = crate::operation::CreateDeployment;
#[doc(hidden)]
pub type CreateDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeployment`](crate::operation::CreateDeployment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.group_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_12, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/deployments",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateDeploymentInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_13) = &_input.amzn_client_token {
                let formatted_14 = AsRef::<str>::as_ref(inner_13);
                if !formatted_14.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_14;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_deployment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeployment",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentInput`](crate::input::CreateDeploymentInput)
    pub fn builder() -> crate::input::create_deployment_input::Builder {
        crate::input::create_deployment_input::Builder::default()
    }
}

/// See [`CreateDeviceDefinitionInput`](crate::input::CreateDeviceDefinitionInput)
pub mod create_device_definition_input {
    /// A builder for [`CreateDeviceDefinitionInput`](crate::input::CreateDeviceDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) initial_version: std::option::Option<crate::model::DeviceDefinitionVersion>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// Information about the initial version of the device definition.
        pub fn initial_version(mut self, input: crate::model::DeviceDefinitionVersion) -> Self {
            self.initial_version = Some(input);
            self
        }
        /// Information about the initial version of the device definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::DeviceDefinitionVersion>,
        ) -> Self {
            self.initial_version = input;
            self
        }
        /// The name of the device definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the device definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeviceDefinitionInput`](crate::input::CreateDeviceDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeviceDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeviceDefinitionInput {
                amzn_client_token: self.amzn_client_token,
                initial_version: self.initial_version,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeviceDefinitionInputOperationOutputAlias = crate::operation::CreateDeviceDefinition;
#[doc(hidden)]
pub type CreateDeviceDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDeviceDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeviceDefinition`](crate::operation::CreateDeviceDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeviceDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeviceDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/devices").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateDeviceDefinitionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_15) = &_input.amzn_client_token {
                let formatted_16 = AsRef::<str>::as_ref(inner_15);
                if !formatted_16.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_16;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeviceDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeviceDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_device_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeviceDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeviceDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeviceDefinitionInput`](crate::input::CreateDeviceDefinitionInput)
    pub fn builder() -> crate::input::create_device_definition_input::Builder {
        crate::input::create_device_definition_input::Builder::default()
    }
}

/// See [`CreateDeviceDefinitionVersionInput`](crate::input::CreateDeviceDefinitionVersionInput)
pub mod create_device_definition_version_input {
    /// A builder for [`CreateDeviceDefinitionVersionInput`](crate::input::CreateDeviceDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) device_definition_id: std::option::Option<std::string::String>,
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_definition_id = Some(input.into());
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_definition_id = input;
            self
        }
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// A list of devices in the definition version.
        pub fn devices(mut self, input: impl Into<crate::model::Device>) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input.into());
            self.devices = Some(v);
            self
        }
        /// A list of devices in the definition version.
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Device>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeviceDefinitionVersionInput`](crate::input::CreateDeviceDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeviceDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeviceDefinitionVersionInput {
                amzn_client_token: self.amzn_client_token,
                device_definition_id: self.device_definition_id,
                devices: self.devices,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeviceDefinitionVersionInputOperationOutputAlias =
    crate::operation::CreateDeviceDefinitionVersion;
#[doc(hidden)]
pub type CreateDeviceDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDeviceDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeviceDefinitionVersion`](crate::operation::CreateDeviceDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeviceDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeviceDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.device_definition_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_definition_id = aws_smithy_http::label::fmt_string(input_17, false);
            if device_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/devices/{DeviceDefinitionId}/versions",
                DeviceDefinitionId = device_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateDeviceDefinitionVersionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_18) = &_input.amzn_client_token {
                let formatted_19 = AsRef::<str>::as_ref(inner_18);
                if !formatted_19.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_19;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeviceDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeviceDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_device_definition_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeviceDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeviceDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeviceDefinitionVersionInput`](crate::input::CreateDeviceDefinitionVersionInput)
    pub fn builder() -> crate::input::create_device_definition_version_input::Builder {
        crate::input::create_device_definition_version_input::Builder::default()
    }
}

/// See [`CreateFunctionDefinitionInput`](crate::input::CreateFunctionDefinitionInput)
pub mod create_function_definition_input {
    /// A builder for [`CreateFunctionDefinitionInput`](crate::input::CreateFunctionDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) initial_version: std::option::Option<crate::model::FunctionDefinitionVersion>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// Information about the initial version of the function definition.
        pub fn initial_version(mut self, input: crate::model::FunctionDefinitionVersion) -> Self {
            self.initial_version = Some(input);
            self
        }
        /// Information about the initial version of the function definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::FunctionDefinitionVersion>,
        ) -> Self {
            self.initial_version = input;
            self
        }
        /// The name of the function definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the function definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFunctionDefinitionInput`](crate::input::CreateFunctionDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFunctionDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFunctionDefinitionInput {
                amzn_client_token: self.amzn_client_token,
                initial_version: self.initial_version,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFunctionDefinitionInputOperationOutputAlias =
    crate::operation::CreateFunctionDefinition;
#[doc(hidden)]
pub type CreateFunctionDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFunctionDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateFunctionDefinition`](crate::operation::CreateFunctionDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFunctionDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFunctionDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/functions").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateFunctionDefinitionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_20) = &_input.amzn_client_token {
                let formatted_21 = AsRef::<str>::as_ref(inner_20);
                if !formatted_21.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_21;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFunctionDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFunctionDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_function_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFunctionDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFunctionDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFunctionDefinitionInput`](crate::input::CreateFunctionDefinitionInput)
    pub fn builder() -> crate::input::create_function_definition_input::Builder {
        crate::input::create_function_definition_input::Builder::default()
    }
}

/// See [`CreateFunctionDefinitionVersionInput`](crate::input::CreateFunctionDefinitionVersionInput)
pub mod create_function_definition_version_input {
    /// A builder for [`CreateFunctionDefinitionVersionInput`](crate::input::CreateFunctionDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) default_config: std::option::Option<crate::model::FunctionDefaultConfig>,
        pub(crate) function_definition_id: std::option::Option<std::string::String>,
        pub(crate) functions: std::option::Option<std::vec::Vec<crate::model::Function>>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The default configuration that applies to all Lambda functions in this function definition version. Individual Lambda functions can override these settings.
        pub fn default_config(mut self, input: crate::model::FunctionDefaultConfig) -> Self {
            self.default_config = Some(input);
            self
        }
        /// The default configuration that applies to all Lambda functions in this function definition version. Individual Lambda functions can override these settings.
        pub fn set_default_config(
            mut self,
            input: std::option::Option<crate::model::FunctionDefaultConfig>,
        ) -> Self {
            self.default_config = input;
            self
        }
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_definition_id = Some(input.into());
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_definition_id = input;
            self
        }
        /// Appends an item to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// A list of Lambda functions in this function definition version.
        pub fn functions(mut self, input: impl Into<crate::model::Function>) -> Self {
            let mut v = self.functions.unwrap_or_default();
            v.push(input.into());
            self.functions = Some(v);
            self
        }
        /// A list of Lambda functions in this function definition version.
        pub fn set_functions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Function>>,
        ) -> Self {
            self.functions = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFunctionDefinitionVersionInput`](crate::input::CreateFunctionDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFunctionDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFunctionDefinitionVersionInput {
                amzn_client_token: self.amzn_client_token,
                default_config: self.default_config,
                function_definition_id: self.function_definition_id,
                functions: self.functions,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFunctionDefinitionVersionInputOperationOutputAlias =
    crate::operation::CreateFunctionDefinitionVersion;
#[doc(hidden)]
pub type CreateFunctionDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFunctionDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateFunctionDefinitionVersion`](crate::operation::CreateFunctionDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFunctionDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFunctionDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.function_definition_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let function_definition_id = aws_smithy_http::label::fmt_string(input_22, false);
            if function_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "function_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/functions/{FunctionDefinitionId}/versions",
                FunctionDefinitionId = function_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateFunctionDefinitionVersionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_23) = &_input.amzn_client_token {
                let formatted_24 = AsRef::<str>::as_ref(inner_23);
                if !formatted_24.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_24;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFunctionDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFunctionDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_function_definition_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFunctionDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFunctionDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFunctionDefinitionVersionInput`](crate::input::CreateFunctionDefinitionVersionInput)
    pub fn builder() -> crate::input::create_function_definition_version_input::Builder {
        crate::input::create_function_definition_version_input::Builder::default()
    }
}

/// See [`CreateGroupInput`](crate::input::CreateGroupInput)
pub mod create_group_input {
    /// A builder for [`CreateGroupInput`](crate::input::CreateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) initial_version: std::option::Option<crate::model::GroupVersion>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// Information about the initial version of the group.
        pub fn initial_version(mut self, input: crate::model::GroupVersion) -> Self {
            self.initial_version = Some(input);
            self
        }
        /// Information about the initial version of the group.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::GroupVersion>,
        ) -> Self {
            self.initial_version = input;
            self
        }
        /// The name of the group.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the group.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupInput`](crate::input::CreateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGroupInput {
                amzn_client_token: self.amzn_client_token,
                initial_version: self.initial_version,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGroupInputOperationOutputAlias = crate::operation::CreateGroup;
#[doc(hidden)]
pub type CreateGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateGroup`](crate::operation::CreateGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/groups").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateGroupInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_25) = &_input.amzn_client_token {
                let formatted_26 = AsRef::<str>::as_ref(inner_25);
                if !formatted_26.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_26;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_group(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGroup",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
}

/// See [`CreateGroupCertificateAuthorityInput`](crate::input::CreateGroupCertificateAuthorityInput)
pub mod create_group_certificate_authority_input {
    /// A builder for [`CreateGroupCertificateAuthorityInput`](crate::input::CreateGroupCertificateAuthorityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupCertificateAuthorityInput`](crate::input::CreateGroupCertificateAuthorityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGroupCertificateAuthorityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGroupCertificateAuthorityInput {
                amzn_client_token: self.amzn_client_token,
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGroupCertificateAuthorityInputOperationOutputAlias =
    crate::operation::CreateGroupCertificateAuthority;
#[doc(hidden)]
pub type CreateGroupCertificateAuthorityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGroupCertificateAuthorityInput {
    /// Consumes the builder and constructs an Operation<[`CreateGroupCertificateAuthority`](crate::operation::CreateGroupCertificateAuthority)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGroupCertificateAuthority,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGroupCertificateAuthorityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.group_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_27, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/certificateauthorities",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateGroupCertificateAuthorityInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_28) = &_input.amzn_client_token {
                let formatted_29 = AsRef::<str>::as_ref(inner_28);
                if !formatted_29.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_29;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGroupCertificateAuthorityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGroupCertificateAuthorityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGroupCertificateAuthority::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGroupCertificateAuthority",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGroupCertificateAuthorityInput`](crate::input::CreateGroupCertificateAuthorityInput)
    pub fn builder() -> crate::input::create_group_certificate_authority_input::Builder {
        crate::input::create_group_certificate_authority_input::Builder::default()
    }
}

/// See [`CreateGroupVersionInput`](crate::input::CreateGroupVersionInput)
pub mod create_group_version_input {
    /// A builder for [`CreateGroupVersionInput`](crate::input::CreateGroupVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) connector_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) core_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) device_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) function_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) logger_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) resource_definition_version_arn: std::option::Option<std::string::String>,
        pub(crate) subscription_definition_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The ARN of the connector definition version for this group.
        pub fn connector_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.connector_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the connector definition version for this group.
        pub fn set_connector_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_definition_version_arn = input;
            self
        }
        /// The ARN of the core definition version for this group.
        pub fn core_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.core_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the core definition version for this group.
        pub fn set_core_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_definition_version_arn = input;
            self
        }
        /// The ARN of the device definition version for this group.
        pub fn device_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.device_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the device definition version for this group.
        pub fn set_device_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_definition_version_arn = input;
            self
        }
        /// The ARN of the function definition version for this group.
        pub fn function_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.function_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the function definition version for this group.
        pub fn set_function_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_definition_version_arn = input;
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// The ARN of the logger definition version for this group.
        pub fn logger_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.logger_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the logger definition version for this group.
        pub fn set_logger_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logger_definition_version_arn = input;
            self
        }
        /// The ARN of the resource definition version for this group.
        pub fn resource_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resource_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the resource definition version for this group.
        pub fn set_resource_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_definition_version_arn = input;
            self
        }
        /// The ARN of the subscription definition version for this group.
        pub fn subscription_definition_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.subscription_definition_version_arn = Some(input.into());
            self
        }
        /// The ARN of the subscription definition version for this group.
        pub fn set_subscription_definition_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_definition_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupVersionInput`](crate::input::CreateGroupVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGroupVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGroupVersionInput {
                amzn_client_token: self.amzn_client_token,
                connector_definition_version_arn: self.connector_definition_version_arn,
                core_definition_version_arn: self.core_definition_version_arn,
                device_definition_version_arn: self.device_definition_version_arn,
                function_definition_version_arn: self.function_definition_version_arn,
                group_id: self.group_id,
                logger_definition_version_arn: self.logger_definition_version_arn,
                resource_definition_version_arn: self.resource_definition_version_arn,
                subscription_definition_version_arn: self.subscription_definition_version_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGroupVersionInputOperationOutputAlias = crate::operation::CreateGroupVersion;
#[doc(hidden)]
pub type CreateGroupVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGroupVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateGroupVersion`](crate::operation::CreateGroupVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGroupVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGroupVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.group_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_30, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/versions",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateGroupVersionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_31) = &_input.amzn_client_token {
                let formatted_32 = AsRef::<str>::as_ref(inner_31);
                if !formatted_32.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_32;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGroupVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGroupVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_group_version(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGroupVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGroupVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGroupVersionInput`](crate::input::CreateGroupVersionInput)
    pub fn builder() -> crate::input::create_group_version_input::Builder {
        crate::input::create_group_version_input::Builder::default()
    }
}

/// See [`CreateLoggerDefinitionInput`](crate::input::CreateLoggerDefinitionInput)
pub mod create_logger_definition_input {
    /// A builder for [`CreateLoggerDefinitionInput`](crate::input::CreateLoggerDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) initial_version: std::option::Option<crate::model::LoggerDefinitionVersion>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// Information about the initial version of the logger definition.
        pub fn initial_version(mut self, input: crate::model::LoggerDefinitionVersion) -> Self {
            self.initial_version = Some(input);
            self
        }
        /// Information about the initial version of the logger definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::LoggerDefinitionVersion>,
        ) -> Self {
            self.initial_version = input;
            self
        }
        /// The name of the logger definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the logger definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoggerDefinitionInput`](crate::input::CreateLoggerDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLoggerDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLoggerDefinitionInput {
                amzn_client_token: self.amzn_client_token,
                initial_version: self.initial_version,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLoggerDefinitionInputOperationOutputAlias = crate::operation::CreateLoggerDefinition;
#[doc(hidden)]
pub type CreateLoggerDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLoggerDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateLoggerDefinition`](crate::operation::CreateLoggerDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLoggerDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLoggerDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/loggers").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateLoggerDefinitionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_33) = &_input.amzn_client_token {
                let formatted_34 = AsRef::<str>::as_ref(inner_33);
                if !formatted_34.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_34;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLoggerDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLoggerDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_logger_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLoggerDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLoggerDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLoggerDefinitionInput`](crate::input::CreateLoggerDefinitionInput)
    pub fn builder() -> crate::input::create_logger_definition_input::Builder {
        crate::input::create_logger_definition_input::Builder::default()
    }
}

/// See [`CreateLoggerDefinitionVersionInput`](crate::input::CreateLoggerDefinitionVersionInput)
pub mod create_logger_definition_version_input {
    /// A builder for [`CreateLoggerDefinitionVersionInput`](crate::input::CreateLoggerDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) logger_definition_id: std::option::Option<std::string::String>,
        pub(crate) loggers: std::option::Option<std::vec::Vec<crate::model::Logger>>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logger_definition_id = Some(input.into());
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logger_definition_id = input;
            self
        }
        /// Appends an item to `loggers`.
        ///
        /// To override the contents of this collection use [`set_loggers`](Self::set_loggers).
        ///
        /// A list of loggers.
        pub fn loggers(mut self, input: impl Into<crate::model::Logger>) -> Self {
            let mut v = self.loggers.unwrap_or_default();
            v.push(input.into());
            self.loggers = Some(v);
            self
        }
        /// A list of loggers.
        pub fn set_loggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Logger>>,
        ) -> Self {
            self.loggers = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoggerDefinitionVersionInput`](crate::input::CreateLoggerDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLoggerDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLoggerDefinitionVersionInput {
                amzn_client_token: self.amzn_client_token,
                logger_definition_id: self.logger_definition_id,
                loggers: self.loggers,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLoggerDefinitionVersionInputOperationOutputAlias =
    crate::operation::CreateLoggerDefinitionVersion;
#[doc(hidden)]
pub type CreateLoggerDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLoggerDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateLoggerDefinitionVersion`](crate::operation::CreateLoggerDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLoggerDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLoggerDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.logger_definition_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "logger_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let logger_definition_id = aws_smithy_http::label::fmt_string(input_35, false);
            if logger_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "logger_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/loggers/{LoggerDefinitionId}/versions",
                LoggerDefinitionId = logger_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateLoggerDefinitionVersionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_36) = &_input.amzn_client_token {
                let formatted_37 = AsRef::<str>::as_ref(inner_36);
                if !formatted_37.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_37;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLoggerDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLoggerDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_logger_definition_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLoggerDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLoggerDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLoggerDefinitionVersionInput`](crate::input::CreateLoggerDefinitionVersionInput)
    pub fn builder() -> crate::input::create_logger_definition_version_input::Builder {
        crate::input::create_logger_definition_version_input::Builder::default()
    }
}

/// See [`CreateResourceDefinitionInput`](crate::input::CreateResourceDefinitionInput)
pub mod create_resource_definition_input {
    /// A builder for [`CreateResourceDefinitionInput`](crate::input::CreateResourceDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) initial_version: std::option::Option<crate::model::ResourceDefinitionVersion>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// Information about the initial version of the resource definition.
        pub fn initial_version(mut self, input: crate::model::ResourceDefinitionVersion) -> Self {
            self.initial_version = Some(input);
            self
        }
        /// Information about the initial version of the resource definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::ResourceDefinitionVersion>,
        ) -> Self {
            self.initial_version = input;
            self
        }
        /// The name of the resource definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the resource definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceDefinitionInput`](crate::input::CreateResourceDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourceDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourceDefinitionInput {
                amzn_client_token: self.amzn_client_token,
                initial_version: self.initial_version,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourceDefinitionInputOperationOutputAlias =
    crate::operation::CreateResourceDefinition;
#[doc(hidden)]
pub type CreateResourceDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResourceDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateResourceDefinition`](crate::operation::CreateResourceDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResourceDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResourceDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/resources").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateResourceDefinitionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_38) = &_input.amzn_client_token {
                let formatted_39 = AsRef::<str>::as_ref(inner_38);
                if !formatted_39.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_39;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResourceDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResourceDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_resource_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResourceDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResourceDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResourceDefinitionInput`](crate::input::CreateResourceDefinitionInput)
    pub fn builder() -> crate::input::create_resource_definition_input::Builder {
        crate::input::create_resource_definition_input::Builder::default()
    }
}

/// See [`CreateResourceDefinitionVersionInput`](crate::input::CreateResourceDefinitionVersionInput)
pub mod create_resource_definition_version_input {
    /// A builder for [`CreateResourceDefinitionVersionInput`](crate::input::CreateResourceDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) resource_definition_id: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_definition_id = Some(input.into());
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_definition_id = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// A list of resources.
        pub fn resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// A list of resources.
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceDefinitionVersionInput`](crate::input::CreateResourceDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourceDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourceDefinitionVersionInput {
                amzn_client_token: self.amzn_client_token,
                resource_definition_id: self.resource_definition_id,
                resources: self.resources,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourceDefinitionVersionInputOperationOutputAlias =
    crate::operation::CreateResourceDefinitionVersion;
#[doc(hidden)]
pub type CreateResourceDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResourceDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateResourceDefinitionVersion`](crate::operation::CreateResourceDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResourceDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResourceDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_40 = &_input.resource_definition_id;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_definition_id = aws_smithy_http::label::fmt_string(input_40, false);
            if resource_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/resources/{ResourceDefinitionId}/versions",
                ResourceDefinitionId = resource_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateResourceDefinitionVersionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_41) = &_input.amzn_client_token {
                let formatted_42 = AsRef::<str>::as_ref(inner_41);
                if !formatted_42.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_42;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResourceDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResourceDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_resource_definition_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResourceDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResourceDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResourceDefinitionVersionInput`](crate::input::CreateResourceDefinitionVersionInput)
    pub fn builder() -> crate::input::create_resource_definition_version_input::Builder {
        crate::input::create_resource_definition_version_input::Builder::default()
    }
}

/// See [`CreateSoftwareUpdateJobInput`](crate::input::CreateSoftwareUpdateJobInput)
pub mod create_software_update_job_input {
    /// A builder for [`CreateSoftwareUpdateJobInput`](crate::input::CreateSoftwareUpdateJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) s3_url_signer_role: std::option::Option<std::string::String>,
        pub(crate) software_to_update: std::option::Option<crate::model::SoftwareToUpdate>,
        pub(crate) update_agent_log_level: std::option::Option<crate::model::UpdateAgentLogLevel>,
        pub(crate) update_targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) update_targets_architecture:
            std::option::Option<crate::model::UpdateTargetsArchitecture>,
        pub(crate) update_targets_operating_system:
            std::option::Option<crate::model::UpdateTargetsOperatingSystem>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The IAM Role that Greengrass will use to create pre-signed URLs pointing towards the update artifact.
        pub fn s3_url_signer_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_url_signer_role = Some(input.into());
            self
        }
        /// The IAM Role that Greengrass will use to create pre-signed URLs pointing towards the update artifact.
        pub fn set_s3_url_signer_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_url_signer_role = input;
            self
        }
        /// The piece of software on the Greengrass core that will be updated.
        pub fn software_to_update(mut self, input: crate::model::SoftwareToUpdate) -> Self {
            self.software_to_update = Some(input);
            self
        }
        /// The piece of software on the Greengrass core that will be updated.
        pub fn set_software_to_update(
            mut self,
            input: std::option::Option<crate::model::SoftwareToUpdate>,
        ) -> Self {
            self.software_to_update = input;
            self
        }
        /// The minimum level of log statements that should be logged by the OTA Agent during an update.
        pub fn update_agent_log_level(mut self, input: crate::model::UpdateAgentLogLevel) -> Self {
            self.update_agent_log_level = Some(input);
            self
        }
        /// The minimum level of log statements that should be logged by the OTA Agent during an update.
        pub fn set_update_agent_log_level(
            mut self,
            input: std::option::Option<crate::model::UpdateAgentLogLevel>,
        ) -> Self {
            self.update_agent_log_level = input;
            self
        }
        /// Appends an item to `update_targets`.
        ///
        /// To override the contents of this collection use [`set_update_targets`](Self::set_update_targets).
        ///
        /// The ARNs of the targets (IoT things or IoT thing groups) that this update will be applied to.
        pub fn update_targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.update_targets.unwrap_or_default();
            v.push(input.into());
            self.update_targets = Some(v);
            self
        }
        /// The ARNs of the targets (IoT things or IoT thing groups) that this update will be applied to.
        pub fn set_update_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.update_targets = input;
            self
        }
        /// The architecture of the cores which are the targets of an update.
        pub fn update_targets_architecture(
            mut self,
            input: crate::model::UpdateTargetsArchitecture,
        ) -> Self {
            self.update_targets_architecture = Some(input);
            self
        }
        /// The architecture of the cores which are the targets of an update.
        pub fn set_update_targets_architecture(
            mut self,
            input: std::option::Option<crate::model::UpdateTargetsArchitecture>,
        ) -> Self {
            self.update_targets_architecture = input;
            self
        }
        /// The operating system of the cores which are the targets of an update.
        pub fn update_targets_operating_system(
            mut self,
            input: crate::model::UpdateTargetsOperatingSystem,
        ) -> Self {
            self.update_targets_operating_system = Some(input);
            self
        }
        /// The operating system of the cores which are the targets of an update.
        pub fn set_update_targets_operating_system(
            mut self,
            input: std::option::Option<crate::model::UpdateTargetsOperatingSystem>,
        ) -> Self {
            self.update_targets_operating_system = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSoftwareUpdateJobInput`](crate::input::CreateSoftwareUpdateJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSoftwareUpdateJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSoftwareUpdateJobInput {
                amzn_client_token: self.amzn_client_token,
                s3_url_signer_role: self.s3_url_signer_role,
                software_to_update: self.software_to_update,
                update_agent_log_level: self.update_agent_log_level,
                update_targets: self.update_targets,
                update_targets_architecture: self.update_targets_architecture,
                update_targets_operating_system: self.update_targets_operating_system,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSoftwareUpdateJobInputOperationOutputAlias =
    crate::operation::CreateSoftwareUpdateJob;
#[doc(hidden)]
pub type CreateSoftwareUpdateJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSoftwareUpdateJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateSoftwareUpdateJob`](crate::operation::CreateSoftwareUpdateJob)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSoftwareUpdateJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSoftwareUpdateJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/updates").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateSoftwareUpdateJobInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_43) = &_input.amzn_client_token {
                let formatted_44 = AsRef::<str>::as_ref(inner_43);
                if !formatted_44.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_44;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSoftwareUpdateJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSoftwareUpdateJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_software_update_job(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSoftwareUpdateJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSoftwareUpdateJob",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSoftwareUpdateJobInput`](crate::input::CreateSoftwareUpdateJobInput)
    pub fn builder() -> crate::input::create_software_update_job_input::Builder {
        crate::input::create_software_update_job_input::Builder::default()
    }
}

/// See [`CreateSubscriptionDefinitionInput`](crate::input::CreateSubscriptionDefinitionInput)
pub mod create_subscription_definition_input {
    /// A builder for [`CreateSubscriptionDefinitionInput`](crate::input::CreateSubscriptionDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) initial_version:
            std::option::Option<crate::model::SubscriptionDefinitionVersion>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// Information about the initial version of the subscription definition.
        pub fn initial_version(
            mut self,
            input: crate::model::SubscriptionDefinitionVersion,
        ) -> Self {
            self.initial_version = Some(input);
            self
        }
        /// Information about the initial version of the subscription definition.
        pub fn set_initial_version(
            mut self,
            input: std::option::Option<crate::model::SubscriptionDefinitionVersion>,
        ) -> Self {
            self.initial_version = input;
            self
        }
        /// The name of the subscription definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the subscription definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSubscriptionDefinitionInput`](crate::input::CreateSubscriptionDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSubscriptionDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSubscriptionDefinitionInput {
                amzn_client_token: self.amzn_client_token,
                initial_version: self.initial_version,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSubscriptionDefinitionInputOperationOutputAlias =
    crate::operation::CreateSubscriptionDefinition;
#[doc(hidden)]
pub type CreateSubscriptionDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSubscriptionDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateSubscriptionDefinition`](crate::operation::CreateSubscriptionDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSubscriptionDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSubscriptionDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/subscriptions")
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateSubscriptionDefinitionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_45) = &_input.amzn_client_token {
                let formatted_46 = AsRef::<str>::as_ref(inner_45);
                if !formatted_46.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_46;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSubscriptionDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSubscriptionDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_subscription_definition(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSubscriptionDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSubscriptionDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSubscriptionDefinitionInput`](crate::input::CreateSubscriptionDefinitionInput)
    pub fn builder() -> crate::input::create_subscription_definition_input::Builder {
        crate::input::create_subscription_definition_input::Builder::default()
    }
}

/// See [`CreateSubscriptionDefinitionVersionInput`](crate::input::CreateSubscriptionDefinitionVersionInput)
pub mod create_subscription_definition_version_input {
    /// A builder for [`CreateSubscriptionDefinitionVersionInput`](crate::input::CreateSubscriptionDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) subscription_definition_id: std::option::Option<std::string::String>,
        pub(crate) subscriptions: std::option::Option<std::vec::Vec<crate::model::Subscription>>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_definition_id = Some(input.into());
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_definition_id = input;
            self
        }
        /// Appends an item to `subscriptions`.
        ///
        /// To override the contents of this collection use [`set_subscriptions`](Self::set_subscriptions).
        ///
        /// A list of subscriptions.
        pub fn subscriptions(mut self, input: impl Into<crate::model::Subscription>) -> Self {
            let mut v = self.subscriptions.unwrap_or_default();
            v.push(input.into());
            self.subscriptions = Some(v);
            self
        }
        /// A list of subscriptions.
        pub fn set_subscriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscription>>,
        ) -> Self {
            self.subscriptions = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSubscriptionDefinitionVersionInput`](crate::input::CreateSubscriptionDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSubscriptionDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSubscriptionDefinitionVersionInput {
                amzn_client_token: self.amzn_client_token,
                subscription_definition_id: self.subscription_definition_id,
                subscriptions: self.subscriptions,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSubscriptionDefinitionVersionInputOperationOutputAlias =
    crate::operation::CreateSubscriptionDefinitionVersion;
#[doc(hidden)]
pub type CreateSubscriptionDefinitionVersionInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateSubscriptionDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateSubscriptionDefinitionVersion`](crate::operation::CreateSubscriptionDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSubscriptionDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSubscriptionDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.subscription_definition_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscription_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let subscription_definition_id = aws_smithy_http::label::fmt_string(input_47, false);
            if subscription_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "subscription_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}/versions",
                SubscriptionDefinitionId = subscription_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateSubscriptionDefinitionVersionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_48) = &_input.amzn_client_token {
                let formatted_49 = AsRef::<str>::as_ref(inner_48);
                if !formatted_49.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_49;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSubscriptionDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSubscriptionDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_subscription_definition_version(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSubscriptionDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSubscriptionDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSubscriptionDefinitionVersionInput`](crate::input::CreateSubscriptionDefinitionVersionInput)
    pub fn builder() -> crate::input::create_subscription_definition_version_input::Builder {
        crate::input::create_subscription_definition_version_input::Builder::default()
    }
}

/// See [`DeleteConnectorDefinitionInput`](crate::input::DeleteConnectorDefinitionInput)
pub mod delete_connector_definition_input {
    /// A builder for [`DeleteConnectorDefinitionInput`](crate::input::DeleteConnectorDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_definition_id = Some(input.into());
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectorDefinitionInput`](crate::input::DeleteConnectorDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConnectorDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConnectorDefinitionInput {
                connector_definition_id: self.connector_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConnectorDefinitionInputOperationOutputAlias =
    crate::operation::DeleteConnectorDefinition;
#[doc(hidden)]
pub type DeleteConnectorDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConnectorDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConnectorDefinition`](crate::operation::DeleteConnectorDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConnectorDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConnectorDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.connector_definition_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connector_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let connector_definition_id = aws_smithy_http::label::fmt_string(input_50, false);
            if connector_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connector_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/connectors/{ConnectorDefinitionId}",
                ConnectorDefinitionId = connector_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConnectorDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConnectorDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConnectorDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConnectorDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConnectorDefinitionInput`](crate::input::DeleteConnectorDefinitionInput)
    pub fn builder() -> crate::input::delete_connector_definition_input::Builder {
        crate::input::delete_connector_definition_input::Builder::default()
    }
}

/// See [`DeleteCoreDefinitionInput`](crate::input::DeleteCoreDefinitionInput)
pub mod delete_core_definition_input {
    /// A builder for [`DeleteCoreDefinitionInput`](crate::input::DeleteCoreDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_definition_id = Some(input.into());
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCoreDefinitionInput`](crate::input::DeleteCoreDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCoreDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCoreDefinitionInput {
                core_definition_id: self.core_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCoreDefinitionInputOperationOutputAlias = crate::operation::DeleteCoreDefinition;
#[doc(hidden)]
pub type DeleteCoreDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCoreDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCoreDefinition`](crate::operation::DeleteCoreDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCoreDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCoreDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.core_definition_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let core_definition_id = aws_smithy_http::label::fmt_string(input_51, false);
            if core_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/cores/{CoreDefinitionId}",
                CoreDefinitionId = core_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCoreDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCoreDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCoreDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCoreDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCoreDefinitionInput`](crate::input::DeleteCoreDefinitionInput)
    pub fn builder() -> crate::input::delete_core_definition_input::Builder {
        crate::input::delete_core_definition_input::Builder::default()
    }
}

/// See [`DeleteDeviceDefinitionInput`](crate::input::DeleteDeviceDefinitionInput)
pub mod delete_device_definition_input {
    /// A builder for [`DeleteDeviceDefinitionInput`](crate::input::DeleteDeviceDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_definition_id = Some(input.into());
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeviceDefinitionInput`](crate::input::DeleteDeviceDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeviceDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeviceDefinitionInput {
                device_definition_id: self.device_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeviceDefinitionInputOperationOutputAlias = crate::operation::DeleteDeviceDefinition;
#[doc(hidden)]
pub type DeleteDeviceDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDeviceDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeviceDefinition`](crate::operation::DeleteDeviceDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeviceDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeviceDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.device_definition_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_definition_id = aws_smithy_http::label::fmt_string(input_52, false);
            if device_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/devices/{DeviceDefinitionId}",
                DeviceDefinitionId = device_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeviceDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeviceDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeviceDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeviceDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeviceDefinitionInput`](crate::input::DeleteDeviceDefinitionInput)
    pub fn builder() -> crate::input::delete_device_definition_input::Builder {
        crate::input::delete_device_definition_input::Builder::default()
    }
}

/// See [`DeleteFunctionDefinitionInput`](crate::input::DeleteFunctionDefinitionInput)
pub mod delete_function_definition_input {
    /// A builder for [`DeleteFunctionDefinitionInput`](crate::input::DeleteFunctionDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_definition_id = Some(input.into());
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFunctionDefinitionInput`](crate::input::DeleteFunctionDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFunctionDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFunctionDefinitionInput {
                function_definition_id: self.function_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFunctionDefinitionInputOperationOutputAlias =
    crate::operation::DeleteFunctionDefinition;
#[doc(hidden)]
pub type DeleteFunctionDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFunctionDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFunctionDefinition`](crate::operation::DeleteFunctionDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFunctionDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFunctionDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.function_definition_id;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let function_definition_id = aws_smithy_http::label::fmt_string(input_53, false);
            if function_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "function_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/functions/{FunctionDefinitionId}",
                FunctionDefinitionId = function_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFunctionDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFunctionDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFunctionDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFunctionDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFunctionDefinitionInput`](crate::input::DeleteFunctionDefinitionInput)
    pub fn builder() -> crate::input::delete_function_definition_input::Builder {
        crate::input::delete_function_definition_input::Builder::default()
    }
}

/// See [`DeleteGroupInput`](crate::input::DeleteGroupInput)
pub mod delete_group_input {
    /// A builder for [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupInput`](crate::input::DeleteGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGroupInput {
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGroupInputOperationOutputAlias = crate::operation::DeleteGroup;
#[doc(hidden)]
pub type DeleteGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGroup`](crate::operation::DeleteGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_54 = &_input.group_id;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_54, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/groups/{GroupId}", GroupId = group_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGroup",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
}

/// See [`DeleteLoggerDefinitionInput`](crate::input::DeleteLoggerDefinitionInput)
pub mod delete_logger_definition_input {
    /// A builder for [`DeleteLoggerDefinitionInput`](crate::input::DeleteLoggerDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logger_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logger_definition_id = Some(input.into());
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logger_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLoggerDefinitionInput`](crate::input::DeleteLoggerDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLoggerDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLoggerDefinitionInput {
                logger_definition_id: self.logger_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLoggerDefinitionInputOperationOutputAlias = crate::operation::DeleteLoggerDefinition;
#[doc(hidden)]
pub type DeleteLoggerDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLoggerDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLoggerDefinition`](crate::operation::DeleteLoggerDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLoggerDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLoggerDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.logger_definition_id;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "logger_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let logger_definition_id = aws_smithy_http::label::fmt_string(input_55, false);
            if logger_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "logger_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/loggers/{LoggerDefinitionId}",
                LoggerDefinitionId = logger_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLoggerDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLoggerDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLoggerDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLoggerDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLoggerDefinitionInput`](crate::input::DeleteLoggerDefinitionInput)
    pub fn builder() -> crate::input::delete_logger_definition_input::Builder {
        crate::input::delete_logger_definition_input::Builder::default()
    }
}

/// See [`DeleteResourceDefinitionInput`](crate::input::DeleteResourceDefinitionInput)
pub mod delete_resource_definition_input {
    /// A builder for [`DeleteResourceDefinitionInput`](crate::input::DeleteResourceDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_definition_id = Some(input.into());
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourceDefinitionInput`](crate::input::DeleteResourceDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourceDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourceDefinitionInput {
                resource_definition_id: self.resource_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourceDefinitionInputOperationOutputAlias =
    crate::operation::DeleteResourceDefinition;
#[doc(hidden)]
pub type DeleteResourceDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResourceDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourceDefinition`](crate::operation::DeleteResourceDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourceDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourceDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_56 = &_input.resource_definition_id;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_definition_id = aws_smithy_http::label::fmt_string(input_56, false);
            if resource_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/resources/{ResourceDefinitionId}",
                ResourceDefinitionId = resource_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourceDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourceDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourceDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourceDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourceDefinitionInput`](crate::input::DeleteResourceDefinitionInput)
    pub fn builder() -> crate::input::delete_resource_definition_input::Builder {
        crate::input::delete_resource_definition_input::Builder::default()
    }
}

/// See [`DeleteSubscriptionDefinitionInput`](crate::input::DeleteSubscriptionDefinitionInput)
pub mod delete_subscription_definition_input {
    /// A builder for [`DeleteSubscriptionDefinitionInput`](crate::input::DeleteSubscriptionDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_definition_id = Some(input.into());
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSubscriptionDefinitionInput`](crate::input::DeleteSubscriptionDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSubscriptionDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSubscriptionDefinitionInput {
                subscription_definition_id: self.subscription_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSubscriptionDefinitionInputOperationOutputAlias =
    crate::operation::DeleteSubscriptionDefinition;
#[doc(hidden)]
pub type DeleteSubscriptionDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSubscriptionDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSubscriptionDefinition`](crate::operation::DeleteSubscriptionDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSubscriptionDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSubscriptionDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_57 = &_input.subscription_definition_id;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscription_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let subscription_definition_id = aws_smithy_http::label::fmt_string(input_57, false);
            if subscription_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "subscription_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}",
                SubscriptionDefinitionId = subscription_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSubscriptionDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSubscriptionDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSubscriptionDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSubscriptionDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSubscriptionDefinitionInput`](crate::input::DeleteSubscriptionDefinitionInput)
    pub fn builder() -> crate::input::delete_subscription_definition_input::Builder {
        crate::input::delete_subscription_definition_input::Builder::default()
    }
}

/// See [`DisassociateRoleFromGroupInput`](crate::input::DisassociateRoleFromGroupInput)
pub mod disassociate_role_from_group_input {
    /// A builder for [`DisassociateRoleFromGroupInput`](crate::input::DisassociateRoleFromGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateRoleFromGroupInput`](crate::input::DisassociateRoleFromGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateRoleFromGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateRoleFromGroupInput {
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateRoleFromGroupInputOperationOutputAlias =
    crate::operation::DisassociateRoleFromGroup;
#[doc(hidden)]
pub type DisassociateRoleFromGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateRoleFromGroupInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateRoleFromGroup`](crate::operation::DisassociateRoleFromGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateRoleFromGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateRoleFromGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_58 = &_input.group_id;
            let input_58 =
                input_58
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_58, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/role",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateRoleFromGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateRoleFromGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateRoleFromGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateRoleFromGroup",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateRoleFromGroupInput`](crate::input::DisassociateRoleFromGroupInput)
    pub fn builder() -> crate::input::disassociate_role_from_group_input::Builder {
        crate::input::disassociate_role_from_group_input::Builder::default()
    }
}

/// See [`DisassociateServiceRoleFromAccountInput`](crate::input::DisassociateServiceRoleFromAccountInput)
pub mod disassociate_service_role_from_account_input {
    /// A builder for [`DisassociateServiceRoleFromAccountInput`](crate::input::DisassociateServiceRoleFromAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateServiceRoleFromAccountInput`](crate::input::DisassociateServiceRoleFromAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateServiceRoleFromAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateServiceRoleFromAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type DisassociateServiceRoleFromAccountInputOperationOutputAlias =
    crate::operation::DisassociateServiceRoleFromAccount;
#[doc(hidden)]
pub type DisassociateServiceRoleFromAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateServiceRoleFromAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateServiceRoleFromAccount`](crate::operation::DisassociateServiceRoleFromAccount)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateServiceRoleFromAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateServiceRoleFromAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/servicerole").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateServiceRoleFromAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateServiceRoleFromAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateServiceRoleFromAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateServiceRoleFromAccount",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateServiceRoleFromAccountInput`](crate::input::DisassociateServiceRoleFromAccountInput)
    pub fn builder() -> crate::input::disassociate_service_role_from_account_input::Builder {
        crate::input::disassociate_service_role_from_account_input::Builder::default()
    }
}

/// See [`GetAssociatedRoleInput`](crate::input::GetAssociatedRoleInput)
pub mod get_associated_role_input {
    /// A builder for [`GetAssociatedRoleInput`](crate::input::GetAssociatedRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssociatedRoleInput`](crate::input::GetAssociatedRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssociatedRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssociatedRoleInput {
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssociatedRoleInputOperationOutputAlias = crate::operation::GetAssociatedRole;
#[doc(hidden)]
pub type GetAssociatedRoleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAssociatedRoleInput {
    /// Consumes the builder and constructs an Operation<[`GetAssociatedRole`](crate::operation::GetAssociatedRole)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssociatedRole,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssociatedRoleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_59 = &_input.group_id;
            let input_59 =
                input_59
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_59, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/role",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssociatedRoleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssociatedRoleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssociatedRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssociatedRole",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssociatedRoleInput`](crate::input::GetAssociatedRoleInput)
    pub fn builder() -> crate::input::get_associated_role_input::Builder {
        crate::input::get_associated_role_input::Builder::default()
    }
}

/// See [`GetBulkDeploymentStatusInput`](crate::input::GetBulkDeploymentStatusInput)
pub mod get_bulk_deployment_status_input {
    /// A builder for [`GetBulkDeploymentStatusInput`](crate::input::GetBulkDeploymentStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bulk_deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the bulk deployment.
        pub fn bulk_deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bulk_deployment_id = Some(input.into());
            self
        }
        /// The ID of the bulk deployment.
        pub fn set_bulk_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bulk_deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBulkDeploymentStatusInput`](crate::input::GetBulkDeploymentStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBulkDeploymentStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBulkDeploymentStatusInput {
                bulk_deployment_id: self.bulk_deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBulkDeploymentStatusInputOperationOutputAlias =
    crate::operation::GetBulkDeploymentStatus;
#[doc(hidden)]
pub type GetBulkDeploymentStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBulkDeploymentStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetBulkDeploymentStatus`](crate::operation::GetBulkDeploymentStatus)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBulkDeploymentStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBulkDeploymentStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_60 = &_input.bulk_deployment_id;
            let input_60 =
                input_60
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bulk_deployment_id",
                        details: "cannot be empty or unset",
                    })?;
            let bulk_deployment_id = aws_smithy_http::label::fmt_string(input_60, false);
            if bulk_deployment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bulk_deployment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/bulk/deployments/{BulkDeploymentId}/status",
                BulkDeploymentId = bulk_deployment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBulkDeploymentStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBulkDeploymentStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBulkDeploymentStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBulkDeploymentStatus",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBulkDeploymentStatusInput`](crate::input::GetBulkDeploymentStatusInput)
    pub fn builder() -> crate::input::get_bulk_deployment_status_input::Builder {
        crate::input::get_bulk_deployment_status_input::Builder::default()
    }
}

/// See [`GetConnectivityInfoInput`](crate::input::GetConnectivityInfoInput)
pub mod get_connectivity_info_input {
    /// A builder for [`GetConnectivityInfoInput`](crate::input::GetConnectivityInfoInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The thing name.
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// The thing name.
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectivityInfoInput`](crate::input::GetConnectivityInfoInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConnectivityInfoInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConnectivityInfoInput {
                thing_name: self.thing_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConnectivityInfoInputOperationOutputAlias = crate::operation::GetConnectivityInfo;
#[doc(hidden)]
pub type GetConnectivityInfoInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetConnectivityInfoInput {
    /// Consumes the builder and constructs an Operation<[`GetConnectivityInfo`](crate::operation::GetConnectivityInfo)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConnectivityInfo,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConnectivityInfoInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_61 = &_input.thing_name;
            let input_61 =
                input_61
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let thing_name = aws_smithy_http::label::fmt_string(input_61, false);
            if thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/things/{ThingName}/connectivityInfo",
                ThingName = thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConnectivityInfoInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConnectivityInfoInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConnectivityInfo::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConnectivityInfo",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConnectivityInfoInput`](crate::input::GetConnectivityInfoInput)
    pub fn builder() -> crate::input::get_connectivity_info_input::Builder {
        crate::input::get_connectivity_info_input::Builder::default()
    }
}

/// See [`GetConnectorDefinitionInput`](crate::input::GetConnectorDefinitionInput)
pub mod get_connector_definition_input {
    /// A builder for [`GetConnectorDefinitionInput`](crate::input::GetConnectorDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_definition_id = Some(input.into());
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectorDefinitionInput`](crate::input::GetConnectorDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConnectorDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConnectorDefinitionInput {
                connector_definition_id: self.connector_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConnectorDefinitionInputOperationOutputAlias = crate::operation::GetConnectorDefinition;
#[doc(hidden)]
pub type GetConnectorDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetConnectorDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`GetConnectorDefinition`](crate::operation::GetConnectorDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConnectorDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConnectorDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_62 = &_input.connector_definition_id;
            let input_62 =
                input_62
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connector_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let connector_definition_id = aws_smithy_http::label::fmt_string(input_62, false);
            if connector_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connector_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/connectors/{ConnectorDefinitionId}",
                ConnectorDefinitionId = connector_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConnectorDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConnectorDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConnectorDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConnectorDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConnectorDefinitionInput`](crate::input::GetConnectorDefinitionInput)
    pub fn builder() -> crate::input::get_connector_definition_input::Builder {
        crate::input::get_connector_definition_input::Builder::default()
    }
}

/// See [`GetConnectorDefinitionVersionInput`](crate::input::GetConnectorDefinitionVersionInput)
pub mod get_connector_definition_version_input {
    /// A builder for [`GetConnectorDefinitionVersionInput`](crate::input::GetConnectorDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_definition_id: std::option::Option<std::string::String>,
        pub(crate) connector_definition_version_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_definition_id = Some(input.into());
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_definition_id = input;
            self
        }
        /// The ID of the connector definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListConnectorDefinitionVersions'' requests. If the version is the last one that was associated with a connector definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn connector_definition_version_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.connector_definition_version_id = Some(input.into());
            self
        }
        /// The ID of the connector definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListConnectorDefinitionVersions'' requests. If the version is the last one that was associated with a connector definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_connector_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_definition_version_id = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectorDefinitionVersionInput`](crate::input::GetConnectorDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetConnectorDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetConnectorDefinitionVersionInput {
                connector_definition_id: self.connector_definition_id,
                connector_definition_version_id: self.connector_definition_version_id,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetConnectorDefinitionVersionInputOperationOutputAlias =
    crate::operation::GetConnectorDefinitionVersion;
#[doc(hidden)]
pub type GetConnectorDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetConnectorDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetConnectorDefinitionVersion`](crate::operation::GetConnectorDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetConnectorDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetConnectorDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_63 = &_input.connector_definition_id;
            let input_63 =
                input_63
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connector_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let connector_definition_id = aws_smithy_http::label::fmt_string(input_63, false);
            if connector_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connector_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_64 = &_input.connector_definition_version_id;
            let input_64 =
                input_64
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connector_definition_version_id",
                        details: "cannot be empty or unset",
                    })?;
            let connector_definition_version_id =
                aws_smithy_http::label::fmt_string(input_64, false);
            if connector_definition_version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connector_definition_version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/definition/connectors/{ConnectorDefinitionId}/versions/{ConnectorDefinitionVersionId}", ConnectorDefinitionId = connector_definition_id, ConnectorDefinitionVersionId = connector_definition_version_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetConnectorDefinitionVersionInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_65) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_65));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetConnectorDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetConnectorDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetConnectorDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetConnectorDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetConnectorDefinitionVersionInput`](crate::input::GetConnectorDefinitionVersionInput)
    pub fn builder() -> crate::input::get_connector_definition_version_input::Builder {
        crate::input::get_connector_definition_version_input::Builder::default()
    }
}

/// See [`GetCoreDefinitionInput`](crate::input::GetCoreDefinitionInput)
pub mod get_core_definition_input {
    /// A builder for [`GetCoreDefinitionInput`](crate::input::GetCoreDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_definition_id = Some(input.into());
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCoreDefinitionInput`](crate::input::GetCoreDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCoreDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCoreDefinitionInput {
                core_definition_id: self.core_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCoreDefinitionInputOperationOutputAlias = crate::operation::GetCoreDefinition;
#[doc(hidden)]
pub type GetCoreDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCoreDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`GetCoreDefinition`](crate::operation::GetCoreDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCoreDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCoreDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_66 = &_input.core_definition_id;
            let input_66 =
                input_66
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let core_definition_id = aws_smithy_http::label::fmt_string(input_66, false);
            if core_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/cores/{CoreDefinitionId}",
                CoreDefinitionId = core_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCoreDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCoreDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCoreDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCoreDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCoreDefinitionInput`](crate::input::GetCoreDefinitionInput)
    pub fn builder() -> crate::input::get_core_definition_input::Builder {
        crate::input::get_core_definition_input::Builder::default()
    }
}

/// See [`GetCoreDefinitionVersionInput`](crate::input::GetCoreDefinitionVersionInput)
pub mod get_core_definition_version_input {
    /// A builder for [`GetCoreDefinitionVersionInput`](crate::input::GetCoreDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_definition_id: std::option::Option<std::string::String>,
        pub(crate) core_definition_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_definition_id = Some(input.into());
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_definition_id = input;
            self
        }
        /// The ID of the core definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListCoreDefinitionVersions'' requests. If the version is the last one that was associated with a core definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn core_definition_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_definition_version_id = Some(input.into());
            self
        }
        /// The ID of the core definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListCoreDefinitionVersions'' requests. If the version is the last one that was associated with a core definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_core_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_definition_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCoreDefinitionVersionInput`](crate::input::GetCoreDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCoreDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCoreDefinitionVersionInput {
                core_definition_id: self.core_definition_id,
                core_definition_version_id: self.core_definition_version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCoreDefinitionVersionInputOperationOutputAlias =
    crate::operation::GetCoreDefinitionVersion;
#[doc(hidden)]
pub type GetCoreDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCoreDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetCoreDefinitionVersion`](crate::operation::GetCoreDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCoreDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCoreDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_67 = &_input.core_definition_id;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let core_definition_id = aws_smithy_http::label::fmt_string(input_67, false);
            if core_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_68 = &_input.core_definition_version_id;
            let input_68 =
                input_68
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_definition_version_id",
                        details: "cannot be empty or unset",
                    })?;
            let core_definition_version_id = aws_smithy_http::label::fmt_string(input_68, false);
            if core_definition_version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_definition_version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/definition/cores/{CoreDefinitionId}/versions/{CoreDefinitionVersionId}", CoreDefinitionId = core_definition_id, CoreDefinitionVersionId = core_definition_version_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCoreDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCoreDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCoreDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCoreDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCoreDefinitionVersionInput`](crate::input::GetCoreDefinitionVersionInput)
    pub fn builder() -> crate::input::get_core_definition_version_input::Builder {
        crate::input::get_core_definition_version_input::Builder::default()
    }
}

/// See [`GetDeploymentStatusInput`](crate::input::GetDeploymentStatusInput)
pub mod get_deployment_status_input {
    /// A builder for [`GetDeploymentStatusInput`](crate::input::GetDeploymentStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the deployment.
        pub fn deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_id = Some(input.into());
            self
        }
        /// The ID of the deployment.
        pub fn set_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_id = input;
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeploymentStatusInput`](crate::input::GetDeploymentStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeploymentStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeploymentStatusInput {
                deployment_id: self.deployment_id,
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeploymentStatusInputOperationOutputAlias = crate::operation::GetDeploymentStatus;
#[doc(hidden)]
pub type GetDeploymentStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDeploymentStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetDeploymentStatus`](crate::operation::GetDeploymentStatus)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeploymentStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeploymentStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_69 = &_input.group_id;
            let input_69 =
                input_69
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_69, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_70 = &_input.deployment_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "deployment_id",
                        details: "cannot be empty or unset",
                    })?;
            let deployment_id = aws_smithy_http::label::fmt_string(input_70, false);
            if deployment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "deployment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/deployments/{DeploymentId}/status",
                GroupId = group_id,
                DeploymentId = deployment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeploymentStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeploymentStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeploymentStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeploymentStatus",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeploymentStatusInput`](crate::input::GetDeploymentStatusInput)
    pub fn builder() -> crate::input::get_deployment_status_input::Builder {
        crate::input::get_deployment_status_input::Builder::default()
    }
}

/// See [`GetDeviceDefinitionInput`](crate::input::GetDeviceDefinitionInput)
pub mod get_device_definition_input {
    /// A builder for [`GetDeviceDefinitionInput`](crate::input::GetDeviceDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_definition_id = Some(input.into());
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceDefinitionInput`](crate::input::GetDeviceDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeviceDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeviceDefinitionInput {
                device_definition_id: self.device_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeviceDefinitionInputOperationOutputAlias = crate::operation::GetDeviceDefinition;
#[doc(hidden)]
pub type GetDeviceDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDeviceDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`GetDeviceDefinition`](crate::operation::GetDeviceDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeviceDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeviceDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.device_definition_id;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_definition_id = aws_smithy_http::label::fmt_string(input_71, false);
            if device_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/devices/{DeviceDefinitionId}",
                DeviceDefinitionId = device_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeviceDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeviceDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeviceDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeviceDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeviceDefinitionInput`](crate::input::GetDeviceDefinitionInput)
    pub fn builder() -> crate::input::get_device_definition_input::Builder {
        crate::input::get_device_definition_input::Builder::default()
    }
}

/// See [`GetDeviceDefinitionVersionInput`](crate::input::GetDeviceDefinitionVersionInput)
pub mod get_device_definition_version_input {
    /// A builder for [`GetDeviceDefinitionVersionInput`](crate::input::GetDeviceDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_definition_id: std::option::Option<std::string::String>,
        pub(crate) device_definition_version_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_definition_id = Some(input.into());
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_definition_id = input;
            self
        }
        /// The ID of the device definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListDeviceDefinitionVersions'' requests. If the version is the last one that was associated with a device definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn device_definition_version_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.device_definition_version_id = Some(input.into());
            self
        }
        /// The ID of the device definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListDeviceDefinitionVersions'' requests. If the version is the last one that was associated with a device definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_device_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_definition_version_id = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceDefinitionVersionInput`](crate::input::GetDeviceDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDeviceDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDeviceDefinitionVersionInput {
                device_definition_id: self.device_definition_id,
                device_definition_version_id: self.device_definition_version_id,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDeviceDefinitionVersionInputOperationOutputAlias =
    crate::operation::GetDeviceDefinitionVersion;
#[doc(hidden)]
pub type GetDeviceDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDeviceDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetDeviceDefinitionVersion`](crate::operation::GetDeviceDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDeviceDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDeviceDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_72 = &_input.device_definition_id;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_definition_id = aws_smithy_http::label::fmt_string(input_72, false);
            if device_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_73 = &_input.device_definition_version_id;
            let input_73 =
                input_73
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_definition_version_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_definition_version_id = aws_smithy_http::label::fmt_string(input_73, false);
            if device_definition_version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_definition_version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/definition/devices/{DeviceDefinitionId}/versions/{DeviceDefinitionVersionId}", DeviceDefinitionId = device_definition_id, DeviceDefinitionVersionId = device_definition_version_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetDeviceDefinitionVersionInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_74) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_74));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDeviceDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDeviceDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDeviceDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDeviceDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDeviceDefinitionVersionInput`](crate::input::GetDeviceDefinitionVersionInput)
    pub fn builder() -> crate::input::get_device_definition_version_input::Builder {
        crate::input::get_device_definition_version_input::Builder::default()
    }
}

/// See [`GetFunctionDefinitionInput`](crate::input::GetFunctionDefinitionInput)
pub mod get_function_definition_input {
    /// A builder for [`GetFunctionDefinitionInput`](crate::input::GetFunctionDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_definition_id = Some(input.into());
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionDefinitionInput`](crate::input::GetFunctionDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFunctionDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFunctionDefinitionInput {
                function_definition_id: self.function_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFunctionDefinitionInputOperationOutputAlias = crate::operation::GetFunctionDefinition;
#[doc(hidden)]
pub type GetFunctionDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFunctionDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`GetFunctionDefinition`](crate::operation::GetFunctionDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFunctionDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFunctionDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_75 = &_input.function_definition_id;
            let input_75 =
                input_75
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let function_definition_id = aws_smithy_http::label::fmt_string(input_75, false);
            if function_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "function_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/functions/{FunctionDefinitionId}",
                FunctionDefinitionId = function_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFunctionDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFunctionDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFunctionDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFunctionDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFunctionDefinitionInput`](crate::input::GetFunctionDefinitionInput)
    pub fn builder() -> crate::input::get_function_definition_input::Builder {
        crate::input::get_function_definition_input::Builder::default()
    }
}

/// See [`GetFunctionDefinitionVersionInput`](crate::input::GetFunctionDefinitionVersionInput)
pub mod get_function_definition_version_input {
    /// A builder for [`GetFunctionDefinitionVersionInput`](crate::input::GetFunctionDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_definition_id: std::option::Option<std::string::String>,
        pub(crate) function_definition_version_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_definition_id = Some(input.into());
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_definition_id = input;
            self
        }
        /// The ID of the function definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListFunctionDefinitionVersions'' requests. If the version is the last one that was associated with a function definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn function_definition_version_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.function_definition_version_id = Some(input.into());
            self
        }
        /// The ID of the function definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListFunctionDefinitionVersions'' requests. If the version is the last one that was associated with a function definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_function_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_definition_version_id = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionDefinitionVersionInput`](crate::input::GetFunctionDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFunctionDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFunctionDefinitionVersionInput {
                function_definition_id: self.function_definition_id,
                function_definition_version_id: self.function_definition_version_id,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFunctionDefinitionVersionInputOperationOutputAlias =
    crate::operation::GetFunctionDefinitionVersion;
#[doc(hidden)]
pub type GetFunctionDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFunctionDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetFunctionDefinitionVersion`](crate::operation::GetFunctionDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFunctionDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFunctionDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_76 = &_input.function_definition_id;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let function_definition_id = aws_smithy_http::label::fmt_string(input_76, false);
            if function_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "function_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_77 = &_input.function_definition_version_id;
            let input_77 =
                input_77
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_definition_version_id",
                        details: "cannot be empty or unset",
                    })?;
            let function_definition_version_id =
                aws_smithy_http::label::fmt_string(input_77, false);
            if function_definition_version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "function_definition_version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/definition/functions/{FunctionDefinitionId}/versions/{FunctionDefinitionVersionId}", FunctionDefinitionId = function_definition_id, FunctionDefinitionVersionId = function_definition_version_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetFunctionDefinitionVersionInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_78) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_78));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFunctionDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFunctionDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFunctionDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFunctionDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFunctionDefinitionVersionInput`](crate::input::GetFunctionDefinitionVersionInput)
    pub fn builder() -> crate::input::get_function_definition_version_input::Builder {
        crate::input::get_function_definition_version_input::Builder::default()
    }
}

/// See [`GetGroupInput`](crate::input::GetGroupInput)
pub mod get_group_input {
    /// A builder for [`GetGroupInput`](crate::input::GetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupInput`](crate::input::GetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetGroupInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetGroupInput {
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupInputOperationOutputAlias = crate::operation::GetGroup;
#[doc(hidden)]
pub type GetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetGroup`](crate::operation::GetGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_79 = &_input.group_id;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_79, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/groups/{GroupId}", GroupId = group_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetGroup::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetGroup",
                    "greengrass",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupInput`](crate::input::GetGroupInput)
    pub fn builder() -> crate::input::get_group_input::Builder {
        crate::input::get_group_input::Builder::default()
    }
}

/// See [`GetGroupCertificateAuthorityInput`](crate::input::GetGroupCertificateAuthorityInput)
pub mod get_group_certificate_authority_input {
    /// A builder for [`GetGroupCertificateAuthorityInput`](crate::input::GetGroupCertificateAuthorityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_authority_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the certificate authority.
        pub fn certificate_authority_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_authority_id = Some(input.into());
            self
        }
        /// The ID of the certificate authority.
        pub fn set_certificate_authority_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_authority_id = input;
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupCertificateAuthorityInput`](crate::input::GetGroupCertificateAuthorityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGroupCertificateAuthorityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGroupCertificateAuthorityInput {
                certificate_authority_id: self.certificate_authority_id,
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupCertificateAuthorityInputOperationOutputAlias =
    crate::operation::GetGroupCertificateAuthority;
#[doc(hidden)]
pub type GetGroupCertificateAuthorityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupCertificateAuthorityInput {
    /// Consumes the builder and constructs an Operation<[`GetGroupCertificateAuthority`](crate::operation::GetGroupCertificateAuthority)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroupCertificateAuthority,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupCertificateAuthorityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_80 = &_input.group_id;
            let input_80 =
                input_80
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_80, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_81 = &_input.certificate_authority_id;
            let input_81 =
                input_81
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "certificate_authority_id",
                        details: "cannot be empty or unset",
                    })?;
            let certificate_authority_id = aws_smithy_http::label::fmt_string(input_81, false);
            if certificate_authority_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "certificate_authority_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/certificateauthorities/{CertificateAuthorityId}",
                GroupId = group_id,
                CertificateAuthorityId = certificate_authority_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupCertificateAuthorityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupCertificateAuthorityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGroupCertificateAuthority::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGroupCertificateAuthority",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupCertificateAuthorityInput`](crate::input::GetGroupCertificateAuthorityInput)
    pub fn builder() -> crate::input::get_group_certificate_authority_input::Builder {
        crate::input::get_group_certificate_authority_input::Builder::default()
    }
}

/// See [`GetGroupCertificateConfigurationInput`](crate::input::GetGroupCertificateConfigurationInput)
pub mod get_group_certificate_configuration_input {
    /// A builder for [`GetGroupCertificateConfigurationInput`](crate::input::GetGroupCertificateConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupCertificateConfigurationInput`](crate::input::GetGroupCertificateConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGroupCertificateConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGroupCertificateConfigurationInput {
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupCertificateConfigurationInputOperationOutputAlias =
    crate::operation::GetGroupCertificateConfiguration;
#[doc(hidden)]
pub type GetGroupCertificateConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupCertificateConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetGroupCertificateConfiguration`](crate::operation::GetGroupCertificateConfiguration)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroupCertificateConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupCertificateConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_82 = &_input.group_id;
            let input_82 =
                input_82
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_82, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/certificateauthorities/configuration/expiry",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupCertificateConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupCertificateConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGroupCertificateConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGroupCertificateConfiguration",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupCertificateConfigurationInput`](crate::input::GetGroupCertificateConfigurationInput)
    pub fn builder() -> crate::input::get_group_certificate_configuration_input::Builder {
        crate::input::get_group_certificate_configuration_input::Builder::default()
    }
}

/// See [`GetGroupVersionInput`](crate::input::GetGroupVersionInput)
pub mod get_group_version_input {
    /// A builder for [`GetGroupVersionInput`](crate::input::GetGroupVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) group_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// The ID of the group version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListGroupVersions'' requests. If the version is the last one that was associated with a group, the value also maps to the ''LatestVersion'' property of the corresponding ''GroupInformation'' object.
        pub fn group_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_version_id = Some(input.into());
            self
        }
        /// The ID of the group version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListGroupVersions'' requests. If the version is the last one that was associated with a group, the value also maps to the ''LatestVersion'' property of the corresponding ''GroupInformation'' object.
        pub fn set_group_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.group_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupVersionInput`](crate::input::GetGroupVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGroupVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGroupVersionInput {
                group_id: self.group_id,
                group_version_id: self.group_version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupVersionInputOperationOutputAlias = crate::operation::GetGroupVersion;
#[doc(hidden)]
pub type GetGroupVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetGroupVersion`](crate::operation::GetGroupVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroupVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_83 = &_input.group_id;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_83, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_84 = &_input.group_version_id;
            let input_84 =
                input_84
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_version_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_version_id = aws_smithy_http::label::fmt_string(input_84, false);
            if group_version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/versions/{GroupVersionId}",
                GroupId = group_id,
                GroupVersionId = group_version_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGroupVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGroupVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupVersionInput`](crate::input::GetGroupVersionInput)
    pub fn builder() -> crate::input::get_group_version_input::Builder {
        crate::input::get_group_version_input::Builder::default()
    }
}

/// See [`GetLoggerDefinitionInput`](crate::input::GetLoggerDefinitionInput)
pub mod get_logger_definition_input {
    /// A builder for [`GetLoggerDefinitionInput`](crate::input::GetLoggerDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logger_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logger_definition_id = Some(input.into());
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logger_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLoggerDefinitionInput`](crate::input::GetLoggerDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLoggerDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLoggerDefinitionInput {
                logger_definition_id: self.logger_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLoggerDefinitionInputOperationOutputAlias = crate::operation::GetLoggerDefinition;
#[doc(hidden)]
pub type GetLoggerDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLoggerDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`GetLoggerDefinition`](crate::operation::GetLoggerDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLoggerDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLoggerDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_85 = &_input.logger_definition_id;
            let input_85 =
                input_85
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "logger_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let logger_definition_id = aws_smithy_http::label::fmt_string(input_85, false);
            if logger_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "logger_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/loggers/{LoggerDefinitionId}",
                LoggerDefinitionId = logger_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLoggerDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLoggerDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLoggerDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLoggerDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLoggerDefinitionInput`](crate::input::GetLoggerDefinitionInput)
    pub fn builder() -> crate::input::get_logger_definition_input::Builder {
        crate::input::get_logger_definition_input::Builder::default()
    }
}

/// See [`GetLoggerDefinitionVersionInput`](crate::input::GetLoggerDefinitionVersionInput)
pub mod get_logger_definition_version_input {
    /// A builder for [`GetLoggerDefinitionVersionInput`](crate::input::GetLoggerDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logger_definition_id: std::option::Option<std::string::String>,
        pub(crate) logger_definition_version_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logger_definition_id = Some(input.into());
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logger_definition_id = input;
            self
        }
        /// The ID of the logger definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListLoggerDefinitionVersions'' requests. If the version is the last one that was associated with a logger definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn logger_definition_version_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.logger_definition_version_id = Some(input.into());
            self
        }
        /// The ID of the logger definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListLoggerDefinitionVersions'' requests. If the version is the last one that was associated with a logger definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_logger_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logger_definition_version_id = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLoggerDefinitionVersionInput`](crate::input::GetLoggerDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLoggerDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLoggerDefinitionVersionInput {
                logger_definition_id: self.logger_definition_id,
                logger_definition_version_id: self.logger_definition_version_id,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLoggerDefinitionVersionInputOperationOutputAlias =
    crate::operation::GetLoggerDefinitionVersion;
#[doc(hidden)]
pub type GetLoggerDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLoggerDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetLoggerDefinitionVersion`](crate::operation::GetLoggerDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLoggerDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLoggerDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_86 = &_input.logger_definition_id;
            let input_86 =
                input_86
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "logger_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let logger_definition_id = aws_smithy_http::label::fmt_string(input_86, false);
            if logger_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "logger_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_87 = &_input.logger_definition_version_id;
            let input_87 =
                input_87
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "logger_definition_version_id",
                        details: "cannot be empty or unset",
                    })?;
            let logger_definition_version_id = aws_smithy_http::label::fmt_string(input_87, false);
            if logger_definition_version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "logger_definition_version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/definition/loggers/{LoggerDefinitionId}/versions/{LoggerDefinitionVersionId}", LoggerDefinitionId = logger_definition_id, LoggerDefinitionVersionId = logger_definition_version_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetLoggerDefinitionVersionInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_88) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_88));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLoggerDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLoggerDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLoggerDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLoggerDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLoggerDefinitionVersionInput`](crate::input::GetLoggerDefinitionVersionInput)
    pub fn builder() -> crate::input::get_logger_definition_version_input::Builder {
        crate::input::get_logger_definition_version_input::Builder::default()
    }
}

/// See [`GetResourceDefinitionInput`](crate::input::GetResourceDefinitionInput)
pub mod get_resource_definition_input {
    /// A builder for [`GetResourceDefinitionInput`](crate::input::GetResourceDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_definition_id = Some(input.into());
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceDefinitionInput`](crate::input::GetResourceDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceDefinitionInput {
                resource_definition_id: self.resource_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceDefinitionInputOperationOutputAlias = crate::operation::GetResourceDefinition;
#[doc(hidden)]
pub type GetResourceDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourceDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceDefinition`](crate::operation::GetResourceDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_89 = &_input.resource_definition_id;
            let input_89 =
                input_89
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_definition_id = aws_smithy_http::label::fmt_string(input_89, false);
            if resource_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/resources/{ResourceDefinitionId}",
                ResourceDefinitionId = resource_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceDefinitionInput`](crate::input::GetResourceDefinitionInput)
    pub fn builder() -> crate::input::get_resource_definition_input::Builder {
        crate::input::get_resource_definition_input::Builder::default()
    }
}

/// See [`GetResourceDefinitionVersionInput`](crate::input::GetResourceDefinitionVersionInput)
pub mod get_resource_definition_version_input {
    /// A builder for [`GetResourceDefinitionVersionInput`](crate::input::GetResourceDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_definition_id: std::option::Option<std::string::String>,
        pub(crate) resource_definition_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_definition_id = Some(input.into());
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_definition_id = input;
            self
        }
        /// The ID of the resource definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListResourceDefinitionVersions'' requests. If the version is the last one that was associated with a resource definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn resource_definition_version_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resource_definition_version_id = Some(input.into());
            self
        }
        /// The ID of the resource definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListResourceDefinitionVersions'' requests. If the version is the last one that was associated with a resource definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_resource_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_definition_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceDefinitionVersionInput`](crate::input::GetResourceDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceDefinitionVersionInput {
                resource_definition_id: self.resource_definition_id,
                resource_definition_version_id: self.resource_definition_version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceDefinitionVersionInputOperationOutputAlias =
    crate::operation::GetResourceDefinitionVersion;
#[doc(hidden)]
pub type GetResourceDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourceDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceDefinitionVersion`](crate::operation::GetResourceDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_90 = &_input.resource_definition_id;
            let input_90 =
                input_90
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_definition_id = aws_smithy_http::label::fmt_string(input_90, false);
            if resource_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_91 = &_input.resource_definition_version_id;
            let input_91 =
                input_91
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_definition_version_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_definition_version_id =
                aws_smithy_http::label::fmt_string(input_91, false);
            if resource_definition_version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_definition_version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/definition/resources/{ResourceDefinitionId}/versions/{ResourceDefinitionVersionId}", ResourceDefinitionId = resource_definition_id, ResourceDefinitionVersionId = resource_definition_version_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceDefinitionVersionInput`](crate::input::GetResourceDefinitionVersionInput)
    pub fn builder() -> crate::input::get_resource_definition_version_input::Builder {
        crate::input::get_resource_definition_version_input::Builder::default()
    }
}

/// See [`GetServiceRoleForAccountInput`](crate::input::GetServiceRoleForAccountInput)
pub mod get_service_role_for_account_input {
    /// A builder for [`GetServiceRoleForAccountInput`](crate::input::GetServiceRoleForAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetServiceRoleForAccountInput`](crate::input::GetServiceRoleForAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceRoleForAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceRoleForAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetServiceRoleForAccountInputOperationOutputAlias =
    crate::operation::GetServiceRoleForAccount;
#[doc(hidden)]
pub type GetServiceRoleForAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServiceRoleForAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceRoleForAccount`](crate::operation::GetServiceRoleForAccount)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceRoleForAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceRoleForAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/servicerole").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceRoleForAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceRoleForAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceRoleForAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceRoleForAccount",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceRoleForAccountInput`](crate::input::GetServiceRoleForAccountInput)
    pub fn builder() -> crate::input::get_service_role_for_account_input::Builder {
        crate::input::get_service_role_for_account_input::Builder::default()
    }
}

/// See [`GetSubscriptionDefinitionInput`](crate::input::GetSubscriptionDefinitionInput)
pub mod get_subscription_definition_input {
    /// A builder for [`GetSubscriptionDefinitionInput`](crate::input::GetSubscriptionDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_definition_id = Some(input.into());
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSubscriptionDefinitionInput`](crate::input::GetSubscriptionDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSubscriptionDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSubscriptionDefinitionInput {
                subscription_definition_id: self.subscription_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSubscriptionDefinitionInputOperationOutputAlias =
    crate::operation::GetSubscriptionDefinition;
#[doc(hidden)]
pub type GetSubscriptionDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSubscriptionDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`GetSubscriptionDefinition`](crate::operation::GetSubscriptionDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSubscriptionDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSubscriptionDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_92 = &_input.subscription_definition_id;
            let input_92 =
                input_92
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscription_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let subscription_definition_id = aws_smithy_http::label::fmt_string(input_92, false);
            if subscription_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "subscription_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}",
                SubscriptionDefinitionId = subscription_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSubscriptionDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSubscriptionDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSubscriptionDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSubscriptionDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSubscriptionDefinitionInput`](crate::input::GetSubscriptionDefinitionInput)
    pub fn builder() -> crate::input::get_subscription_definition_input::Builder {
        crate::input::get_subscription_definition_input::Builder::default()
    }
}

/// See [`GetSubscriptionDefinitionVersionInput`](crate::input::GetSubscriptionDefinitionVersionInput)
pub mod get_subscription_definition_version_input {
    /// A builder for [`GetSubscriptionDefinitionVersionInput`](crate::input::GetSubscriptionDefinitionVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) subscription_definition_id: std::option::Option<std::string::String>,
        pub(crate) subscription_definition_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_definition_id = Some(input.into());
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_definition_id = input;
            self
        }
        /// The ID of the subscription definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListSubscriptionDefinitionVersions'' requests. If the version is the last one that was associated with a subscription definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn subscription_definition_version_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.subscription_definition_version_id = Some(input.into());
            self
        }
        /// The ID of the subscription definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListSubscriptionDefinitionVersions'' requests. If the version is the last one that was associated with a subscription definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        pub fn set_subscription_definition_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_definition_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSubscriptionDefinitionVersionInput`](crate::input::GetSubscriptionDefinitionVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSubscriptionDefinitionVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSubscriptionDefinitionVersionInput {
                next_token: self.next_token,
                subscription_definition_id: self.subscription_definition_id,
                subscription_definition_version_id: self.subscription_definition_version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSubscriptionDefinitionVersionInputOperationOutputAlias =
    crate::operation::GetSubscriptionDefinitionVersion;
#[doc(hidden)]
pub type GetSubscriptionDefinitionVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSubscriptionDefinitionVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetSubscriptionDefinitionVersion`](crate::operation::GetSubscriptionDefinitionVersion)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSubscriptionDefinitionVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSubscriptionDefinitionVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_93 = &_input.subscription_definition_id;
            let input_93 =
                input_93
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscription_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let subscription_definition_id = aws_smithy_http::label::fmt_string(input_93, false);
            if subscription_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "subscription_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_94 = &_input.subscription_definition_version_id;
            let input_94 =
                input_94
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscription_definition_version_id",
                        details: "cannot be empty or unset",
                    })?;
            let subscription_definition_version_id =
                aws_smithy_http::label::fmt_string(input_94, false);
            if subscription_definition_version_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "subscription_definition_version_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}/versions/{SubscriptionDefinitionVersionId}", SubscriptionDefinitionId = subscription_definition_id, SubscriptionDefinitionVersionId = subscription_definition_version_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetSubscriptionDefinitionVersionInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_95) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_95));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSubscriptionDefinitionVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSubscriptionDefinitionVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSubscriptionDefinitionVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSubscriptionDefinitionVersion",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSubscriptionDefinitionVersionInput`](crate::input::GetSubscriptionDefinitionVersionInput)
    pub fn builder() -> crate::input::get_subscription_definition_version_input::Builder {
        crate::input::get_subscription_definition_version_input::Builder::default()
    }
}

/// See [`GetThingRuntimeConfigurationInput`](crate::input::GetThingRuntimeConfigurationInput)
pub mod get_thing_runtime_configuration_input {
    /// A builder for [`GetThingRuntimeConfigurationInput`](crate::input::GetThingRuntimeConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The thing name.
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// The thing name.
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetThingRuntimeConfigurationInput`](crate::input::GetThingRuntimeConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetThingRuntimeConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetThingRuntimeConfigurationInput {
                thing_name: self.thing_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetThingRuntimeConfigurationInputOperationOutputAlias =
    crate::operation::GetThingRuntimeConfiguration;
#[doc(hidden)]
pub type GetThingRuntimeConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetThingRuntimeConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetThingRuntimeConfiguration`](crate::operation::GetThingRuntimeConfiguration)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetThingRuntimeConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetThingRuntimeConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_96 = &_input.thing_name;
            let input_96 =
                input_96
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let thing_name = aws_smithy_http::label::fmt_string(input_96, false);
            if thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/things/{ThingName}/runtimeconfig",
                ThingName = thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetThingRuntimeConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetThingRuntimeConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetThingRuntimeConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetThingRuntimeConfiguration",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetThingRuntimeConfigurationInput`](crate::input::GetThingRuntimeConfigurationInput)
    pub fn builder() -> crate::input::get_thing_runtime_configuration_input::Builder {
        crate::input::get_thing_runtime_configuration_input::Builder::default()
    }
}

/// See [`ListBulkDeploymentDetailedReportsInput`](crate::input::ListBulkDeploymentDetailedReportsInput)
pub mod list_bulk_deployment_detailed_reports_input {
    /// A builder for [`ListBulkDeploymentDetailedReportsInput`](crate::input::ListBulkDeploymentDetailedReportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bulk_deployment_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the bulk deployment.
        pub fn bulk_deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bulk_deployment_id = Some(input.into());
            self
        }
        /// The ID of the bulk deployment.
        pub fn set_bulk_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bulk_deployment_id = input;
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBulkDeploymentDetailedReportsInput`](crate::input::ListBulkDeploymentDetailedReportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBulkDeploymentDetailedReportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBulkDeploymentDetailedReportsInput {
                bulk_deployment_id: self.bulk_deployment_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBulkDeploymentDetailedReportsInputOperationOutputAlias =
    crate::operation::ListBulkDeploymentDetailedReports;
#[doc(hidden)]
pub type ListBulkDeploymentDetailedReportsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBulkDeploymentDetailedReportsInput {
    /// Consumes the builder and constructs an Operation<[`ListBulkDeploymentDetailedReports`](crate::operation::ListBulkDeploymentDetailedReports)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBulkDeploymentDetailedReports,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBulkDeploymentDetailedReportsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_97 = &_input.bulk_deployment_id;
            let input_97 =
                input_97
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bulk_deployment_id",
                        details: "cannot be empty or unset",
                    })?;
            let bulk_deployment_id = aws_smithy_http::label::fmt_string(input_97, false);
            if bulk_deployment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bulk_deployment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/bulk/deployments/{BulkDeploymentId}/detailed-reports",
                BulkDeploymentId = bulk_deployment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBulkDeploymentDetailedReportsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_98) = &_input.max_results {
                query.push_kv("MaxResults", &aws_smithy_http::query::fmt_string(&inner_98));
            }
            if let Some(inner_99) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_99));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBulkDeploymentDetailedReportsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBulkDeploymentDetailedReportsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBulkDeploymentDetailedReports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBulkDeploymentDetailedReports",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBulkDeploymentDetailedReportsInput`](crate::input::ListBulkDeploymentDetailedReportsInput)
    pub fn builder() -> crate::input::list_bulk_deployment_detailed_reports_input::Builder {
        crate::input::list_bulk_deployment_detailed_reports_input::Builder::default()
    }
}

/// See [`ListBulkDeploymentsInput`](crate::input::ListBulkDeploymentsInput)
pub mod list_bulk_deployments_input {
    /// A builder for [`ListBulkDeploymentsInput`](crate::input::ListBulkDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBulkDeploymentsInput`](crate::input::ListBulkDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBulkDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBulkDeploymentsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBulkDeploymentsInputOperationOutputAlias = crate::operation::ListBulkDeployments;
#[doc(hidden)]
pub type ListBulkDeploymentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListBulkDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`ListBulkDeployments`](crate::operation::ListBulkDeployments)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBulkDeployments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBulkDeploymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/bulk/deployments").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListBulkDeploymentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_100) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_100),
                );
            }
            if let Some(inner_101) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_101));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBulkDeploymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBulkDeploymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBulkDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBulkDeployments",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBulkDeploymentsInput`](crate::input::ListBulkDeploymentsInput)
    pub fn builder() -> crate::input::list_bulk_deployments_input::Builder {
        crate::input::list_bulk_deployments_input::Builder::default()
    }
}

/// See [`ListConnectorDefinitionsInput`](crate::input::ListConnectorDefinitionsInput)
pub mod list_connector_definitions_input {
    /// A builder for [`ListConnectorDefinitionsInput`](crate::input::ListConnectorDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConnectorDefinitionsInput`](crate::input::ListConnectorDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConnectorDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConnectorDefinitionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConnectorDefinitionsInputOperationOutputAlias =
    crate::operation::ListConnectorDefinitions;
#[doc(hidden)]
pub type ListConnectorDefinitionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListConnectorDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListConnectorDefinitions`](crate::operation::ListConnectorDefinitions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConnectorDefinitions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConnectorDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/connectors").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListConnectorDefinitionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_102) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_102),
                );
            }
            if let Some(inner_103) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_103));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConnectorDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConnectorDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConnectorDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConnectorDefinitions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConnectorDefinitionsInput`](crate::input::ListConnectorDefinitionsInput)
    pub fn builder() -> crate::input::list_connector_definitions_input::Builder {
        crate::input::list_connector_definitions_input::Builder::default()
    }
}

/// See [`ListConnectorDefinitionVersionsInput`](crate::input::ListConnectorDefinitionVersionsInput)
pub mod list_connector_definition_versions_input {
    /// A builder for [`ListConnectorDefinitionVersionsInput`](crate::input::ListConnectorDefinitionVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_definition_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_definition_id = Some(input.into());
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_definition_id = input;
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConnectorDefinitionVersionsInput`](crate::input::ListConnectorDefinitionVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListConnectorDefinitionVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListConnectorDefinitionVersionsInput {
                connector_definition_id: self.connector_definition_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListConnectorDefinitionVersionsInputOperationOutputAlias =
    crate::operation::ListConnectorDefinitionVersions;
#[doc(hidden)]
pub type ListConnectorDefinitionVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListConnectorDefinitionVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListConnectorDefinitionVersions`](crate::operation::ListConnectorDefinitionVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListConnectorDefinitionVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListConnectorDefinitionVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_104 = &_input.connector_definition_id;
            let input_104 =
                input_104
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connector_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let connector_definition_id = aws_smithy_http::label::fmt_string(input_104, false);
            if connector_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connector_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/connectors/{ConnectorDefinitionId}/versions",
                ConnectorDefinitionId = connector_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListConnectorDefinitionVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_105) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_105),
                );
            }
            if let Some(inner_106) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_106));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListConnectorDefinitionVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListConnectorDefinitionVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListConnectorDefinitionVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListConnectorDefinitionVersions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListConnectorDefinitionVersionsInput`](crate::input::ListConnectorDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_connector_definition_versions_input::Builder {
        crate::input::list_connector_definition_versions_input::Builder::default()
    }
}

/// See [`ListCoreDefinitionsInput`](crate::input::ListCoreDefinitionsInput)
pub mod list_core_definitions_input {
    /// A builder for [`ListCoreDefinitionsInput`](crate::input::ListCoreDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCoreDefinitionsInput`](crate::input::ListCoreDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCoreDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCoreDefinitionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCoreDefinitionsInputOperationOutputAlias = crate::operation::ListCoreDefinitions;
#[doc(hidden)]
pub type ListCoreDefinitionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCoreDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListCoreDefinitions`](crate::operation::ListCoreDefinitions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCoreDefinitions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCoreDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/cores").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListCoreDefinitionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_107) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_107),
                );
            }
            if let Some(inner_108) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_108));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCoreDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCoreDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCoreDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCoreDefinitions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCoreDefinitionsInput`](crate::input::ListCoreDefinitionsInput)
    pub fn builder() -> crate::input::list_core_definitions_input::Builder {
        crate::input::list_core_definitions_input::Builder::default()
    }
}

/// See [`ListCoreDefinitionVersionsInput`](crate::input::ListCoreDefinitionVersionsInput)
pub mod list_core_definition_versions_input {
    /// A builder for [`ListCoreDefinitionVersionsInput`](crate::input::ListCoreDefinitionVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_definition_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_definition_id = Some(input.into());
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_definition_id = input;
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCoreDefinitionVersionsInput`](crate::input::ListCoreDefinitionVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCoreDefinitionVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCoreDefinitionVersionsInput {
                core_definition_id: self.core_definition_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCoreDefinitionVersionsInputOperationOutputAlias =
    crate::operation::ListCoreDefinitionVersions;
#[doc(hidden)]
pub type ListCoreDefinitionVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCoreDefinitionVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListCoreDefinitionVersions`](crate::operation::ListCoreDefinitionVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCoreDefinitionVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCoreDefinitionVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_109 = &_input.core_definition_id;
            let input_109 =
                input_109
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let core_definition_id = aws_smithy_http::label::fmt_string(input_109, false);
            if core_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/cores/{CoreDefinitionId}/versions",
                CoreDefinitionId = core_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListCoreDefinitionVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_110) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_110),
                );
            }
            if let Some(inner_111) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_111));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCoreDefinitionVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCoreDefinitionVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCoreDefinitionVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCoreDefinitionVersions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCoreDefinitionVersionsInput`](crate::input::ListCoreDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_core_definition_versions_input::Builder {
        crate::input::list_core_definition_versions_input::Builder::default()
    }
}

/// See [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
pub mod list_deployments_input {
    /// A builder for [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeploymentsInput {
                group_id: self.group_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeploymentsInputOperationOutputAlias = crate::operation::ListDeployments;
#[doc(hidden)]
pub type ListDeploymentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeployments`](crate::operation::ListDeployments)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeployments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeploymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_112 = &_input.group_id;
            let input_112 =
                input_112
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_112, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/deployments",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListDeploymentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_113) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_113),
                );
            }
            if let Some(inner_114) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_114));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeploymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeploymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeployments",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeploymentsInput`](crate::input::ListDeploymentsInput)
    pub fn builder() -> crate::input::list_deployments_input::Builder {
        crate::input::list_deployments_input::Builder::default()
    }
}

/// See [`ListDeviceDefinitionsInput`](crate::input::ListDeviceDefinitionsInput)
pub mod list_device_definitions_input {
    /// A builder for [`ListDeviceDefinitionsInput`](crate::input::ListDeviceDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeviceDefinitionsInput`](crate::input::ListDeviceDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeviceDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeviceDefinitionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeviceDefinitionsInputOperationOutputAlias = crate::operation::ListDeviceDefinitions;
#[doc(hidden)]
pub type ListDeviceDefinitionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDeviceDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeviceDefinitions`](crate::operation::ListDeviceDefinitions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeviceDefinitions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeviceDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/devices").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListDeviceDefinitionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_115) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_115),
                );
            }
            if let Some(inner_116) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_116));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeviceDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeviceDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeviceDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeviceDefinitions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeviceDefinitionsInput`](crate::input::ListDeviceDefinitionsInput)
    pub fn builder() -> crate::input::list_device_definitions_input::Builder {
        crate::input::list_device_definitions_input::Builder::default()
    }
}

/// See [`ListDeviceDefinitionVersionsInput`](crate::input::ListDeviceDefinitionVersionsInput)
pub mod list_device_definition_versions_input {
    /// A builder for [`ListDeviceDefinitionVersionsInput`](crate::input::ListDeviceDefinitionVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_definition_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_definition_id = Some(input.into());
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_definition_id = input;
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeviceDefinitionVersionsInput`](crate::input::ListDeviceDefinitionVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeviceDefinitionVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeviceDefinitionVersionsInput {
                device_definition_id: self.device_definition_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeviceDefinitionVersionsInputOperationOutputAlias =
    crate::operation::ListDeviceDefinitionVersions;
#[doc(hidden)]
pub type ListDeviceDefinitionVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDeviceDefinitionVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeviceDefinitionVersions`](crate::operation::ListDeviceDefinitionVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeviceDefinitionVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDeviceDefinitionVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_117 = &_input.device_definition_id;
            let input_117 =
                input_117
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_definition_id = aws_smithy_http::label::fmt_string(input_117, false);
            if device_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/devices/{DeviceDefinitionId}/versions",
                DeviceDefinitionId = device_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDeviceDefinitionVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_118) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_118),
                );
            }
            if let Some(inner_119) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_119));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDeviceDefinitionVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDeviceDefinitionVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeviceDefinitionVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeviceDefinitionVersions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDeviceDefinitionVersionsInput`](crate::input::ListDeviceDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_device_definition_versions_input::Builder {
        crate::input::list_device_definition_versions_input::Builder::default()
    }
}

/// See [`ListFunctionDefinitionsInput`](crate::input::ListFunctionDefinitionsInput)
pub mod list_function_definitions_input {
    /// A builder for [`ListFunctionDefinitionsInput`](crate::input::ListFunctionDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionDefinitionsInput`](crate::input::ListFunctionDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFunctionDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFunctionDefinitionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFunctionDefinitionsInputOperationOutputAlias =
    crate::operation::ListFunctionDefinitions;
#[doc(hidden)]
pub type ListFunctionDefinitionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFunctionDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListFunctionDefinitions`](crate::operation::ListFunctionDefinitions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFunctionDefinitions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFunctionDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/functions").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListFunctionDefinitionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_120) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_120),
                );
            }
            if let Some(inner_121) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_121));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFunctionDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFunctionDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFunctionDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFunctionDefinitions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFunctionDefinitionsInput`](crate::input::ListFunctionDefinitionsInput)
    pub fn builder() -> crate::input::list_function_definitions_input::Builder {
        crate::input::list_function_definitions_input::Builder::default()
    }
}

/// See [`ListFunctionDefinitionVersionsInput`](crate::input::ListFunctionDefinitionVersionsInput)
pub mod list_function_definition_versions_input {
    /// A builder for [`ListFunctionDefinitionVersionsInput`](crate::input::ListFunctionDefinitionVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_definition_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_definition_id = Some(input.into());
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_definition_id = input;
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionDefinitionVersionsInput`](crate::input::ListFunctionDefinitionVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFunctionDefinitionVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFunctionDefinitionVersionsInput {
                function_definition_id: self.function_definition_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFunctionDefinitionVersionsInputOperationOutputAlias =
    crate::operation::ListFunctionDefinitionVersions;
#[doc(hidden)]
pub type ListFunctionDefinitionVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFunctionDefinitionVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListFunctionDefinitionVersions`](crate::operation::ListFunctionDefinitionVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFunctionDefinitionVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFunctionDefinitionVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_122 = &_input.function_definition_id;
            let input_122 =
                input_122
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let function_definition_id = aws_smithy_http::label::fmt_string(input_122, false);
            if function_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "function_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/functions/{FunctionDefinitionId}/versions",
                FunctionDefinitionId = function_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListFunctionDefinitionVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_123) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_123),
                );
            }
            if let Some(inner_124) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_124));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFunctionDefinitionVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFunctionDefinitionVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFunctionDefinitionVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFunctionDefinitionVersions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFunctionDefinitionVersionsInput`](crate::input::ListFunctionDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_function_definition_versions_input::Builder {
        crate::input::list_function_definition_versions_input::Builder::default()
    }
}

/// See [`ListGroupCertificateAuthoritiesInput`](crate::input::ListGroupCertificateAuthoritiesInput)
pub mod list_group_certificate_authorities_input {
    /// A builder for [`ListGroupCertificateAuthoritiesInput`](crate::input::ListGroupCertificateAuthoritiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupCertificateAuthoritiesInput`](crate::input::ListGroupCertificateAuthoritiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupCertificateAuthoritiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupCertificateAuthoritiesInput {
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupCertificateAuthoritiesInputOperationOutputAlias =
    crate::operation::ListGroupCertificateAuthorities;
#[doc(hidden)]
pub type ListGroupCertificateAuthoritiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGroupCertificateAuthoritiesInput {
    /// Consumes the builder and constructs an Operation<[`ListGroupCertificateAuthorities`](crate::operation::ListGroupCertificateAuthorities)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroupCertificateAuthorities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupCertificateAuthoritiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_125 = &_input.group_id;
            let input_125 =
                input_125
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_125, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/certificateauthorities",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupCertificateAuthoritiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupCertificateAuthoritiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroupCertificateAuthorities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroupCertificateAuthorities",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupCertificateAuthoritiesInput`](crate::input::ListGroupCertificateAuthoritiesInput)
    pub fn builder() -> crate::input::list_group_certificate_authorities_input::Builder {
        crate::input::list_group_certificate_authorities_input::Builder::default()
    }
}

/// See [`ListGroupsInput`](crate::input::ListGroupsInput)
pub mod list_groups_input {
    /// A builder for [`ListGroupsInput`](crate::input::ListGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsInput`](crate::input::ListGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupsInputOperationOutputAlias = crate::operation::ListGroups;
#[doc(hidden)]
pub type ListGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListGroups`](crate::operation::ListGroups)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/groups").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListGroupsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_126) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_126),
                );
            }
            if let Some(inner_127) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_127));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroups",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupsInput`](crate::input::ListGroupsInput)
    pub fn builder() -> crate::input::list_groups_input::Builder {
        crate::input::list_groups_input::Builder::default()
    }
}

/// See [`ListGroupVersionsInput`](crate::input::ListGroupVersionsInput)
pub mod list_group_versions_input {
    /// A builder for [`ListGroupVersionsInput`](crate::input::ListGroupVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupVersionsInput`](crate::input::ListGroupVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupVersionsInput {
                group_id: self.group_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupVersionsInputOperationOutputAlias = crate::operation::ListGroupVersions;
#[doc(hidden)]
pub type ListGroupVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGroupVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListGroupVersions`](crate::operation::ListGroupVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroupVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_128 = &_input.group_id;
            let input_128 =
                input_128
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_128, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/versions",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListGroupVersionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_129) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_129),
                );
            }
            if let Some(inner_130) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_130));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroupVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroupVersions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupVersionsInput`](crate::input::ListGroupVersionsInput)
    pub fn builder() -> crate::input::list_group_versions_input::Builder {
        crate::input::list_group_versions_input::Builder::default()
    }
}

/// See [`ListLoggerDefinitionsInput`](crate::input::ListLoggerDefinitionsInput)
pub mod list_logger_definitions_input {
    /// A builder for [`ListLoggerDefinitionsInput`](crate::input::ListLoggerDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLoggerDefinitionsInput`](crate::input::ListLoggerDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLoggerDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLoggerDefinitionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLoggerDefinitionsInputOperationOutputAlias = crate::operation::ListLoggerDefinitions;
#[doc(hidden)]
pub type ListLoggerDefinitionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLoggerDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListLoggerDefinitions`](crate::operation::ListLoggerDefinitions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLoggerDefinitions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLoggerDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/loggers").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListLoggerDefinitionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_131) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_131),
                );
            }
            if let Some(inner_132) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_132));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLoggerDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLoggerDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLoggerDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLoggerDefinitions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLoggerDefinitionsInput`](crate::input::ListLoggerDefinitionsInput)
    pub fn builder() -> crate::input::list_logger_definitions_input::Builder {
        crate::input::list_logger_definitions_input::Builder::default()
    }
}

/// See [`ListLoggerDefinitionVersionsInput`](crate::input::ListLoggerDefinitionVersionsInput)
pub mod list_logger_definition_versions_input {
    /// A builder for [`ListLoggerDefinitionVersionsInput`](crate::input::ListLoggerDefinitionVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logger_definition_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logger_definition_id = Some(input.into());
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logger_definition_id = input;
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLoggerDefinitionVersionsInput`](crate::input::ListLoggerDefinitionVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLoggerDefinitionVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLoggerDefinitionVersionsInput {
                logger_definition_id: self.logger_definition_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLoggerDefinitionVersionsInputOperationOutputAlias =
    crate::operation::ListLoggerDefinitionVersions;
#[doc(hidden)]
pub type ListLoggerDefinitionVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListLoggerDefinitionVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListLoggerDefinitionVersions`](crate::operation::ListLoggerDefinitionVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLoggerDefinitionVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLoggerDefinitionVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_133 = &_input.logger_definition_id;
            let input_133 =
                input_133
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "logger_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let logger_definition_id = aws_smithy_http::label::fmt_string(input_133, false);
            if logger_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "logger_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/loggers/{LoggerDefinitionId}/versions",
                LoggerDefinitionId = logger_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListLoggerDefinitionVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_134) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_134),
                );
            }
            if let Some(inner_135) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_135));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLoggerDefinitionVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLoggerDefinitionVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLoggerDefinitionVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLoggerDefinitionVersions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLoggerDefinitionVersionsInput`](crate::input::ListLoggerDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_logger_definition_versions_input::Builder {
        crate::input::list_logger_definition_versions_input::Builder::default()
    }
}

/// See [`ListResourceDefinitionsInput`](crate::input::ListResourceDefinitionsInput)
pub mod list_resource_definitions_input {
    /// A builder for [`ListResourceDefinitionsInput`](crate::input::ListResourceDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceDefinitionsInput`](crate::input::ListResourceDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceDefinitionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceDefinitionsInputOperationOutputAlias =
    crate::operation::ListResourceDefinitions;
#[doc(hidden)]
pub type ListResourceDefinitionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResourceDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceDefinitions`](crate::operation::ListResourceDefinitions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceDefinitions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourceDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/resources").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListResourceDefinitionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_136) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_136),
                );
            }
            if let Some(inner_137) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_137));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourceDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourceDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceDefinitions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourceDefinitionsInput`](crate::input::ListResourceDefinitionsInput)
    pub fn builder() -> crate::input::list_resource_definitions_input::Builder {
        crate::input::list_resource_definitions_input::Builder::default()
    }
}

/// See [`ListResourceDefinitionVersionsInput`](crate::input::ListResourceDefinitionVersionsInput)
pub mod list_resource_definition_versions_input {
    /// A builder for [`ListResourceDefinitionVersionsInput`](crate::input::ListResourceDefinitionVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) resource_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_definition_id = Some(input.into());
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceDefinitionVersionsInput`](crate::input::ListResourceDefinitionVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceDefinitionVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceDefinitionVersionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                resource_definition_id: self.resource_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceDefinitionVersionsInputOperationOutputAlias =
    crate::operation::ListResourceDefinitionVersions;
#[doc(hidden)]
pub type ListResourceDefinitionVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResourceDefinitionVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceDefinitionVersions`](crate::operation::ListResourceDefinitionVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceDefinitionVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourceDefinitionVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_138 = &_input.resource_definition_id;
            let input_138 =
                input_138
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_definition_id = aws_smithy_http::label::fmt_string(input_138, false);
            if resource_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/resources/{ResourceDefinitionId}/versions",
                ResourceDefinitionId = resource_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListResourceDefinitionVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_139) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_139),
                );
            }
            if let Some(inner_140) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_140));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourceDefinitionVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourceDefinitionVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceDefinitionVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceDefinitionVersions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourceDefinitionVersionsInput`](crate::input::ListResourceDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_resource_definition_versions_input::Builder {
        crate::input::list_resource_definition_versions_input::Builder::default()
    }
}

/// See [`ListSubscriptionDefinitionsInput`](crate::input::ListSubscriptionDefinitionsInput)
pub mod list_subscription_definitions_input {
    /// A builder for [`ListSubscriptionDefinitionsInput`](crate::input::ListSubscriptionDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSubscriptionDefinitionsInput`](crate::input::ListSubscriptionDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSubscriptionDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSubscriptionDefinitionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSubscriptionDefinitionsInputOperationOutputAlias =
    crate::operation::ListSubscriptionDefinitions;
#[doc(hidden)]
pub type ListSubscriptionDefinitionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSubscriptionDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListSubscriptionDefinitions`](crate::operation::ListSubscriptionDefinitions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSubscriptionDefinitions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSubscriptionDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/definition/subscriptions")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSubscriptionDefinitionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_141) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_141),
                );
            }
            if let Some(inner_142) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_142));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSubscriptionDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSubscriptionDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSubscriptionDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSubscriptionDefinitions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSubscriptionDefinitionsInput`](crate::input::ListSubscriptionDefinitionsInput)
    pub fn builder() -> crate::input::list_subscription_definitions_input::Builder {
        crate::input::list_subscription_definitions_input::Builder::default()
    }
}

/// See [`ListSubscriptionDefinitionVersionsInput`](crate::input::ListSubscriptionDefinitionVersionsInput)
pub mod list_subscription_definition_versions_input {
    /// A builder for [`ListSubscriptionDefinitionVersionsInput`](crate::input::ListSubscriptionDefinitionVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) subscription_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to be returned per request.
        pub fn max_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_results = Some(input.into());
            self
        }
        /// The maximum number of results to be returned per request.
        pub fn set_max_results(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_results = input;
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token for the next set of results, or ''null'' if there are no additional results.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_definition_id = Some(input.into());
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSubscriptionDefinitionVersionsInput`](crate::input::ListSubscriptionDefinitionVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSubscriptionDefinitionVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSubscriptionDefinitionVersionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                subscription_definition_id: self.subscription_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSubscriptionDefinitionVersionsInputOperationOutputAlias =
    crate::operation::ListSubscriptionDefinitionVersions;
#[doc(hidden)]
pub type ListSubscriptionDefinitionVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSubscriptionDefinitionVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListSubscriptionDefinitionVersions`](crate::operation::ListSubscriptionDefinitionVersions)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSubscriptionDefinitionVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSubscriptionDefinitionVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_143 = &_input.subscription_definition_id;
            let input_143 =
                input_143
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscription_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let subscription_definition_id = aws_smithy_http::label::fmt_string(input_143, false);
            if subscription_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "subscription_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}/versions",
                SubscriptionDefinitionId = subscription_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSubscriptionDefinitionVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_144) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_http::query::fmt_string(&inner_144),
                );
            }
            if let Some(inner_145) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_145));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSubscriptionDefinitionVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSubscriptionDefinitionVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSubscriptionDefinitionVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSubscriptionDefinitionVersions",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSubscriptionDefinitionVersionsInput`](crate::input::ListSubscriptionDefinitionVersionsInput)
    pub fn builder() -> crate::input::list_subscription_definition_versions_input::Builder {
        crate::input::list_subscription_definition_versions_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_146 = &_input.resource_arn;
            let input_146 =
                input_146
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_146, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ResetDeploymentsInput`](crate::input::ResetDeploymentsInput)
pub mod reset_deployments_input {
    /// A builder for [`ResetDeploymentsInput`](crate::input::ResetDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// If true, performs a best-effort only core reset.
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// If true, performs a best-effort only core reset.
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetDeploymentsInput`](crate::input::ResetDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResetDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResetDeploymentsInput {
                amzn_client_token: self.amzn_client_token,
                force: self.force.unwrap_or_default(),
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ResetDeploymentsInputOperationOutputAlias = crate::operation::ResetDeployments;
#[doc(hidden)]
pub type ResetDeploymentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResetDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`ResetDeployments`](crate::operation::ResetDeployments)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResetDeployments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResetDeploymentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_147 = &_input.group_id;
            let input_147 =
                input_147
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_147, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/deployments/$reset",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ResetDeploymentsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_148) = &_input.amzn_client_token {
                let formatted_149 = AsRef::<str>::as_ref(inner_148);
                if !formatted_149.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_149;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResetDeploymentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResetDeploymentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reset_deployments(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResetDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResetDeployments",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResetDeploymentsInput`](crate::input::ResetDeploymentsInput)
    pub fn builder() -> crate::input::reset_deployments_input::Builder {
        crate::input::reset_deployments_input::Builder::default()
    }
}

/// See [`StartBulkDeploymentInput`](crate::input::StartBulkDeploymentInput)
pub mod start_bulk_deployment_input {
    /// A builder for [`StartBulkDeploymentInput`](crate::input::StartBulkDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amzn_client_token: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) input_file_uri: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// A client token used to correlate requests and responses.
        pub fn amzn_client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.amzn_client_token = Some(input.into());
            self
        }
        /// A client token used to correlate requests and responses.
        pub fn set_amzn_client_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amzn_client_token = input;
            self
        }
        /// The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow the ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This IAM role must have access to the S3 bucket containing the input file.
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow the ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This IAM role must have access to the S3 bucket containing the input file.
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// The URI of the input file contained in the S3 bucket. The execution role must have ''getObject'' permissions on this bucket to access the input file. The input file is a JSON-serialized, line delimited file with UTF-8 encoding that provides a list of group and version IDs and the deployment type. This file must be less than 100 MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
        pub fn input_file_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_file_uri = Some(input.into());
            self
        }
        /// The URI of the input file contained in the S3 bucket. The execution role must have ''getObject'' permissions on this bucket to access the input file. The input file is a JSON-serialized, line delimited file with UTF-8 encoding that provides a list of group and version IDs and the deployment type. This file must be less than 100 MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
        pub fn set_input_file_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_file_uri = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Tag(s) to add to the new resource.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// Tag(s) to add to the new resource.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBulkDeploymentInput`](crate::input::StartBulkDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartBulkDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartBulkDeploymentInput {
                amzn_client_token: self.amzn_client_token,
                execution_role_arn: self.execution_role_arn,
                input_file_uri: self.input_file_uri,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartBulkDeploymentInputOperationOutputAlias = crate::operation::StartBulkDeployment;
#[doc(hidden)]
pub type StartBulkDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartBulkDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`StartBulkDeployment`](crate::operation::StartBulkDeployment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartBulkDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartBulkDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/greengrass/bulk/deployments").expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::StartBulkDeploymentInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_150) = &_input.amzn_client_token {
                let formatted_151 = AsRef::<str>::as_ref(inner_150);
                if !formatted_151.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_151;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "amzn_client_token",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("X-Amzn-Client-Token", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartBulkDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartBulkDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_bulk_deployment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartBulkDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartBulkDeployment",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartBulkDeploymentInput`](crate::input::StartBulkDeploymentInput)
    pub fn builder() -> crate::input::start_bulk_deployment_input::Builder {
        crate::input::start_bulk_deployment_input::Builder::default()
    }
}

/// See [`StopBulkDeploymentInput`](crate::input::StopBulkDeploymentInput)
pub mod stop_bulk_deployment_input {
    /// A builder for [`StopBulkDeploymentInput`](crate::input::StopBulkDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bulk_deployment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the bulk deployment.
        pub fn bulk_deployment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bulk_deployment_id = Some(input.into());
            self
        }
        /// The ID of the bulk deployment.
        pub fn set_bulk_deployment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bulk_deployment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopBulkDeploymentInput`](crate::input::StopBulkDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopBulkDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopBulkDeploymentInput {
                bulk_deployment_id: self.bulk_deployment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopBulkDeploymentInputOperationOutputAlias = crate::operation::StopBulkDeployment;
#[doc(hidden)]
pub type StopBulkDeploymentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopBulkDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`StopBulkDeployment`](crate::operation::StopBulkDeployment)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopBulkDeployment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopBulkDeploymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_152 = &_input.bulk_deployment_id;
            let input_152 =
                input_152
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bulk_deployment_id",
                        details: "cannot be empty or unset",
                    })?;
            let bulk_deployment_id = aws_smithy_http::label::fmt_string(input_152, false);
            if bulk_deployment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bulk_deployment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/bulk/deployments/{BulkDeploymentId}/$stop",
                BulkDeploymentId = bulk_deployment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopBulkDeploymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopBulkDeploymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopBulkDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopBulkDeployment",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopBulkDeploymentInput`](crate::input::StopBulkDeploymentInput)
    pub fn builder() -> crate::input::stop_bulk_deployment_input::Builder {
        crate::input::stop_bulk_deployment_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The key-value pair for the resource tag.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// The key-value pair for the resource tag.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_153 = &_input.resource_arn;
            let input_153 =
                input_153
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_153, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// An array of tag keys to delete
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// An array of tag keys to delete
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_154 = &_input.resource_arn;
            let input_154 =
                input_154
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_154, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_155) = &_input.tag_keys {
                for inner_156 in inner_155 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_156));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateConnectivityInfoInput`](crate::input::UpdateConnectivityInfoInput)
pub mod update_connectivity_info_input {
    /// A builder for [`UpdateConnectivityInfoInput`](crate::input::UpdateConnectivityInfoInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connectivity_info:
            std::option::Option<std::vec::Vec<crate::model::ConnectivityInfo>>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connectivity_info`.
        ///
        /// To override the contents of this collection use [`set_connectivity_info`](Self::set_connectivity_info).
        ///
        /// A list of connectivity info.
        pub fn connectivity_info(
            mut self,
            input: impl Into<crate::model::ConnectivityInfo>,
        ) -> Self {
            let mut v = self.connectivity_info.unwrap_or_default();
            v.push(input.into());
            self.connectivity_info = Some(v);
            self
        }
        /// A list of connectivity info.
        pub fn set_connectivity_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectivityInfo>>,
        ) -> Self {
            self.connectivity_info = input;
            self
        }
        /// The thing name.
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// The thing name.
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectivityInfoInput`](crate::input::UpdateConnectivityInfoInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConnectivityInfoInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConnectivityInfoInput {
                connectivity_info: self.connectivity_info,
                thing_name: self.thing_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConnectivityInfoInputOperationOutputAlias = crate::operation::UpdateConnectivityInfo;
#[doc(hidden)]
pub type UpdateConnectivityInfoInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateConnectivityInfoInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConnectivityInfo`](crate::operation::UpdateConnectivityInfo)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConnectivityInfo,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConnectivityInfoInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_157 = &_input.thing_name;
            let input_157 =
                input_157
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let thing_name = aws_smithy_http::label::fmt_string(input_157, false);
            if thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/things/{ThingName}/connectivityInfo",
                ThingName = thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConnectivityInfoInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConnectivityInfoInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_connectivity_info(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConnectivityInfo::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConnectivityInfo",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConnectivityInfoInput`](crate::input::UpdateConnectivityInfoInput)
    pub fn builder() -> crate::input::update_connectivity_info_input::Builder {
        crate::input::update_connectivity_info_input::Builder::default()
    }
}

/// See [`UpdateConnectorDefinitionInput`](crate::input::UpdateConnectorDefinitionInput)
pub mod update_connector_definition_input {
    /// A builder for [`UpdateConnectorDefinitionInput`](crate::input::UpdateConnectorDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_definition_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the connector definition.
        pub fn connector_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_definition_id = Some(input.into());
            self
        }
        /// The ID of the connector definition.
        pub fn set_connector_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_definition_id = input;
            self
        }
        /// The name of the definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectorDefinitionInput`](crate::input::UpdateConnectorDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateConnectorDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateConnectorDefinitionInput {
                connector_definition_id: self.connector_definition_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateConnectorDefinitionInputOperationOutputAlias =
    crate::operation::UpdateConnectorDefinition;
#[doc(hidden)]
pub type UpdateConnectorDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateConnectorDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateConnectorDefinition`](crate::operation::UpdateConnectorDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateConnectorDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateConnectorDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_158 = &_input.connector_definition_id;
            let input_158 =
                input_158
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "connector_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let connector_definition_id = aws_smithy_http::label::fmt_string(input_158, false);
            if connector_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "connector_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/connectors/{ConnectorDefinitionId}",
                ConnectorDefinitionId = connector_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateConnectorDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateConnectorDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_connector_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateConnectorDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateConnectorDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateConnectorDefinitionInput`](crate::input::UpdateConnectorDefinitionInput)
    pub fn builder() -> crate::input::update_connector_definition_input::Builder {
        crate::input::update_connector_definition_input::Builder::default()
    }
}

/// See [`UpdateCoreDefinitionInput`](crate::input::UpdateCoreDefinitionInput)
pub mod update_core_definition_input {
    /// A builder for [`UpdateCoreDefinitionInput`](crate::input::UpdateCoreDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) core_definition_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the core definition.
        pub fn core_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.core_definition_id = Some(input.into());
            self
        }
        /// The ID of the core definition.
        pub fn set_core_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.core_definition_id = input;
            self
        }
        /// The name of the definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCoreDefinitionInput`](crate::input::UpdateCoreDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCoreDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCoreDefinitionInput {
                core_definition_id: self.core_definition_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCoreDefinitionInputOperationOutputAlias = crate::operation::UpdateCoreDefinition;
#[doc(hidden)]
pub type UpdateCoreDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateCoreDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCoreDefinition`](crate::operation::UpdateCoreDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCoreDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCoreDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_159 = &_input.core_definition_id;
            let input_159 =
                input_159
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "core_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let core_definition_id = aws_smithy_http::label::fmt_string(input_159, false);
            if core_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "core_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/cores/{CoreDefinitionId}",
                CoreDefinitionId = core_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCoreDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCoreDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_core_definition(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCoreDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCoreDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCoreDefinitionInput`](crate::input::UpdateCoreDefinitionInput)
    pub fn builder() -> crate::input::update_core_definition_input::Builder {
        crate::input::update_core_definition_input::Builder::default()
    }
}

/// See [`UpdateDeviceDefinitionInput`](crate::input::UpdateDeviceDefinitionInput)
pub mod update_device_definition_input {
    /// A builder for [`UpdateDeviceDefinitionInput`](crate::input::UpdateDeviceDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_definition_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the device definition.
        pub fn device_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_definition_id = Some(input.into());
            self
        }
        /// The ID of the device definition.
        pub fn set_device_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_definition_id = input;
            self
        }
        /// The name of the definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDeviceDefinitionInput`](crate::input::UpdateDeviceDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDeviceDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDeviceDefinitionInput {
                device_definition_id: self.device_definition_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDeviceDefinitionInputOperationOutputAlias = crate::operation::UpdateDeviceDefinition;
#[doc(hidden)]
pub type UpdateDeviceDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDeviceDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDeviceDefinition`](crate::operation::UpdateDeviceDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDeviceDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDeviceDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_160 = &_input.device_definition_id;
            let input_160 =
                input_160
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let device_definition_id = aws_smithy_http::label::fmt_string(input_160, false);
            if device_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "device_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/devices/{DeviceDefinitionId}",
                DeviceDefinitionId = device_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDeviceDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDeviceDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_device_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDeviceDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDeviceDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDeviceDefinitionInput`](crate::input::UpdateDeviceDefinitionInput)
    pub fn builder() -> crate::input::update_device_definition_input::Builder {
        crate::input::update_device_definition_input::Builder::default()
    }
}

/// See [`UpdateFunctionDefinitionInput`](crate::input::UpdateFunctionDefinitionInput)
pub mod update_function_definition_input {
    /// A builder for [`UpdateFunctionDefinitionInput`](crate::input::UpdateFunctionDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_definition_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Lambda function definition.
        pub fn function_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_definition_id = Some(input.into());
            self
        }
        /// The ID of the Lambda function definition.
        pub fn set_function_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_definition_id = input;
            self
        }
        /// The name of the definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionDefinitionInput`](crate::input::UpdateFunctionDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFunctionDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFunctionDefinitionInput {
                function_definition_id: self.function_definition_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFunctionDefinitionInputOperationOutputAlias =
    crate::operation::UpdateFunctionDefinition;
#[doc(hidden)]
pub type UpdateFunctionDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFunctionDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFunctionDefinition`](crate::operation::UpdateFunctionDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFunctionDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFunctionDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_161 = &_input.function_definition_id;
            let input_161 =
                input_161
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let function_definition_id = aws_smithy_http::label::fmt_string(input_161, false);
            if function_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "function_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/functions/{FunctionDefinitionId}",
                FunctionDefinitionId = function_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFunctionDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFunctionDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_function_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFunctionDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFunctionDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFunctionDefinitionInput`](crate::input::UpdateFunctionDefinitionInput)
    pub fn builder() -> crate::input::update_function_definition_input::Builder {
        crate::input::update_function_definition_input::Builder::default()
    }
}

/// See [`UpdateGroupInput`](crate::input::UpdateGroupInput)
pub mod update_group_input {
    /// A builder for [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// The name of the definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupInput`](crate::input::UpdateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGroupInput {
                group_id: self.group_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGroupInputOperationOutputAlias = crate::operation::UpdateGroup;
#[doc(hidden)]
pub type UpdateGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGroup`](crate::operation::UpdateGroup)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_162 = &_input.group_id;
            let input_162 =
                input_162
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_162, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/greengrass/groups/{GroupId}", GroupId = group_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_group(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGroup",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    pub fn builder() -> crate::input::update_group_input::Builder {
        crate::input::update_group_input::Builder::default()
    }
}

/// See [`UpdateGroupCertificateConfigurationInput`](crate::input::UpdateGroupCertificateConfigurationInput)
pub mod update_group_certificate_configuration_input {
    /// A builder for [`UpdateGroupCertificateConfigurationInput`](crate::input::UpdateGroupCertificateConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_expiry_in_milliseconds: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The amount of time remaining before the certificate expires, in milliseconds.
        pub fn certificate_expiry_in_milliseconds(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.certificate_expiry_in_milliseconds = Some(input.into());
            self
        }
        /// The amount of time remaining before the certificate expires, in milliseconds.
        pub fn set_certificate_expiry_in_milliseconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_expiry_in_milliseconds = input;
            self
        }
        /// The ID of the Greengrass group.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// The ID of the Greengrass group.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupCertificateConfigurationInput`](crate::input::UpdateGroupCertificateConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGroupCertificateConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGroupCertificateConfigurationInput {
                certificate_expiry_in_milliseconds: self.certificate_expiry_in_milliseconds,
                group_id: self.group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGroupCertificateConfigurationInputOperationOutputAlias =
    crate::operation::UpdateGroupCertificateConfiguration;
#[doc(hidden)]
pub type UpdateGroupCertificateConfigurationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl UpdateGroupCertificateConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGroupCertificateConfiguration`](crate::operation::UpdateGroupCertificateConfiguration)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGroupCertificateConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGroupCertificateConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_163 = &_input.group_id;
            let input_163 =
                input_163
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "group_id",
                        details: "cannot be empty or unset",
                    })?;
            let group_id = aws_smithy_http::label::fmt_string(input_163, false);
            if group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/groups/{GroupId}/certificateauthorities/configuration/expiry",
                GroupId = group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGroupCertificateConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGroupCertificateConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_group_certificate_configuration(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGroupCertificateConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGroupCertificateConfiguration",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGroupCertificateConfigurationInput`](crate::input::UpdateGroupCertificateConfigurationInput)
    pub fn builder() -> crate::input::update_group_certificate_configuration_input::Builder {
        crate::input::update_group_certificate_configuration_input::Builder::default()
    }
}

/// See [`UpdateLoggerDefinitionInput`](crate::input::UpdateLoggerDefinitionInput)
pub mod update_logger_definition_input {
    /// A builder for [`UpdateLoggerDefinitionInput`](crate::input::UpdateLoggerDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logger_definition_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ID of the logger definition.
        pub fn logger_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.logger_definition_id = Some(input.into());
            self
        }
        /// The ID of the logger definition.
        pub fn set_logger_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logger_definition_id = input;
            self
        }
        /// The name of the definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLoggerDefinitionInput`](crate::input::UpdateLoggerDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLoggerDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLoggerDefinitionInput {
                logger_definition_id: self.logger_definition_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLoggerDefinitionInputOperationOutputAlias = crate::operation::UpdateLoggerDefinition;
#[doc(hidden)]
pub type UpdateLoggerDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateLoggerDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLoggerDefinition`](crate::operation::UpdateLoggerDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLoggerDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateLoggerDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_164 = &_input.logger_definition_id;
            let input_164 =
                input_164
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "logger_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let logger_definition_id = aws_smithy_http::label::fmt_string(input_164, false);
            if logger_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "logger_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/loggers/{LoggerDefinitionId}",
                LoggerDefinitionId = logger_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateLoggerDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateLoggerDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_logger_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLoggerDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLoggerDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateLoggerDefinitionInput`](crate::input::UpdateLoggerDefinitionInput)
    pub fn builder() -> crate::input::update_logger_definition_input::Builder {
        crate::input::update_logger_definition_input::Builder::default()
    }
}

/// See [`UpdateResourceDefinitionInput`](crate::input::UpdateResourceDefinitionInput)
pub mod update_resource_definition_input {
    /// A builder for [`UpdateResourceDefinitionInput`](crate::input::UpdateResourceDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name of the definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The ID of the resource definition.
        pub fn resource_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_definition_id = Some(input.into());
            self
        }
        /// The ID of the resource definition.
        pub fn set_resource_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceDefinitionInput`](crate::input::UpdateResourceDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResourceDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResourceDefinitionInput {
                name: self.name,
                resource_definition_id: self.resource_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResourceDefinitionInputOperationOutputAlias =
    crate::operation::UpdateResourceDefinition;
#[doc(hidden)]
pub type UpdateResourceDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateResourceDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResourceDefinition`](crate::operation::UpdateResourceDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResourceDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResourceDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_165 = &_input.resource_definition_id;
            let input_165 =
                input_165
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_definition_id = aws_smithy_http::label::fmt_string(input_165, false);
            if resource_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/resources/{ResourceDefinitionId}",
                ResourceDefinitionId = resource_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResourceDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResourceDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_resource_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResourceDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResourceDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResourceDefinitionInput`](crate::input::UpdateResourceDefinitionInput)
    pub fn builder() -> crate::input::update_resource_definition_input::Builder {
        crate::input::update_resource_definition_input::Builder::default()
    }
}

/// See [`UpdateSubscriptionDefinitionInput`](crate::input::UpdateSubscriptionDefinitionInput)
pub mod update_subscription_definition_input {
    /// A builder for [`UpdateSubscriptionDefinitionInput`](crate::input::UpdateSubscriptionDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) subscription_definition_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name of the definition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the definition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The ID of the subscription definition.
        pub fn subscription_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_definition_id = Some(input.into());
            self
        }
        /// The ID of the subscription definition.
        pub fn set_subscription_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_definition_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSubscriptionDefinitionInput`](crate::input::UpdateSubscriptionDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSubscriptionDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSubscriptionDefinitionInput {
                name: self.name,
                subscription_definition_id: self.subscription_definition_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSubscriptionDefinitionInputOperationOutputAlias =
    crate::operation::UpdateSubscriptionDefinition;
#[doc(hidden)]
pub type UpdateSubscriptionDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSubscriptionDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSubscriptionDefinition`](crate::operation::UpdateSubscriptionDefinition)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSubscriptionDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSubscriptionDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_166 = &_input.subscription_definition_id;
            let input_166 =
                input_166
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "subscription_definition_id",
                        details: "cannot be empty or unset",
                    })?;
            let subscription_definition_id = aws_smithy_http::label::fmt_string(input_166, false);
            if subscription_definition_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "subscription_definition_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/definition/subscriptions/{SubscriptionDefinitionId}",
                SubscriptionDefinitionId = subscription_definition_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSubscriptionDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSubscriptionDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_subscription_definition(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSubscriptionDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSubscriptionDefinition",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSubscriptionDefinitionInput`](crate::input::UpdateSubscriptionDefinitionInput)
    pub fn builder() -> crate::input::update_subscription_definition_input::Builder {
        crate::input::update_subscription_definition_input::Builder::default()
    }
}

/// See [`UpdateThingRuntimeConfigurationInput`](crate::input::UpdateThingRuntimeConfigurationInput)
pub mod update_thing_runtime_configuration_input {
    /// A builder for [`UpdateThingRuntimeConfigurationInput`](crate::input::UpdateThingRuntimeConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) telemetry_configuration:
            std::option::Option<crate::model::TelemetryConfigurationUpdate>,
        pub(crate) thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Configuration for telemetry service.
        pub fn telemetry_configuration(
            mut self,
            input: crate::model::TelemetryConfigurationUpdate,
        ) -> Self {
            self.telemetry_configuration = Some(input);
            self
        }
        /// Configuration for telemetry service.
        pub fn set_telemetry_configuration(
            mut self,
            input: std::option::Option<crate::model::TelemetryConfigurationUpdate>,
        ) -> Self {
            self.telemetry_configuration = input;
            self
        }
        /// The thing name.
        pub fn thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.thing_name = Some(input.into());
            self
        }
        /// The thing name.
        pub fn set_thing_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateThingRuntimeConfigurationInput`](crate::input::UpdateThingRuntimeConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateThingRuntimeConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateThingRuntimeConfigurationInput {
                telemetry_configuration: self.telemetry_configuration,
                thing_name: self.thing_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateThingRuntimeConfigurationInputOperationOutputAlias =
    crate::operation::UpdateThingRuntimeConfiguration;
#[doc(hidden)]
pub type UpdateThingRuntimeConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateThingRuntimeConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateThingRuntimeConfiguration`](crate::operation::UpdateThingRuntimeConfiguration)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateThingRuntimeConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateThingRuntimeConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_167 = &_input.thing_name;
            let input_167 =
                input_167
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "thing_name",
                        details: "cannot be empty or unset",
                    })?;
            let thing_name = aws_smithy_http::label::fmt_string(input_167, false);
            if thing_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "thing_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/greengrass/things/{ThingName}/runtimeconfig",
                ThingName = thing_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateThingRuntimeConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateThingRuntimeConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_thing_runtime_configuration(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateThingRuntimeConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateThingRuntimeConfiguration",
            "greengrass",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateThingRuntimeConfigurationInput`](crate::input::UpdateThingRuntimeConfigurationInput)
    pub fn builder() -> crate::input::update_thing_runtime_configuration_input::Builder {
        crate::input::update_thing_runtime_configuration_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThingRuntimeConfigurationInput {
    /// Configuration for telemetry service.
    pub telemetry_configuration: std::option::Option<crate::model::TelemetryConfigurationUpdate>,
    /// The thing name.
    pub thing_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateThingRuntimeConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThingRuntimeConfigurationInput");
        formatter.field("telemetry_configuration", &self.telemetry_configuration);
        formatter.field("thing_name", &self.thing_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSubscriptionDefinitionInput {
    /// The name of the definition.
    pub name: std::option::Option<std::string::String>,
    /// The ID of the subscription definition.
    pub subscription_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateSubscriptionDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSubscriptionDefinitionInput");
        formatter.field("name", &self.name);
        formatter.field(
            "subscription_definition_id",
            &self.subscription_definition_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceDefinitionInput {
    /// The name of the definition.
    pub name: std::option::Option<std::string::String>,
    /// The ID of the resource definition.
    pub resource_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateResourceDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceDefinitionInput");
        formatter.field("name", &self.name);
        formatter.field("resource_definition_id", &self.resource_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLoggerDefinitionInput {
    /// The ID of the logger definition.
    pub logger_definition_id: std::option::Option<std::string::String>,
    /// The name of the definition.
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateLoggerDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLoggerDefinitionInput");
        formatter.field("logger_definition_id", &self.logger_definition_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupCertificateConfigurationInput {
    /// The amount of time remaining before the certificate expires, in milliseconds.
    pub certificate_expiry_in_milliseconds: std::option::Option<std::string::String>,
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateGroupCertificateConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupCertificateConfigurationInput");
        formatter.field(
            "certificate_expiry_in_milliseconds",
            &self.certificate_expiry_in_milliseconds,
        );
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
    /// The name of the definition.
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupInput");
        formatter.field("group_id", &self.group_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionDefinitionInput {
    /// The ID of the Lambda function definition.
    pub function_definition_id: std::option::Option<std::string::String>,
    /// The name of the definition.
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateFunctionDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionDefinitionInput");
        formatter.field("function_definition_id", &self.function_definition_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceDefinitionInput {
    /// The ID of the device definition.
    pub device_definition_id: std::option::Option<std::string::String>,
    /// The name of the definition.
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateDeviceDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceDefinitionInput");
        formatter.field("device_definition_id", &self.device_definition_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCoreDefinitionInput {
    /// The ID of the core definition.
    pub core_definition_id: std::option::Option<std::string::String>,
    /// The name of the definition.
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateCoreDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCoreDefinitionInput");
        formatter.field("core_definition_id", &self.core_definition_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectorDefinitionInput {
    /// The ID of the connector definition.
    pub connector_definition_id: std::option::Option<std::string::String>,
    /// The name of the definition.
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateConnectorDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectorDefinitionInput");
        formatter.field("connector_definition_id", &self.connector_definition_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// Connectivity information.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectivityInfoInput {
    /// A list of connectivity info.
    pub connectivity_info: std::option::Option<std::vec::Vec<crate::model::ConnectivityInfo>>,
    /// The thing name.
    pub thing_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateConnectivityInfoInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectivityInfoInput");
        formatter.field("connectivity_info", &self.connectivity_info);
        formatter.field("thing_name", &self.thing_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// The Amazon Resource Name (ARN) of the resource.
    pub resource_arn: std::option::Option<std::string::String>,
    /// An array of tag keys to delete
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// A map of the key-value pairs for the resource tag.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// The Amazon Resource Name (ARN) of the resource.
    pub resource_arn: std::option::Option<std::string::String>,
    /// The key-value pair for the resource tag.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopBulkDeploymentInput {
    /// The ID of the bulk deployment.
    pub bulk_deployment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopBulkDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopBulkDeploymentInput");
        formatter.field("bulk_deployment_id", &self.bulk_deployment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBulkDeploymentInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow the ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This IAM role must have access to the S3 bucket containing the input file.
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// The URI of the input file contained in the S3 bucket. The execution role must have ''getObject'' permissions on this bucket to access the input file. The input file is a JSON-serialized, line delimited file with UTF-8 encoding that provides a list of group and version IDs and the deployment type. This file must be less than 100 MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
    pub input_file_uri: std::option::Option<std::string::String>,
    /// Tag(s) to add to the new resource.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for StartBulkDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartBulkDeploymentInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("input_file_uri", &self.input_file_uri);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// Information needed to reset deployments.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetDeploymentsInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// If true, performs a best-effort only core reset.
    pub force: bool,
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResetDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetDeploymentsInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("force", &self.force);
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// The Amazon Resource Name (ARN) of the resource.
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSubscriptionDefinitionVersionsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
    /// The ID of the subscription definition.
    pub subscription_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSubscriptionDefinitionVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSubscriptionDefinitionVersionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "subscription_definition_id",
            &self.subscription_definition_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSubscriptionDefinitionsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSubscriptionDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSubscriptionDefinitionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceDefinitionVersionsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
    /// The ID of the resource definition.
    pub resource_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListResourceDefinitionVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceDefinitionVersionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("resource_definition_id", &self.resource_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceDefinitionsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListResourceDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceDefinitionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLoggerDefinitionVersionsInput {
    /// The ID of the logger definition.
    pub logger_definition_id: std::option::Option<std::string::String>,
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListLoggerDefinitionVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLoggerDefinitionVersionsInput");
        formatter.field("logger_definition_id", &self.logger_definition_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLoggerDefinitionsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListLoggerDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLoggerDefinitionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupVersionsInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListGroupVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupVersionsInput");
        formatter.field("group_id", &self.group_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupCertificateAuthoritiesInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListGroupCertificateAuthoritiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupCertificateAuthoritiesInput");
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionDefinitionVersionsInput {
    /// The ID of the Lambda function definition.
    pub function_definition_id: std::option::Option<std::string::String>,
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListFunctionDefinitionVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionDefinitionVersionsInput");
        formatter.field("function_definition_id", &self.function_definition_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionDefinitionsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListFunctionDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionDefinitionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeviceDefinitionVersionsInput {
    /// The ID of the device definition.
    pub device_definition_id: std::option::Option<std::string::String>,
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeviceDefinitionVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeviceDefinitionVersionsInput");
        formatter.field("device_definition_id", &self.device_definition_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeviceDefinitionsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeviceDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeviceDefinitionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentsInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentsInput");
        formatter.field("group_id", &self.group_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCoreDefinitionVersionsInput {
    /// The ID of the core definition.
    pub core_definition_id: std::option::Option<std::string::String>,
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListCoreDefinitionVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCoreDefinitionVersionsInput");
        formatter.field("core_definition_id", &self.core_definition_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCoreDefinitionsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListCoreDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCoreDefinitionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConnectorDefinitionVersionsInput {
    /// The ID of the connector definition.
    pub connector_definition_id: std::option::Option<std::string::String>,
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListConnectorDefinitionVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConnectorDefinitionVersionsInput");
        formatter.field("connector_definition_id", &self.connector_definition_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConnectorDefinitionsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListConnectorDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConnectorDefinitionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBulkDeploymentsInput {
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListBulkDeploymentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBulkDeploymentsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBulkDeploymentDetailedReportsInput {
    /// The ID of the bulk deployment.
    pub bulk_deployment_id: std::option::Option<std::string::String>,
    /// The maximum number of results to be returned per request.
    pub max_results: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListBulkDeploymentDetailedReportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBulkDeploymentDetailedReportsInput");
        formatter.field("bulk_deployment_id", &self.bulk_deployment_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetThingRuntimeConfigurationInput {
    /// The thing name.
    pub thing_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetThingRuntimeConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetThingRuntimeConfigurationInput");
        formatter.field("thing_name", &self.thing_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSubscriptionDefinitionVersionInput {
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
    /// The ID of the subscription definition.
    pub subscription_definition_id: std::option::Option<std::string::String>,
    /// The ID of the subscription definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListSubscriptionDefinitionVersions'' requests. If the version is the last one that was associated with a subscription definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
    pub subscription_definition_version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSubscriptionDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSubscriptionDefinitionVersionInput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "subscription_definition_id",
            &self.subscription_definition_id,
        );
        formatter.field(
            "subscription_definition_version_id",
            &self.subscription_definition_version_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSubscriptionDefinitionInput {
    /// The ID of the subscription definition.
    pub subscription_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSubscriptionDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSubscriptionDefinitionInput");
        formatter.field(
            "subscription_definition_id",
            &self.subscription_definition_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceRoleForAccountInput {}
impl std::fmt::Debug for GetServiceRoleForAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceRoleForAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceDefinitionVersionInput {
    /// The ID of the resource definition.
    pub resource_definition_id: std::option::Option<std::string::String>,
    /// The ID of the resource definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListResourceDefinitionVersions'' requests. If the version is the last one that was associated with a resource definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
    pub resource_definition_version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResourceDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceDefinitionVersionInput");
        formatter.field("resource_definition_id", &self.resource_definition_id);
        formatter.field(
            "resource_definition_version_id",
            &self.resource_definition_version_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceDefinitionInput {
    /// The ID of the resource definition.
    pub resource_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResourceDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceDefinitionInput");
        formatter.field("resource_definition_id", &self.resource_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLoggerDefinitionVersionInput {
    /// The ID of the logger definition.
    pub logger_definition_id: std::option::Option<std::string::String>,
    /// The ID of the logger definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListLoggerDefinitionVersions'' requests. If the version is the last one that was associated with a logger definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
    pub logger_definition_version_id: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetLoggerDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLoggerDefinitionVersionInput");
        formatter.field("logger_definition_id", &self.logger_definition_id);
        formatter.field(
            "logger_definition_version_id",
            &self.logger_definition_version_id,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLoggerDefinitionInput {
    /// The ID of the logger definition.
    pub logger_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetLoggerDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLoggerDefinitionInput");
        formatter.field("logger_definition_id", &self.logger_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupVersionInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
    /// The ID of the group version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListGroupVersions'' requests. If the version is the last one that was associated with a group, the value also maps to the ''LatestVersion'' property of the corresponding ''GroupInformation'' object.
    pub group_version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetGroupVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupVersionInput");
        formatter.field("group_id", &self.group_id);
        formatter.field("group_version_id", &self.group_version_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupCertificateConfigurationInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetGroupCertificateConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupCertificateConfigurationInput");
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupCertificateAuthorityInput {
    /// The ID of the certificate authority.
    pub certificate_authority_id: std::option::Option<std::string::String>,
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetGroupCertificateAuthorityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupCertificateAuthorityInput");
        formatter.field("certificate_authority_id", &self.certificate_authority_id);
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupInput");
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionDefinitionVersionInput {
    /// The ID of the Lambda function definition.
    pub function_definition_id: std::option::Option<std::string::String>,
    /// The ID of the function definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListFunctionDefinitionVersions'' requests. If the version is the last one that was associated with a function definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
    pub function_definition_version_id: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetFunctionDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionDefinitionVersionInput");
        formatter.field("function_definition_id", &self.function_definition_id);
        formatter.field(
            "function_definition_version_id",
            &self.function_definition_version_id,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionDefinitionInput {
    /// The ID of the Lambda function definition.
    pub function_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetFunctionDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionDefinitionInput");
        formatter.field("function_definition_id", &self.function_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceDefinitionVersionInput {
    /// The ID of the device definition.
    pub device_definition_id: std::option::Option<std::string::String>,
    /// The ID of the device definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListDeviceDefinitionVersions'' requests. If the version is the last one that was associated with a device definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
    pub device_definition_version_id: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDeviceDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceDefinitionVersionInput");
        formatter.field("device_definition_id", &self.device_definition_id);
        formatter.field(
            "device_definition_version_id",
            &self.device_definition_version_id,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceDefinitionInput {
    /// The ID of the device definition.
    pub device_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDeviceDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceDefinitionInput");
        formatter.field("device_definition_id", &self.device_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeploymentStatusInput {
    /// The ID of the deployment.
    pub deployment_id: std::option::Option<std::string::String>,
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDeploymentStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeploymentStatusInput");
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCoreDefinitionVersionInput {
    /// The ID of the core definition.
    pub core_definition_id: std::option::Option<std::string::String>,
    /// The ID of the core definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListCoreDefinitionVersions'' requests. If the version is the last one that was associated with a core definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
    pub core_definition_version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCoreDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCoreDefinitionVersionInput");
        formatter.field("core_definition_id", &self.core_definition_id);
        formatter.field(
            "core_definition_version_id",
            &self.core_definition_version_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCoreDefinitionInput {
    /// The ID of the core definition.
    pub core_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCoreDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCoreDefinitionInput");
        formatter.field("core_definition_id", &self.core_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectorDefinitionVersionInput {
    /// The ID of the connector definition.
    pub connector_definition_id: std::option::Option<std::string::String>,
    /// The ID of the connector definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListConnectorDefinitionVersions'' requests. If the version is the last one that was associated with a connector definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
    pub connector_definition_version_id: std::option::Option<std::string::String>,
    /// The token for the next set of results, or ''null'' if there are no additional results.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetConnectorDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectorDefinitionVersionInput");
        formatter.field("connector_definition_id", &self.connector_definition_id);
        formatter.field(
            "connector_definition_version_id",
            &self.connector_definition_version_id,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectorDefinitionInput {
    /// The ID of the connector definition.
    pub connector_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetConnectorDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectorDefinitionInput");
        formatter.field("connector_definition_id", &self.connector_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectivityInfoInput {
    /// The thing name.
    pub thing_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetConnectivityInfoInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectivityInfoInput");
        formatter.field("thing_name", &self.thing_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBulkDeploymentStatusInput {
    /// The ID of the bulk deployment.
    pub bulk_deployment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetBulkDeploymentStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBulkDeploymentStatusInput");
        formatter.field("bulk_deployment_id", &self.bulk_deployment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssociatedRoleInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetAssociatedRoleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssociatedRoleInput");
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateServiceRoleFromAccountInput {}
impl std::fmt::Debug for DisassociateServiceRoleFromAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateServiceRoleFromAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateRoleFromGroupInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateRoleFromGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateRoleFromGroupInput");
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSubscriptionDefinitionInput {
    /// The ID of the subscription definition.
    pub subscription_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSubscriptionDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSubscriptionDefinitionInput");
        formatter.field(
            "subscription_definition_id",
            &self.subscription_definition_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourceDefinitionInput {
    /// The ID of the resource definition.
    pub resource_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteResourceDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourceDefinitionInput");
        formatter.field("resource_definition_id", &self.resource_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLoggerDefinitionInput {
    /// The ID of the logger definition.
    pub logger_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteLoggerDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLoggerDefinitionInput");
        formatter.field("logger_definition_id", &self.logger_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupInput");
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionDefinitionInput {
    /// The ID of the Lambda function definition.
    pub function_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteFunctionDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionDefinitionInput");
        formatter.field("function_definition_id", &self.function_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDeviceDefinitionInput {
    /// The ID of the device definition.
    pub device_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDeviceDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDeviceDefinitionInput");
        formatter.field("device_definition_id", &self.device_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCoreDefinitionInput {
    /// The ID of the core definition.
    pub core_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteCoreDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCoreDefinitionInput");
        formatter.field("core_definition_id", &self.core_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectorDefinitionInput {
    /// The ID of the connector definition.
    pub connector_definition_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteConnectorDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectorDefinitionInput");
        formatter.field("connector_definition_id", &self.connector_definition_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSubscriptionDefinitionVersionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The ID of the subscription definition.
    pub subscription_definition_id: std::option::Option<std::string::String>,
    /// A list of subscriptions.
    pub subscriptions: std::option::Option<std::vec::Vec<crate::model::Subscription>>,
}
impl std::fmt::Debug for CreateSubscriptionDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSubscriptionDefinitionVersionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field(
            "subscription_definition_id",
            &self.subscription_definition_id,
        );
        formatter.field("subscriptions", &self.subscriptions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSubscriptionDefinitionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// Information about the initial version of the subscription definition.
    pub initial_version: std::option::Option<crate::model::SubscriptionDefinitionVersion>,
    /// The name of the subscription definition.
    pub name: std::option::Option<std::string::String>,
    /// Tag(s) to add to the new resource.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateSubscriptionDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSubscriptionDefinitionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("initial_version", &self.initial_version);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSoftwareUpdateJobInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The IAM Role that Greengrass will use to create pre-signed URLs pointing towards the update artifact.
    pub s3_url_signer_role: std::option::Option<std::string::String>,
    /// The piece of software on the Greengrass core that will be updated.
    pub software_to_update: std::option::Option<crate::model::SoftwareToUpdate>,
    /// The minimum level of log statements that should be logged by the OTA Agent during an update.
    pub update_agent_log_level: std::option::Option<crate::model::UpdateAgentLogLevel>,
    /// The ARNs of the targets (IoT things or IoT thing groups) that this update will be applied to.
    pub update_targets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The architecture of the cores which are the targets of an update.
    pub update_targets_architecture: std::option::Option<crate::model::UpdateTargetsArchitecture>,
    /// The operating system of the cores which are the targets of an update.
    pub update_targets_operating_system:
        std::option::Option<crate::model::UpdateTargetsOperatingSystem>,
}
impl std::fmt::Debug for CreateSoftwareUpdateJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSoftwareUpdateJobInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("s3_url_signer_role", &self.s3_url_signer_role);
        formatter.field("software_to_update", &self.software_to_update);
        formatter.field("update_agent_log_level", &self.update_agent_log_level);
        formatter.field("update_targets", &self.update_targets);
        formatter.field(
            "update_targets_architecture",
            &self.update_targets_architecture,
        );
        formatter.field(
            "update_targets_operating_system",
            &self.update_targets_operating_system,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourceDefinitionVersionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The ID of the resource definition.
    pub resource_definition_id: std::option::Option<std::string::String>,
    /// A list of resources.
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
}
impl std::fmt::Debug for CreateResourceDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourceDefinitionVersionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("resource_definition_id", &self.resource_definition_id);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourceDefinitionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// Information about the initial version of the resource definition.
    pub initial_version: std::option::Option<crate::model::ResourceDefinitionVersion>,
    /// The name of the resource definition.
    pub name: std::option::Option<std::string::String>,
    /// Tag(s) to add to the new resource.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateResourceDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourceDefinitionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("initial_version", &self.initial_version);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLoggerDefinitionVersionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The ID of the logger definition.
    pub logger_definition_id: std::option::Option<std::string::String>,
    /// A list of loggers.
    pub loggers: std::option::Option<std::vec::Vec<crate::model::Logger>>,
}
impl std::fmt::Debug for CreateLoggerDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLoggerDefinitionVersionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("logger_definition_id", &self.logger_definition_id);
        formatter.field("loggers", &self.loggers);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLoggerDefinitionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// Information about the initial version of the logger definition.
    pub initial_version: std::option::Option<crate::model::LoggerDefinitionVersion>,
    /// The name of the logger definition.
    pub name: std::option::Option<std::string::String>,
    /// Tag(s) to add to the new resource.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateLoggerDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLoggerDefinitionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("initial_version", &self.initial_version);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupVersionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The ARN of the connector definition version for this group.
    pub connector_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the core definition version for this group.
    pub core_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the device definition version for this group.
    pub device_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the function definition version for this group.
    pub function_definition_version_arn: std::option::Option<std::string::String>,
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
    /// The ARN of the logger definition version for this group.
    pub logger_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the resource definition version for this group.
    pub resource_definition_version_arn: std::option::Option<std::string::String>,
    /// The ARN of the subscription definition version for this group.
    pub subscription_definition_version_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateGroupVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupVersionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field(
            "connector_definition_version_arn",
            &self.connector_definition_version_arn,
        );
        formatter.field(
            "core_definition_version_arn",
            &self.core_definition_version_arn,
        );
        formatter.field(
            "device_definition_version_arn",
            &self.device_definition_version_arn,
        );
        formatter.field(
            "function_definition_version_arn",
            &self.function_definition_version_arn,
        );
        formatter.field("group_id", &self.group_id);
        formatter.field(
            "logger_definition_version_arn",
            &self.logger_definition_version_arn,
        );
        formatter.field(
            "resource_definition_version_arn",
            &self.resource_definition_version_arn,
        );
        formatter.field(
            "subscription_definition_version_arn",
            &self.subscription_definition_version_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupCertificateAuthorityInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateGroupCertificateAuthorityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupCertificateAuthorityInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// Information about the initial version of the group.
    pub initial_version: std::option::Option<crate::model::GroupVersion>,
    /// The name of the group.
    pub name: std::option::Option<std::string::String>,
    /// Tag(s) to add to the new resource.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("initial_version", &self.initial_version);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// Information needed to create a function definition version.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFunctionDefinitionVersionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The default configuration that applies to all Lambda functions in this function definition version. Individual Lambda functions can override these settings.
    pub default_config: std::option::Option<crate::model::FunctionDefaultConfig>,
    /// The ID of the Lambda function definition.
    pub function_definition_id: std::option::Option<std::string::String>,
    /// A list of Lambda functions in this function definition version.
    pub functions: std::option::Option<std::vec::Vec<crate::model::Function>>,
}
impl std::fmt::Debug for CreateFunctionDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFunctionDefinitionVersionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("default_config", &self.default_config);
        formatter.field("function_definition_id", &self.function_definition_id);
        formatter.field("functions", &self.functions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFunctionDefinitionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// Information about the initial version of the function definition.
    pub initial_version: std::option::Option<crate::model::FunctionDefinitionVersion>,
    /// The name of the function definition.
    pub name: std::option::Option<std::string::String>,
    /// Tag(s) to add to the new resource.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateFunctionDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFunctionDefinitionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("initial_version", &self.initial_version);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeviceDefinitionVersionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The ID of the device definition.
    pub device_definition_id: std::option::Option<std::string::String>,
    /// A list of devices in the definition version.
    pub devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
}
impl std::fmt::Debug for CreateDeviceDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeviceDefinitionVersionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("device_definition_id", &self.device_definition_id);
        formatter.field("devices", &self.devices);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeviceDefinitionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// Information about the initial version of the device definition.
    pub initial_version: std::option::Option<crate::model::DeviceDefinitionVersion>,
    /// The name of the device definition.
    pub name: std::option::Option<std::string::String>,
    /// Tag(s) to add to the new resource.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateDeviceDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeviceDefinitionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("initial_version", &self.initial_version);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The ID of the deployment if you wish to redeploy a previous deployment.
    pub deployment_id: std::option::Option<std::string::String>,
    /// The type of deployment. When used for ''CreateDeployment'', only ''NewDeployment'' and ''Redeployment'' are valid.
    pub deployment_type: std::option::Option<crate::model::DeploymentType>,
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
    /// The ID of the group version to be deployed.
    pub group_version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateDeploymentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("deployment_id", &self.deployment_id);
        formatter.field("deployment_type", &self.deployment_type);
        formatter.field("group_id", &self.group_id);
        formatter.field("group_version_id", &self.group_version_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCoreDefinitionVersionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The ID of the core definition.
    pub core_definition_id: std::option::Option<std::string::String>,
    /// A list of cores in the core definition version.
    pub cores: std::option::Option<std::vec::Vec<crate::model::Core>>,
}
impl std::fmt::Debug for CreateCoreDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCoreDefinitionVersionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("core_definition_id", &self.core_definition_id);
        formatter.field("cores", &self.cores);
        formatter.finish()
    }
}

/// Information needed to create a core definition.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCoreDefinitionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// Information about the initial version of the core definition.
    pub initial_version: std::option::Option<crate::model::CoreDefinitionVersion>,
    /// The name of the core definition.
    pub name: std::option::Option<std::string::String>,
    /// Tag(s) to add to the new resource.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateCoreDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCoreDefinitionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("initial_version", &self.initial_version);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectorDefinitionVersionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// The ID of the connector definition.
    pub connector_definition_id: std::option::Option<std::string::String>,
    /// A list of references to connectors in this version, with their corresponding configuration settings.
    pub connectors: std::option::Option<std::vec::Vec<crate::model::Connector>>,
}
impl std::fmt::Debug for CreateConnectorDefinitionVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectorDefinitionVersionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("connector_definition_id", &self.connector_definition_id);
        formatter.field("connectors", &self.connectors);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectorDefinitionInput {
    /// A client token used to correlate requests and responses.
    pub amzn_client_token: std::option::Option<std::string::String>,
    /// Information about the initial version of the connector definition.
    pub initial_version: std::option::Option<crate::model::ConnectorDefinitionVersion>,
    /// The name of the connector definition.
    pub name: std::option::Option<std::string::String>,
    /// Tag(s) to add to the new resource.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateConnectorDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectorDefinitionInput");
        formatter.field("amzn_client_token", &self.amzn_client_token);
        formatter.field("initial_version", &self.initial_version);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateServiceRoleToAccountInput {
    /// The ARN of the service role you wish to associate with your account.
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateServiceRoleToAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateServiceRoleToAccountInput");
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateRoleToGroupInput {
    /// The ID of the Greengrass group.
    pub group_id: std::option::Option<std::string::String>,
    /// The ARN of the role you wish to associate with this group. The existence of the role is not validated.
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateRoleToGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateRoleToGroupInput");
        formatter.field("group_id", &self.group_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
