// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Managed Grafana
///
/// Client for invoking operations on Amazon Managed Grafana. Each operation on Amazon Managed Grafana is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_grafana::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_grafana::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_grafana::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateLicense`](crate::client::fluent_builders::AssociateLicense) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::AssociateLicense::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::AssociateLicense::set_workspace_id): <p>The ID of the workspace to associate the license with.</p>
    ///   - [`license_type(LicenseType)`](crate::client::fluent_builders::AssociateLicense::license_type) / [`set_license_type(Option<LicenseType>)`](crate::client::fluent_builders::AssociateLicense::set_license_type): <p>The type of license to associate with the workspace.</p>
    /// - On success, responds with [`AssociateLicenseOutput`](crate::output::AssociateLicenseOutput) with field(s):
    ///   - [`workspace(Option<WorkspaceDescription>)`](crate::output::AssociateLicenseOutput::workspace): <p>A structure containing data about the workspace.</p>
    /// - On failure, responds with [`SdkError<AssociateLicenseError>`](crate::error::AssociateLicenseError)
    pub fn associate_license(&self) -> fluent_builders::AssociateLicense {
        fluent_builders::AssociateLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWorkspace`](crate::client::fluent_builders::CreateWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_access_type(AccountAccessType)`](crate::client::fluent_builders::CreateWorkspace::account_access_type) / [`set_account_access_type(Option<AccountAccessType>)`](crate::client::fluent_builders::CreateWorkspace::set_account_access_type): <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_client_token): <p>A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.</p>
    ///   - [`organization_role_name(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::organization_role_name) / [`set_organization_role_name(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_organization_role_name): <p>The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data sources and notification channels in other accounts in an organization.</p>
    ///   - [`permission_type(PermissionType)`](crate::client::fluent_builders::CreateWorkspace::permission_type) / [`set_permission_type(Option<PermissionType>)`](crate::client::fluent_builders::CreateWorkspace::set_permission_type): <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p>  <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization that is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>
    ///   - [`stack_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::stack_set_name) / [`set_stack_set_name(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_stack_set_name): <p>The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.</p>
    ///   - [`workspace_data_sources(Vec<DataSourceType>)`](crate::client::fluent_builders::CreateWorkspace::workspace_data_sources) / [`set_workspace_data_sources(Option<Vec<DataSourceType>>)`](crate::client::fluent_builders::CreateWorkspace::set_workspace_data_sources): <p>Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.</p>  <p>If you don't specify a data source here, you can still add it as a data source in the workspace console later. However, you will then have to manually configure permissions for it.</p>
    ///   - [`workspace_description(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::workspace_description) / [`set_workspace_description(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_workspace_description): <p>A description for the workspace. This is used only to help you identify this workspace.</p>
    ///   - [`workspace_name(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::workspace_name) / [`set_workspace_name(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_workspace_name): <p>The name for the workspace. It does not have to be unique.</p>
    ///   - [`workspace_notification_destinations(Vec<NotificationDestinationType>)`](crate::client::fluent_builders::CreateWorkspace::workspace_notification_destinations) / [`set_workspace_notification_destinations(Option<Vec<NotificationDestinationType>>)`](crate::client::fluent_builders::CreateWorkspace::set_workspace_notification_destinations): <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.</p>
    ///   - [`workspace_organizational_units(Vec<String>)`](crate::client::fluent_builders::CreateWorkspace::workspace_organizational_units) / [`set_workspace_organizational_units(Option<Vec<String>>)`](crate::client::fluent_builders::CreateWorkspace::set_workspace_organizational_units): <p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>
    ///   - [`workspace_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateWorkspace::workspace_role_arn) / [`set_workspace_role_arn(Option<String>)`](crate::client::fluent_builders::CreateWorkspace::set_workspace_role_arn): <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. If you already have a role that you want to use, specify it here. If you omit this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is automatically created.</p>
    ///   - [`authentication_providers(Vec<AuthenticationProviderTypes>)`](crate::client::fluent_builders::CreateWorkspace::authentication_providers) / [`set_authentication_providers(Option<Vec<AuthenticationProviderTypes>>)`](crate::client::fluent_builders::CreateWorkspace::set_authentication_providers): <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a>.</p>
    /// - On success, responds with [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput) with field(s):
    ///   - [`workspace(Option<WorkspaceDescription>)`](crate::output::CreateWorkspaceOutput::workspace): <p>A structure containing data about the workspace that was created.</p>
    /// - On failure, responds with [`SdkError<CreateWorkspaceError>`](crate::error::CreateWorkspaceError)
    pub fn create_workspace(&self) -> fluent_builders::CreateWorkspace {
        fluent_builders::CreateWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWorkspace`](crate::client::fluent_builders::DeleteWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkspace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkspace::set_workspace_id): <p>The ID of the workspace to delete.</p>
    /// - On success, responds with [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput) with field(s):
    ///   - [`workspace(Option<WorkspaceDescription>)`](crate::output::DeleteWorkspaceOutput::workspace): <p>A structure containing information about the workspace that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteWorkspaceError>`](crate::error::DeleteWorkspaceError)
    pub fn delete_workspace(&self) -> fluent_builders::DeleteWorkspace {
        fluent_builders::DeleteWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkspace`](crate::client::fluent_builders::DescribeWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DescribeWorkspace::set_workspace_id): <p>The ID of the workspace to display information about.</p>
    /// - On success, responds with [`DescribeWorkspaceOutput`](crate::output::DescribeWorkspaceOutput) with field(s):
    ///   - [`workspace(Option<WorkspaceDescription>)`](crate::output::DescribeWorkspaceOutput::workspace): <p>A structure containing information about the workspace.</p>
    /// - On failure, responds with [`SdkError<DescribeWorkspaceError>`](crate::error::DescribeWorkspaceError)
    pub fn describe_workspace(&self) -> fluent_builders::DescribeWorkspace {
        fluent_builders::DescribeWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeWorkspaceAuthentication`](crate::client::fluent_builders::DescribeWorkspaceAuthentication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DescribeWorkspaceAuthentication::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DescribeWorkspaceAuthentication::set_workspace_id): <p>The ID of the workspace to return authentication information about.</p>
    /// - On success, responds with [`DescribeWorkspaceAuthenticationOutput`](crate::output::DescribeWorkspaceAuthenticationOutput) with field(s):
    ///   - [`authentication(Option<AuthenticationDescription>)`](crate::output::DescribeWorkspaceAuthenticationOutput::authentication): <p>A structure containing information about the authentication methods used in the workspace.</p>
    /// - On failure, responds with [`SdkError<DescribeWorkspaceAuthenticationError>`](crate::error::DescribeWorkspaceAuthenticationError)
    pub fn describe_workspace_authentication(
        &self,
    ) -> fluent_builders::DescribeWorkspaceAuthentication {
        fluent_builders::DescribeWorkspaceAuthentication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateLicense`](crate::client::fluent_builders::DisassociateLicense) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateLicense::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::DisassociateLicense::set_workspace_id): <p>The ID of the workspace to remove the Grafana Enterprise license from.</p>
    ///   - [`license_type(LicenseType)`](crate::client::fluent_builders::DisassociateLicense::license_type) / [`set_license_type(Option<LicenseType>)`](crate::client::fluent_builders::DisassociateLicense::set_license_type): <p>The type of license to remove from the workspace.</p>
    /// - On success, responds with [`DisassociateLicenseOutput`](crate::output::DisassociateLicenseOutput) with field(s):
    ///   - [`workspace(Option<WorkspaceDescription>)`](crate::output::DisassociateLicenseOutput::workspace): <p>A structure containing information about the workspace.</p>
    /// - On failure, responds with [`SdkError<DisassociateLicenseError>`](crate::error::DisassociateLicenseError)
    pub fn disassociate_license(&self) -> fluent_builders::DisassociateLicense {
        fluent_builders::DisassociateLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPermissions`](crate::client::fluent_builders::ListPermissions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPermissions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPermissions::set_max_results): <p>The maximum number of results to include in the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_next_token): <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListPermissions</code> operation.</p>
    ///   - [`user_type(UserType)`](crate::client::fluent_builders::ListPermissions::user_type) / [`set_user_type(Option<UserType>)`](crate::client::fluent_builders::ListPermissions::set_user_type): <p>(Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups are returned.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_user_id): <p>(Optional) Limits the results to only the user that matches this ID.</p>
    ///   - [`group_id(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::group_id) / [`set_group_id(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_group_id): <p>(Optional) Limits the results to only the group that matches this ID.</p>
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::ListPermissions::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::ListPermissions::set_workspace_id): <p>The ID of the workspace to list permissions for. This parameter is required.</p>
    /// - On success, responds with [`ListPermissionsOutput`](crate::output::ListPermissionsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListPermissionsOutput::next_token): <p>The token to use in a subsequent <code>ListPermissions</code> operation to return the next set of results.</p>
    ///   - [`permissions(Option<Vec<PermissionEntry>>)`](crate::output::ListPermissionsOutput::permissions): <p>The permissions returned by the operation.</p>
    /// - On failure, responds with [`SdkError<ListPermissionsError>`](crate::error::ListPermissionsError)
    pub fn list_permissions(&self) -> fluent_builders::ListPermissions {
        fluent_builders::ListPermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWorkspaces`](crate::client::fluent_builders::ListWorkspaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListWorkspaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWorkspaces::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListWorkspaces::set_max_results): <p>The maximum number of workspaces to include in the results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWorkspaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWorkspaces::set_next_token): <p>The token for the next set of workspaces to return. (You receive this token from a previous <code>ListWorkspaces</code> operation.)</p>
    /// - On success, responds with [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput) with field(s):
    ///   - [`workspaces(Option<Vec<WorkspaceSummary>>)`](crate::output::ListWorkspacesOutput::workspaces): <p>An array of structures that contain some information about the workspaces in the account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListWorkspacesOutput::next_token): <p>The token to use when requesting the next set of workspaces.</p>
    /// - On failure, responds with [`SdkError<ListWorkspacesError>`](crate::error::ListWorkspacesError)
    pub fn list_workspaces(&self) -> fluent_builders::ListWorkspaces {
        fluent_builders::ListWorkspaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePermissions`](crate::client::fluent_builders::UpdatePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`update_instruction_batch(Vec<UpdateInstruction>)`](crate::client::fluent_builders::UpdatePermissions::update_instruction_batch) / [`set_update_instruction_batch(Option<Vec<UpdateInstruction>>)`](crate::client::fluent_builders::UpdatePermissions::set_update_instruction_batch): <p>An array of structures that contain the permission updates to make.</p>
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePermissions::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::UpdatePermissions::set_workspace_id): <p>The ID of the workspace to update.</p>
    /// - On success, responds with [`UpdatePermissionsOutput`](crate::output::UpdatePermissionsOutput) with field(s):
    ///   - [`errors(Option<Vec<UpdateError>>)`](crate::output::UpdatePermissionsOutput::errors): <p>An array of structures that contain the errors from the operation, if any.</p>
    /// - On failure, responds with [`SdkError<UpdatePermissionsError>`](crate::error::UpdatePermissionsError)
    pub fn update_permissions(&self) -> fluent_builders::UpdatePermissions {
        fluent_builders::UpdatePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWorkspace`](crate::client::fluent_builders::UpdateWorkspace) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_access_type(AccountAccessType)`](crate::client::fluent_builders::UpdateWorkspace::account_access_type) / [`set_account_access_type(Option<AccountAccessType>)`](crate::client::fluent_builders::UpdateWorkspace::set_account_access_type): <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.</p>
    ///   - [`organization_role_name(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspace::organization_role_name) / [`set_organization_role_name(Option<String>)`](crate::client::fluent_builders::UpdateWorkspace::set_organization_role_name): <p>The name of an IAM role that already exists to use to access resources through Organizations.</p>
    ///   - [`permission_type(PermissionType)`](crate::client::fluent_builders::UpdateWorkspace::permission_type) / [`set_permission_type(Option<PermissionType>)`](crate::client::fluent_builders::UpdateWorkspace::set_permission_type): <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p>  <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>
    ///   - [`stack_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspace::stack_set_name) / [`set_stack_set_name(Option<String>)`](crate::client::fluent_builders::UpdateWorkspace::set_stack_set_name): <p>The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.</p>
    ///   - [`workspace_data_sources(Vec<DataSourceType>)`](crate::client::fluent_builders::UpdateWorkspace::workspace_data_sources) / [`set_workspace_data_sources(Option<Vec<DataSourceType>>)`](crate::client::fluent_builders::UpdateWorkspace::set_workspace_data_sources): <p>Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.</p>  <p>If you don't specify a data source here, you can still add it as a data source later in the workspace console. However, you will then have to manually configure permissions for it.</p>
    ///   - [`workspace_description(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspace::workspace_description) / [`set_workspace_description(Option<String>)`](crate::client::fluent_builders::UpdateWorkspace::set_workspace_description): <p>A description for the workspace. This is used only to help you identify this workspace.</p>
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspace::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkspace::set_workspace_id): <p>The ID of the workspace to update.</p>
    ///   - [`workspace_name(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspace::workspace_name) / [`set_workspace_name(Option<String>)`](crate::client::fluent_builders::UpdateWorkspace::set_workspace_name): <p>A new name for the workspace to update.</p>
    ///   - [`workspace_notification_destinations(Vec<NotificationDestinationType>)`](crate::client::fluent_builders::UpdateWorkspace::workspace_notification_destinations) / [`set_workspace_notification_destinations(Option<Vec<NotificationDestinationType>>)`](crate::client::fluent_builders::UpdateWorkspace::set_workspace_notification_destinations): <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.</p>
    ///   - [`workspace_organizational_units(Vec<String>)`](crate::client::fluent_builders::UpdateWorkspace::workspace_organizational_units) / [`set_workspace_organizational_units(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateWorkspace::set_workspace_organizational_units): <p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>
    ///   - [`workspace_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspace::workspace_role_arn) / [`set_workspace_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateWorkspace::set_workspace_role_arn): <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. If you already have a role that you want to use, specify it here. If you omit this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is automatically created.</p>
    /// - On success, responds with [`UpdateWorkspaceOutput`](crate::output::UpdateWorkspaceOutput) with field(s):
    ///   - [`workspace(Option<WorkspaceDescription>)`](crate::output::UpdateWorkspaceOutput::workspace): <p>A structure containing data about the workspace that was created.</p>
    /// - On failure, responds with [`SdkError<UpdateWorkspaceError>`](crate::error::UpdateWorkspaceError)
    pub fn update_workspace(&self) -> fluent_builders::UpdateWorkspace {
        fluent_builders::UpdateWorkspace::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWorkspaceAuthentication`](crate::client::fluent_builders::UpdateWorkspaceAuthentication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`workspace_id(impl Into<String>)`](crate::client::fluent_builders::UpdateWorkspaceAuthentication::workspace_id) / [`set_workspace_id(Option<String>)`](crate::client::fluent_builders::UpdateWorkspaceAuthentication::set_workspace_id): <p>The ID of the workspace to update the authentication for.</p>
    ///   - [`authentication_providers(Vec<AuthenticationProviderTypes>)`](crate::client::fluent_builders::UpdateWorkspaceAuthentication::authentication_providers) / [`set_authentication_providers(Option<Vec<AuthenticationProviderTypes>>)`](crate::client::fluent_builders::UpdateWorkspaceAuthentication::set_authentication_providers): <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a>.</p>
    ///   - [`saml_configuration(SamlConfiguration)`](crate::client::fluent_builders::UpdateWorkspaceAuthentication::saml_configuration) / [`set_saml_configuration(Option<SamlConfiguration>)`](crate::client::fluent_builders::UpdateWorkspaceAuthentication::set_saml_configuration): <p>If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>
    /// - On success, responds with [`UpdateWorkspaceAuthenticationOutput`](crate::output::UpdateWorkspaceAuthenticationOutput) with field(s):
    ///   - [`authentication(Option<AuthenticationDescription>)`](crate::output::UpdateWorkspaceAuthenticationOutput::authentication): <p>A structure that describes the user authentication for this workspace after the update is made.</p>
    /// - On failure, responds with [`SdkError<UpdateWorkspaceAuthenticationError>`](crate::error::UpdateWorkspaceAuthenticationError)
    pub fn update_workspace_authentication(
        &self,
    ) -> fluent_builders::UpdateWorkspaceAuthentication {
        fluent_builders::UpdateWorkspaceAuthentication::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateLicense`.
    ///
    /// <p>Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html">Upgrade a workspace to Grafana Enterprise</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateLicense {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_license_input::Builder,
    }
    impl AssociateLicense {
        /// Creates a new `AssociateLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateLicenseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace to associate the license with.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to associate the license with.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The type of license to associate with the workspace.</p>
        pub fn license_type(mut self, input: crate::model::LicenseType) -> Self {
            self.inner = self.inner.license_type(input);
            self
        }
        /// <p>The type of license to associate with the workspace.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.inner = self.inner.set_license_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkspace`.
    ///
    /// <p>Creates a <i>workspace</i>. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.</p>
    /// <p>Don't use <code>CreateWorkspace</code> to modify an existing workspace. Instead, use <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html">UpdateWorkspace</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkspace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_workspace_input::Builder,
    }
    impl CreateWorkspace {
        /// Creates a new `CreateWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkspaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.</p>
        pub fn account_access_type(mut self, input: crate::model::AccountAccessType) -> Self {
            self.inner = self.inner.account_access_type(input);
            self
        }
        /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.</p>
        pub fn set_account_access_type(
            mut self,
            input: std::option::Option<crate::model::AccountAccessType>,
        ) -> Self {
            self.inner = self.inner.set_account_access_type(input);
            self
        }
        /// <p>A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data sources and notification channels in other accounts in an organization.</p>
        pub fn organization_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_role_name(input.into());
            self
        }
        /// <p>The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data sources and notification channels in other accounts in an organization.</p>
        pub fn set_organization_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_role_name(input);
            self
        }
        /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p>
        /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization that is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.inner = self.inner.permission_type(input);
            self
        }
        /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p>
        /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization that is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
        /// <p>The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(input.into());
            self
        }
        /// <p>The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// Appends an item to `workspaceDataSources`.
        ///
        /// To override the contents of this collection use [`set_workspace_data_sources`](Self::set_workspace_data_sources).
        ///
        /// <p>Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.</p>
        /// <p>If you don't specify a data source here, you can still add it as a data source in the workspace console later. However, you will then have to manually configure permissions for it.</p>
        pub fn workspace_data_sources(mut self, input: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.workspace_data_sources(input);
            self
        }
        /// <p>Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.</p>
        /// <p>If you don't specify a data source here, you can still add it as a data source in the workspace console later. However, you will then have to manually configure permissions for it.</p>
        pub fn set_workspace_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
        ) -> Self {
            self.inner = self.inner.set_workspace_data_sources(input);
            self
        }
        /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
        pub fn workspace_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_description(input.into());
            self
        }
        /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
        pub fn set_workspace_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workspace_description(input);
            self
        }
        /// <p>The name for the workspace. It does not have to be unique.</p>
        pub fn workspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_name(input.into());
            self
        }
        /// <p>The name for the workspace. It does not have to be unique.</p>
        pub fn set_workspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workspace_name(input);
            self
        }
        /// Appends an item to `workspaceNotificationDestinations`.
        ///
        /// To override the contents of this collection use [`set_workspace_notification_destinations`](Self::set_workspace_notification_destinations).
        ///
        /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.</p>
        pub fn workspace_notification_destinations(
            mut self,
            input: crate::model::NotificationDestinationType,
        ) -> Self {
            self.inner = self.inner.workspace_notification_destinations(input);
            self
        }
        /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.</p>
        pub fn set_workspace_notification_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
        ) -> Self {
            self.inner = self.inner.set_workspace_notification_destinations(input);
            self
        }
        /// Appends an item to `workspaceOrganizationalUnits`.
        ///
        /// To override the contents of this collection use [`set_workspace_organizational_units`](Self::set_workspace_organizational_units).
        ///
        /// <p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>
        pub fn workspace_organizational_units(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.workspace_organizational_units(input.into());
            self
        }
        /// <p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>
        pub fn set_workspace_organizational_units(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_workspace_organizational_units(input);
            self
        }
        /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. If you already have a role that you want to use, specify it here. If you omit this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is automatically created.</p>
        pub fn workspace_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_role_arn(input.into());
            self
        }
        /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. If you already have a role that you want to use, specify it here. If you omit this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is automatically created.</p>
        pub fn set_workspace_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workspace_role_arn(input);
            self
        }
        /// Appends an item to `authenticationProviders`.
        ///
        /// To override the contents of this collection use [`set_authentication_providers`](Self::set_authentication_providers).
        ///
        /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a>.</p>
        pub fn authentication_providers(
            mut self,
            input: crate::model::AuthenticationProviderTypes,
        ) -> Self {
            self.inner = self.inner.authentication_providers(input);
            self
        }
        /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a>.</p>
        pub fn set_authentication_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
        ) -> Self {
            self.inner = self.inner.set_authentication_providers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkspace`.
    ///
    /// <p>Deletes an Amazon Managed Grafana workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkspace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_workspace_input::Builder,
    }
    impl DeleteWorkspace {
        /// Creates a new `DeleteWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkspaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace to delete.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to delete.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspace`.
    ///
    /// <p>Displays information about one Amazon Managed Grafana workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workspace_input::Builder,
    }
    impl DescribeWorkspace {
        /// Creates a new `DescribeWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace to display information about.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to display information about.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkspaceAuthentication`.
    ///
    /// <p>Displays information about the authentication methods used in one Amazon Managed Grafana workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkspaceAuthentication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_workspace_authentication_input::Builder,
    }
    impl DescribeWorkspaceAuthentication {
        /// Creates a new `DescribeWorkspaceAuthentication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkspaceAuthenticationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkspaceAuthenticationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace to return authentication information about.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to return authentication information about.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateLicense`.
    ///
    /// <p>Removes the Grafana Enterprise license from a workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateLicense {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_license_input::Builder,
    }
    impl DisassociateLicense {
        /// Creates a new `DisassociateLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateLicenseError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace to remove the Grafana Enterprise license from.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to remove the Grafana Enterprise license from.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>The type of license to remove from the workspace.</p>
        pub fn license_type(mut self, input: crate::model::LicenseType) -> Self {
            self.inner = self.inner.license_type(input);
            self
        }
        /// <p>The type of license to remove from the workspace.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.inner = self.inner.set_license_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPermissions`.
    ///
    /// <p>Lists the users and groups who have the Grafana <code>Admin</code> and <code>Editor</code> roles in this workspace. If you use this operation without specifying <code>userId</code> or <code>groupId</code>, the operation returns the roles of all users and groups. If you specify a <code>userId</code> or a <code>groupId</code>, only the roles for that user or group are returned. If you do this, you can specify only one <code>userId</code> or one <code>groupId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_permissions_input::Builder,
    }
    impl ListPermissions {
        /// Creates a new `ListPermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPermissionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPermissionsPaginator {
            crate::paginator::ListPermissionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListPermissions</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous <code>ListPermissions</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>(Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups are returned.</p>
        pub fn user_type(mut self, input: crate::model::UserType) -> Self {
            self.inner = self.inner.user_type(input);
            self
        }
        /// <p>(Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups are returned.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.inner = self.inner.set_user_type(input);
            self
        }
        /// <p>(Optional) Limits the results to only the user that matches this ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>(Optional) Limits the results to only the user that matches this ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>(Optional) Limits the results to only the group that matches this ID.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_id(input.into());
            self
        }
        /// <p>(Optional) Limits the results to only the group that matches this ID.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_id(input);
            self
        }
        /// <p>The ID of the workspace to list permissions for. This parameter is required.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to list permissions for. This parameter is required.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkspaces`.
    ///
    /// <p>Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace. For more complete information about one workspace, use <a href="https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html">DescribeWorkspace</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkspaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_workspaces_input::Builder,
    }
    impl ListWorkspaces {
        /// Creates a new `ListWorkspaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkspacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkspacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorkspacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorkspacesPaginator {
            crate::paginator::ListWorkspacesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of workspaces to include in the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of workspaces to include in the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of workspaces to return. (You receive this token from a previous <code>ListWorkspaces</code> operation.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of workspaces to return. (You receive this token from a previous <code>ListWorkspaces</code> operation.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePermissions`.
    ///
    /// <p>Updates which users in a workspace have the Grafana <code>Admin</code> or <code>Editor</code> roles.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePermissions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_permissions_input::Builder,
    }
    impl UpdatePermissions {
        /// Creates a new `UpdatePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePermissionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `updateInstructionBatch`.
        ///
        /// To override the contents of this collection use [`set_update_instruction_batch`](Self::set_update_instruction_batch).
        ///
        /// <p>An array of structures that contain the permission updates to make.</p>
        pub fn update_instruction_batch(mut self, input: crate::model::UpdateInstruction) -> Self {
            self.inner = self.inner.update_instruction_batch(input);
            self
        }
        /// <p>An array of structures that contain the permission updates to make.</p>
        pub fn set_update_instruction_batch(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateInstruction>>,
        ) -> Self {
            self.inner = self.inner.set_update_instruction_batch(input);
            self
        }
        /// <p>The ID of the workspace to update.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to update.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkspace`.
    ///
    /// <p>Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional parameters, the existing values of those parameters are not changed.</p>
    /// <p>To modify the user authentication methods that the workspace uses, such as SAML or Amazon Web Services SSO, use <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html">UpdateWorkspaceAuthentication</a>.</p>
    /// <p>To modify which users in the workspace have the <code>Admin</code> and <code>Editor</code> Grafana roles, use <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkspace {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_workspace_input::Builder,
    }
    impl UpdateWorkspace {
        /// Creates a new `UpdateWorkspace`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkspaceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.</p>
        pub fn account_access_type(mut self, input: crate::model::AccountAccessType) -> Self {
            self.inner = self.inner.account_access_type(input);
            self
        }
        /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must specify which organizational units the workspace can access in the <code>workspaceOrganizationalUnits</code> parameter.</p>
        pub fn set_account_access_type(
            mut self,
            input: std::option::Option<crate::model::AccountAccessType>,
        ) -> Self {
            self.inner = self.inner.set_account_access_type(input);
            self
        }
        /// <p>The name of an IAM role that already exists to use to access resources through Organizations.</p>
        pub fn organization_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_role_name(input.into());
            self
        }
        /// <p>The name of an IAM role that already exists to use to access resources through Organizations.</p>
        pub fn set_organization_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_role_name(input);
            self
        }
        /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p>
        /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.inner = self.inner.permission_type(input);
            self
        }
        /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p>
        /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.inner = self.inner.set_permission_type(input);
            self
        }
        /// <p>The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_set_name(input.into());
            self
        }
        /// <p>The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_stack_set_name(input);
            self
        }
        /// Appends an item to `workspaceDataSources`.
        ///
        /// To override the contents of this collection use [`set_workspace_data_sources`](Self::set_workspace_data_sources).
        ///
        /// <p>Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.</p>
        /// <p>If you don't specify a data source here, you can still add it as a data source later in the workspace console. However, you will then have to manually configure permissions for it.</p>
        pub fn workspace_data_sources(mut self, input: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.workspace_data_sources(input);
            self
        }
        /// <p>Specify the Amazon Web Services data sources that you want to be queried in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these sources. You must still add them as data sources in the Grafana console in the workspace.</p>
        /// <p>If you don't specify a data source here, you can still add it as a data source later in the workspace console. However, you will then have to manually configure permissions for it.</p>
        pub fn set_workspace_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
        ) -> Self {
            self.inner = self.inner.set_workspace_data_sources(input);
            self
        }
        /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
        pub fn workspace_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_description(input.into());
            self
        }
        /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
        pub fn set_workspace_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workspace_description(input);
            self
        }
        /// <p>The ID of the workspace to update.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to update.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// <p>A new name for the workspace to update.</p>
        pub fn workspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_name(input.into());
            self
        }
        /// <p>A new name for the workspace to update.</p>
        pub fn set_workspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workspace_name(input);
            self
        }
        /// Appends an item to `workspaceNotificationDestinations`.
        ///
        /// To override the contents of this collection use [`set_workspace_notification_destinations`](Self::set_workspace_notification_destinations).
        ///
        /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.</p>
        pub fn workspace_notification_destinations(
            mut self,
            input: crate::model::NotificationDestinationType,
        ) -> Self {
            self.inner = self.inner.workspace_notification_destinations(input);
            self
        }
        /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.</p>
        pub fn set_workspace_notification_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
        ) -> Self {
            self.inner = self.inner.set_workspace_notification_destinations(input);
            self
        }
        /// Appends an item to `workspaceOrganizationalUnits`.
        ///
        /// To override the contents of this collection use [`set_workspace_organizational_units`](Self::set_workspace_organizational_units).
        ///
        /// <p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>
        pub fn workspace_organizational_units(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.workspace_organizational_units(input.into());
            self
        }
        /// <p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>
        pub fn set_workspace_organizational_units(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_workspace_organizational_units(input);
            self
        }
        /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. If you already have a role that you want to use, specify it here. If you omit this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is automatically created.</p>
        pub fn workspace_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_role_arn(input.into());
            self
        }
        /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. If you already have a role that you want to use, specify it here. If you omit this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is automatically created.</p>
        pub fn set_workspace_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workspace_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkspaceAuthentication`.
    ///
    /// <p>Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorkspaceAuthentication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_workspace_authentication_input::Builder,
    }
    impl UpdateWorkspaceAuthentication {
        /// Creates a new `UpdateWorkspaceAuthentication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkspaceAuthenticationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkspaceAuthenticationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workspace to update the authentication for.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workspace_id(input.into());
            self
        }
        /// <p>The ID of the workspace to update the authentication for.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workspace_id(input);
            self
        }
        /// Appends an item to `authenticationProviders`.
        ///
        /// To override the contents of this collection use [`set_authentication_providers`](Self::set_authentication_providers).
        ///
        /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a>.</p>
        pub fn authentication_providers(
            mut self,
            input: crate::model::AuthenticationProviderTypes,
        ) -> Self {
            self.inner = self.inner.authentication_providers(input);
            self
        }
        /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a>.</p>
        pub fn set_authentication_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
        ) -> Self {
            self.inner = self.inner.set_authentication_providers(input);
            self
        }
        /// <p>If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>
        pub fn saml_configuration(mut self, input: crate::model::SamlConfiguration) -> Self {
            self.inner = self.inner.saml_configuration(input);
            self
        }
        /// <p>If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>
        pub fn set_saml_configuration(
            mut self,
            input: std::option::Option<crate::model::SamlConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_saml_configuration(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
