// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A structure that contains some information about one workspace in the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceSummary {
    /// <p>The date that the workspace was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The customer-entered description of the workspace.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The URL endpoint to use to access the Grafana console in the workspace.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The Grafana version that the workspace is running.</p>
    pub grafana_version: std::option::Option<std::string::String>,
    /// <p>The unique ID of the workspace.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The most recent date that the workspace was modified.</p>
    pub modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the workspace.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, which allows Amazon Managed Grafana to use these channels.</p>
    pub notification_destinations:
        std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
    /// <p>The current status of the workspace.</p>
    pub status: std::option::Option<crate::model::WorkspaceStatus>,
    /// <p>A structure containing information about the authentication methods used in the workspace.</p>
    pub authentication: std::option::Option<crate::model::AuthenticationSummary>,
}
impl WorkspaceSummary {
    /// <p>The date that the workspace was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The customer-entered description of the workspace.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The URL endpoint to use to access the Grafana console in the workspace.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The Grafana version that the workspace is running.</p>
    pub fn grafana_version(&self) -> std::option::Option<&str> {
        self.grafana_version.as_deref()
    }
    /// <p>The unique ID of the workspace.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The most recent date that the workspace was modified.</p>
    pub fn modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified.as_ref()
    }
    /// <p>The name of the workspace.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, which allows Amazon Managed Grafana to use these channels.</p>
    pub fn notification_destinations(
        &self,
    ) -> std::option::Option<&[crate::model::NotificationDestinationType]> {
        self.notification_destinations.as_deref()
    }
    /// <p>The current status of the workspace.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::WorkspaceStatus> {
        self.status.as_ref()
    }
    /// <p>A structure containing information about the authentication methods used in the workspace.</p>
    pub fn authentication(&self) -> std::option::Option<&crate::model::AuthenticationSummary> {
        self.authentication.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceSummary");
        formatter.field("created", &self.created);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("endpoint", &self.endpoint);
        formatter.field("grafana_version", &self.grafana_version);
        formatter.field("id", &self.id);
        formatter.field("modified", &self.modified);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("notification_destinations", &self.notification_destinations);
        formatter.field("status", &self.status);
        formatter.field("authentication", &self.authentication);
        formatter.finish()
    }
}
/// See [`WorkspaceSummary`](crate::model::WorkspaceSummary)
pub mod workspace_summary {
    /// A builder for [`WorkspaceSummary`](crate::model::WorkspaceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) grafana_version: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) notification_destinations:
            std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
        pub(crate) status: std::option::Option<crate::model::WorkspaceStatus>,
        pub(crate) authentication: std::option::Option<crate::model::AuthenticationSummary>,
    }
    impl Builder {
        /// <p>The date that the workspace was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date that the workspace was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The customer-entered description of the workspace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The customer-entered description of the workspace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The URL endpoint to use to access the Grafana console in the workspace.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The URL endpoint to use to access the Grafana console in the workspace.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The Grafana version that the workspace is running.</p>
        pub fn grafana_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.grafana_version = Some(input.into());
            self
        }
        /// <p>The Grafana version that the workspace is running.</p>
        pub fn set_grafana_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grafana_version = input;
            self
        }
        /// <p>The unique ID of the workspace.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the workspace.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The most recent date that the workspace was modified.</p>
        pub fn modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified = Some(input);
            self
        }
        /// <p>The most recent date that the workspace was modified.</p>
        pub fn set_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified = input;
            self
        }
        /// <p>The name of the workspace.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the workspace.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `notification_destinations`.
        ///
        /// To override the contents of this collection use [`set_notification_destinations`](Self::set_notification_destinations).
        ///
        /// <p>The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, which allows Amazon Managed Grafana to use these channels.</p>
        pub fn notification_destinations(
            mut self,
            input: crate::model::NotificationDestinationType,
        ) -> Self {
            let mut v = self.notification_destinations.unwrap_or_default();
            v.push(input);
            self.notification_destinations = Some(v);
            self
        }
        /// <p>The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, which allows Amazon Managed Grafana to use these channels.</p>
        pub fn set_notification_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
        ) -> Self {
            self.notification_destinations = input;
            self
        }
        /// <p>The current status of the workspace.</p>
        pub fn status(mut self, input: crate::model::WorkspaceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the workspace.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorkspaceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A structure containing information about the authentication methods used in the workspace.</p>
        pub fn authentication(mut self, input: crate::model::AuthenticationSummary) -> Self {
            self.authentication = Some(input);
            self
        }
        /// <p>A structure containing information about the authentication methods used in the workspace.</p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<crate::model::AuthenticationSummary>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceSummary`](crate::model::WorkspaceSummary)
        pub fn build(self) -> crate::model::WorkspaceSummary {
            crate::model::WorkspaceSummary {
                created: self.created,
                description: self.description,
                endpoint: self.endpoint,
                grafana_version: self.grafana_version,
                id: self.id,
                modified: self.modified,
                name: self.name,
                notification_destinations: self.notification_destinations,
                status: self.status,
                authentication: self.authentication,
            }
        }
    }
}
impl WorkspaceSummary {
    /// Creates a new builder-style object to manufacture [`WorkspaceSummary`](crate::model::WorkspaceSummary)
    pub fn builder() -> crate::model::workspace_summary::Builder {
        crate::model::workspace_summary::Builder::default()
    }
}

/// <p>A structure that describes whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication, and whether that authentication is fully configured.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationSummary {
    /// <p>Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.</p>
    pub providers: std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
    /// <p>Specifies whether the workplace's user authentication method is fully configured.</p>
    pub saml_configuration_status: std::option::Option<crate::model::SamlConfigurationStatus>,
}
impl AuthenticationSummary {
    /// <p>Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.</p>
    pub fn providers(&self) -> std::option::Option<&[crate::model::AuthenticationProviderTypes]> {
        self.providers.as_deref()
    }
    /// <p>Specifies whether the workplace's user authentication method is fully configured.</p>
    pub fn saml_configuration_status(
        &self,
    ) -> std::option::Option<&crate::model::SamlConfigurationStatus> {
        self.saml_configuration_status.as_ref()
    }
}
impl std::fmt::Debug for AuthenticationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationSummary");
        formatter.field("providers", &self.providers);
        formatter.field("saml_configuration_status", &self.saml_configuration_status);
        formatter.finish()
    }
}
/// See [`AuthenticationSummary`](crate::model::AuthenticationSummary)
pub mod authentication_summary {
    /// A builder for [`AuthenticationSummary`](crate::model::AuthenticationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) providers:
            std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
        pub(crate) saml_configuration_status:
            std::option::Option<crate::model::SamlConfigurationStatus>,
    }
    impl Builder {
        /// Appends an item to `providers`.
        ///
        /// To override the contents of this collection use [`set_providers`](Self::set_providers).
        ///
        /// <p>Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.</p>
        pub fn providers(mut self, input: crate::model::AuthenticationProviderTypes) -> Self {
            let mut v = self.providers.unwrap_or_default();
            v.push(input);
            self.providers = Some(v);
            self
        }
        /// <p>Specifies whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.</p>
        pub fn set_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
        ) -> Self {
            self.providers = input;
            self
        }
        /// <p>Specifies whether the workplace's user authentication method is fully configured.</p>
        pub fn saml_configuration_status(
            mut self,
            input: crate::model::SamlConfigurationStatus,
        ) -> Self {
            self.saml_configuration_status = Some(input);
            self
        }
        /// <p>Specifies whether the workplace's user authentication method is fully configured.</p>
        pub fn set_saml_configuration_status(
            mut self,
            input: std::option::Option<crate::model::SamlConfigurationStatus>,
        ) -> Self {
            self.saml_configuration_status = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationSummary`](crate::model::AuthenticationSummary)
        pub fn build(self) -> crate::model::AuthenticationSummary {
            crate::model::AuthenticationSummary {
                providers: self.providers,
                saml_configuration_status: self.saml_configuration_status,
            }
        }
    }
}
impl AuthenticationSummary {
    /// Creates a new builder-style object to manufacture [`AuthenticationSummary`](crate::model::AuthenticationSummary)
    pub fn builder() -> crate::model::authentication_summary::Builder {
        crate::model::authentication_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SamlConfigurationStatus {
    /// Indicates that SAML on an AMG workspace is enabled and has been configured.
    Configured,
    /// Indicates that SAML on an AMG workspace is enabled but has not been configured.
    NotConfigured,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SamlConfigurationStatus {
    fn from(s: &str) -> Self {
        match s {
            "CONFIGURED" => SamlConfigurationStatus::Configured,
            "NOT_CONFIGURED" => SamlConfigurationStatus::NotConfigured,
            other => SamlConfigurationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SamlConfigurationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SamlConfigurationStatus::from(s))
    }
}
impl SamlConfigurationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SamlConfigurationStatus::Configured => "CONFIGURED",
            SamlConfigurationStatus::NotConfigured => "NOT_CONFIGURED",
            SamlConfigurationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONFIGURED", "NOT_CONFIGURED"]
    }
}
impl AsRef<str> for SamlConfigurationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthenticationProviderTypes {
    /// Indicates that AMG workspace has AWS SSO enabled as its authentication provider.
    AwsSso,
    /// Indicates that the AMG workspace has SAML enabled as its authentication provider.
    Saml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthenticationProviderTypes {
    fn from(s: &str) -> Self {
        match s {
            "AWS_SSO" => AuthenticationProviderTypes::AwsSso,
            "SAML" => AuthenticationProviderTypes::Saml,
            other => AuthenticationProviderTypes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthenticationProviderTypes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthenticationProviderTypes::from(s))
    }
}
impl AuthenticationProviderTypes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthenticationProviderTypes::AwsSso => "AWS_SSO",
            AuthenticationProviderTypes::Saml => "SAML",
            AuthenticationProviderTypes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_SSO", "SAML"]
    }
}
impl AsRef<str> for AuthenticationProviderTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkspaceStatus {
    /// Workspace is active.
    Active,
    /// Workspace is being created.
    Creating,
    /// Workspace creation failed.
    CreationFailed,
    /// Workspace is being deleted.
    Deleting,
    /// Workspace deletion failed.
    DeletionFailed,
    /// Workspace is in an invalid state, it can only and should be deleted.
    Failed,
    /// Failed to remove enterprise license from workspace.
    LicenseRemovalFailed,
    /// Workspace update failed.
    UpdateFailed,
    /// Workspace is being updated.
    Updating,
    /// Workspace upgrade failed.
    UpgradeFailed,
    /// Workspace is being upgraded to enterprise.
    Upgrading,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkspaceStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => WorkspaceStatus::Active,
            "CREATING" => WorkspaceStatus::Creating,
            "CREATION_FAILED" => WorkspaceStatus::CreationFailed,
            "DELETING" => WorkspaceStatus::Deleting,
            "DELETION_FAILED" => WorkspaceStatus::DeletionFailed,
            "FAILED" => WorkspaceStatus::Failed,
            "LICENSE_REMOVAL_FAILED" => WorkspaceStatus::LicenseRemovalFailed,
            "UPDATE_FAILED" => WorkspaceStatus::UpdateFailed,
            "UPDATING" => WorkspaceStatus::Updating,
            "UPGRADE_FAILED" => WorkspaceStatus::UpgradeFailed,
            "UPGRADING" => WorkspaceStatus::Upgrading,
            other => WorkspaceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkspaceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkspaceStatus::from(s))
    }
}
impl WorkspaceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkspaceStatus::Active => "ACTIVE",
            WorkspaceStatus::Creating => "CREATING",
            WorkspaceStatus::CreationFailed => "CREATION_FAILED",
            WorkspaceStatus::Deleting => "DELETING",
            WorkspaceStatus::DeletionFailed => "DELETION_FAILED",
            WorkspaceStatus::Failed => "FAILED",
            WorkspaceStatus::LicenseRemovalFailed => "LICENSE_REMOVAL_FAILED",
            WorkspaceStatus::UpdateFailed => "UPDATE_FAILED",
            WorkspaceStatus::Updating => "UPDATING",
            WorkspaceStatus::UpgradeFailed => "UPGRADE_FAILED",
            WorkspaceStatus::Upgrading => "UPGRADING",
            WorkspaceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATING",
            "CREATION_FAILED",
            "DELETING",
            "DELETION_FAILED",
            "FAILED",
            "LICENSE_REMOVAL_FAILED",
            "UPDATE_FAILED",
            "UPDATING",
            "UPGRADE_FAILED",
            "UPGRADING",
        ]
    }
}
impl AsRef<str> for WorkspaceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotificationDestinationType {
    /// AWS Simple Notification Service
    Sns,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotificationDestinationType {
    fn from(s: &str) -> Self {
        match s {
            "SNS" => NotificationDestinationType::Sns,
            other => NotificationDestinationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotificationDestinationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotificationDestinationType::from(s))
    }
}
impl NotificationDestinationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotificationDestinationType::Sns => "SNS",
            NotificationDestinationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SNS"]
    }
}
impl AsRef<str> for NotificationDestinationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that contains information about a request parameter that caused an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the field that caused the validation error.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A message describing why this field couldn't be validated.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The name of the field that caused the validation error.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A message describing why this field couldn't be validated.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field that caused the validation error.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the field that caused the validation error.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A message describing why this field couldn't be validated.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing why this field couldn't be validated.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_PARSE",
            "FIELD_VALIDATION_FAILED",
            "OTHER",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure containing information about an Amazon Managed Grafana workspace in your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkspaceDescription {
    /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If this is <code>ORGANIZATION</code>, the <code>workspaceOrganizationalUnits</code> parameter specifies which organizational units the workspace can access.</p>
    pub account_access_type: std::option::Option<crate::model::AccountAccessType>,
    /// <p>The date that the workspace was created.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the Amazon Web Services data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.</p>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
    /// <p>The user-defined description of the workspace.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The URL that users can use to access the Grafana console in the workspace.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The version of Grafana supported in this workspace.</p>
    pub grafana_version: std::option::Option<std::string::String>,
    /// <p>The unique ID of this workspace.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The most recent date that the workspace was modified.</p>
    pub modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the workspace.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the IAM role that is used to access resources through Organizations.</p>
    pub organization_role_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.</p>
    pub notification_destinations:
        std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
    /// <p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>
    pub organizational_units: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If this is <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p>
    /// <p>If this is <code>CUSTOMER_MANAGED</code>, you manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>
    pub permission_type: std::option::Option<crate::model::PermissionType>,
    /// <p>The name of the CloudFormation stack set that is used to generate IAM roles to be used for this workspace.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>The current status of the workspace.</p>
    pub status: std::option::Option<crate::model::WorkspaceStatus>,
    /// <p>The IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. This role must already exist.</p>
    pub workspace_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether this workspace has a full Grafana Enterprise license or a free trial license.</p>
    pub license_type: std::option::Option<crate::model::LicenseType>,
    /// <p>Specifies whether this workspace has already fully used its free trial for Grafana Enterprise.</p>
    pub free_trial_consumed: std::option::Option<bool>,
    /// <p>If this workspace has a full Grafana Enterprise license, this specifies when the license ends and will need to be renewed.</p>
    pub license_expiration: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If this workspace is currently in the free trial period for Grafana Enterprise, this value specifies when that free trial ends.</p>
    pub free_trial_expiration: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A structure that describes whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.</p>
    pub authentication: std::option::Option<crate::model::AuthenticationSummary>,
}
impl WorkspaceDescription {
    /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If this is <code>ORGANIZATION</code>, the <code>workspaceOrganizationalUnits</code> parameter specifies which organizational units the workspace can access.</p>
    pub fn account_access_type(&self) -> std::option::Option<&crate::model::AccountAccessType> {
        self.account_access_type.as_ref()
    }
    /// <p>The date that the workspace was created.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>Specifies the Amazon Web Services data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.</p>
    pub fn data_sources(&self) -> std::option::Option<&[crate::model::DataSourceType]> {
        self.data_sources.as_deref()
    }
    /// <p>The user-defined description of the workspace.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The URL that users can use to access the Grafana console in the workspace.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The version of Grafana supported in this workspace.</p>
    pub fn grafana_version(&self) -> std::option::Option<&str> {
        self.grafana_version.as_deref()
    }
    /// <p>The unique ID of this workspace.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The most recent date that the workspace was modified.</p>
    pub fn modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified.as_ref()
    }
    /// <p>The name of the workspace.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the IAM role that is used to access resources through Organizations.</p>
    pub fn organization_role_name(&self) -> std::option::Option<&str> {
        self.organization_role_name.as_deref()
    }
    /// <p>The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.</p>
    pub fn notification_destinations(
        &self,
    ) -> std::option::Option<&[crate::model::NotificationDestinationType]> {
        self.notification_destinations.as_deref()
    }
    /// <p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>
    pub fn organizational_units(&self) -> std::option::Option<&[std::string::String]> {
        self.organizational_units.as_deref()
    }
    /// <p>If this is <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p>
    /// <p>If this is <code>CUSTOMER_MANAGED</code>, you manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>
    pub fn permission_type(&self) -> std::option::Option<&crate::model::PermissionType> {
        self.permission_type.as_ref()
    }
    /// <p>The name of the CloudFormation stack set that is used to generate IAM roles to be used for this workspace.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>The current status of the workspace.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::WorkspaceStatus> {
        self.status.as_ref()
    }
    /// <p>The IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. This role must already exist.</p>
    pub fn workspace_role_arn(&self) -> std::option::Option<&str> {
        self.workspace_role_arn.as_deref()
    }
    /// <p>Specifies whether this workspace has a full Grafana Enterprise license or a free trial license.</p>
    pub fn license_type(&self) -> std::option::Option<&crate::model::LicenseType> {
        self.license_type.as_ref()
    }
    /// <p>Specifies whether this workspace has already fully used its free trial for Grafana Enterprise.</p>
    pub fn free_trial_consumed(&self) -> std::option::Option<bool> {
        self.free_trial_consumed
    }
    /// <p>If this workspace has a full Grafana Enterprise license, this specifies when the license ends and will need to be renewed.</p>
    pub fn license_expiration(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.license_expiration.as_ref()
    }
    /// <p>If this workspace is currently in the free trial period for Grafana Enterprise, this value specifies when that free trial ends.</p>
    pub fn free_trial_expiration(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.free_trial_expiration.as_ref()
    }
    /// <p>A structure that describes whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.</p>
    pub fn authentication(&self) -> std::option::Option<&crate::model::AuthenticationSummary> {
        self.authentication.as_ref()
    }
}
impl std::fmt::Debug for WorkspaceDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkspaceDescription");
        formatter.field("account_access_type", &self.account_access_type);
        formatter.field("created", &self.created);
        formatter.field("data_sources", &self.data_sources);
        formatter.field("description", &"*** Sensitive Data Redacted ***");
        formatter.field("endpoint", &self.endpoint);
        formatter.field("grafana_version", &self.grafana_version);
        formatter.field("id", &self.id);
        formatter.field("modified", &self.modified);
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("organization_role_name", &"*** Sensitive Data Redacted ***");
        formatter.field("notification_destinations", &self.notification_destinations);
        formatter.field("organizational_units", &"*** Sensitive Data Redacted ***");
        formatter.field("permission_type", &self.permission_type);
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("status", &self.status);
        formatter.field("workspace_role_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("license_type", &self.license_type);
        formatter.field("free_trial_consumed", &self.free_trial_consumed);
        formatter.field("license_expiration", &self.license_expiration);
        formatter.field("free_trial_expiration", &self.free_trial_expiration);
        formatter.field("authentication", &self.authentication);
        formatter.finish()
    }
}
/// See [`WorkspaceDescription`](crate::model::WorkspaceDescription)
pub mod workspace_description {
    /// A builder for [`WorkspaceDescription`](crate::model::WorkspaceDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_access_type: std::option::Option<crate::model::AccountAccessType>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) grafana_version: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) organization_role_name: std::option::Option<std::string::String>,
        pub(crate) notification_destinations:
            std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
        pub(crate) organizational_units: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) permission_type: std::option::Option<crate::model::PermissionType>,
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::WorkspaceStatus>,
        pub(crate) workspace_role_arn: std::option::Option<std::string::String>,
        pub(crate) license_type: std::option::Option<crate::model::LicenseType>,
        pub(crate) free_trial_consumed: std::option::Option<bool>,
        pub(crate) license_expiration: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) free_trial_expiration: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) authentication: std::option::Option<crate::model::AuthenticationSummary>,
    }
    impl Builder {
        /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If this is <code>ORGANIZATION</code>, the <code>workspaceOrganizationalUnits</code> parameter specifies which organizational units the workspace can access.</p>
        pub fn account_access_type(mut self, input: crate::model::AccountAccessType) -> Self {
            self.account_access_type = Some(input);
            self
        }
        /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If this is <code>ORGANIZATION</code>, the <code>workspaceOrganizationalUnits</code> parameter specifies which organizational units the workspace can access.</p>
        pub fn set_account_access_type(
            mut self,
            input: std::option::Option<crate::model::AccountAccessType>,
        ) -> Self {
            self.account_access_type = input;
            self
        }
        /// <p>The date that the workspace was created.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date that the workspace was created.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>Specifies the Amazon Web Services data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.</p>
        pub fn data_sources(mut self, input: crate::model::DataSourceType) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input);
            self.data_sources = Some(v);
            self
        }
        /// <p>Specifies the Amazon Web Services data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// <p>The user-defined description of the workspace.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The user-defined description of the workspace.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The URL that users can use to access the Grafana console in the workspace.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The URL that users can use to access the Grafana console in the workspace.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The version of Grafana supported in this workspace.</p>
        pub fn grafana_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.grafana_version = Some(input.into());
            self
        }
        /// <p>The version of Grafana supported in this workspace.</p>
        pub fn set_grafana_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grafana_version = input;
            self
        }
        /// <p>The unique ID of this workspace.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of this workspace.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The most recent date that the workspace was modified.</p>
        pub fn modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified = Some(input);
            self
        }
        /// <p>The most recent date that the workspace was modified.</p>
        pub fn set_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified = input;
            self
        }
        /// <p>The name of the workspace.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the workspace.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the IAM role that is used to access resources through Organizations.</p>
        pub fn organization_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM role that is used to access resources through Organizations.</p>
        pub fn set_organization_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_role_name = input;
            self
        }
        /// Appends an item to `notification_destinations`.
        ///
        /// To override the contents of this collection use [`set_notification_destinations`](Self::set_notification_destinations).
        ///
        /// <p>The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.</p>
        pub fn notification_destinations(
            mut self,
            input: crate::model::NotificationDestinationType,
        ) -> Self {
            let mut v = self.notification_destinations.unwrap_or_default();
            v.push(input);
            self.notification_destinations = Some(v);
            self
        }
        /// <p>The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.</p>
        pub fn set_notification_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
        ) -> Self {
            self.notification_destinations = input;
            self
        }
        /// Appends an item to `organizational_units`.
        ///
        /// To override the contents of this collection use [`set_organizational_units`](Self::set_organizational_units).
        ///
        /// <p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>
        pub fn organizational_units(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.organizational_units.unwrap_or_default();
            v.push(input.into());
            self.organizational_units = Some(v);
            self
        }
        /// <p>Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.</p>
        pub fn set_organizational_units(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organizational_units = input;
            self
        }
        /// <p>If this is <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p>
        /// <p>If this is <code>CUSTOMER_MANAGED</code>, you manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.permission_type = Some(input);
            self
        }
        /// <p>If this is <code>Service Managed</code>, Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.</p>
        /// <p>If this is <code>CUSTOMER_MANAGED</code>, you manage those roles and permissions yourself. If you are creating this workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels</a> </p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.permission_type = input;
            self
        }
        /// <p>The name of the CloudFormation stack set that is used to generate IAM roles to be used for this workspace.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudFormation stack set that is used to generate IAM roles to be used for this workspace.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// <p>The current status of the workspace.</p>
        pub fn status(mut self, input: crate::model::WorkspaceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the workspace.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorkspaceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. This role must already exist.</p>
        pub fn workspace_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. This role must already exist.</p>
        pub fn set_workspace_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workspace_role_arn = input;
            self
        }
        /// <p>Specifies whether this workspace has a full Grafana Enterprise license or a free trial license.</p>
        pub fn license_type(mut self, input: crate::model::LicenseType) -> Self {
            self.license_type = Some(input);
            self
        }
        /// <p>Specifies whether this workspace has a full Grafana Enterprise license or a free trial license.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.license_type = input;
            self
        }
        /// <p>Specifies whether this workspace has already fully used its free trial for Grafana Enterprise.</p>
        pub fn free_trial_consumed(mut self, input: bool) -> Self {
            self.free_trial_consumed = Some(input);
            self
        }
        /// <p>Specifies whether this workspace has already fully used its free trial for Grafana Enterprise.</p>
        pub fn set_free_trial_consumed(mut self, input: std::option::Option<bool>) -> Self {
            self.free_trial_consumed = input;
            self
        }
        /// <p>If this workspace has a full Grafana Enterprise license, this specifies when the license ends and will need to be renewed.</p>
        pub fn license_expiration(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.license_expiration = Some(input);
            self
        }
        /// <p>If this workspace has a full Grafana Enterprise license, this specifies when the license ends and will need to be renewed.</p>
        pub fn set_license_expiration(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.license_expiration = input;
            self
        }
        /// <p>If this workspace is currently in the free trial period for Grafana Enterprise, this value specifies when that free trial ends.</p>
        pub fn free_trial_expiration(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.free_trial_expiration = Some(input);
            self
        }
        /// <p>If this workspace is currently in the free trial period for Grafana Enterprise, this value specifies when that free trial ends.</p>
        pub fn set_free_trial_expiration(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.free_trial_expiration = input;
            self
        }
        /// <p>A structure that describes whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.</p>
        pub fn authentication(mut self, input: crate::model::AuthenticationSummary) -> Self {
            self.authentication = Some(input);
            self
        }
        /// <p>A structure that describes whether the workspace uses SAML, Amazon Web Services SSO, or both methods for user authentication.</p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<crate::model::AuthenticationSummary>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkspaceDescription`](crate::model::WorkspaceDescription)
        pub fn build(self) -> crate::model::WorkspaceDescription {
            crate::model::WorkspaceDescription {
                account_access_type: self.account_access_type,
                created: self.created,
                data_sources: self.data_sources,
                description: self.description,
                endpoint: self.endpoint,
                grafana_version: self.grafana_version,
                id: self.id,
                modified: self.modified,
                name: self.name,
                organization_role_name: self.organization_role_name,
                notification_destinations: self.notification_destinations,
                organizational_units: self.organizational_units,
                permission_type: self.permission_type,
                stack_set_name: self.stack_set_name,
                status: self.status,
                workspace_role_arn: self.workspace_role_arn,
                license_type: self.license_type,
                free_trial_consumed: self.free_trial_consumed,
                license_expiration: self.license_expiration,
                free_trial_expiration: self.free_trial_expiration,
                authentication: self.authentication,
            }
        }
    }
}
impl WorkspaceDescription {
    /// Creates a new builder-style object to manufacture [`WorkspaceDescription`](crate::model::WorkspaceDescription)
    pub fn builder() -> crate::model::workspace_description::Builder {
        crate::model::workspace_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LicenseType {
    /// Grafana Enterprise License.
    Enterprise,
    /// Grafana Enterprise Free Trial License.
    EnterpriseFreeTrial,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LicenseType {
    fn from(s: &str) -> Self {
        match s {
            "ENTERPRISE" => LicenseType::Enterprise,
            "ENTERPRISE_FREE_TRIAL" => LicenseType::EnterpriseFreeTrial,
            other => LicenseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LicenseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LicenseType::from(s))
    }
}
impl LicenseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LicenseType::Enterprise => "ENTERPRISE",
            LicenseType::EnterpriseFreeTrial => "ENTERPRISE_FREE_TRIAL",
            LicenseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENTERPRISE", "ENTERPRISE_FREE_TRIAL"]
    }
}
impl AsRef<str> for LicenseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PermissionType {
    /// Customer Managed
    CustomerManaged,
    /// Service Managed
    ServiceManaged,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PermissionType {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOMER_MANAGED" => PermissionType::CustomerManaged,
            "SERVICE_MANAGED" => PermissionType::ServiceManaged,
            other => PermissionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PermissionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PermissionType::from(s))
    }
}
impl PermissionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PermissionType::CustomerManaged => "CUSTOMER_MANAGED",
            PermissionType::ServiceManaged => "SERVICE_MANAGED",
            PermissionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOMER_MANAGED", "SERVICE_MANAGED"]
    }
}
impl AsRef<str> for PermissionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSourceType {
    /// Amazon OpenSearch Service
    AmazonOpensearchService,
    /// CloudWatch Logs
    Cloudwatch,
    /// Managed Prometheus
    Prometheus,
    /// IoT SiteWise
    Sitewise,
    /// Timestream
    Timestream,
    /// X-Ray
    Xray,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSourceType {
    fn from(s: &str) -> Self {
        match s {
            "AMAZON_OPENSEARCH_SERVICE" => DataSourceType::AmazonOpensearchService,
            "CLOUDWATCH" => DataSourceType::Cloudwatch,
            "PROMETHEUS" => DataSourceType::Prometheus,
            "SITEWISE" => DataSourceType::Sitewise,
            "TIMESTREAM" => DataSourceType::Timestream,
            "XRAY" => DataSourceType::Xray,
            other => DataSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSourceType::from(s))
    }
}
impl DataSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSourceType::AmazonOpensearchService => "AMAZON_OPENSEARCH_SERVICE",
            DataSourceType::Cloudwatch => "CLOUDWATCH",
            DataSourceType::Prometheus => "PROMETHEUS",
            DataSourceType::Sitewise => "SITEWISE",
            DataSourceType::Timestream => "TIMESTREAM",
            DataSourceType::Xray => "XRAY",
            DataSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AMAZON_OPENSEARCH_SERVICE",
            "CLOUDWATCH",
            "PROMETHEUS",
            "SITEWISE",
            "TIMESTREAM",
            "XRAY",
        ]
    }
}
impl AsRef<str> for DataSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountAccessType {
    /// Indicates that the customer is using Grafana to monitor resources in their current account.
    CurrentAccount,
    /// Indicates that the customer is using Grafana to monitor resources in organizational units.
    Organization,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountAccessType {
    fn from(s: &str) -> Self {
        match s {
            "CURRENT_ACCOUNT" => AccountAccessType::CurrentAccount,
            "ORGANIZATION" => AccountAccessType::Organization,
            other => AccountAccessType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountAccessType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountAccessType::from(s))
    }
}
impl AccountAccessType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountAccessType::CurrentAccount => "CURRENT_ACCOUNT",
            AccountAccessType::Organization => "ORGANIZATION",
            AccountAccessType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CURRENT_ACCOUNT", "ORGANIZATION"]
    }
}
impl AsRef<str> for AccountAccessType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure containing information about one error encountered while performing an <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateError {
    /// <p>The error code.</p>
    pub code: std::option::Option<i32>,
    /// <p>The message for this error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Specifies which permission update caused the error.</p>
    pub caused_by: std::option::Option<crate::model::UpdateInstruction>,
}
impl UpdateError {
    /// <p>The error code.</p>
    pub fn code(&self) -> std::option::Option<i32> {
        self.code
    }
    /// <p>The message for this error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Specifies which permission update caused the error.</p>
    pub fn caused_by(&self) -> std::option::Option<&crate::model::UpdateInstruction> {
        self.caused_by.as_ref()
    }
}
impl std::fmt::Debug for UpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateError");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("caused_by", &self.caused_by);
        formatter.finish()
    }
}
/// See [`UpdateError`](crate::model::UpdateError)
pub mod update_error {
    /// A builder for [`UpdateError`](crate::model::UpdateError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<i32>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) caused_by: std::option::Option<crate::model::UpdateInstruction>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message for this error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for this error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Specifies which permission update caused the error.</p>
        pub fn caused_by(mut self, input: crate::model::UpdateInstruction) -> Self {
            self.caused_by = Some(input);
            self
        }
        /// <p>Specifies which permission update caused the error.</p>
        pub fn set_caused_by(
            mut self,
            input: std::option::Option<crate::model::UpdateInstruction>,
        ) -> Self {
            self.caused_by = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateError`](crate::model::UpdateError)
        pub fn build(self) -> crate::model::UpdateError {
            crate::model::UpdateError {
                code: self.code,
                message: self.message,
                caused_by: self.caused_by,
            }
        }
    }
}
impl UpdateError {
    /// Creates a new builder-style object to manufacture [`UpdateError`](crate::model::UpdateError)
    pub fn builder() -> crate::model::update_error::Builder {
        crate::model::update_error::Builder::default()
    }
}

/// <p>Contains the instructions for one Grafana role permission update in a <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html">UpdatePermissions</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInstruction {
    /// <p>Specifies whether this update is to add or revoke role permissions.</p>
    pub action: std::option::Option<crate::model::UpdateAction>,
    /// <p>The role to add or revoke for the user or the group specified in <code>users</code>.</p>
    pub role: std::option::Option<crate::model::Role>,
    /// <p>A structure that specifies the user or group to add or revoke the role for.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::User>>,
}
impl UpdateInstruction {
    /// <p>Specifies whether this update is to add or revoke role permissions.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::UpdateAction> {
        self.action.as_ref()
    }
    /// <p>The role to add or revoke for the user or the group specified in <code>users</code>.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::Role> {
        self.role.as_ref()
    }
    /// <p>A structure that specifies the user or group to add or revoke the role for.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::User]> {
        self.users.as_deref()
    }
}
impl std::fmt::Debug for UpdateInstruction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInstruction");
        formatter.field("action", &self.action);
        formatter.field("role", &self.role);
        formatter.field("users", &self.users);
        formatter.finish()
    }
}
/// See [`UpdateInstruction`](crate::model::UpdateInstruction)
pub mod update_instruction {
    /// A builder for [`UpdateInstruction`](crate::model::UpdateInstruction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::UpdateAction>,
        pub(crate) role: std::option::Option<crate::model::Role>,
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::User>>,
    }
    impl Builder {
        /// <p>Specifies whether this update is to add or revoke role permissions.</p>
        pub fn action(mut self, input: crate::model::UpdateAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies whether this update is to add or revoke role permissions.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::UpdateAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The role to add or revoke for the user or the group specified in <code>users</code>.</p>
        pub fn role(mut self, input: crate::model::Role) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>The role to add or revoke for the user or the group specified in <code>users</code>.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::Role>) -> Self {
            self.role = input;
            self
        }
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>A structure that specifies the user or group to add or revoke the role for.</p>
        pub fn users(mut self, input: crate::model::User) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input);
            self.users = Some(v);
            self
        }
        /// <p>A structure that specifies the user or group to add or revoke the role for.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInstruction`](crate::model::UpdateInstruction)
        pub fn build(self) -> crate::model::UpdateInstruction {
            crate::model::UpdateInstruction {
                action: self.action,
                role: self.role,
                users: self.users,
            }
        }
    }
}
impl UpdateInstruction {
    /// Creates a new builder-style object to manufacture [`UpdateInstruction`](crate::model::UpdateInstruction)
    pub fn builder() -> crate::model::update_instruction::Builder {
        crate::model::update_instruction::Builder::default()
    }
}

/// <p>A structure that specifies one user or group in the workspace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>The ID of the user or group.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies whether this is a single user or a group.</p>
    pub r#type: std::option::Option<crate::model::UserType>,
}
impl User {
    /// <p>The ID of the user or group.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies whether this is a single user or a group.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UserType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::UserType>,
    }
    impl Builder {
        /// <p>The ID of the user or group.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the user or group.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies whether this is a single user or a group.</p>
        pub fn r#type(mut self, input: crate::model::UserType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies whether this is a single user or a group.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                id: self.id,
                r#type: self.r#type,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserType {
    /// SSO group.
    SsoGroup,
    /// SSO user.
    SsoUser,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserType {
    fn from(s: &str) -> Self {
        match s {
            "SSO_GROUP" => UserType::SsoGroup,
            "SSO_USER" => UserType::SsoUser,
            other => UserType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserType::from(s))
    }
}
impl UserType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserType::SsoGroup => "SSO_GROUP",
            UserType::SsoUser => "SSO_USER",
            UserType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SSO_GROUP", "SSO_USER"]
    }
}
impl AsRef<str> for UserType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Role {
    /// Role Admin.
    Admin,
    /// Role Editor.
    Editor,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Role {
    fn from(s: &str) -> Self {
        match s {
            "ADMIN" => Role::Admin,
            "EDITOR" => Role::Editor,
            other => Role::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Role {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Role::from(s))
    }
}
impl Role {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Role::Admin => "ADMIN",
            Role::Editor => "EDITOR",
            Role::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADMIN", "EDITOR"]
    }
}
impl AsRef<str> for Role {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateAction {
    /// Add permissions.
    Add,
    /// Revoke permissions.
    Revoke,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateAction {
    fn from(s: &str) -> Self {
        match s {
            "ADD" => UpdateAction::Add,
            "REVOKE" => UpdateAction::Revoke,
            other => UpdateAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateAction::from(s))
    }
}
impl UpdateAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateAction::Add => "ADD",
            UpdateAction::Revoke => "REVOKE",
            UpdateAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADD", "REVOKE"]
    }
}
impl AsRef<str> for UpdateAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure containing the identity of one user or group and the <code>Admin</code> or <code>Editor</code> role that they have.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PermissionEntry {
    /// <p>A structure with the ID of the user or group with this role.</p>
    pub user: std::option::Option<crate::model::User>,
    /// <p>Specifies whether the user or group has the <code>Admin</code> or <code>Editor</code> role.</p>
    pub role: std::option::Option<crate::model::Role>,
}
impl PermissionEntry {
    /// <p>A structure with the ID of the user or group with this role.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::User> {
        self.user.as_ref()
    }
    /// <p>Specifies whether the user or group has the <code>Admin</code> or <code>Editor</code> role.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::Role> {
        self.role.as_ref()
    }
}
impl std::fmt::Debug for PermissionEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PermissionEntry");
        formatter.field("user", &self.user);
        formatter.field("role", &self.role);
        formatter.finish()
    }
}
/// See [`PermissionEntry`](crate::model::PermissionEntry)
pub mod permission_entry {
    /// A builder for [`PermissionEntry`](crate::model::PermissionEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::User>,
        pub(crate) role: std::option::Option<crate::model::Role>,
    }
    impl Builder {
        /// <p>A structure with the ID of the user or group with this role.</p>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>A structure with the ID of the user or group with this role.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// <p>Specifies whether the user or group has the <code>Admin</code> or <code>Editor</code> role.</p>
        pub fn role(mut self, input: crate::model::Role) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>Specifies whether the user or group has the <code>Admin</code> or <code>Editor</code> role.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::Role>) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`PermissionEntry`](crate::model::PermissionEntry)
        pub fn build(self) -> crate::model::PermissionEntry {
            crate::model::PermissionEntry {
                user: self.user,
                role: self.role,
            }
        }
    }
}
impl PermissionEntry {
    /// Creates a new builder-style object to manufacture [`PermissionEntry`](crate::model::PermissionEntry)
    pub fn builder() -> crate::model::permission_entry::Builder {
        crate::model::permission_entry::Builder::default()
    }
}

/// <p>A structure containing information about the user authentication methods used by the workspace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationDescription {
    /// <p>Specifies whether this workspace uses Amazon Web Services SSO, SAML, or both methods to authenticate users to use the Grafana console in the Amazon Managed Grafana workspace.</p>
    pub providers: std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
    /// <p>A structure containing information about how this workspace works with SAML, including what attributes within the assertion are to be mapped to user information in the workspace. </p>
    pub saml: std::option::Option<crate::model::SamlAuthentication>,
    /// <p>A structure containing information about how this workspace works with Amazon Web Services SSO. </p>
    pub aws_sso: std::option::Option<crate::model::AwsSsoAuthentication>,
}
impl AuthenticationDescription {
    /// <p>Specifies whether this workspace uses Amazon Web Services SSO, SAML, or both methods to authenticate users to use the Grafana console in the Amazon Managed Grafana workspace.</p>
    pub fn providers(&self) -> std::option::Option<&[crate::model::AuthenticationProviderTypes]> {
        self.providers.as_deref()
    }
    /// <p>A structure containing information about how this workspace works with SAML, including what attributes within the assertion are to be mapped to user information in the workspace. </p>
    pub fn saml(&self) -> std::option::Option<&crate::model::SamlAuthentication> {
        self.saml.as_ref()
    }
    /// <p>A structure containing information about how this workspace works with Amazon Web Services SSO. </p>
    pub fn aws_sso(&self) -> std::option::Option<&crate::model::AwsSsoAuthentication> {
        self.aws_sso.as_ref()
    }
}
impl std::fmt::Debug for AuthenticationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationDescription");
        formatter.field("providers", &self.providers);
        formatter.field("saml", &self.saml);
        formatter.field("aws_sso", &self.aws_sso);
        formatter.finish()
    }
}
/// See [`AuthenticationDescription`](crate::model::AuthenticationDescription)
pub mod authentication_description {
    /// A builder for [`AuthenticationDescription`](crate::model::AuthenticationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) providers:
            std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
        pub(crate) saml: std::option::Option<crate::model::SamlAuthentication>,
        pub(crate) aws_sso: std::option::Option<crate::model::AwsSsoAuthentication>,
    }
    impl Builder {
        /// Appends an item to `providers`.
        ///
        /// To override the contents of this collection use [`set_providers`](Self::set_providers).
        ///
        /// <p>Specifies whether this workspace uses Amazon Web Services SSO, SAML, or both methods to authenticate users to use the Grafana console in the Amazon Managed Grafana workspace.</p>
        pub fn providers(mut self, input: crate::model::AuthenticationProviderTypes) -> Self {
            let mut v = self.providers.unwrap_or_default();
            v.push(input);
            self.providers = Some(v);
            self
        }
        /// <p>Specifies whether this workspace uses Amazon Web Services SSO, SAML, or both methods to authenticate users to use the Grafana console in the Amazon Managed Grafana workspace.</p>
        pub fn set_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
        ) -> Self {
            self.providers = input;
            self
        }
        /// <p>A structure containing information about how this workspace works with SAML, including what attributes within the assertion are to be mapped to user information in the workspace. </p>
        pub fn saml(mut self, input: crate::model::SamlAuthentication) -> Self {
            self.saml = Some(input);
            self
        }
        /// <p>A structure containing information about how this workspace works with SAML, including what attributes within the assertion are to be mapped to user information in the workspace. </p>
        pub fn set_saml(
            mut self,
            input: std::option::Option<crate::model::SamlAuthentication>,
        ) -> Self {
            self.saml = input;
            self
        }
        /// <p>A structure containing information about how this workspace works with Amazon Web Services SSO. </p>
        pub fn aws_sso(mut self, input: crate::model::AwsSsoAuthentication) -> Self {
            self.aws_sso = Some(input);
            self
        }
        /// <p>A structure containing information about how this workspace works with Amazon Web Services SSO. </p>
        pub fn set_aws_sso(
            mut self,
            input: std::option::Option<crate::model::AwsSsoAuthentication>,
        ) -> Self {
            self.aws_sso = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationDescription`](crate::model::AuthenticationDescription)
        pub fn build(self) -> crate::model::AuthenticationDescription {
            crate::model::AuthenticationDescription {
                providers: self.providers,
                saml: self.saml,
                aws_sso: self.aws_sso,
            }
        }
    }
}
impl AuthenticationDescription {
    /// Creates a new builder-style object to manufacture [`AuthenticationDescription`](crate::model::AuthenticationDescription)
    pub fn builder() -> crate::model::authentication_description::Builder {
        crate::model::authentication_description::Builder::default()
    }
}

/// <p>A structure containing information about how this workspace works with Amazon Web Services SSO. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsSsoAuthentication {
    /// <p>The ID of the Amazon Web Services SSO-managed application that is created by Amazon Managed Grafana.</p>
    pub sso_client_id: std::option::Option<std::string::String>,
}
impl AwsSsoAuthentication {
    /// <p>The ID of the Amazon Web Services SSO-managed application that is created by Amazon Managed Grafana.</p>
    pub fn sso_client_id(&self) -> std::option::Option<&str> {
        self.sso_client_id.as_deref()
    }
}
impl std::fmt::Debug for AwsSsoAuthentication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsSsoAuthentication");
        formatter.field("sso_client_id", &self.sso_client_id);
        formatter.finish()
    }
}
/// See [`AwsSsoAuthentication`](crate::model::AwsSsoAuthentication)
pub mod aws_sso_authentication {
    /// A builder for [`AwsSsoAuthentication`](crate::model::AwsSsoAuthentication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sso_client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services SSO-managed application that is created by Amazon Managed Grafana.</p>
        pub fn sso_client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sso_client_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services SSO-managed application that is created by Amazon Managed Grafana.</p>
        pub fn set_sso_client_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sso_client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsSsoAuthentication`](crate::model::AwsSsoAuthentication)
        pub fn build(self) -> crate::model::AwsSsoAuthentication {
            crate::model::AwsSsoAuthentication {
                sso_client_id: self.sso_client_id,
            }
        }
    }
}
impl AwsSsoAuthentication {
    /// Creates a new builder-style object to manufacture [`AwsSsoAuthentication`](crate::model::AwsSsoAuthentication)
    pub fn builder() -> crate::model::aws_sso_authentication::Builder {
        crate::model::aws_sso_authentication::Builder::default()
    }
}

/// <p>A structure containing information about how this workspace works with SAML. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamlAuthentication {
    /// <p>Specifies whether the workspace's SAML configuration is complete.</p>
    pub status: std::option::Option<crate::model::SamlConfigurationStatus>,
    /// <p>A structure containing details about how this workspace works with SAML. </p>
    pub configuration: std::option::Option<crate::model::SamlConfiguration>,
}
impl SamlAuthentication {
    /// <p>Specifies whether the workspace's SAML configuration is complete.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SamlConfigurationStatus> {
        self.status.as_ref()
    }
    /// <p>A structure containing details about how this workspace works with SAML. </p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::SamlConfiguration> {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for SamlAuthentication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamlAuthentication");
        formatter.field("status", &self.status);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`SamlAuthentication`](crate::model::SamlAuthentication)
pub mod saml_authentication {
    /// A builder for [`SamlAuthentication`](crate::model::SamlAuthentication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::SamlConfigurationStatus>,
        pub(crate) configuration: std::option::Option<crate::model::SamlConfiguration>,
    }
    impl Builder {
        /// <p>Specifies whether the workspace's SAML configuration is complete.</p>
        pub fn status(mut self, input: crate::model::SamlConfigurationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies whether the workspace's SAML configuration is complete.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SamlConfigurationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A structure containing details about how this workspace works with SAML. </p>
        pub fn configuration(mut self, input: crate::model::SamlConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>A structure containing details about how this workspace works with SAML. </p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::SamlConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SamlAuthentication`](crate::model::SamlAuthentication)
        pub fn build(self) -> crate::model::SamlAuthentication {
            crate::model::SamlAuthentication {
                status: self.status,
                configuration: self.configuration,
            }
        }
    }
}
impl SamlAuthentication {
    /// Creates a new builder-style object to manufacture [`SamlAuthentication`](crate::model::SamlAuthentication)
    pub fn builder() -> crate::model::saml_authentication::Builder {
        crate::model::saml_authentication::Builder::default()
    }
}

/// <p>A structure containing information about how this workspace works with SAML. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamlConfiguration {
    /// <p>A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.</p>
    pub idp_metadata: std::option::Option<crate::model::IdpMetadata>,
    /// <p>A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.</p>
    pub assertion_attributes: std::option::Option<crate::model::AssertionAttributes>,
    /// <p>A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>
    pub role_values: std::option::Option<crate::model::RoleValues>,
    /// <p>Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana workspace. If this is empty, all organizations in the assertion attribute have access.</p>
    pub allowed_organizations: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>How long a sign-on session by a SAML user is valid, before the user has to sign on again.</p>
    pub login_validity_duration: i32,
}
impl SamlConfiguration {
    /// <p>A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.</p>
    pub fn idp_metadata(&self) -> std::option::Option<&crate::model::IdpMetadata> {
        self.idp_metadata.as_ref()
    }
    /// <p>A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.</p>
    pub fn assertion_attributes(&self) -> std::option::Option<&crate::model::AssertionAttributes> {
        self.assertion_attributes.as_ref()
    }
    /// <p>A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>
    pub fn role_values(&self) -> std::option::Option<&crate::model::RoleValues> {
        self.role_values.as_ref()
    }
    /// <p>Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana workspace. If this is empty, all organizations in the assertion attribute have access.</p>
    pub fn allowed_organizations(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_organizations.as_deref()
    }
    /// <p>How long a sign-on session by a SAML user is valid, before the user has to sign on again.</p>
    pub fn login_validity_duration(&self) -> i32 {
        self.login_validity_duration
    }
}
impl std::fmt::Debug for SamlConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamlConfiguration");
        formatter.field("idp_metadata", &self.idp_metadata);
        formatter.field("assertion_attributes", &self.assertion_attributes);
        formatter.field("role_values", &self.role_values);
        formatter.field("allowed_organizations", &self.allowed_organizations);
        formatter.field("login_validity_duration", &self.login_validity_duration);
        formatter.finish()
    }
}
/// See [`SamlConfiguration`](crate::model::SamlConfiguration)
pub mod saml_configuration {
    /// A builder for [`SamlConfiguration`](crate::model::SamlConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) idp_metadata: std::option::Option<crate::model::IdpMetadata>,
        pub(crate) assertion_attributes: std::option::Option<crate::model::AssertionAttributes>,
        pub(crate) role_values: std::option::Option<crate::model::RoleValues>,
        pub(crate) allowed_organizations: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) login_validity_duration: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.</p>
        pub fn idp_metadata(mut self, input: crate::model::IdpMetadata) -> Self {
            self.idp_metadata = Some(input);
            self
        }
        /// <p>A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.</p>
        pub fn set_idp_metadata(
            mut self,
            input: std::option::Option<crate::model::IdpMetadata>,
        ) -> Self {
            self.idp_metadata = input;
            self
        }
        /// <p>A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.</p>
        pub fn assertion_attributes(mut self, input: crate::model::AssertionAttributes) -> Self {
            self.assertion_attributes = Some(input);
            self
        }
        /// <p>A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.</p>
        pub fn set_assertion_attributes(
            mut self,
            input: std::option::Option<crate::model::AssertionAttributes>,
        ) -> Self {
            self.assertion_attributes = input;
            self
        }
        /// <p>A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>
        pub fn role_values(mut self, input: crate::model::RoleValues) -> Self {
            self.role_values = Some(input);
            self
        }
        /// <p>A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>
        pub fn set_role_values(
            mut self,
            input: std::option::Option<crate::model::RoleValues>,
        ) -> Self {
            self.role_values = input;
            self
        }
        /// Appends an item to `allowed_organizations`.
        ///
        /// To override the contents of this collection use [`set_allowed_organizations`](Self::set_allowed_organizations).
        ///
        /// <p>Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana workspace. If this is empty, all organizations in the assertion attribute have access.</p>
        pub fn allowed_organizations(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_organizations.unwrap_or_default();
            v.push(input.into());
            self.allowed_organizations = Some(v);
            self
        }
        /// <p>Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana workspace. If this is empty, all organizations in the assertion attribute have access.</p>
        pub fn set_allowed_organizations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_organizations = input;
            self
        }
        /// <p>How long a sign-on session by a SAML user is valid, before the user has to sign on again.</p>
        pub fn login_validity_duration(mut self, input: i32) -> Self {
            self.login_validity_duration = Some(input);
            self
        }
        /// <p>How long a sign-on session by a SAML user is valid, before the user has to sign on again.</p>
        pub fn set_login_validity_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.login_validity_duration = input;
            self
        }
        /// Consumes the builder and constructs a [`SamlConfiguration`](crate::model::SamlConfiguration)
        pub fn build(self) -> crate::model::SamlConfiguration {
            crate::model::SamlConfiguration {
                idp_metadata: self.idp_metadata,
                assertion_attributes: self.assertion_attributes,
                role_values: self.role_values,
                allowed_organizations: self.allowed_organizations,
                login_validity_duration: self.login_validity_duration.unwrap_or_default(),
            }
        }
    }
}
impl SamlConfiguration {
    /// Creates a new builder-style object to manufacture [`SamlConfiguration`](crate::model::SamlConfiguration)
    pub fn builder() -> crate::model::saml_configuration::Builder {
        crate::model::saml_configuration::Builder::default()
    }
}

/// <p>This structure defines which groups defined in the SAML assertion attribute are to be mapped to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoleValues {
    /// <p>A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.</p>
    pub editor: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.</p>
    pub admin: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RoleValues {
    /// <p>A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.</p>
    pub fn editor(&self) -> std::option::Option<&[std::string::String]> {
        self.editor.as_deref()
    }
    /// <p>A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.</p>
    pub fn admin(&self) -> std::option::Option<&[std::string::String]> {
        self.admin.as_deref()
    }
}
impl std::fmt::Debug for RoleValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoleValues");
        formatter.field("editor", &self.editor);
        formatter.field("admin", &self.admin);
        formatter.finish()
    }
}
/// See [`RoleValues`](crate::model::RoleValues)
pub mod role_values {
    /// A builder for [`RoleValues`](crate::model::RoleValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) editor: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) admin: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `editor`.
        ///
        /// To override the contents of this collection use [`set_editor`](Self::set_editor).
        ///
        /// <p>A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.</p>
        pub fn editor(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.editor.unwrap_or_default();
            v.push(input.into());
            self.editor = Some(v);
            self
        }
        /// <p>A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.</p>
        pub fn set_editor(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.editor = input;
            self
        }
        /// Appends an item to `admin`.
        ///
        /// To override the contents of this collection use [`set_admin`](Self::set_admin).
        ///
        /// <p>A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.</p>
        pub fn admin(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.admin.unwrap_or_default();
            v.push(input.into());
            self.admin = Some(v);
            self
        }
        /// <p>A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.</p>
        pub fn set_admin(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.admin = input;
            self
        }
        /// Consumes the builder and constructs a [`RoleValues`](crate::model::RoleValues)
        pub fn build(self) -> crate::model::RoleValues {
            crate::model::RoleValues {
                editor: self.editor,
                admin: self.admin,
            }
        }
    }
}
impl RoleValues {
    /// Creates a new builder-style object to manufacture [`RoleValues`](crate::model::RoleValues)
    pub fn builder() -> crate::model::role_values::Builder {
        crate::model::role_values::Builder::default()
    }
}

/// <p>A structure that defines which attributes in the IdP assertion are to be used to define information about the users authenticated by the IdP to use the workspace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssertionAttributes {
    /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML users.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the attribute within the SAML assertion to use as the login names for SAML users.</p>
    pub login: std::option::Option<std::string::String>,
    /// <p>The name of the attribute within the SAML assertion to use as the email names for SAML users.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for user groups.</p>
    pub groups: std::option::Option<std::string::String>,
    /// <p>The name of the attribute within the SAML assertion to use as the user roles.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for the users' organizations.</p>
    pub org: std::option::Option<std::string::String>,
}
impl AssertionAttributes {
    /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML users.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the attribute within the SAML assertion to use as the login names for SAML users.</p>
    pub fn login(&self) -> std::option::Option<&str> {
        self.login.as_deref()
    }
    /// <p>The name of the attribute within the SAML assertion to use as the email names for SAML users.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for user groups.</p>
    pub fn groups(&self) -> std::option::Option<&str> {
        self.groups.as_deref()
    }
    /// <p>The name of the attribute within the SAML assertion to use as the user roles.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for the users' organizations.</p>
    pub fn org(&self) -> std::option::Option<&str> {
        self.org.as_deref()
    }
}
impl std::fmt::Debug for AssertionAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssertionAttributes");
        formatter.field("name", &self.name);
        formatter.field("login", &self.login);
        formatter.field("email", &self.email);
        formatter.field("groups", &self.groups);
        formatter.field("role", &self.role);
        formatter.field("org", &self.org);
        formatter.finish()
    }
}
/// See [`AssertionAttributes`](crate::model::AssertionAttributes)
pub mod assertion_attributes {
    /// A builder for [`AssertionAttributes`](crate::model::AssertionAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) login: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) groups: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) org: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML users.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML users.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the login names for SAML users.</p>
        pub fn login(mut self, input: impl Into<std::string::String>) -> Self {
            self.login = Some(input.into());
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the login names for SAML users.</p>
        pub fn set_login(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.login = input;
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the email names for SAML users.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the email names for SAML users.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for user groups.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.groups = Some(input.into());
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for user groups.</p>
        pub fn set_groups(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.groups = input;
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the user roles.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the user roles.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for the users' organizations.</p>
        pub fn org(mut self, input: impl Into<std::string::String>) -> Self {
            self.org = Some(input.into());
            self
        }
        /// <p>The name of the attribute within the SAML assertion to use as the user full "friendly" names for the users' organizations.</p>
        pub fn set_org(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.org = input;
            self
        }
        /// Consumes the builder and constructs a [`AssertionAttributes`](crate::model::AssertionAttributes)
        pub fn build(self) -> crate::model::AssertionAttributes {
            crate::model::AssertionAttributes {
                name: self.name,
                login: self.login,
                email: self.email,
                groups: self.groups,
                role: self.role,
                org: self.org,
            }
        }
    }
}
impl AssertionAttributes {
    /// Creates a new builder-style object to manufacture [`AssertionAttributes`](crate::model::AssertionAttributes)
    pub fn builder() -> crate::model::assertion_attributes::Builder {
        crate::model::assertion_attributes::Builder::default()
    }
}

/// <p>A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace. You can specify the metadata either by providing a URL to its location in the <code>url</code> parameter, or by specifying the full metadata in XML format in the <code>xml</code> parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum IdpMetadata {
    /// <p>The URL of the location containing the metadata.</p>
    Url(std::string::String),
    /// <p>The actual full metadata file, in XML format.</p>
    Xml(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl IdpMetadata {
    /// Tries to convert the enum instance into [`Url`](crate::model::IdpMetadata::Url), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_url(&self) -> std::result::Result<&std::string::String, &Self> {
        if let IdpMetadata::Url(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Url`](crate::model::IdpMetadata::Url).
    pub fn is_url(&self) -> bool {
        self.as_url().is_ok()
    }
    /// Tries to convert the enum instance into [`Xml`](crate::model::IdpMetadata::Xml), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_xml(&self) -> std::result::Result<&std::string::String, &Self> {
        if let IdpMetadata::Xml(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Xml`](crate::model::IdpMetadata::Xml).
    pub fn is_xml(&self) -> bool {
        self.as_xml().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
