// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateLicenseError {
    /// Kind of error that occurred.
    pub kind: AssociateLicenseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateLicenseErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateLicenseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateLicenseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateLicenseErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateLicenseErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateLicenseErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateLicenseErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateLicenseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateLicenseError {
    fn code(&self) -> Option<&str> {
        AssociateLicenseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            AssociateLicenseErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            AssociateLicenseErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl AssociateLicenseError {
    /// Creates a new `AssociateLicenseError`.
    pub fn new(kind: AssociateLicenseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateLicenseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateLicenseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateLicenseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateLicenseErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateLicenseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLicenseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLicenseErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLicenseErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLicenseErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLicenseErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLicenseErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLicenseErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLicenseErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLicenseErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateLicenseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateLicenseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateLicenseErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateLicenseErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateLicenseErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateLicenseErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateLicenseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkspaceError {
    /// Kind of error that occurred.
    pub kind: CreateWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkspaceErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request would cause a service quota to be exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkspaceError {
    fn code(&self) -> Option<&str> {
        CreateWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateWorkspaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateWorkspaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateWorkspaceError {
    /// Creates a new `CreateWorkspaceError`.
    pub fn new(kind: CreateWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkspaceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkspaceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkspaceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateWorkspaceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            CreateWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkspaceError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkspaceErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkspaceError {
    fn code(&self) -> Option<&str> {
        DeleteWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteWorkspaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteWorkspaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteWorkspaceError {
    /// Creates a new `DeleteWorkspaceError`.
    pub fn new(kind: DeleteWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkspaceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkspaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkspaceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteWorkspaceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkspaceError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkspaceErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeWorkspaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkspaceError {
    fn code(&self) -> Option<&str> {
        DescribeWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeWorkspaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeWorkspaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeWorkspaceError {
    /// Creates a new `DescribeWorkspaceError`.
    pub fn new(kind: DescribeWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeWorkspaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeWorkspaceAuthentication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeWorkspaceAuthenticationError {
    /// Kind of error that occurred.
    pub kind: DescribeWorkspaceAuthenticationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeWorkspaceAuthentication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeWorkspaceAuthenticationErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeWorkspaceAuthenticationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeWorkspaceAuthenticationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkspaceAuthenticationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkspaceAuthenticationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeWorkspaceAuthenticationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeWorkspaceAuthenticationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeWorkspaceAuthenticationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeWorkspaceAuthenticationError {
    fn code(&self) -> Option<&str> {
        DescribeWorkspaceAuthenticationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeWorkspaceAuthenticationErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeWorkspaceAuthenticationErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeWorkspaceAuthenticationError {
    /// Creates a new `DescribeWorkspaceAuthenticationError`.
    pub fn new(
        kind: DescribeWorkspaceAuthenticationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeWorkspaceAuthenticationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeWorkspaceAuthenticationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeWorkspaceAuthenticationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeWorkspaceAuthenticationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceAuthenticationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceAuthenticationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceAuthenticationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceAuthenticationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceAuthenticationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceAuthenticationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceAuthenticationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceAuthenticationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeWorkspaceAuthenticationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeWorkspaceAuthenticationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeWorkspaceAuthenticationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeWorkspaceAuthenticationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeWorkspaceAuthenticationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeWorkspaceAuthenticationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeWorkspaceAuthenticationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeWorkspaceAuthenticationErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeWorkspaceAuthenticationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateLicenseError {
    /// Kind of error that occurred.
    pub kind: DisassociateLicenseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateLicenseErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateLicenseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateLicenseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateLicenseErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateLicenseErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateLicenseErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateLicenseErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateLicenseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateLicenseError {
    fn code(&self) -> Option<&str> {
        DisassociateLicenseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DisassociateLicenseErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DisassociateLicenseErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DisassociateLicenseError {
    /// Creates a new `DisassociateLicenseError`.
    pub fn new(kind: DisassociateLicenseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateLicenseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateLicenseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateLicenseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateLicenseErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateLicenseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLicenseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLicenseErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLicenseErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLicenseErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLicenseErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLicenseErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLicenseErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLicenseErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLicenseErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateLicenseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateLicenseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateLicenseErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateLicenseErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateLicenseErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateLicenseErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateLicenseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPermissionsError {
    /// Kind of error that occurred.
    pub kind: ListPermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPermissionsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPermissionsError {
    fn code(&self) -> Option<&str> {
        ListPermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListPermissionsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListPermissionsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListPermissionsError {
    /// Creates a new `ListPermissionsError`.
    pub fn new(kind: ListPermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListPermissionsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListPermissionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListPermissionsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListPermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPermissionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPermissionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkspacesError {
    /// Kind of error that occurred.
    pub kind: ListWorkspacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkspaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkspacesErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkspacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkspacesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListWorkspacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkspacesError {
    fn code(&self) -> Option<&str> {
        ListWorkspacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListWorkspacesErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListWorkspacesErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListWorkspacesError {
    /// Creates a new `ListWorkspacesError`.
    pub fn new(kind: ListWorkspacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkspacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkspacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkspacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkspacesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkspacesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkspacesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkspacesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListWorkspacesErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListWorkspacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkspacesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListWorkspacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePermissionsError {
    /// Kind of error that occurred.
    pub kind: UpdatePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePermissionsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePermissionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePermissionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePermissionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePermissionsError {
    fn code(&self) -> Option<&str> {
        UpdatePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdatePermissionsErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdatePermissionsErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdatePermissionsError {
    /// Creates a new `UpdatePermissionsError`.
    pub fn new(kind: UpdatePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePermissionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePermissionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePermissionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdatePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePermissionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePermissionsErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePermissionsErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWorkspaceError {
    /// Kind of error that occurred.
    pub kind: UpdateWorkspaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWorkspace` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWorkspaceErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWorkspaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWorkspaceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateWorkspaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWorkspaceError {
    fn code(&self) -> Option<&str> {
        UpdateWorkspaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateWorkspaceErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateWorkspaceErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateWorkspaceError {
    /// Creates a new `UpdateWorkspaceError`.
    pub fn new(kind: UpdateWorkspaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWorkspaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWorkspaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWorkspaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWorkspaceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateWorkspaceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateWorkspaceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateWorkspaceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateWorkspaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWorkspaceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateWorkspaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWorkspaceAuthentication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWorkspaceAuthenticationError {
    /// Kind of error that occurred.
    pub kind: UpdateWorkspaceAuthenticationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWorkspaceAuthentication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWorkspaceAuthenticationErrorKind {
    /// <p>You do not have sufficient permissions to perform this action. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource was in an inconsistent state during an update or a deletion.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Unexpected error while processing the request. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a resource that does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling. Retry the request.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The value of a parameter in the request caused an error.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWorkspaceAuthenticationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWorkspaceAuthenticationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAuthenticationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAuthenticationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateWorkspaceAuthenticationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateWorkspaceAuthenticationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAuthenticationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateWorkspaceAuthenticationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWorkspaceAuthenticationError {
    fn code(&self) -> Option<&str> {
        UpdateWorkspaceAuthenticationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateWorkspaceAuthenticationErrorKind::InternalServerException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateWorkspaceAuthenticationErrorKind::ThrottlingException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateWorkspaceAuthenticationError {
    /// Creates a new `UpdateWorkspaceAuthenticationError`.
    pub fn new(
        kind: UpdateWorkspaceAuthenticationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWorkspaceAuthenticationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWorkspaceAuthenticationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWorkspaceAuthenticationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWorkspaceAuthenticationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAuthenticationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAuthenticationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAuthenticationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAuthenticationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAuthenticationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAuthenticationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAuthenticationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAuthenticationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAuthenticationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAuthenticationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkspaceAuthenticationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkspaceAuthenticationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateWorkspaceAuthenticationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWorkspaceAuthenticationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateWorkspaceAuthenticationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateWorkspaceAuthenticationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateWorkspaceAuthenticationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateWorkspaceAuthenticationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateWorkspaceAuthenticationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateWorkspaceAuthenticationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request was denied because of request throttling. Retry the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the service that is associated with the error.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The ID of the service quota that was exceeded.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The value of a parameter in the request caused an error.</p>
    pub retry_after_seconds: std::option::Option<i32>,
}
impl ThrottlingException {
    /// <p>The ID of the service that is associated with the error.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The ID of the service quota that was exceeded.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>The value of a parameter in the request caused an error.</p>
    pub fn retry_after_seconds(&self) -> std::option::Option<i32> {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ClientError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the service that is associated with the error.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The ID of the service that is associated with the error.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The ID of the service quota that was exceeded.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The ID of the service quota that was exceeded.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The value of a parameter in the request caused an error.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The value of a parameter in the request caused an error.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                service_code: self.service_code,
                quota_code: self.quota_code,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Unexpected error while processing the request. Retry the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>How long to wait before you retry this operation.</p>
    pub retry_after_seconds: std::option::Option<i32>,
}
impl InternalServerException {
    /// <p>How long to wait before you retry this operation.</p>
    pub fn retry_after_seconds(&self) -> std::option::Option<i32> {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ServerError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>How long to wait before you retry this operation.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>How long to wait before you retry this operation.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>You do not have sufficient permissions to perform this action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The value of a parameter in the request caused an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason that the operation failed.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>A list of fields that might be associated with the error.</p>
    pub field_list: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>The reason that the operation failed.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>A list of fields that might be associated with the error.</p>
    pub fn field_list(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.field_list.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("field_list", &self.field_list);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) field_list:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason that the operation failed.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason that the operation failed.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `field_list`.
        ///
        /// To override the contents of this collection use [`set_field_list`](Self::set_field_list).
        ///
        /// <p>A list of fields that might be associated with the error.</p>
        pub fn field_list(mut self, input: crate::model::ValidationExceptionField) -> Self {
            let mut v = self.field_list.unwrap_or_default();
            v.push(input);
            self.field_list = Some(v);
            self
        }
        /// <p>A list of fields that might be associated with the error.</p>
        pub fn set_field_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.field_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                field_list: self.field_list,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request would cause a service quota to be exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that is associated with the error.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource that is associated with the error.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The value of a parameter in the request caused an error.</p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The ID of the service quota that was exceeded.</p>
    pub quota_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// <p>The ID of the resource that is associated with the error.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource that is associated with the error.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The value of a parameter in the request caused an error.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
    /// <p>The ID of the service quota that was exceeded.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("service_code", &self.service_code);
        formatter.field("quota_code", &self.quota_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that is associated with the error.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that is associated with the error.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The value of a parameter in the request caused an error.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The value of a parameter in the request caused an error.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The ID of the service quota that was exceeded.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The ID of the service quota that was exceeded.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                service_code: self.service_code,
                quota_code: self.quota_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>A resource was in an inconsistent state during an update or a deletion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>A description of the error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that is associated with the error.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource that is associated with the error.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>The ID of the resource that is associated with the error.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource that is associated with the error.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that is associated with the error.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that is associated with the error.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The request references a resource that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The value of a parameter in the request caused an error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource that is associated with the error.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource that is associated with the error.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>The ID of the resource that is associated with the error.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource that is associated with the error.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value of a parameter in the request caused an error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The value of a parameter in the request caused an error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource that is associated with the error.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource that is associated with the error.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource that is associated with the error.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}
