// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateLicense`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_license`](crate::client::Client::associate_license).
///
/// See [`crate::client::fluent_builders::AssociateLicense`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateLicense {
    _private: (),
}
impl AssociateLicense {
    /// Creates a new builder-style object to manufacture [`AssociateLicenseInput`](crate::input::AssociateLicenseInput)
    pub fn builder() -> crate::input::associate_license_input::Builder {
        crate::input::associate_license_input::Builder::default()
    }
    /// Creates a new `AssociateLicense` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateLicense {
    type Output = std::result::Result<
        crate::output::AssociateLicenseOutput,
        crate::error::AssociateLicenseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_associate_license_error(response)
        } else {
            crate::operation_deser::parse_associate_license_response(response)
        }
    }
}

/// Operation shape for `CreateWorkspace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_workspace`](crate::client::Client::create_workspace).
///
/// See [`crate::client::fluent_builders::CreateWorkspace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkspace {
    _private: (),
}
impl CreateWorkspace {
    /// Creates a new builder-style object to manufacture [`CreateWorkspaceInput`](crate::input::CreateWorkspaceInput)
    pub fn builder() -> crate::input::create_workspace_input::Builder {
        crate::input::create_workspace_input::Builder::default()
    }
    /// Creates a new `CreateWorkspace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkspace {
    type Output = std::result::Result<
        crate::output::CreateWorkspaceOutput,
        crate::error::CreateWorkspaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_workspace_error(response)
        } else {
            crate::operation_deser::parse_create_workspace_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkspace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_workspace`](crate::client::Client::delete_workspace).
///
/// See [`crate::client::fluent_builders::DeleteWorkspace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkspace {
    _private: (),
}
impl DeleteWorkspace {
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceInput`](crate::input::DeleteWorkspaceInput)
    pub fn builder() -> crate::input::delete_workspace_input::Builder {
        crate::input::delete_workspace_input::Builder::default()
    }
    /// Creates a new `DeleteWorkspace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkspace {
    type Output = std::result::Result<
        crate::output::DeleteWorkspaceOutput,
        crate::error::DeleteWorkspaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_workspace_error(response)
        } else {
            crate::operation_deser::parse_delete_workspace_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkspace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workspace`](crate::client::Client::describe_workspace).
///
/// See [`crate::client::fluent_builders::DescribeWorkspace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkspace {
    _private: (),
}
impl DescribeWorkspace {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceInput`](crate::input::DescribeWorkspaceInput)
    pub fn builder() -> crate::input::describe_workspace_input::Builder {
        crate::input::describe_workspace_input::Builder::default()
    }
    /// Creates a new `DescribeWorkspace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkspace {
    type Output = std::result::Result<
        crate::output::DescribeWorkspaceOutput,
        crate::error::DescribeWorkspaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workspace_error(response)
        } else {
            crate::operation_deser::parse_describe_workspace_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkspaceAuthentication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workspace_authentication`](crate::client::Client::describe_workspace_authentication).
///
/// See [`crate::client::fluent_builders::DescribeWorkspaceAuthentication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkspaceAuthentication {
    _private: (),
}
impl DescribeWorkspaceAuthentication {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceAuthenticationInput`](crate::input::DescribeWorkspaceAuthenticationInput)
    pub fn builder() -> crate::input::describe_workspace_authentication_input::Builder {
        crate::input::describe_workspace_authentication_input::Builder::default()
    }
    /// Creates a new `DescribeWorkspaceAuthentication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkspaceAuthentication {
    type Output = std::result::Result<
        crate::output::DescribeWorkspaceAuthenticationOutput,
        crate::error::DescribeWorkspaceAuthenticationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workspace_authentication_error(response)
        } else {
            crate::operation_deser::parse_describe_workspace_authentication_response(response)
        }
    }
}

/// Operation shape for `DisassociateLicense`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_license`](crate::client::Client::disassociate_license).
///
/// See [`crate::client::fluent_builders::DisassociateLicense`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateLicense {
    _private: (),
}
impl DisassociateLicense {
    /// Creates a new builder-style object to manufacture [`DisassociateLicenseInput`](crate::input::DisassociateLicenseInput)
    pub fn builder() -> crate::input::disassociate_license_input::Builder {
        crate::input::disassociate_license_input::Builder::default()
    }
    /// Creates a new `DisassociateLicense` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateLicense {
    type Output = std::result::Result<
        crate::output::DisassociateLicenseOutput,
        crate::error::DisassociateLicenseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_disassociate_license_error(response)
        } else {
            crate::operation_deser::parse_disassociate_license_response(response)
        }
    }
}

/// Operation shape for `ListPermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_permissions`](crate::client::Client::list_permissions).
///
/// See [`crate::client::fluent_builders::ListPermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPermissions {
    _private: (),
}
impl ListPermissions {
    /// Creates a new builder-style object to manufacture [`ListPermissionsInput`](crate::input::ListPermissionsInput)
    pub fn builder() -> crate::input::list_permissions_input::Builder {
        crate::input::list_permissions_input::Builder::default()
    }
    /// Creates a new `ListPermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPermissions {
    type Output = std::result::Result<
        crate::output::ListPermissionsOutput,
        crate::error::ListPermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_permissions_error(response)
        } else {
            crate::operation_deser::parse_list_permissions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWorkspaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_workspaces`](crate::client::Client::list_workspaces).
///
/// See [`crate::client::fluent_builders::ListWorkspaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkspaces {
    _private: (),
}
impl ListWorkspaces {
    /// Creates a new builder-style object to manufacture [`ListWorkspacesInput`](crate::input::ListWorkspacesInput)
    pub fn builder() -> crate::input::list_workspaces_input::Builder {
        crate::input::list_workspaces_input::Builder::default()
    }
    /// Creates a new `ListWorkspaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkspaces {
    type Output =
        std::result::Result<crate::output::ListWorkspacesOutput, crate::error::ListWorkspacesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_workspaces_error(response)
        } else {
            crate::operation_deser::parse_list_workspaces_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdatePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_permissions`](crate::client::Client::update_permissions).
///
/// See [`crate::client::fluent_builders::UpdatePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePermissions {
    _private: (),
}
impl UpdatePermissions {
    /// Creates a new builder-style object to manufacture [`UpdatePermissionsInput`](crate::input::UpdatePermissionsInput)
    pub fn builder() -> crate::input::update_permissions_input::Builder {
        crate::input::update_permissions_input::Builder::default()
    }
    /// Creates a new `UpdatePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePermissions {
    type Output = std::result::Result<
        crate::output::UpdatePermissionsOutput,
        crate::error::UpdatePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_permissions_error(response)
        } else {
            crate::operation_deser::parse_update_permissions_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkspace`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_workspace`](crate::client::Client::update_workspace).
///
/// See [`crate::client::fluent_builders::UpdateWorkspace`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkspace {
    _private: (),
}
impl UpdateWorkspace {
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceInput`](crate::input::UpdateWorkspaceInput)
    pub fn builder() -> crate::input::update_workspace_input::Builder {
        crate::input::update_workspace_input::Builder::default()
    }
    /// Creates a new `UpdateWorkspace` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkspace {
    type Output = std::result::Result<
        crate::output::UpdateWorkspaceOutput,
        crate::error::UpdateWorkspaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_workspace_error(response)
        } else {
            crate::operation_deser::parse_update_workspace_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkspaceAuthentication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_workspace_authentication`](crate::client::Client::update_workspace_authentication).
///
/// See [`crate::client::fluent_builders::UpdateWorkspaceAuthentication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkspaceAuthentication {
    _private: (),
}
impl UpdateWorkspaceAuthentication {
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceAuthenticationInput`](crate::input::UpdateWorkspaceAuthenticationInput)
    pub fn builder() -> crate::input::update_workspace_authentication_input::Builder {
        crate::input::update_workspace_authentication_input::Builder::default()
    }
    /// Creates a new `UpdateWorkspaceAuthentication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkspaceAuthentication {
    type Output = std::result::Result<
        crate::output::UpdateWorkspaceAuthenticationOutput,
        crate::error::UpdateWorkspaceAuthenticationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_workspace_authentication_error(response)
        } else {
            crate::operation_deser::parse_update_workspace_authentication_response(response)
        }
    }
}
