// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkspacesOutput {
    /// <p>An array of structures that contain some information about the workspaces in the account.</p>
    pub workspaces: std::option::Option<std::vec::Vec<crate::model::WorkspaceSummary>>,
    /// <p>The token to use when requesting the next set of workspaces.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorkspacesOutput {
    /// <p>An array of structures that contain some information about the workspaces in the account.</p>
    pub fn workspaces(&self) -> std::option::Option<&[crate::model::WorkspaceSummary]> {
        self.workspaces.as_deref()
    }
    /// <p>The token to use when requesting the next set of workspaces.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorkspacesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkspacesOutput");
        formatter.field("workspaces", &self.workspaces);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
pub mod list_workspaces_output {
    /// A builder for [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspaces: std::option::Option<std::vec::Vec<crate::model::WorkspaceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `workspaces`.
        ///
        /// To override the contents of this collection use [`set_workspaces`](Self::set_workspaces).
        ///
        /// <p>An array of structures that contain some information about the workspaces in the account.</p>
        pub fn workspaces(mut self, input: impl Into<crate::model::WorkspaceSummary>) -> Self {
            let mut v = self.workspaces.unwrap_or_default();
            v.push(input.into());
            self.workspaces = Some(v);
            self
        }
        /// <p>An array of structures that contain some information about the workspaces in the account.</p>
        pub fn set_workspaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkspaceSummary>>,
        ) -> Self {
            self.workspaces = input;
            self
        }
        /// <p>The token to use when requesting the next set of workspaces.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of workspaces.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
        pub fn build(self) -> crate::output::ListWorkspacesOutput {
            crate::output::ListWorkspacesOutput {
                workspaces: self.workspaces,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorkspacesOutput {
    /// Creates a new builder-style object to manufacture [`ListWorkspacesOutput`](crate::output::ListWorkspacesOutput)
    pub fn builder() -> crate::output::list_workspaces_output::Builder {
        crate::output::list_workspaces_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkspaceOutput {
    /// <p>A structure containing data about the workspace that was created.</p>
    pub workspace: std::option::Option<crate::model::WorkspaceDescription>,
}
impl CreateWorkspaceOutput {
    /// <p>A structure containing data about the workspace that was created.</p>
    pub fn workspace(&self) -> std::option::Option<&crate::model::WorkspaceDescription> {
        self.workspace.as_ref()
    }
}
impl std::fmt::Debug for CreateWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkspaceOutput");
        formatter.field("workspace", &self.workspace);
        formatter.finish()
    }
}
/// See [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
pub mod create_workspace_output {
    /// A builder for [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace: std::option::Option<crate::model::WorkspaceDescription>,
    }
    impl Builder {
        /// <p>A structure containing data about the workspace that was created.</p>
        pub fn workspace(mut self, input: crate::model::WorkspaceDescription) -> Self {
            self.workspace = Some(input);
            self
        }
        /// <p>A structure containing data about the workspace that was created.</p>
        pub fn set_workspace(
            mut self,
            input: std::option::Option<crate::model::WorkspaceDescription>,
        ) -> Self {
            self.workspace = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
        pub fn build(self) -> crate::output::CreateWorkspaceOutput {
            crate::output::CreateWorkspaceOutput {
                workspace: self.workspace,
            }
        }
    }
}
impl CreateWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorkspaceOutput`](crate::output::CreateWorkspaceOutput)
    pub fn builder() -> crate::output::create_workspace_output::Builder {
        crate::output::create_workspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkspaceOutput {
    /// <p>A structure containing information about the workspace that was deleted.</p>
    pub workspace: std::option::Option<crate::model::WorkspaceDescription>,
}
impl DeleteWorkspaceOutput {
    /// <p>A structure containing information about the workspace that was deleted.</p>
    pub fn workspace(&self) -> std::option::Option<&crate::model::WorkspaceDescription> {
        self.workspace.as_ref()
    }
}
impl std::fmt::Debug for DeleteWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkspaceOutput");
        formatter.field("workspace", &self.workspace);
        formatter.finish()
    }
}
/// See [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
pub mod delete_workspace_output {
    /// A builder for [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace: std::option::Option<crate::model::WorkspaceDescription>,
    }
    impl Builder {
        /// <p>A structure containing information about the workspace that was deleted.</p>
        pub fn workspace(mut self, input: crate::model::WorkspaceDescription) -> Self {
            self.workspace = Some(input);
            self
        }
        /// <p>A structure containing information about the workspace that was deleted.</p>
        pub fn set_workspace(
            mut self,
            input: std::option::Option<crate::model::WorkspaceDescription>,
        ) -> Self {
            self.workspace = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
        pub fn build(self) -> crate::output::DeleteWorkspaceOutput {
            crate::output::DeleteWorkspaceOutput {
                workspace: self.workspace,
            }
        }
    }
}
impl DeleteWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceOutput`](crate::output::DeleteWorkspaceOutput)
    pub fn builder() -> crate::output::delete_workspace_output::Builder {
        crate::output::delete_workspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkspaceOutput {
    /// <p>A structure containing data about the workspace that was created.</p>
    pub workspace: std::option::Option<crate::model::WorkspaceDescription>,
}
impl UpdateWorkspaceOutput {
    /// <p>A structure containing data about the workspace that was created.</p>
    pub fn workspace(&self) -> std::option::Option<&crate::model::WorkspaceDescription> {
        self.workspace.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkspaceOutput");
        formatter.field("workspace", &self.workspace);
        formatter.finish()
    }
}
/// See [`UpdateWorkspaceOutput`](crate::output::UpdateWorkspaceOutput)
pub mod update_workspace_output {
    /// A builder for [`UpdateWorkspaceOutput`](crate::output::UpdateWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace: std::option::Option<crate::model::WorkspaceDescription>,
    }
    impl Builder {
        /// <p>A structure containing data about the workspace that was created.</p>
        pub fn workspace(mut self, input: crate::model::WorkspaceDescription) -> Self {
            self.workspace = Some(input);
            self
        }
        /// <p>A structure containing data about the workspace that was created.</p>
        pub fn set_workspace(
            mut self,
            input: std::option::Option<crate::model::WorkspaceDescription>,
        ) -> Self {
            self.workspace = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkspaceOutput`](crate::output::UpdateWorkspaceOutput)
        pub fn build(self) -> crate::output::UpdateWorkspaceOutput {
            crate::output::UpdateWorkspaceOutput {
                workspace: self.workspace,
            }
        }
    }
}
impl UpdateWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceOutput`](crate::output::UpdateWorkspaceOutput)
    pub fn builder() -> crate::output::update_workspace_output::Builder {
        crate::output::update_workspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspaceOutput {
    /// <p>A structure containing information about the workspace.</p>
    pub workspace: std::option::Option<crate::model::WorkspaceDescription>,
}
impl DescribeWorkspaceOutput {
    /// <p>A structure containing information about the workspace.</p>
    pub fn workspace(&self) -> std::option::Option<&crate::model::WorkspaceDescription> {
        self.workspace.as_ref()
    }
}
impl std::fmt::Debug for DescribeWorkspaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspaceOutput");
        formatter.field("workspace", &self.workspace);
        formatter.finish()
    }
}
/// See [`DescribeWorkspaceOutput`](crate::output::DescribeWorkspaceOutput)
pub mod describe_workspace_output {
    /// A builder for [`DescribeWorkspaceOutput`](crate::output::DescribeWorkspaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace: std::option::Option<crate::model::WorkspaceDescription>,
    }
    impl Builder {
        /// <p>A structure containing information about the workspace.</p>
        pub fn workspace(mut self, input: crate::model::WorkspaceDescription) -> Self {
            self.workspace = Some(input);
            self
        }
        /// <p>A structure containing information about the workspace.</p>
        pub fn set_workspace(
            mut self,
            input: std::option::Option<crate::model::WorkspaceDescription>,
        ) -> Self {
            self.workspace = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspaceOutput`](crate::output::DescribeWorkspaceOutput)
        pub fn build(self) -> crate::output::DescribeWorkspaceOutput {
            crate::output::DescribeWorkspaceOutput {
                workspace: self.workspace,
            }
        }
    }
}
impl DescribeWorkspaceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceOutput`](crate::output::DescribeWorkspaceOutput)
    pub fn builder() -> crate::output::describe_workspace_output::Builder {
        crate::output::describe_workspace_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePermissionsOutput {
    /// <p>An array of structures that contain the errors from the operation, if any.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::UpdateError>>,
}
impl UpdatePermissionsOutput {
    /// <p>An array of structures that contain the errors from the operation, if any.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::UpdateError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for UpdatePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePermissionsOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`UpdatePermissionsOutput`](crate::output::UpdatePermissionsOutput)
pub mod update_permissions_output {
    /// A builder for [`UpdatePermissionsOutput`](crate::output::UpdatePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::UpdateError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>An array of structures that contain the errors from the operation, if any.</p>
        pub fn errors(mut self, input: impl Into<crate::model::UpdateError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>An array of structures that contain the errors from the operation, if any.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePermissionsOutput`](crate::output::UpdatePermissionsOutput)
        pub fn build(self) -> crate::output::UpdatePermissionsOutput {
            crate::output::UpdatePermissionsOutput {
                errors: self.errors,
            }
        }
    }
}
impl UpdatePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePermissionsOutput`](crate::output::UpdatePermissionsOutput)
    pub fn builder() -> crate::output::update_permissions_output::Builder {
        crate::output::update_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionsOutput {
    /// <p>The token to use in a subsequent <code>ListPermissions</code> operation to return
    /// the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The permissions returned by the operation.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::PermissionEntry>>,
}
impl ListPermissionsOutput {
    /// <p>The token to use in a subsequent <code>ListPermissions</code> operation to return
    /// the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The permissions returned by the operation.</p>
    pub fn permissions(&self) -> std::option::Option<&[crate::model::PermissionEntry]> {
        self.permissions.as_deref()
    }
}
impl std::fmt::Debug for ListPermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("permissions", &self.permissions);
        formatter.finish()
    }
}
/// See [`ListPermissionsOutput`](crate::output::ListPermissionsOutput)
pub mod list_permissions_output {
    /// A builder for [`ListPermissionsOutput`](crate::output::ListPermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::PermissionEntry>>,
    }
    impl Builder {
        /// <p>The token to use in a subsequent <code>ListPermissions</code> operation to return
        /// the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use in a subsequent <code>ListPermissions</code> operation to return
        /// the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions returned by the operation.</p>
        pub fn permissions(mut self, input: impl Into<crate::model::PermissionEntry>) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>The permissions returned by the operation.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PermissionEntry>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionsOutput`](crate::output::ListPermissionsOutput)
        pub fn build(self) -> crate::output::ListPermissionsOutput {
            crate::output::ListPermissionsOutput {
                next_token: self.next_token,
                permissions: self.permissions,
            }
        }
    }
}
impl ListPermissionsOutput {
    /// Creates a new builder-style object to manufacture [`ListPermissionsOutput`](crate::output::ListPermissionsOutput)
    pub fn builder() -> crate::output::list_permissions_output::Builder {
        crate::output::list_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateLicenseOutput {
    /// <p>A structure containing information about the workspace.</p>
    pub workspace: std::option::Option<crate::model::WorkspaceDescription>,
}
impl DisassociateLicenseOutput {
    /// <p>A structure containing information about the workspace.</p>
    pub fn workspace(&self) -> std::option::Option<&crate::model::WorkspaceDescription> {
        self.workspace.as_ref()
    }
}
impl std::fmt::Debug for DisassociateLicenseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateLicenseOutput");
        formatter.field("workspace", &self.workspace);
        formatter.finish()
    }
}
/// See [`DisassociateLicenseOutput`](crate::output::DisassociateLicenseOutput)
pub mod disassociate_license_output {
    /// A builder for [`DisassociateLicenseOutput`](crate::output::DisassociateLicenseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace: std::option::Option<crate::model::WorkspaceDescription>,
    }
    impl Builder {
        /// <p>A structure containing information about the workspace.</p>
        pub fn workspace(mut self, input: crate::model::WorkspaceDescription) -> Self {
            self.workspace = Some(input);
            self
        }
        /// <p>A structure containing information about the workspace.</p>
        pub fn set_workspace(
            mut self,
            input: std::option::Option<crate::model::WorkspaceDescription>,
        ) -> Self {
            self.workspace = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateLicenseOutput`](crate::output::DisassociateLicenseOutput)
        pub fn build(self) -> crate::output::DisassociateLicenseOutput {
            crate::output::DisassociateLicenseOutput {
                workspace: self.workspace,
            }
        }
    }
}
impl DisassociateLicenseOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateLicenseOutput`](crate::output::DisassociateLicenseOutput)
    pub fn builder() -> crate::output::disassociate_license_output::Builder {
        crate::output::disassociate_license_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateLicenseOutput {
    /// <p>A structure containing data about the workspace.</p>
    pub workspace: std::option::Option<crate::model::WorkspaceDescription>,
}
impl AssociateLicenseOutput {
    /// <p>A structure containing data about the workspace.</p>
    pub fn workspace(&self) -> std::option::Option<&crate::model::WorkspaceDescription> {
        self.workspace.as_ref()
    }
}
impl std::fmt::Debug for AssociateLicenseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateLicenseOutput");
        formatter.field("workspace", &self.workspace);
        formatter.finish()
    }
}
/// See [`AssociateLicenseOutput`](crate::output::AssociateLicenseOutput)
pub mod associate_license_output {
    /// A builder for [`AssociateLicenseOutput`](crate::output::AssociateLicenseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace: std::option::Option<crate::model::WorkspaceDescription>,
    }
    impl Builder {
        /// <p>A structure containing data about the workspace.</p>
        pub fn workspace(mut self, input: crate::model::WorkspaceDescription) -> Self {
            self.workspace = Some(input);
            self
        }
        /// <p>A structure containing data about the workspace.</p>
        pub fn set_workspace(
            mut self,
            input: std::option::Option<crate::model::WorkspaceDescription>,
        ) -> Self {
            self.workspace = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateLicenseOutput`](crate::output::AssociateLicenseOutput)
        pub fn build(self) -> crate::output::AssociateLicenseOutput {
            crate::output::AssociateLicenseOutput {
                workspace: self.workspace,
            }
        }
    }
}
impl AssociateLicenseOutput {
    /// Creates a new builder-style object to manufacture [`AssociateLicenseOutput`](crate::output::AssociateLicenseOutput)
    pub fn builder() -> crate::output::associate_license_output::Builder {
        crate::output::associate_license_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkspaceAuthenticationOutput {
    /// <p>A structure that describes the user authentication for this workspace after the update is made.</p>
    pub authentication: std::option::Option<crate::model::AuthenticationDescription>,
}
impl UpdateWorkspaceAuthenticationOutput {
    /// <p>A structure that describes the user authentication for this workspace after the update is made.</p>
    pub fn authentication(&self) -> std::option::Option<&crate::model::AuthenticationDescription> {
        self.authentication.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorkspaceAuthenticationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkspaceAuthenticationOutput");
        formatter.field("authentication", &self.authentication);
        formatter.finish()
    }
}
/// See [`UpdateWorkspaceAuthenticationOutput`](crate::output::UpdateWorkspaceAuthenticationOutput)
pub mod update_workspace_authentication_output {
    /// A builder for [`UpdateWorkspaceAuthenticationOutput`](crate::output::UpdateWorkspaceAuthenticationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication: std::option::Option<crate::model::AuthenticationDescription>,
    }
    impl Builder {
        /// <p>A structure that describes the user authentication for this workspace after the update is made.</p>
        pub fn authentication(mut self, input: crate::model::AuthenticationDescription) -> Self {
            self.authentication = Some(input);
            self
        }
        /// <p>A structure that describes the user authentication for this workspace after the update is made.</p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<crate::model::AuthenticationDescription>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkspaceAuthenticationOutput`](crate::output::UpdateWorkspaceAuthenticationOutput)
        pub fn build(self) -> crate::output::UpdateWorkspaceAuthenticationOutput {
            crate::output::UpdateWorkspaceAuthenticationOutput {
                authentication: self.authentication,
            }
        }
    }
}
impl UpdateWorkspaceAuthenticationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceAuthenticationOutput`](crate::output::UpdateWorkspaceAuthenticationOutput)
    pub fn builder() -> crate::output::update_workspace_authentication_output::Builder {
        crate::output::update_workspace_authentication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspaceAuthenticationOutput {
    /// <p>A structure containing information about the authentication methods used in
    /// the workspace.</p>
    pub authentication: std::option::Option<crate::model::AuthenticationDescription>,
}
impl DescribeWorkspaceAuthenticationOutput {
    /// <p>A structure containing information about the authentication methods used in
    /// the workspace.</p>
    pub fn authentication(&self) -> std::option::Option<&crate::model::AuthenticationDescription> {
        self.authentication.as_ref()
    }
}
impl std::fmt::Debug for DescribeWorkspaceAuthenticationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspaceAuthenticationOutput");
        formatter.field("authentication", &self.authentication);
        formatter.finish()
    }
}
/// See [`DescribeWorkspaceAuthenticationOutput`](crate::output::DescribeWorkspaceAuthenticationOutput)
pub mod describe_workspace_authentication_output {
    /// A builder for [`DescribeWorkspaceAuthenticationOutput`](crate::output::DescribeWorkspaceAuthenticationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication: std::option::Option<crate::model::AuthenticationDescription>,
    }
    impl Builder {
        /// <p>A structure containing information about the authentication methods used in
        /// the workspace.</p>
        pub fn authentication(mut self, input: crate::model::AuthenticationDescription) -> Self {
            self.authentication = Some(input);
            self
        }
        /// <p>A structure containing information about the authentication methods used in
        /// the workspace.</p>
        pub fn set_authentication(
            mut self,
            input: std::option::Option<crate::model::AuthenticationDescription>,
        ) -> Self {
            self.authentication = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspaceAuthenticationOutput`](crate::output::DescribeWorkspaceAuthenticationOutput)
        pub fn build(self) -> crate::output::DescribeWorkspaceAuthenticationOutput {
            crate::output::DescribeWorkspaceAuthenticationOutput {
                authentication: self.authentication,
            }
        }
    }
}
impl DescribeWorkspaceAuthenticationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceAuthenticationOutput`](crate::output::DescribeWorkspaceAuthenticationOutput)
    pub fn builder() -> crate::output::describe_workspace_authentication_output::Builder {
        crate::output::describe_workspace_authentication_output::Builder::default()
    }
}
