// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateLicenseInput`](crate::input::AssociateLicenseInput)
pub mod associate_license_input {
    /// A builder for [`AssociateLicenseInput`](crate::input::AssociateLicenseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) license_type: std::option::Option<crate::model::LicenseType>,
    }
    impl Builder {
        /// <p>The ID of the workspace to associate the license with.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace to associate the license with.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The type of license to associate with the workspace.</p>
        pub fn license_type(mut self, input: crate::model::LicenseType) -> Self {
            self.license_type = Some(input);
            self
        }
        /// <p>The type of license to associate with the workspace.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.license_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateLicenseInput`](crate::input::AssociateLicenseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateLicenseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateLicenseInput {
                workspace_id: self.workspace_id,
                license_type: self.license_type,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateLicenseInputOperationOutputAlias = crate::operation::AssociateLicense;
#[doc(hidden)]
pub type AssociateLicenseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateLicenseInput {
    /// Consumes the builder and constructs an Operation<[`AssociateLicense`](crate::operation::AssociateLicense)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateLicense,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateLicenseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.workspace_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_1, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.license_type;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "license_type",
                        details: "cannot be empty or unset",
                    })?;
            let license_type = aws_smithy_http::label::fmt_string(input_2, false);
            if license_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "license_type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/licenses/{licenseType}",
                workspaceId = workspace_id,
                licenseType = license_type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateLicenseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateLicenseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateLicense::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateLicense",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateLicenseInput`](crate::input::AssociateLicenseInput)
    pub fn builder() -> crate::input::associate_license_input::Builder {
        crate::input::associate_license_input::Builder::default()
    }
}

/// See [`CreateWorkspaceInput`](crate::input::CreateWorkspaceInput)
pub mod create_workspace_input {
    /// A builder for [`CreateWorkspaceInput`](crate::input::CreateWorkspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_access_type: std::option::Option<crate::model::AccountAccessType>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) organization_role_name: std::option::Option<std::string::String>,
        pub(crate) permission_type: std::option::Option<crate::model::PermissionType>,
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) workspace_data_sources:
            std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
        pub(crate) workspace_description: std::option::Option<std::string::String>,
        pub(crate) workspace_name: std::option::Option<std::string::String>,
        pub(crate) workspace_notification_destinations:
            std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
        pub(crate) workspace_organizational_units:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) workspace_role_arn: std::option::Option<std::string::String>,
        pub(crate) authentication_providers:
            std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
    }
    impl Builder {
        /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in
        /// other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must
        /// specify which organizational units the workspace can access in the
        /// <code>workspaceOrganizationalUnits</code> parameter.</p>
        pub fn account_access_type(mut self, input: crate::model::AccountAccessType) -> Self {
            self.account_access_type = Some(input);
            self
        }
        /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in
        /// other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must
        /// specify which organizational units the workspace can access in the
        /// <code>workspaceOrganizationalUnits</code> parameter.</p>
        pub fn set_account_access_type(
            mut self,
            input: std::option::Option<crate::model::AccountAccessType>,
        ) -> Self {
            self.account_access_type = input;
            self
        }
        /// <p>A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The name of an IAM role that already exists to use with Organizations to access Amazon Web Services
        /// data sources and notification channels in other accounts in an organization.</p>
        pub fn organization_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_role_name = Some(input.into());
            self
        }
        /// <p>The name of an IAM role that already exists to use with Organizations to access Amazon Web Services
        /// data sources and notification channels in other accounts in an organization.</p>
        pub fn set_organization_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_role_name = input;
            self
        }
        /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates
        /// the IAM roles and provisions the permissions that the workspace needs to use
        /// Amazon Web Services data sources and notification channels.</p>
        /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and
        /// permissions yourself. If you are creating this workspace in a member account of an
        /// organization that is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services
        /// accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for
        /// Amazon Web Services data sources and notification channels</a>
        /// </p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.permission_type = Some(input);
            self
        }
        /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates
        /// the IAM roles and provisions the permissions that the workspace needs to use
        /// Amazon Web Services data sources and notification channels.</p>
        /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and
        /// permissions yourself. If you are creating this workspace in a member account of an
        /// organization that is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services
        /// accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for
        /// Amazon Web Services data sources and notification channels</a>
        /// </p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.permission_type = input;
            self
        }
        /// <p>The name of the CloudFormation stack set to use to generate IAM roles
        /// to be used for this workspace.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudFormation stack set to use to generate IAM roles
        /// to be used for this workspace.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// Appends an item to `workspace_data_sources`.
        ///
        /// To override the contents of this collection use [`set_workspace_data_sources`](Self::set_workspace_data_sources).
        ///
        /// <p>Specify the Amazon Web Services data sources that you want to be queried in this
        /// workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these
        /// sources. You must still add them as data sources in the Grafana console in the
        /// workspace.</p>
        /// <p>If you don't specify a data source here, you can still add it as a data source in the
        /// workspace console later. However, you will then have to manually configure permissions for
        /// it.</p>
        pub fn workspace_data_sources(
            mut self,
            input: impl Into<crate::model::DataSourceType>,
        ) -> Self {
            let mut v = self.workspace_data_sources.unwrap_or_default();
            v.push(input.into());
            self.workspace_data_sources = Some(v);
            self
        }
        /// <p>Specify the Amazon Web Services data sources that you want to be queried in this
        /// workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these
        /// sources. You must still add them as data sources in the Grafana console in the
        /// workspace.</p>
        /// <p>If you don't specify a data source here, you can still add it as a data source in the
        /// workspace console later. However, you will then have to manually configure permissions for
        /// it.</p>
        pub fn set_workspace_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
        ) -> Self {
            self.workspace_data_sources = input;
            self
        }
        /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
        pub fn workspace_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_description = Some(input.into());
            self
        }
        /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
        pub fn set_workspace_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workspace_description = input;
            self
        }
        /// <p>The name for the workspace. It does not have to be unique.</p>
        pub fn workspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_name = Some(input.into());
            self
        }
        /// <p>The name for the workspace. It does not have to be unique.</p>
        pub fn set_workspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workspace_name = input;
            self
        }
        /// Appends an item to `workspace_notification_destinations`.
        ///
        /// To override the contents of this collection use [`set_workspace_notification_destinations`](Self::set_workspace_notification_destinations).
        ///
        /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
        /// data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
        /// Amazon Managed Grafana to use these channels.</p>
        pub fn workspace_notification_destinations(
            mut self,
            input: impl Into<crate::model::NotificationDestinationType>,
        ) -> Self {
            let mut v = self.workspace_notification_destinations.unwrap_or_default();
            v.push(input.into());
            self.workspace_notification_destinations = Some(v);
            self
        }
        /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
        /// data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
        /// Amazon Managed Grafana to use these channels.</p>
        pub fn set_workspace_notification_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
        ) -> Self {
            self.workspace_notification_destinations = input;
            self
        }
        /// Appends an item to `workspace_organizational_units`.
        ///
        /// To override the contents of this collection use [`set_workspace_organizational_units`](Self::set_workspace_organizational_units).
        ///
        /// <p>Specifies the organizational units that this workspace is allowed to use data sources
        /// from, if this workspace is in an account that is part of an organization.</p>
        pub fn workspace_organizational_units(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.workspace_organizational_units.unwrap_or_default();
            v.push(input.into());
            self.workspace_organizational_units = Some(v);
            self
        }
        /// <p>Specifies the organizational units that this workspace is allowed to use data sources
        /// from, if this workspace is in an account that is part of an organization.</p>
        pub fn set_workspace_organizational_units(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.workspace_organizational_units = input;
            self
        }
        /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
        /// workspace will view data from. If you already have a role that you want to use, specify it here. If you omit
        /// this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or
        /// <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is
        /// automatically created.</p>
        pub fn workspace_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_role_arn = Some(input.into());
            self
        }
        /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
        /// workspace will view data from. If you already have a role that you want to use, specify it here. If you omit
        /// this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or
        /// <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is
        /// automatically created.</p>
        pub fn set_workspace_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workspace_role_arn = input;
            self
        }
        /// Appends an item to `authentication_providers`.
        ///
        /// To override the contents of this collection use [`set_authentication_providers`](Self::set_authentication_providers).
        ///
        /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate
        /// users for using the Grafana console within a workspace. For more information,
        /// see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
        /// Amazon Managed Grafana</a>.</p>
        pub fn authentication_providers(
            mut self,
            input: impl Into<crate::model::AuthenticationProviderTypes>,
        ) -> Self {
            let mut v = self.authentication_providers.unwrap_or_default();
            v.push(input.into());
            self.authentication_providers = Some(v);
            self
        }
        /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate
        /// users for using the Grafana console within a workspace. For more information,
        /// see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
        /// Amazon Managed Grafana</a>.</p>
        pub fn set_authentication_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
        ) -> Self {
            self.authentication_providers = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkspaceInput`](crate::input::CreateWorkspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkspaceInput {
                account_access_type: self.account_access_type,
                client_token: self.client_token,
                organization_role_name: self.organization_role_name,
                permission_type: self.permission_type,
                stack_set_name: self.stack_set_name,
                workspace_data_sources: self.workspace_data_sources,
                workspace_description: self.workspace_description,
                workspace_name: self.workspace_name,
                workspace_notification_destinations: self.workspace_notification_destinations,
                workspace_organizational_units: self.workspace_organizational_units,
                workspace_role_arn: self.workspace_role_arn,
                authentication_providers: self.authentication_providers,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkspaceInputOperationOutputAlias = crate::operation::CreateWorkspace;
#[doc(hidden)]
pub type CreateWorkspaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkspaceInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkspace`](crate::operation::CreateWorkspace)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkspace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkspaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/workspaces").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkspaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkspaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_workspace(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkspace",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkspaceInput`](crate::input::CreateWorkspaceInput)
    pub fn builder() -> crate::input::create_workspace_input::Builder {
        crate::input::create_workspace_input::Builder::default()
    }
}

/// See [`DeleteWorkspaceInput`](crate::input::DeleteWorkspaceInput)
pub mod delete_workspace_input {
    /// A builder for [`DeleteWorkspaceInput`](crate::input::DeleteWorkspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace to delete.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace to delete.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkspaceInput`](crate::input::DeleteWorkspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkspaceInput {
                workspace_id: self.workspace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkspaceInputOperationOutputAlias = crate::operation::DeleteWorkspace;
#[doc(hidden)]
pub type DeleteWorkspaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkspaceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkspace`](crate::operation::DeleteWorkspace)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkspace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkspaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.workspace_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_3, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkspaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkspaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkspace",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkspaceInput`](crate::input::DeleteWorkspaceInput)
    pub fn builder() -> crate::input::delete_workspace_input::Builder {
        crate::input::delete_workspace_input::Builder::default()
    }
}

/// See [`DescribeWorkspaceInput`](crate::input::DescribeWorkspaceInput)
pub mod describe_workspace_input {
    /// A builder for [`DescribeWorkspaceInput`](crate::input::DescribeWorkspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace to display information about.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace to display information about.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspaceInput`](crate::input::DescribeWorkspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkspaceInput {
                workspace_id: self.workspace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkspaceInputOperationOutputAlias = crate::operation::DescribeWorkspace;
#[doc(hidden)]
pub type DescribeWorkspaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkspaceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkspace`](crate::operation::DescribeWorkspace)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkspace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkspaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.workspace_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_4, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkspaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkspaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkspace",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceInput`](crate::input::DescribeWorkspaceInput)
    pub fn builder() -> crate::input::describe_workspace_input::Builder {
        crate::input::describe_workspace_input::Builder::default()
    }
}

/// See [`DescribeWorkspaceAuthenticationInput`](crate::input::DescribeWorkspaceAuthenticationInput)
pub mod describe_workspace_authentication_input {
    /// A builder for [`DescribeWorkspaceAuthenticationInput`](crate::input::DescribeWorkspaceAuthenticationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workspace to return authentication information about.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace to return authentication information about.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkspaceAuthenticationInput`](crate::input::DescribeWorkspaceAuthenticationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorkspaceAuthenticationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorkspaceAuthenticationInput {
                workspace_id: self.workspace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorkspaceAuthenticationInputOperationOutputAlias =
    crate::operation::DescribeWorkspaceAuthentication;
#[doc(hidden)]
pub type DescribeWorkspaceAuthenticationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeWorkspaceAuthenticationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorkspaceAuthentication`](crate::operation::DescribeWorkspaceAuthentication)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorkspaceAuthentication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeWorkspaceAuthenticationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.workspace_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_5, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/authentication",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeWorkspaceAuthenticationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeWorkspaceAuthenticationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorkspaceAuthentication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorkspaceAuthentication",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorkspaceAuthenticationInput`](crate::input::DescribeWorkspaceAuthenticationInput)
    pub fn builder() -> crate::input::describe_workspace_authentication_input::Builder {
        crate::input::describe_workspace_authentication_input::Builder::default()
    }
}

/// See [`DisassociateLicenseInput`](crate::input::DisassociateLicenseInput)
pub mod disassociate_license_input {
    /// A builder for [`DisassociateLicenseInput`](crate::input::DisassociateLicenseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) license_type: std::option::Option<crate::model::LicenseType>,
    }
    impl Builder {
        /// <p>The ID of the workspace to remove the Grafana Enterprise license from.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace to remove the Grafana Enterprise license from.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>The type of license to remove from the workspace.</p>
        pub fn license_type(mut self, input: crate::model::LicenseType) -> Self {
            self.license_type = Some(input);
            self
        }
        /// <p>The type of license to remove from the workspace.</p>
        pub fn set_license_type(
            mut self,
            input: std::option::Option<crate::model::LicenseType>,
        ) -> Self {
            self.license_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateLicenseInput`](crate::input::DisassociateLicenseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateLicenseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateLicenseInput {
                workspace_id: self.workspace_id,
                license_type: self.license_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateLicenseInputOperationOutputAlias = crate::operation::DisassociateLicense;
#[doc(hidden)]
pub type DisassociateLicenseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateLicenseInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateLicense`](crate::operation::DisassociateLicense)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateLicense,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateLicenseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.workspace_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_6, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.license_type;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "license_type",
                        details: "cannot be empty or unset",
                    })?;
            let license_type = aws_smithy_http::label::fmt_string(input_7, false);
            if license_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "license_type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/licenses/{licenseType}",
                workspaceId = workspace_id,
                licenseType = license_type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateLicenseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateLicenseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateLicense::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateLicense",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateLicenseInput`](crate::input::DisassociateLicenseInput)
    pub fn builder() -> crate::input::disassociate_license_input::Builder {
        crate::input::disassociate_license_input::Builder::default()
    }
}

/// See [`ListPermissionsInput`](crate::input::ListPermissionsInput)
pub mod list_permissions_input {
    /// A builder for [`ListPermissionsInput`](crate::input::ListPermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) user_type: std::option::Option<crate::model::UserType>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to include in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous
        /// <code>ListPermissions</code> operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to use when requesting the next set of results. You received this token from a previous
        /// <code>ListPermissions</code> operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>(Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users
        /// are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups
        /// are returned.</p>
        pub fn user_type(mut self, input: crate::model::UserType) -> Self {
            self.user_type = Some(input);
            self
        }
        /// <p>(Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users
        /// are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups
        /// are returned.</p>
        pub fn set_user_type(mut self, input: std::option::Option<crate::model::UserType>) -> Self {
            self.user_type = input;
            self
        }
        /// <p>(Optional) Limits the results to only the user that matches this ID.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>(Optional) Limits the results to only the user that matches this ID.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>(Optional) Limits the results to only the group that matches this ID.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>(Optional) Limits the results to only the group that matches this ID.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The ID of the workspace to list permissions for. This parameter is required.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace to list permissions for. This parameter is required.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPermissionsInput`](crate::input::ListPermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPermissionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                user_type: self.user_type,
                user_id: self.user_id,
                group_id: self.group_id,
                workspace_id: self.workspace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPermissionsInputOperationOutputAlias = crate::operation::ListPermissions;
#[doc(hidden)]
pub type ListPermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPermissionsInput {
    /// Consumes the builder and constructs an Operation<[`ListPermissions`](crate::operation::ListPermissions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.workspace_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_8, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/permissions",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListPermissionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_9) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_9).encode(),
                );
            }
            if let Some(inner_10) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_10));
            }
            if let Some(inner_11) = &_input.user_type {
                query.push_kv("userType", &aws_smithy_http::query::fmt_string(&inner_11));
            }
            if let Some(inner_12) = &_input.user_id {
                query.push_kv("userId", &aws_smithy_http::query::fmt_string(&inner_12));
            }
            if let Some(inner_13) = &_input.group_id {
                query.push_kv("groupId", &aws_smithy_http::query::fmt_string(&inner_13));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPermissions",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPermissionsInput`](crate::input::ListPermissionsInput)
    pub fn builder() -> crate::input::list_permissions_input::Builder {
        crate::input::list_permissions_input::Builder::default()
    }
}

/// See [`ListWorkspacesInput`](crate::input::ListWorkspacesInput)
pub mod list_workspaces_input {
    /// A builder for [`ListWorkspacesInput`](crate::input::ListWorkspacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of workspaces to include in the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of workspaces to include in the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of workspaces to return. (You receive this token from a
        /// previous <code>ListWorkspaces</code> operation.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of workspaces to return. (You receive this token from a
        /// previous <code>ListWorkspaces</code> operation.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkspacesInput`](crate::input::ListWorkspacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkspacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkspacesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkspacesInputOperationOutputAlias = crate::operation::ListWorkspaces;
#[doc(hidden)]
pub type ListWorkspacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListWorkspacesInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkspaces`](crate::operation::ListWorkspaces)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkspaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWorkspacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/workspaces").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListWorkspacesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_14) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_14).encode(),
                );
            }
            if let Some(inner_15) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_15));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWorkspacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWorkspacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkspaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkspaces",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWorkspacesInput`](crate::input::ListWorkspacesInput)
    pub fn builder() -> crate::input::list_workspaces_input::Builder {
        crate::input::list_workspaces_input::Builder::default()
    }
}

/// See [`UpdatePermissionsInput`](crate::input::UpdatePermissionsInput)
pub mod update_permissions_input {
    /// A builder for [`UpdatePermissionsInput`](crate::input::UpdatePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_instruction_batch:
            std::option::Option<std::vec::Vec<crate::model::UpdateInstruction>>,
        pub(crate) workspace_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `update_instruction_batch`.
        ///
        /// To override the contents of this collection use [`set_update_instruction_batch`](Self::set_update_instruction_batch).
        ///
        /// <p>An array of structures that contain the permission updates to make.</p>
        pub fn update_instruction_batch(
            mut self,
            input: impl Into<crate::model::UpdateInstruction>,
        ) -> Self {
            let mut v = self.update_instruction_batch.unwrap_or_default();
            v.push(input.into());
            self.update_instruction_batch = Some(v);
            self
        }
        /// <p>An array of structures that contain the permission updates to make.</p>
        pub fn set_update_instruction_batch(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateInstruction>>,
        ) -> Self {
            self.update_instruction_batch = input;
            self
        }
        /// <p>The ID of the workspace to update.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace to update.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePermissionsInput`](crate::input::UpdatePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePermissionsInput {
                update_instruction_batch: self.update_instruction_batch,
                workspace_id: self.workspace_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePermissionsInputOperationOutputAlias = crate::operation::UpdatePermissions;
#[doc(hidden)]
pub type UpdatePermissionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdatePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePermissions`](crate::operation::UpdatePermissions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePermissions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.workspace_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_16, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/permissions",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_permissions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePermissions",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePermissionsInput`](crate::input::UpdatePermissionsInput)
    pub fn builder() -> crate::input::update_permissions_input::Builder {
        crate::input::update_permissions_input::Builder::default()
    }
}

/// See [`UpdateWorkspaceInput`](crate::input::UpdateWorkspaceInput)
pub mod update_workspace_input {
    /// A builder for [`UpdateWorkspaceInput`](crate::input::UpdateWorkspaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_access_type: std::option::Option<crate::model::AccountAccessType>,
        pub(crate) organization_role_name: std::option::Option<std::string::String>,
        pub(crate) permission_type: std::option::Option<crate::model::PermissionType>,
        pub(crate) stack_set_name: std::option::Option<std::string::String>,
        pub(crate) workspace_data_sources:
            std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
        pub(crate) workspace_description: std::option::Option<std::string::String>,
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) workspace_name: std::option::Option<std::string::String>,
        pub(crate) workspace_notification_destinations:
            std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
        pub(crate) workspace_organizational_units:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) workspace_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in
        /// other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must
        /// specify which organizational units the workspace can access in the
        /// <code>workspaceOrganizationalUnits</code> parameter.</p>
        pub fn account_access_type(mut self, input: crate::model::AccountAccessType) -> Self {
            self.account_access_type = Some(input);
            self
        }
        /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in
        /// other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must
        /// specify which organizational units the workspace can access in the
        /// <code>workspaceOrganizationalUnits</code> parameter.</p>
        pub fn set_account_access_type(
            mut self,
            input: std::option::Option<crate::model::AccountAccessType>,
        ) -> Self {
            self.account_access_type = input;
            self
        }
        /// <p>The name of an IAM role that already exists to use to access resources through Organizations.</p>
        pub fn organization_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_role_name = Some(input.into());
            self
        }
        /// <p>The name of an IAM role that already exists to use to access resources through Organizations.</p>
        pub fn set_organization_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_role_name = input;
            self
        }
        /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates
        /// the IAM roles and provisions the permissions that the workspace needs to use
        /// Amazon Web Services data sources and notification channels.</p>
        /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and
        /// permissions yourself. If you are creating this workspace in a member account of an
        /// organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services
        /// accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for
        /// Amazon Web Services data sources and notification channels</a>
        /// </p>
        pub fn permission_type(mut self, input: crate::model::PermissionType) -> Self {
            self.permission_type = Some(input);
            self
        }
        /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates
        /// the IAM roles and provisions the permissions that the workspace needs to use
        /// Amazon Web Services data sources and notification channels.</p>
        /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and
        /// permissions yourself. If you are creating this workspace in a member account of an
        /// organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services
        /// accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for
        /// Amazon Web Services data sources and notification channels</a>
        /// </p>
        pub fn set_permission_type(
            mut self,
            input: std::option::Option<crate::model::PermissionType>,
        ) -> Self {
            self.permission_type = input;
            self
        }
        /// <p>The name of the CloudFormation stack set to use to generate IAM roles
        /// to be used for this workspace.</p>
        pub fn stack_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_set_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudFormation stack set to use to generate IAM roles
        /// to be used for this workspace.</p>
        pub fn set_stack_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stack_set_name = input;
            self
        }
        /// Appends an item to `workspace_data_sources`.
        ///
        /// To override the contents of this collection use [`set_workspace_data_sources`](Self::set_workspace_data_sources).
        ///
        /// <p>Specify the Amazon Web Services data sources that you want to be queried in this
        /// workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these
        /// sources. You must still add them as data sources in the Grafana console in the
        /// workspace.</p>
        /// <p>If you don't specify a data source here, you can still add it as a data source later in
        /// the workspace console. However, you will then have to manually configure permissions for
        /// it.</p>
        pub fn workspace_data_sources(
            mut self,
            input: impl Into<crate::model::DataSourceType>,
        ) -> Self {
            let mut v = self.workspace_data_sources.unwrap_or_default();
            v.push(input.into());
            self.workspace_data_sources = Some(v);
            self
        }
        /// <p>Specify the Amazon Web Services data sources that you want to be queried in this
        /// workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these
        /// sources. You must still add them as data sources in the Grafana console in the
        /// workspace.</p>
        /// <p>If you don't specify a data source here, you can still add it as a data source later in
        /// the workspace console. However, you will then have to manually configure permissions for
        /// it.</p>
        pub fn set_workspace_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
        ) -> Self {
            self.workspace_data_sources = input;
            self
        }
        /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
        pub fn workspace_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_description = Some(input.into());
            self
        }
        /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
        pub fn set_workspace_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workspace_description = input;
            self
        }
        /// <p>The ID of the workspace to update.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace to update.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// <p>A new name for the workspace to update.</p>
        pub fn workspace_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_name = Some(input.into());
            self
        }
        /// <p>A new name for the workspace to update.</p>
        pub fn set_workspace_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workspace_name = input;
            self
        }
        /// Appends an item to `workspace_notification_destinations`.
        ///
        /// To override the contents of this collection use [`set_workspace_notification_destinations`](Self::set_workspace_notification_destinations).
        ///
        /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
        /// data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
        /// Amazon Managed Grafana to use these channels.</p>
        pub fn workspace_notification_destinations(
            mut self,
            input: impl Into<crate::model::NotificationDestinationType>,
        ) -> Self {
            let mut v = self.workspace_notification_destinations.unwrap_or_default();
            v.push(input.into());
            self.workspace_notification_destinations = Some(v);
            self
        }
        /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
        /// data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
        /// Amazon Managed Grafana to use these channels.</p>
        pub fn set_workspace_notification_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
        ) -> Self {
            self.workspace_notification_destinations = input;
            self
        }
        /// Appends an item to `workspace_organizational_units`.
        ///
        /// To override the contents of this collection use [`set_workspace_organizational_units`](Self::set_workspace_organizational_units).
        ///
        /// <p>Specifies the organizational units that this workspace is allowed to use data sources
        /// from, if this workspace is in an account that is part of an organization.</p>
        pub fn workspace_organizational_units(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.workspace_organizational_units.unwrap_or_default();
            v.push(input.into());
            self.workspace_organizational_units = Some(v);
            self
        }
        /// <p>Specifies the organizational units that this workspace is allowed to use data sources
        /// from, if this workspace is in an account that is part of an organization.</p>
        pub fn set_workspace_organizational_units(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.workspace_organizational_units = input;
            self
        }
        /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
        /// workspace will view data from. If you already have a role that you want to use, specify it here. If you omit
        /// this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or
        /// <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is
        /// automatically created.</p>
        pub fn workspace_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_role_arn = Some(input.into());
            self
        }
        /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
        /// workspace will view data from. If you already have a role that you want to use, specify it here. If you omit
        /// this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or
        /// <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is
        /// automatically created.</p>
        pub fn set_workspace_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workspace_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkspaceInput`](crate::input::UpdateWorkspaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWorkspaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWorkspaceInput {
                account_access_type: self.account_access_type,
                organization_role_name: self.organization_role_name,
                permission_type: self.permission_type,
                stack_set_name: self.stack_set_name,
                workspace_data_sources: self.workspace_data_sources,
                workspace_description: self.workspace_description,
                workspace_id: self.workspace_id,
                workspace_name: self.workspace_name,
                workspace_notification_destinations: self.workspace_notification_destinations,
                workspace_organizational_units: self.workspace_organizational_units,
                workspace_role_arn: self.workspace_role_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWorkspaceInputOperationOutputAlias = crate::operation::UpdateWorkspace;
#[doc(hidden)]
pub type UpdateWorkspaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateWorkspaceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWorkspace`](crate::operation::UpdateWorkspace)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWorkspace,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateWorkspaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.workspace_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_17, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateWorkspaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateWorkspaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_workspace(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWorkspace::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWorkspace",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceInput`](crate::input::UpdateWorkspaceInput)
    pub fn builder() -> crate::input::update_workspace_input::Builder {
        crate::input::update_workspace_input::Builder::default()
    }
}

/// See [`UpdateWorkspaceAuthenticationInput`](crate::input::UpdateWorkspaceAuthenticationInput)
pub mod update_workspace_authentication_input {
    /// A builder for [`UpdateWorkspaceAuthenticationInput`](crate::input::UpdateWorkspaceAuthenticationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workspace_id: std::option::Option<std::string::String>,
        pub(crate) authentication_providers:
            std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
        pub(crate) saml_configuration: std::option::Option<crate::model::SamlConfiguration>,
    }
    impl Builder {
        /// <p>The ID of the workspace to update the authentication for.</p>
        pub fn workspace_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workspace_id = Some(input.into());
            self
        }
        /// <p>The ID of the workspace to update the authentication for.</p>
        pub fn set_workspace_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workspace_id = input;
            self
        }
        /// Appends an item to `authentication_providers`.
        ///
        /// To override the contents of this collection use [`set_authentication_providers`](Self::set_authentication_providers).
        ///
        /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate
        /// users for using the Grafana console within a workspace. For more information,
        /// see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
        /// Amazon Managed Grafana</a>.</p>
        pub fn authentication_providers(
            mut self,
            input: impl Into<crate::model::AuthenticationProviderTypes>,
        ) -> Self {
            let mut v = self.authentication_providers.unwrap_or_default();
            v.push(input.into());
            self.authentication_providers = Some(v);
            self
        }
        /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate
        /// users for using the Grafana console within a workspace. For more information,
        /// see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
        /// Amazon Managed Grafana</a>.</p>
        pub fn set_authentication_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
        ) -> Self {
            self.authentication_providers = input;
            self
        }
        /// <p>If the workspace uses SAML, use this structure to
        /// map SAML assertion attributes to workspace user information and
        /// define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles
        /// in the workspace.</p>
        pub fn saml_configuration(mut self, input: crate::model::SamlConfiguration) -> Self {
            self.saml_configuration = Some(input);
            self
        }
        /// <p>If the workspace uses SAML, use this structure to
        /// map SAML assertion attributes to workspace user information and
        /// define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles
        /// in the workspace.</p>
        pub fn set_saml_configuration(
            mut self,
            input: std::option::Option<crate::model::SamlConfiguration>,
        ) -> Self {
            self.saml_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkspaceAuthenticationInput`](crate::input::UpdateWorkspaceAuthenticationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWorkspaceAuthenticationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWorkspaceAuthenticationInput {
                workspace_id: self.workspace_id,
                authentication_providers: self.authentication_providers,
                saml_configuration: self.saml_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWorkspaceAuthenticationInputOperationOutputAlias =
    crate::operation::UpdateWorkspaceAuthentication;
#[doc(hidden)]
pub type UpdateWorkspaceAuthenticationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateWorkspaceAuthenticationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWorkspaceAuthentication`](crate::operation::UpdateWorkspaceAuthentication)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWorkspaceAuthentication,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateWorkspaceAuthenticationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.workspace_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workspace_id",
                        details: "cannot be empty or unset",
                    })?;
            let workspace_id = aws_smithy_http::label::fmt_string(input_18, false);
            if workspace_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workspace_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workspaces/{workspaceId}/authentication",
                workspaceId = workspace_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateWorkspaceAuthenticationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateWorkspaceAuthenticationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_workspace_authentication(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWorkspaceAuthentication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWorkspaceAuthentication",
            "grafana",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateWorkspaceAuthenticationInput`](crate::input::UpdateWorkspaceAuthenticationInput)
    pub fn builder() -> crate::input::update_workspace_authentication_input::Builder {
        crate::input::update_workspace_authentication_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkspacesInput {
    /// <p>The maximum number of workspaces to include in the results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of workspaces to return. (You receive this token from a
    /// previous <code>ListWorkspaces</code> operation.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorkspacesInput {
    /// <p>The maximum number of workspaces to include in the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of workspaces to return. (You receive this token from a
    /// previous <code>ListWorkspaces</code> operation.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorkspacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkspacesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkspaceInput {
    /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in
    /// other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must
    /// specify which organizational units the workspace can access in the
    /// <code>workspaceOrganizationalUnits</code> parameter.</p>
    pub account_access_type: std::option::Option<crate::model::AccountAccessType>,
    /// <p>A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The name of an IAM role that already exists to use with Organizations to access Amazon Web Services
    /// data sources and notification channels in other accounts in an organization.</p>
    pub organization_role_name: std::option::Option<std::string::String>,
    /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates
    /// the IAM roles and provisions the permissions that the workspace needs to use
    /// Amazon Web Services data sources and notification channels.</p>
    /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and
    /// permissions yourself. If you are creating this workspace in a member account of an
    /// organization that is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services
    /// accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for
    /// Amazon Web Services data sources and notification channels</a>
    /// </p>
    pub permission_type: std::option::Option<crate::model::PermissionType>,
    /// <p>The name of the CloudFormation stack set to use to generate IAM roles
    /// to be used for this workspace.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>Specify the Amazon Web Services data sources that you want to be queried in this
    /// workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these
    /// sources. You must still add them as data sources in the Grafana console in the
    /// workspace.</p>
    /// <p>If you don't specify a data source here, you can still add it as a data source in the
    /// workspace console later. However, you will then have to manually configure permissions for
    /// it.</p>
    pub workspace_data_sources: std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
    /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
    pub workspace_description: std::option::Option<std::string::String>,
    /// <p>The name for the workspace. It does not have to be unique.</p>
    pub workspace_name: std::option::Option<std::string::String>,
    /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
    /// data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
    /// Amazon Managed Grafana to use these channels.</p>
    pub workspace_notification_destinations:
        std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
    /// <p>Specifies the organizational units that this workspace is allowed to use data sources
    /// from, if this workspace is in an account that is part of an organization.</p>
    pub workspace_organizational_units: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
    /// workspace will view data from. If you already have a role that you want to use, specify it here. If you omit
    /// this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or
    /// <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is
    /// automatically created.</p>
    pub workspace_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate
    /// users for using the Grafana console within a workspace. For more information,
    /// see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
    /// Amazon Managed Grafana</a>.</p>
    pub authentication_providers:
        std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
}
impl CreateWorkspaceInput {
    /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in
    /// other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must
    /// specify which organizational units the workspace can access in the
    /// <code>workspaceOrganizationalUnits</code> parameter.</p>
    pub fn account_access_type(&self) -> std::option::Option<&crate::model::AccountAccessType> {
        self.account_access_type.as_ref()
    }
    /// <p>A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The name of an IAM role that already exists to use with Organizations to access Amazon Web Services
    /// data sources and notification channels in other accounts in an organization.</p>
    pub fn organization_role_name(&self) -> std::option::Option<&str> {
        self.organization_role_name.as_deref()
    }
    /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates
    /// the IAM roles and provisions the permissions that the workspace needs to use
    /// Amazon Web Services data sources and notification channels.</p>
    /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and
    /// permissions yourself. If you are creating this workspace in a member account of an
    /// organization that is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services
    /// accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for
    /// Amazon Web Services data sources and notification channels</a>
    /// </p>
    pub fn permission_type(&self) -> std::option::Option<&crate::model::PermissionType> {
        self.permission_type.as_ref()
    }
    /// <p>The name of the CloudFormation stack set to use to generate IAM roles
    /// to be used for this workspace.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>Specify the Amazon Web Services data sources that you want to be queried in this
    /// workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these
    /// sources. You must still add them as data sources in the Grafana console in the
    /// workspace.</p>
    /// <p>If you don't specify a data source here, you can still add it as a data source in the
    /// workspace console later. However, you will then have to manually configure permissions for
    /// it.</p>
    pub fn workspace_data_sources(&self) -> std::option::Option<&[crate::model::DataSourceType]> {
        self.workspace_data_sources.as_deref()
    }
    /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
    pub fn workspace_description(&self) -> std::option::Option<&str> {
        self.workspace_description.as_deref()
    }
    /// <p>The name for the workspace. It does not have to be unique.</p>
    pub fn workspace_name(&self) -> std::option::Option<&str> {
        self.workspace_name.as_deref()
    }
    /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
    /// data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
    /// Amazon Managed Grafana to use these channels.</p>
    pub fn workspace_notification_destinations(
        &self,
    ) -> std::option::Option<&[crate::model::NotificationDestinationType]> {
        self.workspace_notification_destinations.as_deref()
    }
    /// <p>Specifies the organizational units that this workspace is allowed to use data sources
    /// from, if this workspace is in an account that is part of an organization.</p>
    pub fn workspace_organizational_units(&self) -> std::option::Option<&[std::string::String]> {
        self.workspace_organizational_units.as_deref()
    }
    /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
    /// workspace will view data from. If you already have a role that you want to use, specify it here. If you omit
    /// this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or
    /// <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is
    /// automatically created.</p>
    pub fn workspace_role_arn(&self) -> std::option::Option<&str> {
        self.workspace_role_arn.as_deref()
    }
    /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate
    /// users for using the Grafana console within a workspace. For more information,
    /// see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
    /// Amazon Managed Grafana</a>.</p>
    pub fn authentication_providers(
        &self,
    ) -> std::option::Option<&[crate::model::AuthenticationProviderTypes]> {
        self.authentication_providers.as_deref()
    }
}
impl std::fmt::Debug for CreateWorkspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkspaceInput");
        formatter.field("account_access_type", &self.account_access_type);
        formatter.field("client_token", &self.client_token);
        formatter.field("organization_role_name", &"*** Sensitive Data Redacted ***");
        formatter.field("permission_type", &self.permission_type);
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("workspace_data_sources", &self.workspace_data_sources);
        formatter.field("workspace_description", &"*** Sensitive Data Redacted ***");
        formatter.field("workspace_name", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "workspace_notification_destinations",
            &self.workspace_notification_destinations,
        );
        formatter.field(
            "workspace_organizational_units",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("workspace_role_arn", &"*** Sensitive Data Redacted ***");
        formatter.field("authentication_providers", &self.authentication_providers);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkspaceInput {
    /// <p>The ID of the workspace to delete.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl DeleteWorkspaceInput {
    /// <p>The ID of the workspace to delete.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWorkspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkspaceInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkspaceInput {
    /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in
    /// other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must
    /// specify which organizational units the workspace can access in the
    /// <code>workspaceOrganizationalUnits</code> parameter.</p>
    pub account_access_type: std::option::Option<crate::model::AccountAccessType>,
    /// <p>The name of an IAM role that already exists to use to access resources through Organizations.</p>
    pub organization_role_name: std::option::Option<std::string::String>,
    /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates
    /// the IAM roles and provisions the permissions that the workspace needs to use
    /// Amazon Web Services data sources and notification channels.</p>
    /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and
    /// permissions yourself. If you are creating this workspace in a member account of an
    /// organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services
    /// accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for
    /// Amazon Web Services data sources and notification channels</a>
    /// </p>
    pub permission_type: std::option::Option<crate::model::PermissionType>,
    /// <p>The name of the CloudFormation stack set to use to generate IAM roles
    /// to be used for this workspace.</p>
    pub stack_set_name: std::option::Option<std::string::String>,
    /// <p>Specify the Amazon Web Services data sources that you want to be queried in this
    /// workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these
    /// sources. You must still add them as data sources in the Grafana console in the
    /// workspace.</p>
    /// <p>If you don't specify a data source here, you can still add it as a data source later in
    /// the workspace console. However, you will then have to manually configure permissions for
    /// it.</p>
    pub workspace_data_sources: std::option::Option<std::vec::Vec<crate::model::DataSourceType>>,
    /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
    pub workspace_description: std::option::Option<std::string::String>,
    /// <p>The ID of the workspace to update.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>A new name for the workspace to update.</p>
    pub workspace_name: std::option::Option<std::string::String>,
    /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
    /// data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
    /// Amazon Managed Grafana to use these channels.</p>
    pub workspace_notification_destinations:
        std::option::Option<std::vec::Vec<crate::model::NotificationDestinationType>>,
    /// <p>Specifies the organizational units that this workspace is allowed to use data sources
    /// from, if this workspace is in an account that is part of an organization.</p>
    pub workspace_organizational_units: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
    /// workspace will view data from. If you already have a role that you want to use, specify it here. If you omit
    /// this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or
    /// <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is
    /// automatically created.</p>
    pub workspace_role_arn: std::option::Option<std::string::String>,
}
impl UpdateWorkspaceInput {
    /// <p>Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in
    /// other accounts in the same organization. If you specify <code>ORGANIZATION</code>, you must
    /// specify which organizational units the workspace can access in the
    /// <code>workspaceOrganizationalUnits</code> parameter.</p>
    pub fn account_access_type(&self) -> std::option::Option<&crate::model::AccountAccessType> {
        self.account_access_type.as_ref()
    }
    /// <p>The name of an IAM role that already exists to use to access resources through Organizations.</p>
    pub fn organization_role_name(&self) -> std::option::Option<&str> {
        self.organization_role_name.as_deref()
    }
    /// <p>If you specify <code>Service Managed</code>, Amazon Managed Grafana automatically creates
    /// the IAM roles and provisions the permissions that the workspace needs to use
    /// Amazon Web Services data sources and notification channels.</p>
    /// <p>If you specify <code>CUSTOMER_MANAGED</code>, you will manage those roles and
    /// permissions yourself. If you are creating this workspace in a member account of an
    /// organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services
    /// accounts in the organization, you must choose <code>CUSTOMER_MANAGED</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for
    /// Amazon Web Services data sources and notification channels</a>
    /// </p>
    pub fn permission_type(&self) -> std::option::Option<&crate::model::PermissionType> {
        self.permission_type.as_ref()
    }
    /// <p>The name of the CloudFormation stack set to use to generate IAM roles
    /// to be used for this workspace.</p>
    pub fn stack_set_name(&self) -> std::option::Option<&str> {
        self.stack_set_name.as_deref()
    }
    /// <p>Specify the Amazon Web Services data sources that you want to be queried in this
    /// workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to read data from these
    /// sources. You must still add them as data sources in the Grafana console in the
    /// workspace.</p>
    /// <p>If you don't specify a data source here, you can still add it as a data source later in
    /// the workspace console. However, you will then have to manually configure permissions for
    /// it.</p>
    pub fn workspace_data_sources(&self) -> std::option::Option<&[crate::model::DataSourceType]> {
        self.workspace_data_sources.as_deref()
    }
    /// <p>A description for the workspace. This is used only to help you identify this workspace.</p>
    pub fn workspace_description(&self) -> std::option::Option<&str> {
        self.workspace_description.as_deref()
    }
    /// <p>The ID of the workspace to update.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>A new name for the workspace to update.</p>
    pub fn workspace_name(&self) -> std::option::Option<&str> {
        self.workspace_name.as_deref()
    }
    /// <p>Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these
    /// data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow
    /// Amazon Managed Grafana to use these channels.</p>
    pub fn workspace_notification_destinations(
        &self,
    ) -> std::option::Option<&[crate::model::NotificationDestinationType]> {
        self.workspace_notification_destinations.as_deref()
    }
    /// <p>Specifies the organizational units that this workspace is allowed to use data sources
    /// from, if this workspace is in an account that is part of an organization.</p>
    pub fn workspace_organizational_units(&self) -> std::option::Option<&[std::string::String]> {
        self.workspace_organizational_units.as_deref()
    }
    /// <p>The workspace needs an IAM role that grants permissions to the Amazon Web Services resources that the
    /// workspace will view data from. If you already have a role that you want to use, specify it here. If you omit
    /// this field and you specify some Amazon Web Services resources in <code>workspaceDataSources</code> or
    /// <code>workspaceNotificationDestinations</code>, a new IAM role with the necessary permissions is
    /// automatically created.</p>
    pub fn workspace_role_arn(&self) -> std::option::Option<&str> {
        self.workspace_role_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateWorkspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkspaceInput");
        formatter.field("account_access_type", &self.account_access_type);
        formatter.field("organization_role_name", &"*** Sensitive Data Redacted ***");
        formatter.field("permission_type", &self.permission_type);
        formatter.field("stack_set_name", &self.stack_set_name);
        formatter.field("workspace_data_sources", &self.workspace_data_sources);
        formatter.field("workspace_description", &"*** Sensitive Data Redacted ***");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("workspace_name", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "workspace_notification_destinations",
            &self.workspace_notification_destinations,
        );
        formatter.field(
            "workspace_organizational_units",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("workspace_role_arn", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspaceInput {
    /// <p>The ID of the workspace to display information about.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl DescribeWorkspaceInput {
    /// <p>The ID of the workspace to display information about.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorkspaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspaceInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePermissionsInput {
    /// <p>An array of structures that contain the permission updates to make.</p>
    pub update_instruction_batch:
        std::option::Option<std::vec::Vec<crate::model::UpdateInstruction>>,
    /// <p>The ID of the workspace to update.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl UpdatePermissionsInput {
    /// <p>An array of structures that contain the permission updates to make.</p>
    pub fn update_instruction_batch(
        &self,
    ) -> std::option::Option<&[crate::model::UpdateInstruction]> {
        self.update_instruction_batch.as_deref()
    }
    /// <p>The ID of the workspace to update.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for UpdatePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePermissionsInput");
        formatter.field("update_instruction_batch", &self.update_instruction_batch);
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPermissionsInput {
    /// <p>The maximum number of results to include in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token to use when requesting the next set of results. You received this token from a previous
    /// <code>ListPermissions</code> operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>(Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users
    /// are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups
    /// are returned.</p>
    pub user_type: std::option::Option<crate::model::UserType>,
    /// <p>(Optional) Limits the results to only the user that matches this ID.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>(Optional) Limits the results to only the group that matches this ID.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the workspace to list permissions for. This parameter is required.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl ListPermissionsInput {
    /// <p>The maximum number of results to include in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token to use when requesting the next set of results. You received this token from a previous
    /// <code>ListPermissions</code> operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>(Optional) If you specify <code>SSO_USER</code>, then only the permissions of Amazon Web Services SSO users
    /// are returned. If you specify <code>SSO_GROUP</code>, only the permissions of Amazon Web Services SSO groups
    /// are returned.</p>
    pub fn user_type(&self) -> std::option::Option<&crate::model::UserType> {
        self.user_type.as_ref()
    }
    /// <p>(Optional) Limits the results to only the user that matches this ID.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>(Optional) Limits the results to only the group that matches this ID.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The ID of the workspace to list permissions for. This parameter is required.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for ListPermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPermissionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("user_type", &self.user_type);
        formatter.field("user_id", &self.user_id);
        formatter.field("group_id", &self.group_id);
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateLicenseInput {
    /// <p>The ID of the workspace to remove the Grafana Enterprise license from.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The type of license to remove from the workspace.</p>
    pub license_type: std::option::Option<crate::model::LicenseType>,
}
impl DisassociateLicenseInput {
    /// <p>The ID of the workspace to remove the Grafana Enterprise license from.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The type of license to remove from the workspace.</p>
    pub fn license_type(&self) -> std::option::Option<&crate::model::LicenseType> {
        self.license_type.as_ref()
    }
}
impl std::fmt::Debug for DisassociateLicenseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateLicenseInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("license_type", &self.license_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateLicenseInput {
    /// <p>The ID of the workspace to associate the license with.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>The type of license to associate with the workspace.</p>
    pub license_type: std::option::Option<crate::model::LicenseType>,
}
impl AssociateLicenseInput {
    /// <p>The ID of the workspace to associate the license with.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>The type of license to associate with the workspace.</p>
    pub fn license_type(&self) -> std::option::Option<&crate::model::LicenseType> {
        self.license_type.as_ref()
    }
}
impl std::fmt::Debug for AssociateLicenseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateLicenseInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("license_type", &self.license_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkspaceAuthenticationInput {
    /// <p>The ID of the workspace to update the authentication for.</p>
    pub workspace_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate
    /// users for using the Grafana console within a workspace. For more information,
    /// see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
    /// Amazon Managed Grafana</a>.</p>
    pub authentication_providers:
        std::option::Option<std::vec::Vec<crate::model::AuthenticationProviderTypes>>,
    /// <p>If the workspace uses SAML, use this structure to
    /// map SAML assertion attributes to workspace user information and
    /// define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles
    /// in the workspace.</p>
    pub saml_configuration: std::option::Option<crate::model::SamlConfiguration>,
}
impl UpdateWorkspaceAuthenticationInput {
    /// <p>The ID of the workspace to update the authentication for.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
    /// <p>Specifies whether this workspace uses SAML 2.0, Amazon Web Services Single Sign On, or both to authenticate
    /// users for using the Grafana console within a workspace. For more information,
    /// see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in
    /// Amazon Managed Grafana</a>.</p>
    pub fn authentication_providers(
        &self,
    ) -> std::option::Option<&[crate::model::AuthenticationProviderTypes]> {
        self.authentication_providers.as_deref()
    }
    /// <p>If the workspace uses SAML, use this structure to
    /// map SAML assertion attributes to workspace user information and
    /// define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles
    /// in the workspace.</p>
    pub fn saml_configuration(&self) -> std::option::Option<&crate::model::SamlConfiguration> {
        self.saml_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorkspaceAuthenticationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkspaceAuthenticationInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.field("authentication_providers", &self.authentication_providers);
        formatter.field("saml_configuration", &self.saml_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkspaceAuthenticationInput {
    /// <p>The ID of the workspace to return authentication information about.</p>
    pub workspace_id: std::option::Option<std::string::String>,
}
impl DescribeWorkspaceAuthenticationInput {
    /// <p>The ID of the workspace to return authentication information about.</p>
    pub fn workspace_id(&self) -> std::option::Option<&str> {
        self.workspace_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorkspaceAuthenticationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkspaceAuthenticationInput");
        formatter.field("workspace_id", &self.workspace_id);
        formatter.finish()
    }
}
