// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchCreatePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchCreatePartitionError {
    /// Kind of error that occurred.
    pub kind: BatchCreatePartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchCreatePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchCreatePartitionErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchCreatePartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchCreatePartitionErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            BatchCreatePartitionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            BatchCreatePartitionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            BatchCreatePartitionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchCreatePartitionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchCreatePartitionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchCreatePartitionErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreatePartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchCreatePartitionError {
    fn code(&self) -> Option<&str> {
        BatchCreatePartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchCreatePartitionError {
    /// Creates a new `BatchCreatePartitionError`.
    pub fn new(kind: BatchCreatePartitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchCreatePartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchCreatePartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchCreatePartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchCreatePartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchCreatePartitionErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreatePartitionErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreatePartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreatePartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreatePartitionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreatePartitionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreatePartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreatePartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreatePartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreatePartitionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreatePartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreatePartitionErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreatePartitionErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreatePartitionErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for BatchCreatePartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchCreatePartitionErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            BatchCreatePartitionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            BatchCreatePartitionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            BatchCreatePartitionErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchCreatePartitionErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchCreatePartitionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchCreatePartitionErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            BatchCreatePartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteConnectionError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteConnectionErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteConnectionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchDeleteConnectionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchDeleteConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteConnectionError {
    fn code(&self) -> Option<&str> {
        BatchDeleteConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteConnectionError {
    /// Creates a new `BatchDeleteConnectionError`.
    pub fn new(kind: BatchDeleteConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteConnectionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteConnectionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteConnectionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteConnectionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchDeleteConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteConnectionErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchDeleteConnectionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchDeleteConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeletePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeletePartitionError {
    /// Kind of error that occurred.
    pub kind: BatchDeletePartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeletePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeletePartitionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeletePartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeletePartitionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            BatchDeletePartitionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchDeletePartitionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchDeletePartitionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchDeletePartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeletePartitionError {
    fn code(&self) -> Option<&str> {
        BatchDeletePartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeletePartitionError {
    /// Creates a new `BatchDeletePartitionError`.
    pub fn new(kind: BatchDeletePartitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeletePartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeletePartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeletePartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeletePartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeletePartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeletePartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeletePartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePartitionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeletePartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeletePartitionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchDeletePartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeletePartitionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            BatchDeletePartitionErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchDeletePartitionErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchDeletePartitionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchDeletePartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeleteTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteTableError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeleteTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteTableErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource was not ready for a transaction.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteTableErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            BatchDeleteTableErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            BatchDeleteTableErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchDeleteTableErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchDeleteTableErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchDeleteTableErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            BatchDeleteTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteTableError {
    fn code(&self) -> Option<&str> {
        BatchDeleteTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteTableError {
    /// Creates a new `BatchDeleteTableError`.
    pub fn new(kind: BatchDeleteTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteTableErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteTableErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteTableErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteTableErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteTableErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteTableErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteTableErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteTableErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteTableErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteTableErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteTableErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteTableErrorKind::ResourceNotReadyException(_)
        )
    }
}
impl std::error::Error for BatchDeleteTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteTableErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            BatchDeleteTableErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            BatchDeleteTableErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchDeleteTableErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchDeleteTableErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchDeleteTableErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            BatchDeleteTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeleteTableVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteTableVersionError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteTableVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeleteTableVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteTableVersionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteTableVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteTableVersionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            BatchDeleteTableVersionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchDeleteTableVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchDeleteTableVersionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchDeleteTableVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteTableVersionError {
    fn code(&self) -> Option<&str> {
        BatchDeleteTableVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteTableVersionError {
    /// Creates a new `BatchDeleteTableVersionError`.
    pub fn new(kind: BatchDeleteTableVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteTableVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteTableVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteTableVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteTableVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteTableVersionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteTableVersionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteTableVersionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteTableVersionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteTableVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteTableVersionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteTableVersionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteTableVersionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchDeleteTableVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteTableVersionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            BatchDeleteTableVersionErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchDeleteTableVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchDeleteTableVersionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchDeleteTableVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetBlueprints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetBlueprintsError {
    /// Kind of error that occurred.
    pub kind: BatchGetBlueprintsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetBlueprints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetBlueprintsErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetBlueprintsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetBlueprintsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchGetBlueprintsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetBlueprintsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchGetBlueprintsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetBlueprintsError {
    fn code(&self) -> Option<&str> {
        BatchGetBlueprintsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetBlueprintsError {
    /// Creates a new `BatchGetBlueprintsError`.
    pub fn new(kind: BatchGetBlueprintsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetBlueprintsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetBlueprintsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetBlueprintsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetBlueprintsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetBlueprintsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetBlueprintsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetBlueprintsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetBlueprintsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetBlueprintsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetBlueprintsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchGetBlueprintsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetBlueprintsErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchGetBlueprintsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetBlueprintsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchGetBlueprintsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetCrawlers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetCrawlersError {
    /// Kind of error that occurred.
    pub kind: BatchGetCrawlersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetCrawlers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetCrawlersErrorKind {
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetCrawlersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetCrawlersErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetCrawlersErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchGetCrawlersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetCrawlersError {
    fn code(&self) -> Option<&str> {
        BatchGetCrawlersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetCrawlersError {
    /// Creates a new `BatchGetCrawlersError`.
    pub fn new(kind: BatchGetCrawlersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetCrawlersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetCrawlersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetCrawlersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetCrawlersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetCrawlersErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCrawlersErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCrawlersErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCrawlersErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchGetCrawlersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetCrawlersErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetCrawlersErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchGetCrawlersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetDevEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetDevEndpointsError {
    /// Kind of error that occurred.
    pub kind: BatchGetDevEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetDevEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetDevEndpointsErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetDevEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetDevEndpointsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchGetDevEndpointsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchGetDevEndpointsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetDevEndpointsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchGetDevEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetDevEndpointsError {
    fn code(&self) -> Option<&str> {
        BatchGetDevEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetDevEndpointsError {
    /// Creates a new `BatchGetDevEndpointsError`.
    pub fn new(kind: BatchGetDevEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetDevEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetDevEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetDevEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetDevEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetDevEndpointsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetDevEndpointsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetDevEndpointsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetDevEndpointsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetDevEndpointsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetDevEndpointsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetDevEndpointsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetDevEndpointsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchGetDevEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetDevEndpointsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchGetDevEndpointsErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchGetDevEndpointsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetDevEndpointsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchGetDevEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetJobsError {
    /// Kind of error that occurred.
    pub kind: BatchGetJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetJobsErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetJobsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchGetJobsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetJobsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchGetJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetJobsError {
    fn code(&self) -> Option<&str> {
        BatchGetJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetJobsError {
    /// Creates a new `BatchGetJobsError`.
    pub fn new(kind: BatchGetJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetJobsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetJobsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetJobsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, BatchGetJobsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `BatchGetJobsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetJobsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchGetJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetJobsErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchGetJobsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetJobsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchGetJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetPartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetPartitionError {
    /// Kind of error that occurred.
    pub kind: BatchGetPartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetPartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetPartitionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>An error that indicates your data is in an invalid state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetPartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetPartitionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            BatchGetPartitionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            BatchGetPartitionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchGetPartitionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetPartitionErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            BatchGetPartitionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchGetPartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetPartitionError {
    fn code(&self) -> Option<&str> {
        BatchGetPartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetPartitionError {
    /// Creates a new `BatchGetPartitionError`.
    pub fn new(kind: BatchGetPartitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetPartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetPartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetPartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetPartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetPartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetPartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetPartitionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetPartitionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetPartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetPartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetPartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetPartitionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetPartitionErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetPartitionErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetPartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetPartitionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchGetPartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetPartitionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            BatchGetPartitionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            BatchGetPartitionErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchGetPartitionErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetPartitionErrorKind::InvalidStateException(_inner) => Some(_inner),
            BatchGetPartitionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchGetPartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetTriggersError {
    /// Kind of error that occurred.
    pub kind: BatchGetTriggersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetTriggersErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetTriggersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetTriggersErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchGetTriggersErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetTriggersErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchGetTriggersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetTriggersError {
    fn code(&self) -> Option<&str> {
        BatchGetTriggersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetTriggersError {
    /// Creates a new `BatchGetTriggersError`.
    pub fn new(kind: BatchGetTriggersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetTriggersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetTriggersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetTriggersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetTriggersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetTriggersErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetTriggersErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetTriggersErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetTriggersErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetTriggersErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetTriggersErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchGetTriggersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetTriggersErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchGetTriggersErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetTriggersErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchGetTriggersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetWorkflows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetWorkflowsError {
    /// Kind of error that occurred.
    pub kind: BatchGetWorkflowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetWorkflows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetWorkflowsErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetWorkflowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetWorkflowsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchGetWorkflowsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetWorkflowsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchGetWorkflowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetWorkflowsError {
    fn code(&self) -> Option<&str> {
        BatchGetWorkflowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetWorkflowsError {
    /// Creates a new `BatchGetWorkflowsError`.
    pub fn new(kind: BatchGetWorkflowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetWorkflowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetWorkflowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetWorkflowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetWorkflowsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetWorkflowsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetWorkflowsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetWorkflowsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetWorkflowsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetWorkflowsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetWorkflowsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchGetWorkflowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetWorkflowsErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchGetWorkflowsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetWorkflowsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchGetWorkflowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchStopJobRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchStopJobRunError {
    /// Kind of error that occurred.
    pub kind: BatchStopJobRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchStopJobRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchStopJobRunErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchStopJobRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchStopJobRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchStopJobRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchStopJobRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchStopJobRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchStopJobRunError {
    fn code(&self) -> Option<&str> {
        BatchStopJobRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchStopJobRunError {
    /// Creates a new `BatchStopJobRunError`.
    pub fn new(kind: BatchStopJobRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchStopJobRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchStopJobRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchStopJobRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchStopJobRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchStopJobRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchStopJobRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchStopJobRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchStopJobRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchStopJobRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchStopJobRunErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchStopJobRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchStopJobRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchStopJobRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchStopJobRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchStopJobRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchUpdatePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchUpdatePartitionError {
    /// Kind of error that occurred.
    pub kind: BatchUpdatePartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchUpdatePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchUpdatePartitionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchUpdatePartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchUpdatePartitionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            BatchUpdatePartitionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            BatchUpdatePartitionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            BatchUpdatePartitionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchUpdatePartitionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            BatchUpdatePartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchUpdatePartitionError {
    fn code(&self) -> Option<&str> {
        BatchUpdatePartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchUpdatePartitionError {
    /// Creates a new `BatchUpdatePartitionError`.
    pub fn new(kind: BatchUpdatePartitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchUpdatePartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchUpdatePartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchUpdatePartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchUpdatePartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchUpdatePartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdatePartitionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePartitionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdatePartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdatePartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePartitionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchUpdatePartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchUpdatePartitionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchUpdatePartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchUpdatePartitionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            BatchUpdatePartitionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            BatchUpdatePartitionErrorKind::InternalServiceException(_inner) => Some(_inner),
            BatchUpdatePartitionErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchUpdatePartitionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            BatchUpdatePartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelMLTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelMLTaskRunError {
    /// Kind of error that occurred.
    pub kind: CancelMLTaskRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelMLTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelMLTaskRunErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelMLTaskRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelMLTaskRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            CancelMLTaskRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CancelMLTaskRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CancelMLTaskRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CancelMLTaskRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelMLTaskRunError {
    fn code(&self) -> Option<&str> {
        CancelMLTaskRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelMLTaskRunError {
    /// Creates a new `CancelMLTaskRunError`.
    pub fn new(kind: CancelMLTaskRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelMLTaskRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelMLTaskRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelMLTaskRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelMLTaskRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelMLTaskRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMLTaskRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMLTaskRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMLTaskRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMLTaskRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMLTaskRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelMLTaskRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelMLTaskRunErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for CancelMLTaskRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelMLTaskRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            CancelMLTaskRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            CancelMLTaskRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            CancelMLTaskRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CancelMLTaskRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CheckSchemaVersionValidity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CheckSchemaVersionValidityError {
    /// Kind of error that occurred.
    pub kind: CheckSchemaVersionValidityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CheckSchemaVersionValidity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CheckSchemaVersionValidityErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CheckSchemaVersionValidityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CheckSchemaVersionValidityErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CheckSchemaVersionValidityErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CheckSchemaVersionValidityErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CheckSchemaVersionValidityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CheckSchemaVersionValidityError {
    fn code(&self) -> Option<&str> {
        CheckSchemaVersionValidityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CheckSchemaVersionValidityError {
    /// Creates a new `CheckSchemaVersionValidityError`.
    pub fn new(kind: CheckSchemaVersionValidityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CheckSchemaVersionValidityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CheckSchemaVersionValidityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CheckSchemaVersionValidityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CheckSchemaVersionValidityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CheckSchemaVersionValidityErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckSchemaVersionValidityErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckSchemaVersionValidityErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckSchemaVersionValidityErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckSchemaVersionValidityErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckSchemaVersionValidityErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for CheckSchemaVersionValidityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CheckSchemaVersionValidityErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CheckSchemaVersionValidityErrorKind::InternalServiceException(_inner) => Some(_inner),
            CheckSchemaVersionValidityErrorKind::InvalidInputException(_inner) => Some(_inner),
            CheckSchemaVersionValidityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBlueprint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBlueprintError {
    /// Kind of error that occurred.
    pub kind: CreateBlueprintErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBlueprint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBlueprintErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBlueprintError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBlueprintErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateBlueprintErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateBlueprintErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateBlueprintErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateBlueprintErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreateBlueprintErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBlueprintError {
    fn code(&self) -> Option<&str> {
        CreateBlueprintError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBlueprintError {
    /// Creates a new `CreateBlueprintError`.
    pub fn new(kind: CreateBlueprintErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBlueprintError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBlueprintErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBlueprintError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBlueprintErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBlueprintErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBlueprintErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBlueprintErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBlueprintErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBlueprintErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBlueprintErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBlueprintErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBlueprintErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBlueprintErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBlueprintErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateBlueprintError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBlueprintErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateBlueprintErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateBlueprintErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateBlueprintErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateBlueprintErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateBlueprintErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClassifierError {
    /// Kind of error that occurred.
    pub kind: CreateClassifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClassifierErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClassifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClassifierErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateClassifierErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateClassifierErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateClassifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClassifierError {
    fn code(&self) -> Option<&str> {
        CreateClassifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClassifierError {
    /// Creates a new `CreateClassifierError`.
    pub fn new(kind: CreateClassifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClassifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClassifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClassifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClassifierErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClassifierErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClassifierErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClassifierErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClassifierErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClassifierErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClassifierErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for CreateClassifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClassifierErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateClassifierErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateClassifierErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateClassifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectionError {
    /// Kind of error that occurred.
    pub kind: CreateConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectionErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectionErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectionError {
    fn code(&self) -> Option<&str> {
        CreateConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectionError {
    /// Creates a new `CreateConnectionError`.
    pub fn new(kind: CreateConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectionErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateConnectionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            CreateConnectionErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateConnectionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateConnectionErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCrawlerError {
    /// Kind of error that occurred.
    pub kind: CreateCrawlerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCrawlerErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCrawlerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCrawlerErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateCrawlerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateCrawlerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateCrawlerErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreateCrawlerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCrawlerError {
    fn code(&self) -> Option<&str> {
        CreateCrawlerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCrawlerError {
    /// Creates a new `CreateCrawlerError`.
    pub fn new(kind: CreateCrawlerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCrawlerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCrawlerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCrawlerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCrawlerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCrawlerErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCrawlerErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCrawlerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateCrawlerErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateCrawlerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCrawlerErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCrawlerErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCrawlerErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateCrawlerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCrawlerErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateCrawlerErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateCrawlerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateCrawlerErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateCrawlerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatabaseError {
    /// Kind of error that occurred.
    pub kind: CreateDatabaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatabaseErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatabaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatabaseErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDatabaseErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateDatabaseErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            CreateDatabaseErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateDatabaseErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDatabaseErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateDatabaseErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreateDatabaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatabaseError {
    fn code(&self) -> Option<&str> {
        CreateDatabaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatabaseError {
    /// Creates a new `CreateDatabaseError`.
    pub fn new(kind: CreateDatabaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatabaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatabaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatabaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatabaseErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDatabaseErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatabaseErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatabaseErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatabaseErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatabaseErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatabaseErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatabaseErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatabaseErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatabaseErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatabaseErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatabaseErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatabaseErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDatabaseErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatabaseErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateDatabaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatabaseErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateDatabaseErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateDatabaseErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            CreateDatabaseErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateDatabaseErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDatabaseErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateDatabaseErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateDatabaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDevEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDevEndpointError {
    /// Kind of error that occurred.
    pub kind: CreateDevEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDevEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDevEndpointErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The same unique identifier was associated with two different records.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// <p>A value could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDevEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDevEndpointErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDevEndpointErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDevEndpointErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            CreateDevEndpointErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateDevEndpointErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDevEndpointErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateDevEndpointErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateDevEndpointErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDevEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDevEndpointError {
    fn code(&self) -> Option<&str> {
        CreateDevEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDevEndpointError {
    /// Creates a new `CreateDevEndpointError`.
    pub fn new(kind: CreateDevEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDevEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDevEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDevEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDevEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDevEndpointErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDevEndpointErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDevEndpointErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDevEndpointErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDevEndpointErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDevEndpointErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDevEndpointErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDevEndpointErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDevEndpointErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDevEndpointErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDevEndpointErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDevEndpointErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDevEndpointErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDevEndpointErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDevEndpointErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDevEndpointErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateDevEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDevEndpointErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDevEndpointErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateDevEndpointErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            CreateDevEndpointErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateDevEndpointErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDevEndpointErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateDevEndpointErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateDevEndpointErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDevEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJobError {
    /// Kind of error that occurred.
    pub kind: CreateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJobErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The same unique identifier was associated with two different records.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJobErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::IdempotentParameterMismatchException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJobError {
    fn code(&self) -> Option<&str> {
        CreateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJobError {
    /// Creates a new `CreateJobError`.
    pub fn new(kind: CreateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::AlreadyExistsException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::OperationTimeoutException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJobErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateJobErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateJobErrorKind::IdempotentParameterMismatchException(_inner) => Some(_inner),
            CreateJobErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateJobErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateJobErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMLTransform` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMLTransformError {
    /// Kind of error that occurred.
    pub kind: CreateMLTransformErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMLTransform` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMLTransformErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>The same unique identifier was associated with two different records.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMLTransformError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMLTransformErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateMLTransformErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateMLTransformErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            CreateMLTransformErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateMLTransformErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateMLTransformErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateMLTransformErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateMLTransformErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMLTransformError {
    fn code(&self) -> Option<&str> {
        CreateMLTransformError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMLTransformError {
    /// Creates a new `CreateMLTransformError`.
    pub fn new(kind: CreateMLTransformErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMLTransformError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMLTransformErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMLTransformError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMLTransformErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMLTransformErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMLTransformErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMLTransformErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMLTransformErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMLTransformErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMLTransformErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMLTransformErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMLTransformErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMLTransformErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMLTransformErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMLTransformErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMLTransformErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMLTransformErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMLTransformErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateMLTransformError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMLTransformErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateMLTransformErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateMLTransformErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            CreateMLTransformErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateMLTransformErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateMLTransformErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateMLTransformErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateMLTransformErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePartitionError {
    /// Kind of error that occurred.
    pub kind: CreatePartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePartitionErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePartitionErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreatePartitionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            CreatePartitionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            CreatePartitionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreatePartitionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreatePartitionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreatePartitionErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreatePartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePartitionError {
    fn code(&self) -> Option<&str> {
        CreatePartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePartitionError {
    /// Creates a new `CreatePartitionError`.
    pub fn new(kind: CreatePartitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePartitionErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreatePartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePartitionErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreatePartitionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            CreatePartitionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            CreatePartitionErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreatePartitionErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreatePartitionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreatePartitionErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreatePartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePartitionIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePartitionIndexError {
    /// Kind of error that occurred.
    pub kind: CreatePartitionIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePartitionIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePartitionIndexErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePartitionIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePartitionIndexErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreatePartitionIndexErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            CreatePartitionIndexErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            CreatePartitionIndexErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreatePartitionIndexErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreatePartitionIndexErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreatePartitionIndexErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreatePartitionIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePartitionIndexError {
    fn code(&self) -> Option<&str> {
        CreatePartitionIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePartitionIndexError {
    /// Creates a new `CreatePartitionIndexError`.
    pub fn new(kind: CreatePartitionIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePartitionIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePartitionIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePartitionIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePartitionIndexErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePartitionIndexErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionIndexErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionIndexErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionIndexErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionIndexErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionIndexErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionIndexErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionIndexErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionIndexErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionIndexErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionIndexErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionIndexErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartitionIndexErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartitionIndexErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreatePartitionIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePartitionIndexErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreatePartitionIndexErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            CreatePartitionIndexErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            CreatePartitionIndexErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreatePartitionIndexErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreatePartitionIndexErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreatePartitionIndexErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreatePartitionIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRegistryError {
    /// Kind of error that occurred.
    pub kind: CreateRegistryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRegistryErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRegistryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRegistryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreateRegistryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRegistryError {
    fn code(&self) -> Option<&str> {
        CreateRegistryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRegistryError {
    /// Creates a new `CreateRegistryError`.
    pub fn new(kind: CreateRegistryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRegistryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRegistryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRegistryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRegistryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRegistryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegistryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegistryErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegistryErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegistryErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegistryErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegistryErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegistryErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegistryErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegistryErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRegistryErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRegistryErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateRegistryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRegistryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRegistryErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateRegistryErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateRegistryErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateRegistryErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateRegistryErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateRegistryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSchemaError {
    /// Kind of error that occurred.
    pub kind: CreateSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSchemaErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreateSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSchemaError {
    fn code(&self) -> Option<&str> {
        CreateSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSchemaError {
    /// Creates a new `CreateSchemaError`.
    pub fn new(kind: CreateSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSchemaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateSchemaErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::AlreadyExistsException(_))
    }
    /// Returns `true` if the error kind is `CreateSchemaErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSchemaErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSchemaErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSchemaErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSchemaErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSchemaErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSchemaErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateSchemaErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateSchemaErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSchemaErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSchemaErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateSchemaErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateSchemaErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            CreateSchemaErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateSchemaErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateSchemaErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateScript` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateScriptError {
    /// Kind of error that occurred.
    pub kind: CreateScriptErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateScript` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateScriptErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateScriptError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateScriptErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateScriptErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateScriptErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateScriptErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateScriptError {
    fn code(&self) -> Option<&str> {
        CreateScriptError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateScriptError {
    /// Creates a new `CreateScriptError`.
    pub fn new(kind: CreateScriptErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateScriptError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateScriptErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateScriptError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateScriptErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateScriptErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScriptErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScriptErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateScriptErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateScriptErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateScriptErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for CreateScriptError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateScriptErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateScriptErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateScriptErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateScriptErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSecurityConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateSecurityConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSecurityConfigurationErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSecurityConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSecurityConfigurationErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateSecurityConfigurationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateSecurityConfigurationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateSecurityConfigurationErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            CreateSecurityConfigurationErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateSecurityConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSecurityConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateSecurityConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSecurityConfigurationError {
    /// Creates a new `CreateSecurityConfigurationError`.
    pub fn new(kind: CreateSecurityConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSecurityConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSecurityConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSecurityConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSecurityConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSecurityConfigurationErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityConfigurationErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityConfigurationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityConfigurationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityConfigurationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityConfigurationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityConfigurationErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityConfigurationErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityConfigurationErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityConfigurationErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateSecurityConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSecurityConfigurationErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateSecurityConfigurationErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateSecurityConfigurationErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateSecurityConfigurationErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateSecurityConfigurationErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateSecurityConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTableError {
    /// Kind of error that occurred.
    pub kind: CreateTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTableErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource was not ready for a transaction.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTableErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreateTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTableError {
    fn code(&self) -> Option<&str> {
        CreateTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTableError {
    /// Creates a new `CreateTableError`.
    pub fn new(kind: CreateTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(&self.kind, CreateTableErrorKind::AlreadyExistsException(_))
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTableErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateTableErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(&self.kind, CreateTableErrorKind::GlueEncryptionException(_))
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTableErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateTableErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTableErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTableErrorKind::ResourceNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTableErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTableErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTableErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateTableErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateTableErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            CreateTableErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            CreateTableErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateTableErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateTableErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateTableErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            CreateTableErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTriggerError {
    /// Kind of error that occurred.
    pub kind: CreateTriggerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTriggerErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The same unique identifier was associated with two different records.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTriggerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTriggerErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateTriggerErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateTriggerErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            CreateTriggerErrorKind::IdempotentParameterMismatchException(_inner) => _inner.fmt(f),
            CreateTriggerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateTriggerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateTriggerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateTriggerErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreateTriggerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTriggerError {
    fn code(&self) -> Option<&str> {
        CreateTriggerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTriggerError {
    /// Creates a new `CreateTriggerError`.
    pub fn new(kind: CreateTriggerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTriggerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTriggerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTriggerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTriggerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTriggerErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTriggerErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTriggerErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTriggerErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTriggerErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTriggerErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTriggerErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTriggerErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTriggerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTriggerErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTriggerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateTriggerErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateTriggerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTriggerErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTriggerErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTriggerErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateTriggerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTriggerErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateTriggerErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateTriggerErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            CreateTriggerErrorKind::IdempotentParameterMismatchException(_inner) => Some(_inner),
            CreateTriggerErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateTriggerErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateTriggerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateTriggerErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateTriggerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUserDefinedFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserDefinedFunctionError {
    /// Kind of error that occurred.
    pub kind: CreateUserDefinedFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUserDefinedFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserDefinedFunctionErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserDefinedFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserDefinedFunctionErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateUserDefinedFunctionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            CreateUserDefinedFunctionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            CreateUserDefinedFunctionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateUserDefinedFunctionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateUserDefinedFunctionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateUserDefinedFunctionErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateUserDefinedFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserDefinedFunctionError {
    fn code(&self) -> Option<&str> {
        CreateUserDefinedFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserDefinedFunctionError {
    /// Creates a new `CreateUserDefinedFunctionError`.
    pub fn new(kind: CreateUserDefinedFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserDefinedFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserDefinedFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserDefinedFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserDefinedFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserDefinedFunctionErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserDefinedFunctionErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserDefinedFunctionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserDefinedFunctionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserDefinedFunctionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserDefinedFunctionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserDefinedFunctionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserDefinedFunctionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserDefinedFunctionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserDefinedFunctionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserDefinedFunctionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserDefinedFunctionErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserDefinedFunctionErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserDefinedFunctionErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateUserDefinedFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserDefinedFunctionErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateUserDefinedFunctionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            CreateUserDefinedFunctionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            CreateUserDefinedFunctionErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateUserDefinedFunctionErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateUserDefinedFunctionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateUserDefinedFunctionErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateUserDefinedFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkflowError {
    /// Kind of error that occurred.
    pub kind: CreateWorkflowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkflowErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkflowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkflowErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            CreateWorkflowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkflowError {
    fn code(&self) -> Option<&str> {
        CreateWorkflowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWorkflowError {
    /// Creates a new `CreateWorkflowError`.
    pub fn new(kind: CreateWorkflowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkflowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkflowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkflowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkflowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkflowErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkflowErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkflowErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkflowErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkflowErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWorkflowErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkflowErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateWorkflowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkflowErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            CreateWorkflowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBlueprint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBlueprintError {
    /// Kind of error that occurred.
    pub kind: DeleteBlueprintErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBlueprint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBlueprintErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBlueprintError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBlueprintErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteBlueprintErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteBlueprintErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteBlueprintErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBlueprintError {
    fn code(&self) -> Option<&str> {
        DeleteBlueprintError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBlueprintError {
    /// Creates a new `DeleteBlueprintError`.
    pub fn new(kind: DeleteBlueprintErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBlueprintError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBlueprintErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBlueprintError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBlueprintErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBlueprintErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBlueprintErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBlueprintErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBlueprintErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBlueprintErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBlueprintErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteBlueprintError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBlueprintErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteBlueprintErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteBlueprintErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteBlueprintErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClassifierError {
    /// Kind of error that occurred.
    pub kind: DeleteClassifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClassifierErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClassifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClassifierErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteClassifierErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteClassifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClassifierError {
    fn code(&self) -> Option<&str> {
        DeleteClassifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClassifierError {
    /// Creates a new `DeleteClassifierError`.
    pub fn new(kind: DeleteClassifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClassifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClassifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClassifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClassifierErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClassifierErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClassifierErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClassifierErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClassifierErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteClassifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClassifierErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteClassifierErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteClassifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteColumnStatisticsForPartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteColumnStatisticsForPartitionError {
    /// Kind of error that occurred.
    pub kind: DeleteColumnStatisticsForPartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteColumnStatisticsForPartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteColumnStatisticsForPartitionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteColumnStatisticsForPartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteColumnStatisticsForPartitionErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteColumnStatisticsForPartitionErrorKind::GlueEncryptionException(_inner) => {
                _inner.fmt(f)
            }
            DeleteColumnStatisticsForPartitionErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DeleteColumnStatisticsForPartitionErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            DeleteColumnStatisticsForPartitionErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            DeleteColumnStatisticsForPartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteColumnStatisticsForPartitionError {
    fn code(&self) -> Option<&str> {
        DeleteColumnStatisticsForPartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteColumnStatisticsForPartitionError {
    /// Creates a new `DeleteColumnStatisticsForPartitionError`.
    pub fn new(
        kind: DeleteColumnStatisticsForPartitionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteColumnStatisticsForPartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteColumnStatisticsForPartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteColumnStatisticsForPartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteColumnStatisticsForPartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteColumnStatisticsForPartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteColumnStatisticsForPartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteColumnStatisticsForPartitionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteColumnStatisticsForPartitionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteColumnStatisticsForPartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteColumnStatisticsForPartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteColumnStatisticsForPartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteColumnStatisticsForPartitionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteColumnStatisticsForPartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteColumnStatisticsForPartitionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteColumnStatisticsForPartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteColumnStatisticsForPartitionErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteColumnStatisticsForPartitionErrorKind::GlueEncryptionException(_inner) => {
                Some(_inner)
            }
            DeleteColumnStatisticsForPartitionErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DeleteColumnStatisticsForPartitionErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            DeleteColumnStatisticsForPartitionErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            DeleteColumnStatisticsForPartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteColumnStatisticsForTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteColumnStatisticsForTableError {
    /// Kind of error that occurred.
    pub kind: DeleteColumnStatisticsForTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteColumnStatisticsForTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteColumnStatisticsForTableErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteColumnStatisticsForTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteColumnStatisticsForTableErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteColumnStatisticsForTableErrorKind::GlueEncryptionException(_inner) => {
                _inner.fmt(f)
            }
            DeleteColumnStatisticsForTableErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DeleteColumnStatisticsForTableErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteColumnStatisticsForTableErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            DeleteColumnStatisticsForTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteColumnStatisticsForTableError {
    fn code(&self) -> Option<&str> {
        DeleteColumnStatisticsForTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteColumnStatisticsForTableError {
    /// Creates a new `DeleteColumnStatisticsForTableError`.
    pub fn new(
        kind: DeleteColumnStatisticsForTableErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteColumnStatisticsForTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteColumnStatisticsForTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteColumnStatisticsForTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteColumnStatisticsForTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteColumnStatisticsForTableErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteColumnStatisticsForTableErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteColumnStatisticsForTableErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteColumnStatisticsForTableErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteColumnStatisticsForTableErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteColumnStatisticsForTableErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteColumnStatisticsForTableErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteColumnStatisticsForTableErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteColumnStatisticsForTableErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteColumnStatisticsForTableErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteColumnStatisticsForTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteColumnStatisticsForTableErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteColumnStatisticsForTableErrorKind::GlueEncryptionException(_inner) => {
                Some(_inner)
            }
            DeleteColumnStatisticsForTableErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DeleteColumnStatisticsForTableErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteColumnStatisticsForTableErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            DeleteColumnStatisticsForTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectionError {
    /// Creates a new `DeleteConnectionError`.
    pub fn new(kind: DeleteConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCrawlerError {
    /// Kind of error that occurred.
    pub kind: DeleteCrawlerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCrawlerErrorKind {
    /// <p>The operation cannot be performed because the crawler is already running.</p>
    CrawlerRunningException(crate::error::CrawlerRunningException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>The specified scheduler is transitioning.</p>
    SchedulerTransitioningException(crate::error::SchedulerTransitioningException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCrawlerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCrawlerErrorKind::CrawlerRunningException(_inner) => _inner.fmt(f),
            DeleteCrawlerErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteCrawlerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteCrawlerErrorKind::SchedulerTransitioningException(_inner) => _inner.fmt(f),
            DeleteCrawlerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCrawlerError {
    fn code(&self) -> Option<&str> {
        DeleteCrawlerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCrawlerError {
    /// Creates a new `DeleteCrawlerError`.
    pub fn new(kind: DeleteCrawlerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCrawlerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCrawlerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCrawlerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCrawlerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCrawlerErrorKind::CrawlerRunningException`.
    pub fn is_crawler_running_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCrawlerErrorKind::CrawlerRunningException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCrawlerErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCrawlerErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCrawlerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCrawlerErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCrawlerErrorKind::SchedulerTransitioningException`.
    pub fn is_scheduler_transitioning_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCrawlerErrorKind::SchedulerTransitioningException(_)
        )
    }
}
impl std::error::Error for DeleteCrawlerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCrawlerErrorKind::CrawlerRunningException(_inner) => Some(_inner),
            DeleteCrawlerErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteCrawlerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteCrawlerErrorKind::SchedulerTransitioningException(_inner) => Some(_inner),
            DeleteCrawlerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatabaseError {
    /// Kind of error that occurred.
    pub kind: DeleteDatabaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatabaseErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatabaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatabaseErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteDatabaseErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatabaseErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteDatabaseErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDatabaseErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteDatabaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatabaseError {
    fn code(&self) -> Option<&str> {
        DeleteDatabaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatabaseError {
    /// Creates a new `DeleteDatabaseError`.
    pub fn new(kind: DeleteDatabaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatabaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatabaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatabaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatabaseErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDatabaseErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatabaseErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatabaseErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatabaseErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatabaseErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatabaseErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatabaseErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatabaseErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDatabaseErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatabaseErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteDatabaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatabaseErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteDatabaseErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteDatabaseErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteDatabaseErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDatabaseErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteDatabaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDevEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDevEndpointError {
    /// Kind of error that occurred.
    pub kind: DeleteDevEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDevEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDevEndpointErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDevEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDevEndpointErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteDevEndpointErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteDevEndpointErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDevEndpointErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteDevEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDevEndpointError {
    fn code(&self) -> Option<&str> {
        DeleteDevEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDevEndpointError {
    /// Creates a new `DeleteDevEndpointError`.
    pub fn new(kind: DeleteDevEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDevEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDevEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDevEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDevEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDevEndpointErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDevEndpointErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDevEndpointErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDevEndpointErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDevEndpointErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDevEndpointErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDevEndpointErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDevEndpointErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteDevEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDevEndpointErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteDevEndpointErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteDevEndpointErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDevEndpointErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteDevEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteJobError {
    /// Kind of error that occurred.
    pub kind: DeleteJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteJobErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteJobErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteJobError {
    fn code(&self) -> Option<&str> {
        DeleteJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteJobError {
    /// Creates a new `DeleteJobError`.
    pub fn new(kind: DeleteJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobErrorKind::OperationTimeoutException(_))
    }
}
impl std::error::Error for DeleteJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteJobErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteJobErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMLTransform` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMLTransformError {
    /// Kind of error that occurred.
    pub kind: DeleteMLTransformErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMLTransform` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMLTransformErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMLTransformError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMLTransformErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteMLTransformErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteMLTransformErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteMLTransformErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteMLTransformErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMLTransformError {
    fn code(&self) -> Option<&str> {
        DeleteMLTransformError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMLTransformError {
    /// Creates a new `DeleteMLTransformError`.
    pub fn new(kind: DeleteMLTransformErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMLTransformError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMLTransformErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMLTransformError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMLTransformErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMLTransformErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMLTransformErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMLTransformErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMLTransformErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMLTransformErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMLTransformErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMLTransformErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMLTransformErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteMLTransformError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMLTransformErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteMLTransformErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteMLTransformErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteMLTransformErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteMLTransformErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePartitionError {
    /// Kind of error that occurred.
    pub kind: DeletePartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePartitionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePartitionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeletePartitionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeletePartitionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeletePartitionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeletePartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePartitionError {
    fn code(&self) -> Option<&str> {
        DeletePartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePartitionError {
    /// Creates a new `DeletePartitionError`.
    pub fn new(kind: DeletePartitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartitionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartitionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeletePartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePartitionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeletePartitionErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeletePartitionErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeletePartitionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeletePartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePartitionIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePartitionIndexError {
    /// Kind of error that occurred.
    pub kind: DeletePartitionIndexErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePartitionIndex` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePartitionIndexErrorKind {
    /// <p>The <code>CreatePartitions</code> API was called on a table that has indexes enabled. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePartitionIndexError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePartitionIndexErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePartitionIndexErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeletePartitionIndexErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            DeletePartitionIndexErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeletePartitionIndexErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeletePartitionIndexErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeletePartitionIndexErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePartitionIndexError {
    fn code(&self) -> Option<&str> {
        DeletePartitionIndexError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePartitionIndexError {
    /// Creates a new `DeletePartitionIndexError`.
    pub fn new(kind: DeletePartitionIndexErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePartitionIndexError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePartitionIndexErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePartitionIndexError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePartitionIndexErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePartitionIndexErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartitionIndexErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePartitionIndexErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartitionIndexErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePartitionIndexErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartitionIndexErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePartitionIndexErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartitionIndexErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePartitionIndexErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartitionIndexErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePartitionIndexErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartitionIndexErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeletePartitionIndexError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePartitionIndexErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePartitionIndexErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeletePartitionIndexErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            DeletePartitionIndexErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeletePartitionIndexErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeletePartitionIndexErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeletePartitionIndexErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRegistryError {
    /// Kind of error that occurred.
    pub kind: DeleteRegistryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRegistryErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRegistryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRegistryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRegistryErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteRegistryErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteRegistryErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteRegistryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRegistryError {
    fn code(&self) -> Option<&str> {
        DeleteRegistryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRegistryError {
    /// Creates a new `DeleteRegistryError`.
    pub fn new(kind: DeleteRegistryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRegistryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRegistryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRegistryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRegistryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRegistryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegistryErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegistryErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegistryErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DeleteRegistryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRegistryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRegistryErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteRegistryErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteRegistryErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteRegistryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyErrorKind {
    /// <p>A specified condition was not satisfied.</p>
    ConditionCheckFailureException(crate::error::ConditionCheckFailureException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyErrorKind::ConditionCheckFailureException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyError {
    /// Creates a new `DeleteResourcePolicyError`.
    pub fn new(kind: DeleteResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ConditionCheckFailureException`.
    pub fn is_condition_check_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ConditionCheckFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyErrorKind::ConditionCheckFailureException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSchemaError {
    /// Kind of error that occurred.
    pub kind: DeleteSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSchemaErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSchemaError {
    fn code(&self) -> Option<&str> {
        DeleteSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSchemaError {
    /// Creates a new `DeleteSchemaError`.
    pub fn new(kind: DeleteSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSchemaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteSchemaErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSchemaErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSchemaErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteSchemaErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for DeleteSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSchemaVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSchemaVersionsError {
    /// Kind of error that occurred.
    pub kind: DeleteSchemaVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSchemaVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSchemaVersionsErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSchemaVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSchemaVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteSchemaVersionsErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteSchemaVersionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteSchemaVersionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteSchemaVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSchemaVersionsError {
    fn code(&self) -> Option<&str> {
        DeleteSchemaVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSchemaVersionsError {
    /// Creates a new `DeleteSchemaVersionsError`.
    pub fn new(kind: DeleteSchemaVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSchemaVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSchemaVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSchemaVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSchemaVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSchemaVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSchemaVersionsErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaVersionsErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSchemaVersionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaVersionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSchemaVersionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSchemaVersionsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DeleteSchemaVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSchemaVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteSchemaVersionsErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteSchemaVersionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteSchemaVersionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteSchemaVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSecurityConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteSecurityConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSecurityConfigurationErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSecurityConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSecurityConfigurationErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteSecurityConfigurationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteSecurityConfigurationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteSecurityConfigurationErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            DeleteSecurityConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSecurityConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteSecurityConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSecurityConfigurationError {
    /// Creates a new `DeleteSecurityConfigurationError`.
    pub fn new(kind: DeleteSecurityConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSecurityConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSecurityConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSecurityConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSecurityConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSecurityConfigurationErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityConfigurationErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityConfigurationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityConfigurationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityConfigurationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityConfigurationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityConfigurationErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityConfigurationErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteSecurityConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSecurityConfigurationErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteSecurityConfigurationErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteSecurityConfigurationErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteSecurityConfigurationErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteSecurityConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTableError {
    /// Kind of error that occurred.
    pub kind: DeleteTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTableErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource was not ready for a transaction.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTableErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            DeleteTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTableError {
    fn code(&self) -> Option<&str> {
        DeleteTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTableError {
    /// Creates a new `DeleteTableError`.
    pub fn new(kind: DeleteTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTableErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteTableErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTableErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteTableErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTableErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTableErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTableErrorKind::ResourceNotReadyException(_)
        )
    }
}
impl std::error::Error for DeleteTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTableErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteTableErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteTableErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteTableErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteTableErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteTableErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            DeleteTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTableVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTableVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteTableVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTableVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTableVersionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTableVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTableVersionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteTableVersionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteTableVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteTableVersionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteTableVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTableVersionError {
    fn code(&self) -> Option<&str> {
        DeleteTableVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTableVersionError {
    /// Creates a new `DeleteTableVersionError`.
    pub fn new(kind: DeleteTableVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTableVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTableVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTableVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTableVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTableVersionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTableVersionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTableVersionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTableVersionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTableVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTableVersionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTableVersionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTableVersionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteTableVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTableVersionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteTableVersionErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteTableVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteTableVersionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteTableVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTriggerError {
    /// Kind of error that occurred.
    pub kind: DeleteTriggerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTriggerErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTriggerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTriggerErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteTriggerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteTriggerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteTriggerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteTriggerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTriggerError {
    fn code(&self) -> Option<&str> {
        DeleteTriggerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTriggerError {
    /// Creates a new `DeleteTriggerError`.
    pub fn new(kind: DeleteTriggerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTriggerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTriggerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTriggerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTriggerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTriggerErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTriggerErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTriggerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTriggerErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTriggerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteTriggerErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteTriggerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTriggerErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteTriggerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTriggerErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteTriggerErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteTriggerErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteTriggerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteTriggerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserDefinedFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserDefinedFunctionError {
    /// Kind of error that occurred.
    pub kind: DeleteUserDefinedFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserDefinedFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserDefinedFunctionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserDefinedFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserDefinedFunctionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserDefinedFunctionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteUserDefinedFunctionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteUserDefinedFunctionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteUserDefinedFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserDefinedFunctionError {
    fn code(&self) -> Option<&str> {
        DeleteUserDefinedFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserDefinedFunctionError {
    /// Creates a new `DeleteUserDefinedFunctionError`.
    pub fn new(kind: DeleteUserDefinedFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserDefinedFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserDefinedFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserDefinedFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserDefinedFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserDefinedFunctionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserDefinedFunctionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserDefinedFunctionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserDefinedFunctionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserDefinedFunctionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserDefinedFunctionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserDefinedFunctionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserDefinedFunctionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteUserDefinedFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserDefinedFunctionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            DeleteUserDefinedFunctionErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteUserDefinedFunctionErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteUserDefinedFunctionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteUserDefinedFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkflowError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkflowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkflowErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkflowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkflowErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteWorkflowErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteWorkflowErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteWorkflowErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            DeleteWorkflowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkflowError {
    fn code(&self) -> Option<&str> {
        DeleteWorkflowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWorkflowError {
    /// Creates a new `DeleteWorkflowError`.
    pub fn new(kind: DeleteWorkflowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkflowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkflowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkflowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkflowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWorkflowErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkflowErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkflowErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkflowErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkflowErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkflowErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWorkflowErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkflowErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for DeleteWorkflowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkflowErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteWorkflowErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteWorkflowErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteWorkflowErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            DeleteWorkflowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBlueprint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBlueprintError {
    /// Kind of error that occurred.
    pub kind: GetBlueprintErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBlueprint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBlueprintErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBlueprintError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBlueprintErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetBlueprintErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetBlueprintErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetBlueprintErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetBlueprintErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBlueprintError {
    fn code(&self) -> Option<&str> {
        GetBlueprintError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBlueprintError {
    /// Creates a new `GetBlueprintError`.
    pub fn new(kind: GetBlueprintErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBlueprintError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBlueprintErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBlueprintError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBlueprintErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBlueprintErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlueprintErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlueprintErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetBlueprintErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetBlueprintErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetBlueprintError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBlueprintErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetBlueprintErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetBlueprintErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetBlueprintErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetBlueprintErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBlueprintRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBlueprintRunError {
    /// Kind of error that occurred.
    pub kind: GetBlueprintRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBlueprintRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBlueprintRunErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBlueprintRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBlueprintRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetBlueprintRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetBlueprintRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetBlueprintRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBlueprintRunError {
    fn code(&self) -> Option<&str> {
        GetBlueprintRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBlueprintRunError {
    /// Creates a new `GetBlueprintRunError`.
    pub fn new(kind: GetBlueprintRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBlueprintRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBlueprintRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBlueprintRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBlueprintRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBlueprintRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlueprintRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlueprintRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintRunErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetBlueprintRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBlueprintRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetBlueprintRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetBlueprintRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetBlueprintRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBlueprintRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBlueprintRunsError {
    /// Kind of error that occurred.
    pub kind: GetBlueprintRunsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBlueprintRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBlueprintRunsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBlueprintRunsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBlueprintRunsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetBlueprintRunsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetBlueprintRunsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetBlueprintRunsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetBlueprintRunsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBlueprintRunsError {
    fn code(&self) -> Option<&str> {
        GetBlueprintRunsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBlueprintRunsError {
    /// Creates a new `GetBlueprintRunsError`.
    pub fn new(kind: GetBlueprintRunsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBlueprintRunsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBlueprintRunsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBlueprintRunsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBlueprintRunsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBlueprintRunsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintRunsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlueprintRunsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintRunsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlueprintRunsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintRunsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlueprintRunsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintRunsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetBlueprintRunsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBlueprintRunsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetBlueprintRunsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetBlueprintRunsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetBlueprintRunsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetBlueprintRunsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCatalogImportStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCatalogImportStatusError {
    /// Kind of error that occurred.
    pub kind: GetCatalogImportStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCatalogImportStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCatalogImportStatusErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCatalogImportStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCatalogImportStatusErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetCatalogImportStatusErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetCatalogImportStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCatalogImportStatusError {
    fn code(&self) -> Option<&str> {
        GetCatalogImportStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCatalogImportStatusError {
    /// Creates a new `GetCatalogImportStatusError`.
    pub fn new(kind: GetCatalogImportStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCatalogImportStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCatalogImportStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCatalogImportStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCatalogImportStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCatalogImportStatusErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCatalogImportStatusErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCatalogImportStatusErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCatalogImportStatusErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetCatalogImportStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCatalogImportStatusErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetCatalogImportStatusErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetCatalogImportStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetClassifierError {
    /// Kind of error that occurred.
    pub kind: GetClassifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetClassifierErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetClassifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetClassifierErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetClassifierErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetClassifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetClassifierError {
    fn code(&self) -> Option<&str> {
        GetClassifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetClassifierError {
    /// Creates a new `GetClassifierError`.
    pub fn new(kind: GetClassifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetClassifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetClassifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetClassifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetClassifierErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetClassifierErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClassifierErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetClassifierErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClassifierErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetClassifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetClassifierErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetClassifierErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetClassifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetClassifiers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetClassifiersError {
    /// Kind of error that occurred.
    pub kind: GetClassifiersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetClassifiers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetClassifiersErrorKind {
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetClassifiersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetClassifiersErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetClassifiersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetClassifiersError {
    fn code(&self) -> Option<&str> {
        GetClassifiersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetClassifiersError {
    /// Creates a new `GetClassifiersError`.
    pub fn new(kind: GetClassifiersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetClassifiersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetClassifiersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetClassifiersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetClassifiersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetClassifiersErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClassifiersErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetClassifiersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetClassifiersErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetClassifiersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetColumnStatisticsForPartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetColumnStatisticsForPartitionError {
    /// Kind of error that occurred.
    pub kind: GetColumnStatisticsForPartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetColumnStatisticsForPartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetColumnStatisticsForPartitionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetColumnStatisticsForPartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetColumnStatisticsForPartitionErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetColumnStatisticsForPartitionErrorKind::GlueEncryptionException(_inner) => {
                _inner.fmt(f)
            }
            GetColumnStatisticsForPartitionErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            GetColumnStatisticsForPartitionErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetColumnStatisticsForPartitionErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            GetColumnStatisticsForPartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetColumnStatisticsForPartitionError {
    fn code(&self) -> Option<&str> {
        GetColumnStatisticsForPartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetColumnStatisticsForPartitionError {
    /// Creates a new `GetColumnStatisticsForPartitionError`.
    pub fn new(
        kind: GetColumnStatisticsForPartitionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetColumnStatisticsForPartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetColumnStatisticsForPartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetColumnStatisticsForPartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetColumnStatisticsForPartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetColumnStatisticsForPartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetColumnStatisticsForPartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetColumnStatisticsForPartitionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetColumnStatisticsForPartitionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetColumnStatisticsForPartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetColumnStatisticsForPartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetColumnStatisticsForPartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetColumnStatisticsForPartitionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetColumnStatisticsForPartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetColumnStatisticsForPartitionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetColumnStatisticsForPartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetColumnStatisticsForPartitionErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            GetColumnStatisticsForPartitionErrorKind::GlueEncryptionException(_inner) => {
                Some(_inner)
            }
            GetColumnStatisticsForPartitionErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            GetColumnStatisticsForPartitionErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetColumnStatisticsForPartitionErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            GetColumnStatisticsForPartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetColumnStatisticsForTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetColumnStatisticsForTableError {
    /// Kind of error that occurred.
    pub kind: GetColumnStatisticsForTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetColumnStatisticsForTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetColumnStatisticsForTableErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetColumnStatisticsForTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetColumnStatisticsForTableErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetColumnStatisticsForTableErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetColumnStatisticsForTableErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetColumnStatisticsForTableErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetColumnStatisticsForTableErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            GetColumnStatisticsForTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetColumnStatisticsForTableError {
    fn code(&self) -> Option<&str> {
        GetColumnStatisticsForTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetColumnStatisticsForTableError {
    /// Creates a new `GetColumnStatisticsForTableError`.
    pub fn new(kind: GetColumnStatisticsForTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetColumnStatisticsForTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetColumnStatisticsForTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetColumnStatisticsForTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetColumnStatisticsForTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetColumnStatisticsForTableErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetColumnStatisticsForTableErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetColumnStatisticsForTableErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetColumnStatisticsForTableErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetColumnStatisticsForTableErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetColumnStatisticsForTableErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetColumnStatisticsForTableErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetColumnStatisticsForTableErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetColumnStatisticsForTableErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetColumnStatisticsForTableErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetColumnStatisticsForTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetColumnStatisticsForTableErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetColumnStatisticsForTableErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetColumnStatisticsForTableErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetColumnStatisticsForTableErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetColumnStatisticsForTableErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetColumnStatisticsForTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConnectionError {
    /// Kind of error that occurred.
    pub kind: GetConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConnectionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConnectionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetConnectionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetConnectionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetConnectionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConnectionError {
    fn code(&self) -> Option<&str> {
        GetConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConnectionError {
    /// Creates a new `GetConnectionError`.
    pub fn new(kind: GetConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConnectionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetConnectionErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetConnectionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConnectionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetConnectionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetConnectionErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetConnectionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetConnectionsError {
    /// Kind of error that occurred.
    pub kind: GetConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetConnectionsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetConnectionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetConnectionsErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetConnectionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetConnectionsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetConnectionsError {
    fn code(&self) -> Option<&str> {
        GetConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetConnectionsError {
    /// Creates a new `GetConnectionsError`.
    pub fn new(kind: GetConnectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetConnectionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectionsErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionsErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetConnectionsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetConnectionsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetConnectionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetConnectionsErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetConnectionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetConnectionsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCrawlerError {
    /// Kind of error that occurred.
    pub kind: GetCrawlerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCrawlerErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCrawlerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCrawlerErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetCrawlerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetCrawlerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCrawlerError {
    fn code(&self) -> Option<&str> {
        GetCrawlerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCrawlerError {
    /// Creates a new `GetCrawlerError`.
    pub fn new(kind: GetCrawlerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCrawlerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCrawlerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCrawlerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCrawlerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCrawlerErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetCrawlerErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetCrawlerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCrawlerErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetCrawlerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCrawlerErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetCrawlerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetCrawlerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCrawlerMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCrawlerMetricsError {
    /// Kind of error that occurred.
    pub kind: GetCrawlerMetricsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCrawlerMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCrawlerMetricsErrorKind {
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCrawlerMetricsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCrawlerMetricsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetCrawlerMetricsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCrawlerMetricsError {
    fn code(&self) -> Option<&str> {
        GetCrawlerMetricsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCrawlerMetricsError {
    /// Creates a new `GetCrawlerMetricsError`.
    pub fn new(kind: GetCrawlerMetricsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCrawlerMetricsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCrawlerMetricsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCrawlerMetricsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCrawlerMetricsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCrawlerMetricsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCrawlerMetricsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetCrawlerMetricsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCrawlerMetricsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetCrawlerMetricsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCrawlers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCrawlersError {
    /// Kind of error that occurred.
    pub kind: GetCrawlersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCrawlers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCrawlersErrorKind {
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCrawlersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCrawlersErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetCrawlersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCrawlersError {
    fn code(&self) -> Option<&str> {
        GetCrawlersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCrawlersError {
    /// Creates a new `GetCrawlersError`.
    pub fn new(kind: GetCrawlersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCrawlersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCrawlersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCrawlersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCrawlersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCrawlersErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCrawlersErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetCrawlersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCrawlersErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetCrawlersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDatabaseError {
    /// Kind of error that occurred.
    pub kind: GetDatabaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDatabaseErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDatabaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDatabaseErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetDatabaseErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetDatabaseErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetDatabaseErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDatabaseErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetDatabaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDatabaseError {
    fn code(&self) -> Option<&str> {
        GetDatabaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDatabaseError {
    /// Creates a new `GetDatabaseError`.
    pub fn new(kind: GetDatabaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDatabaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDatabaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDatabaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDatabaseErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDatabaseErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDatabaseErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDatabaseErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(&self.kind, GetDatabaseErrorKind::GlueEncryptionException(_))
    }
    /// Returns `true` if the error kind is `GetDatabaseErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatabaseErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDatabaseErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetDatabaseErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetDatabaseErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatabaseErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetDatabaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDatabaseErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetDatabaseErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetDatabaseErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetDatabaseErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDatabaseErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetDatabaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDatabases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDatabasesError {
    /// Kind of error that occurred.
    pub kind: GetDatabasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDatabases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDatabasesErrorKind {
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDatabasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDatabasesErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetDatabasesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetDatabasesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDatabasesErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetDatabasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDatabasesError {
    fn code(&self) -> Option<&str> {
        GetDatabasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDatabasesError {
    /// Creates a new `GetDatabasesError`.
    pub fn new(kind: GetDatabasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDatabasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDatabasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDatabasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDatabasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDatabasesErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatabasesErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDatabasesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatabasesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDatabasesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetDatabasesErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetDatabasesErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDatabasesErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetDatabasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDatabasesErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetDatabasesErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetDatabasesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDatabasesErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetDatabasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataCatalogEncryptionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataCatalogEncryptionSettingsError {
    /// Kind of error that occurred.
    pub kind: GetDataCatalogEncryptionSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataCatalogEncryptionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataCatalogEncryptionSettingsErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataCatalogEncryptionSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataCatalogEncryptionSettingsErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            GetDataCatalogEncryptionSettingsErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetDataCatalogEncryptionSettingsErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            GetDataCatalogEncryptionSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataCatalogEncryptionSettingsError {
    fn code(&self) -> Option<&str> {
        GetDataCatalogEncryptionSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataCatalogEncryptionSettingsError {
    /// Creates a new `GetDataCatalogEncryptionSettingsError`.
    pub fn new(
        kind: GetDataCatalogEncryptionSettingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataCatalogEncryptionSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataCatalogEncryptionSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataCatalogEncryptionSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataCatalogEncryptionSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDataCatalogEncryptionSettingsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataCatalogEncryptionSettingsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataCatalogEncryptionSettingsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataCatalogEncryptionSettingsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataCatalogEncryptionSettingsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataCatalogEncryptionSettingsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetDataCatalogEncryptionSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataCatalogEncryptionSettingsErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            GetDataCatalogEncryptionSettingsErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            GetDataCatalogEncryptionSettingsErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            GetDataCatalogEncryptionSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataflowGraph` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataflowGraphError {
    /// Kind of error that occurred.
    pub kind: GetDataflowGraphErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataflowGraph` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataflowGraphErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataflowGraphError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataflowGraphErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetDataflowGraphErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDataflowGraphErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetDataflowGraphErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataflowGraphError {
    fn code(&self) -> Option<&str> {
        GetDataflowGraphError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataflowGraphError {
    /// Creates a new `GetDataflowGraphError`.
    pub fn new(kind: GetDataflowGraphErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataflowGraphError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataflowGraphErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataflowGraphError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataflowGraphErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDataflowGraphErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataflowGraphErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataflowGraphErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataflowGraphErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataflowGraphErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataflowGraphErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetDataflowGraphError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataflowGraphErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetDataflowGraphErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDataflowGraphErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetDataflowGraphErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDevEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDevEndpointError {
    /// Kind of error that occurred.
    pub kind: GetDevEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDevEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDevEndpointErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDevEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDevEndpointErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetDevEndpointErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetDevEndpointErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDevEndpointErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetDevEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDevEndpointError {
    fn code(&self) -> Option<&str> {
        GetDevEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDevEndpointError {
    /// Creates a new `GetDevEndpointError`.
    pub fn new(kind: GetDevEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDevEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDevEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDevEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDevEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDevEndpointErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevEndpointErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDevEndpointErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevEndpointErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDevEndpointErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevEndpointErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDevEndpointErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevEndpointErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetDevEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDevEndpointErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetDevEndpointErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetDevEndpointErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDevEndpointErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetDevEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDevEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDevEndpointsError {
    /// Kind of error that occurred.
    pub kind: GetDevEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDevEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDevEndpointsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDevEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDevEndpointsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetDevEndpointsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetDevEndpointsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDevEndpointsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetDevEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDevEndpointsError {
    fn code(&self) -> Option<&str> {
        GetDevEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDevEndpointsError {
    /// Creates a new `GetDevEndpointsError`.
    pub fn new(kind: GetDevEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDevEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDevEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDevEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDevEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDevEndpointsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevEndpointsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDevEndpointsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevEndpointsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDevEndpointsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevEndpointsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDevEndpointsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDevEndpointsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetDevEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDevEndpointsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetDevEndpointsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetDevEndpointsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDevEndpointsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetDevEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobError {
    /// Kind of error that occurred.
    pub kind: GetJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetJobErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetJobErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobError {
    fn code(&self) -> Option<&str> {
        GetJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobError {
    /// Creates a new `GetJobError`.
    pub fn new(kind: GetJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::OperationTimeoutException(_))
    }
}
impl std::error::Error for GetJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetJobErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetJobErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJobBookmark` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobBookmarkError {
    /// Kind of error that occurred.
    pub kind: GetJobBookmarkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJobBookmark` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobBookmarkErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A value could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobBookmarkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobBookmarkErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetJobBookmarkErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetJobBookmarkErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetJobBookmarkErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetJobBookmarkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetJobBookmarkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobBookmarkError {
    fn code(&self) -> Option<&str> {
        GetJobBookmarkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobBookmarkError {
    /// Creates a new `GetJobBookmarkError`.
    pub fn new(kind: GetJobBookmarkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobBookmarkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobBookmarkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobBookmarkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobBookmarkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobBookmarkErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobBookmarkErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobBookmarkErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobBookmarkErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobBookmarkErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobBookmarkErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobBookmarkErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobBookmarkErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobBookmarkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetJobBookmarkErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetJobBookmarkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobBookmarkErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetJobBookmarkErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetJobBookmarkErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetJobBookmarkErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetJobBookmarkErrorKind::ValidationException(_inner) => Some(_inner),
            GetJobBookmarkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJobRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobRunError {
    /// Kind of error that occurred.
    pub kind: GetJobRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJobRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobRunErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetJobRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetJobRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetJobRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetJobRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobRunError {
    fn code(&self) -> Option<&str> {
        GetJobRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobRunError {
    /// Creates a new `GetJobRunError`.
    pub fn new(kind: GetJobRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJobRunErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetJobRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetJobRunErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetJobRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetJobRunErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetJobRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, GetJobRunErrorKind::OperationTimeoutException(_))
    }
}
impl std::error::Error for GetJobRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetJobRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetJobRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetJobRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetJobRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJobRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobRunsError {
    /// Kind of error that occurred.
    pub kind: GetJobRunsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJobRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobRunsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobRunsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobRunsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetJobRunsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetJobRunsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetJobRunsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetJobRunsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobRunsError {
    fn code(&self) -> Option<&str> {
        GetJobRunsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobRunsError {
    /// Creates a new `GetJobRunsError`.
    pub fn new(kind: GetJobRunsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobRunsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobRunsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobRunsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobRunsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobRunsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJobRunsErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetJobRunsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetJobRunsErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetJobRunsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetJobRunsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetJobRunsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobRunsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetJobRunsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobRunsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetJobRunsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetJobRunsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetJobRunsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetJobRunsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobsError {
    /// Kind of error that occurred.
    pub kind: GetJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetJobsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetJobsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetJobsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobsError {
    fn code(&self) -> Option<&str> {
        GetJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobsError {
    /// Creates a new `GetJobsError`.
    pub fn new(kind: GetJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJobsErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetJobsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetJobsErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetJobsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetJobsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetJobsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, GetJobsErrorKind::OperationTimeoutException(_))
    }
}
impl std::error::Error for GetJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetJobsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetJobsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetJobsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMappingError {
    /// Kind of error that occurred.
    pub kind: GetMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMappingErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMappingErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetMappingErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetMappingErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetMappingErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMappingError {
    fn code(&self) -> Option<&str> {
        GetMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMappingError {
    /// Creates a new `GetMappingError`.
    pub fn new(kind: GetMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMappingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMappingErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetMappingErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetMappingErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetMappingErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetMappingErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetMappingErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetMappingErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMappingErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMappingErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetMappingErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetMappingErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetMappingErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMLTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMLTaskRunError {
    /// Kind of error that occurred.
    pub kind: GetMLTaskRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMLTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMLTaskRunErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMLTaskRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMLTaskRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetMLTaskRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetMLTaskRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetMLTaskRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetMLTaskRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMLTaskRunError {
    fn code(&self) -> Option<&str> {
        GetMLTaskRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMLTaskRunError {
    /// Creates a new `GetMLTaskRunError`.
    pub fn new(kind: GetMLTaskRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMLTaskRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMLTaskRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMLTaskRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMLTaskRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMLTaskRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTaskRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMLTaskRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTaskRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMLTaskRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetMLTaskRunErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetMLTaskRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTaskRunErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetMLTaskRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMLTaskRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetMLTaskRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetMLTaskRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetMLTaskRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetMLTaskRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMLTaskRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMLTaskRunsError {
    /// Kind of error that occurred.
    pub kind: GetMLTaskRunsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMLTaskRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMLTaskRunsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMLTaskRunsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMLTaskRunsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetMLTaskRunsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetMLTaskRunsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetMLTaskRunsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetMLTaskRunsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMLTaskRunsError {
    fn code(&self) -> Option<&str> {
        GetMLTaskRunsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMLTaskRunsError {
    /// Creates a new `GetMLTaskRunsError`.
    pub fn new(kind: GetMLTaskRunsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMLTaskRunsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMLTaskRunsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMLTaskRunsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMLTaskRunsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMLTaskRunsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTaskRunsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMLTaskRunsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTaskRunsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMLTaskRunsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetMLTaskRunsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetMLTaskRunsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTaskRunsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetMLTaskRunsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMLTaskRunsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetMLTaskRunsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetMLTaskRunsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetMLTaskRunsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetMLTaskRunsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMLTransform` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMLTransformError {
    /// Kind of error that occurred.
    pub kind: GetMLTransformErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMLTransform` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMLTransformErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMLTransformError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMLTransformErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetMLTransformErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetMLTransformErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetMLTransformErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetMLTransformErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMLTransformError {
    fn code(&self) -> Option<&str> {
        GetMLTransformError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMLTransformError {
    /// Creates a new `GetMLTransformError`.
    pub fn new(kind: GetMLTransformErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMLTransformError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMLTransformErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMLTransformError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMLTransformErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMLTransformErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTransformErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMLTransformErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTransformErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMLTransformErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTransformErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMLTransformErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTransformErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetMLTransformError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMLTransformErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetMLTransformErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetMLTransformErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetMLTransformErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetMLTransformErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMLTransforms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMLTransformsError {
    /// Kind of error that occurred.
    pub kind: GetMLTransformsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMLTransforms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMLTransformsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMLTransformsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMLTransformsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetMLTransformsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetMLTransformsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetMLTransformsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetMLTransformsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMLTransformsError {
    fn code(&self) -> Option<&str> {
        GetMLTransformsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMLTransformsError {
    /// Creates a new `GetMLTransformsError`.
    pub fn new(kind: GetMLTransformsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMLTransformsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMLTransformsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMLTransformsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMLTransformsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMLTransformsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTransformsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMLTransformsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTransformsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMLTransformsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTransformsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMLTransformsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLTransformsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetMLTransformsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMLTransformsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetMLTransformsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetMLTransformsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetMLTransformsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetMLTransformsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPartitionError {
    /// Kind of error that occurred.
    pub kind: GetPartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPartitionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPartitionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetPartitionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetPartitionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetPartitionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetPartitionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetPartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPartitionError {
    fn code(&self) -> Option<&str> {
        GetPartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPartitionError {
    /// Creates a new `GetPartitionError`.
    pub fn new(kind: GetPartitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetPartitionErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetPartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetPartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPartitionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetPartitionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetPartitionErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetPartitionErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetPartitionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetPartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPartitionIndexes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPartitionIndexesError {
    /// Kind of error that occurred.
    pub kind: GetPartitionIndexesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPartitionIndexes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPartitionIndexesErrorKind {
    /// <p>The <code>CreatePartitions</code> API was called on a table that has indexes enabled. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPartitionIndexesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPartitionIndexesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetPartitionIndexesErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetPartitionIndexesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetPartitionIndexesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetPartitionIndexesErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetPartitionIndexesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPartitionIndexesError {
    fn code(&self) -> Option<&str> {
        GetPartitionIndexesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPartitionIndexesError {
    /// Creates a new `GetPartitionIndexesError`.
    pub fn new(kind: GetPartitionIndexesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPartitionIndexesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPartitionIndexesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPartitionIndexesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPartitionIndexesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPartitionIndexesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionIndexesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionIndexesErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionIndexesErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionIndexesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionIndexesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionIndexesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionIndexesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionIndexesErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionIndexesErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetPartitionIndexesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPartitionIndexesErrorKind::ConflictException(_inner) => Some(_inner),
            GetPartitionIndexesErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetPartitionIndexesErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetPartitionIndexesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetPartitionIndexesErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetPartitionIndexesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPartitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPartitionsError {
    /// Kind of error that occurred.
    pub kind: GetPartitionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPartitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPartitionsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>An error that indicates your data is in an invalid state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource was not ready for a transaction.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPartitionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPartitionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetPartitionsErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetPartitionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetPartitionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetPartitionsErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            GetPartitionsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetPartitionsErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            GetPartitionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPartitionsError {
    fn code(&self) -> Option<&str> {
        GetPartitionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPartitionsError {
    /// Creates a new `GetPartitionsError`.
    pub fn new(kind: GetPartitionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPartitionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPartitionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPartitionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPartitionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPartitionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionsErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionsErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetPartitionsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetPartitionsErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, GetPartitionsErrorKind::InvalidStateException(_))
    }
    /// Returns `true` if the error kind is `GetPartitionsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionsErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPartitionsErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPartitionsErrorKind::ResourceNotReadyException(_)
        )
    }
}
impl std::error::Error for GetPartitionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPartitionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetPartitionsErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetPartitionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetPartitionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetPartitionsErrorKind::InvalidStateException(_inner) => Some(_inner),
            GetPartitionsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetPartitionsErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            GetPartitionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPlanError {
    /// Kind of error that occurred.
    pub kind: GetPlanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPlan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPlanErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPlanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPlanErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetPlanErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetPlanErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetPlanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPlanError {
    fn code(&self) -> Option<&str> {
        GetPlanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPlanError {
    /// Creates a new `GetPlanError`.
    pub fn new(kind: GetPlanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPlanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPlanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPlanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPlanErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPlanErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetPlanErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetPlanErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetPlanErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetPlanErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, GetPlanErrorKind::OperationTimeoutException(_))
    }
}
impl std::error::Error for GetPlanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPlanErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetPlanErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetPlanErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetPlanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRegistryError {
    /// Kind of error that occurred.
    pub kind: GetRegistryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRegistryErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRegistryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRegistryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRegistryErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetRegistryErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetRegistryErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetRegistryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRegistryError {
    fn code(&self) -> Option<&str> {
        GetRegistryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRegistryError {
    /// Creates a new `GetRegistryError`.
    pub fn new(kind: GetRegistryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRegistryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRegistryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRegistryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRegistryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRegistryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetRegistryErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetRegistryErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRegistryErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetRegistryErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistryErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegistryErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetRegistryErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for GetRegistryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRegistryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRegistryErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetRegistryErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetRegistryErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRegistryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourcePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourcePoliciesError {
    /// Kind of error that occurred.
    pub kind: GetResourcePoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourcePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourcePoliciesErrorKind {
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourcePoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourcePoliciesErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetResourcePoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourcePoliciesError {
    fn code(&self) -> Option<&str> {
        GetResourcePoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourcePoliciesError {
    /// Creates a new `GetResourcePoliciesError`.
    pub fn new(kind: GetResourcePoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourcePoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourcePoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourcePoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourcePoliciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePoliciesErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePoliciesErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetResourcePoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourcePoliciesErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetResourcePoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: GetResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourcePolicyErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourcePolicyErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourcePolicyError {
    fn code(&self) -> Option<&str> {
        GetResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourcePolicyError {
    /// Creates a new `GetResourcePolicyError`.
    pub fn new(kind: GetResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourcePolicyErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSchemaError {
    /// Kind of error that occurred.
    pub kind: GetSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSchemaErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSchemaErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetSchemaErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetSchemaErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSchemaError {
    fn code(&self) -> Option<&str> {
        GetSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSchemaError {
    /// Creates a new `GetSchemaError`.
    pub fn new(kind: GetSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSchemaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetSchemaErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetSchemaErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSchemaErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetSchemaErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetSchemaErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetSchemaErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetSchemaErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for GetSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSchemaErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetSchemaErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetSchemaErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSchemaByDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSchemaByDefinitionError {
    /// Kind of error that occurred.
    pub kind: GetSchemaByDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSchemaByDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSchemaByDefinitionErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSchemaByDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSchemaByDefinitionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSchemaByDefinitionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetSchemaByDefinitionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetSchemaByDefinitionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetSchemaByDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSchemaByDefinitionError {
    fn code(&self) -> Option<&str> {
        GetSchemaByDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSchemaByDefinitionError {
    /// Creates a new `GetSchemaByDefinitionError`.
    pub fn new(kind: GetSchemaByDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSchemaByDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSchemaByDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSchemaByDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSchemaByDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSchemaByDefinitionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaByDefinitionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSchemaByDefinitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaByDefinitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSchemaByDefinitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaByDefinitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSchemaByDefinitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaByDefinitionErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for GetSchemaByDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSchemaByDefinitionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSchemaByDefinitionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetSchemaByDefinitionErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetSchemaByDefinitionErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetSchemaByDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSchemaVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSchemaVersionError {
    /// Kind of error that occurred.
    pub kind: GetSchemaVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSchemaVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSchemaVersionErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSchemaVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSchemaVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSchemaVersionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetSchemaVersionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetSchemaVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetSchemaVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSchemaVersionError {
    fn code(&self) -> Option<&str> {
        GetSchemaVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSchemaVersionError {
    /// Creates a new `GetSchemaVersionError`.
    pub fn new(kind: GetSchemaVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSchemaVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSchemaVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSchemaVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSchemaVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSchemaVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSchemaVersionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaVersionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSchemaVersionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaVersionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSchemaVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaVersionErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for GetSchemaVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSchemaVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSchemaVersionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetSchemaVersionErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetSchemaVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetSchemaVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSchemaVersionsDiff` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSchemaVersionsDiffError {
    /// Kind of error that occurred.
    pub kind: GetSchemaVersionsDiffErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSchemaVersionsDiff` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSchemaVersionsDiffErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSchemaVersionsDiffError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSchemaVersionsDiffErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSchemaVersionsDiffErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetSchemaVersionsDiffErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetSchemaVersionsDiffErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetSchemaVersionsDiffErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSchemaVersionsDiffError {
    fn code(&self) -> Option<&str> {
        GetSchemaVersionsDiffError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSchemaVersionsDiffError {
    /// Creates a new `GetSchemaVersionsDiffError`.
    pub fn new(kind: GetSchemaVersionsDiffErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSchemaVersionsDiffError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSchemaVersionsDiffErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSchemaVersionsDiffError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSchemaVersionsDiffErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSchemaVersionsDiffErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaVersionsDiffErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSchemaVersionsDiffErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaVersionsDiffErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSchemaVersionsDiffErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaVersionsDiffErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSchemaVersionsDiffErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaVersionsDiffErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for GetSchemaVersionsDiffError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSchemaVersionsDiffErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSchemaVersionsDiffErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetSchemaVersionsDiffErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetSchemaVersionsDiffErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetSchemaVersionsDiffErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSecurityConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetSecurityConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSecurityConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSecurityConfigurationErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSecurityConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSecurityConfigurationErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetSecurityConfigurationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetSecurityConfigurationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetSecurityConfigurationErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetSecurityConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSecurityConfigurationError {
    fn code(&self) -> Option<&str> {
        GetSecurityConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSecurityConfigurationError {
    /// Creates a new `GetSecurityConfigurationError`.
    pub fn new(kind: GetSecurityConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSecurityConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSecurityConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSecurityConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSecurityConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSecurityConfigurationErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSecurityConfigurationErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSecurityConfigurationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSecurityConfigurationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSecurityConfigurationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSecurityConfigurationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSecurityConfigurationErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSecurityConfigurationErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetSecurityConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSecurityConfigurationErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetSecurityConfigurationErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetSecurityConfigurationErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetSecurityConfigurationErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetSecurityConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSecurityConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSecurityConfigurationsError {
    /// Kind of error that occurred.
    pub kind: GetSecurityConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSecurityConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSecurityConfigurationsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSecurityConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSecurityConfigurationsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetSecurityConfigurationsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetSecurityConfigurationsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetSecurityConfigurationsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetSecurityConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSecurityConfigurationsError {
    fn code(&self) -> Option<&str> {
        GetSecurityConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSecurityConfigurationsError {
    /// Creates a new `GetSecurityConfigurationsError`.
    pub fn new(kind: GetSecurityConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSecurityConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSecurityConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSecurityConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSecurityConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSecurityConfigurationsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSecurityConfigurationsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSecurityConfigurationsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSecurityConfigurationsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSecurityConfigurationsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSecurityConfigurationsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSecurityConfigurationsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSecurityConfigurationsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetSecurityConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSecurityConfigurationsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetSecurityConfigurationsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetSecurityConfigurationsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetSecurityConfigurationsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetSecurityConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTableError {
    /// Kind of error that occurred.
    pub kind: GetTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTableErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource was not ready for a transaction.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTableErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetTableErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetTableErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetTableErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetTableErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetTableErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            GetTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTableError {
    fn code(&self) -> Option<&str> {
        GetTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTableError {
    /// Creates a new `GetTableError`.
    pub fn new(kind: GetTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTableErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTableErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetTableErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(&self.kind, GetTableErrorKind::GlueEncryptionException(_))
    }
    /// Returns `true` if the error kind is `GetTableErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetTableErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetTableErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetTableErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetTableErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, GetTableErrorKind::OperationTimeoutException(_))
    }
    /// Returns `true` if the error kind is `GetTableErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(&self.kind, GetTableErrorKind::ResourceNotReadyException(_))
    }
}
impl std::error::Error for GetTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTableErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetTableErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetTableErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetTableErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetTableErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetTableErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            GetTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTablesError {
    /// Kind of error that occurred.
    pub kind: GetTablesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTablesErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTablesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTablesErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetTablesErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetTablesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetTablesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetTablesErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetTablesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTablesError {
    fn code(&self) -> Option<&str> {
        GetTablesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTablesError {
    /// Creates a new `GetTablesError`.
    pub fn new(kind: GetTablesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTablesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTablesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTablesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTablesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTablesErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTablesErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetTablesErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(&self.kind, GetTablesErrorKind::GlueEncryptionException(_))
    }
    /// Returns `true` if the error kind is `GetTablesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetTablesErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetTablesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetTablesErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetTablesErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, GetTablesErrorKind::OperationTimeoutException(_))
    }
}
impl std::error::Error for GetTablesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTablesErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetTablesErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetTablesErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetTablesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetTablesErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetTablesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTableVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTableVersionError {
    /// Kind of error that occurred.
    pub kind: GetTableVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTableVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTableVersionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTableVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTableVersionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetTableVersionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetTableVersionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetTableVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetTableVersionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetTableVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTableVersionError {
    fn code(&self) -> Option<&str> {
        GetTableVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTableVersionError {
    /// Creates a new `GetTableVersionError`.
    pub fn new(kind: GetTableVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTableVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTableVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTableVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTableVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTableVersionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableVersionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTableVersionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableVersionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTableVersionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableVersionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTableVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableVersionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTableVersionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableVersionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetTableVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTableVersionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetTableVersionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetTableVersionErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetTableVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetTableVersionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetTableVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTableVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTableVersionsError {
    /// Kind of error that occurred.
    pub kind: GetTableVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTableVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTableVersionsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTableVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTableVersionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetTableVersionsErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetTableVersionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetTableVersionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetTableVersionsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetTableVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTableVersionsError {
    fn code(&self) -> Option<&str> {
        GetTableVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTableVersionsError {
    /// Creates a new `GetTableVersionsError`.
    pub fn new(kind: GetTableVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTableVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTableVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTableVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTableVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTableVersionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableVersionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTableVersionsErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableVersionsErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTableVersionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableVersionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTableVersionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableVersionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTableVersionsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableVersionsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetTableVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTableVersionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetTableVersionsErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetTableVersionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetTableVersionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetTableVersionsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetTableVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTagsError {
    /// Kind of error that occurred.
    pub kind: GetTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTagsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTagsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTagsError {
    fn code(&self) -> Option<&str> {
        GetTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTagsError {
    /// Creates a new `GetTagsError`.
    pub fn new(kind: GetTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTagsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetTagsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetTagsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::OperationTimeoutException(_))
    }
}
impl std::error::Error for GetTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTagsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetTagsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetTagsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTriggerError {
    /// Kind of error that occurred.
    pub kind: GetTriggerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTriggerErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTriggerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTriggerErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetTriggerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetTriggerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetTriggerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetTriggerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTriggerError {
    fn code(&self) -> Option<&str> {
        GetTriggerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTriggerError {
    /// Creates a new `GetTriggerError`.
    pub fn new(kind: GetTriggerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTriggerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTriggerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTriggerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTriggerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTriggerErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTriggerErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetTriggerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, GetTriggerErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `GetTriggerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetTriggerErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetTriggerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTriggerErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetTriggerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTriggerErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetTriggerErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetTriggerErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetTriggerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetTriggerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTriggersError {
    /// Kind of error that occurred.
    pub kind: GetTriggersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTriggersErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTriggersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTriggersErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetTriggersErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetTriggersErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetTriggersErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetTriggersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTriggersError {
    fn code(&self) -> Option<&str> {
        GetTriggersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTriggersError {
    /// Creates a new `GetTriggersError`.
    pub fn new(kind: GetTriggersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTriggersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTriggersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTriggersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTriggersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTriggersErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTriggersErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetTriggersErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTriggersErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetTriggersErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetTriggersErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetTriggersErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTriggersErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetTriggersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTriggersErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetTriggersErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetTriggersErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetTriggersErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetTriggersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUnfilteredPartitionMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUnfilteredPartitionMetadataError {
    /// Kind of error that occurred.
    pub kind: GetUnfilteredPartitionMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUnfilteredPartitionMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUnfilteredPartitionMetadataErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    #[allow(missing_docs)] // documentation missing in model
    PermissionTypeMismatchException(crate::error::PermissionTypeMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUnfilteredPartitionMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUnfilteredPartitionMetadataErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionMetadataErrorKind::GlueEncryptionException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionMetadataErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionMetadataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetUnfilteredPartitionMetadataErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionMetadataErrorKind::PermissionTypeMismatchException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUnfilteredPartitionMetadataError {
    fn code(&self) -> Option<&str> {
        GetUnfilteredPartitionMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUnfilteredPartitionMetadataError {
    /// Creates a new `GetUnfilteredPartitionMetadataError`.
    pub fn new(
        kind: GetUnfilteredPartitionMetadataErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUnfilteredPartitionMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUnfilteredPartitionMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUnfilteredPartitionMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUnfilteredPartitionMetadataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionMetadataErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionMetadataErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionMetadataErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionMetadataErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionMetadataErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionMetadataErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionMetadataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionMetadataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionMetadataErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionMetadataErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionMetadataErrorKind::PermissionTypeMismatchException`.
    pub fn is_permission_type_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionMetadataErrorKind::PermissionTypeMismatchException(_)
        )
    }
}
impl std::error::Error for GetUnfilteredPartitionMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUnfilteredPartitionMetadataErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredPartitionMetadataErrorKind::GlueEncryptionException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredPartitionMetadataErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredPartitionMetadataErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetUnfilteredPartitionMetadataErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredPartitionMetadataErrorKind::PermissionTypeMismatchException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredPartitionMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUnfilteredPartitionsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUnfilteredPartitionsMetadataError {
    /// Kind of error that occurred.
    pub kind: GetUnfilteredPartitionsMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUnfilteredPartitionsMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUnfilteredPartitionsMetadataErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    #[allow(missing_docs)] // documentation missing in model
    PermissionTypeMismatchException(crate::error::PermissionTypeMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUnfilteredPartitionsMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUnfilteredPartitionsMetadataErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionsMetadataErrorKind::GlueEncryptionException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionsMetadataErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionsMetadataErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionsMetadataErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionsMetadataErrorKind::PermissionTypeMismatchException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredPartitionsMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUnfilteredPartitionsMetadataError {
    fn code(&self) -> Option<&str> {
        GetUnfilteredPartitionsMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUnfilteredPartitionsMetadataError {
    /// Creates a new `GetUnfilteredPartitionsMetadataError`.
    pub fn new(
        kind: GetUnfilteredPartitionsMetadataErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUnfilteredPartitionsMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUnfilteredPartitionsMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUnfilteredPartitionsMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUnfilteredPartitionsMetadataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionsMetadataErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionsMetadataErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionsMetadataErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionsMetadataErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionsMetadataErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionsMetadataErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionsMetadataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionsMetadataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionsMetadataErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionsMetadataErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredPartitionsMetadataErrorKind::PermissionTypeMismatchException`.
    pub fn is_permission_type_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredPartitionsMetadataErrorKind::PermissionTypeMismatchException(_)
        )
    }
}
impl std::error::Error for GetUnfilteredPartitionsMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUnfilteredPartitionsMetadataErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredPartitionsMetadataErrorKind::GlueEncryptionException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredPartitionsMetadataErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredPartitionsMetadataErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetUnfilteredPartitionsMetadataErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredPartitionsMetadataErrorKind::PermissionTypeMismatchException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredPartitionsMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUnfilteredTableMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUnfilteredTableMetadataError {
    /// Kind of error that occurred.
    pub kind: GetUnfilteredTableMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUnfilteredTableMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUnfilteredTableMetadataErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    #[allow(missing_docs)] // documentation missing in model
    PermissionTypeMismatchException(crate::error::PermissionTypeMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUnfilteredTableMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUnfilteredTableMetadataErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetUnfilteredTableMetadataErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetUnfilteredTableMetadataErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetUnfilteredTableMetadataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetUnfilteredTableMetadataErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetUnfilteredTableMetadataErrorKind::PermissionTypeMismatchException(_inner) => {
                _inner.fmt(f)
            }
            GetUnfilteredTableMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUnfilteredTableMetadataError {
    fn code(&self) -> Option<&str> {
        GetUnfilteredTableMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUnfilteredTableMetadataError {
    /// Creates a new `GetUnfilteredTableMetadataError`.
    pub fn new(kind: GetUnfilteredTableMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUnfilteredTableMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUnfilteredTableMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUnfilteredTableMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUnfilteredTableMetadataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUnfilteredTableMetadataErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredTableMetadataErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredTableMetadataErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredTableMetadataErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredTableMetadataErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredTableMetadataErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredTableMetadataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredTableMetadataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredTableMetadataErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredTableMetadataErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUnfilteredTableMetadataErrorKind::PermissionTypeMismatchException`.
    pub fn is_permission_type_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUnfilteredTableMetadataErrorKind::PermissionTypeMismatchException(_)
        )
    }
}
impl std::error::Error for GetUnfilteredTableMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUnfilteredTableMetadataErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetUnfilteredTableMetadataErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetUnfilteredTableMetadataErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetUnfilteredTableMetadataErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetUnfilteredTableMetadataErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetUnfilteredTableMetadataErrorKind::PermissionTypeMismatchException(_inner) => {
                Some(_inner)
            }
            GetUnfilteredTableMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUserDefinedFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserDefinedFunctionError {
    /// Kind of error that occurred.
    pub kind: GetUserDefinedFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUserDefinedFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserDefinedFunctionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserDefinedFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserDefinedFunctionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetUserDefinedFunctionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetUserDefinedFunctionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetUserDefinedFunctionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetUserDefinedFunctionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetUserDefinedFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserDefinedFunctionError {
    fn code(&self) -> Option<&str> {
        GetUserDefinedFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserDefinedFunctionError {
    /// Creates a new `GetUserDefinedFunctionError`.
    pub fn new(kind: GetUserDefinedFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserDefinedFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserDefinedFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserDefinedFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserDefinedFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserDefinedFunctionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserDefinedFunctionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserDefinedFunctionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserDefinedFunctionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserDefinedFunctionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserDefinedFunctionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserDefinedFunctionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserDefinedFunctionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserDefinedFunctionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserDefinedFunctionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetUserDefinedFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserDefinedFunctionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetUserDefinedFunctionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetUserDefinedFunctionErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetUserDefinedFunctionErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetUserDefinedFunctionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetUserDefinedFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUserDefinedFunctions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserDefinedFunctionsError {
    /// Kind of error that occurred.
    pub kind: GetUserDefinedFunctionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUserDefinedFunctions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserDefinedFunctionsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserDefinedFunctionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserDefinedFunctionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetUserDefinedFunctionsErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            GetUserDefinedFunctionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetUserDefinedFunctionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetUserDefinedFunctionsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetUserDefinedFunctionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserDefinedFunctionsError {
    fn code(&self) -> Option<&str> {
        GetUserDefinedFunctionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserDefinedFunctionsError {
    /// Creates a new `GetUserDefinedFunctionsError`.
    pub fn new(kind: GetUserDefinedFunctionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserDefinedFunctionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserDefinedFunctionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserDefinedFunctionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserDefinedFunctionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserDefinedFunctionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserDefinedFunctionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserDefinedFunctionsErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserDefinedFunctionsErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserDefinedFunctionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserDefinedFunctionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserDefinedFunctionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserDefinedFunctionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUserDefinedFunctionsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserDefinedFunctionsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetUserDefinedFunctionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserDefinedFunctionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetUserDefinedFunctionsErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            GetUserDefinedFunctionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetUserDefinedFunctionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetUserDefinedFunctionsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetUserDefinedFunctionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWorkflowError {
    /// Kind of error that occurred.
    pub kind: GetWorkflowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWorkflowErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWorkflowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWorkflowErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetWorkflowErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetWorkflowErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetWorkflowErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetWorkflowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWorkflowError {
    fn code(&self) -> Option<&str> {
        GetWorkflowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWorkflowError {
    /// Creates a new `GetWorkflowError`.
    pub fn new(kind: GetWorkflowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWorkflowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWorkflowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWorkflowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWorkflowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWorkflowErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetWorkflowErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetWorkflowErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetWorkflowErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetWorkflowErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetWorkflowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWorkflowErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetWorkflowErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetWorkflowErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetWorkflowErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetWorkflowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWorkflowRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWorkflowRunError {
    /// Kind of error that occurred.
    pub kind: GetWorkflowRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWorkflowRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWorkflowRunErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWorkflowRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWorkflowRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetWorkflowRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetWorkflowRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetWorkflowRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetWorkflowRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWorkflowRunError {
    fn code(&self) -> Option<&str> {
        GetWorkflowRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWorkflowRunError {
    /// Creates a new `GetWorkflowRunError`.
    pub fn new(kind: GetWorkflowRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWorkflowRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWorkflowRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWorkflowRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWorkflowRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWorkflowRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetWorkflowRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWorkflowRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetWorkflowRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetWorkflowRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetWorkflowRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetWorkflowRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWorkflowRunProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWorkflowRunPropertiesError {
    /// Kind of error that occurred.
    pub kind: GetWorkflowRunPropertiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWorkflowRunProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWorkflowRunPropertiesErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWorkflowRunPropertiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWorkflowRunPropertiesErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetWorkflowRunPropertiesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetWorkflowRunPropertiesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetWorkflowRunPropertiesErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetWorkflowRunPropertiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWorkflowRunPropertiesError {
    fn code(&self) -> Option<&str> {
        GetWorkflowRunPropertiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWorkflowRunPropertiesError {
    /// Creates a new `GetWorkflowRunPropertiesError`.
    pub fn new(kind: GetWorkflowRunPropertiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWorkflowRunPropertiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWorkflowRunPropertiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWorkflowRunPropertiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWorkflowRunPropertiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWorkflowRunPropertiesErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunPropertiesErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowRunPropertiesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunPropertiesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowRunPropertiesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunPropertiesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowRunPropertiesErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunPropertiesErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetWorkflowRunPropertiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWorkflowRunPropertiesErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetWorkflowRunPropertiesErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetWorkflowRunPropertiesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetWorkflowRunPropertiesErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetWorkflowRunPropertiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWorkflowRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWorkflowRunsError {
    /// Kind of error that occurred.
    pub kind: GetWorkflowRunsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWorkflowRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWorkflowRunsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWorkflowRunsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWorkflowRunsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            GetWorkflowRunsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetWorkflowRunsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetWorkflowRunsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            GetWorkflowRunsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWorkflowRunsError {
    fn code(&self) -> Option<&str> {
        GetWorkflowRunsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWorkflowRunsError {
    /// Creates a new `GetWorkflowRunsError`.
    pub fn new(kind: GetWorkflowRunsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWorkflowRunsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWorkflowRunsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWorkflowRunsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWorkflowRunsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetWorkflowRunsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowRunsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowRunsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetWorkflowRunsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkflowRunsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for GetWorkflowRunsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWorkflowRunsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            GetWorkflowRunsErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetWorkflowRunsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetWorkflowRunsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            GetWorkflowRunsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportCatalogToGlue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportCatalogToGlueError {
    /// Kind of error that occurred.
    pub kind: ImportCatalogToGlueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportCatalogToGlue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportCatalogToGlueErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportCatalogToGlueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportCatalogToGlueErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ImportCatalogToGlueErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ImportCatalogToGlueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportCatalogToGlueError {
    fn code(&self) -> Option<&str> {
        ImportCatalogToGlueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportCatalogToGlueError {
    /// Creates a new `ImportCatalogToGlueError`.
    pub fn new(kind: ImportCatalogToGlueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportCatalogToGlueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportCatalogToGlueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportCatalogToGlueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportCatalogToGlueErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportCatalogToGlueErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCatalogToGlueErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCatalogToGlueErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportCatalogToGlueErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ImportCatalogToGlueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportCatalogToGlueErrorKind::InternalServiceException(_inner) => Some(_inner),
            ImportCatalogToGlueErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ImportCatalogToGlueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBlueprints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBlueprintsError {
    /// Kind of error that occurred.
    pub kind: ListBlueprintsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBlueprints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBlueprintsErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBlueprintsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBlueprintsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListBlueprintsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListBlueprintsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ListBlueprintsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBlueprintsError {
    fn code(&self) -> Option<&str> {
        ListBlueprintsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBlueprintsError {
    /// Creates a new `ListBlueprintsError`.
    pub fn new(kind: ListBlueprintsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBlueprintsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBlueprintsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBlueprintsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBlueprintsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBlueprintsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBlueprintsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBlueprintsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBlueprintsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBlueprintsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBlueprintsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ListBlueprintsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBlueprintsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListBlueprintsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListBlueprintsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ListBlueprintsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCrawlers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCrawlersError {
    /// Kind of error that occurred.
    pub kind: ListCrawlersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCrawlers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCrawlersErrorKind {
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCrawlersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCrawlersErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ListCrawlersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCrawlersError {
    fn code(&self) -> Option<&str> {
        ListCrawlersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCrawlersError {
    /// Creates a new `ListCrawlersError`.
    pub fn new(kind: ListCrawlersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCrawlersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCrawlersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCrawlersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCrawlersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCrawlersErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCrawlersErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ListCrawlersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCrawlersErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ListCrawlersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDevEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDevEndpointsError {
    /// Kind of error that occurred.
    pub kind: ListDevEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDevEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDevEndpointsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDevEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDevEndpointsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListDevEndpointsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListDevEndpointsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListDevEndpointsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ListDevEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDevEndpointsError {
    fn code(&self) -> Option<&str> {
        ListDevEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDevEndpointsError {
    /// Creates a new `ListDevEndpointsError`.
    pub fn new(kind: ListDevEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDevEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDevEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDevEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDevEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDevEndpointsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevEndpointsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevEndpointsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevEndpointsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevEndpointsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevEndpointsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDevEndpointsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDevEndpointsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ListDevEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDevEndpointsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListDevEndpointsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListDevEndpointsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListDevEndpointsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ListDevEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsError {
    /// Kind of error that occurred.
    pub kind: ListJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsError {
    fn code(&self) -> Option<&str> {
        ListJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsError {
    /// Creates a new `ListJobsError`.
    pub fn new(kind: ListJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::OperationTimeoutException(_))
    }
}
impl std::error::Error for ListJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListJobsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListJobsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListJobsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ListJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMLTransforms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMLTransformsError {
    /// Kind of error that occurred.
    pub kind: ListMLTransformsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMLTransforms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMLTransformsErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMLTransformsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMLTransformsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListMLTransformsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListMLTransformsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListMLTransformsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ListMLTransformsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMLTransformsError {
    fn code(&self) -> Option<&str> {
        ListMLTransformsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMLTransformsError {
    /// Creates a new `ListMLTransformsError`.
    pub fn new(kind: ListMLTransformsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMLTransformsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMLTransformsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMLTransformsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMLTransformsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMLTransformsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMLTransformsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMLTransformsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMLTransformsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMLTransformsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMLTransformsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMLTransformsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMLTransformsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ListMLTransformsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMLTransformsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListMLTransformsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListMLTransformsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListMLTransformsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ListMLTransformsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRegistries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRegistriesError {
    /// Kind of error that occurred.
    pub kind: ListRegistriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRegistries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRegistriesErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRegistriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRegistriesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRegistriesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListRegistriesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListRegistriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRegistriesError {
    fn code(&self) -> Option<&str> {
        ListRegistriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRegistriesError {
    /// Creates a new `ListRegistriesError`.
    pub fn new(kind: ListRegistriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRegistriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRegistriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRegistriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRegistriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRegistriesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegistriesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRegistriesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegistriesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRegistriesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRegistriesErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for ListRegistriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRegistriesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRegistriesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListRegistriesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListRegistriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSchemasError {
    /// Kind of error that occurred.
    pub kind: ListSchemasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSchemasErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSchemasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSchemasErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSchemasError {
    fn code(&self) -> Option<&str> {
        ListSchemasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSchemasError {
    /// Creates a new `ListSchemasError`.
    pub fn new(kind: ListSchemasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSchemasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSchemasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSchemasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSchemasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSchemasErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListSchemasErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListSchemasErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListSchemasErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListSchemasErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemasErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSchemasErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListSchemasErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for ListSchemasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSchemasErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListSchemasErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListSchemasErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListSchemasErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListSchemasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSchemaVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSchemaVersionsError {
    /// Kind of error that occurred.
    pub kind: ListSchemaVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSchemaVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSchemaVersionsErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSchemaVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSchemaVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListSchemaVersionsErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListSchemaVersionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListSchemaVersionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListSchemaVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSchemaVersionsError {
    fn code(&self) -> Option<&str> {
        ListSchemaVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSchemaVersionsError {
    /// Creates a new `ListSchemaVersionsError`.
    pub fn new(kind: ListSchemaVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSchemaVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSchemaVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSchemaVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSchemaVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSchemaVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSchemaVersionsErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaVersionsErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSchemaVersionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaVersionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSchemaVersionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemaVersionsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for ListSchemaVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSchemaVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListSchemaVersionsErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListSchemaVersionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListSchemaVersionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListSchemaVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTriggersError {
    /// Kind of error that occurred.
    pub kind: ListTriggersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTriggersErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTriggersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTriggersErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ListTriggersErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListTriggersErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListTriggersErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ListTriggersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTriggersError {
    fn code(&self) -> Option<&str> {
        ListTriggersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTriggersError {
    /// Creates a new `ListTriggersError`.
    pub fn new(kind: ListTriggersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTriggersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTriggersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTriggersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTriggersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTriggersErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTriggersErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTriggersErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTriggersErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTriggersErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListTriggersErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListTriggersErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTriggersErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ListTriggersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTriggersErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ListTriggersErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListTriggersErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListTriggersErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ListTriggersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkflows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkflowsError {
    /// Kind of error that occurred.
    pub kind: ListWorkflowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkflows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkflowsErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkflowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkflowsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListWorkflowsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListWorkflowsErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ListWorkflowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkflowsError {
    fn code(&self) -> Option<&str> {
        ListWorkflowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWorkflowsError {
    /// Creates a new `ListWorkflowsError`.
    pub fn new(kind: ListWorkflowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkflowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkflowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkflowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkflowsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListWorkflowsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkflowsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListWorkflowsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListWorkflowsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ListWorkflowsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkflowsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ListWorkflowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkflowsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListWorkflowsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListWorkflowsErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ListWorkflowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDataCatalogEncryptionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDataCatalogEncryptionSettingsError {
    /// Kind of error that occurred.
    pub kind: PutDataCatalogEncryptionSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDataCatalogEncryptionSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDataCatalogEncryptionSettingsErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDataCatalogEncryptionSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDataCatalogEncryptionSettingsErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            PutDataCatalogEncryptionSettingsErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            PutDataCatalogEncryptionSettingsErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            PutDataCatalogEncryptionSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDataCatalogEncryptionSettingsError {
    fn code(&self) -> Option<&str> {
        PutDataCatalogEncryptionSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDataCatalogEncryptionSettingsError {
    /// Creates a new `PutDataCatalogEncryptionSettingsError`.
    pub fn new(
        kind: PutDataCatalogEncryptionSettingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDataCatalogEncryptionSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDataCatalogEncryptionSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDataCatalogEncryptionSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDataCatalogEncryptionSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutDataCatalogEncryptionSettingsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDataCatalogEncryptionSettingsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDataCatalogEncryptionSettingsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDataCatalogEncryptionSettingsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDataCatalogEncryptionSettingsErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDataCatalogEncryptionSettingsErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for PutDataCatalogEncryptionSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDataCatalogEncryptionSettingsErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            PutDataCatalogEncryptionSettingsErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            PutDataCatalogEncryptionSettingsErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            PutDataCatalogEncryptionSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: PutResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourcePolicyErrorKind {
    /// <p>A specified condition was not satisfied.</p>
    ConditionCheckFailureException(crate::error::ConditionCheckFailureException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourcePolicyErrorKind::ConditionCheckFailureException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourcePolicyError {
    fn code(&self) -> Option<&str> {
        PutResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourcePolicyError {
    /// Creates a new `PutResourcePolicyError`.
    pub fn new(kind: PutResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ConditionCheckFailureException`.
    pub fn is_condition_check_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ConditionCheckFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for PutResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourcePolicyErrorKind::ConditionCheckFailureException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::InternalServiceException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutSchemaVersionMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutSchemaVersionMetadataError {
    /// Kind of error that occurred.
    pub kind: PutSchemaVersionMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutSchemaVersionMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutSchemaVersionMetadataErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutSchemaVersionMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutSchemaVersionMetadataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutSchemaVersionMetadataErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            PutSchemaVersionMetadataErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            PutSchemaVersionMetadataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutSchemaVersionMetadataErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutSchemaVersionMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutSchemaVersionMetadataError {
    fn code(&self) -> Option<&str> {
        PutSchemaVersionMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutSchemaVersionMetadataError {
    /// Creates a new `PutSchemaVersionMetadataError`.
    pub fn new(kind: PutSchemaVersionMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutSchemaVersionMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutSchemaVersionMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutSchemaVersionMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutSchemaVersionMetadataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutSchemaVersionMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaVersionMetadataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSchemaVersionMetadataErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaVersionMetadataErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSchemaVersionMetadataErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaVersionMetadataErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSchemaVersionMetadataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaVersionMetadataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSchemaVersionMetadataErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSchemaVersionMetadataErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for PutSchemaVersionMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutSchemaVersionMetadataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutSchemaVersionMetadataErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            PutSchemaVersionMetadataErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            PutSchemaVersionMetadataErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutSchemaVersionMetadataErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            PutSchemaVersionMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutWorkflowRunProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutWorkflowRunPropertiesError {
    /// Kind of error that occurred.
    pub kind: PutWorkflowRunPropertiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutWorkflowRunProperties` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutWorkflowRunPropertiesErrorKind {
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutWorkflowRunPropertiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutWorkflowRunPropertiesErrorKind::AlreadyExistsException(_inner) => _inner.fmt(f),
            PutWorkflowRunPropertiesErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            PutWorkflowRunPropertiesErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            PutWorkflowRunPropertiesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            PutWorkflowRunPropertiesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutWorkflowRunPropertiesErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            PutWorkflowRunPropertiesErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutWorkflowRunPropertiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutWorkflowRunPropertiesError {
    fn code(&self) -> Option<&str> {
        PutWorkflowRunPropertiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutWorkflowRunPropertiesError {
    /// Creates a new `PutWorkflowRunPropertiesError`.
    pub fn new(kind: PutWorkflowRunPropertiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutWorkflowRunPropertiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutWorkflowRunPropertiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutWorkflowRunPropertiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutWorkflowRunPropertiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutWorkflowRunPropertiesErrorKind::AlreadyExistsException`.
    pub fn is_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWorkflowRunPropertiesErrorKind::AlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutWorkflowRunPropertiesErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWorkflowRunPropertiesErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutWorkflowRunPropertiesErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWorkflowRunPropertiesErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutWorkflowRunPropertiesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWorkflowRunPropertiesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutWorkflowRunPropertiesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWorkflowRunPropertiesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `PutWorkflowRunPropertiesErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWorkflowRunPropertiesErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `PutWorkflowRunPropertiesErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutWorkflowRunPropertiesErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for PutWorkflowRunPropertiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutWorkflowRunPropertiesErrorKind::AlreadyExistsException(_inner) => Some(_inner),
            PutWorkflowRunPropertiesErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            PutWorkflowRunPropertiesErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            PutWorkflowRunPropertiesErrorKind::InternalServiceException(_inner) => Some(_inner),
            PutWorkflowRunPropertiesErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutWorkflowRunPropertiesErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            PutWorkflowRunPropertiesErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            PutWorkflowRunPropertiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `QuerySchemaVersionMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct QuerySchemaVersionMetadataError {
    /// Kind of error that occurred.
    pub kind: QuerySchemaVersionMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `QuerySchemaVersionMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum QuerySchemaVersionMetadataErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for QuerySchemaVersionMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            QuerySchemaVersionMetadataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            QuerySchemaVersionMetadataErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            QuerySchemaVersionMetadataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            QuerySchemaVersionMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for QuerySchemaVersionMetadataError {
    fn code(&self) -> Option<&str> {
        QuerySchemaVersionMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl QuerySchemaVersionMetadataError {
    /// Creates a new `QuerySchemaVersionMetadataError`.
    pub fn new(kind: QuerySchemaVersionMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `QuerySchemaVersionMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: QuerySchemaVersionMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `QuerySchemaVersionMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: QuerySchemaVersionMetadataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `QuerySchemaVersionMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            QuerySchemaVersionMetadataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `QuerySchemaVersionMetadataErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            QuerySchemaVersionMetadataErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `QuerySchemaVersionMetadataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            QuerySchemaVersionMetadataErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for QuerySchemaVersionMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            QuerySchemaVersionMetadataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            QuerySchemaVersionMetadataErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            QuerySchemaVersionMetadataErrorKind::InvalidInputException(_inner) => Some(_inner),
            QuerySchemaVersionMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterSchemaVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterSchemaVersionError {
    /// Kind of error that occurred.
    pub kind: RegisterSchemaVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterSchemaVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterSchemaVersionErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterSchemaVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterSchemaVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RegisterSchemaVersionErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            RegisterSchemaVersionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            RegisterSchemaVersionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            RegisterSchemaVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RegisterSchemaVersionErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            RegisterSchemaVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterSchemaVersionError {
    fn code(&self) -> Option<&str> {
        RegisterSchemaVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterSchemaVersionError {
    /// Creates a new `RegisterSchemaVersionError`.
    pub fn new(kind: RegisterSchemaVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterSchemaVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterSchemaVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterSchemaVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterSchemaVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterSchemaVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterSchemaVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterSchemaVersionErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterSchemaVersionErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterSchemaVersionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterSchemaVersionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterSchemaVersionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterSchemaVersionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterSchemaVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterSchemaVersionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterSchemaVersionErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterSchemaVersionErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for RegisterSchemaVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterSchemaVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RegisterSchemaVersionErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            RegisterSchemaVersionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            RegisterSchemaVersionErrorKind::InternalServiceException(_inner) => Some(_inner),
            RegisterSchemaVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            RegisterSchemaVersionErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            RegisterSchemaVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveSchemaVersionMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveSchemaVersionMetadataError {
    /// Kind of error that occurred.
    pub kind: RemoveSchemaVersionMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveSchemaVersionMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveSchemaVersionMetadataErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveSchemaVersionMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveSchemaVersionMetadataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RemoveSchemaVersionMetadataErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            RemoveSchemaVersionMetadataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RemoveSchemaVersionMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveSchemaVersionMetadataError {
    fn code(&self) -> Option<&str> {
        RemoveSchemaVersionMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveSchemaVersionMetadataError {
    /// Creates a new `RemoveSchemaVersionMetadataError`.
    pub fn new(kind: RemoveSchemaVersionMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveSchemaVersionMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveSchemaVersionMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveSchemaVersionMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveSchemaVersionMetadataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveSchemaVersionMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveSchemaVersionMetadataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveSchemaVersionMetadataErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveSchemaVersionMetadataErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveSchemaVersionMetadataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveSchemaVersionMetadataErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for RemoveSchemaVersionMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveSchemaVersionMetadataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RemoveSchemaVersionMetadataErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            RemoveSchemaVersionMetadataErrorKind::InvalidInputException(_inner) => Some(_inner),
            RemoveSchemaVersionMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetJobBookmark` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetJobBookmarkError {
    /// Kind of error that occurred.
    pub kind: ResetJobBookmarkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetJobBookmark` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetJobBookmarkErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetJobBookmarkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetJobBookmarkErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ResetJobBookmarkErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ResetJobBookmarkErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ResetJobBookmarkErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ResetJobBookmarkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetJobBookmarkError {
    fn code(&self) -> Option<&str> {
        ResetJobBookmarkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetJobBookmarkError {
    /// Creates a new `ResetJobBookmarkError`.
    pub fn new(kind: ResetJobBookmarkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetJobBookmarkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetJobBookmarkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetJobBookmarkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetJobBookmarkErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetJobBookmarkErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetJobBookmarkErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetJobBookmarkErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetJobBookmarkErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetJobBookmarkErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetJobBookmarkErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetJobBookmarkErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetJobBookmarkErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ResetJobBookmarkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetJobBookmarkErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ResetJobBookmarkErrorKind::InternalServiceException(_inner) => Some(_inner),
            ResetJobBookmarkErrorKind::InvalidInputException(_inner) => Some(_inner),
            ResetJobBookmarkErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ResetJobBookmarkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResumeWorkflowRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResumeWorkflowRunError {
    /// Kind of error that occurred.
    pub kind: ResumeWorkflowRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResumeWorkflowRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResumeWorkflowRunErrorKind {
    /// <p>Too many jobs are being run concurrently.</p>
    ConcurrentRunsExceededException(crate::error::ConcurrentRunsExceededException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The workflow is in an invalid state to perform a requested operation.</p>
    IllegalWorkflowStateException(crate::error::IllegalWorkflowStateException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResumeWorkflowRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResumeWorkflowRunErrorKind::ConcurrentRunsExceededException(_inner) => _inner.fmt(f),
            ResumeWorkflowRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            ResumeWorkflowRunErrorKind::IllegalWorkflowStateException(_inner) => _inner.fmt(f),
            ResumeWorkflowRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ResumeWorkflowRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ResumeWorkflowRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            ResumeWorkflowRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResumeWorkflowRunError {
    fn code(&self) -> Option<&str> {
        ResumeWorkflowRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResumeWorkflowRunError {
    /// Creates a new `ResumeWorkflowRunError`.
    pub fn new(kind: ResumeWorkflowRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResumeWorkflowRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResumeWorkflowRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResumeWorkflowRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResumeWorkflowRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResumeWorkflowRunErrorKind::ConcurrentRunsExceededException`.
    pub fn is_concurrent_runs_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeWorkflowRunErrorKind::ConcurrentRunsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeWorkflowRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeWorkflowRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeWorkflowRunErrorKind::IllegalWorkflowStateException`.
    pub fn is_illegal_workflow_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeWorkflowRunErrorKind::IllegalWorkflowStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeWorkflowRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeWorkflowRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeWorkflowRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeWorkflowRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeWorkflowRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeWorkflowRunErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for ResumeWorkflowRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResumeWorkflowRunErrorKind::ConcurrentRunsExceededException(_inner) => Some(_inner),
            ResumeWorkflowRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            ResumeWorkflowRunErrorKind::IllegalWorkflowStateException(_inner) => Some(_inner),
            ResumeWorkflowRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            ResumeWorkflowRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            ResumeWorkflowRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            ResumeWorkflowRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchTablesError {
    /// Kind of error that occurred.
    pub kind: SearchTablesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchTablesErrorKind {
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchTablesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchTablesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            SearchTablesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            SearchTablesErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            SearchTablesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchTablesError {
    fn code(&self) -> Option<&str> {
        SearchTablesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchTablesError {
    /// Creates a new `SearchTablesError`.
    pub fn new(kind: SearchTablesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchTablesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchTablesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchTablesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchTablesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SearchTablesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchTablesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchTablesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, SearchTablesErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `SearchTablesErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchTablesErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for SearchTablesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchTablesErrorKind::InternalServiceException(_inner) => Some(_inner),
            SearchTablesErrorKind::InvalidInputException(_inner) => Some(_inner),
            SearchTablesErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            SearchTablesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartBlueprintRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartBlueprintRunError {
    /// Kind of error that occurred.
    pub kind: StartBlueprintRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartBlueprintRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartBlueprintRunErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    IllegalBlueprintStateException(crate::error::IllegalBlueprintStateException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartBlueprintRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartBlueprintRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StartBlueprintRunErrorKind::IllegalBlueprintStateException(_inner) => _inner.fmt(f),
            StartBlueprintRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartBlueprintRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartBlueprintRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StartBlueprintRunErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartBlueprintRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartBlueprintRunError {
    fn code(&self) -> Option<&str> {
        StartBlueprintRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartBlueprintRunError {
    /// Creates a new `StartBlueprintRunError`.
    pub fn new(kind: StartBlueprintRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartBlueprintRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartBlueprintRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartBlueprintRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartBlueprintRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartBlueprintRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBlueprintRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBlueprintRunErrorKind::IllegalBlueprintStateException`.
    pub fn is_illegal_blueprint_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBlueprintRunErrorKind::IllegalBlueprintStateException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBlueprintRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBlueprintRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBlueprintRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBlueprintRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBlueprintRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBlueprintRunErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBlueprintRunErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBlueprintRunErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for StartBlueprintRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartBlueprintRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StartBlueprintRunErrorKind::IllegalBlueprintStateException(_inner) => Some(_inner),
            StartBlueprintRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartBlueprintRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartBlueprintRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StartBlueprintRunErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            StartBlueprintRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartCrawlerError {
    /// Kind of error that occurred.
    pub kind: StartCrawlerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartCrawlerErrorKind {
    /// <p>The operation cannot be performed because the crawler is already running.</p>
    CrawlerRunningException(crate::error::CrawlerRunningException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartCrawlerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartCrawlerErrorKind::CrawlerRunningException(_inner) => _inner.fmt(f),
            StartCrawlerErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StartCrawlerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StartCrawlerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartCrawlerError {
    fn code(&self) -> Option<&str> {
        StartCrawlerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartCrawlerError {
    /// Creates a new `StartCrawlerError`.
    pub fn new(kind: StartCrawlerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartCrawlerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartCrawlerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartCrawlerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartCrawlerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartCrawlerErrorKind::CrawlerRunningException`.
    pub fn is_crawler_running_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCrawlerErrorKind::CrawlerRunningException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCrawlerErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCrawlerErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCrawlerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCrawlerErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for StartCrawlerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartCrawlerErrorKind::CrawlerRunningException(_inner) => Some(_inner),
            StartCrawlerErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StartCrawlerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StartCrawlerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartCrawlerSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartCrawlerScheduleError {
    /// Kind of error that occurred.
    pub kind: StartCrawlerScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartCrawlerSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartCrawlerScheduleErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>There is no applicable schedule.</p>
    NoScheduleException(crate::error::NoScheduleException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>The specified scheduler is already running.</p>
    SchedulerRunningException(crate::error::SchedulerRunningException),
    /// <p>The specified scheduler is transitioning.</p>
    SchedulerTransitioningException(crate::error::SchedulerTransitioningException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartCrawlerScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartCrawlerScheduleErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StartCrawlerScheduleErrorKind::NoScheduleException(_inner) => _inner.fmt(f),
            StartCrawlerScheduleErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StartCrawlerScheduleErrorKind::SchedulerRunningException(_inner) => _inner.fmt(f),
            StartCrawlerScheduleErrorKind::SchedulerTransitioningException(_inner) => _inner.fmt(f),
            StartCrawlerScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartCrawlerScheduleError {
    fn code(&self) -> Option<&str> {
        StartCrawlerScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartCrawlerScheduleError {
    /// Creates a new `StartCrawlerScheduleError`.
    pub fn new(kind: StartCrawlerScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartCrawlerScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartCrawlerScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartCrawlerScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartCrawlerScheduleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartCrawlerScheduleErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCrawlerScheduleErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCrawlerScheduleErrorKind::NoScheduleException`.
    pub fn is_no_schedule_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCrawlerScheduleErrorKind::NoScheduleException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCrawlerScheduleErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCrawlerScheduleErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCrawlerScheduleErrorKind::SchedulerRunningException`.
    pub fn is_scheduler_running_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCrawlerScheduleErrorKind::SchedulerRunningException(_)
        )
    }
    /// Returns `true` if the error kind is `StartCrawlerScheduleErrorKind::SchedulerTransitioningException`.
    pub fn is_scheduler_transitioning_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartCrawlerScheduleErrorKind::SchedulerTransitioningException(_)
        )
    }
}
impl std::error::Error for StartCrawlerScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartCrawlerScheduleErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StartCrawlerScheduleErrorKind::NoScheduleException(_inner) => Some(_inner),
            StartCrawlerScheduleErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StartCrawlerScheduleErrorKind::SchedulerRunningException(_inner) => Some(_inner),
            StartCrawlerScheduleErrorKind::SchedulerTransitioningException(_inner) => Some(_inner),
            StartCrawlerScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartExportLabelsTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartExportLabelsTaskRunError {
    /// Kind of error that occurred.
    pub kind: StartExportLabelsTaskRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartExportLabelsTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartExportLabelsTaskRunErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartExportLabelsTaskRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartExportLabelsTaskRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StartExportLabelsTaskRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartExportLabelsTaskRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartExportLabelsTaskRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StartExportLabelsTaskRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartExportLabelsTaskRunError {
    fn code(&self) -> Option<&str> {
        StartExportLabelsTaskRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartExportLabelsTaskRunError {
    /// Creates a new `StartExportLabelsTaskRunError`.
    pub fn new(kind: StartExportLabelsTaskRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartExportLabelsTaskRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartExportLabelsTaskRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartExportLabelsTaskRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartExportLabelsTaskRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartExportLabelsTaskRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExportLabelsTaskRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportLabelsTaskRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExportLabelsTaskRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportLabelsTaskRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExportLabelsTaskRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportLabelsTaskRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartExportLabelsTaskRunErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for StartExportLabelsTaskRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartExportLabelsTaskRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StartExportLabelsTaskRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartExportLabelsTaskRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartExportLabelsTaskRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StartExportLabelsTaskRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartImportLabelsTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartImportLabelsTaskRunError {
    /// Kind of error that occurred.
    pub kind: StartImportLabelsTaskRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartImportLabelsTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartImportLabelsTaskRunErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartImportLabelsTaskRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartImportLabelsTaskRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StartImportLabelsTaskRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartImportLabelsTaskRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartImportLabelsTaskRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StartImportLabelsTaskRunErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartImportLabelsTaskRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartImportLabelsTaskRunError {
    fn code(&self) -> Option<&str> {
        StartImportLabelsTaskRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartImportLabelsTaskRunError {
    /// Creates a new `StartImportLabelsTaskRunError`.
    pub fn new(kind: StartImportLabelsTaskRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartImportLabelsTaskRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartImportLabelsTaskRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartImportLabelsTaskRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartImportLabelsTaskRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartImportLabelsTaskRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportLabelsTaskRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportLabelsTaskRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportLabelsTaskRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportLabelsTaskRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportLabelsTaskRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportLabelsTaskRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportLabelsTaskRunErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportLabelsTaskRunErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportLabelsTaskRunErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for StartImportLabelsTaskRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartImportLabelsTaskRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StartImportLabelsTaskRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartImportLabelsTaskRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartImportLabelsTaskRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StartImportLabelsTaskRunErrorKind::ResourceNumberLimitExceededException(_inner) => {
                Some(_inner)
            }
            StartImportLabelsTaskRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartJobRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartJobRunError {
    /// Kind of error that occurred.
    pub kind: StartJobRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartJobRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartJobRunErrorKind {
    /// <p>Too many jobs are being run concurrently.</p>
    ConcurrentRunsExceededException(crate::error::ConcurrentRunsExceededException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartJobRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartJobRunErrorKind::ConcurrentRunsExceededException(_inner) => _inner.fmt(f),
            StartJobRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StartJobRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartJobRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartJobRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StartJobRunErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            StartJobRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartJobRunError {
    fn code(&self) -> Option<&str> {
        StartJobRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartJobRunError {
    /// Creates a new `StartJobRunError`.
    pub fn new(kind: StartJobRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartJobRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartJobRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartJobRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartJobRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartJobRunErrorKind::ConcurrentRunsExceededException`.
    pub fn is_concurrent_runs_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartJobRunErrorKind::ConcurrentRunsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartJobRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartJobRunErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartJobRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartJobRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartJobRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, StartJobRunErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `StartJobRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartJobRunErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `StartJobRunErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartJobRunErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for StartJobRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartJobRunErrorKind::ConcurrentRunsExceededException(_inner) => Some(_inner),
            StartJobRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StartJobRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartJobRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartJobRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StartJobRunErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            StartJobRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMLEvaluationTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMLEvaluationTaskRunError {
    /// Kind of error that occurred.
    pub kind: StartMLEvaluationTaskRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMLEvaluationTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMLEvaluationTaskRunErrorKind {
    /// <p>Too many jobs are being run concurrently.</p>
    ConcurrentRunsExceededException(crate::error::ConcurrentRunsExceededException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The machine learning transform is not ready to run.</p>
    MlTransformNotReadyException(crate::error::MlTransformNotReadyException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMLEvaluationTaskRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMLEvaluationTaskRunErrorKind::ConcurrentRunsExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartMLEvaluationTaskRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StartMLEvaluationTaskRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartMLEvaluationTaskRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartMLEvaluationTaskRunErrorKind::MlTransformNotReadyException(_inner) => {
                _inner.fmt(f)
            }
            StartMLEvaluationTaskRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StartMLEvaluationTaskRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMLEvaluationTaskRunError {
    fn code(&self) -> Option<&str> {
        StartMLEvaluationTaskRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMLEvaluationTaskRunError {
    /// Creates a new `StartMLEvaluationTaskRunError`.
    pub fn new(kind: StartMLEvaluationTaskRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMLEvaluationTaskRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMLEvaluationTaskRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMLEvaluationTaskRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMLEvaluationTaskRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMLEvaluationTaskRunErrorKind::ConcurrentRunsExceededException`.
    pub fn is_concurrent_runs_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLEvaluationTaskRunErrorKind::ConcurrentRunsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMLEvaluationTaskRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLEvaluationTaskRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMLEvaluationTaskRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLEvaluationTaskRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMLEvaluationTaskRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLEvaluationTaskRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMLEvaluationTaskRunErrorKind::MlTransformNotReadyException`.
    pub fn is_ml_transform_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLEvaluationTaskRunErrorKind::MlTransformNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMLEvaluationTaskRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLEvaluationTaskRunErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for StartMLEvaluationTaskRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMLEvaluationTaskRunErrorKind::ConcurrentRunsExceededException(_inner) => {
                Some(_inner)
            }
            StartMLEvaluationTaskRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StartMLEvaluationTaskRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartMLEvaluationTaskRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartMLEvaluationTaskRunErrorKind::MlTransformNotReadyException(_inner) => Some(_inner),
            StartMLEvaluationTaskRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StartMLEvaluationTaskRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMLLabelingSetGenerationTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMLLabelingSetGenerationTaskRunError {
    /// Kind of error that occurred.
    pub kind: StartMLLabelingSetGenerationTaskRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMLLabelingSetGenerationTaskRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMLLabelingSetGenerationTaskRunErrorKind {
    /// <p>Too many jobs are being run concurrently.</p>
    ConcurrentRunsExceededException(crate::error::ConcurrentRunsExceededException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMLLabelingSetGenerationTaskRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMLLabelingSetGenerationTaskRunErrorKind::ConcurrentRunsExceededException(
                _inner,
            ) => _inner.fmt(f),
            StartMLLabelingSetGenerationTaskRunErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartMLLabelingSetGenerationTaskRunErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            StartMLLabelingSetGenerationTaskRunErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            StartMLLabelingSetGenerationTaskRunErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            StartMLLabelingSetGenerationTaskRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMLLabelingSetGenerationTaskRunError {
    fn code(&self) -> Option<&str> {
        StartMLLabelingSetGenerationTaskRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMLLabelingSetGenerationTaskRunError {
    /// Creates a new `StartMLLabelingSetGenerationTaskRunError`.
    pub fn new(
        kind: StartMLLabelingSetGenerationTaskRunErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMLLabelingSetGenerationTaskRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMLLabelingSetGenerationTaskRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMLLabelingSetGenerationTaskRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMLLabelingSetGenerationTaskRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMLLabelingSetGenerationTaskRunErrorKind::ConcurrentRunsExceededException`.
    pub fn is_concurrent_runs_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLLabelingSetGenerationTaskRunErrorKind::ConcurrentRunsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMLLabelingSetGenerationTaskRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLLabelingSetGenerationTaskRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMLLabelingSetGenerationTaskRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLLabelingSetGenerationTaskRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMLLabelingSetGenerationTaskRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLLabelingSetGenerationTaskRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMLLabelingSetGenerationTaskRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMLLabelingSetGenerationTaskRunErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for StartMLLabelingSetGenerationTaskRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMLLabelingSetGenerationTaskRunErrorKind::ConcurrentRunsExceededException(
                _inner,
            ) => Some(_inner),
            StartMLLabelingSetGenerationTaskRunErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            StartMLLabelingSetGenerationTaskRunErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            StartMLLabelingSetGenerationTaskRunErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            StartMLLabelingSetGenerationTaskRunErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            StartMLLabelingSetGenerationTaskRunErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `StartTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartTriggerError {
    /// Kind of error that occurred.
    pub kind: StartTriggerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartTriggerErrorKind {
    /// <p>Too many jobs are being run concurrently.</p>
    ConcurrentRunsExceededException(crate::error::ConcurrentRunsExceededException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartTriggerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartTriggerErrorKind::ConcurrentRunsExceededException(_inner) => _inner.fmt(f),
            StartTriggerErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StartTriggerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartTriggerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartTriggerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StartTriggerErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            StartTriggerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartTriggerError {
    fn code(&self) -> Option<&str> {
        StartTriggerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartTriggerError {
    /// Creates a new `StartTriggerError`.
    pub fn new(kind: StartTriggerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartTriggerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartTriggerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartTriggerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartTriggerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartTriggerErrorKind::ConcurrentRunsExceededException`.
    pub fn is_concurrent_runs_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTriggerErrorKind::ConcurrentRunsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTriggerErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTriggerErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTriggerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTriggerErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTriggerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, StartTriggerErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `StartTriggerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTriggerErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTriggerErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTriggerErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for StartTriggerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartTriggerErrorKind::ConcurrentRunsExceededException(_inner) => Some(_inner),
            StartTriggerErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StartTriggerErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartTriggerErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartTriggerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StartTriggerErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            StartTriggerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartWorkflowRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartWorkflowRunError {
    /// Kind of error that occurred.
    pub kind: StartWorkflowRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartWorkflowRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartWorkflowRunErrorKind {
    /// <p>Too many jobs are being run concurrently.</p>
    ConcurrentRunsExceededException(crate::error::ConcurrentRunsExceededException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartWorkflowRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartWorkflowRunErrorKind::ConcurrentRunsExceededException(_inner) => _inner.fmt(f),
            StartWorkflowRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StartWorkflowRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartWorkflowRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartWorkflowRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StartWorkflowRunErrorKind::ResourceNumberLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            StartWorkflowRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartWorkflowRunError {
    fn code(&self) -> Option<&str> {
        StartWorkflowRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartWorkflowRunError {
    /// Creates a new `StartWorkflowRunError`.
    pub fn new(kind: StartWorkflowRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartWorkflowRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartWorkflowRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartWorkflowRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartWorkflowRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartWorkflowRunErrorKind::ConcurrentRunsExceededException`.
    pub fn is_concurrent_runs_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowRunErrorKind::ConcurrentRunsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartWorkflowRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartWorkflowRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartWorkflowRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StartWorkflowRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowRunErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `StartWorkflowRunErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartWorkflowRunErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for StartWorkflowRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartWorkflowRunErrorKind::ConcurrentRunsExceededException(_inner) => Some(_inner),
            StartWorkflowRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StartWorkflowRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartWorkflowRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartWorkflowRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StartWorkflowRunErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            StartWorkflowRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopCrawlerError {
    /// Kind of error that occurred.
    pub kind: StopCrawlerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopCrawlerErrorKind {
    /// <p>The specified crawler is not running.</p>
    CrawlerNotRunningException(crate::error::CrawlerNotRunningException),
    /// <p>The specified crawler is stopping.</p>
    CrawlerStoppingException(crate::error::CrawlerStoppingException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopCrawlerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopCrawlerErrorKind::CrawlerNotRunningException(_inner) => _inner.fmt(f),
            StopCrawlerErrorKind::CrawlerStoppingException(_inner) => _inner.fmt(f),
            StopCrawlerErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StopCrawlerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StopCrawlerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopCrawlerError {
    fn code(&self) -> Option<&str> {
        StopCrawlerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopCrawlerError {
    /// Creates a new `StopCrawlerError`.
    pub fn new(kind: StopCrawlerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopCrawlerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopCrawlerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopCrawlerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopCrawlerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopCrawlerErrorKind::CrawlerNotRunningException`.
    pub fn is_crawler_not_running_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopCrawlerErrorKind::CrawlerNotRunningException(_)
        )
    }
    /// Returns `true` if the error kind is `StopCrawlerErrorKind::CrawlerStoppingException`.
    pub fn is_crawler_stopping_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopCrawlerErrorKind::CrawlerStoppingException(_)
        )
    }
    /// Returns `true` if the error kind is `StopCrawlerErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopCrawlerErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopCrawlerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopCrawlerErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for StopCrawlerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopCrawlerErrorKind::CrawlerNotRunningException(_inner) => Some(_inner),
            StopCrawlerErrorKind::CrawlerStoppingException(_inner) => Some(_inner),
            StopCrawlerErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StopCrawlerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StopCrawlerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopCrawlerSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopCrawlerScheduleError {
    /// Kind of error that occurred.
    pub kind: StopCrawlerScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopCrawlerSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopCrawlerScheduleErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>The specified scheduler is not running.</p>
    SchedulerNotRunningException(crate::error::SchedulerNotRunningException),
    /// <p>The specified scheduler is transitioning.</p>
    SchedulerTransitioningException(crate::error::SchedulerTransitioningException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopCrawlerScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopCrawlerScheduleErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StopCrawlerScheduleErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StopCrawlerScheduleErrorKind::SchedulerNotRunningException(_inner) => _inner.fmt(f),
            StopCrawlerScheduleErrorKind::SchedulerTransitioningException(_inner) => _inner.fmt(f),
            StopCrawlerScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopCrawlerScheduleError {
    fn code(&self) -> Option<&str> {
        StopCrawlerScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopCrawlerScheduleError {
    /// Creates a new `StopCrawlerScheduleError`.
    pub fn new(kind: StopCrawlerScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopCrawlerScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopCrawlerScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopCrawlerScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopCrawlerScheduleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopCrawlerScheduleErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopCrawlerScheduleErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopCrawlerScheduleErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopCrawlerScheduleErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `StopCrawlerScheduleErrorKind::SchedulerNotRunningException`.
    pub fn is_scheduler_not_running_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopCrawlerScheduleErrorKind::SchedulerNotRunningException(_)
        )
    }
    /// Returns `true` if the error kind is `StopCrawlerScheduleErrorKind::SchedulerTransitioningException`.
    pub fn is_scheduler_transitioning_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopCrawlerScheduleErrorKind::SchedulerTransitioningException(_)
        )
    }
}
impl std::error::Error for StopCrawlerScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopCrawlerScheduleErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StopCrawlerScheduleErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StopCrawlerScheduleErrorKind::SchedulerNotRunningException(_inner) => Some(_inner),
            StopCrawlerScheduleErrorKind::SchedulerTransitioningException(_inner) => Some(_inner),
            StopCrawlerScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopTriggerError {
    /// Kind of error that occurred.
    pub kind: StopTriggerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopTriggerErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopTriggerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopTriggerErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            StopTriggerErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StopTriggerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StopTriggerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StopTriggerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StopTriggerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopTriggerError {
    fn code(&self) -> Option<&str> {
        StopTriggerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopTriggerError {
    /// Creates a new `StopTriggerError`.
    pub fn new(kind: StopTriggerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopTriggerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopTriggerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopTriggerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopTriggerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopTriggerErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTriggerErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTriggerErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopTriggerErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopTriggerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTriggerErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StopTriggerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, StopTriggerErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `StopTriggerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopTriggerErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for StopTriggerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopTriggerErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            StopTriggerErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StopTriggerErrorKind::InternalServiceException(_inner) => Some(_inner),
            StopTriggerErrorKind::InvalidInputException(_inner) => Some(_inner),
            StopTriggerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StopTriggerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopWorkflowRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopWorkflowRunError {
    /// Kind of error that occurred.
    pub kind: StopWorkflowRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopWorkflowRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopWorkflowRunErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The workflow is in an invalid state to perform a requested operation.</p>
    IllegalWorkflowStateException(crate::error::IllegalWorkflowStateException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopWorkflowRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopWorkflowRunErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            StopWorkflowRunErrorKind::IllegalWorkflowStateException(_inner) => _inner.fmt(f),
            StopWorkflowRunErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StopWorkflowRunErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StopWorkflowRunErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            StopWorkflowRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopWorkflowRunError {
    fn code(&self) -> Option<&str> {
        StopWorkflowRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopWorkflowRunError {
    /// Creates a new `StopWorkflowRunError`.
    pub fn new(kind: StopWorkflowRunErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopWorkflowRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopWorkflowRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopWorkflowRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopWorkflowRunErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopWorkflowRunErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopWorkflowRunErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopWorkflowRunErrorKind::IllegalWorkflowStateException`.
    pub fn is_illegal_workflow_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopWorkflowRunErrorKind::IllegalWorkflowStateException(_)
        )
    }
    /// Returns `true` if the error kind is `StopWorkflowRunErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopWorkflowRunErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StopWorkflowRunErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopWorkflowRunErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StopWorkflowRunErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopWorkflowRunErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for StopWorkflowRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopWorkflowRunErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            StopWorkflowRunErrorKind::IllegalWorkflowStateException(_inner) => Some(_inner),
            StopWorkflowRunErrorKind::InternalServiceException(_inner) => Some(_inner),
            StopWorkflowRunErrorKind::InvalidInputException(_inner) => Some(_inner),
            StopWorkflowRunErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            StopWorkflowRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagResourceErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagResourceErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBlueprint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBlueprintError {
    /// Kind of error that occurred.
    pub kind: UpdateBlueprintErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBlueprint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBlueprintErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    IllegalBlueprintStateException(crate::error::IllegalBlueprintStateException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBlueprintError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBlueprintErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateBlueprintErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateBlueprintErrorKind::IllegalBlueprintStateException(_inner) => _inner.fmt(f),
            UpdateBlueprintErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateBlueprintErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateBlueprintErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateBlueprintErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBlueprintError {
    fn code(&self) -> Option<&str> {
        UpdateBlueprintError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBlueprintError {
    /// Creates a new `UpdateBlueprintError`.
    pub fn new(kind: UpdateBlueprintErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBlueprintError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBlueprintErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBlueprintError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBlueprintErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBlueprintErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBlueprintErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBlueprintErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBlueprintErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBlueprintErrorKind::IllegalBlueprintStateException`.
    pub fn is_illegal_blueprint_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBlueprintErrorKind::IllegalBlueprintStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBlueprintErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBlueprintErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBlueprintErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBlueprintErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBlueprintErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBlueprintErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateBlueprintError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBlueprintErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateBlueprintErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateBlueprintErrorKind::IllegalBlueprintStateException(_inner) => Some(_inner),
            UpdateBlueprintErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateBlueprintErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateBlueprintErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateBlueprintErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateClassifierError {
    /// Kind of error that occurred.
    pub kind: UpdateClassifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateClassifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateClassifierErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>There was a version conflict.</p>
    VersionMismatchException(crate::error::VersionMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateClassifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateClassifierErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateClassifierErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateClassifierErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateClassifierErrorKind::VersionMismatchException(_inner) => _inner.fmt(f),
            UpdateClassifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateClassifierError {
    fn code(&self) -> Option<&str> {
        UpdateClassifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateClassifierError {
    /// Creates a new `UpdateClassifierError`.
    pub fn new(kind: UpdateClassifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateClassifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateClassifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateClassifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateClassifierErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateClassifierErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassifierErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClassifierErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassifierErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClassifierErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassifierErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClassifierErrorKind::VersionMismatchException`.
    pub fn is_version_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassifierErrorKind::VersionMismatchException(_)
        )
    }
}
impl std::error::Error for UpdateClassifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateClassifierErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateClassifierErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateClassifierErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateClassifierErrorKind::VersionMismatchException(_inner) => Some(_inner),
            UpdateClassifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateColumnStatisticsForPartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateColumnStatisticsForPartitionError {
    /// Kind of error that occurred.
    pub kind: UpdateColumnStatisticsForPartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateColumnStatisticsForPartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateColumnStatisticsForPartitionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateColumnStatisticsForPartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateColumnStatisticsForPartitionErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateColumnStatisticsForPartitionErrorKind::GlueEncryptionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateColumnStatisticsForPartitionErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            UpdateColumnStatisticsForPartitionErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            UpdateColumnStatisticsForPartitionErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            UpdateColumnStatisticsForPartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateColumnStatisticsForPartitionError {
    fn code(&self) -> Option<&str> {
        UpdateColumnStatisticsForPartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateColumnStatisticsForPartitionError {
    /// Creates a new `UpdateColumnStatisticsForPartitionError`.
    pub fn new(
        kind: UpdateColumnStatisticsForPartitionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateColumnStatisticsForPartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateColumnStatisticsForPartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateColumnStatisticsForPartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateColumnStatisticsForPartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateColumnStatisticsForPartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateColumnStatisticsForPartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateColumnStatisticsForPartitionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateColumnStatisticsForPartitionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateColumnStatisticsForPartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateColumnStatisticsForPartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateColumnStatisticsForPartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateColumnStatisticsForPartitionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateColumnStatisticsForPartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateColumnStatisticsForPartitionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateColumnStatisticsForPartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateColumnStatisticsForPartitionErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateColumnStatisticsForPartitionErrorKind::GlueEncryptionException(_inner) => {
                Some(_inner)
            }
            UpdateColumnStatisticsForPartitionErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            UpdateColumnStatisticsForPartitionErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            UpdateColumnStatisticsForPartitionErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            UpdateColumnStatisticsForPartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateColumnStatisticsForTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateColumnStatisticsForTableError {
    /// Kind of error that occurred.
    pub kind: UpdateColumnStatisticsForTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateColumnStatisticsForTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateColumnStatisticsForTableErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateColumnStatisticsForTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateColumnStatisticsForTableErrorKind::EntityNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateColumnStatisticsForTableErrorKind::GlueEncryptionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateColumnStatisticsForTableErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            UpdateColumnStatisticsForTableErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateColumnStatisticsForTableErrorKind::OperationTimeoutException(_inner) => {
                _inner.fmt(f)
            }
            UpdateColumnStatisticsForTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateColumnStatisticsForTableError {
    fn code(&self) -> Option<&str> {
        UpdateColumnStatisticsForTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateColumnStatisticsForTableError {
    /// Creates a new `UpdateColumnStatisticsForTableError`.
    pub fn new(
        kind: UpdateColumnStatisticsForTableErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateColumnStatisticsForTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateColumnStatisticsForTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateColumnStatisticsForTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateColumnStatisticsForTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateColumnStatisticsForTableErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateColumnStatisticsForTableErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateColumnStatisticsForTableErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateColumnStatisticsForTableErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateColumnStatisticsForTableErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateColumnStatisticsForTableErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateColumnStatisticsForTableErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateColumnStatisticsForTableErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateColumnStatisticsForTableErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateColumnStatisticsForTableErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateColumnStatisticsForTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateColumnStatisticsForTableErrorKind::EntityNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateColumnStatisticsForTableErrorKind::GlueEncryptionException(_inner) => {
                Some(_inner)
            }
            UpdateColumnStatisticsForTableErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            UpdateColumnStatisticsForTableErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateColumnStatisticsForTableErrorKind::OperationTimeoutException(_inner) => {
                Some(_inner)
            }
            UpdateColumnStatisticsForTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConnectionError {
    /// Kind of error that occurred.
    pub kind: UpdateConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConnectionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConnectionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConnectionError {
    fn code(&self) -> Option<&str> {
        UpdateConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConnectionError {
    /// Creates a new `UpdateConnectionError`.
    pub fn new(kind: UpdateConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConnectionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCrawlerError {
    /// Kind of error that occurred.
    pub kind: UpdateCrawlerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCrawler` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCrawlerErrorKind {
    /// <p>The operation cannot be performed because the crawler is already running.</p>
    CrawlerRunningException(crate::error::CrawlerRunningException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>There was a version conflict.</p>
    VersionMismatchException(crate::error::VersionMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCrawlerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCrawlerErrorKind::CrawlerRunningException(_inner) => _inner.fmt(f),
            UpdateCrawlerErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateCrawlerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateCrawlerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateCrawlerErrorKind::VersionMismatchException(_inner) => _inner.fmt(f),
            UpdateCrawlerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCrawlerError {
    fn code(&self) -> Option<&str> {
        UpdateCrawlerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCrawlerError {
    /// Creates a new `UpdateCrawlerError`.
    pub fn new(kind: UpdateCrawlerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCrawlerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCrawlerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCrawlerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCrawlerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCrawlerErrorKind::CrawlerRunningException`.
    pub fn is_crawler_running_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCrawlerErrorKind::CrawlerRunningException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCrawlerErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCrawlerErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCrawlerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UpdateCrawlerErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UpdateCrawlerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCrawlerErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCrawlerErrorKind::VersionMismatchException`.
    pub fn is_version_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCrawlerErrorKind::VersionMismatchException(_)
        )
    }
}
impl std::error::Error for UpdateCrawlerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCrawlerErrorKind::CrawlerRunningException(_inner) => Some(_inner),
            UpdateCrawlerErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateCrawlerErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateCrawlerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateCrawlerErrorKind::VersionMismatchException(_inner) => Some(_inner),
            UpdateCrawlerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCrawlerSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCrawlerScheduleError {
    /// Kind of error that occurred.
    pub kind: UpdateCrawlerScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCrawlerSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCrawlerScheduleErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>The specified scheduler is transitioning.</p>
    SchedulerTransitioningException(crate::error::SchedulerTransitioningException),
    /// <p>There was a version conflict.</p>
    VersionMismatchException(crate::error::VersionMismatchException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCrawlerScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCrawlerScheduleErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateCrawlerScheduleErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateCrawlerScheduleErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateCrawlerScheduleErrorKind::SchedulerTransitioningException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCrawlerScheduleErrorKind::VersionMismatchException(_inner) => _inner.fmt(f),
            UpdateCrawlerScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCrawlerScheduleError {
    fn code(&self) -> Option<&str> {
        UpdateCrawlerScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCrawlerScheduleError {
    /// Creates a new `UpdateCrawlerScheduleError`.
    pub fn new(kind: UpdateCrawlerScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCrawlerScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCrawlerScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCrawlerScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCrawlerScheduleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCrawlerScheduleErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCrawlerScheduleErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCrawlerScheduleErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCrawlerScheduleErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCrawlerScheduleErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCrawlerScheduleErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCrawlerScheduleErrorKind::SchedulerTransitioningException`.
    pub fn is_scheduler_transitioning_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCrawlerScheduleErrorKind::SchedulerTransitioningException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCrawlerScheduleErrorKind::VersionMismatchException`.
    pub fn is_version_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCrawlerScheduleErrorKind::VersionMismatchException(_)
        )
    }
}
impl std::error::Error for UpdateCrawlerScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCrawlerScheduleErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateCrawlerScheduleErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateCrawlerScheduleErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateCrawlerScheduleErrorKind::SchedulerTransitioningException(_inner) => Some(_inner),
            UpdateCrawlerScheduleErrorKind::VersionMismatchException(_inner) => Some(_inner),
            UpdateCrawlerScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDatabaseError {
    /// Kind of error that occurred.
    pub kind: UpdateDatabaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDatabaseErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDatabaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDatabaseErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateDatabaseErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateDatabaseErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            UpdateDatabaseErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateDatabaseErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateDatabaseErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateDatabaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDatabaseError {
    fn code(&self) -> Option<&str> {
        UpdateDatabaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDatabaseError {
    /// Creates a new `UpdateDatabaseError`.
    pub fn new(kind: UpdateDatabaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDatabaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDatabaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDatabaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDatabaseErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDatabaseErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatabaseErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatabaseErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatabaseErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatabaseErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatabaseErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatabaseErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatabaseErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatabaseErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatabaseErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDatabaseErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatabaseErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateDatabaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDatabaseErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateDatabaseErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateDatabaseErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            UpdateDatabaseErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateDatabaseErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateDatabaseErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateDatabaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDevEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDevEndpointError {
    /// Kind of error that occurred.
    pub kind: UpdateDevEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDevEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDevEndpointErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A value could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDevEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDevEndpointErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateDevEndpointErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateDevEndpointErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateDevEndpointErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateDevEndpointErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDevEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDevEndpointError {
    fn code(&self) -> Option<&str> {
        UpdateDevEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDevEndpointError {
    /// Creates a new `UpdateDevEndpointError`.
    pub fn new(kind: UpdateDevEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDevEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDevEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDevEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDevEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDevEndpointErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevEndpointErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDevEndpointErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevEndpointErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDevEndpointErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevEndpointErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDevEndpointErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevEndpointErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDevEndpointErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDevEndpointErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDevEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDevEndpointErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateDevEndpointErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateDevEndpointErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateDevEndpointErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateDevEndpointErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDevEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateJobError {
    /// Kind of error that occurred.
    pub kind: UpdateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateJobErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateJobErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateJobError {
    fn code(&self) -> Option<&str> {
        UpdateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateJobError {
    /// Creates a new `UpdateJobError`.
    pub fn new(kind: UpdateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateJobErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UpdateJobErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobErrorKind::OperationTimeoutException(_))
    }
}
impl std::error::Error for UpdateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateJobErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateJobErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateJobErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateJobErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateJobErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMLTransform` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMLTransformError {
    /// Kind of error that occurred.
    pub kind: UpdateMLTransformErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMLTransform` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMLTransformErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMLTransformError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMLTransformErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateMLTransformErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateMLTransformErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateMLTransformErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateMLTransformErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateMLTransformErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMLTransformError {
    fn code(&self) -> Option<&str> {
        UpdateMLTransformError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMLTransformError {
    /// Creates a new `UpdateMLTransformError`.
    pub fn new(kind: UpdateMLTransformErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMLTransformError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMLTransformErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMLTransformError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMLTransformErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMLTransformErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMLTransformErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMLTransformErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMLTransformErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMLTransformErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMLTransformErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMLTransformErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMLTransformErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMLTransformErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMLTransformErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateMLTransformError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMLTransformErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateMLTransformErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateMLTransformErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateMLTransformErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateMLTransformErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateMLTransformErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePartitionError {
    /// Kind of error that occurred.
    pub kind: UpdatePartitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePartition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePartitionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePartitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePartitionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdatePartitionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            UpdatePartitionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdatePartitionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdatePartitionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdatePartitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePartitionError {
    fn code(&self) -> Option<&str> {
        UpdatePartitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePartitionError {
    /// Creates a new `UpdatePartitionError`.
    pub fn new(kind: UpdatePartitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePartitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePartitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePartitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePartitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePartitionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartitionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePartitionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartitionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePartitionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartitionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePartitionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartitionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePartitionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartitionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdatePartitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePartitionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdatePartitionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            UpdatePartitionErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdatePartitionErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdatePartitionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdatePartitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRegistryError {
    /// Kind of error that occurred.
    pub kind: UpdateRegistryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRegistryErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRegistryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRegistryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateRegistryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRegistryError {
    fn code(&self) -> Option<&str> {
        UpdateRegistryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRegistryError {
    /// Creates a new `UpdateRegistryError`.
    pub fn new(kind: UpdateRegistryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRegistryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRegistryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRegistryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRegistryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRegistryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegistryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegistryErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegistryErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegistryErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegistryErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegistryErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegistryErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRegistryErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRegistryErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for UpdateRegistryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRegistryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateRegistryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSchemaError {
    /// Kind of error that occurred.
    pub kind: UpdateSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSchemaErrorKind {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSchemaErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSchemaError {
    fn code(&self) -> Option<&str> {
        UpdateSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSchemaError {
    /// Creates a new `UpdateSchemaError`.
    pub fn new(kind: UpdateSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSchemaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSchemaErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateSchemaErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateSchemaErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSchemaErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSchemaErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSchemaErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSchemaErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSchemaErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSchemaErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UpdateSchemaErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for UpdateSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSchemaErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTableError {
    /// Kind of error that occurred.
    pub kind: UpdateTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTableErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource was not ready for a transaction.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTableErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::ResourceNumberLimitExceededException(_inner) => _inner.fmt(f),
            UpdateTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTableError {
    fn code(&self) -> Option<&str> {
        UpdateTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTableError {
    /// Creates a new `UpdateTableError`.
    pub fn new(kind: UpdateTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateTableErrorKind::EntityNotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(&self.kind, UpdateTableErrorKind::GlueEncryptionException(_))
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UpdateTableErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableErrorKind::OperationTimeoutException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableErrorKind::ResourceNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTableErrorKind::ResourceNumberLimitExceededException`.
    pub fn is_resource_number_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTableErrorKind::ResourceNumberLimitExceededException(_)
        )
    }
}
impl std::error::Error for UpdateTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTableErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateTableErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateTableErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            UpdateTableErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateTableErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateTableErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateTableErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            UpdateTableErrorKind::ResourceNumberLimitExceededException(_inner) => Some(_inner),
            UpdateTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTriggerError {
    /// Kind of error that occurred.
    pub kind: UpdateTriggerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTrigger` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTriggerErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTriggerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTriggerErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateTriggerErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateTriggerErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateTriggerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateTriggerErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateTriggerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTriggerError {
    fn code(&self) -> Option<&str> {
        UpdateTriggerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTriggerError {
    /// Creates a new `UpdateTriggerError`.
    pub fn new(kind: UpdateTriggerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTriggerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTriggerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTriggerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTriggerErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTriggerErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTriggerErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTriggerErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTriggerErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTriggerErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTriggerErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTriggerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UpdateTriggerErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UpdateTriggerErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTriggerErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateTriggerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTriggerErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateTriggerErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateTriggerErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateTriggerErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateTriggerErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateTriggerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserDefinedFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserDefinedFunctionError {
    /// Kind of error that occurred.
    pub kind: UpdateUserDefinedFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserDefinedFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserDefinedFunctionErrorKind {
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserDefinedFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserDefinedFunctionErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserDefinedFunctionErrorKind::GlueEncryptionException(_inner) => _inner.fmt(f),
            UpdateUserDefinedFunctionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateUserDefinedFunctionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateUserDefinedFunctionErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateUserDefinedFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserDefinedFunctionError {
    fn code(&self) -> Option<&str> {
        UpdateUserDefinedFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserDefinedFunctionError {
    /// Creates a new `UpdateUserDefinedFunctionError`.
    pub fn new(kind: UpdateUserDefinedFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserDefinedFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserDefinedFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserDefinedFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserDefinedFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserDefinedFunctionErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserDefinedFunctionErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserDefinedFunctionErrorKind::GlueEncryptionException`.
    pub fn is_glue_encryption_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserDefinedFunctionErrorKind::GlueEncryptionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserDefinedFunctionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserDefinedFunctionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserDefinedFunctionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserDefinedFunctionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserDefinedFunctionErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserDefinedFunctionErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateUserDefinedFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserDefinedFunctionErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateUserDefinedFunctionErrorKind::GlueEncryptionException(_inner) => Some(_inner),
            UpdateUserDefinedFunctionErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateUserDefinedFunctionErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateUserDefinedFunctionErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateUserDefinedFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWorkflowError {
    /// Kind of error that occurred.
    pub kind: UpdateWorkflowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWorkflow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWorkflowErrorKind {
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWorkflowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWorkflowErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateWorkflowErrorKind::EntityNotFoundException(_inner) => _inner.fmt(f),
            UpdateWorkflowErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateWorkflowErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateWorkflowErrorKind::OperationTimeoutException(_inner) => _inner.fmt(f),
            UpdateWorkflowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWorkflowError {
    fn code(&self) -> Option<&str> {
        UpdateWorkflowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWorkflowError {
    /// Creates a new `UpdateWorkflowError`.
    pub fn new(kind: UpdateWorkflowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWorkflowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWorkflowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWorkflowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWorkflowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWorkflowErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkflowErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkflowErrorKind::EntityNotFoundException`.
    pub fn is_entity_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkflowErrorKind::EntityNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkflowErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkflowErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkflowErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkflowErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWorkflowErrorKind::OperationTimeoutException`.
    pub fn is_operation_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkflowErrorKind::OperationTimeoutException(_)
        )
    }
}
impl std::error::Error for UpdateWorkflowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWorkflowErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateWorkflowErrorKind::EntityNotFoundException(_inner) => Some(_inner),
            UpdateWorkflowErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateWorkflowErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateWorkflowErrorKind::OperationTimeoutException(_inner) => Some(_inner),
            UpdateWorkflowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The operation timed out.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationTimeoutException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationTimeoutException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationTimeoutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationTimeoutException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationTimeoutException {}
/// See [`OperationTimeoutException`](crate::error::OperationTimeoutException)
pub mod operation_timeout_exception {
    /// A builder for [`OperationTimeoutException`](crate::error::OperationTimeoutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationTimeoutException`](crate::error::OperationTimeoutException)
        pub fn build(self) -> crate::error::OperationTimeoutException {
            crate::error::OperationTimeoutException {
                message: self.message,
            }
        }
    }
}
impl OperationTimeoutException {
    /// Creates a new builder-style object to manufacture [`OperationTimeoutException`](crate::error::OperationTimeoutException)
    pub fn builder() -> crate::error::operation_timeout_exception::Builder {
        crate::error::operation_timeout_exception::Builder::default()
    }
}

/// <p>The input provided was not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>An internal service error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceException {}
/// See [`InternalServiceException`](crate::error::InternalServiceException)
pub mod internal_service_exception {
    /// A builder for [`InternalServiceException`](crate::error::InternalServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceException`](crate::error::InternalServiceException)
        pub fn build(self) -> crate::error::InternalServiceException {
            crate::error::InternalServiceException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceException {
    /// Creates a new builder-style object to manufacture [`InternalServiceException`](crate::error::InternalServiceException)
    pub fn builder() -> crate::error::internal_service_exception::Builder {
        crate::error::internal_service_exception::Builder::default()
    }
}

/// <p>A specified entity does not exist</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityNotFoundException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EntityNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EntityNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EntityNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EntityNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for EntityNotFoundException {}
/// See [`EntityNotFoundException`](crate::error::EntityNotFoundException)
pub mod entity_not_found_exception {
    /// A builder for [`EntityNotFoundException`](crate::error::EntityNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityNotFoundException`](crate::error::EntityNotFoundException)
        pub fn build(self) -> crate::error::EntityNotFoundException {
            crate::error::EntityNotFoundException {
                message: self.message,
            }
        }
    }
}
impl EntityNotFoundException {
    /// Creates a new builder-style object to manufacture [`EntityNotFoundException`](crate::error::EntityNotFoundException)
    pub fn builder() -> crate::error::entity_not_found_exception::Builder {
        crate::error::entity_not_found_exception::Builder::default()
    }
}

/// <p>Two processes are trying to modify a resource simultaneously.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>An encryption operation failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlueEncryptionException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GlueEncryptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlueEncryptionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GlueEncryptionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GlueEncryptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GlueEncryptionException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for GlueEncryptionException {}
/// See [`GlueEncryptionException`](crate::error::GlueEncryptionException)
pub mod glue_encryption_exception {
    /// A builder for [`GlueEncryptionException`](crate::error::GlueEncryptionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GlueEncryptionException`](crate::error::GlueEncryptionException)
        pub fn build(self) -> crate::error::GlueEncryptionException {
            crate::error::GlueEncryptionException {
                message: self.message,
            }
        }
    }
}
impl GlueEncryptionException {
    /// Creates a new builder-style object to manufacture [`GlueEncryptionException`](crate::error::GlueEncryptionException)
    pub fn builder() -> crate::error::glue_encryption_exception::Builder {
        crate::error::glue_encryption_exception::Builder::default()
    }
}

/// <p>A resource numerical limit was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNumberLimitExceededException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNumberLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNumberLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNumberLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNumberLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNumberLimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNumberLimitExceededException {}
/// See [`ResourceNumberLimitExceededException`](crate::error::ResourceNumberLimitExceededException)
pub mod resource_number_limit_exceeded_exception {
    /// A builder for [`ResourceNumberLimitExceededException`](crate::error::ResourceNumberLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNumberLimitExceededException`](crate::error::ResourceNumberLimitExceededException)
        pub fn build(self) -> crate::error::ResourceNumberLimitExceededException {
            crate::error::ResourceNumberLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ResourceNumberLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceNumberLimitExceededException`](crate::error::ResourceNumberLimitExceededException)
    pub fn builder() -> crate::error::resource_number_limit_exceeded_exception::Builder {
        crate::error::resource_number_limit_exceeded_exception::Builder::default()
    }
}

/// <p>A resource was not ready for a transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotReadyException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotReadyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotReadyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotReadyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotReadyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotReadyException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotReadyException {}
/// See [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
pub mod resource_not_ready_exception {
    /// A builder for [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
        pub fn build(self) -> crate::error::ResourceNotReadyException {
            crate::error::ResourceNotReadyException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotReadyException {
    /// Creates a new builder-style object to manufacture [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
    pub fn builder() -> crate::error::resource_not_ready_exception::Builder {
        crate::error::resource_not_ready_exception::Builder::default()
    }
}

/// <p>Access to a resource was denied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>A value could not be validated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>There was a version conflict.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VersionMismatchException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VersionMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VersionMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl VersionMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for VersionMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "VersionMismatchException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for VersionMismatchException {}
/// See [`VersionMismatchException`](crate::error::VersionMismatchException)
pub mod version_mismatch_exception {
    /// A builder for [`VersionMismatchException`](crate::error::VersionMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`VersionMismatchException`](crate::error::VersionMismatchException)
        pub fn build(self) -> crate::error::VersionMismatchException {
            crate::error::VersionMismatchException {
                message: self.message,
            }
        }
    }
}
impl VersionMismatchException {
    /// Creates a new builder-style object to manufacture [`VersionMismatchException`](crate::error::VersionMismatchException)
    pub fn builder() -> crate::error::version_mismatch_exception::Builder {
        crate::error::version_mismatch_exception::Builder::default()
    }
}

/// <p>The specified scheduler is transitioning.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchedulerTransitioningException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SchedulerTransitioningException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchedulerTransitioningException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SchedulerTransitioningException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SchedulerTransitioningException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SchedulerTransitioningException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for SchedulerTransitioningException {}
/// See [`SchedulerTransitioningException`](crate::error::SchedulerTransitioningException)
pub mod scheduler_transitioning_exception {
    /// A builder for [`SchedulerTransitioningException`](crate::error::SchedulerTransitioningException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SchedulerTransitioningException`](crate::error::SchedulerTransitioningException)
        pub fn build(self) -> crate::error::SchedulerTransitioningException {
            crate::error::SchedulerTransitioningException {
                message: self.message,
            }
        }
    }
}
impl SchedulerTransitioningException {
    /// Creates a new builder-style object to manufacture [`SchedulerTransitioningException`](crate::error::SchedulerTransitioningException)
    pub fn builder() -> crate::error::scheduler_transitioning_exception::Builder {
        crate::error::scheduler_transitioning_exception::Builder::default()
    }
}

/// <p>The operation cannot be performed because the crawler is already running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrawlerRunningException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CrawlerRunningException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrawlerRunningException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CrawlerRunningException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CrawlerRunningException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CrawlerRunningException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for CrawlerRunningException {}
/// See [`CrawlerRunningException`](crate::error::CrawlerRunningException)
pub mod crawler_running_exception {
    /// A builder for [`CrawlerRunningException`](crate::error::CrawlerRunningException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CrawlerRunningException`](crate::error::CrawlerRunningException)
        pub fn build(self) -> crate::error::CrawlerRunningException {
            crate::error::CrawlerRunningException {
                message: self.message,
            }
        }
    }
}
impl CrawlerRunningException {
    /// Creates a new builder-style object to manufacture [`CrawlerRunningException`](crate::error::CrawlerRunningException)
    pub fn builder() -> crate::error::crawler_running_exception::Builder {
        crate::error::crawler_running_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IllegalBlueprintStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IllegalBlueprintStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IllegalBlueprintStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IllegalBlueprintStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IllegalBlueprintStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IllegalBlueprintStateException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for IllegalBlueprintStateException {}
/// See [`IllegalBlueprintStateException`](crate::error::IllegalBlueprintStateException)
pub mod illegal_blueprint_state_exception {
    /// A builder for [`IllegalBlueprintStateException`](crate::error::IllegalBlueprintStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IllegalBlueprintStateException`](crate::error::IllegalBlueprintStateException)
        pub fn build(self) -> crate::error::IllegalBlueprintStateException {
            crate::error::IllegalBlueprintStateException {
                message: self.message,
            }
        }
    }
}
impl IllegalBlueprintStateException {
    /// Creates a new builder-style object to manufacture [`IllegalBlueprintStateException`](crate::error::IllegalBlueprintStateException)
    pub fn builder() -> crate::error::illegal_blueprint_state_exception::Builder {
        crate::error::illegal_blueprint_state_exception::Builder::default()
    }
}

/// <p>The workflow is in an invalid state to perform a requested operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IllegalWorkflowStateException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IllegalWorkflowStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IllegalWorkflowStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IllegalWorkflowStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IllegalWorkflowStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IllegalWorkflowStateException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for IllegalWorkflowStateException {}
/// See [`IllegalWorkflowStateException`](crate::error::IllegalWorkflowStateException)
pub mod illegal_workflow_state_exception {
    /// A builder for [`IllegalWorkflowStateException`](crate::error::IllegalWorkflowStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IllegalWorkflowStateException`](crate::error::IllegalWorkflowStateException)
        pub fn build(self) -> crate::error::IllegalWorkflowStateException {
            crate::error::IllegalWorkflowStateException {
                message: self.message,
            }
        }
    }
}
impl IllegalWorkflowStateException {
    /// Creates a new builder-style object to manufacture [`IllegalWorkflowStateException`](crate::error::IllegalWorkflowStateException)
    pub fn builder() -> crate::error::illegal_workflow_state_exception::Builder {
        crate::error::illegal_workflow_state_exception::Builder::default()
    }
}

/// <p>The specified scheduler is not running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchedulerNotRunningException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SchedulerNotRunningException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchedulerNotRunningException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SchedulerNotRunningException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SchedulerNotRunningException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SchedulerNotRunningException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for SchedulerNotRunningException {}
/// See [`SchedulerNotRunningException`](crate::error::SchedulerNotRunningException)
pub mod scheduler_not_running_exception {
    /// A builder for [`SchedulerNotRunningException`](crate::error::SchedulerNotRunningException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SchedulerNotRunningException`](crate::error::SchedulerNotRunningException)
        pub fn build(self) -> crate::error::SchedulerNotRunningException {
            crate::error::SchedulerNotRunningException {
                message: self.message,
            }
        }
    }
}
impl SchedulerNotRunningException {
    /// Creates a new builder-style object to manufacture [`SchedulerNotRunningException`](crate::error::SchedulerNotRunningException)
    pub fn builder() -> crate::error::scheduler_not_running_exception::Builder {
        crate::error::scheduler_not_running_exception::Builder::default()
    }
}

/// <p>The specified crawler is stopping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrawlerStoppingException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CrawlerStoppingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrawlerStoppingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CrawlerStoppingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CrawlerStoppingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CrawlerStoppingException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for CrawlerStoppingException {}
/// See [`CrawlerStoppingException`](crate::error::CrawlerStoppingException)
pub mod crawler_stopping_exception {
    /// A builder for [`CrawlerStoppingException`](crate::error::CrawlerStoppingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CrawlerStoppingException`](crate::error::CrawlerStoppingException)
        pub fn build(self) -> crate::error::CrawlerStoppingException {
            crate::error::CrawlerStoppingException {
                message: self.message,
            }
        }
    }
}
impl CrawlerStoppingException {
    /// Creates a new builder-style object to manufacture [`CrawlerStoppingException`](crate::error::CrawlerStoppingException)
    pub fn builder() -> crate::error::crawler_stopping_exception::Builder {
        crate::error::crawler_stopping_exception::Builder::default()
    }
}

/// <p>The specified crawler is not running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrawlerNotRunningException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CrawlerNotRunningException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrawlerNotRunningException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CrawlerNotRunningException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CrawlerNotRunningException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CrawlerNotRunningException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for CrawlerNotRunningException {}
/// See [`CrawlerNotRunningException`](crate::error::CrawlerNotRunningException)
pub mod crawler_not_running_exception {
    /// A builder for [`CrawlerNotRunningException`](crate::error::CrawlerNotRunningException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CrawlerNotRunningException`](crate::error::CrawlerNotRunningException)
        pub fn build(self) -> crate::error::CrawlerNotRunningException {
            crate::error::CrawlerNotRunningException {
                message: self.message,
            }
        }
    }
}
impl CrawlerNotRunningException {
    /// Creates a new builder-style object to manufacture [`CrawlerNotRunningException`](crate::error::CrawlerNotRunningException)
    pub fn builder() -> crate::error::crawler_not_running_exception::Builder {
        crate::error::crawler_not_running_exception::Builder::default()
    }
}

/// <p>Too many jobs are being run concurrently.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentRunsExceededException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentRunsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentRunsExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentRunsExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentRunsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentRunsExceededException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentRunsExceededException {}
/// See [`ConcurrentRunsExceededException`](crate::error::ConcurrentRunsExceededException)
pub mod concurrent_runs_exceeded_exception {
    /// A builder for [`ConcurrentRunsExceededException`](crate::error::ConcurrentRunsExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentRunsExceededException`](crate::error::ConcurrentRunsExceededException)
        pub fn build(self) -> crate::error::ConcurrentRunsExceededException {
            crate::error::ConcurrentRunsExceededException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentRunsExceededException {
    /// Creates a new builder-style object to manufacture [`ConcurrentRunsExceededException`](crate::error::ConcurrentRunsExceededException)
    pub fn builder() -> crate::error::concurrent_runs_exceeded_exception::Builder {
        crate::error::concurrent_runs_exceeded_exception::Builder::default()
    }
}

/// <p>The machine learning transform is not ready to run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MlTransformNotReadyException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MlTransformNotReadyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MlTransformNotReadyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MlTransformNotReadyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MlTransformNotReadyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "MlTransformNotReadyException [MLTransformNotReadyException]"
        )?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for MlTransformNotReadyException {}
/// See [`MlTransformNotReadyException`](crate::error::MlTransformNotReadyException)
pub mod ml_transform_not_ready_exception {
    /// A builder for [`MlTransformNotReadyException`](crate::error::MlTransformNotReadyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MlTransformNotReadyException`](crate::error::MlTransformNotReadyException)
        pub fn build(self) -> crate::error::MlTransformNotReadyException {
            crate::error::MlTransformNotReadyException {
                message: self.message,
            }
        }
    }
}
impl MlTransformNotReadyException {
    /// Creates a new builder-style object to manufacture [`MlTransformNotReadyException`](crate::error::MlTransformNotReadyException)
    pub fn builder() -> crate::error::ml_transform_not_ready_exception::Builder {
        crate::error::ml_transform_not_ready_exception::Builder::default()
    }
}

/// <p>The specified scheduler is already running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchedulerRunningException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SchedulerRunningException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchedulerRunningException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SchedulerRunningException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SchedulerRunningException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SchedulerRunningException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for SchedulerRunningException {}
/// See [`SchedulerRunningException`](crate::error::SchedulerRunningException)
pub mod scheduler_running_exception {
    /// A builder for [`SchedulerRunningException`](crate::error::SchedulerRunningException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SchedulerRunningException`](crate::error::SchedulerRunningException)
        pub fn build(self) -> crate::error::SchedulerRunningException {
            crate::error::SchedulerRunningException {
                message: self.message,
            }
        }
    }
}
impl SchedulerRunningException {
    /// Creates a new builder-style object to manufacture [`SchedulerRunningException`](crate::error::SchedulerRunningException)
    pub fn builder() -> crate::error::scheduler_running_exception::Builder {
        crate::error::scheduler_running_exception::Builder::default()
    }
}

/// <p>There is no applicable schedule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoScheduleException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoScheduleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoScheduleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoScheduleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoScheduleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoScheduleException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoScheduleException {}
/// See [`NoScheduleException`](crate::error::NoScheduleException)
pub mod no_schedule_exception {
    /// A builder for [`NoScheduleException`](crate::error::NoScheduleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoScheduleException`](crate::error::NoScheduleException)
        pub fn build(self) -> crate::error::NoScheduleException {
            crate::error::NoScheduleException {
                message: self.message,
            }
        }
    }
}
impl NoScheduleException {
    /// Creates a new builder-style object to manufacture [`NoScheduleException`](crate::error::NoScheduleException)
    pub fn builder() -> crate::error::no_schedule_exception::Builder {
        crate::error::no_schedule_exception::Builder::default()
    }
}

/// <p>A resource to be created or added already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlreadyExistsException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AlreadyExistsException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for AlreadyExistsException {}
/// See [`AlreadyExistsException`](crate::error::AlreadyExistsException)
pub mod already_exists_exception {
    /// A builder for [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AlreadyExistsException`](crate::error::AlreadyExistsException)
        pub fn build(self) -> crate::error::AlreadyExistsException {
            crate::error::AlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl AlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`AlreadyExistsException`](crate::error::AlreadyExistsException)
    pub fn builder() -> crate::error::already_exists_exception::Builder {
        crate::error::already_exists_exception::Builder::default()
    }
}

/// <p>A specified condition was not satisfied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConditionCheckFailureException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConditionCheckFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConditionCheckFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConditionCheckFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConditionCheckFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConditionCheckFailureException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConditionCheckFailureException {}
/// See [`ConditionCheckFailureException`](crate::error::ConditionCheckFailureException)
pub mod condition_check_failure_exception {
    /// A builder for [`ConditionCheckFailureException`](crate::error::ConditionCheckFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConditionCheckFailureException`](crate::error::ConditionCheckFailureException)
        pub fn build(self) -> crate::error::ConditionCheckFailureException {
            crate::error::ConditionCheckFailureException {
                message: self.message,
            }
        }
    }
}
impl ConditionCheckFailureException {
    /// Creates a new builder-style object to manufacture [`ConditionCheckFailureException`](crate::error::ConditionCheckFailureException)
    pub fn builder() -> crate::error::condition_check_failure_exception::Builder {
        crate::error::condition_check_failure_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PermissionTypeMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PermissionTypeMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PermissionTypeMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PermissionTypeMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PermissionTypeMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PermissionTypeMismatchException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for PermissionTypeMismatchException {}
/// See [`PermissionTypeMismatchException`](crate::error::PermissionTypeMismatchException)
pub mod permission_type_mismatch_exception {
    /// A builder for [`PermissionTypeMismatchException`](crate::error::PermissionTypeMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PermissionTypeMismatchException`](crate::error::PermissionTypeMismatchException)
        pub fn build(self) -> crate::error::PermissionTypeMismatchException {
            crate::error::PermissionTypeMismatchException {
                message: self.message,
            }
        }
    }
}
impl PermissionTypeMismatchException {
    /// Creates a new builder-style object to manufacture [`PermissionTypeMismatchException`](crate::error::PermissionTypeMismatchException)
    pub fn builder() -> crate::error::permission_type_mismatch_exception::Builder {
        crate::error::permission_type_mismatch_exception::Builder::default()
    }
}

/// <p>An error that indicates your data is in an invalid state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStateException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStateException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStateException {}
/// See [`InvalidStateException`](crate::error::InvalidStateException)
pub mod invalid_state_exception {
    /// A builder for [`InvalidStateException`](crate::error::InvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStateException`](crate::error::InvalidStateException)
        pub fn build(self) -> crate::error::InvalidStateException {
            crate::error::InvalidStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidStateException {
    /// Creates a new builder-style object to manufacture [`InvalidStateException`](crate::error::InvalidStateException)
    pub fn builder() -> crate::error::invalid_state_exception::Builder {
        crate::error::invalid_state_exception::Builder::default()
    }
}

/// <p>The <code>CreatePartitions</code> API was called on a table that has indexes enabled. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The same unique identifier was associated with two different records.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdempotentParameterMismatchException {
    /// <p>A message describing the problem.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdempotentParameterMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IdempotentParameterMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IdempotentParameterMismatchException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdempotentParameterMismatchException {}
/// See [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
pub mod idempotent_parameter_mismatch_exception {
    /// A builder for [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message describing the problem.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the problem.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
        pub fn build(self) -> crate::error::IdempotentParameterMismatchException {
            crate::error::IdempotentParameterMismatchException {
                message: self.message,
            }
        }
    }
}
impl IdempotentParameterMismatchException {
    /// Creates a new builder-style object to manufacture [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    pub fn builder() -> crate::error::idempotent_parameter_mismatch_exception::Builder {
        crate::error::idempotent_parameter_mismatch_exception::Builder::default()
    }
}
