// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Glue
///
/// Client for invoking operations on AWS Glue. Each operation on AWS Glue is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_glue::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_glue::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_glue::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchCreatePartition` operation.
    ///
    /// See [`BatchCreatePartition`](crate::client::fluent_builders::BatchCreatePartition) for more information about the
    /// operation and its arguments.
    pub fn batch_create_partition(&self) -> fluent_builders::BatchCreatePartition<C, M, R> {
        fluent_builders::BatchCreatePartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteConnection` operation.
    ///
    /// See [`BatchDeleteConnection`](crate::client::fluent_builders::BatchDeleteConnection) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_connection(&self) -> fluent_builders::BatchDeleteConnection<C, M, R> {
        fluent_builders::BatchDeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeletePartition` operation.
    ///
    /// See [`BatchDeletePartition`](crate::client::fluent_builders::BatchDeletePartition) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_partition(&self) -> fluent_builders::BatchDeletePartition<C, M, R> {
        fluent_builders::BatchDeletePartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteTable` operation.
    ///
    /// See [`BatchDeleteTable`](crate::client::fluent_builders::BatchDeleteTable) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_table(&self) -> fluent_builders::BatchDeleteTable<C, M, R> {
        fluent_builders::BatchDeleteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteTableVersion` operation.
    ///
    /// See [`BatchDeleteTableVersion`](crate::client::fluent_builders::BatchDeleteTableVersion) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_table_version(&self) -> fluent_builders::BatchDeleteTableVersion<C, M, R> {
        fluent_builders::BatchDeleteTableVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetBlueprints` operation.
    ///
    /// See [`BatchGetBlueprints`](crate::client::fluent_builders::BatchGetBlueprints) for more information about the
    /// operation and its arguments.
    pub fn batch_get_blueprints(&self) -> fluent_builders::BatchGetBlueprints<C, M, R> {
        fluent_builders::BatchGetBlueprints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetCrawlers` operation.
    ///
    /// See [`BatchGetCrawlers`](crate::client::fluent_builders::BatchGetCrawlers) for more information about the
    /// operation and its arguments.
    pub fn batch_get_crawlers(&self) -> fluent_builders::BatchGetCrawlers<C, M, R> {
        fluent_builders::BatchGetCrawlers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetDevEndpoints` operation.
    ///
    /// See [`BatchGetDevEndpoints`](crate::client::fluent_builders::BatchGetDevEndpoints) for more information about the
    /// operation and its arguments.
    pub fn batch_get_dev_endpoints(&self) -> fluent_builders::BatchGetDevEndpoints<C, M, R> {
        fluent_builders::BatchGetDevEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetJobs` operation.
    ///
    /// See [`BatchGetJobs`](crate::client::fluent_builders::BatchGetJobs) for more information about the
    /// operation and its arguments.
    pub fn batch_get_jobs(&self) -> fluent_builders::BatchGetJobs<C, M, R> {
        fluent_builders::BatchGetJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetPartition` operation.
    ///
    /// See [`BatchGetPartition`](crate::client::fluent_builders::BatchGetPartition) for more information about the
    /// operation and its arguments.
    pub fn batch_get_partition(&self) -> fluent_builders::BatchGetPartition<C, M, R> {
        fluent_builders::BatchGetPartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetTriggers` operation.
    ///
    /// See [`BatchGetTriggers`](crate::client::fluent_builders::BatchGetTriggers) for more information about the
    /// operation and its arguments.
    pub fn batch_get_triggers(&self) -> fluent_builders::BatchGetTriggers<C, M, R> {
        fluent_builders::BatchGetTriggers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetWorkflows` operation.
    ///
    /// See [`BatchGetWorkflows`](crate::client::fluent_builders::BatchGetWorkflows) for more information about the
    /// operation and its arguments.
    pub fn batch_get_workflows(&self) -> fluent_builders::BatchGetWorkflows<C, M, R> {
        fluent_builders::BatchGetWorkflows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchStopJobRun` operation.
    ///
    /// See [`BatchStopJobRun`](crate::client::fluent_builders::BatchStopJobRun) for more information about the
    /// operation and its arguments.
    pub fn batch_stop_job_run(&self) -> fluent_builders::BatchStopJobRun<C, M, R> {
        fluent_builders::BatchStopJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchUpdatePartition` operation.
    ///
    /// See [`BatchUpdatePartition`](crate::client::fluent_builders::BatchUpdatePartition) for more information about the
    /// operation and its arguments.
    pub fn batch_update_partition(&self) -> fluent_builders::BatchUpdatePartition<C, M, R> {
        fluent_builders::BatchUpdatePartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelMLTaskRun` operation.
    ///
    /// See [`CancelMLTaskRun`](crate::client::fluent_builders::CancelMLTaskRun) for more information about the
    /// operation and its arguments.
    pub fn cancel_ml_task_run(&self) -> fluent_builders::CancelMLTaskRun<C, M, R> {
        fluent_builders::CancelMLTaskRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CheckSchemaVersionValidity` operation.
    ///
    /// See [`CheckSchemaVersionValidity`](crate::client::fluent_builders::CheckSchemaVersionValidity) for more information about the
    /// operation and its arguments.
    pub fn check_schema_version_validity(
        &self,
    ) -> fluent_builders::CheckSchemaVersionValidity<C, M, R> {
        fluent_builders::CheckSchemaVersionValidity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBlueprint` operation.
    ///
    /// See [`CreateBlueprint`](crate::client::fluent_builders::CreateBlueprint) for more information about the
    /// operation and its arguments.
    pub fn create_blueprint(&self) -> fluent_builders::CreateBlueprint<C, M, R> {
        fluent_builders::CreateBlueprint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateClassifier` operation.
    ///
    /// See [`CreateClassifier`](crate::client::fluent_builders::CreateClassifier) for more information about the
    /// operation and its arguments.
    pub fn create_classifier(&self) -> fluent_builders::CreateClassifier<C, M, R> {
        fluent_builders::CreateClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConnection` operation.
    ///
    /// See [`CreateConnection`](crate::client::fluent_builders::CreateConnection) for more information about the
    /// operation and its arguments.
    pub fn create_connection(&self) -> fluent_builders::CreateConnection<C, M, R> {
        fluent_builders::CreateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCrawler` operation.
    ///
    /// See [`CreateCrawler`](crate::client::fluent_builders::CreateCrawler) for more information about the
    /// operation and its arguments.
    pub fn create_crawler(&self) -> fluent_builders::CreateCrawler<C, M, R> {
        fluent_builders::CreateCrawler::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDatabase` operation.
    ///
    /// See [`CreateDatabase`](crate::client::fluent_builders::CreateDatabase) for more information about the
    /// operation and its arguments.
    pub fn create_database(&self) -> fluent_builders::CreateDatabase<C, M, R> {
        fluent_builders::CreateDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDevEndpoint` operation.
    ///
    /// See [`CreateDevEndpoint`](crate::client::fluent_builders::CreateDevEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_dev_endpoint(&self) -> fluent_builders::CreateDevEndpoint<C, M, R> {
        fluent_builders::CreateDevEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateJob` operation.
    ///
    /// See [`CreateJob`](crate::client::fluent_builders::CreateJob) for more information about the
    /// operation and its arguments.
    pub fn create_job(&self) -> fluent_builders::CreateJob<C, M, R> {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMLTransform` operation.
    ///
    /// See [`CreateMLTransform`](crate::client::fluent_builders::CreateMLTransform) for more information about the
    /// operation and its arguments.
    pub fn create_ml_transform(&self) -> fluent_builders::CreateMLTransform<C, M, R> {
        fluent_builders::CreateMLTransform::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePartition` operation.
    ///
    /// See [`CreatePartition`](crate::client::fluent_builders::CreatePartition) for more information about the
    /// operation and its arguments.
    pub fn create_partition(&self) -> fluent_builders::CreatePartition<C, M, R> {
        fluent_builders::CreatePartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePartitionIndex` operation.
    ///
    /// See [`CreatePartitionIndex`](crate::client::fluent_builders::CreatePartitionIndex) for more information about the
    /// operation and its arguments.
    pub fn create_partition_index(&self) -> fluent_builders::CreatePartitionIndex<C, M, R> {
        fluent_builders::CreatePartitionIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRegistry` operation.
    ///
    /// See [`CreateRegistry`](crate::client::fluent_builders::CreateRegistry) for more information about the
    /// operation and its arguments.
    pub fn create_registry(&self) -> fluent_builders::CreateRegistry<C, M, R> {
        fluent_builders::CreateRegistry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSchema` operation.
    ///
    /// See [`CreateSchema`](crate::client::fluent_builders::CreateSchema) for more information about the
    /// operation and its arguments.
    pub fn create_schema(&self) -> fluent_builders::CreateSchema<C, M, R> {
        fluent_builders::CreateSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateScript` operation.
    ///
    /// See [`CreateScript`](crate::client::fluent_builders::CreateScript) for more information about the
    /// operation and its arguments.
    pub fn create_script(&self) -> fluent_builders::CreateScript<C, M, R> {
        fluent_builders::CreateScript::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSecurityConfiguration` operation.
    ///
    /// See [`CreateSecurityConfiguration`](crate::client::fluent_builders::CreateSecurityConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_security_configuration(
        &self,
    ) -> fluent_builders::CreateSecurityConfiguration<C, M, R> {
        fluent_builders::CreateSecurityConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTable` operation.
    ///
    /// See [`CreateTable`](crate::client::fluent_builders::CreateTable) for more information about the
    /// operation and its arguments.
    pub fn create_table(&self) -> fluent_builders::CreateTable<C, M, R> {
        fluent_builders::CreateTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrigger` operation.
    ///
    /// See [`CreateTrigger`](crate::client::fluent_builders::CreateTrigger) for more information about the
    /// operation and its arguments.
    pub fn create_trigger(&self) -> fluent_builders::CreateTrigger<C, M, R> {
        fluent_builders::CreateTrigger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUserDefinedFunction` operation.
    ///
    /// See [`CreateUserDefinedFunction`](crate::client::fluent_builders::CreateUserDefinedFunction) for more information about the
    /// operation and its arguments.
    pub fn create_user_defined_function(
        &self,
    ) -> fluent_builders::CreateUserDefinedFunction<C, M, R> {
        fluent_builders::CreateUserDefinedFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkflow` operation.
    ///
    /// See [`CreateWorkflow`](crate::client::fluent_builders::CreateWorkflow) for more information about the
    /// operation and its arguments.
    pub fn create_workflow(&self) -> fluent_builders::CreateWorkflow<C, M, R> {
        fluent_builders::CreateWorkflow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBlueprint` operation.
    ///
    /// See [`DeleteBlueprint`](crate::client::fluent_builders::DeleteBlueprint) for more information about the
    /// operation and its arguments.
    pub fn delete_blueprint(&self) -> fluent_builders::DeleteBlueprint<C, M, R> {
        fluent_builders::DeleteBlueprint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteClassifier` operation.
    ///
    /// See [`DeleteClassifier`](crate::client::fluent_builders::DeleteClassifier) for more information about the
    /// operation and its arguments.
    pub fn delete_classifier(&self) -> fluent_builders::DeleteClassifier<C, M, R> {
        fluent_builders::DeleteClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteColumnStatisticsForPartition` operation.
    ///
    /// See [`DeleteColumnStatisticsForPartition`](crate::client::fluent_builders::DeleteColumnStatisticsForPartition) for more information about the
    /// operation and its arguments.
    pub fn delete_column_statistics_for_partition(
        &self,
    ) -> fluent_builders::DeleteColumnStatisticsForPartition<C, M, R> {
        fluent_builders::DeleteColumnStatisticsForPartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteColumnStatisticsForTable` operation.
    ///
    /// See [`DeleteColumnStatisticsForTable`](crate::client::fluent_builders::DeleteColumnStatisticsForTable) for more information about the
    /// operation and its arguments.
    pub fn delete_column_statistics_for_table(
        &self,
    ) -> fluent_builders::DeleteColumnStatisticsForTable<C, M, R> {
        fluent_builders::DeleteColumnStatisticsForTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnection` operation.
    ///
    /// See [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection<C, M, R> {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCrawler` operation.
    ///
    /// See [`DeleteCrawler`](crate::client::fluent_builders::DeleteCrawler) for more information about the
    /// operation and its arguments.
    pub fn delete_crawler(&self) -> fluent_builders::DeleteCrawler<C, M, R> {
        fluent_builders::DeleteCrawler::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDatabase` operation.
    ///
    /// See [`DeleteDatabase`](crate::client::fluent_builders::DeleteDatabase) for more information about the
    /// operation and its arguments.
    pub fn delete_database(&self) -> fluent_builders::DeleteDatabase<C, M, R> {
        fluent_builders::DeleteDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDevEndpoint` operation.
    ///
    /// See [`DeleteDevEndpoint`](crate::client::fluent_builders::DeleteDevEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_dev_endpoint(&self) -> fluent_builders::DeleteDevEndpoint<C, M, R> {
        fluent_builders::DeleteDevEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJob` operation.
    ///
    /// See [`DeleteJob`](crate::client::fluent_builders::DeleteJob) for more information about the
    /// operation and its arguments.
    pub fn delete_job(&self) -> fluent_builders::DeleteJob<C, M, R> {
        fluent_builders::DeleteJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMLTransform` operation.
    ///
    /// See [`DeleteMLTransform`](crate::client::fluent_builders::DeleteMLTransform) for more information about the
    /// operation and its arguments.
    pub fn delete_ml_transform(&self) -> fluent_builders::DeleteMLTransform<C, M, R> {
        fluent_builders::DeleteMLTransform::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePartition` operation.
    ///
    /// See [`DeletePartition`](crate::client::fluent_builders::DeletePartition) for more information about the
    /// operation and its arguments.
    pub fn delete_partition(&self) -> fluent_builders::DeletePartition<C, M, R> {
        fluent_builders::DeletePartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePartitionIndex` operation.
    ///
    /// See [`DeletePartitionIndex`](crate::client::fluent_builders::DeletePartitionIndex) for more information about the
    /// operation and its arguments.
    pub fn delete_partition_index(&self) -> fluent_builders::DeletePartitionIndex<C, M, R> {
        fluent_builders::DeletePartitionIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRegistry` operation.
    ///
    /// See [`DeleteRegistry`](crate::client::fluent_builders::DeleteRegistry) for more information about the
    /// operation and its arguments.
    pub fn delete_registry(&self) -> fluent_builders::DeleteRegistry<C, M, R> {
        fluent_builders::DeleteRegistry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourcePolicy` operation.
    ///
    /// See [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy<C, M, R> {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSchema` operation.
    ///
    /// See [`DeleteSchema`](crate::client::fluent_builders::DeleteSchema) for more information about the
    /// operation and its arguments.
    pub fn delete_schema(&self) -> fluent_builders::DeleteSchema<C, M, R> {
        fluent_builders::DeleteSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSchemaVersions` operation.
    ///
    /// See [`DeleteSchemaVersions`](crate::client::fluent_builders::DeleteSchemaVersions) for more information about the
    /// operation and its arguments.
    pub fn delete_schema_versions(&self) -> fluent_builders::DeleteSchemaVersions<C, M, R> {
        fluent_builders::DeleteSchemaVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSecurityConfiguration` operation.
    ///
    /// See [`DeleteSecurityConfiguration`](crate::client::fluent_builders::DeleteSecurityConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_security_configuration(
        &self,
    ) -> fluent_builders::DeleteSecurityConfiguration<C, M, R> {
        fluent_builders::DeleteSecurityConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTable` operation.
    ///
    /// See [`DeleteTable`](crate::client::fluent_builders::DeleteTable) for more information about the
    /// operation and its arguments.
    pub fn delete_table(&self) -> fluent_builders::DeleteTable<C, M, R> {
        fluent_builders::DeleteTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTableVersion` operation.
    ///
    /// See [`DeleteTableVersion`](crate::client::fluent_builders::DeleteTableVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_table_version(&self) -> fluent_builders::DeleteTableVersion<C, M, R> {
        fluent_builders::DeleteTableVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrigger` operation.
    ///
    /// See [`DeleteTrigger`](crate::client::fluent_builders::DeleteTrigger) for more information about the
    /// operation and its arguments.
    pub fn delete_trigger(&self) -> fluent_builders::DeleteTrigger<C, M, R> {
        fluent_builders::DeleteTrigger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUserDefinedFunction` operation.
    ///
    /// See [`DeleteUserDefinedFunction`](crate::client::fluent_builders::DeleteUserDefinedFunction) for more information about the
    /// operation and its arguments.
    pub fn delete_user_defined_function(
        &self,
    ) -> fluent_builders::DeleteUserDefinedFunction<C, M, R> {
        fluent_builders::DeleteUserDefinedFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkflow` operation.
    ///
    /// See [`DeleteWorkflow`](crate::client::fluent_builders::DeleteWorkflow) for more information about the
    /// operation and its arguments.
    pub fn delete_workflow(&self) -> fluent_builders::DeleteWorkflow<C, M, R> {
        fluent_builders::DeleteWorkflow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBlueprint` operation.
    ///
    /// See [`GetBlueprint`](crate::client::fluent_builders::GetBlueprint) for more information about the
    /// operation and its arguments.
    pub fn get_blueprint(&self) -> fluent_builders::GetBlueprint<C, M, R> {
        fluent_builders::GetBlueprint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBlueprintRun` operation.
    ///
    /// See [`GetBlueprintRun`](crate::client::fluent_builders::GetBlueprintRun) for more information about the
    /// operation and its arguments.
    pub fn get_blueprint_run(&self) -> fluent_builders::GetBlueprintRun<C, M, R> {
        fluent_builders::GetBlueprintRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBlueprintRuns` operation.
    ///
    /// See [`GetBlueprintRuns`](crate::client::fluent_builders::GetBlueprintRuns) for more information about the
    /// operation and its arguments.
    pub fn get_blueprint_runs(&self) -> fluent_builders::GetBlueprintRuns<C, M, R> {
        fluent_builders::GetBlueprintRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCatalogImportStatus` operation.
    ///
    /// See [`GetCatalogImportStatus`](crate::client::fluent_builders::GetCatalogImportStatus) for more information about the
    /// operation and its arguments.
    pub fn get_catalog_import_status(&self) -> fluent_builders::GetCatalogImportStatus<C, M, R> {
        fluent_builders::GetCatalogImportStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetClassifier` operation.
    ///
    /// See [`GetClassifier`](crate::client::fluent_builders::GetClassifier) for more information about the
    /// operation and its arguments.
    pub fn get_classifier(&self) -> fluent_builders::GetClassifier<C, M, R> {
        fluent_builders::GetClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetClassifiers` operation.
    ///
    /// See [`GetClassifiers`](crate::client::fluent_builders::GetClassifiers) for more information about the
    /// operation and its arguments.
    pub fn get_classifiers(&self) -> fluent_builders::GetClassifiers<C, M, R> {
        fluent_builders::GetClassifiers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetColumnStatisticsForPartition` operation.
    ///
    /// See [`GetColumnStatisticsForPartition`](crate::client::fluent_builders::GetColumnStatisticsForPartition) for more information about the
    /// operation and its arguments.
    pub fn get_column_statistics_for_partition(
        &self,
    ) -> fluent_builders::GetColumnStatisticsForPartition<C, M, R> {
        fluent_builders::GetColumnStatisticsForPartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetColumnStatisticsForTable` operation.
    ///
    /// See [`GetColumnStatisticsForTable`](crate::client::fluent_builders::GetColumnStatisticsForTable) for more information about the
    /// operation and its arguments.
    pub fn get_column_statistics_for_table(
        &self,
    ) -> fluent_builders::GetColumnStatisticsForTable<C, M, R> {
        fluent_builders::GetColumnStatisticsForTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnection` operation.
    ///
    /// See [`GetConnection`](crate::client::fluent_builders::GetConnection) for more information about the
    /// operation and its arguments.
    pub fn get_connection(&self) -> fluent_builders::GetConnection<C, M, R> {
        fluent_builders::GetConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetConnections` operation.
    ///
    /// See [`GetConnections`](crate::client::fluent_builders::GetConnections) for more information about the
    /// operation and its arguments.
    pub fn get_connections(&self) -> fluent_builders::GetConnections<C, M, R> {
        fluent_builders::GetConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCrawler` operation.
    ///
    /// See [`GetCrawler`](crate::client::fluent_builders::GetCrawler) for more information about the
    /// operation and its arguments.
    pub fn get_crawler(&self) -> fluent_builders::GetCrawler<C, M, R> {
        fluent_builders::GetCrawler::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCrawlerMetrics` operation.
    ///
    /// See [`GetCrawlerMetrics`](crate::client::fluent_builders::GetCrawlerMetrics) for more information about the
    /// operation and its arguments.
    pub fn get_crawler_metrics(&self) -> fluent_builders::GetCrawlerMetrics<C, M, R> {
        fluent_builders::GetCrawlerMetrics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCrawlers` operation.
    ///
    /// See [`GetCrawlers`](crate::client::fluent_builders::GetCrawlers) for more information about the
    /// operation and its arguments.
    pub fn get_crawlers(&self) -> fluent_builders::GetCrawlers<C, M, R> {
        fluent_builders::GetCrawlers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDatabase` operation.
    ///
    /// See [`GetDatabase`](crate::client::fluent_builders::GetDatabase) for more information about the
    /// operation and its arguments.
    pub fn get_database(&self) -> fluent_builders::GetDatabase<C, M, R> {
        fluent_builders::GetDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDatabases` operation.
    ///
    /// See [`GetDatabases`](crate::client::fluent_builders::GetDatabases) for more information about the
    /// operation and its arguments.
    pub fn get_databases(&self) -> fluent_builders::GetDatabases<C, M, R> {
        fluent_builders::GetDatabases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDataCatalogEncryptionSettings` operation.
    ///
    /// See [`GetDataCatalogEncryptionSettings`](crate::client::fluent_builders::GetDataCatalogEncryptionSettings) for more information about the
    /// operation and its arguments.
    pub fn get_data_catalog_encryption_settings(
        &self,
    ) -> fluent_builders::GetDataCatalogEncryptionSettings<C, M, R> {
        fluent_builders::GetDataCatalogEncryptionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDataflowGraph` operation.
    ///
    /// See [`GetDataflowGraph`](crate::client::fluent_builders::GetDataflowGraph) for more information about the
    /// operation and its arguments.
    pub fn get_dataflow_graph(&self) -> fluent_builders::GetDataflowGraph<C, M, R> {
        fluent_builders::GetDataflowGraph::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDevEndpoint` operation.
    ///
    /// See [`GetDevEndpoint`](crate::client::fluent_builders::GetDevEndpoint) for more information about the
    /// operation and its arguments.
    pub fn get_dev_endpoint(&self) -> fluent_builders::GetDevEndpoint<C, M, R> {
        fluent_builders::GetDevEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDevEndpoints` operation.
    ///
    /// See [`GetDevEndpoints`](crate::client::fluent_builders::GetDevEndpoints) for more information about the
    /// operation and its arguments.
    pub fn get_dev_endpoints(&self) -> fluent_builders::GetDevEndpoints<C, M, R> {
        fluent_builders::GetDevEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJob` operation.
    ///
    /// See [`GetJob`](crate::client::fluent_builders::GetJob) for more information about the
    /// operation and its arguments.
    pub fn get_job(&self) -> fluent_builders::GetJob<C, M, R> {
        fluent_builders::GetJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJobBookmark` operation.
    ///
    /// See [`GetJobBookmark`](crate::client::fluent_builders::GetJobBookmark) for more information about the
    /// operation and its arguments.
    pub fn get_job_bookmark(&self) -> fluent_builders::GetJobBookmark<C, M, R> {
        fluent_builders::GetJobBookmark::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJobRun` operation.
    ///
    /// See [`GetJobRun`](crate::client::fluent_builders::GetJobRun) for more information about the
    /// operation and its arguments.
    pub fn get_job_run(&self) -> fluent_builders::GetJobRun<C, M, R> {
        fluent_builders::GetJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJobRuns` operation.
    ///
    /// See [`GetJobRuns`](crate::client::fluent_builders::GetJobRuns) for more information about the
    /// operation and its arguments.
    pub fn get_job_runs(&self) -> fluent_builders::GetJobRuns<C, M, R> {
        fluent_builders::GetJobRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJobs` operation.
    ///
    /// See [`GetJobs`](crate::client::fluent_builders::GetJobs) for more information about the
    /// operation and its arguments.
    pub fn get_jobs(&self) -> fluent_builders::GetJobs<C, M, R> {
        fluent_builders::GetJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMapping` operation.
    ///
    /// See [`GetMapping`](crate::client::fluent_builders::GetMapping) for more information about the
    /// operation and its arguments.
    pub fn get_mapping(&self) -> fluent_builders::GetMapping<C, M, R> {
        fluent_builders::GetMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMLTaskRun` operation.
    ///
    /// See [`GetMLTaskRun`](crate::client::fluent_builders::GetMLTaskRun) for more information about the
    /// operation and its arguments.
    pub fn get_ml_task_run(&self) -> fluent_builders::GetMLTaskRun<C, M, R> {
        fluent_builders::GetMLTaskRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMLTaskRuns` operation.
    ///
    /// See [`GetMLTaskRuns`](crate::client::fluent_builders::GetMLTaskRuns) for more information about the
    /// operation and its arguments.
    pub fn get_ml_task_runs(&self) -> fluent_builders::GetMLTaskRuns<C, M, R> {
        fluent_builders::GetMLTaskRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMLTransform` operation.
    ///
    /// See [`GetMLTransform`](crate::client::fluent_builders::GetMLTransform) for more information about the
    /// operation and its arguments.
    pub fn get_ml_transform(&self) -> fluent_builders::GetMLTransform<C, M, R> {
        fluent_builders::GetMLTransform::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMLTransforms` operation.
    ///
    /// See [`GetMLTransforms`](crate::client::fluent_builders::GetMLTransforms) for more information about the
    /// operation and its arguments.
    pub fn get_ml_transforms(&self) -> fluent_builders::GetMLTransforms<C, M, R> {
        fluent_builders::GetMLTransforms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPartition` operation.
    ///
    /// See [`GetPartition`](crate::client::fluent_builders::GetPartition) for more information about the
    /// operation and its arguments.
    pub fn get_partition(&self) -> fluent_builders::GetPartition<C, M, R> {
        fluent_builders::GetPartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPartitionIndexes` operation.
    ///
    /// See [`GetPartitionIndexes`](crate::client::fluent_builders::GetPartitionIndexes) for more information about the
    /// operation and its arguments.
    pub fn get_partition_indexes(&self) -> fluent_builders::GetPartitionIndexes<C, M, R> {
        fluent_builders::GetPartitionIndexes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPartitions` operation.
    ///
    /// See [`GetPartitions`](crate::client::fluent_builders::GetPartitions) for more information about the
    /// operation and its arguments.
    pub fn get_partitions(&self) -> fluent_builders::GetPartitions<C, M, R> {
        fluent_builders::GetPartitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPlan` operation.
    ///
    /// See [`GetPlan`](crate::client::fluent_builders::GetPlan) for more information about the
    /// operation and its arguments.
    pub fn get_plan(&self) -> fluent_builders::GetPlan<C, M, R> {
        fluent_builders::GetPlan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRegistry` operation.
    ///
    /// See [`GetRegistry`](crate::client::fluent_builders::GetRegistry) for more information about the
    /// operation and its arguments.
    pub fn get_registry(&self) -> fluent_builders::GetRegistry<C, M, R> {
        fluent_builders::GetRegistry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourcePolicies` operation.
    ///
    /// See [`GetResourcePolicies`](crate::client::fluent_builders::GetResourcePolicies) for more information about the
    /// operation and its arguments.
    pub fn get_resource_policies(&self) -> fluent_builders::GetResourcePolicies<C, M, R> {
        fluent_builders::GetResourcePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourcePolicy` operation.
    ///
    /// See [`GetResourcePolicy`](crate::client::fluent_builders::GetResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_resource_policy(&self) -> fluent_builders::GetResourcePolicy<C, M, R> {
        fluent_builders::GetResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSchema` operation.
    ///
    /// See [`GetSchema`](crate::client::fluent_builders::GetSchema) for more information about the
    /// operation and its arguments.
    pub fn get_schema(&self) -> fluent_builders::GetSchema<C, M, R> {
        fluent_builders::GetSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSchemaByDefinition` operation.
    ///
    /// See [`GetSchemaByDefinition`](crate::client::fluent_builders::GetSchemaByDefinition) for more information about the
    /// operation and its arguments.
    pub fn get_schema_by_definition(&self) -> fluent_builders::GetSchemaByDefinition<C, M, R> {
        fluent_builders::GetSchemaByDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSchemaVersion` operation.
    ///
    /// See [`GetSchemaVersion`](crate::client::fluent_builders::GetSchemaVersion) for more information about the
    /// operation and its arguments.
    pub fn get_schema_version(&self) -> fluent_builders::GetSchemaVersion<C, M, R> {
        fluent_builders::GetSchemaVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSchemaVersionsDiff` operation.
    ///
    /// See [`GetSchemaVersionsDiff`](crate::client::fluent_builders::GetSchemaVersionsDiff) for more information about the
    /// operation and its arguments.
    pub fn get_schema_versions_diff(&self) -> fluent_builders::GetSchemaVersionsDiff<C, M, R> {
        fluent_builders::GetSchemaVersionsDiff::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSecurityConfiguration` operation.
    ///
    /// See [`GetSecurityConfiguration`](crate::client::fluent_builders::GetSecurityConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_security_configuration(&self) -> fluent_builders::GetSecurityConfiguration<C, M, R> {
        fluent_builders::GetSecurityConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSecurityConfigurations` operation.
    ///
    /// See [`GetSecurityConfigurations`](crate::client::fluent_builders::GetSecurityConfigurations) for more information about the
    /// operation and its arguments.
    pub fn get_security_configurations(
        &self,
    ) -> fluent_builders::GetSecurityConfigurations<C, M, R> {
        fluent_builders::GetSecurityConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTable` operation.
    ///
    /// See [`GetTable`](crate::client::fluent_builders::GetTable) for more information about the
    /// operation and its arguments.
    pub fn get_table(&self) -> fluent_builders::GetTable<C, M, R> {
        fluent_builders::GetTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTables` operation.
    ///
    /// See [`GetTables`](crate::client::fluent_builders::GetTables) for more information about the
    /// operation and its arguments.
    pub fn get_tables(&self) -> fluent_builders::GetTables<C, M, R> {
        fluent_builders::GetTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTableVersion` operation.
    ///
    /// See [`GetTableVersion`](crate::client::fluent_builders::GetTableVersion) for more information about the
    /// operation and its arguments.
    pub fn get_table_version(&self) -> fluent_builders::GetTableVersion<C, M, R> {
        fluent_builders::GetTableVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTableVersions` operation.
    ///
    /// See [`GetTableVersions`](crate::client::fluent_builders::GetTableVersions) for more information about the
    /// operation and its arguments.
    pub fn get_table_versions(&self) -> fluent_builders::GetTableVersions<C, M, R> {
        fluent_builders::GetTableVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTags` operation.
    ///
    /// See [`GetTags`](crate::client::fluent_builders::GetTags) for more information about the
    /// operation and its arguments.
    pub fn get_tags(&self) -> fluent_builders::GetTags<C, M, R> {
        fluent_builders::GetTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTrigger` operation.
    ///
    /// See [`GetTrigger`](crate::client::fluent_builders::GetTrigger) for more information about the
    /// operation and its arguments.
    pub fn get_trigger(&self) -> fluent_builders::GetTrigger<C, M, R> {
        fluent_builders::GetTrigger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTriggers` operation.
    ///
    /// See [`GetTriggers`](crate::client::fluent_builders::GetTriggers) for more information about the
    /// operation and its arguments.
    pub fn get_triggers(&self) -> fluent_builders::GetTriggers<C, M, R> {
        fluent_builders::GetTriggers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUserDefinedFunction` operation.
    ///
    /// See [`GetUserDefinedFunction`](crate::client::fluent_builders::GetUserDefinedFunction) for more information about the
    /// operation and its arguments.
    pub fn get_user_defined_function(&self) -> fluent_builders::GetUserDefinedFunction<C, M, R> {
        fluent_builders::GetUserDefinedFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUserDefinedFunctions` operation.
    ///
    /// See [`GetUserDefinedFunctions`](crate::client::fluent_builders::GetUserDefinedFunctions) for more information about the
    /// operation and its arguments.
    pub fn get_user_defined_functions(&self) -> fluent_builders::GetUserDefinedFunctions<C, M, R> {
        fluent_builders::GetUserDefinedFunctions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWorkflow` operation.
    ///
    /// See [`GetWorkflow`](crate::client::fluent_builders::GetWorkflow) for more information about the
    /// operation and its arguments.
    pub fn get_workflow(&self) -> fluent_builders::GetWorkflow<C, M, R> {
        fluent_builders::GetWorkflow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWorkflowRun` operation.
    ///
    /// See [`GetWorkflowRun`](crate::client::fluent_builders::GetWorkflowRun) for more information about the
    /// operation and its arguments.
    pub fn get_workflow_run(&self) -> fluent_builders::GetWorkflowRun<C, M, R> {
        fluent_builders::GetWorkflowRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWorkflowRunProperties` operation.
    ///
    /// See [`GetWorkflowRunProperties`](crate::client::fluent_builders::GetWorkflowRunProperties) for more information about the
    /// operation and its arguments.
    pub fn get_workflow_run_properties(
        &self,
    ) -> fluent_builders::GetWorkflowRunProperties<C, M, R> {
        fluent_builders::GetWorkflowRunProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWorkflowRuns` operation.
    ///
    /// See [`GetWorkflowRuns`](crate::client::fluent_builders::GetWorkflowRuns) for more information about the
    /// operation and its arguments.
    pub fn get_workflow_runs(&self) -> fluent_builders::GetWorkflowRuns<C, M, R> {
        fluent_builders::GetWorkflowRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportCatalogToGlue` operation.
    ///
    /// See [`ImportCatalogToGlue`](crate::client::fluent_builders::ImportCatalogToGlue) for more information about the
    /// operation and its arguments.
    pub fn import_catalog_to_glue(&self) -> fluent_builders::ImportCatalogToGlue<C, M, R> {
        fluent_builders::ImportCatalogToGlue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBlueprints` operation.
    ///
    /// See [`ListBlueprints`](crate::client::fluent_builders::ListBlueprints) for more information about the
    /// operation and its arguments.
    pub fn list_blueprints(&self) -> fluent_builders::ListBlueprints<C, M, R> {
        fluent_builders::ListBlueprints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCrawlers` operation.
    ///
    /// See [`ListCrawlers`](crate::client::fluent_builders::ListCrawlers) for more information about the
    /// operation and its arguments.
    pub fn list_crawlers(&self) -> fluent_builders::ListCrawlers<C, M, R> {
        fluent_builders::ListCrawlers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDevEndpoints` operation.
    ///
    /// See [`ListDevEndpoints`](crate::client::fluent_builders::ListDevEndpoints) for more information about the
    /// operation and its arguments.
    pub fn list_dev_endpoints(&self) -> fluent_builders::ListDevEndpoints<C, M, R> {
        fluent_builders::ListDevEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobs` operation.
    ///
    /// See [`ListJobs`](crate::client::fluent_builders::ListJobs) for more information about the
    /// operation and its arguments.
    pub fn list_jobs(&self) -> fluent_builders::ListJobs<C, M, R> {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMLTransforms` operation.
    ///
    /// See [`ListMLTransforms`](crate::client::fluent_builders::ListMLTransforms) for more information about the
    /// operation and its arguments.
    pub fn list_ml_transforms(&self) -> fluent_builders::ListMLTransforms<C, M, R> {
        fluent_builders::ListMLTransforms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRegistries` operation.
    ///
    /// See [`ListRegistries`](crate::client::fluent_builders::ListRegistries) for more information about the
    /// operation and its arguments.
    pub fn list_registries(&self) -> fluent_builders::ListRegistries<C, M, R> {
        fluent_builders::ListRegistries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSchemas` operation.
    ///
    /// See [`ListSchemas`](crate::client::fluent_builders::ListSchemas) for more information about the
    /// operation and its arguments.
    pub fn list_schemas(&self) -> fluent_builders::ListSchemas<C, M, R> {
        fluent_builders::ListSchemas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSchemaVersions` operation.
    ///
    /// See [`ListSchemaVersions`](crate::client::fluent_builders::ListSchemaVersions) for more information about the
    /// operation and its arguments.
    pub fn list_schema_versions(&self) -> fluent_builders::ListSchemaVersions<C, M, R> {
        fluent_builders::ListSchemaVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTriggers` operation.
    ///
    /// See [`ListTriggers`](crate::client::fluent_builders::ListTriggers) for more information about the
    /// operation and its arguments.
    pub fn list_triggers(&self) -> fluent_builders::ListTriggers<C, M, R> {
        fluent_builders::ListTriggers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkflows` operation.
    ///
    /// See [`ListWorkflows`](crate::client::fluent_builders::ListWorkflows) for more information about the
    /// operation and its arguments.
    pub fn list_workflows(&self) -> fluent_builders::ListWorkflows<C, M, R> {
        fluent_builders::ListWorkflows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutDataCatalogEncryptionSettings` operation.
    ///
    /// See [`PutDataCatalogEncryptionSettings`](crate::client::fluent_builders::PutDataCatalogEncryptionSettings) for more information about the
    /// operation and its arguments.
    pub fn put_data_catalog_encryption_settings(
        &self,
    ) -> fluent_builders::PutDataCatalogEncryptionSettings<C, M, R> {
        fluent_builders::PutDataCatalogEncryptionSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResourcePolicy` operation.
    ///
    /// See [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy<C, M, R> {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutSchemaVersionMetadata` operation.
    ///
    /// See [`PutSchemaVersionMetadata`](crate::client::fluent_builders::PutSchemaVersionMetadata) for more information about the
    /// operation and its arguments.
    pub fn put_schema_version_metadata(
        &self,
    ) -> fluent_builders::PutSchemaVersionMetadata<C, M, R> {
        fluent_builders::PutSchemaVersionMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutWorkflowRunProperties` operation.
    ///
    /// See [`PutWorkflowRunProperties`](crate::client::fluent_builders::PutWorkflowRunProperties) for more information about the
    /// operation and its arguments.
    pub fn put_workflow_run_properties(
        &self,
    ) -> fluent_builders::PutWorkflowRunProperties<C, M, R> {
        fluent_builders::PutWorkflowRunProperties::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `QuerySchemaVersionMetadata` operation.
    ///
    /// See [`QuerySchemaVersionMetadata`](crate::client::fluent_builders::QuerySchemaVersionMetadata) for more information about the
    /// operation and its arguments.
    pub fn query_schema_version_metadata(
        &self,
    ) -> fluent_builders::QuerySchemaVersionMetadata<C, M, R> {
        fluent_builders::QuerySchemaVersionMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterSchemaVersion` operation.
    ///
    /// See [`RegisterSchemaVersion`](crate::client::fluent_builders::RegisterSchemaVersion) for more information about the
    /// operation and its arguments.
    pub fn register_schema_version(&self) -> fluent_builders::RegisterSchemaVersion<C, M, R> {
        fluent_builders::RegisterSchemaVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveSchemaVersionMetadata` operation.
    ///
    /// See [`RemoveSchemaVersionMetadata`](crate::client::fluent_builders::RemoveSchemaVersionMetadata) for more information about the
    /// operation and its arguments.
    pub fn remove_schema_version_metadata(
        &self,
    ) -> fluent_builders::RemoveSchemaVersionMetadata<C, M, R> {
        fluent_builders::RemoveSchemaVersionMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetJobBookmark` operation.
    ///
    /// See [`ResetJobBookmark`](crate::client::fluent_builders::ResetJobBookmark) for more information about the
    /// operation and its arguments.
    pub fn reset_job_bookmark(&self) -> fluent_builders::ResetJobBookmark<C, M, R> {
        fluent_builders::ResetJobBookmark::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResumeWorkflowRun` operation.
    ///
    /// See [`ResumeWorkflowRun`](crate::client::fluent_builders::ResumeWorkflowRun) for more information about the
    /// operation and its arguments.
    pub fn resume_workflow_run(&self) -> fluent_builders::ResumeWorkflowRun<C, M, R> {
        fluent_builders::ResumeWorkflowRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchTables` operation.
    ///
    /// See [`SearchTables`](crate::client::fluent_builders::SearchTables) for more information about the
    /// operation and its arguments.
    pub fn search_tables(&self) -> fluent_builders::SearchTables<C, M, R> {
        fluent_builders::SearchTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartBlueprintRun` operation.
    ///
    /// See [`StartBlueprintRun`](crate::client::fluent_builders::StartBlueprintRun) for more information about the
    /// operation and its arguments.
    pub fn start_blueprint_run(&self) -> fluent_builders::StartBlueprintRun<C, M, R> {
        fluent_builders::StartBlueprintRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartCrawler` operation.
    ///
    /// See [`StartCrawler`](crate::client::fluent_builders::StartCrawler) for more information about the
    /// operation and its arguments.
    pub fn start_crawler(&self) -> fluent_builders::StartCrawler<C, M, R> {
        fluent_builders::StartCrawler::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartCrawlerSchedule` operation.
    ///
    /// See [`StartCrawlerSchedule`](crate::client::fluent_builders::StartCrawlerSchedule) for more information about the
    /// operation and its arguments.
    pub fn start_crawler_schedule(&self) -> fluent_builders::StartCrawlerSchedule<C, M, R> {
        fluent_builders::StartCrawlerSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartExportLabelsTaskRun` operation.
    ///
    /// See [`StartExportLabelsTaskRun`](crate::client::fluent_builders::StartExportLabelsTaskRun) for more information about the
    /// operation and its arguments.
    pub fn start_export_labels_task_run(
        &self,
    ) -> fluent_builders::StartExportLabelsTaskRun<C, M, R> {
        fluent_builders::StartExportLabelsTaskRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartImportLabelsTaskRun` operation.
    ///
    /// See [`StartImportLabelsTaskRun`](crate::client::fluent_builders::StartImportLabelsTaskRun) for more information about the
    /// operation and its arguments.
    pub fn start_import_labels_task_run(
        &self,
    ) -> fluent_builders::StartImportLabelsTaskRun<C, M, R> {
        fluent_builders::StartImportLabelsTaskRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartJobRun` operation.
    ///
    /// See [`StartJobRun`](crate::client::fluent_builders::StartJobRun) for more information about the
    /// operation and its arguments.
    pub fn start_job_run(&self) -> fluent_builders::StartJobRun<C, M, R> {
        fluent_builders::StartJobRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartMLEvaluationTaskRun` operation.
    ///
    /// See [`StartMLEvaluationTaskRun`](crate::client::fluent_builders::StartMLEvaluationTaskRun) for more information about the
    /// operation and its arguments.
    pub fn start_ml_evaluation_task_run(
        &self,
    ) -> fluent_builders::StartMLEvaluationTaskRun<C, M, R> {
        fluent_builders::StartMLEvaluationTaskRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartMLLabelingSetGenerationTaskRun` operation.
    ///
    /// See [`StartMLLabelingSetGenerationTaskRun`](crate::client::fluent_builders::StartMLLabelingSetGenerationTaskRun) for more information about the
    /// operation and its arguments.
    pub fn start_ml_labeling_set_generation_task_run(
        &self,
    ) -> fluent_builders::StartMLLabelingSetGenerationTaskRun<C, M, R> {
        fluent_builders::StartMLLabelingSetGenerationTaskRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartTrigger` operation.
    ///
    /// See [`StartTrigger`](crate::client::fluent_builders::StartTrigger) for more information about the
    /// operation and its arguments.
    pub fn start_trigger(&self) -> fluent_builders::StartTrigger<C, M, R> {
        fluent_builders::StartTrigger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartWorkflowRun` operation.
    ///
    /// See [`StartWorkflowRun`](crate::client::fluent_builders::StartWorkflowRun) for more information about the
    /// operation and its arguments.
    pub fn start_workflow_run(&self) -> fluent_builders::StartWorkflowRun<C, M, R> {
        fluent_builders::StartWorkflowRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopCrawler` operation.
    ///
    /// See [`StopCrawler`](crate::client::fluent_builders::StopCrawler) for more information about the
    /// operation and its arguments.
    pub fn stop_crawler(&self) -> fluent_builders::StopCrawler<C, M, R> {
        fluent_builders::StopCrawler::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopCrawlerSchedule` operation.
    ///
    /// See [`StopCrawlerSchedule`](crate::client::fluent_builders::StopCrawlerSchedule) for more information about the
    /// operation and its arguments.
    pub fn stop_crawler_schedule(&self) -> fluent_builders::StopCrawlerSchedule<C, M, R> {
        fluent_builders::StopCrawlerSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopTrigger` operation.
    ///
    /// See [`StopTrigger`](crate::client::fluent_builders::StopTrigger) for more information about the
    /// operation and its arguments.
    pub fn stop_trigger(&self) -> fluent_builders::StopTrigger<C, M, R> {
        fluent_builders::StopTrigger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopWorkflowRun` operation.
    ///
    /// See [`StopWorkflowRun`](crate::client::fluent_builders::StopWorkflowRun) for more information about the
    /// operation and its arguments.
    pub fn stop_workflow_run(&self) -> fluent_builders::StopWorkflowRun<C, M, R> {
        fluent_builders::StopWorkflowRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBlueprint` operation.
    ///
    /// See [`UpdateBlueprint`](crate::client::fluent_builders::UpdateBlueprint) for more information about the
    /// operation and its arguments.
    pub fn update_blueprint(&self) -> fluent_builders::UpdateBlueprint<C, M, R> {
        fluent_builders::UpdateBlueprint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateClassifier` operation.
    ///
    /// See [`UpdateClassifier`](crate::client::fluent_builders::UpdateClassifier) for more information about the
    /// operation and its arguments.
    pub fn update_classifier(&self) -> fluent_builders::UpdateClassifier<C, M, R> {
        fluent_builders::UpdateClassifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateColumnStatisticsForPartition` operation.
    ///
    /// See [`UpdateColumnStatisticsForPartition`](crate::client::fluent_builders::UpdateColumnStatisticsForPartition) for more information about the
    /// operation and its arguments.
    pub fn update_column_statistics_for_partition(
        &self,
    ) -> fluent_builders::UpdateColumnStatisticsForPartition<C, M, R> {
        fluent_builders::UpdateColumnStatisticsForPartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateColumnStatisticsForTable` operation.
    ///
    /// See [`UpdateColumnStatisticsForTable`](crate::client::fluent_builders::UpdateColumnStatisticsForTable) for more information about the
    /// operation and its arguments.
    pub fn update_column_statistics_for_table(
        &self,
    ) -> fluent_builders::UpdateColumnStatisticsForTable<C, M, R> {
        fluent_builders::UpdateColumnStatisticsForTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConnection` operation.
    ///
    /// See [`UpdateConnection`](crate::client::fluent_builders::UpdateConnection) for more information about the
    /// operation and its arguments.
    pub fn update_connection(&self) -> fluent_builders::UpdateConnection<C, M, R> {
        fluent_builders::UpdateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCrawler` operation.
    ///
    /// See [`UpdateCrawler`](crate::client::fluent_builders::UpdateCrawler) for more information about the
    /// operation and its arguments.
    pub fn update_crawler(&self) -> fluent_builders::UpdateCrawler<C, M, R> {
        fluent_builders::UpdateCrawler::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCrawlerSchedule` operation.
    ///
    /// See [`UpdateCrawlerSchedule`](crate::client::fluent_builders::UpdateCrawlerSchedule) for more information about the
    /// operation and its arguments.
    pub fn update_crawler_schedule(&self) -> fluent_builders::UpdateCrawlerSchedule<C, M, R> {
        fluent_builders::UpdateCrawlerSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDatabase` operation.
    ///
    /// See [`UpdateDatabase`](crate::client::fluent_builders::UpdateDatabase) for more information about the
    /// operation and its arguments.
    pub fn update_database(&self) -> fluent_builders::UpdateDatabase<C, M, R> {
        fluent_builders::UpdateDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDevEndpoint` operation.
    ///
    /// See [`UpdateDevEndpoint`](crate::client::fluent_builders::UpdateDevEndpoint) for more information about the
    /// operation and its arguments.
    pub fn update_dev_endpoint(&self) -> fluent_builders::UpdateDevEndpoint<C, M, R> {
        fluent_builders::UpdateDevEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateJob` operation.
    ///
    /// See [`UpdateJob`](crate::client::fluent_builders::UpdateJob) for more information about the
    /// operation and its arguments.
    pub fn update_job(&self) -> fluent_builders::UpdateJob<C, M, R> {
        fluent_builders::UpdateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMLTransform` operation.
    ///
    /// See [`UpdateMLTransform`](crate::client::fluent_builders::UpdateMLTransform) for more information about the
    /// operation and its arguments.
    pub fn update_ml_transform(&self) -> fluent_builders::UpdateMLTransform<C, M, R> {
        fluent_builders::UpdateMLTransform::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePartition` operation.
    ///
    /// See [`UpdatePartition`](crate::client::fluent_builders::UpdatePartition) for more information about the
    /// operation and its arguments.
    pub fn update_partition(&self) -> fluent_builders::UpdatePartition<C, M, R> {
        fluent_builders::UpdatePartition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRegistry` operation.
    ///
    /// See [`UpdateRegistry`](crate::client::fluent_builders::UpdateRegistry) for more information about the
    /// operation and its arguments.
    pub fn update_registry(&self) -> fluent_builders::UpdateRegistry<C, M, R> {
        fluent_builders::UpdateRegistry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSchema` operation.
    ///
    /// See [`UpdateSchema`](crate::client::fluent_builders::UpdateSchema) for more information about the
    /// operation and its arguments.
    pub fn update_schema(&self) -> fluent_builders::UpdateSchema<C, M, R> {
        fluent_builders::UpdateSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTable` operation.
    ///
    /// See [`UpdateTable`](crate::client::fluent_builders::UpdateTable) for more information about the
    /// operation and its arguments.
    pub fn update_table(&self) -> fluent_builders::UpdateTable<C, M, R> {
        fluent_builders::UpdateTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTrigger` operation.
    ///
    /// See [`UpdateTrigger`](crate::client::fluent_builders::UpdateTrigger) for more information about the
    /// operation and its arguments.
    pub fn update_trigger(&self) -> fluent_builders::UpdateTrigger<C, M, R> {
        fluent_builders::UpdateTrigger::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserDefinedFunction` operation.
    ///
    /// See [`UpdateUserDefinedFunction`](crate::client::fluent_builders::UpdateUserDefinedFunction) for more information about the
    /// operation and its arguments.
    pub fn update_user_defined_function(
        &self,
    ) -> fluent_builders::UpdateUserDefinedFunction<C, M, R> {
        fluent_builders::UpdateUserDefinedFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkflow` operation.
    ///
    /// See [`UpdateWorkflow`](crate::client::fluent_builders::UpdateWorkflow) for more information about the
    /// operation and its arguments.
    pub fn update_workflow(&self) -> fluent_builders::UpdateWorkflow<C, M, R> {
        fluent_builders::UpdateWorkflow::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchCreatePartition`.
    ///
    /// <p>Creates one or more partitions in a batch operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchCreatePartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_partition_input::Builder,
    }
    impl<C, M, R> BatchCreatePartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreatePartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreatePartitionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreatePartitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreatePartitionInputOperationOutputAlias,
                crate::output::BatchCreatePartitionOutput,
                crate::error::BatchCreatePartitionError,
                crate::input::BatchCreatePartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the catalog in which the partition is to be created. Currently, this should be
        /// the Amazon Web Services account ID.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the catalog in which the partition is to be created. Currently, this should be
        /// the Amazon Web Services account ID.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the metadata database in which the partition is
        /// to be created.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the metadata database in which the partition is
        /// to be created.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the metadata table in which the partition is to be created.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the metadata table in which the partition is to be created.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `PartitionInputList`.
        ///
        /// To override the contents of this collection use [`set_partition_input_list`](Self::set_partition_input_list).
        ///
        /// <p>A list of <code>PartitionInput</code> structures that define
        /// the partitions to be created.</p>
        pub fn partition_input_list(
            mut self,
            inp: impl Into<crate::model::PartitionInput>,
        ) -> Self {
            self.inner = self.inner.partition_input_list(inp);
            self
        }
        /// <p>A list of <code>PartitionInput</code> structures that define
        /// the partitions to be created.</p>
        pub fn set_partition_input_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartitionInput>>,
        ) -> Self {
            self.inner = self.inner.set_partition_input_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteConnection`.
    ///
    /// <p>Deletes a list of connection definitions from the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_connection_input::Builder,
    }
    impl<C, M, R> BatchDeleteConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteConnectionInputOperationOutputAlias,
                crate::output::BatchDeleteConnectionOutput,
                crate::error::BatchDeleteConnectionError,
                crate::input::BatchDeleteConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which the connections reside. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which the connections reside. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// Appends an item to `ConnectionNameList`.
        ///
        /// To override the contents of this collection use [`set_connection_name_list`](Self::set_connection_name_list).
        ///
        /// <p>A list of names of the connections to delete.</p>
        pub fn connection_name_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name_list(inp);
            self
        }
        /// <p>A list of names of the connections to delete.</p>
        pub fn set_connection_name_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_connection_name_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeletePartition`.
    ///
    /// <p>Deletes one or more partitions in a batch operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeletePartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_partition_input::Builder,
    }
    impl<C, M, R> BatchDeletePartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeletePartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeletePartitionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeletePartitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeletePartitionInputOperationOutputAlias,
                crate::output::BatchDeletePartitionOutput,
                crate::error::BatchDeletePartitionError,
                crate::input::BatchDeletePartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partition to be deleted resides. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partition to be deleted resides. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database in which the table in question
        /// resides.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database in which the table in question
        /// resides.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the table that contains the partitions to be deleted.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table that contains the partitions to be deleted.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `PartitionsToDelete`.
        ///
        /// To override the contents of this collection use [`set_partitions_to_delete`](Self::set_partitions_to_delete).
        ///
        /// <p>A list of <code>PartitionInput</code> structures that define
        /// the partitions to be deleted.</p>
        pub fn partitions_to_delete(
            mut self,
            inp: impl Into<crate::model::PartitionValueList>,
        ) -> Self {
            self.inner = self.inner.partitions_to_delete(inp);
            self
        }
        /// <p>A list of <code>PartitionInput</code> structures that define
        /// the partitions to be deleted.</p>
        pub fn set_partitions_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartitionValueList>>,
        ) -> Self {
            self.inner = self.inner.set_partitions_to_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteTable`.
    ///
    /// <p>Deletes multiple tables at once.</p>
    /// <note>
    /// <p>After completing this operation, you no longer have access to the table versions and
    /// partitions that belong to the deleted table. Glue deletes these "orphaned" resources
    /// asynchronously in a timely manner, at the discretion of the service.</p>
    /// <p>To ensure the immediate deletion of all related resources, before calling
    /// <code>BatchDeleteTable</code>, use <code>DeleteTableVersion</code> or
    /// <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
    /// <code>BatchDeletePartition</code>, to delete any resources that belong to the
    /// table.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_table_input::Builder,
    }
    impl<C, M, R> BatchDeleteTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteTableOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteTableInputOperationOutputAlias,
                crate::output::BatchDeleteTableOutput,
                crate::error::BatchDeleteTableError,
                crate::input::BatchDeleteTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database in which the tables to delete reside. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database in which the tables to delete reside. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// Appends an item to `TablesToDelete`.
        ///
        /// To override the contents of this collection use [`set_tables_to_delete`](Self::set_tables_to_delete).
        ///
        /// <p>A list of the table to delete.</p>
        pub fn tables_to_delete(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tables_to_delete(inp);
            self
        }
        /// <p>A list of the table to delete.</p>
        pub fn set_tables_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tables_to_delete(input);
            self
        }
        /// <p>The transaction ID at which to delete the table contents.</p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The transaction ID at which to delete the table contents.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteTableVersion`.
    ///
    /// <p>Deletes a specified batch of versions of a table.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteTableVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_table_version_input::Builder,
    }
    impl<C, M, R> BatchDeleteTableVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteTableVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteTableVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteTableVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteTableVersionInputOperationOutputAlias,
                crate::output::BatchDeleteTableVersionOutput,
                crate::error::BatchDeleteTableVersionError,
                crate::input::BatchDeleteTableVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database in the catalog in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The database in the catalog in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the table. For Hive compatibility,
        /// this name is entirely lowercase.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table. For Hive compatibility,
        /// this name is entirely lowercase.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `VersionIds`.
        ///
        /// To override the contents of this collection use [`set_version_ids`](Self::set_version_ids).
        ///
        /// <p>A list of the IDs of versions to be deleted. A <code>VersionId</code> is a string representation of an integer. Each version is incremented by 1.</p>
        pub fn version_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_ids(inp);
            self
        }
        /// <p>A list of the IDs of versions to be deleted. A <code>VersionId</code> is a string representation of an integer. Each version is incremented by 1.</p>
        pub fn set_version_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_version_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetBlueprints`.
    ///
    /// <p>Retrieves information about a list of blueprints.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetBlueprints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_blueprints_input::Builder,
    }
    impl<C, M, R> BatchGetBlueprints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetBlueprints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetBlueprintsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetBlueprintsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetBlueprintsInputOperationOutputAlias,
                crate::output::BatchGetBlueprintsOutput,
                crate::error::BatchGetBlueprintsError,
                crate::input::BatchGetBlueprintsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A list of blueprint names.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>A list of blueprint names.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>Specifies whether or not to include the blueprint in the response.</p>
        pub fn include_blueprint(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_blueprint(inp);
            self
        }
        /// <p>Specifies whether or not to include the blueprint in the response.</p>
        pub fn set_include_blueprint(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_blueprint(input);
            self
        }
        /// <p>Specifies whether or not to include the parameters, as a JSON string, for the blueprint in the response.</p>
        pub fn include_parameter_spec(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_parameter_spec(inp);
            self
        }
        /// <p>Specifies whether or not to include the parameters, as a JSON string, for the blueprint in the response.</p>
        pub fn set_include_parameter_spec(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_parameter_spec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetCrawlers`.
    ///
    /// <p>Returns a list of resource metadata for a given list of crawler names. After calling the <code>ListCrawlers</code> operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetCrawlers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_crawlers_input::Builder,
    }
    impl<C, M, R> BatchGetCrawlers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetCrawlers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetCrawlersOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetCrawlersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetCrawlersInputOperationOutputAlias,
                crate::output::BatchGetCrawlersOutput,
                crate::error::BatchGetCrawlersError,
                crate::input::BatchGetCrawlersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `CrawlerNames`.
        ///
        /// To override the contents of this collection use [`set_crawler_names`](Self::set_crawler_names).
        ///
        /// <p>A list of crawler names, which might be the names returned from the
        /// <code>ListCrawlers</code> operation.</p>
        pub fn crawler_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.crawler_names(inp);
            self
        }
        /// <p>A list of crawler names, which might be the names returned from the
        /// <code>ListCrawlers</code> operation.</p>
        pub fn set_crawler_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_crawler_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDevEndpoints`.
    ///
    /// <p>Returns a list of resource metadata for a given list of development endpoint names. After
    /// calling the <code>ListDevEndpoints</code> operation, you can call this operation to access the
    /// data to which you have been granted permissions. This operation supports all IAM permissions,
    /// including permission conditions that uses tags.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetDevEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_dev_endpoints_input::Builder,
    }
    impl<C, M, R> BatchGetDevEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetDevEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDevEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDevEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetDevEndpointsInputOperationOutputAlias,
                crate::output::BatchGetDevEndpointsOutput,
                crate::error::BatchGetDevEndpointsError,
                crate::input::BatchGetDevEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DevEndpointNames`.
        ///
        /// To override the contents of this collection use [`set_dev_endpoint_names`](Self::set_dev_endpoint_names).
        ///
        /// <p>The list of <code>DevEndpoint</code> names, which might be the names returned from the
        /// <code>ListDevEndpoint</code> operation.</p>
        pub fn dev_endpoint_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dev_endpoint_names(inp);
            self
        }
        /// <p>The list of <code>DevEndpoint</code> names, which might be the names returned from the
        /// <code>ListDevEndpoint</code> operation.</p>
        pub fn set_dev_endpoint_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_dev_endpoint_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetJobs`.
    ///
    /// <p>Returns a list of resource metadata for a given list of job names. After calling the <code>ListJobs</code> operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_jobs_input::Builder,
    }
    impl<C, M, R> BatchGetJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetJobsInputOperationOutputAlias,
                crate::output::BatchGetJobsOutput,
                crate::error::BatchGetJobsError,
                crate::input::BatchGetJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `JobNames`.
        ///
        /// To override the contents of this collection use [`set_job_names`](Self::set_job_names).
        ///
        /// <p>A list of job names, which might be the names returned from the <code>ListJobs</code>
        /// operation.</p>
        pub fn job_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_names(inp);
            self
        }
        /// <p>A list of job names, which might be the names returned from the <code>ListJobs</code>
        /// operation.</p>
        pub fn set_job_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_job_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetPartition`.
    ///
    /// <p>Retrieves partitions in a batch request.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetPartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_partition_input::Builder,
    }
    impl<C, M, R> BatchGetPartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetPartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetPartitionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetPartitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetPartitionInputOperationOutputAlias,
                crate::output::BatchGetPartitionOutput,
                crate::error::BatchGetPartitionError,
                crate::input::BatchGetPartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `PartitionsToGet`.
        ///
        /// To override the contents of this collection use [`set_partitions_to_get`](Self::set_partitions_to_get).
        ///
        /// <p>A list of partition values identifying the partitions to retrieve.</p>
        pub fn partitions_to_get(
            mut self,
            inp: impl Into<crate::model::PartitionValueList>,
        ) -> Self {
            self.inner = self.inner.partitions_to_get(inp);
            self
        }
        /// <p>A list of partition values identifying the partitions to retrieve.</p>
        pub fn set_partitions_to_get(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartitionValueList>>,
        ) -> Self {
            self.inner = self.inner.set_partitions_to_get(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetTriggers`.
    ///
    /// <p>Returns a list of resource metadata for a given list of trigger names. After calling the <code>ListTriggers</code> operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetTriggers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_triggers_input::Builder,
    }
    impl<C, M, R> BatchGetTriggers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetTriggers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetTriggersOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetTriggersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetTriggersInputOperationOutputAlias,
                crate::output::BatchGetTriggersOutput,
                crate::error::BatchGetTriggersError,
                crate::input::BatchGetTriggersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TriggerNames`.
        ///
        /// To override the contents of this collection use [`set_trigger_names`](Self::set_trigger_names).
        ///
        /// <p>A list of trigger names, which may be the names returned from the <code>ListTriggers</code> operation.</p>
        pub fn trigger_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trigger_names(inp);
            self
        }
        /// <p>A list of trigger names, which may be the names returned from the <code>ListTriggers</code> operation.</p>
        pub fn set_trigger_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_trigger_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetWorkflows`.
    ///
    /// <p>Returns a list of resource metadata for a given list of workflow names. After calling the <code>ListWorkflows</code> operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetWorkflows<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_workflows_input::Builder,
    }
    impl<C, M, R> BatchGetWorkflows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetWorkflows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetWorkflowsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetWorkflowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetWorkflowsInputOperationOutputAlias,
                crate::output::BatchGetWorkflowsOutput,
                crate::error::BatchGetWorkflowsError,
                crate::input::BatchGetWorkflowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>A list of workflow names, which may be the names returned from the <code>ListWorkflows</code> operation.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>A list of workflow names, which may be the names returned from the <code>ListWorkflows</code> operation.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>Specifies whether to include a graph when returning the workflow resource metadata.</p>
        pub fn include_graph(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_graph(inp);
            self
        }
        /// <p>Specifies whether to include a graph when returning the workflow resource metadata.</p>
        pub fn set_include_graph(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_graph(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchStopJobRun`.
    ///
    /// <p>Stops one or more job runs for a specified job definition.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchStopJobRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_stop_job_run_input::Builder,
    }
    impl<C, M, R> BatchStopJobRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchStopJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchStopJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchStopJobRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchStopJobRunInputOperationOutputAlias,
                crate::output::BatchStopJobRunOutput,
                crate::error::BatchStopJobRunError,
                crate::input::BatchStopJobRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job definition for which to stop job runs.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the job definition for which to stop job runs.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// Appends an item to `JobRunIds`.
        ///
        /// To override the contents of this collection use [`set_job_run_ids`](Self::set_job_run_ids).
        ///
        /// <p>A list of the <code>JobRunIds</code> that should be stopped for that job
        /// definition.</p>
        pub fn job_run_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_run_ids(inp);
            self
        }
        /// <p>A list of the <code>JobRunIds</code> that should be stopped for that job
        /// definition.</p>
        pub fn set_job_run_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_job_run_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpdatePartition`.
    ///
    /// <p>Updates one or more partitions in a batch operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchUpdatePartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_update_partition_input::Builder,
    }
    impl<C, M, R> BatchUpdatePartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpdatePartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdatePartitionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdatePartitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpdatePartitionInputOperationOutputAlias,
                crate::output::BatchUpdatePartitionOutput,
                crate::error::BatchUpdatePartitionError,
                crate::input::BatchUpdatePartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the catalog in which the partition is to be updated. Currently, this should be
        /// the Amazon Web Services account ID.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the catalog in which the partition is to be updated. Currently, this should be
        /// the Amazon Web Services account ID.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the metadata database in which the partition is
        /// to be updated.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the metadata database in which the partition is
        /// to be updated.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the metadata table in which the partition is to be updated.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the metadata table in which the partition is to be updated.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>A list of up to 100 <code>BatchUpdatePartitionRequestEntry</code> objects to update.</p>
        pub fn entries(
            mut self,
            inp: impl Into<crate::model::BatchUpdatePartitionRequestEntry>,
        ) -> Self {
            self.inner = self.inner.entries(inp);
            self
        }
        /// <p>A list of up to 100 <code>BatchUpdatePartitionRequestEntry</code> objects to update.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BatchUpdatePartitionRequestEntry>,
            >,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelMLTaskRun`.
    ///
    /// <p>Cancels (stops) a task run. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as part of various machine learning workflows. You can cancel a
    /// machine learning task run at any time by calling <code>CancelMLTaskRun</code> with a task
    /// run's parent transform's <code>TransformID</code> and the task run's <code>TaskRunId</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct CancelMLTaskRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_ml_task_run_input::Builder,
    }
    impl<C, M, R> CancelMLTaskRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelMLTaskRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelMlTaskRunOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelMLTaskRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelMlTaskRunInputOperationOutputAlias,
                crate::output::CancelMlTaskRunOutput,
                crate::error::CancelMLTaskRunError,
                crate::input::CancelMlTaskRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn transform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_id(inp);
            self
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_transform_id(input);
            self
        }
        /// <p>A unique identifier for the task run.</p>
        pub fn task_run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_run_id(inp);
            self
        }
        /// <p>A unique identifier for the task run.</p>
        pub fn set_task_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckSchemaVersionValidity`.
    ///
    /// <p>Validates the supplied schema. This call has no side effects, it simply validates using the supplied schema using <code>DataFormat</code> as the format. Since it does not take a schema set name, no compatibility checks are performed.</p>
    #[derive(std::fmt::Debug)]
    pub struct CheckSchemaVersionValidity<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::check_schema_version_validity_input::Builder,
    }
    impl<C, M, R> CheckSchemaVersionValidity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckSchemaVersionValidity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckSchemaVersionValidityOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckSchemaVersionValidityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckSchemaVersionValidityInputOperationOutputAlias,
                crate::output::CheckSchemaVersionValidityOutput,
                crate::error::CheckSchemaVersionValidityError,
                crate::input::CheckSchemaVersionValidityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn data_format(mut self, inp: crate::model::DataFormat) -> Self {
            self.inner = self.inner.data_format(inp);
            self
        }
        /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::DataFormat>,
        ) -> Self {
            self.inner = self.inner.set_data_format(input);
            self
        }
        /// <p>The definition of the schema that has to be validated.</p>
        pub fn schema_definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_definition(inp);
            self
        }
        /// <p>The definition of the schema that has to be validated.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBlueprint`.
    ///
    /// <p>Registers a blueprint with Glue.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBlueprint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_blueprint_input::Builder,
    }
    impl<C, M, R> CreateBlueprint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBlueprint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBlueprintOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBlueprintError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBlueprintInputOperationOutputAlias,
                crate::output::CreateBlueprintOutput,
                crate::error::CreateBlueprintError,
                crate::input::CreateBlueprintInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the blueprint.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the blueprint.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the blueprint.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the blueprint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies a path in Amazon S3 where the blueprint is published.</p>
        pub fn blueprint_location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blueprint_location(inp);
            self
        }
        /// <p>Specifies a path in Amazon S3 where the blueprint is published.</p>
        pub fn set_blueprint_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_blueprint_location(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be applied to this blueprint.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be applied to this blueprint.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClassifier`.
    ///
    /// <p>Creates a classifier in the user's account. This can be a <code>GrokClassifier</code>, an
    /// <code>XMLClassifier</code>, a <code>JsonClassifier</code>, or a <code>CsvClassifier</code>,
    /// depending on which field of the request is present.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateClassifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_classifier_input::Builder,
    }
    impl<C, M, R> CreateClassifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClassifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClassifierInputOperationOutputAlias,
                crate::output::CreateClassifierOutput,
                crate::error::CreateClassifierError,
                crate::input::CreateClassifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A <code>GrokClassifier</code> object specifying the classifier
        /// to create.</p>
        pub fn grok_classifier(mut self, inp: crate::model::CreateGrokClassifierRequest) -> Self {
            self.inner = self.inner.grok_classifier(inp);
            self
        }
        /// <p>A <code>GrokClassifier</code> object specifying the classifier
        /// to create.</p>
        pub fn set_grok_classifier(
            mut self,
            input: std::option::Option<crate::model::CreateGrokClassifierRequest>,
        ) -> Self {
            self.inner = self.inner.set_grok_classifier(input);
            self
        }
        /// <p>An <code>XMLClassifier</code> object specifying the classifier
        /// to create.</p>
        pub fn xml_classifier(mut self, inp: crate::model::CreateXmlClassifierRequest) -> Self {
            self.inner = self.inner.xml_classifier(inp);
            self
        }
        /// <p>An <code>XMLClassifier</code> object specifying the classifier
        /// to create.</p>
        pub fn set_xml_classifier(
            mut self,
            input: std::option::Option<crate::model::CreateXmlClassifierRequest>,
        ) -> Self {
            self.inner = self.inner.set_xml_classifier(input);
            self
        }
        /// <p>A <code>JsonClassifier</code> object specifying the classifier
        /// to create.</p>
        pub fn json_classifier(mut self, inp: crate::model::CreateJsonClassifierRequest) -> Self {
            self.inner = self.inner.json_classifier(inp);
            self
        }
        /// <p>A <code>JsonClassifier</code> object specifying the classifier
        /// to create.</p>
        pub fn set_json_classifier(
            mut self,
            input: std::option::Option<crate::model::CreateJsonClassifierRequest>,
        ) -> Self {
            self.inner = self.inner.set_json_classifier(input);
            self
        }
        /// <p>A <code>CsvClassifier</code> object specifying the classifier
        /// to create.</p>
        pub fn csv_classifier(mut self, inp: crate::model::CreateCsvClassifierRequest) -> Self {
            self.inner = self.inner.csv_classifier(inp);
            self
        }
        /// <p>A <code>CsvClassifier</code> object specifying the classifier
        /// to create.</p>
        pub fn set_csv_classifier(
            mut self,
            input: std::option::Option<crate::model::CreateCsvClassifierRequest>,
        ) -> Self {
            self.inner = self.inner.set_csv_classifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnection`.
    ///
    /// <p>Creates a connection definition in the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connection_input::Builder,
    }
    impl<C, M, R> CreateConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectionInputOperationOutputAlias,
                crate::output::CreateConnectionOutput,
                crate::error::CreateConnectionError,
                crate::input::CreateConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which to create the connection. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which to create the connection. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>A <code>ConnectionInput</code> object defining the connection
        /// to create.</p>
        pub fn connection_input(mut self, inp: crate::model::ConnectionInput) -> Self {
            self.inner = self.inner.connection_input(inp);
            self
        }
        /// <p>A <code>ConnectionInput</code> object defining the connection
        /// to create.</p>
        pub fn set_connection_input(
            mut self,
            input: std::option::Option<crate::model::ConnectionInput>,
        ) -> Self {
            self.inner = self.inner.set_connection_input(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags you assign to the connection.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags you assign to the connection.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCrawler`.
    ///
    /// <p>Creates a new crawler with specified targets, role, configuration, and optional schedule.
    /// At least one crawl target must be specified, in the <code>s3Targets</code> field, the
    /// <code>jdbcTargets</code> field, or the <code>DynamoDBTargets</code> field.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCrawler<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_crawler_input::Builder,
    }
    impl<C, M, R> CreateCrawler<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCrawler`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCrawlerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCrawlerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCrawlerInputOperationOutputAlias,
                crate::output::CreateCrawlerOutput,
                crate::error::CreateCrawlerError,
                crate::input::CreateCrawlerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the new crawler.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the new crawler.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The IAM role or Amazon Resource Name (ARN) of an IAM role used by the new crawler to
        /// access customer resources.</p>
        pub fn role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The IAM role or Amazon Resource Name (ARN) of an IAM role used by the new crawler to
        /// access customer resources.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The Glue database where results are written, such as:
        /// <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The Glue database where results are written, such as:
        /// <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>A description of the new crawler.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the new crawler.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A list of collection of targets to crawl.</p>
        pub fn targets(mut self, inp: crate::model::CrawlerTargets) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>A list of collection of targets to crawl.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<crate::model::CrawlerTargets>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn schedule(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// Appends an item to `Classifiers`.
        ///
        /// To override the contents of this collection use [`set_classifiers`](Self::set_classifiers).
        ///
        /// <p>A list of custom classifiers that the user has registered. By default, all built-in
        /// classifiers are included in a crawl, but these custom classifiers always override the default
        /// classifiers for a given classification.</p>
        pub fn classifiers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.classifiers(inp);
            self
        }
        /// <p>A list of custom classifiers that the user has registered. By default, all built-in
        /// classifiers are included in a crawl, but these custom classifiers always override the default
        /// classifiers for a given classification.</p>
        pub fn set_classifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_classifiers(input);
            self
        }
        /// <p>The table prefix used for catalog tables that are created.</p>
        pub fn table_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_prefix(inp);
            self
        }
        /// <p>The table prefix used for catalog tables that are created.</p>
        pub fn set_table_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_prefix(input);
            self
        }
        /// <p>The policy for the crawler's update and deletion behavior.</p>
        pub fn schema_change_policy(mut self, inp: crate::model::SchemaChangePolicy) -> Self {
            self.inner = self.inner.schema_change_policy(inp);
            self
        }
        /// <p>The policy for the crawler's update and deletion behavior.</p>
        pub fn set_schema_change_policy(
            mut self,
            input: std::option::Option<crate::model::SchemaChangePolicy>,
        ) -> Self {
            self.inner = self.inner.set_schema_change_policy(input);
            self
        }
        /// <p>A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.</p>
        pub fn recrawl_policy(mut self, inp: crate::model::RecrawlPolicy) -> Self {
            self.inner = self.inner.recrawl_policy(inp);
            self
        }
        /// <p>A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.</p>
        pub fn set_recrawl_policy(
            mut self,
            input: std::option::Option<crate::model::RecrawlPolicy>,
        ) -> Self {
            self.inner = self.inner.set_recrawl_policy(input);
            self
        }
        /// <p>Specifies data lineage configuration settings for the crawler.</p>
        pub fn lineage_configuration(mut self, inp: crate::model::LineageConfiguration) -> Self {
            self.inner = self.inner.lineage_configuration(inp);
            self
        }
        /// <p>Specifies data lineage configuration settings for the crawler.</p>
        pub fn set_lineage_configuration(
            mut self,
            input: std::option::Option<crate::model::LineageConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_lineage_configuration(input);
            self
        }
        /// <p>Crawler configuration information. This versioned JSON
        /// string allows users to specify aspects of a crawler's behavior.
        /// For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a>.</p>
        pub fn configuration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>Crawler configuration information. This versioned JSON
        /// string allows users to specify aspects of a crawler's behavior.
        /// For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a>.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used by this
        /// crawler.</p>
        pub fn crawler_security_configuration(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.crawler_security_configuration(inp);
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used by this
        /// crawler.</p>
        pub fn set_crawler_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_crawler_security_configuration(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to use with this crawler request. You may use tags to limit access to the
        /// crawler. For more information about tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a> in the developer
        /// guide.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to use with this crawler request. You may use tags to limit access to the
        /// crawler. For more information about tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a> in the developer
        /// guide.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDatabase`.
    ///
    /// <p>Creates a new database in a Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_database_input::Builder,
    }
    impl<C, M, R> CreateDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatabaseInputOperationOutputAlias,
                crate::output::CreateDatabaseOutput,
                crate::error::CreateDatabaseError,
                crate::input::CreateDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which to create the database. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which to create the database. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The metadata for the database.</p>
        pub fn database_input(mut self, inp: crate::model::DatabaseInput) -> Self {
            self.inner = self.inner.database_input(inp);
            self
        }
        /// <p>The metadata for the database.</p>
        pub fn set_database_input(
            mut self,
            input: std::option::Option<crate::model::DatabaseInput>,
        ) -> Self {
            self.inner = self.inner.set_database_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDevEndpoint`.
    ///
    /// <p>Creates a new development endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDevEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dev_endpoint_input::Builder,
    }
    impl<C, M, R> CreateDevEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDevEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDevEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDevEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDevEndpointInputOperationOutputAlias,
                crate::output::CreateDevEndpointOutput,
                crate::error::CreateDevEndpointError,
                crate::input::CreateDevEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to be assigned to the new <code>DevEndpoint</code>.</p>
        pub fn endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(inp);
            self
        }
        /// <p>The name to be assigned to the new <code>DevEndpoint</code>.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// <p>The IAM role for the <code>DevEndpoint</code>.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The IAM role for the <code>DevEndpoint</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>Security group IDs for the security groups to be used by the new
        /// <code>DevEndpoint</code>.</p>
        pub fn security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(inp);
            self
        }
        /// <p>Security group IDs for the security groups to be used by the new
        /// <code>DevEndpoint</code>.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>The subnet ID for the new <code>DevEndpoint</code> to use.</p>
        pub fn subnet_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(inp);
            self
        }
        /// <p>The subnet ID for the new <code>DevEndpoint</code> to use.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The public key to be used by this <code>DevEndpoint</code> for authentication. This
        /// attribute is provided for backward compatibility because the recommended attribute to use is
        /// public keys.</p>
        pub fn public_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_key(inp);
            self
        }
        /// <p>The public key to be used by this <code>DevEndpoint</code> for authentication. This
        /// attribute is provided for backward compatibility because the recommended attribute to use is
        /// public keys.</p>
        pub fn set_public_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_public_key(input);
            self
        }
        /// Appends an item to `PublicKeys`.
        ///
        /// To override the contents of this collection use [`set_public_keys`](Self::set_public_keys).
        ///
        /// <p>A list of public keys to be used by the development endpoints for authentication. The use
        /// of this attribute is preferred over a single public key because the public keys allow you to
        /// have a different private key per client.</p>
        ///
        /// <note>
        /// <p>If you previously created an endpoint with a public key, you must remove that key to be able
        /// to set a list of public keys. Call the <code>UpdateDevEndpoint</code> API with the public
        /// key content in the <code>deletePublicKeys</code> attribute, and the list of new keys in the
        /// <code>addPublicKeys</code> attribute.</p>
        /// </note>
        pub fn public_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_keys(inp);
            self
        }
        /// <p>A list of public keys to be used by the development endpoints for authentication. The use
        /// of this attribute is preferred over a single public key because the public keys allow you to
        /// have a different private key per client.</p>
        ///
        /// <note>
        /// <p>If you previously created an endpoint with a public key, you must remove that key to be able
        /// to set a list of public keys. Call the <code>UpdateDevEndpoint</code> API with the public
        /// key content in the <code>deletePublicKeys</code> attribute, and the list of new keys in the
        /// <code>addPublicKeys</code> attribute.</p>
        /// </note>
        pub fn set_public_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_public_keys(input);
            self
        }
        /// <p>The number of Glue Data Processing Units (DPUs) to allocate to this
        /// <code>DevEndpoint</code>.</p>
        pub fn number_of_nodes(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_nodes(inp);
            self
        }
        /// <p>The number of Glue Data Processing Units (DPUs) to allocate to this
        /// <code>DevEndpoint</code>.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_nodes(input);
            self
        }
        /// <p>The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// </ul>
        /// <p>Known issue: when a development endpoint is created with the <code>G.2X</code>
        /// <code>WorkerType</code> configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk. </p>
        pub fn worker_type(mut self, inp: crate::model::WorkerType) -> Self {
            self.inner = self.inner.worker_type(inp);
            self
        }
        /// <p>The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// </ul>
        /// <p>Known issue: when a development endpoint is created with the <code>G.2X</code>
        /// <code>WorkerType</code> configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk. </p>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.inner = self.inner.set_worker_type(input);
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        ///
        /// <p>Development endpoints that are created without specifying a Glue version default to Glue 0.9.</p>  
        ///
        /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
        pub fn glue_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.glue_version(inp);
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        ///
        /// <p>Development endpoints that are created without specifying a Glue version default to Glue 0.9.</p>  
        ///
        /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_glue_version(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn number_of_workers(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_workers(inp);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_workers(input);
            self
        }
        /// <p>The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in
        /// your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a
        /// comma.</p>
        /// <note>
        /// <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on
        /// C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data
        /// analysis library, are not yet supported.</p>
        /// </note>
        pub fn extra_python_libs_s3_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.extra_python_libs_s3_path(inp);
            self
        }
        /// <p>The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in
        /// your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a
        /// comma.</p>
        /// <note>
        /// <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on
        /// C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data
        /// analysis library, are not yet supported.</p>
        /// </note>
        pub fn set_extra_python_libs_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_extra_python_libs_s3_path(input);
            self
        }
        /// <p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded
        /// in your <code>DevEndpoint</code>.</p>
        pub fn extra_jars_s3_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.extra_jars_s3_path(inp);
            self
        }
        /// <p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded
        /// in your <code>DevEndpoint</code>.</p>
        pub fn set_extra_jars_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_extra_jars_s3_path(input);
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// <code>DevEndpoint</code>.</p>
        pub fn security_configuration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_configuration(inp);
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// <code>DevEndpoint</code>.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_configuration(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to use with this DevEndpoint. You may use tags to limit access to the DevEndpoint. For more information about tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a> in the developer guide.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to use with this DevEndpoint. You may use tags to limit access to the DevEndpoint. For more information about tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a> in the developer guide.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `Arguments`.
        ///
        /// To override the contents of this collection use [`set_arguments`](Self::set_arguments).
        ///
        /// <p>A map of arguments used to configure the <code>DevEndpoint</code>.</p>
        pub fn arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.arguments(k, v);
            self
        }
        /// <p>A map of arguments used to configure the <code>DevEndpoint</code>.</p>
        pub fn set_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_arguments(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// <p>Creates a new job definition.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_input::Builder,
    }
    impl<C, M, R> CreateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobInputOperationOutputAlias,
                crate::output::CreateJobOutput,
                crate::error::CreateJobError,
                crate::input::CreateJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name you assign to this job definition. It must be unique in your account.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name you assign to this job definition. It must be unique in your account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Description of the job being defined.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Description of the job being defined.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>This field is reserved for future use.</p>
        pub fn log_uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_uri(inp);
            self
        }
        /// <p>This field is reserved for future use.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_log_uri(input);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job.</p>
        pub fn role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed
        /// for this job.</p>
        pub fn execution_property(mut self, inp: crate::model::ExecutionProperty) -> Self {
            self.inner = self.inner.execution_property(inp);
            self
        }
        /// <p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed
        /// for this job.</p>
        pub fn set_execution_property(
            mut self,
            input: std::option::Option<crate::model::ExecutionProperty>,
        ) -> Self {
            self.inner = self.inner.set_execution_property(input);
            self
        }
        /// <p>The <code>JobCommand</code> that runs this job.</p>
        pub fn command(mut self, inp: crate::model::JobCommand) -> Self {
            self.inner = self.inner.command(inp);
            self
        }
        /// <p>The <code>JobCommand</code> that runs this job.</p>
        pub fn set_command(mut self, input: std::option::Option<crate::model::JobCommand>) -> Self {
            self.inner = self.inner.set_command(input);
            self
        }
        /// Adds a key-value pair to `DefaultArguments`.
        ///
        /// To override the contents of this collection use [`set_default_arguments`](Self::set_default_arguments).
        ///
        /// <p>The default arguments for this job.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn default_arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_arguments(k, v);
            self
        }
        /// <p>The default arguments for this job.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn set_default_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_arguments(input);
            self
        }
        /// Adds a key-value pair to `NonOverridableArguments`.
        ///
        /// To override the contents of this collection use [`set_non_overridable_arguments`](Self::set_non_overridable_arguments).
        ///
        /// <p>Non-overridable arguments for this job, specified as name-value pairs.</p>
        pub fn non_overridable_arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.non_overridable_arguments(k, v);
            self
        }
        /// <p>Non-overridable arguments for this job, specified as name-value pairs.</p>
        pub fn set_non_overridable_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_non_overridable_arguments(input);
            self
        }
        /// <p>The connections used for this job.</p>
        pub fn connections(mut self, inp: crate::model::ConnectionsList) -> Self {
            self.inner = self.inner.connections(inp);
            self
        }
        /// <p>The connections used for this job.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<crate::model::ConnectionsList>,
        ) -> Self {
            self.inner = self.inner.set_connections(input);
            self
        }
        /// <p>The maximum number of times to retry this job if it fails.</p>
        pub fn max_retries(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_retries(inp);
            self
        }
        /// <p>The maximum number of times to retry this job if it fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
        /// <p>This parameter is deprecated. Use <code>MaxCapacity</code> instead.</p>
        ///
        /// <p>The number of Glue data processing units (DPUs) to allocate to this Job. You can
        /// allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing
        /// power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
        /// see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>.</p>
        pub fn allocated_capacity(mut self, inp: i32) -> Self {
            self.inner = self.inner.allocated_capacity(inp);
            self
        }
        /// <p>This parameter is deprecated. Use <code>MaxCapacity</code> instead.</p>
        ///
        /// <p>The number of Glue data processing units (DPUs) to allocate to this Job. You can
        /// allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing
        /// power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
        /// see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>.</p>
        pub fn set_allocated_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_capacity(input);
            self
        }
        /// <p>The job timeout in minutes.  This is the maximum time that a job run
        /// can consume resources before it is terminated and enters <code>TIMEOUT</code>
        /// status. The default is 2,880 minutes (48 hours).</p>
        pub fn timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout(inp);
            self
        }
        /// <p>The job timeout in minutes.  This is the maximum time that a job run
        /// can consume resources before it is terminated and enters <code>TIMEOUT</code>
        /// status. The default is 2,880 minutes (48 hours).</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        ///
        /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>
        ///
        /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
        /// running a Python shell job or an Apache Spark ETL job:</p>
        /// <ul>
        /// <li>
        /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
        /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
        /// </li>
        /// <li>
        /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache
        /// Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs.
        /// The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
        /// </li>
        /// </ul>
        /// <p>For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you should specify a <code>Worker type</code> and the <code>Number of workers</code>.</p>
        pub fn max_capacity(mut self, inp: f64) -> Self {
            self.inner = self.inner.max_capacity(inp);
            self
        }
        /// <p>For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        ///
        /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>
        ///
        /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
        /// running a Python shell job or an Apache Spark ETL job:</p>
        /// <ul>
        /// <li>
        /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
        /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
        /// </li>
        /// <li>
        /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache
        /// Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs.
        /// The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
        /// </li>
        /// </ul>
        /// <p>For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you should specify a <code>Worker type</code> and the <code>Number of workers</code>.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// job.</p>
        pub fn security_configuration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_configuration(inp);
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// job.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_configuration(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to use with this job. You may use tags to limit access to the job. For more information about tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a> in the developer guide.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to use with this job. You may use tags to limit access to the job. For more information about tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a> in the developer guide.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies configuration properties of a job notification.</p>
        pub fn notification_property(mut self, inp: crate::model::NotificationProperty) -> Self {
            self.inner = self.inner.notification_property(inp);
            self
        }
        /// <p>Specifies configuration properties of a job notification.</p>
        pub fn set_notification_property(
            mut self,
            input: std::option::Option<crate::model::NotificationProperty>,
        ) -> Self {
            self.inner = self.inner.set_notification_property(input);
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        ///
        /// <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>
        pub fn glue_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.glue_version(inp);
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        ///
        /// <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_glue_version(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn number_of_workers(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_workers(inp);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_workers(input);
            self
        }
        /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// </ul>
        pub fn worker_type(mut self, inp: crate::model::WorkerType) -> Self {
            self.inner = self.inner.worker_type(inp);
            self
        }
        /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// </ul>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.inner = self.inner.set_worker_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMLTransform`.
    ///
    /// <p>Creates an Glue machine learning transform. This operation creates the transform and
    /// all the necessary parameters to train it.</p>
    ///
    /// <p>Call this operation as the first step in the process of using a machine learning transform
    /// (such as the <code>FindMatches</code> transform) for deduplicating data. You can provide an
    /// optional <code>Description</code>, in addition to the parameters that you want to use for your
    /// algorithm.</p>
    ///
    /// <p>You must also specify certain parameters for the tasks that Glue runs on your
    /// behalf as part of learning from your data and creating a high-quality machine learning
    /// transform. These parameters include <code>Role</code>, and optionally,
    /// <code>AllocatedCapacity</code>, <code>Timeout</code>, and <code>MaxRetries</code>. For more
    /// information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html">Jobs</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMLTransform<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ml_transform_input::Builder,
    }
    impl<C, M, R> CreateMLTransform<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMLTransform`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMlTransformOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMLTransformError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMlTransformInputOperationOutputAlias,
                crate::output::CreateMlTransformOutput,
                crate::error::CreateMLTransformError,
                crate::input::CreateMlTransformInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name that you give the transform when you create it.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The unique name that you give the transform when you create it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the machine learning transform that is being defined. The default is an
        /// empty string.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the machine learning transform that is being defined. The default is an
        /// empty string.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `InputRecordTables`.
        ///
        /// To override the contents of this collection use [`set_input_record_tables`](Self::set_input_record_tables).
        ///
        /// <p>A list of Glue table definitions used by the transform.</p>
        pub fn input_record_tables(mut self, inp: impl Into<crate::model::GlueTable>) -> Self {
            self.inner = self.inner.input_record_tables(inp);
            self
        }
        /// <p>A list of Glue table definitions used by the transform.</p>
        pub fn set_input_record_tables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlueTable>>,
        ) -> Self {
            self.inner = self.inner.set_input_record_tables(input);
            self
        }
        /// <p>The algorithmic parameters that are specific to the transform type used. Conditionally
        /// dependent on the transform type.</p>
        pub fn parameters(mut self, inp: crate::model::TransformParameters) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The algorithmic parameters that are specific to the transform type used. Conditionally
        /// dependent on the transform type.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::TransformParameters>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions include both Glue service role permissions to Glue resources, and Amazon S3 permissions required by the transform. </p>
        ///
        /// <ul>
        /// <li>
        /// <p>This role needs Glue service role permissions to allow access to resources in Glue. See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access Glue</a>.</p>
        /// </li>
        /// <li>
        /// <p>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</p>
        /// </li>
        /// </ul>
        pub fn role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions include both Glue service role permissions to Glue resources, and Amazon S3 permissions required by the transform. </p>
        ///
        /// <ul>
        /// <li>
        /// <p>This role needs Glue service role permissions to allow access to resources in Glue. See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access Glue</a>.</p>
        /// </li>
        /// <li>
        /// <p>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</p>
        /// </li>
        /// </ul>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
        pub fn glue_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.glue_version(inp);
            self
        }
        /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_glue_version(input);
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
        /// processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
        /// information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>. </p>
        ///
        /// <p>
        /// <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p>
        /// <ul>
        /// <li>
        /// <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>    
        ///
        ///
        /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>
        pub fn max_capacity(mut self, inp: f64) -> Self {
            self.inner = self.inner.max_capacity(inp);
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
        /// processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
        /// information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>. </p>
        ///
        /// <p>
        /// <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p>
        /// <ul>
        /// <li>
        /// <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>    
        ///
        ///
        /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p>
        /// <ul>
        /// <li>
        /// <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p>
        /// </li>
        /// </ul>
        pub fn worker_type(mut self, inp: crate::model::WorkerType) -> Self {
            self.inner = self.inner.worker_type(inp);
            self
        }
        /// <p>The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p>
        /// <ul>
        /// <li>
        /// <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p>
        /// </li>
        /// </ul>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.inner = self.inner.set_worker_type(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>
        ///
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        pub fn number_of_workers(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_workers(inp);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>
        ///
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_workers(input);
            self
        }
        /// <p>The timeout of the task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>
        pub fn timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout(inp);
            self
        }
        /// <p>The timeout of the task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>The maximum number of times to retry a task for this transform after a task run fails.</p>
        pub fn max_retries(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_retries(inp);
            self
        }
        /// <p>The maximum number of times to retry a task for this transform after a task run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to use with this machine learning transform. You may use tags to limit access to the machine learning transform. For more information about tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a> in the developer guide.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to use with this machine learning transform. You may use tags to limit access to the machine learning transform. For more information about tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a> in the developer guide.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can access user data encrypted in Amazon S3 using KMS.</p>
        pub fn transform_encryption(mut self, inp: crate::model::TransformEncryption) -> Self {
            self.inner = self.inner.transform_encryption(inp);
            self
        }
        /// <p>The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can access user data encrypted in Amazon S3 using KMS.</p>
        pub fn set_transform_encryption(
            mut self,
            input: std::option::Option<crate::model::TransformEncryption>,
        ) -> Self {
            self.inner = self.inner.set_transform_encryption(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePartition`.
    ///
    /// <p>Creates a new partition.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_partition_input::Builder,
    }
    impl<C, M, R> CreatePartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePartitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePartitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePartitionInputOperationOutputAlias,
                crate::output::CreatePartitionOutput,
                crate::error::CreatePartitionError,
                crate::input::CreatePartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the catalog in which the partition is to be created.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the catalog in which the partition is to be created.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the metadata database in which the partition is
        /// to be created.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the metadata database in which the partition is
        /// to be created.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the metadata table in which the partition is to be created.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the metadata table in which the partition is to be created.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>A <code>PartitionInput</code> structure defining the partition
        /// to be created.</p>
        pub fn partition_input(mut self, inp: crate::model::PartitionInput) -> Self {
            self.inner = self.inner.partition_input(inp);
            self
        }
        /// <p>A <code>PartitionInput</code> structure defining the partition
        /// to be created.</p>
        pub fn set_partition_input(
            mut self,
            input: std::option::Option<crate::model::PartitionInput>,
        ) -> Self {
            self.inner = self.inner.set_partition_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePartitionIndex`.
    ///
    /// <p>Creates a specified partition index in an existing table.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePartitionIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_partition_index_input::Builder,
    }
    impl<C, M, R> CreatePartitionIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePartitionIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePartitionIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePartitionIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePartitionIndexInputOperationOutputAlias,
                crate::output::CreatePartitionIndexOutput,
                crate::error::CreatePartitionIndexError,
                crate::input::CreatePartitionIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The catalog ID where the table resides.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The catalog ID where the table resides.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>Specifies the name of a database in which you want to create a partition index.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>Specifies the name of a database in which you want to create a partition index.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>Specifies the name of a table in which you want to create a partition index.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>Specifies the name of a table in which you want to create a partition index.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>Specifies a <code>PartitionIndex</code> structure to create a partition index in an existing table.</p>
        pub fn partition_index(mut self, inp: crate::model::PartitionIndex) -> Self {
            self.inner = self.inner.partition_index(inp);
            self
        }
        /// <p>Specifies a <code>PartitionIndex</code> structure to create a partition index in an existing table.</p>
        pub fn set_partition_index(
            mut self,
            input: std::option::Option<crate::model::PartitionIndex>,
        ) -> Self {
            self.inner = self.inner.set_partition_index(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRegistry`.
    ///
    /// <p>Creates a new registry which may be used to hold a collection of schemas.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRegistry<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_registry_input::Builder,
    }
    impl<C, M, R> CreateRegistry<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRegistry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRegistryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRegistryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRegistryInputOperationOutputAlias,
                crate::output::CreateRegistryOutput,
                crate::error::CreateRegistryError,
                crate::input::CreateRegistryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the registry to be created of max length of 255, and may only contain letters, numbers, hyphen, underscore, dollar sign, or hash mark.  No whitespace.</p>
        pub fn registry_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_name(inp);
            self
        }
        /// <p>Name of the registry to be created of max length of 255, and may only contain letters, numbers, hyphen, underscore, dollar sign, or hash mark.  No whitespace.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_registry_name(input);
            self
        }
        /// <p>A description of the registry. If description is not provided, there will not be any default value for this.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the registry. If description is not provided, there will not be any default value for this.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Amazon Web Services tags that contain a key value pair and may be searched by console, command line, or API.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Amazon Web Services tags that contain a key value pair and may be searched by console, command line, or API.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSchema`.
    ///
    /// <p>Creates a new schema set and registers the schema definition. Returns an error if the schema set already exists without actually registering the version.</p>
    /// <p>When the schema set is created, a version checkpoint will be set to the first version. Compatibility mode "DISABLED" restricts any additional schema versions from being added after the first schema version. For all other compatibility modes, validation of compatibility settings will be applied only from the second version onwards when the <code>RegisterSchemaVersion</code> API is used.</p>
    /// <p>When this API is called without a <code>RegistryId</code>, this will create an entry for a "default-registry" in the registry database tables, if it is not already present.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_schema_input::Builder,
    }
    impl<C, M, R> CreateSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSchemaInputOperationOutputAlias,
                crate::output::CreateSchemaOutput,
                crate::error::CreateSchemaError,
                crate::input::CreateSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> This is a wrapper shape to contain the registry identity fields. If this is not provided, the default registry will be used. The ARN format for the same will be: <code>arn:aws:glue:us-east-2:<customer id>:registry/default-registry:random-5-letter-id</code>.</p>
        pub fn registry_id(mut self, inp: crate::model::RegistryId) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p> This is a wrapper shape to contain the registry identity fields. If this is not provided, the default registry will be used. The ARN format for the same will be: <code>arn:aws:glue:us-east-2:<customer id>:registry/default-registry:random-5-letter-id</code>.</p>
        pub fn set_registry_id(
            mut self,
            input: std::option::Option<crate::model::RegistryId>,
        ) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>Name of the schema to be created of max length of 255, and may only contain letters, numbers, hyphen, underscore, dollar sign, or hash mark. No whitespace.</p>
        pub fn schema_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_name(inp);
            self
        }
        /// <p>Name of the schema to be created of max length of 255, and may only contain letters, numbers, hyphen, underscore, dollar sign, or hash mark. No whitespace.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema_name(input);
            self
        }
        /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn data_format(mut self, inp: crate::model::DataFormat) -> Self {
            self.inner = self.inner.data_format(inp);
            self
        }
        /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::DataFormat>,
        ) -> Self {
            self.inner = self.inner.set_data_format(input);
            self
        }
        /// <p>The compatibility mode of the schema. The possible values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <i>NONE</i>: No compatibility mode applies. You can use this choice in development scenarios or if you do not know the compatibility mode that you want to apply to schemas. Any new version added will be accepted without undergoing a compatibility check.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>DISABLED</i>: This compatibility choice prevents versioning for a particular schema. You can use this choice to prevent future versioning of a schema.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>BACKWARD</i>: This compatibility choice is recommended as it allows data receivers to read both the current and one previous schema version. This means that for instance, a new schema version cannot drop data fields or change the type of these fields, so they can't be read by readers using the previous version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>BACKWARD_ALL</i>: This compatibility choice allows data receivers to read both the current and all previous schema versions. You can use this choice when you need to delete fields or add optional fields, and check compatibility against all previous schema versions. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>FORWARD</i>: This compatibility choice allows data receivers to read both the current and one next schema version, but not necessarily later versions. You can use this choice when you need to add fields or delete optional fields, but only check compatibility against the last schema version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>FORWARD_ALL</i>: This compatibility choice allows data receivers to read written by producers of any new registered schema. You can use this choice when you need to add fields or delete optional fields, and check compatibility against all previous schema versions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>FULL</i>: This compatibility choice allows data receivers to read data written by producers using the previous or next version of the schema, but not necessarily earlier or later versions. You can use this choice when you need to add or remove optional fields, but only check compatibility against the last schema version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>FULL_ALL</i>: This compatibility choice allows data receivers to read data written by producers using all previous schema versions. You can use this choice when you need to add or remove optional fields, and check compatibility against all previous schema versions.</p>
        /// </li>
        /// </ul>
        pub fn compatibility(mut self, inp: crate::model::Compatibility) -> Self {
            self.inner = self.inner.compatibility(inp);
            self
        }
        /// <p>The compatibility mode of the schema. The possible values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <i>NONE</i>: No compatibility mode applies. You can use this choice in development scenarios or if you do not know the compatibility mode that you want to apply to schemas. Any new version added will be accepted without undergoing a compatibility check.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>DISABLED</i>: This compatibility choice prevents versioning for a particular schema. You can use this choice to prevent future versioning of a schema.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>BACKWARD</i>: This compatibility choice is recommended as it allows data receivers to read both the current and one previous schema version. This means that for instance, a new schema version cannot drop data fields or change the type of these fields, so they can't be read by readers using the previous version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>BACKWARD_ALL</i>: This compatibility choice allows data receivers to read both the current and all previous schema versions. You can use this choice when you need to delete fields or add optional fields, and check compatibility against all previous schema versions. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>FORWARD</i>: This compatibility choice allows data receivers to read both the current and one next schema version, but not necessarily later versions. You can use this choice when you need to add fields or delete optional fields, but only check compatibility against the last schema version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>FORWARD_ALL</i>: This compatibility choice allows data receivers to read written by producers of any new registered schema. You can use this choice when you need to add fields or delete optional fields, and check compatibility against all previous schema versions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>FULL</i>: This compatibility choice allows data receivers to read data written by producers using the previous or next version of the schema, but not necessarily earlier or later versions. You can use this choice when you need to add or remove optional fields, but only check compatibility against the last schema version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>FULL_ALL</i>: This compatibility choice allows data receivers to read data written by producers using all previous schema versions. You can use this choice when you need to add or remove optional fields, and check compatibility against all previous schema versions.</p>
        /// </li>
        /// </ul>
        pub fn set_compatibility(
            mut self,
            input: std::option::Option<crate::model::Compatibility>,
        ) -> Self {
            self.inner = self.inner.set_compatibility(input);
            self
        }
        /// <p>An optional description of the schema. If description is not provided, there will not be any automatic default value for this.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description of the schema. If description is not provided, there will not be any automatic default value for this.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Amazon Web Services tags that contain a key value pair and may be searched by console, command line, or API. If specified, follows the Amazon Web Services tags-on-create pattern.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Amazon Web Services tags that contain a key value pair and may be searched by console, command line, or API. If specified, follows the Amazon Web Services tags-on-create pattern.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The schema definition using the <code>DataFormat</code> setting for <code>SchemaName</code>.</p>
        pub fn schema_definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_definition(inp);
            self
        }
        /// <p>The schema definition using the <code>DataFormat</code> setting for <code>SchemaName</code>.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateScript`.
    ///
    /// <p>Transforms a directed acyclic graph (DAG) into code.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateScript<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_script_input::Builder,
    }
    impl<C, M, R> CreateScript<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateScript`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateScriptOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateScriptError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateScriptInputOperationOutputAlias,
                crate::output::CreateScriptOutput,
                crate::error::CreateScriptError,
                crate::input::CreateScriptInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DagNodes`.
        ///
        /// To override the contents of this collection use [`set_dag_nodes`](Self::set_dag_nodes).
        ///
        /// <p>A list of the nodes in the DAG.</p>
        pub fn dag_nodes(mut self, inp: impl Into<crate::model::CodeGenNode>) -> Self {
            self.inner = self.inner.dag_nodes(inp);
            self
        }
        /// <p>A list of the nodes in the DAG.</p>
        pub fn set_dag_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeGenNode>>,
        ) -> Self {
            self.inner = self.inner.set_dag_nodes(input);
            self
        }
        /// Appends an item to `DagEdges`.
        ///
        /// To override the contents of this collection use [`set_dag_edges`](Self::set_dag_edges).
        ///
        /// <p>A list of the edges in the DAG.</p>
        pub fn dag_edges(mut self, inp: impl Into<crate::model::CodeGenEdge>) -> Self {
            self.inner = self.inner.dag_edges(inp);
            self
        }
        /// <p>A list of the edges in the DAG.</p>
        pub fn set_dag_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeGenEdge>>,
        ) -> Self {
            self.inner = self.inner.set_dag_edges(input);
            self
        }
        /// <p>The programming language of the resulting code from the DAG.</p>
        pub fn language(mut self, inp: crate::model::Language) -> Self {
            self.inner = self.inner.language(inp);
            self
        }
        /// <p>The programming language of the resulting code from the DAG.</p>
        pub fn set_language(mut self, input: std::option::Option<crate::model::Language>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSecurityConfiguration`.
    ///
    /// <p>Creates a new security configuration. A security configuration is a set of security properties that can be used by Glue. You can use a security configuration to encrypt data at rest. For information about using security configurations in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html">Encrypting Data Written by Crawlers, Jobs, and Development Endpoints</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSecurityConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_security_configuration_input::Builder,
    }
    impl<C, M, R> CreateSecurityConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSecurityConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSecurityConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSecurityConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSecurityConfigurationInputOperationOutputAlias,
                crate::output::CreateSecurityConfigurationOutput,
                crate::error::CreateSecurityConfigurationError,
                crate::input::CreateSecurityConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the new security configuration.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name for the new security configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The encryption configuration for the new security configuration.</p>
        pub fn encryption_configuration(
            mut self,
            inp: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.encryption_configuration(inp);
            self
        }
        /// <p>The encryption configuration for the new security configuration.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_encryption_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTable`.
    ///
    /// <p>Creates a new table definition in the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_table_input::Builder,
    }
    impl<C, M, R> CreateTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTableOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTableInputOperationOutputAlias,
                crate::output::CreateTableOutput,
                crate::error::CreateTableError,
                crate::input::CreateTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which to create the <code>Table</code>.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which to create the <code>Table</code>.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The catalog database in which to create the new table. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The catalog database in which to create the new table. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The <code>TableInput</code> object that defines the metadata table
        /// to create in the catalog.</p>
        pub fn table_input(mut self, inp: crate::model::TableInput) -> Self {
            self.inner = self.inner.table_input(inp);
            self
        }
        /// <p>The <code>TableInput</code> object that defines the metadata table
        /// to create in the catalog.</p>
        pub fn set_table_input(
            mut self,
            input: std::option::Option<crate::model::TableInput>,
        ) -> Self {
            self.inner = self.inner.set_table_input(input);
            self
        }
        /// Appends an item to `PartitionIndexes`.
        ///
        /// To override the contents of this collection use [`set_partition_indexes`](Self::set_partition_indexes).
        ///
        /// <p>A list of partition indexes, <code>PartitionIndex</code> structures, to create in the table.</p>
        pub fn partition_indexes(mut self, inp: impl Into<crate::model::PartitionIndex>) -> Self {
            self.inner = self.inner.partition_indexes(inp);
            self
        }
        /// <p>A list of partition indexes, <code>PartitionIndex</code> structures, to create in the table.</p>
        pub fn set_partition_indexes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartitionIndex>>,
        ) -> Self {
            self.inner = self.inner.set_partition_indexes(input);
            self
        }
        /// <p>The ID of the transaction.</p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The ID of the transaction.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrigger`.
    ///
    /// <p>Creates a new trigger.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTrigger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_trigger_input::Builder,
    }
    impl<C, M, R> CreateTrigger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrigger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTriggerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTriggerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTriggerInputOperationOutputAlias,
                crate::output::CreateTriggerOutput,
                crate::error::CreateTriggerError,
                crate::input::CreateTriggerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the trigger.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the trigger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the workflow associated with the trigger.</p>
        pub fn workflow_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_name(inp);
            self
        }
        /// <p>The name of the workflow associated with the trigger.</p>
        pub fn set_workflow_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workflow_name(input);
            self
        }
        /// <p>The type of the new trigger.</p>
        pub fn r#type(mut self, inp: crate::model::TriggerType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the new trigger.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TriggerType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        /// <p>This field is required when the trigger type is SCHEDULED.</p>
        pub fn schedule(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        /// <p>This field is required when the trigger type is SCHEDULED.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>A predicate to specify when the new trigger should fire.</p>
        /// <p>This field is required when the trigger type is <code>CONDITIONAL</code>.</p>
        pub fn predicate(mut self, inp: crate::model::Predicate) -> Self {
            self.inner = self.inner.predicate(inp);
            self
        }
        /// <p>A predicate to specify when the new trigger should fire.</p>
        /// <p>This field is required when the trigger type is <code>CONDITIONAL</code>.</p>
        pub fn set_predicate(
            mut self,
            input: std::option::Option<crate::model::Predicate>,
        ) -> Self {
            self.inner = self.inner.set_predicate(input);
            self
        }
        /// Appends an item to `Actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions initiated by this trigger when it fires.</p>
        pub fn actions(mut self, inp: impl Into<crate::model::Action>) -> Self {
            self.inner = self.inner.actions(inp);
            self
        }
        /// <p>The actions initiated by this trigger when it fires.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// <p>A description of the new trigger.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the new trigger.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Set to <code>true</code> to start <code>SCHEDULED</code> and <code>CONDITIONAL</code>
        /// triggers when created. True is not supported for <code>ON_DEMAND</code> triggers.</p>
        pub fn start_on_creation(mut self, inp: bool) -> Self {
            self.inner = self.inner.start_on_creation(inp);
            self
        }
        /// <p>Set to <code>true</code> to start <code>SCHEDULED</code> and <code>CONDITIONAL</code>
        /// triggers when created. True is not supported for <code>ON_DEMAND</code> triggers.</p>
        pub fn set_start_on_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_start_on_creation(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to use with this trigger. You may use tags to limit access to the trigger.
        /// For more information about tags in Glue, see
        /// <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a> in the developer guide. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to use with this trigger. You may use tags to limit access to the trigger.
        /// For more information about tags in Glue, see
        /// <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a> in the developer guide. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Batch condition that must be met (specified number of events received or batch time window expired)
        /// before EventBridge event trigger fires.</p>
        pub fn event_batching_condition(
            mut self,
            inp: crate::model::EventBatchingCondition,
        ) -> Self {
            self.inner = self.inner.event_batching_condition(inp);
            self
        }
        /// <p>Batch condition that must be met (specified number of events received or batch time window expired)
        /// before EventBridge event trigger fires.</p>
        pub fn set_event_batching_condition(
            mut self,
            input: std::option::Option<crate::model::EventBatchingCondition>,
        ) -> Self {
            self.inner = self.inner.set_event_batching_condition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserDefinedFunction`.
    ///
    /// <p>Creates a new function definition in the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUserDefinedFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_defined_function_input::Builder,
    }
    impl<C, M, R> CreateUserDefinedFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserDefinedFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserDefinedFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserDefinedFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserDefinedFunctionInputOperationOutputAlias,
                crate::output::CreateUserDefinedFunctionOutput,
                crate::error::CreateUserDefinedFunctionError,
                crate::input::CreateUserDefinedFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which to create the function. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which to create the function. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database in which to create the function.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database in which to create the function.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>A <code>FunctionInput</code> object that defines the function
        /// to create in the Data Catalog.</p>
        pub fn function_input(mut self, inp: crate::model::UserDefinedFunctionInput) -> Self {
            self.inner = self.inner.function_input(inp);
            self
        }
        /// <p>A <code>FunctionInput</code> object that defines the function
        /// to create in the Data Catalog.</p>
        pub fn set_function_input(
            mut self,
            input: std::option::Option<crate::model::UserDefinedFunctionInput>,
        ) -> Self {
            self.inner = self.inner.set_function_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkflow`.
    ///
    /// <p>Creates a new workflow.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWorkflow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workflow_input::Builder,
    }
    impl<C, M, R> CreateWorkflow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkflow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkflowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkflowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkflowInputOperationOutputAlias,
                crate::output::CreateWorkflowOutput,
                crate::error::CreateWorkflowError,
                crate::input::CreateWorkflowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to be assigned to the workflow. It should be unique within your account.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name to be assigned to the workflow. It should be unique within your account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the workflow.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the workflow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `DefaultRunProperties`.
        ///
        /// To override the contents of this collection use [`set_default_run_properties`](Self::set_default_run_properties).
        ///
        /// <p>A collection of properties to be used as part of each execution of the workflow.</p>
        pub fn default_run_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_run_properties(k, v);
            self
        }
        /// <p>A collection of properties to be used as part of each execution of the workflow.</p>
        pub fn set_default_run_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_run_properties(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be used with this workflow.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be used with this workflow.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.</p>
        pub fn max_concurrent_runs(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_concurrent_runs(inp);
            self
        }
        /// <p>You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.</p>
        pub fn set_max_concurrent_runs(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_concurrent_runs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBlueprint`.
    ///
    /// <p>Deletes an existing blueprint.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBlueprint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_blueprint_input::Builder,
    }
    impl<C, M, R> DeleteBlueprint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBlueprint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBlueprintOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBlueprintError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBlueprintInputOperationOutputAlias,
                crate::output::DeleteBlueprintOutput,
                crate::error::DeleteBlueprintError,
                crate::input::DeleteBlueprintInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the blueprint to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the blueprint to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClassifier`.
    ///
    /// <p>Removes a classifier from the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteClassifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_classifier_input::Builder,
    }
    impl<C, M, R> DeleteClassifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClassifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClassifierInputOperationOutputAlias,
                crate::output::DeleteClassifierOutput,
                crate::error::DeleteClassifierError,
                crate::input::DeleteClassifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the classifier to remove.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the classifier to remove.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteColumnStatisticsForPartition`.
    ///
    /// <p>Delete the partition column statistics of a column.</p>
    ///
    /// <p>The Identity and Access Management (IAM) permission required for this operation is <code>DeletePartition</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteColumnStatisticsForPartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_column_statistics_for_partition_input::Builder,
    }
    impl<C, M, R> DeleteColumnStatisticsForPartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteColumnStatisticsForPartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteColumnStatisticsForPartitionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteColumnStatisticsForPartitionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteColumnStatisticsForPartitionInputOperationOutputAlias,
                crate::output::DeleteColumnStatisticsForPartitionOutput,
                crate::error::DeleteColumnStatisticsForPartitionError,
                crate::input::DeleteColumnStatisticsForPartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `PartitionValues`.
        ///
        /// To override the contents of this collection use [`set_partition_values`](Self::set_partition_values).
        ///
        /// <p>A list of partition values identifying the partition.</p>
        pub fn partition_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partition_values(inp);
            self
        }
        /// <p>A list of partition values identifying the partition.</p>
        pub fn set_partition_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_partition_values(input);
            self
        }
        /// <p>Name of the column.</p>
        pub fn column_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.column_name(inp);
            self
        }
        /// <p>Name of the column.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_column_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteColumnStatisticsForTable`.
    ///
    /// <p>Retrieves table statistics of columns.</p>
    ///
    /// <p>The Identity and Access Management (IAM) permission required for this operation is <code>DeleteTable</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteColumnStatisticsForTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_column_statistics_for_table_input::Builder,
    }
    impl<C, M, R> DeleteColumnStatisticsForTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteColumnStatisticsForTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteColumnStatisticsForTableOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteColumnStatisticsForTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteColumnStatisticsForTableInputOperationOutputAlias,
                crate::output::DeleteColumnStatisticsForTableOutput,
                crate::error::DeleteColumnStatisticsForTableError,
                crate::input::DeleteColumnStatisticsForTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The name of the column.</p>
        pub fn column_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.column_name(inp);
            self
        }
        /// <p>The name of the column.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_column_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>Deletes a connection from the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl<C, M, R> DeleteConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectionInputOperationOutputAlias,
                crate::output::DeleteConnectionOutput,
                crate::error::DeleteConnectionError,
                crate::input::DeleteConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the connection to delete.</p>
        pub fn connection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(inp);
            self
        }
        /// <p>The name of the connection to delete.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCrawler`.
    ///
    /// <p>Removes a specified crawler from the Glue Data Catalog, unless the crawler state is
    /// <code>RUNNING</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCrawler<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_crawler_input::Builder,
    }
    impl<C, M, R> DeleteCrawler<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCrawler`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCrawlerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCrawlerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCrawlerInputOperationOutputAlias,
                crate::output::DeleteCrawlerOutput,
                crate::error::DeleteCrawlerError,
                crate::input::DeleteCrawlerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the crawler to remove.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the crawler to remove.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDatabase`.
    ///
    /// <p>Removes a specified database from a Data Catalog.</p>
    /// <note>
    /// <p>After completing this operation, you no longer have access to the tables (and all table
    /// versions and partitions that might belong to the tables) and the user-defined functions in
    /// the deleted database. Glue deletes these "orphaned" resources asynchronously in a timely
    /// manner, at the discretion of the service.</p>
    /// <p>To ensure the immediate deletion of all related resources, before calling
    /// <code>DeleteDatabase</code>, use <code>DeleteTableVersion</code> or
    /// <code>BatchDeleteTableVersion</code>, <code>DeletePartition</code> or
    /// <code>BatchDeletePartition</code>, <code>DeleteUserDefinedFunction</code>, and
    /// <code>DeleteTable</code> or <code>BatchDeleteTable</code>, to delete any resources that
    /// belong to the database.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_database_input::Builder,
    }
    impl<C, M, R> DeleteDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatabaseInputOperationOutputAlias,
                crate::output::DeleteDatabaseOutput,
                crate::error::DeleteDatabaseError,
                crate::input::DeleteDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which the database resides. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which the database resides. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the database to delete. For Hive compatibility, this must be all
        /// lowercase.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the database to delete. For Hive compatibility, this must be all
        /// lowercase.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDevEndpoint`.
    ///
    /// <p>Deletes a specified development endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDevEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dev_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteDevEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDevEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDevEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDevEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDevEndpointInputOperationOutputAlias,
                crate::output::DeleteDevEndpointOutput,
                crate::error::DeleteDevEndpointError,
                crate::input::DeleteDevEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>DevEndpoint</code>.</p>
        pub fn endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(inp);
            self
        }
        /// <p>The name of the <code>DevEndpoint</code>.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJob`.
    ///
    /// <p>Deletes a specified job definition. If the job definition
    /// is not found, no exception is thrown.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_input::Builder,
    }
    impl<C, M, R> DeleteJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobInputOperationOutputAlias,
                crate::output::DeleteJobOutput,
                crate::error::DeleteJobError,
                crate::input::DeleteJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job definition to delete.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the job definition to delete.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMLTransform`.
    ///
    /// <p>Deletes an Glue machine learning transform. Machine learning transforms are a special
    /// type of transform that use machine learning to learn the details of the transformation to be
    /// performed by learning from examples provided by humans. These transformations are then saved
    /// by Glue. If you no longer need a transform, you can delete it by calling
    /// <code>DeleteMLTransforms</code>. However, any Glue jobs that still reference the deleted
    /// transform will no longer succeed.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMLTransform<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ml_transform_input::Builder,
    }
    impl<C, M, R> DeleteMLTransform<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMLTransform`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMlTransformOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMLTransformError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMlTransformInputOperationOutputAlias,
                crate::output::DeleteMlTransformOutput,
                crate::error::DeleteMLTransformError,
                crate::input::DeleteMlTransformInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the transform to delete.</p>
        pub fn transform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_id(inp);
            self
        }
        /// <p>The unique identifier of the transform to delete.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_transform_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePartition`.
    ///
    /// <p>Deletes a specified partition.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_partition_input::Builder,
    }
    impl<C, M, R> DeletePartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePartitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePartitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePartitionInputOperationOutputAlias,
                crate::output::DeletePartitionOutput,
                crate::error::DeletePartitionError,
                crate::input::DeletePartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partition to be deleted resides. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partition to be deleted resides. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database in which the table in question
        /// resides.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database in which the table in question
        /// resides.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the table that contains the partition to be deleted.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table that contains the partition to be deleted.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `PartitionValues`.
        ///
        /// To override the contents of this collection use [`set_partition_values`](Self::set_partition_values).
        ///
        /// <p>The values that define the partition.</p>
        pub fn partition_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partition_values(inp);
            self
        }
        /// <p>The values that define the partition.</p>
        pub fn set_partition_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_partition_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePartitionIndex`.
    ///
    /// <p>Deletes a specified partition index from an existing table.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePartitionIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_partition_index_input::Builder,
    }
    impl<C, M, R> DeletePartitionIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePartitionIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePartitionIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePartitionIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePartitionIndexInputOperationOutputAlias,
                crate::output::DeletePartitionIndexOutput,
                crate::error::DeletePartitionIndexError,
                crate::input::DeletePartitionIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The catalog ID where the table resides.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The catalog ID where the table resides.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>Specifies the name of a database from which you want to delete a partition index.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>Specifies the name of a database from which you want to delete a partition index.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>Specifies the name of a table from which you want to delete a partition index.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>Specifies the name of a table from which you want to delete a partition index.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The name of the partition index to be deleted.</p>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The name of the partition index to be deleted.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegistry`.
    ///
    /// <p>Delete the entire registry including schema and all of its versions. To get the status of the delete operation, you can call the <code>GetRegistry</code> API after the asynchronous call. Deleting a registry will deactivate all online operations for the registry such as the <code>UpdateRegistry</code>, <code>CreateSchema</code>, <code>UpdateSchema</code>, and <code>RegisterSchemaVersion</code> APIs. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRegistry<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_registry_input::Builder,
    }
    impl<C, M, R> DeleteRegistry<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRegistry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegistryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegistryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRegistryInputOperationOutputAlias,
                crate::output::DeleteRegistryOutput,
                crate::error::DeleteRegistryError,
                crate::input::DeleteRegistryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).</p>
        pub fn registry_id(mut self, inp: crate::model::RegistryId) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).</p>
        pub fn set_registry_id(
            mut self,
            input: std::option::Option<crate::model::RegistryId>,
        ) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes a specified policy.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl<C, M, R> DeleteResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourcePolicyInputOperationOutputAlias,
                crate::output::DeleteResourcePolicyOutput,
                crate::error::DeleteResourcePolicyError,
                crate::input::DeleteResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The hash value returned when this policy was set.</p>
        pub fn policy_hash_condition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_hash_condition(inp);
            self
        }
        /// <p>The hash value returned when this policy was set.</p>
        pub fn set_policy_hash_condition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_hash_condition(input);
            self
        }
        /// <p>The ARN of the Glue resource for the resource policy to be deleted.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the Glue resource for the resource policy to be deleted.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSchema`.
    ///
    /// <p>Deletes the entire schema set, including the schema set and all of its versions. To get the status of the delete operation, you can call <code>GetSchema</code> API after the asynchronous call. Deleting a registry will deactivate all online operations for the schema, such as the <code>GetSchemaByDefinition</code>, and <code>RegisterSchemaVersion</code> APIs.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_schema_input::Builder,
    }
    impl<C, M, R> DeleteSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSchemaInputOperationOutputAlias,
                crate::output::DeleteSchemaOutput,
                crate::error::DeleteSchemaError,
                crate::input::DeleteSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).</p>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).</p>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSchemaVersions`.
    ///
    /// <p>Remove versions from the specified schema. A version number or range may be supplied. If the compatibility mode forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is returned.  Calling the <code>GetSchemaVersions</code> API after this call will list the status of the deleted versions.</p>
    /// <p>When the range of version numbers contain check pointed version, the API will return a 409 conflict and will not proceed with the deletion. You have to remove the checkpoint first using the <code>DeleteSchemaCheckpoint</code> API before using this API.</p>
    /// <p>You cannot use the <code>DeleteSchemaVersions</code> API to delete the first schema version in the schema set. The first schema version can only be deleted by the <code>DeleteSchema</code> API. This operation will also delete the attached <code>SchemaVersionMetadata</code> under the schema versions. Hard deletes will be enforced on the database.</p>
    /// <p>If the compatibility mode forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSchemaVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_schema_versions_input::Builder,
    }
    impl<C, M, R> DeleteSchemaVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSchemaVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSchemaVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSchemaVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSchemaVersionsInputOperationOutputAlias,
                crate::output::DeleteSchemaVersionsOutput,
                crate::error::DeleteSchemaVersionsError,
                crate::input::DeleteSchemaVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).</p>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).</p>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
        /// <p>A version range may be supplied which may be of the format:</p>
        /// <ul>
        /// <li>
        /// <p>a single version number, 5</p>
        /// </li>
        /// <li>
        /// <p>a range, 5-8 : deletes versions 5, 6, 7, 8</p>
        /// </li>
        /// </ul>
        pub fn versions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.versions(inp);
            self
        }
        /// <p>A version range may be supplied which may be of the format:</p>
        /// <ul>
        /// <li>
        /// <p>a single version number, 5</p>
        /// </li>
        /// <li>
        /// <p>a range, 5-8 : deletes versions 5, 6, 7, 8</p>
        /// </li>
        /// </ul>
        pub fn set_versions(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_versions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSecurityConfiguration`.
    ///
    /// <p>Deletes a specified security configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSecurityConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_security_configuration_input::Builder,
    }
    impl<C, M, R> DeleteSecurityConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSecurityConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSecurityConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSecurityConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSecurityConfigurationInputOperationOutputAlias,
                crate::output::DeleteSecurityConfigurationOutput,
                crate::error::DeleteSecurityConfigurationError,
                crate::input::DeleteSecurityConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security configuration to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the security configuration to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTable`.
    ///
    /// <p>Removes a table definition from the Data Catalog.</p>
    /// <note>
    /// <p>After completing this operation, you no longer have access to the table versions and
    /// partitions that belong to the deleted table. Glue deletes these "orphaned" resources
    /// asynchronously in a timely manner, at the discretion of the service.</p>
    /// <p>To ensure the immediate deletion of all related resources, before calling
    /// <code>DeleteTable</code>, use <code>DeleteTableVersion</code> or
    /// <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or
    /// <code>BatchDeletePartition</code>, to delete any resources that belong to the
    /// table.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_table_input::Builder,
    }
    impl<C, M, R> DeleteTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTableOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTableInputOperationOutputAlias,
                crate::output::DeleteTableOutput,
                crate::error::DeleteTableError,
                crate::input::DeleteTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the table to be deleted. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the table to be deleted. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The transaction ID at which to delete the table contents.</p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The transaction ID at which to delete the table contents.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTableVersion`.
    ///
    /// <p>Deletes a specified version of a table.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTableVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_table_version_input::Builder,
    }
    impl<C, M, R> DeleteTableVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTableVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTableVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTableVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTableVersionInputOperationOutputAlias,
                crate::output::DeleteTableVersionOutput,
                crate::error::DeleteTableVersionError,
                crate::input::DeleteTableVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database in the catalog in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The database in the catalog in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the table. For Hive compatibility,
        /// this name is entirely lowercase.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table. For Hive compatibility,
        /// this name is entirely lowercase.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The ID of the table version to be deleted. A <code>VersionID</code> is a string representation of an integer. Each version is incremented by 1.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The ID of the table version to be deleted. A <code>VersionID</code> is a string representation of an integer. Each version is incremented by 1.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrigger`.
    ///
    /// <p>Deletes a specified trigger. If the trigger is not found, no
    /// exception is thrown.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTrigger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_trigger_input::Builder,
    }
    impl<C, M, R> DeleteTrigger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTrigger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTriggerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTriggerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTriggerInputOperationOutputAlias,
                crate::output::DeleteTriggerOutput,
                crate::error::DeleteTriggerError,
                crate::input::DeleteTriggerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the trigger to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the trigger to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserDefinedFunction`.
    ///
    /// <p>Deletes an existing function definition from the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUserDefinedFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_defined_function_input::Builder,
    }
    impl<C, M, R> DeleteUserDefinedFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserDefinedFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserDefinedFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserDefinedFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserDefinedFunctionInputOperationOutputAlias,
                crate::output::DeleteUserDefinedFunctionOutput,
                crate::error::DeleteUserDefinedFunctionError,
                crate::input::DeleteUserDefinedFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the function to be deleted is
        /// located. If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the function to be deleted is
        /// located. If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the function is located.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the function is located.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the function definition to be deleted.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the function definition to be deleted.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkflow`.
    ///
    /// <p>Deletes a workflow.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWorkflow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workflow_input::Builder,
    }
    impl<C, M, R> DeleteWorkflow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkflow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkflowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkflowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkflowInputOperationOutputAlias,
                crate::output::DeleteWorkflowOutput,
                crate::error::DeleteWorkflowError,
                crate::input::DeleteWorkflowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the workflow to be deleted.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the workflow to be deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBlueprint`.
    ///
    /// <p>Retrieves the details of a blueprint.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBlueprint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_blueprint_input::Builder,
    }
    impl<C, M, R> GetBlueprint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBlueprint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlueprintOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlueprintError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBlueprintInputOperationOutputAlias,
                crate::output::GetBlueprintOutput,
                crate::error::GetBlueprintError,
                crate::input::GetBlueprintInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the blueprint.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the blueprint.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether or not to include the blueprint in the response.</p>
        pub fn include_blueprint(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_blueprint(inp);
            self
        }
        /// <p>Specifies whether or not to include the blueprint in the response.</p>
        pub fn set_include_blueprint(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_blueprint(input);
            self
        }
        /// <p>Specifies whether or not to include the parameter specification.</p>
        pub fn include_parameter_spec(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_parameter_spec(inp);
            self
        }
        /// <p>Specifies whether or not to include the parameter specification.</p>
        pub fn set_include_parameter_spec(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_parameter_spec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBlueprintRun`.
    ///
    /// <p>Retrieves the details of a blueprint run.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBlueprintRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_blueprint_run_input::Builder,
    }
    impl<C, M, R> GetBlueprintRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBlueprintRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlueprintRunOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlueprintRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBlueprintRunInputOperationOutputAlias,
                crate::output::GetBlueprintRunOutput,
                crate::error::GetBlueprintRunError,
                crate::input::GetBlueprintRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the blueprint.</p>
        pub fn blueprint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blueprint_name(inp);
            self
        }
        /// <p>The name of the blueprint.</p>
        pub fn set_blueprint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_blueprint_name(input);
            self
        }
        /// <p>The run ID for the blueprint run you want to retrieve.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The run ID for the blueprint run you want to retrieve.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBlueprintRuns`.
    ///
    /// <p>Retrieves the details of blueprint runs for a specified blueprint.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBlueprintRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_blueprint_runs_input::Builder,
    }
    impl<C, M, R> GetBlueprintRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBlueprintRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlueprintRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlueprintRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBlueprintRunsInputOperationOutputAlias,
                crate::output::GetBlueprintRunsOutput,
                crate::error::GetBlueprintRunsError,
                crate::input::GetBlueprintRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the blueprint.</p>
        pub fn blueprint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blueprint_name(inp);
            self
        }
        /// <p>The name of the blueprint.</p>
        pub fn set_blueprint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_blueprint_name(input);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCatalogImportStatus`.
    ///
    /// <p>Retrieves the status of a migration operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCatalogImportStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_catalog_import_status_input::Builder,
    }
    impl<C, M, R> GetCatalogImportStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCatalogImportStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCatalogImportStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCatalogImportStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCatalogImportStatusInputOperationOutputAlias,
                crate::output::GetCatalogImportStatusOutput,
                crate::error::GetCatalogImportStatusError,
                crate::input::GetCatalogImportStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the catalog to migrate. Currently, this should be the Amazon Web Services account ID.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the catalog to migrate. Currently, this should be the Amazon Web Services account ID.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetClassifier`.
    ///
    /// <p>Retrieve a classifier by name.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetClassifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_classifier_input::Builder,
    }
    impl<C, M, R> GetClassifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::GetClassifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetClassifierInputOperationOutputAlias,
                crate::output::GetClassifierOutput,
                crate::error::GetClassifierError,
                crate::input::GetClassifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the classifier to retrieve.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the classifier to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetClassifiers`.
    ///
    /// <p>Lists all classifier objects in the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetClassifiers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_classifiers_input::Builder,
    }
    impl<C, M, R> GetClassifiers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetClassifiers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetClassifiersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetClassifiersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetClassifiersInputOperationOutputAlias,
                crate::output::GetClassifiersOutput,
                crate::error::GetClassifiersError,
                crate::input::GetClassifiersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The size of the list to return (optional).</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The size of the list to return (optional).</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional continuation token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An optional continuation token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetColumnStatisticsForPartition`.
    ///
    /// <p>Retrieves partition statistics of columns.</p>
    ///
    /// <p>The Identity and Access Management (IAM) permission required for this operation is <code>GetPartition</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetColumnStatisticsForPartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_column_statistics_for_partition_input::Builder,
    }
    impl<C, M, R> GetColumnStatisticsForPartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetColumnStatisticsForPartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetColumnStatisticsForPartitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetColumnStatisticsForPartitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetColumnStatisticsForPartitionInputOperationOutputAlias,
                crate::output::GetColumnStatisticsForPartitionOutput,
                crate::error::GetColumnStatisticsForPartitionError,
                crate::input::GetColumnStatisticsForPartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `PartitionValues`.
        ///
        /// To override the contents of this collection use [`set_partition_values`](Self::set_partition_values).
        ///
        /// <p>A list of partition values identifying the partition.</p>
        pub fn partition_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partition_values(inp);
            self
        }
        /// <p>A list of partition values identifying the partition.</p>
        pub fn set_partition_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_partition_values(input);
            self
        }
        /// Appends an item to `ColumnNames`.
        ///
        /// To override the contents of this collection use [`set_column_names`](Self::set_column_names).
        ///
        /// <p>A list of the column names.</p>
        pub fn column_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.column_names(inp);
            self
        }
        /// <p>A list of the column names.</p>
        pub fn set_column_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_column_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetColumnStatisticsForTable`.
    ///
    /// <p>Retrieves table statistics of columns.</p>
    ///
    /// <p>The Identity and Access Management (IAM) permission required for this operation is <code>GetTable</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetColumnStatisticsForTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_column_statistics_for_table_input::Builder,
    }
    impl<C, M, R> GetColumnStatisticsForTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetColumnStatisticsForTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetColumnStatisticsForTableOutput,
            aws_smithy_http::result::SdkError<crate::error::GetColumnStatisticsForTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetColumnStatisticsForTableInputOperationOutputAlias,
                crate::output::GetColumnStatisticsForTableOutput,
                crate::error::GetColumnStatisticsForTableError,
                crate::input::GetColumnStatisticsForTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `ColumnNames`.
        ///
        /// To override the contents of this collection use [`set_column_names`](Self::set_column_names).
        ///
        /// <p>A list of the column names.</p>
        pub fn column_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.column_names(inp);
            self
        }
        /// <p>A list of the column names.</p>
        pub fn set_column_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_column_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnection`.
    ///
    /// <p>Retrieves a connection definition from the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connection_input::Builder,
    }
    impl<C, M, R> GetConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectionInputOperationOutputAlias,
                crate::output::GetConnectionOutput,
                crate::error::GetConnectionError,
                crate::input::GetConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the connection definition to retrieve.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the connection definition to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Allows you to retrieve the connection metadata without returning the password. For
        /// instance, the AWS Glue console uses this flag to retrieve the connection, and does not display
        /// the password. Set this parameter when the caller might not have permission to use the KMS
        /// key to decrypt the password, but it does have permission to access the rest of the connection
        /// properties.</p>
        pub fn hide_password(mut self, inp: bool) -> Self {
            self.inner = self.inner.hide_password(inp);
            self
        }
        /// <p>Allows you to retrieve the connection metadata without returning the password. For
        /// instance, the AWS Glue console uses this flag to retrieve the connection, and does not display
        /// the password. Set this parameter when the caller might not have permission to use the KMS
        /// key to decrypt the password, but it does have permission to access the rest of the connection
        /// properties.</p>
        pub fn set_hide_password(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_hide_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetConnections`.
    ///
    /// <p>Retrieves a list of connection definitions from the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_connections_input::Builder,
    }
    impl<C, M, R> GetConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetConnectionsInputOperationOutputAlias,
                crate::output::GetConnectionsOutput,
                crate::error::GetConnectionsError,
                crate::input::GetConnectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which the connections reside. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which the connections reside. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>A filter that controls which connections are returned.</p>
        pub fn filter(mut self, inp: crate::model::GetConnectionsFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>A filter that controls which connections are returned.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::GetConnectionsFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Allows you to retrieve the connection metadata without returning the password. For
        /// instance, the AWS Glue console uses this flag to retrieve the connection, and does not display
        /// the password. Set this parameter when the caller might not have permission to use the KMS
        /// key to decrypt the password, but it does have permission to access the rest of the connection
        /// properties.</p>
        pub fn hide_password(mut self, inp: bool) -> Self {
            self.inner = self.inner.hide_password(inp);
            self
        }
        /// <p>Allows you to retrieve the connection metadata without returning the password. For
        /// instance, the AWS Glue console uses this flag to retrieve the connection, and does not display
        /// the password. Set this parameter when the caller might not have permission to use the KMS
        /// key to decrypt the password, but it does have permission to access the rest of the connection
        /// properties.</p>
        pub fn set_hide_password(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_hide_password(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of connections to return in one response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of connections to return in one response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCrawler`.
    ///
    /// <p>Retrieves metadata for a specified crawler.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCrawler<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_crawler_input::Builder,
    }
    impl<C, M, R> GetCrawler<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCrawler`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCrawlerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCrawlerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCrawlerInputOperationOutputAlias,
                crate::output::GetCrawlerOutput,
                crate::error::GetCrawlerError,
                crate::input::GetCrawlerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the crawler to retrieve metadata for.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the crawler to retrieve metadata for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCrawlerMetrics`.
    ///
    /// <p>Retrieves metrics about specified crawlers.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCrawlerMetrics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_crawler_metrics_input::Builder,
    }
    impl<C, M, R> GetCrawlerMetrics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCrawlerMetrics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCrawlerMetricsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCrawlerMetricsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCrawlerMetricsInputOperationOutputAlias,
                crate::output::GetCrawlerMetricsOutput,
                crate::error::GetCrawlerMetricsError,
                crate::input::GetCrawlerMetricsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `CrawlerNameList`.
        ///
        /// To override the contents of this collection use [`set_crawler_name_list`](Self::set_crawler_name_list).
        ///
        /// <p>A list of the names of crawlers about which to retrieve metrics.</p>
        pub fn crawler_name_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.crawler_name_list(inp);
            self
        }
        /// <p>A list of the names of crawlers about which to retrieve metrics.</p>
        pub fn set_crawler_name_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_crawler_name_list(input);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCrawlers`.
    ///
    /// <p>Retrieves metadata for all crawlers defined in the customer
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCrawlers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_crawlers_input::Builder,
    }
    impl<C, M, R> GetCrawlers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCrawlers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCrawlersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCrawlersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCrawlersInputOperationOutputAlias,
                crate::output::GetCrawlersOutput,
                crate::error::GetCrawlersError,
                crate::input::GetCrawlersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of crawlers to return on each call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of crawlers to return on each call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDatabase`.
    ///
    /// <p>Retrieves the definition of a specified database.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_database_input::Builder,
    }
    impl<C, M, R> GetDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDatabaseInputOperationOutputAlias,
                crate::output::GetDatabaseOutput,
                crate::error::GetDatabaseError,
                crate::input::GetDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which the database resides. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which the database resides. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the database to retrieve. For Hive compatibility, this
        /// should be all lowercase.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the database to retrieve. For Hive compatibility, this
        /// should be all lowercase.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDatabases`.
    ///
    /// <p>Retrieves all databases defined in a given Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDatabases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_databases_input::Builder,
    }
    impl<C, M, R> GetDatabases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDatabases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDatabasesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDatabasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDatabasesInputOperationOutputAlias,
                crate::output::GetDatabasesOutput,
                crate::error::GetDatabasesError,
                crate::input::GetDatabasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is
        /// provided, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is
        /// provided, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of databases to return in one response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of databases to return in one response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Allows you to specify that you want to list the databases shared with your account. The allowable values are <code>FOREIGN</code> or <code>ALL</code>. </p>
        ///
        /// <ul>
        /// <li>
        /// <p>If set to <code>FOREIGN</code>, will list the databases shared with your account. </p>
        /// </li>
        /// <li>
        /// <p>If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor local account. </p>
        /// </li>
        /// </ul>
        pub fn resource_share_type(mut self, inp: crate::model::ResourceShareType) -> Self {
            self.inner = self.inner.resource_share_type(inp);
            self
        }
        /// <p>Allows you to specify that you want to list the databases shared with your account. The allowable values are <code>FOREIGN</code> or <code>ALL</code>. </p>
        ///
        /// <ul>
        /// <li>
        /// <p>If set to <code>FOREIGN</code>, will list the databases shared with your account. </p>
        /// </li>
        /// <li>
        /// <p>If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor local account. </p>
        /// </li>
        /// </ul>
        pub fn set_resource_share_type(
            mut self,
            input: std::option::Option<crate::model::ResourceShareType>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataCatalogEncryptionSettings`.
    ///
    /// <p>Retrieves the security configuration for a specified catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDataCatalogEncryptionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_data_catalog_encryption_settings_input::Builder,
    }
    impl<C, M, R> GetDataCatalogEncryptionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDataCatalogEncryptionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataCatalogEncryptionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataCatalogEncryptionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDataCatalogEncryptionSettingsInputOperationOutputAlias,
                crate::output::GetDataCatalogEncryptionSettingsOutput,
                crate::error::GetDataCatalogEncryptionSettingsError,
                crate::input::GetDataCatalogEncryptionSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog to retrieve the security configuration for. If none is
        /// provided, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog to retrieve the security configuration for. If none is
        /// provided, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataflowGraph`.
    ///
    /// <p>Transforms a Python script into a directed acyclic graph (DAG). </p>
    #[derive(std::fmt::Debug)]
    pub struct GetDataflowGraph<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dataflow_graph_input::Builder,
    }
    impl<C, M, R> GetDataflowGraph<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDataflowGraph`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataflowGraphOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataflowGraphError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDataflowGraphInputOperationOutputAlias,
                crate::output::GetDataflowGraphOutput,
                crate::error::GetDataflowGraphError,
                crate::input::GetDataflowGraphInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Python script to transform.</p>
        pub fn python_script(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.python_script(inp);
            self
        }
        /// <p>The Python script to transform.</p>
        pub fn set_python_script(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_python_script(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevEndpoint`.
    ///
    /// <p>Retrieves information about a specified development endpoint.</p>
    /// <note>
    /// <p>When you create a development endpoint in a virtual private cloud (VPC), Glue returns only
    /// a private IP address, and the public IP address field is not populated. When you create a
    /// non-VPC development endpoint, Glue returns only a public IP address.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetDevEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dev_endpoint_input::Builder,
    }
    impl<C, M, R> GetDevEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDevEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDevEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDevEndpointInputOperationOutputAlias,
                crate::output::GetDevEndpointOutput,
                crate::error::GetDevEndpointError,
                crate::input::GetDevEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the <code>DevEndpoint</code> to retrieve information for.</p>
        pub fn endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(inp);
            self
        }
        /// <p>Name of the <code>DevEndpoint</code> to retrieve information for.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevEndpoints`.
    ///
    /// <p>Retrieves all the development endpoints in this AWS account.</p>
    /// <note>
    /// <p>When you create a development endpoint in a virtual private cloud (VPC), Glue returns only a private IP address
    /// and the public IP address field is not populated. When you create a non-VPC development
    /// endpoint, Glue returns only a public IP address.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetDevEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dev_endpoints_input::Builder,
    }
    impl<C, M, R> GetDevEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDevEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDevEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDevEndpointsInputOperationOutputAlias,
                crate::output::GetDevEndpointsOutput,
                crate::error::GetDevEndpointsError,
                crate::input::GetDevEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum size of information to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of information to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJob`.
    ///
    /// <p>Retrieves an existing job definition.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_input::Builder,
    }
    impl<C, M, R> GetJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobInputOperationOutputAlias,
                crate::output::GetJobOutput,
                crate::error::GetJobError,
                crate::input::GetJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job definition to retrieve.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the job definition to retrieve.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJobBookmark`.
    ///
    /// <p>Returns information on a job bookmark entry.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetJobBookmark<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_bookmark_input::Builder,
    }
    impl<C, M, R> GetJobBookmark<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJobBookmark`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobBookmarkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobBookmarkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobBookmarkInputOperationOutputAlias,
                crate::output::GetJobBookmarkOutput,
                crate::error::GetJobBookmarkError,
                crate::input::GetJobBookmarkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job in question.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the job in question.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The unique run identifier associated with this job run.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The unique run identifier associated with this job run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJobRun`.
    ///
    /// <p>Retrieves the metadata for a given job run.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetJobRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_run_input::Builder,
    }
    impl<C, M, R> GetJobRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobRunInputOperationOutputAlias,
                crate::output::GetJobRunOutput,
                crate::error::GetJobRunError,
                crate::input::GetJobRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the job definition being run.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>Name of the job definition being run.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The ID of the job run.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The ID of the job run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
        /// <p>True if a list of predecessor runs should be returned.</p>
        pub fn predecessors_included(mut self, inp: bool) -> Self {
            self.inner = self.inner.predecessors_included(inp);
            self
        }
        /// <p>True if a list of predecessor runs should be returned.</p>
        pub fn set_predecessors_included(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_predecessors_included(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJobRuns`.
    ///
    /// <p>Retrieves metadata for all runs of a given job definition.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetJobRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_runs_input::Builder,
    }
    impl<C, M, R> GetJobRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJobRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobRunsInputOperationOutputAlias,
                crate::output::GetJobRunsOutput,
                crate::error::GetJobRunsError,
                crate::input::GetJobRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job definition for which to retrieve all job runs.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the job definition for which to retrieve all job runs.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJobs`.
    ///
    /// <p>Retrieves all current job definitions.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_jobs_input::Builder,
    }
    impl<C, M, R> GetJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobsInputOperationOutputAlias,
                crate::output::GetJobsOutput,
                crate::error::GetJobsError,
                crate::input::GetJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMapping`.
    ///
    /// <p>Creates mappings.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_mapping_input::Builder,
    }
    impl<C, M, R> GetMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMappingInputOperationOutputAlias,
                crate::output::GetMappingOutput,
                crate::error::GetMappingError,
                crate::input::GetMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the source table.</p>
        pub fn source(mut self, inp: crate::model::CatalogEntry) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>Specifies the source table.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::CatalogEntry>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Sinks`.
        ///
        /// To override the contents of this collection use [`set_sinks`](Self::set_sinks).
        ///
        /// <p>A list of target tables.</p>
        pub fn sinks(mut self, inp: impl Into<crate::model::CatalogEntry>) -> Self {
            self.inner = self.inner.sinks(inp);
            self
        }
        /// <p>A list of target tables.</p>
        pub fn set_sinks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CatalogEntry>>,
        ) -> Self {
            self.inner = self.inner.set_sinks(input);
            self
        }
        /// <p>Parameters for the mapping.</p>
        pub fn location(mut self, inp: crate::model::Location) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>Parameters for the mapping.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMLTaskRun`.
    ///
    /// <p>Gets details for a specific task run on a machine learning transform. Machine learning
    /// task runs are asynchronous tasks that Glue runs on your behalf as part of various machine
    /// learning workflows. You can check the stats of any task run by calling
    /// <code>GetMLTaskRun</code> with the <code>TaskRunID</code> and its parent transform's
    /// <code>TransformID</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMLTaskRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ml_task_run_input::Builder,
    }
    impl<C, M, R> GetMLTaskRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMLTaskRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMlTaskRunOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMLTaskRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMlTaskRunInputOperationOutputAlias,
                crate::output::GetMlTaskRunOutput,
                crate::error::GetMLTaskRunError,
                crate::input::GetMlTaskRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn transform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_id(inp);
            self
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_transform_id(input);
            self
        }
        /// <p>The unique identifier of the task run.</p>
        pub fn task_run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_run_id(inp);
            self
        }
        /// <p>The unique identifier of the task run.</p>
        pub fn set_task_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMLTaskRuns`.
    ///
    /// <p>Gets a list of runs for a machine learning transform. Machine learning task runs are
    /// asynchronous tasks that Glue runs on your behalf as part of various machine learning
    /// workflows. You can get a sortable, filterable list of machine learning task runs by calling
    /// <code>GetMLTaskRuns</code> with their parent transform's <code>TransformID</code> and other
    /// optional parameters as documented in this section.</p>
    ///
    /// <p>This operation returns a list of historic runs and must be paginated.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMLTaskRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ml_task_runs_input::Builder,
    }
    impl<C, M, R> GetMLTaskRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMLTaskRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMlTaskRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMLTaskRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMlTaskRunsInputOperationOutputAlias,
                crate::output::GetMlTaskRunsOutput,
                crate::error::GetMLTaskRunsError,
                crate::input::GetMlTaskRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn transform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_id(inp);
            self
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_transform_id(input);
            self
        }
        /// <p>A token for pagination of the results. The default is empty.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token for pagination of the results. The default is empty.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The filter criteria, in the <code>TaskRunFilterCriteria</code> structure, for the task run.</p>
        pub fn filter(mut self, inp: crate::model::TaskRunFilterCriteria) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>The filter criteria, in the <code>TaskRunFilterCriteria</code> structure, for the task run.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TaskRunFilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The sorting criteria, in the <code>TaskRunSortCriteria</code> structure, for the task run.</p>
        pub fn sort(mut self, inp: crate::model::TaskRunSortCriteria) -> Self {
            self.inner = self.inner.sort(inp);
            self
        }
        /// <p>The sorting criteria, in the <code>TaskRunSortCriteria</code> structure, for the task run.</p>
        pub fn set_sort(
            mut self,
            input: std::option::Option<crate::model::TaskRunSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMLTransform`.
    ///
    /// <p>Gets an Glue machine learning transform artifact and all its corresponding metadata.
    /// Machine learning transforms are a special type of transform that use machine learning to learn
    /// the details of the transformation to be performed by learning from examples provided by
    /// humans. These transformations are then saved by Glue. You can retrieve their metadata by
    /// calling <code>GetMLTransform</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMLTransform<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ml_transform_input::Builder,
    }
    impl<C, M, R> GetMLTransform<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMLTransform`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMlTransformOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMLTransformError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMlTransformInputOperationOutputAlias,
                crate::output::GetMlTransformOutput,
                crate::error::GetMLTransformError,
                crate::input::GetMlTransformInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the transform, generated at the time that the transform was
        /// created.</p>
        pub fn transform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_id(inp);
            self
        }
        /// <p>The unique identifier of the transform, generated at the time that the transform was
        /// created.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_transform_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMLTransforms`.
    ///
    /// <p>Gets a sortable, filterable list of existing Glue machine learning transforms. Machine
    /// learning transforms are a special type of transform that use machine learning to learn the
    /// details of the transformation to be performed by learning from examples provided by humans.
    /// These transformations are then saved by Glue, and you can retrieve their metadata by
    /// calling <code>GetMLTransforms</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMLTransforms<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ml_transforms_input::Builder,
    }
    impl<C, M, R> GetMLTransforms<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMLTransforms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMlTransformsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMLTransformsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMlTransformsInputOperationOutputAlias,
                crate::output::GetMlTransformsOutput,
                crate::error::GetMLTransformsError,
                crate::input::GetMlTransformsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A paginated token to offset the results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A paginated token to offset the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The filter transformation criteria.</p>
        pub fn filter(mut self, inp: crate::model::TransformFilterCriteria) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>The filter transformation criteria.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TransformFilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn sort(mut self, inp: crate::model::TransformSortCriteria) -> Self {
            self.inner = self.inner.sort(inp);
            self
        }
        /// <p>The sorting criteria.</p>
        pub fn set_sort(
            mut self,
            input: std::option::Option<crate::model::TransformSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPartition`.
    ///
    /// <p>Retrieves information about a specified partition.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_partition_input::Builder,
    }
    impl<C, M, R> GetPartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPartitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPartitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPartitionInputOperationOutputAlias,
                crate::output::GetPartitionOutput,
                crate::error::GetPartitionError,
                crate::input::GetPartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partition in question resides. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partition in question resides. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the partition resides.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the partition resides.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partition's table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the partition's table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `PartitionValues`.
        ///
        /// To override the contents of this collection use [`set_partition_values`](Self::set_partition_values).
        ///
        /// <p>The values that define the partition.</p>
        pub fn partition_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partition_values(inp);
            self
        }
        /// <p>The values that define the partition.</p>
        pub fn set_partition_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_partition_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPartitionIndexes`.
    ///
    /// <p>Retrieves the partition indexes associated with a table.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPartitionIndexes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_partition_indexes_input::Builder,
    }
    impl<C, M, R> GetPartitionIndexes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPartitionIndexes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPartitionIndexesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPartitionIndexesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPartitionIndexesInputOperationOutputAlias,
                crate::output::GetPartitionIndexesOutput,
                crate::error::GetPartitionIndexesError,
                crate::input::GetPartitionIndexesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The catalog ID where the table resides.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The catalog ID where the table resides.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>Specifies the name of a database from which you want to retrieve partition indexes.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>Specifies the name of a database from which you want to retrieve partition indexes.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>Specifies the name of a table for which you want to retrieve the partition indexes.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>Specifies the name of a table for which you want to retrieve the partition indexes.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>A continuation token, included if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, included if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPartitions`.
    ///
    /// <p>Retrieves information about the partitions in a table.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPartitions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_partitions_input::Builder,
    }
    impl<C, M, R> GetPartitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPartitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPartitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPartitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPartitionsInputOperationOutputAlias,
                crate::output::GetPartitionsOutput,
                crate::error::GetPartitionsError,
                crate::input::GetPartitionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>An expression that filters the partitions to be returned.</p>
        /// <p>The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The
        /// SQL statement parser <a href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression. </p>
        /// <p>
        /// <i>Operators</i>: The following are the operators that you can use in the
        /// <code>Expression</code> API call:</p>
        /// <dl>
        /// <dt>=</dt>
        /// <dd>
        /// <p>Checks whether the values of the two operands are equal; if yes, then the condition becomes
        /// true.</p>
        /// <p>Example: Assume 'variable a' holds 10 and 'variable b' holds 20. </p>
        /// <p>(a = b) is not true.</p>
        /// </dd>
        /// <dt>< ></dt>
        /// <dd>
        /// <p>Checks whether the values of two operands are equal; if the values are not equal,
        /// then the condition becomes true.</p>
        /// <p>Example: (a < > b) is true.</p>
        /// </dd>
        /// <dt>></dt>
        /// <dd>
        /// <p>Checks whether the value of the left operand is greater than the value of the right
        /// operand; if yes, then the condition becomes true.</p>
        /// <p>Example: (a > b) is not true.</p>
        /// </dd>
        /// <dt><</dt>
        /// <dd>
        /// <p>Checks whether the value of the left operand is less than the value of the right
        /// operand; if yes, then the condition becomes true.</p>
        /// <p>Example: (a < b) is true.</p>
        /// </dd>
        /// <dt>>=</dt>
        /// <dd>
        /// <p>Checks whether the value of the left operand is greater than or equal to the value
        /// of the right operand; if yes, then the condition becomes true.</p>
        /// <p>Example: (a >= b) is not true.</p>
        /// </dd>
        /// <dt><=</dt>
        /// <dd>
        /// <p>Checks whether the value of the left operand is less than or equal to the value of
        /// the right operand; if yes, then the condition becomes true.</p>
        /// <p>Example: (a <= b) is true.</p>
        /// </dd>
        /// <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
        /// <dd>
        /// <p>Logical operators.</p>
        /// </dd>
        /// </dl>
        /// <p>
        /// <i>Supported Partition Key Types</i>: The following are the supported
        /// partition keys.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>string</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>date</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>timestamp</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>int</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>bigint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>long</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tinyint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>smallint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>decimal</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If an type is encountered that is not valid, an exception is thrown. </p>
        /// <p>The following list shows the valid operators on each type. When you define a crawler, the
        /// <code>partitionKey</code> type is created as a <code>STRING</code>, to be compatible with the catalog
        /// partitions. </p>
        ///
        /// <p>
        /// <i>Sample API Call</i>: </p>
        pub fn expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(inp);
            self
        }
        /// <p>An expression that filters the partitions to be returned.</p>
        /// <p>The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The
        /// SQL statement parser <a href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression. </p>
        /// <p>
        /// <i>Operators</i>: The following are the operators that you can use in the
        /// <code>Expression</code> API call:</p>
        /// <dl>
        /// <dt>=</dt>
        /// <dd>
        /// <p>Checks whether the values of the two operands are equal; if yes, then the condition becomes
        /// true.</p>
        /// <p>Example: Assume 'variable a' holds 10 and 'variable b' holds 20. </p>
        /// <p>(a = b) is not true.</p>
        /// </dd>
        /// <dt>< ></dt>
        /// <dd>
        /// <p>Checks whether the values of two operands are equal; if the values are not equal,
        /// then the condition becomes true.</p>
        /// <p>Example: (a < > b) is true.</p>
        /// </dd>
        /// <dt>></dt>
        /// <dd>
        /// <p>Checks whether the value of the left operand is greater than the value of the right
        /// operand; if yes, then the condition becomes true.</p>
        /// <p>Example: (a > b) is not true.</p>
        /// </dd>
        /// <dt><</dt>
        /// <dd>
        /// <p>Checks whether the value of the left operand is less than the value of the right
        /// operand; if yes, then the condition becomes true.</p>
        /// <p>Example: (a < b) is true.</p>
        /// </dd>
        /// <dt>>=</dt>
        /// <dd>
        /// <p>Checks whether the value of the left operand is greater than or equal to the value
        /// of the right operand; if yes, then the condition becomes true.</p>
        /// <p>Example: (a >= b) is not true.</p>
        /// </dd>
        /// <dt><=</dt>
        /// <dd>
        /// <p>Checks whether the value of the left operand is less than or equal to the value of
        /// the right operand; if yes, then the condition becomes true.</p>
        /// <p>Example: (a <= b) is true.</p>
        /// </dd>
        /// <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt>
        /// <dd>
        /// <p>Logical operators.</p>
        /// </dd>
        /// </dl>
        /// <p>
        /// <i>Supported Partition Key Types</i>: The following are the supported
        /// partition keys.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>string</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>date</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>timestamp</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>int</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>bigint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>long</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tinyint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>smallint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>decimal</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If an type is encountered that is not valid, an exception is thrown. </p>
        /// <p>The following list shows the valid operators on each type. When you define a crawler, the
        /// <code>partitionKey</code> type is created as a <code>STRING</code>, to be compatible with the catalog
        /// partitions. </p>
        ///
        /// <p>
        /// <i>Sample API Call</i>: </p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve
        /// these partitions.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is not the first call to retrieve
        /// these partitions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The segment of the table's partitions to scan in this request.</p>
        pub fn segment(mut self, inp: crate::model::Segment) -> Self {
            self.inner = self.inner.segment(inp);
            self
        }
        /// <p>The segment of the table's partitions to scan in this request.</p>
        pub fn set_segment(mut self, input: std::option::Option<crate::model::Segment>) -> Self {
            self.inner = self.inner.set_segment(input);
            self
        }
        /// <p>The maximum number of partitions to return in a single response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of partitions to return in a single response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>When true, specifies not returning the partition column schema. Useful when you are interested only in other partition attributes such as partition values or location. This approach avoids the problem of a large response by not returning duplicate data.</p>
        pub fn exclude_column_schema(mut self, inp: bool) -> Self {
            self.inner = self.inner.exclude_column_schema(inp);
            self
        }
        /// <p>When true, specifies not returning the partition column schema. Useful when you are interested only in other partition attributes such as partition values or location. This approach avoids the problem of a large response by not returning duplicate data.</p>
        pub fn set_exclude_column_schema(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exclude_column_schema(input);
            self
        }
        /// <p>The transaction ID at which to read the partition contents.</p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The transaction ID at which to read the partition contents.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
        /// <p>The time as of when to read the partition contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn query_as_of_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.query_as_of_time(inp);
            self
        }
        /// <p>The time as of when to read the partition contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn set_query_as_of_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_query_as_of_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPlan`.
    ///
    /// <p>Gets code to perform a specified mapping.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPlan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_plan_input::Builder,
    }
    impl<C, M, R> GetPlan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPlan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPlanOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPlanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPlanInputOperationOutputAlias,
                crate::output::GetPlanOutput,
                crate::error::GetPlanError,
                crate::input::GetPlanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Mapping`.
        ///
        /// To override the contents of this collection use [`set_mapping`](Self::set_mapping).
        ///
        /// <p>The list of mappings from a source table to target tables.</p>
        pub fn mapping(mut self, inp: impl Into<crate::model::MappingEntry>) -> Self {
            self.inner = self.inner.mapping(inp);
            self
        }
        /// <p>The list of mappings from a source table to target tables.</p>
        pub fn set_mapping(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MappingEntry>>,
        ) -> Self {
            self.inner = self.inner.set_mapping(input);
            self
        }
        /// <p>The source table.</p>
        pub fn source(mut self, inp: crate::model::CatalogEntry) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>The source table.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::CatalogEntry>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `Sinks`.
        ///
        /// To override the contents of this collection use [`set_sinks`](Self::set_sinks).
        ///
        /// <p>The target tables.</p>
        pub fn sinks(mut self, inp: impl Into<crate::model::CatalogEntry>) -> Self {
            self.inner = self.inner.sinks(inp);
            self
        }
        /// <p>The target tables.</p>
        pub fn set_sinks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CatalogEntry>>,
        ) -> Self {
            self.inner = self.inner.set_sinks(input);
            self
        }
        /// <p>The parameters for the mapping.</p>
        pub fn location(mut self, inp: crate::model::Location) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>The parameters for the mapping.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The programming language of the code to perform the mapping.</p>
        pub fn language(mut self, inp: crate::model::Language) -> Self {
            self.inner = self.inner.language(inp);
            self
        }
        /// <p>The programming language of the code to perform the mapping.</p>
        pub fn set_language(mut self, input: std::option::Option<crate::model::Language>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
        /// Adds a key-value pair to `AdditionalPlanOptionsMap`.
        ///
        /// To override the contents of this collection use [`set_additional_plan_options_map`](Self::set_additional_plan_options_map).
        ///
        /// <p>A map to hold additional optional key-value parameters.</p>
        ///
        /// <p>Currently, these key-value pairs are supported:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>inferSchema</code>  —  Specifies whether to set <code>inferSchema</code> to true or false for the default script generated by an Glue job. For example, to set <code>inferSchema</code> to true, pass the following key value pair:</p>
        /// <p>
        /// <code>--additional-plan-options-map '{"inferSchema":"true"}'</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn additional_plan_options_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_plan_options_map(k, v);
            self
        }
        /// <p>A map to hold additional optional key-value parameters.</p>
        ///
        /// <p>Currently, these key-value pairs are supported:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>inferSchema</code>  —  Specifies whether to set <code>inferSchema</code> to true or false for the default script generated by an Glue job. For example, to set <code>inferSchema</code> to true, pass the following key value pair:</p>
        /// <p>
        /// <code>--additional-plan-options-map '{"inferSchema":"true"}'</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_additional_plan_options_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_plan_options_map(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegistry`.
    ///
    /// <p>Describes the specified registry in detail.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRegistry<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_registry_input::Builder,
    }
    impl<C, M, R> GetRegistry<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRegistry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegistryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegistryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRegistryInputOperationOutputAlias,
                crate::output::GetRegistryOutput,
                crate::error::GetRegistryError,
                crate::input::GetRegistryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).</p>
        pub fn registry_id(mut self, inp: crate::model::RegistryId) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).</p>
        pub fn set_registry_id(
            mut self,
            input: std::option::Option<crate::model::RegistryId>,
        ) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicies`.
    ///
    /// <p>Retrieves the resource policies set on individual resources by Resource Access Manager
    /// during cross-account permission grants. Also retrieves the Data Catalog resource
    /// policy.</p>
    /// <p>If you enabled metadata encryption in Data Catalog settings, and you do not have
    /// permission on the KMS key, the operation can't return the Data Catalog resource
    /// policy.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourcePolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_policies_input::Builder,
    }
    impl<C, M, R> GetResourcePolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourcePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcePoliciesInputOperationOutputAlias,
                crate::output::GetResourcePoliciesOutput,
                crate::error::GetResourcePoliciesError,
                crate::input::GetResourcePoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicy`.
    ///
    /// <p>Retrieves a specified resource policy.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_policy_input::Builder,
    }
    impl<C, M, R> GetResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcePolicyInputOperationOutputAlias,
                crate::output::GetResourcePolicyOutput,
                crate::error::GetResourcePolicyError,
                crate::input::GetResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Glue resource for which to retrieve the resource policy. If not
        /// supplied, the Data Catalog resource policy is returned. Use <code>GetResourcePolicies</code>
        /// to view all existing resource policies. For more information see <a href="https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html">Specifying Glue Resource ARNs</a>.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the Glue resource for which to retrieve the resource policy. If not
        /// supplied, the Data Catalog resource policy is returned. Use <code>GetResourcePolicies</code>
        /// to view all existing resource policies. For more information see <a href="https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html">Specifying Glue Resource ARNs</a>.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSchema`.
    ///
    /// <p>Describes the specified schema in detail.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_schema_input::Builder,
    }
    impl<C, M, R> GetSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSchemaInputOperationOutputAlias,
                crate::output::GetSchemaOutput,
                crate::error::GetSchemaError,
                crate::input::GetSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSchemaByDefinition`.
    ///
    /// <p>Retrieves a schema by the <code>SchemaDefinition</code>. The schema definition is sent to the Schema Registry, canonicalized, and hashed. If the hash is matched within the scope of the <code>SchemaName</code> or ARN (or the default registry, if none is supplied), that schema’s metadata is returned. Otherwise, a 404 or NotFound error is returned. Schema versions in <code>Deleted</code> statuses will not be included in the results.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSchemaByDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_schema_by_definition_input::Builder,
    }
    impl<C, M, R> GetSchemaByDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSchemaByDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSchemaByDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSchemaByDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSchemaByDefinitionInputOperationOutputAlias,
                crate::output::GetSchemaByDefinitionOutput,
                crate::error::GetSchemaByDefinitionError,
                crate::input::GetSchemaByDefinitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
        /// <p>The definition of the schema for which schema details are required.</p>
        pub fn schema_definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_definition(inp);
            self
        }
        /// <p>The definition of the schema for which schema details are required.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSchemaVersion`.
    ///
    /// <p>Get the specified schema by its unique ID assigned when a version of the schema is created or registered. Schema versions in Deleted status will not be included in the results.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSchemaVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_schema_version_input::Builder,
    }
    impl<C, M, R> GetSchemaVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSchemaVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSchemaVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSchemaVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSchemaVersionInputOperationOutputAlias,
                crate::output::GetSchemaVersionOutput,
                crate::error::GetSchemaVersionError,
                crate::input::GetSchemaVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
        /// <p>The <code>SchemaVersionId</code> of the schema version. This field is required for fetching by schema ID. Either this or the <code>SchemaId</code> wrapper has to be provided.</p>
        pub fn schema_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_version_id(inp);
            self
        }
        /// <p>The <code>SchemaVersionId</code> of the schema version. This field is required for fetching by schema ID. Either this or the <code>SchemaId</code> wrapper has to be provided.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_version_id(input);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn schema_version_number(mut self, inp: crate::model::SchemaVersionNumber) -> Self {
            self.inner = self.inner.schema_version_number(inp);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_schema_version_number(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionNumber>,
        ) -> Self {
            self.inner = self.inner.set_schema_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSchemaVersionsDiff`.
    ///
    /// <p>Fetches the schema version difference in the specified difference type between two stored schema versions in the Schema Registry.</p>
    /// <p>This API allows you to compare two schema versions between two schema definitions under the same schema.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSchemaVersionsDiff<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_schema_versions_diff_input::Builder,
    }
    impl<C, M, R> GetSchemaVersionsDiff<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSchemaVersionsDiff`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSchemaVersionsDiffOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSchemaVersionsDiffError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSchemaVersionsDiffInputOperationOutputAlias,
                crate::output::GetSchemaVersionsDiffOutput,
                crate::error::GetSchemaVersionsDiffError,
                crate::input::GetSchemaVersionsDiffInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
        /// <p>The first of the two schema versions to be compared.</p>
        pub fn first_schema_version_number(
            mut self,
            inp: crate::model::SchemaVersionNumber,
        ) -> Self {
            self.inner = self.inner.first_schema_version_number(inp);
            self
        }
        /// <p>The first of the two schema versions to be compared.</p>
        pub fn set_first_schema_version_number(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionNumber>,
        ) -> Self {
            self.inner = self.inner.set_first_schema_version_number(input);
            self
        }
        /// <p>The second of the two schema versions to be compared.</p>
        pub fn second_schema_version_number(
            mut self,
            inp: crate::model::SchemaVersionNumber,
        ) -> Self {
            self.inner = self.inner.second_schema_version_number(inp);
            self
        }
        /// <p>The second of the two schema versions to be compared.</p>
        pub fn set_second_schema_version_number(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionNumber>,
        ) -> Self {
            self.inner = self.inner.set_second_schema_version_number(input);
            self
        }
        /// <p>Refers to <code>SYNTAX_DIFF</code>, which is the currently supported diff type.</p>
        pub fn schema_diff_type(mut self, inp: crate::model::SchemaDiffType) -> Self {
            self.inner = self.inner.schema_diff_type(inp);
            self
        }
        /// <p>Refers to <code>SYNTAX_DIFF</code>, which is the currently supported diff type.</p>
        pub fn set_schema_diff_type(
            mut self,
            input: std::option::Option<crate::model::SchemaDiffType>,
        ) -> Self {
            self.inner = self.inner.set_schema_diff_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSecurityConfiguration`.
    ///
    /// <p>Retrieves a specified security configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSecurityConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_security_configuration_input::Builder,
    }
    impl<C, M, R> GetSecurityConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSecurityConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSecurityConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSecurityConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSecurityConfigurationInputOperationOutputAlias,
                crate::output::GetSecurityConfigurationOutput,
                crate::error::GetSecurityConfigurationError,
                crate::input::GetSecurityConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security configuration to retrieve.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the security configuration to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSecurityConfigurations`.
    ///
    /// <p>Retrieves a list of all security configurations.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSecurityConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_security_configurations_input::Builder,
    }
    impl<C, M, R> GetSecurityConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSecurityConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSecurityConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSecurityConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSecurityConfigurationsInputOperationOutputAlias,
                crate::output::GetSecurityConfigurationsOutput,
                crate::error::GetSecurityConfigurationsError,
                crate::input::GetSecurityConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTable`.
    ///
    /// <p>Retrieves the <code>Table</code> definition in a Data Catalog for
    /// a specified table.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_table_input::Builder,
    }
    impl<C, M, R> GetTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTableOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTableInputOperationOutputAlias,
                crate::output::GetTableOutput,
                crate::error::GetTableError,
                crate::input::GetTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the database in the catalog in which the table resides.
        /// For Hive compatibility, this name is entirely lowercase.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the database in the catalog in which the table resides.
        /// For Hive compatibility, this name is entirely lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the table for which to retrieve the definition. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the table for which to retrieve the definition. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The transaction ID at which to read the table contents. </p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The transaction ID at which to read the table contents. </p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
        /// <p>The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn query_as_of_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.query_as_of_time(inp);
            self
        }
        /// <p>The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn set_query_as_of_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_query_as_of_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTables`.
    ///
    /// <p>Retrieves the definitions of some or all of the tables in a given
    /// <code>Database</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTables<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_tables_input::Builder,
    }
    impl<C, M, R> GetTables<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTablesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTablesInputOperationOutputAlias,
                crate::output::GetTablesOutput,
                crate::error::GetTablesError,
                crate::input::GetTablesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database in the catalog whose tables to list. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The database in the catalog whose tables to list. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>A regular expression pattern. If present, only those tables
        /// whose names match the pattern are returned.</p>
        pub fn expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(inp);
            self
        }
        /// <p>A regular expression pattern. If present, only those tables
        /// whose names match the pattern are returned.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>A continuation token, included if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, included if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of tables to return in a single response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of tables to return in a single response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The transaction ID at which to read the table contents.</p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The transaction ID at which to read the table contents.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
        /// <p>The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn query_as_of_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.query_as_of_time(inp);
            self
        }
        /// <p>The time as of when to read the table contents. If not set, the most recent transaction commit time will be used. Cannot be specified along with <code>TransactionId</code>.</p>
        pub fn set_query_as_of_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_query_as_of_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTableVersion`.
    ///
    /// <p>Retrieves a specified version of a table.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTableVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_table_version_input::Builder,
    }
    impl<C, M, R> GetTableVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTableVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTableVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTableVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTableVersionInputOperationOutputAlias,
                crate::output::GetTableVersionOutput,
                crate::error::GetTableVersionError,
                crate::input::GetTableVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database in the catalog in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The database in the catalog in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the table. For Hive compatibility,
        /// this name is entirely lowercase.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table. For Hive compatibility,
        /// this name is entirely lowercase.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>The ID value of the table version to be retrieved. A <code>VersionID</code> is a string representation of an integer. Each version is incremented by 1. </p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The ID value of the table version to be retrieved. A <code>VersionID</code> is a string representation of an integer. Each version is incremented by 1. </p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTableVersions`.
    ///
    /// <p>Retrieves a list of strings that identify available versions of
    /// a specified table.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTableVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_table_versions_input::Builder,
    }
    impl<C, M, R> GetTableVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTableVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTableVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTableVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTableVersionsInputOperationOutputAlias,
                crate::output::GetTableVersionsOutput,
                crate::error::GetTableVersionsError,
                crate::input::GetTableVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The database in the catalog in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The database in the catalog in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the table. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// <p>A continuation token, if this is not the first call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is not the first call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of table versions to return in one response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of table versions to return in one response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTags`.
    ///
    /// <p>Retrieves a list of tags associated with a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_tags_input::Builder,
    }
    impl<C, M, R> GetTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTagsInputOperationOutputAlias,
                crate::output::GetTagsOutput,
                crate::error::GetTagsError,
                crate::input::GetTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which to retrieve tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which to retrieve tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrigger`.
    ///
    /// <p>Retrieves the definition of a trigger.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTrigger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_trigger_input::Builder,
    }
    impl<C, M, R> GetTrigger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTrigger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTriggerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTriggerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTriggerInputOperationOutputAlias,
                crate::output::GetTriggerOutput,
                crate::error::GetTriggerError,
                crate::input::GetTriggerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the trigger to retrieve.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the trigger to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTriggers`.
    ///
    /// <p>Gets all the triggers associated with a job.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTriggers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_triggers_input::Builder,
    }
    impl<C, M, R> GetTriggers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTriggers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTriggersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTriggersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTriggersInputOperationOutputAlias,
                crate::output::GetTriggersOutput,
                crate::error::GetTriggersError,
                crate::input::GetTriggersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The name of the job to retrieve triggers for. The trigger that can start this job is
        /// returned, and if there is no such trigger, all triggers are returned.</p>
        pub fn dependent_job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dependent_job_name(inp);
            self
        }
        /// <p>The name of the job to retrieve triggers for. The trigger that can start this job is
        /// returned, and if there is no such trigger, all triggers are returned.</p>
        pub fn set_dependent_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dependent_job_name(input);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserDefinedFunction`.
    ///
    /// <p>Retrieves a specified function definition from the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUserDefinedFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_defined_function_input::Builder,
    }
    impl<C, M, R> GetUserDefinedFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserDefinedFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserDefinedFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserDefinedFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserDefinedFunctionInputOperationOutputAlias,
                crate::output::GetUserDefinedFunctionOutput,
                crate::error::GetUserDefinedFunctionError,
                crate::input::GetUserDefinedFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the function to be retrieved is located. If none is
        /// provided, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the function to be retrieved is located. If none is
        /// provided, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the function is located.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the function is located.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the function.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the function.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserDefinedFunctions`.
    ///
    /// <p>Retrieves multiple function definitions from the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUserDefinedFunctions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_defined_functions_input::Builder,
    }
    impl<C, M, R> GetUserDefinedFunctions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserDefinedFunctions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserDefinedFunctionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserDefinedFunctionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserDefinedFunctionsInputOperationOutputAlias,
                crate::output::GetUserDefinedFunctionsOutput,
                crate::error::GetUserDefinedFunctionsError,
                crate::input::GetUserDefinedFunctionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the functions to be retrieved are located. If none is
        /// provided, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the functions to be retrieved are located. If none is
        /// provided, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the functions are located. If none is provided, functions from all the
        /// databases across the catalog will be returned.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the functions are located. If none is provided, functions from all the
        /// databases across the catalog will be returned.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>An optional function-name pattern string that filters the function
        /// definitions returned.</p>
        pub fn pattern(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pattern(inp);
            self
        }
        /// <p>An optional function-name pattern string that filters the function
        /// definitions returned.</p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_pattern(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of functions to return in one response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of functions to return in one response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkflow`.
    ///
    /// <p>Retrieves resource metadata for a workflow.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWorkflow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_workflow_input::Builder,
    }
    impl<C, M, R> GetWorkflow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkflow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkflowOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkflowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkflowInputOperationOutputAlias,
                crate::output::GetWorkflowOutput,
                crate::error::GetWorkflowError,
                crate::input::GetWorkflowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the workflow to retrieve.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the workflow to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether to include a graph when returning the workflow resource metadata.</p>
        pub fn include_graph(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_graph(inp);
            self
        }
        /// <p>Specifies whether to include a graph when returning the workflow resource metadata.</p>
        pub fn set_include_graph(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_graph(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkflowRun`.
    ///
    /// <p>Retrieves the metadata for a given workflow run. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetWorkflowRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_workflow_run_input::Builder,
    }
    impl<C, M, R> GetWorkflowRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkflowRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkflowRunOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkflowRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkflowRunInputOperationOutputAlias,
                crate::output::GetWorkflowRunOutput,
                crate::error::GetWorkflowRunError,
                crate::input::GetWorkflowRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the workflow being run.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the workflow being run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the workflow run.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The ID of the workflow run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
        /// <p>Specifies whether to include the workflow graph in response or not.</p>
        pub fn include_graph(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_graph(inp);
            self
        }
        /// <p>Specifies whether to include the workflow graph in response or not.</p>
        pub fn set_include_graph(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_graph(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkflowRunProperties`.
    ///
    /// <p>Retrieves the workflow run properties which were set during the run.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWorkflowRunProperties<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_workflow_run_properties_input::Builder,
    }
    impl<C, M, R> GetWorkflowRunProperties<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkflowRunProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkflowRunPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkflowRunPropertiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkflowRunPropertiesInputOperationOutputAlias,
                crate::output::GetWorkflowRunPropertiesOutput,
                crate::error::GetWorkflowRunPropertiesError,
                crate::input::GetWorkflowRunPropertiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the workflow which was run.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the workflow which was run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the workflow run whose run properties should be returned.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The ID of the workflow run whose run properties should be returned.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkflowRuns`.
    ///
    /// <p>Retrieves metadata for all runs of a given workflow.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWorkflowRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_workflow_runs_input::Builder,
    }
    impl<C, M, R> GetWorkflowRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkflowRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkflowRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkflowRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkflowRunsInputOperationOutputAlias,
                crate::output::GetWorkflowRunsOutput,
                crate::error::GetWorkflowRunsError,
                crate::input::GetWorkflowRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the workflow whose metadata of runs should be returned.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the workflow whose metadata of runs should be returned.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies whether to include the workflow graph in response or not.</p>
        pub fn include_graph(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_graph(inp);
            self
        }
        /// <p>Specifies whether to include the workflow graph in response or not.</p>
        pub fn set_include_graph(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_graph(input);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The maximum size of the response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of workflow runs to be included in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of workflow runs to be included in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportCatalogToGlue`.
    ///
    /// <p>Imports an existing Amazon Athena Data Catalog to Glue.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportCatalogToGlue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_catalog_to_glue_input::Builder,
    }
    impl<C, M, R> ImportCatalogToGlue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportCatalogToGlue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportCatalogToGlueOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportCatalogToGlueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportCatalogToGlueInputOperationOutputAlias,
                crate::output::ImportCatalogToGlueOutput,
                crate::error::ImportCatalogToGlueError,
                crate::input::ImportCatalogToGlueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the catalog to import. Currently, this should be the Amazon Web Services account ID.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the catalog to import. Currently, this should be the Amazon Web Services account ID.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBlueprints`.
    ///
    /// <p>Lists all the blueprint names in an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBlueprints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_blueprints_input::Builder,
    }
    impl<C, M, R> ListBlueprints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBlueprints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBlueprintsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBlueprintsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBlueprintsInputOperationOutputAlias,
                crate::output::ListBlueprintsOutput,
                crate::error::ListBlueprintsError,
                crate::input::ListBlueprintsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Filters the list by an Amazon Web Services resource tag.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Filters the list by an Amazon Web Services resource tag.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCrawlers`.
    ///
    /// <p>Retrieves the names of all crawler resources in this Amazon Web Services account, or the
    /// resources with the specified tag. This operation allows you to see which
    /// resources are available in your account, and their names.</p>
    ///
    /// <p>This operation takes the optional <code>Tags</code> field, which you can use as a filter on
    /// the response so that tagged resources can be retrieved as a group. If you choose to use tags
    /// filtering, only resources with the tag are retrieved.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCrawlers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_crawlers_input::Builder,
    }
    impl<C, M, R> ListCrawlers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCrawlers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCrawlersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCrawlersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCrawlersInputOperationOutputAlias,
                crate::output::ListCrawlersOutput,
                crate::error::ListCrawlersError,
                crate::input::ListCrawlersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies to return only these tagged resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Specifies to return only these tagged resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevEndpoints`.
    ///
    /// <p>Retrieves the names of all <code>DevEndpoint</code> resources in this Amazon Web Services account, or the
    /// resources with the specified tag. This operation allows you to see which resources are
    /// available in your account, and their names.</p>
    ///
    /// <p>This operation takes the optional <code>Tags</code> field, which you can use as a filter on
    /// the response so that tagged resources can be retrieved as a group. If you choose to use tags
    /// filtering, only resources with the tag are retrieved.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDevEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dev_endpoints_input::Builder,
    }
    impl<C, M, R> ListDevEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDevEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDevEndpointsInputOperationOutputAlias,
                crate::output::ListDevEndpointsOutput,
                crate::error::ListDevEndpointsError,
                crate::input::ListDevEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies to return only these tagged resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Specifies to return only these tagged resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p>Retrieves the names of all job resources in this Amazon Web Services account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names.</p>
    ///
    /// <p>This operation takes the optional <code>Tags</code> field, which you can use as a filter on
    /// the response so that tagged resources can be retrieved as a group. If you choose to use tags
    /// filtering, only resources with the tag are retrieved.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl<C, M, R> ListJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobsInputOperationOutputAlias,
                crate::output::ListJobsOutput,
                crate::error::ListJobsError,
                crate::input::ListJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies to return only these tagged resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Specifies to return only these tagged resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMLTransforms`.
    ///
    /// <p> Retrieves a sortable, filterable list of existing Glue machine learning transforms in this Amazon Web Services account,
    /// or the resources with the specified tag. This operation takes the optional <code>Tags</code> field, which you can use as
    /// a filter of the responses so that tagged resources can be retrieved as a group. If you choose to use tag
    /// filtering, only resources with the tags are retrieved.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListMLTransforms<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ml_transforms_input::Builder,
    }
    impl<C, M, R> ListMLTransforms<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMLTransforms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMlTransformsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMLTransformsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMlTransformsInputOperationOutputAlias,
                crate::output::ListMlTransformsOutput,
                crate::error::ListMLTransformsError,
                crate::input::ListMlTransformsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A <code>TransformFilterCriteria</code> used to filter the machine learning transforms.</p>
        pub fn filter(mut self, inp: crate::model::TransformFilterCriteria) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>A <code>TransformFilterCriteria</code> used to filter the machine learning transforms.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TransformFilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>A <code>TransformSortCriteria</code> used to sort the machine learning transforms.</p>
        pub fn sort(mut self, inp: crate::model::TransformSortCriteria) -> Self {
            self.inner = self.inner.sort(inp);
            self
        }
        /// <p>A <code>TransformSortCriteria</code> used to sort the machine learning transforms.</p>
        pub fn set_sort(
            mut self,
            input: std::option::Option<crate::model::TransformSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies to return only these tagged resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Specifies to return only these tagged resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRegistries`.
    ///
    /// <p>Returns a list of registries that you have created, with minimal registry information. Registries in the <code>Deleting</code> status will not be included in the results. Empty results will be returned if there are no registries available.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRegistries<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_registries_input::Builder,
    }
    impl<C, M, R> ListRegistries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRegistries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRegistriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRegistriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRegistriesInputOperationOutputAlias,
                crate::output::ListRegistriesOutput,
                crate::error::ListRegistriesError,
                crate::input::ListRegistriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSchemas`.
    ///
    /// <p>Returns a list of schemas with minimal details. Schemas in Deleting status will not be included in the results. Empty results will be returned if there are no schemas available.</p>
    /// <p>When the <code>RegistryId</code> is not provided, all the schemas across registries will be part of the API response.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSchemas<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_schemas_input::Builder,
    }
    impl<C, M, R> ListSchemas<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSchemas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSchemasOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSchemasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSchemasInputOperationOutputAlias,
                crate::output::ListSchemasOutput,
                crate::error::ListSchemasError,
                crate::input::ListSchemasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A wrapper structure that may contain the registry name and Amazon Resource Name (ARN).</p>
        pub fn registry_id(mut self, inp: crate::model::RegistryId) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>A wrapper structure that may contain the registry name and Amazon Resource Name (ARN).</p>
        pub fn set_registry_id(
            mut self,
            input: std::option::Option<crate::model::RegistryId>,
        ) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSchemaVersions`.
    ///
    /// <p>Returns a list of schema versions that you have created, with minimal information. Schema versions in Deleted status will not be included in the results. Empty results will be returned if there are no schema versions available.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSchemaVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_schema_versions_input::Builder,
    }
    impl<C, M, R> ListSchemaVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSchemaVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSchemaVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSchemaVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSchemaVersionsInputOperationOutputAlias,
                crate::output::ListSchemaVersionsOutput,
                crate::error::ListSchemaVersionsError,
                crate::input::ListSchemaVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
        /// <p>Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTriggers`.
    ///
    /// <p>Retrieves the names of all trigger resources in this Amazon Web Services account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names.</p>
    ///
    /// <p>This operation takes the optional <code>Tags</code> field, which you can use as a filter on
    /// the response so that tagged resources can be retrieved as a group. If you choose to use tags
    /// filtering, only resources with the tag are retrieved.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTriggers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_triggers_input::Builder,
    }
    impl<C, M, R> ListTriggers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTriggers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTriggersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTriggersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTriggersInputOperationOutputAlias,
                crate::output::ListTriggersOutput,
                crate::error::ListTriggersError,
                crate::input::ListTriggersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The name of the job for which to retrieve triggers. The trigger that can start this job
        /// is returned. If there is no such trigger, all triggers are returned.</p>
        pub fn dependent_job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dependent_job_name(inp);
            self
        }
        /// <p> The name of the job for which to retrieve triggers. The trigger that can start this job
        /// is returned. If there is no such trigger, all triggers are returned.</p>
        pub fn set_dependent_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dependent_job_name(input);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Specifies to return only these tagged resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Specifies to return only these tagged resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkflows`.
    ///
    /// <p>Lists names of workflows created in the account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWorkflows<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_workflows_input::Builder,
    }
    impl<C, M, R> ListWorkflows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkflows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkflowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkflowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkflowsInputOperationOutputAlias,
                crate::output::ListWorkflowsOutput,
                crate::error::ListWorkflowsError,
                crate::input::ListWorkflowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of a list to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDataCatalogEncryptionSettings`.
    ///
    /// <p>Sets the security configuration for a specified catalog. After the configuration has been
    /// set, the specified encryption is applied to every catalog write thereafter.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutDataCatalogEncryptionSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_data_catalog_encryption_settings_input::Builder,
    }
    impl<C, M, R> PutDataCatalogEncryptionSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDataCatalogEncryptionSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDataCatalogEncryptionSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDataCatalogEncryptionSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDataCatalogEncryptionSettingsInputOperationOutputAlias,
                crate::output::PutDataCatalogEncryptionSettingsOutput,
                crate::error::PutDataCatalogEncryptionSettingsError,
                crate::input::PutDataCatalogEncryptionSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog to set the security configuration for. If none is provided, the
        /// Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog to set the security configuration for. If none is provided, the
        /// Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The security configuration to set.</p>
        pub fn data_catalog_encryption_settings(
            mut self,
            inp: crate::model::DataCatalogEncryptionSettings,
        ) -> Self {
            self.inner = self.inner.data_catalog_encryption_settings(inp);
            self
        }
        /// <p>The security configuration to set.</p>
        pub fn set_data_catalog_encryption_settings(
            mut self,
            input: std::option::Option<crate::model::DataCatalogEncryptionSettings>,
        ) -> Self {
            self.inner = self.inner.set_data_catalog_encryption_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Sets the Data Catalog resource policy for access control.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl<C, M, R> PutResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourcePolicyInputOperationOutputAlias,
                crate::output::PutResourcePolicyOutput,
                crate::error::PutResourcePolicyError,
                crate::input::PutResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Contains the policy document to set, in JSON format.</p>
        pub fn policy_in_json(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_in_json(inp);
            self
        }
        /// <p>Contains the policy document to set, in JSON format.</p>
        pub fn set_policy_in_json(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_in_json(input);
            self
        }
        /// <p>Do not use. For internal use only.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Do not use. For internal use only.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The hash value returned when the previous policy was set using
        /// <code>PutResourcePolicy</code>. Its purpose is to prevent concurrent modifications of a
        /// policy. Do not use this parameter if no previous policy has been set.</p>
        pub fn policy_hash_condition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_hash_condition(inp);
            self
        }
        /// <p>The hash value returned when the previous policy was set using
        /// <code>PutResourcePolicy</code>. Its purpose is to prevent concurrent modifications of a
        /// policy. Do not use this parameter if no previous policy has been set.</p>
        pub fn set_policy_hash_condition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_hash_condition(input);
            self
        }
        /// <p>A value of <code>MUST_EXIST</code> is used to update a policy. A value of
        /// <code>NOT_EXIST</code> is used to create a new policy. If a value of <code>NONE</code> or a
        /// null value is used, the call does not depend on the existence of a policy.</p>
        pub fn policy_exists_condition(mut self, inp: crate::model::ExistCondition) -> Self {
            self.inner = self.inner.policy_exists_condition(inp);
            self
        }
        /// <p>A value of <code>MUST_EXIST</code> is used to update a policy. A value of
        /// <code>NOT_EXIST</code> is used to create a new policy. If a value of <code>NONE</code> or a
        /// null value is used, the call does not depend on the existence of a policy.</p>
        pub fn set_policy_exists_condition(
            mut self,
            input: std::option::Option<crate::model::ExistCondition>,
        ) -> Self {
            self.inner = self.inner.set_policy_exists_condition(input);
            self
        }
        /// <p>If <code>'TRUE'</code>, indicates that you are using both methods to grant cross-account
        /// access to Data Catalog resources:</p>
        /// <ul>
        /// <li>
        /// <p>By directly updating the resource policy with <code>PutResourePolicy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>By using the <b>Grant permissions</b> command on the Amazon Web Services Management Console.</p>
        /// </li>
        /// </ul>
        /// <p>Must be set to <code>'TRUE'</code> if you have already used the Management Console to
        /// grant cross-account access, otherwise the call fails. Default is 'FALSE'.</p>
        pub fn enable_hybrid(mut self, inp: crate::model::EnableHybridValues) -> Self {
            self.inner = self.inner.enable_hybrid(inp);
            self
        }
        /// <p>If <code>'TRUE'</code>, indicates that you are using both methods to grant cross-account
        /// access to Data Catalog resources:</p>
        /// <ul>
        /// <li>
        /// <p>By directly updating the resource policy with <code>PutResourePolicy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>By using the <b>Grant permissions</b> command on the Amazon Web Services Management Console.</p>
        /// </li>
        /// </ul>
        /// <p>Must be set to <code>'TRUE'</code> if you have already used the Management Console to
        /// grant cross-account access, otherwise the call fails. Default is 'FALSE'.</p>
        pub fn set_enable_hybrid(
            mut self,
            input: std::option::Option<crate::model::EnableHybridValues>,
        ) -> Self {
            self.inner = self.inner.set_enable_hybrid(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSchemaVersionMetadata`.
    ///
    /// <p>Puts the metadata key value pair for a specified schema version ID. A maximum of 10 key value pairs will be allowed per schema version. They can be added over one or more calls.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutSchemaVersionMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_schema_version_metadata_input::Builder,
    }
    impl<C, M, R> PutSchemaVersionMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutSchemaVersionMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSchemaVersionMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSchemaVersionMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutSchemaVersionMetadataInputOperationOutputAlias,
                crate::output::PutSchemaVersionMetadataOutput,
                crate::error::PutSchemaVersionMetadataError,
                crate::input::PutSchemaVersionMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID for the schema.</p>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>The unique ID for the schema.</p>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn schema_version_number(mut self, inp: crate::model::SchemaVersionNumber) -> Self {
            self.inner = self.inner.schema_version_number(inp);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_schema_version_number(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionNumber>,
        ) -> Self {
            self.inner = self.inner.set_schema_version_number(input);
            self
        }
        /// <p>The unique version ID of the schema version.</p>
        pub fn schema_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_version_id(inp);
            self
        }
        /// <p>The unique version ID of the schema version.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_version_id(input);
            self
        }
        /// <p>The metadata key's corresponding value.</p>
        pub fn metadata_key_value(mut self, inp: crate::model::MetadataKeyValuePair) -> Self {
            self.inner = self.inner.metadata_key_value(inp);
            self
        }
        /// <p>The metadata key's corresponding value.</p>
        pub fn set_metadata_key_value(
            mut self,
            input: std::option::Option<crate::model::MetadataKeyValuePair>,
        ) -> Self {
            self.inner = self.inner.set_metadata_key_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutWorkflowRunProperties`.
    ///
    /// <p>Puts the specified workflow run properties for the given workflow run. If a property already exists for the specified run, then it overrides the value otherwise adds the property to existing properties.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutWorkflowRunProperties<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_workflow_run_properties_input::Builder,
    }
    impl<C, M, R> PutWorkflowRunProperties<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutWorkflowRunProperties`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutWorkflowRunPropertiesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutWorkflowRunPropertiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutWorkflowRunPropertiesInputOperationOutputAlias,
                crate::output::PutWorkflowRunPropertiesOutput,
                crate::error::PutWorkflowRunPropertiesError,
                crate::input::PutWorkflowRunPropertiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the workflow which was run.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the workflow which was run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the workflow run for which the run properties should be updated.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The ID of the workflow run for which the run properties should be updated.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
        /// Adds a key-value pair to `RunProperties`.
        ///
        /// To override the contents of this collection use [`set_run_properties`](Self::set_run_properties).
        ///
        /// <p>The properties to put for the specified run.</p>
        pub fn run_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.run_properties(k, v);
            self
        }
        /// <p>The properties to put for the specified run.</p>
        pub fn set_run_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_run_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `QuerySchemaVersionMetadata`.
    ///
    /// <p>Queries for the schema version metadata information. </p>
    #[derive(std::fmt::Debug)]
    pub struct QuerySchemaVersionMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::query_schema_version_metadata_input::Builder,
    }
    impl<C, M, R> QuerySchemaVersionMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `QuerySchemaVersionMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::QuerySchemaVersionMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::QuerySchemaVersionMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::QuerySchemaVersionMetadataInputOperationOutputAlias,
                crate::output::QuerySchemaVersionMetadataOutput,
                crate::error::QuerySchemaVersionMetadataError,
                crate::input::QuerySchemaVersionMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A wrapper structure that may contain the schema name and Amazon Resource Name (ARN).</p>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>A wrapper structure that may contain the schema name and Amazon Resource Name (ARN).</p>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn schema_version_number(mut self, inp: crate::model::SchemaVersionNumber) -> Self {
            self.inner = self.inner.schema_version_number(inp);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_schema_version_number(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionNumber>,
        ) -> Self {
            self.inner = self.inner.set_schema_version_number(input);
            self
        }
        /// <p>The unique version ID of the schema version.</p>
        pub fn schema_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_version_id(inp);
            self
        }
        /// <p>The unique version ID of the schema version.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_version_id(input);
            self
        }
        /// Appends an item to `MetadataList`.
        ///
        /// To override the contents of this collection use [`set_metadata_list`](Self::set_metadata_list).
        ///
        /// <p>Search key-value pairs for metadata, if they are not provided all the metadata information will be fetched.</p>
        pub fn metadata_list(mut self, inp: impl Into<crate::model::MetadataKeyValuePair>) -> Self {
            self.inner = self.inner.metadata_list(inp);
            self
        }
        /// <p>Search key-value pairs for metadata, if they are not provided all the metadata information will be fetched.</p>
        pub fn set_metadata_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetadataKeyValuePair>>,
        ) -> Self {
            self.inner = self.inner.set_metadata_list(input);
            self
        }
        /// <p>Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterSchemaVersion`.
    ///
    /// <p>Adds a new version to the existing schema. Returns an error if new version of schema does not meet the compatibility requirements of the schema set. This API will not create a new schema set and will return a 404 error if the schema set is not already present in the Schema Registry.</p>
    /// <p>If this is the first schema definition to be registered in the Schema Registry, this API will store the schema version and return immediately. Otherwise, this call has the potential to run longer than other operations due to compatibility modes. You can call the <code>GetSchemaVersion</code> API with the <code>SchemaVersionId</code> to check compatibility modes.</p>
    /// <p>If the same schema definition is already stored in Schema Registry as a version, the schema ID of the existing schema is returned to the caller.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterSchemaVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_schema_version_input::Builder,
    }
    impl<C, M, R> RegisterSchemaVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterSchemaVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterSchemaVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterSchemaVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterSchemaVersionInputOperationOutputAlias,
                crate::output::RegisterSchemaVersionOutput,
                crate::error::RegisterSchemaVersionError,
                crate::input::RegisterSchemaVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. Either <code>SchemaArn</code> or <code>SchemaName</code> and <code>RegistryName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
        /// <p>The schema definition using the <code>DataFormat</code> setting for the <code>SchemaName</code>.</p>
        pub fn schema_definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_definition(inp);
            self
        }
        /// <p>The schema definition using the <code>DataFormat</code> setting for the <code>SchemaName</code>.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveSchemaVersionMetadata`.
    ///
    /// <p>Removes a key value pair from the schema version metadata for the specified schema version ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveSchemaVersionMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_schema_version_metadata_input::Builder,
    }
    impl<C, M, R> RemoveSchemaVersionMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveSchemaVersionMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveSchemaVersionMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveSchemaVersionMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveSchemaVersionMetadataInputOperationOutputAlias,
                crate::output::RemoveSchemaVersionMetadataOutput,
                crate::error::RemoveSchemaVersionMetadataError,
                crate::input::RemoveSchemaVersionMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A wrapper structure that may contain the schema name and Amazon Resource Name (ARN).</p>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>A wrapper structure that may contain the schema name and Amazon Resource Name (ARN).</p>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn schema_version_number(mut self, inp: crate::model::SchemaVersionNumber) -> Self {
            self.inner = self.inner.schema_version_number(inp);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_schema_version_number(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionNumber>,
        ) -> Self {
            self.inner = self.inner.set_schema_version_number(input);
            self
        }
        /// <p>The unique version ID of the schema version.</p>
        pub fn schema_version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_version_id(inp);
            self
        }
        /// <p>The unique version ID of the schema version.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_version_id(input);
            self
        }
        /// <p>The value of the metadata key.</p>
        pub fn metadata_key_value(mut self, inp: crate::model::MetadataKeyValuePair) -> Self {
            self.inner = self.inner.metadata_key_value(inp);
            self
        }
        /// <p>The value of the metadata key.</p>
        pub fn set_metadata_key_value(
            mut self,
            input: std::option::Option<crate::model::MetadataKeyValuePair>,
        ) -> Self {
            self.inner = self.inner.set_metadata_key_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetJobBookmark`.
    ///
    /// <p>Resets a bookmark entry.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetJobBookmark<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_job_bookmark_input::Builder,
    }
    impl<C, M, R> ResetJobBookmark<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetJobBookmark`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetJobBookmarkOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetJobBookmarkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetJobBookmarkInputOperationOutputAlias,
                crate::output::ResetJobBookmarkOutput,
                crate::error::ResetJobBookmarkError,
                crate::input::ResetJobBookmarkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job in question.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the job in question.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The unique run identifier associated with this job run.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The unique run identifier associated with this job run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResumeWorkflowRun`.
    ///
    /// <p>Restarts selected nodes of a previous partially completed workflow run and resumes the workflow run. The selected nodes and all nodes that are downstream from the selected nodes are run.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResumeWorkflowRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resume_workflow_run_input::Builder,
    }
    impl<C, M, R> ResumeWorkflowRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResumeWorkflowRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResumeWorkflowRunOutput,
            aws_smithy_http::result::SdkError<crate::error::ResumeWorkflowRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResumeWorkflowRunInputOperationOutputAlias,
                crate::output::ResumeWorkflowRunOutput,
                crate::error::ResumeWorkflowRunError,
                crate::input::ResumeWorkflowRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the workflow to resume.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the workflow to resume.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the workflow run to resume.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The ID of the workflow run to resume.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
        /// Appends an item to `NodeIds`.
        ///
        /// To override the contents of this collection use [`set_node_ids`](Self::set_node_ids).
        ///
        /// <p>A list of the node IDs for the nodes you want to restart. The nodes that are to be restarted must have a run attempt in the original run.</p>
        pub fn node_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_ids(inp);
            self
        }
        /// <p>A list of the node IDs for the nodes you want to restart. The nodes that are to be restarted must have a run attempt in the original run.</p>
        pub fn set_node_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_node_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchTables`.
    ///
    /// <p>Searches a set of tables based on properties in the table metadata as well as on the parent database. You can search against text or filter conditions. </p>
    /// <p>You can only get tables that you have access to based on the security policies defined in Lake Formation. You need at least a read-only access to the table for it to be returned. If you do not have access to all the columns in the table, these columns will not be searched against when returning the list of tables back to you. If you have access to the columns but not the data in the columns, those columns and the associated metadata for those columns will be included in the search. </p>
    #[derive(std::fmt::Debug)]
    pub struct SearchTables<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_tables_input::Builder,
    }
    impl<C, M, R> SearchTables<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchTablesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchTablesInputOperationOutputAlias,
                crate::output::SearchTablesOutput,
                crate::error::SearchTablesError,
                crate::input::SearchTablesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier, consisting of <code>
        /// <i>account_id</i>
        /// </code>.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>A unique identifier, consisting of <code>
        /// <i>account_id</i>
        /// </code>.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>A continuation token, included if this is a continuation call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token, included if this is a continuation call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of key-value pairs, and a comparator used to filter the search results. Returns all entities matching the predicate.</p>
        ///
        /// <p>The <code>Comparator</code> member of the <code>PropertyPredicate</code> struct is used only for time fields, and can be omitted for other field types. Also, when comparing string values, such as when <code>Key=Name</code>, a fuzzy match algorithm is used. The <code>Key</code> field (for example, the value of the <code>Name</code> field) is split on certain punctuation characters, for example, -, :, #, etc. into tokens. Then each token is exact-match compared with the <code>Value</code> member of <code>PropertyPredicate</code>. For example, if <code>Key=Name</code> and <code>Value=link</code>, tables named <code>customer-link</code> and <code>xx-link-yy</code> are returned, but <code>xxlinkyy</code> is not returned.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::PropertyPredicate>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A list of key-value pairs, and a comparator used to filter the search results. Returns all entities matching the predicate.</p>
        ///
        /// <p>The <code>Comparator</code> member of the <code>PropertyPredicate</code> struct is used only for time fields, and can be omitted for other field types. Also, when comparing string values, such as when <code>Key=Name</code>, a fuzzy match algorithm is used. The <code>Key</code> field (for example, the value of the <code>Name</code> field) is split on certain punctuation characters, for example, -, :, #, etc. into tokens. Then each token is exact-match compared with the <code>Value</code> member of <code>PropertyPredicate</code>. For example, if <code>Key=Name</code> and <code>Value=link</code>, tables named <code>customer-link</code> and <code>xx-link-yy</code> are returned, but <code>xxlinkyy</code> is not returned.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyPredicate>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>A string used for a text search.</p>
        /// <p>Specifying a value in quotes filters based on an exact match to the value.</p>
        pub fn search_text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.search_text(inp);
            self
        }
        /// <p>A string used for a text search.</p>
        /// <p>Specifying a value in quotes filters based on an exact match to the value.</p>
        pub fn set_search_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_search_text(input);
            self
        }
        /// Appends an item to `SortCriteria`.
        ///
        /// To override the contents of this collection use [`set_sort_criteria`](Self::set_sort_criteria).
        ///
        /// <p>A list of criteria for sorting the results by a field name, in an ascending or descending order.</p>
        pub fn sort_criteria(mut self, inp: impl Into<crate::model::SortCriterion>) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>A list of criteria for sorting the results by a field name, in an ascending or descending order.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SortCriterion>>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
        /// <p>The maximum number of tables to return in a single response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of tables to return in a single response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Allows you to specify that you want to search the tables shared with your account. The allowable values are <code>FOREIGN</code> or <code>ALL</code>. </p>
        ///
        /// <ul>
        /// <li>
        /// <p>If set to <code>FOREIGN</code>, will search the tables shared with your account. </p>
        /// </li>
        /// <li>
        /// <p>If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in yor local account. </p>
        /// </li>
        /// </ul>
        pub fn resource_share_type(mut self, inp: crate::model::ResourceShareType) -> Self {
            self.inner = self.inner.resource_share_type(inp);
            self
        }
        /// <p>Allows you to specify that you want to search the tables shared with your account. The allowable values are <code>FOREIGN</code> or <code>ALL</code>. </p>
        ///
        /// <ul>
        /// <li>
        /// <p>If set to <code>FOREIGN</code>, will search the tables shared with your account. </p>
        /// </li>
        /// <li>
        /// <p>If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in yor local account. </p>
        /// </li>
        /// </ul>
        pub fn set_resource_share_type(
            mut self,
            input: std::option::Option<crate::model::ResourceShareType>,
        ) -> Self {
            self.inner = self.inner.set_resource_share_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBlueprintRun`.
    ///
    /// <p>Starts a new run of the specified blueprint.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartBlueprintRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_blueprint_run_input::Builder,
    }
    impl<C, M, R> StartBlueprintRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartBlueprintRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartBlueprintRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartBlueprintRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartBlueprintRunInputOperationOutputAlias,
                crate::output::StartBlueprintRunOutput,
                crate::error::StartBlueprintRunError,
                crate::input::StartBlueprintRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the blueprint.</p>
        pub fn blueprint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blueprint_name(inp);
            self
        }
        /// <p>The name of the blueprint.</p>
        pub fn set_blueprint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_blueprint_name(input);
            self
        }
        /// <p>Specifies the parameters as a <code>BlueprintParameters</code> object.</p>
        pub fn parameters(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>Specifies the parameters as a <code>BlueprintParameters</code> object.</p>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>Specifies the IAM role used to create the workflow.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>Specifies the IAM role used to create the workflow.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartCrawler`.
    ///
    /// <p>Starts a crawl using the specified crawler, regardless
    /// of what is scheduled. If the crawler is already running, returns a
    /// <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-exceptions.html#aws-glue-api-exceptions-CrawlerRunningException">CrawlerRunningException</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartCrawler<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_crawler_input::Builder,
    }
    impl<C, M, R> StartCrawler<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartCrawler`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartCrawlerOutput,
            aws_smithy_http::result::SdkError<crate::error::StartCrawlerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartCrawlerInputOperationOutputAlias,
                crate::output::StartCrawlerOutput,
                crate::error::StartCrawlerError,
                crate::input::StartCrawlerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the crawler to start.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the crawler to start.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartCrawlerSchedule`.
    ///
    /// <p>Changes the schedule state of the specified crawler to
    /// <code>SCHEDULED</code>, unless the crawler is already running or the
    /// schedule state is already <code>SCHEDULED</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartCrawlerSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_crawler_schedule_input::Builder,
    }
    impl<C, M, R> StartCrawlerSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartCrawlerSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartCrawlerScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::StartCrawlerScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartCrawlerScheduleInputOperationOutputAlias,
                crate::output::StartCrawlerScheduleOutput,
                crate::error::StartCrawlerScheduleError,
                crate::input::StartCrawlerScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the crawler to schedule.</p>
        pub fn crawler_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.crawler_name(inp);
            self
        }
        /// <p>Name of the crawler to schedule.</p>
        pub fn set_crawler_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_crawler_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartExportLabelsTaskRun`.
    ///
    /// <p>Begins an asynchronous task to export all labeled data for a particular transform. This
    /// task is the only label-related API call that is not part of the typical active learning
    /// workflow. You typically use <code>StartExportLabelsTaskRun</code> when you want to work with
    /// all of your existing labels at the same time, such as when you want to remove or change labels
    /// that were previously submitted as truth. This API operation accepts the
    /// <code>TransformId</code> whose labels you want to export and an Amazon Simple Storage
    /// Service (Amazon S3) path to export the labels to. The operation returns a
    /// <code>TaskRunId</code>. You can check on the status of your task run by calling the
    /// <code>GetMLTaskRun</code> API.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartExportLabelsTaskRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_export_labels_task_run_input::Builder,
    }
    impl<C, M, R> StartExportLabelsTaskRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartExportLabelsTaskRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartExportLabelsTaskRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartExportLabelsTaskRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartExportLabelsTaskRunInputOperationOutputAlias,
                crate::output::StartExportLabelsTaskRunOutput,
                crate::error::StartExportLabelsTaskRunError,
                crate::input::StartExportLabelsTaskRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn transform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_id(inp);
            self
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_transform_id(input);
            self
        }
        /// <p>The Amazon S3 path where you export the labels.</p>
        pub fn output_s3_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_path(inp);
            self
        }
        /// <p>The Amazon S3 path where you export the labels.</p>
        pub fn set_output_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImportLabelsTaskRun`.
    ///
    /// <p>Enables you to provide additional labels (examples of truth) to be used to teach the
    /// machine learning transform and improve its quality. This API operation is generally used as
    /// part of the active learning workflow that starts with the
    /// <code>StartMLLabelingSetGenerationTaskRun</code> call and that ultimately results in
    /// improving the quality of your machine learning transform. </p>
    ///
    /// <p>After the <code>StartMLLabelingSetGenerationTaskRun</code> finishes, Glue machine learning
    /// will have generated a series of questions for humans to answer. (Answering these questions is
    /// often called 'labeling' in the machine learning workflows). In the case of the
    /// <code>FindMatches</code> transform, these questions are of the form, “What is the correct
    /// way to group these rows together into groups composed entirely of matching records?” After the
    /// labeling process is finished, users upload their answers/labels with a call to
    /// <code>StartImportLabelsTaskRun</code>. After <code>StartImportLabelsTaskRun</code> finishes,
    /// all future runs of the machine learning transform use the new and improved labels and perform
    /// a higher-quality transformation.</p>
    ///
    /// <p>By default, <code>StartMLLabelingSetGenerationTaskRun</code> continually learns from and
    /// combines all labels that you upload unless you set <code>Replace</code> to true. If you set
    /// <code>Replace</code> to true, <code>StartImportLabelsTaskRun</code> deletes and forgets all
    /// previously uploaded labels and learns only from the exact set that you upload. Replacing
    /// labels can be helpful if you realize that you previously uploaded incorrect labels, and you
    /// believe that they are having a negative effect on your transform quality.</p>
    ///
    /// <p>You can check on the status of your task run by calling the <code>GetMLTaskRun</code>
    /// operation. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartImportLabelsTaskRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_import_labels_task_run_input::Builder,
    }
    impl<C, M, R> StartImportLabelsTaskRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartImportLabelsTaskRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImportLabelsTaskRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImportLabelsTaskRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartImportLabelsTaskRunInputOperationOutputAlias,
                crate::output::StartImportLabelsTaskRunOutput,
                crate::error::StartImportLabelsTaskRunError,
                crate::input::StartImportLabelsTaskRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn transform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_id(inp);
            self
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_transform_id(input);
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path from where you import the
        /// labels.</p>
        pub fn input_s3_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_s3_path(inp);
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path from where you import the
        /// labels.</p>
        pub fn set_input_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_input_s3_path(input);
            self
        }
        /// <p>Indicates whether to overwrite your existing labels.</p>
        pub fn replace_all_labels(mut self, inp: bool) -> Self {
            self.inner = self.inner.replace_all_labels(inp);
            self
        }
        /// <p>Indicates whether to overwrite your existing labels.</p>
        pub fn set_replace_all_labels(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_replace_all_labels(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartJobRun`.
    ///
    /// <p>Starts a job run using a job definition.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartJobRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_job_run_input::Builder,
    }
    impl<C, M, R> StartJobRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartJobRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartJobRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartJobRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartJobRunInputOperationOutputAlias,
                crate::output::StartJobRunOutput,
                crate::error::StartJobRunError,
                crate::input::StartJobRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job definition to use.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the job definition to use.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The ID of a previous <code>JobRun</code> to retry.</p>
        pub fn job_run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_run_id(inp);
            self
        }
        /// <p>The ID of a previous <code>JobRun</code> to retry.</p>
        pub fn set_job_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_run_id(input);
            self
        }
        /// Adds a key-value pair to `Arguments`.
        ///
        /// To override the contents of this collection use [`set_arguments`](Self::set_arguments).
        ///
        /// <p>The job arguments specifically for this run. For this job run, they replace the default arguments set in the job definition itself.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.arguments(k, v);
            self
        }
        /// <p>The job arguments specifically for this run. For this job run, they replace the default arguments set in the job definition itself.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn set_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_arguments(input);
            self
        }
        /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
        ///
        /// <p>The number of Glue data processing units (DPUs) to allocate to this JobRun.
        /// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        pub fn allocated_capacity(mut self, inp: i32) -> Self {
            self.inner = self.inner.allocated_capacity(inp);
            self
        }
        /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
        ///
        /// <p>The number of Glue data processing units (DPUs) to allocate to this JobRun.
        /// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        pub fn set_allocated_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_capacity(input);
            self
        }
        /// <p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can
        /// consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
        /// is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>
        pub fn timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout(inp);
            self
        }
        /// <p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can
        /// consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
        /// is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        ///
        /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>
        ///
        /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
        /// running a Python shell job, or an Apache Spark ETL job:</p>
        /// <ul>
        /// <li>
        /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
        /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
        /// </li>
        /// <li>
        /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
        /// </li>
        /// </ul>
        pub fn max_capacity(mut self, inp: f64) -> Self {
            self.inner = self.inner.max_capacity(inp);
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        ///
        /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>
        ///
        /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
        /// running a Python shell job, or an Apache Spark ETL job:</p>
        /// <ul>
        /// <li>
        /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
        /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
        /// </li>
        /// <li>
        /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
        /// </li>
        /// </ul>
        pub fn set_max_capacity(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this job
        /// run.</p>
        pub fn security_configuration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_configuration(inp);
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this job
        /// run.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_configuration(input);
            self
        }
        /// <p>Specifies configuration properties of a job run notification.</p>
        pub fn notification_property(mut self, inp: crate::model::NotificationProperty) -> Self {
            self.inner = self.inner.notification_property(inp);
            self
        }
        /// <p>Specifies configuration properties of a job run notification.</p>
        pub fn set_notification_property(
            mut self,
            input: std::option::Option<crate::model::NotificationProperty>,
        ) -> Self {
            self.inner = self.inner.set_notification_property(input);
            self
        }
        /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        pub fn worker_type(mut self, inp: crate::model::WorkerType) -> Self {
            self.inner = self.inner.worker_type(inp);
            self
        }
        /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.inner = self.inner.set_worker_type(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn number_of_workers(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_workers(inp);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_workers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMLEvaluationTaskRun`.
    ///
    /// <p>Starts a task to estimate the quality of the transform. </p>
    ///
    /// <p>When you provide label sets as examples of truth, Glue machine learning uses some of
    /// those examples to learn from them. The rest of the labels are used as a test to estimate
    /// quality.</p>
    ///
    /// <p>Returns a unique identifier for the run. You can call <code>GetMLTaskRun</code> to get more
    /// information about the stats of the <code>EvaluationTaskRun</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartMLEvaluationTaskRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_ml_evaluation_task_run_input::Builder,
    }
    impl<C, M, R> StartMLEvaluationTaskRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartMLEvaluationTaskRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMlEvaluationTaskRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMLEvaluationTaskRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartMlEvaluationTaskRunInputOperationOutputAlias,
                crate::output::StartMlEvaluationTaskRunOutput,
                crate::error::StartMLEvaluationTaskRunError,
                crate::input::StartMlEvaluationTaskRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn transform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_id(inp);
            self
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_transform_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMLLabelingSetGenerationTaskRun`.
    ///
    /// <p>Starts the active learning workflow for your machine learning transform to improve the
    /// transform's quality by generating label sets and adding labels.</p>
    ///
    /// <p>When the <code>StartMLLabelingSetGenerationTaskRun</code> finishes, Glue will have
    /// generated a "labeling set" or a set of questions for humans to answer.</p>
    ///
    /// <p>In the case of the <code>FindMatches</code> transform, these questions are of the form,
    /// “What is the correct way to group these rows together into groups composed entirely of
    /// matching records?” </p>
    ///
    /// <p>After the labeling process is finished, you can upload your labels with a call to
    /// <code>StartImportLabelsTaskRun</code>. After <code>StartImportLabelsTaskRun</code> finishes,
    /// all future runs of the machine learning transform will use the new and improved labels and
    /// perform a higher-quality transformation.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartMLLabelingSetGenerationTaskRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_ml_labeling_set_generation_task_run_input::Builder,
    }
    impl<C, M, R> StartMLLabelingSetGenerationTaskRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartMLLabelingSetGenerationTaskRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMlLabelingSetGenerationTaskRunOutput,
            aws_smithy_http::result::SdkError<
                crate::error::StartMLLabelingSetGenerationTaskRunError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartMlLabelingSetGenerationTaskRunInputOperationOutputAlias,
                crate::output::StartMlLabelingSetGenerationTaskRunOutput,
                crate::error::StartMLLabelingSetGenerationTaskRunError,
                crate::input::StartMlLabelingSetGenerationTaskRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn transform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_id(inp);
            self
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_transform_id(input);
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path where you generate the labeling
        /// set.</p>
        pub fn output_s3_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_s3_path(inp);
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path where you generate the labeling
        /// set.</p>
        pub fn set_output_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_output_s3_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTrigger`.
    ///
    /// <p>Starts an existing trigger. See <a href="https://docs.aws.amazon.com/glue/latest/dg/trigger-job.html">Triggering
    /// Jobs</a> for information about how different types of trigger are
    /// started.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartTrigger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_trigger_input::Builder,
    }
    impl<C, M, R> StartTrigger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartTrigger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTriggerOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTriggerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartTriggerInputOperationOutputAlias,
                crate::output::StartTriggerOutput,
                crate::error::StartTriggerError,
                crate::input::StartTriggerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the trigger to start.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the trigger to start.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartWorkflowRun`.
    ///
    /// <p>Starts a new run of the specified workflow.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartWorkflowRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_workflow_run_input::Builder,
    }
    impl<C, M, R> StartWorkflowRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartWorkflowRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartWorkflowRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartWorkflowRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartWorkflowRunInputOperationOutputAlias,
                crate::output::StartWorkflowRunOutput,
                crate::error::StartWorkflowRunError,
                crate::input::StartWorkflowRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the workflow to start.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the workflow to start.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopCrawler`.
    ///
    /// <p>If the specified crawler is running, stops the crawl.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopCrawler<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_crawler_input::Builder,
    }
    impl<C, M, R> StopCrawler<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopCrawler`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopCrawlerOutput,
            aws_smithy_http::result::SdkError<crate::error::StopCrawlerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopCrawlerInputOperationOutputAlias,
                crate::output::StopCrawlerOutput,
                crate::error::StopCrawlerError,
                crate::input::StopCrawlerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the crawler to stop.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the crawler to stop.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopCrawlerSchedule`.
    ///
    /// <p>Sets the schedule state of the specified crawler to
    /// <code>NOT_SCHEDULED</code>, but does not stop the crawler if it is
    /// already running.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopCrawlerSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_crawler_schedule_input::Builder,
    }
    impl<C, M, R> StopCrawlerSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopCrawlerSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopCrawlerScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::StopCrawlerScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopCrawlerScheduleInputOperationOutputAlias,
                crate::output::StopCrawlerScheduleOutput,
                crate::error::StopCrawlerScheduleError,
                crate::input::StopCrawlerScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the crawler whose schedule state to set.</p>
        pub fn crawler_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.crawler_name(inp);
            self
        }
        /// <p>Name of the crawler whose schedule state to set.</p>
        pub fn set_crawler_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_crawler_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopTrigger`.
    ///
    /// <p>Stops a specified trigger.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopTrigger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_trigger_input::Builder,
    }
    impl<C, M, R> StopTrigger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopTrigger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopTriggerOutput,
            aws_smithy_http::result::SdkError<crate::error::StopTriggerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopTriggerInputOperationOutputAlias,
                crate::output::StopTriggerOutput,
                crate::error::StopTriggerError,
                crate::input::StopTriggerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the trigger to stop.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the trigger to stop.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopWorkflowRun`.
    ///
    /// <p>Stops the execution of the specified workflow run.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopWorkflowRun<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_workflow_run_input::Builder,
    }
    impl<C, M, R> StopWorkflowRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopWorkflowRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopWorkflowRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StopWorkflowRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopWorkflowRunInputOperationOutputAlias,
                crate::output::StopWorkflowRunOutput,
                crate::error::StopWorkflowRunError,
                crate::input::StopWorkflowRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the workflow to stop.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the workflow to stop.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the workflow run to stop.</p>
        pub fn run_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.run_id(inp);
            self
        }
        /// <p>The ID of the workflow run to stop.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_run_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to a resource. A tag is a label you can assign to an Amazon Web Services resource.
    /// In Glue, you can tag only certain resources. For information about what
    /// resources you can tag, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in Glue</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Glue resource to which to add the tags. For more
        /// information about Glue resource ARNs, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id">Glue ARN string pattern</a>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the Glue resource to which to add the tags. For more
        /// information about Glue resource ARNs, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id">Glue ARN string pattern</a>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `TagsToAdd`.
        ///
        /// To override the contents of this collection use [`set_tags_to_add`](Self::set_tags_to_add).
        ///
        /// <p>Tags to add to this resource.</p>
        pub fn tags_to_add(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags_to_add(k, v);
            self
        }
        /// <p>Tags to add to this resource.</p>
        pub fn set_tags_to_add(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags_to_add(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to remove the tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to remove the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagsToRemove`.
        ///
        /// To override the contents of this collection use [`set_tags_to_remove`](Self::set_tags_to_remove).
        ///
        /// <p>Tags to remove from this resource.</p>
        pub fn tags_to_remove(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tags_to_remove(inp);
            self
        }
        /// <p>Tags to remove from this resource.</p>
        pub fn set_tags_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tags_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBlueprint`.
    ///
    /// <p>Updates a registered blueprint.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBlueprint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_blueprint_input::Builder,
    }
    impl<C, M, R> UpdateBlueprint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBlueprint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBlueprintOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBlueprintError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBlueprintInputOperationOutputAlias,
                crate::output::UpdateBlueprintOutput,
                crate::error::UpdateBlueprintError,
                crate::input::UpdateBlueprintInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the blueprint.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the blueprint.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the blueprint.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the blueprint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies a path in Amazon S3 where the blueprint is published.</p>
        pub fn blueprint_location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blueprint_location(inp);
            self
        }
        /// <p>Specifies a path in Amazon S3 where the blueprint is published.</p>
        pub fn set_blueprint_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_blueprint_location(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateClassifier`.
    ///
    /// <p>Modifies an existing classifier (a <code>GrokClassifier</code>,
    /// an <code>XMLClassifier</code>, a <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on
    /// which field is present).</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateClassifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_classifier_input::Builder,
    }
    impl<C, M, R> UpdateClassifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateClassifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClassifierOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClassifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateClassifierInputOperationOutputAlias,
                crate::output::UpdateClassifierOutput,
                crate::error::UpdateClassifierError,
                crate::input::UpdateClassifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A <code>GrokClassifier</code> object with updated fields.</p>
        pub fn grok_classifier(mut self, inp: crate::model::UpdateGrokClassifierRequest) -> Self {
            self.inner = self.inner.grok_classifier(inp);
            self
        }
        /// <p>A <code>GrokClassifier</code> object with updated fields.</p>
        pub fn set_grok_classifier(
            mut self,
            input: std::option::Option<crate::model::UpdateGrokClassifierRequest>,
        ) -> Self {
            self.inner = self.inner.set_grok_classifier(input);
            self
        }
        /// <p>An <code>XMLClassifier</code> object with updated fields.</p>
        pub fn xml_classifier(mut self, inp: crate::model::UpdateXmlClassifierRequest) -> Self {
            self.inner = self.inner.xml_classifier(inp);
            self
        }
        /// <p>An <code>XMLClassifier</code> object with updated fields.</p>
        pub fn set_xml_classifier(
            mut self,
            input: std::option::Option<crate::model::UpdateXmlClassifierRequest>,
        ) -> Self {
            self.inner = self.inner.set_xml_classifier(input);
            self
        }
        /// <p>A <code>JsonClassifier</code> object with updated fields.</p>
        pub fn json_classifier(mut self, inp: crate::model::UpdateJsonClassifierRequest) -> Self {
            self.inner = self.inner.json_classifier(inp);
            self
        }
        /// <p>A <code>JsonClassifier</code> object with updated fields.</p>
        pub fn set_json_classifier(
            mut self,
            input: std::option::Option<crate::model::UpdateJsonClassifierRequest>,
        ) -> Self {
            self.inner = self.inner.set_json_classifier(input);
            self
        }
        /// <p>A <code>CsvClassifier</code> object with updated fields.</p>
        pub fn csv_classifier(mut self, inp: crate::model::UpdateCsvClassifierRequest) -> Self {
            self.inner = self.inner.csv_classifier(inp);
            self
        }
        /// <p>A <code>CsvClassifier</code> object with updated fields.</p>
        pub fn set_csv_classifier(
            mut self,
            input: std::option::Option<crate::model::UpdateCsvClassifierRequest>,
        ) -> Self {
            self.inner = self.inner.set_csv_classifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateColumnStatisticsForPartition`.
    ///
    /// <p>Creates or updates partition statistics of columns.</p>
    ///
    /// <p>The Identity and Access Management (IAM) permission required for this operation is <code>UpdatePartition</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateColumnStatisticsForPartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_column_statistics_for_partition_input::Builder,
    }
    impl<C, M, R> UpdateColumnStatisticsForPartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateColumnStatisticsForPartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateColumnStatisticsForPartitionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateColumnStatisticsForPartitionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateColumnStatisticsForPartitionInputOperationOutputAlias,
                crate::output::UpdateColumnStatisticsForPartitionOutput,
                crate::error::UpdateColumnStatisticsForPartitionError,
                crate::input::UpdateColumnStatisticsForPartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `PartitionValues`.
        ///
        /// To override the contents of this collection use [`set_partition_values`](Self::set_partition_values).
        ///
        /// <p>A list of partition values identifying the partition.</p>
        pub fn partition_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partition_values(inp);
            self
        }
        /// <p>A list of partition values identifying the partition.</p>
        pub fn set_partition_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_partition_values(input);
            self
        }
        /// Appends an item to `ColumnStatisticsList`.
        ///
        /// To override the contents of this collection use [`set_column_statistics_list`](Self::set_column_statistics_list).
        ///
        /// <p>A list of the column statistics.</p>
        pub fn column_statistics_list(
            mut self,
            inp: impl Into<crate::model::ColumnStatistics>,
        ) -> Self {
            self.inner = self.inner.column_statistics_list(inp);
            self
        }
        /// <p>A list of the column statistics.</p>
        pub fn set_column_statistics_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnStatistics>>,
        ) -> Self {
            self.inner = self.inner.set_column_statistics_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateColumnStatisticsForTable`.
    ///
    /// <p>Creates or updates table statistics of columns.</p>
    ///
    /// <p>The Identity and Access Management (IAM) permission required for this operation is <code>UpdateTable</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateColumnStatisticsForTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_column_statistics_for_table_input::Builder,
    }
    impl<C, M, R> UpdateColumnStatisticsForTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateColumnStatisticsForTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateColumnStatisticsForTableOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateColumnStatisticsForTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateColumnStatisticsForTableInputOperationOutputAlias,
                crate::output::UpdateColumnStatisticsForTableOutput,
                crate::error::UpdateColumnStatisticsForTableError,
                crate::input::UpdateColumnStatisticsForTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partitions in question reside.
        /// If none is supplied, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the partitions reside.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the partitions' table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `ColumnStatisticsList`.
        ///
        /// To override the contents of this collection use [`set_column_statistics_list`](Self::set_column_statistics_list).
        ///
        /// <p>A list of the column statistics.</p>
        pub fn column_statistics_list(
            mut self,
            inp: impl Into<crate::model::ColumnStatistics>,
        ) -> Self {
            self.inner = self.inner.column_statistics_list(inp);
            self
        }
        /// <p>A list of the column statistics.</p>
        pub fn set_column_statistics_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnStatistics>>,
        ) -> Self {
            self.inner = self.inner.set_column_statistics_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnection`.
    ///
    /// <p>Updates a connection definition in the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_connection_input::Builder,
    }
    impl<C, M, R> UpdateConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConnectionInputOperationOutputAlias,
                crate::output::UpdateConnectionOutput,
                crate::error::UpdateConnectionError,
                crate::input::UpdateConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which the connection resides. If none is provided, the Amazon Web Services
        /// account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the connection definition to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the connection definition to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A <code>ConnectionInput</code> object that redefines the connection
        /// in question.</p>
        pub fn connection_input(mut self, inp: crate::model::ConnectionInput) -> Self {
            self.inner = self.inner.connection_input(inp);
            self
        }
        /// <p>A <code>ConnectionInput</code> object that redefines the connection
        /// in question.</p>
        pub fn set_connection_input(
            mut self,
            input: std::option::Option<crate::model::ConnectionInput>,
        ) -> Self {
            self.inner = self.inner.set_connection_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCrawler`.
    ///
    /// <p>Updates a crawler. If a crawler is
    /// running, you must stop it using <code>StopCrawler</code> before updating
    /// it.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCrawler<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_crawler_input::Builder,
    }
    impl<C, M, R> UpdateCrawler<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCrawler`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCrawlerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCrawlerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCrawlerInputOperationOutputAlias,
                crate::output::UpdateCrawlerOutput,
                crate::error::UpdateCrawlerError,
                crate::input::UpdateCrawlerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the new crawler.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the new crawler.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The IAM role or Amazon Resource Name (ARN) of an IAM role that is used by the new crawler
        /// to access customer resources.</p>
        pub fn role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The IAM role or Amazon Resource Name (ARN) of an IAM role that is used by the new crawler
        /// to access customer resources.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The Glue database where results are stored, such as:
        /// <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The Glue database where results are stored, such as:
        /// <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>A description of the new crawler.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the new crawler.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A list of targets to crawl.</p>
        pub fn targets(mut self, inp: crate::model::CrawlerTargets) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>A list of targets to crawl.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<crate::model::CrawlerTargets>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn schedule(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// Appends an item to `Classifiers`.
        ///
        /// To override the contents of this collection use [`set_classifiers`](Self::set_classifiers).
        ///
        /// <p>A list of custom classifiers that the user
        /// has registered. By default, all built-in classifiers are included in a crawl,
        /// but these custom classifiers always override the default classifiers
        /// for a given classification.</p>
        pub fn classifiers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.classifiers(inp);
            self
        }
        /// <p>A list of custom classifiers that the user
        /// has registered. By default, all built-in classifiers are included in a crawl,
        /// but these custom classifiers always override the default classifiers
        /// for a given classification.</p>
        pub fn set_classifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_classifiers(input);
            self
        }
        /// <p>The table prefix used for catalog tables that are created.</p>
        pub fn table_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_prefix(inp);
            self
        }
        /// <p>The table prefix used for catalog tables that are created.</p>
        pub fn set_table_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_prefix(input);
            self
        }
        /// <p>The policy for the crawler's update and deletion behavior.</p>
        pub fn schema_change_policy(mut self, inp: crate::model::SchemaChangePolicy) -> Self {
            self.inner = self.inner.schema_change_policy(inp);
            self
        }
        /// <p>The policy for the crawler's update and deletion behavior.</p>
        pub fn set_schema_change_policy(
            mut self,
            input: std::option::Option<crate::model::SchemaChangePolicy>,
        ) -> Self {
            self.inner = self.inner.set_schema_change_policy(input);
            self
        }
        /// <p>A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.</p>
        pub fn recrawl_policy(mut self, inp: crate::model::RecrawlPolicy) -> Self {
            self.inner = self.inner.recrawl_policy(inp);
            self
        }
        /// <p>A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.</p>
        pub fn set_recrawl_policy(
            mut self,
            input: std::option::Option<crate::model::RecrawlPolicy>,
        ) -> Self {
            self.inner = self.inner.set_recrawl_policy(input);
            self
        }
        /// <p>Specifies data lineage configuration settings for the crawler.</p>
        pub fn lineage_configuration(mut self, inp: crate::model::LineageConfiguration) -> Self {
            self.inner = self.inner.lineage_configuration(inp);
            self
        }
        /// <p>Specifies data lineage configuration settings for the crawler.</p>
        pub fn set_lineage_configuration(
            mut self,
            input: std::option::Option<crate::model::LineageConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_lineage_configuration(input);
            self
        }
        /// <p>Crawler configuration information. This versioned JSON string allows users
        /// to specify aspects of a crawler's behavior.
        /// For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a>.</p>
        pub fn configuration(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>Crawler configuration information. This versioned JSON string allows users
        /// to specify aspects of a crawler's behavior.
        /// For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a>.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used by this
        /// crawler.</p>
        pub fn crawler_security_configuration(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.crawler_security_configuration(inp);
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used by this
        /// crawler.</p>
        pub fn set_crawler_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_crawler_security_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCrawlerSchedule`.
    ///
    /// <p>Updates the schedule of a crawler using a <code>cron</code> expression. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCrawlerSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_crawler_schedule_input::Builder,
    }
    impl<C, M, R> UpdateCrawlerSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCrawlerSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCrawlerScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCrawlerScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCrawlerScheduleInputOperationOutputAlias,
                crate::output::UpdateCrawlerScheduleOutput,
                crate::error::UpdateCrawlerScheduleError,
                crate::input::UpdateCrawlerScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the crawler whose schedule to update.</p>
        pub fn crawler_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.crawler_name(inp);
            self
        }
        /// <p>The name of the crawler whose schedule to update.</p>
        pub fn set_crawler_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_crawler_name(input);
            self
        }
        /// <p>The updated <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn schedule(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>The updated <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDatabase`.
    ///
    /// <p>Updates an existing database definition in a Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_database_input::Builder,
    }
    impl<C, M, R> UpdateDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDatabaseInputOperationOutputAlias,
                crate::output::UpdateDatabaseOutput,
                crate::error::UpdateDatabaseError,
                crate::input::UpdateDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog in which the metadata database resides. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog in which the metadata database resides. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the database to update in the catalog. For Hive
        /// compatibility, this is folded to lowercase.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the database to update in the catalog. For Hive
        /// compatibility, this is folded to lowercase.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A <code>DatabaseInput</code> object specifying the new definition
        /// of the metadata database in the catalog.</p>
        pub fn database_input(mut self, inp: crate::model::DatabaseInput) -> Self {
            self.inner = self.inner.database_input(inp);
            self
        }
        /// <p>A <code>DatabaseInput</code> object specifying the new definition
        /// of the metadata database in the catalog.</p>
        pub fn set_database_input(
            mut self,
            input: std::option::Option<crate::model::DatabaseInput>,
        ) -> Self {
            self.inner = self.inner.set_database_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDevEndpoint`.
    ///
    /// <p>Updates a specified development endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDevEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dev_endpoint_input::Builder,
    }
    impl<C, M, R> UpdateDevEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDevEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDevEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDevEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDevEndpointInputOperationOutputAlias,
                crate::output::UpdateDevEndpointOutput,
                crate::error::UpdateDevEndpointError,
                crate::input::UpdateDevEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>DevEndpoint</code> to be updated.</p>
        pub fn endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(inp);
            self
        }
        /// <p>The name of the <code>DevEndpoint</code> to be updated.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// <p>The public key for the <code>DevEndpoint</code> to use.</p>
        pub fn public_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_key(inp);
            self
        }
        /// <p>The public key for the <code>DevEndpoint</code> to use.</p>
        pub fn set_public_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_public_key(input);
            self
        }
        /// Appends an item to `AddPublicKeys`.
        ///
        /// To override the contents of this collection use [`set_add_public_keys`](Self::set_add_public_keys).
        ///
        /// <p>The list of public keys for the <code>DevEndpoint</code> to use.</p>
        pub fn add_public_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.add_public_keys(inp);
            self
        }
        /// <p>The list of public keys for the <code>DevEndpoint</code> to use.</p>
        pub fn set_add_public_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_add_public_keys(input);
            self
        }
        /// Appends an item to `DeletePublicKeys`.
        ///
        /// To override the contents of this collection use [`set_delete_public_keys`](Self::set_delete_public_keys).
        ///
        /// <p>The list of public keys to be deleted from the <code>DevEndpoint</code>.</p>
        pub fn delete_public_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delete_public_keys(inp);
            self
        }
        /// <p>The list of public keys to be deleted from the <code>DevEndpoint</code>.</p>
        pub fn set_delete_public_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_delete_public_keys(input);
            self
        }
        /// <p>Custom Python or Java libraries to be loaded in the <code>DevEndpoint</code>.</p>
        pub fn custom_libraries(mut self, inp: crate::model::DevEndpointCustomLibraries) -> Self {
            self.inner = self.inner.custom_libraries(inp);
            self
        }
        /// <p>Custom Python or Java libraries to be loaded in the <code>DevEndpoint</code>.</p>
        pub fn set_custom_libraries(
            mut self,
            input: std::option::Option<crate::model::DevEndpointCustomLibraries>,
        ) -> Self {
            self.inner = self.inner.set_custom_libraries(input);
            self
        }
        /// <p>
        /// <code>True</code> if the list of custom libraries to be loaded in the development endpoint
        /// needs to be updated, or <code>False</code> if otherwise.</p>
        pub fn update_etl_libraries(mut self, inp: bool) -> Self {
            self.inner = self.inner.update_etl_libraries(inp);
            self
        }
        /// <p>
        /// <code>True</code> if the list of custom libraries to be loaded in the development endpoint
        /// needs to be updated, or <code>False</code> if otherwise.</p>
        pub fn set_update_etl_libraries(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_update_etl_libraries(input);
            self
        }
        /// Appends an item to `DeleteArguments`.
        ///
        /// To override the contents of this collection use [`set_delete_arguments`](Self::set_delete_arguments).
        ///
        /// <p>The list of argument keys to be deleted from the map of arguments used to configure the
        /// <code>DevEndpoint</code>.</p>
        pub fn delete_arguments(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delete_arguments(inp);
            self
        }
        /// <p>The list of argument keys to be deleted from the map of arguments used to configure the
        /// <code>DevEndpoint</code>.</p>
        pub fn set_delete_arguments(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_delete_arguments(input);
            self
        }
        /// Adds a key-value pair to `AddArguments`.
        ///
        /// To override the contents of this collection use [`set_add_arguments`](Self::set_add_arguments).
        ///
        /// <p>The map of arguments to add the map of arguments used to configure the
        /// <code>DevEndpoint</code>.</p>
        ///
        /// <p>Valid arguments are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"--enable-glue-datacatalog": ""</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
        pub fn add_arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.add_arguments(k, v);
            self
        }
        /// <p>The map of arguments to add the map of arguments used to configure the
        /// <code>DevEndpoint</code>.</p>
        ///
        /// <p>Valid arguments are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"--enable-glue-datacatalog": ""</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
        pub fn set_add_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_add_arguments(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJob`.
    ///
    /// <p>Updates an existing job definition.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_job_input::Builder,
    }
    impl<C, M, R> UpdateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateJobInputOperationOutputAlias,
                crate::output::UpdateJobOutput,
                crate::error::UpdateJobError,
                crate::input::UpdateJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job definition to update.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the job definition to update.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>Specifies the values with which to update the job definition.</p>
        pub fn job_update(mut self, inp: crate::model::JobUpdate) -> Self {
            self.inner = self.inner.job_update(inp);
            self
        }
        /// <p>Specifies the values with which to update the job definition.</p>
        pub fn set_job_update(
            mut self,
            input: std::option::Option<crate::model::JobUpdate>,
        ) -> Self {
            self.inner = self.inner.set_job_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMLTransform`.
    ///
    /// <p>Updates an existing machine learning transform. Call this operation to tune the algorithm parameters to achieve better results.</p>
    ///
    /// <p>After calling this operation, you can call the <code>StartMLEvaluationTaskRun</code>
    /// operation to assess how well your new parameters achieved your goals (such as improving the
    /// quality of your machine learning transform, or making it more cost-effective).</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMLTransform<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ml_transform_input::Builder,
    }
    impl<C, M, R> UpdateMLTransform<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMLTransform`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMlTransformOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMLTransformError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMlTransformInputOperationOutputAlias,
                crate::output::UpdateMlTransformOutput,
                crate::error::UpdateMLTransformError,
                crate::input::UpdateMlTransformInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier that was generated when the transform was created.</p>
        pub fn transform_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_id(inp);
            self
        }
        /// <p>A unique identifier that was generated when the transform was created.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_transform_id(input);
            self
        }
        /// <p>The unique name that you gave the transform when you created it.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The unique name that you gave the transform when you created it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the transform. The default is an empty string.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the transform. The default is an empty string.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The configuration parameters that are specific to the transform type (algorithm) used.
        /// Conditionally dependent on the transform type.</p>
        pub fn parameters(mut self, inp: crate::model::TransformParameters) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The configuration parameters that are specific to the transform type (algorithm) used.
        /// Conditionally dependent on the transform type.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::TransformParameters>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role with the required
        /// permissions.</p>
        pub fn role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role with the required
        /// permissions.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
        pub fn glue_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.glue_version(inp);
            self
        }
        /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_glue_version(input);
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
        /// processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
        /// information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>. </p>
        ///
        /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>
        pub fn max_capacity(mut self, inp: f64) -> Self {
            self.inner = self.inner.max_capacity(inp);
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
        /// processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
        /// information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>. </p>
        ///
        /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_max_capacity(input);
            self
        }
        /// <p>The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        pub fn worker_type(mut self, inp: crate::model::WorkerType) -> Self {
            self.inner = self.inner.worker_type(inp);
            self
        }
        /// <p>The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.inner = self.inner.set_worker_type(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>
        pub fn number_of_workers(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_workers(inp);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_workers(input);
            self
        }
        /// <p>The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>
        pub fn timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout(inp);
            self
        }
        /// <p>The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>The maximum number of times to retry a task for this transform after a task run fails.</p>
        pub fn max_retries(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_retries(inp);
            self
        }
        /// <p>The maximum number of times to retry a task for this transform after a task run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_retries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePartition`.
    ///
    /// <p>Updates a partition.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePartition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_partition_input::Builder,
    }
    impl<C, M, R> UpdatePartition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePartition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePartitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePartitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePartitionInputOperationOutputAlias,
                crate::output::UpdatePartitionOutput,
                crate::error::UpdatePartitionError,
                crate::input::UpdatePartitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the partition to be updated resides. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the partition to be updated resides. If none is provided,
        /// the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database in which the table in question
        /// resides.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database in which the table in question
        /// resides.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the table in which the partition to be updated is located.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table in which the partition to be updated is located.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
        /// Appends an item to `PartitionValueList`.
        ///
        /// To override the contents of this collection use [`set_partition_value_list`](Self::set_partition_value_list).
        ///
        /// <p>List of partition key values that define the partition to update.</p>
        pub fn partition_value_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partition_value_list(inp);
            self
        }
        /// <p>List of partition key values that define the partition to update.</p>
        pub fn set_partition_value_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_partition_value_list(input);
            self
        }
        /// <p>The new partition object to update the partition to.</p>
        ///
        /// <p>The <code>Values</code> property can't be changed. If you want to change the partition key values for a partition, delete and recreate the partition.</p>
        pub fn partition_input(mut self, inp: crate::model::PartitionInput) -> Self {
            self.inner = self.inner.partition_input(inp);
            self
        }
        /// <p>The new partition object to update the partition to.</p>
        ///
        /// <p>The <code>Values</code> property can't be changed. If you want to change the partition key values for a partition, delete and recreate the partition.</p>
        pub fn set_partition_input(
            mut self,
            input: std::option::Option<crate::model::PartitionInput>,
        ) -> Self {
            self.inner = self.inner.set_partition_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRegistry`.
    ///
    /// <p>Updates an existing registry which is used to hold a collection of schemas. The updated properties relate to the registry, and do not modify any of the schemas within the registry. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRegistry<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_registry_input::Builder,
    }
    impl<C, M, R> UpdateRegistry<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRegistry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRegistryOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRegistryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRegistryInputOperationOutputAlias,
                crate::output::UpdateRegistryOutput,
                crate::error::UpdateRegistryError,
                crate::input::UpdateRegistryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).</p>
        pub fn registry_id(mut self, inp: crate::model::RegistryId) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).</p>
        pub fn set_registry_id(
            mut self,
            input: std::option::Option<crate::model::RegistryId>,
        ) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>A description of the registry. If description is not provided, this field will not be updated.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the registry. If description is not provided, this field will not be updated.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSchema`.
    ///
    /// <p>Updates the description, compatibility setting, or version checkpoint for a schema set.</p>
    /// <p>For updating the compatibility setting, the call will not validate compatibility for the entire set of schema versions with the new compatibility setting. If the value for <code>Compatibility</code> is provided, the <code>VersionNumber</code> (a checkpoint) is also required. The API will validate the checkpoint version number for consistency.</p>
    /// <p>If the value for the <code>VersionNumber</code> (checkpoint) is provided, <code>Compatibility</code> is optional and this can be used to set/reset a checkpoint for the schema.</p>
    /// <p>This update will happen only if the schema is in the AVAILABLE state.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_schema_input::Builder,
    }
    impl<C, M, R> UpdateSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSchemaInputOperationOutputAlias,
                crate::output::UpdateSchemaOutput,
                crate::error::UpdateSchemaError,
                crate::input::UpdateSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn schema_id(mut self, inp: crate::model::SchemaId) -> Self {
            self.inner = self.inner.schema_id(inp);
            self
        }
        /// <p>This is a wrapper structure to contain schema identity fields. The structure contains:</p>
        /// <ul>
        /// <li>
        /// <p>SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// <li>
        /// <p>SchemaId$SchemaName: The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        /// </li>
        /// </ul>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.inner = self.inner.set_schema_id(input);
            self
        }
        /// <p>Version number required for check pointing. One of <code>VersionNumber</code> or <code>Compatibility</code> has to be provided.</p>
        pub fn schema_version_number(mut self, inp: crate::model::SchemaVersionNumber) -> Self {
            self.inner = self.inner.schema_version_number(inp);
            self
        }
        /// <p>Version number required for check pointing. One of <code>VersionNumber</code> or <code>Compatibility</code> has to be provided.</p>
        pub fn set_schema_version_number(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionNumber>,
        ) -> Self {
            self.inner = self.inner.set_schema_version_number(input);
            self
        }
        /// <p>The new compatibility setting for the schema.</p>
        pub fn compatibility(mut self, inp: crate::model::Compatibility) -> Self {
            self.inner = self.inner.compatibility(inp);
            self
        }
        /// <p>The new compatibility setting for the schema.</p>
        pub fn set_compatibility(
            mut self,
            input: std::option::Option<crate::model::Compatibility>,
        ) -> Self {
            self.inner = self.inner.set_compatibility(input);
            self
        }
        /// <p>The new description for the schema.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description for the schema.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTable`.
    ///
    /// <p>Updates a metadata table in the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_table_input::Builder,
    }
    impl<C, M, R> UpdateTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTableOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTableInputOperationOutputAlias,
                crate::output::UpdateTableOutput,
                crate::error::UpdateTableError,
                crate::input::UpdateTableInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account
        /// ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database in which the table resides. For Hive
        /// compatibility, this name is entirely lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>An updated <code>TableInput</code> object to define the metadata table
        /// in the catalog.</p>
        pub fn table_input(mut self, inp: crate::model::TableInput) -> Self {
            self.inner = self.inner.table_input(inp);
            self
        }
        /// <p>An updated <code>TableInput</code> object to define the metadata table
        /// in the catalog.</p>
        pub fn set_table_input(
            mut self,
            input: std::option::Option<crate::model::TableInput>,
        ) -> Self {
            self.inner = self.inner.set_table_input(input);
            self
        }
        /// <p>By default, <code>UpdateTable</code> always creates an archived version of the table
        /// before updating it. However, if <code>skipArchive</code> is set to true,
        /// <code>UpdateTable</code> does not create the archived version.</p>
        pub fn skip_archive(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_archive(inp);
            self
        }
        /// <p>By default, <code>UpdateTable</code> always creates an archived version of the table
        /// before updating it. However, if <code>skipArchive</code> is set to true,
        /// <code>UpdateTable</code> does not create the archived version.</p>
        pub fn set_skip_archive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_archive(input);
            self
        }
        /// <p>The transaction ID at which to update the table contents. </p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The transaction ID at which to update the table contents. </p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTrigger`.
    ///
    /// <p>Updates a trigger definition.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTrigger<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_trigger_input::Builder,
    }
    impl<C, M, R> UpdateTrigger<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTrigger`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTriggerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTriggerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTriggerInputOperationOutputAlias,
                crate::output::UpdateTriggerOutput,
                crate::error::UpdateTriggerError,
                crate::input::UpdateTriggerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the trigger to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the trigger to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The new values with which to update the trigger.</p>
        pub fn trigger_update(mut self, inp: crate::model::TriggerUpdate) -> Self {
            self.inner = self.inner.trigger_update(inp);
            self
        }
        /// <p>The new values with which to update the trigger.</p>
        pub fn set_trigger_update(
            mut self,
            input: std::option::Option<crate::model::TriggerUpdate>,
        ) -> Self {
            self.inner = self.inner.set_trigger_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserDefinedFunction`.
    ///
    /// <p>Updates an existing function definition in the Data Catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserDefinedFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_defined_function_input::Builder,
    }
    impl<C, M, R> UpdateUserDefinedFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserDefinedFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserDefinedFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserDefinedFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserDefinedFunctionInputOperationOutputAlias,
                crate::output::UpdateUserDefinedFunctionOutput,
                crate::error::UpdateUserDefinedFunctionError,
                crate::input::UpdateUserDefinedFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Data Catalog where the function to be updated is located. If none is
        /// provided, the Amazon Web Services account ID is used by default.</p>
        pub fn catalog_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_id(inp);
            self
        }
        /// <p>The ID of the Data Catalog where the function to be updated is located. If none is
        /// provided, the Amazon Web Services account ID is used by default.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_id(input);
            self
        }
        /// <p>The name of the catalog database where the function to be updated is
        /// located.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the catalog database where the function to be updated is
        /// located.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the function.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the function.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A <code>FunctionInput</code> object that redefines the function in the Data
        /// Catalog.</p>
        pub fn function_input(mut self, inp: crate::model::UserDefinedFunctionInput) -> Self {
            self.inner = self.inner.function_input(inp);
            self
        }
        /// <p>A <code>FunctionInput</code> object that redefines the function in the Data
        /// Catalog.</p>
        pub fn set_function_input(
            mut self,
            input: std::option::Option<crate::model::UserDefinedFunctionInput>,
        ) -> Self {
            self.inner = self.inner.set_function_input(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkflow`.
    ///
    /// <p>Updates an existing workflow.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateWorkflow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_workflow_input::Builder,
    }
    impl<C, M, R> UpdateWorkflow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkflow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkflowOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkflowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkflowInputOperationOutputAlias,
                crate::output::UpdateWorkflowOutput,
                crate::error::UpdateWorkflowError,
                crate::input::UpdateWorkflowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the workflow to be updated.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the workflow to be updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the workflow.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the workflow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `DefaultRunProperties`.
        ///
        /// To override the contents of this collection use [`set_default_run_properties`](Self::set_default_run_properties).
        ///
        /// <p>A collection of properties to be used as part of each execution of the workflow.</p>
        pub fn default_run_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.default_run_properties(k, v);
            self
        }
        /// <p>A collection of properties to be used as part of each execution of the workflow.</p>
        pub fn set_default_run_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_default_run_properties(input);
            self
        }
        /// <p>You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.</p>
        pub fn max_concurrent_runs(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_concurrent_runs(inp);
            self
        }
        /// <p>You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.</p>
        pub fn set_max_concurrent_runs(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_concurrent_runs(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
