// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkflowOutput {
    /// <p>The name of the workflow which was specified in input.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateWorkflowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkflowOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateWorkflowOutput`](crate::output::UpdateWorkflowOutput)
pub mod update_workflow_output {
    /// A builder for [`UpdateWorkflowOutput`](crate::output::UpdateWorkflowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the workflow which was specified in input.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the workflow which was specified in input.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkflowOutput`](crate::output::UpdateWorkflowOutput)
        pub fn build(self) -> crate::output::UpdateWorkflowOutput {
            crate::output::UpdateWorkflowOutput { name: self.name }
        }
    }
}
impl UpdateWorkflowOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWorkflowOutput`](crate::output::UpdateWorkflowOutput)
    pub fn builder() -> crate::output::update_workflow_output::Builder {
        crate::output::update_workflow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserDefinedFunctionOutput {}
impl std::fmt::Debug for UpdateUserDefinedFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserDefinedFunctionOutput");
        formatter.finish()
    }
}
/// See [`UpdateUserDefinedFunctionOutput`](crate::output::UpdateUserDefinedFunctionOutput)
pub mod update_user_defined_function_output {
    /// A builder for [`UpdateUserDefinedFunctionOutput`](crate::output::UpdateUserDefinedFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateUserDefinedFunctionOutput`](crate::output::UpdateUserDefinedFunctionOutput)
        pub fn build(self) -> crate::output::UpdateUserDefinedFunctionOutput {
            crate::output::UpdateUserDefinedFunctionOutput {}
        }
    }
}
impl UpdateUserDefinedFunctionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserDefinedFunctionOutput`](crate::output::UpdateUserDefinedFunctionOutput)
    pub fn builder() -> crate::output::update_user_defined_function_output::Builder {
        crate::output::update_user_defined_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTriggerOutput {
    /// <p>The resulting trigger definition.</p>
    pub trigger: std::option::Option<crate::model::Trigger>,
}
impl std::fmt::Debug for UpdateTriggerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTriggerOutput");
        formatter.field("trigger", &self.trigger);
        formatter.finish()
    }
}
/// See [`UpdateTriggerOutput`](crate::output::UpdateTriggerOutput)
pub mod update_trigger_output {
    /// A builder for [`UpdateTriggerOutput`](crate::output::UpdateTriggerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trigger: std::option::Option<crate::model::Trigger>,
    }
    impl Builder {
        /// <p>The resulting trigger definition.</p>
        pub fn trigger(mut self, input: crate::model::Trigger) -> Self {
            self.trigger = Some(input);
            self
        }
        /// <p>The resulting trigger definition.</p>
        pub fn set_trigger(mut self, input: std::option::Option<crate::model::Trigger>) -> Self {
            self.trigger = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTriggerOutput`](crate::output::UpdateTriggerOutput)
        pub fn build(self) -> crate::output::UpdateTriggerOutput {
            crate::output::UpdateTriggerOutput {
                trigger: self.trigger,
            }
        }
    }
}
impl UpdateTriggerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTriggerOutput`](crate::output::UpdateTriggerOutput)
    pub fn builder() -> crate::output::update_trigger_output::Builder {
        crate::output::update_trigger_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTableOutput {}
impl std::fmt::Debug for UpdateTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTableOutput");
        formatter.finish()
    }
}
/// See [`UpdateTableOutput`](crate::output::UpdateTableOutput)
pub mod update_table_output {
    /// A builder for [`UpdateTableOutput`](crate::output::UpdateTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateTableOutput`](crate::output::UpdateTableOutput)
        pub fn build(self) -> crate::output::UpdateTableOutput {
            crate::output::UpdateTableOutput {}
        }
    }
}
impl UpdateTableOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTableOutput`](crate::output::UpdateTableOutput)
    pub fn builder() -> crate::output::update_table_output::Builder {
        crate::output::update_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSchemaOutput {
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The name of the registry that contains the schema.</p>
    pub registry_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSchemaOutput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("registry_name", &self.registry_name);
        formatter.finish()
    }
}
/// See [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
pub mod update_schema_output {
    /// A builder for [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The name of the registry that contains the schema.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry that contains the schema.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
        pub fn build(self) -> crate::output::UpdateSchemaOutput {
            crate::output::UpdateSchemaOutput {
                schema_arn: self.schema_arn,
                schema_name: self.schema_name,
                registry_name: self.registry_name,
            }
        }
    }
}
impl UpdateSchemaOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSchemaOutput`](crate::output::UpdateSchemaOutput)
    pub fn builder() -> crate::output::update_schema_output::Builder {
        crate::output::update_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRegistryOutput {
    /// <p>The name of the updated registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource name (ARN) of the updated registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateRegistryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRegistryOutput");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.finish()
    }
}
/// See [`UpdateRegistryOutput`](crate::output::UpdateRegistryOutput)
pub mod update_registry_output {
    /// A builder for [`UpdateRegistryOutput`](crate::output::UpdateRegistryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the updated registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the updated registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The Amazon Resource name (ARN) of the updated registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource name (ARN) of the updated registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRegistryOutput`](crate::output::UpdateRegistryOutput)
        pub fn build(self) -> crate::output::UpdateRegistryOutput {
            crate::output::UpdateRegistryOutput {
                registry_name: self.registry_name,
                registry_arn: self.registry_arn,
            }
        }
    }
}
impl UpdateRegistryOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRegistryOutput`](crate::output::UpdateRegistryOutput)
    pub fn builder() -> crate::output::update_registry_output::Builder {
        crate::output::update_registry_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePartitionOutput {}
impl std::fmt::Debug for UpdatePartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePartitionOutput");
        formatter.finish()
    }
}
/// See [`UpdatePartitionOutput`](crate::output::UpdatePartitionOutput)
pub mod update_partition_output {
    /// A builder for [`UpdatePartitionOutput`](crate::output::UpdatePartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdatePartitionOutput`](crate::output::UpdatePartitionOutput)
        pub fn build(self) -> crate::output::UpdatePartitionOutput {
            crate::output::UpdatePartitionOutput {}
        }
    }
}
impl UpdatePartitionOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePartitionOutput`](crate::output::UpdatePartitionOutput)
    pub fn builder() -> crate::output::update_partition_output::Builder {
        crate::output::update_partition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMlTransformOutput {
    /// <p>The unique identifier for the transform that was updated.</p>
    pub transform_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateMlTransformOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMlTransformOutput");
        formatter.field("transform_id", &self.transform_id);
        formatter.finish()
    }
}
/// See [`UpdateMlTransformOutput`](crate::output::UpdateMlTransformOutput)
pub mod update_ml_transform_output {
    /// A builder for [`UpdateMlTransformOutput`](crate::output::UpdateMlTransformOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the transform that was updated.</p>
        pub fn transform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the transform that was updated.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.transform_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMlTransformOutput`](crate::output::UpdateMlTransformOutput)
        pub fn build(self) -> crate::output::UpdateMlTransformOutput {
            crate::output::UpdateMlTransformOutput {
                transform_id: self.transform_id,
            }
        }
    }
}
impl UpdateMlTransformOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMlTransformOutput`](crate::output::UpdateMlTransformOutput)
    pub fn builder() -> crate::output::update_ml_transform_output::Builder {
        crate::output::update_ml_transform_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJobOutput {
    /// <p>Returns the name of the updated job definition.</p>
    pub job_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJobOutput");
        formatter.field("job_name", &self.job_name);
        formatter.finish()
    }
}
/// See [`UpdateJobOutput`](crate::output::UpdateJobOutput)
pub mod update_job_output {
    /// A builder for [`UpdateJobOutput`](crate::output::UpdateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns the name of the updated job definition.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>Returns the name of the updated job definition.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJobOutput`](crate::output::UpdateJobOutput)
        pub fn build(self) -> crate::output::UpdateJobOutput {
            crate::output::UpdateJobOutput {
                job_name: self.job_name,
            }
        }
    }
}
impl UpdateJobOutput {
    /// Creates a new builder-style object to manufacture [`UpdateJobOutput`](crate::output::UpdateJobOutput)
    pub fn builder() -> crate::output::update_job_output::Builder {
        crate::output::update_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDevEndpointOutput {}
impl std::fmt::Debug for UpdateDevEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDevEndpointOutput");
        formatter.finish()
    }
}
/// See [`UpdateDevEndpointOutput`](crate::output::UpdateDevEndpointOutput)
pub mod update_dev_endpoint_output {
    /// A builder for [`UpdateDevEndpointOutput`](crate::output::UpdateDevEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDevEndpointOutput`](crate::output::UpdateDevEndpointOutput)
        pub fn build(self) -> crate::output::UpdateDevEndpointOutput {
            crate::output::UpdateDevEndpointOutput {}
        }
    }
}
impl UpdateDevEndpointOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDevEndpointOutput`](crate::output::UpdateDevEndpointOutput)
    pub fn builder() -> crate::output::update_dev_endpoint_output::Builder {
        crate::output::update_dev_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDatabaseOutput {}
impl std::fmt::Debug for UpdateDatabaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDatabaseOutput");
        formatter.finish()
    }
}
/// See [`UpdateDatabaseOutput`](crate::output::UpdateDatabaseOutput)
pub mod update_database_output {
    /// A builder for [`UpdateDatabaseOutput`](crate::output::UpdateDatabaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDatabaseOutput`](crate::output::UpdateDatabaseOutput)
        pub fn build(self) -> crate::output::UpdateDatabaseOutput {
            crate::output::UpdateDatabaseOutput {}
        }
    }
}
impl UpdateDatabaseOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDatabaseOutput`](crate::output::UpdateDatabaseOutput)
    pub fn builder() -> crate::output::update_database_output::Builder {
        crate::output::update_database_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCrawlerScheduleOutput {}
impl std::fmt::Debug for UpdateCrawlerScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCrawlerScheduleOutput");
        formatter.finish()
    }
}
/// See [`UpdateCrawlerScheduleOutput`](crate::output::UpdateCrawlerScheduleOutput)
pub mod update_crawler_schedule_output {
    /// A builder for [`UpdateCrawlerScheduleOutput`](crate::output::UpdateCrawlerScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateCrawlerScheduleOutput`](crate::output::UpdateCrawlerScheduleOutput)
        pub fn build(self) -> crate::output::UpdateCrawlerScheduleOutput {
            crate::output::UpdateCrawlerScheduleOutput {}
        }
    }
}
impl UpdateCrawlerScheduleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCrawlerScheduleOutput`](crate::output::UpdateCrawlerScheduleOutput)
    pub fn builder() -> crate::output::update_crawler_schedule_output::Builder {
        crate::output::update_crawler_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCrawlerOutput {}
impl std::fmt::Debug for UpdateCrawlerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCrawlerOutput");
        formatter.finish()
    }
}
/// See [`UpdateCrawlerOutput`](crate::output::UpdateCrawlerOutput)
pub mod update_crawler_output {
    /// A builder for [`UpdateCrawlerOutput`](crate::output::UpdateCrawlerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateCrawlerOutput`](crate::output::UpdateCrawlerOutput)
        pub fn build(self) -> crate::output::UpdateCrawlerOutput {
            crate::output::UpdateCrawlerOutput {}
        }
    }
}
impl UpdateCrawlerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCrawlerOutput`](crate::output::UpdateCrawlerOutput)
    pub fn builder() -> crate::output::update_crawler_output::Builder {
        crate::output::update_crawler_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionOutput {}
impl std::fmt::Debug for UpdateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionOutput");
        formatter.finish()
    }
}
/// See [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
pub mod update_connection_output {
    /// A builder for [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
        pub fn build(self) -> crate::output::UpdateConnectionOutput {
            crate::output::UpdateConnectionOutput {}
        }
    }
}
impl UpdateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionOutput`](crate::output::UpdateConnectionOutput)
    pub fn builder() -> crate::output::update_connection_output::Builder {
        crate::output::update_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateColumnStatisticsForTableOutput {
    /// <p>List of ColumnStatisticsErrors.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::ColumnStatisticsError>>,
}
impl std::fmt::Debug for UpdateColumnStatisticsForTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateColumnStatisticsForTableOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`UpdateColumnStatisticsForTableOutput`](crate::output::UpdateColumnStatisticsForTableOutput)
pub mod update_column_statistics_for_table_output {
    /// A builder for [`UpdateColumnStatisticsForTableOutput`](crate::output::UpdateColumnStatisticsForTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::ColumnStatisticsError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>List of ColumnStatisticsErrors.</p>
        pub fn errors(mut self, input: impl Into<crate::model::ColumnStatisticsError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>List of ColumnStatisticsErrors.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnStatisticsError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateColumnStatisticsForTableOutput`](crate::output::UpdateColumnStatisticsForTableOutput)
        pub fn build(self) -> crate::output::UpdateColumnStatisticsForTableOutput {
            crate::output::UpdateColumnStatisticsForTableOutput {
                errors: self.errors,
            }
        }
    }
}
impl UpdateColumnStatisticsForTableOutput {
    /// Creates a new builder-style object to manufacture [`UpdateColumnStatisticsForTableOutput`](crate::output::UpdateColumnStatisticsForTableOutput)
    pub fn builder() -> crate::output::update_column_statistics_for_table_output::Builder {
        crate::output::update_column_statistics_for_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateColumnStatisticsForPartitionOutput {
    /// <p>Error occurred during updating column statistics data.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::ColumnStatisticsError>>,
}
impl std::fmt::Debug for UpdateColumnStatisticsForPartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateColumnStatisticsForPartitionOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`UpdateColumnStatisticsForPartitionOutput`](crate::output::UpdateColumnStatisticsForPartitionOutput)
pub mod update_column_statistics_for_partition_output {
    /// A builder for [`UpdateColumnStatisticsForPartitionOutput`](crate::output::UpdateColumnStatisticsForPartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::ColumnStatisticsError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Error occurred during updating column statistics data.</p>
        pub fn errors(mut self, input: impl Into<crate::model::ColumnStatisticsError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Error occurred during updating column statistics data.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnStatisticsError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateColumnStatisticsForPartitionOutput`](crate::output::UpdateColumnStatisticsForPartitionOutput)
        pub fn build(self) -> crate::output::UpdateColumnStatisticsForPartitionOutput {
            crate::output::UpdateColumnStatisticsForPartitionOutput {
                errors: self.errors,
            }
        }
    }
}
impl UpdateColumnStatisticsForPartitionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateColumnStatisticsForPartitionOutput`](crate::output::UpdateColumnStatisticsForPartitionOutput)
    pub fn builder() -> crate::output::update_column_statistics_for_partition_output::Builder {
        crate::output::update_column_statistics_for_partition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClassifierOutput {}
impl std::fmt::Debug for UpdateClassifierOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClassifierOutput");
        formatter.finish()
    }
}
/// See [`UpdateClassifierOutput`](crate::output::UpdateClassifierOutput)
pub mod update_classifier_output {
    /// A builder for [`UpdateClassifierOutput`](crate::output::UpdateClassifierOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateClassifierOutput`](crate::output::UpdateClassifierOutput)
        pub fn build(self) -> crate::output::UpdateClassifierOutput {
            crate::output::UpdateClassifierOutput {}
        }
    }
}
impl UpdateClassifierOutput {
    /// Creates a new builder-style object to manufacture [`UpdateClassifierOutput`](crate::output::UpdateClassifierOutput)
    pub fn builder() -> crate::output::update_classifier_output::Builder {
        crate::output::update_classifier_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBlueprintOutput {
    /// <p>Returns the name of the blueprint that was updated.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateBlueprintOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBlueprintOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`UpdateBlueprintOutput`](crate::output::UpdateBlueprintOutput)
pub mod update_blueprint_output {
    /// A builder for [`UpdateBlueprintOutput`](crate::output::UpdateBlueprintOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns the name of the blueprint that was updated.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Returns the name of the blueprint that was updated.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBlueprintOutput`](crate::output::UpdateBlueprintOutput)
        pub fn build(self) -> crate::output::UpdateBlueprintOutput {
            crate::output::UpdateBlueprintOutput { name: self.name }
        }
    }
}
impl UpdateBlueprintOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBlueprintOutput`](crate::output::UpdateBlueprintOutput)
    pub fn builder() -> crate::output::update_blueprint_output::Builder {
        crate::output::update_blueprint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopWorkflowRunOutput {}
impl std::fmt::Debug for StopWorkflowRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopWorkflowRunOutput");
        formatter.finish()
    }
}
/// See [`StopWorkflowRunOutput`](crate::output::StopWorkflowRunOutput)
pub mod stop_workflow_run_output {
    /// A builder for [`StopWorkflowRunOutput`](crate::output::StopWorkflowRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopWorkflowRunOutput`](crate::output::StopWorkflowRunOutput)
        pub fn build(self) -> crate::output::StopWorkflowRunOutput {
            crate::output::StopWorkflowRunOutput {}
        }
    }
}
impl StopWorkflowRunOutput {
    /// Creates a new builder-style object to manufacture [`StopWorkflowRunOutput`](crate::output::StopWorkflowRunOutput)
    pub fn builder() -> crate::output::stop_workflow_run_output::Builder {
        crate::output::stop_workflow_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopTriggerOutput {
    /// <p>The name of the trigger that was stopped.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopTriggerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopTriggerOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`StopTriggerOutput`](crate::output::StopTriggerOutput)
pub mod stop_trigger_output {
    /// A builder for [`StopTriggerOutput`](crate::output::StopTriggerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the trigger that was stopped.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the trigger that was stopped.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopTriggerOutput`](crate::output::StopTriggerOutput)
        pub fn build(self) -> crate::output::StopTriggerOutput {
            crate::output::StopTriggerOutput { name: self.name }
        }
    }
}
impl StopTriggerOutput {
    /// Creates a new builder-style object to manufacture [`StopTriggerOutput`](crate::output::StopTriggerOutput)
    pub fn builder() -> crate::output::stop_trigger_output::Builder {
        crate::output::stop_trigger_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopCrawlerScheduleOutput {}
impl std::fmt::Debug for StopCrawlerScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopCrawlerScheduleOutput");
        formatter.finish()
    }
}
/// See [`StopCrawlerScheduleOutput`](crate::output::StopCrawlerScheduleOutput)
pub mod stop_crawler_schedule_output {
    /// A builder for [`StopCrawlerScheduleOutput`](crate::output::StopCrawlerScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopCrawlerScheduleOutput`](crate::output::StopCrawlerScheduleOutput)
        pub fn build(self) -> crate::output::StopCrawlerScheduleOutput {
            crate::output::StopCrawlerScheduleOutput {}
        }
    }
}
impl StopCrawlerScheduleOutput {
    /// Creates a new builder-style object to manufacture [`StopCrawlerScheduleOutput`](crate::output::StopCrawlerScheduleOutput)
    pub fn builder() -> crate::output::stop_crawler_schedule_output::Builder {
        crate::output::stop_crawler_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopCrawlerOutput {}
impl std::fmt::Debug for StopCrawlerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopCrawlerOutput");
        formatter.finish()
    }
}
/// See [`StopCrawlerOutput`](crate::output::StopCrawlerOutput)
pub mod stop_crawler_output {
    /// A builder for [`StopCrawlerOutput`](crate::output::StopCrawlerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopCrawlerOutput`](crate::output::StopCrawlerOutput)
        pub fn build(self) -> crate::output::StopCrawlerOutput {
            crate::output::StopCrawlerOutput {}
        }
    }
}
impl StopCrawlerOutput {
    /// Creates a new builder-style object to manufacture [`StopCrawlerOutput`](crate::output::StopCrawlerOutput)
    pub fn builder() -> crate::output::stop_crawler_output::Builder {
        crate::output::stop_crawler_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartWorkflowRunOutput {
    /// <p>An Id for the new run.</p>
    pub run_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartWorkflowRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartWorkflowRunOutput");
        formatter.field("run_id", &self.run_id);
        formatter.finish()
    }
}
/// See [`StartWorkflowRunOutput`](crate::output::StartWorkflowRunOutput)
pub mod start_workflow_run_output {
    /// A builder for [`StartWorkflowRunOutput`](crate::output::StartWorkflowRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Id for the new run.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>An Id for the new run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartWorkflowRunOutput`](crate::output::StartWorkflowRunOutput)
        pub fn build(self) -> crate::output::StartWorkflowRunOutput {
            crate::output::StartWorkflowRunOutput {
                run_id: self.run_id,
            }
        }
    }
}
impl StartWorkflowRunOutput {
    /// Creates a new builder-style object to manufacture [`StartWorkflowRunOutput`](crate::output::StartWorkflowRunOutput)
    pub fn builder() -> crate::output::start_workflow_run_output::Builder {
        crate::output::start_workflow_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTriggerOutput {
    /// <p>The name of the trigger that was started.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartTriggerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTriggerOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`StartTriggerOutput`](crate::output::StartTriggerOutput)
pub mod start_trigger_output {
    /// A builder for [`StartTriggerOutput`](crate::output::StartTriggerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the trigger that was started.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the trigger that was started.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTriggerOutput`](crate::output::StartTriggerOutput)
        pub fn build(self) -> crate::output::StartTriggerOutput {
            crate::output::StartTriggerOutput { name: self.name }
        }
    }
}
impl StartTriggerOutput {
    /// Creates a new builder-style object to manufacture [`StartTriggerOutput`](crate::output::StartTriggerOutput)
    pub fn builder() -> crate::output::start_trigger_output::Builder {
        crate::output::start_trigger_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMlLabelingSetGenerationTaskRunOutput {
    /// <p>The unique run identifier that is associated with this task run.</p>
    pub task_run_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartMlLabelingSetGenerationTaskRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMlLabelingSetGenerationTaskRunOutput");
        formatter.field("task_run_id", &self.task_run_id);
        formatter.finish()
    }
}
/// See [`StartMlLabelingSetGenerationTaskRunOutput`](crate::output::StartMlLabelingSetGenerationTaskRunOutput)
pub mod start_ml_labeling_set_generation_task_run_output {
    /// A builder for [`StartMlLabelingSetGenerationTaskRunOutput`](crate::output::StartMlLabelingSetGenerationTaskRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique run identifier that is associated with this task run.</p>
        pub fn task_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_run_id = Some(input.into());
            self
        }
        /// <p>The unique run identifier that is associated with this task run.</p>
        pub fn set_task_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMlLabelingSetGenerationTaskRunOutput`](crate::output::StartMlLabelingSetGenerationTaskRunOutput)
        pub fn build(self) -> crate::output::StartMlLabelingSetGenerationTaskRunOutput {
            crate::output::StartMlLabelingSetGenerationTaskRunOutput {
                task_run_id: self.task_run_id,
            }
        }
    }
}
impl StartMlLabelingSetGenerationTaskRunOutput {
    /// Creates a new builder-style object to manufacture [`StartMlLabelingSetGenerationTaskRunOutput`](crate::output::StartMlLabelingSetGenerationTaskRunOutput)
    pub fn builder() -> crate::output::start_ml_labeling_set_generation_task_run_output::Builder {
        crate::output::start_ml_labeling_set_generation_task_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMlEvaluationTaskRunOutput {
    /// <p>The unique identifier associated with this run.</p>
    pub task_run_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartMlEvaluationTaskRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMlEvaluationTaskRunOutput");
        formatter.field("task_run_id", &self.task_run_id);
        formatter.finish()
    }
}
/// See [`StartMlEvaluationTaskRunOutput`](crate::output::StartMlEvaluationTaskRunOutput)
pub mod start_ml_evaluation_task_run_output {
    /// A builder for [`StartMlEvaluationTaskRunOutput`](crate::output::StartMlEvaluationTaskRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier associated with this run.</p>
        pub fn task_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_run_id = Some(input.into());
            self
        }
        /// <p>The unique identifier associated with this run.</p>
        pub fn set_task_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMlEvaluationTaskRunOutput`](crate::output::StartMlEvaluationTaskRunOutput)
        pub fn build(self) -> crate::output::StartMlEvaluationTaskRunOutput {
            crate::output::StartMlEvaluationTaskRunOutput {
                task_run_id: self.task_run_id,
            }
        }
    }
}
impl StartMlEvaluationTaskRunOutput {
    /// Creates a new builder-style object to manufacture [`StartMlEvaluationTaskRunOutput`](crate::output::StartMlEvaluationTaskRunOutput)
    pub fn builder() -> crate::output::start_ml_evaluation_task_run_output::Builder {
        crate::output::start_ml_evaluation_task_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartJobRunOutput {
    /// <p>The ID assigned to this job run.</p>
    pub job_run_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartJobRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartJobRunOutput");
        formatter.field("job_run_id", &self.job_run_id);
        formatter.finish()
    }
}
/// See [`StartJobRunOutput`](crate::output::StartJobRunOutput)
pub mod start_job_run_output {
    /// A builder for [`StartJobRunOutput`](crate::output::StartJobRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to this job run.</p>
        pub fn job_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_run_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to this job run.</p>
        pub fn set_job_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartJobRunOutput`](crate::output::StartJobRunOutput)
        pub fn build(self) -> crate::output::StartJobRunOutput {
            crate::output::StartJobRunOutput {
                job_run_id: self.job_run_id,
            }
        }
    }
}
impl StartJobRunOutput {
    /// Creates a new builder-style object to manufacture [`StartJobRunOutput`](crate::output::StartJobRunOutput)
    pub fn builder() -> crate::output::start_job_run_output::Builder {
        crate::output::start_job_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImportLabelsTaskRunOutput {
    /// <p>The unique identifier for the task run.</p>
    pub task_run_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartImportLabelsTaskRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImportLabelsTaskRunOutput");
        formatter.field("task_run_id", &self.task_run_id);
        formatter.finish()
    }
}
/// See [`StartImportLabelsTaskRunOutput`](crate::output::StartImportLabelsTaskRunOutput)
pub mod start_import_labels_task_run_output {
    /// A builder for [`StartImportLabelsTaskRunOutput`](crate::output::StartImportLabelsTaskRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the task run.</p>
        pub fn task_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_run_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the task run.</p>
        pub fn set_task_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImportLabelsTaskRunOutput`](crate::output::StartImportLabelsTaskRunOutput)
        pub fn build(self) -> crate::output::StartImportLabelsTaskRunOutput {
            crate::output::StartImportLabelsTaskRunOutput {
                task_run_id: self.task_run_id,
            }
        }
    }
}
impl StartImportLabelsTaskRunOutput {
    /// Creates a new builder-style object to manufacture [`StartImportLabelsTaskRunOutput`](crate::output::StartImportLabelsTaskRunOutput)
    pub fn builder() -> crate::output::start_import_labels_task_run_output::Builder {
        crate::output::start_import_labels_task_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartExportLabelsTaskRunOutput {
    /// <p>The unique identifier for the task run.</p>
    pub task_run_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartExportLabelsTaskRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartExportLabelsTaskRunOutput");
        formatter.field("task_run_id", &self.task_run_id);
        formatter.finish()
    }
}
/// See [`StartExportLabelsTaskRunOutput`](crate::output::StartExportLabelsTaskRunOutput)
pub mod start_export_labels_task_run_output {
    /// A builder for [`StartExportLabelsTaskRunOutput`](crate::output::StartExportLabelsTaskRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the task run.</p>
        pub fn task_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_run_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the task run.</p>
        pub fn set_task_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartExportLabelsTaskRunOutput`](crate::output::StartExportLabelsTaskRunOutput)
        pub fn build(self) -> crate::output::StartExportLabelsTaskRunOutput {
            crate::output::StartExportLabelsTaskRunOutput {
                task_run_id: self.task_run_id,
            }
        }
    }
}
impl StartExportLabelsTaskRunOutput {
    /// Creates a new builder-style object to manufacture [`StartExportLabelsTaskRunOutput`](crate::output::StartExportLabelsTaskRunOutput)
    pub fn builder() -> crate::output::start_export_labels_task_run_output::Builder {
        crate::output::start_export_labels_task_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartCrawlerScheduleOutput {}
impl std::fmt::Debug for StartCrawlerScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartCrawlerScheduleOutput");
        formatter.finish()
    }
}
/// See [`StartCrawlerScheduleOutput`](crate::output::StartCrawlerScheduleOutput)
pub mod start_crawler_schedule_output {
    /// A builder for [`StartCrawlerScheduleOutput`](crate::output::StartCrawlerScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartCrawlerScheduleOutput`](crate::output::StartCrawlerScheduleOutput)
        pub fn build(self) -> crate::output::StartCrawlerScheduleOutput {
            crate::output::StartCrawlerScheduleOutput {}
        }
    }
}
impl StartCrawlerScheduleOutput {
    /// Creates a new builder-style object to manufacture [`StartCrawlerScheduleOutput`](crate::output::StartCrawlerScheduleOutput)
    pub fn builder() -> crate::output::start_crawler_schedule_output::Builder {
        crate::output::start_crawler_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartCrawlerOutput {}
impl std::fmt::Debug for StartCrawlerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartCrawlerOutput");
        formatter.finish()
    }
}
/// See [`StartCrawlerOutput`](crate::output::StartCrawlerOutput)
pub mod start_crawler_output {
    /// A builder for [`StartCrawlerOutput`](crate::output::StartCrawlerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartCrawlerOutput`](crate::output::StartCrawlerOutput)
        pub fn build(self) -> crate::output::StartCrawlerOutput {
            crate::output::StartCrawlerOutput {}
        }
    }
}
impl StartCrawlerOutput {
    /// Creates a new builder-style object to manufacture [`StartCrawlerOutput`](crate::output::StartCrawlerOutput)
    pub fn builder() -> crate::output::start_crawler_output::Builder {
        crate::output::start_crawler_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBlueprintRunOutput {
    /// <p>The run ID for this blueprint run.</p>
    pub run_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartBlueprintRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartBlueprintRunOutput");
        formatter.field("run_id", &self.run_id);
        formatter.finish()
    }
}
/// See [`StartBlueprintRunOutput`](crate::output::StartBlueprintRunOutput)
pub mod start_blueprint_run_output {
    /// A builder for [`StartBlueprintRunOutput`](crate::output::StartBlueprintRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The run ID for this blueprint run.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The run ID for this blueprint run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBlueprintRunOutput`](crate::output::StartBlueprintRunOutput)
        pub fn build(self) -> crate::output::StartBlueprintRunOutput {
            crate::output::StartBlueprintRunOutput {
                run_id: self.run_id,
            }
        }
    }
}
impl StartBlueprintRunOutput {
    /// Creates a new builder-style object to manufacture [`StartBlueprintRunOutput`](crate::output::StartBlueprintRunOutput)
    pub fn builder() -> crate::output::start_blueprint_run_output::Builder {
        crate::output::start_blueprint_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchTablesOutput {
    /// <p>A continuation token, present if the current list segment is not the last.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns only the tables that you have access to.</p>
    pub table_list: std::option::Option<std::vec::Vec<crate::model::Table>>,
}
impl std::fmt::Debug for SearchTablesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchTablesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("table_list", &self.table_list);
        formatter.finish()
    }
}
/// See [`SearchTablesOutput`](crate::output::SearchTablesOutput)
pub mod search_tables_output {
    /// A builder for [`SearchTablesOutput`](crate::output::SearchTablesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) table_list: std::option::Option<std::vec::Vec<crate::model::Table>>,
    }
    impl Builder {
        /// <p>A continuation token, present if the current list segment is not the last.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, present if the current list segment is not the last.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `table_list`.
        ///
        /// To override the contents of this collection use [`set_table_list`](Self::set_table_list).
        ///
        /// <p>A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns only the tables that you have access to.</p>
        pub fn table_list(mut self, input: impl Into<crate::model::Table>) -> Self {
            let mut v = self.table_list.unwrap_or_default();
            v.push(input.into());
            self.table_list = Some(v);
            self
        }
        /// <p>A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns only the tables that you have access to.</p>
        pub fn set_table_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Table>>,
        ) -> Self {
            self.table_list = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchTablesOutput`](crate::output::SearchTablesOutput)
        pub fn build(self) -> crate::output::SearchTablesOutput {
            crate::output::SearchTablesOutput {
                next_token: self.next_token,
                table_list: self.table_list,
            }
        }
    }
}
impl SearchTablesOutput {
    /// Creates a new builder-style object to manufacture [`SearchTablesOutput`](crate::output::SearchTablesOutput)
    pub fn builder() -> crate::output::search_tables_output::Builder {
        crate::output::search_tables_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResumeWorkflowRunOutput {
    /// <p>The new ID assigned to the resumed workflow run. Each resume of a workflow run will have a new run ID.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>A list of the node IDs for the nodes that were actually restarted.</p>
    pub node_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ResumeWorkflowRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResumeWorkflowRunOutput");
        formatter.field("run_id", &self.run_id);
        formatter.field("node_ids", &self.node_ids);
        formatter.finish()
    }
}
/// See [`ResumeWorkflowRunOutput`](crate::output::ResumeWorkflowRunOutput)
pub mod resume_workflow_run_output {
    /// A builder for [`ResumeWorkflowRunOutput`](crate::output::ResumeWorkflowRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) node_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The new ID assigned to the resumed workflow run. Each resume of a workflow run will have a new run ID.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The new ID assigned to the resumed workflow run. Each resume of a workflow run will have a new run ID.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Appends an item to `node_ids`.
        ///
        /// To override the contents of this collection use [`set_node_ids`](Self::set_node_ids).
        ///
        /// <p>A list of the node IDs for the nodes that were actually restarted.</p>
        pub fn node_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.node_ids.unwrap_or_default();
            v.push(input.into());
            self.node_ids = Some(v);
            self
        }
        /// <p>A list of the node IDs for the nodes that were actually restarted.</p>
        pub fn set_node_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.node_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ResumeWorkflowRunOutput`](crate::output::ResumeWorkflowRunOutput)
        pub fn build(self) -> crate::output::ResumeWorkflowRunOutput {
            crate::output::ResumeWorkflowRunOutput {
                run_id: self.run_id,
                node_ids: self.node_ids,
            }
        }
    }
}
impl ResumeWorkflowRunOutput {
    /// Creates a new builder-style object to manufacture [`ResumeWorkflowRunOutput`](crate::output::ResumeWorkflowRunOutput)
    pub fn builder() -> crate::output::resume_workflow_run_output::Builder {
        crate::output::resume_workflow_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetJobBookmarkOutput {
    /// <p>The reset bookmark entry.</p>
    pub job_bookmark_entry: std::option::Option<crate::model::JobBookmarkEntry>,
}
impl std::fmt::Debug for ResetJobBookmarkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetJobBookmarkOutput");
        formatter.field("job_bookmark_entry", &self.job_bookmark_entry);
        formatter.finish()
    }
}
/// See [`ResetJobBookmarkOutput`](crate::output::ResetJobBookmarkOutput)
pub mod reset_job_bookmark_output {
    /// A builder for [`ResetJobBookmarkOutput`](crate::output::ResetJobBookmarkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_bookmark_entry: std::option::Option<crate::model::JobBookmarkEntry>,
    }
    impl Builder {
        /// <p>The reset bookmark entry.</p>
        pub fn job_bookmark_entry(mut self, input: crate::model::JobBookmarkEntry) -> Self {
            self.job_bookmark_entry = Some(input);
            self
        }
        /// <p>The reset bookmark entry.</p>
        pub fn set_job_bookmark_entry(
            mut self,
            input: std::option::Option<crate::model::JobBookmarkEntry>,
        ) -> Self {
            self.job_bookmark_entry = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetJobBookmarkOutput`](crate::output::ResetJobBookmarkOutput)
        pub fn build(self) -> crate::output::ResetJobBookmarkOutput {
            crate::output::ResetJobBookmarkOutput {
                job_bookmark_entry: self.job_bookmark_entry,
            }
        }
    }
}
impl ResetJobBookmarkOutput {
    /// Creates a new builder-style object to manufacture [`ResetJobBookmarkOutput`](crate::output::ResetJobBookmarkOutput)
    pub fn builder() -> crate::output::reset_job_bookmark_output::Builder {
        crate::output::reset_job_bookmark_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveSchemaVersionMetadataOutput {
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The latest version of the schema.</p>
    pub latest_version: bool,
    /// <p>The version number of the schema.</p>
    pub version_number: i64,
    /// <p>The version ID for the schema version.</p>
    pub schema_version_id: std::option::Option<std::string::String>,
    /// <p>The metadata key.</p>
    pub metadata_key: std::option::Option<std::string::String>,
    /// <p>The value of the metadata key.</p>
    pub metadata_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveSchemaVersionMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveSchemaVersionMetadataOutput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("latest_version", &self.latest_version);
        formatter.field("version_number", &self.version_number);
        formatter.field("schema_version_id", &self.schema_version_id);
        formatter.field("metadata_key", &self.metadata_key);
        formatter.field("metadata_value", &self.metadata_value);
        formatter.finish()
    }
}
/// See [`RemoveSchemaVersionMetadataOutput`](crate::output::RemoveSchemaVersionMetadataOutput)
pub mod remove_schema_version_metadata_output {
    /// A builder for [`RemoveSchemaVersionMetadataOutput`](crate::output::RemoveSchemaVersionMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) latest_version: std::option::Option<bool>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) schema_version_id: std::option::Option<std::string::String>,
        pub(crate) metadata_key: std::option::Option<std::string::String>,
        pub(crate) metadata_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The latest version of the schema.</p>
        pub fn latest_version(mut self, input: bool) -> Self {
            self.latest_version = Some(input);
            self
        }
        /// <p>The latest version of the schema.</p>
        pub fn set_latest_version(mut self, input: std::option::Option<bool>) -> Self {
            self.latest_version = input;
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The version ID for the schema version.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version_id = Some(input.into());
            self
        }
        /// <p>The version ID for the schema version.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version_id = input;
            self
        }
        /// <p>The metadata key.</p>
        pub fn metadata_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata_key = Some(input.into());
            self
        }
        /// <p>The metadata key.</p>
        pub fn set_metadata_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata_key = input;
            self
        }
        /// <p>The value of the metadata key.</p>
        pub fn metadata_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata_value = Some(input.into());
            self
        }
        /// <p>The value of the metadata key.</p>
        pub fn set_metadata_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metadata_value = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveSchemaVersionMetadataOutput`](crate::output::RemoveSchemaVersionMetadataOutput)
        pub fn build(self) -> crate::output::RemoveSchemaVersionMetadataOutput {
            crate::output::RemoveSchemaVersionMetadataOutput {
                schema_arn: self.schema_arn,
                schema_name: self.schema_name,
                registry_name: self.registry_name,
                latest_version: self.latest_version.unwrap_or_default(),
                version_number: self.version_number.unwrap_or_default(),
                schema_version_id: self.schema_version_id,
                metadata_key: self.metadata_key,
                metadata_value: self.metadata_value,
            }
        }
    }
}
impl RemoveSchemaVersionMetadataOutput {
    /// Creates a new builder-style object to manufacture [`RemoveSchemaVersionMetadataOutput`](crate::output::RemoveSchemaVersionMetadataOutput)
    pub fn builder() -> crate::output::remove_schema_version_metadata_output::Builder {
        crate::output::remove_schema_version_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterSchemaVersionOutput {
    /// <p>The unique ID that represents the version of this schema.</p>
    pub schema_version_id: std::option::Option<std::string::String>,
    /// <p>The version of this schema (for sync flow only, in case this is the first version).</p>
    pub version_number: i64,
    /// <p>The status of the schema version.</p>
    pub status: std::option::Option<crate::model::SchemaVersionStatus>,
}
impl std::fmt::Debug for RegisterSchemaVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterSchemaVersionOutput");
        formatter.field("schema_version_id", &self.schema_version_id);
        formatter.field("version_number", &self.version_number);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RegisterSchemaVersionOutput`](crate::output::RegisterSchemaVersionOutput)
pub mod register_schema_version_output {
    /// A builder for [`RegisterSchemaVersionOutput`](crate::output::RegisterSchemaVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_version_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::SchemaVersionStatus>,
    }
    impl Builder {
        /// <p>The unique ID that represents the version of this schema.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version_id = Some(input.into());
            self
        }
        /// <p>The unique ID that represents the version of this schema.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version_id = input;
            self
        }
        /// <p>The version of this schema (for sync flow only, in case this is the first version).</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version of this schema (for sync flow only, in case this is the first version).</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The status of the schema version.</p>
        pub fn status(mut self, input: crate::model::SchemaVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the schema version.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterSchemaVersionOutput`](crate::output::RegisterSchemaVersionOutput)
        pub fn build(self) -> crate::output::RegisterSchemaVersionOutput {
            crate::output::RegisterSchemaVersionOutput {
                schema_version_id: self.schema_version_id,
                version_number: self.version_number.unwrap_or_default(),
                status: self.status,
            }
        }
    }
}
impl RegisterSchemaVersionOutput {
    /// Creates a new builder-style object to manufacture [`RegisterSchemaVersionOutput`](crate::output::RegisterSchemaVersionOutput)
    pub fn builder() -> crate::output::register_schema_version_output::Builder {
        crate::output::register_schema_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QuerySchemaVersionMetadataOutput {
    /// <p>A map of a metadata key and associated values.</p>
    pub metadata_info_map: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MetadataInfo>,
    >,
    /// <p>The unique version ID of the schema version.</p>
    pub schema_version_id: std::option::Option<std::string::String>,
    /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QuerySchemaVersionMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QuerySchemaVersionMetadataOutput");
        formatter.field("metadata_info_map", &self.metadata_info_map);
        formatter.field("schema_version_id", &self.schema_version_id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`QuerySchemaVersionMetadataOutput`](crate::output::QuerySchemaVersionMetadataOutput)
pub mod query_schema_version_metadata_output {
    /// A builder for [`QuerySchemaVersionMetadataOutput`](crate::output::QuerySchemaVersionMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata_info_map: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MetadataInfo>,
        >,
        pub(crate) schema_version_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `metadata_info_map`.
        ///
        /// To override the contents of this collection use [`set_metadata_info_map`](Self::set_metadata_info_map).
        ///
        /// <p>A map of a metadata key and associated values.</p>
        pub fn metadata_info_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::MetadataInfo>,
        ) -> Self {
            let mut hash_map = self.metadata_info_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata_info_map = Some(hash_map);
            self
        }
        /// <p>A map of a metadata key and associated values.</p>
        pub fn set_metadata_info_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MetadataInfo>,
            >,
        ) -> Self {
            self.metadata_info_map = input;
            self
        }
        /// <p>The unique version ID of the schema version.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version_id = Some(input.into());
            self
        }
        /// <p>The unique version ID of the schema version.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version_id = input;
            self
        }
        /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`QuerySchemaVersionMetadataOutput`](crate::output::QuerySchemaVersionMetadataOutput)
        pub fn build(self) -> crate::output::QuerySchemaVersionMetadataOutput {
            crate::output::QuerySchemaVersionMetadataOutput {
                metadata_info_map: self.metadata_info_map,
                schema_version_id: self.schema_version_id,
                next_token: self.next_token,
            }
        }
    }
}
impl QuerySchemaVersionMetadataOutput {
    /// Creates a new builder-style object to manufacture [`QuerySchemaVersionMetadataOutput`](crate::output::QuerySchemaVersionMetadataOutput)
    pub fn builder() -> crate::output::query_schema_version_metadata_output::Builder {
        crate::output::query_schema_version_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutWorkflowRunPropertiesOutput {}
impl std::fmt::Debug for PutWorkflowRunPropertiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutWorkflowRunPropertiesOutput");
        formatter.finish()
    }
}
/// See [`PutWorkflowRunPropertiesOutput`](crate::output::PutWorkflowRunPropertiesOutput)
pub mod put_workflow_run_properties_output {
    /// A builder for [`PutWorkflowRunPropertiesOutput`](crate::output::PutWorkflowRunPropertiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutWorkflowRunPropertiesOutput`](crate::output::PutWorkflowRunPropertiesOutput)
        pub fn build(self) -> crate::output::PutWorkflowRunPropertiesOutput {
            crate::output::PutWorkflowRunPropertiesOutput {}
        }
    }
}
impl PutWorkflowRunPropertiesOutput {
    /// Creates a new builder-style object to manufacture [`PutWorkflowRunPropertiesOutput`](crate::output::PutWorkflowRunPropertiesOutput)
    pub fn builder() -> crate::output::put_workflow_run_properties_output::Builder {
        crate::output::put_workflow_run_properties_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSchemaVersionMetadataOutput {
    /// <p>The Amazon Resource Name (ARN) for the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name for the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The name for the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The latest version of the schema.</p>
    pub latest_version: bool,
    /// <p>The version number of the schema.</p>
    pub version_number: i64,
    /// <p>The unique version ID of the schema version.</p>
    pub schema_version_id: std::option::Option<std::string::String>,
    /// <p>The metadata key.</p>
    pub metadata_key: std::option::Option<std::string::String>,
    /// <p>The value of the metadata key.</p>
    pub metadata_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutSchemaVersionMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSchemaVersionMetadataOutput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("latest_version", &self.latest_version);
        formatter.field("version_number", &self.version_number);
        formatter.field("schema_version_id", &self.schema_version_id);
        formatter.field("metadata_key", &self.metadata_key);
        formatter.field("metadata_value", &self.metadata_value);
        formatter.finish()
    }
}
/// See [`PutSchemaVersionMetadataOutput`](crate::output::PutSchemaVersionMetadataOutput)
pub mod put_schema_version_metadata_output {
    /// A builder for [`PutSchemaVersionMetadataOutput`](crate::output::PutSchemaVersionMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) latest_version: std::option::Option<bool>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) schema_version_id: std::option::Option<std::string::String>,
        pub(crate) metadata_key: std::option::Option<std::string::String>,
        pub(crate) metadata_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name for the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name for the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The name for the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name for the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The latest version of the schema.</p>
        pub fn latest_version(mut self, input: bool) -> Self {
            self.latest_version = Some(input);
            self
        }
        /// <p>The latest version of the schema.</p>
        pub fn set_latest_version(mut self, input: std::option::Option<bool>) -> Self {
            self.latest_version = input;
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The unique version ID of the schema version.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version_id = Some(input.into());
            self
        }
        /// <p>The unique version ID of the schema version.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version_id = input;
            self
        }
        /// <p>The metadata key.</p>
        pub fn metadata_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata_key = Some(input.into());
            self
        }
        /// <p>The metadata key.</p>
        pub fn set_metadata_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata_key = input;
            self
        }
        /// <p>The value of the metadata key.</p>
        pub fn metadata_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata_value = Some(input.into());
            self
        }
        /// <p>The value of the metadata key.</p>
        pub fn set_metadata_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metadata_value = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSchemaVersionMetadataOutput`](crate::output::PutSchemaVersionMetadataOutput)
        pub fn build(self) -> crate::output::PutSchemaVersionMetadataOutput {
            crate::output::PutSchemaVersionMetadataOutput {
                schema_arn: self.schema_arn,
                schema_name: self.schema_name,
                registry_name: self.registry_name,
                latest_version: self.latest_version.unwrap_or_default(),
                version_number: self.version_number.unwrap_or_default(),
                schema_version_id: self.schema_version_id,
                metadata_key: self.metadata_key,
                metadata_value: self.metadata_value,
            }
        }
    }
}
impl PutSchemaVersionMetadataOutput {
    /// Creates a new builder-style object to manufacture [`PutSchemaVersionMetadataOutput`](crate::output::PutSchemaVersionMetadataOutput)
    pub fn builder() -> crate::output::put_schema_version_metadata_output::Builder {
        crate::output::put_schema_version_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourcePolicyOutput {
    /// <p>A hash of the policy that has just been set. This must
    /// be included in a subsequent call that overwrites or updates
    /// this policy.</p>
    pub policy_hash: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourcePolicyOutput");
        formatter.field("policy_hash", &self.policy_hash);
        formatter.finish()
    }
}
/// See [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
pub mod put_resource_policy_output {
    /// A builder for [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_hash: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A hash of the policy that has just been set. This must
        /// be included in a subsequent call that overwrites or updates
        /// this policy.</p>
        pub fn policy_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_hash = Some(input.into());
            self
        }
        /// <p>A hash of the policy that has just been set. This must
        /// be included in a subsequent call that overwrites or updates
        /// this policy.</p>
        pub fn set_policy_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_hash = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
        pub fn build(self) -> crate::output::PutResourcePolicyOutput {
            crate::output::PutResourcePolicyOutput {
                policy_hash: self.policy_hash,
            }
        }
    }
}
impl PutResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    pub fn builder() -> crate::output::put_resource_policy_output::Builder {
        crate::output::put_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDataCatalogEncryptionSettingsOutput {}
impl std::fmt::Debug for PutDataCatalogEncryptionSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDataCatalogEncryptionSettingsOutput");
        formatter.finish()
    }
}
/// See [`PutDataCatalogEncryptionSettingsOutput`](crate::output::PutDataCatalogEncryptionSettingsOutput)
pub mod put_data_catalog_encryption_settings_output {
    /// A builder for [`PutDataCatalogEncryptionSettingsOutput`](crate::output::PutDataCatalogEncryptionSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutDataCatalogEncryptionSettingsOutput`](crate::output::PutDataCatalogEncryptionSettingsOutput)
        pub fn build(self) -> crate::output::PutDataCatalogEncryptionSettingsOutput {
            crate::output::PutDataCatalogEncryptionSettingsOutput {}
        }
    }
}
impl PutDataCatalogEncryptionSettingsOutput {
    /// Creates a new builder-style object to manufacture [`PutDataCatalogEncryptionSettingsOutput`](crate::output::PutDataCatalogEncryptionSettingsOutput)
    pub fn builder() -> crate::output::put_data_catalog_encryption_settings_output::Builder {
        crate::output::put_data_catalog_encryption_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkflowsOutput {
    /// <p>List of names of workflows in the account.</p>
    pub workflows: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A continuation token, if not all workflow names have been returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListWorkflowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkflowsOutput");
        formatter.field("workflows", &self.workflows);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorkflowsOutput`](crate::output::ListWorkflowsOutput)
pub mod list_workflows_output {
    /// A builder for [`ListWorkflowsOutput`](crate::output::ListWorkflowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflows: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `workflows`.
        ///
        /// To override the contents of this collection use [`set_workflows`](Self::set_workflows).
        ///
        /// <p>List of names of workflows in the account.</p>
        pub fn workflows(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.workflows.unwrap_or_default();
            v.push(input.into());
            self.workflows = Some(v);
            self
        }
        /// <p>List of names of workflows in the account.</p>
        pub fn set_workflows(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.workflows = input;
            self
        }
        /// <p>A continuation token, if not all workflow names have been returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if not all workflow names have been returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkflowsOutput`](crate::output::ListWorkflowsOutput)
        pub fn build(self) -> crate::output::ListWorkflowsOutput {
            crate::output::ListWorkflowsOutput {
                workflows: self.workflows,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorkflowsOutput {
    /// Creates a new builder-style object to manufacture [`ListWorkflowsOutput`](crate::output::ListWorkflowsOutput)
    pub fn builder() -> crate::output::list_workflows_output::Builder {
        crate::output::list_workflows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTriggersOutput {
    /// <p>The names of all triggers in the account, or the triggers with the specified tags.</p>
    pub trigger_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A continuation token, if the returned list does not contain the
    /// last metric available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTriggersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTriggersOutput");
        formatter.field("trigger_names", &self.trigger_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTriggersOutput`](crate::output::ListTriggersOutput)
pub mod list_triggers_output {
    /// A builder for [`ListTriggersOutput`](crate::output::ListTriggersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trigger_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `trigger_names`.
        ///
        /// To override the contents of this collection use [`set_trigger_names`](Self::set_trigger_names).
        ///
        /// <p>The names of all triggers in the account, or the triggers with the specified tags.</p>
        pub fn trigger_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.trigger_names.unwrap_or_default();
            v.push(input.into());
            self.trigger_names = Some(v);
            self
        }
        /// <p>The names of all triggers in the account, or the triggers with the specified tags.</p>
        pub fn set_trigger_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.trigger_names = input;
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTriggersOutput`](crate::output::ListTriggersOutput)
        pub fn build(self) -> crate::output::ListTriggersOutput {
            crate::output::ListTriggersOutput {
                trigger_names: self.trigger_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTriggersOutput {
    /// Creates a new builder-style object to manufacture [`ListTriggersOutput`](crate::output::ListTriggersOutput)
    pub fn builder() -> crate::output::list_triggers_output::Builder {
        crate::output::list_triggers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemaVersionsOutput {
    /// <p>An array of <code>SchemaVersionList</code> objects containing details of each schema version.</p>
    pub schemas: std::option::Option<std::vec::Vec<crate::model::SchemaVersionListItem>>,
    /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSchemaVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemaVersionsOutput");
        formatter.field("schemas", &self.schemas);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSchemaVersionsOutput`](crate::output::ListSchemaVersionsOutput)
pub mod list_schema_versions_output {
    /// A builder for [`ListSchemaVersionsOutput`](crate::output::ListSchemaVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schemas: std::option::Option<std::vec::Vec<crate::model::SchemaVersionListItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schemas`.
        ///
        /// To override the contents of this collection use [`set_schemas`](Self::set_schemas).
        ///
        /// <p>An array of <code>SchemaVersionList</code> objects containing details of each schema version.</p>
        pub fn schemas(mut self, input: impl Into<crate::model::SchemaVersionListItem>) -> Self {
            let mut v = self.schemas.unwrap_or_default();
            v.push(input.into());
            self.schemas = Some(v);
            self
        }
        /// <p>An array of <code>SchemaVersionList</code> objects containing details of each schema version.</p>
        pub fn set_schemas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaVersionListItem>>,
        ) -> Self {
            self.schemas = input;
            self
        }
        /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemaVersionsOutput`](crate::output::ListSchemaVersionsOutput)
        pub fn build(self) -> crate::output::ListSchemaVersionsOutput {
            crate::output::ListSchemaVersionsOutput {
                schemas: self.schemas,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSchemaVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListSchemaVersionsOutput`](crate::output::ListSchemaVersionsOutput)
    pub fn builder() -> crate::output::list_schema_versions_output::Builder {
        crate::output::list_schema_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemasOutput {
    /// <p>An array of <code>SchemaListItem</code> objects containing details of each schema.</p>
    pub schemas: std::option::Option<std::vec::Vec<crate::model::SchemaListItem>>,
    /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSchemasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemasOutput");
        formatter.field("schemas", &self.schemas);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSchemasOutput`](crate::output::ListSchemasOutput)
pub mod list_schemas_output {
    /// A builder for [`ListSchemasOutput`](crate::output::ListSchemasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schemas: std::option::Option<std::vec::Vec<crate::model::SchemaListItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schemas`.
        ///
        /// To override the contents of this collection use [`set_schemas`](Self::set_schemas).
        ///
        /// <p>An array of <code>SchemaListItem</code> objects containing details of each schema.</p>
        pub fn schemas(mut self, input: impl Into<crate::model::SchemaListItem>) -> Self {
            let mut v = self.schemas.unwrap_or_default();
            v.push(input.into());
            self.schemas = Some(v);
            self
        }
        /// <p>An array of <code>SchemaListItem</code> objects containing details of each schema.</p>
        pub fn set_schemas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaListItem>>,
        ) -> Self {
            self.schemas = input;
            self
        }
        /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemasOutput`](crate::output::ListSchemasOutput)
        pub fn build(self) -> crate::output::ListSchemasOutput {
            crate::output::ListSchemasOutput {
                schemas: self.schemas,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSchemasOutput {
    /// Creates a new builder-style object to manufacture [`ListSchemasOutput`](crate::output::ListSchemasOutput)
    pub fn builder() -> crate::output::list_schemas_output::Builder {
        crate::output::list_schemas_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRegistriesOutput {
    /// <p>An array of <code>RegistryDetailedListItem</code> objects containing minimal details of each registry.</p>
    pub registries: std::option::Option<std::vec::Vec<crate::model::RegistryListItem>>,
    /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListRegistriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRegistriesOutput");
        formatter.field("registries", &self.registries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRegistriesOutput`](crate::output::ListRegistriesOutput)
pub mod list_registries_output {
    /// A builder for [`ListRegistriesOutput`](crate::output::ListRegistriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registries: std::option::Option<std::vec::Vec<crate::model::RegistryListItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `registries`.
        ///
        /// To override the contents of this collection use [`set_registries`](Self::set_registries).
        ///
        /// <p>An array of <code>RegistryDetailedListItem</code> objects containing minimal details of each registry.</p>
        pub fn registries(mut self, input: impl Into<crate::model::RegistryListItem>) -> Self {
            let mut v = self.registries.unwrap_or_default();
            v.push(input.into());
            self.registries = Some(v);
            self
        }
        /// <p>An array of <code>RegistryDetailedListItem</code> objects containing minimal details of each registry.</p>
        pub fn set_registries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegistryListItem>>,
        ) -> Self {
            self.registries = input;
            self
        }
        /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRegistriesOutput`](crate::output::ListRegistriesOutput)
        pub fn build(self) -> crate::output::ListRegistriesOutput {
            crate::output::ListRegistriesOutput {
                registries: self.registries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRegistriesOutput {
    /// Creates a new builder-style object to manufacture [`ListRegistriesOutput`](crate::output::ListRegistriesOutput)
    pub fn builder() -> crate::output::list_registries_output::Builder {
        crate::output::list_registries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMlTransformsOutput {
    /// <p>The identifiers of all the machine learning transforms in the account, or the
    /// machine learning transforms with the specified tags.</p>
    pub transform_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A continuation token, if the returned list does not contain the
    /// last metric available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListMlTransformsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMlTransformsOutput");
        formatter.field("transform_ids", &self.transform_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMlTransformsOutput`](crate::output::ListMlTransformsOutput)
pub mod list_ml_transforms_output {
    /// A builder for [`ListMlTransformsOutput`](crate::output::ListMlTransformsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `transform_ids`.
        ///
        /// To override the contents of this collection use [`set_transform_ids`](Self::set_transform_ids).
        ///
        /// <p>The identifiers of all the machine learning transforms in the account, or the
        /// machine learning transforms with the specified tags.</p>
        pub fn transform_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.transform_ids.unwrap_or_default();
            v.push(input.into());
            self.transform_ids = Some(v);
            self
        }
        /// <p>The identifiers of all the machine learning transforms in the account, or the
        /// machine learning transforms with the specified tags.</p>
        pub fn set_transform_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.transform_ids = input;
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMlTransformsOutput`](crate::output::ListMlTransformsOutput)
        pub fn build(self) -> crate::output::ListMlTransformsOutput {
            crate::output::ListMlTransformsOutput {
                transform_ids: self.transform_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMlTransformsOutput {
    /// Creates a new builder-style object to manufacture [`ListMlTransformsOutput`](crate::output::ListMlTransformsOutput)
    pub fn builder() -> crate::output::list_ml_transforms_output::Builder {
        crate::output::list_ml_transforms_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsOutput {
    /// <p>The names of all jobs in the account, or the jobs with the specified tags.</p>
    pub job_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A continuation token, if the returned list does not contain the
    /// last metric available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsOutput");
        formatter.field("job_names", &self.job_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobsOutput`](crate::output::ListJobsOutput)
pub mod list_jobs_output {
    /// A builder for [`ListJobsOutput`](crate::output::ListJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_names`.
        ///
        /// To override the contents of this collection use [`set_job_names`](Self::set_job_names).
        ///
        /// <p>The names of all jobs in the account, or the jobs with the specified tags.</p>
        pub fn job_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.job_names.unwrap_or_default();
            v.push(input.into());
            self.job_names = Some(v);
            self
        }
        /// <p>The names of all jobs in the account, or the jobs with the specified tags.</p>
        pub fn set_job_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.job_names = input;
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsOutput`](crate::output::ListJobsOutput)
        pub fn build(self) -> crate::output::ListJobsOutput {
            crate::output::ListJobsOutput {
                job_names: self.job_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsOutput`](crate::output::ListJobsOutput)
    pub fn builder() -> crate::output::list_jobs_output::Builder {
        crate::output::list_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevEndpointsOutput {
    /// <p>The names of all the <code>DevEndpoint</code>s in the account, or the
    /// <code>DevEndpoint</code>s with the specified tags.</p>
    pub dev_endpoint_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A continuation token, if the returned list does not contain the
    /// last metric available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDevEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevEndpointsOutput");
        formatter.field("dev_endpoint_names", &self.dev_endpoint_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDevEndpointsOutput`](crate::output::ListDevEndpointsOutput)
pub mod list_dev_endpoints_output {
    /// A builder for [`ListDevEndpointsOutput`](crate::output::ListDevEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dev_endpoint_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dev_endpoint_names`.
        ///
        /// To override the contents of this collection use [`set_dev_endpoint_names`](Self::set_dev_endpoint_names).
        ///
        /// <p>The names of all the <code>DevEndpoint</code>s in the account, or the
        /// <code>DevEndpoint</code>s with the specified tags.</p>
        pub fn dev_endpoint_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dev_endpoint_names.unwrap_or_default();
            v.push(input.into());
            self.dev_endpoint_names = Some(v);
            self
        }
        /// <p>The names of all the <code>DevEndpoint</code>s in the account, or the
        /// <code>DevEndpoint</code>s with the specified tags.</p>
        pub fn set_dev_endpoint_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dev_endpoint_names = input;
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevEndpointsOutput`](crate::output::ListDevEndpointsOutput)
        pub fn build(self) -> crate::output::ListDevEndpointsOutput {
            crate::output::ListDevEndpointsOutput {
                dev_endpoint_names: self.dev_endpoint_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDevEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`ListDevEndpointsOutput`](crate::output::ListDevEndpointsOutput)
    pub fn builder() -> crate::output::list_dev_endpoints_output::Builder {
        crate::output::list_dev_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCrawlersOutput {
    /// <p>The names of all crawlers in the account, or the crawlers with the specified tags.</p>
    pub crawler_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A continuation token, if the returned list does not contain the
    /// last metric available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListCrawlersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCrawlersOutput");
        formatter.field("crawler_names", &self.crawler_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCrawlersOutput`](crate::output::ListCrawlersOutput)
pub mod list_crawlers_output {
    /// A builder for [`ListCrawlersOutput`](crate::output::ListCrawlersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawler_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `crawler_names`.
        ///
        /// To override the contents of this collection use [`set_crawler_names`](Self::set_crawler_names).
        ///
        /// <p>The names of all crawlers in the account, or the crawlers with the specified tags.</p>
        pub fn crawler_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.crawler_names.unwrap_or_default();
            v.push(input.into());
            self.crawler_names = Some(v);
            self
        }
        /// <p>The names of all crawlers in the account, or the crawlers with the specified tags.</p>
        pub fn set_crawler_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.crawler_names = input;
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCrawlersOutput`](crate::output::ListCrawlersOutput)
        pub fn build(self) -> crate::output::ListCrawlersOutput {
            crate::output::ListCrawlersOutput {
                crawler_names: self.crawler_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCrawlersOutput {
    /// Creates a new builder-style object to manufacture [`ListCrawlersOutput`](crate::output::ListCrawlersOutput)
    pub fn builder() -> crate::output::list_crawlers_output::Builder {
        crate::output::list_crawlers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBlueprintsOutput {
    /// <p>List of names of blueprints in the account.</p>
    pub blueprints: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A continuation token, if not all blueprint names have been returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListBlueprintsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBlueprintsOutput");
        formatter.field("blueprints", &self.blueprints);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBlueprintsOutput`](crate::output::ListBlueprintsOutput)
pub mod list_blueprints_output {
    /// A builder for [`ListBlueprintsOutput`](crate::output::ListBlueprintsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blueprints: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `blueprints`.
        ///
        /// To override the contents of this collection use [`set_blueprints`](Self::set_blueprints).
        ///
        /// <p>List of names of blueprints in the account.</p>
        pub fn blueprints(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.blueprints.unwrap_or_default();
            v.push(input.into());
            self.blueprints = Some(v);
            self
        }
        /// <p>List of names of blueprints in the account.</p>
        pub fn set_blueprints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.blueprints = input;
            self
        }
        /// <p>A continuation token, if not all blueprint names have been returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if not all blueprint names have been returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBlueprintsOutput`](crate::output::ListBlueprintsOutput)
        pub fn build(self) -> crate::output::ListBlueprintsOutput {
            crate::output::ListBlueprintsOutput {
                blueprints: self.blueprints,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBlueprintsOutput {
    /// Creates a new builder-style object to manufacture [`ListBlueprintsOutput`](crate::output::ListBlueprintsOutput)
    pub fn builder() -> crate::output::list_blueprints_output::Builder {
        crate::output::list_blueprints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportCatalogToGlueOutput {}
impl std::fmt::Debug for ImportCatalogToGlueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportCatalogToGlueOutput");
        formatter.finish()
    }
}
/// See [`ImportCatalogToGlueOutput`](crate::output::ImportCatalogToGlueOutput)
pub mod import_catalog_to_glue_output {
    /// A builder for [`ImportCatalogToGlueOutput`](crate::output::ImportCatalogToGlueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ImportCatalogToGlueOutput`](crate::output::ImportCatalogToGlueOutput)
        pub fn build(self) -> crate::output::ImportCatalogToGlueOutput {
            crate::output::ImportCatalogToGlueOutput {}
        }
    }
}
impl ImportCatalogToGlueOutput {
    /// Creates a new builder-style object to manufacture [`ImportCatalogToGlueOutput`](crate::output::ImportCatalogToGlueOutput)
    pub fn builder() -> crate::output::import_catalog_to_glue_output::Builder {
        crate::output::import_catalog_to_glue_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkflowRunsOutput {
    /// <p>A list of workflow run metadata objects.</p>
    pub runs: std::option::Option<std::vec::Vec<crate::model::WorkflowRun>>,
    /// <p>A continuation token, if not all requested workflow runs have been returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetWorkflowRunsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkflowRunsOutput");
        formatter.field("runs", &self.runs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetWorkflowRunsOutput`](crate::output::GetWorkflowRunsOutput)
pub mod get_workflow_runs_output {
    /// A builder for [`GetWorkflowRunsOutput`](crate::output::GetWorkflowRunsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) runs: std::option::Option<std::vec::Vec<crate::model::WorkflowRun>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `runs`.
        ///
        /// To override the contents of this collection use [`set_runs`](Self::set_runs).
        ///
        /// <p>A list of workflow run metadata objects.</p>
        pub fn runs(mut self, input: impl Into<crate::model::WorkflowRun>) -> Self {
            let mut v = self.runs.unwrap_or_default();
            v.push(input.into());
            self.runs = Some(v);
            self
        }
        /// <p>A list of workflow run metadata objects.</p>
        pub fn set_runs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorkflowRun>>,
        ) -> Self {
            self.runs = input;
            self
        }
        /// <p>A continuation token, if not all requested workflow runs have been returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if not all requested workflow runs have been returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkflowRunsOutput`](crate::output::GetWorkflowRunsOutput)
        pub fn build(self) -> crate::output::GetWorkflowRunsOutput {
            crate::output::GetWorkflowRunsOutput {
                runs: self.runs,
                next_token: self.next_token,
            }
        }
    }
}
impl GetWorkflowRunsOutput {
    /// Creates a new builder-style object to manufacture [`GetWorkflowRunsOutput`](crate::output::GetWorkflowRunsOutput)
    pub fn builder() -> crate::output::get_workflow_runs_output::Builder {
        crate::output::get_workflow_runs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkflowRunPropertiesOutput {
    /// <p>The workflow run properties which were set during the specified run.</p>
    pub run_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetWorkflowRunPropertiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkflowRunPropertiesOutput");
        formatter.field("run_properties", &self.run_properties);
        formatter.finish()
    }
}
/// See [`GetWorkflowRunPropertiesOutput`](crate::output::GetWorkflowRunPropertiesOutput)
pub mod get_workflow_run_properties_output {
    /// A builder for [`GetWorkflowRunPropertiesOutput`](crate::output::GetWorkflowRunPropertiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `run_properties`.
        ///
        /// To override the contents of this collection use [`set_run_properties`](Self::set_run_properties).
        ///
        /// <p>The workflow run properties which were set during the specified run.</p>
        pub fn run_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.run_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.run_properties = Some(hash_map);
            self
        }
        /// <p>The workflow run properties which were set during the specified run.</p>
        pub fn set_run_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.run_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkflowRunPropertiesOutput`](crate::output::GetWorkflowRunPropertiesOutput)
        pub fn build(self) -> crate::output::GetWorkflowRunPropertiesOutput {
            crate::output::GetWorkflowRunPropertiesOutput {
                run_properties: self.run_properties,
            }
        }
    }
}
impl GetWorkflowRunPropertiesOutput {
    /// Creates a new builder-style object to manufacture [`GetWorkflowRunPropertiesOutput`](crate::output::GetWorkflowRunPropertiesOutput)
    pub fn builder() -> crate::output::get_workflow_run_properties_output::Builder {
        crate::output::get_workflow_run_properties_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkflowRunOutput {
    /// <p>The requested workflow run metadata.</p>
    pub run: std::option::Option<crate::model::WorkflowRun>,
}
impl std::fmt::Debug for GetWorkflowRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkflowRunOutput");
        formatter.field("run", &self.run);
        formatter.finish()
    }
}
/// See [`GetWorkflowRunOutput`](crate::output::GetWorkflowRunOutput)
pub mod get_workflow_run_output {
    /// A builder for [`GetWorkflowRunOutput`](crate::output::GetWorkflowRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run: std::option::Option<crate::model::WorkflowRun>,
    }
    impl Builder {
        /// <p>The requested workflow run metadata.</p>
        pub fn run(mut self, input: crate::model::WorkflowRun) -> Self {
            self.run = Some(input);
            self
        }
        /// <p>The requested workflow run metadata.</p>
        pub fn set_run(mut self, input: std::option::Option<crate::model::WorkflowRun>) -> Self {
            self.run = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkflowRunOutput`](crate::output::GetWorkflowRunOutput)
        pub fn build(self) -> crate::output::GetWorkflowRunOutput {
            crate::output::GetWorkflowRunOutput { run: self.run }
        }
    }
}
impl GetWorkflowRunOutput {
    /// Creates a new builder-style object to manufacture [`GetWorkflowRunOutput`](crate::output::GetWorkflowRunOutput)
    pub fn builder() -> crate::output::get_workflow_run_output::Builder {
        crate::output::get_workflow_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkflowOutput {
    /// <p>The resource metadata for the workflow.</p>
    pub workflow: std::option::Option<crate::model::Workflow>,
}
impl std::fmt::Debug for GetWorkflowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkflowOutput");
        formatter.field("workflow", &self.workflow);
        formatter.finish()
    }
}
/// See [`GetWorkflowOutput`](crate::output::GetWorkflowOutput)
pub mod get_workflow_output {
    /// A builder for [`GetWorkflowOutput`](crate::output::GetWorkflowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflow: std::option::Option<crate::model::Workflow>,
    }
    impl Builder {
        /// <p>The resource metadata for the workflow.</p>
        pub fn workflow(mut self, input: crate::model::Workflow) -> Self {
            self.workflow = Some(input);
            self
        }
        /// <p>The resource metadata for the workflow.</p>
        pub fn set_workflow(mut self, input: std::option::Option<crate::model::Workflow>) -> Self {
            self.workflow = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkflowOutput`](crate::output::GetWorkflowOutput)
        pub fn build(self) -> crate::output::GetWorkflowOutput {
            crate::output::GetWorkflowOutput {
                workflow: self.workflow,
            }
        }
    }
}
impl GetWorkflowOutput {
    /// Creates a new builder-style object to manufacture [`GetWorkflowOutput`](crate::output::GetWorkflowOutput)
    pub fn builder() -> crate::output::get_workflow_output::Builder {
        crate::output::get_workflow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUserDefinedFunctionsOutput {
    /// <p>A list of requested function definitions.</p>
    pub user_defined_functions:
        std::option::Option<std::vec::Vec<crate::model::UserDefinedFunction>>,
    /// <p>A continuation token, if the list of functions returned does
    /// not include the last requested function.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetUserDefinedFunctionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUserDefinedFunctionsOutput");
        formatter.field("user_defined_functions", &self.user_defined_functions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetUserDefinedFunctionsOutput`](crate::output::GetUserDefinedFunctionsOutput)
pub mod get_user_defined_functions_output {
    /// A builder for [`GetUserDefinedFunctionsOutput`](crate::output::GetUserDefinedFunctionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_defined_functions:
            std::option::Option<std::vec::Vec<crate::model::UserDefinedFunction>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_defined_functions`.
        ///
        /// To override the contents of this collection use [`set_user_defined_functions`](Self::set_user_defined_functions).
        ///
        /// <p>A list of requested function definitions.</p>
        pub fn user_defined_functions(
            mut self,
            input: impl Into<crate::model::UserDefinedFunction>,
        ) -> Self {
            let mut v = self.user_defined_functions.unwrap_or_default();
            v.push(input.into());
            self.user_defined_functions = Some(v);
            self
        }
        /// <p>A list of requested function definitions.</p>
        pub fn set_user_defined_functions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserDefinedFunction>>,
        ) -> Self {
            self.user_defined_functions = input;
            self
        }
        /// <p>A continuation token, if the list of functions returned does
        /// not include the last requested function.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the list of functions returned does
        /// not include the last requested function.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserDefinedFunctionsOutput`](crate::output::GetUserDefinedFunctionsOutput)
        pub fn build(self) -> crate::output::GetUserDefinedFunctionsOutput {
            crate::output::GetUserDefinedFunctionsOutput {
                user_defined_functions: self.user_defined_functions,
                next_token: self.next_token,
            }
        }
    }
}
impl GetUserDefinedFunctionsOutput {
    /// Creates a new builder-style object to manufacture [`GetUserDefinedFunctionsOutput`](crate::output::GetUserDefinedFunctionsOutput)
    pub fn builder() -> crate::output::get_user_defined_functions_output::Builder {
        crate::output::get_user_defined_functions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUserDefinedFunctionOutput {
    /// <p>The requested function definition.</p>
    pub user_defined_function: std::option::Option<crate::model::UserDefinedFunction>,
}
impl std::fmt::Debug for GetUserDefinedFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUserDefinedFunctionOutput");
        formatter.field("user_defined_function", &self.user_defined_function);
        formatter.finish()
    }
}
/// See [`GetUserDefinedFunctionOutput`](crate::output::GetUserDefinedFunctionOutput)
pub mod get_user_defined_function_output {
    /// A builder for [`GetUserDefinedFunctionOutput`](crate::output::GetUserDefinedFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_defined_function: std::option::Option<crate::model::UserDefinedFunction>,
    }
    impl Builder {
        /// <p>The requested function definition.</p>
        pub fn user_defined_function(mut self, input: crate::model::UserDefinedFunction) -> Self {
            self.user_defined_function = Some(input);
            self
        }
        /// <p>The requested function definition.</p>
        pub fn set_user_defined_function(
            mut self,
            input: std::option::Option<crate::model::UserDefinedFunction>,
        ) -> Self {
            self.user_defined_function = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserDefinedFunctionOutput`](crate::output::GetUserDefinedFunctionOutput)
        pub fn build(self) -> crate::output::GetUserDefinedFunctionOutput {
            crate::output::GetUserDefinedFunctionOutput {
                user_defined_function: self.user_defined_function,
            }
        }
    }
}
impl GetUserDefinedFunctionOutput {
    /// Creates a new builder-style object to manufacture [`GetUserDefinedFunctionOutput`](crate::output::GetUserDefinedFunctionOutput)
    pub fn builder() -> crate::output::get_user_defined_function_output::Builder {
        crate::output::get_user_defined_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTriggersOutput {
    /// <p>A list of triggers for the specified job.</p>
    pub triggers: std::option::Option<std::vec::Vec<crate::model::Trigger>>,
    /// <p>A continuation token, if not all the requested triggers
    /// have yet been returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTriggersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTriggersOutput");
        formatter.field("triggers", &self.triggers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTriggersOutput`](crate::output::GetTriggersOutput)
pub mod get_triggers_output {
    /// A builder for [`GetTriggersOutput`](crate::output::GetTriggersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) triggers: std::option::Option<std::vec::Vec<crate::model::Trigger>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>A list of triggers for the specified job.</p>
        pub fn triggers(mut self, input: impl Into<crate::model::Trigger>) -> Self {
            let mut v = self.triggers.unwrap_or_default();
            v.push(input.into());
            self.triggers = Some(v);
            self
        }
        /// <p>A list of triggers for the specified job.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Trigger>>,
        ) -> Self {
            self.triggers = input;
            self
        }
        /// <p>A continuation token, if not all the requested triggers
        /// have yet been returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if not all the requested triggers
        /// have yet been returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTriggersOutput`](crate::output::GetTriggersOutput)
        pub fn build(self) -> crate::output::GetTriggersOutput {
            crate::output::GetTriggersOutput {
                triggers: self.triggers,
                next_token: self.next_token,
            }
        }
    }
}
impl GetTriggersOutput {
    /// Creates a new builder-style object to manufacture [`GetTriggersOutput`](crate::output::GetTriggersOutput)
    pub fn builder() -> crate::output::get_triggers_output::Builder {
        crate::output::get_triggers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTriggerOutput {
    /// <p>The requested trigger definition.</p>
    pub trigger: std::option::Option<crate::model::Trigger>,
}
impl std::fmt::Debug for GetTriggerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTriggerOutput");
        formatter.field("trigger", &self.trigger);
        formatter.finish()
    }
}
/// See [`GetTriggerOutput`](crate::output::GetTriggerOutput)
pub mod get_trigger_output {
    /// A builder for [`GetTriggerOutput`](crate::output::GetTriggerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trigger: std::option::Option<crate::model::Trigger>,
    }
    impl Builder {
        /// <p>The requested trigger definition.</p>
        pub fn trigger(mut self, input: crate::model::Trigger) -> Self {
            self.trigger = Some(input);
            self
        }
        /// <p>The requested trigger definition.</p>
        pub fn set_trigger(mut self, input: std::option::Option<crate::model::Trigger>) -> Self {
            self.trigger = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTriggerOutput`](crate::output::GetTriggerOutput)
        pub fn build(self) -> crate::output::GetTriggerOutput {
            crate::output::GetTriggerOutput {
                trigger: self.trigger,
            }
        }
    }
}
impl GetTriggerOutput {
    /// Creates a new builder-style object to manufacture [`GetTriggerOutput`](crate::output::GetTriggerOutput)
    pub fn builder() -> crate::output::get_trigger_output::Builder {
        crate::output::get_trigger_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTagsOutput {
    /// <p>The requested tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetTagsOutput`](crate::output::GetTagsOutput)
pub mod get_tags_output {
    /// A builder for [`GetTagsOutput`](crate::output::GetTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The requested tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The requested tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTagsOutput`](crate::output::GetTagsOutput)
        pub fn build(self) -> crate::output::GetTagsOutput {
            crate::output::GetTagsOutput { tags: self.tags }
        }
    }
}
impl GetTagsOutput {
    /// Creates a new builder-style object to manufacture [`GetTagsOutput`](crate::output::GetTagsOutput)
    pub fn builder() -> crate::output::get_tags_output::Builder {
        crate::output::get_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTableVersionsOutput {
    /// <p>A list of strings identifying available versions of the
    /// specified table.</p>
    pub table_versions: std::option::Option<std::vec::Vec<crate::model::TableVersion>>,
    /// <p>A continuation token, if the list of available versions does
    /// not include the last one.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTableVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTableVersionsOutput");
        formatter.field("table_versions", &self.table_versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTableVersionsOutput`](crate::output::GetTableVersionsOutput)
pub mod get_table_versions_output {
    /// A builder for [`GetTableVersionsOutput`](crate::output::GetTableVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_versions: std::option::Option<std::vec::Vec<crate::model::TableVersion>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `table_versions`.
        ///
        /// To override the contents of this collection use [`set_table_versions`](Self::set_table_versions).
        ///
        /// <p>A list of strings identifying available versions of the
        /// specified table.</p>
        pub fn table_versions(mut self, input: impl Into<crate::model::TableVersion>) -> Self {
            let mut v = self.table_versions.unwrap_or_default();
            v.push(input.into());
            self.table_versions = Some(v);
            self
        }
        /// <p>A list of strings identifying available versions of the
        /// specified table.</p>
        pub fn set_table_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableVersion>>,
        ) -> Self {
            self.table_versions = input;
            self
        }
        /// <p>A continuation token, if the list of available versions does
        /// not include the last one.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the list of available versions does
        /// not include the last one.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTableVersionsOutput`](crate::output::GetTableVersionsOutput)
        pub fn build(self) -> crate::output::GetTableVersionsOutput {
            crate::output::GetTableVersionsOutput {
                table_versions: self.table_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl GetTableVersionsOutput {
    /// Creates a new builder-style object to manufacture [`GetTableVersionsOutput`](crate::output::GetTableVersionsOutput)
    pub fn builder() -> crate::output::get_table_versions_output::Builder {
        crate::output::get_table_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTableVersionOutput {
    /// <p>The requested table version.</p>
    pub table_version: std::option::Option<crate::model::TableVersion>,
}
impl std::fmt::Debug for GetTableVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTableVersionOutput");
        formatter.field("table_version", &self.table_version);
        formatter.finish()
    }
}
/// See [`GetTableVersionOutput`](crate::output::GetTableVersionOutput)
pub mod get_table_version_output {
    /// A builder for [`GetTableVersionOutput`](crate::output::GetTableVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_version: std::option::Option<crate::model::TableVersion>,
    }
    impl Builder {
        /// <p>The requested table version.</p>
        pub fn table_version(mut self, input: crate::model::TableVersion) -> Self {
            self.table_version = Some(input);
            self
        }
        /// <p>The requested table version.</p>
        pub fn set_table_version(
            mut self,
            input: std::option::Option<crate::model::TableVersion>,
        ) -> Self {
            self.table_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTableVersionOutput`](crate::output::GetTableVersionOutput)
        pub fn build(self) -> crate::output::GetTableVersionOutput {
            crate::output::GetTableVersionOutput {
                table_version: self.table_version,
            }
        }
    }
}
impl GetTableVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetTableVersionOutput`](crate::output::GetTableVersionOutput)
    pub fn builder() -> crate::output::get_table_version_output::Builder {
        crate::output::get_table_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTablesOutput {
    /// <p>A list of the requested <code>Table</code> objects.</p>
    pub table_list: std::option::Option<std::vec::Vec<crate::model::Table>>,
    /// <p>A continuation token, present if the current list segment is
    /// not the last.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTablesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTablesOutput");
        formatter.field("table_list", &self.table_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTablesOutput`](crate::output::GetTablesOutput)
pub mod get_tables_output {
    /// A builder for [`GetTablesOutput`](crate::output::GetTablesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_list: std::option::Option<std::vec::Vec<crate::model::Table>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `table_list`.
        ///
        /// To override the contents of this collection use [`set_table_list`](Self::set_table_list).
        ///
        /// <p>A list of the requested <code>Table</code> objects.</p>
        pub fn table_list(mut self, input: impl Into<crate::model::Table>) -> Self {
            let mut v = self.table_list.unwrap_or_default();
            v.push(input.into());
            self.table_list = Some(v);
            self
        }
        /// <p>A list of the requested <code>Table</code> objects.</p>
        pub fn set_table_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Table>>,
        ) -> Self {
            self.table_list = input;
            self
        }
        /// <p>A continuation token, present if the current list segment is
        /// not the last.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, present if the current list segment is
        /// not the last.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTablesOutput`](crate::output::GetTablesOutput)
        pub fn build(self) -> crate::output::GetTablesOutput {
            crate::output::GetTablesOutput {
                table_list: self.table_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetTablesOutput {
    /// Creates a new builder-style object to manufacture [`GetTablesOutput`](crate::output::GetTablesOutput)
    pub fn builder() -> crate::output::get_tables_output::Builder {
        crate::output::get_tables_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTableOutput {
    /// <p>The <code>Table</code> object that defines the specified table.</p>
    pub table: std::option::Option<crate::model::Table>,
}
impl std::fmt::Debug for GetTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTableOutput");
        formatter.field("table", &self.table);
        formatter.finish()
    }
}
/// See [`GetTableOutput`](crate::output::GetTableOutput)
pub mod get_table_output {
    /// A builder for [`GetTableOutput`](crate::output::GetTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table: std::option::Option<crate::model::Table>,
    }
    impl Builder {
        /// <p>The <code>Table</code> object that defines the specified table.</p>
        pub fn table(mut self, input: crate::model::Table) -> Self {
            self.table = Some(input);
            self
        }
        /// <p>The <code>Table</code> object that defines the specified table.</p>
        pub fn set_table(mut self, input: std::option::Option<crate::model::Table>) -> Self {
            self.table = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTableOutput`](crate::output::GetTableOutput)
        pub fn build(self) -> crate::output::GetTableOutput {
            crate::output::GetTableOutput { table: self.table }
        }
    }
}
impl GetTableOutput {
    /// Creates a new builder-style object to manufacture [`GetTableOutput`](crate::output::GetTableOutput)
    pub fn builder() -> crate::output::get_table_output::Builder {
        crate::output::get_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSecurityConfigurationsOutput {
    /// <p>A list of security configurations.</p>
    pub security_configurations:
        std::option::Option<std::vec::Vec<crate::model::SecurityConfiguration>>,
    /// <p>A continuation token, if there are more security
    /// configurations to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSecurityConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSecurityConfigurationsOutput");
        formatter.field("security_configurations", &self.security_configurations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetSecurityConfigurationsOutput`](crate::output::GetSecurityConfigurationsOutput)
pub mod get_security_configurations_output {
    /// A builder for [`GetSecurityConfigurationsOutput`](crate::output::GetSecurityConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_configurations:
            std::option::Option<std::vec::Vec<crate::model::SecurityConfiguration>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `security_configurations`.
        ///
        /// To override the contents of this collection use [`set_security_configurations`](Self::set_security_configurations).
        ///
        /// <p>A list of security configurations.</p>
        pub fn security_configurations(
            mut self,
            input: impl Into<crate::model::SecurityConfiguration>,
        ) -> Self {
            let mut v = self.security_configurations.unwrap_or_default();
            v.push(input.into());
            self.security_configurations = Some(v);
            self
        }
        /// <p>A list of security configurations.</p>
        pub fn set_security_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecurityConfiguration>>,
        ) -> Self {
            self.security_configurations = input;
            self
        }
        /// <p>A continuation token, if there are more security
        /// configurations to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if there are more security
        /// configurations to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSecurityConfigurationsOutput`](crate::output::GetSecurityConfigurationsOutput)
        pub fn build(self) -> crate::output::GetSecurityConfigurationsOutput {
            crate::output::GetSecurityConfigurationsOutput {
                security_configurations: self.security_configurations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetSecurityConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`GetSecurityConfigurationsOutput`](crate::output::GetSecurityConfigurationsOutput)
    pub fn builder() -> crate::output::get_security_configurations_output::Builder {
        crate::output::get_security_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSecurityConfigurationOutput {
    /// <p>The requested security configuration.</p>
    pub security_configuration: std::option::Option<crate::model::SecurityConfiguration>,
}
impl std::fmt::Debug for GetSecurityConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSecurityConfigurationOutput");
        formatter.field("security_configuration", &self.security_configuration);
        formatter.finish()
    }
}
/// See [`GetSecurityConfigurationOutput`](crate::output::GetSecurityConfigurationOutput)
pub mod get_security_configuration_output {
    /// A builder for [`GetSecurityConfigurationOutput`](crate::output::GetSecurityConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_configuration: std::option::Option<crate::model::SecurityConfiguration>,
    }
    impl Builder {
        /// <p>The requested security configuration.</p>
        pub fn security_configuration(
            mut self,
            input: crate::model::SecurityConfiguration,
        ) -> Self {
            self.security_configuration = Some(input);
            self
        }
        /// <p>The requested security configuration.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<crate::model::SecurityConfiguration>,
        ) -> Self {
            self.security_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSecurityConfigurationOutput`](crate::output::GetSecurityConfigurationOutput)
        pub fn build(self) -> crate::output::GetSecurityConfigurationOutput {
            crate::output::GetSecurityConfigurationOutput {
                security_configuration: self.security_configuration,
            }
        }
    }
}
impl GetSecurityConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetSecurityConfigurationOutput`](crate::output::GetSecurityConfigurationOutput)
    pub fn builder() -> crate::output::get_security_configuration_output::Builder {
        crate::output::get_security_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSchemaVersionsDiffOutput {
    /// <p>The difference between schemas as a string in JsonPatch format.</p>
    pub diff: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSchemaVersionsDiffOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSchemaVersionsDiffOutput");
        formatter.field("diff", &self.diff);
        formatter.finish()
    }
}
/// See [`GetSchemaVersionsDiffOutput`](crate::output::GetSchemaVersionsDiffOutput)
pub mod get_schema_versions_diff_output {
    /// A builder for [`GetSchemaVersionsDiffOutput`](crate::output::GetSchemaVersionsDiffOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) diff: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The difference between schemas as a string in JsonPatch format.</p>
        pub fn diff(mut self, input: impl Into<std::string::String>) -> Self {
            self.diff = Some(input.into());
            self
        }
        /// <p>The difference between schemas as a string in JsonPatch format.</p>
        pub fn set_diff(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.diff = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSchemaVersionsDiffOutput`](crate::output::GetSchemaVersionsDiffOutput)
        pub fn build(self) -> crate::output::GetSchemaVersionsDiffOutput {
            crate::output::GetSchemaVersionsDiffOutput { diff: self.diff }
        }
    }
}
impl GetSchemaVersionsDiffOutput {
    /// Creates a new builder-style object to manufacture [`GetSchemaVersionsDiffOutput`](crate::output::GetSchemaVersionsDiffOutput)
    pub fn builder() -> crate::output::get_schema_versions_diff_output::Builder {
        crate::output::get_schema_versions_diff_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSchemaVersionOutput {
    /// <p>The <code>SchemaVersionId</code> of the schema version.</p>
    pub schema_version_id: std::option::Option<std::string::String>,
    /// <p>The schema definition for the schema ID.</p>
    pub schema_definition: std::option::Option<std::string::String>,
    /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
    pub data_format: std::option::Option<crate::model::DataFormat>,
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The version number of the schema.</p>
    pub version_number: i64,
    /// <p>The status of the schema version. </p>
    pub status: std::option::Option<crate::model::SchemaVersionStatus>,
    /// <p>The date and time the schema version was created.</p>
    pub created_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSchemaVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSchemaVersionOutput");
        formatter.field("schema_version_id", &self.schema_version_id);
        formatter.field("schema_definition", &self.schema_definition);
        formatter.field("data_format", &self.data_format);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("version_number", &self.version_number);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`GetSchemaVersionOutput`](crate::output::GetSchemaVersionOutput)
pub mod get_schema_version_output {
    /// A builder for [`GetSchemaVersionOutput`](crate::output::GetSchemaVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_version_id: std::option::Option<std::string::String>,
        pub(crate) schema_definition: std::option::Option<std::string::String>,
        pub(crate) data_format: std::option::Option<crate::model::DataFormat>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::SchemaVersionStatus>,
        pub(crate) created_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>SchemaVersionId</code> of the schema version.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version_id = Some(input.into());
            self
        }
        /// <p>The <code>SchemaVersionId</code> of the schema version.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version_id = input;
            self
        }
        /// <p>The schema definition for the schema ID.</p>
        pub fn schema_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_definition = Some(input.into());
            self
        }
        /// <p>The schema definition for the schema ID.</p>
        pub fn set_schema_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_definition = input;
            self
        }
        /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn data_format(mut self, input: crate::model::DataFormat) -> Self {
            self.data_format = Some(input);
            self
        }
        /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::DataFormat>,
        ) -> Self {
            self.data_format = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The status of the schema version. </p>
        pub fn status(mut self, input: crate::model::SchemaVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the schema version. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time the schema version was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The date and time the schema version was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSchemaVersionOutput`](crate::output::GetSchemaVersionOutput)
        pub fn build(self) -> crate::output::GetSchemaVersionOutput {
            crate::output::GetSchemaVersionOutput {
                schema_version_id: self.schema_version_id,
                schema_definition: self.schema_definition,
                data_format: self.data_format,
                schema_arn: self.schema_arn,
                version_number: self.version_number.unwrap_or_default(),
                status: self.status,
                created_time: self.created_time,
            }
        }
    }
}
impl GetSchemaVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetSchemaVersionOutput`](crate::output::GetSchemaVersionOutput)
    pub fn builder() -> crate::output::get_schema_version_output::Builder {
        crate::output::get_schema_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSchemaByDefinitionOutput {
    /// <p>The schema ID of the schema version.</p>
    pub schema_version_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The data format of the schema definition. Currently only <code>AVRO</code> and <code>JSON</code> are supported.</p>
    pub data_format: std::option::Option<crate::model::DataFormat>,
    /// <p>The status of the schema version.</p>
    pub status: std::option::Option<crate::model::SchemaVersionStatus>,
    /// <p>The date and time the schema was created.</p>
    pub created_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSchemaByDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSchemaByDefinitionOutput");
        formatter.field("schema_version_id", &self.schema_version_id);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("data_format", &self.data_format);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`GetSchemaByDefinitionOutput`](crate::output::GetSchemaByDefinitionOutput)
pub mod get_schema_by_definition_output {
    /// A builder for [`GetSchemaByDefinitionOutput`](crate::output::GetSchemaByDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_version_id: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) data_format: std::option::Option<crate::model::DataFormat>,
        pub(crate) status: std::option::Option<crate::model::SchemaVersionStatus>,
        pub(crate) created_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The schema ID of the schema version.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version_id = Some(input.into());
            self
        }
        /// <p>The schema ID of the schema version.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The data format of the schema definition. Currently only <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn data_format(mut self, input: crate::model::DataFormat) -> Self {
            self.data_format = Some(input);
            self
        }
        /// <p>The data format of the schema definition. Currently only <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::DataFormat>,
        ) -> Self {
            self.data_format = input;
            self
        }
        /// <p>The status of the schema version.</p>
        pub fn status(mut self, input: crate::model::SchemaVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the schema version.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time the schema was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The date and time the schema was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSchemaByDefinitionOutput`](crate::output::GetSchemaByDefinitionOutput)
        pub fn build(self) -> crate::output::GetSchemaByDefinitionOutput {
            crate::output::GetSchemaByDefinitionOutput {
                schema_version_id: self.schema_version_id,
                schema_arn: self.schema_arn,
                data_format: self.data_format,
                status: self.status,
                created_time: self.created_time,
            }
        }
    }
}
impl GetSchemaByDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`GetSchemaByDefinitionOutput`](crate::output::GetSchemaByDefinitionOutput)
    pub fn builder() -> crate::output::get_schema_by_definition_output::Builder {
        crate::output::get_schema_by_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSchemaOutput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>A description of schema if specified when created</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
    pub data_format: std::option::Option<crate::model::DataFormat>,
    /// <p>The compatibility mode of the schema.</p>
    pub compatibility: std::option::Option<crate::model::Compatibility>,
    /// <p>The version number of the checkpoint (the last time the compatibility mode was changed).</p>
    pub schema_checkpoint: i64,
    /// <p>The latest version of the schema associated with the returned schema definition.</p>
    pub latest_schema_version: i64,
    /// <p>The next version of the schema associated with the returned schema definition.</p>
    pub next_schema_version: i64,
    /// <p>The status of the schema.</p>
    pub schema_status: std::option::Option<crate::model::SchemaStatus>,
    /// <p>The date and time the schema was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The date and time the schema was updated.</p>
    pub updated_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSchemaOutput");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("description", &self.description);
        formatter.field("data_format", &self.data_format);
        formatter.field("compatibility", &self.compatibility);
        formatter.field("schema_checkpoint", &self.schema_checkpoint);
        formatter.field("latest_schema_version", &self.latest_schema_version);
        formatter.field("next_schema_version", &self.next_schema_version);
        formatter.field("schema_status", &self.schema_status);
        formatter.field("created_time", &self.created_time);
        formatter.field("updated_time", &self.updated_time);
        formatter.finish()
    }
}
/// See [`GetSchemaOutput`](crate::output::GetSchemaOutput)
pub mod get_schema_output {
    /// A builder for [`GetSchemaOutput`](crate::output::GetSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_format: std::option::Option<crate::model::DataFormat>,
        pub(crate) compatibility: std::option::Option<crate::model::Compatibility>,
        pub(crate) schema_checkpoint: std::option::Option<i64>,
        pub(crate) latest_schema_version: std::option::Option<i64>,
        pub(crate) next_schema_version: std::option::Option<i64>,
        pub(crate) schema_status: std::option::Option<crate::model::SchemaStatus>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) updated_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>A description of schema if specified when created</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of schema if specified when created</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn data_format(mut self, input: crate::model::DataFormat) -> Self {
            self.data_format = Some(input);
            self
        }
        /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::DataFormat>,
        ) -> Self {
            self.data_format = input;
            self
        }
        /// <p>The compatibility mode of the schema.</p>
        pub fn compatibility(mut self, input: crate::model::Compatibility) -> Self {
            self.compatibility = Some(input);
            self
        }
        /// <p>The compatibility mode of the schema.</p>
        pub fn set_compatibility(
            mut self,
            input: std::option::Option<crate::model::Compatibility>,
        ) -> Self {
            self.compatibility = input;
            self
        }
        /// <p>The version number of the checkpoint (the last time the compatibility mode was changed).</p>
        pub fn schema_checkpoint(mut self, input: i64) -> Self {
            self.schema_checkpoint = Some(input);
            self
        }
        /// <p>The version number of the checkpoint (the last time the compatibility mode was changed).</p>
        pub fn set_schema_checkpoint(mut self, input: std::option::Option<i64>) -> Self {
            self.schema_checkpoint = input;
            self
        }
        /// <p>The latest version of the schema associated with the returned schema definition.</p>
        pub fn latest_schema_version(mut self, input: i64) -> Self {
            self.latest_schema_version = Some(input);
            self
        }
        /// <p>The latest version of the schema associated with the returned schema definition.</p>
        pub fn set_latest_schema_version(mut self, input: std::option::Option<i64>) -> Self {
            self.latest_schema_version = input;
            self
        }
        /// <p>The next version of the schema associated with the returned schema definition.</p>
        pub fn next_schema_version(mut self, input: i64) -> Self {
            self.next_schema_version = Some(input);
            self
        }
        /// <p>The next version of the schema associated with the returned schema definition.</p>
        pub fn set_next_schema_version(mut self, input: std::option::Option<i64>) -> Self {
            self.next_schema_version = input;
            self
        }
        /// <p>The status of the schema.</p>
        pub fn schema_status(mut self, input: crate::model::SchemaStatus) -> Self {
            self.schema_status = Some(input);
            self
        }
        /// <p>The status of the schema.</p>
        pub fn set_schema_status(
            mut self,
            input: std::option::Option<crate::model::SchemaStatus>,
        ) -> Self {
            self.schema_status = input;
            self
        }
        /// <p>The date and time the schema was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The date and time the schema was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time the schema was updated.</p>
        pub fn updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_time = Some(input.into());
            self
        }
        /// <p>The date and time the schema was updated.</p>
        pub fn set_updated_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSchemaOutput`](crate::output::GetSchemaOutput)
        pub fn build(self) -> crate::output::GetSchemaOutput {
            crate::output::GetSchemaOutput {
                registry_name: self.registry_name,
                registry_arn: self.registry_arn,
                schema_name: self.schema_name,
                schema_arn: self.schema_arn,
                description: self.description,
                data_format: self.data_format,
                compatibility: self.compatibility,
                schema_checkpoint: self.schema_checkpoint.unwrap_or_default(),
                latest_schema_version: self.latest_schema_version.unwrap_or_default(),
                next_schema_version: self.next_schema_version.unwrap_or_default(),
                schema_status: self.schema_status,
                created_time: self.created_time,
                updated_time: self.updated_time,
            }
        }
    }
}
impl GetSchemaOutput {
    /// Creates a new builder-style object to manufacture [`GetSchemaOutput`](crate::output::GetSchemaOutput)
    pub fn builder() -> crate::output::get_schema_output::Builder {
        crate::output::get_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePolicyOutput {
    /// <p>Contains the requested policy document, in JSON format.</p>
    pub policy_in_json: std::option::Option<std::string::String>,
    /// <p>Contains the hash value associated with this policy.</p>
    pub policy_hash: std::option::Option<std::string::String>,
    /// <p>The date and time at which the policy was created.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time at which the policy was last updated.</p>
    pub update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for GetResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePolicyOutput");
        formatter.field("policy_in_json", &self.policy_in_json);
        formatter.field("policy_hash", &self.policy_hash);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
pub mod get_resource_policy_output {
    /// A builder for [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_in_json: std::option::Option<std::string::String>,
        pub(crate) policy_hash: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Contains the requested policy document, in JSON format.</p>
        pub fn policy_in_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_in_json = Some(input.into());
            self
        }
        /// <p>Contains the requested policy document, in JSON format.</p>
        pub fn set_policy_in_json(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_in_json = input;
            self
        }
        /// <p>Contains the hash value associated with this policy.</p>
        pub fn policy_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_hash = Some(input.into());
            self
        }
        /// <p>Contains the hash value associated with this policy.</p>
        pub fn set_policy_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_hash = input;
            self
        }
        /// <p>The date and time at which the policy was created.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The date and time at which the policy was created.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The date and time at which the policy was last updated.</p>
        pub fn update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The date and time at which the policy was last updated.</p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
        pub fn build(self) -> crate::output::GetResourcePolicyOutput {
            crate::output::GetResourcePolicyOutput {
                policy_in_json: self.policy_in_json,
                policy_hash: self.policy_hash,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl GetResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    pub fn builder() -> crate::output::get_resource_policy_output::Builder {
        crate::output::get_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePoliciesOutput {
    /// <p>A list of the individual resource policies and the account-level resource policy.</p>
    pub get_resource_policies_response_list:
        std::option::Option<std::vec::Vec<crate::model::GluePolicy>>,
    /// <p>A continuation token, if the returned list does not contain the last resource policy available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResourcePoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePoliciesOutput");
        formatter.field(
            "get_resource_policies_response_list",
            &self.get_resource_policies_response_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetResourcePoliciesOutput`](crate::output::GetResourcePoliciesOutput)
pub mod get_resource_policies_output {
    /// A builder for [`GetResourcePoliciesOutput`](crate::output::GetResourcePoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) get_resource_policies_response_list:
            std::option::Option<std::vec::Vec<crate::model::GluePolicy>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `get_resource_policies_response_list`.
        ///
        /// To override the contents of this collection use [`set_get_resource_policies_response_list`](Self::set_get_resource_policies_response_list).
        ///
        /// <p>A list of the individual resource policies and the account-level resource policy.</p>
        pub fn get_resource_policies_response_list(
            mut self,
            input: impl Into<crate::model::GluePolicy>,
        ) -> Self {
            let mut v = self.get_resource_policies_response_list.unwrap_or_default();
            v.push(input.into());
            self.get_resource_policies_response_list = Some(v);
            self
        }
        /// <p>A list of the individual resource policies and the account-level resource policy.</p>
        pub fn set_get_resource_policies_response_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GluePolicy>>,
        ) -> Self {
            self.get_resource_policies_response_list = input;
            self
        }
        /// <p>A continuation token, if the returned list does not contain the last resource policy available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the returned list does not contain the last resource policy available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePoliciesOutput`](crate::output::GetResourcePoliciesOutput)
        pub fn build(self) -> crate::output::GetResourcePoliciesOutput {
            crate::output::GetResourcePoliciesOutput {
                get_resource_policies_response_list: self.get_resource_policies_response_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetResourcePoliciesOutput {
    /// Creates a new builder-style object to manufacture [`GetResourcePoliciesOutput`](crate::output::GetResourcePoliciesOutput)
    pub fn builder() -> crate::output::get_resource_policies_output::Builder {
        crate::output::get_resource_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRegistryOutput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>A description of the registry.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the registry.</p>
    pub status: std::option::Option<crate::model::RegistryStatus>,
    /// <p>The date and time the registry was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The date and time the registry was updated.</p>
    pub updated_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetRegistryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRegistryOutput");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("updated_time", &self.updated_time);
        formatter.finish()
    }
}
/// See [`GetRegistryOutput`](crate::output::GetRegistryOutput)
pub mod get_registry_output {
    /// A builder for [`GetRegistryOutput`](crate::output::GetRegistryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RegistryStatus>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) updated_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>A description of the registry.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the registry.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the registry.</p>
        pub fn status(mut self, input: crate::model::RegistryStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the registry.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RegistryStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time the registry was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The date and time the registry was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time the registry was updated.</p>
        pub fn updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_time = Some(input.into());
            self
        }
        /// <p>The date and time the registry was updated.</p>
        pub fn set_updated_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRegistryOutput`](crate::output::GetRegistryOutput)
        pub fn build(self) -> crate::output::GetRegistryOutput {
            crate::output::GetRegistryOutput {
                registry_name: self.registry_name,
                registry_arn: self.registry_arn,
                description: self.description,
                status: self.status,
                created_time: self.created_time,
                updated_time: self.updated_time,
            }
        }
    }
}
impl GetRegistryOutput {
    /// Creates a new builder-style object to manufacture [`GetRegistryOutput`](crate::output::GetRegistryOutput)
    pub fn builder() -> crate::output::get_registry_output::Builder {
        crate::output::get_registry_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPlanOutput {
    /// <p>A Python script to perform the mapping.</p>
    pub python_script: std::option::Option<std::string::String>,
    /// <p>The Scala code to perform the mapping.</p>
    pub scala_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetPlanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPlanOutput");
        formatter.field("python_script", &self.python_script);
        formatter.field("scala_code", &self.scala_code);
        formatter.finish()
    }
}
/// See [`GetPlanOutput`](crate::output::GetPlanOutput)
pub mod get_plan_output {
    /// A builder for [`GetPlanOutput`](crate::output::GetPlanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) python_script: std::option::Option<std::string::String>,
        pub(crate) scala_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A Python script to perform the mapping.</p>
        pub fn python_script(mut self, input: impl Into<std::string::String>) -> Self {
            self.python_script = Some(input.into());
            self
        }
        /// <p>A Python script to perform the mapping.</p>
        pub fn set_python_script(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.python_script = input;
            self
        }
        /// <p>The Scala code to perform the mapping.</p>
        pub fn scala_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.scala_code = Some(input.into());
            self
        }
        /// <p>The Scala code to perform the mapping.</p>
        pub fn set_scala_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scala_code = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPlanOutput`](crate::output::GetPlanOutput)
        pub fn build(self) -> crate::output::GetPlanOutput {
            crate::output::GetPlanOutput {
                python_script: self.python_script,
                scala_code: self.scala_code,
            }
        }
    }
}
impl GetPlanOutput {
    /// Creates a new builder-style object to manufacture [`GetPlanOutput`](crate::output::GetPlanOutput)
    pub fn builder() -> crate::output::get_plan_output::Builder {
        crate::output::get_plan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPartitionsOutput {
    /// <p>A list of requested partitions.</p>
    pub partitions: std::option::Option<std::vec::Vec<crate::model::Partition>>,
    /// <p>A continuation token, if the returned list of partitions does not include the last
    /// one.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetPartitionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPartitionsOutput");
        formatter.field("partitions", &self.partitions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetPartitionsOutput`](crate::output::GetPartitionsOutput)
pub mod get_partitions_output {
    /// A builder for [`GetPartitionsOutput`](crate::output::GetPartitionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partitions: std::option::Option<std::vec::Vec<crate::model::Partition>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `partitions`.
        ///
        /// To override the contents of this collection use [`set_partitions`](Self::set_partitions).
        ///
        /// <p>A list of requested partitions.</p>
        pub fn partitions(mut self, input: impl Into<crate::model::Partition>) -> Self {
            let mut v = self.partitions.unwrap_or_default();
            v.push(input.into());
            self.partitions = Some(v);
            self
        }
        /// <p>A list of requested partitions.</p>
        pub fn set_partitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Partition>>,
        ) -> Self {
            self.partitions = input;
            self
        }
        /// <p>A continuation token, if the returned list of partitions does not include the last
        /// one.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the returned list of partitions does not include the last
        /// one.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPartitionsOutput`](crate::output::GetPartitionsOutput)
        pub fn build(self) -> crate::output::GetPartitionsOutput {
            crate::output::GetPartitionsOutput {
                partitions: self.partitions,
                next_token: self.next_token,
            }
        }
    }
}
impl GetPartitionsOutput {
    /// Creates a new builder-style object to manufacture [`GetPartitionsOutput`](crate::output::GetPartitionsOutput)
    pub fn builder() -> crate::output::get_partitions_output::Builder {
        crate::output::get_partitions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPartitionIndexesOutput {
    /// <p>A list of index descriptors.</p>
    pub partition_index_descriptor_list:
        std::option::Option<std::vec::Vec<crate::model::PartitionIndexDescriptor>>,
    /// <p>A continuation token, present if the current list segment is not the last.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetPartitionIndexesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPartitionIndexesOutput");
        formatter.field(
            "partition_index_descriptor_list",
            &self.partition_index_descriptor_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetPartitionIndexesOutput`](crate::output::GetPartitionIndexesOutput)
pub mod get_partition_indexes_output {
    /// A builder for [`GetPartitionIndexesOutput`](crate::output::GetPartitionIndexesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partition_index_descriptor_list:
            std::option::Option<std::vec::Vec<crate::model::PartitionIndexDescriptor>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `partition_index_descriptor_list`.
        ///
        /// To override the contents of this collection use [`set_partition_index_descriptor_list`](Self::set_partition_index_descriptor_list).
        ///
        /// <p>A list of index descriptors.</p>
        pub fn partition_index_descriptor_list(
            mut self,
            input: impl Into<crate::model::PartitionIndexDescriptor>,
        ) -> Self {
            let mut v = self.partition_index_descriptor_list.unwrap_or_default();
            v.push(input.into());
            self.partition_index_descriptor_list = Some(v);
            self
        }
        /// <p>A list of index descriptors.</p>
        pub fn set_partition_index_descriptor_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartitionIndexDescriptor>>,
        ) -> Self {
            self.partition_index_descriptor_list = input;
            self
        }
        /// <p>A continuation token, present if the current list segment is not the last.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, present if the current list segment is not the last.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPartitionIndexesOutput`](crate::output::GetPartitionIndexesOutput)
        pub fn build(self) -> crate::output::GetPartitionIndexesOutput {
            crate::output::GetPartitionIndexesOutput {
                partition_index_descriptor_list: self.partition_index_descriptor_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetPartitionIndexesOutput {
    /// Creates a new builder-style object to manufacture [`GetPartitionIndexesOutput`](crate::output::GetPartitionIndexesOutput)
    pub fn builder() -> crate::output::get_partition_indexes_output::Builder {
        crate::output::get_partition_indexes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPartitionOutput {
    /// <p>The requested information, in the form of a <code>Partition</code>
    /// object.</p>
    pub partition: std::option::Option<crate::model::Partition>,
}
impl std::fmt::Debug for GetPartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPartitionOutput");
        formatter.field("partition", &self.partition);
        formatter.finish()
    }
}
/// See [`GetPartitionOutput`](crate::output::GetPartitionOutput)
pub mod get_partition_output {
    /// A builder for [`GetPartitionOutput`](crate::output::GetPartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partition: std::option::Option<crate::model::Partition>,
    }
    impl Builder {
        /// <p>The requested information, in the form of a <code>Partition</code>
        /// object.</p>
        pub fn partition(mut self, input: crate::model::Partition) -> Self {
            self.partition = Some(input);
            self
        }
        /// <p>The requested information, in the form of a <code>Partition</code>
        /// object.</p>
        pub fn set_partition(
            mut self,
            input: std::option::Option<crate::model::Partition>,
        ) -> Self {
            self.partition = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPartitionOutput`](crate::output::GetPartitionOutput)
        pub fn build(self) -> crate::output::GetPartitionOutput {
            crate::output::GetPartitionOutput {
                partition: self.partition,
            }
        }
    }
}
impl GetPartitionOutput {
    /// Creates a new builder-style object to manufacture [`GetPartitionOutput`](crate::output::GetPartitionOutput)
    pub fn builder() -> crate::output::get_partition_output::Builder {
        crate::output::get_partition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMlTransformsOutput {
    /// <p>A list of machine learning transforms.</p>
    pub transforms: std::option::Option<std::vec::Vec<crate::model::MlTransform>>,
    /// <p>A pagination token, if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetMlTransformsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMlTransformsOutput");
        formatter.field("transforms", &self.transforms);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetMlTransformsOutput`](crate::output::GetMlTransformsOutput)
pub mod get_ml_transforms_output {
    /// A builder for [`GetMlTransformsOutput`](crate::output::GetMlTransformsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transforms: std::option::Option<std::vec::Vec<crate::model::MlTransform>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `transforms`.
        ///
        /// To override the contents of this collection use [`set_transforms`](Self::set_transforms).
        ///
        /// <p>A list of machine learning transforms.</p>
        pub fn transforms(mut self, input: impl Into<crate::model::MlTransform>) -> Self {
            let mut v = self.transforms.unwrap_or_default();
            v.push(input.into());
            self.transforms = Some(v);
            self
        }
        /// <p>A list of machine learning transforms.</p>
        pub fn set_transforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MlTransform>>,
        ) -> Self {
            self.transforms = input;
            self
        }
        /// <p>A pagination token, if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token, if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMlTransformsOutput`](crate::output::GetMlTransformsOutput)
        pub fn build(self) -> crate::output::GetMlTransformsOutput {
            crate::output::GetMlTransformsOutput {
                transforms: self.transforms,
                next_token: self.next_token,
            }
        }
    }
}
impl GetMlTransformsOutput {
    /// Creates a new builder-style object to manufacture [`GetMlTransformsOutput`](crate::output::GetMlTransformsOutput)
    pub fn builder() -> crate::output::get_ml_transforms_output::Builder {
        crate::output::get_ml_transforms_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMlTransformOutput {
    /// <p>The unique identifier of the transform, generated at the time that the transform was
    /// created.</p>
    pub transform_id: std::option::Option<std::string::String>,
    /// <p>The unique name given to the transform when it was created.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the transform.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The last known status of the transform (to indicate whether it can be used or not). One of "NOT_READY", "READY", or "DELETING".</p>
    pub status: std::option::Option<crate::model::TransformStatusType>,
    /// <p>The date and time when the transform was created.</p>
    pub created_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the transform was last modified.</p>
    pub last_modified_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of Glue table definitions used by the transform.</p>
    pub input_record_tables: std::option::Option<std::vec::Vec<crate::model::GlueTable>>,
    /// <p>The configuration parameters that are specific to the algorithm used.</p>
    pub parameters: std::option::Option<crate::model::TransformParameters>,
    /// <p>The latest evaluation metrics.</p>
    pub evaluation_metrics: std::option::Option<crate::model::EvaluationMetrics>,
    /// <p>The number of labels available for this transform.</p>
    pub label_count: i32,
    /// <p>The <code>Map<Column, Type></code> object that represents the schema that this
    /// transform accepts. Has an upper bound of 100 columns.</p>
    pub schema: std::option::Option<std::vec::Vec<crate::model::SchemaColumn>>,
    /// <p>The name or Amazon Resource Name (ARN) of the IAM role with the required
    /// permissions.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
    pub glue_version: std::option::Option<std::string::String>,
    /// <p>The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
    /// processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
    /// information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
    /// page</a>. </p>
    ///
    /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>
    pub max_capacity: std::option::Option<f64>,
    /// <p>The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.</p>
    /// <ul>
    /// <li>
    /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
    /// </li>
    /// </ul>
    pub worker_type: std::option::Option<crate::model::WorkerType>,
    /// <p>The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>
    pub number_of_workers: std::option::Option<i32>,
    /// <p>The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The maximum number of times to retry a task for this transform after a task run fails.</p>
    pub max_retries: std::option::Option<i32>,
    /// <p>The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can access user data encrypted in Amazon S3 using KMS.</p>
    pub transform_encryption: std::option::Option<crate::model::TransformEncryption>,
}
impl std::fmt::Debug for GetMlTransformOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMlTransformOutput");
        formatter.field("transform_id", &self.transform_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("created_on", &self.created_on);
        formatter.field("last_modified_on", &self.last_modified_on);
        formatter.field("input_record_tables", &self.input_record_tables);
        formatter.field("parameters", &self.parameters);
        formatter.field("evaluation_metrics", &self.evaluation_metrics);
        formatter.field("label_count", &self.label_count);
        formatter.field("schema", &self.schema);
        formatter.field("role", &self.role);
        formatter.field("glue_version", &self.glue_version);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("worker_type", &self.worker_type);
        formatter.field("number_of_workers", &self.number_of_workers);
        formatter.field("timeout", &self.timeout);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("transform_encryption", &self.transform_encryption);
        formatter.finish()
    }
}
/// See [`GetMlTransformOutput`](crate::output::GetMlTransformOutput)
pub mod get_ml_transform_output {
    /// A builder for [`GetMlTransformOutput`](crate::output::GetMlTransformOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TransformStatusType>,
        pub(crate) created_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_record_tables: std::option::Option<std::vec::Vec<crate::model::GlueTable>>,
        pub(crate) parameters: std::option::Option<crate::model::TransformParameters>,
        pub(crate) evaluation_metrics: std::option::Option<crate::model::EvaluationMetrics>,
        pub(crate) label_count: std::option::Option<i32>,
        pub(crate) schema: std::option::Option<std::vec::Vec<crate::model::SchemaColumn>>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) glue_version: std::option::Option<std::string::String>,
        pub(crate) max_capacity: std::option::Option<f64>,
        pub(crate) worker_type: std::option::Option<crate::model::WorkerType>,
        pub(crate) number_of_workers: std::option::Option<i32>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) transform_encryption: std::option::Option<crate::model::TransformEncryption>,
    }
    impl Builder {
        /// <p>The unique identifier of the transform, generated at the time that the transform was
        /// created.</p>
        pub fn transform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the transform, generated at the time that the transform was
        /// created.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.transform_id = input;
            self
        }
        /// <p>The unique name given to the transform when it was created.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name given to the transform when it was created.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the transform.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the transform.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The last known status of the transform (to indicate whether it can be used or not). One of "NOT_READY", "READY", or "DELETING".</p>
        pub fn status(mut self, input: crate::model::TransformStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The last known status of the transform (to indicate whether it can be used or not). One of "NOT_READY", "READY", or "DELETING".</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TransformStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time when the transform was created.</p>
        pub fn created_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_on = Some(input);
            self
        }
        /// <p>The date and time when the transform was created.</p>
        pub fn set_created_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_on = input;
            self
        }
        /// <p>The date and time when the transform was last modified.</p>
        pub fn last_modified_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_on = Some(input);
            self
        }
        /// <p>The date and time when the transform was last modified.</p>
        pub fn set_last_modified_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_on = input;
            self
        }
        /// Appends an item to `input_record_tables`.
        ///
        /// To override the contents of this collection use [`set_input_record_tables`](Self::set_input_record_tables).
        ///
        /// <p>A list of Glue table definitions used by the transform.</p>
        pub fn input_record_tables(mut self, input: impl Into<crate::model::GlueTable>) -> Self {
            let mut v = self.input_record_tables.unwrap_or_default();
            v.push(input.into());
            self.input_record_tables = Some(v);
            self
        }
        /// <p>A list of Glue table definitions used by the transform.</p>
        pub fn set_input_record_tables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlueTable>>,
        ) -> Self {
            self.input_record_tables = input;
            self
        }
        /// <p>The configuration parameters that are specific to the algorithm used.</p>
        pub fn parameters(mut self, input: crate::model::TransformParameters) -> Self {
            self.parameters = Some(input);
            self
        }
        /// <p>The configuration parameters that are specific to the algorithm used.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::TransformParameters>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The latest evaluation metrics.</p>
        pub fn evaluation_metrics(mut self, input: crate::model::EvaluationMetrics) -> Self {
            self.evaluation_metrics = Some(input);
            self
        }
        /// <p>The latest evaluation metrics.</p>
        pub fn set_evaluation_metrics(
            mut self,
            input: std::option::Option<crate::model::EvaluationMetrics>,
        ) -> Self {
            self.evaluation_metrics = input;
            self
        }
        /// <p>The number of labels available for this transform.</p>
        pub fn label_count(mut self, input: i32) -> Self {
            self.label_count = Some(input);
            self
        }
        /// <p>The number of labels available for this transform.</p>
        pub fn set_label_count(mut self, input: std::option::Option<i32>) -> Self {
            self.label_count = input;
            self
        }
        /// Appends an item to `schema`.
        ///
        /// To override the contents of this collection use [`set_schema`](Self::set_schema).
        ///
        /// <p>The <code>Map<Column, Type></code> object that represents the schema that this
        /// transform accepts. Has an upper bound of 100 columns.</p>
        pub fn schema(mut self, input: impl Into<crate::model::SchemaColumn>) -> Self {
            let mut v = self.schema.unwrap_or_default();
            v.push(input.into());
            self.schema = Some(v);
            self
        }
        /// <p>The <code>Map<Column, Type></code> object that represents the schema that this
        /// transform accepts. Has an upper bound of 100 columns.</p>
        pub fn set_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaColumn>>,
        ) -> Self {
            self.schema = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role with the required
        /// permissions.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role with the required
        /// permissions.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
        pub fn glue_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.glue_version = Some(input.into());
            self
        }
        /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.glue_version = input;
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
        /// processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
        /// information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>. </p>
        ///
        /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>
        pub fn max_capacity(mut self, input: f64) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
        /// processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
        /// information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>. </p>
        ///
        /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<f64>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        pub fn worker_type(mut self, input: crate::model::WorkerType) -> Self {
            self.worker_type = Some(input);
            self
        }
        /// <p>The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.worker_type = input;
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>
        pub fn number_of_workers(mut self, input: i32) -> Self {
            self.number_of_workers = Some(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_workers = input;
            self
        }
        /// <p>The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The maximum number of times to retry a task for this transform after a task run fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times to retry a task for this transform after a task run fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// <p>The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can access user data encrypted in Amazon S3 using KMS.</p>
        pub fn transform_encryption(mut self, input: crate::model::TransformEncryption) -> Self {
            self.transform_encryption = Some(input);
            self
        }
        /// <p>The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can access user data encrypted in Amazon S3 using KMS.</p>
        pub fn set_transform_encryption(
            mut self,
            input: std::option::Option<crate::model::TransformEncryption>,
        ) -> Self {
            self.transform_encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMlTransformOutput`](crate::output::GetMlTransformOutput)
        pub fn build(self) -> crate::output::GetMlTransformOutput {
            crate::output::GetMlTransformOutput {
                transform_id: self.transform_id,
                name: self.name,
                description: self.description,
                status: self.status,
                created_on: self.created_on,
                last_modified_on: self.last_modified_on,
                input_record_tables: self.input_record_tables,
                parameters: self.parameters,
                evaluation_metrics: self.evaluation_metrics,
                label_count: self.label_count.unwrap_or_default(),
                schema: self.schema,
                role: self.role,
                glue_version: self.glue_version,
                max_capacity: self.max_capacity,
                worker_type: self.worker_type,
                number_of_workers: self.number_of_workers,
                timeout: self.timeout,
                max_retries: self.max_retries,
                transform_encryption: self.transform_encryption,
            }
        }
    }
}
impl GetMlTransformOutput {
    /// Creates a new builder-style object to manufacture [`GetMlTransformOutput`](crate::output::GetMlTransformOutput)
    pub fn builder() -> crate::output::get_ml_transform_output::Builder {
        crate::output::get_ml_transform_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMlTaskRunsOutput {
    /// <p>A list of task runs that are associated with the transform.</p>
    pub task_runs: std::option::Option<std::vec::Vec<crate::model::TaskRun>>,
    /// <p>A pagination token, if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetMlTaskRunsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMlTaskRunsOutput");
        formatter.field("task_runs", &self.task_runs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetMlTaskRunsOutput`](crate::output::GetMlTaskRunsOutput)
pub mod get_ml_task_runs_output {
    /// A builder for [`GetMlTaskRunsOutput`](crate::output::GetMlTaskRunsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_runs: std::option::Option<std::vec::Vec<crate::model::TaskRun>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `task_runs`.
        ///
        /// To override the contents of this collection use [`set_task_runs`](Self::set_task_runs).
        ///
        /// <p>A list of task runs that are associated with the transform.</p>
        pub fn task_runs(mut self, input: impl Into<crate::model::TaskRun>) -> Self {
            let mut v = self.task_runs.unwrap_or_default();
            v.push(input.into());
            self.task_runs = Some(v);
            self
        }
        /// <p>A list of task runs that are associated with the transform.</p>
        pub fn set_task_runs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskRun>>,
        ) -> Self {
            self.task_runs = input;
            self
        }
        /// <p>A pagination token, if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token, if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMlTaskRunsOutput`](crate::output::GetMlTaskRunsOutput)
        pub fn build(self) -> crate::output::GetMlTaskRunsOutput {
            crate::output::GetMlTaskRunsOutput {
                task_runs: self.task_runs,
                next_token: self.next_token,
            }
        }
    }
}
impl GetMlTaskRunsOutput {
    /// Creates a new builder-style object to manufacture [`GetMlTaskRunsOutput`](crate::output::GetMlTaskRunsOutput)
    pub fn builder() -> crate::output::get_ml_task_runs_output::Builder {
        crate::output::get_ml_task_runs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMlTaskRunOutput {
    /// <p>The unique identifier of the task run.</p>
    pub transform_id: std::option::Option<std::string::String>,
    /// <p>The unique run identifier associated with this run.</p>
    pub task_run_id: std::option::Option<std::string::String>,
    /// <p>The status for this task run.</p>
    pub status: std::option::Option<crate::model::TaskStatusType>,
    /// <p>The names of the log groups that are associated with the task run.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>The list of properties that are associated with the task run.</p>
    pub properties: std::option::Option<crate::model::TaskRunProperties>,
    /// <p>The error strings that are associated with the task run.</p>
    pub error_string: std::option::Option<std::string::String>,
    /// <p>The date and time when this task run started.</p>
    pub started_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when this task run was last modified.</p>
    pub last_modified_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when this task run was completed.</p>
    pub completed_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The amount of time (in seconds) that the task run consumed resources.</p>
    pub execution_time: i32,
}
impl std::fmt::Debug for GetMlTaskRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMlTaskRunOutput");
        formatter.field("transform_id", &self.transform_id);
        formatter.field("task_run_id", &self.task_run_id);
        formatter.field("status", &self.status);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("properties", &self.properties);
        formatter.field("error_string", &self.error_string);
        formatter.field("started_on", &self.started_on);
        formatter.field("last_modified_on", &self.last_modified_on);
        formatter.field("completed_on", &self.completed_on);
        formatter.field("execution_time", &self.execution_time);
        formatter.finish()
    }
}
/// See [`GetMlTaskRunOutput`](crate::output::GetMlTaskRunOutput)
pub mod get_ml_task_run_output {
    /// A builder for [`GetMlTaskRunOutput`](crate::output::GetMlTaskRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_id: std::option::Option<std::string::String>,
        pub(crate) task_run_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TaskStatusType>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<crate::model::TaskRunProperties>,
        pub(crate) error_string: std::option::Option<std::string::String>,
        pub(crate) started_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) execution_time: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the task run.</p>
        pub fn transform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the task run.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.transform_id = input;
            self
        }
        /// <p>The unique run identifier associated with this run.</p>
        pub fn task_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_run_id = Some(input.into());
            self
        }
        /// <p>The unique run identifier associated with this run.</p>
        pub fn set_task_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_run_id = input;
            self
        }
        /// <p>The status for this task run.</p>
        pub fn status(mut self, input: crate::model::TaskStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status for this task run.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The names of the log groups that are associated with the task run.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The names of the log groups that are associated with the task run.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// <p>The list of properties that are associated with the task run.</p>
        pub fn properties(mut self, input: crate::model::TaskRunProperties) -> Self {
            self.properties = Some(input);
            self
        }
        /// <p>The list of properties that are associated with the task run.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<crate::model::TaskRunProperties>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// <p>The error strings that are associated with the task run.</p>
        pub fn error_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_string = Some(input.into());
            self
        }
        /// <p>The error strings that are associated with the task run.</p>
        pub fn set_error_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_string = input;
            self
        }
        /// <p>The date and time when this task run started.</p>
        pub fn started_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_on = Some(input);
            self
        }
        /// <p>The date and time when this task run started.</p>
        pub fn set_started_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_on = input;
            self
        }
        /// <p>The date and time when this task run was last modified.</p>
        pub fn last_modified_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_on = Some(input);
            self
        }
        /// <p>The date and time when this task run was last modified.</p>
        pub fn set_last_modified_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_on = input;
            self
        }
        /// <p>The date and time when this task run was completed.</p>
        pub fn completed_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_on = Some(input);
            self
        }
        /// <p>The date and time when this task run was completed.</p>
        pub fn set_completed_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_on = input;
            self
        }
        /// <p>The amount of time (in seconds) that the task run consumed resources.</p>
        pub fn execution_time(mut self, input: i32) -> Self {
            self.execution_time = Some(input);
            self
        }
        /// <p>The amount of time (in seconds) that the task run consumed resources.</p>
        pub fn set_execution_time(mut self, input: std::option::Option<i32>) -> Self {
            self.execution_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMlTaskRunOutput`](crate::output::GetMlTaskRunOutput)
        pub fn build(self) -> crate::output::GetMlTaskRunOutput {
            crate::output::GetMlTaskRunOutput {
                transform_id: self.transform_id,
                task_run_id: self.task_run_id,
                status: self.status,
                log_group_name: self.log_group_name,
                properties: self.properties,
                error_string: self.error_string,
                started_on: self.started_on,
                last_modified_on: self.last_modified_on,
                completed_on: self.completed_on,
                execution_time: self.execution_time.unwrap_or_default(),
            }
        }
    }
}
impl GetMlTaskRunOutput {
    /// Creates a new builder-style object to manufacture [`GetMlTaskRunOutput`](crate::output::GetMlTaskRunOutput)
    pub fn builder() -> crate::output::get_ml_task_run_output::Builder {
        crate::output::get_ml_task_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMappingOutput {
    /// <p>A list of mappings to the specified targets.</p>
    pub mapping: std::option::Option<std::vec::Vec<crate::model::MappingEntry>>,
}
impl std::fmt::Debug for GetMappingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMappingOutput");
        formatter.field("mapping", &self.mapping);
        formatter.finish()
    }
}
/// See [`GetMappingOutput`](crate::output::GetMappingOutput)
pub mod get_mapping_output {
    /// A builder for [`GetMappingOutput`](crate::output::GetMappingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mapping: std::option::Option<std::vec::Vec<crate::model::MappingEntry>>,
    }
    impl Builder {
        /// Appends an item to `mapping`.
        ///
        /// To override the contents of this collection use [`set_mapping`](Self::set_mapping).
        ///
        /// <p>A list of mappings to the specified targets.</p>
        pub fn mapping(mut self, input: impl Into<crate::model::MappingEntry>) -> Self {
            let mut v = self.mapping.unwrap_or_default();
            v.push(input.into());
            self.mapping = Some(v);
            self
        }
        /// <p>A list of mappings to the specified targets.</p>
        pub fn set_mapping(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MappingEntry>>,
        ) -> Self {
            self.mapping = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMappingOutput`](crate::output::GetMappingOutput)
        pub fn build(self) -> crate::output::GetMappingOutput {
            crate::output::GetMappingOutput {
                mapping: self.mapping,
            }
        }
    }
}
impl GetMappingOutput {
    /// Creates a new builder-style object to manufacture [`GetMappingOutput`](crate::output::GetMappingOutput)
    pub fn builder() -> crate::output::get_mapping_output::Builder {
        crate::output::get_mapping_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobsOutput {
    /// <p>A list of job definitions.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
    /// <p>A continuation token, if not all job definitions have yet been returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetJobsOutput`](crate::output::GetJobsOutput)
pub mod get_jobs_output {
    /// A builder for [`GetJobsOutput`](crate::output::GetJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>A list of job definitions.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::Job>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>A list of job definitions.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// <p>A continuation token, if not all job definitions have yet been returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if not all job definitions have yet been returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobsOutput`](crate::output::GetJobsOutput)
        pub fn build(self) -> crate::output::GetJobsOutput {
            crate::output::GetJobsOutput {
                jobs: self.jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl GetJobsOutput {
    /// Creates a new builder-style object to manufacture [`GetJobsOutput`](crate::output::GetJobsOutput)
    pub fn builder() -> crate::output::get_jobs_output::Builder {
        crate::output::get_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobRunsOutput {
    /// <p>A list of job-run metadata objects.</p>
    pub job_runs: std::option::Option<std::vec::Vec<crate::model::JobRun>>,
    /// <p>A continuation token, if not all requested job runs have been returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetJobRunsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobRunsOutput");
        formatter.field("job_runs", &self.job_runs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetJobRunsOutput`](crate::output::GetJobRunsOutput)
pub mod get_job_runs_output {
    /// A builder for [`GetJobRunsOutput`](crate::output::GetJobRunsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_runs: std::option::Option<std::vec::Vec<crate::model::JobRun>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_runs`.
        ///
        /// To override the contents of this collection use [`set_job_runs`](Self::set_job_runs).
        ///
        /// <p>A list of job-run metadata objects.</p>
        pub fn job_runs(mut self, input: impl Into<crate::model::JobRun>) -> Self {
            let mut v = self.job_runs.unwrap_or_default();
            v.push(input.into());
            self.job_runs = Some(v);
            self
        }
        /// <p>A list of job-run metadata objects.</p>
        pub fn set_job_runs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobRun>>,
        ) -> Self {
            self.job_runs = input;
            self
        }
        /// <p>A continuation token, if not all requested job runs have been returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if not all requested job runs have been returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobRunsOutput`](crate::output::GetJobRunsOutput)
        pub fn build(self) -> crate::output::GetJobRunsOutput {
            crate::output::GetJobRunsOutput {
                job_runs: self.job_runs,
                next_token: self.next_token,
            }
        }
    }
}
impl GetJobRunsOutput {
    /// Creates a new builder-style object to manufacture [`GetJobRunsOutput`](crate::output::GetJobRunsOutput)
    pub fn builder() -> crate::output::get_job_runs_output::Builder {
        crate::output::get_job_runs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobRunOutput {
    /// <p>The requested job-run metadata.</p>
    pub job_run: std::option::Option<crate::model::JobRun>,
}
impl std::fmt::Debug for GetJobRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobRunOutput");
        formatter.field("job_run", &self.job_run);
        formatter.finish()
    }
}
/// See [`GetJobRunOutput`](crate::output::GetJobRunOutput)
pub mod get_job_run_output {
    /// A builder for [`GetJobRunOutput`](crate::output::GetJobRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_run: std::option::Option<crate::model::JobRun>,
    }
    impl Builder {
        /// <p>The requested job-run metadata.</p>
        pub fn job_run(mut self, input: crate::model::JobRun) -> Self {
            self.job_run = Some(input);
            self
        }
        /// <p>The requested job-run metadata.</p>
        pub fn set_job_run(mut self, input: std::option::Option<crate::model::JobRun>) -> Self {
            self.job_run = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobRunOutput`](crate::output::GetJobRunOutput)
        pub fn build(self) -> crate::output::GetJobRunOutput {
            crate::output::GetJobRunOutput {
                job_run: self.job_run,
            }
        }
    }
}
impl GetJobRunOutput {
    /// Creates a new builder-style object to manufacture [`GetJobRunOutput`](crate::output::GetJobRunOutput)
    pub fn builder() -> crate::output::get_job_run_output::Builder {
        crate::output::get_job_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobBookmarkOutput {
    /// <p>A structure that defines a point that a job can resume processing.</p>
    pub job_bookmark_entry: std::option::Option<crate::model::JobBookmarkEntry>,
}
impl std::fmt::Debug for GetJobBookmarkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobBookmarkOutput");
        formatter.field("job_bookmark_entry", &self.job_bookmark_entry);
        formatter.finish()
    }
}
/// See [`GetJobBookmarkOutput`](crate::output::GetJobBookmarkOutput)
pub mod get_job_bookmark_output {
    /// A builder for [`GetJobBookmarkOutput`](crate::output::GetJobBookmarkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_bookmark_entry: std::option::Option<crate::model::JobBookmarkEntry>,
    }
    impl Builder {
        /// <p>A structure that defines a point that a job can resume processing.</p>
        pub fn job_bookmark_entry(mut self, input: crate::model::JobBookmarkEntry) -> Self {
            self.job_bookmark_entry = Some(input);
            self
        }
        /// <p>A structure that defines a point that a job can resume processing.</p>
        pub fn set_job_bookmark_entry(
            mut self,
            input: std::option::Option<crate::model::JobBookmarkEntry>,
        ) -> Self {
            self.job_bookmark_entry = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobBookmarkOutput`](crate::output::GetJobBookmarkOutput)
        pub fn build(self) -> crate::output::GetJobBookmarkOutput {
            crate::output::GetJobBookmarkOutput {
                job_bookmark_entry: self.job_bookmark_entry,
            }
        }
    }
}
impl GetJobBookmarkOutput {
    /// Creates a new builder-style object to manufacture [`GetJobBookmarkOutput`](crate::output::GetJobBookmarkOutput)
    pub fn builder() -> crate::output::get_job_bookmark_output::Builder {
        crate::output::get_job_bookmark_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobOutput {
    /// <p>The requested job definition.</p>
    pub job: std::option::Option<crate::model::Job>,
}
impl std::fmt::Debug for GetJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`GetJobOutput`](crate::output::GetJobOutput)
pub mod get_job_output {
    /// A builder for [`GetJobOutput`](crate::output::GetJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// <p>The requested job definition.</p>
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>The requested job definition.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobOutput`](crate::output::GetJobOutput)
        pub fn build(self) -> crate::output::GetJobOutput {
            crate::output::GetJobOutput { job: self.job }
        }
    }
}
impl GetJobOutput {
    /// Creates a new builder-style object to manufacture [`GetJobOutput`](crate::output::GetJobOutput)
    pub fn builder() -> crate::output::get_job_output::Builder {
        crate::output::get_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevEndpointsOutput {
    /// <p>A list of <code>DevEndpoint</code> definitions.</p>
    pub dev_endpoints: std::option::Option<std::vec::Vec<crate::model::DevEndpoint>>,
    /// <p>A continuation token, if not all <code>DevEndpoint</code> definitions have yet been
    /// returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDevEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevEndpointsOutput");
        formatter.field("dev_endpoints", &self.dev_endpoints);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDevEndpointsOutput`](crate::output::GetDevEndpointsOutput)
pub mod get_dev_endpoints_output {
    /// A builder for [`GetDevEndpointsOutput`](crate::output::GetDevEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dev_endpoints: std::option::Option<std::vec::Vec<crate::model::DevEndpoint>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dev_endpoints`.
        ///
        /// To override the contents of this collection use [`set_dev_endpoints`](Self::set_dev_endpoints).
        ///
        /// <p>A list of <code>DevEndpoint</code> definitions.</p>
        pub fn dev_endpoints(mut self, input: impl Into<crate::model::DevEndpoint>) -> Self {
            let mut v = self.dev_endpoints.unwrap_or_default();
            v.push(input.into());
            self.dev_endpoints = Some(v);
            self
        }
        /// <p>A list of <code>DevEndpoint</code> definitions.</p>
        pub fn set_dev_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevEndpoint>>,
        ) -> Self {
            self.dev_endpoints = input;
            self
        }
        /// <p>A continuation token, if not all <code>DevEndpoint</code> definitions have yet been
        /// returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if not all <code>DevEndpoint</code> definitions have yet been
        /// returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevEndpointsOutput`](crate::output::GetDevEndpointsOutput)
        pub fn build(self) -> crate::output::GetDevEndpointsOutput {
            crate::output::GetDevEndpointsOutput {
                dev_endpoints: self.dev_endpoints,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDevEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`GetDevEndpointsOutput`](crate::output::GetDevEndpointsOutput)
    pub fn builder() -> crate::output::get_dev_endpoints_output::Builder {
        crate::output::get_dev_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevEndpointOutput {
    /// <p>A <code>DevEndpoint</code> definition.</p>
    pub dev_endpoint: std::option::Option<crate::model::DevEndpoint>,
}
impl std::fmt::Debug for GetDevEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevEndpointOutput");
        formatter.field("dev_endpoint", &self.dev_endpoint);
        formatter.finish()
    }
}
/// See [`GetDevEndpointOutput`](crate::output::GetDevEndpointOutput)
pub mod get_dev_endpoint_output {
    /// A builder for [`GetDevEndpointOutput`](crate::output::GetDevEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dev_endpoint: std::option::Option<crate::model::DevEndpoint>,
    }
    impl Builder {
        /// <p>A <code>DevEndpoint</code> definition.</p>
        pub fn dev_endpoint(mut self, input: crate::model::DevEndpoint) -> Self {
            self.dev_endpoint = Some(input);
            self
        }
        /// <p>A <code>DevEndpoint</code> definition.</p>
        pub fn set_dev_endpoint(
            mut self,
            input: std::option::Option<crate::model::DevEndpoint>,
        ) -> Self {
            self.dev_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevEndpointOutput`](crate::output::GetDevEndpointOutput)
        pub fn build(self) -> crate::output::GetDevEndpointOutput {
            crate::output::GetDevEndpointOutput {
                dev_endpoint: self.dev_endpoint,
            }
        }
    }
}
impl GetDevEndpointOutput {
    /// Creates a new builder-style object to manufacture [`GetDevEndpointOutput`](crate::output::GetDevEndpointOutput)
    pub fn builder() -> crate::output::get_dev_endpoint_output::Builder {
        crate::output::get_dev_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataflowGraphOutput {
    /// <p>A list of the nodes in the resulting DAG.</p>
    pub dag_nodes: std::option::Option<std::vec::Vec<crate::model::CodeGenNode>>,
    /// <p>A list of the edges in the resulting DAG.</p>
    pub dag_edges: std::option::Option<std::vec::Vec<crate::model::CodeGenEdge>>,
}
impl std::fmt::Debug for GetDataflowGraphOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataflowGraphOutput");
        formatter.field("dag_nodes", &self.dag_nodes);
        formatter.field("dag_edges", &self.dag_edges);
        formatter.finish()
    }
}
/// See [`GetDataflowGraphOutput`](crate::output::GetDataflowGraphOutput)
pub mod get_dataflow_graph_output {
    /// A builder for [`GetDataflowGraphOutput`](crate::output::GetDataflowGraphOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dag_nodes: std::option::Option<std::vec::Vec<crate::model::CodeGenNode>>,
        pub(crate) dag_edges: std::option::Option<std::vec::Vec<crate::model::CodeGenEdge>>,
    }
    impl Builder {
        /// Appends an item to `dag_nodes`.
        ///
        /// To override the contents of this collection use [`set_dag_nodes`](Self::set_dag_nodes).
        ///
        /// <p>A list of the nodes in the resulting DAG.</p>
        pub fn dag_nodes(mut self, input: impl Into<crate::model::CodeGenNode>) -> Self {
            let mut v = self.dag_nodes.unwrap_or_default();
            v.push(input.into());
            self.dag_nodes = Some(v);
            self
        }
        /// <p>A list of the nodes in the resulting DAG.</p>
        pub fn set_dag_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeGenNode>>,
        ) -> Self {
            self.dag_nodes = input;
            self
        }
        /// Appends an item to `dag_edges`.
        ///
        /// To override the contents of this collection use [`set_dag_edges`](Self::set_dag_edges).
        ///
        /// <p>A list of the edges in the resulting DAG.</p>
        pub fn dag_edges(mut self, input: impl Into<crate::model::CodeGenEdge>) -> Self {
            let mut v = self.dag_edges.unwrap_or_default();
            v.push(input.into());
            self.dag_edges = Some(v);
            self
        }
        /// <p>A list of the edges in the resulting DAG.</p>
        pub fn set_dag_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeGenEdge>>,
        ) -> Self {
            self.dag_edges = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataflowGraphOutput`](crate::output::GetDataflowGraphOutput)
        pub fn build(self) -> crate::output::GetDataflowGraphOutput {
            crate::output::GetDataflowGraphOutput {
                dag_nodes: self.dag_nodes,
                dag_edges: self.dag_edges,
            }
        }
    }
}
impl GetDataflowGraphOutput {
    /// Creates a new builder-style object to manufacture [`GetDataflowGraphOutput`](crate::output::GetDataflowGraphOutput)
    pub fn builder() -> crate::output::get_dataflow_graph_output::Builder {
        crate::output::get_dataflow_graph_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataCatalogEncryptionSettingsOutput {
    /// <p>The requested security configuration.</p>
    pub data_catalog_encryption_settings:
        std::option::Option<crate::model::DataCatalogEncryptionSettings>,
}
impl std::fmt::Debug for GetDataCatalogEncryptionSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataCatalogEncryptionSettingsOutput");
        formatter.field(
            "data_catalog_encryption_settings",
            &self.data_catalog_encryption_settings,
        );
        formatter.finish()
    }
}
/// See [`GetDataCatalogEncryptionSettingsOutput`](crate::output::GetDataCatalogEncryptionSettingsOutput)
pub mod get_data_catalog_encryption_settings_output {
    /// A builder for [`GetDataCatalogEncryptionSettingsOutput`](crate::output::GetDataCatalogEncryptionSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_catalog_encryption_settings:
            std::option::Option<crate::model::DataCatalogEncryptionSettings>,
    }
    impl Builder {
        /// <p>The requested security configuration.</p>
        pub fn data_catalog_encryption_settings(
            mut self,
            input: crate::model::DataCatalogEncryptionSettings,
        ) -> Self {
            self.data_catalog_encryption_settings = Some(input);
            self
        }
        /// <p>The requested security configuration.</p>
        pub fn set_data_catalog_encryption_settings(
            mut self,
            input: std::option::Option<crate::model::DataCatalogEncryptionSettings>,
        ) -> Self {
            self.data_catalog_encryption_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataCatalogEncryptionSettingsOutput`](crate::output::GetDataCatalogEncryptionSettingsOutput)
        pub fn build(self) -> crate::output::GetDataCatalogEncryptionSettingsOutput {
            crate::output::GetDataCatalogEncryptionSettingsOutput {
                data_catalog_encryption_settings: self.data_catalog_encryption_settings,
            }
        }
    }
}
impl GetDataCatalogEncryptionSettingsOutput {
    /// Creates a new builder-style object to manufacture [`GetDataCatalogEncryptionSettingsOutput`](crate::output::GetDataCatalogEncryptionSettingsOutput)
    pub fn builder() -> crate::output::get_data_catalog_encryption_settings_output::Builder {
        crate::output::get_data_catalog_encryption_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDatabasesOutput {
    /// <p>A list of <code>Database</code> objects from the specified catalog.</p>
    pub database_list: std::option::Option<std::vec::Vec<crate::model::Database>>,
    /// <p>A continuation token for paginating the returned list of tokens,
    /// returned if the current segment of the list is not the last.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDatabasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDatabasesOutput");
        formatter.field("database_list", &self.database_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDatabasesOutput`](crate::output::GetDatabasesOutput)
pub mod get_databases_output {
    /// A builder for [`GetDatabasesOutput`](crate::output::GetDatabasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_list: std::option::Option<std::vec::Vec<crate::model::Database>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `database_list`.
        ///
        /// To override the contents of this collection use [`set_database_list`](Self::set_database_list).
        ///
        /// <p>A list of <code>Database</code> objects from the specified catalog.</p>
        pub fn database_list(mut self, input: impl Into<crate::model::Database>) -> Self {
            let mut v = self.database_list.unwrap_or_default();
            v.push(input.into());
            self.database_list = Some(v);
            self
        }
        /// <p>A list of <code>Database</code> objects from the specified catalog.</p>
        pub fn set_database_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Database>>,
        ) -> Self {
            self.database_list = input;
            self
        }
        /// <p>A continuation token for paginating the returned list of tokens,
        /// returned if the current segment of the list is not the last.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token for paginating the returned list of tokens,
        /// returned if the current segment of the list is not the last.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDatabasesOutput`](crate::output::GetDatabasesOutput)
        pub fn build(self) -> crate::output::GetDatabasesOutput {
            crate::output::GetDatabasesOutput {
                database_list: self.database_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDatabasesOutput {
    /// Creates a new builder-style object to manufacture [`GetDatabasesOutput`](crate::output::GetDatabasesOutput)
    pub fn builder() -> crate::output::get_databases_output::Builder {
        crate::output::get_databases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDatabaseOutput {
    /// <p>The definition of the specified database in the Data Catalog.</p>
    pub database: std::option::Option<crate::model::Database>,
}
impl std::fmt::Debug for GetDatabaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDatabaseOutput");
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`GetDatabaseOutput`](crate::output::GetDatabaseOutput)
pub mod get_database_output {
    /// A builder for [`GetDatabaseOutput`](crate::output::GetDatabaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database: std::option::Option<crate::model::Database>,
    }
    impl Builder {
        /// <p>The definition of the specified database in the Data Catalog.</p>
        pub fn database(mut self, input: crate::model::Database) -> Self {
            self.database = Some(input);
            self
        }
        /// <p>The definition of the specified database in the Data Catalog.</p>
        pub fn set_database(mut self, input: std::option::Option<crate::model::Database>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDatabaseOutput`](crate::output::GetDatabaseOutput)
        pub fn build(self) -> crate::output::GetDatabaseOutput {
            crate::output::GetDatabaseOutput {
                database: self.database,
            }
        }
    }
}
impl GetDatabaseOutput {
    /// Creates a new builder-style object to manufacture [`GetDatabaseOutput`](crate::output::GetDatabaseOutput)
    pub fn builder() -> crate::output::get_database_output::Builder {
        crate::output::get_database_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCrawlersOutput {
    /// <p>A list of crawler metadata.</p>
    pub crawlers: std::option::Option<std::vec::Vec<crate::model::Crawler>>,
    /// <p>A continuation token, if the returned list has not reached the end
    /// of those defined in this customer account.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCrawlersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCrawlersOutput");
        formatter.field("crawlers", &self.crawlers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetCrawlersOutput`](crate::output::GetCrawlersOutput)
pub mod get_crawlers_output {
    /// A builder for [`GetCrawlersOutput`](crate::output::GetCrawlersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawlers: std::option::Option<std::vec::Vec<crate::model::Crawler>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `crawlers`.
        ///
        /// To override the contents of this collection use [`set_crawlers`](Self::set_crawlers).
        ///
        /// <p>A list of crawler metadata.</p>
        pub fn crawlers(mut self, input: impl Into<crate::model::Crawler>) -> Self {
            let mut v = self.crawlers.unwrap_or_default();
            v.push(input.into());
            self.crawlers = Some(v);
            self
        }
        /// <p>A list of crawler metadata.</p>
        pub fn set_crawlers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Crawler>>,
        ) -> Self {
            self.crawlers = input;
            self
        }
        /// <p>A continuation token, if the returned list has not reached the end
        /// of those defined in this customer account.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the returned list has not reached the end
        /// of those defined in this customer account.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCrawlersOutput`](crate::output::GetCrawlersOutput)
        pub fn build(self) -> crate::output::GetCrawlersOutput {
            crate::output::GetCrawlersOutput {
                crawlers: self.crawlers,
                next_token: self.next_token,
            }
        }
    }
}
impl GetCrawlersOutput {
    /// Creates a new builder-style object to manufacture [`GetCrawlersOutput`](crate::output::GetCrawlersOutput)
    pub fn builder() -> crate::output::get_crawlers_output::Builder {
        crate::output::get_crawlers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCrawlerMetricsOutput {
    /// <p>A list of metrics for the specified crawler.</p>
    pub crawler_metrics_list: std::option::Option<std::vec::Vec<crate::model::CrawlerMetrics>>,
    /// <p>A continuation token, if the returned list does not contain the
    /// last metric available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCrawlerMetricsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCrawlerMetricsOutput");
        formatter.field("crawler_metrics_list", &self.crawler_metrics_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetCrawlerMetricsOutput`](crate::output::GetCrawlerMetricsOutput)
pub mod get_crawler_metrics_output {
    /// A builder for [`GetCrawlerMetricsOutput`](crate::output::GetCrawlerMetricsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawler_metrics_list:
            std::option::Option<std::vec::Vec<crate::model::CrawlerMetrics>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `crawler_metrics_list`.
        ///
        /// To override the contents of this collection use [`set_crawler_metrics_list`](Self::set_crawler_metrics_list).
        ///
        /// <p>A list of metrics for the specified crawler.</p>
        pub fn crawler_metrics_list(
            mut self,
            input: impl Into<crate::model::CrawlerMetrics>,
        ) -> Self {
            let mut v = self.crawler_metrics_list.unwrap_or_default();
            v.push(input.into());
            self.crawler_metrics_list = Some(v);
            self
        }
        /// <p>A list of metrics for the specified crawler.</p>
        pub fn set_crawler_metrics_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CrawlerMetrics>>,
        ) -> Self {
            self.crawler_metrics_list = input;
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the returned list does not contain the
        /// last metric available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCrawlerMetricsOutput`](crate::output::GetCrawlerMetricsOutput)
        pub fn build(self) -> crate::output::GetCrawlerMetricsOutput {
            crate::output::GetCrawlerMetricsOutput {
                crawler_metrics_list: self.crawler_metrics_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetCrawlerMetricsOutput {
    /// Creates a new builder-style object to manufacture [`GetCrawlerMetricsOutput`](crate::output::GetCrawlerMetricsOutput)
    pub fn builder() -> crate::output::get_crawler_metrics_output::Builder {
        crate::output::get_crawler_metrics_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCrawlerOutput {
    /// <p>The metadata for the specified crawler.</p>
    pub crawler: std::option::Option<crate::model::Crawler>,
}
impl std::fmt::Debug for GetCrawlerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCrawlerOutput");
        formatter.field("crawler", &self.crawler);
        formatter.finish()
    }
}
/// See [`GetCrawlerOutput`](crate::output::GetCrawlerOutput)
pub mod get_crawler_output {
    /// A builder for [`GetCrawlerOutput`](crate::output::GetCrawlerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawler: std::option::Option<crate::model::Crawler>,
    }
    impl Builder {
        /// <p>The metadata for the specified crawler.</p>
        pub fn crawler(mut self, input: crate::model::Crawler) -> Self {
            self.crawler = Some(input);
            self
        }
        /// <p>The metadata for the specified crawler.</p>
        pub fn set_crawler(mut self, input: std::option::Option<crate::model::Crawler>) -> Self {
            self.crawler = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCrawlerOutput`](crate::output::GetCrawlerOutput)
        pub fn build(self) -> crate::output::GetCrawlerOutput {
            crate::output::GetCrawlerOutput {
                crawler: self.crawler,
            }
        }
    }
}
impl GetCrawlerOutput {
    /// Creates a new builder-style object to manufacture [`GetCrawlerOutput`](crate::output::GetCrawlerOutput)
    pub fn builder() -> crate::output::get_crawler_output::Builder {
        crate::output::get_crawler_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectionsOutput {
    /// <p>A list of requested connection definitions.</p>
    pub connection_list: std::option::Option<std::vec::Vec<crate::model::Connection>>,
    /// <p>A continuation token, if the list of connections returned does not
    /// include the last of the filtered connections.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectionsOutput");
        formatter.field("connection_list", &self.connection_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
pub mod get_connections_output {
    /// A builder for [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_list: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connection_list`.
        ///
        /// To override the contents of this collection use [`set_connection_list`](Self::set_connection_list).
        ///
        /// <p>A list of requested connection definitions.</p>
        pub fn connection_list(mut self, input: impl Into<crate::model::Connection>) -> Self {
            let mut v = self.connection_list.unwrap_or_default();
            v.push(input.into());
            self.connection_list = Some(v);
            self
        }
        /// <p>A list of requested connection definitions.</p>
        pub fn set_connection_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Connection>>,
        ) -> Self {
            self.connection_list = input;
            self
        }
        /// <p>A continuation token, if the list of connections returned does not
        /// include the last of the filtered connections.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if the list of connections returned does not
        /// include the last of the filtered connections.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
        pub fn build(self) -> crate::output::GetConnectionsOutput {
            crate::output::GetConnectionsOutput {
                connection_list: self.connection_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`GetConnectionsOutput`](crate::output::GetConnectionsOutput)
    pub fn builder() -> crate::output::get_connections_output::Builder {
        crate::output::get_connections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectionOutput {
    /// <p>The requested connection definition.</p>
    pub connection: std::option::Option<crate::model::Connection>,
}
impl std::fmt::Debug for GetConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`GetConnectionOutput`](crate::output::GetConnectionOutput)
pub mod get_connection_output {
    /// A builder for [`GetConnectionOutput`](crate::output::GetConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::Connection>,
    }
    impl Builder {
        /// <p>The requested connection definition.</p>
        pub fn connection(mut self, input: crate::model::Connection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>The requested connection definition.</p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::Connection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectionOutput`](crate::output::GetConnectionOutput)
        pub fn build(self) -> crate::output::GetConnectionOutput {
            crate::output::GetConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl GetConnectionOutput {
    /// Creates a new builder-style object to manufacture [`GetConnectionOutput`](crate::output::GetConnectionOutput)
    pub fn builder() -> crate::output::get_connection_output::Builder {
        crate::output::get_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetColumnStatisticsForTableOutput {
    /// <p>List of ColumnStatistics that failed to be retrieved.</p>
    pub column_statistics_list: std::option::Option<std::vec::Vec<crate::model::ColumnStatistics>>,
    /// <p>List of ColumnStatistics that failed to be retrieved.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::ColumnError>>,
}
impl std::fmt::Debug for GetColumnStatisticsForTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetColumnStatisticsForTableOutput");
        formatter.field("column_statistics_list", &self.column_statistics_list);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`GetColumnStatisticsForTableOutput`](crate::output::GetColumnStatisticsForTableOutput)
pub mod get_column_statistics_for_table_output {
    /// A builder for [`GetColumnStatisticsForTableOutput`](crate::output::GetColumnStatisticsForTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_statistics_list:
            std::option::Option<std::vec::Vec<crate::model::ColumnStatistics>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::ColumnError>>,
    }
    impl Builder {
        /// Appends an item to `column_statistics_list`.
        ///
        /// To override the contents of this collection use [`set_column_statistics_list`](Self::set_column_statistics_list).
        ///
        /// <p>List of ColumnStatistics that failed to be retrieved.</p>
        pub fn column_statistics_list(
            mut self,
            input: impl Into<crate::model::ColumnStatistics>,
        ) -> Self {
            let mut v = self.column_statistics_list.unwrap_or_default();
            v.push(input.into());
            self.column_statistics_list = Some(v);
            self
        }
        /// <p>List of ColumnStatistics that failed to be retrieved.</p>
        pub fn set_column_statistics_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnStatistics>>,
        ) -> Self {
            self.column_statistics_list = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>List of ColumnStatistics that failed to be retrieved.</p>
        pub fn errors(mut self, input: impl Into<crate::model::ColumnError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>List of ColumnStatistics that failed to be retrieved.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`GetColumnStatisticsForTableOutput`](crate::output::GetColumnStatisticsForTableOutput)
        pub fn build(self) -> crate::output::GetColumnStatisticsForTableOutput {
            crate::output::GetColumnStatisticsForTableOutput {
                column_statistics_list: self.column_statistics_list,
                errors: self.errors,
            }
        }
    }
}
impl GetColumnStatisticsForTableOutput {
    /// Creates a new builder-style object to manufacture [`GetColumnStatisticsForTableOutput`](crate::output::GetColumnStatisticsForTableOutput)
    pub fn builder() -> crate::output::get_column_statistics_for_table_output::Builder {
        crate::output::get_column_statistics_for_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetColumnStatisticsForPartitionOutput {
    /// <p>List of ColumnStatistics that failed to be retrieved.</p>
    pub column_statistics_list: std::option::Option<std::vec::Vec<crate::model::ColumnStatistics>>,
    /// <p>Error occurred during retrieving column statistics data.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::ColumnError>>,
}
impl std::fmt::Debug for GetColumnStatisticsForPartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetColumnStatisticsForPartitionOutput");
        formatter.field("column_statistics_list", &self.column_statistics_list);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`GetColumnStatisticsForPartitionOutput`](crate::output::GetColumnStatisticsForPartitionOutput)
pub mod get_column_statistics_for_partition_output {
    /// A builder for [`GetColumnStatisticsForPartitionOutput`](crate::output::GetColumnStatisticsForPartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_statistics_list:
            std::option::Option<std::vec::Vec<crate::model::ColumnStatistics>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::ColumnError>>,
    }
    impl Builder {
        /// Appends an item to `column_statistics_list`.
        ///
        /// To override the contents of this collection use [`set_column_statistics_list`](Self::set_column_statistics_list).
        ///
        /// <p>List of ColumnStatistics that failed to be retrieved.</p>
        pub fn column_statistics_list(
            mut self,
            input: impl Into<crate::model::ColumnStatistics>,
        ) -> Self {
            let mut v = self.column_statistics_list.unwrap_or_default();
            v.push(input.into());
            self.column_statistics_list = Some(v);
            self
        }
        /// <p>List of ColumnStatistics that failed to be retrieved.</p>
        pub fn set_column_statistics_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnStatistics>>,
        ) -> Self {
            self.column_statistics_list = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Error occurred during retrieving column statistics data.</p>
        pub fn errors(mut self, input: impl Into<crate::model::ColumnError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Error occurred during retrieving column statistics data.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`GetColumnStatisticsForPartitionOutput`](crate::output::GetColumnStatisticsForPartitionOutput)
        pub fn build(self) -> crate::output::GetColumnStatisticsForPartitionOutput {
            crate::output::GetColumnStatisticsForPartitionOutput {
                column_statistics_list: self.column_statistics_list,
                errors: self.errors,
            }
        }
    }
}
impl GetColumnStatisticsForPartitionOutput {
    /// Creates a new builder-style object to manufacture [`GetColumnStatisticsForPartitionOutput`](crate::output::GetColumnStatisticsForPartitionOutput)
    pub fn builder() -> crate::output::get_column_statistics_for_partition_output::Builder {
        crate::output::get_column_statistics_for_partition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetClassifiersOutput {
    /// <p>The requested list of classifier
    /// objects.</p>
    pub classifiers: std::option::Option<std::vec::Vec<crate::model::Classifier>>,
    /// <p>A continuation token.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetClassifiersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetClassifiersOutput");
        formatter.field("classifiers", &self.classifiers);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetClassifiersOutput`](crate::output::GetClassifiersOutput)
pub mod get_classifiers_output {
    /// A builder for [`GetClassifiersOutput`](crate::output::GetClassifiersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) classifiers: std::option::Option<std::vec::Vec<crate::model::Classifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `classifiers`.
        ///
        /// To override the contents of this collection use [`set_classifiers`](Self::set_classifiers).
        ///
        /// <p>The requested list of classifier
        /// objects.</p>
        pub fn classifiers(mut self, input: impl Into<crate::model::Classifier>) -> Self {
            let mut v = self.classifiers.unwrap_or_default();
            v.push(input.into());
            self.classifiers = Some(v);
            self
        }
        /// <p>The requested list of classifier
        /// objects.</p>
        pub fn set_classifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Classifier>>,
        ) -> Self {
            self.classifiers = input;
            self
        }
        /// <p>A continuation token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetClassifiersOutput`](crate::output::GetClassifiersOutput)
        pub fn build(self) -> crate::output::GetClassifiersOutput {
            crate::output::GetClassifiersOutput {
                classifiers: self.classifiers,
                next_token: self.next_token,
            }
        }
    }
}
impl GetClassifiersOutput {
    /// Creates a new builder-style object to manufacture [`GetClassifiersOutput`](crate::output::GetClassifiersOutput)
    pub fn builder() -> crate::output::get_classifiers_output::Builder {
        crate::output::get_classifiers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetClassifierOutput {
    /// <p>The requested classifier.</p>
    pub classifier: std::option::Option<crate::model::Classifier>,
}
impl std::fmt::Debug for GetClassifierOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetClassifierOutput");
        formatter.field("classifier", &self.classifier);
        formatter.finish()
    }
}
/// See [`GetClassifierOutput`](crate::output::GetClassifierOutput)
pub mod get_classifier_output {
    /// A builder for [`GetClassifierOutput`](crate::output::GetClassifierOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) classifier: std::option::Option<crate::model::Classifier>,
    }
    impl Builder {
        /// <p>The requested classifier.</p>
        pub fn classifier(mut self, input: crate::model::Classifier) -> Self {
            self.classifier = Some(input);
            self
        }
        /// <p>The requested classifier.</p>
        pub fn set_classifier(
            mut self,
            input: std::option::Option<crate::model::Classifier>,
        ) -> Self {
            self.classifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetClassifierOutput`](crate::output::GetClassifierOutput)
        pub fn build(self) -> crate::output::GetClassifierOutput {
            crate::output::GetClassifierOutput {
                classifier: self.classifier,
            }
        }
    }
}
impl GetClassifierOutput {
    /// Creates a new builder-style object to manufacture [`GetClassifierOutput`](crate::output::GetClassifierOutput)
    pub fn builder() -> crate::output::get_classifier_output::Builder {
        crate::output::get_classifier_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCatalogImportStatusOutput {
    /// <p>The status of the specified catalog migration.</p>
    pub import_status: std::option::Option<crate::model::CatalogImportStatus>,
}
impl std::fmt::Debug for GetCatalogImportStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCatalogImportStatusOutput");
        formatter.field("import_status", &self.import_status);
        formatter.finish()
    }
}
/// See [`GetCatalogImportStatusOutput`](crate::output::GetCatalogImportStatusOutput)
pub mod get_catalog_import_status_output {
    /// A builder for [`GetCatalogImportStatusOutput`](crate::output::GetCatalogImportStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_status: std::option::Option<crate::model::CatalogImportStatus>,
    }
    impl Builder {
        /// <p>The status of the specified catalog migration.</p>
        pub fn import_status(mut self, input: crate::model::CatalogImportStatus) -> Self {
            self.import_status = Some(input);
            self
        }
        /// <p>The status of the specified catalog migration.</p>
        pub fn set_import_status(
            mut self,
            input: std::option::Option<crate::model::CatalogImportStatus>,
        ) -> Self {
            self.import_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCatalogImportStatusOutput`](crate::output::GetCatalogImportStatusOutput)
        pub fn build(self) -> crate::output::GetCatalogImportStatusOutput {
            crate::output::GetCatalogImportStatusOutput {
                import_status: self.import_status,
            }
        }
    }
}
impl GetCatalogImportStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetCatalogImportStatusOutput`](crate::output::GetCatalogImportStatusOutput)
    pub fn builder() -> crate::output::get_catalog_import_status_output::Builder {
        crate::output::get_catalog_import_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBlueprintRunsOutput {
    /// <p>Returns a list of <code>BlueprintRun</code> objects.</p>
    pub blueprint_runs: std::option::Option<std::vec::Vec<crate::model::BlueprintRun>>,
    /// <p>A continuation token, if not all blueprint runs have been returned.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetBlueprintRunsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBlueprintRunsOutput");
        formatter.field("blueprint_runs", &self.blueprint_runs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetBlueprintRunsOutput`](crate::output::GetBlueprintRunsOutput)
pub mod get_blueprint_runs_output {
    /// A builder for [`GetBlueprintRunsOutput`](crate::output::GetBlueprintRunsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blueprint_runs: std::option::Option<std::vec::Vec<crate::model::BlueprintRun>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `blueprint_runs`.
        ///
        /// To override the contents of this collection use [`set_blueprint_runs`](Self::set_blueprint_runs).
        ///
        /// <p>Returns a list of <code>BlueprintRun</code> objects.</p>
        pub fn blueprint_runs(mut self, input: impl Into<crate::model::BlueprintRun>) -> Self {
            let mut v = self.blueprint_runs.unwrap_or_default();
            v.push(input.into());
            self.blueprint_runs = Some(v);
            self
        }
        /// <p>Returns a list of <code>BlueprintRun</code> objects.</p>
        pub fn set_blueprint_runs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BlueprintRun>>,
        ) -> Self {
            self.blueprint_runs = input;
            self
        }
        /// <p>A continuation token, if not all blueprint runs have been returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token, if not all blueprint runs have been returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBlueprintRunsOutput`](crate::output::GetBlueprintRunsOutput)
        pub fn build(self) -> crate::output::GetBlueprintRunsOutput {
            crate::output::GetBlueprintRunsOutput {
                blueprint_runs: self.blueprint_runs,
                next_token: self.next_token,
            }
        }
    }
}
impl GetBlueprintRunsOutput {
    /// Creates a new builder-style object to manufacture [`GetBlueprintRunsOutput`](crate::output::GetBlueprintRunsOutput)
    pub fn builder() -> crate::output::get_blueprint_runs_output::Builder {
        crate::output::get_blueprint_runs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBlueprintRunOutput {
    /// <p>Returns a <code>BlueprintRun</code> object.</p>
    pub blueprint_run: std::option::Option<crate::model::BlueprintRun>,
}
impl std::fmt::Debug for GetBlueprintRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBlueprintRunOutput");
        formatter.field("blueprint_run", &self.blueprint_run);
        formatter.finish()
    }
}
/// See [`GetBlueprintRunOutput`](crate::output::GetBlueprintRunOutput)
pub mod get_blueprint_run_output {
    /// A builder for [`GetBlueprintRunOutput`](crate::output::GetBlueprintRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blueprint_run: std::option::Option<crate::model::BlueprintRun>,
    }
    impl Builder {
        /// <p>Returns a <code>BlueprintRun</code> object.</p>
        pub fn blueprint_run(mut self, input: crate::model::BlueprintRun) -> Self {
            self.blueprint_run = Some(input);
            self
        }
        /// <p>Returns a <code>BlueprintRun</code> object.</p>
        pub fn set_blueprint_run(
            mut self,
            input: std::option::Option<crate::model::BlueprintRun>,
        ) -> Self {
            self.blueprint_run = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBlueprintRunOutput`](crate::output::GetBlueprintRunOutput)
        pub fn build(self) -> crate::output::GetBlueprintRunOutput {
            crate::output::GetBlueprintRunOutput {
                blueprint_run: self.blueprint_run,
            }
        }
    }
}
impl GetBlueprintRunOutput {
    /// Creates a new builder-style object to manufacture [`GetBlueprintRunOutput`](crate::output::GetBlueprintRunOutput)
    pub fn builder() -> crate::output::get_blueprint_run_output::Builder {
        crate::output::get_blueprint_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBlueprintOutput {
    /// <p>Returns a <code>Blueprint</code> object.</p>
    pub blueprint: std::option::Option<crate::model::Blueprint>,
}
impl std::fmt::Debug for GetBlueprintOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBlueprintOutput");
        formatter.field("blueprint", &self.blueprint);
        formatter.finish()
    }
}
/// See [`GetBlueprintOutput`](crate::output::GetBlueprintOutput)
pub mod get_blueprint_output {
    /// A builder for [`GetBlueprintOutput`](crate::output::GetBlueprintOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blueprint: std::option::Option<crate::model::Blueprint>,
    }
    impl Builder {
        /// <p>Returns a <code>Blueprint</code> object.</p>
        pub fn blueprint(mut self, input: crate::model::Blueprint) -> Self {
            self.blueprint = Some(input);
            self
        }
        /// <p>Returns a <code>Blueprint</code> object.</p>
        pub fn set_blueprint(
            mut self,
            input: std::option::Option<crate::model::Blueprint>,
        ) -> Self {
            self.blueprint = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBlueprintOutput`](crate::output::GetBlueprintOutput)
        pub fn build(self) -> crate::output::GetBlueprintOutput {
            crate::output::GetBlueprintOutput {
                blueprint: self.blueprint,
            }
        }
    }
}
impl GetBlueprintOutput {
    /// Creates a new builder-style object to manufacture [`GetBlueprintOutput`](crate::output::GetBlueprintOutput)
    pub fn builder() -> crate::output::get_blueprint_output::Builder {
        crate::output::get_blueprint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkflowOutput {
    /// <p>Name of the workflow specified in input.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteWorkflowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkflowOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DeleteWorkflowOutput`](crate::output::DeleteWorkflowOutput)
pub mod delete_workflow_output {
    /// A builder for [`DeleteWorkflowOutput`](crate::output::DeleteWorkflowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the workflow specified in input.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the workflow specified in input.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkflowOutput`](crate::output::DeleteWorkflowOutput)
        pub fn build(self) -> crate::output::DeleteWorkflowOutput {
            crate::output::DeleteWorkflowOutput { name: self.name }
        }
    }
}
impl DeleteWorkflowOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWorkflowOutput`](crate::output::DeleteWorkflowOutput)
    pub fn builder() -> crate::output::delete_workflow_output::Builder {
        crate::output::delete_workflow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserDefinedFunctionOutput {}
impl std::fmt::Debug for DeleteUserDefinedFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserDefinedFunctionOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserDefinedFunctionOutput`](crate::output::DeleteUserDefinedFunctionOutput)
pub mod delete_user_defined_function_output {
    /// A builder for [`DeleteUserDefinedFunctionOutput`](crate::output::DeleteUserDefinedFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserDefinedFunctionOutput`](crate::output::DeleteUserDefinedFunctionOutput)
        pub fn build(self) -> crate::output::DeleteUserDefinedFunctionOutput {
            crate::output::DeleteUserDefinedFunctionOutput {}
        }
    }
}
impl DeleteUserDefinedFunctionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserDefinedFunctionOutput`](crate::output::DeleteUserDefinedFunctionOutput)
    pub fn builder() -> crate::output::delete_user_defined_function_output::Builder {
        crate::output::delete_user_defined_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTriggerOutput {
    /// <p>The name of the trigger that was deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteTriggerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTriggerOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DeleteTriggerOutput`](crate::output::DeleteTriggerOutput)
pub mod delete_trigger_output {
    /// A builder for [`DeleteTriggerOutput`](crate::output::DeleteTriggerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the trigger that was deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the trigger that was deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTriggerOutput`](crate::output::DeleteTriggerOutput)
        pub fn build(self) -> crate::output::DeleteTriggerOutput {
            crate::output::DeleteTriggerOutput { name: self.name }
        }
    }
}
impl DeleteTriggerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTriggerOutput`](crate::output::DeleteTriggerOutput)
    pub fn builder() -> crate::output::delete_trigger_output::Builder {
        crate::output::delete_trigger_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTableVersionOutput {}
impl std::fmt::Debug for DeleteTableVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTableVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteTableVersionOutput`](crate::output::DeleteTableVersionOutput)
pub mod delete_table_version_output {
    /// A builder for [`DeleteTableVersionOutput`](crate::output::DeleteTableVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTableVersionOutput`](crate::output::DeleteTableVersionOutput)
        pub fn build(self) -> crate::output::DeleteTableVersionOutput {
            crate::output::DeleteTableVersionOutput {}
        }
    }
}
impl DeleteTableVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTableVersionOutput`](crate::output::DeleteTableVersionOutput)
    pub fn builder() -> crate::output::delete_table_version_output::Builder {
        crate::output::delete_table_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTableOutput {}
impl std::fmt::Debug for DeleteTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTableOutput");
        formatter.finish()
    }
}
/// See [`DeleteTableOutput`](crate::output::DeleteTableOutput)
pub mod delete_table_output {
    /// A builder for [`DeleteTableOutput`](crate::output::DeleteTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTableOutput`](crate::output::DeleteTableOutput)
        pub fn build(self) -> crate::output::DeleteTableOutput {
            crate::output::DeleteTableOutput {}
        }
    }
}
impl DeleteTableOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTableOutput`](crate::output::DeleteTableOutput)
    pub fn builder() -> crate::output::delete_table_output::Builder {
        crate::output::delete_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSecurityConfigurationOutput {}
impl std::fmt::Debug for DeleteSecurityConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSecurityConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteSecurityConfigurationOutput`](crate::output::DeleteSecurityConfigurationOutput)
pub mod delete_security_configuration_output {
    /// A builder for [`DeleteSecurityConfigurationOutput`](crate::output::DeleteSecurityConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSecurityConfigurationOutput`](crate::output::DeleteSecurityConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteSecurityConfigurationOutput {
            crate::output::DeleteSecurityConfigurationOutput {}
        }
    }
}
impl DeleteSecurityConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSecurityConfigurationOutput`](crate::output::DeleteSecurityConfigurationOutput)
    pub fn builder() -> crate::output::delete_security_configuration_output::Builder {
        crate::output::delete_security_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSchemaVersionsOutput {
    /// <p>A list of <code>SchemaVersionErrorItem</code> objects, each containing an error and schema version.</p>
    pub schema_version_errors:
        std::option::Option<std::vec::Vec<crate::model::SchemaVersionErrorItem>>,
}
impl std::fmt::Debug for DeleteSchemaVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSchemaVersionsOutput");
        formatter.field("schema_version_errors", &self.schema_version_errors);
        formatter.finish()
    }
}
/// See [`DeleteSchemaVersionsOutput`](crate::output::DeleteSchemaVersionsOutput)
pub mod delete_schema_versions_output {
    /// A builder for [`DeleteSchemaVersionsOutput`](crate::output::DeleteSchemaVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_version_errors:
            std::option::Option<std::vec::Vec<crate::model::SchemaVersionErrorItem>>,
    }
    impl Builder {
        /// Appends an item to `schema_version_errors`.
        ///
        /// To override the contents of this collection use [`set_schema_version_errors`](Self::set_schema_version_errors).
        ///
        /// <p>A list of <code>SchemaVersionErrorItem</code> objects, each containing an error and schema version.</p>
        pub fn schema_version_errors(
            mut self,
            input: impl Into<crate::model::SchemaVersionErrorItem>,
        ) -> Self {
            let mut v = self.schema_version_errors.unwrap_or_default();
            v.push(input.into());
            self.schema_version_errors = Some(v);
            self
        }
        /// <p>A list of <code>SchemaVersionErrorItem</code> objects, each containing an error and schema version.</p>
        pub fn set_schema_version_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaVersionErrorItem>>,
        ) -> Self {
            self.schema_version_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSchemaVersionsOutput`](crate::output::DeleteSchemaVersionsOutput)
        pub fn build(self) -> crate::output::DeleteSchemaVersionsOutput {
            crate::output::DeleteSchemaVersionsOutput {
                schema_version_errors: self.schema_version_errors,
            }
        }
    }
}
impl DeleteSchemaVersionsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaVersionsOutput`](crate::output::DeleteSchemaVersionsOutput)
    pub fn builder() -> crate::output::delete_schema_versions_output::Builder {
        crate::output::delete_schema_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSchemaOutput {
    /// <p>The Amazon Resource Name (ARN) of the schema being deleted.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the schema being deleted.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The status of the schema.</p>
    pub status: std::option::Option<crate::model::SchemaStatus>,
}
impl std::fmt::Debug for DeleteSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSchemaOutput");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
pub mod delete_schema_output {
    /// A builder for [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SchemaStatus>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the schema being deleted.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema being deleted.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the schema being deleted.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema being deleted.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The status of the schema.</p>
        pub fn status(mut self, input: crate::model::SchemaStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the schema.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SchemaStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
        pub fn build(self) -> crate::output::DeleteSchemaOutput {
            crate::output::DeleteSchemaOutput {
                schema_arn: self.schema_arn,
                schema_name: self.schema_name,
                status: self.status,
            }
        }
    }
}
impl DeleteSchemaOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaOutput`](crate::output::DeleteSchemaOutput)
    pub fn builder() -> crate::output::delete_schema_output::Builder {
        crate::output::delete_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyOutput {}
impl std::fmt::Debug for DeleteResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
pub mod delete_resource_policy_output {
    /// A builder for [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
        pub fn build(self) -> crate::output::DeleteResourcePolicyOutput {
            crate::output::DeleteResourcePolicyOutput {}
        }
    }
}
impl DeleteResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    pub fn builder() -> crate::output::delete_resource_policy_output::Builder {
        crate::output::delete_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRegistryOutput {
    /// <p>The name of the registry being deleted.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the registry being deleted.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>The status of the registry. A successful operation will return the <code>Deleting</code> status.</p>
    pub status: std::option::Option<crate::model::RegistryStatus>,
}
impl std::fmt::Debug for DeleteRegistryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRegistryOutput");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteRegistryOutput`](crate::output::DeleteRegistryOutput)
pub mod delete_registry_output {
    /// A builder for [`DeleteRegistryOutput`](crate::output::DeleteRegistryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RegistryStatus>,
    }
    impl Builder {
        /// <p>The name of the registry being deleted.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry being deleted.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registry being deleted.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registry being deleted.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>The status of the registry. A successful operation will return the <code>Deleting</code> status.</p>
        pub fn status(mut self, input: crate::model::RegistryStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the registry. A successful operation will return the <code>Deleting</code> status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RegistryStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRegistryOutput`](crate::output::DeleteRegistryOutput)
        pub fn build(self) -> crate::output::DeleteRegistryOutput {
            crate::output::DeleteRegistryOutput {
                registry_name: self.registry_name,
                registry_arn: self.registry_arn,
                status: self.status,
            }
        }
    }
}
impl DeleteRegistryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRegistryOutput`](crate::output::DeleteRegistryOutput)
    pub fn builder() -> crate::output::delete_registry_output::Builder {
        crate::output::delete_registry_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePartitionIndexOutput {}
impl std::fmt::Debug for DeletePartitionIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePartitionIndexOutput");
        formatter.finish()
    }
}
/// See [`DeletePartitionIndexOutput`](crate::output::DeletePartitionIndexOutput)
pub mod delete_partition_index_output {
    /// A builder for [`DeletePartitionIndexOutput`](crate::output::DeletePartitionIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePartitionIndexOutput`](crate::output::DeletePartitionIndexOutput)
        pub fn build(self) -> crate::output::DeletePartitionIndexOutput {
            crate::output::DeletePartitionIndexOutput {}
        }
    }
}
impl DeletePartitionIndexOutput {
    /// Creates a new builder-style object to manufacture [`DeletePartitionIndexOutput`](crate::output::DeletePartitionIndexOutput)
    pub fn builder() -> crate::output::delete_partition_index_output::Builder {
        crate::output::delete_partition_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePartitionOutput {}
impl std::fmt::Debug for DeletePartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePartitionOutput");
        formatter.finish()
    }
}
/// See [`DeletePartitionOutput`](crate::output::DeletePartitionOutput)
pub mod delete_partition_output {
    /// A builder for [`DeletePartitionOutput`](crate::output::DeletePartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePartitionOutput`](crate::output::DeletePartitionOutput)
        pub fn build(self) -> crate::output::DeletePartitionOutput {
            crate::output::DeletePartitionOutput {}
        }
    }
}
impl DeletePartitionOutput {
    /// Creates a new builder-style object to manufacture [`DeletePartitionOutput`](crate::output::DeletePartitionOutput)
    pub fn builder() -> crate::output::delete_partition_output::Builder {
        crate::output::delete_partition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMlTransformOutput {
    /// <p>The unique identifier of the transform that was deleted.</p>
    pub transform_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteMlTransformOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMlTransformOutput");
        formatter.field("transform_id", &self.transform_id);
        formatter.finish()
    }
}
/// See [`DeleteMlTransformOutput`](crate::output::DeleteMlTransformOutput)
pub mod delete_ml_transform_output {
    /// A builder for [`DeleteMlTransformOutput`](crate::output::DeleteMlTransformOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the transform that was deleted.</p>
        pub fn transform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the transform that was deleted.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.transform_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMlTransformOutput`](crate::output::DeleteMlTransformOutput)
        pub fn build(self) -> crate::output::DeleteMlTransformOutput {
            crate::output::DeleteMlTransformOutput {
                transform_id: self.transform_id,
            }
        }
    }
}
impl DeleteMlTransformOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMlTransformOutput`](crate::output::DeleteMlTransformOutput)
    pub fn builder() -> crate::output::delete_ml_transform_output::Builder {
        crate::output::delete_ml_transform_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobOutput {
    /// <p>The name of the job definition that was deleted.</p>
    pub job_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobOutput");
        formatter.field("job_name", &self.job_name);
        formatter.finish()
    }
}
/// See [`DeleteJobOutput`](crate::output::DeleteJobOutput)
pub mod delete_job_output {
    /// A builder for [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job definition that was deleted.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the job definition that was deleted.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJobOutput`](crate::output::DeleteJobOutput)
        pub fn build(self) -> crate::output::DeleteJobOutput {
            crate::output::DeleteJobOutput {
                job_name: self.job_name,
            }
        }
    }
}
impl DeleteJobOutput {
    /// Creates a new builder-style object to manufacture [`DeleteJobOutput`](crate::output::DeleteJobOutput)
    pub fn builder() -> crate::output::delete_job_output::Builder {
        crate::output::delete_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDevEndpointOutput {}
impl std::fmt::Debug for DeleteDevEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDevEndpointOutput");
        formatter.finish()
    }
}
/// See [`DeleteDevEndpointOutput`](crate::output::DeleteDevEndpointOutput)
pub mod delete_dev_endpoint_output {
    /// A builder for [`DeleteDevEndpointOutput`](crate::output::DeleteDevEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDevEndpointOutput`](crate::output::DeleteDevEndpointOutput)
        pub fn build(self) -> crate::output::DeleteDevEndpointOutput {
            crate::output::DeleteDevEndpointOutput {}
        }
    }
}
impl DeleteDevEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDevEndpointOutput`](crate::output::DeleteDevEndpointOutput)
    pub fn builder() -> crate::output::delete_dev_endpoint_output::Builder {
        crate::output::delete_dev_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatabaseOutput {}
impl std::fmt::Debug for DeleteDatabaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatabaseOutput");
        formatter.finish()
    }
}
/// See [`DeleteDatabaseOutput`](crate::output::DeleteDatabaseOutput)
pub mod delete_database_output {
    /// A builder for [`DeleteDatabaseOutput`](crate::output::DeleteDatabaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDatabaseOutput`](crate::output::DeleteDatabaseOutput)
        pub fn build(self) -> crate::output::DeleteDatabaseOutput {
            crate::output::DeleteDatabaseOutput {}
        }
    }
}
impl DeleteDatabaseOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDatabaseOutput`](crate::output::DeleteDatabaseOutput)
    pub fn builder() -> crate::output::delete_database_output::Builder {
        crate::output::delete_database_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCrawlerOutput {}
impl std::fmt::Debug for DeleteCrawlerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCrawlerOutput");
        formatter.finish()
    }
}
/// See [`DeleteCrawlerOutput`](crate::output::DeleteCrawlerOutput)
pub mod delete_crawler_output {
    /// A builder for [`DeleteCrawlerOutput`](crate::output::DeleteCrawlerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCrawlerOutput`](crate::output::DeleteCrawlerOutput)
        pub fn build(self) -> crate::output::DeleteCrawlerOutput {
            crate::output::DeleteCrawlerOutput {}
        }
    }
}
impl DeleteCrawlerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCrawlerOutput`](crate::output::DeleteCrawlerOutput)
    pub fn builder() -> crate::output::delete_crawler_output::Builder {
        crate::output::delete_crawler_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionOutput {}
impl std::fmt::Debug for DeleteConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionOutput");
        formatter.finish()
    }
}
/// See [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
pub mod delete_connection_output {
    /// A builder for [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
        pub fn build(self) -> crate::output::DeleteConnectionOutput {
            crate::output::DeleteConnectionOutput {}
        }
    }
}
impl DeleteConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    pub fn builder() -> crate::output::delete_connection_output::Builder {
        crate::output::delete_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteColumnStatisticsForTableOutput {}
impl std::fmt::Debug for DeleteColumnStatisticsForTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteColumnStatisticsForTableOutput");
        formatter.finish()
    }
}
/// See [`DeleteColumnStatisticsForTableOutput`](crate::output::DeleteColumnStatisticsForTableOutput)
pub mod delete_column_statistics_for_table_output {
    /// A builder for [`DeleteColumnStatisticsForTableOutput`](crate::output::DeleteColumnStatisticsForTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteColumnStatisticsForTableOutput`](crate::output::DeleteColumnStatisticsForTableOutput)
        pub fn build(self) -> crate::output::DeleteColumnStatisticsForTableOutput {
            crate::output::DeleteColumnStatisticsForTableOutput {}
        }
    }
}
impl DeleteColumnStatisticsForTableOutput {
    /// Creates a new builder-style object to manufacture [`DeleteColumnStatisticsForTableOutput`](crate::output::DeleteColumnStatisticsForTableOutput)
    pub fn builder() -> crate::output::delete_column_statistics_for_table_output::Builder {
        crate::output::delete_column_statistics_for_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteColumnStatisticsForPartitionOutput {}
impl std::fmt::Debug for DeleteColumnStatisticsForPartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteColumnStatisticsForPartitionOutput");
        formatter.finish()
    }
}
/// See [`DeleteColumnStatisticsForPartitionOutput`](crate::output::DeleteColumnStatisticsForPartitionOutput)
pub mod delete_column_statistics_for_partition_output {
    /// A builder for [`DeleteColumnStatisticsForPartitionOutput`](crate::output::DeleteColumnStatisticsForPartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteColumnStatisticsForPartitionOutput`](crate::output::DeleteColumnStatisticsForPartitionOutput)
        pub fn build(self) -> crate::output::DeleteColumnStatisticsForPartitionOutput {
            crate::output::DeleteColumnStatisticsForPartitionOutput {}
        }
    }
}
impl DeleteColumnStatisticsForPartitionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteColumnStatisticsForPartitionOutput`](crate::output::DeleteColumnStatisticsForPartitionOutput)
    pub fn builder() -> crate::output::delete_column_statistics_for_partition_output::Builder {
        crate::output::delete_column_statistics_for_partition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClassifierOutput {}
impl std::fmt::Debug for DeleteClassifierOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClassifierOutput");
        formatter.finish()
    }
}
/// See [`DeleteClassifierOutput`](crate::output::DeleteClassifierOutput)
pub mod delete_classifier_output {
    /// A builder for [`DeleteClassifierOutput`](crate::output::DeleteClassifierOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteClassifierOutput`](crate::output::DeleteClassifierOutput)
        pub fn build(self) -> crate::output::DeleteClassifierOutput {
            crate::output::DeleteClassifierOutput {}
        }
    }
}
impl DeleteClassifierOutput {
    /// Creates a new builder-style object to manufacture [`DeleteClassifierOutput`](crate::output::DeleteClassifierOutput)
    pub fn builder() -> crate::output::delete_classifier_output::Builder {
        crate::output::delete_classifier_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBlueprintOutput {
    /// <p>Returns the name of the blueprint that was deleted.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteBlueprintOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBlueprintOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DeleteBlueprintOutput`](crate::output::DeleteBlueprintOutput)
pub mod delete_blueprint_output {
    /// A builder for [`DeleteBlueprintOutput`](crate::output::DeleteBlueprintOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns the name of the blueprint that was deleted.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Returns the name of the blueprint that was deleted.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBlueprintOutput`](crate::output::DeleteBlueprintOutput)
        pub fn build(self) -> crate::output::DeleteBlueprintOutput {
            crate::output::DeleteBlueprintOutput { name: self.name }
        }
    }
}
impl DeleteBlueprintOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBlueprintOutput`](crate::output::DeleteBlueprintOutput)
    pub fn builder() -> crate::output::delete_blueprint_output::Builder {
        crate::output::delete_blueprint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkflowOutput {
    /// <p>The name of the workflow which was provided as part of the request.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateWorkflowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkflowOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateWorkflowOutput`](crate::output::CreateWorkflowOutput)
pub mod create_workflow_output {
    /// A builder for [`CreateWorkflowOutput`](crate::output::CreateWorkflowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the workflow which was provided as part of the request.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the workflow which was provided as part of the request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkflowOutput`](crate::output::CreateWorkflowOutput)
        pub fn build(self) -> crate::output::CreateWorkflowOutput {
            crate::output::CreateWorkflowOutput { name: self.name }
        }
    }
}
impl CreateWorkflowOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorkflowOutput`](crate::output::CreateWorkflowOutput)
    pub fn builder() -> crate::output::create_workflow_output::Builder {
        crate::output::create_workflow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserDefinedFunctionOutput {}
impl std::fmt::Debug for CreateUserDefinedFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserDefinedFunctionOutput");
        formatter.finish()
    }
}
/// See [`CreateUserDefinedFunctionOutput`](crate::output::CreateUserDefinedFunctionOutput)
pub mod create_user_defined_function_output {
    /// A builder for [`CreateUserDefinedFunctionOutput`](crate::output::CreateUserDefinedFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateUserDefinedFunctionOutput`](crate::output::CreateUserDefinedFunctionOutput)
        pub fn build(self) -> crate::output::CreateUserDefinedFunctionOutput {
            crate::output::CreateUserDefinedFunctionOutput {}
        }
    }
}
impl CreateUserDefinedFunctionOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserDefinedFunctionOutput`](crate::output::CreateUserDefinedFunctionOutput)
    pub fn builder() -> crate::output::create_user_defined_function_output::Builder {
        crate::output::create_user_defined_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTriggerOutput {
    /// <p>The name of the trigger.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateTriggerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTriggerOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateTriggerOutput`](crate::output::CreateTriggerOutput)
pub mod create_trigger_output {
    /// A builder for [`CreateTriggerOutput`](crate::output::CreateTriggerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the trigger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the trigger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTriggerOutput`](crate::output::CreateTriggerOutput)
        pub fn build(self) -> crate::output::CreateTriggerOutput {
            crate::output::CreateTriggerOutput { name: self.name }
        }
    }
}
impl CreateTriggerOutput {
    /// Creates a new builder-style object to manufacture [`CreateTriggerOutput`](crate::output::CreateTriggerOutput)
    pub fn builder() -> crate::output::create_trigger_output::Builder {
        crate::output::create_trigger_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTableOutput {}
impl std::fmt::Debug for CreateTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTableOutput");
        formatter.finish()
    }
}
/// See [`CreateTableOutput`](crate::output::CreateTableOutput)
pub mod create_table_output {
    /// A builder for [`CreateTableOutput`](crate::output::CreateTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateTableOutput`](crate::output::CreateTableOutput)
        pub fn build(self) -> crate::output::CreateTableOutput {
            crate::output::CreateTableOutput {}
        }
    }
}
impl CreateTableOutput {
    /// Creates a new builder-style object to manufacture [`CreateTableOutput`](crate::output::CreateTableOutput)
    pub fn builder() -> crate::output::create_table_output::Builder {
        crate::output::create_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSecurityConfigurationOutput {
    /// <p>The name assigned to the new security configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time at which the new security configuration was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for CreateSecurityConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSecurityConfigurationOutput");
        formatter.field("name", &self.name);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.finish()
    }
}
/// See [`CreateSecurityConfigurationOutput`](crate::output::CreateSecurityConfigurationOutput)
pub mod create_security_configuration_output {
    /// A builder for [`CreateSecurityConfigurationOutput`](crate::output::CreateSecurityConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name assigned to the new security configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name assigned to the new security configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time at which the new security configuration was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The time at which the new security configuration was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSecurityConfigurationOutput`](crate::output::CreateSecurityConfigurationOutput)
        pub fn build(self) -> crate::output::CreateSecurityConfigurationOutput {
            crate::output::CreateSecurityConfigurationOutput {
                name: self.name,
                created_timestamp: self.created_timestamp,
            }
        }
    }
}
impl CreateSecurityConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateSecurityConfigurationOutput`](crate::output::CreateSecurityConfigurationOutput)
    pub fn builder() -> crate::output::create_security_configuration_output::Builder {
        crate::output::create_security_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateScriptOutput {
    /// <p>The Python script generated from the DAG.</p>
    pub python_script: std::option::Option<std::string::String>,
    /// <p>The Scala code generated from the DAG.</p>
    pub scala_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateScriptOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateScriptOutput");
        formatter.field("python_script", &self.python_script);
        formatter.field("scala_code", &self.scala_code);
        formatter.finish()
    }
}
/// See [`CreateScriptOutput`](crate::output::CreateScriptOutput)
pub mod create_script_output {
    /// A builder for [`CreateScriptOutput`](crate::output::CreateScriptOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) python_script: std::option::Option<std::string::String>,
        pub(crate) scala_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Python script generated from the DAG.</p>
        pub fn python_script(mut self, input: impl Into<std::string::String>) -> Self {
            self.python_script = Some(input.into());
            self
        }
        /// <p>The Python script generated from the DAG.</p>
        pub fn set_python_script(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.python_script = input;
            self
        }
        /// <p>The Scala code generated from the DAG.</p>
        pub fn scala_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.scala_code = Some(input.into());
            self
        }
        /// <p>The Scala code generated from the DAG.</p>
        pub fn set_scala_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scala_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateScriptOutput`](crate::output::CreateScriptOutput)
        pub fn build(self) -> crate::output::CreateScriptOutput {
            crate::output::CreateScriptOutput {
                python_script: self.python_script,
                scala_code: self.scala_code,
            }
        }
    }
}
impl CreateScriptOutput {
    /// Creates a new builder-style object to manufacture [`CreateScriptOutput`](crate::output::CreateScriptOutput)
    pub fn builder() -> crate::output::create_script_output::Builder {
        crate::output::create_script_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSchemaOutput {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>A description of the schema if specified when created.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
    pub data_format: std::option::Option<crate::model::DataFormat>,
    /// <p>The schema compatibility mode.</p>
    pub compatibility: std::option::Option<crate::model::Compatibility>,
    /// <p>The version number of the checkpoint (the last time the compatibility mode was changed).</p>
    pub schema_checkpoint: i64,
    /// <p>The latest version of the schema associated with the returned schema definition.</p>
    pub latest_schema_version: i64,
    /// <p>The next version of the schema associated with the returned schema definition.</p>
    pub next_schema_version: i64,
    /// <p>The status of the schema. </p>
    pub schema_status: std::option::Option<crate::model::SchemaStatus>,
    /// <p>The tags for the schema.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The unique identifier of the first schema version.</p>
    pub schema_version_id: std::option::Option<std::string::String>,
    /// <p>The status of the first schema version created.</p>
    pub schema_version_status: std::option::Option<crate::model::SchemaVersionStatus>,
}
impl std::fmt::Debug for CreateSchemaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSchemaOutput");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("description", &self.description);
        formatter.field("data_format", &self.data_format);
        formatter.field("compatibility", &self.compatibility);
        formatter.field("schema_checkpoint", &self.schema_checkpoint);
        formatter.field("latest_schema_version", &self.latest_schema_version);
        formatter.field("next_schema_version", &self.next_schema_version);
        formatter.field("schema_status", &self.schema_status);
        formatter.field("tags", &self.tags);
        formatter.field("schema_version_id", &self.schema_version_id);
        formatter.field("schema_version_status", &self.schema_version_status);
        formatter.finish()
    }
}
/// See [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
pub mod create_schema_output {
    /// A builder for [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_format: std::option::Option<crate::model::DataFormat>,
        pub(crate) compatibility: std::option::Option<crate::model::Compatibility>,
        pub(crate) schema_checkpoint: std::option::Option<i64>,
        pub(crate) latest_schema_version: std::option::Option<i64>,
        pub(crate) next_schema_version: std::option::Option<i64>,
        pub(crate) schema_status: std::option::Option<crate::model::SchemaStatus>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) schema_version_id: std::option::Option<std::string::String>,
        pub(crate) schema_version_status: std::option::Option<crate::model::SchemaVersionStatus>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>A description of the schema if specified when created.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the schema if specified when created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn data_format(mut self, input: crate::model::DataFormat) -> Self {
            self.data_format = Some(input);
            self
        }
        /// <p>The data format of the schema definition. Currently <code>AVRO</code> and <code>JSON</code> are supported.</p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::DataFormat>,
        ) -> Self {
            self.data_format = input;
            self
        }
        /// <p>The schema compatibility mode.</p>
        pub fn compatibility(mut self, input: crate::model::Compatibility) -> Self {
            self.compatibility = Some(input);
            self
        }
        /// <p>The schema compatibility mode.</p>
        pub fn set_compatibility(
            mut self,
            input: std::option::Option<crate::model::Compatibility>,
        ) -> Self {
            self.compatibility = input;
            self
        }
        /// <p>The version number of the checkpoint (the last time the compatibility mode was changed).</p>
        pub fn schema_checkpoint(mut self, input: i64) -> Self {
            self.schema_checkpoint = Some(input);
            self
        }
        /// <p>The version number of the checkpoint (the last time the compatibility mode was changed).</p>
        pub fn set_schema_checkpoint(mut self, input: std::option::Option<i64>) -> Self {
            self.schema_checkpoint = input;
            self
        }
        /// <p>The latest version of the schema associated with the returned schema definition.</p>
        pub fn latest_schema_version(mut self, input: i64) -> Self {
            self.latest_schema_version = Some(input);
            self
        }
        /// <p>The latest version of the schema associated with the returned schema definition.</p>
        pub fn set_latest_schema_version(mut self, input: std::option::Option<i64>) -> Self {
            self.latest_schema_version = input;
            self
        }
        /// <p>The next version of the schema associated with the returned schema definition.</p>
        pub fn next_schema_version(mut self, input: i64) -> Self {
            self.next_schema_version = Some(input);
            self
        }
        /// <p>The next version of the schema associated with the returned schema definition.</p>
        pub fn set_next_schema_version(mut self, input: std::option::Option<i64>) -> Self {
            self.next_schema_version = input;
            self
        }
        /// <p>The status of the schema. </p>
        pub fn schema_status(mut self, input: crate::model::SchemaStatus) -> Self {
            self.schema_status = Some(input);
            self
        }
        /// <p>The status of the schema. </p>
        pub fn set_schema_status(
            mut self,
            input: std::option::Option<crate::model::SchemaStatus>,
        ) -> Self {
            self.schema_status = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the schema.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the schema.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The unique identifier of the first schema version.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the first schema version.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version_id = input;
            self
        }
        /// <p>The status of the first schema version created.</p>
        pub fn schema_version_status(mut self, input: crate::model::SchemaVersionStatus) -> Self {
            self.schema_version_status = Some(input);
            self
        }
        /// <p>The status of the first schema version created.</p>
        pub fn set_schema_version_status(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionStatus>,
        ) -> Self {
            self.schema_version_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
        pub fn build(self) -> crate::output::CreateSchemaOutput {
            crate::output::CreateSchemaOutput {
                registry_name: self.registry_name,
                registry_arn: self.registry_arn,
                schema_name: self.schema_name,
                schema_arn: self.schema_arn,
                description: self.description,
                data_format: self.data_format,
                compatibility: self.compatibility,
                schema_checkpoint: self.schema_checkpoint.unwrap_or_default(),
                latest_schema_version: self.latest_schema_version.unwrap_or_default(),
                next_schema_version: self.next_schema_version.unwrap_or_default(),
                schema_status: self.schema_status,
                tags: self.tags,
                schema_version_id: self.schema_version_id,
                schema_version_status: self.schema_version_status,
            }
        }
    }
}
impl CreateSchemaOutput {
    /// Creates a new builder-style object to manufacture [`CreateSchemaOutput`](crate::output::CreateSchemaOutput)
    pub fn builder() -> crate::output::create_schema_output::Builder {
        crate::output::create_schema_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRegistryOutput {
    /// <p>The Amazon Resource Name (ARN) of the newly created registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>A description of the registry.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The tags for the registry.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateRegistryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRegistryOutput");
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("registry_name", &self.registry_name);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateRegistryOutput`](crate::output::CreateRegistryOutput)
pub mod create_registry_output {
    /// A builder for [`CreateRegistryOutput`](crate::output::CreateRegistryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the newly created registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the newly created registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>A description of the registry.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the registry.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the registry.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the registry.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRegistryOutput`](crate::output::CreateRegistryOutput)
        pub fn build(self) -> crate::output::CreateRegistryOutput {
            crate::output::CreateRegistryOutput {
                registry_arn: self.registry_arn,
                registry_name: self.registry_name,
                description: self.description,
                tags: self.tags,
            }
        }
    }
}
impl CreateRegistryOutput {
    /// Creates a new builder-style object to manufacture [`CreateRegistryOutput`](crate::output::CreateRegistryOutput)
    pub fn builder() -> crate::output::create_registry_output::Builder {
        crate::output::create_registry_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePartitionIndexOutput {}
impl std::fmt::Debug for CreatePartitionIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePartitionIndexOutput");
        formatter.finish()
    }
}
/// See [`CreatePartitionIndexOutput`](crate::output::CreatePartitionIndexOutput)
pub mod create_partition_index_output {
    /// A builder for [`CreatePartitionIndexOutput`](crate::output::CreatePartitionIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreatePartitionIndexOutput`](crate::output::CreatePartitionIndexOutput)
        pub fn build(self) -> crate::output::CreatePartitionIndexOutput {
            crate::output::CreatePartitionIndexOutput {}
        }
    }
}
impl CreatePartitionIndexOutput {
    /// Creates a new builder-style object to manufacture [`CreatePartitionIndexOutput`](crate::output::CreatePartitionIndexOutput)
    pub fn builder() -> crate::output::create_partition_index_output::Builder {
        crate::output::create_partition_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePartitionOutput {}
impl std::fmt::Debug for CreatePartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePartitionOutput");
        formatter.finish()
    }
}
/// See [`CreatePartitionOutput`](crate::output::CreatePartitionOutput)
pub mod create_partition_output {
    /// A builder for [`CreatePartitionOutput`](crate::output::CreatePartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreatePartitionOutput`](crate::output::CreatePartitionOutput)
        pub fn build(self) -> crate::output::CreatePartitionOutput {
            crate::output::CreatePartitionOutput {}
        }
    }
}
impl CreatePartitionOutput {
    /// Creates a new builder-style object to manufacture [`CreatePartitionOutput`](crate::output::CreatePartitionOutput)
    pub fn builder() -> crate::output::create_partition_output::Builder {
        crate::output::create_partition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMlTransformOutput {
    /// <p>A unique identifier that is generated for the transform.</p>
    pub transform_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateMlTransformOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMlTransformOutput");
        formatter.field("transform_id", &self.transform_id);
        formatter.finish()
    }
}
/// See [`CreateMlTransformOutput`](crate::output::CreateMlTransformOutput)
pub mod create_ml_transform_output {
    /// A builder for [`CreateMlTransformOutput`](crate::output::CreateMlTransformOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier that is generated for the transform.</p>
        pub fn transform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that is generated for the transform.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.transform_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMlTransformOutput`](crate::output::CreateMlTransformOutput)
        pub fn build(self) -> crate::output::CreateMlTransformOutput {
            crate::output::CreateMlTransformOutput {
                transform_id: self.transform_id,
            }
        }
    }
}
impl CreateMlTransformOutput {
    /// Creates a new builder-style object to manufacture [`CreateMlTransformOutput`](crate::output::CreateMlTransformOutput)
    pub fn builder() -> crate::output::create_ml_transform_output::Builder {
        crate::output::create_ml_transform_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobOutput {
    /// <p>The unique name that was provided for this job definition.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateJobOutput`](crate::output::CreateJobOutput)
pub mod create_job_output {
    /// A builder for [`CreateJobOutput`](crate::output::CreateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name that was provided for this job definition.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name that was provided for this job definition.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobOutput`](crate::output::CreateJobOutput)
        pub fn build(self) -> crate::output::CreateJobOutput {
            crate::output::CreateJobOutput { name: self.name }
        }
    }
}
impl CreateJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateJobOutput`](crate::output::CreateJobOutput)
    pub fn builder() -> crate::output::create_job_output::Builder {
        crate::output::create_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDevEndpointOutput {
    /// <p>The name assigned to the new <code>DevEndpoint</code>.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>The current status of the new <code>DevEndpoint</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The security groups assigned to the new <code>DevEndpoint</code>.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The subnet ID assigned to the new <code>DevEndpoint</code>.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the role assigned to the new
    /// <code>DevEndpoint</code>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The address of the YARN endpoint used by this <code>DevEndpoint</code>.</p>
    pub yarn_endpoint_address: std::option::Option<std::string::String>,
    /// <p>The Apache Zeppelin port for the remote Apache Spark interpreter.</p>
    pub zeppelin_remote_spark_interpreter_port: i32,
    /// <p>The number of Glue Data Processing Units (DPUs) allocated to this DevEndpoint.</p>
    pub number_of_nodes: i32,
    /// <p>The type of predefined worker that is allocated to the development endpoint. May be a value of Standard, G.1X, or G.2X.</p>
    pub worker_type: std::option::Option<crate::model::WorkerType>,
    /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p>
    ///
    /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
    pub glue_version: std::option::Option<std::string::String>,
    /// <p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p>
    pub number_of_workers: std::option::Option<i32>,
    /// <p>The AWS Availability Zone where this <code>DevEndpoint</code> is located.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The paths to one or more Python libraries in an S3 bucket that will be loaded in your
    /// <code>DevEndpoint</code>.</p>
    pub extra_python_libs_s3_path: std::option::Option<std::string::String>,
    /// <p>Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in
    /// your <code>DevEndpoint</code>.</p>
    pub extra_jars_s3_path: std::option::Option<std::string::String>,
    /// <p>The reason for a current failure in this <code>DevEndpoint</code>.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The name of the <code>SecurityConfiguration</code> structure being used with this
    /// <code>DevEndpoint</code>.</p>
    pub security_configuration: std::option::Option<std::string::String>,
    /// <p>The point in time at which this <code>DevEndpoint</code> was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The map of arguments used to configure this <code>DevEndpoint</code>.</p>
    ///
    /// <p>Valid arguments are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"--enable-glue-datacatalog": ""</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
    pub arguments:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateDevEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDevEndpointOutput");
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("status", &self.status);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("yarn_endpoint_address", &self.yarn_endpoint_address);
        formatter.field(
            "zeppelin_remote_spark_interpreter_port",
            &self.zeppelin_remote_spark_interpreter_port,
        );
        formatter.field("number_of_nodes", &self.number_of_nodes);
        formatter.field("worker_type", &self.worker_type);
        formatter.field("glue_version", &self.glue_version);
        formatter.field("number_of_workers", &self.number_of_workers);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("extra_python_libs_s3_path", &self.extra_python_libs_s3_path);
        formatter.field("extra_jars_s3_path", &self.extra_jars_s3_path);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("security_configuration", &self.security_configuration);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("arguments", &self.arguments);
        formatter.finish()
    }
}
/// See [`CreateDevEndpointOutput`](crate::output::CreateDevEndpointOutput)
pub mod create_dev_endpoint_output {
    /// A builder for [`CreateDevEndpointOutput`](crate::output::CreateDevEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) yarn_endpoint_address: std::option::Option<std::string::String>,
        pub(crate) zeppelin_remote_spark_interpreter_port: std::option::Option<i32>,
        pub(crate) number_of_nodes: std::option::Option<i32>,
        pub(crate) worker_type: std::option::Option<crate::model::WorkerType>,
        pub(crate) glue_version: std::option::Option<std::string::String>,
        pub(crate) number_of_workers: std::option::Option<i32>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) extra_python_libs_s3_path: std::option::Option<std::string::String>,
        pub(crate) extra_jars_s3_path: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) security_configuration: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) arguments: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name assigned to the new <code>DevEndpoint</code>.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name assigned to the new <code>DevEndpoint</code>.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The current status of the new <code>DevEndpoint</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the new <code>DevEndpoint</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security groups assigned to the new <code>DevEndpoint</code>.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The security groups assigned to the new <code>DevEndpoint</code>.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The subnet ID assigned to the new <code>DevEndpoint</code>.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID assigned to the new <code>DevEndpoint</code>.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role assigned to the new
        /// <code>DevEndpoint</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role assigned to the new
        /// <code>DevEndpoint</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The address of the YARN endpoint used by this <code>DevEndpoint</code>.</p>
        pub fn yarn_endpoint_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.yarn_endpoint_address = Some(input.into());
            self
        }
        /// <p>The address of the YARN endpoint used by this <code>DevEndpoint</code>.</p>
        pub fn set_yarn_endpoint_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.yarn_endpoint_address = input;
            self
        }
        /// <p>The Apache Zeppelin port for the remote Apache Spark interpreter.</p>
        pub fn zeppelin_remote_spark_interpreter_port(mut self, input: i32) -> Self {
            self.zeppelin_remote_spark_interpreter_port = Some(input);
            self
        }
        /// <p>The Apache Zeppelin port for the remote Apache Spark interpreter.</p>
        pub fn set_zeppelin_remote_spark_interpreter_port(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.zeppelin_remote_spark_interpreter_port = input;
            self
        }
        /// <p>The number of Glue Data Processing Units (DPUs) allocated to this DevEndpoint.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.number_of_nodes = Some(input);
            self
        }
        /// <p>The number of Glue Data Processing Units (DPUs) allocated to this DevEndpoint.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_nodes = input;
            self
        }
        /// <p>The type of predefined worker that is allocated to the development endpoint. May be a value of Standard, G.1X, or G.2X.</p>
        pub fn worker_type(mut self, input: crate::model::WorkerType) -> Self {
            self.worker_type = Some(input);
            self
        }
        /// <p>The type of predefined worker that is allocated to the development endpoint. May be a value of Standard, G.1X, or G.2X.</p>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.worker_type = input;
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        pub fn glue_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.glue_version = Some(input.into());
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.glue_version = input;
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p>
        pub fn number_of_workers(mut self, input: i32) -> Self {
            self.number_of_workers = Some(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_workers = input;
            self
        }
        /// <p>The AWS Availability Zone where this <code>DevEndpoint</code> is located.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The AWS Availability Zone where this <code>DevEndpoint</code> is located.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The paths to one or more Python libraries in an S3 bucket that will be loaded in your
        /// <code>DevEndpoint</code>.</p>
        pub fn extra_python_libs_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.extra_python_libs_s3_path = Some(input.into());
            self
        }
        /// <p>The paths to one or more Python libraries in an S3 bucket that will be loaded in your
        /// <code>DevEndpoint</code>.</p>
        pub fn set_extra_python_libs_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extra_python_libs_s3_path = input;
            self
        }
        /// <p>Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in
        /// your <code>DevEndpoint</code>.</p>
        pub fn extra_jars_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.extra_jars_s3_path = Some(input.into());
            self
        }
        /// <p>Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in
        /// your <code>DevEndpoint</code>.</p>
        pub fn set_extra_jars_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extra_jars_s3_path = input;
            self
        }
        /// <p>The reason for a current failure in this <code>DevEndpoint</code>.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason for a current failure in this <code>DevEndpoint</code>.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure being used with this
        /// <code>DevEndpoint</code>.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_configuration = Some(input.into());
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure being used with this
        /// <code>DevEndpoint</code>.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_configuration = input;
            self
        }
        /// <p>The point in time at which this <code>DevEndpoint</code> was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The point in time at which this <code>DevEndpoint</code> was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// Adds a key-value pair to `arguments`.
        ///
        /// To override the contents of this collection use [`set_arguments`](Self::set_arguments).
        ///
        /// <p>The map of arguments used to configure this <code>DevEndpoint</code>.</p>
        ///
        /// <p>Valid arguments are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"--enable-glue-datacatalog": ""</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
        pub fn arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.arguments.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.arguments = Some(hash_map);
            self
        }
        /// <p>The map of arguments used to configure this <code>DevEndpoint</code>.</p>
        ///
        /// <p>Valid arguments are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"--enable-glue-datacatalog": ""</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
        pub fn set_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.arguments = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDevEndpointOutput`](crate::output::CreateDevEndpointOutput)
        pub fn build(self) -> crate::output::CreateDevEndpointOutput {
            crate::output::CreateDevEndpointOutput {
                endpoint_name: self.endpoint_name,
                status: self.status,
                security_group_ids: self.security_group_ids,
                subnet_id: self.subnet_id,
                role_arn: self.role_arn,
                yarn_endpoint_address: self.yarn_endpoint_address,
                zeppelin_remote_spark_interpreter_port: self
                    .zeppelin_remote_spark_interpreter_port
                    .unwrap_or_default(),
                number_of_nodes: self.number_of_nodes.unwrap_or_default(),
                worker_type: self.worker_type,
                glue_version: self.glue_version,
                number_of_workers: self.number_of_workers,
                availability_zone: self.availability_zone,
                vpc_id: self.vpc_id,
                extra_python_libs_s3_path: self.extra_python_libs_s3_path,
                extra_jars_s3_path: self.extra_jars_s3_path,
                failure_reason: self.failure_reason,
                security_configuration: self.security_configuration,
                created_timestamp: self.created_timestamp,
                arguments: self.arguments,
            }
        }
    }
}
impl CreateDevEndpointOutput {
    /// Creates a new builder-style object to manufacture [`CreateDevEndpointOutput`](crate::output::CreateDevEndpointOutput)
    pub fn builder() -> crate::output::create_dev_endpoint_output::Builder {
        crate::output::create_dev_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatabaseOutput {}
impl std::fmt::Debug for CreateDatabaseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatabaseOutput");
        formatter.finish()
    }
}
/// See [`CreateDatabaseOutput`](crate::output::CreateDatabaseOutput)
pub mod create_database_output {
    /// A builder for [`CreateDatabaseOutput`](crate::output::CreateDatabaseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateDatabaseOutput`](crate::output::CreateDatabaseOutput)
        pub fn build(self) -> crate::output::CreateDatabaseOutput {
            crate::output::CreateDatabaseOutput {}
        }
    }
}
impl CreateDatabaseOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatabaseOutput`](crate::output::CreateDatabaseOutput)
    pub fn builder() -> crate::output::create_database_output::Builder {
        crate::output::create_database_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCrawlerOutput {}
impl std::fmt::Debug for CreateCrawlerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCrawlerOutput");
        formatter.finish()
    }
}
/// See [`CreateCrawlerOutput`](crate::output::CreateCrawlerOutput)
pub mod create_crawler_output {
    /// A builder for [`CreateCrawlerOutput`](crate::output::CreateCrawlerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateCrawlerOutput`](crate::output::CreateCrawlerOutput)
        pub fn build(self) -> crate::output::CreateCrawlerOutput {
            crate::output::CreateCrawlerOutput {}
        }
    }
}
impl CreateCrawlerOutput {
    /// Creates a new builder-style object to manufacture [`CreateCrawlerOutput`](crate::output::CreateCrawlerOutput)
    pub fn builder() -> crate::output::create_crawler_output::Builder {
        crate::output::create_crawler_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionOutput {}
impl std::fmt::Debug for CreateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionOutput");
        formatter.finish()
    }
}
/// See [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
pub mod create_connection_output {
    /// A builder for [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
        pub fn build(self) -> crate::output::CreateConnectionOutput {
            crate::output::CreateConnectionOutput {}
        }
    }
}
impl CreateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    pub fn builder() -> crate::output::create_connection_output::Builder {
        crate::output::create_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClassifierOutput {}
impl std::fmt::Debug for CreateClassifierOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClassifierOutput");
        formatter.finish()
    }
}
/// See [`CreateClassifierOutput`](crate::output::CreateClassifierOutput)
pub mod create_classifier_output {
    /// A builder for [`CreateClassifierOutput`](crate::output::CreateClassifierOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateClassifierOutput`](crate::output::CreateClassifierOutput)
        pub fn build(self) -> crate::output::CreateClassifierOutput {
            crate::output::CreateClassifierOutput {}
        }
    }
}
impl CreateClassifierOutput {
    /// Creates a new builder-style object to manufacture [`CreateClassifierOutput`](crate::output::CreateClassifierOutput)
    pub fn builder() -> crate::output::create_classifier_output::Builder {
        crate::output::create_classifier_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBlueprintOutput {
    /// <p>Returns the name of the blueprint that was registered.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateBlueprintOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBlueprintOutput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CreateBlueprintOutput`](crate::output::CreateBlueprintOutput)
pub mod create_blueprint_output {
    /// A builder for [`CreateBlueprintOutput`](crate::output::CreateBlueprintOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns the name of the blueprint that was registered.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Returns the name of the blueprint that was registered.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBlueprintOutput`](crate::output::CreateBlueprintOutput)
        pub fn build(self) -> crate::output::CreateBlueprintOutput {
            crate::output::CreateBlueprintOutput { name: self.name }
        }
    }
}
impl CreateBlueprintOutput {
    /// Creates a new builder-style object to manufacture [`CreateBlueprintOutput`](crate::output::CreateBlueprintOutput)
    pub fn builder() -> crate::output::create_blueprint_output::Builder {
        crate::output::create_blueprint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckSchemaVersionValidityOutput {
    /// <p>Return true, if the schema is valid and false otherwise.</p>
    pub valid: bool,
    /// <p>A validation failure error message.</p>
    pub error: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CheckSchemaVersionValidityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckSchemaVersionValidityOutput");
        formatter.field("valid", &self.valid);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`CheckSchemaVersionValidityOutput`](crate::output::CheckSchemaVersionValidityOutput)
pub mod check_schema_version_validity_output {
    /// A builder for [`CheckSchemaVersionValidityOutput`](crate::output::CheckSchemaVersionValidityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) valid: std::option::Option<bool>,
        pub(crate) error: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Return true, if the schema is valid and false otherwise.</p>
        pub fn valid(mut self, input: bool) -> Self {
            self.valid = Some(input);
            self
        }
        /// <p>Return true, if the schema is valid and false otherwise.</p>
        pub fn set_valid(mut self, input: std::option::Option<bool>) -> Self {
            self.valid = input;
            self
        }
        /// <p>A validation failure error message.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>A validation failure error message.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckSchemaVersionValidityOutput`](crate::output::CheckSchemaVersionValidityOutput)
        pub fn build(self) -> crate::output::CheckSchemaVersionValidityOutput {
            crate::output::CheckSchemaVersionValidityOutput {
                valid: self.valid.unwrap_or_default(),
                error: self.error,
            }
        }
    }
}
impl CheckSchemaVersionValidityOutput {
    /// Creates a new builder-style object to manufacture [`CheckSchemaVersionValidityOutput`](crate::output::CheckSchemaVersionValidityOutput)
    pub fn builder() -> crate::output::check_schema_version_validity_output::Builder {
        crate::output::check_schema_version_validity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelMlTaskRunOutput {
    /// <p>The unique identifier of the machine learning transform.</p>
    pub transform_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the task run.</p>
    pub task_run_id: std::option::Option<std::string::String>,
    /// <p>The status for this run.</p>
    pub status: std::option::Option<crate::model::TaskStatusType>,
}
impl std::fmt::Debug for CancelMlTaskRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelMlTaskRunOutput");
        formatter.field("transform_id", &self.transform_id);
        formatter.field("task_run_id", &self.task_run_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CancelMlTaskRunOutput`](crate::output::CancelMlTaskRunOutput)
pub mod cancel_ml_task_run_output {
    /// A builder for [`CancelMlTaskRunOutput`](crate::output::CancelMlTaskRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_id: std::option::Option<std::string::String>,
        pub(crate) task_run_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TaskStatusType>,
    }
    impl Builder {
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn transform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the machine learning transform.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.transform_id = input;
            self
        }
        /// <p>The unique identifier for the task run.</p>
        pub fn task_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_run_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the task run.</p>
        pub fn set_task_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_run_id = input;
            self
        }
        /// <p>The status for this run.</p>
        pub fn status(mut self, input: crate::model::TaskStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status for this run.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelMlTaskRunOutput`](crate::output::CancelMlTaskRunOutput)
        pub fn build(self) -> crate::output::CancelMlTaskRunOutput {
            crate::output::CancelMlTaskRunOutput {
                transform_id: self.transform_id,
                task_run_id: self.task_run_id,
                status: self.status,
            }
        }
    }
}
impl CancelMlTaskRunOutput {
    /// Creates a new builder-style object to manufacture [`CancelMlTaskRunOutput`](crate::output::CancelMlTaskRunOutput)
    pub fn builder() -> crate::output::cancel_ml_task_run_output::Builder {
        crate::output::cancel_ml_task_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdatePartitionOutput {
    /// <p>The errors encountered when trying to update the requested partitions. A list of <code>BatchUpdatePartitionFailureEntry</code> objects.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchUpdatePartitionFailureEntry>>,
}
impl std::fmt::Debug for BatchUpdatePartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdatePartitionOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchUpdatePartitionOutput`](crate::output::BatchUpdatePartitionOutput)
pub mod batch_update_partition_output {
    /// A builder for [`BatchUpdatePartitionOutput`](crate::output::BatchUpdatePartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchUpdatePartitionFailureEntry>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>The errors encountered when trying to update the requested partitions. A list of <code>BatchUpdatePartitionFailureEntry</code> objects.</p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::BatchUpdatePartitionFailureEntry>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>The errors encountered when trying to update the requested partitions. A list of <code>BatchUpdatePartitionFailureEntry</code> objects.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BatchUpdatePartitionFailureEntry>,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdatePartitionOutput`](crate::output::BatchUpdatePartitionOutput)
        pub fn build(self) -> crate::output::BatchUpdatePartitionOutput {
            crate::output::BatchUpdatePartitionOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchUpdatePartitionOutput {
    /// Creates a new builder-style object to manufacture [`BatchUpdatePartitionOutput`](crate::output::BatchUpdatePartitionOutput)
    pub fn builder() -> crate::output::batch_update_partition_output::Builder {
        crate::output::batch_update_partition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchStopJobRunOutput {
    /// <p>A list of the JobRuns that were successfully submitted for stopping.</p>
    pub successful_submissions:
        std::option::Option<std::vec::Vec<crate::model::BatchStopJobRunSuccessfulSubmission>>,
    /// <p>A list of the errors that were encountered in trying to stop <code>JobRuns</code>,
    /// including the <code>JobRunId</code> for which each error was encountered and details about the
    /// error.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchStopJobRunError>>,
}
impl std::fmt::Debug for BatchStopJobRunOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchStopJobRunOutput");
        formatter.field("successful_submissions", &self.successful_submissions);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchStopJobRunOutput`](crate::output::BatchStopJobRunOutput)
pub mod batch_stop_job_run_output {
    /// A builder for [`BatchStopJobRunOutput`](crate::output::BatchStopJobRunOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful_submissions:
            std::option::Option<std::vec::Vec<crate::model::BatchStopJobRunSuccessfulSubmission>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::BatchStopJobRunError>>,
    }
    impl Builder {
        /// Appends an item to `successful_submissions`.
        ///
        /// To override the contents of this collection use [`set_successful_submissions`](Self::set_successful_submissions).
        ///
        /// <p>A list of the JobRuns that were successfully submitted for stopping.</p>
        pub fn successful_submissions(
            mut self,
            input: impl Into<crate::model::BatchStopJobRunSuccessfulSubmission>,
        ) -> Self {
            let mut v = self.successful_submissions.unwrap_or_default();
            v.push(input.into());
            self.successful_submissions = Some(v);
            self
        }
        /// <p>A list of the JobRuns that were successfully submitted for stopping.</p>
        pub fn set_successful_submissions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BatchStopJobRunSuccessfulSubmission>,
            >,
        ) -> Self {
            self.successful_submissions = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of the errors that were encountered in trying to stop <code>JobRuns</code>,
        /// including the <code>JobRunId</code> for which each error was encountered and details about the
        /// error.</p>
        pub fn errors(mut self, input: impl Into<crate::model::BatchStopJobRunError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>A list of the errors that were encountered in trying to stop <code>JobRuns</code>,
        /// including the <code>JobRunId</code> for which each error was encountered and details about the
        /// error.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchStopJobRunError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchStopJobRunOutput`](crate::output::BatchStopJobRunOutput)
        pub fn build(self) -> crate::output::BatchStopJobRunOutput {
            crate::output::BatchStopJobRunOutput {
                successful_submissions: self.successful_submissions,
                errors: self.errors,
            }
        }
    }
}
impl BatchStopJobRunOutput {
    /// Creates a new builder-style object to manufacture [`BatchStopJobRunOutput`](crate::output::BatchStopJobRunOutput)
    pub fn builder() -> crate::output::batch_stop_job_run_output::Builder {
        crate::output::batch_stop_job_run_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetWorkflowsOutput {
    /// <p>A list of workflow resource metadata.</p>
    pub workflows: std::option::Option<std::vec::Vec<crate::model::Workflow>>,
    /// <p>A list of names of workflows not found.</p>
    pub missing_workflows: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetWorkflowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetWorkflowsOutput");
        formatter.field("workflows", &self.workflows);
        formatter.field("missing_workflows", &self.missing_workflows);
        formatter.finish()
    }
}
/// See [`BatchGetWorkflowsOutput`](crate::output::BatchGetWorkflowsOutput)
pub mod batch_get_workflows_output {
    /// A builder for [`BatchGetWorkflowsOutput`](crate::output::BatchGetWorkflowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workflows: std::option::Option<std::vec::Vec<crate::model::Workflow>>,
        pub(crate) missing_workflows: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `workflows`.
        ///
        /// To override the contents of this collection use [`set_workflows`](Self::set_workflows).
        ///
        /// <p>A list of workflow resource metadata.</p>
        pub fn workflows(mut self, input: impl Into<crate::model::Workflow>) -> Self {
            let mut v = self.workflows.unwrap_or_default();
            v.push(input.into());
            self.workflows = Some(v);
            self
        }
        /// <p>A list of workflow resource metadata.</p>
        pub fn set_workflows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Workflow>>,
        ) -> Self {
            self.workflows = input;
            self
        }
        /// Appends an item to `missing_workflows`.
        ///
        /// To override the contents of this collection use [`set_missing_workflows`](Self::set_missing_workflows).
        ///
        /// <p>A list of names of workflows not found.</p>
        pub fn missing_workflows(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.missing_workflows.unwrap_or_default();
            v.push(input.into());
            self.missing_workflows = Some(v);
            self
        }
        /// <p>A list of names of workflows not found.</p>
        pub fn set_missing_workflows(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.missing_workflows = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetWorkflowsOutput`](crate::output::BatchGetWorkflowsOutput)
        pub fn build(self) -> crate::output::BatchGetWorkflowsOutput {
            crate::output::BatchGetWorkflowsOutput {
                workflows: self.workflows,
                missing_workflows: self.missing_workflows,
            }
        }
    }
}
impl BatchGetWorkflowsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetWorkflowsOutput`](crate::output::BatchGetWorkflowsOutput)
    pub fn builder() -> crate::output::batch_get_workflows_output::Builder {
        crate::output::batch_get_workflows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetTriggersOutput {
    /// <p>A list of trigger definitions.</p>
    pub triggers: std::option::Option<std::vec::Vec<crate::model::Trigger>>,
    /// <p>A list of names of triggers not found.</p>
    pub triggers_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetTriggersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetTriggersOutput");
        formatter.field("triggers", &self.triggers);
        formatter.field("triggers_not_found", &self.triggers_not_found);
        formatter.finish()
    }
}
/// See [`BatchGetTriggersOutput`](crate::output::BatchGetTriggersOutput)
pub mod batch_get_triggers_output {
    /// A builder for [`BatchGetTriggersOutput`](crate::output::BatchGetTriggersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) triggers: std::option::Option<std::vec::Vec<crate::model::Trigger>>,
        pub(crate) triggers_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>A list of trigger definitions.</p>
        pub fn triggers(mut self, input: impl Into<crate::model::Trigger>) -> Self {
            let mut v = self.triggers.unwrap_or_default();
            v.push(input.into());
            self.triggers = Some(v);
            self
        }
        /// <p>A list of trigger definitions.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Trigger>>,
        ) -> Self {
            self.triggers = input;
            self
        }
        /// Appends an item to `triggers_not_found`.
        ///
        /// To override the contents of this collection use [`set_triggers_not_found`](Self::set_triggers_not_found).
        ///
        /// <p>A list of names of triggers not found.</p>
        pub fn triggers_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.triggers_not_found.unwrap_or_default();
            v.push(input.into());
            self.triggers_not_found = Some(v);
            self
        }
        /// <p>A list of names of triggers not found.</p>
        pub fn set_triggers_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.triggers_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetTriggersOutput`](crate::output::BatchGetTriggersOutput)
        pub fn build(self) -> crate::output::BatchGetTriggersOutput {
            crate::output::BatchGetTriggersOutput {
                triggers: self.triggers,
                triggers_not_found: self.triggers_not_found,
            }
        }
    }
}
impl BatchGetTriggersOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetTriggersOutput`](crate::output::BatchGetTriggersOutput)
    pub fn builder() -> crate::output::batch_get_triggers_output::Builder {
        crate::output::batch_get_triggers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetPartitionOutput {
    /// <p>A list of the requested partitions.</p>
    pub partitions: std::option::Option<std::vec::Vec<crate::model::Partition>>,
    /// <p>A list of the partition values in the request for which partitions were not
    /// returned.</p>
    pub unprocessed_keys: std::option::Option<std::vec::Vec<crate::model::PartitionValueList>>,
}
impl std::fmt::Debug for BatchGetPartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetPartitionOutput");
        formatter.field("partitions", &self.partitions);
        formatter.field("unprocessed_keys", &self.unprocessed_keys);
        formatter.finish()
    }
}
/// See [`BatchGetPartitionOutput`](crate::output::BatchGetPartitionOutput)
pub mod batch_get_partition_output {
    /// A builder for [`BatchGetPartitionOutput`](crate::output::BatchGetPartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partitions: std::option::Option<std::vec::Vec<crate::model::Partition>>,
        pub(crate) unprocessed_keys:
            std::option::Option<std::vec::Vec<crate::model::PartitionValueList>>,
    }
    impl Builder {
        /// Appends an item to `partitions`.
        ///
        /// To override the contents of this collection use [`set_partitions`](Self::set_partitions).
        ///
        /// <p>A list of the requested partitions.</p>
        pub fn partitions(mut self, input: impl Into<crate::model::Partition>) -> Self {
            let mut v = self.partitions.unwrap_or_default();
            v.push(input.into());
            self.partitions = Some(v);
            self
        }
        /// <p>A list of the requested partitions.</p>
        pub fn set_partitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Partition>>,
        ) -> Self {
            self.partitions = input;
            self
        }
        /// Appends an item to `unprocessed_keys`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_keys`](Self::set_unprocessed_keys).
        ///
        /// <p>A list of the partition values in the request for which partitions were not
        /// returned.</p>
        pub fn unprocessed_keys(
            mut self,
            input: impl Into<crate::model::PartitionValueList>,
        ) -> Self {
            let mut v = self.unprocessed_keys.unwrap_or_default();
            v.push(input.into());
            self.unprocessed_keys = Some(v);
            self
        }
        /// <p>A list of the partition values in the request for which partitions were not
        /// returned.</p>
        pub fn set_unprocessed_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartitionValueList>>,
        ) -> Self {
            self.unprocessed_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetPartitionOutput`](crate::output::BatchGetPartitionOutput)
        pub fn build(self) -> crate::output::BatchGetPartitionOutput {
            crate::output::BatchGetPartitionOutput {
                partitions: self.partitions,
                unprocessed_keys: self.unprocessed_keys,
            }
        }
    }
}
impl BatchGetPartitionOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetPartitionOutput`](crate::output::BatchGetPartitionOutput)
    pub fn builder() -> crate::output::batch_get_partition_output::Builder {
        crate::output::batch_get_partition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetJobsOutput {
    /// <p>A list of job definitions.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
    /// <p>A list of names of jobs not found.</p>
    pub jobs_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("jobs_not_found", &self.jobs_not_found);
        formatter.finish()
    }
}
/// See [`BatchGetJobsOutput`](crate::output::BatchGetJobsOutput)
pub mod batch_get_jobs_output {
    /// A builder for [`BatchGetJobsOutput`](crate::output::BatchGetJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
        pub(crate) jobs_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>A list of job definitions.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::Job>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>A list of job definitions.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// Appends an item to `jobs_not_found`.
        ///
        /// To override the contents of this collection use [`set_jobs_not_found`](Self::set_jobs_not_found).
        ///
        /// <p>A list of names of jobs not found.</p>
        pub fn jobs_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.jobs_not_found.unwrap_or_default();
            v.push(input.into());
            self.jobs_not_found = Some(v);
            self
        }
        /// <p>A list of names of jobs not found.</p>
        pub fn set_jobs_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.jobs_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetJobsOutput`](crate::output::BatchGetJobsOutput)
        pub fn build(self) -> crate::output::BatchGetJobsOutput {
            crate::output::BatchGetJobsOutput {
                jobs: self.jobs,
                jobs_not_found: self.jobs_not_found,
            }
        }
    }
}
impl BatchGetJobsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetJobsOutput`](crate::output::BatchGetJobsOutput)
    pub fn builder() -> crate::output::batch_get_jobs_output::Builder {
        crate::output::batch_get_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDevEndpointsOutput {
    /// <p>A list of <code>DevEndpoint</code> definitions.</p>
    pub dev_endpoints: std::option::Option<std::vec::Vec<crate::model::DevEndpoint>>,
    /// <p>A list of <code>DevEndpoints</code> not found.</p>
    pub dev_endpoints_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetDevEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDevEndpointsOutput");
        formatter.field("dev_endpoints", &self.dev_endpoints);
        formatter.field("dev_endpoints_not_found", &self.dev_endpoints_not_found);
        formatter.finish()
    }
}
/// See [`BatchGetDevEndpointsOutput`](crate::output::BatchGetDevEndpointsOutput)
pub mod batch_get_dev_endpoints_output {
    /// A builder for [`BatchGetDevEndpointsOutput`](crate::output::BatchGetDevEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dev_endpoints: std::option::Option<std::vec::Vec<crate::model::DevEndpoint>>,
        pub(crate) dev_endpoints_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `dev_endpoints`.
        ///
        /// To override the contents of this collection use [`set_dev_endpoints`](Self::set_dev_endpoints).
        ///
        /// <p>A list of <code>DevEndpoint</code> definitions.</p>
        pub fn dev_endpoints(mut self, input: impl Into<crate::model::DevEndpoint>) -> Self {
            let mut v = self.dev_endpoints.unwrap_or_default();
            v.push(input.into());
            self.dev_endpoints = Some(v);
            self
        }
        /// <p>A list of <code>DevEndpoint</code> definitions.</p>
        pub fn set_dev_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevEndpoint>>,
        ) -> Self {
            self.dev_endpoints = input;
            self
        }
        /// Appends an item to `dev_endpoints_not_found`.
        ///
        /// To override the contents of this collection use [`set_dev_endpoints_not_found`](Self::set_dev_endpoints_not_found).
        ///
        /// <p>A list of <code>DevEndpoints</code> not found.</p>
        pub fn dev_endpoints_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dev_endpoints_not_found.unwrap_or_default();
            v.push(input.into());
            self.dev_endpoints_not_found = Some(v);
            self
        }
        /// <p>A list of <code>DevEndpoints</code> not found.</p>
        pub fn set_dev_endpoints_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dev_endpoints_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDevEndpointsOutput`](crate::output::BatchGetDevEndpointsOutput)
        pub fn build(self) -> crate::output::BatchGetDevEndpointsOutput {
            crate::output::BatchGetDevEndpointsOutput {
                dev_endpoints: self.dev_endpoints,
                dev_endpoints_not_found: self.dev_endpoints_not_found,
            }
        }
    }
}
impl BatchGetDevEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetDevEndpointsOutput`](crate::output::BatchGetDevEndpointsOutput)
    pub fn builder() -> crate::output::batch_get_dev_endpoints_output::Builder {
        crate::output::batch_get_dev_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetCrawlersOutput {
    /// <p>A list of crawler definitions.</p>
    pub crawlers: std::option::Option<std::vec::Vec<crate::model::Crawler>>,
    /// <p>A list of names of crawlers that were not found.</p>
    pub crawlers_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetCrawlersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetCrawlersOutput");
        formatter.field("crawlers", &self.crawlers);
        formatter.field("crawlers_not_found", &self.crawlers_not_found);
        formatter.finish()
    }
}
/// See [`BatchGetCrawlersOutput`](crate::output::BatchGetCrawlersOutput)
pub mod batch_get_crawlers_output {
    /// A builder for [`BatchGetCrawlersOutput`](crate::output::BatchGetCrawlersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawlers: std::option::Option<std::vec::Vec<crate::model::Crawler>>,
        pub(crate) crawlers_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `crawlers`.
        ///
        /// To override the contents of this collection use [`set_crawlers`](Self::set_crawlers).
        ///
        /// <p>A list of crawler definitions.</p>
        pub fn crawlers(mut self, input: impl Into<crate::model::Crawler>) -> Self {
            let mut v = self.crawlers.unwrap_or_default();
            v.push(input.into());
            self.crawlers = Some(v);
            self
        }
        /// <p>A list of crawler definitions.</p>
        pub fn set_crawlers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Crawler>>,
        ) -> Self {
            self.crawlers = input;
            self
        }
        /// Appends an item to `crawlers_not_found`.
        ///
        /// To override the contents of this collection use [`set_crawlers_not_found`](Self::set_crawlers_not_found).
        ///
        /// <p>A list of names of crawlers that were not found.</p>
        pub fn crawlers_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.crawlers_not_found.unwrap_or_default();
            v.push(input.into());
            self.crawlers_not_found = Some(v);
            self
        }
        /// <p>A list of names of crawlers that were not found.</p>
        pub fn set_crawlers_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.crawlers_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetCrawlersOutput`](crate::output::BatchGetCrawlersOutput)
        pub fn build(self) -> crate::output::BatchGetCrawlersOutput {
            crate::output::BatchGetCrawlersOutput {
                crawlers: self.crawlers,
                crawlers_not_found: self.crawlers_not_found,
            }
        }
    }
}
impl BatchGetCrawlersOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetCrawlersOutput`](crate::output::BatchGetCrawlersOutput)
    pub fn builder() -> crate::output::batch_get_crawlers_output::Builder {
        crate::output::batch_get_crawlers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetBlueprintsOutput {
    /// <p>Returns a list of blueprint as a <code>Blueprints</code> object.</p>
    pub blueprints: std::option::Option<std::vec::Vec<crate::model::Blueprint>>,
    /// <p>Returns a list of <code>BlueprintNames</code> that were not found.</p>
    pub missing_blueprints: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetBlueprintsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetBlueprintsOutput");
        formatter.field("blueprints", &self.blueprints);
        formatter.field("missing_blueprints", &self.missing_blueprints);
        formatter.finish()
    }
}
/// See [`BatchGetBlueprintsOutput`](crate::output::BatchGetBlueprintsOutput)
pub mod batch_get_blueprints_output {
    /// A builder for [`BatchGetBlueprintsOutput`](crate::output::BatchGetBlueprintsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blueprints: std::option::Option<std::vec::Vec<crate::model::Blueprint>>,
        pub(crate) missing_blueprints: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `blueprints`.
        ///
        /// To override the contents of this collection use [`set_blueprints`](Self::set_blueprints).
        ///
        /// <p>Returns a list of blueprint as a <code>Blueprints</code> object.</p>
        pub fn blueprints(mut self, input: impl Into<crate::model::Blueprint>) -> Self {
            let mut v = self.blueprints.unwrap_or_default();
            v.push(input.into());
            self.blueprints = Some(v);
            self
        }
        /// <p>Returns a list of blueprint as a <code>Blueprints</code> object.</p>
        pub fn set_blueprints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Blueprint>>,
        ) -> Self {
            self.blueprints = input;
            self
        }
        /// Appends an item to `missing_blueprints`.
        ///
        /// To override the contents of this collection use [`set_missing_blueprints`](Self::set_missing_blueprints).
        ///
        /// <p>Returns a list of <code>BlueprintNames</code> that were not found.</p>
        pub fn missing_blueprints(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.missing_blueprints.unwrap_or_default();
            v.push(input.into());
            self.missing_blueprints = Some(v);
            self
        }
        /// <p>Returns a list of <code>BlueprintNames</code> that were not found.</p>
        pub fn set_missing_blueprints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.missing_blueprints = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetBlueprintsOutput`](crate::output::BatchGetBlueprintsOutput)
        pub fn build(self) -> crate::output::BatchGetBlueprintsOutput {
            crate::output::BatchGetBlueprintsOutput {
                blueprints: self.blueprints,
                missing_blueprints: self.missing_blueprints,
            }
        }
    }
}
impl BatchGetBlueprintsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetBlueprintsOutput`](crate::output::BatchGetBlueprintsOutput)
    pub fn builder() -> crate::output::batch_get_blueprints_output::Builder {
        crate::output::batch_get_blueprints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteTableVersionOutput {
    /// <p>A list of errors encountered while trying to delete
    /// the specified table versions.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::TableVersionError>>,
}
impl std::fmt::Debug for BatchDeleteTableVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteTableVersionOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDeleteTableVersionOutput`](crate::output::BatchDeleteTableVersionOutput)
pub mod batch_delete_table_version_output {
    /// A builder for [`BatchDeleteTableVersionOutput`](crate::output::BatchDeleteTableVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::TableVersionError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of errors encountered while trying to delete
        /// the specified table versions.</p>
        pub fn errors(mut self, input: impl Into<crate::model::TableVersionError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>A list of errors encountered while trying to delete
        /// the specified table versions.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableVersionError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteTableVersionOutput`](crate::output::BatchDeleteTableVersionOutput)
        pub fn build(self) -> crate::output::BatchDeleteTableVersionOutput {
            crate::output::BatchDeleteTableVersionOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchDeleteTableVersionOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteTableVersionOutput`](crate::output::BatchDeleteTableVersionOutput)
    pub fn builder() -> crate::output::batch_delete_table_version_output::Builder {
        crate::output::batch_delete_table_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteTableOutput {
    /// <p>A list of errors encountered in attempting to delete the specified tables.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::TableError>>,
}
impl std::fmt::Debug for BatchDeleteTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteTableOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDeleteTableOutput`](crate::output::BatchDeleteTableOutput)
pub mod batch_delete_table_output {
    /// A builder for [`BatchDeleteTableOutput`](crate::output::BatchDeleteTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::TableError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of errors encountered in attempting to delete the specified tables.</p>
        pub fn errors(mut self, input: impl Into<crate::model::TableError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>A list of errors encountered in attempting to delete the specified tables.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteTableOutput`](crate::output::BatchDeleteTableOutput)
        pub fn build(self) -> crate::output::BatchDeleteTableOutput {
            crate::output::BatchDeleteTableOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchDeleteTableOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteTableOutput`](crate::output::BatchDeleteTableOutput)
    pub fn builder() -> crate::output::batch_delete_table_output::Builder {
        crate::output::batch_delete_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeletePartitionOutput {
    /// <p>The errors encountered when trying to delete the requested partitions.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::PartitionError>>,
}
impl std::fmt::Debug for BatchDeletePartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeletePartitionOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDeletePartitionOutput`](crate::output::BatchDeletePartitionOutput)
pub mod batch_delete_partition_output {
    /// A builder for [`BatchDeletePartitionOutput`](crate::output::BatchDeletePartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::PartitionError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>The errors encountered when trying to delete the requested partitions.</p>
        pub fn errors(mut self, input: impl Into<crate::model::PartitionError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>The errors encountered when trying to delete the requested partitions.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartitionError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeletePartitionOutput`](crate::output::BatchDeletePartitionOutput)
        pub fn build(self) -> crate::output::BatchDeletePartitionOutput {
            crate::output::BatchDeletePartitionOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchDeletePartitionOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeletePartitionOutput`](crate::output::BatchDeletePartitionOutput)
    pub fn builder() -> crate::output::batch_delete_partition_output::Builder {
        crate::output::batch_delete_partition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteConnectionOutput {
    /// <p>A list of names of the connection definitions that were
    /// successfully deleted.</p>
    pub succeeded: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A map of the names of connections that were not successfully
    /// deleted to error details.</p>
    pub errors: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ErrorDetail>,
    >,
}
impl std::fmt::Debug for BatchDeleteConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteConnectionOutput");
        formatter.field("succeeded", &self.succeeded);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDeleteConnectionOutput`](crate::output::BatchDeleteConnectionOutput)
pub mod batch_delete_connection_output {
    /// A builder for [`BatchDeleteConnectionOutput`](crate::output::BatchDeleteConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) succeeded: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) errors: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ErrorDetail>,
        >,
    }
    impl Builder {
        /// Appends an item to `succeeded`.
        ///
        /// To override the contents of this collection use [`set_succeeded`](Self::set_succeeded).
        ///
        /// <p>A list of names of the connection definitions that were
        /// successfully deleted.</p>
        pub fn succeeded(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.succeeded.unwrap_or_default();
            v.push(input.into());
            self.succeeded = Some(v);
            self
        }
        /// <p>A list of names of the connection definitions that were
        /// successfully deleted.</p>
        pub fn set_succeeded(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.succeeded = input;
            self
        }
        /// Adds a key-value pair to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A map of the names of connections that were not successfully
        /// deleted to error details.</p>
        pub fn errors(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ErrorDetail>,
        ) -> Self {
            let mut hash_map = self.errors.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.errors = Some(hash_map);
            self
        }
        /// <p>A map of the names of connections that were not successfully
        /// deleted to error details.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ErrorDetail>,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteConnectionOutput`](crate::output::BatchDeleteConnectionOutput)
        pub fn build(self) -> crate::output::BatchDeleteConnectionOutput {
            crate::output::BatchDeleteConnectionOutput {
                succeeded: self.succeeded,
                errors: self.errors,
            }
        }
    }
}
impl BatchDeleteConnectionOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteConnectionOutput`](crate::output::BatchDeleteConnectionOutput)
    pub fn builder() -> crate::output::batch_delete_connection_output::Builder {
        crate::output::batch_delete_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreatePartitionOutput {
    /// <p>The errors encountered when trying to create the requested partitions.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::PartitionError>>,
}
impl std::fmt::Debug for BatchCreatePartitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreatePartitionOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchCreatePartitionOutput`](crate::output::BatchCreatePartitionOutput)
pub mod batch_create_partition_output {
    /// A builder for [`BatchCreatePartitionOutput`](crate::output::BatchCreatePartitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::PartitionError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>The errors encountered when trying to create the requested partitions.</p>
        pub fn errors(mut self, input: impl Into<crate::model::PartitionError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>The errors encountered when trying to create the requested partitions.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartitionError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreatePartitionOutput`](crate::output::BatchCreatePartitionOutput)
        pub fn build(self) -> crate::output::BatchCreatePartitionOutput {
            crate::output::BatchCreatePartitionOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchCreatePartitionOutput {
    /// Creates a new builder-style object to manufacture [`BatchCreatePartitionOutput`](crate::output::BatchCreatePartitionOutput)
    pub fn builder() -> crate::output::batch_create_partition_output::Builder {
        crate::output::batch_create_partition_output::Builder::default()
    }
}
