// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A structure used to create or update a user-defined function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserDefinedFunctionInput {
    /// <p>The name of the function.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The Java class that contains the function code.</p>
    pub class_name: std::option::Option<std::string::String>,
    /// <p>The owner of the function.</p>
    pub owner_name: std::option::Option<std::string::String>,
    /// <p>The owner type.</p>
    pub owner_type: std::option::Option<crate::model::PrincipalType>,
    /// <p>The resource URIs for the function.</p>
    pub resource_uris: std::option::Option<std::vec::Vec<crate::model::ResourceUri>>,
}
impl std::fmt::Debug for UserDefinedFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserDefinedFunctionInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("class_name", &self.class_name);
        formatter.field("owner_name", &self.owner_name);
        formatter.field("owner_type", &self.owner_type);
        formatter.field("resource_uris", &self.resource_uris);
        formatter.finish()
    }
}
/// See [`UserDefinedFunctionInput`](crate::model::UserDefinedFunctionInput)
pub mod user_defined_function_input {
    /// A builder for [`UserDefinedFunctionInput`](crate::model::UserDefinedFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) class_name: std::option::Option<std::string::String>,
        pub(crate) owner_name: std::option::Option<std::string::String>,
        pub(crate) owner_type: std::option::Option<crate::model::PrincipalType>,
        pub(crate) resource_uris: std::option::Option<std::vec::Vec<crate::model::ResourceUri>>,
    }
    impl Builder {
        /// <p>The name of the function.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the function.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The Java class that contains the function code.</p>
        pub fn class_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.class_name = Some(input.into());
            self
        }
        /// <p>The Java class that contains the function code.</p>
        pub fn set_class_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.class_name = input;
            self
        }
        /// <p>The owner of the function.</p>
        pub fn owner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_name = Some(input.into());
            self
        }
        /// <p>The owner of the function.</p>
        pub fn set_owner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_name = input;
            self
        }
        /// <p>The owner type.</p>
        pub fn owner_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.owner_type = Some(input);
            self
        }
        /// <p>The owner type.</p>
        pub fn set_owner_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.owner_type = input;
            self
        }
        /// Appends an item to `resource_uris`.
        ///
        /// To override the contents of this collection use [`set_resource_uris`](Self::set_resource_uris).
        ///
        /// <p>The resource URIs for the function.</p>
        pub fn resource_uris(mut self, input: impl Into<crate::model::ResourceUri>) -> Self {
            let mut v = self.resource_uris.unwrap_or_default();
            v.push(input.into());
            self.resource_uris = Some(v);
            self
        }
        /// <p>The resource URIs for the function.</p>
        pub fn set_resource_uris(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceUri>>,
        ) -> Self {
            self.resource_uris = input;
            self
        }
        /// Consumes the builder and constructs a [`UserDefinedFunctionInput`](crate::model::UserDefinedFunctionInput)
        pub fn build(self) -> crate::model::UserDefinedFunctionInput {
            crate::model::UserDefinedFunctionInput {
                function_name: self.function_name,
                class_name: self.class_name,
                owner_name: self.owner_name,
                owner_type: self.owner_type,
                resource_uris: self.resource_uris,
            }
        }
    }
}
impl UserDefinedFunctionInput {
    /// Creates a new builder-style object to manufacture [`UserDefinedFunctionInput`](crate::model::UserDefinedFunctionInput)
    pub fn builder() -> crate::model::user_defined_function_input::Builder {
        crate::model::user_defined_function_input::Builder::default()
    }
}

/// <p>The URIs for function resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceUri {
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The URI for accessing the resource.</p>
    pub uri: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceUri {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceUri");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("uri", &self.uri);
        formatter.finish()
    }
}
/// See [`ResourceUri`](crate::model::ResourceUri)
pub mod resource_uri {
    /// A builder for [`ResourceUri`](crate::model::ResourceUri)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The URI for accessing the resource.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The URI for accessing the resource.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceUri`](crate::model::ResourceUri)
        pub fn build(self) -> crate::model::ResourceUri {
            crate::model::ResourceUri {
                resource_type: self.resource_type,
                uri: self.uri,
            }
        }
    }
}
impl ResourceUri {
    /// Creates a new builder-style object to manufacture [`ResourceUri`](crate::model::ResourceUri)
    pub fn builder() -> crate::model::resource_uri::Builder {
        crate::model::resource_uri::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Archive,
    #[allow(missing_docs)] // documentation missing in model
    File,
    #[allow(missing_docs)] // documentation missing in model
    Jar,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "ARCHIVE" => ResourceType::Archive,
            "FILE" => ResourceType::File,
            "JAR" => ResourceType::Jar,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Archive => "ARCHIVE",
            ResourceType::File => "FILE",
            ResourceType::Jar => "JAR",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ARCHIVE", "FILE", "JAR"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PrincipalType {
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    Role,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PrincipalType {
    fn from(s: &str) -> Self {
        match s {
            "GROUP" => PrincipalType::Group,
            "ROLE" => PrincipalType::Role,
            "USER" => PrincipalType::User,
            other => PrincipalType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PrincipalType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PrincipalType::from(s))
    }
}
impl PrincipalType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PrincipalType::Group => "GROUP",
            PrincipalType::Role => "ROLE",
            PrincipalType::User => "USER",
            PrincipalType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GROUP", "ROLE", "USER"]
    }
}
impl AsRef<str> for PrincipalType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a specific trigger.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Trigger {
    /// <p>The name of the trigger.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the workflow associated with the trigger.</p>
    pub workflow_name: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of trigger that this is.</p>
    pub r#type: std::option::Option<crate::model::TriggerType>,
    /// <p>The current state of the trigger.</p>
    pub state: std::option::Option<crate::model::TriggerState>,
    /// <p>A description of this trigger.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
    /// Schedules for Jobs and Crawlers</a>. For example, to run
    /// something every day at 12:15 UTC, you would specify:
    /// <code>cron(15 12 * * ? *)</code>.</p>
    pub schedule: std::option::Option<std::string::String>,
    /// <p>The actions initiated by this trigger.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p>The predicate of this trigger, which defines when it will fire.</p>
    pub predicate: std::option::Option<crate::model::Predicate>,
    /// <p>Batch condition that must be met (specified number of events received or batch time window expired)
    /// before EventBridge event trigger fires.</p>
    pub event_batching_condition: std::option::Option<crate::model::EventBatchingCondition>,
}
impl std::fmt::Debug for Trigger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Trigger");
        formatter.field("name", &self.name);
        formatter.field("workflow_name", &self.workflow_name);
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("state", &self.state);
        formatter.field("description", &self.description);
        formatter.field("schedule", &self.schedule);
        formatter.field("actions", &self.actions);
        formatter.field("predicate", &self.predicate);
        formatter.field("event_batching_condition", &self.event_batching_condition);
        formatter.finish()
    }
}
/// See [`Trigger`](crate::model::Trigger)
pub mod trigger {
    /// A builder for [`Trigger`](crate::model::Trigger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) workflow_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TriggerType>,
        pub(crate) state: std::option::Option<crate::model::TriggerState>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) predicate: std::option::Option<crate::model::Predicate>,
        pub(crate) event_batching_condition:
            std::option::Option<crate::model::EventBatchingCondition>,
    }
    impl Builder {
        /// <p>The name of the trigger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the trigger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the workflow associated with the trigger.</p>
        pub fn workflow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_name = Some(input.into());
            self
        }
        /// <p>The name of the workflow associated with the trigger.</p>
        pub fn set_workflow_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workflow_name = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of trigger that this is.</p>
        pub fn r#type(mut self, input: crate::model::TriggerType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of trigger that this is.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TriggerType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The current state of the trigger.</p>
        pub fn state(mut self, input: crate::model::TriggerState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the trigger.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::TriggerState>) -> Self {
            self.state = input;
            self
        }
        /// <p>A description of this trigger.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of this trigger.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
        /// Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
        /// Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions initiated by this trigger.</p>
        pub fn actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions initiated by this trigger.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>The predicate of this trigger, which defines when it will fire.</p>
        pub fn predicate(mut self, input: crate::model::Predicate) -> Self {
            self.predicate = Some(input);
            self
        }
        /// <p>The predicate of this trigger, which defines when it will fire.</p>
        pub fn set_predicate(
            mut self,
            input: std::option::Option<crate::model::Predicate>,
        ) -> Self {
            self.predicate = input;
            self
        }
        /// <p>Batch condition that must be met (specified number of events received or batch time window expired)
        /// before EventBridge event trigger fires.</p>
        pub fn event_batching_condition(
            mut self,
            input: crate::model::EventBatchingCondition,
        ) -> Self {
            self.event_batching_condition = Some(input);
            self
        }
        /// <p>Batch condition that must be met (specified number of events received or batch time window expired)
        /// before EventBridge event trigger fires.</p>
        pub fn set_event_batching_condition(
            mut self,
            input: std::option::Option<crate::model::EventBatchingCondition>,
        ) -> Self {
            self.event_batching_condition = input;
            self
        }
        /// Consumes the builder and constructs a [`Trigger`](crate::model::Trigger)
        pub fn build(self) -> crate::model::Trigger {
            crate::model::Trigger {
                name: self.name,
                workflow_name: self.workflow_name,
                id: self.id,
                r#type: self.r#type,
                state: self.state,
                description: self.description,
                schedule: self.schedule,
                actions: self.actions,
                predicate: self.predicate,
                event_batching_condition: self.event_batching_condition,
            }
        }
    }
}
impl Trigger {
    /// Creates a new builder-style object to manufacture [`Trigger`](crate::model::Trigger)
    pub fn builder() -> crate::model::trigger::Builder {
        crate::model::trigger::Builder::default()
    }
}

/// <p>Batch condition that must be met (specified number of events received or batch time window expired)
/// before EventBridge event trigger fires.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventBatchingCondition {
    /// <p>Number of events that must be received from Amazon EventBridge before EventBridge event trigger fires.</p>
    pub batch_size: i32,
    /// <p>Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received.</p>
    pub batch_window: std::option::Option<i32>,
}
impl std::fmt::Debug for EventBatchingCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventBatchingCondition");
        formatter.field("batch_size", &self.batch_size);
        formatter.field("batch_window", &self.batch_window);
        formatter.finish()
    }
}
/// See [`EventBatchingCondition`](crate::model::EventBatchingCondition)
pub mod event_batching_condition {
    /// A builder for [`EventBatchingCondition`](crate::model::EventBatchingCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_size: std::option::Option<i32>,
        pub(crate) batch_window: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Number of events that must be received from Amazon EventBridge before EventBridge event trigger fires.</p>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>Number of events that must be received from Amazon EventBridge before EventBridge event trigger fires.</p>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// <p>Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received.</p>
        pub fn batch_window(mut self, input: i32) -> Self {
            self.batch_window = Some(input);
            self
        }
        /// <p>Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received.</p>
        pub fn set_batch_window(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_window = input;
            self
        }
        /// Consumes the builder and constructs a [`EventBatchingCondition`](crate::model::EventBatchingCondition)
        pub fn build(self) -> crate::model::EventBatchingCondition {
            crate::model::EventBatchingCondition {
                batch_size: self.batch_size.unwrap_or_default(),
                batch_window: self.batch_window,
            }
        }
    }
}
impl EventBatchingCondition {
    /// Creates a new builder-style object to manufacture [`EventBatchingCondition`](crate::model::EventBatchingCondition)
    pub fn builder() -> crate::model::event_batching_condition::Builder {
        crate::model::event_batching_condition::Builder::default()
    }
}

/// <p>Defines the predicate of the trigger, which determines when it fires.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Predicate {
    /// <p>An optional field if only one condition is listed. If multiple conditions are listed, then
    /// this field is required.</p>
    pub logical: std::option::Option<crate::model::Logical>,
    /// <p>A list of the conditions that determine when the trigger will fire.</p>
    pub conditions: std::option::Option<std::vec::Vec<crate::model::Condition>>,
}
impl std::fmt::Debug for Predicate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Predicate");
        formatter.field("logical", &self.logical);
        formatter.field("conditions", &self.conditions);
        formatter.finish()
    }
}
/// See [`Predicate`](crate::model::Predicate)
pub mod predicate {
    /// A builder for [`Predicate`](crate::model::Predicate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logical: std::option::Option<crate::model::Logical>,
        pub(crate) conditions: std::option::Option<std::vec::Vec<crate::model::Condition>>,
    }
    impl Builder {
        /// <p>An optional field if only one condition is listed. If multiple conditions are listed, then
        /// this field is required.</p>
        pub fn logical(mut self, input: crate::model::Logical) -> Self {
            self.logical = Some(input);
            self
        }
        /// <p>An optional field if only one condition is listed. If multiple conditions are listed, then
        /// this field is required.</p>
        pub fn set_logical(mut self, input: std::option::Option<crate::model::Logical>) -> Self {
            self.logical = input;
            self
        }
        /// Appends an item to `conditions`.
        ///
        /// To override the contents of this collection use [`set_conditions`](Self::set_conditions).
        ///
        /// <p>A list of the conditions that determine when the trigger will fire.</p>
        pub fn conditions(mut self, input: impl Into<crate::model::Condition>) -> Self {
            let mut v = self.conditions.unwrap_or_default();
            v.push(input.into());
            self.conditions = Some(v);
            self
        }
        /// <p>A list of the conditions that determine when the trigger will fire.</p>
        pub fn set_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Condition>>,
        ) -> Self {
            self.conditions = input;
            self
        }
        /// Consumes the builder and constructs a [`Predicate`](crate::model::Predicate)
        pub fn build(self) -> crate::model::Predicate {
            crate::model::Predicate {
                logical: self.logical,
                conditions: self.conditions,
            }
        }
    }
}
impl Predicate {
    /// Creates a new builder-style object to manufacture [`Predicate`](crate::model::Predicate)
    pub fn builder() -> crate::model::predicate::Builder {
        crate::model::predicate::Builder::default()
    }
}

/// <p>Defines a condition under which a trigger fires.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Condition {
    /// <p>A logical operator.</p>
    pub logical_operator: std::option::Option<crate::model::LogicalOperator>,
    /// <p>The name of the job whose <code>JobRuns</code> this condition applies to, and on which
    /// this trigger waits.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The condition state. Currently, the only job states that a trigger can listen for are <code>SUCCEEDED</code>, <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only crawler states that a trigger can listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and <code>CANCELLED</code>.</p>
    pub state: std::option::Option<crate::model::JobRunState>,
    /// <p>The name of the crawler to which this condition applies.</p>
    pub crawler_name: std::option::Option<std::string::String>,
    /// <p>The state of the crawler to which this condition applies.</p>
    pub crawl_state: std::option::Option<crate::model::CrawlState>,
}
impl std::fmt::Debug for Condition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Condition");
        formatter.field("logical_operator", &self.logical_operator);
        formatter.field("job_name", &self.job_name);
        formatter.field("state", &self.state);
        formatter.field("crawler_name", &self.crawler_name);
        formatter.field("crawl_state", &self.crawl_state);
        formatter.finish()
    }
}
/// See [`Condition`](crate::model::Condition)
pub mod condition {
    /// A builder for [`Condition`](crate::model::Condition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logical_operator: std::option::Option<crate::model::LogicalOperator>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::JobRunState>,
        pub(crate) crawler_name: std::option::Option<std::string::String>,
        pub(crate) crawl_state: std::option::Option<crate::model::CrawlState>,
    }
    impl Builder {
        /// <p>A logical operator.</p>
        pub fn logical_operator(mut self, input: crate::model::LogicalOperator) -> Self {
            self.logical_operator = Some(input);
            self
        }
        /// <p>A logical operator.</p>
        pub fn set_logical_operator(
            mut self,
            input: std::option::Option<crate::model::LogicalOperator>,
        ) -> Self {
            self.logical_operator = input;
            self
        }
        /// <p>The name of the job whose <code>JobRuns</code> this condition applies to, and on which
        /// this trigger waits.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the job whose <code>JobRuns</code> this condition applies to, and on which
        /// this trigger waits.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The condition state. Currently, the only job states that a trigger can listen for are <code>SUCCEEDED</code>, <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only crawler states that a trigger can listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and <code>CANCELLED</code>.</p>
        pub fn state(mut self, input: crate::model::JobRunState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The condition state. Currently, the only job states that a trigger can listen for are <code>SUCCEEDED</code>, <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only crawler states that a trigger can listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and <code>CANCELLED</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::JobRunState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The name of the crawler to which this condition applies.</p>
        pub fn crawler_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.crawler_name = Some(input.into());
            self
        }
        /// <p>The name of the crawler to which this condition applies.</p>
        pub fn set_crawler_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.crawler_name = input;
            self
        }
        /// <p>The state of the crawler to which this condition applies.</p>
        pub fn crawl_state(mut self, input: crate::model::CrawlState) -> Self {
            self.crawl_state = Some(input);
            self
        }
        /// <p>The state of the crawler to which this condition applies.</p>
        pub fn set_crawl_state(
            mut self,
            input: std::option::Option<crate::model::CrawlState>,
        ) -> Self {
            self.crawl_state = input;
            self
        }
        /// Consumes the builder and constructs a [`Condition`](crate::model::Condition)
        pub fn build(self) -> crate::model::Condition {
            crate::model::Condition {
                logical_operator: self.logical_operator,
                job_name: self.job_name,
                state: self.state,
                crawler_name: self.crawler_name,
                crawl_state: self.crawl_state,
            }
        }
    }
}
impl Condition {
    /// Creates a new builder-style object to manufacture [`Condition`](crate::model::Condition)
    pub fn builder() -> crate::model::condition::Builder {
        crate::model::condition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CrawlState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CrawlState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => CrawlState::Cancelled,
            "CANCELLING" => CrawlState::Cancelling,
            "FAILED" => CrawlState::Failed,
            "RUNNING" => CrawlState::Running,
            "SUCCEEDED" => CrawlState::Succeeded,
            other => CrawlState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CrawlState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CrawlState::from(s))
    }
}
impl CrawlState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CrawlState::Cancelled => "CANCELLED",
            CrawlState::Cancelling => "CANCELLING",
            CrawlState::Failed => "FAILED",
            CrawlState::Running => "RUNNING",
            CrawlState::Succeeded => "SUCCEEDED",
            CrawlState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "CANCELLING", "FAILED", "RUNNING", "SUCCEEDED"]
    }
}
impl AsRef<str> for CrawlState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobRunState {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    Timeout,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobRunState {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => JobRunState::Failed,
            "RUNNING" => JobRunState::Running,
            "STARTING" => JobRunState::Starting,
            "STOPPED" => JobRunState::Stopped,
            "STOPPING" => JobRunState::Stopping,
            "SUCCEEDED" => JobRunState::Succeeded,
            "TIMEOUT" => JobRunState::Timeout,
            other => JobRunState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobRunState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobRunState::from(s))
    }
}
impl JobRunState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobRunState::Failed => "FAILED",
            JobRunState::Running => "RUNNING",
            JobRunState::Starting => "STARTING",
            JobRunState::Stopped => "STOPPED",
            JobRunState::Stopping => "STOPPING",
            JobRunState::Succeeded => "SUCCEEDED",
            JobRunState::Timeout => "TIMEOUT",
            JobRunState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "RUNNING",
            "STARTING",
            "STOPPED",
            "STOPPING",
            "SUCCEEDED",
            "TIMEOUT",
        ]
    }
}
impl AsRef<str> for JobRunState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogicalOperator {
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogicalOperator {
    fn from(s: &str) -> Self {
        match s {
            "EQUALS" => LogicalOperator::Equals,
            other => LogicalOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogicalOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogicalOperator::from(s))
    }
}
impl LogicalOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogicalOperator::Equals => "EQUALS",
            LogicalOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUALS"]
    }
}
impl AsRef<str> for LogicalOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Logical {
    #[allow(missing_docs)] // documentation missing in model
    And,
    #[allow(missing_docs)] // documentation missing in model
    Any,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Logical {
    fn from(s: &str) -> Self {
        match s {
            "AND" => Logical::And,
            "ANY" => Logical::Any,
            other => Logical::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Logical {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Logical::from(s))
    }
}
impl Logical {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Logical::And => "AND",
            Logical::Any => "ANY",
            Logical::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AND", "ANY"]
    }
}
impl AsRef<str> for Logical {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines an action to be initiated by a trigger.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Action {
    /// <p>The name of a job to be run.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the job definition itself.</p>
    /// <p>You can specify arguments here that your own job-execution script
    /// consumes, as well as arguments that Glue itself consumes.</p>
    /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
    /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
    pub arguments:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can
    /// consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
    /// is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
    /// action.</p>
    pub security_configuration: std::option::Option<std::string::String>,
    /// <p>Specifies configuration properties of a job run notification.</p>
    pub notification_property: std::option::Option<crate::model::NotificationProperty>,
    /// <p>The name of the crawler to be used with this action.</p>
    pub crawler_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Action");
        formatter.field("job_name", &self.job_name);
        formatter.field("arguments", &self.arguments);
        formatter.field("timeout", &self.timeout);
        formatter.field("security_configuration", &self.security_configuration);
        formatter.field("notification_property", &self.notification_property);
        formatter.field("crawler_name", &self.crawler_name);
        formatter.finish()
    }
}
/// See [`Action`](crate::model::Action)
pub mod action {
    /// A builder for [`Action`](crate::model::Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) arguments: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) security_configuration: std::option::Option<std::string::String>,
        pub(crate) notification_property: std::option::Option<crate::model::NotificationProperty>,
        pub(crate) crawler_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a job to be run.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of a job to be run.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// Adds a key-value pair to `arguments`.
        ///
        /// To override the contents of this collection use [`set_arguments`](Self::set_arguments).
        ///
        /// <p>The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the job definition itself.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.arguments.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.arguments = Some(hash_map);
            self
        }
        /// <p>The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the job definition itself.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn set_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.arguments = input;
            self
        }
        /// <p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can
        /// consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
        /// is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can
        /// consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
        /// is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// action.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_configuration = Some(input.into());
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// action.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_configuration = input;
            self
        }
        /// <p>Specifies configuration properties of a job run notification.</p>
        pub fn notification_property(mut self, input: crate::model::NotificationProperty) -> Self {
            self.notification_property = Some(input);
            self
        }
        /// <p>Specifies configuration properties of a job run notification.</p>
        pub fn set_notification_property(
            mut self,
            input: std::option::Option<crate::model::NotificationProperty>,
        ) -> Self {
            self.notification_property = input;
            self
        }
        /// <p>The name of the crawler to be used with this action.</p>
        pub fn crawler_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.crawler_name = Some(input.into());
            self
        }
        /// <p>The name of the crawler to be used with this action.</p>
        pub fn set_crawler_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.crawler_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Action`](crate::model::Action)
        pub fn build(self) -> crate::model::Action {
            crate::model::Action {
                job_name: self.job_name,
                arguments: self.arguments,
                timeout: self.timeout,
                security_configuration: self.security_configuration,
                notification_property: self.notification_property,
                crawler_name: self.crawler_name,
            }
        }
    }
}
impl Action {
    /// Creates a new builder-style object to manufacture [`Action`](crate::model::Action)
    pub fn builder() -> crate::model::action::Builder {
        crate::model::action::Builder::default()
    }
}

/// <p>Specifies configuration properties of a notification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationProperty {
    /// <p>After a job run starts, the number of minutes to wait before
    /// sending a job run delay notification.</p>
    pub notify_delay_after: std::option::Option<i32>,
}
impl std::fmt::Debug for NotificationProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationProperty");
        formatter.field("notify_delay_after", &self.notify_delay_after);
        formatter.finish()
    }
}
/// See [`NotificationProperty`](crate::model::NotificationProperty)
pub mod notification_property {
    /// A builder for [`NotificationProperty`](crate::model::NotificationProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notify_delay_after: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>After a job run starts, the number of minutes to wait before
        /// sending a job run delay notification.</p>
        pub fn notify_delay_after(mut self, input: i32) -> Self {
            self.notify_delay_after = Some(input);
            self
        }
        /// <p>After a job run starts, the number of minutes to wait before
        /// sending a job run delay notification.</p>
        pub fn set_notify_delay_after(mut self, input: std::option::Option<i32>) -> Self {
            self.notify_delay_after = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationProperty`](crate::model::NotificationProperty)
        pub fn build(self) -> crate::model::NotificationProperty {
            crate::model::NotificationProperty {
                notify_delay_after: self.notify_delay_after,
            }
        }
    }
}
impl NotificationProperty {
    /// Creates a new builder-style object to manufacture [`NotificationProperty`](crate::model::NotificationProperty)
    pub fn builder() -> crate::model::notification_property::Builder {
        crate::model::notification_property::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TriggerState {
    #[allow(missing_docs)] // documentation missing in model
    Activated,
    #[allow(missing_docs)] // documentation missing in model
    Activating,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deactivated,
    #[allow(missing_docs)] // documentation missing in model
    Deactivating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TriggerState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATED" => TriggerState::Activated,
            "ACTIVATING" => TriggerState::Activating,
            "CREATED" => TriggerState::Created,
            "CREATING" => TriggerState::Creating,
            "DEACTIVATED" => TriggerState::Deactivated,
            "DEACTIVATING" => TriggerState::Deactivating,
            "DELETING" => TriggerState::Deleting,
            "UPDATING" => TriggerState::Updating,
            other => TriggerState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TriggerState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TriggerState::from(s))
    }
}
impl TriggerState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TriggerState::Activated => "ACTIVATED",
            TriggerState::Activating => "ACTIVATING",
            TriggerState::Created => "CREATED",
            TriggerState::Creating => "CREATING",
            TriggerState::Deactivated => "DEACTIVATED",
            TriggerState::Deactivating => "DEACTIVATING",
            TriggerState::Deleting => "DELETING",
            TriggerState::Updating => "UPDATING",
            TriggerState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVATED",
            "ACTIVATING",
            "CREATED",
            "CREATING",
            "DEACTIVATED",
            "DEACTIVATING",
            "DELETING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for TriggerState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TriggerType {
    #[allow(missing_docs)] // documentation missing in model
    Conditional,
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    OnDemand,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TriggerType {
    fn from(s: &str) -> Self {
        match s {
            "CONDITIONAL" => TriggerType::Conditional,
            "EVENT" => TriggerType::Event,
            "ON_DEMAND" => TriggerType::OnDemand,
            "SCHEDULED" => TriggerType::Scheduled,
            other => TriggerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TriggerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TriggerType::from(s))
    }
}
impl TriggerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TriggerType::Conditional => "CONDITIONAL",
            TriggerType::Event => "EVENT",
            TriggerType::OnDemand => "ON_DEMAND",
            TriggerType::Scheduled => "SCHEDULED",
            TriggerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONDITIONAL", "EVENT", "ON_DEMAND", "SCHEDULED"]
    }
}
impl AsRef<str> for TriggerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure used to provide information used to update a trigger. This object updates the
/// previous trigger definition by overwriting it completely.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TriggerUpdate {
    /// <p>Reserved for future use.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of this trigger.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
    /// Schedules for Jobs and Crawlers</a>. For example, to run
    /// something every day at 12:15 UTC, you would specify:
    /// <code>cron(15 12 * * ? *)</code>.</p>
    pub schedule: std::option::Option<std::string::String>,
    /// <p>The actions initiated by this trigger.</p>
    pub actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
    /// <p>The predicate of this trigger, which defines when it will fire.</p>
    pub predicate: std::option::Option<crate::model::Predicate>,
    /// <p>Batch condition that must be met (specified number of events received or batch time window expired)
    /// before EventBridge event trigger fires.</p>
    pub event_batching_condition: std::option::Option<crate::model::EventBatchingCondition>,
}
impl std::fmt::Debug for TriggerUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TriggerUpdate");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("schedule", &self.schedule);
        formatter.field("actions", &self.actions);
        formatter.field("predicate", &self.predicate);
        formatter.field("event_batching_condition", &self.event_batching_condition);
        formatter.finish()
    }
}
/// See [`TriggerUpdate`](crate::model::TriggerUpdate)
pub mod trigger_update {
    /// A builder for [`TriggerUpdate`](crate::model::TriggerUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<std::vec::Vec<crate::model::Action>>,
        pub(crate) predicate: std::option::Option<crate::model::Predicate>,
        pub(crate) event_batching_condition:
            std::option::Option<crate::model::EventBatchingCondition>,
    }
    impl Builder {
        /// <p>Reserved for future use.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of this trigger.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of this trigger.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
        /// Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
        /// Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>The actions initiated by this trigger.</p>
        pub fn actions(mut self, input: impl Into<crate::model::Action>) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input.into());
            self.actions = Some(v);
            self
        }
        /// <p>The actions initiated by this trigger.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Action>>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>The predicate of this trigger, which defines when it will fire.</p>
        pub fn predicate(mut self, input: crate::model::Predicate) -> Self {
            self.predicate = Some(input);
            self
        }
        /// <p>The predicate of this trigger, which defines when it will fire.</p>
        pub fn set_predicate(
            mut self,
            input: std::option::Option<crate::model::Predicate>,
        ) -> Self {
            self.predicate = input;
            self
        }
        /// <p>Batch condition that must be met (specified number of events received or batch time window expired)
        /// before EventBridge event trigger fires.</p>
        pub fn event_batching_condition(
            mut self,
            input: crate::model::EventBatchingCondition,
        ) -> Self {
            self.event_batching_condition = Some(input);
            self
        }
        /// <p>Batch condition that must be met (specified number of events received or batch time window expired)
        /// before EventBridge event trigger fires.</p>
        pub fn set_event_batching_condition(
            mut self,
            input: std::option::Option<crate::model::EventBatchingCondition>,
        ) -> Self {
            self.event_batching_condition = input;
            self
        }
        /// Consumes the builder and constructs a [`TriggerUpdate`](crate::model::TriggerUpdate)
        pub fn build(self) -> crate::model::TriggerUpdate {
            crate::model::TriggerUpdate {
                name: self.name,
                description: self.description,
                schedule: self.schedule,
                actions: self.actions,
                predicate: self.predicate,
                event_batching_condition: self.event_batching_condition,
            }
        }
    }
}
impl TriggerUpdate {
    /// Creates a new builder-style object to manufacture [`TriggerUpdate`](crate::model::TriggerUpdate)
    pub fn builder() -> crate::model::trigger_update::Builder {
        crate::model::trigger_update::Builder::default()
    }
}

/// <p>A structure used to define a table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableInput {
    /// <p>The table name. For Hive compatibility, this is folded to
    /// lowercase when it is stored.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the table.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The table owner.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The last time that the table was accessed.</p>
    pub last_access_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that column statistics were computed for this table.</p>
    pub last_analyzed_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The retention time for this table.</p>
    pub retention: i32,
    /// <p>A storage descriptor containing information about the physical storage
    /// of this table.</p>
    pub storage_descriptor: std::option::Option<crate::model::StorageDescriptor>,
    /// <p>A list of columns by which the table is partitioned. Only primitive
    /// types are supported as partition keys.</p>
    /// <p>When you create a table used by Amazon Athena, and you do not specify any
    /// <code>partitionKeys</code>, you must at least set the value of <code>partitionKeys</code> to
    /// an empty list. For example:</p>
    /// <p>
    /// <code>"PartitionKeys": []</code>
    /// </p>
    pub partition_keys: std::option::Option<std::vec::Vec<crate::model::Column>>,
    /// <p>If the table is a view, the original text of the view; otherwise <code>null</code>.</p>
    pub view_original_text: std::option::Option<std::string::String>,
    /// <p>If the table is a view, the expanded text of the view; otherwise <code>null</code>.</p>
    pub view_expanded_text: std::option::Option<std::string::String>,
    /// <p>The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).</p>
    pub table_type: std::option::Option<std::string::String>,
    /// <p>These key-value pairs define properties associated with the table.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A <code>TableIdentifier</code> structure that describes a target table for resource linking.</p>
    pub target_table: std::option::Option<crate::model::TableIdentifier>,
}
impl std::fmt::Debug for TableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("owner", &self.owner);
        formatter.field("last_access_time", &self.last_access_time);
        formatter.field("last_analyzed_time", &self.last_analyzed_time);
        formatter.field("retention", &self.retention);
        formatter.field("storage_descriptor", &self.storage_descriptor);
        formatter.field("partition_keys", &self.partition_keys);
        formatter.field("view_original_text", &self.view_original_text);
        formatter.field("view_expanded_text", &self.view_expanded_text);
        formatter.field("table_type", &self.table_type);
        formatter.field("parameters", &self.parameters);
        formatter.field("target_table", &self.target_table);
        formatter.finish()
    }
}
/// See [`TableInput`](crate::model::TableInput)
pub mod table_input {
    /// A builder for [`TableInput`](crate::model::TableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) last_access_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_analyzed_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) retention: std::option::Option<i32>,
        pub(crate) storage_descriptor: std::option::Option<crate::model::StorageDescriptor>,
        pub(crate) partition_keys: std::option::Option<std::vec::Vec<crate::model::Column>>,
        pub(crate) view_original_text: std::option::Option<std::string::String>,
        pub(crate) view_expanded_text: std::option::Option<std::string::String>,
        pub(crate) table_type: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) target_table: std::option::Option<crate::model::TableIdentifier>,
    }
    impl Builder {
        /// <p>The table name. For Hive compatibility, this is folded to
        /// lowercase when it is stored.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The table name. For Hive compatibility, this is folded to
        /// lowercase when it is stored.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the table.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the table.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The table owner.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The table owner.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The last time that the table was accessed.</p>
        pub fn last_access_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_access_time = Some(input);
            self
        }
        /// <p>The last time that the table was accessed.</p>
        pub fn set_last_access_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_access_time = input;
            self
        }
        /// <p>The last time that column statistics were computed for this table.</p>
        pub fn last_analyzed_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_analyzed_time = Some(input);
            self
        }
        /// <p>The last time that column statistics were computed for this table.</p>
        pub fn set_last_analyzed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_analyzed_time = input;
            self
        }
        /// <p>The retention time for this table.</p>
        pub fn retention(mut self, input: i32) -> Self {
            self.retention = Some(input);
            self
        }
        /// <p>The retention time for this table.</p>
        pub fn set_retention(mut self, input: std::option::Option<i32>) -> Self {
            self.retention = input;
            self
        }
        /// <p>A storage descriptor containing information about the physical storage
        /// of this table.</p>
        pub fn storage_descriptor(mut self, input: crate::model::StorageDescriptor) -> Self {
            self.storage_descriptor = Some(input);
            self
        }
        /// <p>A storage descriptor containing information about the physical storage
        /// of this table.</p>
        pub fn set_storage_descriptor(
            mut self,
            input: std::option::Option<crate::model::StorageDescriptor>,
        ) -> Self {
            self.storage_descriptor = input;
            self
        }
        /// Appends an item to `partition_keys`.
        ///
        /// To override the contents of this collection use [`set_partition_keys`](Self::set_partition_keys).
        ///
        /// <p>A list of columns by which the table is partitioned. Only primitive
        /// types are supported as partition keys.</p>
        /// <p>When you create a table used by Amazon Athena, and you do not specify any
        /// <code>partitionKeys</code>, you must at least set the value of <code>partitionKeys</code> to
        /// an empty list. For example:</p>
        /// <p>
        /// <code>"PartitionKeys": []</code>
        /// </p>
        pub fn partition_keys(mut self, input: impl Into<crate::model::Column>) -> Self {
            let mut v = self.partition_keys.unwrap_or_default();
            v.push(input.into());
            self.partition_keys = Some(v);
            self
        }
        /// <p>A list of columns by which the table is partitioned. Only primitive
        /// types are supported as partition keys.</p>
        /// <p>When you create a table used by Amazon Athena, and you do not specify any
        /// <code>partitionKeys</code>, you must at least set the value of <code>partitionKeys</code> to
        /// an empty list. For example:</p>
        /// <p>
        /// <code>"PartitionKeys": []</code>
        /// </p>
        pub fn set_partition_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Column>>,
        ) -> Self {
            self.partition_keys = input;
            self
        }
        /// <p>If the table is a view, the original text of the view; otherwise <code>null</code>.</p>
        pub fn view_original_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.view_original_text = Some(input.into());
            self
        }
        /// <p>If the table is a view, the original text of the view; otherwise <code>null</code>.</p>
        pub fn set_view_original_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.view_original_text = input;
            self
        }
        /// <p>If the table is a view, the expanded text of the view; otherwise <code>null</code>.</p>
        pub fn view_expanded_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.view_expanded_text = Some(input.into());
            self
        }
        /// <p>If the table is a view, the expanded text of the view; otherwise <code>null</code>.</p>
        pub fn set_view_expanded_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.view_expanded_text = input;
            self
        }
        /// <p>The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).</p>
        pub fn table_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_type = Some(input.into());
            self
        }
        /// <p>The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).</p>
        pub fn set_table_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_type = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>These key-value pairs define properties associated with the table.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>These key-value pairs define properties associated with the table.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>A <code>TableIdentifier</code> structure that describes a target table for resource linking.</p>
        pub fn target_table(mut self, input: crate::model::TableIdentifier) -> Self {
            self.target_table = Some(input);
            self
        }
        /// <p>A <code>TableIdentifier</code> structure that describes a target table for resource linking.</p>
        pub fn set_target_table(
            mut self,
            input: std::option::Option<crate::model::TableIdentifier>,
        ) -> Self {
            self.target_table = input;
            self
        }
        /// Consumes the builder and constructs a [`TableInput`](crate::model::TableInput)
        pub fn build(self) -> crate::model::TableInput {
            crate::model::TableInput {
                name: self.name,
                description: self.description,
                owner: self.owner,
                last_access_time: self.last_access_time,
                last_analyzed_time: self.last_analyzed_time,
                retention: self.retention.unwrap_or_default(),
                storage_descriptor: self.storage_descriptor,
                partition_keys: self.partition_keys,
                view_original_text: self.view_original_text,
                view_expanded_text: self.view_expanded_text,
                table_type: self.table_type,
                parameters: self.parameters,
                target_table: self.target_table,
            }
        }
    }
}
impl TableInput {
    /// Creates a new builder-style object to manufacture [`TableInput`](crate::model::TableInput)
    pub fn builder() -> crate::model::table_input::Builder {
        crate::model::table_input::Builder::default()
    }
}

/// <p>A structure that describes a target table for resource linking.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableIdentifier {
    /// <p>The ID of the Data Catalog in which the table resides.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The name of the catalog database that contains the target table.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the target table.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TableIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableIdentifier");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`TableIdentifier`](crate::model::TableIdentifier)
pub mod table_identifier {
    /// A builder for [`TableIdentifier`](crate::model::TableIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Data Catalog in which the table resides.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the Data Catalog in which the table resides.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The name of the catalog database that contains the target table.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the catalog database that contains the target table.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the target table.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the target table.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`TableIdentifier`](crate::model::TableIdentifier)
        pub fn build(self) -> crate::model::TableIdentifier {
            crate::model::TableIdentifier {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
                name: self.name,
            }
        }
    }
}
impl TableIdentifier {
    /// Creates a new builder-style object to manufacture [`TableIdentifier`](crate::model::TableIdentifier)
    pub fn builder() -> crate::model::table_identifier::Builder {
        crate::model::table_identifier::Builder::default()
    }
}

/// <p>A column in a <code>Table</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Column {
    /// <p>The name of the <code>Column</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the <code>Column</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>A free-form text comment.</p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>These key-value pairs define properties associated with the column.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Column {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Column");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("comment", &self.comment);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`Column`](crate::model::Column)
pub mod column {
    /// A builder for [`Column`](crate::model::Column)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the <code>Column</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>Column</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the <code>Column</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The data type of the <code>Column</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A free-form text comment.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>A free-form text comment.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>These key-value pairs define properties associated with the column.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>These key-value pairs define properties associated with the column.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`Column`](crate::model::Column)
        pub fn build(self) -> crate::model::Column {
            crate::model::Column {
                name: self.name,
                r#type: self.r#type,
                comment: self.comment,
                parameters: self.parameters,
            }
        }
    }
}
impl Column {
    /// Creates a new builder-style object to manufacture [`Column`](crate::model::Column)
    pub fn builder() -> crate::model::column::Builder {
        crate::model::column::Builder::default()
    }
}

/// <p>Describes the physical storage of table data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageDescriptor {
    /// <p>A list of the <code>Columns</code> in the table.</p>
    pub columns: std::option::Option<std::vec::Vec<crate::model::Column>>,
    /// <p>The physical location of the table. By default, this takes the form of the warehouse
    /// location, followed by the database location in the warehouse, followed by the table
    /// name.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The input format: <code>SequenceFileInputFormat</code> (binary),
    /// or <code>TextInputFormat</code>, or a custom format.</p>
    pub input_format: std::option::Option<std::string::String>,
    /// <p>The output format: <code>SequenceFileOutputFormat</code> (binary),
    /// or <code>IgnoreKeyTextOutputFormat</code>, or a custom format.</p>
    pub output_format: std::option::Option<std::string::String>,
    /// <p>
    /// <code>True</code> if the data in the table is compressed, or <code>False</code> if
    /// not.</p>
    pub compressed: bool,
    /// <p>Must be specified if the table contains any dimension columns.</p>
    pub number_of_buckets: i32,
    /// <p>The serialization/deserialization (SerDe) information.</p>
    pub serde_info: std::option::Option<crate::model::SerDeInfo>,
    /// <p>A list of reducer grouping columns, clustering columns, and
    /// bucketing columns in the table.</p>
    pub bucket_columns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list specifying the sort order of each bucket in the table.</p>
    pub sort_columns: std::option::Option<std::vec::Vec<crate::model::Order>>,
    /// <p>The user-supplied properties in key-value form.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The information about values that appear frequently in a column (skewed values).</p>
    pub skewed_info: std::option::Option<crate::model::SkewedInfo>,
    /// <p>
    /// <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if
    /// not.</p>
    pub stored_as_sub_directories: bool,
    /// <p>An object that references a schema stored in the Glue Schema Registry.</p>
    ///
    /// <p>When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference.</p>
    pub schema_reference: std::option::Option<crate::model::SchemaReference>,
}
impl std::fmt::Debug for StorageDescriptor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageDescriptor");
        formatter.field("columns", &self.columns);
        formatter.field("location", &self.location);
        formatter.field("input_format", &self.input_format);
        formatter.field("output_format", &self.output_format);
        formatter.field("compressed", &self.compressed);
        formatter.field("number_of_buckets", &self.number_of_buckets);
        formatter.field("serde_info", &self.serde_info);
        formatter.field("bucket_columns", &self.bucket_columns);
        formatter.field("sort_columns", &self.sort_columns);
        formatter.field("parameters", &self.parameters);
        formatter.field("skewed_info", &self.skewed_info);
        formatter.field("stored_as_sub_directories", &self.stored_as_sub_directories);
        formatter.field("schema_reference", &self.schema_reference);
        formatter.finish()
    }
}
/// See [`StorageDescriptor`](crate::model::StorageDescriptor)
pub mod storage_descriptor {
    /// A builder for [`StorageDescriptor`](crate::model::StorageDescriptor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) columns: std::option::Option<std::vec::Vec<crate::model::Column>>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) input_format: std::option::Option<std::string::String>,
        pub(crate) output_format: std::option::Option<std::string::String>,
        pub(crate) compressed: std::option::Option<bool>,
        pub(crate) number_of_buckets: std::option::Option<i32>,
        pub(crate) serde_info: std::option::Option<crate::model::SerDeInfo>,
        pub(crate) bucket_columns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sort_columns: std::option::Option<std::vec::Vec<crate::model::Order>>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) skewed_info: std::option::Option<crate::model::SkewedInfo>,
        pub(crate) stored_as_sub_directories: std::option::Option<bool>,
        pub(crate) schema_reference: std::option::Option<crate::model::SchemaReference>,
    }
    impl Builder {
        /// Appends an item to `columns`.
        ///
        /// To override the contents of this collection use [`set_columns`](Self::set_columns).
        ///
        /// <p>A list of the <code>Columns</code> in the table.</p>
        pub fn columns(mut self, input: impl Into<crate::model::Column>) -> Self {
            let mut v = self.columns.unwrap_or_default();
            v.push(input.into());
            self.columns = Some(v);
            self
        }
        /// <p>A list of the <code>Columns</code> in the table.</p>
        pub fn set_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Column>>,
        ) -> Self {
            self.columns = input;
            self
        }
        /// <p>The physical location of the table. By default, this takes the form of the warehouse
        /// location, followed by the database location in the warehouse, followed by the table
        /// name.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The physical location of the table. By default, this takes the form of the warehouse
        /// location, followed by the database location in the warehouse, followed by the table
        /// name.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The input format: <code>SequenceFileInputFormat</code> (binary),
        /// or <code>TextInputFormat</code>, or a custom format.</p>
        pub fn input_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_format = Some(input.into());
            self
        }
        /// <p>The input format: <code>SequenceFileInputFormat</code> (binary),
        /// or <code>TextInputFormat</code>, or a custom format.</p>
        pub fn set_input_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_format = input;
            self
        }
        /// <p>The output format: <code>SequenceFileOutputFormat</code> (binary),
        /// or <code>IgnoreKeyTextOutputFormat</code>, or a custom format.</p>
        pub fn output_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_format = Some(input.into());
            self
        }
        /// <p>The output format: <code>SequenceFileOutputFormat</code> (binary),
        /// or <code>IgnoreKeyTextOutputFormat</code>, or a custom format.</p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_format = input;
            self
        }
        /// <p>
        /// <code>True</code> if the data in the table is compressed, or <code>False</code> if
        /// not.</p>
        pub fn compressed(mut self, input: bool) -> Self {
            self.compressed = Some(input);
            self
        }
        /// <p>
        /// <code>True</code> if the data in the table is compressed, or <code>False</code> if
        /// not.</p>
        pub fn set_compressed(mut self, input: std::option::Option<bool>) -> Self {
            self.compressed = input;
            self
        }
        /// <p>Must be specified if the table contains any dimension columns.</p>
        pub fn number_of_buckets(mut self, input: i32) -> Self {
            self.number_of_buckets = Some(input);
            self
        }
        /// <p>Must be specified if the table contains any dimension columns.</p>
        pub fn set_number_of_buckets(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_buckets = input;
            self
        }
        /// <p>The serialization/deserialization (SerDe) information.</p>
        pub fn serde_info(mut self, input: crate::model::SerDeInfo) -> Self {
            self.serde_info = Some(input);
            self
        }
        /// <p>The serialization/deserialization (SerDe) information.</p>
        pub fn set_serde_info(
            mut self,
            input: std::option::Option<crate::model::SerDeInfo>,
        ) -> Self {
            self.serde_info = input;
            self
        }
        /// Appends an item to `bucket_columns`.
        ///
        /// To override the contents of this collection use [`set_bucket_columns`](Self::set_bucket_columns).
        ///
        /// <p>A list of reducer grouping columns, clustering columns, and
        /// bucketing columns in the table.</p>
        pub fn bucket_columns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.bucket_columns.unwrap_or_default();
            v.push(input.into());
            self.bucket_columns = Some(v);
            self
        }
        /// <p>A list of reducer grouping columns, clustering columns, and
        /// bucketing columns in the table.</p>
        pub fn set_bucket_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.bucket_columns = input;
            self
        }
        /// Appends an item to `sort_columns`.
        ///
        /// To override the contents of this collection use [`set_sort_columns`](Self::set_sort_columns).
        ///
        /// <p>A list specifying the sort order of each bucket in the table.</p>
        pub fn sort_columns(mut self, input: impl Into<crate::model::Order>) -> Self {
            let mut v = self.sort_columns.unwrap_or_default();
            v.push(input.into());
            self.sort_columns = Some(v);
            self
        }
        /// <p>A list specifying the sort order of each bucket in the table.</p>
        pub fn set_sort_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Order>>,
        ) -> Self {
            self.sort_columns = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The user-supplied properties in key-value form.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The user-supplied properties in key-value form.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The information about values that appear frequently in a column (skewed values).</p>
        pub fn skewed_info(mut self, input: crate::model::SkewedInfo) -> Self {
            self.skewed_info = Some(input);
            self
        }
        /// <p>The information about values that appear frequently in a column (skewed values).</p>
        pub fn set_skewed_info(
            mut self,
            input: std::option::Option<crate::model::SkewedInfo>,
        ) -> Self {
            self.skewed_info = input;
            self
        }
        /// <p>
        /// <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if
        /// not.</p>
        pub fn stored_as_sub_directories(mut self, input: bool) -> Self {
            self.stored_as_sub_directories = Some(input);
            self
        }
        /// <p>
        /// <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if
        /// not.</p>
        pub fn set_stored_as_sub_directories(mut self, input: std::option::Option<bool>) -> Self {
            self.stored_as_sub_directories = input;
            self
        }
        /// <p>An object that references a schema stored in the Glue Schema Registry.</p>
        ///
        /// <p>When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference.</p>
        pub fn schema_reference(mut self, input: crate::model::SchemaReference) -> Self {
            self.schema_reference = Some(input);
            self
        }
        /// <p>An object that references a schema stored in the Glue Schema Registry.</p>
        ///
        /// <p>When creating a table, you can pass an empty list of columns for the schema, and instead use a schema reference.</p>
        pub fn set_schema_reference(
            mut self,
            input: std::option::Option<crate::model::SchemaReference>,
        ) -> Self {
            self.schema_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageDescriptor`](crate::model::StorageDescriptor)
        pub fn build(self) -> crate::model::StorageDescriptor {
            crate::model::StorageDescriptor {
                columns: self.columns,
                location: self.location,
                input_format: self.input_format,
                output_format: self.output_format,
                compressed: self.compressed.unwrap_or_default(),
                number_of_buckets: self.number_of_buckets.unwrap_or_default(),
                serde_info: self.serde_info,
                bucket_columns: self.bucket_columns,
                sort_columns: self.sort_columns,
                parameters: self.parameters,
                skewed_info: self.skewed_info,
                stored_as_sub_directories: self.stored_as_sub_directories.unwrap_or_default(),
                schema_reference: self.schema_reference,
            }
        }
    }
}
impl StorageDescriptor {
    /// Creates a new builder-style object to manufacture [`StorageDescriptor`](crate::model::StorageDescriptor)
    pub fn builder() -> crate::model::storage_descriptor::Builder {
        crate::model::storage_descriptor::Builder::default()
    }
}

/// <p>An object that references a schema stored in the Glue Schema Registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaReference {
    /// <p>A structure that contains schema identity fields. Either this or the <code>SchemaVersionId</code> has to be provided.</p>
    pub schema_id: std::option::Option<crate::model::SchemaId>,
    /// <p>The unique ID assigned to a version of the schema. Either this or the <code>SchemaId</code> has to be provided.</p>
    pub schema_version_id: std::option::Option<std::string::String>,
    /// <p>The version number of the schema.</p>
    pub schema_version_number: std::option::Option<i64>,
}
impl std::fmt::Debug for SchemaReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaReference");
        formatter.field("schema_id", &self.schema_id);
        formatter.field("schema_version_id", &self.schema_version_id);
        formatter.field("schema_version_number", &self.schema_version_number);
        formatter.finish()
    }
}
/// See [`SchemaReference`](crate::model::SchemaReference)
pub mod schema_reference {
    /// A builder for [`SchemaReference`](crate::model::SchemaReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_id: std::option::Option<crate::model::SchemaId>,
        pub(crate) schema_version_id: std::option::Option<std::string::String>,
        pub(crate) schema_version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>A structure that contains schema identity fields. Either this or the <code>SchemaVersionId</code> has to be provided.</p>
        pub fn schema_id(mut self, input: crate::model::SchemaId) -> Self {
            self.schema_id = Some(input);
            self
        }
        /// <p>A structure that contains schema identity fields. Either this or the <code>SchemaVersionId</code> has to be provided.</p>
        pub fn set_schema_id(mut self, input: std::option::Option<crate::model::SchemaId>) -> Self {
            self.schema_id = input;
            self
        }
        /// <p>The unique ID assigned to a version of the schema. Either this or the <code>SchemaId</code> has to be provided.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version_id = Some(input.into());
            self
        }
        /// <p>The unique ID assigned to a version of the schema. Either this or the <code>SchemaId</code> has to be provided.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version_id = input;
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn schema_version_number(mut self, input: i64) -> Self {
            self.schema_version_number = Some(input);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_schema_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.schema_version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaReference`](crate::model::SchemaReference)
        pub fn build(self) -> crate::model::SchemaReference {
            crate::model::SchemaReference {
                schema_id: self.schema_id,
                schema_version_id: self.schema_version_id,
                schema_version_number: self.schema_version_number,
            }
        }
    }
}
impl SchemaReference {
    /// Creates a new builder-style object to manufacture [`SchemaReference`](crate::model::SchemaReference)
    pub fn builder() -> crate::model::schema_reference::Builder {
        crate::model::schema_reference::Builder::default()
    }
}

/// <p>The unique ID of the schema in the Glue schema registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaId {
    /// <p>The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema registry that contains the schema.</p>
    pub registry_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SchemaId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaId");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("registry_name", &self.registry_name);
        formatter.finish()
    }
}
/// See [`SchemaId`](crate::model::SchemaId)
pub mod schema_id {
    /// A builder for [`SchemaId`](crate::model::SchemaId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) registry_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema. One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The name of the schema registry that contains the schema.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the schema registry that contains the schema.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaId`](crate::model::SchemaId)
        pub fn build(self) -> crate::model::SchemaId {
            crate::model::SchemaId {
                schema_arn: self.schema_arn,
                schema_name: self.schema_name,
                registry_name: self.registry_name,
            }
        }
    }
}
impl SchemaId {
    /// Creates a new builder-style object to manufacture [`SchemaId`](crate::model::SchemaId)
    pub fn builder() -> crate::model::schema_id::Builder {
        crate::model::schema_id::Builder::default()
    }
}

/// <p>Specifies skewed values in a table. Skewed values are those that occur with very high
/// frequency.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SkewedInfo {
    /// <p>A list of names of columns that contain skewed values.</p>
    pub skewed_column_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of values that appear so frequently as to be considered
    /// skewed.</p>
    pub skewed_column_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A mapping of skewed values to the columns that contain them.</p>
    pub skewed_column_value_location_maps:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for SkewedInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SkewedInfo");
        formatter.field("skewed_column_names", &self.skewed_column_names);
        formatter.field("skewed_column_values", &self.skewed_column_values);
        formatter.field(
            "skewed_column_value_location_maps",
            &self.skewed_column_value_location_maps,
        );
        formatter.finish()
    }
}
/// See [`SkewedInfo`](crate::model::SkewedInfo)
pub mod skewed_info {
    /// A builder for [`SkewedInfo`](crate::model::SkewedInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) skewed_column_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) skewed_column_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) skewed_column_value_location_maps: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `skewed_column_names`.
        ///
        /// To override the contents of this collection use [`set_skewed_column_names`](Self::set_skewed_column_names).
        ///
        /// <p>A list of names of columns that contain skewed values.</p>
        pub fn skewed_column_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.skewed_column_names.unwrap_or_default();
            v.push(input.into());
            self.skewed_column_names = Some(v);
            self
        }
        /// <p>A list of names of columns that contain skewed values.</p>
        pub fn set_skewed_column_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.skewed_column_names = input;
            self
        }
        /// Appends an item to `skewed_column_values`.
        ///
        /// To override the contents of this collection use [`set_skewed_column_values`](Self::set_skewed_column_values).
        ///
        /// <p>A list of values that appear so frequently as to be considered
        /// skewed.</p>
        pub fn skewed_column_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.skewed_column_values.unwrap_or_default();
            v.push(input.into());
            self.skewed_column_values = Some(v);
            self
        }
        /// <p>A list of values that appear so frequently as to be considered
        /// skewed.</p>
        pub fn set_skewed_column_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.skewed_column_values = input;
            self
        }
        /// Adds a key-value pair to `skewed_column_value_location_maps`.
        ///
        /// To override the contents of this collection use [`set_skewed_column_value_location_maps`](Self::set_skewed_column_value_location_maps).
        ///
        /// <p>A mapping of skewed values to the columns that contain them.</p>
        pub fn skewed_column_value_location_maps(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.skewed_column_value_location_maps.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.skewed_column_value_location_maps = Some(hash_map);
            self
        }
        /// <p>A mapping of skewed values to the columns that contain them.</p>
        pub fn set_skewed_column_value_location_maps(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.skewed_column_value_location_maps = input;
            self
        }
        /// Consumes the builder and constructs a [`SkewedInfo`](crate::model::SkewedInfo)
        pub fn build(self) -> crate::model::SkewedInfo {
            crate::model::SkewedInfo {
                skewed_column_names: self.skewed_column_names,
                skewed_column_values: self.skewed_column_values,
                skewed_column_value_location_maps: self.skewed_column_value_location_maps,
            }
        }
    }
}
impl SkewedInfo {
    /// Creates a new builder-style object to manufacture [`SkewedInfo`](crate::model::SkewedInfo)
    pub fn builder() -> crate::model::skewed_info::Builder {
        crate::model::skewed_info::Builder::default()
    }
}

/// <p>Specifies the sort order of a sorted column.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Order {
    /// <p>The name of the column.</p>
    pub column: std::option::Option<std::string::String>,
    /// <p>Indicates that the column is sorted in ascending order
    /// (<code>== 1</code>), or in descending order (<code>==0</code>).</p>
    pub sort_order: i32,
}
impl std::fmt::Debug for Order {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Order");
        formatter.field("column", &self.column);
        formatter.field("sort_order", &self.sort_order);
        formatter.finish()
    }
}
/// See [`Order`](crate::model::Order)
pub mod order {
    /// A builder for [`Order`](crate::model::Order)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the column.</p>
        pub fn column(mut self, input: impl Into<std::string::String>) -> Self {
            self.column = Some(input.into());
            self
        }
        /// <p>The name of the column.</p>
        pub fn set_column(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column = input;
            self
        }
        /// <p>Indicates that the column is sorted in ascending order
        /// (<code>== 1</code>), or in descending order (<code>==0</code>).</p>
        pub fn sort_order(mut self, input: i32) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>Indicates that the column is sorted in ascending order
        /// (<code>== 1</code>), or in descending order (<code>==0</code>).</p>
        pub fn set_sort_order(mut self, input: std::option::Option<i32>) -> Self {
            self.sort_order = input;
            self
        }
        /// Consumes the builder and constructs a [`Order`](crate::model::Order)
        pub fn build(self) -> crate::model::Order {
            crate::model::Order {
                column: self.column,
                sort_order: self.sort_order.unwrap_or_default(),
            }
        }
    }
}
impl Order {
    /// Creates a new builder-style object to manufacture [`Order`](crate::model::Order)
    pub fn builder() -> crate::model::order::Builder {
        crate::model::order::Builder::default()
    }
}

/// <p>Information about a serialization/deserialization program (SerDe) that serves as an
/// extractor and loader.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SerDeInfo {
    /// <p>Name of the SerDe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Usually the class that implements the SerDe. An example is
    /// <code>org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe</code>.</p>
    pub serialization_library: std::option::Option<std::string::String>,
    /// <p>These key-value pairs define initialization parameters for the SerDe.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for SerDeInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SerDeInfo");
        formatter.field("name", &self.name);
        formatter.field("serialization_library", &self.serialization_library);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`SerDeInfo`](crate::model::SerDeInfo)
pub mod ser_de_info {
    /// A builder for [`SerDeInfo`](crate::model::SerDeInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) serialization_library: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Name of the SerDe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the SerDe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Usually the class that implements the SerDe. An example is
        /// <code>org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe</code>.</p>
        pub fn serialization_library(mut self, input: impl Into<std::string::String>) -> Self {
            self.serialization_library = Some(input.into());
            self
        }
        /// <p>Usually the class that implements the SerDe. An example is
        /// <code>org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe</code>.</p>
        pub fn set_serialization_library(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serialization_library = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>These key-value pairs define initialization parameters for the SerDe.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>These key-value pairs define initialization parameters for the SerDe.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`SerDeInfo`](crate::model::SerDeInfo)
        pub fn build(self) -> crate::model::SerDeInfo {
            crate::model::SerDeInfo {
                name: self.name,
                serialization_library: self.serialization_library,
                parameters: self.parameters,
            }
        }
    }
}
impl SerDeInfo {
    /// Creates a new builder-style object to manufacture [`SerDeInfo`](crate::model::SerDeInfo)
    pub fn builder() -> crate::model::ser_de_info::Builder {
        crate::model::ser_de_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Compatibility {
    #[allow(missing_docs)] // documentation missing in model
    Backward,
    #[allow(missing_docs)] // documentation missing in model
    BackwardAll,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Forward,
    #[allow(missing_docs)] // documentation missing in model
    ForwardAll,
    #[allow(missing_docs)] // documentation missing in model
    Full,
    #[allow(missing_docs)] // documentation missing in model
    FullAll,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Compatibility {
    fn from(s: &str) -> Self {
        match s {
            "BACKWARD" => Compatibility::Backward,
            "BACKWARD_ALL" => Compatibility::BackwardAll,
            "DISABLED" => Compatibility::Disabled,
            "FORWARD" => Compatibility::Forward,
            "FORWARD_ALL" => Compatibility::ForwardAll,
            "FULL" => Compatibility::Full,
            "FULL_ALL" => Compatibility::FullAll,
            "NONE" => Compatibility::None,
            other => Compatibility::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Compatibility {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Compatibility::from(s))
    }
}
impl Compatibility {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Compatibility::Backward => "BACKWARD",
            Compatibility::BackwardAll => "BACKWARD_ALL",
            Compatibility::Disabled => "DISABLED",
            Compatibility::Forward => "FORWARD",
            Compatibility::ForwardAll => "FORWARD_ALL",
            Compatibility::Full => "FULL",
            Compatibility::FullAll => "FULL_ALL",
            Compatibility::None => "NONE",
            Compatibility::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BACKWARD",
            "BACKWARD_ALL",
            "DISABLED",
            "FORWARD",
            "FORWARD_ALL",
            "FULL",
            "FULL_ALL",
            "NONE",
        ]
    }
}
impl AsRef<str> for Compatibility {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure containing the schema version information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaVersionNumber {
    /// <p>The latest version available for the schema.</p>
    pub latest_version: bool,
    /// <p>The version number of the schema.</p>
    pub version_number: i64,
}
impl std::fmt::Debug for SchemaVersionNumber {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaVersionNumber");
        formatter.field("latest_version", &self.latest_version);
        formatter.field("version_number", &self.version_number);
        formatter.finish()
    }
}
/// See [`SchemaVersionNumber`](crate::model::SchemaVersionNumber)
pub mod schema_version_number {
    /// A builder for [`SchemaVersionNumber`](crate::model::SchemaVersionNumber)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) latest_version: std::option::Option<bool>,
        pub(crate) version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The latest version available for the schema.</p>
        pub fn latest_version(mut self, input: bool) -> Self {
            self.latest_version = Some(input);
            self
        }
        /// <p>The latest version available for the schema.</p>
        pub fn set_latest_version(mut self, input: std::option::Option<bool>) -> Self {
            self.latest_version = input;
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaVersionNumber`](crate::model::SchemaVersionNumber)
        pub fn build(self) -> crate::model::SchemaVersionNumber {
            crate::model::SchemaVersionNumber {
                latest_version: self.latest_version.unwrap_or_default(),
                version_number: self.version_number.unwrap_or_default(),
            }
        }
    }
}
impl SchemaVersionNumber {
    /// Creates a new builder-style object to manufacture [`SchemaVersionNumber`](crate::model::SchemaVersionNumber)
    pub fn builder() -> crate::model::schema_version_number::Builder {
        crate::model::schema_version_number::Builder::default()
    }
}

/// <p>A wrapper structure that may contain the registry name and Amazon Resource Name (ARN).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegistryId {
    /// <p>Name of the registry. Used only for lookup. One of <code>RegistryArn</code> or <code>RegistryName</code> has to be provided. </p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>Arn of the registry to be updated. One of <code>RegistryArn</code> or <code>RegistryName</code> has to be provided.</p>
    pub registry_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RegistryId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegistryId");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.finish()
    }
}
/// See [`RegistryId`](crate::model::RegistryId)
pub mod registry_id {
    /// A builder for [`RegistryId`](crate::model::RegistryId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the registry. Used only for lookup. One of <code>RegistryArn</code> or <code>RegistryName</code> has to be provided. </p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>Name of the registry. Used only for lookup. One of <code>RegistryArn</code> or <code>RegistryName</code> has to be provided. </p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>Arn of the registry to be updated. One of <code>RegistryArn</code> or <code>RegistryName</code> has to be provided.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>Arn of the registry to be updated. One of <code>RegistryArn</code> or <code>RegistryName</code> has to be provided.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RegistryId`](crate::model::RegistryId)
        pub fn build(self) -> crate::model::RegistryId {
            crate::model::RegistryId {
                registry_name: self.registry_name,
                registry_arn: self.registry_arn,
            }
        }
    }
}
impl RegistryId {
    /// Creates a new builder-style object to manufacture [`RegistryId`](crate::model::RegistryId)
    pub fn builder() -> crate::model::registry_id::Builder {
        crate::model::registry_id::Builder::default()
    }
}

/// <p>The structure used to create and update a partition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartitionInput {
    /// <p>The values of the partition. Although this parameter is not required by the SDK, you must specify this parameter for a valid input.</p>
    ///
    /// <p>The values for the keys for the new partition must be passed as an array of String objects that must be ordered in the same order as the partition keys appearing in the Amazon S3 prefix. Otherwise Glue will add the values to the wrong keys.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The last time at which the partition was accessed.</p>
    pub last_access_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Provides information about the physical
    /// location where the partition is stored.</p>
    pub storage_descriptor: std::option::Option<crate::model::StorageDescriptor>,
    /// <p>These key-value pairs define partition parameters.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The last time at which column statistics were computed for this partition.</p>
    pub last_analyzed_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for PartitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartitionInput");
        formatter.field("values", &self.values);
        formatter.field("last_access_time", &self.last_access_time);
        formatter.field("storage_descriptor", &self.storage_descriptor);
        formatter.field("parameters", &self.parameters);
        formatter.field("last_analyzed_time", &self.last_analyzed_time);
        formatter.finish()
    }
}
/// See [`PartitionInput`](crate::model::PartitionInput)
pub mod partition_input {
    /// A builder for [`PartitionInput`](crate::model::PartitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) last_access_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) storage_descriptor: std::option::Option<crate::model::StorageDescriptor>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) last_analyzed_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of the partition. Although this parameter is not required by the SDK, you must specify this parameter for a valid input.</p>
        ///
        /// <p>The values for the keys for the new partition must be passed as an array of String objects that must be ordered in the same order as the partition keys appearing in the Amazon S3 prefix. Otherwise Glue will add the values to the wrong keys.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of the partition. Although this parameter is not required by the SDK, you must specify this parameter for a valid input.</p>
        ///
        /// <p>The values for the keys for the new partition must be passed as an array of String objects that must be ordered in the same order as the partition keys appearing in the Amazon S3 prefix. Otherwise Glue will add the values to the wrong keys.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The last time at which the partition was accessed.</p>
        pub fn last_access_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_access_time = Some(input);
            self
        }
        /// <p>The last time at which the partition was accessed.</p>
        pub fn set_last_access_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_access_time = input;
            self
        }
        /// <p>Provides information about the physical
        /// location where the partition is stored.</p>
        pub fn storage_descriptor(mut self, input: crate::model::StorageDescriptor) -> Self {
            self.storage_descriptor = Some(input);
            self
        }
        /// <p>Provides information about the physical
        /// location where the partition is stored.</p>
        pub fn set_storage_descriptor(
            mut self,
            input: std::option::Option<crate::model::StorageDescriptor>,
        ) -> Self {
            self.storage_descriptor = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>These key-value pairs define partition parameters.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>These key-value pairs define partition parameters.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The last time at which column statistics were computed for this partition.</p>
        pub fn last_analyzed_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_analyzed_time = Some(input);
            self
        }
        /// <p>The last time at which column statistics were computed for this partition.</p>
        pub fn set_last_analyzed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_analyzed_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PartitionInput`](crate::model::PartitionInput)
        pub fn build(self) -> crate::model::PartitionInput {
            crate::model::PartitionInput {
                values: self.values,
                last_access_time: self.last_access_time,
                storage_descriptor: self.storage_descriptor,
                parameters: self.parameters,
                last_analyzed_time: self.last_analyzed_time,
            }
        }
    }
}
impl PartitionInput {
    /// Creates a new builder-style object to manufacture [`PartitionInput`](crate::model::PartitionInput)
    pub fn builder() -> crate::model::partition_input::Builder {
        crate::model::partition_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkerType {
    #[allow(missing_docs)] // documentation missing in model
    G1X,
    #[allow(missing_docs)] // documentation missing in model
    G2X,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkerType {
    fn from(s: &str) -> Self {
        match s {
            "G.1X" => WorkerType::G1X,
            "G.2X" => WorkerType::G2X,
            "Standard" => WorkerType::Standard,
            other => WorkerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkerType::from(s))
    }
}
impl WorkerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkerType::G1X => "G.1X",
            WorkerType::G2X => "G.2X",
            WorkerType::Standard => "Standard",
            WorkerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["G.1X", "G.2X", "Standard"]
    }
}
impl AsRef<str> for WorkerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The algorithm-specific parameters that are associated with the machine learning
/// transform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformParameters {
    /// <p>The type of machine learning transform.</p>
    /// <p>For information about the types of machine learning transforms, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating Machine Learning Transforms</a>.</p>
    pub transform_type: std::option::Option<crate::model::TransformType>,
    /// <p>The parameters for the find matches algorithm.</p>
    pub find_matches_parameters: std::option::Option<crate::model::FindMatchesParameters>,
}
impl std::fmt::Debug for TransformParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformParameters");
        formatter.field("transform_type", &self.transform_type);
        formatter.field("find_matches_parameters", &self.find_matches_parameters);
        formatter.finish()
    }
}
/// See [`TransformParameters`](crate::model::TransformParameters)
pub mod transform_parameters {
    /// A builder for [`TransformParameters`](crate::model::TransformParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_type: std::option::Option<crate::model::TransformType>,
        pub(crate) find_matches_parameters:
            std::option::Option<crate::model::FindMatchesParameters>,
    }
    impl Builder {
        /// <p>The type of machine learning transform.</p>
        /// <p>For information about the types of machine learning transforms, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating Machine Learning Transforms</a>.</p>
        pub fn transform_type(mut self, input: crate::model::TransformType) -> Self {
            self.transform_type = Some(input);
            self
        }
        /// <p>The type of machine learning transform.</p>
        /// <p>For information about the types of machine learning transforms, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating Machine Learning Transforms</a>.</p>
        pub fn set_transform_type(
            mut self,
            input: std::option::Option<crate::model::TransformType>,
        ) -> Self {
            self.transform_type = input;
            self
        }
        /// <p>The parameters for the find matches algorithm.</p>
        pub fn find_matches_parameters(
            mut self,
            input: crate::model::FindMatchesParameters,
        ) -> Self {
            self.find_matches_parameters = Some(input);
            self
        }
        /// <p>The parameters for the find matches algorithm.</p>
        pub fn set_find_matches_parameters(
            mut self,
            input: std::option::Option<crate::model::FindMatchesParameters>,
        ) -> Self {
            self.find_matches_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformParameters`](crate::model::TransformParameters)
        pub fn build(self) -> crate::model::TransformParameters {
            crate::model::TransformParameters {
                transform_type: self.transform_type,
                find_matches_parameters: self.find_matches_parameters,
            }
        }
    }
}
impl TransformParameters {
    /// Creates a new builder-style object to manufacture [`TransformParameters`](crate::model::TransformParameters)
    pub fn builder() -> crate::model::transform_parameters::Builder {
        crate::model::transform_parameters::Builder::default()
    }
}

/// <p>The parameters to configure the find matches transform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindMatchesParameters {
    /// <p>The name of a column that uniquely identifies rows in the source table. Used to help identify matching records.</p>
    pub primary_key_column_name: std::option::Option<std::string::String>,
    /// <p>The value selected when tuning your transform for a balance between precision and recall.
    /// A value of 0.5 means no preference; a value of 1.0 means a bias purely for precision, and a
    /// value of 0.0 means a bias for recall. Because this is a tradeoff, choosing values close to 1.0
    /// means very low recall, and choosing values close to 0.0 results in very low precision.</p>
    ///
    /// <p>The precision metric indicates how often your model is correct when it predicts a match. </p>
    ///
    /// <p>The recall metric indicates that for an actual match, how often your model predicts the
    /// match.</p>
    pub precision_recall_tradeoff: std::option::Option<f64>,
    /// <p>The value that is selected when tuning your transform for a balance between accuracy and
    /// cost. A value of 0.5 means that the system balances accuracy and cost concerns. A value of 1.0
    /// means a bias purely for accuracy, which typically results in a higher cost, sometimes
    /// substantially higher. A value of 0.0 means a bias purely for cost, which results in a less
    /// accurate <code>FindMatches</code> transform, sometimes with unacceptable accuracy.</p>
    ///
    /// <p>Accuracy measures how well the transform finds true positives and true negatives. Increasing accuracy requires more machine resources and cost. But it also results in increased recall. </p>
    ///
    /// <p>Cost measures how many compute resources, and thus money, are consumed to run the
    /// transform.</p>
    pub accuracy_cost_tradeoff: std::option::Option<f64>,
    /// <p>The value to switch on or off to force the output to match the provided labels from users. If the value is <code>True</code>, the <code>find matches</code> transform forces the output to match the provided labels. The results override the normal conflation results. If the value is <code>False</code>, the <code>find matches</code> transform does not ensure all the labels provided are respected, and the results rely on the trained model.</p>
    /// <p>Note that setting this value to true may increase the conflation execution time.</p>
    pub enforce_provided_labels: std::option::Option<bool>,
}
impl std::fmt::Debug for FindMatchesParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindMatchesParameters");
        formatter.field("primary_key_column_name", &self.primary_key_column_name);
        formatter.field("precision_recall_tradeoff", &self.precision_recall_tradeoff);
        formatter.field("accuracy_cost_tradeoff", &self.accuracy_cost_tradeoff);
        formatter.field("enforce_provided_labels", &self.enforce_provided_labels);
        formatter.finish()
    }
}
/// See [`FindMatchesParameters`](crate::model::FindMatchesParameters)
pub mod find_matches_parameters {
    /// A builder for [`FindMatchesParameters`](crate::model::FindMatchesParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary_key_column_name: std::option::Option<std::string::String>,
        pub(crate) precision_recall_tradeoff: std::option::Option<f64>,
        pub(crate) accuracy_cost_tradeoff: std::option::Option<f64>,
        pub(crate) enforce_provided_labels: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of a column that uniquely identifies rows in the source table. Used to help identify matching records.</p>
        pub fn primary_key_column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_key_column_name = Some(input.into());
            self
        }
        /// <p>The name of a column that uniquely identifies rows in the source table. Used to help identify matching records.</p>
        pub fn set_primary_key_column_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_key_column_name = input;
            self
        }
        /// <p>The value selected when tuning your transform for a balance between precision and recall.
        /// A value of 0.5 means no preference; a value of 1.0 means a bias purely for precision, and a
        /// value of 0.0 means a bias for recall. Because this is a tradeoff, choosing values close to 1.0
        /// means very low recall, and choosing values close to 0.0 results in very low precision.</p>
        ///
        /// <p>The precision metric indicates how often your model is correct when it predicts a match. </p>
        ///
        /// <p>The recall metric indicates that for an actual match, how often your model predicts the
        /// match.</p>
        pub fn precision_recall_tradeoff(mut self, input: f64) -> Self {
            self.precision_recall_tradeoff = Some(input);
            self
        }
        /// <p>The value selected when tuning your transform for a balance between precision and recall.
        /// A value of 0.5 means no preference; a value of 1.0 means a bias purely for precision, and a
        /// value of 0.0 means a bias for recall. Because this is a tradeoff, choosing values close to 1.0
        /// means very low recall, and choosing values close to 0.0 results in very low precision.</p>
        ///
        /// <p>The precision metric indicates how often your model is correct when it predicts a match. </p>
        ///
        /// <p>The recall metric indicates that for an actual match, how often your model predicts the
        /// match.</p>
        pub fn set_precision_recall_tradeoff(mut self, input: std::option::Option<f64>) -> Self {
            self.precision_recall_tradeoff = input;
            self
        }
        /// <p>The value that is selected when tuning your transform for a balance between accuracy and
        /// cost. A value of 0.5 means that the system balances accuracy and cost concerns. A value of 1.0
        /// means a bias purely for accuracy, which typically results in a higher cost, sometimes
        /// substantially higher. A value of 0.0 means a bias purely for cost, which results in a less
        /// accurate <code>FindMatches</code> transform, sometimes with unacceptable accuracy.</p>
        ///
        /// <p>Accuracy measures how well the transform finds true positives and true negatives. Increasing accuracy requires more machine resources and cost. But it also results in increased recall. </p>
        ///
        /// <p>Cost measures how many compute resources, and thus money, are consumed to run the
        /// transform.</p>
        pub fn accuracy_cost_tradeoff(mut self, input: f64) -> Self {
            self.accuracy_cost_tradeoff = Some(input);
            self
        }
        /// <p>The value that is selected when tuning your transform for a balance between accuracy and
        /// cost. A value of 0.5 means that the system balances accuracy and cost concerns. A value of 1.0
        /// means a bias purely for accuracy, which typically results in a higher cost, sometimes
        /// substantially higher. A value of 0.0 means a bias purely for cost, which results in a less
        /// accurate <code>FindMatches</code> transform, sometimes with unacceptable accuracy.</p>
        ///
        /// <p>Accuracy measures how well the transform finds true positives and true negatives. Increasing accuracy requires more machine resources and cost. But it also results in increased recall. </p>
        ///
        /// <p>Cost measures how many compute resources, and thus money, are consumed to run the
        /// transform.</p>
        pub fn set_accuracy_cost_tradeoff(mut self, input: std::option::Option<f64>) -> Self {
            self.accuracy_cost_tradeoff = input;
            self
        }
        /// <p>The value to switch on or off to force the output to match the provided labels from users. If the value is <code>True</code>, the <code>find matches</code> transform forces the output to match the provided labels. The results override the normal conflation results. If the value is <code>False</code>, the <code>find matches</code> transform does not ensure all the labels provided are respected, and the results rely on the trained model.</p>
        /// <p>Note that setting this value to true may increase the conflation execution time.</p>
        pub fn enforce_provided_labels(mut self, input: bool) -> Self {
            self.enforce_provided_labels = Some(input);
            self
        }
        /// <p>The value to switch on or off to force the output to match the provided labels from users. If the value is <code>True</code>, the <code>find matches</code> transform forces the output to match the provided labels. The results override the normal conflation results. If the value is <code>False</code>, the <code>find matches</code> transform does not ensure all the labels provided are respected, and the results rely on the trained model.</p>
        /// <p>Note that setting this value to true may increase the conflation execution time.</p>
        pub fn set_enforce_provided_labels(mut self, input: std::option::Option<bool>) -> Self {
            self.enforce_provided_labels = input;
            self
        }
        /// Consumes the builder and constructs a [`FindMatchesParameters`](crate::model::FindMatchesParameters)
        pub fn build(self) -> crate::model::FindMatchesParameters {
            crate::model::FindMatchesParameters {
                primary_key_column_name: self.primary_key_column_name,
                precision_recall_tradeoff: self.precision_recall_tradeoff,
                accuracy_cost_tradeoff: self.accuracy_cost_tradeoff,
                enforce_provided_labels: self.enforce_provided_labels,
            }
        }
    }
}
impl FindMatchesParameters {
    /// Creates a new builder-style object to manufacture [`FindMatchesParameters`](crate::model::FindMatchesParameters)
    pub fn builder() -> crate::model::find_matches_parameters::Builder {
        crate::model::find_matches_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransformType {
    #[allow(missing_docs)] // documentation missing in model
    FindMatches,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransformType {
    fn from(s: &str) -> Self {
        match s {
            "FIND_MATCHES" => TransformType::FindMatches,
            other => TransformType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransformType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransformType::from(s))
    }
}
impl TransformType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransformType::FindMatches => "FIND_MATCHES",
            TransformType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FIND_MATCHES"]
    }
}
impl AsRef<str> for TransformType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies information used to update an existing job definition. The previous job
/// definition is completely overwritten by this information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobUpdate {
    /// <p>Description of the job being defined.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>This field is reserved for future use.</p>
    pub log_uri: std::option::Option<std::string::String>,
    /// <p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job
    /// (required).</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed
    /// for this job.</p>
    pub execution_property: std::option::Option<crate::model::ExecutionProperty>,
    /// <p>The <code>JobCommand</code> that runs this job (required).</p>
    pub command: std::option::Option<crate::model::JobCommand>,
    /// <p>The default arguments for this job.</p>
    /// <p>You can specify arguments here that your own job-execution script
    /// consumes, as well as arguments that Glue itself consumes.</p>
    /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
    /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
    pub default_arguments:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Non-overridable arguments for this job, specified as name-value pairs.</p>
    pub non_overridable_arguments:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The connections used for this job.</p>
    pub connections: std::option::Option<crate::model::ConnectionsList>,
    /// <p>The maximum number of times to retry this job if it fails.</p>
    pub max_retries: i32,
    /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
    ///
    /// <p>The number of Glue data processing units (DPUs) to allocate to this job. You can
    /// allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing
    /// power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
    /// see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
    /// page</a>.</p>
    pub allocated_capacity: i32,
    /// <p>The job timeout in minutes.  This is the maximum time that a job run
    /// can consume resources before it is terminated and enters <code>TIMEOUT</code>
    /// status. The default is 2,880 minutes (48 hours).</p>
    pub timeout: std::option::Option<i32>,
    /// <p>For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
    /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.</p>
    ///
    /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>       
    ///
    /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
    /// running a Python shell job or an Apache Spark ETL job:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
    /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
    /// </li>
    /// <li>
    /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache
    /// Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs.
    /// The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
    /// </li>
    /// </ul>    
    /// <p>For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you should specify a <code>Worker type</code> and the <code>Number of workers</code>.</p>
    pub max_capacity: std::option::Option<f64>,
    /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
    /// <ul>
    /// <li>
    /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
    /// </li>
    /// </ul>
    pub worker_type: std::option::Option<crate::model::WorkerType>,
    /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
    ///
    /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
    pub number_of_workers: std::option::Option<i32>,
    /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
    /// job.</p>
    pub security_configuration: std::option::Option<std::string::String>,
    /// <p>Specifies the configuration properties of a job notification.</p>
    pub notification_property: std::option::Option<crate::model::NotificationProperty>,
    /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
    ///
    /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
    pub glue_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JobUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobUpdate");
        formatter.field("description", &self.description);
        formatter.field("log_uri", &self.log_uri);
        formatter.field("role", &self.role);
        formatter.field("execution_property", &self.execution_property);
        formatter.field("command", &self.command);
        formatter.field("default_arguments", &self.default_arguments);
        formatter.field("non_overridable_arguments", &self.non_overridable_arguments);
        formatter.field("connections", &self.connections);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("allocated_capacity", &self.allocated_capacity);
        formatter.field("timeout", &self.timeout);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("worker_type", &self.worker_type);
        formatter.field("number_of_workers", &self.number_of_workers);
        formatter.field("security_configuration", &self.security_configuration);
        formatter.field("notification_property", &self.notification_property);
        formatter.field("glue_version", &self.glue_version);
        formatter.finish()
    }
}
/// See [`JobUpdate`](crate::model::JobUpdate)
pub mod job_update {
    /// A builder for [`JobUpdate`](crate::model::JobUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) log_uri: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) execution_property: std::option::Option<crate::model::ExecutionProperty>,
        pub(crate) command: std::option::Option<crate::model::JobCommand>,
        pub(crate) default_arguments: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) non_overridable_arguments: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) connections: std::option::Option<crate::model::ConnectionsList>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) allocated_capacity: std::option::Option<i32>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) max_capacity: std::option::Option<f64>,
        pub(crate) worker_type: std::option::Option<crate::model::WorkerType>,
        pub(crate) number_of_workers: std::option::Option<i32>,
        pub(crate) security_configuration: std::option::Option<std::string::String>,
        pub(crate) notification_property: std::option::Option<crate::model::NotificationProperty>,
        pub(crate) glue_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Description of the job being defined.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the job being defined.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>This field is reserved for future use.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_uri = Some(input.into());
            self
        }
        /// <p>This field is reserved for future use.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_uri = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job
        /// (required).</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job
        /// (required).</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed
        /// for this job.</p>
        pub fn execution_property(mut self, input: crate::model::ExecutionProperty) -> Self {
            self.execution_property = Some(input);
            self
        }
        /// <p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed
        /// for this job.</p>
        pub fn set_execution_property(
            mut self,
            input: std::option::Option<crate::model::ExecutionProperty>,
        ) -> Self {
            self.execution_property = input;
            self
        }
        /// <p>The <code>JobCommand</code> that runs this job (required).</p>
        pub fn command(mut self, input: crate::model::JobCommand) -> Self {
            self.command = Some(input);
            self
        }
        /// <p>The <code>JobCommand</code> that runs this job (required).</p>
        pub fn set_command(mut self, input: std::option::Option<crate::model::JobCommand>) -> Self {
            self.command = input;
            self
        }
        /// Adds a key-value pair to `default_arguments`.
        ///
        /// To override the contents of this collection use [`set_default_arguments`](Self::set_default_arguments).
        ///
        /// <p>The default arguments for this job.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn default_arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.default_arguments.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.default_arguments = Some(hash_map);
            self
        }
        /// <p>The default arguments for this job.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn set_default_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.default_arguments = input;
            self
        }
        /// Adds a key-value pair to `non_overridable_arguments`.
        ///
        /// To override the contents of this collection use [`set_non_overridable_arguments`](Self::set_non_overridable_arguments).
        ///
        /// <p>Non-overridable arguments for this job, specified as name-value pairs.</p>
        pub fn non_overridable_arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.non_overridable_arguments.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.non_overridable_arguments = Some(hash_map);
            self
        }
        /// <p>Non-overridable arguments for this job, specified as name-value pairs.</p>
        pub fn set_non_overridable_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.non_overridable_arguments = input;
            self
        }
        /// <p>The connections used for this job.</p>
        pub fn connections(mut self, input: crate::model::ConnectionsList) -> Self {
            self.connections = Some(input);
            self
        }
        /// <p>The connections used for this job.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<crate::model::ConnectionsList>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>The maximum number of times to retry this job if it fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times to retry this job if it fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
        ///
        /// <p>The number of Glue data processing units (DPUs) to allocate to this job. You can
        /// allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing
        /// power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
        /// see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>.</p>
        pub fn allocated_capacity(mut self, input: i32) -> Self {
            self.allocated_capacity = Some(input);
            self
        }
        /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
        ///
        /// <p>The number of Glue data processing units (DPUs) to allocate to this job. You can
        /// allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing
        /// power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
        /// see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>.</p>
        pub fn set_allocated_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_capacity = input;
            self
        }
        /// <p>The job timeout in minutes.  This is the maximum time that a job run
        /// can consume resources before it is terminated and enters <code>TIMEOUT</code>
        /// status. The default is 2,880 minutes (48 hours).</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The job timeout in minutes.  This is the maximum time that a job run
        /// can consume resources before it is terminated and enters <code>TIMEOUT</code>
        /// status. The default is 2,880 minutes (48 hours).</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.</p>
        ///
        /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>       
        ///
        /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
        /// running a Python shell job or an Apache Spark ETL job:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
        /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
        /// </li>
        /// <li>
        /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache
        /// Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs.
        /// The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
        /// </li>
        /// </ul>    
        /// <p>For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you should specify a <code>Worker type</code> and the <code>Number of workers</code>.</p>
        pub fn max_capacity(mut self, input: f64) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.</p>
        ///
        /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>       
        ///
        /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
        /// running a Python shell job or an Apache Spark ETL job:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
        /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
        /// </li>
        /// <li>
        /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache
        /// Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs.
        /// The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
        /// </li>
        /// </ul>    
        /// <p>For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you should specify a <code>Worker type</code> and the <code>Number of workers</code>.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<f64>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// </ul>
        pub fn worker_type(mut self, input: crate::model::WorkerType) -> Self {
            self.worker_type = Some(input);
            self
        }
        /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// </ul>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.worker_type = input;
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn number_of_workers(mut self, input: i32) -> Self {
            self.number_of_workers = Some(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_workers = input;
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// job.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_configuration = Some(input.into());
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// job.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_configuration = input;
            self
        }
        /// <p>Specifies the configuration properties of a job notification.</p>
        pub fn notification_property(mut self, input: crate::model::NotificationProperty) -> Self {
            self.notification_property = Some(input);
            self
        }
        /// <p>Specifies the configuration properties of a job notification.</p>
        pub fn set_notification_property(
            mut self,
            input: std::option::Option<crate::model::NotificationProperty>,
        ) -> Self {
            self.notification_property = input;
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        pub fn glue_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.glue_version = Some(input.into());
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.glue_version = input;
            self
        }
        /// Consumes the builder and constructs a [`JobUpdate`](crate::model::JobUpdate)
        pub fn build(self) -> crate::model::JobUpdate {
            crate::model::JobUpdate {
                description: self.description,
                log_uri: self.log_uri,
                role: self.role,
                execution_property: self.execution_property,
                command: self.command,
                default_arguments: self.default_arguments,
                non_overridable_arguments: self.non_overridable_arguments,
                connections: self.connections,
                max_retries: self.max_retries.unwrap_or_default(),
                allocated_capacity: self.allocated_capacity.unwrap_or_default(),
                timeout: self.timeout,
                max_capacity: self.max_capacity,
                worker_type: self.worker_type,
                number_of_workers: self.number_of_workers,
                security_configuration: self.security_configuration,
                notification_property: self.notification_property,
                glue_version: self.glue_version,
            }
        }
    }
}
impl JobUpdate {
    /// Creates a new builder-style object to manufacture [`JobUpdate`](crate::model::JobUpdate)
    pub fn builder() -> crate::model::job_update::Builder {
        crate::model::job_update::Builder::default()
    }
}

/// <p>Specifies the connections used by a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionsList {
    /// <p>A list of connections used by the job.</p>
    pub connections: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ConnectionsList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionsList");
        formatter.field("connections", &self.connections);
        formatter.finish()
    }
}
/// See [`ConnectionsList`](crate::model::ConnectionsList)
pub mod connections_list {
    /// A builder for [`ConnectionsList`](crate::model::ConnectionsList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connections: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `connections`.
        ///
        /// To override the contents of this collection use [`set_connections`](Self::set_connections).
        ///
        /// <p>A list of connections used by the job.</p>
        pub fn connections(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.connections.unwrap_or_default();
            v.push(input.into());
            self.connections = Some(v);
            self
        }
        /// <p>A list of connections used by the job.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionsList`](crate::model::ConnectionsList)
        pub fn build(self) -> crate::model::ConnectionsList {
            crate::model::ConnectionsList {
                connections: self.connections,
            }
        }
    }
}
impl ConnectionsList {
    /// Creates a new builder-style object to manufacture [`ConnectionsList`](crate::model::ConnectionsList)
    pub fn builder() -> crate::model::connections_list::Builder {
        crate::model::connections_list::Builder::default()
    }
}

/// <p>Specifies code that runs when a job is run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobCommand {
    /// <p>The name of the job command. For an Apache Spark ETL job, this must be
    /// <code>glueetl</code>. For a Python shell job, it must be <code>pythonshell</code>.
    /// For an Apache Spark streaming ETL job, this must be <code>gluestreaming</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that runs a
    /// job.</p>
    pub script_location: std::option::Option<std::string::String>,
    /// <p>The Python version being used to run a Python shell job. Allowed values are 2 or 3.</p>
    pub python_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JobCommand {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobCommand");
        formatter.field("name", &self.name);
        formatter.field("script_location", &self.script_location);
        formatter.field("python_version", &self.python_version);
        formatter.finish()
    }
}
/// See [`JobCommand`](crate::model::JobCommand)
pub mod job_command {
    /// A builder for [`JobCommand`](crate::model::JobCommand)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) script_location: std::option::Option<std::string::String>,
        pub(crate) python_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job command. For an Apache Spark ETL job, this must be
        /// <code>glueetl</code>. For a Python shell job, it must be <code>pythonshell</code>.
        /// For an Apache Spark streaming ETL job, this must be <code>gluestreaming</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the job command. For an Apache Spark ETL job, this must be
        /// <code>glueetl</code>. For a Python shell job, it must be <code>pythonshell</code>.
        /// For an Apache Spark streaming ETL job, this must be <code>gluestreaming</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that runs a
        /// job.</p>
        pub fn script_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.script_location = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that runs a
        /// job.</p>
        pub fn set_script_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.script_location = input;
            self
        }
        /// <p>The Python version being used to run a Python shell job. Allowed values are 2 or 3.</p>
        pub fn python_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.python_version = Some(input.into());
            self
        }
        /// <p>The Python version being used to run a Python shell job. Allowed values are 2 or 3.</p>
        pub fn set_python_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.python_version = input;
            self
        }
        /// Consumes the builder and constructs a [`JobCommand`](crate::model::JobCommand)
        pub fn build(self) -> crate::model::JobCommand {
            crate::model::JobCommand {
                name: self.name,
                script_location: self.script_location,
                python_version: self.python_version,
            }
        }
    }
}
impl JobCommand {
    /// Creates a new builder-style object to manufacture [`JobCommand`](crate::model::JobCommand)
    pub fn builder() -> crate::model::job_command::Builder {
        crate::model::job_command::Builder::default()
    }
}

/// <p>An execution property of a job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionProperty {
    /// <p>The maximum number of concurrent runs allowed for the job.
    /// The default is 1. An error is returned when this threshold is reached.
    /// The maximum value you can specify is controlled by a service limit.</p>
    pub max_concurrent_runs: i32,
}
impl std::fmt::Debug for ExecutionProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionProperty");
        formatter.field("max_concurrent_runs", &self.max_concurrent_runs);
        formatter.finish()
    }
}
/// See [`ExecutionProperty`](crate::model::ExecutionProperty)
pub mod execution_property {
    /// A builder for [`ExecutionProperty`](crate::model::ExecutionProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_concurrent_runs: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum number of concurrent runs allowed for the job.
        /// The default is 1. An error is returned when this threshold is reached.
        /// The maximum value you can specify is controlled by a service limit.</p>
        pub fn max_concurrent_runs(mut self, input: i32) -> Self {
            self.max_concurrent_runs = Some(input);
            self
        }
        /// <p>The maximum number of concurrent runs allowed for the job.
        /// The default is 1. An error is returned when this threshold is reached.
        /// The maximum value you can specify is controlled by a service limit.</p>
        pub fn set_max_concurrent_runs(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrent_runs = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionProperty`](crate::model::ExecutionProperty)
        pub fn build(self) -> crate::model::ExecutionProperty {
            crate::model::ExecutionProperty {
                max_concurrent_runs: self.max_concurrent_runs.unwrap_or_default(),
            }
        }
    }
}
impl ExecutionProperty {
    /// Creates a new builder-style object to manufacture [`ExecutionProperty`](crate::model::ExecutionProperty)
    pub fn builder() -> crate::model::execution_property::Builder {
        crate::model::execution_property::Builder::default()
    }
}

/// <p>Custom libraries to be loaded into a development endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DevEndpointCustomLibraries {
    /// <p>The paths to one or more Python libraries in an Amazon Simple Storage Service (Amazon S3)
    /// bucket that should be loaded in your <code>DevEndpoint</code>. Multiple values must be
    /// complete paths separated by a comma.</p>
    /// <note>
    /// <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on
    /// C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data
    /// analysis library, are not currently supported.</p>
    /// </note>
    pub extra_python_libs_s3_path: std::option::Option<std::string::String>,
    /// <p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded
    /// in your <code>DevEndpoint</code>.</p>
    /// <note>
    /// <p>You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.</p>
    /// </note>
    pub extra_jars_s3_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DevEndpointCustomLibraries {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DevEndpointCustomLibraries");
        formatter.field("extra_python_libs_s3_path", &self.extra_python_libs_s3_path);
        formatter.field("extra_jars_s3_path", &self.extra_jars_s3_path);
        formatter.finish()
    }
}
/// See [`DevEndpointCustomLibraries`](crate::model::DevEndpointCustomLibraries)
pub mod dev_endpoint_custom_libraries {
    /// A builder for [`DevEndpointCustomLibraries`](crate::model::DevEndpointCustomLibraries)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) extra_python_libs_s3_path: std::option::Option<std::string::String>,
        pub(crate) extra_jars_s3_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The paths to one or more Python libraries in an Amazon Simple Storage Service (Amazon S3)
        /// bucket that should be loaded in your <code>DevEndpoint</code>. Multiple values must be
        /// complete paths separated by a comma.</p>
        /// <note>
        /// <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on
        /// C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data
        /// analysis library, are not currently supported.</p>
        /// </note>
        pub fn extra_python_libs_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.extra_python_libs_s3_path = Some(input.into());
            self
        }
        /// <p>The paths to one or more Python libraries in an Amazon Simple Storage Service (Amazon S3)
        /// bucket that should be loaded in your <code>DevEndpoint</code>. Multiple values must be
        /// complete paths separated by a comma.</p>
        /// <note>
        /// <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on
        /// C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data
        /// analysis library, are not currently supported.</p>
        /// </note>
        pub fn set_extra_python_libs_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extra_python_libs_s3_path = input;
            self
        }
        /// <p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded
        /// in your <code>DevEndpoint</code>.</p>
        /// <note>
        /// <p>You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.</p>
        /// </note>
        pub fn extra_jars_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.extra_jars_s3_path = Some(input.into());
            self
        }
        /// <p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded
        /// in your <code>DevEndpoint</code>.</p>
        /// <note>
        /// <p>You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.</p>
        /// </note>
        pub fn set_extra_jars_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extra_jars_s3_path = input;
            self
        }
        /// Consumes the builder and constructs a [`DevEndpointCustomLibraries`](crate::model::DevEndpointCustomLibraries)
        pub fn build(self) -> crate::model::DevEndpointCustomLibraries {
            crate::model::DevEndpointCustomLibraries {
                extra_python_libs_s3_path: self.extra_python_libs_s3_path,
                extra_jars_s3_path: self.extra_jars_s3_path,
            }
        }
    }
}
impl DevEndpointCustomLibraries {
    /// Creates a new builder-style object to manufacture [`DevEndpointCustomLibraries`](crate::model::DevEndpointCustomLibraries)
    pub fn builder() -> crate::model::dev_endpoint_custom_libraries::Builder {
        crate::model::dev_endpoint_custom_libraries::Builder::default()
    }
}

/// <p>The structure used to create or update a database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatabaseInput {
    /// <p>The name of the database. For Hive compatibility, this is folded to lowercase when it is
    /// stored.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the database.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The location of the database (for example, an HDFS path). </p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>These key-value pairs define parameters and properties
    /// of the database.</p>
    /// <p>These key-value pairs define parameters and properties of the database.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Creates a set of default permissions on the table for principals. </p>
    pub create_table_default_permissions:
        std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
    /// <p>A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.</p>
    pub target_database: std::option::Option<crate::model::DatabaseIdentifier>,
}
impl std::fmt::Debug for DatabaseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatabaseInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("parameters", &self.parameters);
        formatter.field(
            "create_table_default_permissions",
            &self.create_table_default_permissions,
        );
        formatter.field("target_database", &self.target_database);
        formatter.finish()
    }
}
/// See [`DatabaseInput`](crate::model::DatabaseInput)
pub mod database_input {
    /// A builder for [`DatabaseInput`](crate::model::DatabaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) create_table_default_permissions:
            std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
        pub(crate) target_database: std::option::Option<crate::model::DatabaseIdentifier>,
    }
    impl Builder {
        /// <p>The name of the database. For Hive compatibility, this is folded to lowercase when it is
        /// stored.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the database. For Hive compatibility, this is folded to lowercase when it is
        /// stored.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the database.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the database.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The location of the database (for example, an HDFS path). </p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The location of the database (for example, an HDFS path). </p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>These key-value pairs define parameters and properties
        /// of the database.</p>
        /// <p>These key-value pairs define parameters and properties of the database.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>These key-value pairs define parameters and properties
        /// of the database.</p>
        /// <p>These key-value pairs define parameters and properties of the database.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `create_table_default_permissions`.
        ///
        /// To override the contents of this collection use [`set_create_table_default_permissions`](Self::set_create_table_default_permissions).
        ///
        /// <p>Creates a set of default permissions on the table for principals. </p>
        pub fn create_table_default_permissions(
            mut self,
            input: impl Into<crate::model::PrincipalPermissions>,
        ) -> Self {
            let mut v = self.create_table_default_permissions.unwrap_or_default();
            v.push(input.into());
            self.create_table_default_permissions = Some(v);
            self
        }
        /// <p>Creates a set of default permissions on the table for principals. </p>
        pub fn set_create_table_default_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
        ) -> Self {
            self.create_table_default_permissions = input;
            self
        }
        /// <p>A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.</p>
        pub fn target_database(mut self, input: crate::model::DatabaseIdentifier) -> Self {
            self.target_database = Some(input);
            self
        }
        /// <p>A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.</p>
        pub fn set_target_database(
            mut self,
            input: std::option::Option<crate::model::DatabaseIdentifier>,
        ) -> Self {
            self.target_database = input;
            self
        }
        /// Consumes the builder and constructs a [`DatabaseInput`](crate::model::DatabaseInput)
        pub fn build(self) -> crate::model::DatabaseInput {
            crate::model::DatabaseInput {
                name: self.name,
                description: self.description,
                location_uri: self.location_uri,
                parameters: self.parameters,
                create_table_default_permissions: self.create_table_default_permissions,
                target_database: self.target_database,
            }
        }
    }
}
impl DatabaseInput {
    /// Creates a new builder-style object to manufacture [`DatabaseInput`](crate::model::DatabaseInput)
    pub fn builder() -> crate::model::database_input::Builder {
        crate::model::database_input::Builder::default()
    }
}

/// <p>A structure that describes a target database for resource linking.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatabaseIdentifier {
    /// <p>The ID of the Data Catalog in which the database resides.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The name of the catalog database.</p>
    pub database_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DatabaseIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatabaseIdentifier");
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("database_name", &self.database_name);
        formatter.finish()
    }
}
/// See [`DatabaseIdentifier`](crate::model::DatabaseIdentifier)
pub mod database_identifier {
    /// A builder for [`DatabaseIdentifier`](crate::model::DatabaseIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Data Catalog in which the database resides.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the Data Catalog in which the database resides.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The name of the catalog database.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the catalog database.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DatabaseIdentifier`](crate::model::DatabaseIdentifier)
        pub fn build(self) -> crate::model::DatabaseIdentifier {
            crate::model::DatabaseIdentifier {
                catalog_id: self.catalog_id,
                database_name: self.database_name,
            }
        }
    }
}
impl DatabaseIdentifier {
    /// Creates a new builder-style object to manufacture [`DatabaseIdentifier`](crate::model::DatabaseIdentifier)
    pub fn builder() -> crate::model::database_identifier::Builder {
        crate::model::database_identifier::Builder::default()
    }
}

/// <p>Permissions granted to a principal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrincipalPermissions {
    /// <p>The principal who is granted permissions.</p>
    pub principal: std::option::Option<crate::model::DataLakePrincipal>,
    /// <p>The permissions that are granted to the principal.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
}
impl std::fmt::Debug for PrincipalPermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrincipalPermissions");
        formatter.field("principal", &self.principal);
        formatter.field("permissions", &self.permissions);
        formatter.finish()
    }
}
/// See [`PrincipalPermissions`](crate::model::PrincipalPermissions)
pub mod principal_permissions {
    /// A builder for [`PrincipalPermissions`](crate::model::PrincipalPermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal: std::option::Option<crate::model::DataLakePrincipal>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<crate::model::Permission>>,
    }
    impl Builder {
        /// <p>The principal who is granted permissions.</p>
        pub fn principal(mut self, input: crate::model::DataLakePrincipal) -> Self {
            self.principal = Some(input);
            self
        }
        /// <p>The principal who is granted permissions.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<crate::model::DataLakePrincipal>,
        ) -> Self {
            self.principal = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions that are granted to the principal.</p>
        pub fn permissions(mut self, input: impl Into<crate::model::Permission>) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>The permissions that are granted to the principal.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Permission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`PrincipalPermissions`](crate::model::PrincipalPermissions)
        pub fn build(self) -> crate::model::PrincipalPermissions {
            crate::model::PrincipalPermissions {
                principal: self.principal,
                permissions: self.permissions,
            }
        }
    }
}
impl PrincipalPermissions {
    /// Creates a new builder-style object to manufacture [`PrincipalPermissions`](crate::model::PrincipalPermissions)
    pub fn builder() -> crate::model::principal_permissions::Builder {
        crate::model::principal_permissions::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Permission {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Alter,
    #[allow(missing_docs)] // documentation missing in model
    CreateDatabase,
    #[allow(missing_docs)] // documentation missing in model
    CreateTable,
    #[allow(missing_docs)] // documentation missing in model
    DataLocationAccess,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Drop,
    #[allow(missing_docs)] // documentation missing in model
    Insert,
    #[allow(missing_docs)] // documentation missing in model
    Select,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Permission {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => Permission::All,
            "ALTER" => Permission::Alter,
            "CREATE_DATABASE" => Permission::CreateDatabase,
            "CREATE_TABLE" => Permission::CreateTable,
            "DATA_LOCATION_ACCESS" => Permission::DataLocationAccess,
            "DELETE" => Permission::Delete,
            "DROP" => Permission::Drop,
            "INSERT" => Permission::Insert,
            "SELECT" => Permission::Select,
            other => Permission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Permission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Permission::from(s))
    }
}
impl Permission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Permission::All => "ALL",
            Permission::Alter => "ALTER",
            Permission::CreateDatabase => "CREATE_DATABASE",
            Permission::CreateTable => "CREATE_TABLE",
            Permission::DataLocationAccess => "DATA_LOCATION_ACCESS",
            Permission::Delete => "DELETE",
            Permission::Drop => "DROP",
            Permission::Insert => "INSERT",
            Permission::Select => "SELECT",
            Permission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL",
            "ALTER",
            "CREATE_DATABASE",
            "CREATE_TABLE",
            "DATA_LOCATION_ACCESS",
            "DELETE",
            "DROP",
            "INSERT",
            "SELECT",
        ]
    }
}
impl AsRef<str> for Permission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Lake Formation principal.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataLakePrincipal {
    /// <p>An identifier for the Lake Formation principal.</p>
    pub data_lake_principal_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DataLakePrincipal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataLakePrincipal");
        formatter.field(
            "data_lake_principal_identifier",
            &self.data_lake_principal_identifier,
        );
        formatter.finish()
    }
}
/// See [`DataLakePrincipal`](crate::model::DataLakePrincipal)
pub mod data_lake_principal {
    /// A builder for [`DataLakePrincipal`](crate::model::DataLakePrincipal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_lake_principal_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for the Lake Formation principal.</p>
        pub fn data_lake_principal_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.data_lake_principal_identifier = Some(input.into());
            self
        }
        /// <p>An identifier for the Lake Formation principal.</p>
        pub fn set_data_lake_principal_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_lake_principal_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DataLakePrincipal`](crate::model::DataLakePrincipal)
        pub fn build(self) -> crate::model::DataLakePrincipal {
            crate::model::DataLakePrincipal {
                data_lake_principal_identifier: self.data_lake_principal_identifier,
            }
        }
    }
}
impl DataLakePrincipal {
    /// Creates a new builder-style object to manufacture [`DataLakePrincipal`](crate::model::DataLakePrincipal)
    pub fn builder() -> crate::model::data_lake_principal::Builder {
        crate::model::data_lake_principal::Builder::default()
    }
}

/// <p>Specifies data lineage configuration settings for the crawler.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LineageConfiguration {
    /// <p>Specifies whether data lineage is enabled for the crawler. Valid values are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>ENABLE: enables data lineage for the crawler</p>
    /// </li>
    /// <li>
    /// <p>DISABLE: disables data lineage for the crawler</p>
    /// </li>
    /// </ul>
    pub crawler_lineage_settings: std::option::Option<crate::model::CrawlerLineageSettings>,
}
impl std::fmt::Debug for LineageConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LineageConfiguration");
        formatter.field("crawler_lineage_settings", &self.crawler_lineage_settings);
        formatter.finish()
    }
}
/// See [`LineageConfiguration`](crate::model::LineageConfiguration)
pub mod lineage_configuration {
    /// A builder for [`LineageConfiguration`](crate::model::LineageConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawler_lineage_settings:
            std::option::Option<crate::model::CrawlerLineageSettings>,
    }
    impl Builder {
        /// <p>Specifies whether data lineage is enabled for the crawler. Valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>ENABLE: enables data lineage for the crawler</p>
        /// </li>
        /// <li>
        /// <p>DISABLE: disables data lineage for the crawler</p>
        /// </li>
        /// </ul>
        pub fn crawler_lineage_settings(
            mut self,
            input: crate::model::CrawlerLineageSettings,
        ) -> Self {
            self.crawler_lineage_settings = Some(input);
            self
        }
        /// <p>Specifies whether data lineage is enabled for the crawler. Valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>ENABLE: enables data lineage for the crawler</p>
        /// </li>
        /// <li>
        /// <p>DISABLE: disables data lineage for the crawler</p>
        /// </li>
        /// </ul>
        pub fn set_crawler_lineage_settings(
            mut self,
            input: std::option::Option<crate::model::CrawlerLineageSettings>,
        ) -> Self {
            self.crawler_lineage_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`LineageConfiguration`](crate::model::LineageConfiguration)
        pub fn build(self) -> crate::model::LineageConfiguration {
            crate::model::LineageConfiguration {
                crawler_lineage_settings: self.crawler_lineage_settings,
            }
        }
    }
}
impl LineageConfiguration {
    /// Creates a new builder-style object to manufacture [`LineageConfiguration`](crate::model::LineageConfiguration)
    pub fn builder() -> crate::model::lineage_configuration::Builder {
        crate::model::lineage_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CrawlerLineageSettings {
    #[allow(missing_docs)] // documentation missing in model
    Disable,
    #[allow(missing_docs)] // documentation missing in model
    Enable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CrawlerLineageSettings {
    fn from(s: &str) -> Self {
        match s {
            "DISABLE" => CrawlerLineageSettings::Disable,
            "ENABLE" => CrawlerLineageSettings::Enable,
            other => CrawlerLineageSettings::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CrawlerLineageSettings {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CrawlerLineageSettings::from(s))
    }
}
impl CrawlerLineageSettings {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CrawlerLineageSettings::Disable => "DISABLE",
            CrawlerLineageSettings::Enable => "ENABLE",
            CrawlerLineageSettings::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLE", "ENABLE"]
    }
}
impl AsRef<str> for CrawlerLineageSettings {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>When crawling an Amazon S3 data source after the first crawl is complete, specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/incremental-crawls.html">Incremental Crawls in Glue</a> in the developer guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecrawlPolicy {
    /// <p>Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run.</p>
    ///
    /// <p>A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.</p>
    ///
    /// <p>A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last crawler run.</p>
    ///
    /// <p>A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.</p>
    pub recrawl_behavior: std::option::Option<crate::model::RecrawlBehavior>,
}
impl std::fmt::Debug for RecrawlPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecrawlPolicy");
        formatter.field("recrawl_behavior", &self.recrawl_behavior);
        formatter.finish()
    }
}
/// See [`RecrawlPolicy`](crate::model::RecrawlPolicy)
pub mod recrawl_policy {
    /// A builder for [`RecrawlPolicy`](crate::model::RecrawlPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recrawl_behavior: std::option::Option<crate::model::RecrawlBehavior>,
    }
    impl Builder {
        /// <p>Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run.</p>
        ///
        /// <p>A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.</p>
        ///
        /// <p>A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last crawler run.</p>
        ///
        /// <p>A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.</p>
        pub fn recrawl_behavior(mut self, input: crate::model::RecrawlBehavior) -> Self {
            self.recrawl_behavior = Some(input);
            self
        }
        /// <p>Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run.</p>
        ///
        /// <p>A value of <code>CRAWL_EVERYTHING</code> specifies crawling the entire dataset again.</p>
        ///
        /// <p>A value of <code>CRAWL_NEW_FOLDERS_ONLY</code> specifies crawling only folders that were added since the last crawler run.</p>
        ///
        /// <p>A value of <code>CRAWL_EVENT_MODE</code> specifies crawling only the changes identified by Amazon S3 events.</p>
        pub fn set_recrawl_behavior(
            mut self,
            input: std::option::Option<crate::model::RecrawlBehavior>,
        ) -> Self {
            self.recrawl_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`RecrawlPolicy`](crate::model::RecrawlPolicy)
        pub fn build(self) -> crate::model::RecrawlPolicy {
            crate::model::RecrawlPolicy {
                recrawl_behavior: self.recrawl_behavior,
            }
        }
    }
}
impl RecrawlPolicy {
    /// Creates a new builder-style object to manufacture [`RecrawlPolicy`](crate::model::RecrawlPolicy)
    pub fn builder() -> crate::model::recrawl_policy::Builder {
        crate::model::recrawl_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecrawlBehavior {
    #[allow(missing_docs)] // documentation missing in model
    CrawlEventMode,
    #[allow(missing_docs)] // documentation missing in model
    CrawlEverything,
    #[allow(missing_docs)] // documentation missing in model
    CrawlNewFoldersOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecrawlBehavior {
    fn from(s: &str) -> Self {
        match s {
            "CRAWL_EVENT_MODE" => RecrawlBehavior::CrawlEventMode,
            "CRAWL_EVERYTHING" => RecrawlBehavior::CrawlEverything,
            "CRAWL_NEW_FOLDERS_ONLY" => RecrawlBehavior::CrawlNewFoldersOnly,
            other => RecrawlBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecrawlBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecrawlBehavior::from(s))
    }
}
impl RecrawlBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecrawlBehavior::CrawlEventMode => "CRAWL_EVENT_MODE",
            RecrawlBehavior::CrawlEverything => "CRAWL_EVERYTHING",
            RecrawlBehavior::CrawlNewFoldersOnly => "CRAWL_NEW_FOLDERS_ONLY",
            RecrawlBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CRAWL_EVENT_MODE",
            "CRAWL_EVERYTHING",
            "CRAWL_NEW_FOLDERS_ONLY",
        ]
    }
}
impl AsRef<str> for RecrawlBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A policy that specifies update and deletion behaviors for the crawler.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaChangePolicy {
    /// <p>The update behavior when the crawler finds a changed schema.</p>
    pub update_behavior: std::option::Option<crate::model::UpdateBehavior>,
    /// <p>The deletion behavior when the crawler finds a deleted object.</p>
    pub delete_behavior: std::option::Option<crate::model::DeleteBehavior>,
}
impl std::fmt::Debug for SchemaChangePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaChangePolicy");
        formatter.field("update_behavior", &self.update_behavior);
        formatter.field("delete_behavior", &self.delete_behavior);
        formatter.finish()
    }
}
/// See [`SchemaChangePolicy`](crate::model::SchemaChangePolicy)
pub mod schema_change_policy {
    /// A builder for [`SchemaChangePolicy`](crate::model::SchemaChangePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) update_behavior: std::option::Option<crate::model::UpdateBehavior>,
        pub(crate) delete_behavior: std::option::Option<crate::model::DeleteBehavior>,
    }
    impl Builder {
        /// <p>The update behavior when the crawler finds a changed schema.</p>
        pub fn update_behavior(mut self, input: crate::model::UpdateBehavior) -> Self {
            self.update_behavior = Some(input);
            self
        }
        /// <p>The update behavior when the crawler finds a changed schema.</p>
        pub fn set_update_behavior(
            mut self,
            input: std::option::Option<crate::model::UpdateBehavior>,
        ) -> Self {
            self.update_behavior = input;
            self
        }
        /// <p>The deletion behavior when the crawler finds a deleted object.</p>
        pub fn delete_behavior(mut self, input: crate::model::DeleteBehavior) -> Self {
            self.delete_behavior = Some(input);
            self
        }
        /// <p>The deletion behavior when the crawler finds a deleted object.</p>
        pub fn set_delete_behavior(
            mut self,
            input: std::option::Option<crate::model::DeleteBehavior>,
        ) -> Self {
            self.delete_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaChangePolicy`](crate::model::SchemaChangePolicy)
        pub fn build(self) -> crate::model::SchemaChangePolicy {
            crate::model::SchemaChangePolicy {
                update_behavior: self.update_behavior,
                delete_behavior: self.delete_behavior,
            }
        }
    }
}
impl SchemaChangePolicy {
    /// Creates a new builder-style object to manufacture [`SchemaChangePolicy`](crate::model::SchemaChangePolicy)
    pub fn builder() -> crate::model::schema_change_policy::Builder {
        crate::model::schema_change_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeleteBehavior {
    #[allow(missing_docs)] // documentation missing in model
    DeleteFromDatabase,
    #[allow(missing_docs)] // documentation missing in model
    DeprecateInDatabase,
    #[allow(missing_docs)] // documentation missing in model
    Log,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeleteBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DELETE_FROM_DATABASE" => DeleteBehavior::DeleteFromDatabase,
            "DEPRECATE_IN_DATABASE" => DeleteBehavior::DeprecateInDatabase,
            "LOG" => DeleteBehavior::Log,
            other => DeleteBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeleteBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeleteBehavior::from(s))
    }
}
impl DeleteBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeleteBehavior::DeleteFromDatabase => "DELETE_FROM_DATABASE",
            DeleteBehavior::DeprecateInDatabase => "DEPRECATE_IN_DATABASE",
            DeleteBehavior::Log => "LOG",
            DeleteBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE_FROM_DATABASE", "DEPRECATE_IN_DATABASE", "LOG"]
    }
}
impl AsRef<str> for DeleteBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Log,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInDatabase,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateBehavior {
    fn from(s: &str) -> Self {
        match s {
            "LOG" => UpdateBehavior::Log,
            "UPDATE_IN_DATABASE" => UpdateBehavior::UpdateInDatabase,
            other => UpdateBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateBehavior::from(s))
    }
}
impl UpdateBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateBehavior::Log => "LOG",
            UpdateBehavior::UpdateInDatabase => "UPDATE_IN_DATABASE",
            UpdateBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LOG", "UPDATE_IN_DATABASE"]
    }
}
impl AsRef<str> for UpdateBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies data stores to crawl.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrawlerTargets {
    /// <p>Specifies Amazon Simple Storage Service (Amazon S3) targets.</p>
    pub s3_targets: std::option::Option<std::vec::Vec<crate::model::S3Target>>,
    /// <p>Specifies JDBC targets.</p>
    pub jdbc_targets: std::option::Option<std::vec::Vec<crate::model::JdbcTarget>>,
    /// <p>Specifies Amazon DocumentDB or MongoDB targets.</p>
    pub mongo_db_targets: std::option::Option<std::vec::Vec<crate::model::MongoDbTarget>>,
    /// <p>Specifies Amazon DynamoDB targets.</p>
    pub dynamo_db_targets: std::option::Option<std::vec::Vec<crate::model::DynamoDbTarget>>,
    /// <p>Specifies Glue Data Catalog targets.</p>
    pub catalog_targets: std::option::Option<std::vec::Vec<crate::model::CatalogTarget>>,
}
impl std::fmt::Debug for CrawlerTargets {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrawlerTargets");
        formatter.field("s3_targets", &self.s3_targets);
        formatter.field("jdbc_targets", &self.jdbc_targets);
        formatter.field("mongo_db_targets", &self.mongo_db_targets);
        formatter.field("dynamo_db_targets", &self.dynamo_db_targets);
        formatter.field("catalog_targets", &self.catalog_targets);
        formatter.finish()
    }
}
/// See [`CrawlerTargets`](crate::model::CrawlerTargets)
pub mod crawler_targets {
    /// A builder for [`CrawlerTargets`](crate::model::CrawlerTargets)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_targets: std::option::Option<std::vec::Vec<crate::model::S3Target>>,
        pub(crate) jdbc_targets: std::option::Option<std::vec::Vec<crate::model::JdbcTarget>>,
        pub(crate) mongo_db_targets:
            std::option::Option<std::vec::Vec<crate::model::MongoDbTarget>>,
        pub(crate) dynamo_db_targets:
            std::option::Option<std::vec::Vec<crate::model::DynamoDbTarget>>,
        pub(crate) catalog_targets: std::option::Option<std::vec::Vec<crate::model::CatalogTarget>>,
    }
    impl Builder {
        /// Appends an item to `s3_targets`.
        ///
        /// To override the contents of this collection use [`set_s3_targets`](Self::set_s3_targets).
        ///
        /// <p>Specifies Amazon Simple Storage Service (Amazon S3) targets.</p>
        pub fn s3_targets(mut self, input: impl Into<crate::model::S3Target>) -> Self {
            let mut v = self.s3_targets.unwrap_or_default();
            v.push(input.into());
            self.s3_targets = Some(v);
            self
        }
        /// <p>Specifies Amazon Simple Storage Service (Amazon S3) targets.</p>
        pub fn set_s3_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Target>>,
        ) -> Self {
            self.s3_targets = input;
            self
        }
        /// Appends an item to `jdbc_targets`.
        ///
        /// To override the contents of this collection use [`set_jdbc_targets`](Self::set_jdbc_targets).
        ///
        /// <p>Specifies JDBC targets.</p>
        pub fn jdbc_targets(mut self, input: impl Into<crate::model::JdbcTarget>) -> Self {
            let mut v = self.jdbc_targets.unwrap_or_default();
            v.push(input.into());
            self.jdbc_targets = Some(v);
            self
        }
        /// <p>Specifies JDBC targets.</p>
        pub fn set_jdbc_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JdbcTarget>>,
        ) -> Self {
            self.jdbc_targets = input;
            self
        }
        /// Appends an item to `mongo_db_targets`.
        ///
        /// To override the contents of this collection use [`set_mongo_db_targets`](Self::set_mongo_db_targets).
        ///
        /// <p>Specifies Amazon DocumentDB or MongoDB targets.</p>
        pub fn mongo_db_targets(mut self, input: impl Into<crate::model::MongoDbTarget>) -> Self {
            let mut v = self.mongo_db_targets.unwrap_or_default();
            v.push(input.into());
            self.mongo_db_targets = Some(v);
            self
        }
        /// <p>Specifies Amazon DocumentDB or MongoDB targets.</p>
        pub fn set_mongo_db_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MongoDbTarget>>,
        ) -> Self {
            self.mongo_db_targets = input;
            self
        }
        /// Appends an item to `dynamo_db_targets`.
        ///
        /// To override the contents of this collection use [`set_dynamo_db_targets`](Self::set_dynamo_db_targets).
        ///
        /// <p>Specifies Amazon DynamoDB targets.</p>
        pub fn dynamo_db_targets(mut self, input: impl Into<crate::model::DynamoDbTarget>) -> Self {
            let mut v = self.dynamo_db_targets.unwrap_or_default();
            v.push(input.into());
            self.dynamo_db_targets = Some(v);
            self
        }
        /// <p>Specifies Amazon DynamoDB targets.</p>
        pub fn set_dynamo_db_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DynamoDbTarget>>,
        ) -> Self {
            self.dynamo_db_targets = input;
            self
        }
        /// Appends an item to `catalog_targets`.
        ///
        /// To override the contents of this collection use [`set_catalog_targets`](Self::set_catalog_targets).
        ///
        /// <p>Specifies Glue Data Catalog targets.</p>
        pub fn catalog_targets(mut self, input: impl Into<crate::model::CatalogTarget>) -> Self {
            let mut v = self.catalog_targets.unwrap_or_default();
            v.push(input.into());
            self.catalog_targets = Some(v);
            self
        }
        /// <p>Specifies Glue Data Catalog targets.</p>
        pub fn set_catalog_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CatalogTarget>>,
        ) -> Self {
            self.catalog_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`CrawlerTargets`](crate::model::CrawlerTargets)
        pub fn build(self) -> crate::model::CrawlerTargets {
            crate::model::CrawlerTargets {
                s3_targets: self.s3_targets,
                jdbc_targets: self.jdbc_targets,
                mongo_db_targets: self.mongo_db_targets,
                dynamo_db_targets: self.dynamo_db_targets,
                catalog_targets: self.catalog_targets,
            }
        }
    }
}
impl CrawlerTargets {
    /// Creates a new builder-style object to manufacture [`CrawlerTargets`](crate::model::CrawlerTargets)
    pub fn builder() -> crate::model::crawler_targets::Builder {
        crate::model::crawler_targets::Builder::default()
    }
}

/// <p>Specifies an Glue Data Catalog target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CatalogTarget {
    /// <p>The name of the database to be synchronized.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>A list of the tables to be synchronized.</p>
    pub tables: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for CatalogTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CatalogTarget");
        formatter.field("database_name", &self.database_name);
        formatter.field("tables", &self.tables);
        formatter.finish()
    }
}
/// See [`CatalogTarget`](crate::model::CatalogTarget)
pub mod catalog_target {
    /// A builder for [`CatalogTarget`](crate::model::CatalogTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) tables: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the database to be synchronized.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database to be synchronized.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// Appends an item to `tables`.
        ///
        /// To override the contents of this collection use [`set_tables`](Self::set_tables).
        ///
        /// <p>A list of the tables to be synchronized.</p>
        pub fn tables(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tables.unwrap_or_default();
            v.push(input.into());
            self.tables = Some(v);
            self
        }
        /// <p>A list of the tables to be synchronized.</p>
        pub fn set_tables(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tables = input;
            self
        }
        /// Consumes the builder and constructs a [`CatalogTarget`](crate::model::CatalogTarget)
        pub fn build(self) -> crate::model::CatalogTarget {
            crate::model::CatalogTarget {
                database_name: self.database_name,
                tables: self.tables,
            }
        }
    }
}
impl CatalogTarget {
    /// Creates a new builder-style object to manufacture [`CatalogTarget`](crate::model::CatalogTarget)
    pub fn builder() -> crate::model::catalog_target::Builder {
        crate::model::catalog_target::Builder::default()
    }
}

/// <p>Specifies an Amazon DynamoDB table to crawl.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynamoDbTarget {
    /// <p>The name of the DynamoDB table to crawl.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.</p>
    ///
    /// <p>A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample the records. If no value is specified, the value defaults to <code>true</code>.</p>
    pub scan_all: std::option::Option<bool>,
    /// <p>The percentage of the configured read capacity units to use by the Glue crawler. Read capacity units is a term defined by DynamoDB, and is a numeric value that acts as rate limiter for the number of reads that can be performed on that table per second.</p>
    ///
    /// <p>The valid values are null or a value between 0.1 to 1.5. A null value is used when user does not provide a value, and defaults to 0.5 of the configured Read Capacity Unit (for provisioned tables), or 0.25 of the max configured Read Capacity Unit (for tables using on-demand mode).</p>
    pub scan_rate: std::option::Option<f64>,
}
impl std::fmt::Debug for DynamoDbTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynamoDbTarget");
        formatter.field("path", &self.path);
        formatter.field("scan_all", &self.scan_all);
        formatter.field("scan_rate", &self.scan_rate);
        formatter.finish()
    }
}
/// See [`DynamoDbTarget`](crate::model::DynamoDbTarget)
pub mod dynamo_db_target {
    /// A builder for [`DynamoDbTarget`](crate::model::DynamoDbTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) scan_all: std::option::Option<bool>,
        pub(crate) scan_rate: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the DynamoDB table to crawl.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The name of the DynamoDB table to crawl.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.</p>
        ///
        /// <p>A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample the records. If no value is specified, the value defaults to <code>true</code>.</p>
        pub fn scan_all(mut self, input: bool) -> Self {
            self.scan_all = Some(input);
            self
        }
        /// <p>Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.</p>
        ///
        /// <p>A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample the records. If no value is specified, the value defaults to <code>true</code>.</p>
        pub fn set_scan_all(mut self, input: std::option::Option<bool>) -> Self {
            self.scan_all = input;
            self
        }
        /// <p>The percentage of the configured read capacity units to use by the Glue crawler. Read capacity units is a term defined by DynamoDB, and is a numeric value that acts as rate limiter for the number of reads that can be performed on that table per second.</p>
        ///
        /// <p>The valid values are null or a value between 0.1 to 1.5. A null value is used when user does not provide a value, and defaults to 0.5 of the configured Read Capacity Unit (for provisioned tables), or 0.25 of the max configured Read Capacity Unit (for tables using on-demand mode).</p>
        pub fn scan_rate(mut self, input: f64) -> Self {
            self.scan_rate = Some(input);
            self
        }
        /// <p>The percentage of the configured read capacity units to use by the Glue crawler. Read capacity units is a term defined by DynamoDB, and is a numeric value that acts as rate limiter for the number of reads that can be performed on that table per second.</p>
        ///
        /// <p>The valid values are null or a value between 0.1 to 1.5. A null value is used when user does not provide a value, and defaults to 0.5 of the configured Read Capacity Unit (for provisioned tables), or 0.25 of the max configured Read Capacity Unit (for tables using on-demand mode).</p>
        pub fn set_scan_rate(mut self, input: std::option::Option<f64>) -> Self {
            self.scan_rate = input;
            self
        }
        /// Consumes the builder and constructs a [`DynamoDbTarget`](crate::model::DynamoDbTarget)
        pub fn build(self) -> crate::model::DynamoDbTarget {
            crate::model::DynamoDbTarget {
                path: self.path,
                scan_all: self.scan_all,
                scan_rate: self.scan_rate,
            }
        }
    }
}
impl DynamoDbTarget {
    /// Creates a new builder-style object to manufacture [`DynamoDbTarget`](crate::model::DynamoDbTarget)
    pub fn builder() -> crate::model::dynamo_db_target::Builder {
        crate::model::dynamo_db_target::Builder::default()
    }
}

/// <p>Specifies an Amazon DocumentDB or MongoDB data store to crawl.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MongoDbTarget {
    /// <p>The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The path of the Amazon DocumentDB or MongoDB target (database/collection).</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.</p>
    ///
    /// <p>A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample the records. If no value is specified, the value defaults to <code>true</code>.</p>
    pub scan_all: std::option::Option<bool>,
}
impl std::fmt::Debug for MongoDbTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MongoDbTarget");
        formatter.field("connection_name", &self.connection_name);
        formatter.field("path", &self.path);
        formatter.field("scan_all", &self.scan_all);
        formatter.finish()
    }
}
/// See [`MongoDbTarget`](crate::model::MongoDbTarget)
pub mod mongo_db_target {
    /// A builder for [`MongoDbTarget`](crate::model::MongoDbTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) scan_all: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The path of the Amazon DocumentDB or MongoDB target (database/collection).</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path of the Amazon DocumentDB or MongoDB target (database/collection).</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.</p>
        ///
        /// <p>A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample the records. If no value is specified, the value defaults to <code>true</code>.</p>
        pub fn scan_all(mut self, input: bool) -> Self {
            self.scan_all = Some(input);
            self
        }
        /// <p>Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.</p>
        ///
        /// <p>A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample the records. If no value is specified, the value defaults to <code>true</code>.</p>
        pub fn set_scan_all(mut self, input: std::option::Option<bool>) -> Self {
            self.scan_all = input;
            self
        }
        /// Consumes the builder and constructs a [`MongoDbTarget`](crate::model::MongoDbTarget)
        pub fn build(self) -> crate::model::MongoDbTarget {
            crate::model::MongoDbTarget {
                connection_name: self.connection_name,
                path: self.path,
                scan_all: self.scan_all,
            }
        }
    }
}
impl MongoDbTarget {
    /// Creates a new builder-style object to manufacture [`MongoDbTarget`](crate::model::MongoDbTarget)
    pub fn builder() -> crate::model::mongo_db_target::Builder {
        crate::model::mongo_db_target::Builder::default()
    }
}

/// <p>Specifies a JDBC data store to crawl.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JdbcTarget {
    /// <p>The name of the connection to use to connect to the JDBC target.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The path of the JDBC target.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>A list of glob patterns used to exclude from the crawl.
    /// For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.</p>
    pub exclusions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for JdbcTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JdbcTarget");
        formatter.field("connection_name", &self.connection_name);
        formatter.field("path", &self.path);
        formatter.field("exclusions", &self.exclusions);
        formatter.finish()
    }
}
/// See [`JdbcTarget`](crate::model::JdbcTarget)
pub mod jdbc_target {
    /// A builder for [`JdbcTarget`](crate::model::JdbcTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) exclusions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the connection to use to connect to the JDBC target.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection to use to connect to the JDBC target.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The path of the JDBC target.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path of the JDBC target.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `exclusions`.
        ///
        /// To override the contents of this collection use [`set_exclusions`](Self::set_exclusions).
        ///
        /// <p>A list of glob patterns used to exclude from the crawl.
        /// For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.</p>
        pub fn exclusions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclusions.unwrap_or_default();
            v.push(input.into());
            self.exclusions = Some(v);
            self
        }
        /// <p>A list of glob patterns used to exclude from the crawl.
        /// For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.</p>
        pub fn set_exclusions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclusions = input;
            self
        }
        /// Consumes the builder and constructs a [`JdbcTarget`](crate::model::JdbcTarget)
        pub fn build(self) -> crate::model::JdbcTarget {
            crate::model::JdbcTarget {
                connection_name: self.connection_name,
                path: self.path,
                exclusions: self.exclusions,
            }
        }
    }
}
impl JdbcTarget {
    /// Creates a new builder-style object to manufacture [`JdbcTarget`](crate::model::JdbcTarget)
    pub fn builder() -> crate::model::jdbc_target::Builder {
        crate::model::jdbc_target::Builder::default()
    }
}

/// <p>Specifies a data store in Amazon Simple Storage Service (Amazon S3).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Target {
    /// <p>The path to the Amazon S3 target.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>A list of glob patterns used to exclude from the crawl.
    /// For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.</p>
    pub exclusions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.</p>
    pub sample_size: std::option::Option<i32>,
    /// <p>A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.</p>
    pub event_queue_arn: std::option::Option<std::string::String>,
    /// <p>A valid Amazon dead-letter SQS ARN. For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code>.</p>
    pub dlq_event_queue_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3Target {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Target");
        formatter.field("path", &self.path);
        formatter.field("exclusions", &self.exclusions);
        formatter.field("connection_name", &self.connection_name);
        formatter.field("sample_size", &self.sample_size);
        formatter.field("event_queue_arn", &self.event_queue_arn);
        formatter.field("dlq_event_queue_arn", &self.dlq_event_queue_arn);
        formatter.finish()
    }
}
/// See [`S3Target`](crate::model::S3Target)
pub mod s3_target {
    /// A builder for [`S3Target`](crate::model::S3Target)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) exclusions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) sample_size: std::option::Option<i32>,
        pub(crate) event_queue_arn: std::option::Option<std::string::String>,
        pub(crate) dlq_event_queue_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path to the Amazon S3 target.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the Amazon S3 target.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `exclusions`.
        ///
        /// To override the contents of this collection use [`set_exclusions`](Self::set_exclusions).
        ///
        /// <p>A list of glob patterns used to exclude from the crawl.
        /// For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.</p>
        pub fn exclusions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclusions.unwrap_or_default();
            v.push(input.into());
            self.exclusions = Some(v);
            self
        }
        /// <p>A list of glob patterns used to exclude from the crawl.
        /// For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.</p>
        pub fn set_exclusions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclusions = input;
            self
        }
        /// <p>The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.</p>
        pub fn sample_size(mut self, input: i32) -> Self {
            self.sample_size = Some(input);
            self
        }
        /// <p>Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.</p>
        pub fn set_sample_size(mut self, input: std::option::Option<i32>) -> Self {
            self.sample_size = input;
            self
        }
        /// <p>A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.</p>
        pub fn event_queue_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_queue_arn = Some(input.into());
            self
        }
        /// <p>A valid Amazon SQS ARN. For example, <code>arn:aws:sqs:region:account:sqs</code>.</p>
        pub fn set_event_queue_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_queue_arn = input;
            self
        }
        /// <p>A valid Amazon dead-letter SQS ARN. For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code>.</p>
        pub fn dlq_event_queue_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dlq_event_queue_arn = Some(input.into());
            self
        }
        /// <p>A valid Amazon dead-letter SQS ARN. For example, <code>arn:aws:sqs:region:account:deadLetterQueue</code>.</p>
        pub fn set_dlq_event_queue_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dlq_event_queue_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Target`](crate::model::S3Target)
        pub fn build(self) -> crate::model::S3Target {
            crate::model::S3Target {
                path: self.path,
                exclusions: self.exclusions,
                connection_name: self.connection_name,
                sample_size: self.sample_size,
                event_queue_arn: self.event_queue_arn,
                dlq_event_queue_arn: self.dlq_event_queue_arn,
            }
        }
    }
}
impl S3Target {
    /// Creates a new builder-style object to manufacture [`S3Target`](crate::model::S3Target)
    pub fn builder() -> crate::model::s3_target::Builder {
        crate::model::s3_target::Builder::default()
    }
}

/// <p>A structure that is used to specify a connection to create or update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionInput {
    /// <p>The name of the connection.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the connection.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the connection. Currently, these types are supported:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MONGODB</code> - Designates a connection to a MongoDB document database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web Services Marketplace to read from and write to data stores that are not natively supported by Glue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to data stores that are not natively supported by Glue.</p>
    /// </li>
    /// </ul>
    /// <p>SFTP is not supported.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>A list of criteria that can be used in selecting this connection.</p>
    pub match_criteria: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>These key-value pairs define parameters for the connection.</p>
    pub connection_properties: std::option::Option<
        std::collections::HashMap<crate::model::ConnectionPropertyKey, std::string::String>,
    >,
    /// <p>A map of physical connection requirements, such as virtual private cloud (VPC) and
    /// <code>SecurityGroup</code>, that are needed to successfully make this connection.</p>
    pub physical_connection_requirements:
        std::option::Option<crate::model::PhysicalConnectionRequirements>,
}
impl std::fmt::Debug for ConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("match_criteria", &self.match_criteria);
        formatter.field("connection_properties", &self.connection_properties);
        formatter.field(
            "physical_connection_requirements",
            &self.physical_connection_requirements,
        );
        formatter.finish()
    }
}
/// See [`ConnectionInput`](crate::model::ConnectionInput)
pub mod connection_input {
    /// A builder for [`ConnectionInput`](crate::model::ConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) match_criteria: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) connection_properties: std::option::Option<
            std::collections::HashMap<crate::model::ConnectionPropertyKey, std::string::String>,
        >,
        pub(crate) physical_connection_requirements:
            std::option::Option<crate::model::PhysicalConnectionRequirements>,
    }
    impl Builder {
        /// <p>The name of the connection.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the connection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the connection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the connection. Currently, these types are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MONGODB</code> - Designates a connection to a MongoDB document database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web Services Marketplace to read from and write to data stores that are not natively supported by Glue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to data stores that are not natively supported by Glue.</p>
        /// </li>
        /// </ul>
        /// <p>SFTP is not supported.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the connection. Currently, these types are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MONGODB</code> - Designates a connection to a MongoDB document database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MARKETPLACE</code> - Uses configuration settings contained in a connector purchased from Amazon Web Services Marketplace to read from and write to data stores that are not natively supported by Glue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM</code> - Uses configuration settings contained in a custom connector to read from and write to data stores that are not natively supported by Glue.</p>
        /// </li>
        /// </ul>
        /// <p>SFTP is not supported.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// Appends an item to `match_criteria`.
        ///
        /// To override the contents of this collection use [`set_match_criteria`](Self::set_match_criteria).
        ///
        /// <p>A list of criteria that can be used in selecting this connection.</p>
        pub fn match_criteria(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.match_criteria.unwrap_or_default();
            v.push(input.into());
            self.match_criteria = Some(v);
            self
        }
        /// <p>A list of criteria that can be used in selecting this connection.</p>
        pub fn set_match_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.match_criteria = input;
            self
        }
        /// Adds a key-value pair to `connection_properties`.
        ///
        /// To override the contents of this collection use [`set_connection_properties`](Self::set_connection_properties).
        ///
        /// <p>These key-value pairs define parameters for the connection.</p>
        pub fn connection_properties(
            mut self,
            k: impl Into<crate::model::ConnectionPropertyKey>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.connection_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.connection_properties = Some(hash_map);
            self
        }
        /// <p>These key-value pairs define parameters for the connection.</p>
        pub fn set_connection_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::ConnectionPropertyKey, std::string::String>,
            >,
        ) -> Self {
            self.connection_properties = input;
            self
        }
        /// <p>A map of physical connection requirements, such as virtual private cloud (VPC) and
        /// <code>SecurityGroup</code>, that are needed to successfully make this connection.</p>
        pub fn physical_connection_requirements(
            mut self,
            input: crate::model::PhysicalConnectionRequirements,
        ) -> Self {
            self.physical_connection_requirements = Some(input);
            self
        }
        /// <p>A map of physical connection requirements, such as virtual private cloud (VPC) and
        /// <code>SecurityGroup</code>, that are needed to successfully make this connection.</p>
        pub fn set_physical_connection_requirements(
            mut self,
            input: std::option::Option<crate::model::PhysicalConnectionRequirements>,
        ) -> Self {
            self.physical_connection_requirements = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionInput`](crate::model::ConnectionInput)
        pub fn build(self) -> crate::model::ConnectionInput {
            crate::model::ConnectionInput {
                name: self.name,
                description: self.description,
                connection_type: self.connection_type,
                match_criteria: self.match_criteria,
                connection_properties: self.connection_properties,
                physical_connection_requirements: self.physical_connection_requirements,
            }
        }
    }
}
impl ConnectionInput {
    /// Creates a new builder-style object to manufacture [`ConnectionInput`](crate::model::ConnectionInput)
    pub fn builder() -> crate::model::connection_input::Builder {
        crate::model::connection_input::Builder::default()
    }
}

/// <p>Specifies the physical requirements for a connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhysicalConnectionRequirements {
    /// <p>The subnet ID used by the connection.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The security group ID list used by the connection.</p>
    pub security_group_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The connection's Availability Zone. This field is redundant because the specified subnet
    /// implies the Availability Zone to be used. Currently the field must be populated, but it will
    /// be deprecated in the future.</p>
    pub availability_zone: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PhysicalConnectionRequirements {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhysicalConnectionRequirements");
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("security_group_id_list", &self.security_group_id_list);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.finish()
    }
}
/// See [`PhysicalConnectionRequirements`](crate::model::PhysicalConnectionRequirements)
pub mod physical_connection_requirements {
    /// A builder for [`PhysicalConnectionRequirements`](crate::model::PhysicalConnectionRequirements)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) security_group_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The subnet ID used by the connection.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID used by the connection.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// Appends an item to `security_group_id_list`.
        ///
        /// To override the contents of this collection use [`set_security_group_id_list`](Self::set_security_group_id_list).
        ///
        /// <p>The security group ID list used by the connection.</p>
        pub fn security_group_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_id_list.unwrap_or_default();
            v.push(input.into());
            self.security_group_id_list = Some(v);
            self
        }
        /// <p>The security group ID list used by the connection.</p>
        pub fn set_security_group_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_id_list = input;
            self
        }
        /// <p>The connection's Availability Zone. This field is redundant because the specified subnet
        /// implies the Availability Zone to be used. Currently the field must be populated, but it will
        /// be deprecated in the future.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The connection's Availability Zone. This field is redundant because the specified subnet
        /// implies the Availability Zone to be used. Currently the field must be populated, but it will
        /// be deprecated in the future.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`PhysicalConnectionRequirements`](crate::model::PhysicalConnectionRequirements)
        pub fn build(self) -> crate::model::PhysicalConnectionRequirements {
            crate::model::PhysicalConnectionRequirements {
                subnet_id: self.subnet_id,
                security_group_id_list: self.security_group_id_list,
                availability_zone: self.availability_zone,
            }
        }
    }
}
impl PhysicalConnectionRequirements {
    /// Creates a new builder-style object to manufacture [`PhysicalConnectionRequirements`](crate::model::PhysicalConnectionRequirements)
    pub fn builder() -> crate::model::physical_connection_requirements::Builder {
        crate::model::physical_connection_requirements::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionPropertyKey {
    #[allow(missing_docs)] // documentation missing in model
    ConfigFiles,
    #[allow(missing_docs)] // documentation missing in model
    ConnectionUrl,
    #[allow(missing_docs)] // documentation missing in model
    ConnectorClassName,
    #[allow(missing_docs)] // documentation missing in model
    ConnectorType,
    #[allow(missing_docs)] // documentation missing in model
    ConnectorUrl,
    #[allow(missing_docs)] // documentation missing in model
    CustomJdbcCert,
    #[allow(missing_docs)] // documentation missing in model
    CustomJdbcCertString,
    #[allow(missing_docs)] // documentation missing in model
    EncryptedKafkaClientKeystorePassword,
    #[allow(missing_docs)] // documentation missing in model
    EncryptedKafkaClientKeyPassword,
    #[allow(missing_docs)] // documentation missing in model
    EncryptedPassword,
    #[allow(missing_docs)] // documentation missing in model
    Host,
    #[allow(missing_docs)] // documentation missing in model
    InstanceId,
    #[allow(missing_docs)] // documentation missing in model
    JdbcConnectionUrl,
    #[allow(missing_docs)] // documentation missing in model
    JdbcDriverClassName,
    #[allow(missing_docs)] // documentation missing in model
    JdbcDriverJarUri,
    #[allow(missing_docs)] // documentation missing in model
    JdbcEnforceSsl,
    #[allow(missing_docs)] // documentation missing in model
    JdbcEngine,
    #[allow(missing_docs)] // documentation missing in model
    JdbcEngineVersion,
    #[allow(missing_docs)] // documentation missing in model
    KafkaBootstrapServers,
    #[allow(missing_docs)] // documentation missing in model
    KafkaClientKeystore,
    #[allow(missing_docs)] // documentation missing in model
    KafkaClientKeystorePassword,
    #[allow(missing_docs)] // documentation missing in model
    KafkaClientKeyPassword,
    #[allow(missing_docs)] // documentation missing in model
    KafkaCustomCert,
    #[allow(missing_docs)] // documentation missing in model
    KafkaSkipCustomCertValidation,
    #[allow(missing_docs)] // documentation missing in model
    KafkaSslEnabled,
    #[allow(missing_docs)] // documentation missing in model
    Password,
    #[allow(missing_docs)] // documentation missing in model
    Port,
    #[allow(missing_docs)] // documentation missing in model
    SecretId,
    #[allow(missing_docs)] // documentation missing in model
    SkipCustomJdbcCertValidation,
    #[allow(missing_docs)] // documentation missing in model
    UserName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionPropertyKey {
    fn from(s: &str) -> Self {
        match s {
            "CONFIG_FILES" => ConnectionPropertyKey::ConfigFiles,
            "CONNECTION_URL" => ConnectionPropertyKey::ConnectionUrl,
            "CONNECTOR_CLASS_NAME" => ConnectionPropertyKey::ConnectorClassName,
            "CONNECTOR_TYPE" => ConnectionPropertyKey::ConnectorType,
            "CONNECTOR_URL" => ConnectionPropertyKey::ConnectorUrl,
            "CUSTOM_JDBC_CERT" => ConnectionPropertyKey::CustomJdbcCert,
            "CUSTOM_JDBC_CERT_STRING" => ConnectionPropertyKey::CustomJdbcCertString,
            "ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD" => {
                ConnectionPropertyKey::EncryptedKafkaClientKeystorePassword
            }
            "ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD" => {
                ConnectionPropertyKey::EncryptedKafkaClientKeyPassword
            }
            "ENCRYPTED_PASSWORD" => ConnectionPropertyKey::EncryptedPassword,
            "HOST" => ConnectionPropertyKey::Host,
            "INSTANCE_ID" => ConnectionPropertyKey::InstanceId,
            "JDBC_CONNECTION_URL" => ConnectionPropertyKey::JdbcConnectionUrl,
            "JDBC_DRIVER_CLASS_NAME" => ConnectionPropertyKey::JdbcDriverClassName,
            "JDBC_DRIVER_JAR_URI" => ConnectionPropertyKey::JdbcDriverJarUri,
            "JDBC_ENFORCE_SSL" => ConnectionPropertyKey::JdbcEnforceSsl,
            "JDBC_ENGINE" => ConnectionPropertyKey::JdbcEngine,
            "JDBC_ENGINE_VERSION" => ConnectionPropertyKey::JdbcEngineVersion,
            "KAFKA_BOOTSTRAP_SERVERS" => ConnectionPropertyKey::KafkaBootstrapServers,
            "KAFKA_CLIENT_KEYSTORE" => ConnectionPropertyKey::KafkaClientKeystore,
            "KAFKA_CLIENT_KEYSTORE_PASSWORD" => ConnectionPropertyKey::KafkaClientKeystorePassword,
            "KAFKA_CLIENT_KEY_PASSWORD" => ConnectionPropertyKey::KafkaClientKeyPassword,
            "KAFKA_CUSTOM_CERT" => ConnectionPropertyKey::KafkaCustomCert,
            "KAFKA_SKIP_CUSTOM_CERT_VALIDATION" => {
                ConnectionPropertyKey::KafkaSkipCustomCertValidation
            }
            "KAFKA_SSL_ENABLED" => ConnectionPropertyKey::KafkaSslEnabled,
            "PASSWORD" => ConnectionPropertyKey::Password,
            "PORT" => ConnectionPropertyKey::Port,
            "SECRET_ID" => ConnectionPropertyKey::SecretId,
            "SKIP_CUSTOM_JDBC_CERT_VALIDATION" => {
                ConnectionPropertyKey::SkipCustomJdbcCertValidation
            }
            "USERNAME" => ConnectionPropertyKey::UserName,
            other => ConnectionPropertyKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionPropertyKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionPropertyKey::from(s))
    }
}
impl ConnectionPropertyKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionPropertyKey::ConfigFiles => "CONFIG_FILES",
            ConnectionPropertyKey::ConnectionUrl => "CONNECTION_URL",
            ConnectionPropertyKey::ConnectorClassName => "CONNECTOR_CLASS_NAME",
            ConnectionPropertyKey::ConnectorType => "CONNECTOR_TYPE",
            ConnectionPropertyKey::ConnectorUrl => "CONNECTOR_URL",
            ConnectionPropertyKey::CustomJdbcCert => "CUSTOM_JDBC_CERT",
            ConnectionPropertyKey::CustomJdbcCertString => "CUSTOM_JDBC_CERT_STRING",
            ConnectionPropertyKey::EncryptedKafkaClientKeystorePassword => {
                "ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD"
            }
            ConnectionPropertyKey::EncryptedKafkaClientKeyPassword => {
                "ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD"
            }
            ConnectionPropertyKey::EncryptedPassword => "ENCRYPTED_PASSWORD",
            ConnectionPropertyKey::Host => "HOST",
            ConnectionPropertyKey::InstanceId => "INSTANCE_ID",
            ConnectionPropertyKey::JdbcConnectionUrl => "JDBC_CONNECTION_URL",
            ConnectionPropertyKey::JdbcDriverClassName => "JDBC_DRIVER_CLASS_NAME",
            ConnectionPropertyKey::JdbcDriverJarUri => "JDBC_DRIVER_JAR_URI",
            ConnectionPropertyKey::JdbcEnforceSsl => "JDBC_ENFORCE_SSL",
            ConnectionPropertyKey::JdbcEngine => "JDBC_ENGINE",
            ConnectionPropertyKey::JdbcEngineVersion => "JDBC_ENGINE_VERSION",
            ConnectionPropertyKey::KafkaBootstrapServers => "KAFKA_BOOTSTRAP_SERVERS",
            ConnectionPropertyKey::KafkaClientKeystore => "KAFKA_CLIENT_KEYSTORE",
            ConnectionPropertyKey::KafkaClientKeystorePassword => "KAFKA_CLIENT_KEYSTORE_PASSWORD",
            ConnectionPropertyKey::KafkaClientKeyPassword => "KAFKA_CLIENT_KEY_PASSWORD",
            ConnectionPropertyKey::KafkaCustomCert => "KAFKA_CUSTOM_CERT",
            ConnectionPropertyKey::KafkaSkipCustomCertValidation => {
                "KAFKA_SKIP_CUSTOM_CERT_VALIDATION"
            }
            ConnectionPropertyKey::KafkaSslEnabled => "KAFKA_SSL_ENABLED",
            ConnectionPropertyKey::Password => "PASSWORD",
            ConnectionPropertyKey::Port => "PORT",
            ConnectionPropertyKey::SecretId => "SECRET_ID",
            ConnectionPropertyKey::SkipCustomJdbcCertValidation => {
                "SKIP_CUSTOM_JDBC_CERT_VALIDATION"
            }
            ConnectionPropertyKey::UserName => "USERNAME",
            ConnectionPropertyKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONFIG_FILES",
            "CONNECTION_URL",
            "CONNECTOR_CLASS_NAME",
            "CONNECTOR_TYPE",
            "CONNECTOR_URL",
            "CUSTOM_JDBC_CERT",
            "CUSTOM_JDBC_CERT_STRING",
            "ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD",
            "ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD",
            "ENCRYPTED_PASSWORD",
            "HOST",
            "INSTANCE_ID",
            "JDBC_CONNECTION_URL",
            "JDBC_DRIVER_CLASS_NAME",
            "JDBC_DRIVER_JAR_URI",
            "JDBC_ENFORCE_SSL",
            "JDBC_ENGINE",
            "JDBC_ENGINE_VERSION",
            "KAFKA_BOOTSTRAP_SERVERS",
            "KAFKA_CLIENT_KEYSTORE",
            "KAFKA_CLIENT_KEYSTORE_PASSWORD",
            "KAFKA_CLIENT_KEY_PASSWORD",
            "KAFKA_CUSTOM_CERT",
            "KAFKA_SKIP_CUSTOM_CERT_VALIDATION",
            "KAFKA_SSL_ENABLED",
            "PASSWORD",
            "PORT",
            "SECRET_ID",
            "SKIP_CUSTOM_JDBC_CERT_VALIDATION",
            "USERNAME",
        ]
    }
}
impl AsRef<str> for ConnectionPropertyKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionType {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Jdbc,
    #[allow(missing_docs)] // documentation missing in model
    Kafka,
    #[allow(missing_docs)] // documentation missing in model
    Marketplace,
    #[allow(missing_docs)] // documentation missing in model
    Mongodb,
    #[allow(missing_docs)] // documentation missing in model
    Network,
    #[allow(missing_docs)] // documentation missing in model
    Sftp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionType {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOM" => ConnectionType::Custom,
            "JDBC" => ConnectionType::Jdbc,
            "KAFKA" => ConnectionType::Kafka,
            "MARKETPLACE" => ConnectionType::Marketplace,
            "MONGODB" => ConnectionType::Mongodb,
            "NETWORK" => ConnectionType::Network,
            "SFTP" => ConnectionType::Sftp,
            other => ConnectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionType::from(s))
    }
}
impl ConnectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionType::Custom => "CUSTOM",
            ConnectionType::Jdbc => "JDBC",
            ConnectionType::Kafka => "KAFKA",
            ConnectionType::Marketplace => "MARKETPLACE",
            ConnectionType::Mongodb => "MONGODB",
            ConnectionType::Network => "NETWORK",
            ConnectionType::Sftp => "SFTP",
            ConnectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CUSTOM",
            "JDBC",
            "KAFKA",
            "MARKETPLACE",
            "MONGODB",
            "NETWORK",
            "SFTP",
        ]
    }
}
impl AsRef<str> for ConnectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Encapsulates a <code>ColumnStatistics</code> object that failed and the reason for failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnStatisticsError {
    /// <p>The <code>ColumnStatistics</code> of the column.</p>
    pub column_statistics: std::option::Option<crate::model::ColumnStatistics>,
    /// <p>An error message with the reason for the failure of an operation.</p>
    pub error: std::option::Option<crate::model::ErrorDetail>,
}
impl std::fmt::Debug for ColumnStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnStatisticsError");
        formatter.field("column_statistics", &self.column_statistics);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`ColumnStatisticsError`](crate::model::ColumnStatisticsError)
pub mod column_statistics_error {
    /// A builder for [`ColumnStatisticsError`](crate::model::ColumnStatisticsError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_statistics: std::option::Option<crate::model::ColumnStatistics>,
        pub(crate) error: std::option::Option<crate::model::ErrorDetail>,
    }
    impl Builder {
        /// <p>The <code>ColumnStatistics</code> of the column.</p>
        pub fn column_statistics(mut self, input: crate::model::ColumnStatistics) -> Self {
            self.column_statistics = Some(input);
            self
        }
        /// <p>The <code>ColumnStatistics</code> of the column.</p>
        pub fn set_column_statistics(
            mut self,
            input: std::option::Option<crate::model::ColumnStatistics>,
        ) -> Self {
            self.column_statistics = input;
            self
        }
        /// <p>An error message with the reason for the failure of an operation.</p>
        pub fn error(mut self, input: crate::model::ErrorDetail) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>An error message with the reason for the failure of an operation.</p>
        pub fn set_error(mut self, input: std::option::Option<crate::model::ErrorDetail>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnStatisticsError`](crate::model::ColumnStatisticsError)
        pub fn build(self) -> crate::model::ColumnStatisticsError {
            crate::model::ColumnStatisticsError {
                column_statistics: self.column_statistics,
                error: self.error,
            }
        }
    }
}
impl ColumnStatisticsError {
    /// Creates a new builder-style object to manufacture [`ColumnStatisticsError`](crate::model::ColumnStatisticsError)
    pub fn builder() -> crate::model::column_statistics_error::Builder {
        crate::model::column_statistics_error::Builder::default()
    }
}

/// <p>Contains details about an error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDetail {
    /// <p>The code associated with this error.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>A message describing the error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ErrorDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDetail");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`ErrorDetail`](crate::model::ErrorDetail)
pub mod error_detail {
    /// A builder for [`ErrorDetail`](crate::model::ErrorDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The code associated with this error.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The code associated with this error.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A message describing the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message describing the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDetail`](crate::model::ErrorDetail)
        pub fn build(self) -> crate::model::ErrorDetail {
            crate::model::ErrorDetail {
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl ErrorDetail {
    /// Creates a new builder-style object to manufacture [`ErrorDetail`](crate::model::ErrorDetail)
    pub fn builder() -> crate::model::error_detail::Builder {
        crate::model::error_detail::Builder::default()
    }
}

/// <p>Represents the generated column-level statistics for a table or partition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnStatistics {
    /// <p>Name of column which statistics belong to.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>The data type of the column.</p>
    pub column_type: std::option::Option<std::string::String>,
    /// <p>The timestamp of when column statistics were generated.</p>
    pub analyzed_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A <code>ColumnStatisticData</code> object that contains the statistics data values.</p>
    pub statistics_data: std::option::Option<crate::model::ColumnStatisticsData>,
}
impl std::fmt::Debug for ColumnStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnStatistics");
        formatter.field("column_name", &self.column_name);
        formatter.field("column_type", &self.column_type);
        formatter.field("analyzed_time", &self.analyzed_time);
        formatter.field("statistics_data", &self.statistics_data);
        formatter.finish()
    }
}
/// See [`ColumnStatistics`](crate::model::ColumnStatistics)
pub mod column_statistics {
    /// A builder for [`ColumnStatistics`](crate::model::ColumnStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) column_type: std::option::Option<std::string::String>,
        pub(crate) analyzed_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) statistics_data: std::option::Option<crate::model::ColumnStatisticsData>,
    }
    impl Builder {
        /// <p>Name of column which statistics belong to.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>Name of column which statistics belong to.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// <p>The data type of the column.</p>
        pub fn column_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_type = Some(input.into());
            self
        }
        /// <p>The data type of the column.</p>
        pub fn set_column_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_type = input;
            self
        }
        /// <p>The timestamp of when column statistics were generated.</p>
        pub fn analyzed_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.analyzed_time = Some(input);
            self
        }
        /// <p>The timestamp of when column statistics were generated.</p>
        pub fn set_analyzed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.analyzed_time = input;
            self
        }
        /// <p>A <code>ColumnStatisticData</code> object that contains the statistics data values.</p>
        pub fn statistics_data(mut self, input: crate::model::ColumnStatisticsData) -> Self {
            self.statistics_data = Some(input);
            self
        }
        /// <p>A <code>ColumnStatisticData</code> object that contains the statistics data values.</p>
        pub fn set_statistics_data(
            mut self,
            input: std::option::Option<crate::model::ColumnStatisticsData>,
        ) -> Self {
            self.statistics_data = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnStatistics`](crate::model::ColumnStatistics)
        pub fn build(self) -> crate::model::ColumnStatistics {
            crate::model::ColumnStatistics {
                column_name: self.column_name,
                column_type: self.column_type,
                analyzed_time: self.analyzed_time,
                statistics_data: self.statistics_data,
            }
        }
    }
}
impl ColumnStatistics {
    /// Creates a new builder-style object to manufacture [`ColumnStatistics`](crate::model::ColumnStatistics)
    pub fn builder() -> crate::model::column_statistics::Builder {
        crate::model::column_statistics::Builder::default()
    }
}

/// <p>Contains the individual types of column statistics data. Only one data object should be set and indicated by the <code>Type</code> attribute.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnStatisticsData {
    /// <p>The type of column statistics data.</p>
    pub r#type: std::option::Option<crate::model::ColumnStatisticsType>,
    /// <p>Boolean column statistics data.</p>
    pub boolean_column_statistics_data:
        std::option::Option<crate::model::BooleanColumnStatisticsData>,
    /// <p>Date column statistics data.</p>
    pub date_column_statistics_data: std::option::Option<crate::model::DateColumnStatisticsData>,
    /// <p>Decimal column statistics data.</p>
    pub decimal_column_statistics_data:
        std::option::Option<crate::model::DecimalColumnStatisticsData>,
    /// <p>Double column statistics data.</p>
    pub double_column_statistics_data:
        std::option::Option<crate::model::DoubleColumnStatisticsData>,
    /// <p>Long column statistics data.</p>
    pub long_column_statistics_data: std::option::Option<crate::model::LongColumnStatisticsData>,
    /// <p>String column statistics data.</p>
    pub string_column_statistics_data:
        std::option::Option<crate::model::StringColumnStatisticsData>,
    /// <p>Binary column statistics data.</p>
    pub binary_column_statistics_data:
        std::option::Option<crate::model::BinaryColumnStatisticsData>,
}
impl std::fmt::Debug for ColumnStatisticsData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnStatisticsData");
        formatter.field("r#type", &self.r#type);
        formatter.field(
            "boolean_column_statistics_data",
            &self.boolean_column_statistics_data,
        );
        formatter.field(
            "date_column_statistics_data",
            &self.date_column_statistics_data,
        );
        formatter.field(
            "decimal_column_statistics_data",
            &self.decimal_column_statistics_data,
        );
        formatter.field(
            "double_column_statistics_data",
            &self.double_column_statistics_data,
        );
        formatter.field(
            "long_column_statistics_data",
            &self.long_column_statistics_data,
        );
        formatter.field(
            "string_column_statistics_data",
            &self.string_column_statistics_data,
        );
        formatter.field(
            "binary_column_statistics_data",
            &self.binary_column_statistics_data,
        );
        formatter.finish()
    }
}
/// See [`ColumnStatisticsData`](crate::model::ColumnStatisticsData)
pub mod column_statistics_data {
    /// A builder for [`ColumnStatisticsData`](crate::model::ColumnStatisticsData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ColumnStatisticsType>,
        pub(crate) boolean_column_statistics_data:
            std::option::Option<crate::model::BooleanColumnStatisticsData>,
        pub(crate) date_column_statistics_data:
            std::option::Option<crate::model::DateColumnStatisticsData>,
        pub(crate) decimal_column_statistics_data:
            std::option::Option<crate::model::DecimalColumnStatisticsData>,
        pub(crate) double_column_statistics_data:
            std::option::Option<crate::model::DoubleColumnStatisticsData>,
        pub(crate) long_column_statistics_data:
            std::option::Option<crate::model::LongColumnStatisticsData>,
        pub(crate) string_column_statistics_data:
            std::option::Option<crate::model::StringColumnStatisticsData>,
        pub(crate) binary_column_statistics_data:
            std::option::Option<crate::model::BinaryColumnStatisticsData>,
    }
    impl Builder {
        /// <p>The type of column statistics data.</p>
        pub fn r#type(mut self, input: crate::model::ColumnStatisticsType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of column statistics data.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ColumnStatisticsType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Boolean column statistics data.</p>
        pub fn boolean_column_statistics_data(
            mut self,
            input: crate::model::BooleanColumnStatisticsData,
        ) -> Self {
            self.boolean_column_statistics_data = Some(input);
            self
        }
        /// <p>Boolean column statistics data.</p>
        pub fn set_boolean_column_statistics_data(
            mut self,
            input: std::option::Option<crate::model::BooleanColumnStatisticsData>,
        ) -> Self {
            self.boolean_column_statistics_data = input;
            self
        }
        /// <p>Date column statistics data.</p>
        pub fn date_column_statistics_data(
            mut self,
            input: crate::model::DateColumnStatisticsData,
        ) -> Self {
            self.date_column_statistics_data = Some(input);
            self
        }
        /// <p>Date column statistics data.</p>
        pub fn set_date_column_statistics_data(
            mut self,
            input: std::option::Option<crate::model::DateColumnStatisticsData>,
        ) -> Self {
            self.date_column_statistics_data = input;
            self
        }
        /// <p>Decimal column statistics data.</p>
        pub fn decimal_column_statistics_data(
            mut self,
            input: crate::model::DecimalColumnStatisticsData,
        ) -> Self {
            self.decimal_column_statistics_data = Some(input);
            self
        }
        /// <p>Decimal column statistics data.</p>
        pub fn set_decimal_column_statistics_data(
            mut self,
            input: std::option::Option<crate::model::DecimalColumnStatisticsData>,
        ) -> Self {
            self.decimal_column_statistics_data = input;
            self
        }
        /// <p>Double column statistics data.</p>
        pub fn double_column_statistics_data(
            mut self,
            input: crate::model::DoubleColumnStatisticsData,
        ) -> Self {
            self.double_column_statistics_data = Some(input);
            self
        }
        /// <p>Double column statistics data.</p>
        pub fn set_double_column_statistics_data(
            mut self,
            input: std::option::Option<crate::model::DoubleColumnStatisticsData>,
        ) -> Self {
            self.double_column_statistics_data = input;
            self
        }
        /// <p>Long column statistics data.</p>
        pub fn long_column_statistics_data(
            mut self,
            input: crate::model::LongColumnStatisticsData,
        ) -> Self {
            self.long_column_statistics_data = Some(input);
            self
        }
        /// <p>Long column statistics data.</p>
        pub fn set_long_column_statistics_data(
            mut self,
            input: std::option::Option<crate::model::LongColumnStatisticsData>,
        ) -> Self {
            self.long_column_statistics_data = input;
            self
        }
        /// <p>String column statistics data.</p>
        pub fn string_column_statistics_data(
            mut self,
            input: crate::model::StringColumnStatisticsData,
        ) -> Self {
            self.string_column_statistics_data = Some(input);
            self
        }
        /// <p>String column statistics data.</p>
        pub fn set_string_column_statistics_data(
            mut self,
            input: std::option::Option<crate::model::StringColumnStatisticsData>,
        ) -> Self {
            self.string_column_statistics_data = input;
            self
        }
        /// <p>Binary column statistics data.</p>
        pub fn binary_column_statistics_data(
            mut self,
            input: crate::model::BinaryColumnStatisticsData,
        ) -> Self {
            self.binary_column_statistics_data = Some(input);
            self
        }
        /// <p>Binary column statistics data.</p>
        pub fn set_binary_column_statistics_data(
            mut self,
            input: std::option::Option<crate::model::BinaryColumnStatisticsData>,
        ) -> Self {
            self.binary_column_statistics_data = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnStatisticsData`](crate::model::ColumnStatisticsData)
        pub fn build(self) -> crate::model::ColumnStatisticsData {
            crate::model::ColumnStatisticsData {
                r#type: self.r#type,
                boolean_column_statistics_data: self.boolean_column_statistics_data,
                date_column_statistics_data: self.date_column_statistics_data,
                decimal_column_statistics_data: self.decimal_column_statistics_data,
                double_column_statistics_data: self.double_column_statistics_data,
                long_column_statistics_data: self.long_column_statistics_data,
                string_column_statistics_data: self.string_column_statistics_data,
                binary_column_statistics_data: self.binary_column_statistics_data,
            }
        }
    }
}
impl ColumnStatisticsData {
    /// Creates a new builder-style object to manufacture [`ColumnStatisticsData`](crate::model::ColumnStatisticsData)
    pub fn builder() -> crate::model::column_statistics_data::Builder {
        crate::model::column_statistics_data::Builder::default()
    }
}

/// <p>Defines column statistics supported for bit sequence data values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BinaryColumnStatisticsData {
    /// <p>The size of the longest bit sequence in the column.</p>
    pub maximum_length: i64,
    /// <p>The average bit sequence length in the column.</p>
    pub average_length: f64,
    /// <p>The number of null values in the column.</p>
    pub number_of_nulls: i64,
}
impl std::fmt::Debug for BinaryColumnStatisticsData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BinaryColumnStatisticsData");
        formatter.field("maximum_length", &self.maximum_length);
        formatter.field("average_length", &self.average_length);
        formatter.field("number_of_nulls", &self.number_of_nulls);
        formatter.finish()
    }
}
/// See [`BinaryColumnStatisticsData`](crate::model::BinaryColumnStatisticsData)
pub mod binary_column_statistics_data {
    /// A builder for [`BinaryColumnStatisticsData`](crate::model::BinaryColumnStatisticsData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum_length: std::option::Option<i64>,
        pub(crate) average_length: std::option::Option<f64>,
        pub(crate) number_of_nulls: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The size of the longest bit sequence in the column.</p>
        pub fn maximum_length(mut self, input: i64) -> Self {
            self.maximum_length = Some(input);
            self
        }
        /// <p>The size of the longest bit sequence in the column.</p>
        pub fn set_maximum_length(mut self, input: std::option::Option<i64>) -> Self {
            self.maximum_length = input;
            self
        }
        /// <p>The average bit sequence length in the column.</p>
        pub fn average_length(mut self, input: f64) -> Self {
            self.average_length = Some(input);
            self
        }
        /// <p>The average bit sequence length in the column.</p>
        pub fn set_average_length(mut self, input: std::option::Option<f64>) -> Self {
            self.average_length = input;
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn number_of_nulls(mut self, input: i64) -> Self {
            self.number_of_nulls = Some(input);
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn set_number_of_nulls(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_nulls = input;
            self
        }
        /// Consumes the builder and constructs a [`BinaryColumnStatisticsData`](crate::model::BinaryColumnStatisticsData)
        pub fn build(self) -> crate::model::BinaryColumnStatisticsData {
            crate::model::BinaryColumnStatisticsData {
                maximum_length: self.maximum_length.unwrap_or_default(),
                average_length: self.average_length.unwrap_or_default(),
                number_of_nulls: self.number_of_nulls.unwrap_or_default(),
            }
        }
    }
}
impl BinaryColumnStatisticsData {
    /// Creates a new builder-style object to manufacture [`BinaryColumnStatisticsData`](crate::model::BinaryColumnStatisticsData)
    pub fn builder() -> crate::model::binary_column_statistics_data::Builder {
        crate::model::binary_column_statistics_data::Builder::default()
    }
}

/// <p>Defines column statistics supported for character sequence data values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StringColumnStatisticsData {
    /// <p>The size of the longest string in the column.</p>
    pub maximum_length: i64,
    /// <p>The average string length in the column.</p>
    pub average_length: f64,
    /// <p>The number of null values in the column.</p>
    pub number_of_nulls: i64,
    /// <p>The number of distinct values in a column.</p>
    pub number_of_distinct_values: i64,
}
impl std::fmt::Debug for StringColumnStatisticsData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StringColumnStatisticsData");
        formatter.field("maximum_length", &self.maximum_length);
        formatter.field("average_length", &self.average_length);
        formatter.field("number_of_nulls", &self.number_of_nulls);
        formatter.field("number_of_distinct_values", &self.number_of_distinct_values);
        formatter.finish()
    }
}
/// See [`StringColumnStatisticsData`](crate::model::StringColumnStatisticsData)
pub mod string_column_statistics_data {
    /// A builder for [`StringColumnStatisticsData`](crate::model::StringColumnStatisticsData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum_length: std::option::Option<i64>,
        pub(crate) average_length: std::option::Option<f64>,
        pub(crate) number_of_nulls: std::option::Option<i64>,
        pub(crate) number_of_distinct_values: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The size of the longest string in the column.</p>
        pub fn maximum_length(mut self, input: i64) -> Self {
            self.maximum_length = Some(input);
            self
        }
        /// <p>The size of the longest string in the column.</p>
        pub fn set_maximum_length(mut self, input: std::option::Option<i64>) -> Self {
            self.maximum_length = input;
            self
        }
        /// <p>The average string length in the column.</p>
        pub fn average_length(mut self, input: f64) -> Self {
            self.average_length = Some(input);
            self
        }
        /// <p>The average string length in the column.</p>
        pub fn set_average_length(mut self, input: std::option::Option<f64>) -> Self {
            self.average_length = input;
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn number_of_nulls(mut self, input: i64) -> Self {
            self.number_of_nulls = Some(input);
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn set_number_of_nulls(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_nulls = input;
            self
        }
        /// <p>The number of distinct values in a column.</p>
        pub fn number_of_distinct_values(mut self, input: i64) -> Self {
            self.number_of_distinct_values = Some(input);
            self
        }
        /// <p>The number of distinct values in a column.</p>
        pub fn set_number_of_distinct_values(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_distinct_values = input;
            self
        }
        /// Consumes the builder and constructs a [`StringColumnStatisticsData`](crate::model::StringColumnStatisticsData)
        pub fn build(self) -> crate::model::StringColumnStatisticsData {
            crate::model::StringColumnStatisticsData {
                maximum_length: self.maximum_length.unwrap_or_default(),
                average_length: self.average_length.unwrap_or_default(),
                number_of_nulls: self.number_of_nulls.unwrap_or_default(),
                number_of_distinct_values: self.number_of_distinct_values.unwrap_or_default(),
            }
        }
    }
}
impl StringColumnStatisticsData {
    /// Creates a new builder-style object to manufacture [`StringColumnStatisticsData`](crate::model::StringColumnStatisticsData)
    pub fn builder() -> crate::model::string_column_statistics_data::Builder {
        crate::model::string_column_statistics_data::Builder::default()
    }
}

/// <p>Defines column statistics supported for integer data columns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LongColumnStatisticsData {
    /// <p>The lowest value in the column.</p>
    pub minimum_value: i64,
    /// <p>The highest value in the column.</p>
    pub maximum_value: i64,
    /// <p>The number of null values in the column.</p>
    pub number_of_nulls: i64,
    /// <p>The number of distinct values in a column.</p>
    pub number_of_distinct_values: i64,
}
impl std::fmt::Debug for LongColumnStatisticsData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LongColumnStatisticsData");
        formatter.field("minimum_value", &self.minimum_value);
        formatter.field("maximum_value", &self.maximum_value);
        formatter.field("number_of_nulls", &self.number_of_nulls);
        formatter.field("number_of_distinct_values", &self.number_of_distinct_values);
        formatter.finish()
    }
}
/// See [`LongColumnStatisticsData`](crate::model::LongColumnStatisticsData)
pub mod long_column_statistics_data {
    /// A builder for [`LongColumnStatisticsData`](crate::model::LongColumnStatisticsData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_value: std::option::Option<i64>,
        pub(crate) maximum_value: std::option::Option<i64>,
        pub(crate) number_of_nulls: std::option::Option<i64>,
        pub(crate) number_of_distinct_values: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The lowest value in the column.</p>
        pub fn minimum_value(mut self, input: i64) -> Self {
            self.minimum_value = Some(input);
            self
        }
        /// <p>The lowest value in the column.</p>
        pub fn set_minimum_value(mut self, input: std::option::Option<i64>) -> Self {
            self.minimum_value = input;
            self
        }
        /// <p>The highest value in the column.</p>
        pub fn maximum_value(mut self, input: i64) -> Self {
            self.maximum_value = Some(input);
            self
        }
        /// <p>The highest value in the column.</p>
        pub fn set_maximum_value(mut self, input: std::option::Option<i64>) -> Self {
            self.maximum_value = input;
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn number_of_nulls(mut self, input: i64) -> Self {
            self.number_of_nulls = Some(input);
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn set_number_of_nulls(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_nulls = input;
            self
        }
        /// <p>The number of distinct values in a column.</p>
        pub fn number_of_distinct_values(mut self, input: i64) -> Self {
            self.number_of_distinct_values = Some(input);
            self
        }
        /// <p>The number of distinct values in a column.</p>
        pub fn set_number_of_distinct_values(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_distinct_values = input;
            self
        }
        /// Consumes the builder and constructs a [`LongColumnStatisticsData`](crate::model::LongColumnStatisticsData)
        pub fn build(self) -> crate::model::LongColumnStatisticsData {
            crate::model::LongColumnStatisticsData {
                minimum_value: self.minimum_value.unwrap_or_default(),
                maximum_value: self.maximum_value.unwrap_or_default(),
                number_of_nulls: self.number_of_nulls.unwrap_or_default(),
                number_of_distinct_values: self.number_of_distinct_values.unwrap_or_default(),
            }
        }
    }
}
impl LongColumnStatisticsData {
    /// Creates a new builder-style object to manufacture [`LongColumnStatisticsData`](crate::model::LongColumnStatisticsData)
    pub fn builder() -> crate::model::long_column_statistics_data::Builder {
        crate::model::long_column_statistics_data::Builder::default()
    }
}

/// <p>Defines column statistics supported for floating-point number data columns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DoubleColumnStatisticsData {
    /// <p>The lowest value in the column.</p>
    pub minimum_value: f64,
    /// <p>The highest value in the column.</p>
    pub maximum_value: f64,
    /// <p>The number of null values in the column.</p>
    pub number_of_nulls: i64,
    /// <p>The number of distinct values in a column.</p>
    pub number_of_distinct_values: i64,
}
impl std::fmt::Debug for DoubleColumnStatisticsData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DoubleColumnStatisticsData");
        formatter.field("minimum_value", &self.minimum_value);
        formatter.field("maximum_value", &self.maximum_value);
        formatter.field("number_of_nulls", &self.number_of_nulls);
        formatter.field("number_of_distinct_values", &self.number_of_distinct_values);
        formatter.finish()
    }
}
/// See [`DoubleColumnStatisticsData`](crate::model::DoubleColumnStatisticsData)
pub mod double_column_statistics_data {
    /// A builder for [`DoubleColumnStatisticsData`](crate::model::DoubleColumnStatisticsData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_value: std::option::Option<f64>,
        pub(crate) maximum_value: std::option::Option<f64>,
        pub(crate) number_of_nulls: std::option::Option<i64>,
        pub(crate) number_of_distinct_values: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The lowest value in the column.</p>
        pub fn minimum_value(mut self, input: f64) -> Self {
            self.minimum_value = Some(input);
            self
        }
        /// <p>The lowest value in the column.</p>
        pub fn set_minimum_value(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum_value = input;
            self
        }
        /// <p>The highest value in the column.</p>
        pub fn maximum_value(mut self, input: f64) -> Self {
            self.maximum_value = Some(input);
            self
        }
        /// <p>The highest value in the column.</p>
        pub fn set_maximum_value(mut self, input: std::option::Option<f64>) -> Self {
            self.maximum_value = input;
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn number_of_nulls(mut self, input: i64) -> Self {
            self.number_of_nulls = Some(input);
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn set_number_of_nulls(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_nulls = input;
            self
        }
        /// <p>The number of distinct values in a column.</p>
        pub fn number_of_distinct_values(mut self, input: i64) -> Self {
            self.number_of_distinct_values = Some(input);
            self
        }
        /// <p>The number of distinct values in a column.</p>
        pub fn set_number_of_distinct_values(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_distinct_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DoubleColumnStatisticsData`](crate::model::DoubleColumnStatisticsData)
        pub fn build(self) -> crate::model::DoubleColumnStatisticsData {
            crate::model::DoubleColumnStatisticsData {
                minimum_value: self.minimum_value.unwrap_or_default(),
                maximum_value: self.maximum_value.unwrap_or_default(),
                number_of_nulls: self.number_of_nulls.unwrap_or_default(),
                number_of_distinct_values: self.number_of_distinct_values.unwrap_or_default(),
            }
        }
    }
}
impl DoubleColumnStatisticsData {
    /// Creates a new builder-style object to manufacture [`DoubleColumnStatisticsData`](crate::model::DoubleColumnStatisticsData)
    pub fn builder() -> crate::model::double_column_statistics_data::Builder {
        crate::model::double_column_statistics_data::Builder::default()
    }
}

/// <p>Defines column statistics supported for fixed-point number data columns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecimalColumnStatisticsData {
    /// <p>The lowest value in the column.</p>
    pub minimum_value: std::option::Option<crate::model::DecimalNumber>,
    /// <p>The highest value in the column.</p>
    pub maximum_value: std::option::Option<crate::model::DecimalNumber>,
    /// <p>The number of null values in the column.</p>
    pub number_of_nulls: i64,
    /// <p>The number of distinct values in a column.</p>
    pub number_of_distinct_values: i64,
}
impl std::fmt::Debug for DecimalColumnStatisticsData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecimalColumnStatisticsData");
        formatter.field("minimum_value", &self.minimum_value);
        formatter.field("maximum_value", &self.maximum_value);
        formatter.field("number_of_nulls", &self.number_of_nulls);
        formatter.field("number_of_distinct_values", &self.number_of_distinct_values);
        formatter.finish()
    }
}
/// See [`DecimalColumnStatisticsData`](crate::model::DecimalColumnStatisticsData)
pub mod decimal_column_statistics_data {
    /// A builder for [`DecimalColumnStatisticsData`](crate::model::DecimalColumnStatisticsData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_value: std::option::Option<crate::model::DecimalNumber>,
        pub(crate) maximum_value: std::option::Option<crate::model::DecimalNumber>,
        pub(crate) number_of_nulls: std::option::Option<i64>,
        pub(crate) number_of_distinct_values: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The lowest value in the column.</p>
        pub fn minimum_value(mut self, input: crate::model::DecimalNumber) -> Self {
            self.minimum_value = Some(input);
            self
        }
        /// <p>The lowest value in the column.</p>
        pub fn set_minimum_value(
            mut self,
            input: std::option::Option<crate::model::DecimalNumber>,
        ) -> Self {
            self.minimum_value = input;
            self
        }
        /// <p>The highest value in the column.</p>
        pub fn maximum_value(mut self, input: crate::model::DecimalNumber) -> Self {
            self.maximum_value = Some(input);
            self
        }
        /// <p>The highest value in the column.</p>
        pub fn set_maximum_value(
            mut self,
            input: std::option::Option<crate::model::DecimalNumber>,
        ) -> Self {
            self.maximum_value = input;
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn number_of_nulls(mut self, input: i64) -> Self {
            self.number_of_nulls = Some(input);
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn set_number_of_nulls(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_nulls = input;
            self
        }
        /// <p>The number of distinct values in a column.</p>
        pub fn number_of_distinct_values(mut self, input: i64) -> Self {
            self.number_of_distinct_values = Some(input);
            self
        }
        /// <p>The number of distinct values in a column.</p>
        pub fn set_number_of_distinct_values(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_distinct_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DecimalColumnStatisticsData`](crate::model::DecimalColumnStatisticsData)
        pub fn build(self) -> crate::model::DecimalColumnStatisticsData {
            crate::model::DecimalColumnStatisticsData {
                minimum_value: self.minimum_value,
                maximum_value: self.maximum_value,
                number_of_nulls: self.number_of_nulls.unwrap_or_default(),
                number_of_distinct_values: self.number_of_distinct_values.unwrap_or_default(),
            }
        }
    }
}
impl DecimalColumnStatisticsData {
    /// Creates a new builder-style object to manufacture [`DecimalColumnStatisticsData`](crate::model::DecimalColumnStatisticsData)
    pub fn builder() -> crate::model::decimal_column_statistics_data::Builder {
        crate::model::decimal_column_statistics_data::Builder::default()
    }
}

/// <p>Contains a numeric value in decimal format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DecimalNumber {
    /// <p>The unscaled numeric value.</p>
    pub unscaled_value: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The scale that determines where the decimal point falls in the
    /// unscaled value.</p>
    pub scale: i32,
}
impl std::fmt::Debug for DecimalNumber {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DecimalNumber");
        formatter.field("unscaled_value", &self.unscaled_value);
        formatter.field("scale", &self.scale);
        formatter.finish()
    }
}
/// See [`DecimalNumber`](crate::model::DecimalNumber)
pub mod decimal_number {
    /// A builder for [`DecimalNumber`](crate::model::DecimalNumber)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unscaled_value: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) scale: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unscaled numeric value.</p>
        pub fn unscaled_value(mut self, input: aws_smithy_types::Blob) -> Self {
            self.unscaled_value = Some(input);
            self
        }
        /// <p>The unscaled numeric value.</p>
        pub fn set_unscaled_value(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.unscaled_value = input;
            self
        }
        /// <p>The scale that determines where the decimal point falls in the
        /// unscaled value.</p>
        pub fn scale(mut self, input: i32) -> Self {
            self.scale = Some(input);
            self
        }
        /// <p>The scale that determines where the decimal point falls in the
        /// unscaled value.</p>
        pub fn set_scale(mut self, input: std::option::Option<i32>) -> Self {
            self.scale = input;
            self
        }
        /// Consumes the builder and constructs a [`DecimalNumber`](crate::model::DecimalNumber)
        pub fn build(self) -> crate::model::DecimalNumber {
            crate::model::DecimalNumber {
                unscaled_value: self.unscaled_value,
                scale: self.scale.unwrap_or_default(),
            }
        }
    }
}
impl DecimalNumber {
    /// Creates a new builder-style object to manufacture [`DecimalNumber`](crate::model::DecimalNumber)
    pub fn builder() -> crate::model::decimal_number::Builder {
        crate::model::decimal_number::Builder::default()
    }
}

/// <p>Defines column statistics supported for timestamp data columns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DateColumnStatisticsData {
    /// <p>The lowest value in the column.</p>
    pub minimum_value: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The highest value in the column.</p>
    pub maximum_value: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of null values in the column.</p>
    pub number_of_nulls: i64,
    /// <p>The number of distinct values in a column.</p>
    pub number_of_distinct_values: i64,
}
impl std::fmt::Debug for DateColumnStatisticsData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DateColumnStatisticsData");
        formatter.field("minimum_value", &self.minimum_value);
        formatter.field("maximum_value", &self.maximum_value);
        formatter.field("number_of_nulls", &self.number_of_nulls);
        formatter.field("number_of_distinct_values", &self.number_of_distinct_values);
        formatter.finish()
    }
}
/// See [`DateColumnStatisticsData`](crate::model::DateColumnStatisticsData)
pub mod date_column_statistics_data {
    /// A builder for [`DateColumnStatisticsData`](crate::model::DateColumnStatisticsData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_value: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) maximum_value: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) number_of_nulls: std::option::Option<i64>,
        pub(crate) number_of_distinct_values: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The lowest value in the column.</p>
        pub fn minimum_value(mut self, input: aws_smithy_types::Instant) -> Self {
            self.minimum_value = Some(input);
            self
        }
        /// <p>The lowest value in the column.</p>
        pub fn set_minimum_value(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.minimum_value = input;
            self
        }
        /// <p>The highest value in the column.</p>
        pub fn maximum_value(mut self, input: aws_smithy_types::Instant) -> Self {
            self.maximum_value = Some(input);
            self
        }
        /// <p>The highest value in the column.</p>
        pub fn set_maximum_value(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.maximum_value = input;
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn number_of_nulls(mut self, input: i64) -> Self {
            self.number_of_nulls = Some(input);
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn set_number_of_nulls(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_nulls = input;
            self
        }
        /// <p>The number of distinct values in a column.</p>
        pub fn number_of_distinct_values(mut self, input: i64) -> Self {
            self.number_of_distinct_values = Some(input);
            self
        }
        /// <p>The number of distinct values in a column.</p>
        pub fn set_number_of_distinct_values(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_distinct_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DateColumnStatisticsData`](crate::model::DateColumnStatisticsData)
        pub fn build(self) -> crate::model::DateColumnStatisticsData {
            crate::model::DateColumnStatisticsData {
                minimum_value: self.minimum_value,
                maximum_value: self.maximum_value,
                number_of_nulls: self.number_of_nulls.unwrap_or_default(),
                number_of_distinct_values: self.number_of_distinct_values.unwrap_or_default(),
            }
        }
    }
}
impl DateColumnStatisticsData {
    /// Creates a new builder-style object to manufacture [`DateColumnStatisticsData`](crate::model::DateColumnStatisticsData)
    pub fn builder() -> crate::model::date_column_statistics_data::Builder {
        crate::model::date_column_statistics_data::Builder::default()
    }
}

/// <p>Defines column statistics supported for Boolean data columns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BooleanColumnStatisticsData {
    /// <p>The number of true values in the column.</p>
    pub number_of_trues: i64,
    /// <p>The number of false values in the column.</p>
    pub number_of_falses: i64,
    /// <p>The number of null values in the column.</p>
    pub number_of_nulls: i64,
}
impl std::fmt::Debug for BooleanColumnStatisticsData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BooleanColumnStatisticsData");
        formatter.field("number_of_trues", &self.number_of_trues);
        formatter.field("number_of_falses", &self.number_of_falses);
        formatter.field("number_of_nulls", &self.number_of_nulls);
        formatter.finish()
    }
}
/// See [`BooleanColumnStatisticsData`](crate::model::BooleanColumnStatisticsData)
pub mod boolean_column_statistics_data {
    /// A builder for [`BooleanColumnStatisticsData`](crate::model::BooleanColumnStatisticsData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) number_of_trues: std::option::Option<i64>,
        pub(crate) number_of_falses: std::option::Option<i64>,
        pub(crate) number_of_nulls: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of true values in the column.</p>
        pub fn number_of_trues(mut self, input: i64) -> Self {
            self.number_of_trues = Some(input);
            self
        }
        /// <p>The number of true values in the column.</p>
        pub fn set_number_of_trues(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_trues = input;
            self
        }
        /// <p>The number of false values in the column.</p>
        pub fn number_of_falses(mut self, input: i64) -> Self {
            self.number_of_falses = Some(input);
            self
        }
        /// <p>The number of false values in the column.</p>
        pub fn set_number_of_falses(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_falses = input;
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn number_of_nulls(mut self, input: i64) -> Self {
            self.number_of_nulls = Some(input);
            self
        }
        /// <p>The number of null values in the column.</p>
        pub fn set_number_of_nulls(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_nulls = input;
            self
        }
        /// Consumes the builder and constructs a [`BooleanColumnStatisticsData`](crate::model::BooleanColumnStatisticsData)
        pub fn build(self) -> crate::model::BooleanColumnStatisticsData {
            crate::model::BooleanColumnStatisticsData {
                number_of_trues: self.number_of_trues.unwrap_or_default(),
                number_of_falses: self.number_of_falses.unwrap_or_default(),
                number_of_nulls: self.number_of_nulls.unwrap_or_default(),
            }
        }
    }
}
impl BooleanColumnStatisticsData {
    /// Creates a new builder-style object to manufacture [`BooleanColumnStatisticsData`](crate::model::BooleanColumnStatisticsData)
    pub fn builder() -> crate::model::boolean_column_statistics_data::Builder {
        crate::model::boolean_column_statistics_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ColumnStatisticsType {
    #[allow(missing_docs)] // documentation missing in model
    Binary,
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    Date,
    #[allow(missing_docs)] // documentation missing in model
    Decimal,
    #[allow(missing_docs)] // documentation missing in model
    Double,
    #[allow(missing_docs)] // documentation missing in model
    Long,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ColumnStatisticsType {
    fn from(s: &str) -> Self {
        match s {
            "BINARY" => ColumnStatisticsType::Binary,
            "BOOLEAN" => ColumnStatisticsType::Boolean,
            "DATE" => ColumnStatisticsType::Date,
            "DECIMAL" => ColumnStatisticsType::Decimal,
            "DOUBLE" => ColumnStatisticsType::Double,
            "LONG" => ColumnStatisticsType::Long,
            "STRING" => ColumnStatisticsType::String,
            other => ColumnStatisticsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ColumnStatisticsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ColumnStatisticsType::from(s))
    }
}
impl ColumnStatisticsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ColumnStatisticsType::Binary => "BINARY",
            ColumnStatisticsType::Boolean => "BOOLEAN",
            ColumnStatisticsType::Date => "DATE",
            ColumnStatisticsType::Decimal => "DECIMAL",
            ColumnStatisticsType::Double => "DOUBLE",
            ColumnStatisticsType::Long => "LONG",
            ColumnStatisticsType::String => "STRING",
            ColumnStatisticsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BINARY", "BOOLEAN", "DATE", "DECIMAL", "DOUBLE", "LONG", "STRING",
        ]
    }
}
impl AsRef<str> for ColumnStatisticsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a custom CSV classifier to be updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCsvClassifierRequest {
    /// <p>The name of the classifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A custom symbol to denote what separates each column entry in the row.</p>
    pub delimiter: std::option::Option<std::string::String>,
    /// <p>A custom symbol to denote what combines content into a single column value. It must be
    /// different from the column delimiter.</p>
    pub quote_symbol: std::option::Option<std::string::String>,
    /// <p>Indicates whether the CSV file contains a header.</p>
    pub contains_header: std::option::Option<crate::model::CsvHeaderOption>,
    /// <p>A list of strings representing column names.</p>
    pub header: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies not to trim values before identifying the type of column values. The default value is true.</p>
    pub disable_value_trimming: std::option::Option<bool>,
    /// <p>Enables the processing of files that contain only one column.</p>
    pub allow_single_column: std::option::Option<bool>,
}
impl std::fmt::Debug for UpdateCsvClassifierRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCsvClassifierRequest");
        formatter.field("name", &self.name);
        formatter.field("delimiter", &self.delimiter);
        formatter.field("quote_symbol", &self.quote_symbol);
        formatter.field("contains_header", &self.contains_header);
        formatter.field("header", &self.header);
        formatter.field("disable_value_trimming", &self.disable_value_trimming);
        formatter.field("allow_single_column", &self.allow_single_column);
        formatter.finish()
    }
}
/// See [`UpdateCsvClassifierRequest`](crate::model::UpdateCsvClassifierRequest)
pub mod update_csv_classifier_request {
    /// A builder for [`UpdateCsvClassifierRequest`](crate::model::UpdateCsvClassifierRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) quote_symbol: std::option::Option<std::string::String>,
        pub(crate) contains_header: std::option::Option<crate::model::CsvHeaderOption>,
        pub(crate) header: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) disable_value_trimming: std::option::Option<bool>,
        pub(crate) allow_single_column: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the classifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the classifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A custom symbol to denote what separates each column entry in the row.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A custom symbol to denote what separates each column entry in the row.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>A custom symbol to denote what combines content into a single column value. It must be
        /// different from the column delimiter.</p>
        pub fn quote_symbol(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_symbol = Some(input.into());
            self
        }
        /// <p>A custom symbol to denote what combines content into a single column value. It must be
        /// different from the column delimiter.</p>
        pub fn set_quote_symbol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quote_symbol = input;
            self
        }
        /// <p>Indicates whether the CSV file contains a header.</p>
        pub fn contains_header(mut self, input: crate::model::CsvHeaderOption) -> Self {
            self.contains_header = Some(input);
            self
        }
        /// <p>Indicates whether the CSV file contains a header.</p>
        pub fn set_contains_header(
            mut self,
            input: std::option::Option<crate::model::CsvHeaderOption>,
        ) -> Self {
            self.contains_header = input;
            self
        }
        /// Appends an item to `header`.
        ///
        /// To override the contents of this collection use [`set_header`](Self::set_header).
        ///
        /// <p>A list of strings representing column names.</p>
        pub fn header(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.header.unwrap_or_default();
            v.push(input.into());
            self.header = Some(v);
            self
        }
        /// <p>A list of strings representing column names.</p>
        pub fn set_header(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.header = input;
            self
        }
        /// <p>Specifies not to trim values before identifying the type of column values. The default value is true.</p>
        pub fn disable_value_trimming(mut self, input: bool) -> Self {
            self.disable_value_trimming = Some(input);
            self
        }
        /// <p>Specifies not to trim values before identifying the type of column values. The default value is true.</p>
        pub fn set_disable_value_trimming(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_value_trimming = input;
            self
        }
        /// <p>Enables the processing of files that contain only one column.</p>
        pub fn allow_single_column(mut self, input: bool) -> Self {
            self.allow_single_column = Some(input);
            self
        }
        /// <p>Enables the processing of files that contain only one column.</p>
        pub fn set_allow_single_column(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_single_column = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCsvClassifierRequest`](crate::model::UpdateCsvClassifierRequest)
        pub fn build(self) -> crate::model::UpdateCsvClassifierRequest {
            crate::model::UpdateCsvClassifierRequest {
                name: self.name,
                delimiter: self.delimiter,
                quote_symbol: self.quote_symbol,
                contains_header: self.contains_header,
                header: self.header,
                disable_value_trimming: self.disable_value_trimming,
                allow_single_column: self.allow_single_column,
            }
        }
    }
}
impl UpdateCsvClassifierRequest {
    /// Creates a new builder-style object to manufacture [`UpdateCsvClassifierRequest`](crate::model::UpdateCsvClassifierRequest)
    pub fn builder() -> crate::model::update_csv_classifier_request::Builder {
        crate::model::update_csv_classifier_request::Builder::default()
    }
}

/// _Note: `CsvHeaderOption::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CsvHeaderOption {
    #[allow(missing_docs)] // documentation missing in model
    Absent,
    #[allow(missing_docs)] // documentation missing in model
    Present,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CsvHeaderOption {
    fn from(s: &str) -> Self {
        match s {
            "ABSENT" => CsvHeaderOption::Absent,
            "PRESENT" => CsvHeaderOption::Present,
            "UNKNOWN" => CsvHeaderOption::UnknownValue,
            other => CsvHeaderOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CsvHeaderOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CsvHeaderOption::from(s))
    }
}
impl CsvHeaderOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CsvHeaderOption::Absent => "ABSENT",
            CsvHeaderOption::Present => "PRESENT",
            CsvHeaderOption::UnknownValue => "UNKNOWN",
            CsvHeaderOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ABSENT", "PRESENT", "UNKNOWN"]
    }
}
impl AsRef<str> for CsvHeaderOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a JSON classifier to be updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJsonClassifierRequest {
    /// <p>The name of the classifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A <code>JsonPath</code> string defining the JSON data for the classifier to classify.
    /// Glue supports a subset of JsonPath, as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a>.</p>
    pub json_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateJsonClassifierRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJsonClassifierRequest");
        formatter.field("name", &self.name);
        formatter.field("json_path", &self.json_path);
        formatter.finish()
    }
}
/// See [`UpdateJsonClassifierRequest`](crate::model::UpdateJsonClassifierRequest)
pub mod update_json_classifier_request {
    /// A builder for [`UpdateJsonClassifierRequest`](crate::model::UpdateJsonClassifierRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) json_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the classifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the classifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A <code>JsonPath</code> string defining the JSON data for the classifier to classify.
        /// Glue supports a subset of JsonPath, as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a>.</p>
        pub fn json_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.json_path = Some(input.into());
            self
        }
        /// <p>A <code>JsonPath</code> string defining the JSON data for the classifier to classify.
        /// Glue supports a subset of JsonPath, as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a>.</p>
        pub fn set_json_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.json_path = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJsonClassifierRequest`](crate::model::UpdateJsonClassifierRequest)
        pub fn build(self) -> crate::model::UpdateJsonClassifierRequest {
            crate::model::UpdateJsonClassifierRequest {
                name: self.name,
                json_path: self.json_path,
            }
        }
    }
}
impl UpdateJsonClassifierRequest {
    /// Creates a new builder-style object to manufacture [`UpdateJsonClassifierRequest`](crate::model::UpdateJsonClassifierRequest)
    pub fn builder() -> crate::model::update_json_classifier_request::Builder {
        crate::model::update_json_classifier_request::Builder::default()
    }
}

/// <p>Specifies an XML classifier to be updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateXmlClassifierRequest {
    /// <p>The name of the classifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An identifier of the data format that the classifier matches.</p>
    pub classification: std::option::Option<std::string::String>,
    /// <p>The XML tag designating the element that contains each record in an XML document being
    /// parsed. This cannot identify a self-closing element (closed by <code>/></code>). An empty
    /// row element that contains only attributes can be parsed as long as it ends with a closing tag
    /// (for example, <code><row item_a="A" item_b="B"></row></code> is okay, but
    /// <code><row item_a="A" item_b="B" /></code> is not).</p>
    pub row_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateXmlClassifierRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateXmlClassifierRequest");
        formatter.field("name", &self.name);
        formatter.field("classification", &self.classification);
        formatter.field("row_tag", &self.row_tag);
        formatter.finish()
    }
}
/// See [`UpdateXmlClassifierRequest`](crate::model::UpdateXmlClassifierRequest)
pub mod update_xml_classifier_request {
    /// A builder for [`UpdateXmlClassifierRequest`](crate::model::UpdateXmlClassifierRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) classification: std::option::Option<std::string::String>,
        pub(crate) row_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the classifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the classifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An identifier of the data format that the classifier matches.</p>
        pub fn classification(mut self, input: impl Into<std::string::String>) -> Self {
            self.classification = Some(input.into());
            self
        }
        /// <p>An identifier of the data format that the classifier matches.</p>
        pub fn set_classification(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.classification = input;
            self
        }
        /// <p>The XML tag designating the element that contains each record in an XML document being
        /// parsed. This cannot identify a self-closing element (closed by <code>/></code>). An empty
        /// row element that contains only attributes can be parsed as long as it ends with a closing tag
        /// (for example, <code><row item_a="A" item_b="B"></row></code> is okay, but
        /// <code><row item_a="A" item_b="B" /></code> is not).</p>
        pub fn row_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.row_tag = Some(input.into());
            self
        }
        /// <p>The XML tag designating the element that contains each record in an XML document being
        /// parsed. This cannot identify a self-closing element (closed by <code>/></code>). An empty
        /// row element that contains only attributes can be parsed as long as it ends with a closing tag
        /// (for example, <code><row item_a="A" item_b="B"></row></code> is okay, but
        /// <code><row item_a="A" item_b="B" /></code> is not).</p>
        pub fn set_row_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.row_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateXmlClassifierRequest`](crate::model::UpdateXmlClassifierRequest)
        pub fn build(self) -> crate::model::UpdateXmlClassifierRequest {
            crate::model::UpdateXmlClassifierRequest {
                name: self.name,
                classification: self.classification,
                row_tag: self.row_tag,
            }
        }
    }
}
impl UpdateXmlClassifierRequest {
    /// Creates a new builder-style object to manufacture [`UpdateXmlClassifierRequest`](crate::model::UpdateXmlClassifierRequest)
    pub fn builder() -> crate::model::update_xml_classifier_request::Builder {
        crate::model::update_xml_classifier_request::Builder::default()
    }
}

/// <p>Specifies a grok classifier to update when passed to
/// <code>UpdateClassifier</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGrokClassifierRequest {
    /// <p>The name of the <code>GrokClassifier</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs,
    /// Amazon CloudWatch Logs, and so on.</p>
    pub classification: std::option::Option<std::string::String>,
    /// <p>The grok pattern used by this classifier.</p>
    pub grok_pattern: std::option::Option<std::string::String>,
    /// <p>Optional custom grok patterns used by this classifier.</p>
    pub custom_patterns: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateGrokClassifierRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGrokClassifierRequest");
        formatter.field("name", &self.name);
        formatter.field("classification", &self.classification);
        formatter.field("grok_pattern", &self.grok_pattern);
        formatter.field("custom_patterns", &self.custom_patterns);
        formatter.finish()
    }
}
/// See [`UpdateGrokClassifierRequest`](crate::model::UpdateGrokClassifierRequest)
pub mod update_grok_classifier_request {
    /// A builder for [`UpdateGrokClassifierRequest`](crate::model::UpdateGrokClassifierRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) classification: std::option::Option<std::string::String>,
        pub(crate) grok_pattern: std::option::Option<std::string::String>,
        pub(crate) custom_patterns: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the <code>GrokClassifier</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>GrokClassifier</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs,
        /// Amazon CloudWatch Logs, and so on.</p>
        pub fn classification(mut self, input: impl Into<std::string::String>) -> Self {
            self.classification = Some(input.into());
            self
        }
        /// <p>An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs,
        /// Amazon CloudWatch Logs, and so on.</p>
        pub fn set_classification(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.classification = input;
            self
        }
        /// <p>The grok pattern used by this classifier.</p>
        pub fn grok_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.grok_pattern = Some(input.into());
            self
        }
        /// <p>The grok pattern used by this classifier.</p>
        pub fn set_grok_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grok_pattern = input;
            self
        }
        /// <p>Optional custom grok patterns used by this classifier.</p>
        pub fn custom_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_patterns = Some(input.into());
            self
        }
        /// <p>Optional custom grok patterns used by this classifier.</p>
        pub fn set_custom_patterns(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_patterns = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGrokClassifierRequest`](crate::model::UpdateGrokClassifierRequest)
        pub fn build(self) -> crate::model::UpdateGrokClassifierRequest {
            crate::model::UpdateGrokClassifierRequest {
                name: self.name,
                classification: self.classification,
                grok_pattern: self.grok_pattern,
                custom_patterns: self.custom_patterns,
            }
        }
    }
}
impl UpdateGrokClassifierRequest {
    /// Creates a new builder-style object to manufacture [`UpdateGrokClassifierRequest`](crate::model::UpdateGrokClassifierRequest)
    pub fn builder() -> crate::model::update_grok_classifier_request::Builder {
        crate::model::update_grok_classifier_request::Builder::default()
    }
}

/// <p>Represents a collection of related data organized in columns and rows.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Table {
    /// <p>The table name. For Hive compatibility, this must be entirely
    /// lowercase.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the database where the table metadata resides.
    /// For Hive compatibility, this must be all lowercase.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>A description of the table.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The owner of the table.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The time when the table definition was created in the Data Catalog.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that the table was updated.</p>
    pub update_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that the table was accessed. This is usually taken from HDFS, and might not
    /// be reliable.</p>
    pub last_access_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that column statistics were computed for this table.</p>
    pub last_analyzed_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The retention time for this table.</p>
    pub retention: i32,
    /// <p>A storage descriptor containing information about the physical storage
    /// of this table.</p>
    pub storage_descriptor: std::option::Option<crate::model::StorageDescriptor>,
    /// <p>A list of columns by which the table is partitioned. Only primitive
    /// types are supported as partition keys.</p>
    /// <p>When you create a table used by Amazon Athena, and you do not specify any
    /// <code>partitionKeys</code>, you must at least set the value of <code>partitionKeys</code> to
    /// an empty list. For example:</p>
    /// <p>
    /// <code>"PartitionKeys": []</code>
    /// </p>
    pub partition_keys: std::option::Option<std::vec::Vec<crate::model::Column>>,
    /// <p>If the table is a view, the original text of the view; otherwise <code>null</code>.</p>
    pub view_original_text: std::option::Option<std::string::String>,
    /// <p>If the table is a view, the expanded text of the view; otherwise <code>null</code>.</p>
    pub view_expanded_text: std::option::Option<std::string::String>,
    /// <p>The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).</p>
    pub table_type: std::option::Option<std::string::String>,
    /// <p>These key-value pairs define properties associated with the table.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The person or entity who created the table.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>Indicates whether the table has been registered with Lake Formation.</p>
    pub is_registered_with_lake_formation: bool,
    /// <p>A <code>TableIdentifier</code> structure that describes a target table for resource linking.</p>
    pub target_table: std::option::Option<crate::model::TableIdentifier>,
    /// <p>The ID of the Data Catalog in which the table resides.</p>
    pub catalog_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Table {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Table");
        formatter.field("name", &self.name);
        formatter.field("database_name", &self.database_name);
        formatter.field("description", &self.description);
        formatter.field("owner", &self.owner);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.field("last_access_time", &self.last_access_time);
        formatter.field("last_analyzed_time", &self.last_analyzed_time);
        formatter.field("retention", &self.retention);
        formatter.field("storage_descriptor", &self.storage_descriptor);
        formatter.field("partition_keys", &self.partition_keys);
        formatter.field("view_original_text", &self.view_original_text);
        formatter.field("view_expanded_text", &self.view_expanded_text);
        formatter.field("table_type", &self.table_type);
        formatter.field("parameters", &self.parameters);
        formatter.field("created_by", &self.created_by);
        formatter.field(
            "is_registered_with_lake_formation",
            &self.is_registered_with_lake_formation,
        );
        formatter.field("target_table", &self.target_table);
        formatter.field("catalog_id", &self.catalog_id);
        formatter.finish()
    }
}
/// See [`Table`](crate::model::Table)
pub mod table {
    /// A builder for [`Table`](crate::model::Table)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_access_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_analyzed_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) retention: std::option::Option<i32>,
        pub(crate) storage_descriptor: std::option::Option<crate::model::StorageDescriptor>,
        pub(crate) partition_keys: std::option::Option<std::vec::Vec<crate::model::Column>>,
        pub(crate) view_original_text: std::option::Option<std::string::String>,
        pub(crate) view_expanded_text: std::option::Option<std::string::String>,
        pub(crate) table_type: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) is_registered_with_lake_formation: std::option::Option<bool>,
        pub(crate) target_table: std::option::Option<crate::model::TableIdentifier>,
        pub(crate) catalog_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The table name. For Hive compatibility, this must be entirely
        /// lowercase.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The table name. For Hive compatibility, this must be entirely
        /// lowercase.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the database where the table metadata resides.
        /// For Hive compatibility, this must be all lowercase.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database where the table metadata resides.
        /// For Hive compatibility, this must be all lowercase.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>A description of the table.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the table.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The owner of the table.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the table.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The time when the table definition was created in the Data Catalog.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The time when the table definition was created in the Data Catalog.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The last time that the table was updated.</p>
        pub fn update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The last time that the table was updated.</p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p>The last time that the table was accessed. This is usually taken from HDFS, and might not
        /// be reliable.</p>
        pub fn last_access_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_access_time = Some(input);
            self
        }
        /// <p>The last time that the table was accessed. This is usually taken from HDFS, and might not
        /// be reliable.</p>
        pub fn set_last_access_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_access_time = input;
            self
        }
        /// <p>The last time that column statistics were computed for this table.</p>
        pub fn last_analyzed_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_analyzed_time = Some(input);
            self
        }
        /// <p>The last time that column statistics were computed for this table.</p>
        pub fn set_last_analyzed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_analyzed_time = input;
            self
        }
        /// <p>The retention time for this table.</p>
        pub fn retention(mut self, input: i32) -> Self {
            self.retention = Some(input);
            self
        }
        /// <p>The retention time for this table.</p>
        pub fn set_retention(mut self, input: std::option::Option<i32>) -> Self {
            self.retention = input;
            self
        }
        /// <p>A storage descriptor containing information about the physical storage
        /// of this table.</p>
        pub fn storage_descriptor(mut self, input: crate::model::StorageDescriptor) -> Self {
            self.storage_descriptor = Some(input);
            self
        }
        /// <p>A storage descriptor containing information about the physical storage
        /// of this table.</p>
        pub fn set_storage_descriptor(
            mut self,
            input: std::option::Option<crate::model::StorageDescriptor>,
        ) -> Self {
            self.storage_descriptor = input;
            self
        }
        /// Appends an item to `partition_keys`.
        ///
        /// To override the contents of this collection use [`set_partition_keys`](Self::set_partition_keys).
        ///
        /// <p>A list of columns by which the table is partitioned. Only primitive
        /// types are supported as partition keys.</p>
        /// <p>When you create a table used by Amazon Athena, and you do not specify any
        /// <code>partitionKeys</code>, you must at least set the value of <code>partitionKeys</code> to
        /// an empty list. For example:</p>
        /// <p>
        /// <code>"PartitionKeys": []</code>
        /// </p>
        pub fn partition_keys(mut self, input: impl Into<crate::model::Column>) -> Self {
            let mut v = self.partition_keys.unwrap_or_default();
            v.push(input.into());
            self.partition_keys = Some(v);
            self
        }
        /// <p>A list of columns by which the table is partitioned. Only primitive
        /// types are supported as partition keys.</p>
        /// <p>When you create a table used by Amazon Athena, and you do not specify any
        /// <code>partitionKeys</code>, you must at least set the value of <code>partitionKeys</code> to
        /// an empty list. For example:</p>
        /// <p>
        /// <code>"PartitionKeys": []</code>
        /// </p>
        pub fn set_partition_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Column>>,
        ) -> Self {
            self.partition_keys = input;
            self
        }
        /// <p>If the table is a view, the original text of the view; otherwise <code>null</code>.</p>
        pub fn view_original_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.view_original_text = Some(input.into());
            self
        }
        /// <p>If the table is a view, the original text of the view; otherwise <code>null</code>.</p>
        pub fn set_view_original_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.view_original_text = input;
            self
        }
        /// <p>If the table is a view, the expanded text of the view; otherwise <code>null</code>.</p>
        pub fn view_expanded_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.view_expanded_text = Some(input.into());
            self
        }
        /// <p>If the table is a view, the expanded text of the view; otherwise <code>null</code>.</p>
        pub fn set_view_expanded_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.view_expanded_text = input;
            self
        }
        /// <p>The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).</p>
        pub fn table_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_type = Some(input.into());
            self
        }
        /// <p>The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).</p>
        pub fn set_table_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_type = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>These key-value pairs define properties associated with the table.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>These key-value pairs define properties associated with the table.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The person or entity who created the table.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The person or entity who created the table.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>Indicates whether the table has been registered with Lake Formation.</p>
        pub fn is_registered_with_lake_formation(mut self, input: bool) -> Self {
            self.is_registered_with_lake_formation = Some(input);
            self
        }
        /// <p>Indicates whether the table has been registered with Lake Formation.</p>
        pub fn set_is_registered_with_lake_formation(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.is_registered_with_lake_formation = input;
            self
        }
        /// <p>A <code>TableIdentifier</code> structure that describes a target table for resource linking.</p>
        pub fn target_table(mut self, input: crate::model::TableIdentifier) -> Self {
            self.target_table = Some(input);
            self
        }
        /// <p>A <code>TableIdentifier</code> structure that describes a target table for resource linking.</p>
        pub fn set_target_table(
            mut self,
            input: std::option::Option<crate::model::TableIdentifier>,
        ) -> Self {
            self.target_table = input;
            self
        }
        /// <p>The ID of the Data Catalog in which the table resides.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the Data Catalog in which the table resides.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Table`](crate::model::Table)
        pub fn build(self) -> crate::model::Table {
            crate::model::Table {
                name: self.name,
                database_name: self.database_name,
                description: self.description,
                owner: self.owner,
                create_time: self.create_time,
                update_time: self.update_time,
                last_access_time: self.last_access_time,
                last_analyzed_time: self.last_analyzed_time,
                retention: self.retention.unwrap_or_default(),
                storage_descriptor: self.storage_descriptor,
                partition_keys: self.partition_keys,
                view_original_text: self.view_original_text,
                view_expanded_text: self.view_expanded_text,
                table_type: self.table_type,
                parameters: self.parameters,
                created_by: self.created_by,
                is_registered_with_lake_formation: self
                    .is_registered_with_lake_formation
                    .unwrap_or_default(),
                target_table: self.target_table,
                catalog_id: self.catalog_id,
            }
        }
    }
}
impl Table {
    /// Creates a new builder-style object to manufacture [`Table`](crate::model::Table)
    pub fn builder() -> crate::model::table::Builder {
        crate::model::table::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceShareType {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Foreign,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceShareType {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => ResourceShareType::All,
            "FOREIGN" => ResourceShareType::Foreign,
            other => ResourceShareType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceShareType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceShareType::from(s))
    }
}
impl ResourceShareType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceShareType::All => "ALL",
            ResourceShareType::Foreign => "FOREIGN",
            ResourceShareType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "FOREIGN"]
    }
}
impl AsRef<str> for ResourceShareType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a field to sort by and a sort order.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SortCriterion {
    /// <p>The name of the field on which to sort.</p>
    pub field_name: std::option::Option<std::string::String>,
    /// <p>An ascending or descending sort.</p>
    pub sort: std::option::Option<crate::model::Sort>,
}
impl std::fmt::Debug for SortCriterion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SortCriterion");
        formatter.field("field_name", &self.field_name);
        formatter.field("sort", &self.sort);
        formatter.finish()
    }
}
/// See [`SortCriterion`](crate::model::SortCriterion)
pub mod sort_criterion {
    /// A builder for [`SortCriterion`](crate::model::SortCriterion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_name: std::option::Option<std::string::String>,
        pub(crate) sort: std::option::Option<crate::model::Sort>,
    }
    impl Builder {
        /// <p>The name of the field on which to sort.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_name = Some(input.into());
            self
        }
        /// <p>The name of the field on which to sort.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field_name = input;
            self
        }
        /// <p>An ascending or descending sort.</p>
        pub fn sort(mut self, input: crate::model::Sort) -> Self {
            self.sort = Some(input);
            self
        }
        /// <p>An ascending or descending sort.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::Sort>) -> Self {
            self.sort = input;
            self
        }
        /// Consumes the builder and constructs a [`SortCriterion`](crate::model::SortCriterion)
        pub fn build(self) -> crate::model::SortCriterion {
            crate::model::SortCriterion {
                field_name: self.field_name,
                sort: self.sort,
            }
        }
    }
}
impl SortCriterion {
    /// Creates a new builder-style object to manufacture [`SortCriterion`](crate::model::SortCriterion)
    pub fn builder() -> crate::model::sort_criterion::Builder {
        crate::model::sort_criterion::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Sort {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Sort {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => Sort::Ascending,
            "DESC" => Sort::Descending,
            other => Sort::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Sort {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Sort::from(s))
    }
}
impl Sort {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Sort::Ascending => "ASC",
            Sort::Descending => "DESC",
            Sort::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for Sort {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines a property predicate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PropertyPredicate {
    /// <p>The key of the property.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the property.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The comparator used to compare this property to others.</p>
    pub comparator: std::option::Option<crate::model::Comparator>,
}
impl std::fmt::Debug for PropertyPredicate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PropertyPredicate");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("comparator", &self.comparator);
        formatter.finish()
    }
}
/// See [`PropertyPredicate`](crate::model::PropertyPredicate)
pub mod property_predicate {
    /// A builder for [`PropertyPredicate`](crate::model::PropertyPredicate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) comparator: std::option::Option<crate::model::Comparator>,
    }
    impl Builder {
        /// <p>The key of the property.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the property.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the property.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the property.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The comparator used to compare this property to others.</p>
        pub fn comparator(mut self, input: crate::model::Comparator) -> Self {
            self.comparator = Some(input);
            self
        }
        /// <p>The comparator used to compare this property to others.</p>
        pub fn set_comparator(
            mut self,
            input: std::option::Option<crate::model::Comparator>,
        ) -> Self {
            self.comparator = input;
            self
        }
        /// Consumes the builder and constructs a [`PropertyPredicate`](crate::model::PropertyPredicate)
        pub fn build(self) -> crate::model::PropertyPredicate {
            crate::model::PropertyPredicate {
                key: self.key,
                value: self.value,
                comparator: self.comparator,
            }
        }
    }
}
impl PropertyPredicate {
    /// Creates a new builder-style object to manufacture [`PropertyPredicate`](crate::model::PropertyPredicate)
    pub fn builder() -> crate::model::property_predicate::Builder {
        crate::model::property_predicate::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Comparator {
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanEquals,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanEquals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Comparator {
    fn from(s: &str) -> Self {
        match s {
            "EQUALS" => Comparator::Equals,
            "GREATER_THAN" => Comparator::GreaterThan,
            "GREATER_THAN_EQUALS" => Comparator::GreaterThanEquals,
            "LESS_THAN" => Comparator::LessThan,
            "LESS_THAN_EQUALS" => Comparator::LessThanEquals,
            other => Comparator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Comparator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Comparator::from(s))
    }
}
impl Comparator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Comparator::Equals => "EQUALS",
            Comparator::GreaterThan => "GREATER_THAN",
            Comparator::GreaterThanEquals => "GREATER_THAN_EQUALS",
            Comparator::LessThan => "LESS_THAN",
            Comparator::LessThanEquals => "LESS_THAN_EQUALS",
            Comparator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EQUALS",
            "GREATER_THAN",
            "GREATER_THAN_EQUALS",
            "LESS_THAN",
            "LESS_THAN_EQUALS",
        ]
    }
}
impl AsRef<str> for Comparator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines a point that a job can resume processing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobBookmarkEntry {
    /// <p>The name of the job in question.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The version of the job.</p>
    pub version: i32,
    /// <p>The run ID number.</p>
    pub run: i32,
    /// <p>The attempt ID number.</p>
    pub attempt: i32,
    /// <p>The unique run identifier associated with the previous job run.</p>
    pub previous_run_id: std::option::Option<std::string::String>,
    /// <p>The run ID number.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>The bookmark itself.</p>
    pub job_bookmark: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JobBookmarkEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobBookmarkEntry");
        formatter.field("job_name", &self.job_name);
        formatter.field("version", &self.version);
        formatter.field("run", &self.run);
        formatter.field("attempt", &self.attempt);
        formatter.field("previous_run_id", &self.previous_run_id);
        formatter.field("run_id", &self.run_id);
        formatter.field("job_bookmark", &self.job_bookmark);
        formatter.finish()
    }
}
/// See [`JobBookmarkEntry`](crate::model::JobBookmarkEntry)
pub mod job_bookmark_entry {
    /// A builder for [`JobBookmarkEntry`](crate::model::JobBookmarkEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
        pub(crate) run: std::option::Option<i32>,
        pub(crate) attempt: std::option::Option<i32>,
        pub(crate) previous_run_id: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) job_bookmark: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job in question.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the job in question.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The version of the job.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the job.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// <p>The run ID number.</p>
        pub fn run(mut self, input: i32) -> Self {
            self.run = Some(input);
            self
        }
        /// <p>The run ID number.</p>
        pub fn set_run(mut self, input: std::option::Option<i32>) -> Self {
            self.run = input;
            self
        }
        /// <p>The attempt ID number.</p>
        pub fn attempt(mut self, input: i32) -> Self {
            self.attempt = Some(input);
            self
        }
        /// <p>The attempt ID number.</p>
        pub fn set_attempt(mut self, input: std::option::Option<i32>) -> Self {
            self.attempt = input;
            self
        }
        /// <p>The unique run identifier associated with the previous job run.</p>
        pub fn previous_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.previous_run_id = Some(input.into());
            self
        }
        /// <p>The unique run identifier associated with the previous job run.</p>
        pub fn set_previous_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.previous_run_id = input;
            self
        }
        /// <p>The run ID number.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The run ID number.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>The bookmark itself.</p>
        pub fn job_bookmark(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_bookmark = Some(input.into());
            self
        }
        /// <p>The bookmark itself.</p>
        pub fn set_job_bookmark(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_bookmark = input;
            self
        }
        /// Consumes the builder and constructs a [`JobBookmarkEntry`](crate::model::JobBookmarkEntry)
        pub fn build(self) -> crate::model::JobBookmarkEntry {
            crate::model::JobBookmarkEntry {
                job_name: self.job_name,
                version: self.version.unwrap_or_default(),
                run: self.run.unwrap_or_default(),
                attempt: self.attempt.unwrap_or_default(),
                previous_run_id: self.previous_run_id,
                run_id: self.run_id,
                job_bookmark: self.job_bookmark,
            }
        }
    }
}
impl JobBookmarkEntry {
    /// Creates a new builder-style object to manufacture [`JobBookmarkEntry`](crate::model::JobBookmarkEntry)
    pub fn builder() -> crate::model::job_bookmark_entry::Builder {
        crate::model::job_bookmark_entry::Builder::default()
    }
}

/// <p>A structure containing a key value pair for metadata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetadataKeyValuePair {
    /// <p>A metadata key.</p>
    pub metadata_key: std::option::Option<std::string::String>,
    /// <p>A metadata key’s corresponding value.</p>
    pub metadata_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MetadataKeyValuePair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetadataKeyValuePair");
        formatter.field("metadata_key", &self.metadata_key);
        formatter.field("metadata_value", &self.metadata_value);
        formatter.finish()
    }
}
/// See [`MetadataKeyValuePair`](crate::model::MetadataKeyValuePair)
pub mod metadata_key_value_pair {
    /// A builder for [`MetadataKeyValuePair`](crate::model::MetadataKeyValuePair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata_key: std::option::Option<std::string::String>,
        pub(crate) metadata_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A metadata key.</p>
        pub fn metadata_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata_key = Some(input.into());
            self
        }
        /// <p>A metadata key.</p>
        pub fn set_metadata_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata_key = input;
            self
        }
        /// <p>A metadata key’s corresponding value.</p>
        pub fn metadata_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata_value = Some(input.into());
            self
        }
        /// <p>A metadata key’s corresponding value.</p>
        pub fn set_metadata_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metadata_value = input;
            self
        }
        /// Consumes the builder and constructs a [`MetadataKeyValuePair`](crate::model::MetadataKeyValuePair)
        pub fn build(self) -> crate::model::MetadataKeyValuePair {
            crate::model::MetadataKeyValuePair {
                metadata_key: self.metadata_key,
                metadata_value: self.metadata_value,
            }
        }
    }
}
impl MetadataKeyValuePair {
    /// Creates a new builder-style object to manufacture [`MetadataKeyValuePair`](crate::model::MetadataKeyValuePair)
    pub fn builder() -> crate::model::metadata_key_value_pair::Builder {
        crate::model::metadata_key_value_pair::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SchemaVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failure,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SchemaVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => SchemaVersionStatus::Available,
            "DELETING" => SchemaVersionStatus::Deleting,
            "FAILURE" => SchemaVersionStatus::Failure,
            "PENDING" => SchemaVersionStatus::Pending,
            other => SchemaVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SchemaVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SchemaVersionStatus::from(s))
    }
}
impl SchemaVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SchemaVersionStatus::Available => "AVAILABLE",
            SchemaVersionStatus::Deleting => "DELETING",
            SchemaVersionStatus::Failure => "FAILURE",
            SchemaVersionStatus::Pending => "PENDING",
            SchemaVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "FAILURE", "PENDING"]
    }
}
impl AsRef<str> for SchemaVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure containing metadata information for a schema version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetadataInfo {
    /// <p>The metadata key’s corresponding value.</p>
    pub metadata_value: std::option::Option<std::string::String>,
    /// <p>The time at which the entry was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>Other metadata belonging to the same metadata key.</p>
    pub other_metadata_value_list:
        std::option::Option<std::vec::Vec<crate::model::OtherMetadataValueListItem>>,
}
impl std::fmt::Debug for MetadataInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetadataInfo");
        formatter.field("metadata_value", &self.metadata_value);
        formatter.field("created_time", &self.created_time);
        formatter.field("other_metadata_value_list", &self.other_metadata_value_list);
        formatter.finish()
    }
}
/// See [`MetadataInfo`](crate::model::MetadataInfo)
pub mod metadata_info {
    /// A builder for [`MetadataInfo`](crate::model::MetadataInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata_value: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) other_metadata_value_list:
            std::option::Option<std::vec::Vec<crate::model::OtherMetadataValueListItem>>,
    }
    impl Builder {
        /// <p>The metadata key’s corresponding value.</p>
        pub fn metadata_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata_value = Some(input.into());
            self
        }
        /// <p>The metadata key’s corresponding value.</p>
        pub fn set_metadata_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metadata_value = input;
            self
        }
        /// <p>The time at which the entry was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The time at which the entry was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// Appends an item to `other_metadata_value_list`.
        ///
        /// To override the contents of this collection use [`set_other_metadata_value_list`](Self::set_other_metadata_value_list).
        ///
        /// <p>Other metadata belonging to the same metadata key.</p>
        pub fn other_metadata_value_list(
            mut self,
            input: impl Into<crate::model::OtherMetadataValueListItem>,
        ) -> Self {
            let mut v = self.other_metadata_value_list.unwrap_or_default();
            v.push(input.into());
            self.other_metadata_value_list = Some(v);
            self
        }
        /// <p>Other metadata belonging to the same metadata key.</p>
        pub fn set_other_metadata_value_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OtherMetadataValueListItem>>,
        ) -> Self {
            self.other_metadata_value_list = input;
            self
        }
        /// Consumes the builder and constructs a [`MetadataInfo`](crate::model::MetadataInfo)
        pub fn build(self) -> crate::model::MetadataInfo {
            crate::model::MetadataInfo {
                metadata_value: self.metadata_value,
                created_time: self.created_time,
                other_metadata_value_list: self.other_metadata_value_list,
            }
        }
    }
}
impl MetadataInfo {
    /// Creates a new builder-style object to manufacture [`MetadataInfo`](crate::model::MetadataInfo)
    pub fn builder() -> crate::model::metadata_info::Builder {
        crate::model::metadata_info::Builder::default()
    }
}

/// <p>A structure containing other metadata for a schema version belonging to the same metadata key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OtherMetadataValueListItem {
    /// <p>The metadata key’s corresponding value for the other metadata belonging to the same metadata key.</p>
    pub metadata_value: std::option::Option<std::string::String>,
    /// <p>The time at which the entry was created.</p>
    pub created_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OtherMetadataValueListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OtherMetadataValueListItem");
        formatter.field("metadata_value", &self.metadata_value);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`OtherMetadataValueListItem`](crate::model::OtherMetadataValueListItem)
pub mod other_metadata_value_list_item {
    /// A builder for [`OtherMetadataValueListItem`](crate::model::OtherMetadataValueListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata_value: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The metadata key’s corresponding value for the other metadata belonging to the same metadata key.</p>
        pub fn metadata_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata_value = Some(input.into());
            self
        }
        /// <p>The metadata key’s corresponding value for the other metadata belonging to the same metadata key.</p>
        pub fn set_metadata_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metadata_value = input;
            self
        }
        /// <p>The time at which the entry was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The time at which the entry was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OtherMetadataValueListItem`](crate::model::OtherMetadataValueListItem)
        pub fn build(self) -> crate::model::OtherMetadataValueListItem {
            crate::model::OtherMetadataValueListItem {
                metadata_value: self.metadata_value,
                created_time: self.created_time,
            }
        }
    }
}
impl OtherMetadataValueListItem {
    /// Creates a new builder-style object to manufacture [`OtherMetadataValueListItem`](crate::model::OtherMetadataValueListItem)
    pub fn builder() -> crate::model::other_metadata_value_list_item::Builder {
        crate::model::other_metadata_value_list_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnableHybridValues {
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    True,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnableHybridValues {
    fn from(s: &str) -> Self {
        match s {
            "FALSE" => EnableHybridValues::False,
            "TRUE" => EnableHybridValues::True,
            other => EnableHybridValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnableHybridValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnableHybridValues::from(s))
    }
}
impl EnableHybridValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnableHybridValues::False => "FALSE",
            EnableHybridValues::True => "TRUE",
            EnableHybridValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FALSE", "TRUE"]
    }
}
impl AsRef<str> for EnableHybridValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExistCondition {
    #[allow(missing_docs)] // documentation missing in model
    MustExist,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    NotExist,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExistCondition {
    fn from(s: &str) -> Self {
        match s {
            "MUST_EXIST" => ExistCondition::MustExist,
            "NONE" => ExistCondition::None,
            "NOT_EXIST" => ExistCondition::NotExist,
            other => ExistCondition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExistCondition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExistCondition::from(s))
    }
}
impl ExistCondition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExistCondition::MustExist => "MUST_EXIST",
            ExistCondition::None => "NONE",
            ExistCondition::NotExist => "NOT_EXIST",
            ExistCondition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MUST_EXIST", "NONE", "NOT_EXIST"]
    }
}
impl AsRef<str> for ExistCondition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains configuration information for maintaining Data Catalog security.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataCatalogEncryptionSettings {
    /// <p>Specifies the encryption-at-rest configuration for the Data Catalog.</p>
    pub encryption_at_rest: std::option::Option<crate::model::EncryptionAtRest>,
    /// <p>When connection password protection is enabled, the Data Catalog uses a customer-provided
    /// key to encrypt the password as part of <code>CreateConnection</code> or
    /// <code>UpdateConnection</code> and store it in the <code>ENCRYPTED_PASSWORD</code> field in
    /// the connection properties. You can enable catalog encryption or only password
    /// encryption.</p>
    pub connection_password_encryption:
        std::option::Option<crate::model::ConnectionPasswordEncryption>,
}
impl std::fmt::Debug for DataCatalogEncryptionSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataCatalogEncryptionSettings");
        formatter.field("encryption_at_rest", &self.encryption_at_rest);
        formatter.field(
            "connection_password_encryption",
            &self.connection_password_encryption,
        );
        formatter.finish()
    }
}
/// See [`DataCatalogEncryptionSettings`](crate::model::DataCatalogEncryptionSettings)
pub mod data_catalog_encryption_settings {
    /// A builder for [`DataCatalogEncryptionSettings`](crate::model::DataCatalogEncryptionSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_at_rest: std::option::Option<crate::model::EncryptionAtRest>,
        pub(crate) connection_password_encryption:
            std::option::Option<crate::model::ConnectionPasswordEncryption>,
    }
    impl Builder {
        /// <p>Specifies the encryption-at-rest configuration for the Data Catalog.</p>
        pub fn encryption_at_rest(mut self, input: crate::model::EncryptionAtRest) -> Self {
            self.encryption_at_rest = Some(input);
            self
        }
        /// <p>Specifies the encryption-at-rest configuration for the Data Catalog.</p>
        pub fn set_encryption_at_rest(
            mut self,
            input: std::option::Option<crate::model::EncryptionAtRest>,
        ) -> Self {
            self.encryption_at_rest = input;
            self
        }
        /// <p>When connection password protection is enabled, the Data Catalog uses a customer-provided
        /// key to encrypt the password as part of <code>CreateConnection</code> or
        /// <code>UpdateConnection</code> and store it in the <code>ENCRYPTED_PASSWORD</code> field in
        /// the connection properties. You can enable catalog encryption or only password
        /// encryption.</p>
        pub fn connection_password_encryption(
            mut self,
            input: crate::model::ConnectionPasswordEncryption,
        ) -> Self {
            self.connection_password_encryption = Some(input);
            self
        }
        /// <p>When connection password protection is enabled, the Data Catalog uses a customer-provided
        /// key to encrypt the password as part of <code>CreateConnection</code> or
        /// <code>UpdateConnection</code> and store it in the <code>ENCRYPTED_PASSWORD</code> field in
        /// the connection properties. You can enable catalog encryption or only password
        /// encryption.</p>
        pub fn set_connection_password_encryption(
            mut self,
            input: std::option::Option<crate::model::ConnectionPasswordEncryption>,
        ) -> Self {
            self.connection_password_encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`DataCatalogEncryptionSettings`](crate::model::DataCatalogEncryptionSettings)
        pub fn build(self) -> crate::model::DataCatalogEncryptionSettings {
            crate::model::DataCatalogEncryptionSettings {
                encryption_at_rest: self.encryption_at_rest,
                connection_password_encryption: self.connection_password_encryption,
            }
        }
    }
}
impl DataCatalogEncryptionSettings {
    /// Creates a new builder-style object to manufacture [`DataCatalogEncryptionSettings`](crate::model::DataCatalogEncryptionSettings)
    pub fn builder() -> crate::model::data_catalog_encryption_settings::Builder {
        crate::model::data_catalog_encryption_settings::Builder::default()
    }
}

/// <p>The data structure used by the Data Catalog to encrypt the password as part of
/// <code>CreateConnection</code> or <code>UpdateConnection</code> and store it in the
/// <code>ENCRYPTED_PASSWORD</code> field in the connection properties. You can enable catalog
/// encryption or only password encryption.</p>
///
/// <p>When a <code>CreationConnection</code> request arrives containing a password, the Data
/// Catalog first encrypts the password using your KMS key. It then encrypts the whole
/// connection object again if catalog encryption is also enabled.</p>
///
/// <p>This encryption requires that you set KMS key permissions to enable or restrict access
/// on the password key according to your security requirements. For example, you might want only
/// administrators to have decrypt permission on the password key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionPasswordEncryption {
    /// <p>When the <code>ReturnConnectionPasswordEncrypted</code> flag is set to "true", passwords remain encrypted in the responses of <code>GetConnection</code> and <code>GetConnections</code>. This encryption takes effect independently from catalog encryption. </p>
    pub return_connection_password_encrypted: bool,
    /// <p>An KMS key that is used to encrypt the connection password. </p>
    ///
    /// <p>If connection password protection is enabled, the caller of <code>CreateConnection</code>
    /// and <code>UpdateConnection</code> needs at least <code>kms:Encrypt</code> permission on the
    /// specified KMS key, to encrypt passwords before storing them in the Data Catalog. </p>
    ///
    /// <p>You can set the decrypt permission to enable or restrict access on the password key according to your security requirements.</p>
    pub aws_kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConnectionPasswordEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionPasswordEncryption");
        formatter.field(
            "return_connection_password_encrypted",
            &self.return_connection_password_encrypted,
        );
        formatter.field("aws_kms_key_id", &self.aws_kms_key_id);
        formatter.finish()
    }
}
/// See [`ConnectionPasswordEncryption`](crate::model::ConnectionPasswordEncryption)
pub mod connection_password_encryption {
    /// A builder for [`ConnectionPasswordEncryption`](crate::model::ConnectionPasswordEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) return_connection_password_encrypted: std::option::Option<bool>,
        pub(crate) aws_kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>When the <code>ReturnConnectionPasswordEncrypted</code> flag is set to "true", passwords remain encrypted in the responses of <code>GetConnection</code> and <code>GetConnections</code>. This encryption takes effect independently from catalog encryption. </p>
        pub fn return_connection_password_encrypted(mut self, input: bool) -> Self {
            self.return_connection_password_encrypted = Some(input);
            self
        }
        /// <p>When the <code>ReturnConnectionPasswordEncrypted</code> flag is set to "true", passwords remain encrypted in the responses of <code>GetConnection</code> and <code>GetConnections</code>. This encryption takes effect independently from catalog encryption. </p>
        pub fn set_return_connection_password_encrypted(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.return_connection_password_encrypted = input;
            self
        }
        /// <p>An KMS key that is used to encrypt the connection password. </p>
        ///
        /// <p>If connection password protection is enabled, the caller of <code>CreateConnection</code>
        /// and <code>UpdateConnection</code> needs at least <code>kms:Encrypt</code> permission on the
        /// specified KMS key, to encrypt passwords before storing them in the Data Catalog. </p>
        ///
        /// <p>You can set the decrypt permission to enable or restrict access on the password key according to your security requirements.</p>
        pub fn aws_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_kms_key_id = Some(input.into());
            self
        }
        /// <p>An KMS key that is used to encrypt the connection password. </p>
        ///
        /// <p>If connection password protection is enabled, the caller of <code>CreateConnection</code>
        /// and <code>UpdateConnection</code> needs at least <code>kms:Encrypt</code> permission on the
        /// specified KMS key, to encrypt passwords before storing them in the Data Catalog. </p>
        ///
        /// <p>You can set the decrypt permission to enable or restrict access on the password key according to your security requirements.</p>
        pub fn set_aws_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionPasswordEncryption`](crate::model::ConnectionPasswordEncryption)
        pub fn build(self) -> crate::model::ConnectionPasswordEncryption {
            crate::model::ConnectionPasswordEncryption {
                return_connection_password_encrypted: self
                    .return_connection_password_encrypted
                    .unwrap_or_default(),
                aws_kms_key_id: self.aws_kms_key_id,
            }
        }
    }
}
impl ConnectionPasswordEncryption {
    /// Creates a new builder-style object to manufacture [`ConnectionPasswordEncryption`](crate::model::ConnectionPasswordEncryption)
    pub fn builder() -> crate::model::connection_password_encryption::Builder {
        crate::model::connection_password_encryption::Builder::default()
    }
}

/// <p>Specifies the encryption-at-rest configuration for the Data Catalog.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionAtRest {
    /// <p>The encryption-at-rest mode for encrypting Data Catalog data.</p>
    pub catalog_encryption_mode: std::option::Option<crate::model::CatalogEncryptionMode>,
    /// <p>The ID of the KMS key to use for encryption at rest.</p>
    pub sse_aws_kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EncryptionAtRest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionAtRest");
        formatter.field("catalog_encryption_mode", &self.catalog_encryption_mode);
        formatter.field("sse_aws_kms_key_id", &self.sse_aws_kms_key_id);
        formatter.finish()
    }
}
/// See [`EncryptionAtRest`](crate::model::EncryptionAtRest)
pub mod encryption_at_rest {
    /// A builder for [`EncryptionAtRest`](crate::model::EncryptionAtRest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_encryption_mode:
            std::option::Option<crate::model::CatalogEncryptionMode>,
        pub(crate) sse_aws_kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encryption-at-rest mode for encrypting Data Catalog data.</p>
        pub fn catalog_encryption_mode(
            mut self,
            input: crate::model::CatalogEncryptionMode,
        ) -> Self {
            self.catalog_encryption_mode = Some(input);
            self
        }
        /// <p>The encryption-at-rest mode for encrypting Data Catalog data.</p>
        pub fn set_catalog_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::CatalogEncryptionMode>,
        ) -> Self {
            self.catalog_encryption_mode = input;
            self
        }
        /// <p>The ID of the KMS key to use for encryption at rest.</p>
        pub fn sse_aws_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_aws_kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key to use for encryption at rest.</p>
        pub fn set_sse_aws_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_aws_kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionAtRest`](crate::model::EncryptionAtRest)
        pub fn build(self) -> crate::model::EncryptionAtRest {
            crate::model::EncryptionAtRest {
                catalog_encryption_mode: self.catalog_encryption_mode,
                sse_aws_kms_key_id: self.sse_aws_kms_key_id,
            }
        }
    }
}
impl EncryptionAtRest {
    /// Creates a new builder-style object to manufacture [`EncryptionAtRest`](crate::model::EncryptionAtRest)
    pub fn builder() -> crate::model::encryption_at_rest::Builder {
        crate::model::encryption_at_rest::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CatalogEncryptionMode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Ssekms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CatalogEncryptionMode {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => CatalogEncryptionMode::Disabled,
            "SSE-KMS" => CatalogEncryptionMode::Ssekms,
            other => CatalogEncryptionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CatalogEncryptionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CatalogEncryptionMode::from(s))
    }
}
impl CatalogEncryptionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CatalogEncryptionMode::Disabled => "DISABLED",
            CatalogEncryptionMode::Ssekms => "SSE-KMS",
            CatalogEncryptionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "SSE-KMS"]
    }
}
impl AsRef<str> for CatalogEncryptionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object containing the details about a schema version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaVersionListItem {
    /// <p>The Amazon Resource Name (ARN) of the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the schema version.</p>
    pub schema_version_id: std::option::Option<std::string::String>,
    /// <p>The version number of the schema.</p>
    pub version_number: i64,
    /// <p>The status of the schema version.</p>
    pub status: std::option::Option<crate::model::SchemaVersionStatus>,
    /// <p>The date and time the schema version was created.</p>
    pub created_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SchemaVersionListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaVersionListItem");
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("schema_version_id", &self.schema_version_id);
        formatter.field("version_number", &self.version_number);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`SchemaVersionListItem`](crate::model::SchemaVersionListItem)
pub mod schema_version_list_item {
    /// A builder for [`SchemaVersionListItem`](crate::model::SchemaVersionListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) schema_version_id: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::SchemaVersionStatus>,
        pub(crate) created_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>The unique identifier of the schema version.</p>
        pub fn schema_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the schema version.</p>
        pub fn set_schema_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version_id = input;
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number of the schema.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The status of the schema version.</p>
        pub fn status(mut self, input: crate::model::SchemaVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the schema version.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SchemaVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time the schema version was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The date and time the schema version was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaVersionListItem`](crate::model::SchemaVersionListItem)
        pub fn build(self) -> crate::model::SchemaVersionListItem {
            crate::model::SchemaVersionListItem {
                schema_arn: self.schema_arn,
                schema_version_id: self.schema_version_id,
                version_number: self.version_number.unwrap_or_default(),
                status: self.status,
                created_time: self.created_time,
            }
        }
    }
}
impl SchemaVersionListItem {
    /// Creates a new builder-style object to manufacture [`SchemaVersionListItem`](crate::model::SchemaVersionListItem)
    pub fn builder() -> crate::model::schema_version_list_item::Builder {
        crate::model::schema_version_list_item::Builder::default()
    }
}

/// <p>An object that contains minimal details for a schema.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaListItem {
    /// <p>the name of the registry where the schema resides.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the schema.</p>
    pub schema_arn: std::option::Option<std::string::String>,
    /// <p>A description for the schema.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the schema.</p>
    pub schema_status: std::option::Option<crate::model::SchemaStatus>,
    /// <p>The date and time that a schema was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The date and time that a schema was updated.</p>
    pub updated_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SchemaListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaListItem");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("schema_arn", &self.schema_arn);
        formatter.field("description", &self.description);
        formatter.field("schema_status", &self.schema_status);
        formatter.field("created_time", &self.created_time);
        formatter.field("updated_time", &self.updated_time);
        formatter.finish()
    }
}
/// See [`SchemaListItem`](crate::model::SchemaListItem)
pub mod schema_list_item {
    /// A builder for [`SchemaListItem`](crate::model::SchemaListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) schema_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schema_status: std::option::Option<crate::model::SchemaStatus>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) updated_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>the name of the registry where the schema resides.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>the name of the registry where the schema resides.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The name of the schema.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the schema.</p>
        pub fn schema_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the schema.</p>
        pub fn set_schema_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_arn = input;
            self
        }
        /// <p>A description for the schema.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the schema.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the schema.</p>
        pub fn schema_status(mut self, input: crate::model::SchemaStatus) -> Self {
            self.schema_status = Some(input);
            self
        }
        /// <p>The status of the schema.</p>
        pub fn set_schema_status(
            mut self,
            input: std::option::Option<crate::model::SchemaStatus>,
        ) -> Self {
            self.schema_status = input;
            self
        }
        /// <p>The date and time that a schema was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The date and time that a schema was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time that a schema was updated.</p>
        pub fn updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_time = Some(input.into());
            self
        }
        /// <p>The date and time that a schema was updated.</p>
        pub fn set_updated_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaListItem`](crate::model::SchemaListItem)
        pub fn build(self) -> crate::model::SchemaListItem {
            crate::model::SchemaListItem {
                registry_name: self.registry_name,
                schema_name: self.schema_name,
                schema_arn: self.schema_arn,
                description: self.description,
                schema_status: self.schema_status,
                created_time: self.created_time,
                updated_time: self.updated_time,
            }
        }
    }
}
impl SchemaListItem {
    /// Creates a new builder-style object to manufacture [`SchemaListItem`](crate::model::SchemaListItem)
    pub fn builder() -> crate::model::schema_list_item::Builder {
        crate::model::schema_list_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SchemaStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SchemaStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => SchemaStatus::Available,
            "DELETING" => SchemaStatus::Deleting,
            "PENDING" => SchemaStatus::Pending,
            other => SchemaStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SchemaStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SchemaStatus::from(s))
    }
}
impl SchemaStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SchemaStatus::Available => "AVAILABLE",
            SchemaStatus::Deleting => "DELETING",
            SchemaStatus::Pending => "PENDING",
            SchemaStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING", "PENDING"]
    }
}
impl AsRef<str> for SchemaStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure containing the details for a registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegistryListItem {
    /// <p>The name of the registry.</p>
    pub registry_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>A description of the registry.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the registry.</p>
    pub status: std::option::Option<crate::model::RegistryStatus>,
    /// <p>The data the registry was created.</p>
    pub created_time: std::option::Option<std::string::String>,
    /// <p>The date the registry was updated.</p>
    pub updated_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RegistryListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegistryListItem");
        formatter.field("registry_name", &self.registry_name);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("updated_time", &self.updated_time);
        formatter.finish()
    }
}
/// See [`RegistryListItem`](crate::model::RegistryListItem)
pub mod registry_list_item {
    /// A builder for [`RegistryListItem`](crate::model::RegistryListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_name: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RegistryStatus>,
        pub(crate) created_time: std::option::Option<std::string::String>,
        pub(crate) updated_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the registry.</p>
        pub fn registry_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_name = Some(input.into());
            self
        }
        /// <p>The name of the registry.</p>
        pub fn set_registry_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>A description of the registry.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the registry.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the registry.</p>
        pub fn status(mut self, input: crate::model::RegistryStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the registry.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RegistryStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The data the registry was created.</p>
        pub fn created_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_time = Some(input.into());
            self
        }
        /// <p>The data the registry was created.</p>
        pub fn set_created_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date the registry was updated.</p>
        pub fn updated_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.updated_time = Some(input.into());
            self
        }
        /// <p>The date the registry was updated.</p>
        pub fn set_updated_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RegistryListItem`](crate::model::RegistryListItem)
        pub fn build(self) -> crate::model::RegistryListItem {
            crate::model::RegistryListItem {
                registry_name: self.registry_name,
                registry_arn: self.registry_arn,
                description: self.description,
                status: self.status,
                created_time: self.created_time,
                updated_time: self.updated_time,
            }
        }
    }
}
impl RegistryListItem {
    /// Creates a new builder-style object to manufacture [`RegistryListItem`](crate::model::RegistryListItem)
    pub fn builder() -> crate::model::registry_list_item::Builder {
        crate::model::registry_list_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegistryStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegistryStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => RegistryStatus::Available,
            "DELETING" => RegistryStatus::Deleting,
            other => RegistryStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegistryStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegistryStatus::from(s))
    }
}
impl RegistryStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegistryStatus::Available => "AVAILABLE",
            RegistryStatus::Deleting => "DELETING",
            RegistryStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETING"]
    }
}
impl AsRef<str> for RegistryStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The sorting criteria that are associated with the machine learning transform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformSortCriteria {
    /// <p>The column to be used in the sorting criteria that are associated with the machine
    /// learning transform.</p>
    pub column: std::option::Option<crate::model::TransformSortColumnType>,
    /// <p>The sort direction to be used in the sorting criteria that are associated with the machine
    /// learning transform.</p>
    pub sort_direction: std::option::Option<crate::model::SortDirectionType>,
}
impl std::fmt::Debug for TransformSortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformSortCriteria");
        formatter.field("column", &self.column);
        formatter.field("sort_direction", &self.sort_direction);
        formatter.finish()
    }
}
/// See [`TransformSortCriteria`](crate::model::TransformSortCriteria)
pub mod transform_sort_criteria {
    /// A builder for [`TransformSortCriteria`](crate::model::TransformSortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column: std::option::Option<crate::model::TransformSortColumnType>,
        pub(crate) sort_direction: std::option::Option<crate::model::SortDirectionType>,
    }
    impl Builder {
        /// <p>The column to be used in the sorting criteria that are associated with the machine
        /// learning transform.</p>
        pub fn column(mut self, input: crate::model::TransformSortColumnType) -> Self {
            self.column = Some(input);
            self
        }
        /// <p>The column to be used in the sorting criteria that are associated with the machine
        /// learning transform.</p>
        pub fn set_column(
            mut self,
            input: std::option::Option<crate::model::TransformSortColumnType>,
        ) -> Self {
            self.column = input;
            self
        }
        /// <p>The sort direction to be used in the sorting criteria that are associated with the machine
        /// learning transform.</p>
        pub fn sort_direction(mut self, input: crate::model::SortDirectionType) -> Self {
            self.sort_direction = Some(input);
            self
        }
        /// <p>The sort direction to be used in the sorting criteria that are associated with the machine
        /// learning transform.</p>
        pub fn set_sort_direction(
            mut self,
            input: std::option::Option<crate::model::SortDirectionType>,
        ) -> Self {
            self.sort_direction = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformSortCriteria`](crate::model::TransformSortCriteria)
        pub fn build(self) -> crate::model::TransformSortCriteria {
            crate::model::TransformSortCriteria {
                column: self.column,
                sort_direction: self.sort_direction,
            }
        }
    }
}
impl TransformSortCriteria {
    /// Creates a new builder-style object to manufacture [`TransformSortCriteria`](crate::model::TransformSortCriteria)
    pub fn builder() -> crate::model::transform_sort_criteria::Builder {
        crate::model::transform_sort_criteria::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortDirectionType {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortDirectionType {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortDirectionType::Ascending,
            "DESCENDING" => SortDirectionType::Descending,
            other => SortDirectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortDirectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortDirectionType::from(s))
    }
}
impl SortDirectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortDirectionType::Ascending => "ASCENDING",
            SortDirectionType::Descending => "DESCENDING",
            SortDirectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortDirectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransformSortColumnType {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    LastModified,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    #[allow(missing_docs)] // documentation missing in model
    TransformType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransformSortColumnType {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => TransformSortColumnType::Created,
            "LAST_MODIFIED" => TransformSortColumnType::LastModified,
            "NAME" => TransformSortColumnType::Name,
            "STATUS" => TransformSortColumnType::Status,
            "TRANSFORM_TYPE" => TransformSortColumnType::TransformType,
            other => TransformSortColumnType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransformSortColumnType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransformSortColumnType::from(s))
    }
}
impl TransformSortColumnType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransformSortColumnType::Created => "CREATED",
            TransformSortColumnType::LastModified => "LAST_MODIFIED",
            TransformSortColumnType::Name => "NAME",
            TransformSortColumnType::Status => "STATUS",
            TransformSortColumnType::TransformType => "TRANSFORM_TYPE",
            TransformSortColumnType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATED",
            "LAST_MODIFIED",
            "NAME",
            "STATUS",
            "TRANSFORM_TYPE",
        ]
    }
}
impl AsRef<str> for TransformSortColumnType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The criteria used to filter the machine learning transforms.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformFilterCriteria {
    /// <p>A unique transform name that is used to filter the machine learning transforms.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of machine learning transform that is used to filter the machine learning
    /// transforms.</p>
    pub transform_type: std::option::Option<crate::model::TransformType>,
    /// <p>Filters the list of machine learning transforms by the last known status of the transforms (to indicate whether a transform can be used or not). One of "NOT_READY", "READY", or "DELETING".</p>
    pub status: std::option::Option<crate::model::TransformStatusType>,
    /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
    pub glue_version: std::option::Option<std::string::String>,
    /// <p>The time and date before which the transforms were created.</p>
    pub created_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time and date after which the transforms were created.</p>
    pub created_after: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filter on transforms last modified before this date.</p>
    pub last_modified_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filter on transforms last modified after this date.</p>
    pub last_modified_after: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filters on datasets with a specific schema. The <code>Map<Column, Type></code>
    /// object is an array of key-value pairs representing the schema this transform accepts, where
    /// <code>Column</code> is the name of a column, and <code>Type</code> is the type of the data
    /// such as an integer or string. Has an upper bound of 100 columns.</p>
    pub schema: std::option::Option<std::vec::Vec<crate::model::SchemaColumn>>,
}
impl std::fmt::Debug for TransformFilterCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformFilterCriteria");
        formatter.field("name", &self.name);
        formatter.field("transform_type", &self.transform_type);
        formatter.field("status", &self.status);
        formatter.field("glue_version", &self.glue_version);
        formatter.field("created_before", &self.created_before);
        formatter.field("created_after", &self.created_after);
        formatter.field("last_modified_before", &self.last_modified_before);
        formatter.field("last_modified_after", &self.last_modified_after);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}
/// See [`TransformFilterCriteria`](crate::model::TransformFilterCriteria)
pub mod transform_filter_criteria {
    /// A builder for [`TransformFilterCriteria`](crate::model::TransformFilterCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) transform_type: std::option::Option<crate::model::TransformType>,
        pub(crate) status: std::option::Option<crate::model::TransformStatusType>,
        pub(crate) glue_version: std::option::Option<std::string::String>,
        pub(crate) created_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_after: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_after: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) schema: std::option::Option<std::vec::Vec<crate::model::SchemaColumn>>,
    }
    impl Builder {
        /// <p>A unique transform name that is used to filter the machine learning transforms.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique transform name that is used to filter the machine learning transforms.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of machine learning transform that is used to filter the machine learning
        /// transforms.</p>
        pub fn transform_type(mut self, input: crate::model::TransformType) -> Self {
            self.transform_type = Some(input);
            self
        }
        /// <p>The type of machine learning transform that is used to filter the machine learning
        /// transforms.</p>
        pub fn set_transform_type(
            mut self,
            input: std::option::Option<crate::model::TransformType>,
        ) -> Self {
            self.transform_type = input;
            self
        }
        /// <p>Filters the list of machine learning transforms by the last known status of the transforms (to indicate whether a transform can be used or not). One of "NOT_READY", "READY", or "DELETING".</p>
        pub fn status(mut self, input: crate::model::TransformStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Filters the list of machine learning transforms by the last known status of the transforms (to indicate whether a transform can be used or not). One of "NOT_READY", "READY", or "DELETING".</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TransformStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
        pub fn glue_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.glue_version = Some(input.into());
            self
        }
        /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.glue_version = input;
            self
        }
        /// <p>The time and date before which the transforms were created.</p>
        pub fn created_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_before = Some(input);
            self
        }
        /// <p>The time and date before which the transforms were created.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_before = input;
            self
        }
        /// <p>The time and date after which the transforms were created.</p>
        pub fn created_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_after = Some(input);
            self
        }
        /// <p>The time and date after which the transforms were created.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_after = input;
            self
        }
        /// <p>Filter on transforms last modified before this date.</p>
        pub fn last_modified_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_before = Some(input);
            self
        }
        /// <p>Filter on transforms last modified before this date.</p>
        pub fn set_last_modified_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_before = input;
            self
        }
        /// <p>Filter on transforms last modified after this date.</p>
        pub fn last_modified_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_after = Some(input);
            self
        }
        /// <p>Filter on transforms last modified after this date.</p>
        pub fn set_last_modified_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_after = input;
            self
        }
        /// Appends an item to `schema`.
        ///
        /// To override the contents of this collection use [`set_schema`](Self::set_schema).
        ///
        /// <p>Filters on datasets with a specific schema. The <code>Map<Column, Type></code>
        /// object is an array of key-value pairs representing the schema this transform accepts, where
        /// <code>Column</code> is the name of a column, and <code>Type</code> is the type of the data
        /// such as an integer or string. Has an upper bound of 100 columns.</p>
        pub fn schema(mut self, input: impl Into<crate::model::SchemaColumn>) -> Self {
            let mut v = self.schema.unwrap_or_default();
            v.push(input.into());
            self.schema = Some(v);
            self
        }
        /// <p>Filters on datasets with a specific schema. The <code>Map<Column, Type></code>
        /// object is an array of key-value pairs representing the schema this transform accepts, where
        /// <code>Column</code> is the name of a column, and <code>Type</code> is the type of the data
        /// such as an integer or string. Has an upper bound of 100 columns.</p>
        pub fn set_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaColumn>>,
        ) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformFilterCriteria`](crate::model::TransformFilterCriteria)
        pub fn build(self) -> crate::model::TransformFilterCriteria {
            crate::model::TransformFilterCriteria {
                name: self.name,
                transform_type: self.transform_type,
                status: self.status,
                glue_version: self.glue_version,
                created_before: self.created_before,
                created_after: self.created_after,
                last_modified_before: self.last_modified_before,
                last_modified_after: self.last_modified_after,
                schema: self.schema,
            }
        }
    }
}
impl TransformFilterCriteria {
    /// Creates a new builder-style object to manufacture [`TransformFilterCriteria`](crate::model::TransformFilterCriteria)
    pub fn builder() -> crate::model::transform_filter_criteria::Builder {
        crate::model::transform_filter_criteria::Builder::default()
    }
}

/// <p>A key-value pair representing a column and data type that this transform can
/// run against. The <code>Schema</code> parameter of the <code>MLTransform</code> may contain up to 100 of these structures.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SchemaColumn {
    /// <p>The name of the column.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of data in the column.</p>
    pub data_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SchemaColumn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SchemaColumn");
        formatter.field("name", &self.name);
        formatter.field("data_type", &self.data_type);
        formatter.finish()
    }
}
/// See [`SchemaColumn`](crate::model::SchemaColumn)
pub mod schema_column {
    /// A builder for [`SchemaColumn`](crate::model::SchemaColumn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the column.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of data in the column.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The type of data in the column.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SchemaColumn`](crate::model::SchemaColumn)
        pub fn build(self) -> crate::model::SchemaColumn {
            crate::model::SchemaColumn {
                name: self.name,
                data_type: self.data_type,
            }
        }
    }
}
impl SchemaColumn {
    /// Creates a new builder-style object to manufacture [`SchemaColumn`](crate::model::SchemaColumn)
    pub fn builder() -> crate::model::schema_column::Builder {
        crate::model::schema_column::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransformStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    NotReady,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransformStatusType {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => TransformStatusType::Deleting,
            "NOT_READY" => TransformStatusType::NotReady,
            "READY" => TransformStatusType::Ready,
            other => TransformStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransformStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransformStatusType::from(s))
    }
}
impl TransformStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransformStatusType::Deleting => "DELETING",
            TransformStatusType::NotReady => "NOT_READY",
            TransformStatusType::Ready => "READY",
            TransformStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETING", "NOT_READY", "READY"]
    }
}
impl AsRef<str> for TransformStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A workflow run is an execution of a workflow providing all the runtime information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowRun {
    /// <p>Name of the workflow that was run.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of this workflow run.</p>
    pub workflow_run_id: std::option::Option<std::string::String>,
    /// <p>The ID of the previous workflow run.</p>
    pub previous_run_id: std::option::Option<std::string::String>,
    /// <p>The workflow run properties which were set during the run.</p>
    pub workflow_run_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The date and time when the workflow run was started.</p>
    pub started_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the workflow run completed.</p>
    pub completed_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the workflow run.</p>
    pub status: std::option::Option<crate::model::WorkflowRunStatus>,
    /// <p>This error message describes any error that may have occurred in starting the workflow run. Currently the only error message is "Concurrent runs exceeded for workflow: <code>foo</code>."</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The statistics of the run.</p>
    pub statistics: std::option::Option<crate::model::WorkflowRunStatistics>,
    /// <p>The graph representing all the Glue components that belong to the workflow as nodes and directed
    /// connections between them as edges.</p>
    pub graph: std::option::Option<crate::model::WorkflowGraph>,
    /// <p>The batch condition that started the workflow run.</p>
    pub starting_event_batch_condition:
        std::option::Option<crate::model::StartingEventBatchCondition>,
}
impl std::fmt::Debug for WorkflowRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowRun");
        formatter.field("name", &self.name);
        formatter.field("workflow_run_id", &self.workflow_run_id);
        formatter.field("previous_run_id", &self.previous_run_id);
        formatter.field("workflow_run_properties", &self.workflow_run_properties);
        formatter.field("started_on", &self.started_on);
        formatter.field("completed_on", &self.completed_on);
        formatter.field("status", &self.status);
        formatter.field("error_message", &self.error_message);
        formatter.field("statistics", &self.statistics);
        formatter.field("graph", &self.graph);
        formatter.field(
            "starting_event_batch_condition",
            &self.starting_event_batch_condition,
        );
        formatter.finish()
    }
}
/// See [`WorkflowRun`](crate::model::WorkflowRun)
pub mod workflow_run {
    /// A builder for [`WorkflowRun`](crate::model::WorkflowRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) workflow_run_id: std::option::Option<std::string::String>,
        pub(crate) previous_run_id: std::option::Option<std::string::String>,
        pub(crate) workflow_run_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) started_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::WorkflowRunStatus>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) statistics: std::option::Option<crate::model::WorkflowRunStatistics>,
        pub(crate) graph: std::option::Option<crate::model::WorkflowGraph>,
        pub(crate) starting_event_batch_condition:
            std::option::Option<crate::model::StartingEventBatchCondition>,
    }
    impl Builder {
        /// <p>Name of the workflow that was run.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the workflow that was run.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of this workflow run.</p>
        pub fn workflow_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_run_id = Some(input.into());
            self
        }
        /// <p>The ID of this workflow run.</p>
        pub fn set_workflow_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workflow_run_id = input;
            self
        }
        /// <p>The ID of the previous workflow run.</p>
        pub fn previous_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.previous_run_id = Some(input.into());
            self
        }
        /// <p>The ID of the previous workflow run.</p>
        pub fn set_previous_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.previous_run_id = input;
            self
        }
        /// Adds a key-value pair to `workflow_run_properties`.
        ///
        /// To override the contents of this collection use [`set_workflow_run_properties`](Self::set_workflow_run_properties).
        ///
        /// <p>The workflow run properties which were set during the run.</p>
        pub fn workflow_run_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.workflow_run_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.workflow_run_properties = Some(hash_map);
            self
        }
        /// <p>The workflow run properties which were set during the run.</p>
        pub fn set_workflow_run_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.workflow_run_properties = input;
            self
        }
        /// <p>The date and time when the workflow run was started.</p>
        pub fn started_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_on = Some(input);
            self
        }
        /// <p>The date and time when the workflow run was started.</p>
        pub fn set_started_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_on = input;
            self
        }
        /// <p>The date and time when the workflow run completed.</p>
        pub fn completed_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_on = Some(input);
            self
        }
        /// <p>The date and time when the workflow run completed.</p>
        pub fn set_completed_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_on = input;
            self
        }
        /// <p>The status of the workflow run.</p>
        pub fn status(mut self, input: crate::model::WorkflowRunStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the workflow run.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorkflowRunStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>This error message describes any error that may have occurred in starting the workflow run. Currently the only error message is "Concurrent runs exceeded for workflow: <code>foo</code>."</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>This error message describes any error that may have occurred in starting the workflow run. Currently the only error message is "Concurrent runs exceeded for workflow: <code>foo</code>."</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The statistics of the run.</p>
        pub fn statistics(mut self, input: crate::model::WorkflowRunStatistics) -> Self {
            self.statistics = Some(input);
            self
        }
        /// <p>The statistics of the run.</p>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<crate::model::WorkflowRunStatistics>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// <p>The graph representing all the Glue components that belong to the workflow as nodes and directed
        /// connections between them as edges.</p>
        pub fn graph(mut self, input: crate::model::WorkflowGraph) -> Self {
            self.graph = Some(input);
            self
        }
        /// <p>The graph representing all the Glue components that belong to the workflow as nodes and directed
        /// connections between them as edges.</p>
        pub fn set_graph(
            mut self,
            input: std::option::Option<crate::model::WorkflowGraph>,
        ) -> Self {
            self.graph = input;
            self
        }
        /// <p>The batch condition that started the workflow run.</p>
        pub fn starting_event_batch_condition(
            mut self,
            input: crate::model::StartingEventBatchCondition,
        ) -> Self {
            self.starting_event_batch_condition = Some(input);
            self
        }
        /// <p>The batch condition that started the workflow run.</p>
        pub fn set_starting_event_batch_condition(
            mut self,
            input: std::option::Option<crate::model::StartingEventBatchCondition>,
        ) -> Self {
            self.starting_event_batch_condition = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowRun`](crate::model::WorkflowRun)
        pub fn build(self) -> crate::model::WorkflowRun {
            crate::model::WorkflowRun {
                name: self.name,
                workflow_run_id: self.workflow_run_id,
                previous_run_id: self.previous_run_id,
                workflow_run_properties: self.workflow_run_properties,
                started_on: self.started_on,
                completed_on: self.completed_on,
                status: self.status,
                error_message: self.error_message,
                statistics: self.statistics,
                graph: self.graph,
                starting_event_batch_condition: self.starting_event_batch_condition,
            }
        }
    }
}
impl WorkflowRun {
    /// Creates a new builder-style object to manufacture [`WorkflowRun`](crate::model::WorkflowRun)
    pub fn builder() -> crate::model::workflow_run::Builder {
        crate::model::workflow_run::Builder::default()
    }
}

/// <p>The batch condition that started the workflow run. Either the number of events in the batch size arrived,
/// in which case the BatchSize member is non-zero, or the batch window expired, in which case the BatchWindow
/// member is non-zero.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartingEventBatchCondition {
    /// <p>Number of events in the batch.</p>
    pub batch_size: std::option::Option<i32>,
    /// <p>Duration of the batch window in seconds.</p>
    pub batch_window: std::option::Option<i32>,
}
impl std::fmt::Debug for StartingEventBatchCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartingEventBatchCondition");
        formatter.field("batch_size", &self.batch_size);
        formatter.field("batch_window", &self.batch_window);
        formatter.finish()
    }
}
/// See [`StartingEventBatchCondition`](crate::model::StartingEventBatchCondition)
pub mod starting_event_batch_condition {
    /// A builder for [`StartingEventBatchCondition`](crate::model::StartingEventBatchCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_size: std::option::Option<i32>,
        pub(crate) batch_window: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Number of events in the batch.</p>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>Number of events in the batch.</p>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// <p>Duration of the batch window in seconds.</p>
        pub fn batch_window(mut self, input: i32) -> Self {
            self.batch_window = Some(input);
            self
        }
        /// <p>Duration of the batch window in seconds.</p>
        pub fn set_batch_window(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_window = input;
            self
        }
        /// Consumes the builder and constructs a [`StartingEventBatchCondition`](crate::model::StartingEventBatchCondition)
        pub fn build(self) -> crate::model::StartingEventBatchCondition {
            crate::model::StartingEventBatchCondition {
                batch_size: self.batch_size,
                batch_window: self.batch_window,
            }
        }
    }
}
impl StartingEventBatchCondition {
    /// Creates a new builder-style object to manufacture [`StartingEventBatchCondition`](crate::model::StartingEventBatchCondition)
    pub fn builder() -> crate::model::starting_event_batch_condition::Builder {
        crate::model::starting_event_batch_condition::Builder::default()
    }
}

/// <p>A workflow graph represents the complete workflow containing all the Glue components present in the
/// workflow and all the directed connections between them.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowGraph {
    /// <p>A list of the the Glue components belong to the workflow represented as nodes.</p>
    pub nodes: std::option::Option<std::vec::Vec<crate::model::Node>>,
    /// <p>A list of all the directed connections between the nodes belonging to the workflow.</p>
    pub edges: std::option::Option<std::vec::Vec<crate::model::Edge>>,
}
impl std::fmt::Debug for WorkflowGraph {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowGraph");
        formatter.field("nodes", &self.nodes);
        formatter.field("edges", &self.edges);
        formatter.finish()
    }
}
/// See [`WorkflowGraph`](crate::model::WorkflowGraph)
pub mod workflow_graph {
    /// A builder for [`WorkflowGraph`](crate::model::WorkflowGraph)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nodes: std::option::Option<std::vec::Vec<crate::model::Node>>,
        pub(crate) edges: std::option::Option<std::vec::Vec<crate::model::Edge>>,
    }
    impl Builder {
        /// Appends an item to `nodes`.
        ///
        /// To override the contents of this collection use [`set_nodes`](Self::set_nodes).
        ///
        /// <p>A list of the the Glue components belong to the workflow represented as nodes.</p>
        pub fn nodes(mut self, input: impl Into<crate::model::Node>) -> Self {
            let mut v = self.nodes.unwrap_or_default();
            v.push(input.into());
            self.nodes = Some(v);
            self
        }
        /// <p>A list of the the Glue components belong to the workflow represented as nodes.</p>
        pub fn set_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Node>>,
        ) -> Self {
            self.nodes = input;
            self
        }
        /// Appends an item to `edges`.
        ///
        /// To override the contents of this collection use [`set_edges`](Self::set_edges).
        ///
        /// <p>A list of all the directed connections between the nodes belonging to the workflow.</p>
        pub fn edges(mut self, input: impl Into<crate::model::Edge>) -> Self {
            let mut v = self.edges.unwrap_or_default();
            v.push(input.into());
            self.edges = Some(v);
            self
        }
        /// <p>A list of all the directed connections between the nodes belonging to the workflow.</p>
        pub fn set_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Edge>>,
        ) -> Self {
            self.edges = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowGraph`](crate::model::WorkflowGraph)
        pub fn build(self) -> crate::model::WorkflowGraph {
            crate::model::WorkflowGraph {
                nodes: self.nodes,
                edges: self.edges,
            }
        }
    }
}
impl WorkflowGraph {
    /// Creates a new builder-style object to manufacture [`WorkflowGraph`](crate::model::WorkflowGraph)
    pub fn builder() -> crate::model::workflow_graph::Builder {
        crate::model::workflow_graph::Builder::default()
    }
}

/// <p>An edge represents a directed connection between two components
/// on a workflow graph.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Edge {
    /// <p>The unique of the node within the workflow where the edge starts.</p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p>The unique of the node within the workflow where the edge ends.</p>
    pub destination_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Edge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Edge");
        formatter.field("source_id", &self.source_id);
        formatter.field("destination_id", &self.destination_id);
        formatter.finish()
    }
}
/// See [`Edge`](crate::model::Edge)
pub mod edge {
    /// A builder for [`Edge`](crate::model::Edge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) destination_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique of the node within the workflow where the edge starts.</p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p>The unique of the node within the workflow where the edge starts.</p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p>The unique of the node within the workflow where the edge ends.</p>
        pub fn destination_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_id = Some(input.into());
            self
        }
        /// <p>The unique of the node within the workflow where the edge ends.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Edge`](crate::model::Edge)
        pub fn build(self) -> crate::model::Edge {
            crate::model::Edge {
                source_id: self.source_id,
                destination_id: self.destination_id,
            }
        }
    }
}
impl Edge {
    /// Creates a new builder-style object to manufacture [`Edge`](crate::model::Edge)
    pub fn builder() -> crate::model::edge::Builder {
        crate::model::edge::Builder::default()
    }
}

/// <p>A node represents an Glue component (trigger, crawler, or job) on a workflow graph.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Node {
    /// <p>The type of Glue component represented by the node.</p>
    pub r#type: std::option::Option<crate::model::NodeType>,
    /// <p>The name of the Glue component represented by the node.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique Id assigned to the node within the workflow.</p>
    pub unique_id: std::option::Option<std::string::String>,
    /// <p>Details of the Trigger when the node represents a Trigger.</p>
    pub trigger_details: std::option::Option<crate::model::TriggerNodeDetails>,
    /// <p>Details of the Job when the node represents a Job.</p>
    pub job_details: std::option::Option<crate::model::JobNodeDetails>,
    /// <p>Details of the crawler when the node represents a crawler.</p>
    pub crawler_details: std::option::Option<crate::model::CrawlerNodeDetails>,
}
impl std::fmt::Debug for Node {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Node");
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("unique_id", &self.unique_id);
        formatter.field("trigger_details", &self.trigger_details);
        formatter.field("job_details", &self.job_details);
        formatter.field("crawler_details", &self.crawler_details);
        formatter.finish()
    }
}
/// See [`Node`](crate::model::Node)
pub mod node {
    /// A builder for [`Node`](crate::model::Node)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::NodeType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) unique_id: std::option::Option<std::string::String>,
        pub(crate) trigger_details: std::option::Option<crate::model::TriggerNodeDetails>,
        pub(crate) job_details: std::option::Option<crate::model::JobNodeDetails>,
        pub(crate) crawler_details: std::option::Option<crate::model::CrawlerNodeDetails>,
    }
    impl Builder {
        /// <p>The type of Glue component represented by the node.</p>
        pub fn r#type(mut self, input: crate::model::NodeType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of Glue component represented by the node.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::NodeType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the Glue component represented by the node.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Glue component represented by the node.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique Id assigned to the node within the workflow.</p>
        pub fn unique_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.unique_id = Some(input.into());
            self
        }
        /// <p>The unique Id assigned to the node within the workflow.</p>
        pub fn set_unique_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unique_id = input;
            self
        }
        /// <p>Details of the Trigger when the node represents a Trigger.</p>
        pub fn trigger_details(mut self, input: crate::model::TriggerNodeDetails) -> Self {
            self.trigger_details = Some(input);
            self
        }
        /// <p>Details of the Trigger when the node represents a Trigger.</p>
        pub fn set_trigger_details(
            mut self,
            input: std::option::Option<crate::model::TriggerNodeDetails>,
        ) -> Self {
            self.trigger_details = input;
            self
        }
        /// <p>Details of the Job when the node represents a Job.</p>
        pub fn job_details(mut self, input: crate::model::JobNodeDetails) -> Self {
            self.job_details = Some(input);
            self
        }
        /// <p>Details of the Job when the node represents a Job.</p>
        pub fn set_job_details(
            mut self,
            input: std::option::Option<crate::model::JobNodeDetails>,
        ) -> Self {
            self.job_details = input;
            self
        }
        /// <p>Details of the crawler when the node represents a crawler.</p>
        pub fn crawler_details(mut self, input: crate::model::CrawlerNodeDetails) -> Self {
            self.crawler_details = Some(input);
            self
        }
        /// <p>Details of the crawler when the node represents a crawler.</p>
        pub fn set_crawler_details(
            mut self,
            input: std::option::Option<crate::model::CrawlerNodeDetails>,
        ) -> Self {
            self.crawler_details = input;
            self
        }
        /// Consumes the builder and constructs a [`Node`](crate::model::Node)
        pub fn build(self) -> crate::model::Node {
            crate::model::Node {
                r#type: self.r#type,
                name: self.name,
                unique_id: self.unique_id,
                trigger_details: self.trigger_details,
                job_details: self.job_details,
                crawler_details: self.crawler_details,
            }
        }
    }
}
impl Node {
    /// Creates a new builder-style object to manufacture [`Node`](crate::model::Node)
    pub fn builder() -> crate::model::node::Builder {
        crate::model::node::Builder::default()
    }
}

/// <p>The details of a Crawler node present in the workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrawlerNodeDetails {
    /// <p>A list of crawls represented by the crawl node.</p>
    pub crawls: std::option::Option<std::vec::Vec<crate::model::Crawl>>,
}
impl std::fmt::Debug for CrawlerNodeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrawlerNodeDetails");
        formatter.field("crawls", &self.crawls);
        formatter.finish()
    }
}
/// See [`CrawlerNodeDetails`](crate::model::CrawlerNodeDetails)
pub mod crawler_node_details {
    /// A builder for [`CrawlerNodeDetails`](crate::model::CrawlerNodeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawls: std::option::Option<std::vec::Vec<crate::model::Crawl>>,
    }
    impl Builder {
        /// Appends an item to `crawls`.
        ///
        /// To override the contents of this collection use [`set_crawls`](Self::set_crawls).
        ///
        /// <p>A list of crawls represented by the crawl node.</p>
        pub fn crawls(mut self, input: impl Into<crate::model::Crawl>) -> Self {
            let mut v = self.crawls.unwrap_or_default();
            v.push(input.into());
            self.crawls = Some(v);
            self
        }
        /// <p>A list of crawls represented by the crawl node.</p>
        pub fn set_crawls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Crawl>>,
        ) -> Self {
            self.crawls = input;
            self
        }
        /// Consumes the builder and constructs a [`CrawlerNodeDetails`](crate::model::CrawlerNodeDetails)
        pub fn build(self) -> crate::model::CrawlerNodeDetails {
            crate::model::CrawlerNodeDetails {
                crawls: self.crawls,
            }
        }
    }
}
impl CrawlerNodeDetails {
    /// Creates a new builder-style object to manufacture [`CrawlerNodeDetails`](crate::model::CrawlerNodeDetails)
    pub fn builder() -> crate::model::crawler_node_details::Builder {
        crate::model::crawler_node_details::Builder::default()
    }
}

/// <p>The details of a crawl in the workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Crawl {
    /// <p>The state of the crawler.</p>
    pub state: std::option::Option<crate::model::CrawlState>,
    /// <p>The date and time on which the crawl started.</p>
    pub started_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time on which the crawl completed.</p>
    pub completed_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The error message associated with the crawl.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The log group associated with the crawl.</p>
    pub log_group: std::option::Option<std::string::String>,
    /// <p>The log stream associated with the crawl.</p>
    pub log_stream: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Crawl {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Crawl");
        formatter.field("state", &self.state);
        formatter.field("started_on", &self.started_on);
        formatter.field("completed_on", &self.completed_on);
        formatter.field("error_message", &self.error_message);
        formatter.field("log_group", &self.log_group);
        formatter.field("log_stream", &self.log_stream);
        formatter.finish()
    }
}
/// See [`Crawl`](crate::model::Crawl)
pub mod crawl {
    /// A builder for [`Crawl`](crate::model::Crawl)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::CrawlState>,
        pub(crate) started_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) log_group: std::option::Option<std::string::String>,
        pub(crate) log_stream: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state of the crawler.</p>
        pub fn state(mut self, input: crate::model::CrawlState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the crawler.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::CrawlState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The date and time on which the crawl started.</p>
        pub fn started_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_on = Some(input);
            self
        }
        /// <p>The date and time on which the crawl started.</p>
        pub fn set_started_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_on = input;
            self
        }
        /// <p>The date and time on which the crawl completed.</p>
        pub fn completed_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_on = Some(input);
            self
        }
        /// <p>The date and time on which the crawl completed.</p>
        pub fn set_completed_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_on = input;
            self
        }
        /// <p>The error message associated with the crawl.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message associated with the crawl.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The log group associated with the crawl.</p>
        pub fn log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group = Some(input.into());
            self
        }
        /// <p>The log group associated with the crawl.</p>
        pub fn set_log_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_group = input;
            self
        }
        /// <p>The log stream associated with the crawl.</p>
        pub fn log_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream = Some(input.into());
            self
        }
        /// <p>The log stream associated with the crawl.</p>
        pub fn set_log_stream(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_stream = input;
            self
        }
        /// Consumes the builder and constructs a [`Crawl`](crate::model::Crawl)
        pub fn build(self) -> crate::model::Crawl {
            crate::model::Crawl {
                state: self.state,
                started_on: self.started_on,
                completed_on: self.completed_on,
                error_message: self.error_message,
                log_group: self.log_group,
                log_stream: self.log_stream,
            }
        }
    }
}
impl Crawl {
    /// Creates a new builder-style object to manufacture [`Crawl`](crate::model::Crawl)
    pub fn builder() -> crate::model::crawl::Builder {
        crate::model::crawl::Builder::default()
    }
}

/// <p>The details of a Job node present in the workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobNodeDetails {
    /// <p>The information for the job runs represented by the job node.</p>
    pub job_runs: std::option::Option<std::vec::Vec<crate::model::JobRun>>,
}
impl std::fmt::Debug for JobNodeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobNodeDetails");
        formatter.field("job_runs", &self.job_runs);
        formatter.finish()
    }
}
/// See [`JobNodeDetails`](crate::model::JobNodeDetails)
pub mod job_node_details {
    /// A builder for [`JobNodeDetails`](crate::model::JobNodeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_runs: std::option::Option<std::vec::Vec<crate::model::JobRun>>,
    }
    impl Builder {
        /// Appends an item to `job_runs`.
        ///
        /// To override the contents of this collection use [`set_job_runs`](Self::set_job_runs).
        ///
        /// <p>The information for the job runs represented by the job node.</p>
        pub fn job_runs(mut self, input: impl Into<crate::model::JobRun>) -> Self {
            let mut v = self.job_runs.unwrap_or_default();
            v.push(input.into());
            self.job_runs = Some(v);
            self
        }
        /// <p>The information for the job runs represented by the job node.</p>
        pub fn set_job_runs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobRun>>,
        ) -> Self {
            self.job_runs = input;
            self
        }
        /// Consumes the builder and constructs a [`JobNodeDetails`](crate::model::JobNodeDetails)
        pub fn build(self) -> crate::model::JobNodeDetails {
            crate::model::JobNodeDetails {
                job_runs: self.job_runs,
            }
        }
    }
}
impl JobNodeDetails {
    /// Creates a new builder-style object to manufacture [`JobNodeDetails`](crate::model::JobNodeDetails)
    pub fn builder() -> crate::model::job_node_details::Builder {
        crate::model::job_node_details::Builder::default()
    }
}

/// <p>Contains information about a job run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobRun {
    /// <p>The ID of this job run.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The number of the attempt to run this job.</p>
    pub attempt: i32,
    /// <p>The ID of the previous run of this job. For example, the <code>JobRunId</code> specified
    /// in the <code>StartJobRun</code> action.</p>
    pub previous_run_id: std::option::Option<std::string::String>,
    /// <p>The name of the trigger that started this job run.</p>
    pub trigger_name: std::option::Option<std::string::String>,
    /// <p>The name of the job definition being used in this run.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The date and time at which this job run was started.</p>
    pub started_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that this job run was modified.</p>
    pub last_modified_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that this job run completed.</p>
    pub completed_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current state of the job run. For more information about the statuses of jobs that have terminated abnormally, see <a href="https://docs.aws.amazon.com/glue/latest/dg/job-run-statuses.html">Glue Job Run Statuses</a>.</p>
    pub job_run_state: std::option::Option<crate::model::JobRunState>,
    /// <p>The job arguments associated with this run. For this job run, they replace the default arguments set in the job definition itself.</p>
    /// <p>You can specify arguments here that your own job-execution script
    /// consumes, as well as arguments that Glue itself consumes.</p>
    /// <p>For information about how to specify and consume your own job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
    /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
    pub arguments:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>An error message associated with this job run.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>A list of predecessors to this job run.</p>
    pub predecessor_runs: std::option::Option<std::vec::Vec<crate::model::Predecessor>>,
    /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
    ///
    /// <p>The number of Glue data processing units (DPUs) allocated to this JobRun.
    /// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative measure
    /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
    /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
    /// pricing page</a>.</p>
    pub allocated_capacity: i32,
    /// <p>The amount of time (in seconds) that the job run consumed resources.</p>
    pub execution_time: i32,
    /// <p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can
    /// consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
    /// is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
    /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
    /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
    /// pricing page</a>.</p>
    ///
    /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>
    ///
    /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
    /// running a Python shell job or an Apache Spark ETL job:</p>
    /// <ul>
    /// <li>
    /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
    /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
    /// </li>
    /// <li>
    /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
    /// </li>
    /// </ul>
    pub max_capacity: std::option::Option<f64>,
    /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
    /// <ul>
    /// <li>
    /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
    /// </li>
    /// </ul>
    pub worker_type: std::option::Option<crate::model::WorkerType>,
    /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
    ///
    /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
    pub number_of_workers: std::option::Option<i32>,
    /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this job
    /// run.</p>
    pub security_configuration: std::option::Option<std::string::String>,
    /// <p>The name of the log group for secure logging that can be server-side encrypted in Amazon
    /// CloudWatch using KMS. This name can be <code>/aws-glue/jobs/</code>, in which case the
    /// default encryption is <code>NONE</code>. If you add a role name and
    /// <code>SecurityConfiguration</code> name (in other words,
    /// <code>/aws-glue/jobs-yourRoleName-yourSecurityConfigurationName/</code>), then that security
    /// configuration is used to encrypt the log group.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies configuration properties of a job run notification.</p>
    pub notification_property: std::option::Option<crate::model::NotificationProperty>,
    /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
    ///
    /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
    ///
    /// <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>
    pub glue_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JobRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobRun");
        formatter.field("id", &self.id);
        formatter.field("attempt", &self.attempt);
        formatter.field("previous_run_id", &self.previous_run_id);
        formatter.field("trigger_name", &self.trigger_name);
        formatter.field("job_name", &self.job_name);
        formatter.field("started_on", &self.started_on);
        formatter.field("last_modified_on", &self.last_modified_on);
        formatter.field("completed_on", &self.completed_on);
        formatter.field("job_run_state", &self.job_run_state);
        formatter.field("arguments", &self.arguments);
        formatter.field("error_message", &self.error_message);
        formatter.field("predecessor_runs", &self.predecessor_runs);
        formatter.field("allocated_capacity", &self.allocated_capacity);
        formatter.field("execution_time", &self.execution_time);
        formatter.field("timeout", &self.timeout);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("worker_type", &self.worker_type);
        formatter.field("number_of_workers", &self.number_of_workers);
        formatter.field("security_configuration", &self.security_configuration);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("notification_property", &self.notification_property);
        formatter.field("glue_version", &self.glue_version);
        formatter.finish()
    }
}
/// See [`JobRun`](crate::model::JobRun)
pub mod job_run {
    /// A builder for [`JobRun`](crate::model::JobRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) attempt: std::option::Option<i32>,
        pub(crate) previous_run_id: std::option::Option<std::string::String>,
        pub(crate) trigger_name: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) started_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) job_run_state: std::option::Option<crate::model::JobRunState>,
        pub(crate) arguments: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) predecessor_runs: std::option::Option<std::vec::Vec<crate::model::Predecessor>>,
        pub(crate) allocated_capacity: std::option::Option<i32>,
        pub(crate) execution_time: std::option::Option<i32>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) max_capacity: std::option::Option<f64>,
        pub(crate) worker_type: std::option::Option<crate::model::WorkerType>,
        pub(crate) number_of_workers: std::option::Option<i32>,
        pub(crate) security_configuration: std::option::Option<std::string::String>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) notification_property: std::option::Option<crate::model::NotificationProperty>,
        pub(crate) glue_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of this job run.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of this job run.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The number of the attempt to run this job.</p>
        pub fn attempt(mut self, input: i32) -> Self {
            self.attempt = Some(input);
            self
        }
        /// <p>The number of the attempt to run this job.</p>
        pub fn set_attempt(mut self, input: std::option::Option<i32>) -> Self {
            self.attempt = input;
            self
        }
        /// <p>The ID of the previous run of this job. For example, the <code>JobRunId</code> specified
        /// in the <code>StartJobRun</code> action.</p>
        pub fn previous_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.previous_run_id = Some(input.into());
            self
        }
        /// <p>The ID of the previous run of this job. For example, the <code>JobRunId</code> specified
        /// in the <code>StartJobRun</code> action.</p>
        pub fn set_previous_run_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.previous_run_id = input;
            self
        }
        /// <p>The name of the trigger that started this job run.</p>
        pub fn trigger_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trigger_name = Some(input.into());
            self
        }
        /// <p>The name of the trigger that started this job run.</p>
        pub fn set_trigger_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trigger_name = input;
            self
        }
        /// <p>The name of the job definition being used in this run.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the job definition being used in this run.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The date and time at which this job run was started.</p>
        pub fn started_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_on = Some(input);
            self
        }
        /// <p>The date and time at which this job run was started.</p>
        pub fn set_started_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_on = input;
            self
        }
        /// <p>The last time that this job run was modified.</p>
        pub fn last_modified_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_on = Some(input);
            self
        }
        /// <p>The last time that this job run was modified.</p>
        pub fn set_last_modified_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_on = input;
            self
        }
        /// <p>The date and time that this job run completed.</p>
        pub fn completed_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_on = Some(input);
            self
        }
        /// <p>The date and time that this job run completed.</p>
        pub fn set_completed_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_on = input;
            self
        }
        /// <p>The current state of the job run. For more information about the statuses of jobs that have terminated abnormally, see <a href="https://docs.aws.amazon.com/glue/latest/dg/job-run-statuses.html">Glue Job Run Statuses</a>.</p>
        pub fn job_run_state(mut self, input: crate::model::JobRunState) -> Self {
            self.job_run_state = Some(input);
            self
        }
        /// <p>The current state of the job run. For more information about the statuses of jobs that have terminated abnormally, see <a href="https://docs.aws.amazon.com/glue/latest/dg/job-run-statuses.html">Glue Job Run Statuses</a>.</p>
        pub fn set_job_run_state(
            mut self,
            input: std::option::Option<crate::model::JobRunState>,
        ) -> Self {
            self.job_run_state = input;
            self
        }
        /// Adds a key-value pair to `arguments`.
        ///
        /// To override the contents of this collection use [`set_arguments`](Self::set_arguments).
        ///
        /// <p>The job arguments associated with this run. For this job run, they replace the default arguments set in the job definition itself.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.arguments.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.arguments = Some(hash_map);
            self
        }
        /// <p>The job arguments associated with this run. For this job run, they replace the default arguments set in the job definition itself.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn set_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.arguments = input;
            self
        }
        /// <p>An error message associated with this job run.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An error message associated with this job run.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Appends an item to `predecessor_runs`.
        ///
        /// To override the contents of this collection use [`set_predecessor_runs`](Self::set_predecessor_runs).
        ///
        /// <p>A list of predecessors to this job run.</p>
        pub fn predecessor_runs(mut self, input: impl Into<crate::model::Predecessor>) -> Self {
            let mut v = self.predecessor_runs.unwrap_or_default();
            v.push(input.into());
            self.predecessor_runs = Some(v);
            self
        }
        /// <p>A list of predecessors to this job run.</p>
        pub fn set_predecessor_runs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Predecessor>>,
        ) -> Self {
            self.predecessor_runs = input;
            self
        }
        /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
        ///
        /// <p>The number of Glue data processing units (DPUs) allocated to this JobRun.
        /// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        pub fn allocated_capacity(mut self, input: i32) -> Self {
            self.allocated_capacity = Some(input);
            self
        }
        /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
        ///
        /// <p>The number of Glue data processing units (DPUs) allocated to this JobRun.
        /// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        pub fn set_allocated_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_capacity = input;
            self
        }
        /// <p>The amount of time (in seconds) that the job run consumed resources.</p>
        pub fn execution_time(mut self, input: i32) -> Self {
            self.execution_time = Some(input);
            self
        }
        /// <p>The amount of time (in seconds) that the job run consumed resources.</p>
        pub fn set_execution_time(mut self, input: std::option::Option<i32>) -> Self {
            self.execution_time = input;
            self
        }
        /// <p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can
        /// consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
        /// is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can
        /// consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
        /// is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        ///
        /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>
        ///
        /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
        /// running a Python shell job or an Apache Spark ETL job:</p>
        /// <ul>
        /// <li>
        /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
        /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
        /// </li>
        /// <li>
        /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
        /// </li>
        /// </ul>
        pub fn max_capacity(mut self, input: f64) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        ///
        /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>
        ///
        /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
        /// running a Python shell job or an Apache Spark ETL job:</p>
        /// <ul>
        /// <li>
        /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
        /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
        /// </li>
        /// <li>
        /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
        /// </li>
        /// </ul>
        pub fn set_max_capacity(mut self, input: std::option::Option<f64>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        pub fn worker_type(mut self, input: crate::model::WorkerType) -> Self {
            self.worker_type = Some(input);
            self
        }
        /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.worker_type = input;
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn number_of_workers(mut self, input: i32) -> Self {
            self.number_of_workers = Some(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_workers = input;
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this job
        /// run.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_configuration = Some(input.into());
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this job
        /// run.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_configuration = input;
            self
        }
        /// <p>The name of the log group for secure logging that can be server-side encrypted in Amazon
        /// CloudWatch using KMS. This name can be <code>/aws-glue/jobs/</code>, in which case the
        /// default encryption is <code>NONE</code>. If you add a role name and
        /// <code>SecurityConfiguration</code> name (in other words,
        /// <code>/aws-glue/jobs-yourRoleName-yourSecurityConfigurationName/</code>), then that security
        /// configuration is used to encrypt the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the log group for secure logging that can be server-side encrypted in Amazon
        /// CloudWatch using KMS. This name can be <code>/aws-glue/jobs/</code>, in which case the
        /// default encryption is <code>NONE</code>. If you add a role name and
        /// <code>SecurityConfiguration</code> name (in other words,
        /// <code>/aws-glue/jobs-yourRoleName-yourSecurityConfigurationName/</code>), then that security
        /// configuration is used to encrypt the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// <p>Specifies configuration properties of a job run notification.</p>
        pub fn notification_property(mut self, input: crate::model::NotificationProperty) -> Self {
            self.notification_property = Some(input);
            self
        }
        /// <p>Specifies configuration properties of a job run notification.</p>
        pub fn set_notification_property(
            mut self,
            input: std::option::Option<crate::model::NotificationProperty>,
        ) -> Self {
            self.notification_property = input;
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        ///
        /// <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>
        pub fn glue_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.glue_version = Some(input.into());
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        ///
        /// <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.glue_version = input;
            self
        }
        /// Consumes the builder and constructs a [`JobRun`](crate::model::JobRun)
        pub fn build(self) -> crate::model::JobRun {
            crate::model::JobRun {
                id: self.id,
                attempt: self.attempt.unwrap_or_default(),
                previous_run_id: self.previous_run_id,
                trigger_name: self.trigger_name,
                job_name: self.job_name,
                started_on: self.started_on,
                last_modified_on: self.last_modified_on,
                completed_on: self.completed_on,
                job_run_state: self.job_run_state,
                arguments: self.arguments,
                error_message: self.error_message,
                predecessor_runs: self.predecessor_runs,
                allocated_capacity: self.allocated_capacity.unwrap_or_default(),
                execution_time: self.execution_time.unwrap_or_default(),
                timeout: self.timeout,
                max_capacity: self.max_capacity,
                worker_type: self.worker_type,
                number_of_workers: self.number_of_workers,
                security_configuration: self.security_configuration,
                log_group_name: self.log_group_name,
                notification_property: self.notification_property,
                glue_version: self.glue_version,
            }
        }
    }
}
impl JobRun {
    /// Creates a new builder-style object to manufacture [`JobRun`](crate::model::JobRun)
    pub fn builder() -> crate::model::job_run::Builder {
        crate::model::job_run::Builder::default()
    }
}

/// <p>A job run that was used in the predicate of a conditional trigger
/// that triggered this job run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Predecessor {
    /// <p>The name of the job definition used by the predecessor job run.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The job-run ID of the predecessor job run.</p>
    pub run_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Predecessor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Predecessor");
        formatter.field("job_name", &self.job_name);
        formatter.field("run_id", &self.run_id);
        formatter.finish()
    }
}
/// See [`Predecessor`](crate::model::Predecessor)
pub mod predecessor {
    /// A builder for [`Predecessor`](crate::model::Predecessor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the job definition used by the predecessor job run.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the job definition used by the predecessor job run.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The job-run ID of the predecessor job run.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The job-run ID of the predecessor job run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Predecessor`](crate::model::Predecessor)
        pub fn build(self) -> crate::model::Predecessor {
            crate::model::Predecessor {
                job_name: self.job_name,
                run_id: self.run_id,
            }
        }
    }
}
impl Predecessor {
    /// Creates a new builder-style object to manufacture [`Predecessor`](crate::model::Predecessor)
    pub fn builder() -> crate::model::predecessor::Builder {
        crate::model::predecessor::Builder::default()
    }
}

/// <p>The details of a Trigger node present in the workflow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TriggerNodeDetails {
    /// <p>The information of the trigger represented by the trigger node.</p>
    pub trigger: std::option::Option<crate::model::Trigger>,
}
impl std::fmt::Debug for TriggerNodeDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TriggerNodeDetails");
        formatter.field("trigger", &self.trigger);
        formatter.finish()
    }
}
/// See [`TriggerNodeDetails`](crate::model::TriggerNodeDetails)
pub mod trigger_node_details {
    /// A builder for [`TriggerNodeDetails`](crate::model::TriggerNodeDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trigger: std::option::Option<crate::model::Trigger>,
    }
    impl Builder {
        /// <p>The information of the trigger represented by the trigger node.</p>
        pub fn trigger(mut self, input: crate::model::Trigger) -> Self {
            self.trigger = Some(input);
            self
        }
        /// <p>The information of the trigger represented by the trigger node.</p>
        pub fn set_trigger(mut self, input: std::option::Option<crate::model::Trigger>) -> Self {
            self.trigger = input;
            self
        }
        /// Consumes the builder and constructs a [`TriggerNodeDetails`](crate::model::TriggerNodeDetails)
        pub fn build(self) -> crate::model::TriggerNodeDetails {
            crate::model::TriggerNodeDetails {
                trigger: self.trigger,
            }
        }
    }
}
impl TriggerNodeDetails {
    /// Creates a new builder-style object to manufacture [`TriggerNodeDetails`](crate::model::TriggerNodeDetails)
    pub fn builder() -> crate::model::trigger_node_details::Builder {
        crate::model::trigger_node_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodeType {
    #[allow(missing_docs)] // documentation missing in model
    Crawler,
    #[allow(missing_docs)] // documentation missing in model
    Job,
    #[allow(missing_docs)] // documentation missing in model
    Trigger,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodeType {
    fn from(s: &str) -> Self {
        match s {
            "CRAWLER" => NodeType::Crawler,
            "JOB" => NodeType::Job,
            "TRIGGER" => NodeType::Trigger,
            other => NodeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodeType::from(s))
    }
}
impl NodeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodeType::Crawler => "CRAWLER",
            NodeType::Job => "JOB",
            NodeType::Trigger => "TRIGGER",
            NodeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CRAWLER", "JOB", "TRIGGER"]
    }
}
impl AsRef<str> for NodeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Workflow run statistics provides statistics about the workflow run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkflowRunStatistics {
    /// <p>Total number of Actions in the workflow run.</p>
    pub total_actions: i32,
    /// <p>Total number of Actions that timed out.</p>
    pub timeout_actions: i32,
    /// <p>Total number of Actions that have failed.</p>
    pub failed_actions: i32,
    /// <p>Total number of Actions that have stopped.</p>
    pub stopped_actions: i32,
    /// <p>Total number of Actions that have succeeded.</p>
    pub succeeded_actions: i32,
    /// <p>Total number Actions in running state.</p>
    pub running_actions: i32,
}
impl std::fmt::Debug for WorkflowRunStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkflowRunStatistics");
        formatter.field("total_actions", &self.total_actions);
        formatter.field("timeout_actions", &self.timeout_actions);
        formatter.field("failed_actions", &self.failed_actions);
        formatter.field("stopped_actions", &self.stopped_actions);
        formatter.field("succeeded_actions", &self.succeeded_actions);
        formatter.field("running_actions", &self.running_actions);
        formatter.finish()
    }
}
/// See [`WorkflowRunStatistics`](crate::model::WorkflowRunStatistics)
pub mod workflow_run_statistics {
    /// A builder for [`WorkflowRunStatistics`](crate::model::WorkflowRunStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_actions: std::option::Option<i32>,
        pub(crate) timeout_actions: std::option::Option<i32>,
        pub(crate) failed_actions: std::option::Option<i32>,
        pub(crate) stopped_actions: std::option::Option<i32>,
        pub(crate) succeeded_actions: std::option::Option<i32>,
        pub(crate) running_actions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Total number of Actions in the workflow run.</p>
        pub fn total_actions(mut self, input: i32) -> Self {
            self.total_actions = Some(input);
            self
        }
        /// <p>Total number of Actions in the workflow run.</p>
        pub fn set_total_actions(mut self, input: std::option::Option<i32>) -> Self {
            self.total_actions = input;
            self
        }
        /// <p>Total number of Actions that timed out.</p>
        pub fn timeout_actions(mut self, input: i32) -> Self {
            self.timeout_actions = Some(input);
            self
        }
        /// <p>Total number of Actions that timed out.</p>
        pub fn set_timeout_actions(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_actions = input;
            self
        }
        /// <p>Total number of Actions that have failed.</p>
        pub fn failed_actions(mut self, input: i32) -> Self {
            self.failed_actions = Some(input);
            self
        }
        /// <p>Total number of Actions that have failed.</p>
        pub fn set_failed_actions(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_actions = input;
            self
        }
        /// <p>Total number of Actions that have stopped.</p>
        pub fn stopped_actions(mut self, input: i32) -> Self {
            self.stopped_actions = Some(input);
            self
        }
        /// <p>Total number of Actions that have stopped.</p>
        pub fn set_stopped_actions(mut self, input: std::option::Option<i32>) -> Self {
            self.stopped_actions = input;
            self
        }
        /// <p>Total number of Actions that have succeeded.</p>
        pub fn succeeded_actions(mut self, input: i32) -> Self {
            self.succeeded_actions = Some(input);
            self
        }
        /// <p>Total number of Actions that have succeeded.</p>
        pub fn set_succeeded_actions(mut self, input: std::option::Option<i32>) -> Self {
            self.succeeded_actions = input;
            self
        }
        /// <p>Total number Actions in running state.</p>
        pub fn running_actions(mut self, input: i32) -> Self {
            self.running_actions = Some(input);
            self
        }
        /// <p>Total number Actions in running state.</p>
        pub fn set_running_actions(mut self, input: std::option::Option<i32>) -> Self {
            self.running_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkflowRunStatistics`](crate::model::WorkflowRunStatistics)
        pub fn build(self) -> crate::model::WorkflowRunStatistics {
            crate::model::WorkflowRunStatistics {
                total_actions: self.total_actions.unwrap_or_default(),
                timeout_actions: self.timeout_actions.unwrap_or_default(),
                failed_actions: self.failed_actions.unwrap_or_default(),
                stopped_actions: self.stopped_actions.unwrap_or_default(),
                succeeded_actions: self.succeeded_actions.unwrap_or_default(),
                running_actions: self.running_actions.unwrap_or_default(),
            }
        }
    }
}
impl WorkflowRunStatistics {
    /// Creates a new builder-style object to manufacture [`WorkflowRunStatistics`](crate::model::WorkflowRunStatistics)
    pub fn builder() -> crate::model::workflow_run_statistics::Builder {
        crate::model::workflow_run_statistics::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkflowRunStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkflowRunStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => WorkflowRunStatus::Completed,
            "ERROR" => WorkflowRunStatus::Error,
            "RUNNING" => WorkflowRunStatus::Running,
            "STOPPED" => WorkflowRunStatus::Stopped,
            "STOPPING" => WorkflowRunStatus::Stopping,
            other => WorkflowRunStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkflowRunStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkflowRunStatus::from(s))
    }
}
impl WorkflowRunStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkflowRunStatus::Completed => "COMPLETED",
            WorkflowRunStatus::Error => "ERROR",
            WorkflowRunStatus::Running => "RUNNING",
            WorkflowRunStatus::Stopped => "STOPPED",
            WorkflowRunStatus::Stopping => "STOPPING",
            WorkflowRunStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "ERROR", "RUNNING", "STOPPED", "STOPPING"]
    }
}
impl AsRef<str> for WorkflowRunStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A workflow is a collection of multiple dependent Glue
/// jobs and crawlers that are run to complete a complex ETL task. A
/// workflow manages the execution and monitoring of all its jobs and crawlers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Workflow {
    /// <p>The name of the workflow.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the workflow.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A collection of properties to be used as part of each execution of the workflow.
    /// The run properties are made available to each job in the workflow. A job can modify
    /// the properties for the next jobs in the flow.</p>
    pub default_run_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The date and time when the workflow was created.</p>
    pub created_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the workflow was last modified.</p>
    pub last_modified_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The information about the last execution of the workflow.</p>
    pub last_run: std::option::Option<crate::model::WorkflowRun>,
    /// <p>The graph representing all the Glue components that belong to the workflow as nodes and directed
    /// connections between them as edges.</p>
    pub graph: std::option::Option<crate::model::WorkflowGraph>,
    /// <p>You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.</p>
    pub max_concurrent_runs: std::option::Option<i32>,
    /// <p>This structure indicates the details of the blueprint that this particular workflow is created from.</p>
    pub blueprint_details: std::option::Option<crate::model::BlueprintDetails>,
}
impl std::fmt::Debug for Workflow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Workflow");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("default_run_properties", &self.default_run_properties);
        formatter.field("created_on", &self.created_on);
        formatter.field("last_modified_on", &self.last_modified_on);
        formatter.field("last_run", &self.last_run);
        formatter.field("graph", &self.graph);
        formatter.field("max_concurrent_runs", &self.max_concurrent_runs);
        formatter.field("blueprint_details", &self.blueprint_details);
        formatter.finish()
    }
}
/// See [`Workflow`](crate::model::Workflow)
pub mod workflow {
    /// A builder for [`Workflow`](crate::model::Workflow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) default_run_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) created_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_run: std::option::Option<crate::model::WorkflowRun>,
        pub(crate) graph: std::option::Option<crate::model::WorkflowGraph>,
        pub(crate) max_concurrent_runs: std::option::Option<i32>,
        pub(crate) blueprint_details: std::option::Option<crate::model::BlueprintDetails>,
    }
    impl Builder {
        /// <p>The name of the workflow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the workflow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the workflow.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the workflow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `default_run_properties`.
        ///
        /// To override the contents of this collection use [`set_default_run_properties`](Self::set_default_run_properties).
        ///
        /// <p>A collection of properties to be used as part of each execution of the workflow.
        /// The run properties are made available to each job in the workflow. A job can modify
        /// the properties for the next jobs in the flow.</p>
        pub fn default_run_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.default_run_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.default_run_properties = Some(hash_map);
            self
        }
        /// <p>A collection of properties to be used as part of each execution of the workflow.
        /// The run properties are made available to each job in the workflow. A job can modify
        /// the properties for the next jobs in the flow.</p>
        pub fn set_default_run_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.default_run_properties = input;
            self
        }
        /// <p>The date and time when the workflow was created.</p>
        pub fn created_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_on = Some(input);
            self
        }
        /// <p>The date and time when the workflow was created.</p>
        pub fn set_created_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_on = input;
            self
        }
        /// <p>The date and time when the workflow was last modified.</p>
        pub fn last_modified_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_on = Some(input);
            self
        }
        /// <p>The date and time when the workflow was last modified.</p>
        pub fn set_last_modified_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_on = input;
            self
        }
        /// <p>The information about the last execution of the workflow.</p>
        pub fn last_run(mut self, input: crate::model::WorkflowRun) -> Self {
            self.last_run = Some(input);
            self
        }
        /// <p>The information about the last execution of the workflow.</p>
        pub fn set_last_run(
            mut self,
            input: std::option::Option<crate::model::WorkflowRun>,
        ) -> Self {
            self.last_run = input;
            self
        }
        /// <p>The graph representing all the Glue components that belong to the workflow as nodes and directed
        /// connections between them as edges.</p>
        pub fn graph(mut self, input: crate::model::WorkflowGraph) -> Self {
            self.graph = Some(input);
            self
        }
        /// <p>The graph representing all the Glue components that belong to the workflow as nodes and directed
        /// connections between them as edges.</p>
        pub fn set_graph(
            mut self,
            input: std::option::Option<crate::model::WorkflowGraph>,
        ) -> Self {
            self.graph = input;
            self
        }
        /// <p>You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.</p>
        pub fn max_concurrent_runs(mut self, input: i32) -> Self {
            self.max_concurrent_runs = Some(input);
            self
        }
        /// <p>You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs.</p>
        pub fn set_max_concurrent_runs(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrent_runs = input;
            self
        }
        /// <p>This structure indicates the details of the blueprint that this particular workflow is created from.</p>
        pub fn blueprint_details(mut self, input: crate::model::BlueprintDetails) -> Self {
            self.blueprint_details = Some(input);
            self
        }
        /// <p>This structure indicates the details of the blueprint that this particular workflow is created from.</p>
        pub fn set_blueprint_details(
            mut self,
            input: std::option::Option<crate::model::BlueprintDetails>,
        ) -> Self {
            self.blueprint_details = input;
            self
        }
        /// Consumes the builder and constructs a [`Workflow`](crate::model::Workflow)
        pub fn build(self) -> crate::model::Workflow {
            crate::model::Workflow {
                name: self.name,
                description: self.description,
                default_run_properties: self.default_run_properties,
                created_on: self.created_on,
                last_modified_on: self.last_modified_on,
                last_run: self.last_run,
                graph: self.graph,
                max_concurrent_runs: self.max_concurrent_runs,
                blueprint_details: self.blueprint_details,
            }
        }
    }
}
impl Workflow {
    /// Creates a new builder-style object to manufacture [`Workflow`](crate::model::Workflow)
    pub fn builder() -> crate::model::workflow::Builder {
        crate::model::workflow::Builder::default()
    }
}

/// <p>The details of a blueprint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlueprintDetails {
    /// <p>The name of the blueprint.</p>
    pub blueprint_name: std::option::Option<std::string::String>,
    /// <p>The run ID for this blueprint.</p>
    pub run_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BlueprintDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlueprintDetails");
        formatter.field("blueprint_name", &self.blueprint_name);
        formatter.field("run_id", &self.run_id);
        formatter.finish()
    }
}
/// See [`BlueprintDetails`](crate::model::BlueprintDetails)
pub mod blueprint_details {
    /// A builder for [`BlueprintDetails`](crate::model::BlueprintDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blueprint_name: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the blueprint.</p>
        pub fn blueprint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.blueprint_name = Some(input.into());
            self
        }
        /// <p>The name of the blueprint.</p>
        pub fn set_blueprint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.blueprint_name = input;
            self
        }
        /// <p>The run ID for this blueprint.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The run ID for this blueprint.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BlueprintDetails`](crate::model::BlueprintDetails)
        pub fn build(self) -> crate::model::BlueprintDetails {
            crate::model::BlueprintDetails {
                blueprint_name: self.blueprint_name,
                run_id: self.run_id,
            }
        }
    }
}
impl BlueprintDetails {
    /// Creates a new builder-style object to manufacture [`BlueprintDetails`](crate::model::BlueprintDetails)
    pub fn builder() -> crate::model::blueprint_details::Builder {
        crate::model::blueprint_details::Builder::default()
    }
}

/// <p>Represents the equivalent of a Hive user-defined function
/// (<code>UDF</code>) definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserDefinedFunction {
    /// <p>The name of the function.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The name of the catalog database that contains the function.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The Java class that contains the function code.</p>
    pub class_name: std::option::Option<std::string::String>,
    /// <p>The owner of the function.</p>
    pub owner_name: std::option::Option<std::string::String>,
    /// <p>The owner type.</p>
    pub owner_type: std::option::Option<crate::model::PrincipalType>,
    /// <p>The time at which the function was created.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The resource URIs for the function.</p>
    pub resource_uris: std::option::Option<std::vec::Vec<crate::model::ResourceUri>>,
    /// <p>The ID of the Data Catalog in which the function resides.</p>
    pub catalog_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserDefinedFunction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserDefinedFunction");
        formatter.field("function_name", &self.function_name);
        formatter.field("database_name", &self.database_name);
        formatter.field("class_name", &self.class_name);
        formatter.field("owner_name", &self.owner_name);
        formatter.field("owner_type", &self.owner_type);
        formatter.field("create_time", &self.create_time);
        formatter.field("resource_uris", &self.resource_uris);
        formatter.field("catalog_id", &self.catalog_id);
        formatter.finish()
    }
}
/// See [`UserDefinedFunction`](crate::model::UserDefinedFunction)
pub mod user_defined_function {
    /// A builder for [`UserDefinedFunction`](crate::model::UserDefinedFunction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) class_name: std::option::Option<std::string::String>,
        pub(crate) owner_name: std::option::Option<std::string::String>,
        pub(crate) owner_type: std::option::Option<crate::model::PrincipalType>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) resource_uris: std::option::Option<std::vec::Vec<crate::model::ResourceUri>>,
        pub(crate) catalog_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the function.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the function.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The name of the catalog database that contains the function.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the catalog database that contains the function.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The Java class that contains the function code.</p>
        pub fn class_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.class_name = Some(input.into());
            self
        }
        /// <p>The Java class that contains the function code.</p>
        pub fn set_class_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.class_name = input;
            self
        }
        /// <p>The owner of the function.</p>
        pub fn owner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_name = Some(input.into());
            self
        }
        /// <p>The owner of the function.</p>
        pub fn set_owner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_name = input;
            self
        }
        /// <p>The owner type.</p>
        pub fn owner_type(mut self, input: crate::model::PrincipalType) -> Self {
            self.owner_type = Some(input);
            self
        }
        /// <p>The owner type.</p>
        pub fn set_owner_type(
            mut self,
            input: std::option::Option<crate::model::PrincipalType>,
        ) -> Self {
            self.owner_type = input;
            self
        }
        /// <p>The time at which the function was created.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The time at which the function was created.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Appends an item to `resource_uris`.
        ///
        /// To override the contents of this collection use [`set_resource_uris`](Self::set_resource_uris).
        ///
        /// <p>The resource URIs for the function.</p>
        pub fn resource_uris(mut self, input: impl Into<crate::model::ResourceUri>) -> Self {
            let mut v = self.resource_uris.unwrap_or_default();
            v.push(input.into());
            self.resource_uris = Some(v);
            self
        }
        /// <p>The resource URIs for the function.</p>
        pub fn set_resource_uris(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceUri>>,
        ) -> Self {
            self.resource_uris = input;
            self
        }
        /// <p>The ID of the Data Catalog in which the function resides.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the Data Catalog in which the function resides.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UserDefinedFunction`](crate::model::UserDefinedFunction)
        pub fn build(self) -> crate::model::UserDefinedFunction {
            crate::model::UserDefinedFunction {
                function_name: self.function_name,
                database_name: self.database_name,
                class_name: self.class_name,
                owner_name: self.owner_name,
                owner_type: self.owner_type,
                create_time: self.create_time,
                resource_uris: self.resource_uris,
                catalog_id: self.catalog_id,
            }
        }
    }
}
impl UserDefinedFunction {
    /// Creates a new builder-style object to manufacture [`UserDefinedFunction`](crate::model::UserDefinedFunction)
    pub fn builder() -> crate::model::user_defined_function::Builder {
        crate::model::user_defined_function::Builder::default()
    }
}

/// <p>Specifies a version of a table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableVersion {
    /// <p>The table in question.</p>
    pub table: std::option::Option<crate::model::Table>,
    /// <p>The ID value that identifies this table version. A <code>VersionId</code> is a string representation of an integer. Each version is incremented by 1.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TableVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableVersion");
        formatter.field("table", &self.table);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
/// See [`TableVersion`](crate::model::TableVersion)
pub mod table_version {
    /// A builder for [`TableVersion`](crate::model::TableVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table: std::option::Option<crate::model::Table>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The table in question.</p>
        pub fn table(mut self, input: crate::model::Table) -> Self {
            self.table = Some(input);
            self
        }
        /// <p>The table in question.</p>
        pub fn set_table(mut self, input: std::option::Option<crate::model::Table>) -> Self {
            self.table = input;
            self
        }
        /// <p>The ID value that identifies this table version. A <code>VersionId</code> is a string representation of an integer. Each version is incremented by 1.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The ID value that identifies this table version. A <code>VersionId</code> is a string representation of an integer. Each version is incremented by 1.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TableVersion`](crate::model::TableVersion)
        pub fn build(self) -> crate::model::TableVersion {
            crate::model::TableVersion {
                table: self.table,
                version_id: self.version_id,
            }
        }
    }
}
impl TableVersion {
    /// Creates a new builder-style object to manufacture [`TableVersion`](crate::model::TableVersion)
    pub fn builder() -> crate::model::table_version::Builder {
        crate::model::table_version::Builder::default()
    }
}

/// <p>Specifies a security configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityConfiguration {
    /// <p>The name of the security configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time at which this security configuration was created.</p>
    pub created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The encryption configuration associated with this security configuration.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
}
impl std::fmt::Debug for SecurityConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityConfiguration");
        formatter.field("name", &self.name);
        formatter.field("created_time_stamp", &self.created_time_stamp);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.finish()
    }
}
/// See [`SecurityConfiguration`](crate::model::SecurityConfiguration)
pub mod security_configuration {
    /// A builder for [`SecurityConfiguration`](crate::model::SecurityConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_time_stamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
    }
    impl Builder {
        /// <p>The name of the security configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the security configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time at which this security configuration was created.</p>
        pub fn created_time_stamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time_stamp = Some(input);
            self
        }
        /// <p>The time at which this security configuration was created.</p>
        pub fn set_created_time_stamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time_stamp = input;
            self
        }
        /// <p>The encryption configuration associated with this security configuration.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption configuration associated with this security configuration.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityConfiguration`](crate::model::SecurityConfiguration)
        pub fn build(self) -> crate::model::SecurityConfiguration {
            crate::model::SecurityConfiguration {
                name: self.name,
                created_time_stamp: self.created_time_stamp,
                encryption_configuration: self.encryption_configuration,
            }
        }
    }
}
impl SecurityConfiguration {
    /// Creates a new builder-style object to manufacture [`SecurityConfiguration`](crate::model::SecurityConfiguration)
    pub fn builder() -> crate::model::security_configuration::Builder {
        crate::model::security_configuration::Builder::default()
    }
}

/// <p>Specifies an encryption configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionConfiguration {
    /// <p>The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.</p>
    pub s3_encryption: std::option::Option<std::vec::Vec<crate::model::S3Encryption>>,
    /// <p>The encryption configuration for Amazon CloudWatch.</p>
    pub cloud_watch_encryption: std::option::Option<crate::model::CloudWatchEncryption>,
    /// <p>The encryption configuration for job bookmarks.</p>
    pub job_bookmarks_encryption: std::option::Option<crate::model::JobBookmarksEncryption>,
}
impl std::fmt::Debug for EncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionConfiguration");
        formatter.field("s3_encryption", &self.s3_encryption);
        formatter.field("cloud_watch_encryption", &self.cloud_watch_encryption);
        formatter.field("job_bookmarks_encryption", &self.job_bookmarks_encryption);
        formatter.finish()
    }
}
/// See [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
pub mod encryption_configuration {
    /// A builder for [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_encryption: std::option::Option<std::vec::Vec<crate::model::S3Encryption>>,
        pub(crate) cloud_watch_encryption: std::option::Option<crate::model::CloudWatchEncryption>,
        pub(crate) job_bookmarks_encryption:
            std::option::Option<crate::model::JobBookmarksEncryption>,
    }
    impl Builder {
        /// Appends an item to `s3_encryption`.
        ///
        /// To override the contents of this collection use [`set_s3_encryption`](Self::set_s3_encryption).
        ///
        /// <p>The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.</p>
        pub fn s3_encryption(mut self, input: impl Into<crate::model::S3Encryption>) -> Self {
            let mut v = self.s3_encryption.unwrap_or_default();
            v.push(input.into());
            self.s3_encryption = Some(v);
            self
        }
        /// <p>The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.</p>
        pub fn set_s3_encryption(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Encryption>>,
        ) -> Self {
            self.s3_encryption = input;
            self
        }
        /// <p>The encryption configuration for Amazon CloudWatch.</p>
        pub fn cloud_watch_encryption(mut self, input: crate::model::CloudWatchEncryption) -> Self {
            self.cloud_watch_encryption = Some(input);
            self
        }
        /// <p>The encryption configuration for Amazon CloudWatch.</p>
        pub fn set_cloud_watch_encryption(
            mut self,
            input: std::option::Option<crate::model::CloudWatchEncryption>,
        ) -> Self {
            self.cloud_watch_encryption = input;
            self
        }
        /// <p>The encryption configuration for job bookmarks.</p>
        pub fn job_bookmarks_encryption(
            mut self,
            input: crate::model::JobBookmarksEncryption,
        ) -> Self {
            self.job_bookmarks_encryption = Some(input);
            self
        }
        /// <p>The encryption configuration for job bookmarks.</p>
        pub fn set_job_bookmarks_encryption(
            mut self,
            input: std::option::Option<crate::model::JobBookmarksEncryption>,
        ) -> Self {
            self.job_bookmarks_encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
        pub fn build(self) -> crate::model::EncryptionConfiguration {
            crate::model::EncryptionConfiguration {
                s3_encryption: self.s3_encryption,
                cloud_watch_encryption: self.cloud_watch_encryption,
                job_bookmarks_encryption: self.job_bookmarks_encryption,
            }
        }
    }
}
impl EncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    pub fn builder() -> crate::model::encryption_configuration::Builder {
        crate::model::encryption_configuration::Builder::default()
    }
}

/// <p>Specifies how job bookmark data should be encrypted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobBookmarksEncryption {
    /// <p>The encryption mode to use for job bookmarks data.</p>
    pub job_bookmarks_encryption_mode:
        std::option::Option<crate::model::JobBookmarksEncryptionMode>,
    /// <p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JobBookmarksEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobBookmarksEncryption");
        formatter.field(
            "job_bookmarks_encryption_mode",
            &self.job_bookmarks_encryption_mode,
        );
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`JobBookmarksEncryption`](crate::model::JobBookmarksEncryption)
pub mod job_bookmarks_encryption {
    /// A builder for [`JobBookmarksEncryption`](crate::model::JobBookmarksEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_bookmarks_encryption_mode:
            std::option::Option<crate::model::JobBookmarksEncryptionMode>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encryption mode to use for job bookmarks data.</p>
        pub fn job_bookmarks_encryption_mode(
            mut self,
            input: crate::model::JobBookmarksEncryptionMode,
        ) -> Self {
            self.job_bookmarks_encryption_mode = Some(input);
            self
        }
        /// <p>The encryption mode to use for job bookmarks data.</p>
        pub fn set_job_bookmarks_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::JobBookmarksEncryptionMode>,
        ) -> Self {
            self.job_bookmarks_encryption_mode = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`JobBookmarksEncryption`](crate::model::JobBookmarksEncryption)
        pub fn build(self) -> crate::model::JobBookmarksEncryption {
            crate::model::JobBookmarksEncryption {
                job_bookmarks_encryption_mode: self.job_bookmarks_encryption_mode,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl JobBookmarksEncryption {
    /// Creates a new builder-style object to manufacture [`JobBookmarksEncryption`](crate::model::JobBookmarksEncryption)
    pub fn builder() -> crate::model::job_bookmarks_encryption::Builder {
        crate::model::job_bookmarks_encryption::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobBookmarksEncryptionMode {
    #[allow(missing_docs)] // documentation missing in model
    Csekms,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobBookmarksEncryptionMode {
    fn from(s: &str) -> Self {
        match s {
            "CSE-KMS" => JobBookmarksEncryptionMode::Csekms,
            "DISABLED" => JobBookmarksEncryptionMode::Disabled,
            other => JobBookmarksEncryptionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobBookmarksEncryptionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobBookmarksEncryptionMode::from(s))
    }
}
impl JobBookmarksEncryptionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobBookmarksEncryptionMode::Csekms => "CSE-KMS",
            JobBookmarksEncryptionMode::Disabled => "DISABLED",
            JobBookmarksEncryptionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSE-KMS", "DISABLED"]
    }
}
impl AsRef<str> for JobBookmarksEncryptionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies how Amazon CloudWatch data should be encrypted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchEncryption {
    /// <p>The encryption mode to use for CloudWatch data.</p>
    pub cloud_watch_encryption_mode: std::option::Option<crate::model::CloudWatchEncryptionMode>,
    /// <p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudWatchEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchEncryption");
        formatter.field(
            "cloud_watch_encryption_mode",
            &self.cloud_watch_encryption_mode,
        );
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`CloudWatchEncryption`](crate::model::CloudWatchEncryption)
pub mod cloud_watch_encryption {
    /// A builder for [`CloudWatchEncryption`](crate::model::CloudWatchEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_encryption_mode:
            std::option::Option<crate::model::CloudWatchEncryptionMode>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encryption mode to use for CloudWatch data.</p>
        pub fn cloud_watch_encryption_mode(
            mut self,
            input: crate::model::CloudWatchEncryptionMode,
        ) -> Self {
            self.cloud_watch_encryption_mode = Some(input);
            self
        }
        /// <p>The encryption mode to use for CloudWatch data.</p>
        pub fn set_cloud_watch_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::CloudWatchEncryptionMode>,
        ) -> Self {
            self.cloud_watch_encryption_mode = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchEncryption`](crate::model::CloudWatchEncryption)
        pub fn build(self) -> crate::model::CloudWatchEncryption {
            crate::model::CloudWatchEncryption {
                cloud_watch_encryption_mode: self.cloud_watch_encryption_mode,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl CloudWatchEncryption {
    /// Creates a new builder-style object to manufacture [`CloudWatchEncryption`](crate::model::CloudWatchEncryption)
    pub fn builder() -> crate::model::cloud_watch_encryption::Builder {
        crate::model::cloud_watch_encryption::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloudWatchEncryptionMode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Ssekms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloudWatchEncryptionMode {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => CloudWatchEncryptionMode::Disabled,
            "SSE-KMS" => CloudWatchEncryptionMode::Ssekms,
            other => CloudWatchEncryptionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloudWatchEncryptionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloudWatchEncryptionMode::from(s))
    }
}
impl CloudWatchEncryptionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloudWatchEncryptionMode::Disabled => "DISABLED",
            CloudWatchEncryptionMode::Ssekms => "SSE-KMS",
            CloudWatchEncryptionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "SSE-KMS"]
    }
}
impl AsRef<str> for CloudWatchEncryptionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies how Amazon Simple Storage Service (Amazon S3) data should be encrypted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Encryption {
    /// <p>The encryption mode to use for Amazon S3 data.</p>
    pub s3_encryption_mode: std::option::Option<crate::model::S3EncryptionMode>,
    /// <p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3Encryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Encryption");
        formatter.field("s3_encryption_mode", &self.s3_encryption_mode);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`S3Encryption`](crate::model::S3Encryption)
pub mod s3_encryption {
    /// A builder for [`S3Encryption`](crate::model::S3Encryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_encryption_mode: std::option::Option<crate::model::S3EncryptionMode>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encryption mode to use for Amazon S3 data.</p>
        pub fn s3_encryption_mode(mut self, input: crate::model::S3EncryptionMode) -> Self {
            self.s3_encryption_mode = Some(input);
            self
        }
        /// <p>The encryption mode to use for Amazon S3 data.</p>
        pub fn set_s3_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::S3EncryptionMode>,
        ) -> Self {
            self.s3_encryption_mode = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Encryption`](crate::model::S3Encryption)
        pub fn build(self) -> crate::model::S3Encryption {
            crate::model::S3Encryption {
                s3_encryption_mode: self.s3_encryption_mode,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl S3Encryption {
    /// Creates a new builder-style object to manufacture [`S3Encryption`](crate::model::S3Encryption)
    pub fn builder() -> crate::model::s3_encryption::Builder {
        crate::model::s3_encryption::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3EncryptionMode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Ssekms,
    #[allow(missing_docs)] // documentation missing in model
    Sses3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3EncryptionMode {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => S3EncryptionMode::Disabled,
            "SSE-KMS" => S3EncryptionMode::Ssekms,
            "SSE-S3" => S3EncryptionMode::Sses3,
            other => S3EncryptionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3EncryptionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3EncryptionMode::from(s))
    }
}
impl S3EncryptionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3EncryptionMode::Disabled => "DISABLED",
            S3EncryptionMode::Ssekms => "SSE-KMS",
            S3EncryptionMode::Sses3 => "SSE-S3",
            S3EncryptionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "SSE-KMS", "SSE-S3"]
    }
}
impl AsRef<str> for S3EncryptionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SchemaDiffType {
    #[allow(missing_docs)] // documentation missing in model
    SyntaxDiff,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SchemaDiffType {
    fn from(s: &str) -> Self {
        match s {
            "SYNTAX_DIFF" => SchemaDiffType::SyntaxDiff,
            other => SchemaDiffType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SchemaDiffType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SchemaDiffType::from(s))
    }
}
impl SchemaDiffType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SchemaDiffType::SyntaxDiff => "SYNTAX_DIFF",
            SchemaDiffType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SYNTAX_DIFF"]
    }
}
impl AsRef<str> for SchemaDiffType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataFormat {
    #[allow(missing_docs)] // documentation missing in model
    Avro,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataFormat {
    fn from(s: &str) -> Self {
        match s {
            "AVRO" => DataFormat::Avro,
            "JSON" => DataFormat::Json,
            other => DataFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataFormat::from(s))
    }
}
impl DataFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataFormat::Avro => "AVRO",
            DataFormat::Json => "JSON",
            DataFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVRO", "JSON"]
    }
}
impl AsRef<str> for DataFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure for returning a resource policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GluePolicy {
    /// <p>Contains the requested policy document, in JSON format.</p>
    pub policy_in_json: std::option::Option<std::string::String>,
    /// <p>Contains the hash value associated with this policy.</p>
    pub policy_hash: std::option::Option<std::string::String>,
    /// <p>The date and time at which the policy was created.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time at which the policy was last updated.</p>
    pub update_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for GluePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GluePolicy");
        formatter.field("policy_in_json", &self.policy_in_json);
        formatter.field("policy_hash", &self.policy_hash);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`GluePolicy`](crate::model::GluePolicy)
pub mod glue_policy {
    /// A builder for [`GluePolicy`](crate::model::GluePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_in_json: std::option::Option<std::string::String>,
        pub(crate) policy_hash: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Contains the requested policy document, in JSON format.</p>
        pub fn policy_in_json(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_in_json = Some(input.into());
            self
        }
        /// <p>Contains the requested policy document, in JSON format.</p>
        pub fn set_policy_in_json(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_in_json = input;
            self
        }
        /// <p>Contains the hash value associated with this policy.</p>
        pub fn policy_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_hash = Some(input.into());
            self
        }
        /// <p>Contains the hash value associated with this policy.</p>
        pub fn set_policy_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_hash = input;
            self
        }
        /// <p>The date and time at which the policy was created.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The date and time at which the policy was created.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The date and time at which the policy was last updated.</p>
        pub fn update_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The date and time at which the policy was last updated.</p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GluePolicy`](crate::model::GluePolicy)
        pub fn build(self) -> crate::model::GluePolicy {
            crate::model::GluePolicy {
                policy_in_json: self.policy_in_json,
                policy_hash: self.policy_hash,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl GluePolicy {
    /// Creates a new builder-style object to manufacture [`GluePolicy`](crate::model::GluePolicy)
    pub fn builder() -> crate::model::glue_policy::Builder {
        crate::model::glue_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Language {
    #[allow(missing_docs)] // documentation missing in model
    Python,
    #[allow(missing_docs)] // documentation missing in model
    Scala,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Language {
    fn from(s: &str) -> Self {
        match s {
            "PYTHON" => Language::Python,
            "SCALA" => Language::Scala,
            other => Language::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Language {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Language::from(s))
    }
}
impl Language {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Language::Python => "PYTHON",
            Language::Scala => "SCALA",
            Language::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PYTHON", "SCALA"]
    }
}
impl AsRef<str> for Language {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The location of resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Location {
    /// <p>A JDBC location.</p>
    pub jdbc: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
    /// <p>An Amazon Simple Storage Service (Amazon S3) location.</p>
    pub s3: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
    /// <p>An Amazon DynamoDB table location.</p>
    pub dynamo_db: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
}
impl std::fmt::Debug for Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Location");
        formatter.field("jdbc", &self.jdbc);
        formatter.field("s3", &self.s3);
        formatter.field("dynamo_db", &self.dynamo_db);
        formatter.finish()
    }
}
/// See [`Location`](crate::model::Location)
pub mod location {
    /// A builder for [`Location`](crate::model::Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jdbc: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
        pub(crate) s3: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
        pub(crate) dynamo_db: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
    }
    impl Builder {
        /// Appends an item to `jdbc`.
        ///
        /// To override the contents of this collection use [`set_jdbc`](Self::set_jdbc).
        ///
        /// <p>A JDBC location.</p>
        pub fn jdbc(mut self, input: impl Into<crate::model::CodeGenNodeArg>) -> Self {
            let mut v = self.jdbc.unwrap_or_default();
            v.push(input.into());
            self.jdbc = Some(v);
            self
        }
        /// <p>A JDBC location.</p>
        pub fn set_jdbc(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
        ) -> Self {
            self.jdbc = input;
            self
        }
        /// Appends an item to `s3`.
        ///
        /// To override the contents of this collection use [`set_s3`](Self::set_s3).
        ///
        /// <p>An Amazon Simple Storage Service (Amazon S3) location.</p>
        pub fn s3(mut self, input: impl Into<crate::model::CodeGenNodeArg>) -> Self {
            let mut v = self.s3.unwrap_or_default();
            v.push(input.into());
            self.s3 = Some(v);
            self
        }
        /// <p>An Amazon Simple Storage Service (Amazon S3) location.</p>
        pub fn set_s3(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
        ) -> Self {
            self.s3 = input;
            self
        }
        /// Appends an item to `dynamo_db`.
        ///
        /// To override the contents of this collection use [`set_dynamo_db`](Self::set_dynamo_db).
        ///
        /// <p>An Amazon DynamoDB table location.</p>
        pub fn dynamo_db(mut self, input: impl Into<crate::model::CodeGenNodeArg>) -> Self {
            let mut v = self.dynamo_db.unwrap_or_default();
            v.push(input.into());
            self.dynamo_db = Some(v);
            self
        }
        /// <p>An Amazon DynamoDB table location.</p>
        pub fn set_dynamo_db(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
        ) -> Self {
            self.dynamo_db = input;
            self
        }
        /// Consumes the builder and constructs a [`Location`](crate::model::Location)
        pub fn build(self) -> crate::model::Location {
            crate::model::Location {
                jdbc: self.jdbc,
                s3: self.s3,
                dynamo_db: self.dynamo_db,
            }
        }
    }
}
impl Location {
    /// Creates a new builder-style object to manufacture [`Location`](crate::model::Location)
    pub fn builder() -> crate::model::location::Builder {
        crate::model::location::Builder::default()
    }
}

/// <p>An argument or property of a node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeGenNodeArg {
    /// <p>The name of the argument or property.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the argument or property.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>True if the value is used as a parameter.</p>
    pub param: bool,
}
impl std::fmt::Debug for CodeGenNodeArg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeGenNodeArg");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("param", &self.param);
        formatter.finish()
    }
}
/// See [`CodeGenNodeArg`](crate::model::CodeGenNodeArg)
pub mod code_gen_node_arg {
    /// A builder for [`CodeGenNodeArg`](crate::model::CodeGenNodeArg)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) param: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the argument or property.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the argument or property.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the argument or property.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the argument or property.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>True if the value is used as a parameter.</p>
        pub fn param(mut self, input: bool) -> Self {
            self.param = Some(input);
            self
        }
        /// <p>True if the value is used as a parameter.</p>
        pub fn set_param(mut self, input: std::option::Option<bool>) -> Self {
            self.param = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeGenNodeArg`](crate::model::CodeGenNodeArg)
        pub fn build(self) -> crate::model::CodeGenNodeArg {
            crate::model::CodeGenNodeArg {
                name: self.name,
                value: self.value,
                param: self.param.unwrap_or_default(),
            }
        }
    }
}
impl CodeGenNodeArg {
    /// Creates a new builder-style object to manufacture [`CodeGenNodeArg`](crate::model::CodeGenNodeArg)
    pub fn builder() -> crate::model::code_gen_node_arg::Builder {
        crate::model::code_gen_node_arg::Builder::default()
    }
}

/// <p>Specifies a table definition in the Glue Data Catalog.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CatalogEntry {
    /// <p>The database in which the table metadata resides.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the table in question.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CatalogEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CatalogEntry");
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}
/// See [`CatalogEntry`](crate::model::CatalogEntry)
pub mod catalog_entry {
    /// A builder for [`CatalogEntry`](crate::model::CatalogEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The database in which the table metadata resides.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The database in which the table metadata resides.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the table in question.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table in question.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CatalogEntry`](crate::model::CatalogEntry)
        pub fn build(self) -> crate::model::CatalogEntry {
            crate::model::CatalogEntry {
                database_name: self.database_name,
                table_name: self.table_name,
            }
        }
    }
}
impl CatalogEntry {
    /// Creates a new builder-style object to manufacture [`CatalogEntry`](crate::model::CatalogEntry)
    pub fn builder() -> crate::model::catalog_entry::Builder {
        crate::model::catalog_entry::Builder::default()
    }
}

/// <p>Defines a mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MappingEntry {
    /// <p>The name of the source table.</p>
    pub source_table: std::option::Option<std::string::String>,
    /// <p>The source path.</p>
    pub source_path: std::option::Option<std::string::String>,
    /// <p>The source type.</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>The target table.</p>
    pub target_table: std::option::Option<std::string::String>,
    /// <p>The target path.</p>
    pub target_path: std::option::Option<std::string::String>,
    /// <p>The target type.</p>
    pub target_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MappingEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MappingEntry");
        formatter.field("source_table", &self.source_table);
        formatter.field("source_path", &self.source_path);
        formatter.field("source_type", &self.source_type);
        formatter.field("target_table", &self.target_table);
        formatter.field("target_path", &self.target_path);
        formatter.field("target_type", &self.target_type);
        formatter.finish()
    }
}
/// See [`MappingEntry`](crate::model::MappingEntry)
pub mod mapping_entry {
    /// A builder for [`MappingEntry`](crate::model::MappingEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_table: std::option::Option<std::string::String>,
        pub(crate) source_path: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) target_table: std::option::Option<std::string::String>,
        pub(crate) target_path: std::option::Option<std::string::String>,
        pub(crate) target_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the source table.</p>
        pub fn source_table(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_table = Some(input.into());
            self
        }
        /// <p>The name of the source table.</p>
        pub fn set_source_table(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_table = input;
            self
        }
        /// <p>The source path.</p>
        pub fn source_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_path = Some(input.into());
            self
        }
        /// <p>The source path.</p>
        pub fn set_source_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_path = input;
            self
        }
        /// <p>The source type.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The target table.</p>
        pub fn target_table(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_table = Some(input.into());
            self
        }
        /// <p>The target table.</p>
        pub fn set_target_table(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_table = input;
            self
        }
        /// <p>The target path.</p>
        pub fn target_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_path = Some(input.into());
            self
        }
        /// <p>The target path.</p>
        pub fn set_target_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_path = input;
            self
        }
        /// <p>The target type.</p>
        pub fn target_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_type = Some(input.into());
            self
        }
        /// <p>The target type.</p>
        pub fn set_target_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_type = input;
            self
        }
        /// Consumes the builder and constructs a [`MappingEntry`](crate::model::MappingEntry)
        pub fn build(self) -> crate::model::MappingEntry {
            crate::model::MappingEntry {
                source_table: self.source_table,
                source_path: self.source_path,
                source_type: self.source_type,
                target_table: self.target_table,
                target_path: self.target_path,
                target_type: self.target_type,
            }
        }
    }
}
impl MappingEntry {
    /// Creates a new builder-style object to manufacture [`MappingEntry`](crate::model::MappingEntry)
    pub fn builder() -> crate::model::mapping_entry::Builder {
        crate::model::mapping_entry::Builder::default()
    }
}

/// <p>Represents a slice of table data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Partition {
    /// <p>The values of the partition.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the catalog database in which to create the partition.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the database table in which to create the partition.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The time at which the partition was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time at which the partition was accessed.</p>
    pub last_access_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Provides information about the physical
    /// location where the partition is stored.</p>
    pub storage_descriptor: std::option::Option<crate::model::StorageDescriptor>,
    /// <p>These key-value pairs define partition parameters.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The last time at which column statistics were computed for this
    /// partition.</p>
    pub last_analyzed_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ID of the Data Catalog in which the partition resides.</p>
    pub catalog_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Partition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Partition");
        formatter.field("values", &self.values);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_access_time", &self.last_access_time);
        formatter.field("storage_descriptor", &self.storage_descriptor);
        formatter.field("parameters", &self.parameters);
        formatter.field("last_analyzed_time", &self.last_analyzed_time);
        formatter.field("catalog_id", &self.catalog_id);
        formatter.finish()
    }
}
/// See [`Partition`](crate::model::Partition)
pub mod partition {
    /// A builder for [`Partition`](crate::model::Partition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_access_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) storage_descriptor: std::option::Option<crate::model::StorageDescriptor>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) last_analyzed_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) catalog_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of the partition.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of the partition.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The name of the catalog database in which to create the partition.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the catalog database in which to create the partition.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the database table in which to create the partition.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the database table in which to create the partition.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The time at which the partition was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the partition was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time at which the partition was accessed.</p>
        pub fn last_access_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_access_time = Some(input);
            self
        }
        /// <p>The last time at which the partition was accessed.</p>
        pub fn set_last_access_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_access_time = input;
            self
        }
        /// <p>Provides information about the physical
        /// location where the partition is stored.</p>
        pub fn storage_descriptor(mut self, input: crate::model::StorageDescriptor) -> Self {
            self.storage_descriptor = Some(input);
            self
        }
        /// <p>Provides information about the physical
        /// location where the partition is stored.</p>
        pub fn set_storage_descriptor(
            mut self,
            input: std::option::Option<crate::model::StorageDescriptor>,
        ) -> Self {
            self.storage_descriptor = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>These key-value pairs define partition parameters.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>These key-value pairs define partition parameters.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The last time at which column statistics were computed for this
        /// partition.</p>
        pub fn last_analyzed_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_analyzed_time = Some(input);
            self
        }
        /// <p>The last time at which column statistics were computed for this
        /// partition.</p>
        pub fn set_last_analyzed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_analyzed_time = input;
            self
        }
        /// <p>The ID of the Data Catalog in which the partition resides.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the Data Catalog in which the partition resides.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Partition`](crate::model::Partition)
        pub fn build(self) -> crate::model::Partition {
            crate::model::Partition {
                values: self.values,
                database_name: self.database_name,
                table_name: self.table_name,
                creation_time: self.creation_time,
                last_access_time: self.last_access_time,
                storage_descriptor: self.storage_descriptor,
                parameters: self.parameters,
                last_analyzed_time: self.last_analyzed_time,
                catalog_id: self.catalog_id,
            }
        }
    }
}
impl Partition {
    /// Creates a new builder-style object to manufacture [`Partition`](crate::model::Partition)
    pub fn builder() -> crate::model::partition::Builder {
        crate::model::partition::Builder::default()
    }
}

/// <p>Defines a non-overlapping region of a table's partitions, allowing
/// multiple requests to be run in parallel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Segment {
    /// <p>The zero-based index number of the segment. For example, if the total number of segments
    /// is 4, <code>SegmentNumber</code> values range from 0 through 3.</p>
    pub segment_number: i32,
    /// <p>The total number of segments.</p>
    pub total_segments: i32,
}
impl std::fmt::Debug for Segment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Segment");
        formatter.field("segment_number", &self.segment_number);
        formatter.field("total_segments", &self.total_segments);
        formatter.finish()
    }
}
/// See [`Segment`](crate::model::Segment)
pub mod segment {
    /// A builder for [`Segment`](crate::model::Segment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) segment_number: std::option::Option<i32>,
        pub(crate) total_segments: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The zero-based index number of the segment. For example, if the total number of segments
        /// is 4, <code>SegmentNumber</code> values range from 0 through 3.</p>
        pub fn segment_number(mut self, input: i32) -> Self {
            self.segment_number = Some(input);
            self
        }
        /// <p>The zero-based index number of the segment. For example, if the total number of segments
        /// is 4, <code>SegmentNumber</code> values range from 0 through 3.</p>
        pub fn set_segment_number(mut self, input: std::option::Option<i32>) -> Self {
            self.segment_number = input;
            self
        }
        /// <p>The total number of segments.</p>
        pub fn total_segments(mut self, input: i32) -> Self {
            self.total_segments = Some(input);
            self
        }
        /// <p>The total number of segments.</p>
        pub fn set_total_segments(mut self, input: std::option::Option<i32>) -> Self {
            self.total_segments = input;
            self
        }
        /// Consumes the builder and constructs a [`Segment`](crate::model::Segment)
        pub fn build(self) -> crate::model::Segment {
            crate::model::Segment {
                segment_number: self.segment_number.unwrap_or_default(),
                total_segments: self.total_segments.unwrap_or_default(),
            }
        }
    }
}
impl Segment {
    /// Creates a new builder-style object to manufacture [`Segment`](crate::model::Segment)
    pub fn builder() -> crate::model::segment::Builder {
        crate::model::segment::Builder::default()
    }
}

/// <p>A descriptor for a partition index in a table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartitionIndexDescriptor {
    /// <p>The name of the partition index.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.</p>
    pub keys: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
    /// <p>The status of the partition index. </p>
    ///
    /// <p>The possible statuses are:</p>
    /// <ul>
    /// <li>
    /// <p>CREATING: The index is being created. When an index is in a CREATING state, the index or its table cannot be deleted.</p>
    /// </li>
    /// <li>
    /// <p>ACTIVE: The index creation succeeds.</p>
    /// </li>
    /// <li>
    /// <p>FAILED: The index creation fails. </p>
    /// </li>
    /// <li>
    /// <p>DELETING: The index is deleted from the list of indexes.</p>
    /// </li>
    /// </ul>
    pub index_status: std::option::Option<crate::model::PartitionIndexStatus>,
    /// <p>A list of errors that can occur when registering partition indexes for an existing table.</p>
    pub backfill_errors: std::option::Option<std::vec::Vec<crate::model::BackfillError>>,
}
impl std::fmt::Debug for PartitionIndexDescriptor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartitionIndexDescriptor");
        formatter.field("index_name", &self.index_name);
        formatter.field("keys", &self.keys);
        formatter.field("index_status", &self.index_status);
        formatter.field("backfill_errors", &self.backfill_errors);
        formatter.finish()
    }
}
/// See [`PartitionIndexDescriptor`](crate::model::PartitionIndexDescriptor)
pub mod partition_index_descriptor {
    /// A builder for [`PartitionIndexDescriptor`](crate::model::PartitionIndexDescriptor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) keys: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        pub(crate) index_status: std::option::Option<crate::model::PartitionIndexStatus>,
        pub(crate) backfill_errors: std::option::Option<std::vec::Vec<crate::model::BackfillError>>,
    }
    impl Builder {
        /// <p>The name of the partition index.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the partition index.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.</p>
        pub fn keys(mut self, input: impl Into<crate::model::KeySchemaElement>) -> Self {
            let mut v = self.keys.unwrap_or_default();
            v.push(input.into());
            self.keys = Some(v);
            self
        }
        /// <p>A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySchemaElement>>,
        ) -> Self {
            self.keys = input;
            self
        }
        /// <p>The status of the partition index. </p>
        ///
        /// <p>The possible statuses are:</p>
        /// <ul>
        /// <li>
        /// <p>CREATING: The index is being created. When an index is in a CREATING state, the index or its table cannot be deleted.</p>
        /// </li>
        /// <li>
        /// <p>ACTIVE: The index creation succeeds.</p>
        /// </li>
        /// <li>
        /// <p>FAILED: The index creation fails. </p>
        /// </li>
        /// <li>
        /// <p>DELETING: The index is deleted from the list of indexes.</p>
        /// </li>
        /// </ul>
        pub fn index_status(mut self, input: crate::model::PartitionIndexStatus) -> Self {
            self.index_status = Some(input);
            self
        }
        /// <p>The status of the partition index. </p>
        ///
        /// <p>The possible statuses are:</p>
        /// <ul>
        /// <li>
        /// <p>CREATING: The index is being created. When an index is in a CREATING state, the index or its table cannot be deleted.</p>
        /// </li>
        /// <li>
        /// <p>ACTIVE: The index creation succeeds.</p>
        /// </li>
        /// <li>
        /// <p>FAILED: The index creation fails. </p>
        /// </li>
        /// <li>
        /// <p>DELETING: The index is deleted from the list of indexes.</p>
        /// </li>
        /// </ul>
        pub fn set_index_status(
            mut self,
            input: std::option::Option<crate::model::PartitionIndexStatus>,
        ) -> Self {
            self.index_status = input;
            self
        }
        /// Appends an item to `backfill_errors`.
        ///
        /// To override the contents of this collection use [`set_backfill_errors`](Self::set_backfill_errors).
        ///
        /// <p>A list of errors that can occur when registering partition indexes for an existing table.</p>
        pub fn backfill_errors(mut self, input: impl Into<crate::model::BackfillError>) -> Self {
            let mut v = self.backfill_errors.unwrap_or_default();
            v.push(input.into());
            self.backfill_errors = Some(v);
            self
        }
        /// <p>A list of errors that can occur when registering partition indexes for an existing table.</p>
        pub fn set_backfill_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BackfillError>>,
        ) -> Self {
            self.backfill_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`PartitionIndexDescriptor`](crate::model::PartitionIndexDescriptor)
        pub fn build(self) -> crate::model::PartitionIndexDescriptor {
            crate::model::PartitionIndexDescriptor {
                index_name: self.index_name,
                keys: self.keys,
                index_status: self.index_status,
                backfill_errors: self.backfill_errors,
            }
        }
    }
}
impl PartitionIndexDescriptor {
    /// Creates a new builder-style object to manufacture [`PartitionIndexDescriptor`](crate::model::PartitionIndexDescriptor)
    pub fn builder() -> crate::model::partition_index_descriptor::Builder {
        crate::model::partition_index_descriptor::Builder::default()
    }
}

/// <p>A list of errors that can occur when registering partition indexes for an existing table.</p>
///
/// <p>These errors give the details about why an index registration failed and provide a limited number of partitions in the response, so that you can fix the partitions at fault and try registering the index again. The most common set of errors that can occur are categorized as follows:</p>
///
/// <ul>
/// <li>
/// <p>EncryptedPartitionError: The partitions are encrypted.</p>
/// </li>
/// <li>
/// <p>InvalidPartitionTypeDataError: The partition value doesn't match the data type for that partition column.</p>
/// </li>
/// <li>
/// <p>MissingPartitionValueError: The partitions are encrypted.</p>
/// </li>
/// <li>
/// <p>UnsupportedPartitionCharacterError: Characters inside the partition value are not supported. For example: U+0000 , U+0001, U+0002.</p>
/// </li>
/// <li>
/// <p>InternalError: Any error which does not belong to other error codes.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackfillError {
    /// <p>The error code for an error that occurred when registering partition indexes for an existing table.</p>
    pub code: std::option::Option<crate::model::BackfillErrorCode>,
    /// <p>A list of a limited number of partitions in the response.</p>
    pub partitions: std::option::Option<std::vec::Vec<crate::model::PartitionValueList>>,
}
impl std::fmt::Debug for BackfillError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackfillError");
        formatter.field("code", &self.code);
        formatter.field("partitions", &self.partitions);
        formatter.finish()
    }
}
/// See [`BackfillError`](crate::model::BackfillError)
pub mod backfill_error {
    /// A builder for [`BackfillError`](crate::model::BackfillError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::BackfillErrorCode>,
        pub(crate) partitions: std::option::Option<std::vec::Vec<crate::model::PartitionValueList>>,
    }
    impl Builder {
        /// <p>The error code for an error that occurred when registering partition indexes for an existing table.</p>
        pub fn code(mut self, input: crate::model::BackfillErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code for an error that occurred when registering partition indexes for an existing table.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::BackfillErrorCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// Appends an item to `partitions`.
        ///
        /// To override the contents of this collection use [`set_partitions`](Self::set_partitions).
        ///
        /// <p>A list of a limited number of partitions in the response.</p>
        pub fn partitions(mut self, input: impl Into<crate::model::PartitionValueList>) -> Self {
            let mut v = self.partitions.unwrap_or_default();
            v.push(input.into());
            self.partitions = Some(v);
            self
        }
        /// <p>A list of a limited number of partitions in the response.</p>
        pub fn set_partitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartitionValueList>>,
        ) -> Self {
            self.partitions = input;
            self
        }
        /// Consumes the builder and constructs a [`BackfillError`](crate::model::BackfillError)
        pub fn build(self) -> crate::model::BackfillError {
            crate::model::BackfillError {
                code: self.code,
                partitions: self.partitions,
            }
        }
    }
}
impl BackfillError {
    /// Creates a new builder-style object to manufacture [`BackfillError`](crate::model::BackfillError)
    pub fn builder() -> crate::model::backfill_error::Builder {
        crate::model::backfill_error::Builder::default()
    }
}

/// <p>Contains a list of values defining partitions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartitionValueList {
    /// <p>The list of values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for PartitionValueList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartitionValueList");
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`PartitionValueList`](crate::model::PartitionValueList)
pub mod partition_value_list {
    /// A builder for [`PartitionValueList`](crate::model::PartitionValueList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The list of values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The list of values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`PartitionValueList`](crate::model::PartitionValueList)
        pub fn build(self) -> crate::model::PartitionValueList {
            crate::model::PartitionValueList {
                values: self.values,
            }
        }
    }
}
impl PartitionValueList {
    /// Creates a new builder-style object to manufacture [`PartitionValueList`](crate::model::PartitionValueList)
    pub fn builder() -> crate::model::partition_value_list::Builder {
        crate::model::partition_value_list::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BackfillErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    EncryptedPartitionError,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPartitionTypeDataError,
    #[allow(missing_docs)] // documentation missing in model
    MissingPartitionValueError,
    #[allow(missing_docs)] // documentation missing in model
    UnsupportedPartitionCharacterError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BackfillErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ENCRYPTED_PARTITION_ERROR" => BackfillErrorCode::EncryptedPartitionError,
            "INTERNAL_ERROR" => BackfillErrorCode::InternalError,
            "INVALID_PARTITION_TYPE_DATA_ERROR" => BackfillErrorCode::InvalidPartitionTypeDataError,
            "MISSING_PARTITION_VALUE_ERROR" => BackfillErrorCode::MissingPartitionValueError,
            "UNSUPPORTED_PARTITION_CHARACTER_ERROR" => {
                BackfillErrorCode::UnsupportedPartitionCharacterError
            }
            other => BackfillErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BackfillErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BackfillErrorCode::from(s))
    }
}
impl BackfillErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BackfillErrorCode::EncryptedPartitionError => "ENCRYPTED_PARTITION_ERROR",
            BackfillErrorCode::InternalError => "INTERNAL_ERROR",
            BackfillErrorCode::InvalidPartitionTypeDataError => "INVALID_PARTITION_TYPE_DATA_ERROR",
            BackfillErrorCode::MissingPartitionValueError => "MISSING_PARTITION_VALUE_ERROR",
            BackfillErrorCode::UnsupportedPartitionCharacterError => {
                "UNSUPPORTED_PARTITION_CHARACTER_ERROR"
            }
            BackfillErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ENCRYPTED_PARTITION_ERROR",
            "INTERNAL_ERROR",
            "INVALID_PARTITION_TYPE_DATA_ERROR",
            "MISSING_PARTITION_VALUE_ERROR",
            "UNSUPPORTED_PARTITION_CHARACTER_ERROR",
        ]
    }
}
impl AsRef<str> for BackfillErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PartitionIndexStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PartitionIndexStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => PartitionIndexStatus::Active,
            "CREATING" => PartitionIndexStatus::Creating,
            "DELETING" => PartitionIndexStatus::Deleting,
            "FAILED" => PartitionIndexStatus::Failed,
            other => PartitionIndexStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PartitionIndexStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PartitionIndexStatus::from(s))
    }
}
impl PartitionIndexStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PartitionIndexStatus::Active => "ACTIVE",
            PartitionIndexStatus::Creating => "CREATING",
            PartitionIndexStatus::Deleting => "DELETING",
            PartitionIndexStatus::Failed => "FAILED",
            PartitionIndexStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING", "FAILED"]
    }
}
impl AsRef<str> for PartitionIndexStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A partition key pair consisting of a name and a type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeySchemaElement {
    /// <p>The name of a partition key.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of a partition key.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeySchemaElement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeySchemaElement");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`KeySchemaElement`](crate::model::KeySchemaElement)
pub mod key_schema_element {
    /// A builder for [`KeySchemaElement`](crate::model::KeySchemaElement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a partition key.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a partition key.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of a partition key.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of a partition key.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`KeySchemaElement`](crate::model::KeySchemaElement)
        pub fn build(self) -> crate::model::KeySchemaElement {
            crate::model::KeySchemaElement {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl KeySchemaElement {
    /// Creates a new builder-style object to manufacture [`KeySchemaElement`](crate::model::KeySchemaElement)
    pub fn builder() -> crate::model::key_schema_element::Builder {
        crate::model::key_schema_element::Builder::default()
    }
}

/// <p>A structure for a machine learning transform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MlTransform {
    /// <p>The unique transform ID that is generated for the machine learning transform. The ID is
    /// guaranteed to be unique and does not change.</p>
    pub transform_id: std::option::Option<std::string::String>,
    /// <p>A user-defined name for the machine learning transform. Names are not guaranteed unique
    /// and can be changed at any time.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A user-defined, long-form description text for the machine learning transform.
    /// Descriptions are not guaranteed to be unique and can be changed at any time.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The current status of the machine learning transform.</p>
    pub status: std::option::Option<crate::model::TransformStatusType>,
    /// <p>A timestamp. The time and date that this machine learning transform was created.</p>
    pub created_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp. The last point in time when this machine learning transform was modified.</p>
    pub last_modified_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of Glue table definitions used by the transform.</p>
    pub input_record_tables: std::option::Option<std::vec::Vec<crate::model::GlueTable>>,
    /// <p>A <code>TransformParameters</code> object. You can use parameters to tune (customize) the
    /// behavior of the machine learning transform by specifying what data it learns from and your
    /// preference on various tradeoffs (such as precious vs. recall, or accuracy vs. cost).</p>
    pub parameters: std::option::Option<crate::model::TransformParameters>,
    /// <p>An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your machine learning transform.</p>
    pub evaluation_metrics: std::option::Option<crate::model::EvaluationMetrics>,
    /// <p>A count identifier for the labeling files generated by Glue for this transform. As you create a better transform, you can iteratively download, label, and upload the labeling file.</p>
    pub label_count: i32,
    /// <p>A map of key-value pairs representing the columns and data types that this transform can
    /// run against. Has an upper bound of 100 columns.</p>
    pub schema: std::option::Option<std::vec::Vec<crate::model::SchemaColumn>>,
    /// <p>The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions include both Glue service role permissions to Glue resources, and Amazon S3 permissions required by the transform. </p>
    ///
    /// <ul>
    /// <li>
    /// <p>This role needs Glue service role permissions to allow access to resources in Glue. See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access Glue</a>.</p>
    /// </li>
    /// <li>
    /// <p>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</p>
    /// </li>
    /// </ul>
    pub role: std::option::Option<std::string::String>,
    /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
    pub glue_version: std::option::Option<std::string::String>,
    /// <p>The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
    /// processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
    /// information, see the <a href="http://aws.amazon.com/glue/pricing/">Glue pricing
    /// page</a>. </p>
    ///
    /// <p>
    /// <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p>
    /// <ul>
    /// <li>
    /// <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p>
    /// </li>
    /// <li>
    /// <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p>
    /// </li>
    /// <li>
    /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>
    pub max_capacity: std::option::Option<f64>,
    /// <p>The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of Standard, G.1X, or G.2X.</p>
    /// <ul>
    /// <li>
    /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p>
    /// <ul>
    /// <li>
    /// <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p>
    /// </li>
    /// <li>
    /// <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p>
    /// </li>
    /// <li>
    /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p>
    /// </li>
    /// </ul>
    pub worker_type: std::option::Option<crate::model::WorkerType>,
    /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform runs.</p>
    ///
    /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
    pub number_of_workers: std::option::Option<i32>,
    /// <p>The timeout in minutes of the machine learning transform.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The maximum number of times to retry after an <code>MLTaskRun</code> of the machine
    /// learning transform fails.</p>
    pub max_retries: std::option::Option<i32>,
    /// <p>The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can access user data encrypted in Amazon S3 using KMS.</p>
    pub transform_encryption: std::option::Option<crate::model::TransformEncryption>,
}
impl std::fmt::Debug for MlTransform {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MlTransform");
        formatter.field("transform_id", &self.transform_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("created_on", &self.created_on);
        formatter.field("last_modified_on", &self.last_modified_on);
        formatter.field("input_record_tables", &self.input_record_tables);
        formatter.field("parameters", &self.parameters);
        formatter.field("evaluation_metrics", &self.evaluation_metrics);
        formatter.field("label_count", &self.label_count);
        formatter.field("schema", &self.schema);
        formatter.field("role", &self.role);
        formatter.field("glue_version", &self.glue_version);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("worker_type", &self.worker_type);
        formatter.field("number_of_workers", &self.number_of_workers);
        formatter.field("timeout", &self.timeout);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("transform_encryption", &self.transform_encryption);
        formatter.finish()
    }
}
/// See [`MlTransform`](crate::model::MlTransform)
pub mod ml_transform {
    /// A builder for [`MlTransform`](crate::model::MlTransform)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TransformStatusType>,
        pub(crate) created_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) input_record_tables: std::option::Option<std::vec::Vec<crate::model::GlueTable>>,
        pub(crate) parameters: std::option::Option<crate::model::TransformParameters>,
        pub(crate) evaluation_metrics: std::option::Option<crate::model::EvaluationMetrics>,
        pub(crate) label_count: std::option::Option<i32>,
        pub(crate) schema: std::option::Option<std::vec::Vec<crate::model::SchemaColumn>>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) glue_version: std::option::Option<std::string::String>,
        pub(crate) max_capacity: std::option::Option<f64>,
        pub(crate) worker_type: std::option::Option<crate::model::WorkerType>,
        pub(crate) number_of_workers: std::option::Option<i32>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) transform_encryption: std::option::Option<crate::model::TransformEncryption>,
    }
    impl Builder {
        /// <p>The unique transform ID that is generated for the machine learning transform. The ID is
        /// guaranteed to be unique and does not change.</p>
        pub fn transform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_id = Some(input.into());
            self
        }
        /// <p>The unique transform ID that is generated for the machine learning transform. The ID is
        /// guaranteed to be unique and does not change.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.transform_id = input;
            self
        }
        /// <p>A user-defined name for the machine learning transform. Names are not guaranteed unique
        /// and can be changed at any time.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A user-defined name for the machine learning transform. Names are not guaranteed unique
        /// and can be changed at any time.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A user-defined, long-form description text for the machine learning transform.
        /// Descriptions are not guaranteed to be unique and can be changed at any time.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A user-defined, long-form description text for the machine learning transform.
        /// Descriptions are not guaranteed to be unique and can be changed at any time.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The current status of the machine learning transform.</p>
        pub fn status(mut self, input: crate::model::TransformStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the machine learning transform.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TransformStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A timestamp. The time and date that this machine learning transform was created.</p>
        pub fn created_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_on = Some(input);
            self
        }
        /// <p>A timestamp. The time and date that this machine learning transform was created.</p>
        pub fn set_created_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_on = input;
            self
        }
        /// <p>A timestamp. The last point in time when this machine learning transform was modified.</p>
        pub fn last_modified_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_on = Some(input);
            self
        }
        /// <p>A timestamp. The last point in time when this machine learning transform was modified.</p>
        pub fn set_last_modified_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_on = input;
            self
        }
        /// Appends an item to `input_record_tables`.
        ///
        /// To override the contents of this collection use [`set_input_record_tables`](Self::set_input_record_tables).
        ///
        /// <p>A list of Glue table definitions used by the transform.</p>
        pub fn input_record_tables(mut self, input: impl Into<crate::model::GlueTable>) -> Self {
            let mut v = self.input_record_tables.unwrap_or_default();
            v.push(input.into());
            self.input_record_tables = Some(v);
            self
        }
        /// <p>A list of Glue table definitions used by the transform.</p>
        pub fn set_input_record_tables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlueTable>>,
        ) -> Self {
            self.input_record_tables = input;
            self
        }
        /// <p>A <code>TransformParameters</code> object. You can use parameters to tune (customize) the
        /// behavior of the machine learning transform by specifying what data it learns from and your
        /// preference on various tradeoffs (such as precious vs. recall, or accuracy vs. cost).</p>
        pub fn parameters(mut self, input: crate::model::TransformParameters) -> Self {
            self.parameters = Some(input);
            self
        }
        /// <p>A <code>TransformParameters</code> object. You can use parameters to tune (customize) the
        /// behavior of the machine learning transform by specifying what data it learns from and your
        /// preference on various tradeoffs (such as precious vs. recall, or accuracy vs. cost).</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<crate::model::TransformParameters>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your machine learning transform.</p>
        pub fn evaluation_metrics(mut self, input: crate::model::EvaluationMetrics) -> Self {
            self.evaluation_metrics = Some(input);
            self
        }
        /// <p>An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your machine learning transform.</p>
        pub fn set_evaluation_metrics(
            mut self,
            input: std::option::Option<crate::model::EvaluationMetrics>,
        ) -> Self {
            self.evaluation_metrics = input;
            self
        }
        /// <p>A count identifier for the labeling files generated by Glue for this transform. As you create a better transform, you can iteratively download, label, and upload the labeling file.</p>
        pub fn label_count(mut self, input: i32) -> Self {
            self.label_count = Some(input);
            self
        }
        /// <p>A count identifier for the labeling files generated by Glue for this transform. As you create a better transform, you can iteratively download, label, and upload the labeling file.</p>
        pub fn set_label_count(mut self, input: std::option::Option<i32>) -> Self {
            self.label_count = input;
            self
        }
        /// Appends an item to `schema`.
        ///
        /// To override the contents of this collection use [`set_schema`](Self::set_schema).
        ///
        /// <p>A map of key-value pairs representing the columns and data types that this transform can
        /// run against. Has an upper bound of 100 columns.</p>
        pub fn schema(mut self, input: impl Into<crate::model::SchemaColumn>) -> Self {
            let mut v = self.schema.unwrap_or_default();
            v.push(input.into());
            self.schema = Some(v);
            self
        }
        /// <p>A map of key-value pairs representing the columns and data types that this transform can
        /// run against. Has an upper bound of 100 columns.</p>
        pub fn set_schema(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SchemaColumn>>,
        ) -> Self {
            self.schema = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions include both Glue service role permissions to Glue resources, and Amazon S3 permissions required by the transform. </p>
        ///
        /// <ul>
        /// <li>
        /// <p>This role needs Glue service role permissions to allow access to resources in Glue. See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access Glue</a>.</p>
        /// </li>
        /// <li>
        /// <p>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</p>
        /// </li>
        /// </ul>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions include both Glue service role permissions to Glue resources, and Amazon S3 permissions required by the transform. </p>
        ///
        /// <ul>
        /// <li>
        /// <p>This role needs Glue service role permissions to allow access to resources in Glue. See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access Glue</a>.</p>
        /// </li>
        /// <li>
        /// <p>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</p>
        /// </li>
        /// </ul>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
        pub fn glue_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.glue_version = Some(input.into());
            self
        }
        /// <p>This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.  For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in the developer guide.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.glue_version = input;
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
        /// processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
        /// information, see the <a href="http://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>. </p>
        ///
        /// <p>
        /// <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p>
        /// <ul>
        /// <li>
        /// <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>
        pub fn max_capacity(mut self, input: f64) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
        /// processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
        /// information, see the <a href="http://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>. </p>
        ///
        /// <p>
        /// <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p>
        /// <ul>
        /// <li>
        /// <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<f64>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p>
        /// <ul>
        /// <li>
        /// <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p>
        /// </li>
        /// </ul>
        pub fn worker_type(mut self, input: crate::model::WorkerType) -> Self {
            self.worker_type = Some(input);
            self
        }
        /// <p>The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p>
        /// <ul>
        /// <li>
        /// <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p>
        /// </li>
        /// <li>
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p>
        /// </li>
        /// </ul>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.worker_type = input;
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform runs.</p>
        ///
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        pub fn number_of_workers(mut self, input: i32) -> Self {
            self.number_of_workers = Some(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform runs.</p>
        ///
        /// <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_workers = input;
            self
        }
        /// <p>The timeout in minutes of the machine learning transform.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The timeout in minutes of the machine learning transform.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The maximum number of times to retry after an <code>MLTaskRun</code> of the machine
        /// learning transform fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times to retry after an <code>MLTaskRun</code> of the machine
        /// learning transform fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// <p>The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can access user data encrypted in Amazon S3 using KMS.</p>
        pub fn transform_encryption(mut self, input: crate::model::TransformEncryption) -> Self {
            self.transform_encryption = Some(input);
            self
        }
        /// <p>The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can access user data encrypted in Amazon S3 using KMS.</p>
        pub fn set_transform_encryption(
            mut self,
            input: std::option::Option<crate::model::TransformEncryption>,
        ) -> Self {
            self.transform_encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`MlTransform`](crate::model::MlTransform)
        pub fn build(self) -> crate::model::MlTransform {
            crate::model::MlTransform {
                transform_id: self.transform_id,
                name: self.name,
                description: self.description,
                status: self.status,
                created_on: self.created_on,
                last_modified_on: self.last_modified_on,
                input_record_tables: self.input_record_tables,
                parameters: self.parameters,
                evaluation_metrics: self.evaluation_metrics,
                label_count: self.label_count.unwrap_or_default(),
                schema: self.schema,
                role: self.role,
                glue_version: self.glue_version,
                max_capacity: self.max_capacity,
                worker_type: self.worker_type,
                number_of_workers: self.number_of_workers,
                timeout: self.timeout,
                max_retries: self.max_retries,
                transform_encryption: self.transform_encryption,
            }
        }
    }
}
impl MlTransform {
    /// Creates a new builder-style object to manufacture [`MlTransform`](crate::model::MlTransform)
    pub fn builder() -> crate::model::ml_transform::Builder {
        crate::model::ml_transform::Builder::default()
    }
}

/// <p>The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can access user data encrypted in Amazon S3 using KMS.</p>
///
/// <p>Additionally, imported labels and trained transforms can now be encrypted using a customer provided KMS key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformEncryption {
    /// <p>An <code>MLUserDataEncryption</code> object containing the encryption mode and customer-provided KMS key ID.</p>
    pub ml_user_data_encryption: std::option::Option<crate::model::MlUserDataEncryption>,
    /// <p>The name of the security configuration.</p>
    pub task_run_security_configuration_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TransformEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformEncryption");
        formatter.field("ml_user_data_encryption", &self.ml_user_data_encryption);
        formatter.field(
            "task_run_security_configuration_name",
            &self.task_run_security_configuration_name,
        );
        formatter.finish()
    }
}
/// See [`TransformEncryption`](crate::model::TransformEncryption)
pub mod transform_encryption {
    /// A builder for [`TransformEncryption`](crate::model::TransformEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_user_data_encryption: std::option::Option<crate::model::MlUserDataEncryption>,
        pub(crate) task_run_security_configuration_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An <code>MLUserDataEncryption</code> object containing the encryption mode and customer-provided KMS key ID.</p>
        pub fn ml_user_data_encryption(
            mut self,
            input: crate::model::MlUserDataEncryption,
        ) -> Self {
            self.ml_user_data_encryption = Some(input);
            self
        }
        /// <p>An <code>MLUserDataEncryption</code> object containing the encryption mode and customer-provided KMS key ID.</p>
        pub fn set_ml_user_data_encryption(
            mut self,
            input: std::option::Option<crate::model::MlUserDataEncryption>,
        ) -> Self {
            self.ml_user_data_encryption = input;
            self
        }
        /// <p>The name of the security configuration.</p>
        pub fn task_run_security_configuration_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.task_run_security_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the security configuration.</p>
        pub fn set_task_run_security_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_run_security_configuration_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformEncryption`](crate::model::TransformEncryption)
        pub fn build(self) -> crate::model::TransformEncryption {
            crate::model::TransformEncryption {
                ml_user_data_encryption: self.ml_user_data_encryption,
                task_run_security_configuration_name: self.task_run_security_configuration_name,
            }
        }
    }
}
impl TransformEncryption {
    /// Creates a new builder-style object to manufacture [`TransformEncryption`](crate::model::TransformEncryption)
    pub fn builder() -> crate::model::transform_encryption::Builder {
        crate::model::transform_encryption::Builder::default()
    }
}

/// <p>The encryption-at-rest settings of the transform that apply to accessing user data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MlUserDataEncryption {
    /// <p>The encryption mode applied to user data. Valid values are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>DISABLED: encryption is disabled</p>
    /// </li>
    /// <li>
    /// <p>SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in Amazon S3.</p>
    /// </li>
    /// </ul>
    pub ml_user_data_encryption_mode:
        std::option::Option<crate::model::MlUserDataEncryptionModeString>,
    /// <p>The ID for the customer-provided KMS key.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MlUserDataEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MlUserDataEncryption");
        formatter.field(
            "ml_user_data_encryption_mode",
            &self.ml_user_data_encryption_mode,
        );
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`MlUserDataEncryption`](crate::model::MlUserDataEncryption)
pub mod ml_user_data_encryption {
    /// A builder for [`MlUserDataEncryption`](crate::model::MlUserDataEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_user_data_encryption_mode:
            std::option::Option<crate::model::MlUserDataEncryptionModeString>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encryption mode applied to user data. Valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>DISABLED: encryption is disabled</p>
        /// </li>
        /// <li>
        /// <p>SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn ml_user_data_encryption_mode(
            mut self,
            input: crate::model::MlUserDataEncryptionModeString,
        ) -> Self {
            self.ml_user_data_encryption_mode = Some(input);
            self
        }
        /// <p>The encryption mode applied to user data. Valid values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>DISABLED: encryption is disabled</p>
        /// </li>
        /// <li>
        /// <p>SSEKMS: use of server-side encryption with Key Management Service (SSE-KMS) for user data stored in Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn set_ml_user_data_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::MlUserDataEncryptionModeString>,
        ) -> Self {
            self.ml_user_data_encryption_mode = input;
            self
        }
        /// <p>The ID for the customer-provided KMS key.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID for the customer-provided KMS key.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MlUserDataEncryption`](crate::model::MlUserDataEncryption)
        pub fn build(self) -> crate::model::MlUserDataEncryption {
            crate::model::MlUserDataEncryption {
                ml_user_data_encryption_mode: self.ml_user_data_encryption_mode,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl MlUserDataEncryption {
    /// Creates a new builder-style object to manufacture [`MlUserDataEncryption`](crate::model::MlUserDataEncryption)
    pub fn builder() -> crate::model::ml_user_data_encryption::Builder {
        crate::model::ml_user_data_encryption::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MlUserDataEncryptionModeString {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Ssekms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MlUserDataEncryptionModeString {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => MlUserDataEncryptionModeString::Disabled,
            "SSE-KMS" => MlUserDataEncryptionModeString::Ssekms,
            other => MlUserDataEncryptionModeString::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MlUserDataEncryptionModeString {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MlUserDataEncryptionModeString::from(s))
    }
}
impl MlUserDataEncryptionModeString {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MlUserDataEncryptionModeString::Disabled => "DISABLED",
            MlUserDataEncryptionModeString::Ssekms => "SSE-KMS",
            MlUserDataEncryptionModeString::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "SSE-KMS"]
    }
}
impl AsRef<str> for MlUserDataEncryptionModeString {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Evaluation metrics provide an estimate of the quality of your machine learning transform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationMetrics {
    /// <p>The type of machine learning transform.</p>
    pub transform_type: std::option::Option<crate::model::TransformType>,
    /// <p>The evaluation metrics for the find matches algorithm.</p>
    pub find_matches_metrics: std::option::Option<crate::model::FindMatchesMetrics>,
}
impl std::fmt::Debug for EvaluationMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationMetrics");
        formatter.field("transform_type", &self.transform_type);
        formatter.field("find_matches_metrics", &self.find_matches_metrics);
        formatter.finish()
    }
}
/// See [`EvaluationMetrics`](crate::model::EvaluationMetrics)
pub mod evaluation_metrics {
    /// A builder for [`EvaluationMetrics`](crate::model::EvaluationMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_type: std::option::Option<crate::model::TransformType>,
        pub(crate) find_matches_metrics: std::option::Option<crate::model::FindMatchesMetrics>,
    }
    impl Builder {
        /// <p>The type of machine learning transform.</p>
        pub fn transform_type(mut self, input: crate::model::TransformType) -> Self {
            self.transform_type = Some(input);
            self
        }
        /// <p>The type of machine learning transform.</p>
        pub fn set_transform_type(
            mut self,
            input: std::option::Option<crate::model::TransformType>,
        ) -> Self {
            self.transform_type = input;
            self
        }
        /// <p>The evaluation metrics for the find matches algorithm.</p>
        pub fn find_matches_metrics(mut self, input: crate::model::FindMatchesMetrics) -> Self {
            self.find_matches_metrics = Some(input);
            self
        }
        /// <p>The evaluation metrics for the find matches algorithm.</p>
        pub fn set_find_matches_metrics(
            mut self,
            input: std::option::Option<crate::model::FindMatchesMetrics>,
        ) -> Self {
            self.find_matches_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationMetrics`](crate::model::EvaluationMetrics)
        pub fn build(self) -> crate::model::EvaluationMetrics {
            crate::model::EvaluationMetrics {
                transform_type: self.transform_type,
                find_matches_metrics: self.find_matches_metrics,
            }
        }
    }
}
impl EvaluationMetrics {
    /// Creates a new builder-style object to manufacture [`EvaluationMetrics`](crate::model::EvaluationMetrics)
    pub fn builder() -> crate::model::evaluation_metrics::Builder {
        crate::model::evaluation_metrics::Builder::default()
    }
}

/// <p>The evaluation metrics for the find matches algorithm. The quality of your machine
/// learning transform is measured by getting your transform to predict some matches and comparing
/// the results to known matches from the same dataset. The quality metrics are based on a subset
/// of your data, so they are not precise.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindMatchesMetrics {
    /// <p>The area under the precision/recall curve (AUPRC) is a single number measuring the overall
    /// quality of the transform, that is independent of the choice made for precision vs. recall.
    /// Higher values indicate that you have a more attractive precision vs. recall tradeoff.</p>
    /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>
    pub area_under_pr_curve: std::option::Option<f64>,
    /// <p>The precision metric indicates when often your transform is correct when it predicts a match. Specifically, it measures how well the transform finds true positives from the total true positives possible.</p>
    /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>
    pub precision: std::option::Option<f64>,
    /// <p>The recall metric indicates that for an actual match, how often your transform predicts
    /// the match. Specifically, it measures how well the transform finds true positives from the
    /// total records in the source data.</p>
    /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>
    pub recall: std::option::Option<f64>,
    /// <p>The maximum F1 metric indicates the transform's accuracy between 0 and 1, where 1 is the best accuracy.</p>
    /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/F1_score">F1 score</a> in Wikipedia.</p>
    pub f1: std::option::Option<f64>,
    /// <p>The confusion matrix shows you what your transform is predicting accurately and what types of errors it is making.</p>
    /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Confusion_matrix">Confusion matrix</a> in Wikipedia.</p>
    pub confusion_matrix: std::option::Option<crate::model::ConfusionMatrix>,
    /// <p>A list of <code>ColumnImportance</code> structures containing column importance metrics, sorted in order of descending importance.</p>
    pub column_importances: std::option::Option<std::vec::Vec<crate::model::ColumnImportance>>,
}
impl std::fmt::Debug for FindMatchesMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindMatchesMetrics");
        formatter.field("area_under_pr_curve", &self.area_under_pr_curve);
        formatter.field("precision", &self.precision);
        formatter.field("recall", &self.recall);
        formatter.field("f1", &self.f1);
        formatter.field("confusion_matrix", &self.confusion_matrix);
        formatter.field("column_importances", &self.column_importances);
        formatter.finish()
    }
}
/// See [`FindMatchesMetrics`](crate::model::FindMatchesMetrics)
pub mod find_matches_metrics {
    /// A builder for [`FindMatchesMetrics`](crate::model::FindMatchesMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) area_under_pr_curve: std::option::Option<f64>,
        pub(crate) precision: std::option::Option<f64>,
        pub(crate) recall: std::option::Option<f64>,
        pub(crate) f1: std::option::Option<f64>,
        pub(crate) confusion_matrix: std::option::Option<crate::model::ConfusionMatrix>,
        pub(crate) column_importances:
            std::option::Option<std::vec::Vec<crate::model::ColumnImportance>>,
    }
    impl Builder {
        /// <p>The area under the precision/recall curve (AUPRC) is a single number measuring the overall
        /// quality of the transform, that is independent of the choice made for precision vs. recall.
        /// Higher values indicate that you have a more attractive precision vs. recall tradeoff.</p>
        /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>
        pub fn area_under_pr_curve(mut self, input: f64) -> Self {
            self.area_under_pr_curve = Some(input);
            self
        }
        /// <p>The area under the precision/recall curve (AUPRC) is a single number measuring the overall
        /// quality of the transform, that is independent of the choice made for precision vs. recall.
        /// Higher values indicate that you have a more attractive precision vs. recall tradeoff.</p>
        /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>
        pub fn set_area_under_pr_curve(mut self, input: std::option::Option<f64>) -> Self {
            self.area_under_pr_curve = input;
            self
        }
        /// <p>The precision metric indicates when often your transform is correct when it predicts a match. Specifically, it measures how well the transform finds true positives from the total true positives possible.</p>
        /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>
        pub fn precision(mut self, input: f64) -> Self {
            self.precision = Some(input);
            self
        }
        /// <p>The precision metric indicates when often your transform is correct when it predicts a match. Specifically, it measures how well the transform finds true positives from the total true positives possible.</p>
        /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>
        pub fn set_precision(mut self, input: std::option::Option<f64>) -> Self {
            self.precision = input;
            self
        }
        /// <p>The recall metric indicates that for an actual match, how often your transform predicts
        /// the match. Specifically, it measures how well the transform finds true positives from the
        /// total records in the source data.</p>
        /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>
        pub fn recall(mut self, input: f64) -> Self {
            self.recall = Some(input);
            self
        }
        /// <p>The recall metric indicates that for an actual match, how often your transform predicts
        /// the match. Specifically, it measures how well the transform finds true positives from the
        /// total records in the source data.</p>
        /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>
        pub fn set_recall(mut self, input: std::option::Option<f64>) -> Self {
            self.recall = input;
            self
        }
        /// <p>The maximum F1 metric indicates the transform's accuracy between 0 and 1, where 1 is the best accuracy.</p>
        /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/F1_score">F1 score</a> in Wikipedia.</p>
        pub fn f1(mut self, input: f64) -> Self {
            self.f1 = Some(input);
            self
        }
        /// <p>The maximum F1 metric indicates the transform's accuracy between 0 and 1, where 1 is the best accuracy.</p>
        /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/F1_score">F1 score</a> in Wikipedia.</p>
        pub fn set_f1(mut self, input: std::option::Option<f64>) -> Self {
            self.f1 = input;
            self
        }
        /// <p>The confusion matrix shows you what your transform is predicting accurately and what types of errors it is making.</p>
        /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Confusion_matrix">Confusion matrix</a> in Wikipedia.</p>
        pub fn confusion_matrix(mut self, input: crate::model::ConfusionMatrix) -> Self {
            self.confusion_matrix = Some(input);
            self
        }
        /// <p>The confusion matrix shows you what your transform is predicting accurately and what types of errors it is making.</p>
        /// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Confusion_matrix">Confusion matrix</a> in Wikipedia.</p>
        pub fn set_confusion_matrix(
            mut self,
            input: std::option::Option<crate::model::ConfusionMatrix>,
        ) -> Self {
            self.confusion_matrix = input;
            self
        }
        /// Appends an item to `column_importances`.
        ///
        /// To override the contents of this collection use [`set_column_importances`](Self::set_column_importances).
        ///
        /// <p>A list of <code>ColumnImportance</code> structures containing column importance metrics, sorted in order of descending importance.</p>
        pub fn column_importances(
            mut self,
            input: impl Into<crate::model::ColumnImportance>,
        ) -> Self {
            let mut v = self.column_importances.unwrap_or_default();
            v.push(input.into());
            self.column_importances = Some(v);
            self
        }
        /// <p>A list of <code>ColumnImportance</code> structures containing column importance metrics, sorted in order of descending importance.</p>
        pub fn set_column_importances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnImportance>>,
        ) -> Self {
            self.column_importances = input;
            self
        }
        /// Consumes the builder and constructs a [`FindMatchesMetrics`](crate::model::FindMatchesMetrics)
        pub fn build(self) -> crate::model::FindMatchesMetrics {
            crate::model::FindMatchesMetrics {
                area_under_pr_curve: self.area_under_pr_curve,
                precision: self.precision,
                recall: self.recall,
                f1: self.f1,
                confusion_matrix: self.confusion_matrix,
                column_importances: self.column_importances,
            }
        }
    }
}
impl FindMatchesMetrics {
    /// Creates a new builder-style object to manufacture [`FindMatchesMetrics`](crate::model::FindMatchesMetrics)
    pub fn builder() -> crate::model::find_matches_metrics::Builder {
        crate::model::find_matches_metrics::Builder::default()
    }
}

/// <p>A structure containing the column name and column importance score for a column. </p>
///
/// <p>Column importance helps you understand how columns contribute to your model, by identifying which columns in your records are more important than others.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnImportance {
    /// <p>The name of a column.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>The column importance score for the column, as a decimal.</p>
    pub importance: std::option::Option<f64>,
}
impl std::fmt::Debug for ColumnImportance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnImportance");
        formatter.field("column_name", &self.column_name);
        formatter.field("importance", &self.importance);
        formatter.finish()
    }
}
/// See [`ColumnImportance`](crate::model::ColumnImportance)
pub mod column_importance {
    /// A builder for [`ColumnImportance`](crate::model::ColumnImportance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) importance: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of a column.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>The name of a column.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// <p>The column importance score for the column, as a decimal.</p>
        pub fn importance(mut self, input: f64) -> Self {
            self.importance = Some(input);
            self
        }
        /// <p>The column importance score for the column, as a decimal.</p>
        pub fn set_importance(mut self, input: std::option::Option<f64>) -> Self {
            self.importance = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnImportance`](crate::model::ColumnImportance)
        pub fn build(self) -> crate::model::ColumnImportance {
            crate::model::ColumnImportance {
                column_name: self.column_name,
                importance: self.importance,
            }
        }
    }
}
impl ColumnImportance {
    /// Creates a new builder-style object to manufacture [`ColumnImportance`](crate::model::ColumnImportance)
    pub fn builder() -> crate::model::column_importance::Builder {
        crate::model::column_importance::Builder::default()
    }
}

/// <p>The confusion matrix shows you what your transform is predicting accurately and what types of errors it is making.</p>
///
/// <p>For more information, see <a href="https://en.wikipedia.org/wiki/Confusion_matrix">Confusion matrix</a> in Wikipedia.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfusionMatrix {
    /// <p>The number of matches in the data that the transform correctly found, in the confusion matrix for your transform.</p>
    pub num_true_positives: std::option::Option<i64>,
    /// <p>The number of nonmatches in the data that the transform incorrectly classified as a match,
    /// in the confusion matrix for your transform.</p>
    pub num_false_positives: std::option::Option<i64>,
    /// <p>The number of nonmatches in the data that the transform correctly rejected, in the
    /// confusion matrix for your transform.</p>
    pub num_true_negatives: std::option::Option<i64>,
    /// <p>The number of matches in the data that the transform didn't find, in the confusion matrix for your transform.</p>
    pub num_false_negatives: std::option::Option<i64>,
}
impl std::fmt::Debug for ConfusionMatrix {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfusionMatrix");
        formatter.field("num_true_positives", &self.num_true_positives);
        formatter.field("num_false_positives", &self.num_false_positives);
        formatter.field("num_true_negatives", &self.num_true_negatives);
        formatter.field("num_false_negatives", &self.num_false_negatives);
        formatter.finish()
    }
}
/// See [`ConfusionMatrix`](crate::model::ConfusionMatrix)
pub mod confusion_matrix {
    /// A builder for [`ConfusionMatrix`](crate::model::ConfusionMatrix)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) num_true_positives: std::option::Option<i64>,
        pub(crate) num_false_positives: std::option::Option<i64>,
        pub(crate) num_true_negatives: std::option::Option<i64>,
        pub(crate) num_false_negatives: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of matches in the data that the transform correctly found, in the confusion matrix for your transform.</p>
        pub fn num_true_positives(mut self, input: i64) -> Self {
            self.num_true_positives = Some(input);
            self
        }
        /// <p>The number of matches in the data that the transform correctly found, in the confusion matrix for your transform.</p>
        pub fn set_num_true_positives(mut self, input: std::option::Option<i64>) -> Self {
            self.num_true_positives = input;
            self
        }
        /// <p>The number of nonmatches in the data that the transform incorrectly classified as a match,
        /// in the confusion matrix for your transform.</p>
        pub fn num_false_positives(mut self, input: i64) -> Self {
            self.num_false_positives = Some(input);
            self
        }
        /// <p>The number of nonmatches in the data that the transform incorrectly classified as a match,
        /// in the confusion matrix for your transform.</p>
        pub fn set_num_false_positives(mut self, input: std::option::Option<i64>) -> Self {
            self.num_false_positives = input;
            self
        }
        /// <p>The number of nonmatches in the data that the transform correctly rejected, in the
        /// confusion matrix for your transform.</p>
        pub fn num_true_negatives(mut self, input: i64) -> Self {
            self.num_true_negatives = Some(input);
            self
        }
        /// <p>The number of nonmatches in the data that the transform correctly rejected, in the
        /// confusion matrix for your transform.</p>
        pub fn set_num_true_negatives(mut self, input: std::option::Option<i64>) -> Self {
            self.num_true_negatives = input;
            self
        }
        /// <p>The number of matches in the data that the transform didn't find, in the confusion matrix for your transform.</p>
        pub fn num_false_negatives(mut self, input: i64) -> Self {
            self.num_false_negatives = Some(input);
            self
        }
        /// <p>The number of matches in the data that the transform didn't find, in the confusion matrix for your transform.</p>
        pub fn set_num_false_negatives(mut self, input: std::option::Option<i64>) -> Self {
            self.num_false_negatives = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfusionMatrix`](crate::model::ConfusionMatrix)
        pub fn build(self) -> crate::model::ConfusionMatrix {
            crate::model::ConfusionMatrix {
                num_true_positives: self.num_true_positives,
                num_false_positives: self.num_false_positives,
                num_true_negatives: self.num_true_negatives,
                num_false_negatives: self.num_false_negatives,
            }
        }
    }
}
impl ConfusionMatrix {
    /// Creates a new builder-style object to manufacture [`ConfusionMatrix`](crate::model::ConfusionMatrix)
    pub fn builder() -> crate::model::confusion_matrix::Builder {
        crate::model::confusion_matrix::Builder::default()
    }
}

/// <p>The database and table in the Glue Data Catalog that is used for input or output data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlueTable {
    /// <p>A database name in the Glue Data Catalog.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>A table name in the Glue Data Catalog.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the Glue Data Catalog.</p>
    pub catalog_id: std::option::Option<std::string::String>,
    /// <p>The name of the connection to the Glue Data Catalog.</p>
    pub connection_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GlueTable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlueTable");
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("catalog_id", &self.catalog_id);
        formatter.field("connection_name", &self.connection_name);
        formatter.finish()
    }
}
/// See [`GlueTable`](crate::model::GlueTable)
pub mod glue_table {
    /// A builder for [`GlueTable`](crate::model::GlueTable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) catalog_id: std::option::Option<std::string::String>,
        pub(crate) connection_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A database name in the Glue Data Catalog.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>A database name in the Glue Data Catalog.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>A table name in the Glue Data Catalog.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>A table name in the Glue Data Catalog.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>A unique identifier for the Glue Data Catalog.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the Glue Data Catalog.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// <p>The name of the connection to the Glue Data Catalog.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The name of the connection to the Glue Data Catalog.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GlueTable`](crate::model::GlueTable)
        pub fn build(self) -> crate::model::GlueTable {
            crate::model::GlueTable {
                database_name: self.database_name,
                table_name: self.table_name,
                catalog_id: self.catalog_id,
                connection_name: self.connection_name,
            }
        }
    }
}
impl GlueTable {
    /// Creates a new builder-style object to manufacture [`GlueTable`](crate::model::GlueTable)
    pub fn builder() -> crate::model::glue_table::Builder {
        crate::model::glue_table::Builder::default()
    }
}

/// <p>The sampling parameters that are associated with the machine learning transform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskRun {
    /// <p>The unique identifier for the transform.</p>
    pub transform_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for this task run.</p>
    pub task_run_id: std::option::Option<std::string::String>,
    /// <p>The current status of the requested task run.</p>
    pub status: std::option::Option<crate::model::TaskStatusType>,
    /// <p>The names of the log group for secure logging, associated with this task run.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies configuration properties associated with this task run.</p>
    pub properties: std::option::Option<crate::model::TaskRunProperties>,
    /// <p>The list of error strings associated with this task run.</p>
    pub error_string: std::option::Option<std::string::String>,
    /// <p>The date and time that this task run started.</p>
    pub started_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last point in time that the requested task run was updated.</p>
    pub last_modified_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last point in time that the requested task run was completed.</p>
    pub completed_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The amount of time (in seconds) that the task run consumed resources.</p>
    pub execution_time: i32,
}
impl std::fmt::Debug for TaskRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskRun");
        formatter.field("transform_id", &self.transform_id);
        formatter.field("task_run_id", &self.task_run_id);
        formatter.field("status", &self.status);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("properties", &self.properties);
        formatter.field("error_string", &self.error_string);
        formatter.field("started_on", &self.started_on);
        formatter.field("last_modified_on", &self.last_modified_on);
        formatter.field("completed_on", &self.completed_on);
        formatter.field("execution_time", &self.execution_time);
        formatter.finish()
    }
}
/// See [`TaskRun`](crate::model::TaskRun)
pub mod task_run {
    /// A builder for [`TaskRun`](crate::model::TaskRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_id: std::option::Option<std::string::String>,
        pub(crate) task_run_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TaskStatusType>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<crate::model::TaskRunProperties>,
        pub(crate) error_string: std::option::Option<std::string::String>,
        pub(crate) started_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) execution_time: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the transform.</p>
        pub fn transform_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the transform.</p>
        pub fn set_transform_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.transform_id = input;
            self
        }
        /// <p>The unique identifier for this task run.</p>
        pub fn task_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_run_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for this task run.</p>
        pub fn set_task_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_run_id = input;
            self
        }
        /// <p>The current status of the requested task run.</p>
        pub fn status(mut self, input: crate::model::TaskStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the requested task run.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The names of the log group for secure logging, associated with this task run.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The names of the log group for secure logging, associated with this task run.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// <p>Specifies configuration properties associated with this task run.</p>
        pub fn properties(mut self, input: crate::model::TaskRunProperties) -> Self {
            self.properties = Some(input);
            self
        }
        /// <p>Specifies configuration properties associated with this task run.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<crate::model::TaskRunProperties>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// <p>The list of error strings associated with this task run.</p>
        pub fn error_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_string = Some(input.into());
            self
        }
        /// <p>The list of error strings associated with this task run.</p>
        pub fn set_error_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_string = input;
            self
        }
        /// <p>The date and time that this task run started.</p>
        pub fn started_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_on = Some(input);
            self
        }
        /// <p>The date and time that this task run started.</p>
        pub fn set_started_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_on = input;
            self
        }
        /// <p>The last point in time that the requested task run was updated.</p>
        pub fn last_modified_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_on = Some(input);
            self
        }
        /// <p>The last point in time that the requested task run was updated.</p>
        pub fn set_last_modified_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_on = input;
            self
        }
        /// <p>The last point in time that the requested task run was completed.</p>
        pub fn completed_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_on = Some(input);
            self
        }
        /// <p>The last point in time that the requested task run was completed.</p>
        pub fn set_completed_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_on = input;
            self
        }
        /// <p>The amount of time (in seconds) that the task run consumed resources.</p>
        pub fn execution_time(mut self, input: i32) -> Self {
            self.execution_time = Some(input);
            self
        }
        /// <p>The amount of time (in seconds) that the task run consumed resources.</p>
        pub fn set_execution_time(mut self, input: std::option::Option<i32>) -> Self {
            self.execution_time = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskRun`](crate::model::TaskRun)
        pub fn build(self) -> crate::model::TaskRun {
            crate::model::TaskRun {
                transform_id: self.transform_id,
                task_run_id: self.task_run_id,
                status: self.status,
                log_group_name: self.log_group_name,
                properties: self.properties,
                error_string: self.error_string,
                started_on: self.started_on,
                last_modified_on: self.last_modified_on,
                completed_on: self.completed_on,
                execution_time: self.execution_time.unwrap_or_default(),
            }
        }
    }
}
impl TaskRun {
    /// Creates a new builder-style object to manufacture [`TaskRun`](crate::model::TaskRun)
    pub fn builder() -> crate::model::task_run::Builder {
        crate::model::task_run::Builder::default()
    }
}

/// <p>The configuration properties for the task run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskRunProperties {
    /// <p>The type of task run.</p>
    pub task_type: std::option::Option<crate::model::TaskType>,
    /// <p>The configuration properties for an importing labels task run.</p>
    pub import_labels_task_run_properties:
        std::option::Option<crate::model::ImportLabelsTaskRunProperties>,
    /// <p>The configuration properties for an exporting labels task run.</p>
    pub export_labels_task_run_properties:
        std::option::Option<crate::model::ExportLabelsTaskRunProperties>,
    /// <p>The configuration properties for a labeling set generation task run.</p>
    pub labeling_set_generation_task_run_properties:
        std::option::Option<crate::model::LabelingSetGenerationTaskRunProperties>,
    /// <p>The configuration properties for a find matches task run.</p>
    pub find_matches_task_run_properties:
        std::option::Option<crate::model::FindMatchesTaskRunProperties>,
}
impl std::fmt::Debug for TaskRunProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskRunProperties");
        formatter.field("task_type", &self.task_type);
        formatter.field(
            "import_labels_task_run_properties",
            &self.import_labels_task_run_properties,
        );
        formatter.field(
            "export_labels_task_run_properties",
            &self.export_labels_task_run_properties,
        );
        formatter.field(
            "labeling_set_generation_task_run_properties",
            &self.labeling_set_generation_task_run_properties,
        );
        formatter.field(
            "find_matches_task_run_properties",
            &self.find_matches_task_run_properties,
        );
        formatter.finish()
    }
}
/// See [`TaskRunProperties`](crate::model::TaskRunProperties)
pub mod task_run_properties {
    /// A builder for [`TaskRunProperties`](crate::model::TaskRunProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_type: std::option::Option<crate::model::TaskType>,
        pub(crate) import_labels_task_run_properties:
            std::option::Option<crate::model::ImportLabelsTaskRunProperties>,
        pub(crate) export_labels_task_run_properties:
            std::option::Option<crate::model::ExportLabelsTaskRunProperties>,
        pub(crate) labeling_set_generation_task_run_properties:
            std::option::Option<crate::model::LabelingSetGenerationTaskRunProperties>,
        pub(crate) find_matches_task_run_properties:
            std::option::Option<crate::model::FindMatchesTaskRunProperties>,
    }
    impl Builder {
        /// <p>The type of task run.</p>
        pub fn task_type(mut self, input: crate::model::TaskType) -> Self {
            self.task_type = Some(input);
            self
        }
        /// <p>The type of task run.</p>
        pub fn set_task_type(mut self, input: std::option::Option<crate::model::TaskType>) -> Self {
            self.task_type = input;
            self
        }
        /// <p>The configuration properties for an importing labels task run.</p>
        pub fn import_labels_task_run_properties(
            mut self,
            input: crate::model::ImportLabelsTaskRunProperties,
        ) -> Self {
            self.import_labels_task_run_properties = Some(input);
            self
        }
        /// <p>The configuration properties for an importing labels task run.</p>
        pub fn set_import_labels_task_run_properties(
            mut self,
            input: std::option::Option<crate::model::ImportLabelsTaskRunProperties>,
        ) -> Self {
            self.import_labels_task_run_properties = input;
            self
        }
        /// <p>The configuration properties for an exporting labels task run.</p>
        pub fn export_labels_task_run_properties(
            mut self,
            input: crate::model::ExportLabelsTaskRunProperties,
        ) -> Self {
            self.export_labels_task_run_properties = Some(input);
            self
        }
        /// <p>The configuration properties for an exporting labels task run.</p>
        pub fn set_export_labels_task_run_properties(
            mut self,
            input: std::option::Option<crate::model::ExportLabelsTaskRunProperties>,
        ) -> Self {
            self.export_labels_task_run_properties = input;
            self
        }
        /// <p>The configuration properties for a labeling set generation task run.</p>
        pub fn labeling_set_generation_task_run_properties(
            mut self,
            input: crate::model::LabelingSetGenerationTaskRunProperties,
        ) -> Self {
            self.labeling_set_generation_task_run_properties = Some(input);
            self
        }
        /// <p>The configuration properties for a labeling set generation task run.</p>
        pub fn set_labeling_set_generation_task_run_properties(
            mut self,
            input: std::option::Option<crate::model::LabelingSetGenerationTaskRunProperties>,
        ) -> Self {
            self.labeling_set_generation_task_run_properties = input;
            self
        }
        /// <p>The configuration properties for a find matches task run.</p>
        pub fn find_matches_task_run_properties(
            mut self,
            input: crate::model::FindMatchesTaskRunProperties,
        ) -> Self {
            self.find_matches_task_run_properties = Some(input);
            self
        }
        /// <p>The configuration properties for a find matches task run.</p>
        pub fn set_find_matches_task_run_properties(
            mut self,
            input: std::option::Option<crate::model::FindMatchesTaskRunProperties>,
        ) -> Self {
            self.find_matches_task_run_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskRunProperties`](crate::model::TaskRunProperties)
        pub fn build(self) -> crate::model::TaskRunProperties {
            crate::model::TaskRunProperties {
                task_type: self.task_type,
                import_labels_task_run_properties: self.import_labels_task_run_properties,
                export_labels_task_run_properties: self.export_labels_task_run_properties,
                labeling_set_generation_task_run_properties: self
                    .labeling_set_generation_task_run_properties,
                find_matches_task_run_properties: self.find_matches_task_run_properties,
            }
        }
    }
}
impl TaskRunProperties {
    /// Creates a new builder-style object to manufacture [`TaskRunProperties`](crate::model::TaskRunProperties)
    pub fn builder() -> crate::model::task_run_properties::Builder {
        crate::model::task_run_properties::Builder::default()
    }
}

/// <p>Specifies configuration properties for a Find Matches task run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindMatchesTaskRunProperties {
    /// <p>The job ID for the Find Matches task run.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The name assigned to the job for the Find Matches task run.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The job run ID for the Find Matches task run.</p>
    pub job_run_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FindMatchesTaskRunProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindMatchesTaskRunProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_run_id", &self.job_run_id);
        formatter.finish()
    }
}
/// See [`FindMatchesTaskRunProperties`](crate::model::FindMatchesTaskRunProperties)
pub mod find_matches_task_run_properties {
    /// A builder for [`FindMatchesTaskRunProperties`](crate::model::FindMatchesTaskRunProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_run_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job ID for the Find Matches task run.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job ID for the Find Matches task run.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The name assigned to the job for the Find Matches task run.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name assigned to the job for the Find Matches task run.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The job run ID for the Find Matches task run.</p>
        pub fn job_run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_run_id = Some(input.into());
            self
        }
        /// <p>The job run ID for the Find Matches task run.</p>
        pub fn set_job_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_run_id = input;
            self
        }
        /// Consumes the builder and constructs a [`FindMatchesTaskRunProperties`](crate::model::FindMatchesTaskRunProperties)
        pub fn build(self) -> crate::model::FindMatchesTaskRunProperties {
            crate::model::FindMatchesTaskRunProperties {
                job_id: self.job_id,
                job_name: self.job_name,
                job_run_id: self.job_run_id,
            }
        }
    }
}
impl FindMatchesTaskRunProperties {
    /// Creates a new builder-style object to manufacture [`FindMatchesTaskRunProperties`](crate::model::FindMatchesTaskRunProperties)
    pub fn builder() -> crate::model::find_matches_task_run_properties::Builder {
        crate::model::find_matches_task_run_properties::Builder::default()
    }
}

/// <p>Specifies configuration properties for a labeling set generation task run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LabelingSetGenerationTaskRunProperties {
    /// <p>The Amazon Simple Storage Service (Amazon S3) path where you will generate the labeling
    /// set.</p>
    pub output_s3_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LabelingSetGenerationTaskRunProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LabelingSetGenerationTaskRunProperties");
        formatter.field("output_s3_path", &self.output_s3_path);
        formatter.finish()
    }
}
/// See [`LabelingSetGenerationTaskRunProperties`](crate::model::LabelingSetGenerationTaskRunProperties)
pub mod labeling_set_generation_task_run_properties {
    /// A builder for [`LabelingSetGenerationTaskRunProperties`](crate::model::LabelingSetGenerationTaskRunProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_s3_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Simple Storage Service (Amazon S3) path where you will generate the labeling
        /// set.</p>
        pub fn output_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_path = Some(input.into());
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path where you will generate the labeling
        /// set.</p>
        pub fn set_output_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_path = input;
            self
        }
        /// Consumes the builder and constructs a [`LabelingSetGenerationTaskRunProperties`](crate::model::LabelingSetGenerationTaskRunProperties)
        pub fn build(self) -> crate::model::LabelingSetGenerationTaskRunProperties {
            crate::model::LabelingSetGenerationTaskRunProperties {
                output_s3_path: self.output_s3_path,
            }
        }
    }
}
impl LabelingSetGenerationTaskRunProperties {
    /// Creates a new builder-style object to manufacture [`LabelingSetGenerationTaskRunProperties`](crate::model::LabelingSetGenerationTaskRunProperties)
    pub fn builder() -> crate::model::labeling_set_generation_task_run_properties::Builder {
        crate::model::labeling_set_generation_task_run_properties::Builder::default()
    }
}

/// <p>Specifies configuration properties for an exporting labels task run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportLabelsTaskRunProperties {
    /// <p>The Amazon Simple Storage Service (Amazon S3) path where you will export the
    /// labels.</p>
    pub output_s3_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExportLabelsTaskRunProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportLabelsTaskRunProperties");
        formatter.field("output_s3_path", &self.output_s3_path);
        formatter.finish()
    }
}
/// See [`ExportLabelsTaskRunProperties`](crate::model::ExportLabelsTaskRunProperties)
pub mod export_labels_task_run_properties {
    /// A builder for [`ExportLabelsTaskRunProperties`](crate::model::ExportLabelsTaskRunProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_s3_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Simple Storage Service (Amazon S3) path where you will export the
        /// labels.</p>
        pub fn output_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_s3_path = Some(input.into());
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path where you will export the
        /// labels.</p>
        pub fn set_output_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_s3_path = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportLabelsTaskRunProperties`](crate::model::ExportLabelsTaskRunProperties)
        pub fn build(self) -> crate::model::ExportLabelsTaskRunProperties {
            crate::model::ExportLabelsTaskRunProperties {
                output_s3_path: self.output_s3_path,
            }
        }
    }
}
impl ExportLabelsTaskRunProperties {
    /// Creates a new builder-style object to manufacture [`ExportLabelsTaskRunProperties`](crate::model::ExportLabelsTaskRunProperties)
    pub fn builder() -> crate::model::export_labels_task_run_properties::Builder {
        crate::model::export_labels_task_run_properties::Builder::default()
    }
}

/// <p>Specifies configuration properties for an importing labels task run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportLabelsTaskRunProperties {
    /// <p>The Amazon Simple Storage Service (Amazon S3) path from where you will import the
    /// labels.</p>
    pub input_s3_path: std::option::Option<std::string::String>,
    /// <p>Indicates whether to overwrite your existing labels.</p>
    pub replace: bool,
}
impl std::fmt::Debug for ImportLabelsTaskRunProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportLabelsTaskRunProperties");
        formatter.field("input_s3_path", &self.input_s3_path);
        formatter.field("replace", &self.replace);
        formatter.finish()
    }
}
/// See [`ImportLabelsTaskRunProperties`](crate::model::ImportLabelsTaskRunProperties)
pub mod import_labels_task_run_properties {
    /// A builder for [`ImportLabelsTaskRunProperties`](crate::model::ImportLabelsTaskRunProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_s3_path: std::option::Option<std::string::String>,
        pub(crate) replace: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Simple Storage Service (Amazon S3) path from where you will import the
        /// labels.</p>
        pub fn input_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_s3_path = Some(input.into());
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path from where you will import the
        /// labels.</p>
        pub fn set_input_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_s3_path = input;
            self
        }
        /// <p>Indicates whether to overwrite your existing labels.</p>
        pub fn replace(mut self, input: bool) -> Self {
            self.replace = Some(input);
            self
        }
        /// <p>Indicates whether to overwrite your existing labels.</p>
        pub fn set_replace(mut self, input: std::option::Option<bool>) -> Self {
            self.replace = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportLabelsTaskRunProperties`](crate::model::ImportLabelsTaskRunProperties)
        pub fn build(self) -> crate::model::ImportLabelsTaskRunProperties {
            crate::model::ImportLabelsTaskRunProperties {
                input_s3_path: self.input_s3_path,
                replace: self.replace.unwrap_or_default(),
            }
        }
    }
}
impl ImportLabelsTaskRunProperties {
    /// Creates a new builder-style object to manufacture [`ImportLabelsTaskRunProperties`](crate::model::ImportLabelsTaskRunProperties)
    pub fn builder() -> crate::model::import_labels_task_run_properties::Builder {
        crate::model::import_labels_task_run_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskType {
    #[allow(missing_docs)] // documentation missing in model
    Evaluation,
    #[allow(missing_docs)] // documentation missing in model
    ExportLabels,
    #[allow(missing_docs)] // documentation missing in model
    FindMatches,
    #[allow(missing_docs)] // documentation missing in model
    ImportLabels,
    #[allow(missing_docs)] // documentation missing in model
    LabelingSetGeneration,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskType {
    fn from(s: &str) -> Self {
        match s {
            "EVALUATION" => TaskType::Evaluation,
            "EXPORT_LABELS" => TaskType::ExportLabels,
            "FIND_MATCHES" => TaskType::FindMatches,
            "IMPORT_LABELS" => TaskType::ImportLabels,
            "LABELING_SET_GENERATION" => TaskType::LabelingSetGeneration,
            other => TaskType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskType::from(s))
    }
}
impl TaskType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskType::Evaluation => "EVALUATION",
            TaskType::ExportLabels => "EXPORT_LABELS",
            TaskType::FindMatches => "FIND_MATCHES",
            TaskType::ImportLabels => "IMPORT_LABELS",
            TaskType::LabelingSetGeneration => "LABELING_SET_GENERATION",
            TaskType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EVALUATION",
            "EXPORT_LABELS",
            "FIND_MATCHES",
            "IMPORT_LABELS",
            "LABELING_SET_GENERATION",
        ]
    }
}
impl AsRef<str> for TaskType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    Timeout,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskStatusType {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => TaskStatusType::Failed,
            "RUNNING" => TaskStatusType::Running,
            "STARTING" => TaskStatusType::Starting,
            "STOPPED" => TaskStatusType::Stopped,
            "STOPPING" => TaskStatusType::Stopping,
            "SUCCEEDED" => TaskStatusType::Succeeded,
            "TIMEOUT" => TaskStatusType::Timeout,
            other => TaskStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskStatusType::from(s))
    }
}
impl TaskStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskStatusType::Failed => "FAILED",
            TaskStatusType::Running => "RUNNING",
            TaskStatusType::Starting => "STARTING",
            TaskStatusType::Stopped => "STOPPED",
            TaskStatusType::Stopping => "STOPPING",
            TaskStatusType::Succeeded => "SUCCEEDED",
            TaskStatusType::Timeout => "TIMEOUT",
            TaskStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "RUNNING",
            "STARTING",
            "STOPPED",
            "STOPPING",
            "SUCCEEDED",
            "TIMEOUT",
        ]
    }
}
impl AsRef<str> for TaskStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The sorting criteria that are used to sort the list of task runs for the machine learning
/// transform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskRunSortCriteria {
    /// <p>The column to be used to sort the list of task runs for the machine learning
    /// transform.</p>
    pub column: std::option::Option<crate::model::TaskRunSortColumnType>,
    /// <p>The sort direction to be used to sort the list of task runs for the machine learning
    /// transform.</p>
    pub sort_direction: std::option::Option<crate::model::SortDirectionType>,
}
impl std::fmt::Debug for TaskRunSortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskRunSortCriteria");
        formatter.field("column", &self.column);
        formatter.field("sort_direction", &self.sort_direction);
        formatter.finish()
    }
}
/// See [`TaskRunSortCriteria`](crate::model::TaskRunSortCriteria)
pub mod task_run_sort_criteria {
    /// A builder for [`TaskRunSortCriteria`](crate::model::TaskRunSortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column: std::option::Option<crate::model::TaskRunSortColumnType>,
        pub(crate) sort_direction: std::option::Option<crate::model::SortDirectionType>,
    }
    impl Builder {
        /// <p>The column to be used to sort the list of task runs for the machine learning
        /// transform.</p>
        pub fn column(mut self, input: crate::model::TaskRunSortColumnType) -> Self {
            self.column = Some(input);
            self
        }
        /// <p>The column to be used to sort the list of task runs for the machine learning
        /// transform.</p>
        pub fn set_column(
            mut self,
            input: std::option::Option<crate::model::TaskRunSortColumnType>,
        ) -> Self {
            self.column = input;
            self
        }
        /// <p>The sort direction to be used to sort the list of task runs for the machine learning
        /// transform.</p>
        pub fn sort_direction(mut self, input: crate::model::SortDirectionType) -> Self {
            self.sort_direction = Some(input);
            self
        }
        /// <p>The sort direction to be used to sort the list of task runs for the machine learning
        /// transform.</p>
        pub fn set_sort_direction(
            mut self,
            input: std::option::Option<crate::model::SortDirectionType>,
        ) -> Self {
            self.sort_direction = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskRunSortCriteria`](crate::model::TaskRunSortCriteria)
        pub fn build(self) -> crate::model::TaskRunSortCriteria {
            crate::model::TaskRunSortCriteria {
                column: self.column,
                sort_direction: self.sort_direction,
            }
        }
    }
}
impl TaskRunSortCriteria {
    /// Creates a new builder-style object to manufacture [`TaskRunSortCriteria`](crate::model::TaskRunSortCriteria)
    pub fn builder() -> crate::model::task_run_sort_criteria::Builder {
        crate::model::task_run_sort_criteria::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskRunSortColumnType {
    #[allow(missing_docs)] // documentation missing in model
    Started,
    #[allow(missing_docs)] // documentation missing in model
    Status,
    #[allow(missing_docs)] // documentation missing in model
    TaskRunType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskRunSortColumnType {
    fn from(s: &str) -> Self {
        match s {
            "STARTED" => TaskRunSortColumnType::Started,
            "STATUS" => TaskRunSortColumnType::Status,
            "TASK_RUN_TYPE" => TaskRunSortColumnType::TaskRunType,
            other => TaskRunSortColumnType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskRunSortColumnType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskRunSortColumnType::from(s))
    }
}
impl TaskRunSortColumnType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskRunSortColumnType::Started => "STARTED",
            TaskRunSortColumnType::Status => "STATUS",
            TaskRunSortColumnType::TaskRunType => "TASK_RUN_TYPE",
            TaskRunSortColumnType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STARTED", "STATUS", "TASK_RUN_TYPE"]
    }
}
impl AsRef<str> for TaskRunSortColumnType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The criteria that are used to filter the task runs for the machine learning
/// transform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskRunFilterCriteria {
    /// <p>The type of task run.</p>
    pub task_run_type: std::option::Option<crate::model::TaskType>,
    /// <p>The current status of the task run.</p>
    pub status: std::option::Option<crate::model::TaskStatusType>,
    /// <p>Filter on task runs started before this date.</p>
    pub started_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Filter on task runs started after this date.</p>
    pub started_after: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for TaskRunFilterCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskRunFilterCriteria");
        formatter.field("task_run_type", &self.task_run_type);
        formatter.field("status", &self.status);
        formatter.field("started_before", &self.started_before);
        formatter.field("started_after", &self.started_after);
        formatter.finish()
    }
}
/// See [`TaskRunFilterCriteria`](crate::model::TaskRunFilterCriteria)
pub mod task_run_filter_criteria {
    /// A builder for [`TaskRunFilterCriteria`](crate::model::TaskRunFilterCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_run_type: std::option::Option<crate::model::TaskType>,
        pub(crate) status: std::option::Option<crate::model::TaskStatusType>,
        pub(crate) started_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) started_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The type of task run.</p>
        pub fn task_run_type(mut self, input: crate::model::TaskType) -> Self {
            self.task_run_type = Some(input);
            self
        }
        /// <p>The type of task run.</p>
        pub fn set_task_run_type(
            mut self,
            input: std::option::Option<crate::model::TaskType>,
        ) -> Self {
            self.task_run_type = input;
            self
        }
        /// <p>The current status of the task run.</p>
        pub fn status(mut self, input: crate::model::TaskStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the task run.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Filter on task runs started before this date.</p>
        pub fn started_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_before = Some(input);
            self
        }
        /// <p>Filter on task runs started before this date.</p>
        pub fn set_started_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_before = input;
            self
        }
        /// <p>Filter on task runs started after this date.</p>
        pub fn started_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_after = Some(input);
            self
        }
        /// <p>Filter on task runs started after this date.</p>
        pub fn set_started_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_after = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskRunFilterCriteria`](crate::model::TaskRunFilterCriteria)
        pub fn build(self) -> crate::model::TaskRunFilterCriteria {
            crate::model::TaskRunFilterCriteria {
                task_run_type: self.task_run_type,
                status: self.status,
                started_before: self.started_before,
                started_after: self.started_after,
            }
        }
    }
}
impl TaskRunFilterCriteria {
    /// Creates a new builder-style object to manufacture [`TaskRunFilterCriteria`](crate::model::TaskRunFilterCriteria)
    pub fn builder() -> crate::model::task_run_filter_criteria::Builder {
        crate::model::task_run_filter_criteria::Builder::default()
    }
}

/// <p>Specifies a job definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Job {
    /// <p>The name you assign to this job definition.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the job.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>This field is reserved for future use.</p>
    pub log_uri: std::option::Option<std::string::String>,
    /// <p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The time and date that this job definition was created.</p>
    pub created_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last point in time when this job definition was modified.</p>
    pub last_modified_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed
    /// for this job.</p>
    pub execution_property: std::option::Option<crate::model::ExecutionProperty>,
    /// <p>The <code>JobCommand</code> that runs this job.</p>
    pub command: std::option::Option<crate::model::JobCommand>,
    /// <p>The default arguments for this job, specified as name-value pairs.</p>
    /// <p>You can specify arguments here that your own job-execution script
    /// consumes, as well as arguments that Glue itself consumes.</p>
    /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
    /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
    pub default_arguments:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Non-overridable arguments for this job, specified as name-value pairs.</p>
    pub non_overridable_arguments:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The connections used for this job.</p>
    pub connections: std::option::Option<crate::model::ConnectionsList>,
    /// <p>The maximum number of times to retry this job after a JobRun fails.</p>
    pub max_retries: i32,
    /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
    ///
    /// <p>The number of Glue data processing units (DPUs) allocated to runs of this job. You can
    /// allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing
    /// power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
    /// see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
    /// page</a>.</p>
    /// <p></p>
    pub allocated_capacity: i32,
    /// <p>The job timeout in minutes.  This is the maximum time that a job run
    /// can consume resources before it is terminated and enters <code>TIMEOUT</code>
    /// status. The default is 2,880 minutes (48 hours).</p>
    pub timeout: std::option::Option<i32>,
    /// <p>For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
    /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
    /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
    /// pricing page</a>.</p>
    ///
    /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>
    ///
    /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
    /// running a Python shell job, an Apache Spark ETL job, or an Apache Spark streaming ETL
    /// job:</p>
    /// <ul>
    /// <li>
    /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
    /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
    /// </li>
    /// <li>
    /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache
    /// Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs.
    /// The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
    /// </li>
    /// </ul>
    /// <p>For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you should specify a <code>Worker type</code> and the <code>Number of workers</code>.</p>
    pub max_capacity: std::option::Option<f64>,
    /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
    /// <ul>
    /// <li>
    /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
    /// </li>
    /// </ul>
    pub worker_type: std::option::Option<crate::model::WorkerType>,
    /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
    ///
    /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
    pub number_of_workers: std::option::Option<i32>,
    /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
    /// job.</p>
    pub security_configuration: std::option::Option<std::string::String>,
    /// <p>Specifies configuration properties of a job notification.</p>
    pub notification_property: std::option::Option<crate::model::NotificationProperty>,
    /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
    ///
    /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
    ///
    /// <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>
    pub glue_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Job {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Job");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("log_uri", &self.log_uri);
        formatter.field("role", &self.role);
        formatter.field("created_on", &self.created_on);
        formatter.field("last_modified_on", &self.last_modified_on);
        formatter.field("execution_property", &self.execution_property);
        formatter.field("command", &self.command);
        formatter.field("default_arguments", &self.default_arguments);
        formatter.field("non_overridable_arguments", &self.non_overridable_arguments);
        formatter.field("connections", &self.connections);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("allocated_capacity", &self.allocated_capacity);
        formatter.field("timeout", &self.timeout);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("worker_type", &self.worker_type);
        formatter.field("number_of_workers", &self.number_of_workers);
        formatter.field("security_configuration", &self.security_configuration);
        formatter.field("notification_property", &self.notification_property);
        formatter.field("glue_version", &self.glue_version);
        formatter.finish()
    }
}
/// See [`Job`](crate::model::Job)
pub mod job {
    /// A builder for [`Job`](crate::model::Job)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) log_uri: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) created_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) execution_property: std::option::Option<crate::model::ExecutionProperty>,
        pub(crate) command: std::option::Option<crate::model::JobCommand>,
        pub(crate) default_arguments: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) non_overridable_arguments: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) connections: std::option::Option<crate::model::ConnectionsList>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) allocated_capacity: std::option::Option<i32>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) max_capacity: std::option::Option<f64>,
        pub(crate) worker_type: std::option::Option<crate::model::WorkerType>,
        pub(crate) number_of_workers: std::option::Option<i32>,
        pub(crate) security_configuration: std::option::Option<std::string::String>,
        pub(crate) notification_property: std::option::Option<crate::model::NotificationProperty>,
        pub(crate) glue_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name you assign to this job definition.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name you assign to this job definition.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>This field is reserved for future use.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_uri = Some(input.into());
            self
        }
        /// <p>This field is reserved for future use.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_uri = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The time and date that this job definition was created.</p>
        pub fn created_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_on = Some(input);
            self
        }
        /// <p>The time and date that this job definition was created.</p>
        pub fn set_created_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_on = input;
            self
        }
        /// <p>The last point in time when this job definition was modified.</p>
        pub fn last_modified_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_on = Some(input);
            self
        }
        /// <p>The last point in time when this job definition was modified.</p>
        pub fn set_last_modified_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_on = input;
            self
        }
        /// <p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed
        /// for this job.</p>
        pub fn execution_property(mut self, input: crate::model::ExecutionProperty) -> Self {
            self.execution_property = Some(input);
            self
        }
        /// <p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed
        /// for this job.</p>
        pub fn set_execution_property(
            mut self,
            input: std::option::Option<crate::model::ExecutionProperty>,
        ) -> Self {
            self.execution_property = input;
            self
        }
        /// <p>The <code>JobCommand</code> that runs this job.</p>
        pub fn command(mut self, input: crate::model::JobCommand) -> Self {
            self.command = Some(input);
            self
        }
        /// <p>The <code>JobCommand</code> that runs this job.</p>
        pub fn set_command(mut self, input: std::option::Option<crate::model::JobCommand>) -> Self {
            self.command = input;
            self
        }
        /// Adds a key-value pair to `default_arguments`.
        ///
        /// To override the contents of this collection use [`set_default_arguments`](Self::set_default_arguments).
        ///
        /// <p>The default arguments for this job, specified as name-value pairs.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn default_arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.default_arguments.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.default_arguments = Some(hash_map);
            self
        }
        /// <p>The default arguments for this job, specified as name-value pairs.</p>
        /// <p>You can specify arguments here that your own job-execution script
        /// consumes, as well as arguments that Glue itself consumes.</p>
        /// <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling Glue APIs in Python</a> topic in the developer guide.</p>
        /// <p>For information about the key-value pairs that Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by Glue</a> topic in the developer guide.</p>
        pub fn set_default_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.default_arguments = input;
            self
        }
        /// Adds a key-value pair to `non_overridable_arguments`.
        ///
        /// To override the contents of this collection use [`set_non_overridable_arguments`](Self::set_non_overridable_arguments).
        ///
        /// <p>Non-overridable arguments for this job, specified as name-value pairs.</p>
        pub fn non_overridable_arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.non_overridable_arguments.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.non_overridable_arguments = Some(hash_map);
            self
        }
        /// <p>Non-overridable arguments for this job, specified as name-value pairs.</p>
        pub fn set_non_overridable_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.non_overridable_arguments = input;
            self
        }
        /// <p>The connections used for this job.</p>
        pub fn connections(mut self, input: crate::model::ConnectionsList) -> Self {
            self.connections = Some(input);
            self
        }
        /// <p>The connections used for this job.</p>
        pub fn set_connections(
            mut self,
            input: std::option::Option<crate::model::ConnectionsList>,
        ) -> Self {
            self.connections = input;
            self
        }
        /// <p>The maximum number of times to retry this job after a JobRun fails.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times to retry this job after a JobRun fails.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
        ///
        /// <p>The number of Glue data processing units (DPUs) allocated to runs of this job. You can
        /// allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing
        /// power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
        /// see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>.</p>
        /// <p></p>
        pub fn allocated_capacity(mut self, input: i32) -> Self {
            self.allocated_capacity = Some(input);
            self
        }
        /// <p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p>
        ///
        /// <p>The number of Glue data processing units (DPUs) allocated to runs of this job. You can
        /// allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing
        /// power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
        /// see the <a href="https://aws.amazon.com/glue/pricing/">Glue pricing
        /// page</a>.</p>
        /// <p></p>
        pub fn set_allocated_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_capacity = input;
            self
        }
        /// <p>The job timeout in minutes.  This is the maximum time that a job run
        /// can consume resources before it is terminated and enters <code>TIMEOUT</code>
        /// status. The default is 2,880 minutes (48 hours).</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The job timeout in minutes.  This is the maximum time that a job run
        /// can consume resources before it is terminated and enters <code>TIMEOUT</code>
        /// status. The default is 2,880 minutes (48 hours).</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        ///
        /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>
        ///
        /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
        /// running a Python shell job, an Apache Spark ETL job, or an Apache Spark streaming ETL
        /// job:</p>
        /// <ul>
        /// <li>
        /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
        /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
        /// </li>
        /// <li>
        /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache
        /// Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs.
        /// The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
        /// </li>
        /// </ul>
        /// <p>For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you should specify a <code>Worker type</code> and the <code>Number of workers</code>.</p>
        pub fn max_capacity(mut self, input: f64) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>For Glue version 1.0 or earlier jobs, using the standard worker type, the number of Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure
        /// of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
        /// For more information, see the <a href="https://aws.amazon.com/glue/pricing/">Glue
        /// pricing page</a>.</p>
        ///
        /// <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p>
        ///
        /// <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are
        /// running a Python shell job, an Apache Spark ETL job, or an Apache Spark streaming ETL
        /// job:</p>
        /// <ul>
        /// <li>
        /// <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can
        /// allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p>
        /// </li>
        /// <li>
        /// <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache
        /// Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs.
        /// The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p>
        /// </li>
        /// </ul>
        /// <p>For Glue version 2.0 jobs, you cannot instead specify a <code>Maximum capacity</code>. Instead, you should specify a <code>Worker type</code> and the <code>Number of workers</code>.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<f64>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// </ul>
        pub fn worker_type(mut self, input: crate::model::WorkerType) -> Self {
            self.worker_type = Some(input);
            self
        }
        /// <p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// </ul>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.worker_type = input;
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn number_of_workers(mut self, input: i32) -> Self {
            self.number_of_workers = Some(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_workers = input;
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// job.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_configuration = Some(input.into());
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// job.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_configuration = input;
            self
        }
        /// <p>Specifies configuration properties of a job notification.</p>
        pub fn notification_property(mut self, input: crate::model::NotificationProperty) -> Self {
            self.notification_property = Some(input);
            self
        }
        /// <p>Specifies configuration properties of a job notification.</p>
        pub fn set_notification_property(
            mut self,
            input: std::option::Option<crate::model::NotificationProperty>,
        ) -> Self {
            self.notification_property = input;
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        ///
        /// <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>
        pub fn glue_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.glue_version = Some(input.into());
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for jobs of type Spark. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        ///
        /// <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.glue_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Job`](crate::model::Job)
        pub fn build(self) -> crate::model::Job {
            crate::model::Job {
                name: self.name,
                description: self.description,
                log_uri: self.log_uri,
                role: self.role,
                created_on: self.created_on,
                last_modified_on: self.last_modified_on,
                execution_property: self.execution_property,
                command: self.command,
                default_arguments: self.default_arguments,
                non_overridable_arguments: self.non_overridable_arguments,
                connections: self.connections,
                max_retries: self.max_retries.unwrap_or_default(),
                allocated_capacity: self.allocated_capacity.unwrap_or_default(),
                timeout: self.timeout,
                max_capacity: self.max_capacity,
                worker_type: self.worker_type,
                number_of_workers: self.number_of_workers,
                security_configuration: self.security_configuration,
                notification_property: self.notification_property,
                glue_version: self.glue_version,
            }
        }
    }
}
impl Job {
    /// Creates a new builder-style object to manufacture [`Job`](crate::model::Job)
    pub fn builder() -> crate::model::job::Builder {
        crate::model::job::Builder::default()
    }
}

/// <p>A development endpoint where a developer can remotely debug extract, transform, and load
/// (ETL) scripts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DevEndpoint {
    /// <p>The name of the <code>DevEndpoint</code>.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used in this
    /// <code>DevEndpoint</code>.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A list of security group identifiers used in this <code>DevEndpoint</code>.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The subnet ID for this <code>DevEndpoint</code>.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The YARN endpoint address used by this <code>DevEndpoint</code>.</p>
    pub yarn_endpoint_address: std::option::Option<std::string::String>,
    /// <p>A private IP address to access the <code>DevEndpoint</code> within a VPC if the
    /// <code>DevEndpoint</code> is created within one. The <code>PrivateAddress</code> field is
    /// present only when you create the <code>DevEndpoint</code> within your VPC.</p>
    pub private_address: std::option::Option<std::string::String>,
    /// <p>The Apache Zeppelin port for the remote Apache Spark interpreter.</p>
    pub zeppelin_remote_spark_interpreter_port: i32,
    /// <p>The public IP address used by this <code>DevEndpoint</code>. The
    /// <code>PublicAddress</code> field is present only when you create a non-virtual private cloud
    /// (VPC) <code>DevEndpoint</code>.</p>
    pub public_address: std::option::Option<std::string::String>,
    /// <p>The current status of this <code>DevEndpoint</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X, or G.2X.</p>
    /// <ul>
    /// <li>
    /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
    /// </li>
    /// <li>
    /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>Known issue: when a development endpoint is created with the <code>G.2X</code>
    /// <code>WorkerType</code> configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk. </p>
    pub worker_type: std::option::Option<crate::model::WorkerType>,
    /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p>
    ///
    /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
    ///
    /// <p>Development endpoints that are created without specifying a Glue version default to Glue 0.9.</p>  
    ///
    /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
    pub glue_version: std::option::Option<std::string::String>,
    /// <p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p>
    ///
    /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
    pub number_of_workers: std::option::Option<i32>,
    /// <p>The number of Glue Data Processing Units (DPUs) allocated to this
    /// <code>DevEndpoint</code>.</p>
    pub number_of_nodes: i32,
    /// <p>The AWS Availability Zone where this <code>DevEndpoint</code> is located.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in
    /// your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a
    /// comma.</p>
    ///
    /// <note>
    /// <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on
    /// C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data
    /// analysis library, are not currently supported.</p>
    /// </note>
    pub extra_python_libs_s3_path: std::option::Option<std::string::String>,
    /// <p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded
    /// in your <code>DevEndpoint</code>.</p>
    /// <note>
    /// <p>You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.</p>
    /// </note>
    pub extra_jars_s3_path: std::option::Option<std::string::String>,
    /// <p>The reason for a current failure in this <code>DevEndpoint</code>.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The status of the last update.</p>
    pub last_update_status: std::option::Option<std::string::String>,
    /// <p>The point in time at which this DevEndpoint was created.</p>
    pub created_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The point in time at which this <code>DevEndpoint</code> was last modified.</p>
    pub last_modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The public key to be used by this <code>DevEndpoint</code> for authentication. This
    /// attribute is provided for backward compatibility because the recommended attribute to use is
    /// public keys.</p>
    pub public_key: std::option::Option<std::string::String>,
    /// <p>A list of public keys to be used by the <code>DevEndpoints</code> for authentication.
    /// Using this attribute is preferred over a single public key because the public keys allow you
    /// to have a different private key per client.</p>
    /// <note>
    /// <p>If you previously created an endpoint with a public key, you must remove that key to be
    /// able to set a list of public keys. Call the <code>UpdateDevEndpoint</code> API operation
    /// with the public key content in the <code>deletePublicKeys</code> attribute, and the list of
    /// new keys in the <code>addPublicKeys</code> attribute.</p>
    /// </note>
    pub public_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
    /// <code>DevEndpoint</code>.</p>
    pub security_configuration: std::option::Option<std::string::String>,
    /// <p>A map of arguments used to configure the <code>DevEndpoint</code>.</p>
    /// <p>Valid arguments are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"--enable-glue-datacatalog": ""</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
    pub arguments:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DevEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DevEndpoint");
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("yarn_endpoint_address", &self.yarn_endpoint_address);
        formatter.field("private_address", &self.private_address);
        formatter.field(
            "zeppelin_remote_spark_interpreter_port",
            &self.zeppelin_remote_spark_interpreter_port,
        );
        formatter.field("public_address", &self.public_address);
        formatter.field("status", &self.status);
        formatter.field("worker_type", &self.worker_type);
        formatter.field("glue_version", &self.glue_version);
        formatter.field("number_of_workers", &self.number_of_workers);
        formatter.field("number_of_nodes", &self.number_of_nodes);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("extra_python_libs_s3_path", &self.extra_python_libs_s3_path);
        formatter.field("extra_jars_s3_path", &self.extra_jars_s3_path);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("last_update_status", &self.last_update_status);
        formatter.field("created_timestamp", &self.created_timestamp);
        formatter.field("last_modified_timestamp", &self.last_modified_timestamp);
        formatter.field("public_key", &self.public_key);
        formatter.field("public_keys", &self.public_keys);
        formatter.field("security_configuration", &self.security_configuration);
        formatter.field("arguments", &self.arguments);
        formatter.finish()
    }
}
/// See [`DevEndpoint`](crate::model::DevEndpoint)
pub mod dev_endpoint {
    /// A builder for [`DevEndpoint`](crate::model::DevEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) yarn_endpoint_address: std::option::Option<std::string::String>,
        pub(crate) private_address: std::option::Option<std::string::String>,
        pub(crate) zeppelin_remote_spark_interpreter_port: std::option::Option<i32>,
        pub(crate) public_address: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) worker_type: std::option::Option<crate::model::WorkerType>,
        pub(crate) glue_version: std::option::Option<std::string::String>,
        pub(crate) number_of_workers: std::option::Option<i32>,
        pub(crate) number_of_nodes: std::option::Option<i32>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) extra_python_libs_s3_path: std::option::Option<std::string::String>,
        pub(crate) extra_jars_s3_path: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) last_update_status: std::option::Option<std::string::String>,
        pub(crate) created_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) public_key: std::option::Option<std::string::String>,
        pub(crate) public_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_configuration: std::option::Option<std::string::String>,
        pub(crate) arguments: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the <code>DevEndpoint</code>.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the <code>DevEndpoint</code>.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used in this
        /// <code>DevEndpoint</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used in this
        /// <code>DevEndpoint</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of security group identifiers used in this <code>DevEndpoint</code>.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of security group identifiers used in this <code>DevEndpoint</code>.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The subnet ID for this <code>DevEndpoint</code>.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID for this <code>DevEndpoint</code>.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The YARN endpoint address used by this <code>DevEndpoint</code>.</p>
        pub fn yarn_endpoint_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.yarn_endpoint_address = Some(input.into());
            self
        }
        /// <p>The YARN endpoint address used by this <code>DevEndpoint</code>.</p>
        pub fn set_yarn_endpoint_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.yarn_endpoint_address = input;
            self
        }
        /// <p>A private IP address to access the <code>DevEndpoint</code> within a VPC if the
        /// <code>DevEndpoint</code> is created within one. The <code>PrivateAddress</code> field is
        /// present only when you create the <code>DevEndpoint</code> within your VPC.</p>
        pub fn private_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_address = Some(input.into());
            self
        }
        /// <p>A private IP address to access the <code>DevEndpoint</code> within a VPC if the
        /// <code>DevEndpoint</code> is created within one. The <code>PrivateAddress</code> field is
        /// present only when you create the <code>DevEndpoint</code> within your VPC.</p>
        pub fn set_private_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_address = input;
            self
        }
        /// <p>The Apache Zeppelin port for the remote Apache Spark interpreter.</p>
        pub fn zeppelin_remote_spark_interpreter_port(mut self, input: i32) -> Self {
            self.zeppelin_remote_spark_interpreter_port = Some(input);
            self
        }
        /// <p>The Apache Zeppelin port for the remote Apache Spark interpreter.</p>
        pub fn set_zeppelin_remote_spark_interpreter_port(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.zeppelin_remote_spark_interpreter_port = input;
            self
        }
        /// <p>The public IP address used by this <code>DevEndpoint</code>. The
        /// <code>PublicAddress</code> field is present only when you create a non-virtual private cloud
        /// (VPC) <code>DevEndpoint</code>.</p>
        pub fn public_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_address = Some(input.into());
            self
        }
        /// <p>The public IP address used by this <code>DevEndpoint</code>. The
        /// <code>PublicAddress</code> field is present only when you create a non-virtual private cloud
        /// (VPC) <code>DevEndpoint</code>.</p>
        pub fn set_public_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_address = input;
            self
        }
        /// <p>The current status of this <code>DevEndpoint</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of this <code>DevEndpoint</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Known issue: when a development endpoint is created with the <code>G.2X</code>
        /// <code>WorkerType</code> configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk. </p>
        pub fn worker_type(mut self, input: crate::model::WorkerType) -> Self {
            self.worker_type = Some(input);
            self
        }
        /// <p>The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X, or G.2X.</p>
        /// <ul>
        /// <li>
        /// <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// <li>
        /// <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Known issue: when a development endpoint is created with the <code>G.2X</code>
        /// <code>WorkerType</code> configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk. </p>
        pub fn set_worker_type(
            mut self,
            input: std::option::Option<crate::model::WorkerType>,
        ) -> Self {
            self.worker_type = input;
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        ///
        /// <p>Development endpoints that are created without specifying a Glue version default to Glue 0.9.</p>  
        ///
        /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
        pub fn glue_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.glue_version = Some(input.into());
            self
        }
        /// <p>Glue version determines the versions of Apache Spark and Python that Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p>
        ///
        /// <p>For more information about the available Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>
        ///
        /// <p>Development endpoints that are created without specifying a Glue version default to Glue 0.9.</p>  
        ///
        /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
        pub fn set_glue_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.glue_version = input;
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn number_of_workers(mut self, input: i32) -> Self {
            self.number_of_workers = Some(input);
            self
        }
        /// <p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p>
        ///
        /// <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>
        pub fn set_number_of_workers(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_workers = input;
            self
        }
        /// <p>The number of Glue Data Processing Units (DPUs) allocated to this
        /// <code>DevEndpoint</code>.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.number_of_nodes = Some(input);
            self
        }
        /// <p>The number of Glue Data Processing Units (DPUs) allocated to this
        /// <code>DevEndpoint</code>.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_nodes = input;
            self
        }
        /// <p>The AWS Availability Zone where this <code>DevEndpoint</code> is located.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The AWS Availability Zone where this <code>DevEndpoint</code> is located.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in
        /// your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a
        /// comma.</p>
        ///
        /// <note>
        /// <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on
        /// C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data
        /// analysis library, are not currently supported.</p>
        /// </note>
        pub fn extra_python_libs_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.extra_python_libs_s3_path = Some(input.into());
            self
        }
        /// <p>The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in
        /// your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a
        /// comma.</p>
        ///
        /// <note>
        /// <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on
        /// C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data
        /// analysis library, are not currently supported.</p>
        /// </note>
        pub fn set_extra_python_libs_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extra_python_libs_s3_path = input;
            self
        }
        /// <p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded
        /// in your <code>DevEndpoint</code>.</p>
        /// <note>
        /// <p>You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.</p>
        /// </note>
        pub fn extra_jars_s3_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.extra_jars_s3_path = Some(input.into());
            self
        }
        /// <p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded
        /// in your <code>DevEndpoint</code>.</p>
        /// <note>
        /// <p>You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.</p>
        /// </note>
        pub fn set_extra_jars_s3_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extra_jars_s3_path = input;
            self
        }
        /// <p>The reason for a current failure in this <code>DevEndpoint</code>.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason for a current failure in this <code>DevEndpoint</code>.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The status of the last update.</p>
        pub fn last_update_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_update_status = Some(input.into());
            self
        }
        /// <p>The status of the last update.</p>
        pub fn set_last_update_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_update_status = input;
            self
        }
        /// <p>The point in time at which this DevEndpoint was created.</p>
        pub fn created_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_timestamp = Some(input);
            self
        }
        /// <p>The point in time at which this DevEndpoint was created.</p>
        pub fn set_created_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_timestamp = input;
            self
        }
        /// <p>The point in time at which this <code>DevEndpoint</code> was last modified.</p>
        pub fn last_modified_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_timestamp = Some(input);
            self
        }
        /// <p>The point in time at which this <code>DevEndpoint</code> was last modified.</p>
        pub fn set_last_modified_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_timestamp = input;
            self
        }
        /// <p>The public key to be used by this <code>DevEndpoint</code> for authentication. This
        /// attribute is provided for backward compatibility because the recommended attribute to use is
        /// public keys.</p>
        pub fn public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_key = Some(input.into());
            self
        }
        /// <p>The public key to be used by this <code>DevEndpoint</code> for authentication. This
        /// attribute is provided for backward compatibility because the recommended attribute to use is
        /// public keys.</p>
        pub fn set_public_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_key = input;
            self
        }
        /// Appends an item to `public_keys`.
        ///
        /// To override the contents of this collection use [`set_public_keys`](Self::set_public_keys).
        ///
        /// <p>A list of public keys to be used by the <code>DevEndpoints</code> for authentication.
        /// Using this attribute is preferred over a single public key because the public keys allow you
        /// to have a different private key per client.</p>
        /// <note>
        /// <p>If you previously created an endpoint with a public key, you must remove that key to be
        /// able to set a list of public keys. Call the <code>UpdateDevEndpoint</code> API operation
        /// with the public key content in the <code>deletePublicKeys</code> attribute, and the list of
        /// new keys in the <code>addPublicKeys</code> attribute.</p>
        /// </note>
        pub fn public_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.public_keys.unwrap_or_default();
            v.push(input.into());
            self.public_keys = Some(v);
            self
        }
        /// <p>A list of public keys to be used by the <code>DevEndpoints</code> for authentication.
        /// Using this attribute is preferred over a single public key because the public keys allow you
        /// to have a different private key per client.</p>
        /// <note>
        /// <p>If you previously created an endpoint with a public key, you must remove that key to be
        /// able to set a list of public keys. Call the <code>UpdateDevEndpoint</code> API operation
        /// with the public key content in the <code>deletePublicKeys</code> attribute, and the list of
        /// new keys in the <code>addPublicKeys</code> attribute.</p>
        /// </note>
        pub fn set_public_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.public_keys = input;
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// <code>DevEndpoint</code>.</p>
        pub fn security_configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_configuration = Some(input.into());
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used with this
        /// <code>DevEndpoint</code>.</p>
        pub fn set_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_configuration = input;
            self
        }
        /// Adds a key-value pair to `arguments`.
        ///
        /// To override the contents of this collection use [`set_arguments`](Self::set_arguments).
        ///
        /// <p>A map of arguments used to configure the <code>DevEndpoint</code>.</p>
        /// <p>Valid arguments are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"--enable-glue-datacatalog": ""</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
        pub fn arguments(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.arguments.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.arguments = Some(hash_map);
            self
        }
        /// <p>A map of arguments used to configure the <code>DevEndpoint</code>.</p>
        /// <p>Valid arguments are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"--enable-glue-datacatalog": ""</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>
        pub fn set_arguments(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.arguments = input;
            self
        }
        /// Consumes the builder and constructs a [`DevEndpoint`](crate::model::DevEndpoint)
        pub fn build(self) -> crate::model::DevEndpoint {
            crate::model::DevEndpoint {
                endpoint_name: self.endpoint_name,
                role_arn: self.role_arn,
                security_group_ids: self.security_group_ids,
                subnet_id: self.subnet_id,
                yarn_endpoint_address: self.yarn_endpoint_address,
                private_address: self.private_address,
                zeppelin_remote_spark_interpreter_port: self
                    .zeppelin_remote_spark_interpreter_port
                    .unwrap_or_default(),
                public_address: self.public_address,
                status: self.status,
                worker_type: self.worker_type,
                glue_version: self.glue_version,
                number_of_workers: self.number_of_workers,
                number_of_nodes: self.number_of_nodes.unwrap_or_default(),
                availability_zone: self.availability_zone,
                vpc_id: self.vpc_id,
                extra_python_libs_s3_path: self.extra_python_libs_s3_path,
                extra_jars_s3_path: self.extra_jars_s3_path,
                failure_reason: self.failure_reason,
                last_update_status: self.last_update_status,
                created_timestamp: self.created_timestamp,
                last_modified_timestamp: self.last_modified_timestamp,
                public_key: self.public_key,
                public_keys: self.public_keys,
                security_configuration: self.security_configuration,
                arguments: self.arguments,
            }
        }
    }
}
impl DevEndpoint {
    /// Creates a new builder-style object to manufacture [`DevEndpoint`](crate::model::DevEndpoint)
    pub fn builder() -> crate::model::dev_endpoint::Builder {
        crate::model::dev_endpoint::Builder::default()
    }
}

/// <p>Represents a directional edge in a directed acyclic graph (DAG).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeGenEdge {
    /// <p>The ID of the node at which the edge starts.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The ID of the node at which the edge ends.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The target of the edge.</p>
    pub target_parameter: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CodeGenEdge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeGenEdge");
        formatter.field("source", &self.source);
        formatter.field("target", &self.target);
        formatter.field("target_parameter", &self.target_parameter);
        formatter.finish()
    }
}
/// See [`CodeGenEdge`](crate::model::CodeGenEdge)
pub mod code_gen_edge {
    /// A builder for [`CodeGenEdge`](crate::model::CodeGenEdge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) target_parameter: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the node at which the edge starts.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The ID of the node at which the edge starts.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The ID of the node at which the edge ends.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The ID of the node at which the edge ends.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The target of the edge.</p>
        pub fn target_parameter(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_parameter = Some(input.into());
            self
        }
        /// <p>The target of the edge.</p>
        pub fn set_target_parameter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_parameter = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeGenEdge`](crate::model::CodeGenEdge)
        pub fn build(self) -> crate::model::CodeGenEdge {
            crate::model::CodeGenEdge {
                source: self.source,
                target: self.target,
                target_parameter: self.target_parameter,
            }
        }
    }
}
impl CodeGenEdge {
    /// Creates a new builder-style object to manufacture [`CodeGenEdge`](crate::model::CodeGenEdge)
    pub fn builder() -> crate::model::code_gen_edge::Builder {
        crate::model::code_gen_edge::Builder::default()
    }
}

/// <p>Represents a node in a directed acyclic graph (DAG)</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeGenNode {
    /// <p>A node identifier that is unique within the node's graph.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of node that this is.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>Properties of the node, in the form of name-value pairs.</p>
    pub args: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
    /// <p>The line number of the node.</p>
    pub line_number: i32,
}
impl std::fmt::Debug for CodeGenNode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeGenNode");
        formatter.field("id", &self.id);
        formatter.field("node_type", &self.node_type);
        formatter.field("args", &self.args);
        formatter.field("line_number", &self.line_number);
        formatter.finish()
    }
}
/// See [`CodeGenNode`](crate::model::CodeGenNode)
pub mod code_gen_node {
    /// A builder for [`CodeGenNode`](crate::model::CodeGenNode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) args: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
        pub(crate) line_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A node identifier that is unique within the node's graph.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A node identifier that is unique within the node's graph.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of node that this is.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The type of node that this is.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// Appends an item to `args`.
        ///
        /// To override the contents of this collection use [`set_args`](Self::set_args).
        ///
        /// <p>Properties of the node, in the form of name-value pairs.</p>
        pub fn args(mut self, input: impl Into<crate::model::CodeGenNodeArg>) -> Self {
            let mut v = self.args.unwrap_or_default();
            v.push(input.into());
            self.args = Some(v);
            self
        }
        /// <p>Properties of the node, in the form of name-value pairs.</p>
        pub fn set_args(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeGenNodeArg>>,
        ) -> Self {
            self.args = input;
            self
        }
        /// <p>The line number of the node.</p>
        pub fn line_number(mut self, input: i32) -> Self {
            self.line_number = Some(input);
            self
        }
        /// <p>The line number of the node.</p>
        pub fn set_line_number(mut self, input: std::option::Option<i32>) -> Self {
            self.line_number = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeGenNode`](crate::model::CodeGenNode)
        pub fn build(self) -> crate::model::CodeGenNode {
            crate::model::CodeGenNode {
                id: self.id,
                node_type: self.node_type,
                args: self.args,
                line_number: self.line_number.unwrap_or_default(),
            }
        }
    }
}
impl CodeGenNode {
    /// Creates a new builder-style object to manufacture [`CodeGenNode`](crate::model::CodeGenNode)
    pub fn builder() -> crate::model::code_gen_node::Builder {
        crate::model::code_gen_node::Builder::default()
    }
}

/// <p>The <code>Database</code> object represents a logical grouping of tables that might reside
/// in a Hive metastore or an RDBMS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Database {
    /// <p>The name of the database. For Hive compatibility, this is folded to lowercase when it is
    /// stored.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the database.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The location of the database (for example, an HDFS path).</p>
    pub location_uri: std::option::Option<std::string::String>,
    /// <p>These key-value pairs define parameters and properties
    /// of the database.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The time at which the metadata database was created in the catalog.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Creates a set of default permissions on the table for principals. </p>
    pub create_table_default_permissions:
        std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
    /// <p>A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.</p>
    pub target_database: std::option::Option<crate::model::DatabaseIdentifier>,
    /// <p>The ID of the Data Catalog in which the database resides.</p>
    pub catalog_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Database {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Database");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("location_uri", &self.location_uri);
        formatter.field("parameters", &self.parameters);
        formatter.field("create_time", &self.create_time);
        formatter.field(
            "create_table_default_permissions",
            &self.create_table_default_permissions,
        );
        formatter.field("target_database", &self.target_database);
        formatter.field("catalog_id", &self.catalog_id);
        formatter.finish()
    }
}
/// See [`Database`](crate::model::Database)
pub mod database {
    /// A builder for [`Database`](crate::model::Database)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) location_uri: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) create_table_default_permissions:
            std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
        pub(crate) target_database: std::option::Option<crate::model::DatabaseIdentifier>,
        pub(crate) catalog_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database. For Hive compatibility, this is folded to lowercase when it is
        /// stored.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the database. For Hive compatibility, this is folded to lowercase when it is
        /// stored.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the database.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the database.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The location of the database (for example, an HDFS path).</p>
        pub fn location_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.location_uri = Some(input.into());
            self
        }
        /// <p>The location of the database (for example, an HDFS path).</p>
        pub fn set_location_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location_uri = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>These key-value pairs define parameters and properties
        /// of the database.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>These key-value pairs define parameters and properties
        /// of the database.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The time at which the metadata database was created in the catalog.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The time at which the metadata database was created in the catalog.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Appends an item to `create_table_default_permissions`.
        ///
        /// To override the contents of this collection use [`set_create_table_default_permissions`](Self::set_create_table_default_permissions).
        ///
        /// <p>Creates a set of default permissions on the table for principals. </p>
        pub fn create_table_default_permissions(
            mut self,
            input: impl Into<crate::model::PrincipalPermissions>,
        ) -> Self {
            let mut v = self.create_table_default_permissions.unwrap_or_default();
            v.push(input.into());
            self.create_table_default_permissions = Some(v);
            self
        }
        /// <p>Creates a set of default permissions on the table for principals. </p>
        pub fn set_create_table_default_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PrincipalPermissions>>,
        ) -> Self {
            self.create_table_default_permissions = input;
            self
        }
        /// <p>A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.</p>
        pub fn target_database(mut self, input: crate::model::DatabaseIdentifier) -> Self {
            self.target_database = Some(input);
            self
        }
        /// <p>A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.</p>
        pub fn set_target_database(
            mut self,
            input: std::option::Option<crate::model::DatabaseIdentifier>,
        ) -> Self {
            self.target_database = input;
            self
        }
        /// <p>The ID of the Data Catalog in which the database resides.</p>
        pub fn catalog_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_id = Some(input.into());
            self
        }
        /// <p>The ID of the Data Catalog in which the database resides.</p>
        pub fn set_catalog_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Database`](crate::model::Database)
        pub fn build(self) -> crate::model::Database {
            crate::model::Database {
                name: self.name,
                description: self.description,
                location_uri: self.location_uri,
                parameters: self.parameters,
                create_time: self.create_time,
                create_table_default_permissions: self.create_table_default_permissions,
                target_database: self.target_database,
                catalog_id: self.catalog_id,
            }
        }
    }
}
impl Database {
    /// Creates a new builder-style object to manufacture [`Database`](crate::model::Database)
    pub fn builder() -> crate::model::database::Builder {
        crate::model::database::Builder::default()
    }
}

/// <p>Specifies a crawler program that examines a data source and uses classifiers to try to
/// determine its schema. If successful, the crawler records metadata concerning the data source
/// in the Glue Data Catalog.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Crawler {
    /// <p>The name of the crawler.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources,
    /// such as Amazon Simple Storage Service (Amazon S3) data.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>A collection of targets to crawl.</p>
    pub targets: std::option::Option<crate::model::CrawlerTargets>,
    /// <p>The name of the database in which the crawler's output is stored.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>A description of the crawler.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of UTF-8 strings that specify the custom classifiers that are associated
    /// with the crawler.</p>
    pub classifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.</p>
    pub recrawl_policy: std::option::Option<crate::model::RecrawlPolicy>,
    /// <p>The policy that specifies update and delete behaviors for the crawler.</p>
    pub schema_change_policy: std::option::Option<crate::model::SchemaChangePolicy>,
    /// <p>A configuration that specifies whether data lineage is enabled for the crawler.</p>
    pub lineage_configuration: std::option::Option<crate::model::LineageConfiguration>,
    /// <p>Indicates whether the crawler is running, or whether a run is pending.</p>
    pub state: std::option::Option<crate::model::CrawlerState>,
    /// <p>The prefix added to the names of tables that are created.</p>
    pub table_prefix: std::option::Option<std::string::String>,
    /// <p>For scheduled crawlers, the schedule when the crawler runs.</p>
    pub schedule: std::option::Option<crate::model::Schedule>,
    /// <p>If the crawler is running, contains the total time elapsed since the last crawl
    /// began.</p>
    pub crawl_elapsed_time: i64,
    /// <p>The time that the crawler was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the crawler was last updated.</p>
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the last crawl, and potentially error information if
    /// an error occurred.</p>
    pub last_crawl: std::option::Option<crate::model::LastCrawlInfo>,
    /// <p>The version of the crawler.</p>
    pub version: i64,
    /// <p>Crawler configuration information. This versioned JSON string allows users to specify
    /// aspects of a crawler's behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/define-crawler.html#crawler-data-stores-exclude">Include and Exclude
    /// Patterns</a>.</p>
    pub configuration: std::option::Option<std::string::String>,
    /// <p>The name of the <code>SecurityConfiguration</code> structure to be used by this
    /// crawler.</p>
    pub crawler_security_configuration: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Crawler {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Crawler");
        formatter.field("name", &self.name);
        formatter.field("role", &self.role);
        formatter.field("targets", &self.targets);
        formatter.field("database_name", &self.database_name);
        formatter.field("description", &self.description);
        formatter.field("classifiers", &self.classifiers);
        formatter.field("recrawl_policy", &self.recrawl_policy);
        formatter.field("schema_change_policy", &self.schema_change_policy);
        formatter.field("lineage_configuration", &self.lineage_configuration);
        formatter.field("state", &self.state);
        formatter.field("table_prefix", &self.table_prefix);
        formatter.field("schedule", &self.schedule);
        formatter.field("crawl_elapsed_time", &self.crawl_elapsed_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("last_crawl", &self.last_crawl);
        formatter.field("version", &self.version);
        formatter.field("configuration", &self.configuration);
        formatter.field(
            "crawler_security_configuration",
            &self.crawler_security_configuration,
        );
        formatter.finish()
    }
}
/// See [`Crawler`](crate::model::Crawler)
pub mod crawler {
    /// A builder for [`Crawler`](crate::model::Crawler)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<crate::model::CrawlerTargets>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) classifiers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recrawl_policy: std::option::Option<crate::model::RecrawlPolicy>,
        pub(crate) schema_change_policy: std::option::Option<crate::model::SchemaChangePolicy>,
        pub(crate) lineage_configuration: std::option::Option<crate::model::LineageConfiguration>,
        pub(crate) state: std::option::Option<crate::model::CrawlerState>,
        pub(crate) table_prefix: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<crate::model::Schedule>,
        pub(crate) crawl_elapsed_time: std::option::Option<i64>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_crawl: std::option::Option<crate::model::LastCrawlInfo>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) configuration: std::option::Option<std::string::String>,
        pub(crate) crawler_security_configuration: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the crawler.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the crawler.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources,
        /// such as Amazon Simple Storage Service (Amazon S3) data.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that's used to access customer resources,
        /// such as Amazon Simple Storage Service (Amazon S3) data.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>A collection of targets to crawl.</p>
        pub fn targets(mut self, input: crate::model::CrawlerTargets) -> Self {
            self.targets = Some(input);
            self
        }
        /// <p>A collection of targets to crawl.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<crate::model::CrawlerTargets>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The name of the database in which the crawler's output is stored.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database in which the crawler's output is stored.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>A description of the crawler.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the crawler.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `classifiers`.
        ///
        /// To override the contents of this collection use [`set_classifiers`](Self::set_classifiers).
        ///
        /// <p>A list of UTF-8 strings that specify the custom classifiers that are associated
        /// with the crawler.</p>
        pub fn classifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.classifiers.unwrap_or_default();
            v.push(input.into());
            self.classifiers = Some(v);
            self
        }
        /// <p>A list of UTF-8 strings that specify the custom classifiers that are associated
        /// with the crawler.</p>
        pub fn set_classifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.classifiers = input;
            self
        }
        /// <p>A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.</p>
        pub fn recrawl_policy(mut self, input: crate::model::RecrawlPolicy) -> Self {
            self.recrawl_policy = Some(input);
            self
        }
        /// <p>A policy that specifies whether to crawl the entire dataset again, or to crawl only folders that were added since the last crawler run.</p>
        pub fn set_recrawl_policy(
            mut self,
            input: std::option::Option<crate::model::RecrawlPolicy>,
        ) -> Self {
            self.recrawl_policy = input;
            self
        }
        /// <p>The policy that specifies update and delete behaviors for the crawler.</p>
        pub fn schema_change_policy(mut self, input: crate::model::SchemaChangePolicy) -> Self {
            self.schema_change_policy = Some(input);
            self
        }
        /// <p>The policy that specifies update and delete behaviors for the crawler.</p>
        pub fn set_schema_change_policy(
            mut self,
            input: std::option::Option<crate::model::SchemaChangePolicy>,
        ) -> Self {
            self.schema_change_policy = input;
            self
        }
        /// <p>A configuration that specifies whether data lineage is enabled for the crawler.</p>
        pub fn lineage_configuration(mut self, input: crate::model::LineageConfiguration) -> Self {
            self.lineage_configuration = Some(input);
            self
        }
        /// <p>A configuration that specifies whether data lineage is enabled for the crawler.</p>
        pub fn set_lineage_configuration(
            mut self,
            input: std::option::Option<crate::model::LineageConfiguration>,
        ) -> Self {
            self.lineage_configuration = input;
            self
        }
        /// <p>Indicates whether the crawler is running, or whether a run is pending.</p>
        pub fn state(mut self, input: crate::model::CrawlerState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Indicates whether the crawler is running, or whether a run is pending.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::CrawlerState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The prefix added to the names of tables that are created.</p>
        pub fn table_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_prefix = Some(input.into());
            self
        }
        /// <p>The prefix added to the names of tables that are created.</p>
        pub fn set_table_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_prefix = input;
            self
        }
        /// <p>For scheduled crawlers, the schedule when the crawler runs.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>For scheduled crawlers, the schedule when the crawler runs.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>If the crawler is running, contains the total time elapsed since the last crawl
        /// began.</p>
        pub fn crawl_elapsed_time(mut self, input: i64) -> Self {
            self.crawl_elapsed_time = Some(input);
            self
        }
        /// <p>If the crawler is running, contains the total time elapsed since the last crawl
        /// began.</p>
        pub fn set_crawl_elapsed_time(mut self, input: std::option::Option<i64>) -> Self {
            self.crawl_elapsed_time = input;
            self
        }
        /// <p>The time that the crawler was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the crawler was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that the crawler was last updated.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The time that the crawler was last updated.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The status of the last crawl, and potentially error information if
        /// an error occurred.</p>
        pub fn last_crawl(mut self, input: crate::model::LastCrawlInfo) -> Self {
            self.last_crawl = Some(input);
            self
        }
        /// <p>The status of the last crawl, and potentially error information if
        /// an error occurred.</p>
        pub fn set_last_crawl(
            mut self,
            input: std::option::Option<crate::model::LastCrawlInfo>,
        ) -> Self {
            self.last_crawl = input;
            self
        }
        /// <p>The version of the crawler.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the crawler.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>Crawler configuration information. This versioned JSON string allows users to specify
        /// aspects of a crawler's behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/define-crawler.html#crawler-data-stores-exclude">Include and Exclude
        /// Patterns</a>.</p>
        pub fn configuration(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration = Some(input.into());
            self
        }
        /// <p>Crawler configuration information. This versioned JSON string allows users to specify
        /// aspects of a crawler's behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/define-crawler.html#crawler-data-stores-exclude">Include and Exclude
        /// Patterns</a>.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used by this
        /// crawler.</p>
        pub fn crawler_security_configuration(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.crawler_security_configuration = Some(input.into());
            self
        }
        /// <p>The name of the <code>SecurityConfiguration</code> structure to be used by this
        /// crawler.</p>
        pub fn set_crawler_security_configuration(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.crawler_security_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Crawler`](crate::model::Crawler)
        pub fn build(self) -> crate::model::Crawler {
            crate::model::Crawler {
                name: self.name,
                role: self.role,
                targets: self.targets,
                database_name: self.database_name,
                description: self.description,
                classifiers: self.classifiers,
                recrawl_policy: self.recrawl_policy,
                schema_change_policy: self.schema_change_policy,
                lineage_configuration: self.lineage_configuration,
                state: self.state,
                table_prefix: self.table_prefix,
                schedule: self.schedule,
                crawl_elapsed_time: self.crawl_elapsed_time.unwrap_or_default(),
                creation_time: self.creation_time,
                last_updated: self.last_updated,
                last_crawl: self.last_crawl,
                version: self.version.unwrap_or_default(),
                configuration: self.configuration,
                crawler_security_configuration: self.crawler_security_configuration,
            }
        }
    }
}
impl Crawler {
    /// Creates a new builder-style object to manufacture [`Crawler`](crate::model::Crawler)
    pub fn builder() -> crate::model::crawler::Builder {
        crate::model::crawler::Builder::default()
    }
}

/// <p>Status and error information about the most recent crawl.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LastCrawlInfo {
    /// <p>Status of the last crawl.</p>
    pub status: std::option::Option<crate::model::LastCrawlStatus>,
    /// <p>If an error occurred, the error information about the last crawl.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The log group for the last crawl.</p>
    pub log_group: std::option::Option<std::string::String>,
    /// <p>The log stream for the last crawl.</p>
    pub log_stream: std::option::Option<std::string::String>,
    /// <p>The prefix for a message about this crawl.</p>
    pub message_prefix: std::option::Option<std::string::String>,
    /// <p>The time at which the crawl started.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for LastCrawlInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LastCrawlInfo");
        formatter.field("status", &self.status);
        formatter.field("error_message", &self.error_message);
        formatter.field("log_group", &self.log_group);
        formatter.field("log_stream", &self.log_stream);
        formatter.field("message_prefix", &self.message_prefix);
        formatter.field("start_time", &self.start_time);
        formatter.finish()
    }
}
/// See [`LastCrawlInfo`](crate::model::LastCrawlInfo)
pub mod last_crawl_info {
    /// A builder for [`LastCrawlInfo`](crate::model::LastCrawlInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::LastCrawlStatus>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) log_group: std::option::Option<std::string::String>,
        pub(crate) log_stream: std::option::Option<std::string::String>,
        pub(crate) message_prefix: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Status of the last crawl.</p>
        pub fn status(mut self, input: crate::model::LastCrawlStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the last crawl.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LastCrawlStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>If an error occurred, the error information about the last crawl.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>If an error occurred, the error information about the last crawl.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The log group for the last crawl.</p>
        pub fn log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group = Some(input.into());
            self
        }
        /// <p>The log group for the last crawl.</p>
        pub fn set_log_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_group = input;
            self
        }
        /// <p>The log stream for the last crawl.</p>
        pub fn log_stream(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream = Some(input.into());
            self
        }
        /// <p>The log stream for the last crawl.</p>
        pub fn set_log_stream(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_stream = input;
            self
        }
        /// <p>The prefix for a message about this crawl.</p>
        pub fn message_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_prefix = Some(input.into());
            self
        }
        /// <p>The prefix for a message about this crawl.</p>
        pub fn set_message_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_prefix = input;
            self
        }
        /// <p>The time at which the crawl started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time at which the crawl started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LastCrawlInfo`](crate::model::LastCrawlInfo)
        pub fn build(self) -> crate::model::LastCrawlInfo {
            crate::model::LastCrawlInfo {
                status: self.status,
                error_message: self.error_message,
                log_group: self.log_group,
                log_stream: self.log_stream,
                message_prefix: self.message_prefix,
                start_time: self.start_time,
            }
        }
    }
}
impl LastCrawlInfo {
    /// Creates a new builder-style object to manufacture [`LastCrawlInfo`](crate::model::LastCrawlInfo)
    pub fn builder() -> crate::model::last_crawl_info::Builder {
        crate::model::last_crawl_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LastCrawlStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LastCrawlStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => LastCrawlStatus::Cancelled,
            "FAILED" => LastCrawlStatus::Failed,
            "SUCCEEDED" => LastCrawlStatus::Succeeded,
            other => LastCrawlStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LastCrawlStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LastCrawlStatus::from(s))
    }
}
impl LastCrawlStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LastCrawlStatus::Cancelled => "CANCELLED",
            LastCrawlStatus::Failed => "FAILED",
            LastCrawlStatus::Succeeded => "SUCCEEDED",
            LastCrawlStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "FAILED", "SUCCEEDED"]
    }
}
impl AsRef<str> for LastCrawlStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A scheduling object using a <code>cron</code> statement to schedule an event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Schedule {
    /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
    /// something every day at 12:15 UTC, you would specify:
    /// <code>cron(15 12 * * ? *)</code>.</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>The state of the schedule.</p>
    pub state: std::option::Option<crate::model::ScheduleState>,
}
impl std::fmt::Debug for Schedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Schedule");
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`Schedule`](crate::model::Schedule)
pub mod schedule {
    /// A builder for [`Schedule`](crate::model::Schedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ScheduleState>,
    }
    impl Builder {
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run
        /// something every day at 12:15 UTC, you would specify:
        /// <code>cron(15 12 * * ? *)</code>.</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>The state of the schedule.</p>
        pub fn state(mut self, input: crate::model::ScheduleState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the schedule.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ScheduleState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`Schedule`](crate::model::Schedule)
        pub fn build(self) -> crate::model::Schedule {
            crate::model::Schedule {
                schedule_expression: self.schedule_expression,
                state: self.state,
            }
        }
    }
}
impl Schedule {
    /// Creates a new builder-style object to manufacture [`Schedule`](crate::model::Schedule)
    pub fn builder() -> crate::model::schedule::Builder {
        crate::model::schedule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduleState {
    #[allow(missing_docs)] // documentation missing in model
    NotScheduled,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    #[allow(missing_docs)] // documentation missing in model
    Transitioning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduleState {
    fn from(s: &str) -> Self {
        match s {
            "NOT_SCHEDULED" => ScheduleState::NotScheduled,
            "SCHEDULED" => ScheduleState::Scheduled,
            "TRANSITIONING" => ScheduleState::Transitioning,
            other => ScheduleState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduleState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduleState::from(s))
    }
}
impl ScheduleState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduleState::NotScheduled => "NOT_SCHEDULED",
            ScheduleState::Scheduled => "SCHEDULED",
            ScheduleState::Transitioning => "TRANSITIONING",
            ScheduleState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_SCHEDULED", "SCHEDULED", "TRANSITIONING"]
    }
}
impl AsRef<str> for ScheduleState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CrawlerState {
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CrawlerState {
    fn from(s: &str) -> Self {
        match s {
            "READY" => CrawlerState::Ready,
            "RUNNING" => CrawlerState::Running,
            "STOPPING" => CrawlerState::Stopping,
            other => CrawlerState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CrawlerState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CrawlerState::from(s))
    }
}
impl CrawlerState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CrawlerState::Ready => "READY",
            CrawlerState::Running => "RUNNING",
            CrawlerState::Stopping => "STOPPING",
            CrawlerState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["READY", "RUNNING", "STOPPING"]
    }
}
impl AsRef<str> for CrawlerState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metrics for a specified crawler.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CrawlerMetrics {
    /// <p>The name of the crawler.</p>
    pub crawler_name: std::option::Option<std::string::String>,
    /// <p>The estimated time left to complete a running crawl.</p>
    pub time_left_seconds: f64,
    /// <p>True if the crawler is still estimating how long it will take to complete this run.</p>
    pub still_estimating: bool,
    /// <p>The duration of the crawler's most recent run, in seconds.</p>
    pub last_runtime_seconds: f64,
    /// <p>The median duration of this crawler's runs, in seconds.</p>
    pub median_runtime_seconds: f64,
    /// <p>The number of tables created by this crawler.</p>
    pub tables_created: i32,
    /// <p>The number of tables updated by this crawler.</p>
    pub tables_updated: i32,
    /// <p>The number of tables deleted by this crawler.</p>
    pub tables_deleted: i32,
}
impl std::fmt::Debug for CrawlerMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CrawlerMetrics");
        formatter.field("crawler_name", &self.crawler_name);
        formatter.field("time_left_seconds", &self.time_left_seconds);
        formatter.field("still_estimating", &self.still_estimating);
        formatter.field("last_runtime_seconds", &self.last_runtime_seconds);
        formatter.field("median_runtime_seconds", &self.median_runtime_seconds);
        formatter.field("tables_created", &self.tables_created);
        formatter.field("tables_updated", &self.tables_updated);
        formatter.field("tables_deleted", &self.tables_deleted);
        formatter.finish()
    }
}
/// See [`CrawlerMetrics`](crate::model::CrawlerMetrics)
pub mod crawler_metrics {
    /// A builder for [`CrawlerMetrics`](crate::model::CrawlerMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) crawler_name: std::option::Option<std::string::String>,
        pub(crate) time_left_seconds: std::option::Option<f64>,
        pub(crate) still_estimating: std::option::Option<bool>,
        pub(crate) last_runtime_seconds: std::option::Option<f64>,
        pub(crate) median_runtime_seconds: std::option::Option<f64>,
        pub(crate) tables_created: std::option::Option<i32>,
        pub(crate) tables_updated: std::option::Option<i32>,
        pub(crate) tables_deleted: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the crawler.</p>
        pub fn crawler_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.crawler_name = Some(input.into());
            self
        }
        /// <p>The name of the crawler.</p>
        pub fn set_crawler_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.crawler_name = input;
            self
        }
        /// <p>The estimated time left to complete a running crawl.</p>
        pub fn time_left_seconds(mut self, input: f64) -> Self {
            self.time_left_seconds = Some(input);
            self
        }
        /// <p>The estimated time left to complete a running crawl.</p>
        pub fn set_time_left_seconds(mut self, input: std::option::Option<f64>) -> Self {
            self.time_left_seconds = input;
            self
        }
        /// <p>True if the crawler is still estimating how long it will take to complete this run.</p>
        pub fn still_estimating(mut self, input: bool) -> Self {
            self.still_estimating = Some(input);
            self
        }
        /// <p>True if the crawler is still estimating how long it will take to complete this run.</p>
        pub fn set_still_estimating(mut self, input: std::option::Option<bool>) -> Self {
            self.still_estimating = input;
            self
        }
        /// <p>The duration of the crawler's most recent run, in seconds.</p>
        pub fn last_runtime_seconds(mut self, input: f64) -> Self {
            self.last_runtime_seconds = Some(input);
            self
        }
        /// <p>The duration of the crawler's most recent run, in seconds.</p>
        pub fn set_last_runtime_seconds(mut self, input: std::option::Option<f64>) -> Self {
            self.last_runtime_seconds = input;
            self
        }
        /// <p>The median duration of this crawler's runs, in seconds.</p>
        pub fn median_runtime_seconds(mut self, input: f64) -> Self {
            self.median_runtime_seconds = Some(input);
            self
        }
        /// <p>The median duration of this crawler's runs, in seconds.</p>
        pub fn set_median_runtime_seconds(mut self, input: std::option::Option<f64>) -> Self {
            self.median_runtime_seconds = input;
            self
        }
        /// <p>The number of tables created by this crawler.</p>
        pub fn tables_created(mut self, input: i32) -> Self {
            self.tables_created = Some(input);
            self
        }
        /// <p>The number of tables created by this crawler.</p>
        pub fn set_tables_created(mut self, input: std::option::Option<i32>) -> Self {
            self.tables_created = input;
            self
        }
        /// <p>The number of tables updated by this crawler.</p>
        pub fn tables_updated(mut self, input: i32) -> Self {
            self.tables_updated = Some(input);
            self
        }
        /// <p>The number of tables updated by this crawler.</p>
        pub fn set_tables_updated(mut self, input: std::option::Option<i32>) -> Self {
            self.tables_updated = input;
            self
        }
        /// <p>The number of tables deleted by this crawler.</p>
        pub fn tables_deleted(mut self, input: i32) -> Self {
            self.tables_deleted = Some(input);
            self
        }
        /// <p>The number of tables deleted by this crawler.</p>
        pub fn set_tables_deleted(mut self, input: std::option::Option<i32>) -> Self {
            self.tables_deleted = input;
            self
        }
        /// Consumes the builder and constructs a [`CrawlerMetrics`](crate::model::CrawlerMetrics)
        pub fn build(self) -> crate::model::CrawlerMetrics {
            crate::model::CrawlerMetrics {
                crawler_name: self.crawler_name,
                time_left_seconds: self.time_left_seconds.unwrap_or_default(),
                still_estimating: self.still_estimating.unwrap_or_default(),
                last_runtime_seconds: self.last_runtime_seconds.unwrap_or_default(),
                median_runtime_seconds: self.median_runtime_seconds.unwrap_or_default(),
                tables_created: self.tables_created.unwrap_or_default(),
                tables_updated: self.tables_updated.unwrap_or_default(),
                tables_deleted: self.tables_deleted.unwrap_or_default(),
            }
        }
    }
}
impl CrawlerMetrics {
    /// Creates a new builder-style object to manufacture [`CrawlerMetrics`](crate::model::CrawlerMetrics)
    pub fn builder() -> crate::model::crawler_metrics::Builder {
        crate::model::crawler_metrics::Builder::default()
    }
}

/// <p>Defines a connection to a data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Connection {
    /// <p>The name of the connection definition.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the connection.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the connection. Currently, SFTP is not supported.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
    /// <p>A list of criteria that can be used in selecting this connection.</p>
    pub match_criteria: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>These key-value pairs define parameters for the connection:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HOST</code> - The host URI: either the
    /// fully qualified domain name (FQDN) or the IPv4 address of
    /// the database host.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PORT</code> - The port number, between
    /// 1024 and 65535, of the port on which the database host is
    /// listening for database connections.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>USER_NAME</code> -  The name under which
    /// to log in to the database. The value string for <code>USER_NAME</code> is "<code>USERNAME</code>".</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PASSWORD</code> - A password,
    /// if one is used, for the user name.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores the encrypted password.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the
    /// JAR file that contains the JDBC driver to use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONFIG_FILES</code> - (Reserved for future use.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INSTANCE_ID</code> - The instance ID to use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure
    /// Sockets Layer (SSL) with hostname matching is enforced for the JDBC connection on the
    /// client. The default is false.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue uses this root certificate to validate the customer’s certificate when connecting to the customer database. Glue only handles X.509 certificates. The certificate provided must be DER-encoded and supplied in Base64 encoding PEM format.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates the Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only permitted algorithms for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject Public Key Algorithm, the key length must be at least 2048. You can set the value of this property to <code>true</code> to skip Glue’s validation of the customer certificate.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match or distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as the <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the <code>hostNameInCertificate</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the addresses of the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and bootstrap itself.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection. Default value is "true".</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The default is an empty string.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or not. Glue validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default value is "false".</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka client side authentication (Optional).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the password to access the client key to be used with the Kafka server side key (Optional).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client keystore password (if the user has the Glue encrypt passwords setting selected).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key password (if the user has the Glue encrypt passwords setting selected).</p>
    /// </li>
    /// </ul>
    pub connection_properties: std::option::Option<
        std::collections::HashMap<crate::model::ConnectionPropertyKey, std::string::String>,
    >,
    /// <p>A map of physical connection requirements, such as virtual private cloud (VPC) and
    /// <code>SecurityGroup</code>, that are needed to make this connection successfully.</p>
    pub physical_connection_requirements:
        std::option::Option<crate::model::PhysicalConnectionRequirements>,
    /// <p>The time that this connection definition was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time that this connection definition was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The user, group, or role that last updated this connection definition.</p>
    pub last_updated_by: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Connection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Connection");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("connection_type", &self.connection_type);
        formatter.field("match_criteria", &self.match_criteria);
        formatter.field("connection_properties", &self.connection_properties);
        formatter.field(
            "physical_connection_requirements",
            &self.physical_connection_requirements,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("last_updated_by", &self.last_updated_by);
        formatter.finish()
    }
}
/// See [`Connection`](crate::model::Connection)
pub mod connection {
    /// A builder for [`Connection`](crate::model::Connection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
        pub(crate) match_criteria: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) connection_properties: std::option::Option<
            std::collections::HashMap<crate::model::ConnectionPropertyKey, std::string::String>,
        >,
        pub(crate) physical_connection_requirements:
            std::option::Option<crate::model::PhysicalConnectionRequirements>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the connection definition.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the connection definition.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the connection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the connection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the connection. Currently, SFTP is not supported.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of the connection. Currently, SFTP is not supported.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// Appends an item to `match_criteria`.
        ///
        /// To override the contents of this collection use [`set_match_criteria`](Self::set_match_criteria).
        ///
        /// <p>A list of criteria that can be used in selecting this connection.</p>
        pub fn match_criteria(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.match_criteria.unwrap_or_default();
            v.push(input.into());
            self.match_criteria = Some(v);
            self
        }
        /// <p>A list of criteria that can be used in selecting this connection.</p>
        pub fn set_match_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.match_criteria = input;
            self
        }
        /// Adds a key-value pair to `connection_properties`.
        ///
        /// To override the contents of this collection use [`set_connection_properties`](Self::set_connection_properties).
        ///
        /// <p>These key-value pairs define parameters for the connection:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HOST</code> - The host URI: either the
        /// fully qualified domain name (FQDN) or the IPv4 address of
        /// the database host.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PORT</code> - The port number, between
        /// 1024 and 65535, of the port on which the database host is
        /// listening for database connections.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>USER_NAME</code> -  The name under which
        /// to log in to the database. The value string for <code>USER_NAME</code> is "<code>USERNAME</code>".</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PASSWORD</code> - A password,
        /// if one is used, for the user name.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores the encrypted password.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the
        /// JAR file that contains the JDBC driver to use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONFIG_FILES</code> - (Reserved for future use.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INSTANCE_ID</code> - The instance ID to use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure
        /// Sockets Layer (SSL) with hostname matching is enforced for the JDBC connection on the
        /// client. The default is false.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue uses this root certificate to validate the customer’s certificate when connecting to the customer database. Glue only handles X.509 certificates. The certificate provided must be DER-encoded and supplied in Base64 encoding PEM format.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates the Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only permitted algorithms for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject Public Key Algorithm, the key length must be at least 2048. You can set the value of this property to <code>true</code> to skip Glue’s validation of the customer certificate.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match or distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as the <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the <code>hostNameInCertificate</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the addresses of the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and bootstrap itself.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection. Default value is "true".</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The default is an empty string.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or not. Glue validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default value is "false".</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka client side authentication (Optional).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the password to access the client key to be used with the Kafka server side key (Optional).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client keystore password (if the user has the Glue encrypt passwords setting selected).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key password (if the user has the Glue encrypt passwords setting selected).</p>
        /// </li>
        /// </ul>
        pub fn connection_properties(
            mut self,
            k: impl Into<crate::model::ConnectionPropertyKey>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.connection_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.connection_properties = Some(hash_map);
            self
        }
        /// <p>These key-value pairs define parameters for the connection:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HOST</code> - The host URI: either the
        /// fully qualified domain name (FQDN) or the IPv4 address of
        /// the database host.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PORT</code> - The port number, between
        /// 1024 and 65535, of the port on which the database host is
        /// listening for database connections.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>USER_NAME</code> -  The name under which
        /// to log in to the database. The value string for <code>USER_NAME</code> is "<code>USERNAME</code>".</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PASSWORD</code> - A password,
        /// if one is used, for the user name.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores the encrypted password.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the
        /// JAR file that contains the JDBC driver to use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONFIG_FILES</code> - (Reserved for future use.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INSTANCE_ID</code> - The instance ID to use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure
        /// Sockets Layer (SSL) with hostname matching is enforced for the JDBC connection on the
        /// client. The default is false.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer's root certificate. Glue uses this root certificate to validate the customer’s certificate when connecting to the customer database. Glue only handles X.509 certificates. The certificate provided must be DER-encoded and supplied in Base64 encoding PEM format.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. Glue validates the Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only permitted algorithms for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject Public Key Algorithm, the key length must be at least 2048. You can set the value of this property to <code>true</code> to skip Glue’s validation of the customer certificate.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match or distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as the <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the <code>hostNameInCertificate</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the addresses of the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and bootstrap itself.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection. Default value is "true".</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The default is an empty string.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or not. Glue validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default value is "false".</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SECRET_ID</code> - The secret ID used for the secret manager of credentials.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONNECTOR_URL</code> - The connector URL for a MARKETPLACE or CUSTOM connection.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONNECTOR_TYPE</code> - The connector type for a MARKETPLACE or CUSTOM connection.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONNECTOR_CLASS_NAME</code> - The connector class name for a MARKETPLACE or CUSTOM connection.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_CLIENT_KEYSTORE</code> - The Amazon S3 location of the client keystore file for Kafka client side authentication (Optional).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The password to access the provided keystore (Optional).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KAFKA_CLIENT_KEY_PASSWORD</code> - A keystore can consist of multiple keys, so this is the password to access the client key to be used with the Kafka server side key (Optional).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENCRYPTED_KAFKA_CLIENT_KEYSTORE_PASSWORD</code> - The encrypted version of the Kafka client keystore password (if the user has the Glue encrypt passwords setting selected).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENCRYPTED_KAFKA_CLIENT_KEY_PASSWORD</code> - The encrypted version of the Kafka client key password (if the user has the Glue encrypt passwords setting selected).</p>
        /// </li>
        /// </ul>
        pub fn set_connection_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::ConnectionPropertyKey, std::string::String>,
            >,
        ) -> Self {
            self.connection_properties = input;
            self
        }
        /// <p>A map of physical connection requirements, such as virtual private cloud (VPC) and
        /// <code>SecurityGroup</code>, that are needed to make this connection successfully.</p>
        pub fn physical_connection_requirements(
            mut self,
            input: crate::model::PhysicalConnectionRequirements,
        ) -> Self {
            self.physical_connection_requirements = Some(input);
            self
        }
        /// <p>A map of physical connection requirements, such as virtual private cloud (VPC) and
        /// <code>SecurityGroup</code>, that are needed to make this connection successfully.</p>
        pub fn set_physical_connection_requirements(
            mut self,
            input: std::option::Option<crate::model::PhysicalConnectionRequirements>,
        ) -> Self {
            self.physical_connection_requirements = input;
            self
        }
        /// <p>The time that this connection definition was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that this connection definition was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time that this connection definition was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The last time that this connection definition was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The user, group, or role that last updated this connection definition.</p>
        pub fn last_updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_by = Some(input.into());
            self
        }
        /// <p>The user, group, or role that last updated this connection definition.</p>
        pub fn set_last_updated_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_by = input;
            self
        }
        /// Consumes the builder and constructs a [`Connection`](crate::model::Connection)
        pub fn build(self) -> crate::model::Connection {
            crate::model::Connection {
                name: self.name,
                description: self.description,
                connection_type: self.connection_type,
                match_criteria: self.match_criteria,
                connection_properties: self.connection_properties,
                physical_connection_requirements: self.physical_connection_requirements,
                creation_time: self.creation_time,
                last_updated_time: self.last_updated_time,
                last_updated_by: self.last_updated_by,
            }
        }
    }
}
impl Connection {
    /// Creates a new builder-style object to manufacture [`Connection`](crate::model::Connection)
    pub fn builder() -> crate::model::connection::Builder {
        crate::model::connection::Builder::default()
    }
}

/// <p>Filters the connection definitions that are returned by the <code>GetConnections</code>
/// API operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetConnectionsFilter {
    /// <p>A criteria string that must match the criteria recorded in the
    /// connection definition for that connection definition to be returned.</p>
    pub match_criteria: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of connections to return. Currently, SFTP is not supported.</p>
    pub connection_type: std::option::Option<crate::model::ConnectionType>,
}
impl std::fmt::Debug for GetConnectionsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetConnectionsFilter");
        formatter.field("match_criteria", &self.match_criteria);
        formatter.field("connection_type", &self.connection_type);
        formatter.finish()
    }
}
/// See [`GetConnectionsFilter`](crate::model::GetConnectionsFilter)
pub mod get_connections_filter {
    /// A builder for [`GetConnectionsFilter`](crate::model::GetConnectionsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) match_criteria: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) connection_type: std::option::Option<crate::model::ConnectionType>,
    }
    impl Builder {
        /// Appends an item to `match_criteria`.
        ///
        /// To override the contents of this collection use [`set_match_criteria`](Self::set_match_criteria).
        ///
        /// <p>A criteria string that must match the criteria recorded in the
        /// connection definition for that connection definition to be returned.</p>
        pub fn match_criteria(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.match_criteria.unwrap_or_default();
            v.push(input.into());
            self.match_criteria = Some(v);
            self
        }
        /// <p>A criteria string that must match the criteria recorded in the
        /// connection definition for that connection definition to be returned.</p>
        pub fn set_match_criteria(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.match_criteria = input;
            self
        }
        /// <p>The type of connections to return. Currently, SFTP is not supported.</p>
        pub fn connection_type(mut self, input: crate::model::ConnectionType) -> Self {
            self.connection_type = Some(input);
            self
        }
        /// <p>The type of connections to return. Currently, SFTP is not supported.</p>
        pub fn set_connection_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionType>,
        ) -> Self {
            self.connection_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetConnectionsFilter`](crate::model::GetConnectionsFilter)
        pub fn build(self) -> crate::model::GetConnectionsFilter {
            crate::model::GetConnectionsFilter {
                match_criteria: self.match_criteria,
                connection_type: self.connection_type,
            }
        }
    }
}
impl GetConnectionsFilter {
    /// Creates a new builder-style object to manufacture [`GetConnectionsFilter`](crate::model::GetConnectionsFilter)
    pub fn builder() -> crate::model::get_connections_filter::Builder {
        crate::model::get_connections_filter::Builder::default()
    }
}

/// <p>Encapsulates a column name that failed and the reason for failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnError {
    /// <p>The name of the column that failed.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>An error message with the reason for the failure of an operation.</p>
    pub error: std::option::Option<crate::model::ErrorDetail>,
}
impl std::fmt::Debug for ColumnError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnError");
        formatter.field("column_name", &self.column_name);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`ColumnError`](crate::model::ColumnError)
pub mod column_error {
    /// A builder for [`ColumnError`](crate::model::ColumnError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::ErrorDetail>,
    }
    impl Builder {
        /// <p>The name of the column that failed.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>The name of the column that failed.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// <p>An error message with the reason for the failure of an operation.</p>
        pub fn error(mut self, input: crate::model::ErrorDetail) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>An error message with the reason for the failure of an operation.</p>
        pub fn set_error(mut self, input: std::option::Option<crate::model::ErrorDetail>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnError`](crate::model::ColumnError)
        pub fn build(self) -> crate::model::ColumnError {
            crate::model::ColumnError {
                column_name: self.column_name,
                error: self.error,
            }
        }
    }
}
impl ColumnError {
    /// Creates a new builder-style object to manufacture [`ColumnError`](crate::model::ColumnError)
    pub fn builder() -> crate::model::column_error::Builder {
        crate::model::column_error::Builder::default()
    }
}

/// <p>Classifiers are triggered during a crawl task. A classifier checks whether a given file is
/// in a format it can handle. If it is, the classifier creates a schema in the form of a
/// <code>StructType</code> object that matches that data format.</p>
/// <p>You can use the standard classifiers that Glue provides, or you can write your own
/// classifiers to best categorize your data sources and specify the appropriate schemas to use
/// for them. A classifier can be a <code>grok</code> classifier, an <code>XML</code> classifier,
/// a <code>JSON</code> classifier, or a custom <code>CSV</code> classifier, as specified in one
/// of the fields in the <code>Classifier</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Classifier {
    /// <p>A classifier that uses <code>grok</code>.</p>
    pub grok_classifier: std::option::Option<crate::model::GrokClassifier>,
    /// <p>A classifier for XML content.</p>
    pub xml_classifier: std::option::Option<crate::model::XmlClassifier>,
    /// <p>A classifier for JSON content.</p>
    pub json_classifier: std::option::Option<crate::model::JsonClassifier>,
    /// <p>A classifier for comma-separated values (CSV).</p>
    pub csv_classifier: std::option::Option<crate::model::CsvClassifier>,
}
impl std::fmt::Debug for Classifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Classifier");
        formatter.field("grok_classifier", &self.grok_classifier);
        formatter.field("xml_classifier", &self.xml_classifier);
        formatter.field("json_classifier", &self.json_classifier);
        formatter.field("csv_classifier", &self.csv_classifier);
        formatter.finish()
    }
}
/// See [`Classifier`](crate::model::Classifier)
pub mod classifier {
    /// A builder for [`Classifier`](crate::model::Classifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grok_classifier: std::option::Option<crate::model::GrokClassifier>,
        pub(crate) xml_classifier: std::option::Option<crate::model::XmlClassifier>,
        pub(crate) json_classifier: std::option::Option<crate::model::JsonClassifier>,
        pub(crate) csv_classifier: std::option::Option<crate::model::CsvClassifier>,
    }
    impl Builder {
        /// <p>A classifier that uses <code>grok</code>.</p>
        pub fn grok_classifier(mut self, input: crate::model::GrokClassifier) -> Self {
            self.grok_classifier = Some(input);
            self
        }
        /// <p>A classifier that uses <code>grok</code>.</p>
        pub fn set_grok_classifier(
            mut self,
            input: std::option::Option<crate::model::GrokClassifier>,
        ) -> Self {
            self.grok_classifier = input;
            self
        }
        /// <p>A classifier for XML content.</p>
        pub fn xml_classifier(mut self, input: crate::model::XmlClassifier) -> Self {
            self.xml_classifier = Some(input);
            self
        }
        /// <p>A classifier for XML content.</p>
        pub fn set_xml_classifier(
            mut self,
            input: std::option::Option<crate::model::XmlClassifier>,
        ) -> Self {
            self.xml_classifier = input;
            self
        }
        /// <p>A classifier for JSON content.</p>
        pub fn json_classifier(mut self, input: crate::model::JsonClassifier) -> Self {
            self.json_classifier = Some(input);
            self
        }
        /// <p>A classifier for JSON content.</p>
        pub fn set_json_classifier(
            mut self,
            input: std::option::Option<crate::model::JsonClassifier>,
        ) -> Self {
            self.json_classifier = input;
            self
        }
        /// <p>A classifier for comma-separated values (CSV).</p>
        pub fn csv_classifier(mut self, input: crate::model::CsvClassifier) -> Self {
            self.csv_classifier = Some(input);
            self
        }
        /// <p>A classifier for comma-separated values (CSV).</p>
        pub fn set_csv_classifier(
            mut self,
            input: std::option::Option<crate::model::CsvClassifier>,
        ) -> Self {
            self.csv_classifier = input;
            self
        }
        /// Consumes the builder and constructs a [`Classifier`](crate::model::Classifier)
        pub fn build(self) -> crate::model::Classifier {
            crate::model::Classifier {
                grok_classifier: self.grok_classifier,
                xml_classifier: self.xml_classifier,
                json_classifier: self.json_classifier,
                csv_classifier: self.csv_classifier,
            }
        }
    }
}
impl Classifier {
    /// Creates a new builder-style object to manufacture [`Classifier`](crate::model::Classifier)
    pub fn builder() -> crate::model::classifier::Builder {
        crate::model::classifier::Builder::default()
    }
}

/// <p>A classifier for custom <code>CSV</code> content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CsvClassifier {
    /// <p>The name of the classifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time that this classifier was registered.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that this classifier was last updated.</p>
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version of this classifier.</p>
    pub version: i64,
    /// <p>A custom symbol to denote what separates each column entry in the row.</p>
    pub delimiter: std::option::Option<std::string::String>,
    /// <p>A custom symbol to denote what combines content into a single column value. It must be
    /// different from the column delimiter.</p>
    pub quote_symbol: std::option::Option<std::string::String>,
    /// <p>Indicates whether the CSV file contains a header.</p>
    pub contains_header: std::option::Option<crate::model::CsvHeaderOption>,
    /// <p>A list of strings representing column names.</p>
    pub header: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies not to trim values before identifying the type of column values. The default
    /// value is <code>true</code>.</p>
    pub disable_value_trimming: std::option::Option<bool>,
    /// <p>Enables the processing of files that contain only one column.</p>
    pub allow_single_column: std::option::Option<bool>,
}
impl std::fmt::Debug for CsvClassifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CsvClassifier");
        formatter.field("name", &self.name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("version", &self.version);
        formatter.field("delimiter", &self.delimiter);
        formatter.field("quote_symbol", &self.quote_symbol);
        formatter.field("contains_header", &self.contains_header);
        formatter.field("header", &self.header);
        formatter.field("disable_value_trimming", &self.disable_value_trimming);
        formatter.field("allow_single_column", &self.allow_single_column);
        formatter.finish()
    }
}
/// See [`CsvClassifier`](crate::model::CsvClassifier)
pub mod csv_classifier {
    /// A builder for [`CsvClassifier`](crate::model::CsvClassifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) quote_symbol: std::option::Option<std::string::String>,
        pub(crate) contains_header: std::option::Option<crate::model::CsvHeaderOption>,
        pub(crate) header: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) disable_value_trimming: std::option::Option<bool>,
        pub(crate) allow_single_column: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the classifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the classifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time that this classifier was registered.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that this classifier was registered.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that this classifier was last updated.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The time that this classifier was last updated.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The version of this classifier.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of this classifier.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>A custom symbol to denote what separates each column entry in the row.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A custom symbol to denote what separates each column entry in the row.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>A custom symbol to denote what combines content into a single column value. It must be
        /// different from the column delimiter.</p>
        pub fn quote_symbol(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_symbol = Some(input.into());
            self
        }
        /// <p>A custom symbol to denote what combines content into a single column value. It must be
        /// different from the column delimiter.</p>
        pub fn set_quote_symbol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quote_symbol = input;
            self
        }
        /// <p>Indicates whether the CSV file contains a header.</p>
        pub fn contains_header(mut self, input: crate::model::CsvHeaderOption) -> Self {
            self.contains_header = Some(input);
            self
        }
        /// <p>Indicates whether the CSV file contains a header.</p>
        pub fn set_contains_header(
            mut self,
            input: std::option::Option<crate::model::CsvHeaderOption>,
        ) -> Self {
            self.contains_header = input;
            self
        }
        /// Appends an item to `header`.
        ///
        /// To override the contents of this collection use [`set_header`](Self::set_header).
        ///
        /// <p>A list of strings representing column names.</p>
        pub fn header(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.header.unwrap_or_default();
            v.push(input.into());
            self.header = Some(v);
            self
        }
        /// <p>A list of strings representing column names.</p>
        pub fn set_header(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.header = input;
            self
        }
        /// <p>Specifies not to trim values before identifying the type of column values. The default
        /// value is <code>true</code>.</p>
        pub fn disable_value_trimming(mut self, input: bool) -> Self {
            self.disable_value_trimming = Some(input);
            self
        }
        /// <p>Specifies not to trim values before identifying the type of column values. The default
        /// value is <code>true</code>.</p>
        pub fn set_disable_value_trimming(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_value_trimming = input;
            self
        }
        /// <p>Enables the processing of files that contain only one column.</p>
        pub fn allow_single_column(mut self, input: bool) -> Self {
            self.allow_single_column = Some(input);
            self
        }
        /// <p>Enables the processing of files that contain only one column.</p>
        pub fn set_allow_single_column(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_single_column = input;
            self
        }
        /// Consumes the builder and constructs a [`CsvClassifier`](crate::model::CsvClassifier)
        pub fn build(self) -> crate::model::CsvClassifier {
            crate::model::CsvClassifier {
                name: self.name,
                creation_time: self.creation_time,
                last_updated: self.last_updated,
                version: self.version.unwrap_or_default(),
                delimiter: self.delimiter,
                quote_symbol: self.quote_symbol,
                contains_header: self.contains_header,
                header: self.header,
                disable_value_trimming: self.disable_value_trimming,
                allow_single_column: self.allow_single_column,
            }
        }
    }
}
impl CsvClassifier {
    /// Creates a new builder-style object to manufacture [`CsvClassifier`](crate::model::CsvClassifier)
    pub fn builder() -> crate::model::csv_classifier::Builder {
        crate::model::csv_classifier::Builder::default()
    }
}

/// <p>A classifier for <code>JSON</code> content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JsonClassifier {
    /// <p>The name of the classifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time that this classifier was registered.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that this classifier was last updated.</p>
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version of this classifier.</p>
    pub version: i64,
    /// <p>A <code>JsonPath</code> string defining the JSON data for the classifier to classify.
    /// Glue supports a subset of JsonPath, as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a>.</p>
    pub json_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for JsonClassifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JsonClassifier");
        formatter.field("name", &self.name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("version", &self.version);
        formatter.field("json_path", &self.json_path);
        formatter.finish()
    }
}
/// See [`JsonClassifier`](crate::model::JsonClassifier)
pub mod json_classifier {
    /// A builder for [`JsonClassifier`](crate::model::JsonClassifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) json_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the classifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the classifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time that this classifier was registered.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that this classifier was registered.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that this classifier was last updated.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The time that this classifier was last updated.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The version of this classifier.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of this classifier.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>A <code>JsonPath</code> string defining the JSON data for the classifier to classify.
        /// Glue supports a subset of JsonPath, as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a>.</p>
        pub fn json_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.json_path = Some(input.into());
            self
        }
        /// <p>A <code>JsonPath</code> string defining the JSON data for the classifier to classify.
        /// Glue supports a subset of JsonPath, as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a>.</p>
        pub fn set_json_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.json_path = input;
            self
        }
        /// Consumes the builder and constructs a [`JsonClassifier`](crate::model::JsonClassifier)
        pub fn build(self) -> crate::model::JsonClassifier {
            crate::model::JsonClassifier {
                name: self.name,
                creation_time: self.creation_time,
                last_updated: self.last_updated,
                version: self.version.unwrap_or_default(),
                json_path: self.json_path,
            }
        }
    }
}
impl JsonClassifier {
    /// Creates a new builder-style object to manufacture [`JsonClassifier`](crate::model::JsonClassifier)
    pub fn builder() -> crate::model::json_classifier::Builder {
        crate::model::json_classifier::Builder::default()
    }
}

/// <p>A classifier for <code>XML</code> content.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct XmlClassifier {
    /// <p>The name of the classifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An identifier of the data format that the classifier matches.</p>
    pub classification: std::option::Option<std::string::String>,
    /// <p>The time that this classifier was registered.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that this classifier was last updated.</p>
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version of this classifier.</p>
    pub version: i64,
    /// <p>The XML tag designating the element that contains each record in an XML document being
    /// parsed. This can't identify a self-closing element (closed by <code>/></code>). An empty
    /// row element that contains only attributes can be parsed as long as it ends with a closing tag
    /// (for example, <code><row item_a="A" item_b="B"></row></code> is okay, but
    /// <code><row item_a="A" item_b="B" /></code> is not).</p>
    pub row_tag: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for XmlClassifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("XmlClassifier");
        formatter.field("name", &self.name);
        formatter.field("classification", &self.classification);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("version", &self.version);
        formatter.field("row_tag", &self.row_tag);
        formatter.finish()
    }
}
/// See [`XmlClassifier`](crate::model::XmlClassifier)
pub mod xml_classifier {
    /// A builder for [`XmlClassifier`](crate::model::XmlClassifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) classification: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) row_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the classifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the classifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An identifier of the data format that the classifier matches.</p>
        pub fn classification(mut self, input: impl Into<std::string::String>) -> Self {
            self.classification = Some(input.into());
            self
        }
        /// <p>An identifier of the data format that the classifier matches.</p>
        pub fn set_classification(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.classification = input;
            self
        }
        /// <p>The time that this classifier was registered.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that this classifier was registered.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that this classifier was last updated.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The time that this classifier was last updated.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The version of this classifier.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of this classifier.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The XML tag designating the element that contains each record in an XML document being
        /// parsed. This can't identify a self-closing element (closed by <code>/></code>). An empty
        /// row element that contains only attributes can be parsed as long as it ends with a closing tag
        /// (for example, <code><row item_a="A" item_b="B"></row></code> is okay, but
        /// <code><row item_a="A" item_b="B" /></code> is not).</p>
        pub fn row_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.row_tag = Some(input.into());
            self
        }
        /// <p>The XML tag designating the element that contains each record in an XML document being
        /// parsed. This can't identify a self-closing element (closed by <code>/></code>). An empty
        /// row element that contains only attributes can be parsed as long as it ends with a closing tag
        /// (for example, <code><row item_a="A" item_b="B"></row></code> is okay, but
        /// <code><row item_a="A" item_b="B" /></code> is not).</p>
        pub fn set_row_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.row_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`XmlClassifier`](crate::model::XmlClassifier)
        pub fn build(self) -> crate::model::XmlClassifier {
            crate::model::XmlClassifier {
                name: self.name,
                classification: self.classification,
                creation_time: self.creation_time,
                last_updated: self.last_updated,
                version: self.version.unwrap_or_default(),
                row_tag: self.row_tag,
            }
        }
    }
}
impl XmlClassifier {
    /// Creates a new builder-style object to manufacture [`XmlClassifier`](crate::model::XmlClassifier)
    pub fn builder() -> crate::model::xml_classifier::Builder {
        crate::model::xml_classifier::Builder::default()
    }
}

/// <p>A classifier that uses <code>grok</code> patterns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrokClassifier {
    /// <p>The name of the classifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, and
    /// so on.</p>
    pub classification: std::option::Option<std::string::String>,
    /// <p>The time that this classifier was registered.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that this classifier was last updated.</p>
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version of this classifier.</p>
    pub version: i64,
    /// <p>The grok pattern applied to a data store by this classifier.
    /// For more information, see built-in patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.</p>
    pub grok_pattern: std::option::Option<std::string::String>,
    /// <p>Optional custom grok patterns defined by this classifier.
    /// For more information, see custom patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.</p>
    pub custom_patterns: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GrokClassifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrokClassifier");
        formatter.field("name", &self.name);
        formatter.field("classification", &self.classification);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("version", &self.version);
        formatter.field("grok_pattern", &self.grok_pattern);
        formatter.field("custom_patterns", &self.custom_patterns);
        formatter.finish()
    }
}
/// See [`GrokClassifier`](crate::model::GrokClassifier)
pub mod grok_classifier {
    /// A builder for [`GrokClassifier`](crate::model::GrokClassifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) classification: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) grok_pattern: std::option::Option<std::string::String>,
        pub(crate) custom_patterns: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the classifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the classifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, and
        /// so on.</p>
        pub fn classification(mut self, input: impl Into<std::string::String>) -> Self {
            self.classification = Some(input.into());
            self
        }
        /// <p>An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, and
        /// so on.</p>
        pub fn set_classification(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.classification = input;
            self
        }
        /// <p>The time that this classifier was registered.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that this classifier was registered.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that this classifier was last updated.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The time that this classifier was last updated.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The version of this classifier.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of this classifier.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The grok pattern applied to a data store by this classifier.
        /// For more information, see built-in patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.</p>
        pub fn grok_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.grok_pattern = Some(input.into());
            self
        }
        /// <p>The grok pattern applied to a data store by this classifier.
        /// For more information, see built-in patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.</p>
        pub fn set_grok_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grok_pattern = input;
            self
        }
        /// <p>Optional custom grok patterns defined by this classifier.
        /// For more information, see custom patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.</p>
        pub fn custom_patterns(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_patterns = Some(input.into());
            self
        }
        /// <p>Optional custom grok patterns defined by this classifier.
        /// For more information, see custom patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.</p>
        pub fn set_custom_patterns(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_patterns = input;
            self
        }
        /// Consumes the builder and constructs a [`GrokClassifier`](crate::model::GrokClassifier)
        pub fn build(self) -> crate::model::GrokClassifier {
            crate::model::GrokClassifier {
                name: self.name,
                classification: self.classification,
                creation_time: self.creation_time,
                last_updated: self.last_updated,
                version: self.version.unwrap_or_default(),
                grok_pattern: self.grok_pattern,
                custom_patterns: self.custom_patterns,
            }
        }
    }
}
impl GrokClassifier {
    /// Creates a new builder-style object to manufacture [`GrokClassifier`](crate::model::GrokClassifier)
    pub fn builder() -> crate::model::grok_classifier::Builder {
        crate::model::grok_classifier::Builder::default()
    }
}

/// <p>A structure containing migration status information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CatalogImportStatus {
    /// <p>
    /// <code>True</code> if the migration has completed, or <code>False</code> otherwise.</p>
    pub import_completed: bool,
    /// <p>The time that the migration was started.</p>
    pub import_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the person who initiated the migration.</p>
    pub imported_by: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CatalogImportStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CatalogImportStatus");
        formatter.field("import_completed", &self.import_completed);
        formatter.field("import_time", &self.import_time);
        formatter.field("imported_by", &self.imported_by);
        formatter.finish()
    }
}
/// See [`CatalogImportStatus`](crate::model::CatalogImportStatus)
pub mod catalog_import_status {
    /// A builder for [`CatalogImportStatus`](crate::model::CatalogImportStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_completed: std::option::Option<bool>,
        pub(crate) import_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) imported_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// <code>True</code> if the migration has completed, or <code>False</code> otherwise.</p>
        pub fn import_completed(mut self, input: bool) -> Self {
            self.import_completed = Some(input);
            self
        }
        /// <p>
        /// <code>True</code> if the migration has completed, or <code>False</code> otherwise.</p>
        pub fn set_import_completed(mut self, input: std::option::Option<bool>) -> Self {
            self.import_completed = input;
            self
        }
        /// <p>The time that the migration was started.</p>
        pub fn import_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.import_time = Some(input);
            self
        }
        /// <p>The time that the migration was started.</p>
        pub fn set_import_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.import_time = input;
            self
        }
        /// <p>The name of the person who initiated the migration.</p>
        pub fn imported_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.imported_by = Some(input.into());
            self
        }
        /// <p>The name of the person who initiated the migration.</p>
        pub fn set_imported_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.imported_by = input;
            self
        }
        /// Consumes the builder and constructs a [`CatalogImportStatus`](crate::model::CatalogImportStatus)
        pub fn build(self) -> crate::model::CatalogImportStatus {
            crate::model::CatalogImportStatus {
                import_completed: self.import_completed.unwrap_or_default(),
                import_time: self.import_time,
                imported_by: self.imported_by,
            }
        }
    }
}
impl CatalogImportStatus {
    /// Creates a new builder-style object to manufacture [`CatalogImportStatus`](crate::model::CatalogImportStatus)
    pub fn builder() -> crate::model::catalog_import_status::Builder {
        crate::model::catalog_import_status::Builder::default()
    }
}

/// <p>The details of a blueprint run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlueprintRun {
    /// <p>The name of the blueprint.</p>
    pub blueprint_name: std::option::Option<std::string::String>,
    /// <p>The run ID for this blueprint run.</p>
    pub run_id: std::option::Option<std::string::String>,
    /// <p>The name of a workflow that is created as a result of a successful blueprint run. If a blueprint run has an error, there will not be a workflow created.</p>
    pub workflow_name: std::option::Option<std::string::String>,
    /// <p>The state of the blueprint run. Possible values are:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>Running — The blueprint run is in progress.</p>
    /// </li>
    /// <li>
    /// <p>Succeeded — The blueprint run completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>Failed — The blueprint run failed and rollback is complete.</p>
    /// </li>
    /// <li>
    /// <p>Rolling Back — The blueprint run failed and rollback is in progress.</p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<crate::model::BlueprintRunState>,
    /// <p>The date and time that the blueprint run started.</p>
    pub started_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the blueprint run completed.</p>
    pub completed_on: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates any errors that are seen while running the blueprint.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>If there are any errors while creating the entities of a workflow, we try to roll back the created entities until that point and delete them. This attribute indicates the errors seen while trying to delete the entities that are created.</p>
    pub rollback_error_message: std::option::Option<std::string::String>,
    /// <p>The blueprint parameters as a string. You will have to provide a value for each key that is required from the parameter spec that is defined in the <code>Blueprint$ParameterSpec</code>.</p>
    pub parameters: std::option::Option<std::string::String>,
    /// <p>The role ARN. This role will be assumed by the Glue service and will be used to create the workflow and other entities of a workflow.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BlueprintRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlueprintRun");
        formatter.field("blueprint_name", &self.blueprint_name);
        formatter.field("run_id", &self.run_id);
        formatter.field("workflow_name", &self.workflow_name);
        formatter.field("state", &self.state);
        formatter.field("started_on", &self.started_on);
        formatter.field("completed_on", &self.completed_on);
        formatter.field("error_message", &self.error_message);
        formatter.field("rollback_error_message", &self.rollback_error_message);
        formatter.field("parameters", &self.parameters);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`BlueprintRun`](crate::model::BlueprintRun)
pub mod blueprint_run {
    /// A builder for [`BlueprintRun`](crate::model::BlueprintRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blueprint_name: std::option::Option<std::string::String>,
        pub(crate) run_id: std::option::Option<std::string::String>,
        pub(crate) workflow_name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::BlueprintRunState>,
        pub(crate) started_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completed_on: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) rollback_error_message: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the blueprint.</p>
        pub fn blueprint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.blueprint_name = Some(input.into());
            self
        }
        /// <p>The name of the blueprint.</p>
        pub fn set_blueprint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.blueprint_name = input;
            self
        }
        /// <p>The run ID for this blueprint run.</p>
        pub fn run_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.run_id = Some(input.into());
            self
        }
        /// <p>The run ID for this blueprint run.</p>
        pub fn set_run_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.run_id = input;
            self
        }
        /// <p>The name of a workflow that is created as a result of a successful blueprint run. If a blueprint run has an error, there will not be a workflow created.</p>
        pub fn workflow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_name = Some(input.into());
            self
        }
        /// <p>The name of a workflow that is created as a result of a successful blueprint run. If a blueprint run has an error, there will not be a workflow created.</p>
        pub fn set_workflow_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workflow_name = input;
            self
        }
        /// <p>The state of the blueprint run. Possible values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Running — The blueprint run is in progress.</p>
        /// </li>
        /// <li>
        /// <p>Succeeded — The blueprint run completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>Failed — The blueprint run failed and rollback is complete.</p>
        /// </li>
        /// <li>
        /// <p>Rolling Back — The blueprint run failed and rollback is in progress.</p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: crate::model::BlueprintRunState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the blueprint run. Possible values are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Running — The blueprint run is in progress.</p>
        /// </li>
        /// <li>
        /// <p>Succeeded — The blueprint run completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>Failed — The blueprint run failed and rollback is complete.</p>
        /// </li>
        /// <li>
        /// <p>Rolling Back — The blueprint run failed and rollback is in progress.</p>
        /// </li>
        /// </ul>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::BlueprintRunState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The date and time that the blueprint run started.</p>
        pub fn started_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_on = Some(input);
            self
        }
        /// <p>The date and time that the blueprint run started.</p>
        pub fn set_started_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_on = input;
            self
        }
        /// <p>The date and time that the blueprint run completed.</p>
        pub fn completed_on(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completed_on = Some(input);
            self
        }
        /// <p>The date and time that the blueprint run completed.</p>
        pub fn set_completed_on(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completed_on = input;
            self
        }
        /// <p>Indicates any errors that are seen while running the blueprint.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Indicates any errors that are seen while running the blueprint.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>If there are any errors while creating the entities of a workflow, we try to roll back the created entities until that point and delete them. This attribute indicates the errors seen while trying to delete the entities that are created.</p>
        pub fn rollback_error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.rollback_error_message = Some(input.into());
            self
        }
        /// <p>If there are any errors while creating the entities of a workflow, we try to roll back the created entities until that point and delete them. This attribute indicates the errors seen while trying to delete the entities that are created.</p>
        pub fn set_rollback_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rollback_error_message = input;
            self
        }
        /// <p>The blueprint parameters as a string. You will have to provide a value for each key that is required from the parameter spec that is defined in the <code>Blueprint$ParameterSpec</code>.</p>
        pub fn parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameters = Some(input.into());
            self
        }
        /// <p>The blueprint parameters as a string. You will have to provide a value for each key that is required from the parameter spec that is defined in the <code>Blueprint$ParameterSpec</code>.</p>
        pub fn set_parameters(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The role ARN. This role will be assumed by the Glue service and will be used to create the workflow and other entities of a workflow.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The role ARN. This role will be assumed by the Glue service and will be used to create the workflow and other entities of a workflow.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BlueprintRun`](crate::model::BlueprintRun)
        pub fn build(self) -> crate::model::BlueprintRun {
            crate::model::BlueprintRun {
                blueprint_name: self.blueprint_name,
                run_id: self.run_id,
                workflow_name: self.workflow_name,
                state: self.state,
                started_on: self.started_on,
                completed_on: self.completed_on,
                error_message: self.error_message,
                rollback_error_message: self.rollback_error_message,
                parameters: self.parameters,
                role_arn: self.role_arn,
            }
        }
    }
}
impl BlueprintRun {
    /// Creates a new builder-style object to manufacture [`BlueprintRun`](crate::model::BlueprintRun)
    pub fn builder() -> crate::model::blueprint_run::Builder {
        crate::model::blueprint_run::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BlueprintRunState {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    RollingBack,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BlueprintRunState {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => BlueprintRunState::Failed,
            "ROLLING_BACK" => BlueprintRunState::RollingBack,
            "RUNNING" => BlueprintRunState::Running,
            "SUCCEEDED" => BlueprintRunState::Succeeded,
            other => BlueprintRunState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BlueprintRunState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BlueprintRunState::from(s))
    }
}
impl BlueprintRunState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BlueprintRunState::Failed => "FAILED",
            BlueprintRunState::RollingBack => "ROLLING_BACK",
            BlueprintRunState::Running => "RUNNING",
            BlueprintRunState::Succeeded => "SUCCEEDED",
            BlueprintRunState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "ROLLING_BACK", "RUNNING", "SUCCEEDED"]
    }
}
impl AsRef<str> for BlueprintRunState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of a blueprint.</p>
#[non_exhaustive]
#[derive(std::