// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchCreatePartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_create_partition`](crate::client::Client::batch_create_partition).
///
/// See [`crate::client::fluent_builders::BatchCreatePartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchCreatePartition {
    _private: (),
}
impl BatchCreatePartition {
    /// Creates a new builder-style object to manufacture [`BatchCreatePartitionInput`](crate::input::BatchCreatePartitionInput)
    pub fn builder() -> crate::input::batch_create_partition_input::Builder {
        crate::input::batch_create_partition_input::Builder::default()
    }
    /// Creates a new `BatchCreatePartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchCreatePartition {
    type Output = std::result::Result<
        crate::output::BatchCreatePartitionOutput,
        crate::error::BatchCreatePartitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_create_partition_error(response)
        } else {
            crate::operation_deser::parse_batch_create_partition_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_connection`](crate::client::Client::batch_delete_connection).
///
/// See [`crate::client::fluent_builders::BatchDeleteConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteConnection {
    _private: (),
}
impl BatchDeleteConnection {
    /// Creates a new builder-style object to manufacture [`BatchDeleteConnectionInput`](crate::input::BatchDeleteConnectionInput)
    pub fn builder() -> crate::input::batch_delete_connection_input::Builder {
        crate::input::batch_delete_connection_input::Builder::default()
    }
    /// Creates a new `BatchDeleteConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteConnection {
    type Output = std::result::Result<
        crate::output::BatchDeleteConnectionOutput,
        crate::error::BatchDeleteConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_connection_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_connection_response(response)
        }
    }
}

/// Operation shape for `BatchDeletePartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_partition`](crate::client::Client::batch_delete_partition).
///
/// See [`crate::client::fluent_builders::BatchDeletePartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeletePartition {
    _private: (),
}
impl BatchDeletePartition {
    /// Creates a new builder-style object to manufacture [`BatchDeletePartitionInput`](crate::input::BatchDeletePartitionInput)
    pub fn builder() -> crate::input::batch_delete_partition_input::Builder {
        crate::input::batch_delete_partition_input::Builder::default()
    }
    /// Creates a new `BatchDeletePartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeletePartition {
    type Output = std::result::Result<
        crate::output::BatchDeletePartitionOutput,
        crate::error::BatchDeletePartitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_partition_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_partition_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_table`](crate::client::Client::batch_delete_table).
///
/// See [`crate::client::fluent_builders::BatchDeleteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteTable {
    _private: (),
}
impl BatchDeleteTable {
    /// Creates a new builder-style object to manufacture [`BatchDeleteTableInput`](crate::input::BatchDeleteTableInput)
    pub fn builder() -> crate::input::batch_delete_table_input::Builder {
        crate::input::batch_delete_table_input::Builder::default()
    }
    /// Creates a new `BatchDeleteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteTable {
    type Output = std::result::Result<
        crate::output::BatchDeleteTableOutput,
        crate::error::BatchDeleteTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_table_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_table_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteTableVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_table_version`](crate::client::Client::batch_delete_table_version).
///
/// See [`crate::client::fluent_builders::BatchDeleteTableVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteTableVersion {
    _private: (),
}
impl BatchDeleteTableVersion {
    /// Creates a new builder-style object to manufacture [`BatchDeleteTableVersionInput`](crate::input::BatchDeleteTableVersionInput)
    pub fn builder() -> crate::input::batch_delete_table_version_input::Builder {
        crate::input::batch_delete_table_version_input::Builder::default()
    }
    /// Creates a new `BatchDeleteTableVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteTableVersion {
    type Output = std::result::Result<
        crate::output::BatchDeleteTableVersionOutput,
        crate::error::BatchDeleteTableVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_table_version_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_table_version_response(response)
        }
    }
}

/// Operation shape for `BatchGetBlueprints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_blueprints`](crate::client::Client::batch_get_blueprints).
///
/// See [`crate::client::fluent_builders::BatchGetBlueprints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetBlueprints {
    _private: (),
}
impl BatchGetBlueprints {
    /// Creates a new builder-style object to manufacture [`BatchGetBlueprintsInput`](crate::input::BatchGetBlueprintsInput)
    pub fn builder() -> crate::input::batch_get_blueprints_input::Builder {
        crate::input::batch_get_blueprints_input::Builder::default()
    }
    /// Creates a new `BatchGetBlueprints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetBlueprints {
    type Output = std::result::Result<
        crate::output::BatchGetBlueprintsOutput,
        crate::error::BatchGetBlueprintsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_blueprints_error(response)
        } else {
            crate::operation_deser::parse_batch_get_blueprints_response(response)
        }
    }
}

/// Operation shape for `BatchGetCrawlers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_crawlers`](crate::client::Client::batch_get_crawlers).
///
/// See [`crate::client::fluent_builders::BatchGetCrawlers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetCrawlers {
    _private: (),
}
impl BatchGetCrawlers {
    /// Creates a new builder-style object to manufacture [`BatchGetCrawlersInput`](crate::input::BatchGetCrawlersInput)
    pub fn builder() -> crate::input::batch_get_crawlers_input::Builder {
        crate::input::batch_get_crawlers_input::Builder::default()
    }
    /// Creates a new `BatchGetCrawlers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetCrawlers {
    type Output = std::result::Result<
        crate::output::BatchGetCrawlersOutput,
        crate::error::BatchGetCrawlersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_crawlers_error(response)
        } else {
            crate::operation_deser::parse_batch_get_crawlers_response(response)
        }
    }
}

/// Operation shape for `BatchGetDevEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_dev_endpoints`](crate::client::Client::batch_get_dev_endpoints).
///
/// See [`crate::client::fluent_builders::BatchGetDevEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetDevEndpoints {
    _private: (),
}
impl BatchGetDevEndpoints {
    /// Creates a new builder-style object to manufacture [`BatchGetDevEndpointsInput`](crate::input::BatchGetDevEndpointsInput)
    pub fn builder() -> crate::input::batch_get_dev_endpoints_input::Builder {
        crate::input::batch_get_dev_endpoints_input::Builder::default()
    }
    /// Creates a new `BatchGetDevEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetDevEndpoints {
    type Output = std::result::Result<
        crate::output::BatchGetDevEndpointsOutput,
        crate::error::BatchGetDevEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_dev_endpoints_error(response)
        } else {
            crate::operation_deser::parse_batch_get_dev_endpoints_response(response)
        }
    }
}

/// Operation shape for `BatchGetJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_jobs`](crate::client::Client::batch_get_jobs).
///
/// See [`crate::client::fluent_builders::BatchGetJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetJobs {
    _private: (),
}
impl BatchGetJobs {
    /// Creates a new builder-style object to manufacture [`BatchGetJobsInput`](crate::input::BatchGetJobsInput)
    pub fn builder() -> crate::input::batch_get_jobs_input::Builder {
        crate::input::batch_get_jobs_input::Builder::default()
    }
    /// Creates a new `BatchGetJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetJobs {
    type Output =
        std::result::Result<crate::output::BatchGetJobsOutput, crate::error::BatchGetJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_jobs_error(response)
        } else {
            crate::operation_deser::parse_batch_get_jobs_response(response)
        }
    }
}

/// Operation shape for `BatchGetPartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_partition`](crate::client::Client::batch_get_partition).
///
/// See [`crate::client::fluent_builders::BatchGetPartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetPartition {
    _private: (),
}
impl BatchGetPartition {
    /// Creates a new builder-style object to manufacture [`BatchGetPartitionInput`](crate::input::BatchGetPartitionInput)
    pub fn builder() -> crate::input::batch_get_partition_input::Builder {
        crate::input::batch_get_partition_input::Builder::default()
    }
    /// Creates a new `BatchGetPartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetPartition {
    type Output = std::result::Result<
        crate::output::BatchGetPartitionOutput,
        crate::error::BatchGetPartitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_partition_error(response)
        } else {
            crate::operation_deser::parse_batch_get_partition_response(response)
        }
    }
}

/// Operation shape for `BatchGetTriggers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_triggers`](crate::client::Client::batch_get_triggers).
///
/// See [`crate::client::fluent_builders::BatchGetTriggers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetTriggers {
    _private: (),
}
impl BatchGetTriggers {
    /// Creates a new builder-style object to manufacture [`BatchGetTriggersInput`](crate::input::BatchGetTriggersInput)
    pub fn builder() -> crate::input::batch_get_triggers_input::Builder {
        crate::input::batch_get_triggers_input::Builder::default()
    }
    /// Creates a new `BatchGetTriggers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetTriggers {
    type Output = std::result::Result<
        crate::output::BatchGetTriggersOutput,
        crate::error::BatchGetTriggersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_triggers_error(response)
        } else {
            crate::operation_deser::parse_batch_get_triggers_response(response)
        }
    }
}

/// Operation shape for `BatchGetWorkflows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_workflows`](crate::client::Client::batch_get_workflows).
///
/// See [`crate::client::fluent_builders::BatchGetWorkflows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetWorkflows {
    _private: (),
}
impl BatchGetWorkflows {
    /// Creates a new builder-style object to manufacture [`BatchGetWorkflowsInput`](crate::input::BatchGetWorkflowsInput)
    pub fn builder() -> crate::input::batch_get_workflows_input::Builder {
        crate::input::batch_get_workflows_input::Builder::default()
    }
    /// Creates a new `BatchGetWorkflows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetWorkflows {
    type Output = std::result::Result<
        crate::output::BatchGetWorkflowsOutput,
        crate::error::BatchGetWorkflowsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_workflows_error(response)
        } else {
            crate::operation_deser::parse_batch_get_workflows_response(response)
        }
    }
}

/// Operation shape for `BatchStopJobRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_stop_job_run`](crate::client::Client::batch_stop_job_run).
///
/// See [`crate::client::fluent_builders::BatchStopJobRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchStopJobRun {
    _private: (),
}
impl BatchStopJobRun {
    /// Creates a new builder-style object to manufacture [`BatchStopJobRunInput`](crate::input::BatchStopJobRunInput)
    pub fn builder() -> crate::input::batch_stop_job_run_input::Builder {
        crate::input::batch_stop_job_run_input::Builder::default()
    }
    /// Creates a new `BatchStopJobRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchStopJobRun {
    type Output = std::result::Result<
        crate::output::BatchStopJobRunOutput,
        crate::error::BatchStopJobRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_stop_job_run_error(response)
        } else {
            crate::operation_deser::parse_batch_stop_job_run_response(response)
        }
    }
}

/// Operation shape for `BatchUpdatePartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_update_partition`](crate::client::Client::batch_update_partition).
///
/// See [`crate::client::fluent_builders::BatchUpdatePartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchUpdatePartition {
    _private: (),
}
impl BatchUpdatePartition {
    /// Creates a new builder-style object to manufacture [`BatchUpdatePartitionInput`](crate::input::BatchUpdatePartitionInput)
    pub fn builder() -> crate::input::batch_update_partition_input::Builder {
        crate::input::batch_update_partition_input::Builder::default()
    }
    /// Creates a new `BatchUpdatePartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchUpdatePartition {
    type Output = std::result::Result<
        crate::output::BatchUpdatePartitionOutput,
        crate::error::BatchUpdatePartitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_update_partition_error(response)
        } else {
            crate::operation_deser::parse_batch_update_partition_response(response)
        }
    }
}

/// Operation shape for `CancelMLTaskRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_ml_task_run`](crate::client::Client::cancel_ml_task_run).
///
/// See [`crate::client::fluent_builders::CancelMLTaskRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelMLTaskRun {
    _private: (),
}
impl CancelMLTaskRun {
    /// Creates a new builder-style object to manufacture [`CancelMlTaskRunInput`](crate::input::CancelMlTaskRunInput)
    pub fn builder() -> crate::input::cancel_ml_task_run_input::Builder {
        crate::input::cancel_ml_task_run_input::Builder::default()
    }
    /// Creates a new `CancelMLTaskRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelMLTaskRun {
    type Output = std::result::Result<
        crate::output::CancelMlTaskRunOutput,
        crate::error::CancelMLTaskRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_ml_task_run_error(response)
        } else {
            crate::operation_deser::parse_cancel_ml_task_run_response(response)
        }
    }
}

/// Operation shape for `CheckSchemaVersionValidity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`check_schema_version_validity`](crate::client::Client::check_schema_version_validity).
///
/// See [`crate::client::fluent_builders::CheckSchemaVersionValidity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CheckSchemaVersionValidity {
    _private: (),
}
impl CheckSchemaVersionValidity {
    /// Creates a new builder-style object to manufacture [`CheckSchemaVersionValidityInput`](crate::input::CheckSchemaVersionValidityInput)
    pub fn builder() -> crate::input::check_schema_version_validity_input::Builder {
        crate::input::check_schema_version_validity_input::Builder::default()
    }
    /// Creates a new `CheckSchemaVersionValidity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CheckSchemaVersionValidity {
    type Output = std::result::Result<
        crate::output::CheckSchemaVersionValidityOutput,
        crate::error::CheckSchemaVersionValidityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_check_schema_version_validity_error(response)
        } else {
            crate::operation_deser::parse_check_schema_version_validity_response(response)
        }
    }
}

/// Operation shape for `CreateBlueprint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_blueprint`](crate::client::Client::create_blueprint).
///
/// See [`crate::client::fluent_builders::CreateBlueprint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBlueprint {
    _private: (),
}
impl CreateBlueprint {
    /// Creates a new builder-style object to manufacture [`CreateBlueprintInput`](crate::input::CreateBlueprintInput)
    pub fn builder() -> crate::input::create_blueprint_input::Builder {
        crate::input::create_blueprint_input::Builder::default()
    }
    /// Creates a new `CreateBlueprint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBlueprint {
    type Output = std::result::Result<
        crate::output::CreateBlueprintOutput,
        crate::error::CreateBlueprintError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_blueprint_error(response)
        } else {
            crate::operation_deser::parse_create_blueprint_response(response)
        }
    }
}

/// Operation shape for `CreateClassifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_classifier`](crate::client::Client::create_classifier).
///
/// See [`crate::client::fluent_builders::CreateClassifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateClassifier {
    _private: (),
}
impl CreateClassifier {
    /// Creates a new builder-style object to manufacture [`CreateClassifierInput`](crate::input::CreateClassifierInput)
    pub fn builder() -> crate::input::create_classifier_input::Builder {
        crate::input::create_classifier_input::Builder::default()
    }
    /// Creates a new `CreateClassifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateClassifier {
    type Output = std::result::Result<
        crate::output::CreateClassifierOutput,
        crate::error::CreateClassifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_classifier_error(response)
        } else {
            crate::operation_deser::parse_create_classifier_response(response)
        }
    }
}

/// Operation shape for `CreateConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connection`](crate::client::Client::create_connection).
///
/// See [`crate::client::fluent_builders::CreateConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnection {
    _private: (),
}
impl CreateConnection {
    /// Creates a new builder-style object to manufacture [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    pub fn builder() -> crate::input::create_connection_input::Builder {
        crate::input::create_connection_input::Builder::default()
    }
    /// Creates a new `CreateConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnection {
    type Output = std::result::Result<
        crate::output::CreateConnectionOutput,
        crate::error::CreateConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connection_error(response)
        } else {
            crate::operation_deser::parse_create_connection_response(response)
        }
    }
}

/// Operation shape for `CreateCrawler`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_crawler`](crate::client::Client::create_crawler).
///
/// See [`crate::client::fluent_builders::CreateCrawler`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCrawler {
    _private: (),
}
impl CreateCrawler {
    /// Creates a new builder-style object to manufacture [`CreateCrawlerInput`](crate::input::CreateCrawlerInput)
    pub fn builder() -> crate::input::create_crawler_input::Builder {
        crate::input::create_crawler_input::Builder::default()
    }
    /// Creates a new `CreateCrawler` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCrawler {
    type Output =
        std::result::Result<crate::output::CreateCrawlerOutput, crate::error::CreateCrawlerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_crawler_error(response)
        } else {
            crate::operation_deser::parse_create_crawler_response(response)
        }
    }
}

/// Operation shape for `CreateDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_database`](crate::client::Client::create_database).
///
/// See [`crate::client::fluent_builders::CreateDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDatabase {
    _private: (),
}
impl CreateDatabase {
    /// Creates a new builder-style object to manufacture [`CreateDatabaseInput`](crate::input::CreateDatabaseInput)
    pub fn builder() -> crate::input::create_database_input::Builder {
        crate::input::create_database_input::Builder::default()
    }
    /// Creates a new `CreateDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDatabase {
    type Output =
        std::result::Result<crate::output::CreateDatabaseOutput, crate::error::CreateDatabaseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_database_error(response)
        } else {
            crate::operation_deser::parse_create_database_response(response)
        }
    }
}

/// Operation shape for `CreateDevEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dev_endpoint`](crate::client::Client::create_dev_endpoint).
///
/// See [`crate::client::fluent_builders::CreateDevEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDevEndpoint {
    _private: (),
}
impl CreateDevEndpoint {
    /// Creates a new builder-style object to manufacture [`CreateDevEndpointInput`](crate::input::CreateDevEndpointInput)
    pub fn builder() -> crate::input::create_dev_endpoint_input::Builder {
        crate::input::create_dev_endpoint_input::Builder::default()
    }
    /// Creates a new `CreateDevEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDevEndpoint {
    type Output = std::result::Result<
        crate::output::CreateDevEndpointOutput,
        crate::error::CreateDevEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dev_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_dev_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_job`](crate::client::Client::create_job).
///
/// See [`crate::client::fluent_builders::CreateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateJob {
    _private: (),
}
impl CreateJob {
    /// Creates a new builder-style object to manufacture [`CreateJobInput`](crate::input::CreateJobInput)
    pub fn builder() -> crate::input::create_job_input::Builder {
        crate::input::create_job_input::Builder::default()
    }
    /// Creates a new `CreateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateJob {
    type Output = std::result::Result<crate::output::CreateJobOutput, crate::error::CreateJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_job_error(response)
        } else {
            crate::operation_deser::parse_create_job_response(response)
        }
    }
}

/// Operation shape for `CreateMLTransform`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ml_transform`](crate::client::Client::create_ml_transform).
///
/// See [`crate::client::fluent_builders::CreateMLTransform`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMLTransform {
    _private: (),
}
impl CreateMLTransform {
    /// Creates a new builder-style object to manufacture [`CreateMlTransformInput`](crate::input::CreateMlTransformInput)
    pub fn builder() -> crate::input::create_ml_transform_input::Builder {
        crate::input::create_ml_transform_input::Builder::default()
    }
    /// Creates a new `CreateMLTransform` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMLTransform {
    type Output = std::result::Result<
        crate::output::CreateMlTransformOutput,
        crate::error::CreateMLTransformError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ml_transform_error(response)
        } else {
            crate::operation_deser::parse_create_ml_transform_response(response)
        }
    }
}

/// Operation shape for `CreatePartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_partition`](crate::client::Client::create_partition).
///
/// See [`crate::client::fluent_builders::CreatePartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePartition {
    _private: (),
}
impl CreatePartition {
    /// Creates a new builder-style object to manufacture [`CreatePartitionInput`](crate::input::CreatePartitionInput)
    pub fn builder() -> crate::input::create_partition_input::Builder {
        crate::input::create_partition_input::Builder::default()
    }
    /// Creates a new `CreatePartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePartition {
    type Output = std::result::Result<
        crate::output::CreatePartitionOutput,
        crate::error::CreatePartitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_partition_error(response)
        } else {
            crate::operation_deser::parse_create_partition_response(response)
        }
    }
}

/// Operation shape for `CreatePartitionIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_partition_index`](crate::client::Client::create_partition_index).
///
/// See [`crate::client::fluent_builders::CreatePartitionIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePartitionIndex {
    _private: (),
}
impl CreatePartitionIndex {
    /// Creates a new builder-style object to manufacture [`CreatePartitionIndexInput`](crate::input::CreatePartitionIndexInput)
    pub fn builder() -> crate::input::create_partition_index_input::Builder {
        crate::input::create_partition_index_input::Builder::default()
    }
    /// Creates a new `CreatePartitionIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePartitionIndex {
    type Output = std::result::Result<
        crate::output::CreatePartitionIndexOutput,
        crate::error::CreatePartitionIndexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_partition_index_error(response)
        } else {
            crate::operation_deser::parse_create_partition_index_response(response)
        }
    }
}

/// Operation shape for `CreateRegistry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_registry`](crate::client::Client::create_registry).
///
/// See [`crate::client::fluent_builders::CreateRegistry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRegistry {
    _private: (),
}
impl CreateRegistry {
    /// Creates a new builder-style object to manufacture [`CreateRegistryInput`](crate::input::CreateRegistryInput)
    pub fn builder() -> crate::input::create_registry_input::Builder {
        crate::input::create_registry_input::Builder::default()
    }
    /// Creates a new `CreateRegistry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRegistry {
    type Output =
        std::result::Result<crate::output::CreateRegistryOutput, crate::error::CreateRegistryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_registry_error(response)
        } else {
            crate::operation_deser::parse_create_registry_response(response)
        }
    }
}

/// Operation shape for `CreateSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_schema`](crate::client::Client::create_schema).
///
/// See [`crate::client::fluent_builders::CreateSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSchema {
    _private: (),
}
impl CreateSchema {
    /// Creates a new builder-style object to manufacture [`CreateSchemaInput`](crate::input::CreateSchemaInput)
    pub fn builder() -> crate::input::create_schema_input::Builder {
        crate::input::create_schema_input::Builder::default()
    }
    /// Creates a new `CreateSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSchema {
    type Output =
        std::result::Result<crate::output::CreateSchemaOutput, crate::error::CreateSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_schema_error(response)
        } else {
            crate::operation_deser::parse_create_schema_response(response)
        }
    }
}

/// Operation shape for `CreateScript`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_script`](crate::client::Client::create_script).
///
/// See [`crate::client::fluent_builders::CreateScript`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateScript {
    _private: (),
}
impl CreateScript {
    /// Creates a new builder-style object to manufacture [`CreateScriptInput`](crate::input::CreateScriptInput)
    pub fn builder() -> crate::input::create_script_input::Builder {
        crate::input::create_script_input::Builder::default()
    }
    /// Creates a new `CreateScript` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateScript {
    type Output =
        std::result::Result<crate::output::CreateScriptOutput, crate::error::CreateScriptError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_script_error(response)
        } else {
            crate::operation_deser::parse_create_script_response(response)
        }
    }
}

/// Operation shape for `CreateSecurityConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_security_configuration`](crate::client::Client::create_security_configuration).
///
/// See [`crate::client::fluent_builders::CreateSecurityConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSecurityConfiguration {
    _private: (),
}
impl CreateSecurityConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateSecurityConfigurationInput`](crate::input::CreateSecurityConfigurationInput)
    pub fn builder() -> crate::input::create_security_configuration_input::Builder {
        crate::input::create_security_configuration_input::Builder::default()
    }
    /// Creates a new `CreateSecurityConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSecurityConfiguration {
    type Output = std::result::Result<
        crate::output::CreateSecurityConfigurationOutput,
        crate::error::CreateSecurityConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_security_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_security_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_table`](crate::client::Client::create_table).
///
/// See [`crate::client::fluent_builders::CreateTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTable {
    _private: (),
}
impl CreateTable {
    /// Creates a new builder-style object to manufacture [`CreateTableInput`](crate::input::CreateTableInput)
    pub fn builder() -> crate::input::create_table_input::Builder {
        crate::input::create_table_input::Builder::default()
    }
    /// Creates a new `CreateTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTable {
    type Output =
        std::result::Result<crate::output::CreateTableOutput, crate::error::CreateTableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_table_error(response)
        } else {
            crate::operation_deser::parse_create_table_response(response)
        }
    }
}

/// Operation shape for `CreateTrigger`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_trigger`](crate::client::Client::create_trigger).
///
/// See [`crate::client::fluent_builders::CreateTrigger`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrigger {
    _private: (),
}
impl CreateTrigger {
    /// Creates a new builder-style object to manufacture [`CreateTriggerInput`](crate::input::CreateTriggerInput)
    pub fn builder() -> crate::input::create_trigger_input::Builder {
        crate::input::create_trigger_input::Builder::default()
    }
    /// Creates a new `CreateTrigger` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrigger {
    type Output =
        std::result::Result<crate::output::CreateTriggerOutput, crate::error::CreateTriggerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_trigger_error(response)
        } else {
            crate::operation_deser::parse_create_trigger_response(response)
        }
    }
}

/// Operation shape for `CreateUserDefinedFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user_defined_function`](crate::client::Client::create_user_defined_function).
///
/// See [`crate::client::fluent_builders::CreateUserDefinedFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUserDefinedFunction {
    _private: (),
}
impl CreateUserDefinedFunction {
    /// Creates a new builder-style object to manufacture [`CreateUserDefinedFunctionInput`](crate::input::CreateUserDefinedFunctionInput)
    pub fn builder() -> crate::input::create_user_defined_function_input::Builder {
        crate::input::create_user_defined_function_input::Builder::default()
    }
    /// Creates a new `CreateUserDefinedFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUserDefinedFunction {
    type Output = std::result::Result<
        crate::output::CreateUserDefinedFunctionOutput,
        crate::error::CreateUserDefinedFunctionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_defined_function_error(response)
        } else {
            crate::operation_deser::parse_create_user_defined_function_response(response)
        }
    }
}

/// Operation shape for `CreateWorkflow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_workflow`](crate::client::Client::create_workflow).
///
/// See [`crate::client::fluent_builders::CreateWorkflow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkflow {
    _private: (),
}
impl CreateWorkflow {
    /// Creates a new builder-style object to manufacture [`CreateWorkflowInput`](crate::input::CreateWorkflowInput)
    pub fn builder() -> crate::input::create_workflow_input::Builder {
        crate::input::create_workflow_input::Builder::default()
    }
    /// Creates a new `CreateWorkflow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkflow {
    type Output =
        std::result::Result<crate::output::CreateWorkflowOutput, crate::error::CreateWorkflowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_workflow_error(response)
        } else {
            crate::operation_deser::parse_create_workflow_response(response)
        }
    }
}

/// Operation shape for `DeleteBlueprint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_blueprint`](crate::client::Client::delete_blueprint).
///
/// See [`crate::client::fluent_builders::DeleteBlueprint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBlueprint {
    _private: (),
}
impl DeleteBlueprint {
    /// Creates a new builder-style object to manufacture [`DeleteBlueprintInput`](crate::input::DeleteBlueprintInput)
    pub fn builder() -> crate::input::delete_blueprint_input::Builder {
        crate::input::delete_blueprint_input::Builder::default()
    }
    /// Creates a new `DeleteBlueprint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBlueprint {
    type Output = std::result::Result<
        crate::output::DeleteBlueprintOutput,
        crate::error::DeleteBlueprintError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_blueprint_error(response)
        } else {
            crate::operation_deser::parse_delete_blueprint_response(response)
        }
    }
}

/// Operation shape for `DeleteClassifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_classifier`](crate::client::Client::delete_classifier).
///
/// See [`crate::client::fluent_builders::DeleteClassifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteClassifier {
    _private: (),
}
impl DeleteClassifier {
    /// Creates a new builder-style object to manufacture [`DeleteClassifierInput`](crate::input::DeleteClassifierInput)
    pub fn builder() -> crate::input::delete_classifier_input::Builder {
        crate::input::delete_classifier_input::Builder::default()
    }
    /// Creates a new `DeleteClassifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteClassifier {
    type Output = std::result::Result<
        crate::output::DeleteClassifierOutput,
        crate::error::DeleteClassifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_classifier_error(response)
        } else {
            crate::operation_deser::parse_delete_classifier_response(response)
        }
    }
}

/// Operation shape for `DeleteColumnStatisticsForPartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_column_statistics_for_partition`](crate::client::Client::delete_column_statistics_for_partition).
///
/// See [`crate::client::fluent_builders::DeleteColumnStatisticsForPartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteColumnStatisticsForPartition {
    _private: (),
}
impl DeleteColumnStatisticsForPartition {
    /// Creates a new builder-style object to manufacture [`DeleteColumnStatisticsForPartitionInput`](crate::input::DeleteColumnStatisticsForPartitionInput)
    pub fn builder() -> crate::input::delete_column_statistics_for_partition_input::Builder {
        crate::input::delete_column_statistics_for_partition_input::Builder::default()
    }
    /// Creates a new `DeleteColumnStatisticsForPartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteColumnStatisticsForPartition {
    type Output = std::result::Result<
        crate::output::DeleteColumnStatisticsForPartitionOutput,
        crate::error::DeleteColumnStatisticsForPartitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_column_statistics_for_partition_error(response)
        } else {
            crate::operation_deser::parse_delete_column_statistics_for_partition_response(response)
        }
    }
}

/// Operation shape for `DeleteColumnStatisticsForTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_column_statistics_for_table`](crate::client::Client::delete_column_statistics_for_table).
///
/// See [`crate::client::fluent_builders::DeleteColumnStatisticsForTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteColumnStatisticsForTable {
    _private: (),
}
impl DeleteColumnStatisticsForTable {
    /// Creates a new builder-style object to manufacture [`DeleteColumnStatisticsForTableInput`](crate::input::DeleteColumnStatisticsForTableInput)
    pub fn builder() -> crate::input::delete_column_statistics_for_table_input::Builder {
        crate::input::delete_column_statistics_for_table_input::Builder::default()
    }
    /// Creates a new `DeleteColumnStatisticsForTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteColumnStatisticsForTable {
    type Output = std::result::Result<
        crate::output::DeleteColumnStatisticsForTableOutput,
        crate::error::DeleteColumnStatisticsForTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_column_statistics_for_table_error(response)
        } else {
            crate::operation_deser::parse_delete_column_statistics_for_table_response(response)
        }
    }
}

/// Operation shape for `DeleteConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connection`](crate::client::Client::delete_connection).
///
/// See [`crate::client::fluent_builders::DeleteConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnection {
    _private: (),
}
impl DeleteConnection {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
    /// Creates a new `DeleteConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnection {
    type Output = std::result::Result<
        crate::output::DeleteConnectionOutput,
        crate::error::DeleteConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteCrawler`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_crawler`](crate::client::Client::delete_crawler).
///
/// See [`crate::client::fluent_builders::DeleteCrawler`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCrawler {
    _private: (),
}
impl DeleteCrawler {
    /// Creates a new builder-style object to manufacture [`DeleteCrawlerInput`](crate::input::DeleteCrawlerInput)
    pub fn builder() -> crate::input::delete_crawler_input::Builder {
        crate::input::delete_crawler_input::Builder::default()
    }
    /// Creates a new `DeleteCrawler` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCrawler {
    type Output =
        std::result::Result<crate::output::DeleteCrawlerOutput, crate::error::DeleteCrawlerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_crawler_error(response)
        } else {
            crate::operation_deser::parse_delete_crawler_response(response)
        }
    }
}

/// Operation shape for `DeleteDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_database`](crate::client::Client::delete_database).
///
/// See [`crate::client::fluent_builders::DeleteDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDatabase {
    _private: (),
}
impl DeleteDatabase {
    /// Creates a new builder-style object to manufacture [`DeleteDatabaseInput`](crate::input::DeleteDatabaseInput)
    pub fn builder() -> crate::input::delete_database_input::Builder {
        crate::input::delete_database_input::Builder::default()
    }
    /// Creates a new `DeleteDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDatabase {
    type Output =
        std::result::Result<crate::output::DeleteDatabaseOutput, crate::error::DeleteDatabaseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_database_error(response)
        } else {
            crate::operation_deser::parse_delete_database_response(response)
        }
    }
}

/// Operation shape for `DeleteDevEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dev_endpoint`](crate::client::Client::delete_dev_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteDevEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDevEndpoint {
    _private: (),
}
impl DeleteDevEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteDevEndpointInput`](crate::input::DeleteDevEndpointInput)
    pub fn builder() -> crate::input::delete_dev_endpoint_input::Builder {
        crate::input::delete_dev_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteDevEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDevEndpoint {
    type Output = std::result::Result<
        crate::output::DeleteDevEndpointOutput,
        crate::error::DeleteDevEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dev_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_dev_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeleteJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_job`](crate::client::Client::delete_job).
///
/// See [`crate::client::fluent_builders::DeleteJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteJob {
    _private: (),
}
impl DeleteJob {
    /// Creates a new builder-style object to manufacture [`DeleteJobInput`](crate::input::DeleteJobInput)
    pub fn builder() -> crate::input::delete_job_input::Builder {
        crate::input::delete_job_input::Builder::default()
    }
    /// Creates a new `DeleteJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteJob {
    type Output = std::result::Result<crate::output::DeleteJobOutput, crate::error::DeleteJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_job_error(response)
        } else {
            crate::operation_deser::parse_delete_job_response(response)
        }
    }
}

/// Operation shape for `DeleteMLTransform`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ml_transform`](crate::client::Client::delete_ml_transform).
///
/// See [`crate::client::fluent_builders::DeleteMLTransform`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMLTransform {
    _private: (),
}
impl DeleteMLTransform {
    /// Creates a new builder-style object to manufacture [`DeleteMlTransformInput`](crate::input::DeleteMlTransformInput)
    pub fn builder() -> crate::input::delete_ml_transform_input::Builder {
        crate::input::delete_ml_transform_input::Builder::default()
    }
    /// Creates a new `DeleteMLTransform` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMLTransform {
    type Output = std::result::Result<
        crate::output::DeleteMlTransformOutput,
        crate::error::DeleteMLTransformError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ml_transform_error(response)
        } else {
            crate::operation_deser::parse_delete_ml_transform_response(response)
        }
    }
}

/// Operation shape for `DeletePartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_partition`](crate::client::Client::delete_partition).
///
/// See [`crate::client::fluent_builders::DeletePartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePartition {
    _private: (),
}
impl DeletePartition {
    /// Creates a new builder-style object to manufacture [`DeletePartitionInput`](crate::input::DeletePartitionInput)
    pub fn builder() -> crate::input::delete_partition_input::Builder {
        crate::input::delete_partition_input::Builder::default()
    }
    /// Creates a new `DeletePartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePartition {
    type Output = std::result::Result<
        crate::output::DeletePartitionOutput,
        crate::error::DeletePartitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_partition_error(response)
        } else {
            crate::operation_deser::parse_delete_partition_response(response)
        }
    }
}

/// Operation shape for `DeletePartitionIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_partition_index`](crate::client::Client::delete_partition_index).
///
/// See [`crate::client::fluent_builders::DeletePartitionIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePartitionIndex {
    _private: (),
}
impl DeletePartitionIndex {
    /// Creates a new builder-style object to manufacture [`DeletePartitionIndexInput`](crate::input::DeletePartitionIndexInput)
    pub fn builder() -> crate::input::delete_partition_index_input::Builder {
        crate::input::delete_partition_index_input::Builder::default()
    }
    /// Creates a new `DeletePartitionIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePartitionIndex {
    type Output = std::result::Result<
        crate::output::DeletePartitionIndexOutput,
        crate::error::DeletePartitionIndexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_partition_index_error(response)
        } else {
            crate::operation_deser::parse_delete_partition_index_response(response)
        }
    }
}

/// Operation shape for `DeleteRegistry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_registry`](crate::client::Client::delete_registry).
///
/// See [`crate::client::fluent_builders::DeleteRegistry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRegistry {
    _private: (),
}
impl DeleteRegistry {
    /// Creates a new builder-style object to manufacture [`DeleteRegistryInput`](crate::input::DeleteRegistryInput)
    pub fn builder() -> crate::input::delete_registry_input::Builder {
        crate::input::delete_registry_input::Builder::default()
    }
    /// Creates a new `DeleteRegistry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRegistry {
    type Output =
        std::result::Result<crate::output::DeleteRegistryOutput, crate::error::DeleteRegistryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_registry_error(response)
        } else {
            crate::operation_deser::parse_delete_registry_response(response)
        }
    }
}

/// Operation shape for `DeleteResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_policy`](crate::client::Client::delete_resource_policy).
///
/// See [`crate::client::fluent_builders::DeleteResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourcePolicy {
    _private: (),
}
impl DeleteResourcePolicy {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
    /// Creates a new `DeleteResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourcePolicy {
    type Output = std::result::Result<
        crate::output::DeleteResourcePolicyOutput,
        crate::error::DeleteResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_schema`](crate::client::Client::delete_schema).
///
/// See [`crate::client::fluent_builders::DeleteSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSchema {
    _private: (),
}
impl DeleteSchema {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaInput`](crate::input::DeleteSchemaInput)
    pub fn builder() -> crate::input::delete_schema_input::Builder {
        crate::input::delete_schema_input::Builder::default()
    }
    /// Creates a new `DeleteSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSchema {
    type Output =
        std::result::Result<crate::output::DeleteSchemaOutput, crate::error::DeleteSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_schema_error(response)
        } else {
            crate::operation_deser::parse_delete_schema_response(response)
        }
    }
}

/// Operation shape for `DeleteSchemaVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_schema_versions`](crate::client::Client::delete_schema_versions).
///
/// See [`crate::client::fluent_builders::DeleteSchemaVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSchemaVersions {
    _private: (),
}
impl DeleteSchemaVersions {
    /// Creates a new builder-style object to manufacture [`DeleteSchemaVersionsInput`](crate::input::DeleteSchemaVersionsInput)
    pub fn builder() -> crate::input::delete_schema_versions_input::Builder {
        crate::input::delete_schema_versions_input::Builder::default()
    }
    /// Creates a new `DeleteSchemaVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSchemaVersions {
    type Output = std::result::Result<
        crate::output::DeleteSchemaVersionsOutput,
        crate::error::DeleteSchemaVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_schema_versions_error(response)
        } else {
            crate::operation_deser::parse_delete_schema_versions_response(response)
        }
    }
}

/// Operation shape for `DeleteSecurityConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_security_configuration`](crate::client::Client::delete_security_configuration).
///
/// See [`crate::client::fluent_builders::DeleteSecurityConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSecurityConfiguration {
    _private: (),
}
impl DeleteSecurityConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteSecurityConfigurationInput`](crate::input::DeleteSecurityConfigurationInput)
    pub fn builder() -> crate::input::delete_security_configuration_input::Builder {
        crate::input::delete_security_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteSecurityConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSecurityConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteSecurityConfigurationOutput,
        crate::error::DeleteSecurityConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_security_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_security_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_table`](crate::client::Client::delete_table).
///
/// See [`crate::client::fluent_builders::DeleteTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTable {
    _private: (),
}
impl DeleteTable {
    /// Creates a new builder-style object to manufacture [`DeleteTableInput`](crate::input::DeleteTableInput)
    pub fn builder() -> crate::input::delete_table_input::Builder {
        crate::input::delete_table_input::Builder::default()
    }
    /// Creates a new `DeleteTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTable {
    type Output =
        std::result::Result<crate::output::DeleteTableOutput, crate::error::DeleteTableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_table_error(response)
        } else {
            crate::operation_deser::parse_delete_table_response(response)
        }
    }
}

/// Operation shape for `DeleteTableVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_table_version`](crate::client::Client::delete_table_version).
///
/// See [`crate::client::fluent_builders::DeleteTableVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTableVersion {
    _private: (),
}
impl DeleteTableVersion {
    /// Creates a new builder-style object to manufacture [`DeleteTableVersionInput`](crate::input::DeleteTableVersionInput)
    pub fn builder() -> crate::input::delete_table_version_input::Builder {
        crate::input::delete_table_version_input::Builder::default()
    }
    /// Creates a new `DeleteTableVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTableVersion {
    type Output = std::result::Result<
        crate::output::DeleteTableVersionOutput,
        crate::error::DeleteTableVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_table_version_error(response)
        } else {
            crate::operation_deser::parse_delete_table_version_response(response)
        }
    }
}

/// Operation shape for `DeleteTrigger`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_trigger`](crate::client::Client::delete_trigger).
///
/// See [`crate::client::fluent_builders::DeleteTrigger`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrigger {
    _private: (),
}
impl DeleteTrigger {
    /// Creates a new builder-style object to manufacture [`DeleteTriggerInput`](crate::input::DeleteTriggerInput)
    pub fn builder() -> crate::input::delete_trigger_input::Builder {
        crate::input::delete_trigger_input::Builder::default()
    }
    /// Creates a new `DeleteTrigger` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrigger {
    type Output =
        std::result::Result<crate::output::DeleteTriggerOutput, crate::error::DeleteTriggerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_trigger_error(response)
        } else {
            crate::operation_deser::parse_delete_trigger_response(response)
        }
    }
}

/// Operation shape for `DeleteUserDefinedFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_defined_function`](crate::client::Client::delete_user_defined_function).
///
/// See [`crate::client::fluent_builders::DeleteUserDefinedFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserDefinedFunction {
    _private: (),
}
impl DeleteUserDefinedFunction {
    /// Creates a new builder-style object to manufacture [`DeleteUserDefinedFunctionInput`](crate::input::DeleteUserDefinedFunctionInput)
    pub fn builder() -> crate::input::delete_user_defined_function_input::Builder {
        crate::input::delete_user_defined_function_input::Builder::default()
    }
    /// Creates a new `DeleteUserDefinedFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserDefinedFunction {
    type Output = std::result::Result<
        crate::output::DeleteUserDefinedFunctionOutput,
        crate::error::DeleteUserDefinedFunctionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_defined_function_error(response)
        } else {
            crate::operation_deser::parse_delete_user_defined_function_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkflow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_workflow`](crate::client::Client::delete_workflow).
///
/// See [`crate::client::fluent_builders::DeleteWorkflow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkflow {
    _private: (),
}
impl DeleteWorkflow {
    /// Creates a new builder-style object to manufacture [`DeleteWorkflowInput`](crate::input::DeleteWorkflowInput)
    pub fn builder() -> crate::input::delete_workflow_input::Builder {
        crate::input::delete_workflow_input::Builder::default()
    }
    /// Creates a new `DeleteWorkflow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkflow {
    type Output =
        std::result::Result<crate::output::DeleteWorkflowOutput, crate::error::DeleteWorkflowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_workflow_error(response)
        } else {
            crate::operation_deser::parse_delete_workflow_response(response)
        }
    }
}

/// Operation shape for `GetBlueprint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_blueprint`](crate::client::Client::get_blueprint).
///
/// See [`crate::client::fluent_builders::GetBlueprint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBlueprint {
    _private: (),
}
impl GetBlueprint {
    /// Creates a new builder-style object to manufacture [`GetBlueprintInput`](crate::input::GetBlueprintInput)
    pub fn builder() -> crate::input::get_blueprint_input::Builder {
        crate::input::get_blueprint_input::Builder::default()
    }
    /// Creates a new `GetBlueprint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBlueprint {
    type Output =
        std::result::Result<crate::output::GetBlueprintOutput, crate::error::GetBlueprintError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_blueprint_error(response)
        } else {
            crate::operation_deser::parse_get_blueprint_response(response)
        }
    }
}

/// Operation shape for `GetBlueprintRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_blueprint_run`](crate::client::Client::get_blueprint_run).
///
/// See [`crate::client::fluent_builders::GetBlueprintRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBlueprintRun {
    _private: (),
}
impl GetBlueprintRun {
    /// Creates a new builder-style object to manufacture [`GetBlueprintRunInput`](crate::input::GetBlueprintRunInput)
    pub fn builder() -> crate::input::get_blueprint_run_input::Builder {
        crate::input::get_blueprint_run_input::Builder::default()
    }
    /// Creates a new `GetBlueprintRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBlueprintRun {
    type Output = std::result::Result<
        crate::output::GetBlueprintRunOutput,
        crate::error::GetBlueprintRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_blueprint_run_error(response)
        } else {
            crate::operation_deser::parse_get_blueprint_run_response(response)
        }
    }
}

/// Operation shape for `GetBlueprintRuns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_blueprint_runs`](crate::client::Client::get_blueprint_runs).
///
/// See [`crate::client::fluent_builders::GetBlueprintRuns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBlueprintRuns {
    _private: (),
}
impl GetBlueprintRuns {
    /// Creates a new builder-style object to manufacture [`GetBlueprintRunsInput`](crate::input::GetBlueprintRunsInput)
    pub fn builder() -> crate::input::get_blueprint_runs_input::Builder {
        crate::input::get_blueprint_runs_input::Builder::default()
    }
    /// Creates a new `GetBlueprintRuns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBlueprintRuns {
    type Output = std::result::Result<
        crate::output::GetBlueprintRunsOutput,
        crate::error::GetBlueprintRunsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_blueprint_runs_error(response)
        } else {
            crate::operation_deser::parse_get_blueprint_runs_response(response)
        }
    }
}

/// Operation shape for `GetCatalogImportStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_catalog_import_status`](crate::client::Client::get_catalog_import_status).
///
/// See [`crate::client::fluent_builders::GetCatalogImportStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCatalogImportStatus {
    _private: (),
}
impl GetCatalogImportStatus {
    /// Creates a new builder-style object to manufacture [`GetCatalogImportStatusInput`](crate::input::GetCatalogImportStatusInput)
    pub fn builder() -> crate::input::get_catalog_import_status_input::Builder {
        crate::input::get_catalog_import_status_input::Builder::default()
    }
    /// Creates a new `GetCatalogImportStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCatalogImportStatus {
    type Output = std::result::Result<
        crate::output::GetCatalogImportStatusOutput,
        crate::error::GetCatalogImportStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_catalog_import_status_error(response)
        } else {
            crate::operation_deser::parse_get_catalog_import_status_response(response)
        }
    }
}

/// Operation shape for `GetClassifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_classifier`](crate::client::Client::get_classifier).
///
/// See [`crate::client::fluent_builders::GetClassifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetClassifier {
    _private: (),
}
impl GetClassifier {
    /// Creates a new builder-style object to manufacture [`GetClassifierInput`](crate::input::GetClassifierInput)
    pub fn builder() -> crate::input::get_classifier_input::Builder {
        crate::input::get_classifier_input::Builder::default()
    }
    /// Creates a new `GetClassifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetClassifier {
    type Output =
        std::result::Result<crate::output::GetClassifierOutput, crate::error::GetClassifierError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_classifier_error(response)
        } else {
            crate::operation_deser::parse_get_classifier_response(response)
        }
    }
}

/// Operation shape for `GetClassifiers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_classifiers`](crate::client::Client::get_classifiers).
///
/// See [`crate::client::fluent_builders::GetClassifiers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetClassifiers {
    _private: (),
}
impl GetClassifiers {
    /// Creates a new builder-style object to manufacture [`GetClassifiersInput`](crate::input::GetClassifiersInput)
    pub fn builder() -> crate::input::get_classifiers_input::Builder {
        crate::input::get_classifiers_input::Builder::default()
    }
    /// Creates a new `GetClassifiers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetClassifiers {
    type Output =
        std::result::Result<crate::output::GetClassifiersOutput, crate::error::GetClassifiersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_classifiers_error(response)
        } else {
            crate::operation_deser::parse_get_classifiers_response(response)
        }
    }
}

/// Operation shape for `GetColumnStatisticsForPartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_column_statistics_for_partition`](crate::client::Client::get_column_statistics_for_partition).
///
/// See [`crate::client::fluent_builders::GetColumnStatisticsForPartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetColumnStatisticsForPartition {
    _private: (),
}
impl GetColumnStatisticsForPartition {
    /// Creates a new builder-style object to manufacture [`GetColumnStatisticsForPartitionInput`](crate::input::GetColumnStatisticsForPartitionInput)
    pub fn builder() -> crate::input::get_column_statistics_for_partition_input::Builder {
        crate::input::get_column_statistics_for_partition_input::Builder::default()
    }
    /// Creates a new `GetColumnStatisticsForPartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetColumnStatisticsForPartition {
    type Output = std::result::Result<
        crate::output::GetColumnStatisticsForPartitionOutput,
        crate::error::GetColumnStatisticsForPartitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_column_statistics_for_partition_error(response)
        } else {
            crate::operation_deser::parse_get_column_statistics_for_partition_response(response)
        }
    }
}

/// Operation shape for `GetColumnStatisticsForTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_column_statistics_for_table`](crate::client::Client::get_column_statistics_for_table).
///
/// See [`crate::client::fluent_builders::GetColumnStatisticsForTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetColumnStatisticsForTable {
    _private: (),
}
impl GetColumnStatisticsForTable {
    /// Creates a new builder-style object to manufacture [`GetColumnStatisticsForTableInput`](crate::input::GetColumnStatisticsForTableInput)
    pub fn builder() -> crate::input::get_column_statistics_for_table_input::Builder {
        crate::input::get_column_statistics_for_table_input::Builder::default()
    }
    /// Creates a new `GetColumnStatisticsForTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetColumnStatisticsForTable {
    type Output = std::result::Result<
        crate::output::GetColumnStatisticsForTableOutput,
        crate::error::GetColumnStatisticsForTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_column_statistics_for_table_error(response)
        } else {
            crate::operation_deser::parse_get_column_statistics_for_table_response(response)
        }
    }
}

/// Operation shape for `GetConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connection`](crate::client::Client::get_connection).
///
/// See [`crate::client::fluent_builders::GetConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnection {
    _private: (),
}
impl GetConnection {
    /// Creates a new builder-style object to manufacture [`GetConnectionInput`](crate::input::GetConnectionInput)
    pub fn builder() -> crate::input::get_connection_input::Builder {
        crate::input::get_connection_input::Builder::default()
    }
    /// Creates a new `GetConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnection {
    type Output =
        std::result::Result<crate::output::GetConnectionOutput, crate::error::GetConnectionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connection_error(response)
        } else {
            crate::operation_deser::parse_get_connection_response(response)
        }
    }
}

/// Operation shape for `GetConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_connections`](crate::client::Client::get_connections).
///
/// See [`crate::client::fluent_builders::GetConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetConnections {
    _private: (),
}
impl GetConnections {
    /// Creates a new builder-style object to manufacture [`GetConnectionsInput`](crate::input::GetConnectionsInput)
    pub fn builder() -> crate::input::get_connections_input::Builder {
        crate::input::get_connections_input::Builder::default()
    }
    /// Creates a new `GetConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetConnections {
    type Output =
        std::result::Result<crate::output::GetConnectionsOutput, crate::error::GetConnectionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_connections_error(response)
        } else {
            crate::operation_deser::parse_get_connections_response(response)
        }
    }
}

/// Operation shape for `GetCrawler`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_crawler`](crate::client::Client::get_crawler).
///
/// See [`crate::client::fluent_builders::GetCrawler`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCrawler {
    _private: (),
}
impl GetCrawler {
    /// Creates a new builder-style object to manufacture [`GetCrawlerInput`](crate::input::GetCrawlerInput)
    pub fn builder() -> crate::input::get_crawler_input::Builder {
        crate::input::get_crawler_input::Builder::default()
    }
    /// Creates a new `GetCrawler` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCrawler {
    type Output =
        std::result::Result<crate::output::GetCrawlerOutput, crate::error::GetCrawlerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_crawler_error(response)
        } else {
            crate::operation_deser::parse_get_crawler_response(response)
        }
    }
}

/// Operation shape for `GetCrawlerMetrics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_crawler_metrics`](crate::client::Client::get_crawler_metrics).
///
/// See [`crate::client::fluent_builders::GetCrawlerMetrics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCrawlerMetrics {
    _private: (),
}
impl GetCrawlerMetrics {
    /// Creates a new builder-style object to manufacture [`GetCrawlerMetricsInput`](crate::input::GetCrawlerMetricsInput)
    pub fn builder() -> crate::input::get_crawler_metrics_input::Builder {
        crate::input::get_crawler_metrics_input::Builder::default()
    }
    /// Creates a new `GetCrawlerMetrics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCrawlerMetrics {
    type Output = std::result::Result<
        crate::output::GetCrawlerMetricsOutput,
        crate::error::GetCrawlerMetricsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_crawler_metrics_error(response)
        } else {
            crate::operation_deser::parse_get_crawler_metrics_response(response)
        }
    }
}

/// Operation shape for `GetCrawlers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_crawlers`](crate::client::Client::get_crawlers).
///
/// See [`crate::client::fluent_builders::GetCrawlers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCrawlers {
    _private: (),
}
impl GetCrawlers {
    /// Creates a new builder-style object to manufacture [`GetCrawlersInput`](crate::input::GetCrawlersInput)
    pub fn builder() -> crate::input::get_crawlers_input::Builder {
        crate::input::get_crawlers_input::Builder::default()
    }
    /// Creates a new `GetCrawlers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCrawlers {
    type Output =
        std::result::Result<crate::output::GetCrawlersOutput, crate::error::GetCrawlersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_crawlers_error(response)
        } else {
            crate::operation_deser::parse_get_crawlers_response(response)
        }
    }
}

/// Operation shape for `GetDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_database`](crate::client::Client::get_database).
///
/// See [`crate::client::fluent_builders::GetDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDatabase {
    _private: (),
}
impl GetDatabase {
    /// Creates a new builder-style object to manufacture [`GetDatabaseInput`](crate::input::GetDatabaseInput)
    pub fn builder() -> crate::input::get_database_input::Builder {
        crate::input::get_database_input::Builder::default()
    }
    /// Creates a new `GetDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDatabase {
    type Output =
        std::result::Result<crate::output::GetDatabaseOutput, crate::error::GetDatabaseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_database_error(response)
        } else {
            crate::operation_deser::parse_get_database_response(response)
        }
    }
}

/// Operation shape for `GetDatabases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_databases`](crate::client::Client::get_databases).
///
/// See [`crate::client::fluent_builders::GetDatabases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDatabases {
    _private: (),
}
impl GetDatabases {
    /// Creates a new builder-style object to manufacture [`GetDatabasesInput`](crate::input::GetDatabasesInput)
    pub fn builder() -> crate::input::get_databases_input::Builder {
        crate::input::get_databases_input::Builder::default()
    }
    /// Creates a new `GetDatabases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDatabases {
    type Output =
        std::result::Result<crate::output::GetDatabasesOutput, crate::error::GetDatabasesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_databases_error(response)
        } else {
            crate::operation_deser::parse_get_databases_response(response)
        }
    }
}

/// Operation shape for `GetDataCatalogEncryptionSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_data_catalog_encryption_settings`](crate::client::Client::get_data_catalog_encryption_settings).
///
/// See [`crate::client::fluent_builders::GetDataCatalogEncryptionSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDataCatalogEncryptionSettings {
    _private: (),
}
impl GetDataCatalogEncryptionSettings {
    /// Creates a new builder-style object to manufacture [`GetDataCatalogEncryptionSettingsInput`](crate::input::GetDataCatalogEncryptionSettingsInput)
    pub fn builder() -> crate::input::get_data_catalog_encryption_settings_input::Builder {
        crate::input::get_data_catalog_encryption_settings_input::Builder::default()
    }
    /// Creates a new `GetDataCatalogEncryptionSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDataCatalogEncryptionSettings {
    type Output = std::result::Result<
        crate::output::GetDataCatalogEncryptionSettingsOutput,
        crate::error::GetDataCatalogEncryptionSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_data_catalog_encryption_settings_error(response)
        } else {
            crate::operation_deser::parse_get_data_catalog_encryption_settings_response(response)
        }
    }
}

/// Operation shape for `GetDataflowGraph`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dataflow_graph`](crate::client::Client::get_dataflow_graph).
///
/// See [`crate::client::fluent_builders::GetDataflowGraph`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDataflowGraph {
    _private: (),
}
impl GetDataflowGraph {
    /// Creates a new builder-style object to manufacture [`GetDataflowGraphInput`](crate::input::GetDataflowGraphInput)
    pub fn builder() -> crate::input::get_dataflow_graph_input::Builder {
        crate::input::get_dataflow_graph_input::Builder::default()
    }
    /// Creates a new `GetDataflowGraph` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDataflowGraph {
    type Output = std::result::Result<
        crate::output::GetDataflowGraphOutput,
        crate::error::GetDataflowGraphError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dataflow_graph_error(response)
        } else {
            crate::operation_deser::parse_get_dataflow_graph_response(response)
        }
    }
}

/// Operation shape for `GetDevEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dev_endpoint`](crate::client::Client::get_dev_endpoint).
///
/// See [`crate::client::fluent_builders::GetDevEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevEndpoint {
    _private: (),
}
impl GetDevEndpoint {
    /// Creates a new builder-style object to manufacture [`GetDevEndpointInput`](crate::input::GetDevEndpointInput)
    pub fn builder() -> crate::input::get_dev_endpoint_input::Builder {
        crate::input::get_dev_endpoint_input::Builder::default()
    }
    /// Creates a new `GetDevEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevEndpoint {
    type Output =
        std::result::Result<crate::output::GetDevEndpointOutput, crate::error::GetDevEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dev_endpoint_error(response)
        } else {
            crate::operation_deser::parse_get_dev_endpoint_response(response)
        }
    }
}

/// Operation shape for `GetDevEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dev_endpoints`](crate::client::Client::get_dev_endpoints).
///
/// See [`crate::client::fluent_builders::GetDevEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevEndpoints {
    _private: (),
}
impl GetDevEndpoints {
    /// Creates a new builder-style object to manufacture [`GetDevEndpointsInput`](crate::input::GetDevEndpointsInput)
    pub fn builder() -> crate::input::get_dev_endpoints_input::Builder {
        crate::input::get_dev_endpoints_input::Builder::default()
    }
    /// Creates a new `GetDevEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevEndpoints {
    type Output = std::result::Result<
        crate::output::GetDevEndpointsOutput,
        crate::error::GetDevEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dev_endpoints_error(response)
        } else {
            crate::operation_deser::parse_get_dev_endpoints_response(response)
        }
    }
}

/// Operation shape for `GetJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job`](crate::client::Client::get_job).
///
/// See [`crate::client::fluent_builders::GetJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJob {
    _private: (),
}
impl GetJob {
    /// Creates a new builder-style object to manufacture [`GetJobInput`](crate::input::GetJobInput)
    pub fn builder() -> crate::input::get_job_input::Builder {
        crate::input::get_job_input::Builder::default()
    }
    /// Creates a new `GetJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJob {
    type Output = std::result::Result<crate::output::GetJobOutput, crate::error::GetJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_error(response)
        } else {
            crate::operation_deser::parse_get_job_response(response)
        }
    }
}

/// Operation shape for `GetJobBookmark`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job_bookmark`](crate::client::Client::get_job_bookmark).
///
/// See [`crate::client::fluent_builders::GetJobBookmark`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJobBookmark {
    _private: (),
}
impl GetJobBookmark {
    /// Creates a new builder-style object to manufacture [`GetJobBookmarkInput`](crate::input::GetJobBookmarkInput)
    pub fn builder() -> crate::input::get_job_bookmark_input::Builder {
        crate::input::get_job_bookmark_input::Builder::default()
    }
    /// Creates a new `GetJobBookmark` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJobBookmark {
    type Output =
        std::result::Result<crate::output::GetJobBookmarkOutput, crate::error::GetJobBookmarkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_bookmark_error(response)
        } else {
            crate::operation_deser::parse_get_job_bookmark_response(response)
        }
    }
}

/// Operation shape for `GetJobRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job_run`](crate::client::Client::get_job_run).
///
/// See [`crate::client::fluent_builders::GetJobRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJobRun {
    _private: (),
}
impl GetJobRun {
    /// Creates a new builder-style object to manufacture [`GetJobRunInput`](crate::input::GetJobRunInput)
    pub fn builder() -> crate::input::get_job_run_input::Builder {
        crate::input::get_job_run_input::Builder::default()
    }
    /// Creates a new `GetJobRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJobRun {
    type Output = std::result::Result<crate::output::GetJobRunOutput, crate::error::GetJobRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_run_error(response)
        } else {
            crate::operation_deser::parse_get_job_run_response(response)
        }
    }
}

/// Operation shape for `GetJobRuns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job_runs`](crate::client::Client::get_job_runs).
///
/// See [`crate::client::fluent_builders::GetJobRuns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJobRuns {
    _private: (),
}
impl GetJobRuns {
    /// Creates a new builder-style object to manufacture [`GetJobRunsInput`](crate::input::GetJobRunsInput)
    pub fn builder() -> crate::input::get_job_runs_input::Builder {
        crate::input::get_job_runs_input::Builder::default()
    }
    /// Creates a new `GetJobRuns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJobRuns {
    type Output =
        std::result::Result<crate::output::GetJobRunsOutput, crate::error::GetJobRunsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_runs_error(response)
        } else {
            crate::operation_deser::parse_get_job_runs_response(response)
        }
    }
}

/// Operation shape for `GetJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_jobs`](crate::client::Client::get_jobs).
///
/// See [`crate::client::fluent_builders::GetJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJobs {
    _private: (),
}
impl GetJobs {
    /// Creates a new builder-style object to manufacture [`GetJobsInput`](crate::input::GetJobsInput)
    pub fn builder() -> crate::input::get_jobs_input::Builder {
        crate::input::get_jobs_input::Builder::default()
    }
    /// Creates a new `GetJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJobs {
    type Output = std::result::Result<crate::output::GetJobsOutput, crate::error::GetJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_jobs_error(response)
        } else {
            crate::operation_deser::parse_get_jobs_response(response)
        }
    }
}

/// Operation shape for `GetMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_mapping`](crate::client::Client::get_mapping).
///
/// See [`crate::client::fluent_builders::GetMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMapping {
    _private: (),
}
impl GetMapping {
    /// Creates a new builder-style object to manufacture [`GetMappingInput`](crate::input::GetMappingInput)
    pub fn builder() -> crate::input::get_mapping_input::Builder {
        crate::input::get_mapping_input::Builder::default()
    }
    /// Creates a new `GetMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMapping {
    type Output =
        std::result::Result<crate::output::GetMappingOutput, crate::error::GetMappingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_mapping_error(response)
        } else {
            crate::operation_deser::parse_get_mapping_response(response)
        }
    }
}

/// Operation shape for `GetMLTaskRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ml_task_run`](crate::client::Client::get_ml_task_run).
///
/// See [`crate::client::fluent_builders::GetMLTaskRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMLTaskRun {
    _private: (),
}
impl GetMLTaskRun {
    /// Creates a new builder-style object to manufacture [`GetMlTaskRunInput`](crate::input::GetMlTaskRunInput)
    pub fn builder() -> crate::input::get_ml_task_run_input::Builder {
        crate::input::get_ml_task_run_input::Builder::default()
    }
    /// Creates a new `GetMLTaskRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMLTaskRun {
    type Output =
        std::result::Result<crate::output::GetMlTaskRunOutput, crate::error::GetMLTaskRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ml_task_run_error(response)
        } else {
            crate::operation_deser::parse_get_ml_task_run_response(response)
        }
    }
}

/// Operation shape for `GetMLTaskRuns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ml_task_runs`](crate::client::Client::get_ml_task_runs).
///
/// See [`crate::client::fluent_builders::GetMLTaskRuns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMLTaskRuns {
    _private: (),
}
impl GetMLTaskRuns {
    /// Creates a new builder-style object to manufacture [`GetMlTaskRunsInput`](crate::input::GetMlTaskRunsInput)
    pub fn builder() -> crate::input::get_ml_task_runs_input::Builder {
        crate::input::get_ml_task_runs_input::Builder::default()
    }
    /// Creates a new `GetMLTaskRuns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMLTaskRuns {
    type Output =
        std::result::Result<crate::output::GetMlTaskRunsOutput, crate::error::GetMLTaskRunsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ml_task_runs_error(response)
        } else {
            crate::operation_deser::parse_get_ml_task_runs_response(response)
        }
    }
}

/// Operation shape for `GetMLTransform`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ml_transform`](crate::client::Client::get_ml_transform).
///
/// See [`crate::client::fluent_builders::GetMLTransform`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMLTransform {
    _private: (),
}
impl GetMLTransform {
    /// Creates a new builder-style object to manufacture [`GetMlTransformInput`](crate::input::GetMlTransformInput)
    pub fn builder() -> crate::input::get_ml_transform_input::Builder {
        crate::input::get_ml_transform_input::Builder::default()
    }
    /// Creates a new `GetMLTransform` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMLTransform {
    type Output =
        std::result::Result<crate::output::GetMlTransformOutput, crate::error::GetMLTransformError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ml_transform_error(response)
        } else {
            crate::operation_deser::parse_get_ml_transform_response(response)
        }
    }
}

/// Operation shape for `GetMLTransforms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ml_transforms`](crate::client::Client::get_ml_transforms).
///
/// See [`crate::client::fluent_builders::GetMLTransforms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMLTransforms {
    _private: (),
}
impl GetMLTransforms {
    /// Creates a new builder-style object to manufacture [`GetMlTransformsInput`](crate::input::GetMlTransformsInput)
    pub fn builder() -> crate::input::get_ml_transforms_input::Builder {
        crate::input::get_ml_transforms_input::Builder::default()
    }
    /// Creates a new `GetMLTransforms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMLTransforms {
    type Output = std::result::Result<
        crate::output::GetMlTransformsOutput,
        crate::error::GetMLTransformsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ml_transforms_error(response)
        } else {
            crate::operation_deser::parse_get_ml_transforms_response(response)
        }
    }
}

/// Operation shape for `GetPartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_partition`](crate::client::Client::get_partition).
///
/// See [`crate::client::fluent_builders::GetPartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPartition {
    _private: (),
}
impl GetPartition {
    /// Creates a new builder-style object to manufacture [`GetPartitionInput`](crate::input::GetPartitionInput)
    pub fn builder() -> crate::input::get_partition_input::Builder {
        crate::input::get_partition_input::Builder::default()
    }
    /// Creates a new `GetPartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPartition {
    type Output =
        std::result::Result<crate::output::GetPartitionOutput, crate::error::GetPartitionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_partition_error(response)
        } else {
            crate::operation_deser::parse_get_partition_response(response)
        }
    }
}

/// Operation shape for `GetPartitionIndexes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_partition_indexes`](crate::client::Client::get_partition_indexes).
///
/// See [`crate::client::fluent_builders::GetPartitionIndexes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPartitionIndexes {
    _private: (),
}
impl GetPartitionIndexes {
    /// Creates a new builder-style object to manufacture [`GetPartitionIndexesInput`](crate::input::GetPartitionIndexesInput)
    pub fn builder() -> crate::input::get_partition_indexes_input::Builder {
        crate::input::get_partition_indexes_input::Builder::default()
    }
    /// Creates a new `GetPartitionIndexes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPartitionIndexes {
    type Output = std::result::Result<
        crate::output::GetPartitionIndexesOutput,
        crate::error::GetPartitionIndexesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_partition_indexes_error(response)
        } else {
            crate::operation_deser::parse_get_partition_indexes_response(response)
        }
    }
}

/// Operation shape for `GetPartitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_partitions`](crate::client::Client::get_partitions).
///
/// See [`crate::client::fluent_builders::GetPartitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPartitions {
    _private: (),
}
impl GetPartitions {
    /// Creates a new builder-style object to manufacture [`GetPartitionsInput`](crate::input::GetPartitionsInput)
    pub fn builder() -> crate::input::get_partitions_input::Builder {
        crate::input::get_partitions_input::Builder::default()
    }
    /// Creates a new `GetPartitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPartitions {
    type Output =
        std::result::Result<crate::output::GetPartitionsOutput, crate::error::GetPartitionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_partitions_error(response)
        } else {
            crate::operation_deser::parse_get_partitions_response(response)
        }
    }
}

/// Operation shape for `GetPlan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_plan`](crate::client::Client::get_plan).
///
/// See [`crate::client::fluent_builders::GetPlan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPlan {
    _private: (),
}
impl GetPlan {
    /// Creates a new builder-style object to manufacture [`GetPlanInput`](crate::input::GetPlanInput)
    pub fn builder() -> crate::input::get_plan_input::Builder {
        crate::input::get_plan_input::Builder::default()
    }
    /// Creates a new `GetPlan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPlan {
    type Output = std::result::Result<crate::output::GetPlanOutput, crate::error::GetPlanError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_plan_error(response)
        } else {
            crate::operation_deser::parse_get_plan_response(response)
        }
    }
}

/// Operation shape for `GetRegistry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_registry`](crate::client::Client::get_registry).
///
/// See [`crate::client::fluent_builders::GetRegistry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRegistry {
    _private: (),
}
impl GetRegistry {
    /// Creates a new builder-style object to manufacture [`GetRegistryInput`](crate::input::GetRegistryInput)
    pub fn builder() -> crate::input::get_registry_input::Builder {
        crate::input::get_registry_input::Builder::default()
    }
    /// Creates a new `GetRegistry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRegistry {
    type Output =
        std::result::Result<crate::output::GetRegistryOutput, crate::error::GetRegistryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_registry_error(response)
        } else {
            crate::operation_deser::parse_get_registry_response(response)
        }
    }
}

/// Operation shape for `GetResourcePolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_policies`](crate::client::Client::get_resource_policies).
///
/// See [`crate::client::fluent_builders::GetResourcePolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourcePolicies {
    _private: (),
}
impl GetResourcePolicies {
    /// Creates a new builder-style object to manufacture [`GetResourcePoliciesInput`](crate::input::GetResourcePoliciesInput)
    pub fn builder() -> crate::input::get_resource_policies_input::Builder {
        crate::input::get_resource_policies_input::Builder::default()
    }
    /// Creates a new `GetResourcePolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourcePolicies {
    type Output = std::result::Result<
        crate::output::GetResourcePoliciesOutput,
        crate::error::GetResourcePoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_policies_error(response)
        } else {
            crate::operation_deser::parse_get_resource_policies_response(response)
        }
    }
}

/// Operation shape for `GetResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_policy`](crate::client::Client::get_resource_policy).
///
/// See [`crate::client::fluent_builders::GetResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourcePolicy {
    _private: (),
}
impl GetResourcePolicy {
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
    pub fn builder() -> crate::input::get_resource_policy_input::Builder {
        crate::input::get_resource_policy_input::Builder::default()
    }
    /// Creates a new `GetResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourcePolicy {
    type Output = std::result::Result<
        crate::output::GetResourcePolicyOutput,
        crate::error::GetResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_get_resource_policy_response(response)
        }
    }
}

/// Operation shape for `GetSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_schema`](crate::client::Client::get_schema).
///
/// See [`crate::client::fluent_builders::GetSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSchema {
    _private: (),
}
impl GetSchema {
    /// Creates a new builder-style object to manufacture [`GetSchemaInput`](crate::input::GetSchemaInput)
    pub fn builder() -> crate::input::get_schema_input::Builder {
        crate::input::get_schema_input::Builder::default()
    }
    /// Creates a new `GetSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSchema {
    type Output = std::result::Result<crate::output::GetSchemaOutput, crate::error::GetSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_schema_error(response)
        } else {
            crate::operation_deser::parse_get_schema_response(response)
        }
    }
}

/// Operation shape for `GetSchemaByDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_schema_by_definition`](crate::client::Client::get_schema_by_definition).
///
/// See [`crate::client::fluent_builders::GetSchemaByDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSchemaByDefinition {
    _private: (),
}
impl GetSchemaByDefinition {
    /// Creates a new builder-style object to manufacture [`GetSchemaByDefinitionInput`](crate::input::GetSchemaByDefinitionInput)
    pub fn builder() -> crate::input::get_schema_by_definition_input::Builder {
        crate::input::get_schema_by_definition_input::Builder::default()
    }
    /// Creates a new `GetSchemaByDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSchemaByDefinition {
    type Output = std::result::Result<
        crate::output::GetSchemaByDefinitionOutput,
        crate::error::GetSchemaByDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_schema_by_definition_error(response)
        } else {
            crate::operation_deser::parse_get_schema_by_definition_response(response)
        }
    }
}

/// Operation shape for `GetSchemaVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_schema_version`](crate::client::Client::get_schema_version).
///
/// See [`crate::client::fluent_builders::GetSchemaVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSchemaVersion {
    _private: (),
}
impl GetSchemaVersion {
    /// Creates a new builder-style object to manufacture [`GetSchemaVersionInput`](crate::input::GetSchemaVersionInput)
    pub fn builder() -> crate::input::get_schema_version_input::Builder {
        crate::input::get_schema_version_input::Builder::default()
    }
    /// Creates a new `GetSchemaVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSchemaVersion {
    type Output = std::result::Result<
        crate::output::GetSchemaVersionOutput,
        crate::error::GetSchemaVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_schema_version_error(response)
        } else {
            crate::operation_deser::parse_get_schema_version_response(response)
        }
    }
}

/// Operation shape for `GetSchemaVersionsDiff`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_schema_versions_diff`](crate::client::Client::get_schema_versions_diff).
///
/// See [`crate::client::fluent_builders::GetSchemaVersionsDiff`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSchemaVersionsDiff {
    _private: (),
}
impl GetSchemaVersionsDiff {
    /// Creates a new builder-style object to manufacture [`GetSchemaVersionsDiffInput`](crate::input::GetSchemaVersionsDiffInput)
    pub fn builder() -> crate::input::get_schema_versions_diff_input::Builder {
        crate::input::get_schema_versions_diff_input::Builder::default()
    }
    /// Creates a new `GetSchemaVersionsDiff` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSchemaVersionsDiff {
    type Output = std::result::Result<
        crate::output::GetSchemaVersionsDiffOutput,
        crate::error::GetSchemaVersionsDiffError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_schema_versions_diff_error(response)
        } else {
            crate::operation_deser::parse_get_schema_versions_diff_response(response)
        }
    }
}

/// Operation shape for `GetSecurityConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_security_configuration`](crate::client::Client::get_security_configuration).
///
/// See [`crate::client::fluent_builders::GetSecurityConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSecurityConfiguration {
    _private: (),
}
impl GetSecurityConfiguration {
    /// Creates a new builder-style object to manufacture [`GetSecurityConfigurationInput`](crate::input::GetSecurityConfigurationInput)
    pub fn builder() -> crate::input::get_security_configuration_input::Builder {
        crate::input::get_security_configuration_input::Builder::default()
    }
    /// Creates a new `GetSecurityConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSecurityConfiguration {
    type Output = std::result::Result<
        crate::output::GetSecurityConfigurationOutput,
        crate::error::GetSecurityConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_security_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_security_configuration_response(response)
        }
    }
}

/// Operation shape for `GetSecurityConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_security_configurations`](crate::client::Client::get_security_configurations).
///
/// See [`crate::client::fluent_builders::GetSecurityConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSecurityConfigurations {
    _private: (),
}
impl GetSecurityConfigurations {
    /// Creates a new builder-style object to manufacture [`GetSecurityConfigurationsInput`](crate::input::GetSecurityConfigurationsInput)
    pub fn builder() -> crate::input::get_security_configurations_input::Builder {
        crate::input::get_security_configurations_input::Builder::default()
    }
    /// Creates a new `GetSecurityConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSecurityConfigurations {
    type Output = std::result::Result<
        crate::output::GetSecurityConfigurationsOutput,
        crate::error::GetSecurityConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_security_configurations_error(response)
        } else {
            crate::operation_deser::parse_get_security_configurations_response(response)
        }
    }
}

/// Operation shape for `GetTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_table`](crate::client::Client::get_table).
///
/// See [`crate::client::fluent_builders::GetTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTable {
    _private: (),
}
impl GetTable {
    /// Creates a new builder-style object to manufacture [`GetTableInput`](crate::input::GetTableInput)
    pub fn builder() -> crate::input::get_table_input::Builder {
        crate::input::get_table_input::Builder::default()
    }
    /// Creates a new `GetTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTable {
    type Output = std::result::Result<crate::output::GetTableOutput, crate::error::GetTableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_table_error(response)
        } else {
            crate::operation_deser::parse_get_table_response(response)
        }
    }
}

/// Operation shape for `GetTables`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_tables`](crate::client::Client::get_tables).
///
/// See [`crate::client::fluent_builders::GetTables`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTables {
    _private: (),
}
impl GetTables {
    /// Creates a new builder-style object to manufacture [`GetTablesInput`](crate::input::GetTablesInput)
    pub fn builder() -> crate::input::get_tables_input::Builder {
        crate::input::get_tables_input::Builder::default()
    }
    /// Creates a new `GetTables` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTables {
    type Output = std::result::Result<crate::output::GetTablesOutput, crate::error::GetTablesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_tables_error(response)
        } else {
            crate::operation_deser::parse_get_tables_response(response)
        }
    }
}

/// Operation shape for `GetTableVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_table_version`](crate::client::Client::get_table_version).
///
/// See [`crate::client::fluent_builders::GetTableVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTableVersion {
    _private: (),
}
impl GetTableVersion {
    /// Creates a new builder-style object to manufacture [`GetTableVersionInput`](crate::input::GetTableVersionInput)
    pub fn builder() -> crate::input::get_table_version_input::Builder {
        crate::input::get_table_version_input::Builder::default()
    }
    /// Creates a new `GetTableVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTableVersion {
    type Output = std::result::Result<
        crate::output::GetTableVersionOutput,
        crate::error::GetTableVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_table_version_error(response)
        } else {
            crate::operation_deser::parse_get_table_version_response(response)
        }
    }
}

/// Operation shape for `GetTableVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_table_versions`](crate::client::Client::get_table_versions).
///
/// See [`crate::client::fluent_builders::GetTableVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTableVersions {
    _private: (),
}
impl GetTableVersions {
    /// Creates a new builder-style object to manufacture [`GetTableVersionsInput`](crate::input::GetTableVersionsInput)
    pub fn builder() -> crate::input::get_table_versions_input::Builder {
        crate::input::get_table_versions_input::Builder::default()
    }
    /// Creates a new `GetTableVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTableVersions {
    type Output = std::result::Result<
        crate::output::GetTableVersionsOutput,
        crate::error::GetTableVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_table_versions_error(response)
        } else {
            crate::operation_deser::parse_get_table_versions_response(response)
        }
    }
}

/// Operation shape for `GetTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_tags`](crate::client::Client::get_tags).
///
/// See [`crate::client::fluent_builders::GetTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTags {
    _private: (),
}
impl GetTags {
    /// Creates a new builder-style object to manufacture [`GetTagsInput`](crate::input::GetTagsInput)
    pub fn builder() -> crate::input::get_tags_input::Builder {
        crate::input::get_tags_input::Builder::default()
    }
    /// Creates a new `GetTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTags {
    type Output = std::result::Result<crate::output::GetTagsOutput, crate::error::GetTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_tags_error(response)
        } else {
            crate::operation_deser::parse_get_tags_response(response)
        }
    }
}

/// Operation shape for `GetTrigger`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_trigger`](crate::client::Client::get_trigger).
///
/// See [`crate::client::fluent_builders::GetTrigger`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTrigger {
    _private: (),
}
impl GetTrigger {
    /// Creates a new builder-style object to manufacture [`GetTriggerInput`](crate::input::GetTriggerInput)
    pub fn builder() -> crate::input::get_trigger_input::Builder {
        crate::input::get_trigger_input::Builder::default()
    }
    /// Creates a new `GetTrigger` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTrigger {
    type Output =
        std::result::Result<crate::output::GetTriggerOutput, crate::error::GetTriggerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_trigger_error(response)
        } else {
            crate::operation_deser::parse_get_trigger_response(response)
        }
    }
}

/// Operation shape for `GetTriggers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_triggers`](crate::client::Client::get_triggers).
///
/// See [`crate::client::fluent_builders::GetTriggers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTriggers {
    _private: (),
}
impl GetTriggers {
    /// Creates a new builder-style object to manufacture [`GetTriggersInput`](crate::input::GetTriggersInput)
    pub fn builder() -> crate::input::get_triggers_input::Builder {
        crate::input::get_triggers_input::Builder::default()
    }
    /// Creates a new `GetTriggers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTriggers {
    type Output =
        std::result::Result<crate::output::GetTriggersOutput, crate::error::GetTriggersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_triggers_error(response)
        } else {
            crate::operation_deser::parse_get_triggers_response(response)
        }
    }
}

/// Operation shape for `GetUserDefinedFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_user_defined_function`](crate::client::Client::get_user_defined_function).
///
/// See [`crate::client::fluent_builders::GetUserDefinedFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUserDefinedFunction {
    _private: (),
}
impl GetUserDefinedFunction {
    /// Creates a new builder-style object to manufacture [`GetUserDefinedFunctionInput`](crate::input::GetUserDefinedFunctionInput)
    pub fn builder() -> crate::input::get_user_defined_function_input::Builder {
        crate::input::get_user_defined_function_input::Builder::default()
    }
    /// Creates a new `GetUserDefinedFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUserDefinedFunction {
    type Output = std::result::Result<
        crate::output::GetUserDefinedFunctionOutput,
        crate::error::GetUserDefinedFunctionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_user_defined_function_error(response)
        } else {
            crate::operation_deser::parse_get_user_defined_function_response(response)
        }
    }
}

/// Operation shape for `GetUserDefinedFunctions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_user_defined_functions`](crate::client::Client::get_user_defined_functions).
///
/// See [`crate::client::fluent_builders::GetUserDefinedFunctions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUserDefinedFunctions {
    _private: (),
}
impl GetUserDefinedFunctions {
    /// Creates a new builder-style object to manufacture [`GetUserDefinedFunctionsInput`](crate::input::GetUserDefinedFunctionsInput)
    pub fn builder() -> crate::input::get_user_defined_functions_input::Builder {
        crate::input::get_user_defined_functions_input::Builder::default()
    }
    /// Creates a new `GetUserDefinedFunctions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUserDefinedFunctions {
    type Output = std::result::Result<
        crate::output::GetUserDefinedFunctionsOutput,
        crate::error::GetUserDefinedFunctionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_user_defined_functions_error(response)
        } else {
            crate::operation_deser::parse_get_user_defined_functions_response(response)
        }
    }
}

/// Operation shape for `GetWorkflow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_workflow`](crate::client::Client::get_workflow).
///
/// See [`crate::client::fluent_builders::GetWorkflow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkflow {
    _private: (),
}
impl GetWorkflow {
    /// Creates a new builder-style object to manufacture [`GetWorkflowInput`](crate::input::GetWorkflowInput)
    pub fn builder() -> crate::input::get_workflow_input::Builder {
        crate::input::get_workflow_input::Builder::default()
    }
    /// Creates a new `GetWorkflow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkflow {
    type Output =
        std::result::Result<crate::output::GetWorkflowOutput, crate::error::GetWorkflowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_workflow_error(response)
        } else {
            crate::operation_deser::parse_get_workflow_response(response)
        }
    }
}

/// Operation shape for `GetWorkflowRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_workflow_run`](crate::client::Client::get_workflow_run).
///
/// See [`crate::client::fluent_builders::GetWorkflowRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkflowRun {
    _private: (),
}
impl GetWorkflowRun {
    /// Creates a new builder-style object to manufacture [`GetWorkflowRunInput`](crate::input::GetWorkflowRunInput)
    pub fn builder() -> crate::input::get_workflow_run_input::Builder {
        crate::input::get_workflow_run_input::Builder::default()
    }
    /// Creates a new `GetWorkflowRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkflowRun {
    type Output =
        std::result::Result<crate::output::GetWorkflowRunOutput, crate::error::GetWorkflowRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_workflow_run_error(response)
        } else {
            crate::operation_deser::parse_get_workflow_run_response(response)
        }
    }
}

/// Operation shape for `GetWorkflowRunProperties`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_workflow_run_properties`](crate::client::Client::get_workflow_run_properties).
///
/// See [`crate::client::fluent_builders::GetWorkflowRunProperties`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkflowRunProperties {
    _private: (),
}
impl GetWorkflowRunProperties {
    /// Creates a new builder-style object to manufacture [`GetWorkflowRunPropertiesInput`](crate::input::GetWorkflowRunPropertiesInput)
    pub fn builder() -> crate::input::get_workflow_run_properties_input::Builder {
        crate::input::get_workflow_run_properties_input::Builder::default()
    }
    /// Creates a new `GetWorkflowRunProperties` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkflowRunProperties {
    type Output = std::result::Result<
        crate::output::GetWorkflowRunPropertiesOutput,
        crate::error::GetWorkflowRunPropertiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_workflow_run_properties_error(response)
        } else {
            crate::operation_deser::parse_get_workflow_run_properties_response(response)
        }
    }
}

/// Operation shape for `GetWorkflowRuns`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_workflow_runs`](crate::client::Client::get_workflow_runs).
///
/// See [`crate::client::fluent_builders::GetWorkflowRuns`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkflowRuns {
    _private: (),
}
impl GetWorkflowRuns {
    /// Creates a new builder-style object to manufacture [`GetWorkflowRunsInput`](crate::input::GetWorkflowRunsInput)
    pub fn builder() -> crate::input::get_workflow_runs_input::Builder {
        crate::input::get_workflow_runs_input::Builder::default()
    }
    /// Creates a new `GetWorkflowRuns` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkflowRuns {
    type Output = std::result::Result<
        crate::output::GetWorkflowRunsOutput,
        crate::error::GetWorkflowRunsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_workflow_runs_error(response)
        } else {
            crate::operation_deser::parse_get_workflow_runs_response(response)
        }
    }
}

/// Operation shape for `ImportCatalogToGlue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_catalog_to_glue`](crate::client::Client::import_catalog_to_glue).
///
/// See [`crate::client::fluent_builders::ImportCatalogToGlue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportCatalogToGlue {
    _private: (),
}
impl ImportCatalogToGlue {
    /// Creates a new builder-style object to manufacture [`ImportCatalogToGlueInput`](crate::input::ImportCatalogToGlueInput)
    pub fn builder() -> crate::input::import_catalog_to_glue_input::Builder {
        crate::input::import_catalog_to_glue_input::Builder::default()
    }
    /// Creates a new `ImportCatalogToGlue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportCatalogToGlue {
    type Output = std::result::Result<
        crate::output::ImportCatalogToGlueOutput,
        crate::error::ImportCatalogToGlueError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_catalog_to_glue_error(response)
        } else {
            crate::operation_deser::parse_import_catalog_to_glue_response(response)
        }
    }
}

/// Operation shape for `ListBlueprints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_blueprints`](crate::client::Client::list_blueprints).
///
/// See [`crate::client::fluent_builders::ListBlueprints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBlueprints {
    _private: (),
}
impl ListBlueprints {
    /// Creates a new builder-style object to manufacture [`ListBlueprintsInput`](crate::input::ListBlueprintsInput)
    pub fn builder() -> crate::input::list_blueprints_input::Builder {
        crate::input::list_blueprints_input::Builder::default()
    }
    /// Creates a new `ListBlueprints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBlueprints {
    type Output =
        std::result::Result<crate::output::ListBlueprintsOutput, crate::error::ListBlueprintsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_blueprints_error(response)
        } else {
            crate::operation_deser::parse_list_blueprints_response(response)
        }
    }
}

/// Operation shape for `ListCrawlers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_crawlers`](crate::client::Client::list_crawlers).
///
/// See [`crate::client::fluent_builders::ListCrawlers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCrawlers {
    _private: (),
}
impl ListCrawlers {
    /// Creates a new builder-style object to manufacture [`ListCrawlersInput`](crate::input::ListCrawlersInput)
    pub fn builder() -> crate::input::list_crawlers_input::Builder {
        crate::input::list_crawlers_input::Builder::default()
    }
    /// Creates a new `ListCrawlers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCrawlers {
    type Output =
        std::result::Result<crate::output::ListCrawlersOutput, crate::error::ListCrawlersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_crawlers_error(response)
        } else {
            crate::operation_deser::parse_list_crawlers_response(response)
        }
    }
}

/// Operation shape for `ListDevEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dev_endpoints`](crate::client::Client::list_dev_endpoints).
///
/// See [`crate::client::fluent_builders::ListDevEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevEndpoints {
    _private: (),
}
impl ListDevEndpoints {
    /// Creates a new builder-style object to manufacture [`ListDevEndpointsInput`](crate::input::ListDevEndpointsInput)
    pub fn builder() -> crate::input::list_dev_endpoints_input::Builder {
        crate::input::list_dev_endpoints_input::Builder::default()
    }
    /// Creates a new `ListDevEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevEndpoints {
    type Output = std::result::Result<
        crate::output::ListDevEndpointsOutput,
        crate::error::ListDevEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dev_endpoints_error(response)
        } else {
            crate::operation_deser::parse_list_dev_endpoints_response(response)
        }
    }
}

/// Operation shape for `ListJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_jobs`](crate::client::Client::list_jobs).
///
/// See [`crate::client::fluent_builders::ListJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobs {
    _private: (),
}
impl ListJobs {
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
    /// Creates a new `ListJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobs {
    type Output = std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_jobs_response(response)
        }
    }
}

/// Operation shape for `ListMLTransforms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ml_transforms`](crate::client::Client::list_ml_transforms).
///
/// See [`crate::client::fluent_builders::ListMLTransforms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMLTransforms {
    _private: (),
}
impl ListMLTransforms {
    /// Creates a new builder-style object to manufacture [`ListMlTransformsInput`](crate::input::ListMlTransformsInput)
    pub fn builder() -> crate::input::list_ml_transforms_input::Builder {
        crate::input::list_ml_transforms_input::Builder::default()
    }
    /// Creates a new `ListMLTransforms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMLTransforms {
    type Output = std::result::Result<
        crate::output::ListMlTransformsOutput,
        crate::error::ListMLTransformsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ml_transforms_error(response)
        } else {
            crate::operation_deser::parse_list_ml_transforms_response(response)
        }
    }
}

/// Operation shape for `ListRegistries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_registries`](crate::client::Client::list_registries).
///
/// See [`crate::client::fluent_builders::ListRegistries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRegistries {
    _private: (),
}
impl ListRegistries {
    /// Creates a new builder-style object to manufacture [`ListRegistriesInput`](crate::input::ListRegistriesInput)
    pub fn builder() -> crate::input::list_registries_input::Builder {
        crate::input::list_registries_input::Builder::default()
    }
    /// Creates a new `ListRegistries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRegistries {
    type Output =
        std::result::Result<crate::output::ListRegistriesOutput, crate::error::ListRegistriesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_registries_error(response)
        } else {
            crate::operation_deser::parse_list_registries_response(response)
        }
    }
}

/// Operation shape for `ListSchemas`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_schemas`](crate::client::Client::list_schemas).
///
/// See [`crate::client::fluent_builders::ListSchemas`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSchemas {
    _private: (),
}
impl ListSchemas {
    /// Creates a new builder-style object to manufacture [`ListSchemasInput`](crate::input::ListSchemasInput)
    pub fn builder() -> crate::input::list_schemas_input::Builder {
        crate::input::list_schemas_input::Builder::default()
    }
    /// Creates a new `ListSchemas` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSchemas {
    type Output =
        std::result::Result<crate::output::ListSchemasOutput, crate::error::ListSchemasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_schemas_error(response)
        } else {
            crate::operation_deser::parse_list_schemas_response(response)
        }
    }
}

/// Operation shape for `ListSchemaVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_schema_versions`](crate::client::Client::list_schema_versions).
///
/// See [`crate::client::fluent_builders::ListSchemaVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSchemaVersions {
    _private: (),
}
impl ListSchemaVersions {
    /// Creates a new builder-style object to manufacture [`ListSchemaVersionsInput`](crate::input::ListSchemaVersionsInput)
    pub fn builder() -> crate::input::list_schema_versions_input::Builder {
        crate::input::list_schema_versions_input::Builder::default()
    }
    /// Creates a new `ListSchemaVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSchemaVersions {
    type Output = std::result::Result<
        crate::output::ListSchemaVersionsOutput,
        crate::error::ListSchemaVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_schema_versions_error(response)
        } else {
            crate::operation_deser::parse_list_schema_versions_response(response)
        }
    }
}

/// Operation shape for `ListTriggers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_triggers`](crate::client::Client::list_triggers).
///
/// See [`crate::client::fluent_builders::ListTriggers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTriggers {
    _private: (),
}
impl ListTriggers {
    /// Creates a new builder-style object to manufacture [`ListTriggersInput`](crate::input::ListTriggersInput)
    pub fn builder() -> crate::input::list_triggers_input::Builder {
        crate::input::list_triggers_input::Builder::default()
    }
    /// Creates a new `ListTriggers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTriggers {
    type Output =
        std::result::Result<crate::output::ListTriggersOutput, crate::error::ListTriggersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_triggers_error(response)
        } else {
            crate::operation_deser::parse_list_triggers_response(response)
        }
    }
}

/// Operation shape for `ListWorkflows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_workflows`](crate::client::Client::list_workflows).
///
/// See [`crate::client::fluent_builders::ListWorkflows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkflows {
    _private: (),
}
impl ListWorkflows {
    /// Creates a new builder-style object to manufacture [`ListWorkflowsInput`](crate::input::ListWorkflowsInput)
    pub fn builder() -> crate::input::list_workflows_input::Builder {
        crate::input::list_workflows_input::Builder::default()
    }
    /// Creates a new `ListWorkflows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkflows {
    type Output =
        std::result::Result<crate::output::ListWorkflowsOutput, crate::error::ListWorkflowsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_workflows_error(response)
        } else {
            crate::operation_deser::parse_list_workflows_response(response)
        }
    }
}

/// Operation shape for `PutDataCatalogEncryptionSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_data_catalog_encryption_settings`](crate::client::Client::put_data_catalog_encryption_settings).
///
/// See [`crate::client::fluent_builders::PutDataCatalogEncryptionSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDataCatalogEncryptionSettings {
    _private: (),
}
impl PutDataCatalogEncryptionSettings {
    /// Creates a new builder-style object to manufacture [`PutDataCatalogEncryptionSettingsInput`](crate::input::PutDataCatalogEncryptionSettingsInput)
    pub fn builder() -> crate::input::put_data_catalog_encryption_settings_input::Builder {
        crate::input::put_data_catalog_encryption_settings_input::Builder::default()
    }
    /// Creates a new `PutDataCatalogEncryptionSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDataCatalogEncryptionSettings {
    type Output = std::result::Result<
        crate::output::PutDataCatalogEncryptionSettingsOutput,
        crate::error::PutDataCatalogEncryptionSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_data_catalog_encryption_settings_error(response)
        } else {
            crate::operation_deser::parse_put_data_catalog_encryption_settings_response(response)
        }
    }
}

/// Operation shape for `PutResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resource_policy`](crate::client::Client::put_resource_policy).
///
/// See [`crate::client::fluent_builders::PutResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResourcePolicy {
    _private: (),
}
impl PutResourcePolicy {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    pub fn builder() -> crate::input::put_resource_policy_input::Builder {
        crate::input::put_resource_policy_input::Builder::default()
    }
    /// Creates a new `PutResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResourcePolicy {
    type Output = std::result::Result<
        crate::output::PutResourcePolicyOutput,
        crate::error::PutResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_put_resource_policy_response(response)
        }
    }
}

/// Operation shape for `PutSchemaVersionMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_schema_version_metadata`](crate::client::Client::put_schema_version_metadata).
///
/// See [`crate::client::fluent_builders::PutSchemaVersionMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutSchemaVersionMetadata {
    _private: (),
}
impl PutSchemaVersionMetadata {
    /// Creates a new builder-style object to manufacture [`PutSchemaVersionMetadataInput`](crate::input::PutSchemaVersionMetadataInput)
    pub fn builder() -> crate::input::put_schema_version_metadata_input::Builder {
        crate::input::put_schema_version_metadata_input::Builder::default()
    }
    /// Creates a new `PutSchemaVersionMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutSchemaVersionMetadata {
    type Output = std::result::Result<
        crate::output::PutSchemaVersionMetadataOutput,
        crate::error::PutSchemaVersionMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_schema_version_metadata_error(response)
        } else {
            crate::operation_deser::parse_put_schema_version_metadata_response(response)
        }
    }
}

/// Operation shape for `PutWorkflowRunProperties`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_workflow_run_properties`](crate::client::Client::put_workflow_run_properties).
///
/// See [`crate::client::fluent_builders::PutWorkflowRunProperties`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutWorkflowRunProperties {
    _private: (),
}
impl PutWorkflowRunProperties {
    /// Creates a new builder-style object to manufacture [`PutWorkflowRunPropertiesInput`](crate::input::PutWorkflowRunPropertiesInput)
    pub fn builder() -> crate::input::put_workflow_run_properties_input::Builder {
        crate::input::put_workflow_run_properties_input::Builder::default()
    }
    /// Creates a new `PutWorkflowRunProperties` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutWorkflowRunProperties {
    type Output = std::result::Result<
        crate::output::PutWorkflowRunPropertiesOutput,
        crate::error::PutWorkflowRunPropertiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_workflow_run_properties_error(response)
        } else {
            crate::operation_deser::parse_put_workflow_run_properties_response(response)
        }
    }
}

/// Operation shape for `QuerySchemaVersionMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`query_schema_version_metadata`](crate::client::Client::query_schema_version_metadata).
///
/// See [`crate::client::fluent_builders::QuerySchemaVersionMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct QuerySchemaVersionMetadata {
    _private: (),
}
impl QuerySchemaVersionMetadata {
    /// Creates a new builder-style object to manufacture [`QuerySchemaVersionMetadataInput`](crate::input::QuerySchemaVersionMetadataInput)
    pub fn builder() -> crate::input::query_schema_version_metadata_input::Builder {
        crate::input::query_schema_version_metadata_input::Builder::default()
    }
    /// Creates a new `QuerySchemaVersionMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for QuerySchemaVersionMetadata {
    type Output = std::result::Result<
        crate::output::QuerySchemaVersionMetadataOutput,
        crate::error::QuerySchemaVersionMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_query_schema_version_metadata_error(response)
        } else {
            crate::operation_deser::parse_query_schema_version_metadata_response(response)
        }
    }
}

/// Operation shape for `RegisterSchemaVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_schema_version`](crate::client::Client::register_schema_version).
///
/// See [`crate::client::fluent_builders::RegisterSchemaVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterSchemaVersion {
    _private: (),
}
impl RegisterSchemaVersion {
    /// Creates a new builder-style object to manufacture [`RegisterSchemaVersionInput`](crate::input::RegisterSchemaVersionInput)
    pub fn builder() -> crate::input::register_schema_version_input::Builder {
        crate::input::register_schema_version_input::Builder::default()
    }
    /// Creates a new `RegisterSchemaVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterSchemaVersion {
    type Output = std::result::Result<
        crate::output::RegisterSchemaVersionOutput,
        crate::error::RegisterSchemaVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_schema_version_error(response)
        } else {
            crate::operation_deser::parse_register_schema_version_response(response)
        }
    }
}

/// Operation shape for `RemoveSchemaVersionMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_schema_version_metadata`](crate::client::Client::remove_schema_version_metadata).
///
/// See [`crate::client::fluent_builders::RemoveSchemaVersionMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveSchemaVersionMetadata {
    _private: (),
}
impl RemoveSchemaVersionMetadata {
    /// Creates a new builder-style object to manufacture [`RemoveSchemaVersionMetadataInput`](crate::input::RemoveSchemaVersionMetadataInput)
    pub fn builder() -> crate::input::remove_schema_version_metadata_input::Builder {
        crate::input::remove_schema_version_metadata_input::Builder::default()
    }
    /// Creates a new `RemoveSchemaVersionMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveSchemaVersionMetadata {
    type Output = std::result::Result<
        crate::output::RemoveSchemaVersionMetadataOutput,
        crate::error::RemoveSchemaVersionMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_schema_version_metadata_error(response)
        } else {
            crate::operation_deser::parse_remove_schema_version_metadata_response(response)
        }
    }
}

/// Operation shape for `ResetJobBookmark`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_job_bookmark`](crate::client::Client::reset_job_bookmark).
///
/// See [`crate::client::fluent_builders::ResetJobBookmark`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetJobBookmark {
    _private: (),
}
impl ResetJobBookmark {
    /// Creates a new builder-style object to manufacture [`ResetJobBookmarkInput`](crate::input::ResetJobBookmarkInput)
    pub fn builder() -> crate::input::reset_job_bookmark_input::Builder {
        crate::input::reset_job_bookmark_input::Builder::default()
    }
    /// Creates a new `ResetJobBookmark` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetJobBookmark {
    type Output = std::result::Result<
        crate::output::ResetJobBookmarkOutput,
        crate::error::ResetJobBookmarkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_job_bookmark_error(response)
        } else {
            crate::operation_deser::parse_reset_job_bookmark_response(response)
        }
    }
}

/// Operation shape for `ResumeWorkflowRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resume_workflow_run`](crate::client::Client::resume_workflow_run).
///
/// See [`crate::client::fluent_builders::ResumeWorkflowRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResumeWorkflowRun {
    _private: (),
}
impl ResumeWorkflowRun {
    /// Creates a new builder-style object to manufacture [`ResumeWorkflowRunInput`](crate::input::ResumeWorkflowRunInput)
    pub fn builder() -> crate::input::resume_workflow_run_input::Builder {
        crate::input::resume_workflow_run_input::Builder::default()
    }
    /// Creates a new `ResumeWorkflowRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResumeWorkflowRun {
    type Output = std::result::Result<
        crate::output::ResumeWorkflowRunOutput,
        crate::error::ResumeWorkflowRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resume_workflow_run_error(response)
        } else {
            crate::operation_deser::parse_resume_workflow_run_response(response)
        }
    }
}

/// Operation shape for `SearchTables`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_tables`](crate::client::Client::search_tables).
///
/// See [`crate::client::fluent_builders::SearchTables`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchTables {
    _private: (),
}
impl SearchTables {
    /// Creates a new builder-style object to manufacture [`SearchTablesInput`](crate::input::SearchTablesInput)
    pub fn builder() -> crate::input::search_tables_input::Builder {
        crate::input::search_tables_input::Builder::default()
    }
    /// Creates a new `SearchTables` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchTables {
    type Output =
        std::result::Result<crate::output::SearchTablesOutput, crate::error::SearchTablesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_tables_error(response)
        } else {
            crate::operation_deser::parse_search_tables_response(response)
        }
    }
}

/// Operation shape for `StartBlueprintRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_blueprint_run`](crate::client::Client::start_blueprint_run).
///
/// See [`crate::client::fluent_builders::StartBlueprintRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartBlueprintRun {
    _private: (),
}
impl StartBlueprintRun {
    /// Creates a new builder-style object to manufacture [`StartBlueprintRunInput`](crate::input::StartBlueprintRunInput)
    pub fn builder() -> crate::input::start_blueprint_run_input::Builder {
        crate::input::start_blueprint_run_input::Builder::default()
    }
    /// Creates a new `StartBlueprintRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartBlueprintRun {
    type Output = std::result::Result<
        crate::output::StartBlueprintRunOutput,
        crate::error::StartBlueprintRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_blueprint_run_error(response)
        } else {
            crate::operation_deser::parse_start_blueprint_run_response(response)
        }
    }
}

/// Operation shape for `StartCrawler`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_crawler`](crate::client::Client::start_crawler).
///
/// See [`crate::client::fluent_builders::StartCrawler`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartCrawler {
    _private: (),
}
impl StartCrawler {
    /// Creates a new builder-style object to manufacture [`StartCrawlerInput`](crate::input::StartCrawlerInput)
    pub fn builder() -> crate::input::start_crawler_input::Builder {
        crate::input::start_crawler_input::Builder::default()
    }
    /// Creates a new `StartCrawler` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartCrawler {
    type Output =
        std::result::Result<crate::output::StartCrawlerOutput, crate::error::StartCrawlerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_crawler_error(response)
        } else {
            crate::operation_deser::parse_start_crawler_response(response)
        }
    }
}

/// Operation shape for `StartCrawlerSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_crawler_schedule`](crate::client::Client::start_crawler_schedule).
///
/// See [`crate::client::fluent_builders::StartCrawlerSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartCrawlerSchedule {
    _private: (),
}
impl StartCrawlerSchedule {
    /// Creates a new builder-style object to manufacture [`StartCrawlerScheduleInput`](crate::input::StartCrawlerScheduleInput)
    pub fn builder() -> crate::input::start_crawler_schedule_input::Builder {
        crate::input::start_crawler_schedule_input::Builder::default()
    }
    /// Creates a new `StartCrawlerSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartCrawlerSchedule {
    type Output = std::result::Result<
        crate::output::StartCrawlerScheduleOutput,
        crate::error::StartCrawlerScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_crawler_schedule_error(response)
        } else {
            crate::operation_deser::parse_start_crawler_schedule_response(response)
        }
    }
}

/// Operation shape for `StartExportLabelsTaskRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_export_labels_task_run`](crate::client::Client::start_export_labels_task_run).
///
/// See [`crate::client::fluent_builders::StartExportLabelsTaskRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartExportLabelsTaskRun {
    _private: (),
}
impl StartExportLabelsTaskRun {
    /// Creates a new builder-style object to manufacture [`StartExportLabelsTaskRunInput`](crate::input::StartExportLabelsTaskRunInput)
    pub fn builder() -> crate::input::start_export_labels_task_run_input::Builder {
        crate::input::start_export_labels_task_run_input::Builder::default()
    }
    /// Creates a new `StartExportLabelsTaskRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartExportLabelsTaskRun {
    type Output = std::result::Result<
        crate::output::StartExportLabelsTaskRunOutput,
        crate::error::StartExportLabelsTaskRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_export_labels_task_run_error(response)
        } else {
            crate::operation_deser::parse_start_export_labels_task_run_response(response)
        }
    }
}

/// Operation shape for `StartImportLabelsTaskRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_import_labels_task_run`](crate::client::Client::start_import_labels_task_run).
///
/// See [`crate::client::fluent_builders::StartImportLabelsTaskRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartImportLabelsTaskRun {
    _private: (),
}
impl StartImportLabelsTaskRun {
    /// Creates a new builder-style object to manufacture [`StartImportLabelsTaskRunInput`](crate::input::StartImportLabelsTaskRunInput)
    pub fn builder() -> crate::input::start_import_labels_task_run_input::Builder {
        crate::input::start_import_labels_task_run_input::Builder::default()
    }
    /// Creates a new `StartImportLabelsTaskRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartImportLabelsTaskRun {
    type Output = std::result::Result<
        crate::output::StartImportLabelsTaskRunOutput,
        crate::error::StartImportLabelsTaskRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_import_labels_task_run_error(response)
        } else {
            crate::operation_deser::parse_start_import_labels_task_run_response(response)
        }
    }
}

/// Operation shape for `StartJobRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_job_run`](crate::client::Client::start_job_run).
///
/// See [`crate::client::fluent_builders::StartJobRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartJobRun {
    _private: (),
}
impl StartJobRun {
    /// Creates a new builder-style object to manufacture [`StartJobRunInput`](crate::input::StartJobRunInput)
    pub fn builder() -> crate::input::start_job_run_input::Builder {
        crate::input::start_job_run_input::Builder::default()
    }
    /// Creates a new `StartJobRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartJobRun {
    type Output =
        std::result::Result<crate::output::StartJobRunOutput, crate::error::StartJobRunError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_job_run_error(response)
        } else {
            crate::operation_deser::parse_start_job_run_response(response)
        }
    }
}

/// Operation shape for `StartMLEvaluationTaskRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_ml_evaluation_task_run`](crate::client::Client::start_ml_evaluation_task_run).
///
/// See [`crate::client::fluent_builders::StartMLEvaluationTaskRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMLEvaluationTaskRun {
    _private: (),
}
impl StartMLEvaluationTaskRun {
    /// Creates a new builder-style object to manufacture [`StartMlEvaluationTaskRunInput`](crate::input::StartMlEvaluationTaskRunInput)
    pub fn builder() -> crate::input::start_ml_evaluation_task_run_input::Builder {
        crate::input::start_ml_evaluation_task_run_input::Builder::default()
    }
    /// Creates a new `StartMLEvaluationTaskRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMLEvaluationTaskRun {
    type Output = std::result::Result<
        crate::output::StartMlEvaluationTaskRunOutput,
        crate::error::StartMLEvaluationTaskRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_ml_evaluation_task_run_error(response)
        } else {
            crate::operation_deser::parse_start_ml_evaluation_task_run_response(response)
        }
    }
}

/// Operation shape for `StartMLLabelingSetGenerationTaskRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_ml_labeling_set_generation_task_run`](crate::client::Client::start_ml_labeling_set_generation_task_run).
///
/// See [`crate::client::fluent_builders::StartMLLabelingSetGenerationTaskRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMLLabelingSetGenerationTaskRun {
    _private: (),
}
impl StartMLLabelingSetGenerationTaskRun {
    /// Creates a new builder-style object to manufacture [`StartMlLabelingSetGenerationTaskRunInput`](crate::input::StartMlLabelingSetGenerationTaskRunInput)
    pub fn builder() -> crate::input::start_ml_labeling_set_generation_task_run_input::Builder {
        crate::input::start_ml_labeling_set_generation_task_run_input::Builder::default()
    }
    /// Creates a new `StartMLLabelingSetGenerationTaskRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMLLabelingSetGenerationTaskRun {
    type Output = std::result::Result<
        crate::output::StartMlLabelingSetGenerationTaskRunOutput,
        crate::error::StartMLLabelingSetGenerationTaskRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_ml_labeling_set_generation_task_run_error(response)
        } else {
            crate::operation_deser::parse_start_ml_labeling_set_generation_task_run_response(
                response,
            )
        }
    }
}

/// Operation shape for `StartTrigger`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_trigger`](crate::client::Client::start_trigger).
///
/// See [`crate::client::fluent_builders::StartTrigger`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartTrigger {
    _private: (),
}
impl StartTrigger {
    /// Creates a new builder-style object to manufacture [`StartTriggerInput`](crate::input::StartTriggerInput)
    pub fn builder() -> crate::input::start_trigger_input::Builder {
        crate::input::start_trigger_input::Builder::default()
    }
    /// Creates a new `StartTrigger` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartTrigger {
    type Output =
        std::result::Result<crate::output::StartTriggerOutput, crate::error::StartTriggerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_trigger_error(response)
        } else {
            crate::operation_deser::parse_start_trigger_response(response)
        }
    }
}

/// Operation shape for `StartWorkflowRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_workflow_run`](crate::client::Client::start_workflow_run).
///
/// See [`crate::client::fluent_builders::StartWorkflowRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartWorkflowRun {
    _private: (),
}
impl StartWorkflowRun {
    /// Creates a new builder-style object to manufacture [`StartWorkflowRunInput`](crate::input::StartWorkflowRunInput)
    pub fn builder() -> crate::input::start_workflow_run_input::Builder {
        crate::input::start_workflow_run_input::Builder::default()
    }
    /// Creates a new `StartWorkflowRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartWorkflowRun {
    type Output = std::result::Result<
        crate::output::StartWorkflowRunOutput,
        crate::error::StartWorkflowRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_workflow_run_error(response)
        } else {
            crate::operation_deser::parse_start_workflow_run_response(response)
        }
    }
}

/// Operation shape for `StopCrawler`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_crawler`](crate::client::Client::stop_crawler).
///
/// See [`crate::client::fluent_builders::StopCrawler`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopCrawler {
    _private: (),
}
impl StopCrawler {
    /// Creates a new builder-style object to manufacture [`StopCrawlerInput`](crate::input::StopCrawlerInput)
    pub fn builder() -> crate::input::stop_crawler_input::Builder {
        crate::input::stop_crawler_input::Builder::default()
    }
    /// Creates a new `StopCrawler` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopCrawler {
    type Output =
        std::result::Result<crate::output::StopCrawlerOutput, crate::error::StopCrawlerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_crawler_error(response)
        } else {
            crate::operation_deser::parse_stop_crawler_response(response)
        }
    }
}

/// Operation shape for `StopCrawlerSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_crawler_schedule`](crate::client::Client::stop_crawler_schedule).
///
/// See [`crate::client::fluent_builders::StopCrawlerSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopCrawlerSchedule {
    _private: (),
}
impl StopCrawlerSchedule {
    /// Creates a new builder-style object to manufacture [`StopCrawlerScheduleInput`](crate::input::StopCrawlerScheduleInput)
    pub fn builder() -> crate::input::stop_crawler_schedule_input::Builder {
        crate::input::stop_crawler_schedule_input::Builder::default()
    }
    /// Creates a new `StopCrawlerSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopCrawlerSchedule {
    type Output = std::result::Result<
        crate::output::StopCrawlerScheduleOutput,
        crate::error::StopCrawlerScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_crawler_schedule_error(response)
        } else {
            crate::operation_deser::parse_stop_crawler_schedule_response(response)
        }
    }
}

/// Operation shape for `StopTrigger`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_trigger`](crate::client::Client::stop_trigger).
///
/// See [`crate::client::fluent_builders::StopTrigger`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopTrigger {
    _private: (),
}
impl StopTrigger {
    /// Creates a new builder-style object to manufacture [`StopTriggerInput`](crate::input::StopTriggerInput)
    pub fn builder() -> crate::input::stop_trigger_input::Builder {
        crate::input::stop_trigger_input::Builder::default()
    }
    /// Creates a new `StopTrigger` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopTrigger {
    type Output =
        std::result::Result<crate::output::StopTriggerOutput, crate::error::StopTriggerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_trigger_error(response)
        } else {
            crate::operation_deser::parse_stop_trigger_response(response)
        }
    }
}

/// Operation shape for `StopWorkflowRun`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_workflow_run`](crate::client::Client::stop_workflow_run).
///
/// See [`crate::client::fluent_builders::StopWorkflowRun`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopWorkflowRun {
    _private: (),
}
impl StopWorkflowRun {
    /// Creates a new builder-style object to manufacture [`StopWorkflowRunInput`](crate::input::StopWorkflowRunInput)
    pub fn builder() -> crate::input::stop_workflow_run_input::Builder {
        crate::input::stop_workflow_run_input::Builder::default()
    }
    /// Creates a new `StopWorkflowRun` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopWorkflowRun {
    type Output = std::result::Result<
        crate::output::StopWorkflowRunOutput,
        crate::error::StopWorkflowRunError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_workflow_run_error(response)
        } else {
            crate::operation_deser::parse_stop_workflow_run_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateBlueprint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_blueprint`](crate::client::Client::update_blueprint).
///
/// See [`crate::client::fluent_builders::UpdateBlueprint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBlueprint {
    _private: (),
}
impl UpdateBlueprint {
    /// Creates a new builder-style object to manufacture [`UpdateBlueprintInput`](crate::input::UpdateBlueprintInput)
    pub fn builder() -> crate::input::update_blueprint_input::Builder {
        crate::input::update_blueprint_input::Builder::default()
    }
    /// Creates a new `UpdateBlueprint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBlueprint {
    type Output = std::result::Result<
        crate::output::UpdateBlueprintOutput,
        crate::error::UpdateBlueprintError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_blueprint_error(response)
        } else {
            crate::operation_deser::parse_update_blueprint_response(response)
        }
    }
}

/// Operation shape for `UpdateClassifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_classifier`](crate::client::Client::update_classifier).
///
/// See [`crate::client::fluent_builders::UpdateClassifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateClassifier {
    _private: (),
}
impl UpdateClassifier {
    /// Creates a new builder-style object to manufacture [`UpdateClassifierInput`](crate::input::UpdateClassifierInput)
    pub fn builder() -> crate::input::update_classifier_input::Builder {
        crate::input::update_classifier_input::Builder::default()
    }
    /// Creates a new `UpdateClassifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateClassifier {
    type Output = std::result::Result<
        crate::output::UpdateClassifierOutput,
        crate::error::UpdateClassifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_classifier_error(response)
        } else {
            crate::operation_deser::parse_update_classifier_response(response)
        }
    }
}

/// Operation shape for `UpdateColumnStatisticsForPartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_column_statistics_for_partition`](crate::client::Client::update_column_statistics_for_partition).
///
/// See [`crate::client::fluent_builders::UpdateColumnStatisticsForPartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateColumnStatisticsForPartition {
    _private: (),
}
impl UpdateColumnStatisticsForPartition {
    /// Creates a new builder-style object to manufacture [`UpdateColumnStatisticsForPartitionInput`](crate::input::UpdateColumnStatisticsForPartitionInput)
    pub fn builder() -> crate::input::update_column_statistics_for_partition_input::Builder {
        crate::input::update_column_statistics_for_partition_input::Builder::default()
    }
    /// Creates a new `UpdateColumnStatisticsForPartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateColumnStatisticsForPartition {
    type Output = std::result::Result<
        crate::output::UpdateColumnStatisticsForPartitionOutput,
        crate::error::UpdateColumnStatisticsForPartitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_column_statistics_for_partition_error(response)
        } else {
            crate::operation_deser::parse_update_column_statistics_for_partition_response(response)
        }
    }
}

/// Operation shape for `UpdateColumnStatisticsForTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_column_statistics_for_table`](crate::client::Client::update_column_statistics_for_table).
///
/// See [`crate::client::fluent_builders::UpdateColumnStatisticsForTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateColumnStatisticsForTable {
    _private: (),
}
impl UpdateColumnStatisticsForTable {
    /// Creates a new builder-style object to manufacture [`UpdateColumnStatisticsForTableInput`](crate::input::UpdateColumnStatisticsForTableInput)
    pub fn builder() -> crate::input::update_column_statistics_for_table_input::Builder {
        crate::input::update_column_statistics_for_table_input::Builder::default()
    }
    /// Creates a new `UpdateColumnStatisticsForTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateColumnStatisticsForTable {
    type Output = std::result::Result<
        crate::output::UpdateColumnStatisticsForTableOutput,
        crate::error::UpdateColumnStatisticsForTableError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_column_statistics_for_table_error(response)
        } else {
            crate::operation_deser::parse_update_column_statistics_for_table_response(response)
        }
    }
}

/// Operation shape for `UpdateConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_connection`](crate::client::Client::update_connection).
///
/// See [`crate::client::fluent_builders::UpdateConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateConnection {
    _private: (),
}
impl UpdateConnection {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionInput`](crate::input::UpdateConnectionInput)
    pub fn builder() -> crate::input::update_connection_input::Builder {
        crate::input::update_connection_input::Builder::default()
    }
    /// Creates a new `UpdateConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateConnection {
    type Output = std::result::Result<
        crate::output::UpdateConnectionOutput,
        crate::error::UpdateConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_connection_error(response)
        } else {
            crate::operation_deser::parse_update_connection_response(response)
        }
    }
}

/// Operation shape for `UpdateCrawler`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_crawler`](crate::client::Client::update_crawler).
///
/// See [`crate::client::fluent_builders::UpdateCrawler`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCrawler {
    _private: (),
}
impl UpdateCrawler {
    /// Creates a new builder-style object to manufacture [`UpdateCrawlerInput`](crate::input::UpdateCrawlerInput)
    pub fn builder() -> crate::input::update_crawler_input::Builder {
        crate::input::update_crawler_input::Builder::default()
    }
    /// Creates a new `UpdateCrawler` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCrawler {
    type Output =
        std::result::Result<crate::output::UpdateCrawlerOutput, crate::error::UpdateCrawlerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_crawler_error(response)
        } else {
            crate::operation_deser::parse_update_crawler_response(response)
        }
    }
}

/// Operation shape for `UpdateCrawlerSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_crawler_schedule`](crate::client::Client::update_crawler_schedule).
///
/// See [`crate::client::fluent_builders::UpdateCrawlerSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCrawlerSchedule {
    _private: (),
}
impl UpdateCrawlerSchedule {
    /// Creates a new builder-style object to manufacture [`UpdateCrawlerScheduleInput`](crate::input::UpdateCrawlerScheduleInput)
    pub fn builder() -> crate::input::update_crawler_schedule_input::Builder {
        crate::input::update_crawler_schedule_input::Builder::default()
    }
    /// Creates a new `UpdateCrawlerSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCrawlerSchedule {
    type Output = std::result::Result<
        crate::output::UpdateCrawlerScheduleOutput,
        crate::error::UpdateCrawlerScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_crawler_schedule_error(response)
        } else {
            crate::operation_deser::parse_update_crawler_schedule_response(response)
        }
    }
}

/// Operation shape for `UpdateDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_database`](crate::client::Client::update_database).
///
/// See [`crate::client::fluent_builders::UpdateDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDatabase {
    _private: (),
}
impl UpdateDatabase {
    /// Creates a new builder-style object to manufacture [`UpdateDatabaseInput`](crate::input::UpdateDatabaseInput)
    pub fn builder() -> crate::input::update_database_input::Builder {
        crate::input::update_database_input::Builder::default()
    }
    /// Creates a new `UpdateDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDatabase {
    type Output =
        std::result::Result<crate::output::UpdateDatabaseOutput, crate::error::UpdateDatabaseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_database_error(response)
        } else {
            crate::operation_deser::parse_update_database_response(response)
        }
    }
}

/// Operation shape for `UpdateDevEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dev_endpoint`](crate::client::Client::update_dev_endpoint).
///
/// See [`crate::client::fluent_builders::UpdateDevEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDevEndpoint {
    _private: (),
}
impl UpdateDevEndpoint {
    /// Creates a new builder-style object to manufacture [`UpdateDevEndpointInput`](crate::input::UpdateDevEndpointInput)
    pub fn builder() -> crate::input::update_dev_endpoint_input::Builder {
        crate::input::update_dev_endpoint_input::Builder::default()
    }
    /// Creates a new `UpdateDevEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDevEndpoint {
    type Output = std::result::Result<
        crate::output::UpdateDevEndpointOutput,
        crate::error::UpdateDevEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dev_endpoint_error(response)
        } else {
            crate::operation_deser::parse_update_dev_endpoint_response(response)
        }
    }
}

/// Operation shape for `UpdateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_job`](crate::client::Client::update_job).
///
/// See [`crate::client::fluent_builders::UpdateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateJob {
    _private: (),
}
impl UpdateJob {
    /// Creates a new builder-style object to manufacture [`UpdateJobInput`](crate::input::UpdateJobInput)
    pub fn builder() -> crate::input::update_job_input::Builder {
        crate::input::update_job_input::Builder::default()
    }
    /// Creates a new `UpdateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateJob {
    type Output = std::result::Result<crate::output::UpdateJobOutput, crate::error::UpdateJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_job_error(response)
        } else {
            crate::operation_deser::parse_update_job_response(response)
        }
    }
}

/// Operation shape for `UpdateMLTransform`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_ml_transform`](crate::client::Client::update_ml_transform).
///
/// See [`crate::client::fluent_builders::UpdateMLTransform`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMLTransform {
    _private: (),
}
impl UpdateMLTransform {
    /// Creates a new builder-style object to manufacture [`UpdateMlTransformInput`](crate::input::UpdateMlTransformInput)
    pub fn builder() -> crate::input::update_ml_transform_input::Builder {
        crate::input::update_ml_transform_input::Builder::default()
    }
    /// Creates a new `UpdateMLTransform` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMLTransform {
    type Output = std::result::Result<
        crate::output::UpdateMlTransformOutput,
        crate::error::UpdateMLTransformError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_ml_transform_error(response)
        } else {
            crate::operation_deser::parse_update_ml_transform_response(response)
        }
    }
}

/// Operation shape for `UpdatePartition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_partition`](crate::client::Client::update_partition).
///
/// See [`crate::client::fluent_builders::UpdatePartition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePartition {
    _private: (),
}
impl UpdatePartition {
    /// Creates a new builder-style object to manufacture [`UpdatePartitionInput`](crate::input::UpdatePartitionInput)
    pub fn builder() -> crate::input::update_partition_input::Builder {
        crate::input::update_partition_input::Builder::default()
    }
    /// Creates a new `UpdatePartition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePartition {
    type Output = std::result::Result<
        crate::output::UpdatePartitionOutput,
        crate::error::UpdatePartitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_partition_error(response)
        } else {
            crate::operation_deser::parse_update_partition_response(response)
        }
    }
}

/// Operation shape for `UpdateRegistry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_registry`](crate::client::Client::update_registry).
///
/// See [`crate::client::fluent_builders::UpdateRegistry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRegistry {
    _private: (),
}
impl UpdateRegistry {
    /// Creates a new builder-style object to manufacture [`UpdateRegistryInput`](crate::input::UpdateRegistryInput)
    pub fn builder() -> crate::input::update_registry_input::Builder {
        crate::input::update_registry_input::Builder::default()
    }
    /// Creates a new `UpdateRegistry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRegistry {
    type Output =
        std::result::Result<crate::output::UpdateRegistryOutput, crate::error::UpdateRegistryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_registry_error(response)
        } else {
            crate::operation_deser::parse_update_registry_response(response)
        }
    }
}

/// Operation shape for `UpdateSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_schema`](crate::client::Client::update_schema).
///
/// See [`crate::client::fluent_builders::UpdateSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSchema {
    _private: (),
}
impl UpdateSchema {
    /// Creates a new builder-style object to manufacture [`UpdateSchemaInput`](crate::input::UpdateSchemaInput)
    pub fn builder() -> crate::input::update_schema_input::Builder {
        crate::input::update_schema_input::Builder::default()
    }
    /// Creates a new `UpdateSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSchema {
    type Output =
        std::result::Result<crate::output::UpdateSchemaOutput, crate::error::UpdateSchemaError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_schema_error(response)
        } else {
            crate::operation_deser::parse_update_schema_response(response)
        }
    }
}

/// Operation shape for `UpdateTable`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_table`](crate::client::Client::update_table).
///
/// See [`crate::client::fluent_builders::UpdateTable`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTable {
    _private: (),
}
impl UpdateTable {
    /// Creates a new builder-style object to manufacture [`UpdateTableInput`](crate::input::UpdateTableInput)
    pub fn builder() -> crate::input::update_table_input::Builder {
        crate::input::update_table_input::Builder::default()
    }
    /// Creates a new `UpdateTable` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTable {
    type Output =
        std::result::Result<crate::output::UpdateTableOutput, crate::error::UpdateTableError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_table_error(response)
        } else {
            crate::operation_deser::parse_update_table_response(response)
        }
    }
}

/// Operation shape for `UpdateTrigger`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_trigger`](crate::client::Client::update_trigger).
///
/// See [`crate::client::fluent_builders::UpdateTrigger`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTrigger {
    _private: (),
}
impl UpdateTrigger {
    /// Creates a new builder-style object to manufacture [`UpdateTriggerInput`](crate::input::UpdateTriggerInput)
    pub fn builder() -> crate::input::update_trigger_input::Builder {
        crate::input::update_trigger_input::Builder::default()
    }
    /// Creates a new `UpdateTrigger` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTrigger {
    type Output =
        std::result::Result<crate::output::UpdateTriggerOutput, crate::error::UpdateTriggerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_trigger_error(response)
        } else {
            crate::operation_deser::parse_update_trigger_response(response)
        }
    }
}

/// Operation shape for `UpdateUserDefinedFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_defined_function`](crate::client::Client::update_user_defined_function).
///
/// See [`crate::client::fluent_builders::UpdateUserDefinedFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserDefinedFunction {
    _private: (),
}
impl UpdateUserDefinedFunction {
    /// Creates a new builder-style object to manufacture [`UpdateUserDefinedFunctionInput`](crate::input::UpdateUserDefinedFunctionInput)
    pub fn builder() -> crate::input::update_user_defined_function_input::Builder {
        crate::input::update_user_defined_function_input::Builder::default()
    }
    /// Creates a new `UpdateUserDefinedFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserDefinedFunction {
    type Output = std::result::Result<
        crate::output::UpdateUserDefinedFunctionOutput,
        crate::error::UpdateUserDefinedFunctionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_defined_function_error(response)
        } else {
            crate::operation_deser::parse_update_user_defined_function_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkflow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_workflow`](crate::client::Client::update_workflow).
///
/// See [`crate::client::fluent_builders::UpdateWorkflow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkflow {
    _private: (),
}
impl UpdateWorkflow {
    /// Creates a new builder-style object to manufacture [`UpdateWorkflowInput`](crate::input::UpdateWorkflowInput)
    pub fn builder() -> crate::input::update_workflow_input::Builder {
        crate::input::update_workflow_input::Builder::default()
    }
    /// Creates a new `UpdateWorkflow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkflow {
    type Output =
        std::result::Result<crate::output::UpdateWorkflowOutput, crate::error::UpdateWorkflowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_workflow_error(response)
        } else {
            crate::operation_deser::parse_update_workflow_response(response)
        }
    }
}
