// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Access to a resource was denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A resource to be created or added already exists.</p>
    AlreadyExistsException(crate::error::AlreadyExistsException),
    /// <p>Two processes are trying to modify a resource simultaneously.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Too many jobs are being run concurrently.</p>
    ConcurrentRunsExceededException(crate::error::ConcurrentRunsExceededException),
    /// <p>A specified condition was not satisfied.</p>
    ConditionCheckFailureException(crate::error::ConditionCheckFailureException),
    /// <p>The <code>CreatePartitions</code> API was called on a table that has indexes enabled.  </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The specified crawler is not running.</p>
    CrawlerNotRunningException(crate::error::CrawlerNotRunningException),
    /// <p>The operation cannot be performed because the crawler is already running.</p>
    CrawlerRunningException(crate::error::CrawlerRunningException),
    /// <p>The specified crawler is stopping.</p>
    CrawlerStoppingException(crate::error::CrawlerStoppingException),
    /// <p>A specified entity does not exist</p>
    EntityNotFoundException(crate::error::EntityNotFoundException),
    /// <p>An encryption operation failed.</p>
    GlueEncryptionException(crate::error::GlueEncryptionException),
    /// <p>The same unique identifier was associated with two different records.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    #[allow(missing_docs)] // documentation missing in model
    IllegalBlueprintStateException(crate::error::IllegalBlueprintStateException),
    /// <p>The workflow is in an invalid state to perform a requested operation.</p>
    IllegalWorkflowStateException(crate::error::IllegalWorkflowStateException),
    /// <p>An internal service error occurred.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The input provided was not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The machine learning transform is not ready to run.</p>
    MlTransformNotReadyException(crate::error::MlTransformNotReadyException),
    /// <p>There is no applicable schedule.</p>
    NoScheduleException(crate::error::NoScheduleException),
    /// <p>The operation timed out.</p>
    OperationTimeoutException(crate::error::OperationTimeoutException),
    /// <p>A resource numerical limit was exceeded.</p>
    ResourceNumberLimitExceededException(crate::error::ResourceNumberLimitExceededException),
    /// <p>The specified scheduler is not running.</p>
    SchedulerNotRunningException(crate::error::SchedulerNotRunningException),
    /// <p>The specified scheduler is already running.</p>
    SchedulerRunningException(crate::error::SchedulerRunningException),
    /// <p>The specified scheduler is transitioning.</p>
    SchedulerTransitioningException(crate::error::SchedulerTransitioningException),
    /// <p>A value could not be validated.</p>
    ValidationException(crate::error::ValidationException),
    /// <p>There was a version conflict.</p>
    VersionMismatchException(crate::error::VersionMismatchException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::AlreadyExistsException(inner) => inner.fmt(f),
            Error::ConcurrentModificationException(inner) => inner.fmt(f),
            Error::ConcurrentRunsExceededException(inner) => inner.fmt(f),
            Error::ConditionCheckFailureException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::CrawlerNotRunningException(inner) => inner.fmt(f),
            Error::CrawlerRunningException(inner) => inner.fmt(f),
            Error::CrawlerStoppingException(inner) => inner.fmt(f),
            Error::EntityNotFoundException(inner) => inner.fmt(f),
            Error::GlueEncryptionException(inner) => inner.fmt(f),
            Error::IdempotentParameterMismatchException(inner) => inner.fmt(f),
            Error::IllegalBlueprintStateException(inner) => inner.fmt(f),
            Error::IllegalWorkflowStateException(inner) => inner.fmt(f),
            Error::InternalServiceException(inner) => inner.fmt(f),
            Error::InvalidInputException(inner) => inner.fmt(f),
            Error::MlTransformNotReadyException(inner) => inner.fmt(f),
            Error::NoScheduleException(inner) => inner.fmt(f),
            Error::OperationTimeoutException(inner) => inner.fmt(f),
            Error::ResourceNumberLimitExceededException(inner) => inner.fmt(f),
            Error::SchedulerNotRunningException(inner) => inner.fmt(f),
            Error::SchedulerRunningException(inner) => inner.fmt(f),
            Error::SchedulerTransitioningException(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::VersionMismatchException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchCreatePartitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchCreatePartitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchCreatePartitionErrorKind::AlreadyExistsException(inner) => Error::AlreadyExistsException(inner),
                crate::error::BatchCreatePartitionErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::BatchCreatePartitionErrorKind::GlueEncryptionException(inner) => Error::GlueEncryptionException(inner),
                crate::error::BatchCreatePartitionErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::BatchCreatePartitionErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::BatchCreatePartitionErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::BatchCreatePartitionErrorKind::ResourceNumberLimitExceededException(inner) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::BatchCreatePartitionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDeleteConnectionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDeleteConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchDeleteConnectionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchDeleteConnectionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchDeleteConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDeletePartitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDeletePartitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchDeletePartitionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::BatchDeletePartitionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchDeletePartitionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchDeletePartitionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchDeletePartitionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDeleteTableError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDeleteTableError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchDeleteTableErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::BatchDeleteTableErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchDeleteTableErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchDeleteTableErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchDeleteTableErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDeleteTableVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDeleteTableVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchDeleteTableVersionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::BatchDeleteTableVersionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchDeleteTableVersionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchDeleteTableVersionErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::BatchDeleteTableVersionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetBlueprintsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetBlueprintsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchGetBlueprintsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchGetBlueprintsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchGetBlueprintsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchGetBlueprintsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetCrawlersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetCrawlersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchGetCrawlersErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchGetCrawlersErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchGetCrawlersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetDevEndpointsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetDevEndpointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchGetDevEndpointsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::BatchGetDevEndpointsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchGetDevEndpointsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchGetDevEndpointsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchGetDevEndpointsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetJobsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::BatchGetJobsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchGetJobsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchGetJobsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchGetJobsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchGetJobsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetPartitionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetPartitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchGetPartitionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::BatchGetPartitionErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::BatchGetPartitionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchGetPartitionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchGetPartitionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchGetPartitionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetTriggersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetTriggersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchGetTriggersErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchGetTriggersErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchGetTriggersErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchGetTriggersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetWorkflowsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetWorkflowsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchGetWorkflowsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchGetWorkflowsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchGetWorkflowsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchGetWorkflowsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchStopJobRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::BatchStopJobRunError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchStopJobRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchStopJobRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchStopJobRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchStopJobRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchUpdatePartitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchUpdatePartitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchUpdatePartitionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::BatchUpdatePartitionErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::BatchUpdatePartitionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::BatchUpdatePartitionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::BatchUpdatePartitionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::BatchUpdatePartitionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelMLTaskRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CancelMLTaskRunError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelMLTaskRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::CancelMLTaskRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CancelMLTaskRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CancelMLTaskRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CancelMLTaskRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CheckSchemaVersionValidityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CheckSchemaVersionValidityError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CheckSchemaVersionValidityErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CheckSchemaVersionValidityErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::CheckSchemaVersionValidityErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CheckSchemaVersionValidityErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateBlueprintError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateBlueprintError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateBlueprintErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateBlueprintErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateBlueprintErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateBlueprintErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateBlueprintErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateBlueprintErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateClassifierError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateClassifierError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateClassifierErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateClassifierErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateClassifierErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateClassifierErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateConnectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateConnectionErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateConnectionErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::CreateConnectionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateConnectionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateConnectionErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCrawlerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateCrawlerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateCrawlerErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateCrawlerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateCrawlerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateCrawlerErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateCrawlerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDatabaseError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDatabaseError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDatabaseErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateDatabaseErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::CreateDatabaseErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::CreateDatabaseErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateDatabaseErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateDatabaseErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateDatabaseErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateDatabaseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDevEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDevEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDevEndpointErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateDevEndpointErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateDevEndpointErrorKind::IdempotentParameterMismatchException(
                    inner,
                ) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CreateDevEndpointErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateDevEndpointErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateDevEndpointErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateDevEndpointErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateDevEndpointErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreateDevEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateJobError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateJobError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateJobErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateJobErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::CreateJobErrorKind::IdempotentParameterMismatchException(inner) => {
                    Error::IdempotentParameterMismatchException(inner)
                }
                crate::error::CreateJobErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateJobErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateJobErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateJobErrorKind::ResourceNumberLimitExceededException(inner) => {
                    Error::ResourceNumberLimitExceededException(inner)
                }
                crate::error::CreateJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateMLTransformError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateMLTransformError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateMLTransformErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateMLTransformErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateMLTransformErrorKind::IdempotentParameterMismatchException(
                    inner,
                ) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CreateMLTransformErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateMLTransformErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateMLTransformErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateMLTransformErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateMLTransformErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePartitionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreatePartitionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreatePartitionErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreatePartitionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::CreatePartitionErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::CreatePartitionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreatePartitionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreatePartitionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreatePartitionErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreatePartitionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePartitionIndexError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreatePartitionIndexError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreatePartitionIndexErrorKind::AlreadyExistsException(inner) => Error::AlreadyExistsException(inner),
                crate::error::CreatePartitionIndexErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::CreatePartitionIndexErrorKind::GlueEncryptionException(inner) => Error::GlueEncryptionException(inner),
                crate::error::CreatePartitionIndexErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::CreatePartitionIndexErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreatePartitionIndexErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::CreatePartitionIndexErrorKind::ResourceNumberLimitExceededException(inner) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreatePartitionIndexErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateRegistryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateRegistryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateRegistryErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateRegistryErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateRegistryErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateRegistryErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateRegistryErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateRegistryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateSchemaError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateSchemaError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateSchemaErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateSchemaErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateSchemaErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::CreateSchemaErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateSchemaErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateSchemaErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateSchemaErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateScriptError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateScriptError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateScriptErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateScriptErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateScriptErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateScriptErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateSecurityConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateSecurityConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateSecurityConfigurationErrorKind::AlreadyExistsException(inner) => Error::AlreadyExistsException(inner),
                crate::error::CreateSecurityConfigurationErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::CreateSecurityConfigurationErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateSecurityConfigurationErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::CreateSecurityConfigurationErrorKind::ResourceNumberLimitExceededException(inner) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateSecurityConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTableError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTableError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTableErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateTableErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::CreateTableErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::CreateTableErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::CreateTableErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateTableErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateTableErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateTableErrorKind::ResourceNumberLimitExceededException(inner) => {
                    Error::ResourceNumberLimitExceededException(inner)
                }
                crate::error::CreateTableErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTriggerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTriggerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTriggerErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateTriggerErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::CreateTriggerErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::CreateTriggerErrorKind::IdempotentParameterMismatchException(
                    inner,
                ) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CreateTriggerErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateTriggerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateTriggerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateTriggerErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateTriggerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateUserDefinedFunctionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateUserDefinedFunctionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateUserDefinedFunctionErrorKind::AlreadyExistsException(inner) => Error::AlreadyExistsException(inner),
                crate::error::CreateUserDefinedFunctionErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::CreateUserDefinedFunctionErrorKind::GlueEncryptionException(inner) => Error::GlueEncryptionException(inner),
                crate::error::CreateUserDefinedFunctionErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::CreateUserDefinedFunctionErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateUserDefinedFunctionErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::CreateUserDefinedFunctionErrorKind::ResourceNumberLimitExceededException(inner) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateUserDefinedFunctionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateWorkflowError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateWorkflowError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateWorkflowErrorKind::AlreadyExistsException(inner) => {
                    Error::AlreadyExistsException(inner)
                }
                crate::error::CreateWorkflowErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::CreateWorkflowErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::CreateWorkflowErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateWorkflowErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::CreateWorkflowErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::CreateWorkflowErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteBlueprintError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteBlueprintError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteBlueprintErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteBlueprintErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteBlueprintErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteBlueprintErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteClassifierError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteClassifierError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteClassifierErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteClassifierErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteClassifierErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DeleteColumnStatisticsForPartitionError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteColumnStatisticsForPartitionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteColumnStatisticsForPartitionErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::DeleteColumnStatisticsForPartitionErrorKind::GlueEncryptionException(inner) => Error::GlueEncryptionException(inner),
                crate::error::DeleteColumnStatisticsForPartitionErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::DeleteColumnStatisticsForPartitionErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DeleteColumnStatisticsForPartitionErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::DeleteColumnStatisticsForPartitionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteColumnStatisticsForTableError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteColumnStatisticsForTableError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteColumnStatisticsForTableErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::DeleteColumnStatisticsForTableErrorKind::GlueEncryptionException(inner) => Error::GlueEncryptionException(inner),
                crate::error::DeleteColumnStatisticsForTableErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::DeleteColumnStatisticsForTableErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DeleteColumnStatisticsForTableErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::DeleteColumnStatisticsForTableErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteConnectionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteConnectionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCrawlerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteCrawlerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCrawlerErrorKind::CrawlerRunningException(inner) => {
                    Error::CrawlerRunningException(inner)
                }
                crate::error::DeleteCrawlerErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteCrawlerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteCrawlerErrorKind::SchedulerTransitioningException(inner) => {
                    Error::SchedulerTransitioningException(inner)
                }
                crate::error::DeleteCrawlerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDatabaseError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDatabaseError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDatabaseErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeleteDatabaseErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteDatabaseErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteDatabaseErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteDatabaseErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteDatabaseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDevEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDevEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDevEndpointErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteDevEndpointErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteDevEndpointErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteDevEndpointErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteDevEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteJobError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteJobError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteJobErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteJobErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteJobErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteMLTransformError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteMLTransformError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteMLTransformErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteMLTransformErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteMLTransformErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteMLTransformErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteMLTransformErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePartitionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeletePartitionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePartitionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeletePartitionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeletePartitionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeletePartitionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeletePartitionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePartitionIndexError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeletePartitionIndexError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePartitionIndexErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeletePartitionIndexErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeletePartitionIndexErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::DeletePartitionIndexErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeletePartitionIndexErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeletePartitionIndexErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeletePartitionIndexErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteRegistryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteRegistryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteRegistryErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteRegistryErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeleteRegistryErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteRegistryErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteRegistryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteResourcePolicyErrorKind::ConditionCheckFailureException(
                    inner,
                ) => Error::ConditionCheckFailureException(inner),
                crate::error::DeleteResourcePolicyErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteResourcePolicyErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteResourcePolicyErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteResourcePolicyErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteResourcePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteSchemaError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteSchemaError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteSchemaErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteSchemaErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeleteSchemaErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteSchemaErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteSchemaErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteSchemaVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteSchemaVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteSchemaVersionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteSchemaVersionsErrorKind::ConcurrentModificationException(
                    inner,
                ) => Error::ConcurrentModificationException(inner),
                crate::error::DeleteSchemaVersionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteSchemaVersionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteSchemaVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteSecurityConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteSecurityConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteSecurityConfigurationErrorKind::EntityNotFoundException(
                    inner,
                ) => Error::EntityNotFoundException(inner),
                crate::error::DeleteSecurityConfigurationErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::DeleteSecurityConfigurationErrorKind::InvalidInputException(
                    inner,
                ) => Error::InvalidInputException(inner),
                crate::error::DeleteSecurityConfigurationErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::DeleteSecurityConfigurationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTableError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTableError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTableErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeleteTableErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteTableErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteTableErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteTableErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteTableErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTableVersionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteTableVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTableVersionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::DeleteTableVersionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteTableVersionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteTableVersionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteTableVersionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTriggerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTriggerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTriggerErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeleteTriggerErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteTriggerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteTriggerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteTriggerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteUserDefinedFunctionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteUserDefinedFunctionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteUserDefinedFunctionErrorKind::EntityNotFoundException(
                    inner,
                ) => Error::EntityNotFoundException(inner),
                crate::error::DeleteUserDefinedFunctionErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::DeleteUserDefinedFunctionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteUserDefinedFunctionErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::DeleteUserDefinedFunctionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteWorkflowError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteWorkflowError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteWorkflowErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::DeleteWorkflowErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::DeleteWorkflowErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteWorkflowErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::DeleteWorkflowErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBlueprintError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetBlueprintError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBlueprintErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetBlueprintErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetBlueprintErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetBlueprintErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetBlueprintErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBlueprintRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetBlueprintRunError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBlueprintRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetBlueprintRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetBlueprintRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetBlueprintRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBlueprintRunsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetBlueprintRunsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBlueprintRunsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetBlueprintRunsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetBlueprintRunsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetBlueprintRunsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetBlueprintRunsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCatalogImportStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCatalogImportStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCatalogImportStatusErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetCatalogImportStatusErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetCatalogImportStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetClassifierError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetClassifierError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetClassifierErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetClassifierErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetClassifierErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetClassifiersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetClassifiersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetClassifiersErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetClassifiersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetColumnStatisticsForPartitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetColumnStatisticsForPartitionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetColumnStatisticsForPartitionErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::GetColumnStatisticsForPartitionErrorKind::GlueEncryptionException(inner) => Error::GlueEncryptionException(inner),
                crate::error::GetColumnStatisticsForPartitionErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::GetColumnStatisticsForPartitionErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetColumnStatisticsForPartitionErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::GetColumnStatisticsForPartitionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetColumnStatisticsForTableError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetColumnStatisticsForTableError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetColumnStatisticsForTableErrorKind::EntityNotFoundException(
                    inner,
                ) => Error::EntityNotFoundException(inner),
                crate::error::GetColumnStatisticsForTableErrorKind::GlueEncryptionException(
                    inner,
                ) => Error::GlueEncryptionException(inner),
                crate::error::GetColumnStatisticsForTableErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::GetColumnStatisticsForTableErrorKind::InvalidInputException(
                    inner,
                ) => Error::InvalidInputException(inner),
                crate::error::GetColumnStatisticsForTableErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::GetColumnStatisticsForTableErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetConnectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetConnectionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetConnectionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetConnectionErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetConnectionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetConnectionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetConnectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetConnectionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetConnectionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetConnectionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetConnectionsErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetConnectionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetConnectionsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetConnectionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCrawlerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetCrawlerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCrawlerErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetCrawlerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetCrawlerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCrawlerMetricsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCrawlerMetricsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCrawlerMetricsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetCrawlerMetricsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCrawlersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetCrawlersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCrawlersErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetCrawlersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDatabaseError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDatabaseError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDatabaseErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetDatabaseErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetDatabaseErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetDatabaseErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDatabaseErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetDatabaseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDatabasesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDatabasesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDatabasesErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetDatabasesErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetDatabasesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDatabasesErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetDatabasesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetDataCatalogEncryptionSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetDataCatalogEncryptionSettingsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetDataCatalogEncryptionSettingsErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::GetDataCatalogEncryptionSettingsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetDataCatalogEncryptionSettingsErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::GetDataCatalogEncryptionSettingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDataflowGraphError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDataflowGraphError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDataflowGraphErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetDataflowGraphErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDataflowGraphErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetDataflowGraphErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDevEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDevEndpointError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDevEndpointErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetDevEndpointErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetDevEndpointErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDevEndpointErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetDevEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDevEndpointsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDevEndpointsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDevEndpointsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetDevEndpointsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetDevEndpointsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDevEndpointsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetDevEndpointsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetJobError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetJobError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetJobErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetJobErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetJobErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetJobErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetJobBookmarkError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetJobBookmarkError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetJobBookmarkErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetJobBookmarkErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetJobBookmarkErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetJobBookmarkErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetJobBookmarkErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetJobBookmarkErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetJobRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetJobRunError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetJobRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetJobRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetJobRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetJobRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetJobRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetJobRunsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetJobRunsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetJobRunsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetJobRunsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetJobRunsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetJobRunsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetJobRunsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetJobsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetJobsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetJobsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetJobsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetJobsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetJobsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetJobsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMappingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetMappingError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMappingErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetMappingErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetMappingErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetMappingErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetMappingErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMLTaskRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetMLTaskRunError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMLTaskRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetMLTaskRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetMLTaskRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetMLTaskRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetMLTaskRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMLTaskRunsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetMLTaskRunsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMLTaskRunsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetMLTaskRunsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetMLTaskRunsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetMLTaskRunsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetMLTaskRunsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMLTransformError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetMLTransformError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMLTransformErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetMLTransformErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetMLTransformErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetMLTransformErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetMLTransformErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMLTransformsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetMLTransformsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetMLTransformsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetMLTransformsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetMLTransformsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetMLTransformsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetMLTransformsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPartitionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetPartitionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPartitionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetPartitionErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetPartitionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetPartitionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetPartitionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetPartitionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPartitionIndexesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPartitionIndexesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPartitionIndexesErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::GetPartitionIndexesErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetPartitionIndexesErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetPartitionIndexesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetPartitionIndexesErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetPartitionIndexesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPartitionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetPartitionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPartitionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetPartitionsErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetPartitionsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetPartitionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetPartitionsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetPartitionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPlanError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetPlanError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPlanErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetPlanErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetPlanErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetPlanErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRegistryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetRegistryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetRegistryErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetRegistryErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetRegistryErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetRegistryErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetRegistryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResourcePoliciesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResourcePoliciesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResourcePoliciesErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetResourcePoliciesErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetResourcePoliciesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetResourcePoliciesErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetResourcePoliciesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResourcePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResourcePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResourcePolicyErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetResourcePolicyErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetResourcePolicyErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetResourcePolicyErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetResourcePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSchemaError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetSchemaError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetSchemaErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetSchemaErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetSchemaErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetSchemaErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetSchemaErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSchemaByDefinitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSchemaByDefinitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetSchemaByDefinitionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetSchemaByDefinitionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetSchemaByDefinitionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetSchemaByDefinitionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetSchemaByDefinitionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSchemaVersionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSchemaVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetSchemaVersionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetSchemaVersionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetSchemaVersionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetSchemaVersionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetSchemaVersionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSchemaVersionsDiffError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSchemaVersionsDiffError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetSchemaVersionsDiffErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetSchemaVersionsDiffErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetSchemaVersionsDiffErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetSchemaVersionsDiffErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetSchemaVersionsDiffErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSecurityConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSecurityConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetSecurityConfigurationErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetSecurityConfigurationErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::GetSecurityConfigurationErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetSecurityConfigurationErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::GetSecurityConfigurationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSecurityConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSecurityConfigurationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetSecurityConfigurationsErrorKind::EntityNotFoundException(
                    inner,
                ) => Error::EntityNotFoundException(inner),
                crate::error::GetSecurityConfigurationsErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::GetSecurityConfigurationsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetSecurityConfigurationsErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::GetSecurityConfigurationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTableError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetTableError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTableErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetTableErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetTableErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetTableErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetTableErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetTableErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTablesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetTablesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTablesErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetTablesErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetTablesErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetTablesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetTablesErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetTablesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTableVersionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetTableVersionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTableVersionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetTableVersionErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetTableVersionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetTableVersionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetTableVersionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetTableVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTableVersionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetTableVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTableVersionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetTableVersionsErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetTableVersionsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetTableVersionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetTableVersionsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetTableVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTagsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetTagsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetTagsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetTagsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTriggerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetTriggerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTriggerErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetTriggerErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetTriggerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetTriggerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetTriggerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTriggersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetTriggersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTriggersErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetTriggersErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetTriggersErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetTriggersErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetTriggersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetUserDefinedFunctionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetUserDefinedFunctionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetUserDefinedFunctionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetUserDefinedFunctionErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetUserDefinedFunctionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetUserDefinedFunctionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetUserDefinedFunctionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetUserDefinedFunctionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetUserDefinedFunctionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetUserDefinedFunctionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetUserDefinedFunctionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetUserDefinedFunctionsErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::GetUserDefinedFunctionsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetUserDefinedFunctionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetUserDefinedFunctionsErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::GetUserDefinedFunctionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetWorkflowError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetWorkflowError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetWorkflowErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetWorkflowErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetWorkflowErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetWorkflowErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetWorkflowErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetWorkflowRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetWorkflowRunError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetWorkflowRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetWorkflowRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetWorkflowRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetWorkflowRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetWorkflowRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetWorkflowRunPropertiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetWorkflowRunPropertiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetWorkflowRunPropertiesErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetWorkflowRunPropertiesErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::GetWorkflowRunPropertiesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetWorkflowRunPropertiesErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::GetWorkflowRunPropertiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetWorkflowRunsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetWorkflowRunsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetWorkflowRunsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::GetWorkflowRunsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::GetWorkflowRunsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetWorkflowRunsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::GetWorkflowRunsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportCatalogToGlueError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ImportCatalogToGlueError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportCatalogToGlueErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ImportCatalogToGlueErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ImportCatalogToGlueErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListBlueprintsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListBlueprintsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListBlueprintsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListBlueprintsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListBlueprintsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListBlueprintsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCrawlersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListCrawlersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListCrawlersErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListCrawlersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDevEndpointsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDevEndpointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDevEndpointsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListDevEndpointsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListDevEndpointsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListDevEndpointsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListDevEndpointsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListJobsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListJobsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListJobsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListJobsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListJobsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListJobsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListJobsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListMLTransformsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListMLTransformsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListMLTransformsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListMLTransformsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListMLTransformsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListMLTransformsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListMLTransformsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListRegistriesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListRegistriesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListRegistriesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListRegistriesErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListRegistriesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListRegistriesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListSchemasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListSchemasError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListSchemasErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListSchemasErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListSchemasErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListSchemasErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListSchemasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListSchemaVersionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListSchemaVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListSchemaVersionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListSchemaVersionsErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListSchemaVersionsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListSchemaVersionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListSchemaVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTriggersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTriggersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTriggersErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ListTriggersErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListTriggersErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListTriggersErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListTriggersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListWorkflowsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListWorkflowsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListWorkflowsErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ListWorkflowsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ListWorkflowsErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ListWorkflowsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::PutDataCatalogEncryptionSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::PutDataCatalogEncryptionSettingsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutDataCatalogEncryptionSettingsErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::PutDataCatalogEncryptionSettingsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::PutDataCatalogEncryptionSettingsErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::PutDataCatalogEncryptionSettingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutResourcePolicyErrorKind::ConditionCheckFailureException(inner) => {
                    Error::ConditionCheckFailureException(inner)
                }
                crate::error::PutResourcePolicyErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::PutResourcePolicyErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::PutResourcePolicyErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::PutResourcePolicyErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::PutResourcePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutSchemaVersionMetadataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutSchemaVersionMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutSchemaVersionMetadataErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::PutSchemaVersionMetadataErrorKind::AlreadyExistsException(inner) => Error::AlreadyExistsException(inner),
                crate::error::PutSchemaVersionMetadataErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::PutSchemaVersionMetadataErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::PutSchemaVersionMetadataErrorKind::ResourceNumberLimitExceededException(inner) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::PutSchemaVersionMetadataErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutWorkflowRunPropertiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutWorkflowRunPropertiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutWorkflowRunPropertiesErrorKind::AlreadyExistsException(inner) => Error::AlreadyExistsException(inner),
                crate::error::PutWorkflowRunPropertiesErrorKind::ConcurrentModificationException(inner) => Error::ConcurrentModificationException(inner),
                crate::error::PutWorkflowRunPropertiesErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::PutWorkflowRunPropertiesErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::PutWorkflowRunPropertiesErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::PutWorkflowRunPropertiesErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::PutWorkflowRunPropertiesErrorKind::ResourceNumberLimitExceededException(inner) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::PutWorkflowRunPropertiesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::QuerySchemaVersionMetadataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::QuerySchemaVersionMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::QuerySchemaVersionMetadataErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::QuerySchemaVersionMetadataErrorKind::EntityNotFoundException(
                    inner,
                ) => Error::EntityNotFoundException(inner),
                crate::error::QuerySchemaVersionMetadataErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::QuerySchemaVersionMetadataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterSchemaVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterSchemaVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterSchemaVersionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::RegisterSchemaVersionErrorKind::ConcurrentModificationException(inner) => Error::ConcurrentModificationException(inner),
                crate::error::RegisterSchemaVersionErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::RegisterSchemaVersionErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::RegisterSchemaVersionErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::RegisterSchemaVersionErrorKind::ResourceNumberLimitExceededException(inner) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::RegisterSchemaVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveSchemaVersionMetadataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveSchemaVersionMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveSchemaVersionMetadataErrorKind::AccessDeniedException(
                    inner,
                ) => Error::AccessDeniedException(inner),
                crate::error::RemoveSchemaVersionMetadataErrorKind::EntityNotFoundException(
                    inner,
                ) => Error::EntityNotFoundException(inner),
                crate::error::RemoveSchemaVersionMetadataErrorKind::InvalidInputException(
                    inner,
                ) => Error::InvalidInputException(inner),
                crate::error::RemoveSchemaVersionMetadataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetJobBookmarkError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetJobBookmarkError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResetJobBookmarkErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ResetJobBookmarkErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ResetJobBookmarkErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ResetJobBookmarkErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ResetJobBookmarkErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResumeWorkflowRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResumeWorkflowRunError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResumeWorkflowRunErrorKind::ConcurrentRunsExceededException(
                    inner,
                ) => Error::ConcurrentRunsExceededException(inner),
                crate::error::ResumeWorkflowRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::ResumeWorkflowRunErrorKind::IllegalWorkflowStateException(inner) => {
                    Error::IllegalWorkflowStateException(inner)
                }
                crate::error::ResumeWorkflowRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::ResumeWorkflowRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ResumeWorkflowRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::ResumeWorkflowRunErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SearchTablesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::SearchTablesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SearchTablesErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::SearchTablesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::SearchTablesErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::SearchTablesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartBlueprintRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartBlueprintRunError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartBlueprintRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StartBlueprintRunErrorKind::IllegalBlueprintStateException(inner) => {
                    Error::IllegalBlueprintStateException(inner)
                }
                crate::error::StartBlueprintRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::StartBlueprintRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StartBlueprintRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StartBlueprintRunErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::StartBlueprintRunErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartCrawlerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartCrawlerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartCrawlerErrorKind::CrawlerRunningException(inner) => {
                    Error::CrawlerRunningException(inner)
                }
                crate::error::StartCrawlerErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StartCrawlerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StartCrawlerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartCrawlerScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartCrawlerScheduleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartCrawlerScheduleErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StartCrawlerScheduleErrorKind::NoScheduleException(inner) => {
                    Error::NoScheduleException(inner)
                }
                crate::error::StartCrawlerScheduleErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StartCrawlerScheduleErrorKind::SchedulerRunningException(inner) => {
                    Error::SchedulerRunningException(inner)
                }
                crate::error::StartCrawlerScheduleErrorKind::SchedulerTransitioningException(
                    inner,
                ) => Error::SchedulerTransitioningException(inner),
                crate::error::StartCrawlerScheduleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartExportLabelsTaskRunError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartExportLabelsTaskRunError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartExportLabelsTaskRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StartExportLabelsTaskRunErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::StartExportLabelsTaskRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StartExportLabelsTaskRunErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::StartExportLabelsTaskRunErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartImportLabelsTaskRunError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartImportLabelsTaskRunError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartImportLabelsTaskRunErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::StartImportLabelsTaskRunErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::StartImportLabelsTaskRunErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::StartImportLabelsTaskRunErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::StartImportLabelsTaskRunErrorKind::ResourceNumberLimitExceededException(inner) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::StartImportLabelsTaskRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartJobRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartJobRunError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartJobRunErrorKind::ConcurrentRunsExceededException(inner) => {
                    Error::ConcurrentRunsExceededException(inner)
                }
                crate::error::StartJobRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StartJobRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::StartJobRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StartJobRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StartJobRunErrorKind::ResourceNumberLimitExceededException(inner) => {
                    Error::ResourceNumberLimitExceededException(inner)
                }
                crate::error::StartJobRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartMLEvaluationTaskRunError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartMLEvaluationTaskRunError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartMLEvaluationTaskRunErrorKind::ConcurrentRunsExceededException(inner) => Error::ConcurrentRunsExceededException(inner),
                crate::error::StartMLEvaluationTaskRunErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::StartMLEvaluationTaskRunErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::StartMLEvaluationTaskRunErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::StartMLEvaluationTaskRunErrorKind::MlTransformNotReadyException(inner) => Error::MlTransformNotReadyException(inner),
                crate::error::StartMLEvaluationTaskRunErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::StartMLEvaluationTaskRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::StartMLLabelingSetGenerationTaskRunError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StartMLLabelingSetGenerationTaskRunError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartMLLabelingSetGenerationTaskRunErrorKind::ConcurrentRunsExceededException(inner) => Error::ConcurrentRunsExceededException(inner),
                crate::error::StartMLLabelingSetGenerationTaskRunErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::StartMLLabelingSetGenerationTaskRunErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::StartMLLabelingSetGenerationTaskRunErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::StartMLLabelingSetGenerationTaskRunErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::StartMLLabelingSetGenerationTaskRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartTriggerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartTriggerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartTriggerErrorKind::ConcurrentRunsExceededException(inner) => {
                    Error::ConcurrentRunsExceededException(inner)
                }
                crate::error::StartTriggerErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StartTriggerErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::StartTriggerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StartTriggerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StartTriggerErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::StartTriggerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartWorkflowRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartWorkflowRunError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartWorkflowRunErrorKind::ConcurrentRunsExceededException(inner) => {
                    Error::ConcurrentRunsExceededException(inner)
                }
                crate::error::StartWorkflowRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StartWorkflowRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::StartWorkflowRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StartWorkflowRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StartWorkflowRunErrorKind::ResourceNumberLimitExceededException(
                    inner,
                ) => Error::ResourceNumberLimitExceededException(inner),
                crate::error::StartWorkflowRunErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopCrawlerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopCrawlerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopCrawlerErrorKind::CrawlerNotRunningException(inner) => {
                    Error::CrawlerNotRunningException(inner)
                }
                crate::error::StopCrawlerErrorKind::CrawlerStoppingException(inner) => {
                    Error::CrawlerStoppingException(inner)
                }
                crate::error::StopCrawlerErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StopCrawlerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StopCrawlerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopCrawlerScheduleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopCrawlerScheduleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopCrawlerScheduleErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StopCrawlerScheduleErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StopCrawlerScheduleErrorKind::SchedulerNotRunningException(inner) => {
                    Error::SchedulerNotRunningException(inner)
                }
                crate::error::StopCrawlerScheduleErrorKind::SchedulerTransitioningException(
                    inner,
                ) => Error::SchedulerTransitioningException(inner),
                crate::error::StopCrawlerScheduleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopTriggerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopTriggerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopTriggerErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::StopTriggerErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StopTriggerErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::StopTriggerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StopTriggerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StopTriggerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopWorkflowRunError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopWorkflowRunError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopWorkflowRunErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::StopWorkflowRunErrorKind::IllegalWorkflowStateException(inner) => {
                    Error::IllegalWorkflowStateException(inner)
                }
                crate::error::StopWorkflowRunErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::StopWorkflowRunErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StopWorkflowRunErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::StopWorkflowRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::TagResourceErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UntagResourceErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateBlueprintError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateBlueprintError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateBlueprintErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateBlueprintErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateBlueprintErrorKind::IllegalBlueprintStateException(inner) => {
                    Error::IllegalBlueprintStateException(inner)
                }
                crate::error::UpdateBlueprintErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateBlueprintErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateBlueprintErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateBlueprintErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateClassifierError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateClassifierError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateClassifierErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateClassifierErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateClassifierErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateClassifierErrorKind::VersionMismatchException(inner) => {
                    Error::VersionMismatchException(inner)
                }
                crate::error::UpdateClassifierErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::UpdateColumnStatisticsForPartitionError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateColumnStatisticsForPartitionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateColumnStatisticsForPartitionErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::UpdateColumnStatisticsForPartitionErrorKind::GlueEncryptionException(inner) => Error::GlueEncryptionException(inner),
                crate::error::UpdateColumnStatisticsForPartitionErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::UpdateColumnStatisticsForPartitionErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::UpdateColumnStatisticsForPartitionErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::UpdateColumnStatisticsForPartitionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateColumnStatisticsForTableError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateColumnStatisticsForTableError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateColumnStatisticsForTableErrorKind::EntityNotFoundException(inner) => Error::EntityNotFoundException(inner),
                crate::error::UpdateColumnStatisticsForTableErrorKind::GlueEncryptionException(inner) => Error::GlueEncryptionException(inner),
                crate::error::UpdateColumnStatisticsForTableErrorKind::InternalServiceException(inner) => Error::InternalServiceException(inner),
                crate::error::UpdateColumnStatisticsForTableErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::UpdateColumnStatisticsForTableErrorKind::OperationTimeoutException(inner) => Error::OperationTimeoutException(inner),
                crate::error::UpdateColumnStatisticsForTableErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateConnectionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateConnectionErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::UpdateConnectionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateConnectionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateCrawlerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateCrawlerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateCrawlerErrorKind::CrawlerRunningException(inner) => {
                    Error::CrawlerRunningException(inner)
                }
                crate::error::UpdateCrawlerErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateCrawlerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateCrawlerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateCrawlerErrorKind::VersionMismatchException(inner) => {
                    Error::VersionMismatchException(inner)
                }
                crate::error::UpdateCrawlerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateCrawlerScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateCrawlerScheduleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateCrawlerScheduleErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateCrawlerScheduleErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateCrawlerScheduleErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateCrawlerScheduleErrorKind::SchedulerTransitioningException(
                    inner,
                ) => Error::SchedulerTransitioningException(inner),
                crate::error::UpdateCrawlerScheduleErrorKind::VersionMismatchException(inner) => {
                    Error::VersionMismatchException(inner)
                }
                crate::error::UpdateCrawlerScheduleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDatabaseError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateDatabaseError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDatabaseErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateDatabaseErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateDatabaseErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::UpdateDatabaseErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateDatabaseErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateDatabaseErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateDatabaseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDevEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDevEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDevEndpointErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateDevEndpointErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateDevEndpointErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateDevEndpointErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateDevEndpointErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::UpdateDevEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateJobError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateJobError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateJobErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateJobErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateJobErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateJobErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateJobErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateJobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateMLTransformError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateMLTransformError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateMLTransformErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateMLTransformErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateMLTransformErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateMLTransformErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateMLTransformErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateMLTransformErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePartitionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdatePartitionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdatePartitionErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdatePartitionErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::UpdatePartitionErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdatePartitionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdatePartitionErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdatePartitionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateRegistryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateRegistryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateRegistryErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateRegistryErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateRegistryErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateRegistryErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateRegistryErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateRegistryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateSchemaError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateSchemaError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateSchemaErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateSchemaErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateSchemaErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateSchemaErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateSchemaErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateSchemaErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTableError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateTableError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTableErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateTableErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateTableErrorKind::GlueEncryptionException(inner) => {
                    Error::GlueEncryptionException(inner)
                }
                crate::error::UpdateTableErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateTableErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateTableErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateTableErrorKind::ResourceNumberLimitExceededException(inner) => {
                    Error::ResourceNumberLimitExceededException(inner)
                }
                crate::error::UpdateTableErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTriggerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateTriggerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTriggerErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateTriggerErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateTriggerErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateTriggerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateTriggerErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateTriggerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateUserDefinedFunctionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateUserDefinedFunctionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateUserDefinedFunctionErrorKind::EntityNotFoundException(
                    inner,
                ) => Error::EntityNotFoundException(inner),
                crate::error::UpdateUserDefinedFunctionErrorKind::GlueEncryptionException(
                    inner,
                ) => Error::GlueEncryptionException(inner),
                crate::error::UpdateUserDefinedFunctionErrorKind::InternalServiceException(
                    inner,
                ) => Error::InternalServiceException(inner),
                crate::error::UpdateUserDefinedFunctionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateUserDefinedFunctionErrorKind::OperationTimeoutException(
                    inner,
                ) => Error::OperationTimeoutException(inner),
                crate::error::UpdateUserDefinedFunctionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateWorkflowError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateWorkflowError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateWorkflowErrorKind::ConcurrentModificationException(inner) => {
                    Error::ConcurrentModificationException(inner)
                }
                crate::error::UpdateWorkflowErrorKind::EntityNotFoundException(inner) => {
                    Error::EntityNotFoundException(inner)
                }
                crate::error::UpdateWorkflowErrorKind::InternalServiceException(inner) => {
                    Error::InternalServiceException(inner)
                }
                crate::error::UpdateWorkflowErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateWorkflowErrorKind::OperationTimeoutException(inner) => {
                    Error::OperationTimeoutException(inner)
                }
                crate::error::UpdateWorkflowErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
