// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_custom_routing_endpoints_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddCustomRoutingEndpointsOutput,
    crate::error::AddCustomRoutingEndpointsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddCustomRoutingEndpointsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AddCustomRoutingEndpointsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AddCustomRoutingEndpointsError {
            meta: generic,
            kind: crate::error::AddCustomRoutingEndpointsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomRoutingEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::AddCustomRoutingEndpointsError {
                meta: generic,
                kind: crate::error::AddCustomRoutingEndpointsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomRoutingEndpointsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EndpointAlreadyExistsException" => crate::error::AddCustomRoutingEndpointsError {
            meta: generic,
            kind: crate::error::AddCustomRoutingEndpointsErrorKind::EndpointAlreadyExistsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::endpoint_already_exists_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_endpoint_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomRoutingEndpointsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "EndpointGroupNotFoundException" => crate::error::AddCustomRoutingEndpointsError {
            meta: generic,
            kind: crate::error::AddCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::endpoint_group_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_endpoint_group_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomRoutingEndpointsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalServiceErrorException" => crate::error::AddCustomRoutingEndpointsError {
            meta: generic,
            kind: crate::error::AddCustomRoutingEndpointsErrorKind::InternalServiceErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_service_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomRoutingEndpointsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidArgumentException" => crate::error::AddCustomRoutingEndpointsError {
            meta: generic,
            kind: crate::error::AddCustomRoutingEndpointsErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomRoutingEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::AddCustomRoutingEndpointsError {
            meta: generic,
            kind: crate::error::AddCustomRoutingEndpointsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddCustomRoutingEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddCustomRoutingEndpointsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_custom_routing_endpoints_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddCustomRoutingEndpointsOutput,
    crate::error::AddCustomRoutingEndpointsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_custom_routing_endpoints_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_add_custom_routing_endpoints(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddCustomRoutingEndpointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_advertise_byoip_cidr_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdvertiseByoipCidrOutput,
    crate::error::AdvertiseByoipCidrError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AdvertiseByoipCidrError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AdvertiseByoipCidrError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AdvertiseByoipCidrError {
            meta: generic,
            kind: crate::error::AdvertiseByoipCidrErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdvertiseByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ByoipCidrNotFoundException" => crate::error::AdvertiseByoipCidrError {
            meta: generic,
            kind: crate::error::AdvertiseByoipCidrErrorKind::ByoipCidrNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::byoip_cidr_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_byoip_cidr_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdvertiseByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectCidrStateException" => crate::error::AdvertiseByoipCidrError {
            meta: generic,
            kind: crate::error::AdvertiseByoipCidrErrorKind::IncorrectCidrStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incorrect_cidr_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_cidr_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdvertiseByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::AdvertiseByoipCidrError {
            meta: generic,
            kind: crate::error::AdvertiseByoipCidrErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdvertiseByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::AdvertiseByoipCidrError {
            meta: generic,
            kind: crate::error::AdvertiseByoipCidrErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AdvertiseByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AdvertiseByoipCidrError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_advertise_byoip_cidr_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AdvertiseByoipCidrOutput,
    crate::error::AdvertiseByoipCidrError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::advertise_byoip_cidr_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_advertise_byoip_cidr(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AdvertiseByoipCidrError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_allow_custom_routing_traffic_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AllowCustomRoutingTrafficOutput,
    crate::error::AllowCustomRoutingTrafficError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AllowCustomRoutingTrafficError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AllowCustomRoutingTrafficError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::AllowCustomRoutingTrafficError {
            meta: generic,
            kind: crate::error::AllowCustomRoutingTrafficErrorKind::InternalServiceErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_service_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AllowCustomRoutingTrafficError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidArgumentException" => crate::error::AllowCustomRoutingTrafficError {
            meta: generic,
            kind: crate::error::AllowCustomRoutingTrafficErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AllowCustomRoutingTrafficError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AllowCustomRoutingTrafficError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_allow_custom_routing_traffic_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AllowCustomRoutingTrafficOutput,
    crate::error::AllowCustomRoutingTrafficError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::allow_custom_routing_traffic_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_accelerator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAcceleratorOutput, crate::error::CreateAcceleratorError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAcceleratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAcceleratorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::CreateAcceleratorError {
            meta: generic,
            kind: crate::error::CreateAcceleratorErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::CreateAcceleratorError {
            meta: generic,
            kind: crate::error::CreateAcceleratorErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateAcceleratorError {
            meta: generic,
            kind: crate::error::CreateAcceleratorErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAcceleratorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_accelerator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAcceleratorOutput, crate::error::CreateAcceleratorError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_accelerator_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_accelerator(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAcceleratorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_routing_accelerator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomRoutingAcceleratorOutput,
    crate::error::CreateCustomRoutingAcceleratorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCustomRoutingAcceleratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateCustomRoutingAcceleratorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateCustomRoutingAcceleratorError {
            meta: generic,
            kind: crate::error::CreateCustomRoutingAcceleratorErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::CreateCustomRoutingAcceleratorError {
            meta: generic,
            kind:
                crate::error::CreateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::internal_service_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingAcceleratorError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidArgumentException" => crate::error::CreateCustomRoutingAcceleratorError {
            meta: generic,
            kind: crate::error::CreateCustomRoutingAcceleratorErrorKind::InvalidArgumentException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_argument_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingAcceleratorError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "LimitExceededException" => crate::error::CreateCustomRoutingAcceleratorError {
            meta: generic,
            kind: crate::error::CreateCustomRoutingAcceleratorErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCustomRoutingAcceleratorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_routing_accelerator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomRoutingAcceleratorOutput,
    crate::error::CreateCustomRoutingAcceleratorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_custom_routing_accelerator_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_custom_routing_accelerator(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateCustomRoutingAcceleratorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_routing_endpoint_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomRoutingEndpointGroupOutput,
    crate::error::CreateCustomRoutingEndpointGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::CreateCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::CreateCustomRoutingEndpointGroupErrorKind::AcceleratorNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccessDeniedException" => crate::error::CreateCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::CreateCustomRoutingEndpointGroupErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EndpointGroupAlreadyExistsException" => crate::error::CreateCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::CreateCustomRoutingEndpointGroupErrorKind::EndpointGroupAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::endpoint_group_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_endpoint_group_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServiceErrorException" => crate::error::CreateCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::CreateCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgumentException" => crate::error::CreateCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::CreateCustomRoutingEndpointGroupErrorKind::InvalidArgumentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidPortRangeException" => crate::error::CreateCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::CreateCustomRoutingEndpointGroupErrorKind::InvalidPortRangeException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_port_range_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_port_range_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::CreateCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::CreateCustomRoutingEndpointGroupErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ListenerNotFoundException" => crate::error::CreateCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::CreateCustomRoutingEndpointGroupErrorKind::ListenerNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_listener_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateCustomRoutingEndpointGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_routing_endpoint_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomRoutingEndpointGroupOutput,
    crate::error::CreateCustomRoutingEndpointGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_custom_routing_endpoint_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_custom_routing_endpoint_group(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingEndpointGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_routing_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomRoutingListenerOutput,
    crate::error::CreateCustomRoutingListenerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCustomRoutingListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCustomRoutingListenerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::CreateCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::CreateCustomRoutingListenerErrorKind::AcceleratorNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::accelerator_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingListenerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalServiceErrorException" => crate::error::CreateCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::CreateCustomRoutingListenerErrorKind::InternalServiceErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_service_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingListenerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidArgumentException" => crate::error::CreateCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::CreateCustomRoutingListenerErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPortRangeException" => crate::error::CreateCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::CreateCustomRoutingListenerErrorKind::InvalidPortRangeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_port_range_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_port_range_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::CreateCustomRoutingListenerErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomRoutingListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCustomRoutingListenerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_routing_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomRoutingListenerOutput,
    crate::error::CreateCustomRoutingListenerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_custom_routing_listener_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_custom_routing_listener(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCustomRoutingListenerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEndpointGroupOutput,
    crate::error::CreateEndpointGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEndpointGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateEndpointGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::CreateEndpointGroupError {
            meta: generic,
            kind: crate::error::CreateEndpointGroupErrorKind::AcceleratorNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccessDeniedException" => crate::error::CreateEndpointGroupError {
            meta: generic,
            kind: crate::error::CreateEndpointGroupErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EndpointGroupAlreadyExistsException" => {
            crate::error::CreateEndpointGroupError {
                meta: generic,
                kind:
                    crate::error::CreateEndpointGroupErrorKind::EndpointGroupAlreadyExistsException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::endpoint_group_already_exists_exception::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_endpoint_group_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointGroupError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InternalServiceErrorException" => crate::error::CreateEndpointGroupError {
            meta: generic,
            kind: crate::error::CreateEndpointGroupErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::CreateEndpointGroupError {
            meta: generic,
            kind: crate::error::CreateEndpointGroupErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateEndpointGroupError {
            meta: generic,
            kind: crate::error::CreateEndpointGroupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ListenerNotFoundException" => crate::error::CreateEndpointGroupError {
            meta: generic,
            kind: crate::error::CreateEndpointGroupErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_listener_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEndpointGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEndpointGroupOutput,
    crate::error::CreateEndpointGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_endpoint_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_endpoint_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEndpointGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateListenerOutput, crate::error::CreateListenerError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateListenerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::CreateListenerError {
            meta: generic,
            kind: crate::error::CreateListenerErrorKind::AcceleratorNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::CreateListenerError {
            meta: generic,
            kind: crate::error::CreateListenerErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::CreateListenerError {
            meta: generic,
            kind: crate::error::CreateListenerErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPortRangeException" => crate::error::CreateListenerError {
            meta: generic,
            kind: crate::error::CreateListenerErrorKind::InvalidPortRangeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_port_range_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_port_range_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateListenerError {
            meta: generic,
            kind: crate::error::CreateListenerErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateListenerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateListenerOutput, crate::error::CreateListenerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_listener_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_listener(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateListenerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_accelerator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAcceleratorOutput, crate::error::DeleteAcceleratorError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAcceleratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAcceleratorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotDisabledException" => crate::error::DeleteAcceleratorError {
            meta: generic,
            kind: crate::error::DeleteAcceleratorErrorKind::AcceleratorNotDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::accelerator_not_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AcceleratorNotFoundException" => crate::error::DeleteAcceleratorError {
            meta: generic,
            kind: crate::error::DeleteAcceleratorErrorKind::AcceleratorNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AssociatedListenerFoundException" => crate::error::DeleteAcceleratorError {
            meta: generic,
            kind: crate::error::DeleteAcceleratorErrorKind::AssociatedListenerFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::associated_listener_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_associated_listener_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::DeleteAcceleratorError {
            meta: generic,
            kind: crate::error::DeleteAcceleratorErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::DeleteAcceleratorError {
            meta: generic,
            kind: crate::error::DeleteAcceleratorErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAcceleratorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_accelerator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAcceleratorOutput, crate::error::DeleteAcceleratorError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_accelerator_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_routing_accelerator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomRoutingAcceleratorOutput,
    crate::error::DeleteCustomRoutingAcceleratorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCustomRoutingAcceleratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteCustomRoutingAcceleratorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotDisabledException" => crate::error::DeleteCustomRoutingAcceleratorError { meta: generic, kind: crate::error::DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotDisabledException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::accelerator_not_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingAcceleratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AcceleratorNotFoundException" => crate::error::DeleteCustomRoutingAcceleratorError { meta: generic, kind: crate::error::DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingAcceleratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AssociatedListenerFoundException" => crate::error::DeleteCustomRoutingAcceleratorError { meta: generic, kind: crate::error::DeleteCustomRoutingAcceleratorErrorKind::AssociatedListenerFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::associated_listener_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_associated_listener_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingAcceleratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServiceErrorException" => crate::error::DeleteCustomRoutingAcceleratorError { meta: generic, kind: crate::error::DeleteCustomRoutingAcceleratorErrorKind::InternalServiceErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingAcceleratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgumentException" => crate::error::DeleteCustomRoutingAcceleratorError { meta: generic, kind: crate::error::DeleteCustomRoutingAcceleratorErrorKind::InvalidArgumentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingAcceleratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteCustomRoutingAcceleratorError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_routing_accelerator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomRoutingAcceleratorOutput,
    crate::error::DeleteCustomRoutingAcceleratorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_custom_routing_accelerator_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_routing_endpoint_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomRoutingEndpointGroupOutput,
    crate::error::DeleteCustomRoutingEndpointGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCustomRoutingEndpointGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCustomRoutingEndpointGroupError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EndpointGroupNotFoundException" => crate::error::DeleteCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::DeleteCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::endpoint_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_endpoint_group_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServiceErrorException" => crate::error::DeleteCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::DeleteCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgumentException" => crate::error::DeleteCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::DeleteCustomRoutingEndpointGroupErrorKind::InvalidArgumentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteCustomRoutingEndpointGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_routing_endpoint_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomRoutingEndpointGroupOutput,
    crate::error::DeleteCustomRoutingEndpointGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_custom_routing_endpoint_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_routing_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomRoutingListenerOutput,
    crate::error::DeleteCustomRoutingListenerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCustomRoutingListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCustomRoutingListenerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AssociatedEndpointGroupFoundException" => crate::error::DeleteCustomRoutingListenerError { meta: generic, kind: crate::error::DeleteCustomRoutingListenerErrorKind::AssociatedEndpointGroupFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::associated_endpoint_group_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_associated_endpoint_group_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServiceErrorException" => crate::error::DeleteCustomRoutingListenerError { meta: generic, kind: crate::error::DeleteCustomRoutingListenerErrorKind::InternalServiceErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgumentException" => crate::error::DeleteCustomRoutingListenerError { meta: generic, kind: crate::error::DeleteCustomRoutingListenerErrorKind::InvalidArgumentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ListenerNotFoundException" => crate::error::DeleteCustomRoutingListenerError { meta: generic, kind: crate::error::DeleteCustomRoutingListenerErrorKind::ListenerNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_listener_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomRoutingListenerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteCustomRoutingListenerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_routing_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomRoutingListenerOutput,
    crate::error::DeleteCustomRoutingListenerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_custom_routing_listener_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEndpointGroupOutput,
    crate::error::DeleteEndpointGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEndpointGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteEndpointGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EndpointGroupNotFoundException" => crate::error::DeleteEndpointGroupError {
            meta: generic,
            kind: crate::error::DeleteEndpointGroupErrorKind::EndpointGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::endpoint_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_endpoint_group_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::DeleteEndpointGroupError {
            meta: generic,
            kind: crate::error::DeleteEndpointGroupErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::DeleteEndpointGroupError {
            meta: generic,
            kind: crate::error::DeleteEndpointGroupErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEndpointGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEndpointGroupOutput,
    crate::error::DeleteEndpointGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_endpoint_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteListenerOutput, crate::error::DeleteListenerError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteListenerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AssociatedEndpointGroupFoundException" => crate::error::DeleteListenerError {
            meta: generic,
            kind: crate::error::DeleteListenerErrorKind::AssociatedEndpointGroupFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::associated_endpoint_group_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_associated_endpoint_group_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::DeleteListenerError {
            meta: generic,
            kind: crate::error::DeleteListenerErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::DeleteListenerError {
            meta: generic,
            kind: crate::error::DeleteListenerErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ListenerNotFoundException" => crate::error::DeleteListenerError {
            meta: generic,
            kind: crate::error::DeleteListenerErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_listener_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteListenerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteListenerOutput, crate::error::DeleteListenerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_listener_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deny_custom_routing_traffic_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DenyCustomRoutingTrafficOutput,
    crate::error::DenyCustomRoutingTrafficError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DenyCustomRoutingTrafficError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DenyCustomRoutingTrafficError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::DenyCustomRoutingTrafficError {
            meta: generic,
            kind: crate::error::DenyCustomRoutingTrafficErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DenyCustomRoutingTrafficError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::DenyCustomRoutingTrafficError {
            meta: generic,
            kind: crate::error::DenyCustomRoutingTrafficErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DenyCustomRoutingTrafficError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DenyCustomRoutingTrafficError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deny_custom_routing_traffic_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DenyCustomRoutingTrafficOutput,
    crate::error::DenyCustomRoutingTrafficError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deny_custom_routing_traffic_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deprovision_byoip_cidr_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeprovisionByoipCidrOutput,
    crate::error::DeprovisionByoipCidrError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeprovisionByoipCidrError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeprovisionByoipCidrError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeprovisionByoipCidrError {
            meta: generic,
            kind: crate::error::DeprovisionByoipCidrErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeprovisionByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ByoipCidrNotFoundException" => crate::error::DeprovisionByoipCidrError {
            meta: generic,
            kind: crate::error::DeprovisionByoipCidrErrorKind::ByoipCidrNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::byoip_cidr_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_byoip_cidr_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeprovisionByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectCidrStateException" => crate::error::DeprovisionByoipCidrError {
            meta: generic,
            kind: crate::error::DeprovisionByoipCidrErrorKind::IncorrectCidrStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incorrect_cidr_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_cidr_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeprovisionByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::DeprovisionByoipCidrError {
            meta: generic,
            kind: crate::error::DeprovisionByoipCidrErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeprovisionByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::DeprovisionByoipCidrError {
            meta: generic,
            kind: crate::error::DeprovisionByoipCidrErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeprovisionByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeprovisionByoipCidrError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deprovision_byoip_cidr_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeprovisionByoipCidrOutput,
    crate::error::DeprovisionByoipCidrError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deprovision_byoip_cidr_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_deprovision_byoip_cidr(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeprovisionByoipCidrError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_accelerator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAcceleratorOutput,
    crate::error::DescribeAcceleratorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAcceleratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAcceleratorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::DescribeAcceleratorError {
            meta: generic,
            kind: crate::error::DescribeAcceleratorErrorKind::AcceleratorNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::DescribeAcceleratorError {
            meta: generic,
            kind: crate::error::DescribeAcceleratorErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::DescribeAcceleratorError {
            meta: generic,
            kind: crate::error::DescribeAcceleratorErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAcceleratorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_accelerator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAcceleratorOutput,
    crate::error::DescribeAcceleratorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_accelerator_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_accelerator(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAcceleratorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_accelerator_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAcceleratorAttributesOutput,
    crate::error::DescribeAcceleratorAttributesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAcceleratorAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAcceleratorAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::DescribeAcceleratorAttributesError {
            meta: generic,
            kind:
                crate::error::DescribeAcceleratorAttributesErrorKind::AcceleratorNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::accelerator_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAcceleratorAttributesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalServiceErrorException" => crate::error::DescribeAcceleratorAttributesError {
            meta: generic,
            kind:
                crate::error::DescribeAcceleratorAttributesErrorKind::InternalServiceErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::internal_service_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAcceleratorAttributesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidArgumentException" => crate::error::DescribeAcceleratorAttributesError {
            meta: generic,
            kind: crate::error::DescribeAcceleratorAttributesErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAcceleratorAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAcceleratorAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_accelerator_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAcceleratorAttributesOutput,
    crate::error::DescribeAcceleratorAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_accelerator_attributes_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_accelerator_attributes(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeAcceleratorAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_custom_routing_accelerator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCustomRoutingAcceleratorOutput,
    crate::error::DescribeCustomRoutingAcceleratorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCustomRoutingAcceleratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCustomRoutingAcceleratorError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::DescribeCustomRoutingAcceleratorError { meta: generic, kind: crate::error::DescribeCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingAcceleratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServiceErrorException" => crate::error::DescribeCustomRoutingAcceleratorError { meta: generic, kind: crate::error::DescribeCustomRoutingAcceleratorErrorKind::InternalServiceErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingAcceleratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgumentException" => crate::error::DescribeCustomRoutingAcceleratorError { meta: generic, kind: crate::error::DescribeCustomRoutingAcceleratorErrorKind::InvalidArgumentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingAcceleratorError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeCustomRoutingAcceleratorError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_custom_routing_accelerator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCustomRoutingAcceleratorOutput,
    crate::error::DescribeCustomRoutingAcceleratorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_custom_routing_accelerator_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_custom_routing_accelerator(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeCustomRoutingAcceleratorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_custom_routing_accelerator_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCustomRoutingAcceleratorAttributesOutput,
    crate::error::DescribeCustomRoutingAcceleratorAttributesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCustomRoutingAcceleratorAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::DescribeCustomRoutingAcceleratorAttributesError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::DescribeCustomRoutingAcceleratorAttributesError { meta: generic, kind: crate::error::DescribeCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingAcceleratorAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServiceErrorException" => crate::error::DescribeCustomRoutingAcceleratorAttributesError { meta: generic, kind: crate::error::DescribeCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingAcceleratorAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgumentException" => crate::error::DescribeCustomRoutingAcceleratorAttributesError { meta: generic, kind: crate::error::DescribeCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingAcceleratorAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeCustomRoutingAcceleratorAttributesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_custom_routing_accelerator_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCustomRoutingAcceleratorAttributesOutput,
    crate::error::DescribeCustomRoutingAcceleratorAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_custom_routing_accelerator_attributes_output::Builder::default(
            );
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_custom_routing_accelerator_attributes(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingAcceleratorAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_custom_routing_endpoint_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCustomRoutingEndpointGroupOutput,
    crate::error::DescribeCustomRoutingEndpointGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCustomRoutingEndpointGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCustomRoutingEndpointGroupError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EndpointGroupNotFoundException" => crate::error::DescribeCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::DescribeCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::endpoint_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_endpoint_group_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServiceErrorException" => crate::error::DescribeCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::DescribeCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgumentException" => crate::error::DescribeCustomRoutingEndpointGroupError { meta: generic, kind: crate::error::DescribeCustomRoutingEndpointGroupErrorKind::InvalidArgumentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingEndpointGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeCustomRoutingEndpointGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_custom_routing_endpoint_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCustomRoutingEndpointGroupOutput,
    crate::error::DescribeCustomRoutingEndpointGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_custom_routing_endpoint_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_custom_routing_endpoint_group(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingEndpointGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_custom_routing_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCustomRoutingListenerOutput,
    crate::error::DescribeCustomRoutingListenerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCustomRoutingListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCustomRoutingListenerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::DescribeCustomRoutingListenerError {
            meta: generic,
            kind:
                crate::error::DescribeCustomRoutingListenerErrorKind::InternalServiceErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::internal_service_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingListenerError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidArgumentException" => crate::error::DescribeCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::DescribeCustomRoutingListenerErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ListenerNotFoundException" => crate::error::DescribeCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::DescribeCustomRoutingListenerErrorKind::ListenerNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::listener_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_listener_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCustomRoutingListenerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeCustomRoutingListenerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_custom_routing_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCustomRoutingListenerOutput,
    crate::error::DescribeCustomRoutingListenerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_custom_routing_listener_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_custom_routing_listener(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeCustomRoutingListenerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointGroupOutput,
    crate::error::DescribeEndpointGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEndpointGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeEndpointGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EndpointGroupNotFoundException" => crate::error::DescribeEndpointGroupError {
            meta: generic,
            kind: crate::error::DescribeEndpointGroupErrorKind::EndpointGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::endpoint_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_endpoint_group_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::DescribeEndpointGroupError {
            meta: generic,
            kind: crate::error::DescribeEndpointGroupErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::DescribeEndpointGroupError {
            meta: generic,
            kind: crate::error::DescribeEndpointGroupErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEndpointGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointGroupOutput,
    crate::error::DescribeEndpointGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_endpoint_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_endpoint_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEndpointGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeListenerOutput, crate::error::DescribeListenerError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeListenerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::DescribeListenerError {
            meta: generic,
            kind: crate::error::DescribeListenerErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::DescribeListenerError {
            meta: generic,
            kind: crate::error::DescribeListenerErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ListenerNotFoundException" => crate::error::DescribeListenerError {
            meta: generic,
            kind: crate::error::DescribeListenerErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_listener_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeListenerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeListenerOutput, crate::error::DescribeListenerError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_listener_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_listener(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeListenerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_accelerators_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAcceleratorsOutput, crate::error::ListAcceleratorsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAcceleratorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAcceleratorsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::ListAcceleratorsError {
            meta: generic,
            kind: crate::error::ListAcceleratorsErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAcceleratorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::ListAcceleratorsError {
            meta: generic,
            kind: crate::error::ListAcceleratorsErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAcceleratorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListAcceleratorsError {
            meta: generic,
            kind: crate::error::ListAcceleratorsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAcceleratorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAcceleratorsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_accelerators_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAcceleratorsOutput, crate::error::ListAcceleratorsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_accelerators_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_accelerators(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAcceleratorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_byoip_cidrs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListByoipCidrsOutput, crate::error::ListByoipCidrsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListByoipCidrsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListByoipCidrsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ListByoipCidrsError {
            meta: generic,
            kind: crate::error::ListByoipCidrsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListByoipCidrsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::ListByoipCidrsError {
            meta: generic,
            kind: crate::error::ListByoipCidrsErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListByoipCidrsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::ListByoipCidrsError {
            meta: generic,
            kind: crate::error::ListByoipCidrsErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListByoipCidrsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListByoipCidrsError {
            meta: generic,
            kind: crate::error::ListByoipCidrsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListByoipCidrsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListByoipCidrsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_byoip_cidrs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListByoipCidrsOutput, crate::error::ListByoipCidrsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_byoip_cidrs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_byoip_cidrs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListByoipCidrsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_routing_accelerators_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomRoutingAcceleratorsOutput,
    crate::error::ListCustomRoutingAcceleratorsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCustomRoutingAcceleratorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListCustomRoutingAcceleratorsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::ListCustomRoutingAcceleratorsError {
            meta: generic,
            kind:
                crate::error::ListCustomRoutingAcceleratorsErrorKind::InternalServiceErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::internal_service_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingAcceleratorsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidArgumentException" => crate::error::ListCustomRoutingAcceleratorsError {
            meta: generic,
            kind: crate::error::ListCustomRoutingAcceleratorsErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingAcceleratorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListCustomRoutingAcceleratorsError {
            meta: generic,
            kind: crate::error::ListCustomRoutingAcceleratorsErrorKind::InvalidNextTokenException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_next_token_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingAcceleratorsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListCustomRoutingAcceleratorsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_routing_accelerators_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomRoutingAcceleratorsOutput,
    crate::error::ListCustomRoutingAcceleratorsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_custom_routing_accelerators_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_custom_routing_accelerators(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListCustomRoutingAcceleratorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_routing_endpoint_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomRoutingEndpointGroupsOutput,
    crate::error::ListCustomRoutingEndpointGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCustomRoutingEndpointGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListCustomRoutingEndpointGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::ListCustomRoutingEndpointGroupsError { meta: generic, kind: crate::error::ListCustomRoutingEndpointGroupsErrorKind::InternalServiceErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingEndpointGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgumentException" => crate::error::ListCustomRoutingEndpointGroupsError { meta: generic, kind: crate::error::ListCustomRoutingEndpointGroupsErrorKind::InvalidArgumentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingEndpointGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidNextTokenException" => crate::error::ListCustomRoutingEndpointGroupsError { meta: generic, kind: crate::error::ListCustomRoutingEndpointGroupsErrorKind::InvalidNextTokenException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingEndpointGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ListenerNotFoundException" => crate::error::ListCustomRoutingEndpointGroupsError { meta: generic, kind: crate::error::ListCustomRoutingEndpointGroupsErrorKind::ListenerNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_listener_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingEndpointGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListCustomRoutingEndpointGroupsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_routing_endpoint_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomRoutingEndpointGroupsOutput,
    crate::error::ListCustomRoutingEndpointGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_custom_routing_endpoint_groups_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_custom_routing_endpoint_groups(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListCustomRoutingEndpointGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_routing_listeners_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomRoutingListenersOutput,
    crate::error::ListCustomRoutingListenersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCustomRoutingListenersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListCustomRoutingListenersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::ListCustomRoutingListenersError {
            meta: generic,
            kind: crate::error::ListCustomRoutingListenersErrorKind::AcceleratorNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::accelerator_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingListenersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalServiceErrorException" => crate::error::ListCustomRoutingListenersError {
            meta: generic,
            kind: crate::error::ListCustomRoutingListenersErrorKind::InternalServiceErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_service_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingListenersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidArgumentException" => crate::error::ListCustomRoutingListenersError {
            meta: generic,
            kind: crate::error::ListCustomRoutingListenersErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingListenersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListCustomRoutingListenersError {
            meta: generic,
            kind: crate::error::ListCustomRoutingListenersErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingListenersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListCustomRoutingListenersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_routing_listeners_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomRoutingListenersOutput,
    crate::error::ListCustomRoutingListenersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_custom_routing_listeners_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_custom_routing_listeners(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListCustomRoutingListenersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_routing_port_mappings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomRoutingPortMappingsOutput,
    crate::error::ListCustomRoutingPortMappingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCustomRoutingPortMappingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListCustomRoutingPortMappingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::ListCustomRoutingPortMappingsError {
            meta: generic,
            kind:
                crate::error::ListCustomRoutingPortMappingsErrorKind::AcceleratorNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::accelerator_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingPortMappingsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "EndpointGroupNotFoundException" => crate::error::ListCustomRoutingPortMappingsError {
            meta: generic,
            kind:
                crate::error::ListCustomRoutingPortMappingsErrorKind::EndpointGroupNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::endpoint_group_not_found_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_endpoint_group_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingPortMappingsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalServiceErrorException" => crate::error::ListCustomRoutingPortMappingsError {
            meta: generic,
            kind:
                crate::error::ListCustomRoutingPortMappingsErrorKind::InternalServiceErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::internal_service_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingPortMappingsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidArgumentException" => crate::error::ListCustomRoutingPortMappingsError {
            meta: generic,
            kind: crate::error::ListCustomRoutingPortMappingsErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingPortMappingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListCustomRoutingPortMappingsError {
            meta: generic,
            kind: crate::error::ListCustomRoutingPortMappingsErrorKind::InvalidNextTokenException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_next_token_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingPortMappingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListCustomRoutingPortMappingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_routing_port_mappings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomRoutingPortMappingsOutput,
    crate::error::ListCustomRoutingPortMappingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_custom_routing_port_mappings_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_custom_routing_port_mappings(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListCustomRoutingPortMappingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_routing_port_mappings_by_destination_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomRoutingPortMappingsByDestinationOutput,
    crate::error::ListCustomRoutingPortMappingsByDestinationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCustomRoutingPortMappingsByDestinationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::ListCustomRoutingPortMappingsByDestinationError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EndpointNotFoundException" => crate::error::ListCustomRoutingPortMappingsByDestinationError { meta: generic, kind: crate::error::ListCustomRoutingPortMappingsByDestinationErrorKind::EndpointNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::endpoint_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_endpoint_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingPortMappingsByDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServiceErrorException" => crate::error::ListCustomRoutingPortMappingsByDestinationError { meta: generic, kind: crate::error::ListCustomRoutingPortMappingsByDestinationErrorKind::InternalServiceErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingPortMappingsByDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgumentException" => crate::error::ListCustomRoutingPortMappingsByDestinationError { meta: generic, kind: crate::error::ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidArgumentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingPortMappingsByDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidNextTokenException" => crate::error::ListCustomRoutingPortMappingsByDestinationError { meta: generic, kind: crate::error::ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidNextTokenException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingPortMappingsByDestinationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListCustomRoutingPortMappingsByDestinationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_custom_routing_port_mappings_by_destination_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCustomRoutingPortMappingsByDestinationOutput,
    crate::error::ListCustomRoutingPortMappingsByDestinationError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::list_custom_routing_port_mappings_by_destination_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_custom_routing_port_mappings_by_destination(response.body().as_ref(), output).map_err(crate::error::ListCustomRoutingPortMappingsByDestinationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_endpoint_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEndpointGroupsOutput,
    crate::error::ListEndpointGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEndpointGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListEndpointGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::ListEndpointGroupsError {
            meta: generic,
            kind: crate::error::ListEndpointGroupsErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::ListEndpointGroupsError {
            meta: generic,
            kind: crate::error::ListEndpointGroupsErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListEndpointGroupsError {
            meta: generic,
            kind: crate::error::ListEndpointGroupsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ListenerNotFoundException" => crate::error::ListEndpointGroupsError {
            meta: generic,
            kind: crate::error::ListEndpointGroupsErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_listener_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEndpointGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListEndpointGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_endpoint_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEndpointGroupsOutput,
    crate::error::ListEndpointGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_endpoint_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_endpoint_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEndpointGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_listeners_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListListenersOutput, crate::error::ListListenersError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListListenersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListListenersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::ListListenersError {
            meta: generic,
            kind: crate::error::ListListenersErrorKind::AcceleratorNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListListenersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::ListListenersError {
            meta: generic,
            kind: crate::error::ListListenersErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListListenersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::ListListenersError {
            meta: generic,
            kind: crate::error::ListListenersErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListListenersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListListenersError {
            meta: generic,
            kind: crate::error::ListListenersErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListListenersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListListenersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_listeners_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListListenersOutput, crate::error::ListListenersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_listeners_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_listeners(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListListenersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::AcceleratorNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_provision_byoip_cidr_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ProvisionByoipCidrOutput,
    crate::error::ProvisionByoipCidrError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ProvisionByoipCidrError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ProvisionByoipCidrError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ProvisionByoipCidrError {
            meta: generic,
            kind: crate::error::ProvisionByoipCidrErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ProvisionByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectCidrStateException" => crate::error::ProvisionByoipCidrError {
            meta: generic,
            kind: crate::error::ProvisionByoipCidrErrorKind::IncorrectCidrStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incorrect_cidr_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_cidr_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ProvisionByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::ProvisionByoipCidrError {
            meta: generic,
            kind: crate::error::ProvisionByoipCidrErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ProvisionByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::ProvisionByoipCidrError {
            meta: generic,
            kind: crate::error::ProvisionByoipCidrErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ProvisionByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::ProvisionByoipCidrError {
            meta: generic,
            kind: crate::error::ProvisionByoipCidrErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ProvisionByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ProvisionByoipCidrError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_provision_byoip_cidr_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ProvisionByoipCidrOutput,
    crate::error::ProvisionByoipCidrError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::provision_byoip_cidr_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_provision_byoip_cidr(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ProvisionByoipCidrError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_custom_routing_endpoints_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveCustomRoutingEndpointsOutput,
    crate::error::RemoveCustomRoutingEndpointsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveCustomRoutingEndpointsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveCustomRoutingEndpointsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RemoveCustomRoutingEndpointsError {
            meta: generic,
            kind: crate::error::RemoveCustomRoutingEndpointsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveCustomRoutingEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::RemoveCustomRoutingEndpointsError {
                meta: generic,
                kind: crate::error::RemoveCustomRoutingEndpointsErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveCustomRoutingEndpointsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EndpointGroupNotFoundException" => crate::error::RemoveCustomRoutingEndpointsError {
            meta: generic,
            kind:
                crate::error::RemoveCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::endpoint_group_not_found_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_endpoint_group_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveCustomRoutingEndpointsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "EndpointNotFoundException" => crate::error::RemoveCustomRoutingEndpointsError {
            meta: generic,
            kind: crate::error::RemoveCustomRoutingEndpointsErrorKind::EndpointNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::endpoint_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_endpoint_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveCustomRoutingEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::RemoveCustomRoutingEndpointsError {
            meta: generic,
            kind:
                crate::error::RemoveCustomRoutingEndpointsErrorKind::InternalServiceErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::internal_service_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveCustomRoutingEndpointsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidArgumentException" => crate::error::RemoveCustomRoutingEndpointsError {
            meta: generic,
            kind: crate::error::RemoveCustomRoutingEndpointsErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveCustomRoutingEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveCustomRoutingEndpointsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_custom_routing_endpoints_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveCustomRoutingEndpointsOutput,
    crate::error::RemoveCustomRoutingEndpointsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_custom_routing_endpoints_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::AcceleratorNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::AcceleratorNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_accelerator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAcceleratorOutput, crate::error::UpdateAcceleratorError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAcceleratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateAcceleratorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::UpdateAcceleratorError {
            meta: generic,
            kind: crate::error::UpdateAcceleratorErrorKind::AcceleratorNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::UpdateAcceleratorError {
            meta: generic,
            kind: crate::error::UpdateAcceleratorErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::UpdateAcceleratorError {
            meta: generic,
            kind: crate::error::UpdateAcceleratorErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAcceleratorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAcceleratorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_accelerator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAcceleratorOutput, crate::error::UpdateAcceleratorError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_accelerator_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_accelerator(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateAcceleratorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_accelerator_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAcceleratorAttributesOutput,
    crate::error::UpdateAcceleratorAttributesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAcceleratorAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateAcceleratorAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::UpdateAcceleratorAttributesError {
            meta: generic,
            kind: crate::error::UpdateAcceleratorAttributesErrorKind::AcceleratorNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::accelerator_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAcceleratorAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "AccessDeniedException" => crate::error::UpdateAcceleratorAttributesError {
            meta: generic,
            kind: crate::error::UpdateAcceleratorAttributesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAcceleratorAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::UpdateAcceleratorAttributesError {
            meta: generic,
            kind: crate::error::UpdateAcceleratorAttributesErrorKind::InternalServiceErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_service_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAcceleratorAttributesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidArgumentException" => crate::error::UpdateAcceleratorAttributesError {
            meta: generic,
            kind: crate::error::UpdateAcceleratorAttributesErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAcceleratorAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAcceleratorAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_accelerator_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAcceleratorAttributesOutput,
    crate::error::UpdateAcceleratorAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_accelerator_attributes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_accelerator_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateAcceleratorAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_routing_accelerator_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomRoutingAcceleratorOutput,
    crate::error::UpdateCustomRoutingAcceleratorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCustomRoutingAcceleratorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateCustomRoutingAcceleratorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::UpdateCustomRoutingAcceleratorError {
            meta: generic,
            kind:
                crate::error::UpdateCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::accelerator_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingAcceleratorError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalServiceErrorException" => crate::error::UpdateCustomRoutingAcceleratorError {
            meta: generic,
            kind:
                crate::error::UpdateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::internal_service_error_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingAcceleratorError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidArgumentException" => crate::error::UpdateCustomRoutingAcceleratorError {
            meta: generic,
            kind: crate::error::UpdateCustomRoutingAcceleratorErrorKind::InvalidArgumentException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_argument_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingAcceleratorError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UpdateCustomRoutingAcceleratorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_routing_accelerator_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomRoutingAcceleratorOutput,
    crate::error::UpdateCustomRoutingAcceleratorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_custom_routing_accelerator_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_update_custom_routing_accelerator(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::UpdateCustomRoutingAcceleratorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_routing_accelerator_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomRoutingAcceleratorAttributesOutput,
    crate::error::UpdateCustomRoutingAcceleratorAttributesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCustomRoutingAcceleratorAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::UpdateCustomRoutingAcceleratorAttributesError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AcceleratorNotFoundException" => crate::error::UpdateCustomRoutingAcceleratorAttributesError { meta: generic, kind: crate::error::UpdateCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::accelerator_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_accelerator_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingAcceleratorAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccessDeniedException" => crate::error::UpdateCustomRoutingAcceleratorAttributesError { meta: generic, kind: crate::error::UpdateCustomRoutingAcceleratorAttributesErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingAcceleratorAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServiceErrorException" => crate::error::UpdateCustomRoutingAcceleratorAttributesError { meta: generic, kind: crate::error::UpdateCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingAcceleratorAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidArgumentException" => crate::error::UpdateCustomRoutingAcceleratorAttributesError { meta: generic, kind: crate::error::UpdateCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingAcceleratorAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateCustomRoutingAcceleratorAttributesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_routing_accelerator_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomRoutingAcceleratorAttributesOutput,
    crate::error::UpdateCustomRoutingAcceleratorAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_custom_routing_accelerator_attributes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_custom_routing_accelerator_attributes(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingAcceleratorAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_routing_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomRoutingListenerOutput,
    crate::error::UpdateCustomRoutingListenerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCustomRoutingListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateCustomRoutingListenerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::UpdateCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::UpdateCustomRoutingListenerErrorKind::InternalServiceErrorException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::internal_service_error_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingListenerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidArgumentException" => crate::error::UpdateCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::UpdateCustomRoutingListenerErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPortRangeException" => crate::error::UpdateCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::UpdateCustomRoutingListenerErrorKind::InvalidPortRangeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_port_range_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_port_range_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::UpdateCustomRoutingListenerErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ListenerNotFoundException" => crate::error::UpdateCustomRoutingListenerError {
            meta: generic,
            kind: crate::error::UpdateCustomRoutingListenerErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_listener_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCustomRoutingListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateCustomRoutingListenerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_custom_routing_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCustomRoutingListenerOutput,
    crate::error::UpdateCustomRoutingListenerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_custom_routing_listener_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_custom_routing_listener(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateCustomRoutingListenerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_endpoint_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateEndpointGroupOutput,
    crate::error::UpdateEndpointGroupError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateEndpointGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateEndpointGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateEndpointGroupError {
            meta: generic,
            kind: crate::error::UpdateEndpointGroupErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EndpointGroupNotFoundException" => crate::error::UpdateEndpointGroupError {
            meta: generic,
            kind: crate::error::UpdateEndpointGroupErrorKind::EndpointGroupNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::endpoint_group_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_endpoint_group_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::UpdateEndpointGroupError {
            meta: generic,
            kind: crate::error::UpdateEndpointGroupErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::UpdateEndpointGroupError {
            meta: generic,
            kind: crate::error::UpdateEndpointGroupErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateEndpointGroupError {
            meta: generic,
            kind: crate::error::UpdateEndpointGroupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEndpointGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateEndpointGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_endpoint_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateEndpointGroupOutput,
    crate::error::UpdateEndpointGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_endpoint_group_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_endpoint_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateEndpointGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_listener_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateListenerOutput, crate::error::UpdateListenerError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateListenerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateListenerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceErrorException" => crate::error::UpdateListenerError {
            meta: generic,
            kind: crate::error::UpdateListenerErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::UpdateListenerError {
            meta: generic,
            kind: crate::error::UpdateListenerErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPortRangeException" => crate::error::UpdateListenerError {
            meta: generic,
            kind: crate::error::UpdateListenerErrorKind::InvalidPortRangeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_port_range_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_port_range_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UpdateListenerError {
            meta: generic,
            kind: crate::error::UpdateListenerErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ListenerNotFoundException" => crate::error::UpdateListenerError {
            meta: generic,
            kind: crate::error::UpdateListenerErrorKind::ListenerNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::listener_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_listener_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateListenerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateListenerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_listener_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateListenerOutput, crate::error::UpdateListenerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_listener_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_listener(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateListenerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_withdraw_byoip_cidr_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::WithdrawByoipCidrOutput, crate::error::WithdrawByoipCidrError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::WithdrawByoipCidrError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::WithdrawByoipCidrError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::WithdrawByoipCidrError {
            meta: generic,
            kind: crate::error::WithdrawByoipCidrErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::WithdrawByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ByoipCidrNotFoundException" => crate::error::WithdrawByoipCidrError {
            meta: generic,
            kind: crate::error::WithdrawByoipCidrErrorKind::ByoipCidrNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::byoip_cidr_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_byoip_cidr_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::WithdrawByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectCidrStateException" => crate::error::WithdrawByoipCidrError {
            meta: generic,
            kind: crate::error::WithdrawByoipCidrErrorKind::IncorrectCidrStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incorrect_cidr_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_cidr_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::WithdrawByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceErrorException" => crate::error::WithdrawByoipCidrError {
            meta: generic,
            kind: crate::error::WithdrawByoipCidrErrorKind::InternalServiceErrorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::internal_service_error_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_service_error_exception_json_err(response.body().as_ref(), output).map_err(crate::error::WithdrawByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidArgumentException" => crate::error::WithdrawByoipCidrError {
            meta: generic,
            kind: crate::error::WithdrawByoipCidrErrorKind::InvalidArgumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_argument_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_argument_exception_json_err(response.body().as_ref(), output).map_err(crate::error::WithdrawByoipCidrError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::WithdrawByoipCidrError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_withdraw_byoip_cidr_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::WithdrawByoipCidrOutput, crate::error::WithdrawByoipCidrError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::withdraw_byoip_cidr_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_withdraw_byoip_cidr(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::WithdrawByoipCidrError::unhandled)?;
        output.build()
    })
}
