// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The accelerator that you specified could not be disabled.</p>
    AcceleratorNotDisabledException(crate::error::AcceleratorNotDisabledException),
    /// <p>The accelerator that you specified doesn't exist.</p>
    AcceleratorNotFoundException(crate::error::AcceleratorNotFoundException),
    /// <p>You don't have access permission.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The listener that you specified has an endpoint group associated with it. You must remove all dependent resources from a listener before you can delete it.</p>
    AssociatedEndpointGroupFoundException(crate::error::AssociatedEndpointGroupFoundException),
    /// <p>The accelerator that you specified has a listener associated with it. You must remove all dependent resources from an accelerator before you can delete it.</p>
    AssociatedListenerFoundException(crate::error::AssociatedListenerFoundException),
    /// <p>The CIDR that you specified was not found or is incorrect.</p>
    ByoipCidrNotFoundException(crate::error::ByoipCidrNotFoundException),
    /// <p>You can't use both of those options.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The endpoint that you specified doesn't exist.</p>
    EndpointAlreadyExistsException(crate::error::EndpointAlreadyExistsException),
    /// <p>The endpoint group that you specified already exists.</p>
    EndpointGroupAlreadyExistsException(crate::error::EndpointGroupAlreadyExistsException),
    /// <p>The endpoint group that you specified doesn't exist.</p>
    EndpointGroupNotFoundException(crate::error::EndpointGroupNotFoundException),
    /// <p>The endpoint that you specified doesn't exist.</p>
    EndpointNotFoundException(crate::error::EndpointNotFoundException),
    /// <p>The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be incorrect for this action.</p>
    IncorrectCidrStateException(crate::error::IncorrectCidrStateException),
    /// <p>There was an internal error for AWS Global Accelerator.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>An argument that you specified is invalid.</p>
    InvalidArgumentException(crate::error::InvalidArgumentException),
    /// <p>There isn't another item to return.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>The port numbers that you specified are not valid numbers or are not unique for this accelerator.</p>
    InvalidPortRangeException(crate::error::InvalidPortRangeException),
    /// <p>Processing your request would cause you to exceed an AWS Global Accelerator limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The listener that you specified doesn't exist.</p>
    ListenerNotFoundException(crate::error::ListenerNotFoundException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AcceleratorNotDisabledException(inner) => inner.fmt(f),
            Error::AcceleratorNotFoundException(inner) => inner.fmt(f),
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::AssociatedEndpointGroupFoundException(inner) => inner.fmt(f),
            Error::AssociatedListenerFoundException(inner) => inner.fmt(f),
            Error::ByoipCidrNotFoundException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::EndpointAlreadyExistsException(inner) => inner.fmt(f),
            Error::EndpointGroupAlreadyExistsException(inner) => inner.fmt(f),
            Error::EndpointGroupNotFoundException(inner) => inner.fmt(f),
            Error::EndpointNotFoundException(inner) => inner.fmt(f),
            Error::IncorrectCidrStateException(inner) => inner.fmt(f),
            Error::InternalServiceErrorException(inner) => inner.fmt(f),
            Error::InvalidArgumentException(inner) => inner.fmt(f),
            Error::InvalidNextTokenException(inner) => inner.fmt(f),
            Error::InvalidPortRangeException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::ListenerNotFoundException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddCustomRoutingEndpointsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddCustomRoutingEndpointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AddCustomRoutingEndpointsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::AddCustomRoutingEndpointsErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::AddCustomRoutingEndpointsErrorKind::EndpointAlreadyExistsException(inner) => Error::EndpointAlreadyExistsException(inner),
                crate::error::AddCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException(inner) => Error::EndpointGroupNotFoundException(inner),
                crate::error::AddCustomRoutingEndpointsErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::AddCustomRoutingEndpointsErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::AddCustomRoutingEndpointsErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::AddCustomRoutingEndpointsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AdvertiseByoipCidrError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AdvertiseByoipCidrError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AdvertiseByoipCidrErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AdvertiseByoipCidrErrorKind::ByoipCidrNotFoundException(inner) => {
                    Error::ByoipCidrNotFoundException(inner)
                }
                crate::error::AdvertiseByoipCidrErrorKind::IncorrectCidrStateException(inner) => {
                    Error::IncorrectCidrStateException(inner)
                }
                crate::error::AdvertiseByoipCidrErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::AdvertiseByoipCidrErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::AdvertiseByoipCidrErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AllowCustomRoutingTrafficError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AllowCustomRoutingTrafficError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AllowCustomRoutingTrafficErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::AllowCustomRoutingTrafficErrorKind::InvalidArgumentException(
                    inner,
                ) => Error::InvalidArgumentException(inner),
                crate::error::AllowCustomRoutingTrafficErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAcceleratorError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateAcceleratorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateAcceleratorErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::CreateAcceleratorErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::CreateAcceleratorErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateAcceleratorErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateCustomRoutingAcceleratorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateCustomRoutingAcceleratorError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCustomRoutingAcceleratorErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::CreateCustomRoutingAcceleratorErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::CreateCustomRoutingAcceleratorErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateCustomRoutingAcceleratorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateCustomRoutingEndpointGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateCustomRoutingEndpointGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCustomRoutingEndpointGroupErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::CreateCustomRoutingEndpointGroupErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateCustomRoutingEndpointGroupErrorKind::EndpointGroupAlreadyExistsException(inner) => Error::EndpointGroupAlreadyExistsException(inner),
                crate::error::CreateCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::CreateCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::CreateCustomRoutingEndpointGroupErrorKind::InvalidPortRangeException(inner) => Error::InvalidPortRangeException(inner),
                crate::error::CreateCustomRoutingEndpointGroupErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateCustomRoutingEndpointGroupErrorKind::ListenerNotFoundException(inner) => Error::ListenerNotFoundException(inner),
                crate::error::CreateCustomRoutingEndpointGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCustomRoutingListenerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCustomRoutingListenerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCustomRoutingListenerErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::CreateCustomRoutingListenerErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::CreateCustomRoutingListenerErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::CreateCustomRoutingListenerErrorKind::InvalidPortRangeException(inner) => Error::InvalidPortRangeException(inner),
                crate::error::CreateCustomRoutingListenerErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateCustomRoutingListenerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateEndpointGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateEndpointGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateEndpointGroupErrorKind::AcceleratorNotFoundException(inner) => {
                    Error::AcceleratorNotFoundException(inner)
                }
                crate::error::CreateEndpointGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateEndpointGroupErrorKind::EndpointGroupAlreadyExistsException(
                    inner,
                ) => Error::EndpointGroupAlreadyExistsException(inner),
                crate::error::CreateEndpointGroupErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::CreateEndpointGroupErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::CreateEndpointGroupErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateEndpointGroupErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::CreateEndpointGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateListenerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateListenerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateListenerErrorKind::AcceleratorNotFoundException(inner) => {
                    Error::AcceleratorNotFoundException(inner)
                }
                crate::error::CreateListenerErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::CreateListenerErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::CreateListenerErrorKind::InvalidPortRangeException(inner) => {
                    Error::InvalidPortRangeException(inner)
                }
                crate::error::CreateListenerErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateListenerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAcceleratorError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAcceleratorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAcceleratorErrorKind::AcceleratorNotDisabledException(
                    inner,
                ) => Error::AcceleratorNotDisabledException(inner),
                crate::error::DeleteAcceleratorErrorKind::AcceleratorNotFoundException(inner) => {
                    Error::AcceleratorNotFoundException(inner)
                }
                crate::error::DeleteAcceleratorErrorKind::AssociatedListenerFoundException(
                    inner,
                ) => Error::AssociatedListenerFoundException(inner),
                crate::error::DeleteAcceleratorErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::DeleteAcceleratorErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::DeleteAcceleratorErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteCustomRoutingAcceleratorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteCustomRoutingAcceleratorError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotDisabledException(inner) => Error::AcceleratorNotDisabledException(inner),
                crate::error::DeleteCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::DeleteCustomRoutingAcceleratorErrorKind::AssociatedListenerFoundException(inner) => Error::AssociatedListenerFoundException(inner),
                crate::error::DeleteCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DeleteCustomRoutingAcceleratorErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::DeleteCustomRoutingAcceleratorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteCustomRoutingEndpointGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteCustomRoutingEndpointGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException(inner) => Error::EndpointGroupNotFoundException(inner),
                crate::error::DeleteCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DeleteCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::DeleteCustomRoutingEndpointGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCustomRoutingListenerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCustomRoutingListenerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCustomRoutingListenerErrorKind::AssociatedEndpointGroupFoundException(inner) => Error::AssociatedEndpointGroupFoundException(inner),
                crate::error::DeleteCustomRoutingListenerErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DeleteCustomRoutingListenerErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::DeleteCustomRoutingListenerErrorKind::ListenerNotFoundException(inner) => Error::ListenerNotFoundException(inner),
                crate::error::DeleteCustomRoutingListenerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEndpointGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteEndpointGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteEndpointGroupErrorKind::EndpointGroupNotFoundException(
                    inner,
                ) => Error::EndpointGroupNotFoundException(inner),
                crate::error::DeleteEndpointGroupErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::DeleteEndpointGroupErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::DeleteEndpointGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteListenerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteListenerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteListenerErrorKind::AssociatedEndpointGroupFoundException(
                    inner,
                ) => Error::AssociatedEndpointGroupFoundException(inner),
                crate::error::DeleteListenerErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::DeleteListenerErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::DeleteListenerErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::DeleteListenerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DenyCustomRoutingTrafficError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DenyCustomRoutingTrafficError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DenyCustomRoutingTrafficErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::DenyCustomRoutingTrafficErrorKind::InvalidArgumentException(
                    inner,
                ) => Error::InvalidArgumentException(inner),
                crate::error::DenyCustomRoutingTrafficErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeprovisionByoipCidrError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeprovisionByoipCidrError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeprovisionByoipCidrErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeprovisionByoipCidrErrorKind::ByoipCidrNotFoundException(inner) => {
                    Error::ByoipCidrNotFoundException(inner)
                }
                crate::error::DeprovisionByoipCidrErrorKind::IncorrectCidrStateException(inner) => {
                    Error::IncorrectCidrStateException(inner)
                }
                crate::error::DeprovisionByoipCidrErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::DeprovisionByoipCidrErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::DeprovisionByoipCidrErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAcceleratorError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAcceleratorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAcceleratorErrorKind::AcceleratorNotFoundException(inner) => {
                    Error::AcceleratorNotFoundException(inner)
                }
                crate::error::DescribeAcceleratorErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::DescribeAcceleratorErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::DescribeAcceleratorErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAcceleratorAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAcceleratorAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAcceleratorAttributesErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::DescribeAcceleratorAttributesErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DescribeAcceleratorAttributesErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::DescribeAcceleratorAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeCustomRoutingAcceleratorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeCustomRoutingAcceleratorError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::DescribeCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DescribeCustomRoutingAcceleratorErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::DescribeCustomRoutingAcceleratorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeCustomRoutingAcceleratorAttributesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeCustomRoutingAcceleratorAttributesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::DescribeCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DescribeCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::DescribeCustomRoutingAcceleratorAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeCustomRoutingEndpointGroupError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeCustomRoutingEndpointGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCustomRoutingEndpointGroupErrorKind::EndpointGroupNotFoundException(inner) => Error::EndpointGroupNotFoundException(inner),
                crate::error::DescribeCustomRoutingEndpointGroupErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DescribeCustomRoutingEndpointGroupErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::DescribeCustomRoutingEndpointGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCustomRoutingListenerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCustomRoutingListenerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCustomRoutingListenerErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DescribeCustomRoutingListenerErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::DescribeCustomRoutingListenerErrorKind::ListenerNotFoundException(inner) => Error::ListenerNotFoundException(inner),
                crate::error::DescribeCustomRoutingListenerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEndpointGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEndpointGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEndpointGroupErrorKind::EndpointGroupNotFoundException(
                    inner,
                ) => Error::EndpointGroupNotFoundException(inner),
                crate::error::DescribeEndpointGroupErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::DescribeEndpointGroupErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::DescribeEndpointGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeListenerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeListenerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeListenerErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::DescribeListenerErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::DescribeListenerErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::DescribeListenerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAcceleratorsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListAcceleratorsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAcceleratorsErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::ListAcceleratorsErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::ListAcceleratorsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListAcceleratorsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListByoipCidrsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListByoipCidrsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListByoipCidrsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListByoipCidrsErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::ListByoipCidrsErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::ListByoipCidrsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListByoipCidrsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingAcceleratorsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingAcceleratorsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListCustomRoutingAcceleratorsErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::ListCustomRoutingAcceleratorsErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::ListCustomRoutingAcceleratorsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListCustomRoutingAcceleratorsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingEndpointGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListCustomRoutingEndpointGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListCustomRoutingEndpointGroupsErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::ListCustomRoutingEndpointGroupsErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::ListCustomRoutingEndpointGroupsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListCustomRoutingEndpointGroupsErrorKind::ListenerNotFoundException(inner) => Error::ListenerNotFoundException(inner),
                crate::error::ListCustomRoutingEndpointGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingListenersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingListenersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListCustomRoutingListenersErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::ListCustomRoutingListenersErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::ListCustomRoutingListenersErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::ListCustomRoutingListenersErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListCustomRoutingListenersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingPortMappingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingPortMappingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListCustomRoutingPortMappingsErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::ListCustomRoutingPortMappingsErrorKind::EndpointGroupNotFoundException(inner) => Error::EndpointGroupNotFoundException(inner),
                crate::error::ListCustomRoutingPortMappingsErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::ListCustomRoutingPortMappingsErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::ListCustomRoutingPortMappingsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListCustomRoutingPortMappingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListCustomRoutingPortMappingsByDestinationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListCustomRoutingPortMappingsByDestinationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListCustomRoutingPortMappingsByDestinationErrorKind::EndpointNotFoundException(inner) => Error::EndpointNotFoundException(inner),
                crate::error::ListCustomRoutingPortMappingsByDestinationErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::ListCustomRoutingPortMappingsByDestinationErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListCustomRoutingPortMappingsByDestinationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListEndpointGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListEndpointGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListEndpointGroupsErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::ListEndpointGroupsErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::ListEndpointGroupsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListEndpointGroupsErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::ListEndpointGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListListenersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListListenersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListListenersErrorKind::AcceleratorNotFoundException(inner) => {
                    Error::AcceleratorNotFoundException(inner)
                }
                crate::error::ListListenersErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::ListListenersErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::ListListenersErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListListenersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::AcceleratorNotFoundException(inner) => {
                    Error::AcceleratorNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::ListTagsForResourceErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ProvisionByoipCidrError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ProvisionByoipCidrError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ProvisionByoipCidrErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ProvisionByoipCidrErrorKind::IncorrectCidrStateException(inner) => {
                    Error::IncorrectCidrStateException(inner)
                }
                crate::error::ProvisionByoipCidrErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::ProvisionByoipCidrErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::ProvisionByoipCidrErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::ProvisionByoipCidrErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveCustomRoutingEndpointsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveCustomRoutingEndpointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveCustomRoutingEndpointsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::RemoveCustomRoutingEndpointsErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::RemoveCustomRoutingEndpointsErrorKind::EndpointGroupNotFoundException(inner) => Error::EndpointGroupNotFoundException(inner),
                crate::error::RemoveCustomRoutingEndpointsErrorKind::EndpointNotFoundException(inner) => Error::EndpointNotFoundException(inner),
                crate::error::RemoveCustomRoutingEndpointsErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::RemoveCustomRoutingEndpointsErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::RemoveCustomRoutingEndpointsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::AcceleratorNotFoundException(inner) => {
                    Error::AcceleratorNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::AcceleratorNotFoundException(inner) => {
                    Error::AcceleratorNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAcceleratorError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateAcceleratorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateAcceleratorErrorKind::AcceleratorNotFoundException(inner) => {
                    Error::AcceleratorNotFoundException(inner)
                }
                crate::error::UpdateAcceleratorErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::UpdateAcceleratorErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::UpdateAcceleratorErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateAcceleratorAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateAcceleratorAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateAcceleratorAttributesErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::UpdateAcceleratorAttributesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateAcceleratorAttributesErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::UpdateAcceleratorAttributesErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::UpdateAcceleratorAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateCustomRoutingAcceleratorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateCustomRoutingAcceleratorError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateCustomRoutingAcceleratorErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::UpdateCustomRoutingAcceleratorErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::UpdateCustomRoutingAcceleratorErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::UpdateCustomRoutingAcceleratorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::UpdateCustomRoutingAcceleratorAttributesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateCustomRoutingAcceleratorAttributesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateCustomRoutingAcceleratorAttributesErrorKind::AcceleratorNotFoundException(inner) => Error::AcceleratorNotFoundException(inner),
                crate::error::UpdateCustomRoutingAcceleratorAttributesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateCustomRoutingAcceleratorAttributesErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::UpdateCustomRoutingAcceleratorAttributesErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::UpdateCustomRoutingAcceleratorAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateCustomRoutingListenerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateCustomRoutingListenerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateCustomRoutingListenerErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::UpdateCustomRoutingListenerErrorKind::InvalidArgumentException(inner) => Error::InvalidArgumentException(inner),
                crate::error::UpdateCustomRoutingListenerErrorKind::InvalidPortRangeException(inner) => Error::InvalidPortRangeException(inner),
                crate::error::UpdateCustomRoutingListenerErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::UpdateCustomRoutingListenerErrorKind::ListenerNotFoundException(inner) => Error::ListenerNotFoundException(inner),
                crate::error::UpdateCustomRoutingListenerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateEndpointGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateEndpointGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateEndpointGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateEndpointGroupErrorKind::EndpointGroupNotFoundException(
                    inner,
                ) => Error::EndpointGroupNotFoundException(inner),
                crate::error::UpdateEndpointGroupErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::UpdateEndpointGroupErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::UpdateEndpointGroupErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateEndpointGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateListenerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateListenerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateListenerErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::UpdateListenerErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::UpdateListenerErrorKind::InvalidPortRangeException(inner) => {
                    Error::InvalidPortRangeException(inner)
                }
                crate::error::UpdateListenerErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateListenerErrorKind::ListenerNotFoundException(inner) => {
                    Error::ListenerNotFoundException(inner)
                }
                crate::error::UpdateListenerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::WithdrawByoipCidrError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::WithdrawByoipCidrError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::WithdrawByoipCidrErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::WithdrawByoipCidrErrorKind::ByoipCidrNotFoundException(inner) => {
                    Error::ByoipCidrNotFoundException(inner)
                }
                crate::error::WithdrawByoipCidrErrorKind::IncorrectCidrStateException(inner) => {
                    Error::IncorrectCidrStateException(inner)
                }
                crate::error::WithdrawByoipCidrErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::WithdrawByoipCidrErrorKind::InvalidArgumentException(inner) => {
                    Error::InvalidArgumentException(inner)
                }
                crate::error::WithdrawByoipCidrErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
