// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Global Accelerator
///
/// Client for invoking operations on AWS Global Accelerator. Each operation on AWS Global Accelerator is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_globalaccelerator::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_globalaccelerator::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_globalaccelerator::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddCustomRoutingEndpoints`](crate::client::fluent_builders::AddCustomRoutingEndpoints) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_configurations(Vec<CustomRoutingEndpointConfiguration>)`](crate::client::fluent_builders::AddCustomRoutingEndpoints::endpoint_configurations) / [`set_endpoint_configurations(Option<Vec<CustomRoutingEndpointConfiguration>>)`](crate::client::fluent_builders::AddCustomRoutingEndpoints::set_endpoint_configurations): <p>The list of endpoint objects to add to a custom routing accelerator.</p>
    ///   - [`endpoint_group_arn(impl Into<String>)`](crate::client::fluent_builders::AddCustomRoutingEndpoints::endpoint_group_arn) / [`set_endpoint_group_arn(Option<String>)`](crate::client::fluent_builders::AddCustomRoutingEndpoints::set_endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>
    /// - On success, responds with [`AddCustomRoutingEndpointsOutput`](crate::output::AddCustomRoutingEndpointsOutput) with field(s):
    ///   - [`endpoint_descriptions(Option<Vec<CustomRoutingEndpointDescription>>)`](crate::output::AddCustomRoutingEndpointsOutput::endpoint_descriptions): <p>The endpoint objects added to the custom routing accelerator.</p>
    ///   - [`endpoint_group_arn(Option<String>)`](crate::output::AddCustomRoutingEndpointsOutput::endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>
    /// - On failure, responds with [`SdkError<AddCustomRoutingEndpointsError>`](crate::error::AddCustomRoutingEndpointsError)
    pub fn add_custom_routing_endpoints(&self) -> fluent_builders::AddCustomRoutingEndpoints {
        fluent_builders::AddCustomRoutingEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AdvertiseByoipCidr`](crate::client::fluent_builders::AdvertiseByoipCidr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cidr(impl Into<String>)`](crate::client::fluent_builders::AdvertiseByoipCidr::cidr) / [`set_cidr(Option<String>)`](crate::client::fluent_builders::AdvertiseByoipCidr::set_cidr): <p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.</p>
    /// - On success, responds with [`AdvertiseByoipCidrOutput`](crate::output::AdvertiseByoipCidrOutput) with field(s):
    ///   - [`byoip_cidr(Option<ByoipCidr>)`](crate::output::AdvertiseByoipCidrOutput::byoip_cidr): <p>Information about the address range.</p>
    /// - On failure, responds with [`SdkError<AdvertiseByoipCidrError>`](crate::error::AdvertiseByoipCidrError)
    pub fn advertise_byoip_cidr(&self) -> fluent_builders::AdvertiseByoipCidr {
        fluent_builders::AdvertiseByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AllowCustomRoutingTraffic`](crate::client::fluent_builders::AllowCustomRoutingTraffic) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_group_arn(impl Into<String>)`](crate::client::fluent_builders::AllowCustomRoutingTraffic::endpoint_group_arn) / [`set_endpoint_group_arn(Option<String>)`](crate::client::fluent_builders::AllowCustomRoutingTraffic::set_endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    ///   - [`endpoint_id(impl Into<String>)`](crate::client::fluent_builders::AllowCustomRoutingTraffic::endpoint_id) / [`set_endpoint_id(Option<String>)`](crate::client::fluent_builders::AllowCustomRoutingTraffic::set_endpoint_id): <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
    ///   - [`destination_addresses(Vec<String>)`](crate::client::fluent_builders::AllowCustomRoutingTraffic::destination_addresses) / [`set_destination_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::AllowCustomRoutingTraffic::set_destination_addresses): <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.</p>  <p> <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or is not specified.</p>
    ///   - [`destination_ports(Vec<i32>)`](crate::client::fluent_builders::AllowCustomRoutingTraffic::destination_ports) / [`set_destination_ports(Option<Vec<i32>>)`](crate::client::fluent_builders::AllowCustomRoutingTraffic::set_destination_ports): <p>A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.</p>
    ///   - [`allow_all_traffic_to_endpoint(bool)`](crate::client::fluent_builders::AllowCustomRoutingTraffic::allow_all_traffic_to_endpoint) / [`set_allow_all_traffic_to_endpoint(Option<bool>)`](crate::client::fluent_builders::AllowCustomRoutingTraffic::set_allow_all_traffic_to_endpoint): <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>  <p>When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>  <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group.</p>  <p>The default value is FALSE.</p>
    /// - On success, responds with [`AllowCustomRoutingTrafficOutput`](crate::output::AllowCustomRoutingTrafficOutput)

    /// - On failure, responds with [`SdkError<AllowCustomRoutingTrafficError>`](crate::error::AllowCustomRoutingTrafficError)
    pub fn allow_custom_routing_traffic(&self) -> fluent_builders::AllowCustomRoutingTraffic {
        fluent_builders::AllowCustomRoutingTraffic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAccelerator`](crate::client::fluent_builders::CreateAccelerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAccelerator::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAccelerator::set_name): <p>The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
    ///   - [`ip_address_type(IpAddressType)`](crate::client::fluent_builders::CreateAccelerator::ip_address_type) / [`set_ip_address_type(Option<IpAddressType>)`](crate::client::fluent_builders::CreateAccelerator::set_ip_address_type): <p>The value for the address type must be IPv4.</p>
    ///   - [`ip_addresses(Vec<String>)`](crate::client::fluent_builders::CreateAccelerator::ip_addresses) / [`set_ip_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::CreateAccelerator::set_ip_addresses): <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>  <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only one IP address from your IP address range, Global Accelerator assigns a second static IP address for the accelerator from the AWS IP address pool.</p>  <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::CreateAccelerator::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::CreateAccelerator::set_enabled): <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>  <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateAccelerator::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateAccelerator::set_idempotency_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of an accelerator.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAccelerator::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAccelerator::set_tags): <p>Create tags for an accelerator.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    /// - On success, responds with [`CreateAcceleratorOutput`](crate::output::CreateAcceleratorOutput) with field(s):
    ///   - [`accelerator(Option<Accelerator>)`](crate::output::CreateAcceleratorOutput::accelerator): <p>The accelerator that is created by specifying a listener and the supported IP address types.</p>
    /// - On failure, responds with [`SdkError<CreateAcceleratorError>`](crate::error::CreateAcceleratorError)
    pub fn create_accelerator(&self) -> fluent_builders::CreateAccelerator {
        fluent_builders::CreateAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomRoutingAccelerator`](crate::client::fluent_builders::CreateCustomRoutingAccelerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::set_name): <p>The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
    ///   - [`ip_address_type(IpAddressType)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::ip_address_type) / [`set_ip_address_type(Option<IpAddressType>)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::set_ip_address_type): <p>The value for the address type must be IPv4.</p>
    ///   - [`ip_addresses(Vec<String>)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::ip_addresses) / [`set_ip_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::set_ip_addresses): <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>  <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only one IP address from your IP address range, Global Accelerator assigns a second static IP address for the accelerator from the AWS IP address pool.</p>  <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::set_enabled): <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>  <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::set_idempotency_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCustomRoutingAccelerator::set_tags): <p>Create tags for an accelerator.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    /// - On success, responds with [`CreateCustomRoutingAcceleratorOutput`](crate::output::CreateCustomRoutingAcceleratorOutput) with field(s):
    ///   - [`accelerator(Option<CustomRoutingAccelerator>)`](crate::output::CreateCustomRoutingAcceleratorOutput::accelerator): <p>The accelerator that is created.</p>
    /// - On failure, responds with [`SdkError<CreateCustomRoutingAcceleratorError>`](crate::error::CreateCustomRoutingAcceleratorError)
    pub fn create_custom_routing_accelerator(
        &self,
    ) -> fluent_builders::CreateCustomRoutingAccelerator {
        fluent_builders::CreateCustomRoutingAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomRoutingEndpointGroup`](crate::client::fluent_builders::CreateCustomRoutingEndpointGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCustomRoutingEndpointGroup::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::CreateCustomRoutingEndpointGroup::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.</p>
    ///   - [`endpoint_group_region(impl Into<String>)`](crate::client::fluent_builders::CreateCustomRoutingEndpointGroup::endpoint_group_region) / [`set_endpoint_group_region(Option<String>)`](crate::client::fluent_builders::CreateCustomRoutingEndpointGroup::set_endpoint_group_region): <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific Region.</p>
    ///   - [`destination_configurations(Vec<CustomRoutingDestinationConfiguration>)`](crate::client::fluent_builders::CreateCustomRoutingEndpointGroup::destination_configurations) / [`set_destination_configurations(Option<Vec<CustomRoutingDestinationConfiguration>>)`](crate::client::fluent_builders::CreateCustomRoutingEndpointGroup::set_destination_configurations): <p>Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept client traffic on.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateCustomRoutingEndpointGroup::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateCustomRoutingEndpointGroup::set_idempotency_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
    /// - On success, responds with [`CreateCustomRoutingEndpointGroupOutput`](crate::output::CreateCustomRoutingEndpointGroupOutput) with field(s):
    ///   - [`endpoint_group(Option<CustomRoutingEndpointGroup>)`](crate::output::CreateCustomRoutingEndpointGroupOutput::endpoint_group): <p>The information about the endpoint group created for a custom routing accelerator.</p>
    /// - On failure, responds with [`SdkError<CreateCustomRoutingEndpointGroupError>`](crate::error::CreateCustomRoutingEndpointGroupError)
    pub fn create_custom_routing_endpoint_group(
        &self,
    ) -> fluent_builders::CreateCustomRoutingEndpointGroup {
        fluent_builders::CreateCustomRoutingEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomRoutingListener`](crate::client::fluent_builders::CreateCustomRoutingListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCustomRoutingListener::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::CreateCustomRoutingListener::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.</p>
    ///   - [`port_ranges(Vec<PortRange>)`](crate::client::fluent_builders::CreateCustomRoutingListener::port_ranges) / [`set_port_ranges(Option<Vec<PortRange>>)`](crate::client::fluent_builders::CreateCustomRoutingListener::set_port_ranges): <p>The port range to support for connections from clients to your accelerator.</p>  <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About endpoints for custom routing accelerators</a>.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateCustomRoutingListener::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateCustomRoutingListener::set_idempotency_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
    /// - On success, responds with [`CreateCustomRoutingListenerOutput`](crate::output::CreateCustomRoutingListenerOutput) with field(s):
    ///   - [`listener(Option<CustomRoutingListener>)`](crate::output::CreateCustomRoutingListenerOutput::listener): <p>The listener that you've created for a custom routing accelerator.</p>
    /// - On failure, responds with [`SdkError<CreateCustomRoutingListenerError>`](crate::error::CreateCustomRoutingListenerError)
    pub fn create_custom_routing_listener(&self) -> fluent_builders::CreateCustomRoutingListener {
        fluent_builders::CreateCustomRoutingListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEndpointGroup`](crate::client::fluent_builders::CreateEndpointGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEndpointGroup::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::CreateEndpointGroup::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener.</p>
    ///   - [`endpoint_group_region(impl Into<String>)`](crate::client::fluent_builders::CreateEndpointGroup::endpoint_group_region) / [`set_endpoint_group_region(Option<String>)`](crate::client::fluent_builders::CreateEndpointGroup::set_endpoint_group_region): <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific Region.</p>
    ///   - [`endpoint_configurations(Vec<EndpointConfiguration>)`](crate::client::fluent_builders::CreateEndpointGroup::endpoint_configurations) / [`set_endpoint_configurations(Option<Vec<EndpointConfiguration>>)`](crate::client::fluent_builders::CreateEndpointGroup::set_endpoint_configurations): <p>The list of endpoint objects.</p>
    ///   - [`traffic_dial_percentage(f32)`](crate::client::fluent_builders::CreateEndpointGroup::traffic_dial_percentage) / [`set_traffic_dial_percentage(Option<f32>)`](crate::client::fluent_builders::CreateEndpointGroup::set_traffic_dial_percentage): <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. </p>  <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>  <p>The default value is 100.</p>
    ///   - [`health_check_port(i32)`](crate::client::fluent_builders::CreateEndpointGroup::health_check_port) / [`set_health_check_port(Option<i32>)`](crate::client::fluent_builders::CreateEndpointGroup::set_health_check_port): <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the first port in the list.</p>
    ///   - [`health_check_protocol(HealthCheckProtocol)`](crate::client::fluent_builders::CreateEndpointGroup::health_check_protocol) / [`set_health_check_protocol(Option<HealthCheckProtocol>)`](crate::client::fluent_builders::CreateEndpointGroup::set_health_check_protocol): <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.</p>
    ///   - [`health_check_path(impl Into<String>)`](crate::client::fluent_builders::CreateEndpointGroup::health_check_path) / [`set_health_check_path(Option<String>)`](crate::client::fluent_builders::CreateEndpointGroup::set_health_check_path): <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/).</p>
    ///   - [`health_check_interval_seconds(i32)`](crate::client::fluent_builders::CreateEndpointGroup::health_check_interval_seconds) / [`set_health_check_interval_seconds(Option<i32>)`](crate::client::fluent_builders::CreateEndpointGroup::set_health_check_interval_seconds): <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
    ///   - [`threshold_count(i32)`](crate::client::fluent_builders::CreateEndpointGroup::threshold_count) / [`set_threshold_count(Option<i32>)`](crate::client::fluent_builders::CreateEndpointGroup::set_threshold_count): <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateEndpointGroup::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateEndpointGroup::set_idempotency_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
    ///   - [`port_overrides(Vec<PortOverride>)`](crate::client::fluent_builders::CreateEndpointGroup::port_overrides) / [`set_port_overrides(Option<Vec<PortOverride>>)`](crate::client::fluent_builders::CreateEndpointGroup::set_port_overrides): <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html"> Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    /// - On success, responds with [`CreateEndpointGroupOutput`](crate::output::CreateEndpointGroupOutput) with field(s):
    ///   - [`endpoint_group(Option<EndpointGroup>)`](crate::output::CreateEndpointGroupOutput::endpoint_group): <p>The information about the endpoint group that was created.</p>
    /// - On failure, responds with [`SdkError<CreateEndpointGroupError>`](crate::error::CreateEndpointGroupError)
    pub fn create_endpoint_group(&self) -> fluent_builders::CreateEndpointGroup {
        fluent_builders::CreateEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateListener`](crate::client::fluent_builders::CreateListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::CreateListener::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::CreateListener::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of your accelerator.</p>
    ///   - [`port_ranges(Vec<PortRange>)`](crate::client::fluent_builders::CreateListener::port_ranges) / [`set_port_ranges(Option<Vec<PortRange>>)`](crate::client::fluent_builders::CreateListener::set_port_ranges): <p>The list of port ranges to support for connections from clients to your accelerator.</p>
    ///   - [`protocol(Protocol)`](crate::client::fluent_builders::CreateListener::protocol) / [`set_protocol(Option<Protocol>)`](crate::client::fluent_builders::CreateListener::set_protocol): <p>The protocol for connections from clients to your accelerator.</p>
    ///   - [`client_affinity(ClientAffinity)`](crate::client::fluent_builders::CreateListener::client_affinity) / [`set_client_affinity(Option<ClientAffinity>)`](crate::client::fluent_builders::CreateListener::set_client_affinity): <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint.</p>  <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes. </p>  <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.</p>  <p>The default value is <code>NONE</code>.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::CreateListener::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::CreateListener::set_idempotency_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
    /// - On success, responds with [`CreateListenerOutput`](crate::output::CreateListenerOutput) with field(s):
    ///   - [`listener(Option<Listener>)`](crate::output::CreateListenerOutput::listener): <p>The listener that you've created.</p>
    /// - On failure, responds with [`SdkError<CreateListenerError>`](crate::error::CreateListenerError)
    pub fn create_listener(&self) -> fluent_builders::CreateListener {
        fluent_builders::CreateListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccelerator`](crate::client::fluent_builders::DeleteAccelerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAccelerator::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::DeleteAccelerator::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of an accelerator.</p>
    /// - On success, responds with [`DeleteAcceleratorOutput`](crate::output::DeleteAcceleratorOutput)

    /// - On failure, responds with [`SdkError<DeleteAcceleratorError>`](crate::error::DeleteAcceleratorError)
    pub fn delete_accelerator(&self) -> fluent_builders::DeleteAccelerator {
        fluent_builders::DeleteAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomRoutingAccelerator`](crate::client::fluent_builders::DeleteCustomRoutingAccelerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomRoutingAccelerator::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::DeleteCustomRoutingAccelerator::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the custom routing accelerator to delete.</p>
    /// - On success, responds with [`DeleteCustomRoutingAcceleratorOutput`](crate::output::DeleteCustomRoutingAcceleratorOutput)

    /// - On failure, responds with [`SdkError<DeleteCustomRoutingAcceleratorError>`](crate::error::DeleteCustomRoutingAcceleratorError)
    pub fn delete_custom_routing_accelerator(
        &self,
    ) -> fluent_builders::DeleteCustomRoutingAccelerator {
        fluent_builders::DeleteCustomRoutingAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomRoutingEndpointGroup`](crate::client::fluent_builders::DeleteCustomRoutingEndpointGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_group_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomRoutingEndpointGroup::endpoint_group_arn) / [`set_endpoint_group_arn(Option<String>)`](crate::client::fluent_builders::DeleteCustomRoutingEndpointGroup::set_endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
    /// - On success, responds with [`DeleteCustomRoutingEndpointGroupOutput`](crate::output::DeleteCustomRoutingEndpointGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteCustomRoutingEndpointGroupError>`](crate::error::DeleteCustomRoutingEndpointGroupError)
    pub fn delete_custom_routing_endpoint_group(
        &self,
    ) -> fluent_builders::DeleteCustomRoutingEndpointGroup {
        fluent_builders::DeleteCustomRoutingEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomRoutingListener`](crate::client::fluent_builders::DeleteCustomRoutingListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomRoutingListener::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::DeleteCustomRoutingListener::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener to delete.</p>
    /// - On success, responds with [`DeleteCustomRoutingListenerOutput`](crate::output::DeleteCustomRoutingListenerOutput)

    /// - On failure, responds with [`SdkError<DeleteCustomRoutingListenerError>`](crate::error::DeleteCustomRoutingListenerError)
    pub fn delete_custom_routing_listener(&self) -> fluent_builders::DeleteCustomRoutingListener {
        fluent_builders::DeleteCustomRoutingListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEndpointGroup`](crate::client::fluent_builders::DeleteEndpointGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_group_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteEndpointGroup::endpoint_group_arn) / [`set_endpoint_group_arn(Option<String>)`](crate::client::fluent_builders::DeleteEndpointGroup::set_endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
    /// - On success, responds with [`DeleteEndpointGroupOutput`](crate::output::DeleteEndpointGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteEndpointGroupError>`](crate::error::DeleteEndpointGroupError)
    pub fn delete_endpoint_group(&self) -> fluent_builders::DeleteEndpointGroup {
        fluent_builders::DeleteEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteListener`](crate::client::fluent_builders::DeleteListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteListener::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::DeleteListener::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener.</p>
    /// - On success, responds with [`DeleteListenerOutput`](crate::output::DeleteListenerOutput)

    /// - On failure, responds with [`SdkError<DeleteListenerError>`](crate::error::DeleteListenerError)
    pub fn delete_listener(&self) -> fluent_builders::DeleteListener {
        fluent_builders::DeleteListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DenyCustomRoutingTraffic`](crate::client::fluent_builders::DenyCustomRoutingTraffic) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_group_arn(impl Into<String>)`](crate::client::fluent_builders::DenyCustomRoutingTraffic::endpoint_group_arn) / [`set_endpoint_group_arn(Option<String>)`](crate::client::fluent_builders::DenyCustomRoutingTraffic::set_endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    ///   - [`endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DenyCustomRoutingTraffic::endpoint_id) / [`set_endpoint_id(Option<String>)`](crate::client::fluent_builders::DenyCustomRoutingTraffic::set_endpoint_id): <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
    ///   - [`destination_addresses(Vec<String>)`](crate::client::fluent_builders::DenyCustomRoutingTraffic::destination_addresses) / [`set_destination_addresses(Option<Vec<String>>)`](crate::client::fluent_builders::DenyCustomRoutingTraffic::set_destination_addresses): <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the endpoint group.</p>
    ///   - [`destination_ports(Vec<i32>)`](crate::client::fluent_builders::DenyCustomRoutingTraffic::destination_ports) / [`set_destination_ports(Option<Vec<i32>>)`](crate::client::fluent_builders::DenyCustomRoutingTraffic::set_destination_ports): <p>A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from receiving traffic.</p>
    ///   - [`deny_all_traffic_to_endpoint(bool)`](crate::client::fluent_builders::DenyCustomRoutingTraffic::deny_all_traffic_to_endpoint) / [`set_deny_all_traffic_to_endpoint(Option<bool>)`](crate::client::fluent_builders::DenyCustomRoutingTraffic::set_deny_all_traffic_to_endpoint): <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i> receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>  <p>When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>  <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group.</p>  <p>The default value is FALSE.</p>
    /// - On success, responds with [`DenyCustomRoutingTrafficOutput`](crate::output::DenyCustomRoutingTrafficOutput)

    /// - On failure, responds with [`SdkError<DenyCustomRoutingTrafficError>`](crate::error::DenyCustomRoutingTrafficError)
    pub fn deny_custom_routing_traffic(&self) -> fluent_builders::DenyCustomRoutingTraffic {
        fluent_builders::DenyCustomRoutingTraffic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeprovisionByoipCidr`](crate::client::fluent_builders::DeprovisionByoipCidr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cidr(impl Into<String>)`](crate::client::fluent_builders::DeprovisionByoipCidr::cidr) / [`set_cidr(Option<String>)`](crate::client::fluent_builders::DeprovisionByoipCidr::set_cidr): <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified when you provisioned the address range.</p>
    /// - On success, responds with [`DeprovisionByoipCidrOutput`](crate::output::DeprovisionByoipCidrOutput) with field(s):
    ///   - [`byoip_cidr(Option<ByoipCidr>)`](crate::output::DeprovisionByoipCidrOutput::byoip_cidr): <p>Information about the address range.</p>
    /// - On failure, responds with [`SdkError<DeprovisionByoipCidrError>`](crate::error::DeprovisionByoipCidrError)
    pub fn deprovision_byoip_cidr(&self) -> fluent_builders::DeprovisionByoipCidr {
        fluent_builders::DeprovisionByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccelerator`](crate::client::fluent_builders::DescribeAccelerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAccelerator::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::DescribeAccelerator::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
    /// - On success, responds with [`DescribeAcceleratorOutput`](crate::output::DescribeAcceleratorOutput) with field(s):
    ///   - [`accelerator(Option<Accelerator>)`](crate::output::DescribeAcceleratorOutput::accelerator): <p>The description of the accelerator.</p>
    /// - On failure, responds with [`SdkError<DescribeAcceleratorError>`](crate::error::DescribeAcceleratorError)
    pub fn describe_accelerator(&self) -> fluent_builders::DescribeAccelerator {
        fluent_builders::DescribeAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAcceleratorAttributes`](crate::client::fluent_builders::DescribeAcceleratorAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAcceleratorAttributes::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::DescribeAcceleratorAttributes::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the accelerator with the attributes that you want to describe.</p>
    /// - On success, responds with [`DescribeAcceleratorAttributesOutput`](crate::output::DescribeAcceleratorAttributesOutput) with field(s):
    ///   - [`accelerator_attributes(Option<AcceleratorAttributes>)`](crate::output::DescribeAcceleratorAttributesOutput::accelerator_attributes): <p>The attributes of the accelerator.</p>
    /// - On failure, responds with [`SdkError<DescribeAcceleratorAttributesError>`](crate::error::DescribeAcceleratorAttributesError)
    pub fn describe_accelerator_attributes(
        &self,
    ) -> fluent_builders::DescribeAcceleratorAttributes {
        fluent_builders::DescribeAcceleratorAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCustomRoutingAccelerator`](crate::client::fluent_builders::DescribeCustomRoutingAccelerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomRoutingAccelerator::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::DescribeCustomRoutingAccelerator::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
    /// - On success, responds with [`DescribeCustomRoutingAcceleratorOutput`](crate::output::DescribeCustomRoutingAcceleratorOutput) with field(s):
    ///   - [`accelerator(Option<CustomRoutingAccelerator>)`](crate::output::DescribeCustomRoutingAcceleratorOutput::accelerator): <p>The description of the custom routing accelerator.</p>
    /// - On failure, responds with [`SdkError<DescribeCustomRoutingAcceleratorError>`](crate::error::DescribeCustomRoutingAcceleratorError)
    pub fn describe_custom_routing_accelerator(
        &self,
    ) -> fluent_builders::DescribeCustomRoutingAccelerator {
        fluent_builders::DescribeCustomRoutingAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCustomRoutingAcceleratorAttributes`](crate::client::fluent_builders::DescribeCustomRoutingAcceleratorAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomRoutingAcceleratorAttributes::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::DescribeCustomRoutingAcceleratorAttributes::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.</p>
    /// - On success, responds with [`DescribeCustomRoutingAcceleratorAttributesOutput`](crate::output::DescribeCustomRoutingAcceleratorAttributesOutput) with field(s):
    ///   - [`accelerator_attributes(Option<CustomRoutingAcceleratorAttributes>)`](crate::output::DescribeCustomRoutingAcceleratorAttributesOutput::accelerator_attributes): <p>The attributes of the custom routing accelerator.</p>
    /// - On failure, responds with [`SdkError<DescribeCustomRoutingAcceleratorAttributesError>`](crate::error::DescribeCustomRoutingAcceleratorAttributesError)
    pub fn describe_custom_routing_accelerator_attributes(
        &self,
    ) -> fluent_builders::DescribeCustomRoutingAcceleratorAttributes {
        fluent_builders::DescribeCustomRoutingAcceleratorAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCustomRoutingEndpointGroup`](crate::client::fluent_builders::DescribeCustomRoutingEndpointGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_group_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomRoutingEndpointGroup::endpoint_group_arn) / [`set_endpoint_group_arn(Option<String>)`](crate::client::fluent_builders::DescribeCustomRoutingEndpointGroup::set_endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
    /// - On success, responds with [`DescribeCustomRoutingEndpointGroupOutput`](crate::output::DescribeCustomRoutingEndpointGroupOutput) with field(s):
    ///   - [`endpoint_group(Option<CustomRoutingEndpointGroup>)`](crate::output::DescribeCustomRoutingEndpointGroupOutput::endpoint_group): <p>The description of an endpoint group for a custom routing accelerator.</p>
    /// - On failure, responds with [`SdkError<DescribeCustomRoutingEndpointGroupError>`](crate::error::DescribeCustomRoutingEndpointGroupError)
    pub fn describe_custom_routing_endpoint_group(
        &self,
    ) -> fluent_builders::DescribeCustomRoutingEndpointGroup {
        fluent_builders::DescribeCustomRoutingEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCustomRoutingListener`](crate::client::fluent_builders::DescribeCustomRoutingListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomRoutingListener::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::DescribeCustomRoutingListener::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
    /// - On success, responds with [`DescribeCustomRoutingListenerOutput`](crate::output::DescribeCustomRoutingListenerOutput) with field(s):
    ///   - [`listener(Option<CustomRoutingListener>)`](crate::output::DescribeCustomRoutingListenerOutput::listener): <p>The description of a listener for a custom routing accelerator.</p>
    /// - On failure, responds with [`SdkError<DescribeCustomRoutingListenerError>`](crate::error::DescribeCustomRoutingListenerError)
    pub fn describe_custom_routing_listener(
        &self,
    ) -> fluent_builders::DescribeCustomRoutingListener {
        fluent_builders::DescribeCustomRoutingListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEndpointGroup`](crate::client::fluent_builders::DescribeEndpointGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_group_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointGroup::endpoint_group_arn) / [`set_endpoint_group_arn(Option<String>)`](crate::client::fluent_builders::DescribeEndpointGroup::set_endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
    /// - On success, responds with [`DescribeEndpointGroupOutput`](crate::output::DescribeEndpointGroupOutput) with field(s):
    ///   - [`endpoint_group(Option<EndpointGroup>)`](crate::output::DescribeEndpointGroupOutput::endpoint_group): <p>The description of an endpoint group.</p>
    /// - On failure, responds with [`SdkError<DescribeEndpointGroupError>`](crate::error::DescribeEndpointGroupError)
    pub fn describe_endpoint_group(&self) -> fluent_builders::DescribeEndpointGroup {
        fluent_builders::DescribeEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeListener`](crate::client::fluent_builders::DescribeListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeListener::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::DescribeListener::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
    /// - On success, responds with [`DescribeListenerOutput`](crate::output::DescribeListenerOutput) with field(s):
    ///   - [`listener(Option<Listener>)`](crate::output::DescribeListenerOutput::listener): <p>The description of a listener.</p>
    /// - On failure, responds with [`SdkError<DescribeListenerError>`](crate::error::DescribeListenerError)
    pub fn describe_listener(&self) -> fluent_builders::DescribeListener {
        fluent_builders::DescribeListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccelerators`](crate::client::fluent_builders::ListAccelerators) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccelerators::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccelerators::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccelerators::set_max_results): <p>The number of Global Accelerator objects that you want to return with this call. The default value is 10.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccelerators::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccelerators::set_next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On success, responds with [`ListAcceleratorsOutput`](crate::output::ListAcceleratorsOutput) with field(s):
    ///   - [`accelerators(Option<Vec<Accelerator>>)`](crate::output::ListAcceleratorsOutput::accelerators): <p>The list of accelerators for a customer account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAcceleratorsOutput::next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On failure, responds with [`SdkError<ListAcceleratorsError>`](crate::error::ListAcceleratorsError)
    pub fn list_accelerators(&self) -> fluent_builders::ListAccelerators {
        fluent_builders::ListAccelerators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListByoipCidrs`](crate::client::fluent_builders::ListByoipCidrs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListByoipCidrs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListByoipCidrs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListByoipCidrs::set_max_results): <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListByoipCidrs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListByoipCidrs::set_next_token): <p>The token for the next page of results.</p>
    /// - On success, responds with [`ListByoipCidrsOutput`](crate::output::ListByoipCidrsOutput) with field(s):
    ///   - [`byoip_cidrs(Option<Vec<ByoipCidr>>)`](crate::output::ListByoipCidrsOutput::byoip_cidrs): <p>Information about your address ranges.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListByoipCidrsOutput::next_token): <p>The token for the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListByoipCidrsError>`](crate::error::ListByoipCidrsError)
    pub fn list_byoip_cidrs(&self) -> fluent_builders::ListByoipCidrs {
        fluent_builders::ListByoipCidrs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCustomRoutingAccelerators`](crate::client::fluent_builders::ListCustomRoutingAccelerators) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCustomRoutingAccelerators::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCustomRoutingAccelerators::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCustomRoutingAccelerators::set_max_results): <p>The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingAccelerators::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingAccelerators::set_next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On success, responds with [`ListCustomRoutingAcceleratorsOutput`](crate::output::ListCustomRoutingAcceleratorsOutput) with field(s):
    ///   - [`accelerators(Option<Vec<CustomRoutingAccelerator>>)`](crate::output::ListCustomRoutingAcceleratorsOutput::accelerators): <p>The list of custom routing accelerators for a customer account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCustomRoutingAcceleratorsOutput::next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On failure, responds with [`SdkError<ListCustomRoutingAcceleratorsError>`](crate::error::ListCustomRoutingAcceleratorsError)
    pub fn list_custom_routing_accelerators(
        &self,
    ) -> fluent_builders::ListCustomRoutingAccelerators {
        fluent_builders::ListCustomRoutingAccelerators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCustomRoutingEndpointGroups`](crate::client::fluent_builders::ListCustomRoutingEndpointGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCustomRoutingEndpointGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingEndpointGroups::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingEndpointGroups::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener to list endpoint groups for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCustomRoutingEndpointGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCustomRoutingEndpointGroups::set_max_results): <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingEndpointGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingEndpointGroups::set_next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On success, responds with [`ListCustomRoutingEndpointGroupsOutput`](crate::output::ListCustomRoutingEndpointGroupsOutput) with field(s):
    ///   - [`endpoint_groups(Option<Vec<CustomRoutingEndpointGroup>>)`](crate::output::ListCustomRoutingEndpointGroupsOutput::endpoint_groups): <p>The list of the endpoint groups associated with a listener for a custom routing accelerator.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCustomRoutingEndpointGroupsOutput::next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On failure, responds with [`SdkError<ListCustomRoutingEndpointGroupsError>`](crate::error::ListCustomRoutingEndpointGroupsError)
    pub fn list_custom_routing_endpoint_groups(
        &self,
    ) -> fluent_builders::ListCustomRoutingEndpointGroups {
        fluent_builders::ListCustomRoutingEndpointGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCustomRoutingListeners`](crate::client::fluent_builders::ListCustomRoutingListeners) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCustomRoutingListeners::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingListeners::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingListeners::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the accelerator to list listeners for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCustomRoutingListeners::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCustomRoutingListeners::set_max_results): <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingListeners::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingListeners::set_next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On success, responds with [`ListCustomRoutingListenersOutput`](crate::output::ListCustomRoutingListenersOutput) with field(s):
    ///   - [`listeners(Option<Vec<CustomRoutingListener>>)`](crate::output::ListCustomRoutingListenersOutput::listeners): <p>The list of listeners for a custom routing accelerator.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCustomRoutingListenersOutput::next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On failure, responds with [`SdkError<ListCustomRoutingListenersError>`](crate::error::ListCustomRoutingListenersError)
    pub fn list_custom_routing_listeners(&self) -> fluent_builders::ListCustomRoutingListeners {
        fluent_builders::ListCustomRoutingListeners::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCustomRoutingPortMappings`](crate::client::fluent_builders::ListCustomRoutingPortMappings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCustomRoutingPortMappings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappings::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappings::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.</p>
    ///   - [`endpoint_group_arn(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappings::endpoint_group_arn) / [`set_endpoint_group_arn(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappings::set_endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCustomRoutingPortMappings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCustomRoutingPortMappings::set_max_results): <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappings::set_next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On success, responds with [`ListCustomRoutingPortMappingsOutput`](crate::output::ListCustomRoutingPortMappingsOutput) with field(s):
    ///   - [`port_mappings(Option<Vec<PortMapping>>)`](crate::output::ListCustomRoutingPortMappingsOutput::port_mappings): <p>The port mappings for a custom routing accelerator.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCustomRoutingPortMappingsOutput::next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On failure, responds with [`SdkError<ListCustomRoutingPortMappingsError>`](crate::error::ListCustomRoutingPortMappingsError)
    pub fn list_custom_routing_port_mappings(
        &self,
    ) -> fluent_builders::ListCustomRoutingPortMappings {
        fluent_builders::ListCustomRoutingPortMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCustomRoutingPortMappingsByDestination`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_id(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination::endpoint_id) / [`set_endpoint_id(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination::set_endpoint_id): <p>The ID for the virtual private cloud (VPC) subnet.</p>
    ///   - [`destination_address(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination::destination_address) / [`set_destination_address(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination::set_destination_address): <p>The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port mappings.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination::set_max_results): <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination::set_next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On success, responds with [`ListCustomRoutingPortMappingsByDestinationOutput`](crate::output::ListCustomRoutingPortMappingsByDestinationOutput) with field(s):
    ///   - [`destination_port_mappings(Option<Vec<DestinationPortMapping>>)`](crate::output::ListCustomRoutingPortMappingsByDestinationOutput::destination_port_mappings): <p>The port mappings for the endpoint IP address that you specified in the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCustomRoutingPortMappingsByDestinationOutput::next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On failure, responds with [`SdkError<ListCustomRoutingPortMappingsByDestinationError>`](crate::error::ListCustomRoutingPortMappingsByDestinationError)
    pub fn list_custom_routing_port_mappings_by_destination(
        &self,
    ) -> fluent_builders::ListCustomRoutingPortMappingsByDestination {
        fluent_builders::ListCustomRoutingPortMappingsByDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEndpointGroups`](crate::client::fluent_builders::ListEndpointGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEndpointGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::ListEndpointGroups::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::ListEndpointGroups::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEndpointGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEndpointGroups::set_max_results): <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEndpointGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEndpointGroups::set_next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On success, responds with [`ListEndpointGroupsOutput`](crate::output::ListEndpointGroupsOutput) with field(s):
    ///   - [`endpoint_groups(Option<Vec<EndpointGroup>>)`](crate::output::ListEndpointGroupsOutput::endpoint_groups): <p>The list of the endpoint groups associated with a listener.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEndpointGroupsOutput::next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On failure, responds with [`SdkError<ListEndpointGroupsError>`](crate::error::ListEndpointGroupsError)
    pub fn list_endpoint_groups(&self) -> fluent_builders::ListEndpointGroups {
        fluent_builders::ListEndpointGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListListeners`](crate::client::fluent_builders::ListListeners) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListListeners::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::ListListeners::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::ListListeners::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListListeners::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListListeners::set_max_results): <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListListeners::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListListeners::set_next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On success, responds with [`ListListenersOutput`](crate::output::ListListenersOutput) with field(s):
    ///   - [`listeners(Option<Vec<Listener>>)`](crate::output::ListListenersOutput::listeners): <p>The list of listeners for an accelerator.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListListenersOutput::next_token): <p>The token for the next set of results. You receive this token from a previous call.</p>
    /// - On failure, responds with [`SdkError<ListListenersError>`](crate::error::ListListenersError)
    pub fn list_listeners(&self) -> fluent_builders::ListListeners {
        fluent_builders::ListListeners::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN uniquely identifies an accelerator.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Root level tag for the Tags parameters.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ProvisionByoipCidr`](crate::client::fluent_builders::ProvisionByoipCidr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cidr(impl Into<String>)`](crate::client::fluent_builders::ProvisionByoipCidr::cidr) / [`set_cidr(Option<String>)`](crate::client::fluent_builders::ProvisionByoipCidr::set_cidr): <p>The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can specify is /24. The address range cannot overlap with another address range that you've brought to this or another Region.</p>
    ///   - [`cidr_authorization_context(CidrAuthorizationContext)`](crate::client::fluent_builders::ProvisionByoipCidr::cidr_authorization_context) / [`set_cidr_authorization_context(Option<CidrAuthorizationContext>)`](crate::client::fluent_builders::ProvisionByoipCidr::set_cidr_authorization_context): <p>A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. </p>
    /// - On success, responds with [`ProvisionByoipCidrOutput`](crate::output::ProvisionByoipCidrOutput) with field(s):
    ///   - [`byoip_cidr(Option<ByoipCidr>)`](crate::output::ProvisionByoipCidrOutput::byoip_cidr): <p>Information about the address range.</p>
    /// - On failure, responds with [`SdkError<ProvisionByoipCidrError>`](crate::error::ProvisionByoipCidrError)
    pub fn provision_byoip_cidr(&self) -> fluent_builders::ProvisionByoipCidr {
        fluent_builders::ProvisionByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveCustomRoutingEndpoints`](crate::client::fluent_builders::RemoveCustomRoutingEndpoints) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_ids(Vec<String>)`](crate::client::fluent_builders::RemoveCustomRoutingEndpoints::endpoint_ids) / [`set_endpoint_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveCustomRoutingEndpoints::set_endpoint_ids): <p>The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC) subnet IDs. </p>
    ///   - [`endpoint_group_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveCustomRoutingEndpoints::endpoint_group_arn) / [`set_endpoint_group_arn(Option<String>)`](crate::client::fluent_builders::RemoveCustomRoutingEndpoints::set_endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.</p>
    /// - On success, responds with [`RemoveCustomRoutingEndpointsOutput`](crate::output::RemoveCustomRoutingEndpointsOutput)

    /// - On failure, responds with [`SdkError<RemoveCustomRoutingEndpointsError>`](crate::error::RemoveCustomRoutingEndpointsError)
    pub fn remove_custom_routing_endpoints(&self) -> fluent_builders::RemoveCustomRoutingEndpoints {
        fluent_builders::RemoveCustomRoutingEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to add tags to. An ARN uniquely identifies a resource.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to a resource. A tag consists of a key and a value that you define.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to remove tags from. An ARN uniquely identifies a resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag key pairs that you want to remove from the specified resources.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAccelerator`](crate::client::fluent_builders::UpdateAccelerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAccelerator::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::UpdateAccelerator::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAccelerator::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAccelerator::set_name): <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
    ///   - [`ip_address_type(IpAddressType)`](crate::client::fluent_builders::UpdateAccelerator::ip_address_type) / [`set_ip_address_type(Option<IpAddressType>)`](crate::client::fluent_builders::UpdateAccelerator::set_ip_address_type): <p>The IP address type, which must be IPv4.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::UpdateAccelerator::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateAccelerator::set_enabled): <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>  <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    /// - On success, responds with [`UpdateAcceleratorOutput`](crate::output::UpdateAcceleratorOutput) with field(s):
    ///   - [`accelerator(Option<Accelerator>)`](crate::output::UpdateAcceleratorOutput::accelerator): <p>Information about the updated accelerator.</p>
    /// - On failure, responds with [`SdkError<UpdateAcceleratorError>`](crate::error::UpdateAcceleratorError)
    pub fn update_accelerator(&self) -> fluent_builders::UpdateAccelerator {
        fluent_builders::UpdateAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAcceleratorAttributes`](crate::client::fluent_builders::UpdateAcceleratorAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAcceleratorAttributes::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::UpdateAcceleratorAttributes::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the accelerator that you want to update.</p>
    ///   - [`flow_logs_enabled(bool)`](crate::client::fluent_builders::UpdateAcceleratorAttributes::flow_logs_enabled) / [`set_flow_logs_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateAcceleratorAttributes::set_flow_logs_enabled): <p>Update whether flow logs are enabled. The default value is false. If the value is true, <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    ///   - [`flow_logs_s3_bucket(impl Into<String>)`](crate::client::fluent_builders::UpdateAcceleratorAttributes::flow_logs_s3_bucket) / [`set_flow_logs_s3_bucket(Option<String>)`](crate::client::fluent_builders::UpdateAcceleratorAttributes::set_flow_logs_s3_bucket): <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket.</p>
    ///   - [`flow_logs_s3_prefix(impl Into<String>)`](crate::client::fluent_builders::UpdateAcceleratorAttributes::flow_logs_s3_prefix) / [`set_flow_logs_s3_prefix(Option<String>)`](crate::client::fluent_builders::UpdateAcceleratorAttributes::set_flow_logs_s3_prefix): <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. </p>  <p>If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>  <p>s3-bucket_name//AWSLogs/aws_account_id</p>
    /// - On success, responds with [`UpdateAcceleratorAttributesOutput`](crate::output::UpdateAcceleratorAttributesOutput) with field(s):
    ///   - [`accelerator_attributes(Option<AcceleratorAttributes>)`](crate::output::UpdateAcceleratorAttributesOutput::accelerator_attributes): <p>Updated attributes for the accelerator.</p>
    /// - On failure, responds with [`SdkError<UpdateAcceleratorAttributesError>`](crate::error::UpdateAcceleratorAttributesError)
    pub fn update_accelerator_attributes(&self) -> fluent_builders::UpdateAcceleratorAttributes {
        fluent_builders::UpdateAcceleratorAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCustomRoutingAccelerator`](crate::client::fluent_builders::UpdateCustomRoutingAccelerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomRoutingAccelerator::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::UpdateCustomRoutingAccelerator::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomRoutingAccelerator::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateCustomRoutingAccelerator::set_name): <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
    ///   - [`ip_address_type(IpAddressType)`](crate::client::fluent_builders::UpdateCustomRoutingAccelerator::ip_address_type) / [`set_ip_address_type(Option<IpAddressType>)`](crate::client::fluent_builders::UpdateCustomRoutingAccelerator::set_ip_address_type): <p>The value for the address type must be IPv4.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::UpdateCustomRoutingAccelerator::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateCustomRoutingAccelerator::set_enabled): <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>  <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    /// - On success, responds with [`UpdateCustomRoutingAcceleratorOutput`](crate::output::UpdateCustomRoutingAcceleratorOutput) with field(s):
    ///   - [`accelerator(Option<CustomRoutingAccelerator>)`](crate::output::UpdateCustomRoutingAcceleratorOutput::accelerator): <p>Information about the updated custom routing accelerator.</p>
    /// - On failure, responds with [`SdkError<UpdateCustomRoutingAcceleratorError>`](crate::error::UpdateCustomRoutingAcceleratorError)
    pub fn update_custom_routing_accelerator(
        &self,
    ) -> fluent_builders::UpdateCustomRoutingAccelerator {
        fluent_builders::UpdateCustomRoutingAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCustomRoutingAcceleratorAttributes`](crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`accelerator_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes::accelerator_arn) / [`set_accelerator_arn(Option<String>)`](crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes::set_accelerator_arn): <p>The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.</p>
    ///   - [`flow_logs_enabled(bool)`](crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes::flow_logs_enabled) / [`set_flow_logs_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes::set_flow_logs_enabled): <p>Update whether flow logs are enabled. The default value is false. If the value is true, <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    ///   - [`flow_logs_s3_bucket(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes::flow_logs_s3_bucket) / [`set_flow_logs_s3_bucket(Option<String>)`](crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes::set_flow_logs_s3_bucket): <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket.</p>
    ///   - [`flow_logs_s3_prefix(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes::flow_logs_s3_prefix) / [`set_flow_logs_s3_prefix(Option<String>)`](crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes::set_flow_logs_s3_prefix): <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. </p>  <p>If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>  <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
    /// - On success, responds with [`UpdateCustomRoutingAcceleratorAttributesOutput`](crate::output::UpdateCustomRoutingAcceleratorAttributesOutput) with field(s):
    ///   - [`accelerator_attributes(Option<CustomRoutingAcceleratorAttributes>)`](crate::output::UpdateCustomRoutingAcceleratorAttributesOutput::accelerator_attributes): <p>Updated custom routing accelerator.</p>
    /// - On failure, responds with [`SdkError<UpdateCustomRoutingAcceleratorAttributesError>`](crate::error::UpdateCustomRoutingAcceleratorAttributesError)
    pub fn update_custom_routing_accelerator_attributes(
        &self,
    ) -> fluent_builders::UpdateCustomRoutingAcceleratorAttributes {
        fluent_builders::UpdateCustomRoutingAcceleratorAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCustomRoutingListener`](crate::client::fluent_builders::UpdateCustomRoutingListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateCustomRoutingListener::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::UpdateCustomRoutingListener::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener to update.</p>
    ///   - [`port_ranges(Vec<PortRange>)`](crate::client::fluent_builders::UpdateCustomRoutingListener::port_ranges) / [`set_port_ranges(Option<Vec<PortRange>>)`](crate::client::fluent_builders::UpdateCustomRoutingListener::set_port_ranges): <p>The updated port range to support for connections from clients to your accelerator. If you remove ports that are currently being used by a subnet endpoint, the call fails.</p>  <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About endpoints for custom routing accelerators</a>.</p>
    /// - On success, responds with [`UpdateCustomRoutingListenerOutput`](crate::output::UpdateCustomRoutingListenerOutput) with field(s):
    ///   - [`listener(Option<CustomRoutingListener>)`](crate::output::UpdateCustomRoutingListenerOutput::listener): <p>Information for the updated listener for a custom routing accelerator.</p>
    /// - On failure, responds with [`SdkError<UpdateCustomRoutingListenerError>`](crate::error::UpdateCustomRoutingListenerError)
    pub fn update_custom_routing_listener(&self) -> fluent_builders::UpdateCustomRoutingListener {
        fluent_builders::UpdateCustomRoutingListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEndpointGroup`](crate::client::fluent_builders::UpdateEndpointGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_group_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateEndpointGroup::endpoint_group_arn) / [`set_endpoint_group_arn(Option<String>)`](crate::client::fluent_builders::UpdateEndpointGroup::set_endpoint_group_arn): <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    ///   - [`endpoint_configurations(Vec<EndpointConfiguration>)`](crate::client::fluent_builders::UpdateEndpointGroup::endpoint_configurations) / [`set_endpoint_configurations(Option<Vec<EndpointConfiguration>>)`](crate::client::fluent_builders::UpdateEndpointGroup::set_endpoint_configurations): <p>The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.</p>
    ///   - [`traffic_dial_percentage(f32)`](crate::client::fluent_builders::UpdateEndpointGroup::traffic_dial_percentage) / [`set_traffic_dial_percentage(Option<f32>)`](crate::client::fluent_builders::UpdateEndpointGroup::set_traffic_dial_percentage): <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. </p>  <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>  <p>The default value is 100.</p>
    ///   - [`health_check_port(i32)`](crate::client::fluent_builders::UpdateEndpointGroup::health_check_port) / [`set_health_check_port(Option<i32>)`](crate::client::fluent_builders::UpdateEndpointGroup::set_health_check_port): <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses the first port in the list.</p>
    ///   - [`health_check_protocol(HealthCheckProtocol)`](crate::client::fluent_builders::UpdateEndpointGroup::health_check_protocol) / [`set_health_check_protocol(Option<HealthCheckProtocol>)`](crate::client::fluent_builders::UpdateEndpointGroup::set_health_check_protocol): <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.</p>
    ///   - [`health_check_path(impl Into<String>)`](crate::client::fluent_builders::UpdateEndpointGroup::health_check_path) / [`set_health_check_path(Option<String>)`](crate::client::fluent_builders::UpdateEndpointGroup::set_health_check_path): <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/).</p>
    ///   - [`health_check_interval_seconds(i32)`](crate::client::fluent_builders::UpdateEndpointGroup::health_check_interval_seconds) / [`set_health_check_interval_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateEndpointGroup::set_health_check_interval_seconds): <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
    ///   - [`threshold_count(i32)`](crate::client::fluent_builders::UpdateEndpointGroup::threshold_count) / [`set_threshold_count(Option<i32>)`](crate::client::fluent_builders::UpdateEndpointGroup::set_threshold_count): <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.</p>
    ///   - [`port_overrides(Vec<PortOverride>)`](crate::client::fluent_builders::UpdateEndpointGroup::port_overrides) / [`set_port_overrides(Option<Vec<PortOverride>>)`](crate::client::fluent_builders::UpdateEndpointGroup::set_port_overrides): <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html"> Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    /// - On success, responds with [`UpdateEndpointGroupOutput`](crate::output::UpdateEndpointGroupOutput) with field(s):
    ///   - [`endpoint_group(Option<EndpointGroup>)`](crate::output::UpdateEndpointGroupOutput::endpoint_group): <p>The information about the endpoint group that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateEndpointGroupError>`](crate::error::UpdateEndpointGroupError)
    pub fn update_endpoint_group(&self) -> fluent_builders::UpdateEndpointGroup {
        fluent_builders::UpdateEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateListener`](crate::client::fluent_builders::UpdateListener) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`listener_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateListener::listener_arn) / [`set_listener_arn(Option<String>)`](crate::client::fluent_builders::UpdateListener::set_listener_arn): <p>The Amazon Resource Name (ARN) of the listener to update.</p>
    ///   - [`port_ranges(Vec<PortRange>)`](crate::client::fluent_builders::UpdateListener::port_ranges) / [`set_port_ranges(Option<Vec<PortRange>>)`](crate::client::fluent_builders::UpdateListener::set_port_ranges): <p>The updated list of port ranges for the connections from clients to the accelerator.</p>
    ///   - [`protocol(Protocol)`](crate::client::fluent_builders::UpdateListener::protocol) / [`set_protocol(Option<Protocol>)`](crate::client::fluent_builders::UpdateListener::set_protocol): <p>The updated protocol for the connections from clients to the accelerator.</p>
    ///   - [`client_affinity(ClientAffinity)`](crate::client::fluent_builders::UpdateListener::client_affinity) / [`set_client_affinity(Option<ClientAffinity>)`](crate::client::fluent_builders::UpdateListener::set_client_affinity): <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint.</p>  <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes. </p>  <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.</p>  <p>The default value is <code>NONE</code>.</p>
    /// - On success, responds with [`UpdateListenerOutput`](crate::output::UpdateListenerOutput) with field(s):
    ///   - [`listener(Option<Listener>)`](crate::output::UpdateListenerOutput::listener): <p>Information for the updated listener.</p>
    /// - On failure, responds with [`SdkError<UpdateListenerError>`](crate::error::UpdateListenerError)
    pub fn update_listener(&self) -> fluent_builders::UpdateListener {
        fluent_builders::UpdateListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`WithdrawByoipCidr`](crate::client::fluent_builders::WithdrawByoipCidr) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cidr(impl Into<String>)`](crate::client::fluent_builders::WithdrawByoipCidr::cidr) / [`set_cidr(Option<String>)`](crate::client::fluent_builders::WithdrawByoipCidr::set_cidr): <p>The address range, in CIDR notation.</p>
    /// - On success, responds with [`WithdrawByoipCidrOutput`](crate::output::WithdrawByoipCidrOutput) with field(s):
    ///   - [`byoip_cidr(Option<ByoipCidr>)`](crate::output::WithdrawByoipCidrOutput::byoip_cidr): <p>Information about the address pool.</p>
    /// - On failure, responds with [`SdkError<WithdrawByoipCidrError>`](crate::error::WithdrawByoipCidrError)
    pub fn withdraw_byoip_cidr(&self) -> fluent_builders::WithdrawByoipCidr {
        fluent_builders::WithdrawByoipCidr::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddCustomRoutingEndpoints`.
    ///
    /// <p>Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.</p>
    /// <p>The listener port range must be large enough to support the number of IP addresses that can be specified in your subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For example, a subnet defined as /24 requires a listener port range of at least 255 ports. </p>
    /// <p>Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail with a LimitExceededException.</p>
    /// <p>By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html"> AllowCustomRoutingTraffic</a> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddCustomRoutingEndpoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_custom_routing_endpoints_input::Builder,
    }
    impl AddCustomRoutingEndpoints {
        /// Creates a new `AddCustomRoutingEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddCustomRoutingEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddCustomRoutingEndpointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EndpointConfigurations`.
        ///
        /// To override the contents of this collection use [`set_endpoint_configurations`](Self::set_endpoint_configurations).
        ///
        /// <p>The list of endpoint objects to add to a custom routing accelerator.</p>
        pub fn endpoint_configurations(
            mut self,
            input: crate::model::CustomRoutingEndpointConfiguration,
        ) -> Self {
            self.inner = self.inner.endpoint_configurations(input);
            self
        }
        /// <p>The list of endpoint objects to add to a custom routing accelerator.</p>
        pub fn set_endpoint_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CustomRoutingEndpointConfiguration>,
            >,
        ) -> Self {
            self.inner = self.inner.set_endpoint_configurations(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdvertiseByoipCidr`.
    ///
    /// <p>Advertises an IPv4 address range that is provisioned for use with your AWS resources through bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts routing to AWS because of propagation delays. </p>
    /// <p>To stop advertising the BYOIP address range, use <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html"> WithdrawByoipCidr</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AdvertiseByoipCidr {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::advertise_byoip_cidr_input::Builder,
    }
    impl AdvertiseByoipCidr {
        /// Creates a new `AdvertiseByoipCidr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdvertiseByoipCidrOutput,
            aws_smithy_http::result::SdkError<crate::error::AdvertiseByoipCidrError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(input.into());
            self
        }
        /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can't advertise only a portion of the provisioned range.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllowCustomRoutingTraffic`.
    ///
    /// <p>Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.</p>
    /// <p>After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AllowCustomRoutingTraffic {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::allow_custom_routing_traffic_input::Builder,
    }
    impl AllowCustomRoutingTraffic {
        /// Creates a new `AllowCustomRoutingTraffic`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllowCustomRoutingTrafficOutput,
            aws_smithy_http::result::SdkError<crate::error::AllowCustomRoutingTrafficError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(input.into());
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
        /// Appends an item to `DestinationAddresses`.
        ///
        /// To override the contents of this collection use [`set_destination_addresses`](Self::set_destination_addresses).
        ///
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.</p>
        /// <p> <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or is not specified.</p>
        pub fn destination_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_addresses(input.into());
            self
        }
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.</p>
        /// <p> <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or is not specified.</p>
        pub fn set_destination_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_destination_addresses(input);
            self
        }
        /// Appends an item to `DestinationPorts`.
        ///
        /// To override the contents of this collection use [`set_destination_ports`](Self::set_destination_ports).
        ///
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.</p>
        pub fn destination_ports(mut self, input: i32) -> Self {
            self.inner = self.inner.destination_ports(input);
            self
        }
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.</p>
        pub fn set_destination_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.inner = self.inner.set_destination_ports(input);
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn allow_all_traffic_to_endpoint(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_all_traffic_to_endpoint(input);
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn set_allow_all_traffic_to_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_allow_all_traffic_to_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccelerator`.
    ///
    /// <p>Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers. </p> <important>
    /// <p>Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the US West (Oregon) Region to create or update accelerators.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccelerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_accelerator_input::Builder,
    }
    impl CreateAccelerator {
        /// Creates a new `CreateAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAcceleratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// Appends an item to `IpAddresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only one IP address from your IP address range, Global Accelerator assigns a second static IP address for the accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_addresses(input.into());
            self
        }
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only one IP address from your IP address range, Global Accelerator assigns a second static IP address for the accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ip_addresses(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of an accelerator.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of an accelerator.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomRoutingAccelerator`.
    ///
    /// <p>Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.</p>
    /// <p>Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html"> AllowCustomRoutingTraffic</a> operation.</p> <important>
    /// <p>Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the US West (Oregon) Region to create or update accelerators.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomRoutingAccelerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_custom_routing_accelerator_input::Builder,
    }
    impl CreateCustomRoutingAccelerator {
        /// Creates a new `CreateCustomRoutingAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomRoutingAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomRoutingAcceleratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// Appends an item to `IpAddresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only one IP address from your IP address range, Global Accelerator assigns a second static IP address for the accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_addresses(input.into());
            self
        }
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only one IP address from your IP address range, Global Accelerator assigns a second static IP address for the accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ip_addresses(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomRoutingEndpointGroup`.
    ///
    /// <p>Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a collection of endpoints in one AWS Region. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomRoutingEndpointGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_custom_routing_endpoint_group_input::Builder,
    }
    impl CreateCustomRoutingEndpointGroup {
        /// Creates a new `CreateCustomRoutingEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomRoutingEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomRoutingEndpointGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific Region.</p>
        pub fn endpoint_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_region(input.into());
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific Region.</p>
        pub fn set_endpoint_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_region(input);
            self
        }
        /// Appends an item to `DestinationConfigurations`.
        ///
        /// To override the contents of this collection use [`set_destination_configurations`](Self::set_destination_configurations).
        ///
        /// <p>Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept client traffic on.</p>
        pub fn destination_configurations(
            mut self,
            input: crate::model::CustomRoutingDestinationConfiguration,
        ) -> Self {
            self.inner = self.inner.destination_configurations(input);
            self
        }
        /// <p>Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept client traffic on.</p>
        pub fn set_destination_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CustomRoutingDestinationConfiguration>,
            >,
        ) -> Self {
            self.inner = self.inner.set_destination_configurations(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomRoutingListener`.
    ///
    /// <p>Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive to assigned static IP addresses on the port range that you specify. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomRoutingListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_custom_routing_listener_input::Builder,
    }
    impl CreateCustomRoutingListener {
        /// Creates a new `CreateCustomRoutingListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomRoutingListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomRoutingListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// Appends an item to `PortRanges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The port range to support for connections from clients to your accelerator.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About endpoints for custom routing accelerators</a>.</p>
        pub fn port_ranges(mut self, input: crate::model::PortRange) -> Self {
            self.inner = self.inner.port_ranges(input);
            self
        }
        /// <p>The port range to support for connections from clients to your accelerator.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About endpoints for custom routing accelerators</a>.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.inner = self.inner.set_port_ranges(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEndpointGroup`.
    ///
    /// <p>Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one AWS Region. A resource must be valid and active when you add it as an endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEndpointGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_endpoint_group_input::Builder,
    }
    impl CreateEndpointGroup {
        /// Creates a new `CreateEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEndpointGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific Region.</p>
        pub fn endpoint_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_region(input.into());
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a specific Region.</p>
        pub fn set_endpoint_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_region(input);
            self
        }
        /// Appends an item to `EndpointConfigurations`.
        ///
        /// To override the contents of this collection use [`set_endpoint_configurations`](Self::set_endpoint_configurations).
        ///
        /// <p>The list of endpoint objects.</p>
        pub fn endpoint_configurations(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.inner = self.inner.endpoint_configurations(input);
            self
        }
        /// <p>The list of endpoint objects.</p>
        pub fn set_endpoint_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_configurations(input);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn traffic_dial_percentage(mut self, input: f32) -> Self {
            self.inner = self.inner.traffic_dial_percentage(input);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn set_traffic_dial_percentage(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_traffic_dial_percentage(input);
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the first port in the list.</p>
        pub fn health_check_port(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_port(input);
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the first port in the list.</p>
        pub fn set_health_check_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_health_check_port(input);
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.</p>
        pub fn health_check_protocol(mut self, input: crate::model::HealthCheckProtocol) -> Self {
            self.inner = self.inner.health_check_protocol(input);
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::HealthCheckProtocol>,
        ) -> Self {
            self.inner = self.inner.set_health_check_protocol(input);
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/).</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_path(input.into());
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/).</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_path(input);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_interval_seconds(input);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_health_check_interval_seconds(input);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn threshold_count(mut self, input: i32) -> Self {
            self.inner = self.inner.threshold_count(input);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn set_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_threshold_count(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// Appends an item to `PortOverrides`.
        ///
        /// To override the contents of this collection use [`set_port_overrides`](Self::set_port_overrides).
        ///
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html"> Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn port_overrides(mut self, input: crate::model::PortOverride) -> Self {
            self.inner = self.inner.port_overrides(input);
            self
        }
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html"> Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_port_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
        ) -> Self {
            self.inner = self.inner.set_port_overrides(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateListener`.
    ///
    /// <p>Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static IP addresses on a port, port range, or list of port ranges that you specify. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_listener_input::Builder,
    }
    impl CreateListener {
        /// Creates a new `CreateListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of your accelerator.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of your accelerator.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// Appends an item to `PortRanges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The list of port ranges to support for connections from clients to your accelerator.</p>
        pub fn port_ranges(mut self, input: crate::model::PortRange) -> Self {
            self.inner = self.inner.port_ranges(input);
            self
        }
        /// <p>The list of port ranges to support for connections from clients to your accelerator.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.inner = self.inner.set_port_ranges(input);
            self
        }
        /// <p>The protocol for connections from clients to your accelerator.</p>
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The protocol for connections from clients to your accelerator.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn client_affinity(mut self, input: crate::model::ClientAffinity) -> Self {
            self.inner = self.inner.client_affinity(input);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn set_client_affinity(
            mut self,
            input: std::option::Option<crate::model::ClientAffinity>,
        ) -> Self {
            self.inner = self.inner.set_client_affinity(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccelerator`.
    ///
    /// <p>Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set <code>Enabled</code> to false.</p> <important>
    /// <p>When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses from those ranges. </p>
    /// <p>The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccelerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_accelerator_input::Builder,
    }
    impl DeleteAccelerator {
        /// Creates a new `DeleteAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAcceleratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of an accelerator.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an accelerator.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomRoutingAccelerator`.
    ///
    /// <p>Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set <code>Enabled</code> to false.</p> <important>
    /// <p>When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two static IP addresses. </p>
    /// <p>The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomRoutingAccelerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_custom_routing_accelerator_input::Builder,
    }
    impl DeleteCustomRoutingAccelerator {
        /// Creates a new `DeleteCustomRoutingAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomRoutingAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomRoutingAcceleratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to delete.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to delete.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomRoutingEndpointGroup`.
    ///
    /// <p>Delete an endpoint group from a listener for a custom routing accelerator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomRoutingEndpointGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_custom_routing_endpoint_group_input::Builder,
    }
    impl DeleteCustomRoutingEndpointGroup {
        /// Creates a new `DeleteCustomRoutingEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomRoutingEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomRoutingEndpointGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomRoutingListener`.
    ///
    /// <p>Delete a listener for a custom routing accelerator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomRoutingListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_custom_routing_listener_input::Builder,
    }
    impl DeleteCustomRoutingListener {
        /// Creates a new `DeleteCustomRoutingListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomRoutingListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomRoutingListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to delete.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to delete.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpointGroup`.
    ///
    /// <p>Delete an endpoint group from a listener.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEndpointGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_endpoint_group_input::Builder,
    }
    impl DeleteEndpointGroup {
        /// Creates a new `DeleteEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteListener`.
    ///
    /// <p>Delete a listener from an accelerator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_listener_input::Builder,
    }
    impl DeleteListener {
        /// Creates a new `DeleteListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DenyCustomRoutingTraffic`.
    ///
    /// <p>Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.</p>
    /// <p>After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DenyCustomRoutingTraffic {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deny_custom_routing_traffic_input::Builder,
    }
    impl DenyCustomRoutingTraffic {
        /// Creates a new `DenyCustomRoutingTraffic`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DenyCustomRoutingTrafficOutput,
            aws_smithy_http::result::SdkError<crate::error::DenyCustomRoutingTrafficError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(input.into());
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
        /// Appends an item to `DestinationAddresses`.
        ///
        /// To override the contents of this collection use [`set_destination_addresses`](Self::set_destination_addresses).
        ///
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the endpoint group.</p>
        pub fn destination_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_addresses(input.into());
            self
        }
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the endpoint group.</p>
        pub fn set_destination_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_destination_addresses(input);
            self
        }
        /// Appends an item to `DestinationPorts`.
        ///
        /// To override the contents of this collection use [`set_destination_ports`](Self::set_destination_ports).
        ///
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from receiving traffic.</p>
        pub fn destination_ports(mut self, input: i32) -> Self {
            self.inner = self.inner.destination_ports(input);
            self
        }
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from receiving traffic.</p>
        pub fn set_destination_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.inner = self.inner.set_destination_ports(input);
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i> receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn deny_all_traffic_to_endpoint(mut self, input: bool) -> Self {
            self.inner = self.inner.deny_all_traffic_to_endpoint(input);
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i> receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn set_deny_all_traffic_to_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_deny_all_traffic_to_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprovisionByoipCidr`.
    ///
    /// <p>Releases the specified address range that you provisioned to use with your AWS resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool. </p>
    /// <p>Before you can release an address range, you must stop advertising it by using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr</a> and you must not have any accelerators that are using static IP addresses allocated from its address range. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeprovisionByoipCidr {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deprovision_byoip_cidr_input::Builder,
    }
    impl DeprovisionByoipCidr {
        /// Creates a new `DeprovisionByoipCidr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprovisionByoipCidrOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprovisionByoipCidrError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified when you provisioned the address range.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(input.into());
            self
        }
        /// <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified when you provisioned the address range.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccelerator`.
    ///
    /// <p>Describe an accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccelerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_accelerator_input::Builder,
    }
    impl DescribeAccelerator {
        /// Creates a new `DescribeAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAcceleratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAcceleratorAttributes`.
    ///
    /// <p>Describe the attributes of an accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAcceleratorAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_accelerator_attributes_input::Builder,
    }
    impl DescribeAcceleratorAttributes {
        /// Creates a new `DescribeAcceleratorAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAcceleratorAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAcceleratorAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator with the attributes that you want to describe.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator with the attributes that you want to describe.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomRoutingAccelerator`.
    ///
    /// <p>Describe a custom routing accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCustomRoutingAccelerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_custom_routing_accelerator_input::Builder,
    }
    impl DescribeCustomRoutingAccelerator {
        /// Creates a new `DescribeCustomRoutingAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomRoutingAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomRoutingAcceleratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomRoutingAcceleratorAttributes`.
    ///
    /// <p>Describe the attributes of a custom routing accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCustomRoutingAcceleratorAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_custom_routing_accelerator_attributes_input::Builder,
    }
    impl DescribeCustomRoutingAcceleratorAttributes {
        /// Creates a new `DescribeCustomRoutingAcceleratorAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomRoutingAcceleratorAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeCustomRoutingAcceleratorAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomRoutingEndpointGroup`.
    ///
    /// <p>Describe an endpoint group for a custom routing accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCustomRoutingEndpointGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_custom_routing_endpoint_group_input::Builder,
    }
    impl DescribeCustomRoutingEndpointGroup {
        /// Creates a new `DescribeCustomRoutingEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomRoutingEndpointGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeCustomRoutingEndpointGroupError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomRoutingListener`.
    ///
    /// <p>The description of a listener for a custom routing accelerator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCustomRoutingListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_custom_routing_listener_input::Builder,
    }
    impl DescribeCustomRoutingListener {
        /// Creates a new `DescribeCustomRoutingListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomRoutingListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomRoutingListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointGroup`.
    ///
    /// <p>Describe an endpoint group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpointGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_endpoint_group_input::Builder,
    }
    impl DescribeEndpointGroup {
        /// Creates a new `DescribeEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeListener`.
    ///
    /// <p>Describe a listener. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_listener_input::Builder,
    }
    impl DescribeListener {
        /// Creates a new `DescribeListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccelerators`.
    ///
    /// <p>List the accelerators for an AWS account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccelerators {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_accelerators_input::Builder,
    }
    impl ListAccelerators {
        /// Creates a new `ListAccelerators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAcceleratorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAcceleratorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAcceleratorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAcceleratorsPaginator {
            crate::paginator::ListAcceleratorsPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListByoipCidrs`.
    ///
    /// <p>Lists the IP address ranges that were specified in calls to <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>, including the current state and a history of state changes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListByoipCidrs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_byoip_cidrs_input::Builder,
    }
    impl ListByoipCidrs {
        /// Creates a new `ListByoipCidrs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListByoipCidrsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListByoipCidrsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListByoipCidrsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListByoipCidrsPaginator {
            crate::paginator::ListByoipCidrsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomRoutingAccelerators`.
    ///
    /// <p>List the custom routing accelerators for an AWS account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomRoutingAccelerators {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_custom_routing_accelerators_input::Builder,
    }
    impl ListCustomRoutingAccelerators {
        /// Creates a new `ListCustomRoutingAccelerators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomRoutingAcceleratorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingAcceleratorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomRoutingAcceleratorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCustomRoutingAcceleratorsPaginator {
            crate::paginator::ListCustomRoutingAcceleratorsPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomRoutingEndpointGroups`.
    ///
    /// <p>List the endpoint groups that are associated with a listener for a custom routing accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomRoutingEndpointGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_custom_routing_endpoint_groups_input::Builder,
    }
    impl ListCustomRoutingEndpointGroups {
        /// Creates a new `ListCustomRoutingEndpointGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomRoutingEndpointGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingEndpointGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomRoutingEndpointGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCustomRoutingEndpointGroupsPaginator {
            crate::paginator::ListCustomRoutingEndpointGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to list endpoint groups for.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to list endpoint groups for.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomRoutingListeners`.
    ///
    /// <p>List the listeners for a custom routing accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomRoutingListeners {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_custom_routing_listeners_input::Builder,
    }
    impl ListCustomRoutingListeners {
        /// Creates a new `ListCustomRoutingListeners`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomRoutingListenersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingListenersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomRoutingListenersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCustomRoutingListenersPaginator {
            crate::paginator::ListCustomRoutingListenersPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list listeners for.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list listeners for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomRoutingPortMappings`.
    ///
    /// <p>Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers. </p>
    /// <p>If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created when you add the subnet to Global Accelerator.</p>
    /// <p>The mappings also include a flag for each destination denoting which destination IP addresses and ports are allowed or denied traffic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomRoutingPortMappings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_custom_routing_port_mappings_input::Builder,
    }
    impl ListCustomRoutingPortMappings {
        /// Creates a new `ListCustomRoutingPortMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomRoutingPortMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingPortMappingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomRoutingPortMappingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCustomRoutingPortMappingsPaginator {
            crate::paginator::ListCustomRoutingPortMappingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomRoutingPortMappingsByDestination`.
    ///
    /// <p>List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a specific destination instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomRoutingPortMappingsByDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_custom_routing_port_mappings_by_destination_input::Builder,
    }
    impl ListCustomRoutingPortMappingsByDestination {
        /// Creates a new `ListCustomRoutingPortMappingsByDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomRoutingPortMappingsByDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListCustomRoutingPortMappingsByDestinationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomRoutingPortMappingsByDestinationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListCustomRoutingPortMappingsByDestinationPaginator {
            crate::paginator::ListCustomRoutingPortMappingsByDestinationPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(input.into());
            self
        }
        /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
        /// <p>The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port mappings.</p>
        pub fn destination_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_address(input.into());
            self
        }
        /// <p>The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port mappings.</p>
        pub fn set_destination_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_address(input);
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEndpointGroups`.
    ///
    /// <p>List the endpoint groups that are associated with a listener. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEndpointGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_endpoint_groups_input::Builder,
    }
    impl ListEndpointGroups {
        /// Creates a new `ListEndpointGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEndpointGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEndpointGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEndpointGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEndpointGroupsPaginator {
            crate::paginator::ListEndpointGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListListeners`.
    ///
    /// <p>List the listeners for an accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListListeners {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_listeners_input::Builder,
    }
    impl ListListeners {
        /// Creates a new `ListListeners`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListListenersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListListenersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListListenersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListListenersPaginator {
            crate::paginator::ListListenersPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List all tags for an accelerator. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN uniquely identifies an accelerator.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN uniquely identifies an accelerator.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ProvisionByoipCidr`.
    ///
    /// <p>Provisions an IP address range to use with your AWS resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html"> AdvertiseByoipCidr</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ProvisionByoipCidr {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::provision_byoip_cidr_input::Builder,
    }
    impl ProvisionByoipCidr {
        /// Creates a new `ProvisionByoipCidr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ProvisionByoipCidrOutput,
            aws_smithy_http::result::SdkError<crate::error::ProvisionByoipCidrError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can specify is /24. The address range cannot overlap with another address range that you've brought to this or another Region.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(input.into());
            self
        }
        /// <p>The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can specify is /24. The address range cannot overlap with another address range that you've brought to this or another Region.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
        /// <p>A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. </p>
        pub fn cidr_authorization_context(
            mut self,
            input: crate::model::CidrAuthorizationContext,
        ) -> Self {
            self.inner = self.inner.cidr_authorization_context(input);
            self
        }
        /// <p>A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. </p>
        pub fn set_cidr_authorization_context(
            mut self,
            input: std::option::Option<crate::model::CidrAuthorizationContext>,
        ) -> Self {
            self.inner = self.inner.set_cidr_authorization_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveCustomRoutingEndpoints`.
    ///
    /// <p>Remove endpoints from a custom routing accelerator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveCustomRoutingEndpoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_custom_routing_endpoints_input::Builder,
    }
    impl RemoveCustomRoutingEndpoints {
        /// Creates a new `RemoveCustomRoutingEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveCustomRoutingEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveCustomRoutingEndpointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EndpointIds`.
        ///
        /// To override the contents of this collection use [`set_endpoint_ids`](Self::set_endpoint_ids).
        ///
        /// <p>The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC) subnet IDs. </p>
        pub fn endpoint_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_ids(input.into());
            self
        }
        /// <p>The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC) subnet IDs. </p>
        pub fn set_endpoint_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_ids(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add tags to an accelerator resource. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to add tags to. An ARN uniquely identifies a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to add tags to. An ARN uniquely identifies a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to a resource. A tag consists of a key and a value that you define.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to a resource. A tag consists of a key and a value that you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was already removed.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to remove tags from. An ARN uniquely identifies a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to remove tags from. An ARN uniquely identifies a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key pairs that you want to remove from the specified resources.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag key pairs that you want to remove from the specified resources.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccelerator`.
    ///
    /// <p>Update an accelerator. </p> <important>
    /// <p>Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the US West (Oregon) Region to create or update accelerators.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAccelerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_accelerator_input::Builder,
    }
    impl UpdateAccelerator {
        /// Creates a new `UpdateAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAcceleratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The IP address type, which must be IPv4.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>The IP address type, which must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAcceleratorAttributes`.
    ///
    /// <p>Update the attributes for an accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAcceleratorAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_accelerator_attributes_input::Builder,
    }
    impl UpdateAcceleratorAttributes {
        /// Creates a new `UpdateAcceleratorAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAcceleratorAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAcceleratorAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator that you want to update.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator that you want to update.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true, <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn flow_logs_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.flow_logs_enabled(input);
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true, <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_flow_logs_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_flow_logs_enabled(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket.</p>
        pub fn flow_logs_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_logs_s3_bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket.</p>
        pub fn set_flow_logs_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_logs_s3_bucket(input);
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
        pub fn flow_logs_s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_logs_s3_prefix(input.into());
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
        pub fn set_flow_logs_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_logs_s3_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomRoutingAccelerator`.
    ///
    /// <p>Update a custom routing accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCustomRoutingAccelerator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_custom_routing_accelerator_input::Builder,
    }
    impl UpdateCustomRoutingAccelerator {
        /// Creates a new `UpdateCustomRoutingAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomRoutingAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCustomRoutingAcceleratorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomRoutingAcceleratorAttributes`.
    ///
    /// <p>Update the attributes for a custom routing accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCustomRoutingAcceleratorAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_custom_routing_accelerator_attributes_input::Builder,
    }
    impl UpdateCustomRoutingAcceleratorAttributes {
        /// Creates a new `UpdateCustomRoutingAcceleratorAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomRoutingAcceleratorAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateCustomRoutingAcceleratorAttributesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true, <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn flow_logs_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.flow_logs_enabled(input);
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true, <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_flow_logs_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_flow_logs_enabled(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket.</p>
        pub fn flow_logs_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_logs_s3_bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the bucket.</p>
        pub fn set_flow_logs_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_logs_s3_bucket(input);
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
        pub fn flow_logs_s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_logs_s3_prefix(input.into());
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
        pub fn set_flow_logs_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_logs_s3_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomRoutingListener`.
    ///
    /// <p>Update a listener for a custom routing accelerator. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCustomRoutingListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_custom_routing_listener_input::Builder,
    }
    impl UpdateCustomRoutingListener {
        /// Creates a new `UpdateCustomRoutingListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomRoutingListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCustomRoutingListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `PortRanges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The updated port range to support for connections from clients to your accelerator. If you remove ports that are currently being used by a subnet endpoint, the call fails.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About endpoints for custom routing accelerators</a>.</p>
        pub fn port_ranges(mut self, input: crate::model::PortRange) -> Self {
            self.inner = self.inner.port_ranges(input);
            self
        }
        /// <p>The updated port range to support for connections from clients to your accelerator. If you remove ports that are currently being used by a subnet endpoint, the call fails.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About endpoints for custom routing accelerators</a>.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.inner = self.inner.set_port_ranges(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEndpointGroup`.
    ///
    /// <p>Update an endpoint group. A resource must be valid and active when you add it as an endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEndpointGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_endpoint_group_input::Builder,
    }
    impl UpdateEndpointGroup {
        /// Creates a new `UpdateEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEndpointGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
        /// Appends an item to `EndpointConfigurations`.
        ///
        /// To override the contents of this collection use [`set_endpoint_configurations`](Self::set_endpoint_configurations).
        ///
        /// <p>The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.</p>
        pub fn endpoint_configurations(
            mut self,
            input: crate::model::EndpointConfiguration,
        ) -> Self {
            self.inner = self.inner.endpoint_configurations(input);
            self
        }
        /// <p>The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.</p>
        pub fn set_endpoint_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_configurations(input);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn traffic_dial_percentage(mut self, input: f32) -> Self {
            self.inner = self.inner.traffic_dial_percentage(input);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn set_traffic_dial_percentage(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_traffic_dial_percentage(input);
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses the first port in the list.</p>
        pub fn health_check_port(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_port(input);
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses the first port in the list.</p>
        pub fn set_health_check_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_health_check_port(input);
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.</p>
        pub fn health_check_protocol(mut self, input: crate::model::HealthCheckProtocol) -> Self {
            self.inner = self.inner.health_check_protocol(input);
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::HealthCheckProtocol>,
        ) -> Self {
            self.inner = self.inner.set_health_check_protocol(input);
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/).</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_path(input.into());
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/).</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_path(input);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_interval_seconds(input);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_health_check_interval_seconds(input);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn threshold_count(mut self, input: i32) -> Self {
            self.inner = self.inner.threshold_count(input);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn set_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_threshold_count(input);
            self
        }
        /// Appends an item to `PortOverrides`.
        ///
        /// To override the contents of this collection use [`set_port_overrides`](Self::set_port_overrides).
        ///
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html"> Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn port_overrides(mut self, input: crate::model::PortOverride) -> Self {
            self.inner = self.inner.port_overrides(input);
            self
        }
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html"> Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_port_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
        ) -> Self {
            self.inner = self.inner.set_port_overrides(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateListener`.
    ///
    /// <p>Update a listener. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateListener {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_listener_input::Builder,
    }
    impl UpdateListener {
        /// Creates a new `UpdateListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateListenerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `PortRanges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The updated list of port ranges for the connections from clients to the accelerator.</p>
        pub fn port_ranges(mut self, input: crate::model::PortRange) -> Self {
            self.inner = self.inner.port_ranges(input);
            self
        }
        /// <p>The updated list of port ranges for the connections from clients to the accelerator.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.inner = self.inner.set_port_ranges(input);
            self
        }
        /// <p>The updated protocol for the connections from clients to the accelerator.</p>
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// <p>The updated protocol for the connections from clients to the accelerator.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn client_affinity(mut self, input: crate::model::ClientAffinity) -> Self {
            self.inner = self.inner.client_affinity(input);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications, regardless of the port and protocol of the client request. Client affinity gives you control over whether to always route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port, destination IP address, destination port, and protocol—to select the hash value, and then chooses the best endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code> instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties— source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn set_client_affinity(
            mut self,
            input: std::option::Option<crate::model::ClientAffinity>,
        ) -> Self {
            self.inner = self.inner.set_client_affinity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `WithdrawByoipCidr`.
    ///
    /// <p>Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.</p>
    /// <p>It can take a few minutes before traffic to the specified addresses stops routing to AWS because of propagation delays.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct WithdrawByoipCidr {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::withdraw_byoip_cidr_input::Builder,
    }
    impl WithdrawByoipCidr {
        /// Creates a new `WithdrawByoipCidr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::WithdrawByoipCidrOutput,
            aws_smithy_http::result::SdkError<crate::error::WithdrawByoipCidrError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The address range, in CIDR notation.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(input.into());
            self
        }
        /// <p>The address range, in CIDR notation.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
