// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddCustomRoutingEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_custom_routing_endpoints`](crate::client::Client::add_custom_routing_endpoints).
///
/// See [`crate::client::fluent_builders::AddCustomRoutingEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddCustomRoutingEndpoints {
    _private: (),
}
impl AddCustomRoutingEndpoints {
    /// Creates a new builder-style object to manufacture [`AddCustomRoutingEndpointsInput`](crate::input::AddCustomRoutingEndpointsInput)
    pub fn builder() -> crate::input::add_custom_routing_endpoints_input::Builder {
        crate::input::add_custom_routing_endpoints_input::Builder::default()
    }
    /// Creates a new `AddCustomRoutingEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddCustomRoutingEndpoints {
    type Output = std::result::Result<
        crate::output::AddCustomRoutingEndpointsOutput,
        crate::error::AddCustomRoutingEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_custom_routing_endpoints_error(response)
        } else {
            crate::operation_deser::parse_add_custom_routing_endpoints_response(response)
        }
    }
}

/// Operation shape for `AdvertiseByoipCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`advertise_byoip_cidr`](crate::client::Client::advertise_byoip_cidr).
///
/// See [`crate::client::fluent_builders::AdvertiseByoipCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AdvertiseByoipCidr {
    _private: (),
}
impl AdvertiseByoipCidr {
    /// Creates a new builder-style object to manufacture [`AdvertiseByoipCidrInput`](crate::input::AdvertiseByoipCidrInput)
    pub fn builder() -> crate::input::advertise_byoip_cidr_input::Builder {
        crate::input::advertise_byoip_cidr_input::Builder::default()
    }
    /// Creates a new `AdvertiseByoipCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AdvertiseByoipCidr {
    type Output = std::result::Result<
        crate::output::AdvertiseByoipCidrOutput,
        crate::error::AdvertiseByoipCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_advertise_byoip_cidr_error(response)
        } else {
            crate::operation_deser::parse_advertise_byoip_cidr_response(response)
        }
    }
}

/// Operation shape for `AllowCustomRoutingTraffic`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`allow_custom_routing_traffic`](crate::client::Client::allow_custom_routing_traffic).
///
/// See [`crate::client::fluent_builders::AllowCustomRoutingTraffic`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AllowCustomRoutingTraffic {
    _private: (),
}
impl AllowCustomRoutingTraffic {
    /// Creates a new builder-style object to manufacture [`AllowCustomRoutingTrafficInput`](crate::input::AllowCustomRoutingTrafficInput)
    pub fn builder() -> crate::input::allow_custom_routing_traffic_input::Builder {
        crate::input::allow_custom_routing_traffic_input::Builder::default()
    }
    /// Creates a new `AllowCustomRoutingTraffic` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AllowCustomRoutingTraffic {
    type Output = std::result::Result<
        crate::output::AllowCustomRoutingTrafficOutput,
        crate::error::AllowCustomRoutingTrafficError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_allow_custom_routing_traffic_error(response)
        } else {
            crate::operation_deser::parse_allow_custom_routing_traffic_response(response)
        }
    }
}

/// Operation shape for `CreateAccelerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_accelerator`](crate::client::Client::create_accelerator).
///
/// See [`crate::client::fluent_builders::CreateAccelerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccelerator {
    _private: (),
}
impl CreateAccelerator {
    /// Creates a new builder-style object to manufacture [`CreateAcceleratorInput`](crate::input::CreateAcceleratorInput)
    pub fn builder() -> crate::input::create_accelerator_input::Builder {
        crate::input::create_accelerator_input::Builder::default()
    }
    /// Creates a new `CreateAccelerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccelerator {
    type Output = std::result::Result<
        crate::output::CreateAcceleratorOutput,
        crate::error::CreateAcceleratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_accelerator_error(response)
        } else {
            crate::operation_deser::parse_create_accelerator_response(response)
        }
    }
}

/// Operation shape for `CreateCustomRoutingAccelerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_routing_accelerator`](crate::client::Client::create_custom_routing_accelerator).
///
/// See [`crate::client::fluent_builders::CreateCustomRoutingAccelerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomRoutingAccelerator {
    _private: (),
}
impl CreateCustomRoutingAccelerator {
    /// Creates a new builder-style object to manufacture [`CreateCustomRoutingAcceleratorInput`](crate::input::CreateCustomRoutingAcceleratorInput)
    pub fn builder() -> crate::input::create_custom_routing_accelerator_input::Builder {
        crate::input::create_custom_routing_accelerator_input::Builder::default()
    }
    /// Creates a new `CreateCustomRoutingAccelerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomRoutingAccelerator {
    type Output = std::result::Result<
        crate::output::CreateCustomRoutingAcceleratorOutput,
        crate::error::CreateCustomRoutingAcceleratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_routing_accelerator_error(response)
        } else {
            crate::operation_deser::parse_create_custom_routing_accelerator_response(response)
        }
    }
}

/// Operation shape for `CreateCustomRoutingEndpointGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_routing_endpoint_group`](crate::client::Client::create_custom_routing_endpoint_group).
///
/// See [`crate::client::fluent_builders::CreateCustomRoutingEndpointGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomRoutingEndpointGroup {
    _private: (),
}
impl CreateCustomRoutingEndpointGroup {
    /// Creates a new builder-style object to manufacture [`CreateCustomRoutingEndpointGroupInput`](crate::input::CreateCustomRoutingEndpointGroupInput)
    pub fn builder() -> crate::input::create_custom_routing_endpoint_group_input::Builder {
        crate::input::create_custom_routing_endpoint_group_input::Builder::default()
    }
    /// Creates a new `CreateCustomRoutingEndpointGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomRoutingEndpointGroup {
    type Output = std::result::Result<
        crate::output::CreateCustomRoutingEndpointGroupOutput,
        crate::error::CreateCustomRoutingEndpointGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_routing_endpoint_group_error(response)
        } else {
            crate::operation_deser::parse_create_custom_routing_endpoint_group_response(response)
        }
    }
}

/// Operation shape for `CreateCustomRoutingListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_routing_listener`](crate::client::Client::create_custom_routing_listener).
///
/// See [`crate::client::fluent_builders::CreateCustomRoutingListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomRoutingListener {
    _private: (),
}
impl CreateCustomRoutingListener {
    /// Creates a new builder-style object to manufacture [`CreateCustomRoutingListenerInput`](crate::input::CreateCustomRoutingListenerInput)
    pub fn builder() -> crate::input::create_custom_routing_listener_input::Builder {
        crate::input::create_custom_routing_listener_input::Builder::default()
    }
    /// Creates a new `CreateCustomRoutingListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomRoutingListener {
    type Output = std::result::Result<
        crate::output::CreateCustomRoutingListenerOutput,
        crate::error::CreateCustomRoutingListenerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_routing_listener_error(response)
        } else {
            crate::operation_deser::parse_create_custom_routing_listener_response(response)
        }
    }
}

/// Operation shape for `CreateEndpointGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_endpoint_group`](crate::client::Client::create_endpoint_group).
///
/// See [`crate::client::fluent_builders::CreateEndpointGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEndpointGroup {
    _private: (),
}
impl CreateEndpointGroup {
    /// Creates a new builder-style object to manufacture [`CreateEndpointGroupInput`](crate::input::CreateEndpointGroupInput)
    pub fn builder() -> crate::input::create_endpoint_group_input::Builder {
        crate::input::create_endpoint_group_input::Builder::default()
    }
    /// Creates a new `CreateEndpointGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEndpointGroup {
    type Output = std::result::Result<
        crate::output::CreateEndpointGroupOutput,
        crate::error::CreateEndpointGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_endpoint_group_error(response)
        } else {
            crate::operation_deser::parse_create_endpoint_group_response(response)
        }
    }
}

/// Operation shape for `CreateListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_listener`](crate::client::Client::create_listener).
///
/// See [`crate::client::fluent_builders::CreateListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateListener {
    _private: (),
}
impl CreateListener {
    /// Creates a new builder-style object to manufacture [`CreateListenerInput`](crate::input::CreateListenerInput)
    pub fn builder() -> crate::input::create_listener_input::Builder {
        crate::input::create_listener_input::Builder::default()
    }
    /// Creates a new `CreateListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateListener {
    type Output =
        std::result::Result<crate::output::CreateListenerOutput, crate::error::CreateListenerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_listener_error(response)
        } else {
            crate::operation_deser::parse_create_listener_response(response)
        }
    }
}

/// Operation shape for `DeleteAccelerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_accelerator`](crate::client::Client::delete_accelerator).
///
/// See [`crate::client::fluent_builders::DeleteAccelerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccelerator {
    _private: (),
}
impl DeleteAccelerator {
    /// Creates a new builder-style object to manufacture [`DeleteAcceleratorInput`](crate::input::DeleteAcceleratorInput)
    pub fn builder() -> crate::input::delete_accelerator_input::Builder {
        crate::input::delete_accelerator_input::Builder::default()
    }
    /// Creates a new `DeleteAccelerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccelerator {
    type Output = std::result::Result<
        crate::output::DeleteAcceleratorOutput,
        crate::error::DeleteAcceleratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_accelerator_error(response)
        } else {
            crate::operation_deser::parse_delete_accelerator_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomRoutingAccelerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_routing_accelerator`](crate::client::Client::delete_custom_routing_accelerator).
///
/// See [`crate::client::fluent_builders::DeleteCustomRoutingAccelerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomRoutingAccelerator {
    _private: (),
}
impl DeleteCustomRoutingAccelerator {
    /// Creates a new builder-style object to manufacture [`DeleteCustomRoutingAcceleratorInput`](crate::input::DeleteCustomRoutingAcceleratorInput)
    pub fn builder() -> crate::input::delete_custom_routing_accelerator_input::Builder {
        crate::input::delete_custom_routing_accelerator_input::Builder::default()
    }
    /// Creates a new `DeleteCustomRoutingAccelerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomRoutingAccelerator {
    type Output = std::result::Result<
        crate::output::DeleteCustomRoutingAcceleratorOutput,
        crate::error::DeleteCustomRoutingAcceleratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_routing_accelerator_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_routing_accelerator_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomRoutingEndpointGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_routing_endpoint_group`](crate::client::Client::delete_custom_routing_endpoint_group).
///
/// See [`crate::client::fluent_builders::DeleteCustomRoutingEndpointGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomRoutingEndpointGroup {
    _private: (),
}
impl DeleteCustomRoutingEndpointGroup {
    /// Creates a new builder-style object to manufacture [`DeleteCustomRoutingEndpointGroupInput`](crate::input::DeleteCustomRoutingEndpointGroupInput)
    pub fn builder() -> crate::input::delete_custom_routing_endpoint_group_input::Builder {
        crate::input::delete_custom_routing_endpoint_group_input::Builder::default()
    }
    /// Creates a new `DeleteCustomRoutingEndpointGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomRoutingEndpointGroup {
    type Output = std::result::Result<
        crate::output::DeleteCustomRoutingEndpointGroupOutput,
        crate::error::DeleteCustomRoutingEndpointGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_routing_endpoint_group_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_routing_endpoint_group_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomRoutingListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_routing_listener`](crate::client::Client::delete_custom_routing_listener).
///
/// See [`crate::client::fluent_builders::DeleteCustomRoutingListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomRoutingListener {
    _private: (),
}
impl DeleteCustomRoutingListener {
    /// Creates a new builder-style object to manufacture [`DeleteCustomRoutingListenerInput`](crate::input::DeleteCustomRoutingListenerInput)
    pub fn builder() -> crate::input::delete_custom_routing_listener_input::Builder {
        crate::input::delete_custom_routing_listener_input::Builder::default()
    }
    /// Creates a new `DeleteCustomRoutingListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomRoutingListener {
    type Output = std::result::Result<
        crate::output::DeleteCustomRoutingListenerOutput,
        crate::error::DeleteCustomRoutingListenerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_routing_listener_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_routing_listener_response(response)
        }
    }
}

/// Operation shape for `DeleteEndpointGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_endpoint_group`](crate::client::Client::delete_endpoint_group).
///
/// See [`crate::client::fluent_builders::DeleteEndpointGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEndpointGroup {
    _private: (),
}
impl DeleteEndpointGroup {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointGroupInput`](crate::input::DeleteEndpointGroupInput)
    pub fn builder() -> crate::input::delete_endpoint_group_input::Builder {
        crate::input::delete_endpoint_group_input::Builder::default()
    }
    /// Creates a new `DeleteEndpointGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEndpointGroup {
    type Output = std::result::Result<
        crate::output::DeleteEndpointGroupOutput,
        crate::error::DeleteEndpointGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_endpoint_group_error(response)
        } else {
            crate::operation_deser::parse_delete_endpoint_group_response(response)
        }
    }
}

/// Operation shape for `DeleteListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_listener`](crate::client::Client::delete_listener).
///
/// See [`crate::client::fluent_builders::DeleteListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteListener {
    _private: (),
}
impl DeleteListener {
    /// Creates a new builder-style object to manufacture [`DeleteListenerInput`](crate::input::DeleteListenerInput)
    pub fn builder() -> crate::input::delete_listener_input::Builder {
        crate::input::delete_listener_input::Builder::default()
    }
    /// Creates a new `DeleteListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteListener {
    type Output =
        std::result::Result<crate::output::DeleteListenerOutput, crate::error::DeleteListenerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_listener_error(response)
        } else {
            crate::operation_deser::parse_delete_listener_response(response)
        }
    }
}

/// Operation shape for `DenyCustomRoutingTraffic`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deny_custom_routing_traffic`](crate::client::Client::deny_custom_routing_traffic).
///
/// See [`crate::client::fluent_builders::DenyCustomRoutingTraffic`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DenyCustomRoutingTraffic {
    _private: (),
}
impl DenyCustomRoutingTraffic {
    /// Creates a new builder-style object to manufacture [`DenyCustomRoutingTrafficInput`](crate::input::DenyCustomRoutingTrafficInput)
    pub fn builder() -> crate::input::deny_custom_routing_traffic_input::Builder {
        crate::input::deny_custom_routing_traffic_input::Builder::default()
    }
    /// Creates a new `DenyCustomRoutingTraffic` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DenyCustomRoutingTraffic {
    type Output = std::result::Result<
        crate::output::DenyCustomRoutingTrafficOutput,
        crate::error::DenyCustomRoutingTrafficError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deny_custom_routing_traffic_error(response)
        } else {
            crate::operation_deser::parse_deny_custom_routing_traffic_response(response)
        }
    }
}

/// Operation shape for `DeprovisionByoipCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deprovision_byoip_cidr`](crate::client::Client::deprovision_byoip_cidr).
///
/// See [`crate::client::fluent_builders::DeprovisionByoipCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeprovisionByoipCidr {
    _private: (),
}
impl DeprovisionByoipCidr {
    /// Creates a new builder-style object to manufacture [`DeprovisionByoipCidrInput`](crate::input::DeprovisionByoipCidrInput)
    pub fn builder() -> crate::input::deprovision_byoip_cidr_input::Builder {
        crate::input::deprovision_byoip_cidr_input::Builder::default()
    }
    /// Creates a new `DeprovisionByoipCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeprovisionByoipCidr {
    type Output = std::result::Result<
        crate::output::DeprovisionByoipCidrOutput,
        crate::error::DeprovisionByoipCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deprovision_byoip_cidr_error(response)
        } else {
            crate::operation_deser::parse_deprovision_byoip_cidr_response(response)
        }
    }
}

/// Operation shape for `DescribeAccelerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_accelerator`](crate::client::Client::describe_accelerator).
///
/// See [`crate::client::fluent_builders::DescribeAccelerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccelerator {
    _private: (),
}
impl DescribeAccelerator {
    /// Creates a new builder-style object to manufacture [`DescribeAcceleratorInput`](crate::input::DescribeAcceleratorInput)
    pub fn builder() -> crate::input::describe_accelerator_input::Builder {
        crate::input::describe_accelerator_input::Builder::default()
    }
    /// Creates a new `DescribeAccelerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccelerator {
    type Output = std::result::Result<
        crate::output::DescribeAcceleratorOutput,
        crate::error::DescribeAcceleratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_accelerator_error(response)
        } else {
            crate::operation_deser::parse_describe_accelerator_response(response)
        }
    }
}

/// Operation shape for `DescribeAcceleratorAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_accelerator_attributes`](crate::client::Client::describe_accelerator_attributes).
///
/// See [`crate::client::fluent_builders::DescribeAcceleratorAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAcceleratorAttributes {
    _private: (),
}
impl DescribeAcceleratorAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeAcceleratorAttributesInput`](crate::input::DescribeAcceleratorAttributesInput)
    pub fn builder() -> crate::input::describe_accelerator_attributes_input::Builder {
        crate::input::describe_accelerator_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeAcceleratorAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAcceleratorAttributes {
    type Output = std::result::Result<
        crate::output::DescribeAcceleratorAttributesOutput,
        crate::error::DescribeAcceleratorAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_accelerator_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_accelerator_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeCustomRoutingAccelerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_custom_routing_accelerator`](crate::client::Client::describe_custom_routing_accelerator).
///
/// See [`crate::client::fluent_builders::DescribeCustomRoutingAccelerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCustomRoutingAccelerator {
    _private: (),
}
impl DescribeCustomRoutingAccelerator {
    /// Creates a new builder-style object to manufacture [`DescribeCustomRoutingAcceleratorInput`](crate::input::DescribeCustomRoutingAcceleratorInput)
    pub fn builder() -> crate::input::describe_custom_routing_accelerator_input::Builder {
        crate::input::describe_custom_routing_accelerator_input::Builder::default()
    }
    /// Creates a new `DescribeCustomRoutingAccelerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCustomRoutingAccelerator {
    type Output = std::result::Result<
        crate::output::DescribeCustomRoutingAcceleratorOutput,
        crate::error::DescribeCustomRoutingAcceleratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_custom_routing_accelerator_error(response)
        } else {
            crate::operation_deser::parse_describe_custom_routing_accelerator_response(response)
        }
    }
}

/// Operation shape for `DescribeCustomRoutingAcceleratorAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_custom_routing_accelerator_attributes`](crate::client::Client::describe_custom_routing_accelerator_attributes).
///
/// See [`crate::client::fluent_builders::DescribeCustomRoutingAcceleratorAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCustomRoutingAcceleratorAttributes {
    _private: (),
}
impl DescribeCustomRoutingAcceleratorAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeCustomRoutingAcceleratorAttributesInput`](crate::input::DescribeCustomRoutingAcceleratorAttributesInput)
    pub fn builder() -> crate::input::describe_custom_routing_accelerator_attributes_input::Builder
    {
        crate::input::describe_custom_routing_accelerator_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeCustomRoutingAcceleratorAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCustomRoutingAcceleratorAttributes {
    type Output = std::result::Result<
        crate::output::DescribeCustomRoutingAcceleratorAttributesOutput,
        crate::error::DescribeCustomRoutingAcceleratorAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_custom_routing_accelerator_attributes_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_custom_routing_accelerator_attributes_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeCustomRoutingEndpointGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_custom_routing_endpoint_group`](crate::client::Client::describe_custom_routing_endpoint_group).
///
/// See [`crate::client::fluent_builders::DescribeCustomRoutingEndpointGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCustomRoutingEndpointGroup {
    _private: (),
}
impl DescribeCustomRoutingEndpointGroup {
    /// Creates a new builder-style object to manufacture [`DescribeCustomRoutingEndpointGroupInput`](crate::input::DescribeCustomRoutingEndpointGroupInput)
    pub fn builder() -> crate::input::describe_custom_routing_endpoint_group_input::Builder {
        crate::input::describe_custom_routing_endpoint_group_input::Builder::default()
    }
    /// Creates a new `DescribeCustomRoutingEndpointGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCustomRoutingEndpointGroup {
    type Output = std::result::Result<
        crate::output::DescribeCustomRoutingEndpointGroupOutput,
        crate::error::DescribeCustomRoutingEndpointGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_custom_routing_endpoint_group_error(response)
        } else {
            crate::operation_deser::parse_describe_custom_routing_endpoint_group_response(response)
        }
    }
}

/// Operation shape for `DescribeCustomRoutingListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_custom_routing_listener`](crate::client::Client::describe_custom_routing_listener).
///
/// See [`crate::client::fluent_builders::DescribeCustomRoutingListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCustomRoutingListener {
    _private: (),
}
impl DescribeCustomRoutingListener {
    /// Creates a new builder-style object to manufacture [`DescribeCustomRoutingListenerInput`](crate::input::DescribeCustomRoutingListenerInput)
    pub fn builder() -> crate::input::describe_custom_routing_listener_input::Builder {
        crate::input::describe_custom_routing_listener_input::Builder::default()
    }
    /// Creates a new `DescribeCustomRoutingListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCustomRoutingListener {
    type Output = std::result::Result<
        crate::output::DescribeCustomRoutingListenerOutput,
        crate::error::DescribeCustomRoutingListenerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_custom_routing_listener_error(response)
        } else {
            crate::operation_deser::parse_describe_custom_routing_listener_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpointGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoint_group`](crate::client::Client::describe_endpoint_group).
///
/// See [`crate::client::fluent_builders::DescribeEndpointGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpointGroup {
    _private: (),
}
impl DescribeEndpointGroup {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointGroupInput`](crate::input::DescribeEndpointGroupInput)
    pub fn builder() -> crate::input::describe_endpoint_group_input::Builder {
        crate::input::describe_endpoint_group_input::Builder::default()
    }
    /// Creates a new `DescribeEndpointGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpointGroup {
    type Output = std::result::Result<
        crate::output::DescribeEndpointGroupOutput,
        crate::error::DescribeEndpointGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoint_group_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoint_group_response(response)
        }
    }
}

/// Operation shape for `DescribeListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_listener`](crate::client::Client::describe_listener).
///
/// See [`crate::client::fluent_builders::DescribeListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeListener {
    _private: (),
}
impl DescribeListener {
    /// Creates a new builder-style object to manufacture [`DescribeListenerInput`](crate::input::DescribeListenerInput)
    pub fn builder() -> crate::input::describe_listener_input::Builder {
        crate::input::describe_listener_input::Builder::default()
    }
    /// Creates a new `DescribeListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeListener {
    type Output = std::result::Result<
        crate::output::DescribeListenerOutput,
        crate::error::DescribeListenerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_listener_error(response)
        } else {
            crate::operation_deser::parse_describe_listener_response(response)
        }
    }
}

/// Operation shape for `ListAccelerators`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_accelerators`](crate::client::Client::list_accelerators).
///
/// See [`crate::client::fluent_builders::ListAccelerators`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccelerators {
    _private: (),
}
impl ListAccelerators {
    /// Creates a new builder-style object to manufacture [`ListAcceleratorsInput`](crate::input::ListAcceleratorsInput)
    pub fn builder() -> crate::input::list_accelerators_input::Builder {
        crate::input::list_accelerators_input::Builder::default()
    }
    /// Creates a new `ListAccelerators` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccelerators {
    type Output = std::result::Result<
        crate::output::ListAcceleratorsOutput,
        crate::error::ListAcceleratorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_accelerators_error(response)
        } else {
            crate::operation_deser::parse_list_accelerators_response(response)
        }
    }
}

/// Operation shape for `ListByoipCidrs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_byoip_cidrs`](crate::client::Client::list_byoip_cidrs).
///
/// See [`crate::client::fluent_builders::ListByoipCidrs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListByoipCidrs {
    _private: (),
}
impl ListByoipCidrs {
    /// Creates a new builder-style object to manufacture [`ListByoipCidrsInput`](crate::input::ListByoipCidrsInput)
    pub fn builder() -> crate::input::list_byoip_cidrs_input::Builder {
        crate::input::list_byoip_cidrs_input::Builder::default()
    }
    /// Creates a new `ListByoipCidrs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListByoipCidrs {
    type Output =
        std::result::Result<crate::output::ListByoipCidrsOutput, crate::error::ListByoipCidrsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_byoip_cidrs_error(response)
        } else {
            crate::operation_deser::parse_list_byoip_cidrs_response(response)
        }
    }
}

/// Operation shape for `ListCustomRoutingAccelerators`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_custom_routing_accelerators`](crate::client::Client::list_custom_routing_accelerators).
///
/// See [`crate::client::fluent_builders::ListCustomRoutingAccelerators`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCustomRoutingAccelerators {
    _private: (),
}
impl ListCustomRoutingAccelerators {
    /// Creates a new builder-style object to manufacture [`ListCustomRoutingAcceleratorsInput`](crate::input::ListCustomRoutingAcceleratorsInput)
    pub fn builder() -> crate::input::list_custom_routing_accelerators_input::Builder {
        crate::input::list_custom_routing_accelerators_input::Builder::default()
    }
    /// Creates a new `ListCustomRoutingAccelerators` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCustomRoutingAccelerators {
    type Output = std::result::Result<
        crate::output::ListCustomRoutingAcceleratorsOutput,
        crate::error::ListCustomRoutingAcceleratorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_custom_routing_accelerators_error(response)
        } else {
            crate::operation_deser::parse_list_custom_routing_accelerators_response(response)
        }
    }
}

/// Operation shape for `ListCustomRoutingEndpointGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_custom_routing_endpoint_groups`](crate::client::Client::list_custom_routing_endpoint_groups).
///
/// See [`crate::client::fluent_builders::ListCustomRoutingEndpointGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCustomRoutingEndpointGroups {
    _private: (),
}
impl ListCustomRoutingEndpointGroups {
    /// Creates a new builder-style object to manufacture [`ListCustomRoutingEndpointGroupsInput`](crate::input::ListCustomRoutingEndpointGroupsInput)
    pub fn builder() -> crate::input::list_custom_routing_endpoint_groups_input::Builder {
        crate::input::list_custom_routing_endpoint_groups_input::Builder::default()
    }
    /// Creates a new `ListCustomRoutingEndpointGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCustomRoutingEndpointGroups {
    type Output = std::result::Result<
        crate::output::ListCustomRoutingEndpointGroupsOutput,
        crate::error::ListCustomRoutingEndpointGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_custom_routing_endpoint_groups_error(response)
        } else {
            crate::operation_deser::parse_list_custom_routing_endpoint_groups_response(response)
        }
    }
}

/// Operation shape for `ListCustomRoutingListeners`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_custom_routing_listeners`](crate::client::Client::list_custom_routing_listeners).
///
/// See [`crate::client::fluent_builders::ListCustomRoutingListeners`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCustomRoutingListeners {
    _private: (),
}
impl ListCustomRoutingListeners {
    /// Creates a new builder-style object to manufacture [`ListCustomRoutingListenersInput`](crate::input::ListCustomRoutingListenersInput)
    pub fn builder() -> crate::input::list_custom_routing_listeners_input::Builder {
        crate::input::list_custom_routing_listeners_input::Builder::default()
    }
    /// Creates a new `ListCustomRoutingListeners` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCustomRoutingListeners {
    type Output = std::result::Result<
        crate::output::ListCustomRoutingListenersOutput,
        crate::error::ListCustomRoutingListenersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_custom_routing_listeners_error(response)
        } else {
            crate::operation_deser::parse_list_custom_routing_listeners_response(response)
        }
    }
}

/// Operation shape for `ListCustomRoutingPortMappings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_custom_routing_port_mappings`](crate::client::Client::list_custom_routing_port_mappings).
///
/// See [`crate::client::fluent_builders::ListCustomRoutingPortMappings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCustomRoutingPortMappings {
    _private: (),
}
impl ListCustomRoutingPortMappings {
    /// Creates a new builder-style object to manufacture [`ListCustomRoutingPortMappingsInput`](crate::input::ListCustomRoutingPortMappingsInput)
    pub fn builder() -> crate::input::list_custom_routing_port_mappings_input::Builder {
        crate::input::list_custom_routing_port_mappings_input::Builder::default()
    }
    /// Creates a new `ListCustomRoutingPortMappings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCustomRoutingPortMappings {
    type Output = std::result::Result<
        crate::output::ListCustomRoutingPortMappingsOutput,
        crate::error::ListCustomRoutingPortMappingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_custom_routing_port_mappings_error(response)
        } else {
            crate::operation_deser::parse_list_custom_routing_port_mappings_response(response)
        }
    }
}

/// Operation shape for `ListCustomRoutingPortMappingsByDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_custom_routing_port_mappings_by_destination`](crate::client::Client::list_custom_routing_port_mappings_by_destination).
///
/// See [`crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCustomRoutingPortMappingsByDestination {
    _private: (),
}
impl ListCustomRoutingPortMappingsByDestination {
    /// Creates a new builder-style object to manufacture [`ListCustomRoutingPortMappingsByDestinationInput`](crate::input::ListCustomRoutingPortMappingsByDestinationInput)
    pub fn builder() -> crate::input::list_custom_routing_port_mappings_by_destination_input::Builder
    {
        crate::input::list_custom_routing_port_mappings_by_destination_input::Builder::default()
    }
    /// Creates a new `ListCustomRoutingPortMappingsByDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCustomRoutingPortMappingsByDestination {
    type Output = std::result::Result<
        crate::output::ListCustomRoutingPortMappingsByDestinationOutput,
        crate::error::ListCustomRoutingPortMappingsByDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_custom_routing_port_mappings_by_destination_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_custom_routing_port_mappings_by_destination_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListEndpointGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_endpoint_groups`](crate::client::Client::list_endpoint_groups).
///
/// See [`crate::client::fluent_builders::ListEndpointGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEndpointGroups {
    _private: (),
}
impl ListEndpointGroups {
    /// Creates a new builder-style object to manufacture [`ListEndpointGroupsInput`](crate::input::ListEndpointGroupsInput)
    pub fn builder() -> crate::input::list_endpoint_groups_input::Builder {
        crate::input::list_endpoint_groups_input::Builder::default()
    }
    /// Creates a new `ListEndpointGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEndpointGroups {
    type Output = std::result::Result<
        crate::output::ListEndpointGroupsOutput,
        crate::error::ListEndpointGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_endpoint_groups_error(response)
        } else {
            crate::operation_deser::parse_list_endpoint_groups_response(response)
        }
    }
}

/// Operation shape for `ListListeners`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_listeners`](crate::client::Client::list_listeners).
///
/// See [`crate::client::fluent_builders::ListListeners`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListListeners {
    _private: (),
}
impl ListListeners {
    /// Creates a new builder-style object to manufacture [`ListListenersInput`](crate::input::ListListenersInput)
    pub fn builder() -> crate::input::list_listeners_input::Builder {
        crate::input::list_listeners_input::Builder::default()
    }
    /// Creates a new `ListListeners` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListListeners {
    type Output =
        std::result::Result<crate::output::ListListenersOutput, crate::error::ListListenersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_listeners_error(response)
        } else {
            crate::operation_deser::parse_list_listeners_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ProvisionByoipCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`provision_byoip_cidr`](crate::client::Client::provision_byoip_cidr).
///
/// See [`crate::client::fluent_builders::ProvisionByoipCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ProvisionByoipCidr {
    _private: (),
}
impl ProvisionByoipCidr {
    /// Creates a new builder-style object to manufacture [`ProvisionByoipCidrInput`](crate::input::ProvisionByoipCidrInput)
    pub fn builder() -> crate::input::provision_byoip_cidr_input::Builder {
        crate::input::provision_byoip_cidr_input::Builder::default()
    }
    /// Creates a new `ProvisionByoipCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ProvisionByoipCidr {
    type Output = std::result::Result<
        crate::output::ProvisionByoipCidrOutput,
        crate::error::ProvisionByoipCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_provision_byoip_cidr_error(response)
        } else {
            crate::operation_deser::parse_provision_byoip_cidr_response(response)
        }
    }
}

/// Operation shape for `RemoveCustomRoutingEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_custom_routing_endpoints`](crate::client::Client::remove_custom_routing_endpoints).
///
/// See [`crate::client::fluent_builders::RemoveCustomRoutingEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveCustomRoutingEndpoints {
    _private: (),
}
impl RemoveCustomRoutingEndpoints {
    /// Creates a new builder-style object to manufacture [`RemoveCustomRoutingEndpointsInput`](crate::input::RemoveCustomRoutingEndpointsInput)
    pub fn builder() -> crate::input::remove_custom_routing_endpoints_input::Builder {
        crate::input::remove_custom_routing_endpoints_input::Builder::default()
    }
    /// Creates a new `RemoveCustomRoutingEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveCustomRoutingEndpoints {
    type Output = std::result::Result<
        crate::output::RemoveCustomRoutingEndpointsOutput,
        crate::error::RemoveCustomRoutingEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_custom_routing_endpoints_error(response)
        } else {
            crate::operation_deser::parse_remove_custom_routing_endpoints_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAccelerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_accelerator`](crate::client::Client::update_accelerator).
///
/// See [`crate::client::fluent_builders::UpdateAccelerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAccelerator {
    _private: (),
}
impl UpdateAccelerator {
    /// Creates a new builder-style object to manufacture [`UpdateAcceleratorInput`](crate::input::UpdateAcceleratorInput)
    pub fn builder() -> crate::input::update_accelerator_input::Builder {
        crate::input::update_accelerator_input::Builder::default()
    }
    /// Creates a new `UpdateAccelerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAccelerator {
    type Output = std::result::Result<
        crate::output::UpdateAcceleratorOutput,
        crate::error::UpdateAcceleratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_accelerator_error(response)
        } else {
            crate::operation_deser::parse_update_accelerator_response(response)
        }
    }
}

/// Operation shape for `UpdateAcceleratorAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_accelerator_attributes`](crate::client::Client::update_accelerator_attributes).
///
/// See [`crate::client::fluent_builders::UpdateAcceleratorAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAcceleratorAttributes {
    _private: (),
}
impl UpdateAcceleratorAttributes {
    /// Creates a new builder-style object to manufacture [`UpdateAcceleratorAttributesInput`](crate::input::UpdateAcceleratorAttributesInput)
    pub fn builder() -> crate::input::update_accelerator_attributes_input::Builder {
        crate::input::update_accelerator_attributes_input::Builder::default()
    }
    /// Creates a new `UpdateAcceleratorAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAcceleratorAttributes {
    type Output = std::result::Result<
        crate::output::UpdateAcceleratorAttributesOutput,
        crate::error::UpdateAcceleratorAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_accelerator_attributes_error(response)
        } else {
            crate::operation_deser::parse_update_accelerator_attributes_response(response)
        }
    }
}

/// Operation shape for `UpdateCustomRoutingAccelerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_custom_routing_accelerator`](crate::client::Client::update_custom_routing_accelerator).
///
/// See [`crate::client::fluent_builders::UpdateCustomRoutingAccelerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCustomRoutingAccelerator {
    _private: (),
}
impl UpdateCustomRoutingAccelerator {
    /// Creates a new builder-style object to manufacture [`UpdateCustomRoutingAcceleratorInput`](crate::input::UpdateCustomRoutingAcceleratorInput)
    pub fn builder() -> crate::input::update_custom_routing_accelerator_input::Builder {
        crate::input::update_custom_routing_accelerator_input::Builder::default()
    }
    /// Creates a new `UpdateCustomRoutingAccelerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCustomRoutingAccelerator {
    type Output = std::result::Result<
        crate::output::UpdateCustomRoutingAcceleratorOutput,
        crate::error::UpdateCustomRoutingAcceleratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_custom_routing_accelerator_error(response)
        } else {
            crate::operation_deser::parse_update_custom_routing_accelerator_response(response)
        }
    }
}

/// Operation shape for `UpdateCustomRoutingAcceleratorAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_custom_routing_accelerator_attributes`](crate::client::Client::update_custom_routing_accelerator_attributes).
///
/// See [`crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCustomRoutingAcceleratorAttributes {
    _private: (),
}
impl UpdateCustomRoutingAcceleratorAttributes {
    /// Creates a new builder-style object to manufacture [`UpdateCustomRoutingAcceleratorAttributesInput`](crate::input::UpdateCustomRoutingAcceleratorAttributesInput)
    pub fn builder() -> crate::input::update_custom_routing_accelerator_attributes_input::Builder {
        crate::input::update_custom_routing_accelerator_attributes_input::Builder::default()
    }
    /// Creates a new `UpdateCustomRoutingAcceleratorAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCustomRoutingAcceleratorAttributes {
    type Output = std::result::Result<
        crate::output::UpdateCustomRoutingAcceleratorAttributesOutput,
        crate::error::UpdateCustomRoutingAcceleratorAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_custom_routing_accelerator_attributes_error(
                response,
            )
        } else {
            crate::operation_deser::parse_update_custom_routing_accelerator_attributes_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateCustomRoutingListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_custom_routing_listener`](crate::client::Client::update_custom_routing_listener).
///
/// See [`crate::client::fluent_builders::UpdateCustomRoutingListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCustomRoutingListener {
    _private: (),
}
impl UpdateCustomRoutingListener {
    /// Creates a new builder-style object to manufacture [`UpdateCustomRoutingListenerInput`](crate::input::UpdateCustomRoutingListenerInput)
    pub fn builder() -> crate::input::update_custom_routing_listener_input::Builder {
        crate::input::update_custom_routing_listener_input::Builder::default()
    }
    /// Creates a new `UpdateCustomRoutingListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCustomRoutingListener {
    type Output = std::result::Result<
        crate::output::UpdateCustomRoutingListenerOutput,
        crate::error::UpdateCustomRoutingListenerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_custom_routing_listener_error(response)
        } else {
            crate::operation_deser::parse_update_custom_routing_listener_response(response)
        }
    }
}

/// Operation shape for `UpdateEndpointGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_endpoint_group`](crate::client::Client::update_endpoint_group).
///
/// See [`crate::client::fluent_builders::UpdateEndpointGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEndpointGroup {
    _private: (),
}
impl UpdateEndpointGroup {
    /// Creates a new builder-style object to manufacture [`UpdateEndpointGroupInput`](crate::input::UpdateEndpointGroupInput)
    pub fn builder() -> crate::input::update_endpoint_group_input::Builder {
        crate::input::update_endpoint_group_input::Builder::default()
    }
    /// Creates a new `UpdateEndpointGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEndpointGroup {
    type Output = std::result::Result<
        crate::output::UpdateEndpointGroupOutput,
        crate::error::UpdateEndpointGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_endpoint_group_error(response)
        } else {
            crate::operation_deser::parse_update_endpoint_group_response(response)
        }
    }
}

/// Operation shape for `UpdateListener`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_listener`](crate::client::Client::update_listener).
///
/// See [`crate::client::fluent_builders::UpdateListener`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateListener {
    _private: (),
}
impl UpdateListener {
    /// Creates a new builder-style object to manufacture [`UpdateListenerInput`](crate::input::UpdateListenerInput)
    pub fn builder() -> crate::input::update_listener_input::Builder {
        crate::input::update_listener_input::Builder::default()
    }
    /// Creates a new `UpdateListener` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateListener {
    type Output =
        std::result::Result<crate::output::UpdateListenerOutput, crate::error::UpdateListenerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_listener_error(response)
        } else {
            crate::operation_deser::parse_update_listener_response(response)
        }
    }
}

/// Operation shape for `WithdrawByoipCidr`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`withdraw_byoip_cidr`](crate::client::Client::withdraw_byoip_cidr).
///
/// See [`crate::client::fluent_builders::WithdrawByoipCidr`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct WithdrawByoipCidr {
    _private: (),
}
impl WithdrawByoipCidr {
    /// Creates a new builder-style object to manufacture [`WithdrawByoipCidrInput`](crate::input::WithdrawByoipCidrInput)
    pub fn builder() -> crate::input::withdraw_byoip_cidr_input::Builder {
        crate::input::withdraw_byoip_cidr_input::Builder::default()
    }
    /// Creates a new `WithdrawByoipCidr` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for WithdrawByoipCidr {
    type Output = std::result::Result<
        crate::output::WithdrawByoipCidrOutput,
        crate::error::WithdrawByoipCidrError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_withdraw_byoip_cidr_error(response)
        } else {
            crate::operation_deser::parse_withdraw_byoip_cidr_response(response)
        }
    }
}
