// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Global Accelerator
///
/// Client for invoking operations on AWS Global Accelerator. Each operation on AWS Global Accelerator is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_globalaccelerator::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_globalaccelerator::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_globalaccelerator::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddCustomRoutingEndpoints` operation.
    ///
    /// See [`AddCustomRoutingEndpoints`](crate::client::fluent_builders::AddCustomRoutingEndpoints) for more information about the
    /// operation and its arguments.
    pub fn add_custom_routing_endpoints(
        &self,
    ) -> fluent_builders::AddCustomRoutingEndpoints<C, M, R> {
        fluent_builders::AddCustomRoutingEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AdvertiseByoipCidr` operation.
    ///
    /// See [`AdvertiseByoipCidr`](crate::client::fluent_builders::AdvertiseByoipCidr) for more information about the
    /// operation and its arguments.
    pub fn advertise_byoip_cidr(&self) -> fluent_builders::AdvertiseByoipCidr<C, M, R> {
        fluent_builders::AdvertiseByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AllowCustomRoutingTraffic` operation.
    ///
    /// See [`AllowCustomRoutingTraffic`](crate::client::fluent_builders::AllowCustomRoutingTraffic) for more information about the
    /// operation and its arguments.
    pub fn allow_custom_routing_traffic(
        &self,
    ) -> fluent_builders::AllowCustomRoutingTraffic<C, M, R> {
        fluent_builders::AllowCustomRoutingTraffic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAccelerator` operation.
    ///
    /// See [`CreateAccelerator`](crate::client::fluent_builders::CreateAccelerator) for more information about the
    /// operation and its arguments.
    pub fn create_accelerator(&self) -> fluent_builders::CreateAccelerator<C, M, R> {
        fluent_builders::CreateAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomRoutingAccelerator` operation.
    ///
    /// See [`CreateCustomRoutingAccelerator`](crate::client::fluent_builders::CreateCustomRoutingAccelerator) for more information about the
    /// operation and its arguments.
    pub fn create_custom_routing_accelerator(
        &self,
    ) -> fluent_builders::CreateCustomRoutingAccelerator<C, M, R> {
        fluent_builders::CreateCustomRoutingAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomRoutingEndpointGroup` operation.
    ///
    /// See [`CreateCustomRoutingEndpointGroup`](crate::client::fluent_builders::CreateCustomRoutingEndpointGroup) for more information about the
    /// operation and its arguments.
    pub fn create_custom_routing_endpoint_group(
        &self,
    ) -> fluent_builders::CreateCustomRoutingEndpointGroup<C, M, R> {
        fluent_builders::CreateCustomRoutingEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomRoutingListener` operation.
    ///
    /// See [`CreateCustomRoutingListener`](crate::client::fluent_builders::CreateCustomRoutingListener) for more information about the
    /// operation and its arguments.
    pub fn create_custom_routing_listener(
        &self,
    ) -> fluent_builders::CreateCustomRoutingListener<C, M, R> {
        fluent_builders::CreateCustomRoutingListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEndpointGroup` operation.
    ///
    /// See [`CreateEndpointGroup`](crate::client::fluent_builders::CreateEndpointGroup) for more information about the
    /// operation and its arguments.
    pub fn create_endpoint_group(&self) -> fluent_builders::CreateEndpointGroup<C, M, R> {
        fluent_builders::CreateEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateListener` operation.
    ///
    /// See [`CreateListener`](crate::client::fluent_builders::CreateListener) for more information about the
    /// operation and its arguments.
    pub fn create_listener(&self) -> fluent_builders::CreateListener<C, M, R> {
        fluent_builders::CreateListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccelerator` operation.
    ///
    /// See [`DeleteAccelerator`](crate::client::fluent_builders::DeleteAccelerator) for more information about the
    /// operation and its arguments.
    pub fn delete_accelerator(&self) -> fluent_builders::DeleteAccelerator<C, M, R> {
        fluent_builders::DeleteAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomRoutingAccelerator` operation.
    ///
    /// See [`DeleteCustomRoutingAccelerator`](crate::client::fluent_builders::DeleteCustomRoutingAccelerator) for more information about the
    /// operation and its arguments.
    pub fn delete_custom_routing_accelerator(
        &self,
    ) -> fluent_builders::DeleteCustomRoutingAccelerator<C, M, R> {
        fluent_builders::DeleteCustomRoutingAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomRoutingEndpointGroup` operation.
    ///
    /// See [`DeleteCustomRoutingEndpointGroup`](crate::client::fluent_builders::DeleteCustomRoutingEndpointGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_custom_routing_endpoint_group(
        &self,
    ) -> fluent_builders::DeleteCustomRoutingEndpointGroup<C, M, R> {
        fluent_builders::DeleteCustomRoutingEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomRoutingListener` operation.
    ///
    /// See [`DeleteCustomRoutingListener`](crate::client::fluent_builders::DeleteCustomRoutingListener) for more information about the
    /// operation and its arguments.
    pub fn delete_custom_routing_listener(
        &self,
    ) -> fluent_builders::DeleteCustomRoutingListener<C, M, R> {
        fluent_builders::DeleteCustomRoutingListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEndpointGroup` operation.
    ///
    /// See [`DeleteEndpointGroup`](crate::client::fluent_builders::DeleteEndpointGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_endpoint_group(&self) -> fluent_builders::DeleteEndpointGroup<C, M, R> {
        fluent_builders::DeleteEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteListener` operation.
    ///
    /// See [`DeleteListener`](crate::client::fluent_builders::DeleteListener) for more information about the
    /// operation and its arguments.
    pub fn delete_listener(&self) -> fluent_builders::DeleteListener<C, M, R> {
        fluent_builders::DeleteListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DenyCustomRoutingTraffic` operation.
    ///
    /// See [`DenyCustomRoutingTraffic`](crate::client::fluent_builders::DenyCustomRoutingTraffic) for more information about the
    /// operation and its arguments.
    pub fn deny_custom_routing_traffic(
        &self,
    ) -> fluent_builders::DenyCustomRoutingTraffic<C, M, R> {
        fluent_builders::DenyCustomRoutingTraffic::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeprovisionByoipCidr` operation.
    ///
    /// See [`DeprovisionByoipCidr`](crate::client::fluent_builders::DeprovisionByoipCidr) for more information about the
    /// operation and its arguments.
    pub fn deprovision_byoip_cidr(&self) -> fluent_builders::DeprovisionByoipCidr<C, M, R> {
        fluent_builders::DeprovisionByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccelerator` operation.
    ///
    /// See [`DescribeAccelerator`](crate::client::fluent_builders::DescribeAccelerator) for more information about the
    /// operation and its arguments.
    pub fn describe_accelerator(&self) -> fluent_builders::DescribeAccelerator<C, M, R> {
        fluent_builders::DescribeAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAcceleratorAttributes` operation.
    ///
    /// See [`DescribeAcceleratorAttributes`](crate::client::fluent_builders::DescribeAcceleratorAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_accelerator_attributes(
        &self,
    ) -> fluent_builders::DescribeAcceleratorAttributes<C, M, R> {
        fluent_builders::DescribeAcceleratorAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCustomRoutingAccelerator` operation.
    ///
    /// See [`DescribeCustomRoutingAccelerator`](crate::client::fluent_builders::DescribeCustomRoutingAccelerator) for more information about the
    /// operation and its arguments.
    pub fn describe_custom_routing_accelerator(
        &self,
    ) -> fluent_builders::DescribeCustomRoutingAccelerator<C, M, R> {
        fluent_builders::DescribeCustomRoutingAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCustomRoutingAcceleratorAttributes` operation.
    ///
    /// See [`DescribeCustomRoutingAcceleratorAttributes`](crate::client::fluent_builders::DescribeCustomRoutingAcceleratorAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_custom_routing_accelerator_attributes(
        &self,
    ) -> fluent_builders::DescribeCustomRoutingAcceleratorAttributes<C, M, R> {
        fluent_builders::DescribeCustomRoutingAcceleratorAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCustomRoutingEndpointGroup` operation.
    ///
    /// See [`DescribeCustomRoutingEndpointGroup`](crate::client::fluent_builders::DescribeCustomRoutingEndpointGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_custom_routing_endpoint_group(
        &self,
    ) -> fluent_builders::DescribeCustomRoutingEndpointGroup<C, M, R> {
        fluent_builders::DescribeCustomRoutingEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCustomRoutingListener` operation.
    ///
    /// See [`DescribeCustomRoutingListener`](crate::client::fluent_builders::DescribeCustomRoutingListener) for more information about the
    /// operation and its arguments.
    pub fn describe_custom_routing_listener(
        &self,
    ) -> fluent_builders::DescribeCustomRoutingListener<C, M, R> {
        fluent_builders::DescribeCustomRoutingListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpointGroup` operation.
    ///
    /// See [`DescribeEndpointGroup`](crate::client::fluent_builders::DescribeEndpointGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoint_group(&self) -> fluent_builders::DescribeEndpointGroup<C, M, R> {
        fluent_builders::DescribeEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeListener` operation.
    ///
    /// See [`DescribeListener`](crate::client::fluent_builders::DescribeListener) for more information about the
    /// operation and its arguments.
    pub fn describe_listener(&self) -> fluent_builders::DescribeListener<C, M, R> {
        fluent_builders::DescribeListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccelerators` operation.
    ///
    /// See [`ListAccelerators`](crate::client::fluent_builders::ListAccelerators) for more information about the
    /// operation and its arguments.
    pub fn list_accelerators(&self) -> fluent_builders::ListAccelerators<C, M, R> {
        fluent_builders::ListAccelerators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListByoipCidrs` operation.
    ///
    /// See [`ListByoipCidrs`](crate::client::fluent_builders::ListByoipCidrs) for more information about the
    /// operation and its arguments.
    pub fn list_byoip_cidrs(&self) -> fluent_builders::ListByoipCidrs<C, M, R> {
        fluent_builders::ListByoipCidrs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCustomRoutingAccelerators` operation.
    ///
    /// See [`ListCustomRoutingAccelerators`](crate::client::fluent_builders::ListCustomRoutingAccelerators) for more information about the
    /// operation and its arguments.
    pub fn list_custom_routing_accelerators(
        &self,
    ) -> fluent_builders::ListCustomRoutingAccelerators<C, M, R> {
        fluent_builders::ListCustomRoutingAccelerators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCustomRoutingEndpointGroups` operation.
    ///
    /// See [`ListCustomRoutingEndpointGroups`](crate::client::fluent_builders::ListCustomRoutingEndpointGroups) for more information about the
    /// operation and its arguments.
    pub fn list_custom_routing_endpoint_groups(
        &self,
    ) -> fluent_builders::ListCustomRoutingEndpointGroups<C, M, R> {
        fluent_builders::ListCustomRoutingEndpointGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCustomRoutingListeners` operation.
    ///
    /// See [`ListCustomRoutingListeners`](crate::client::fluent_builders::ListCustomRoutingListeners) for more information about the
    /// operation and its arguments.
    pub fn list_custom_routing_listeners(
        &self,
    ) -> fluent_builders::ListCustomRoutingListeners<C, M, R> {
        fluent_builders::ListCustomRoutingListeners::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCustomRoutingPortMappings` operation.
    ///
    /// See [`ListCustomRoutingPortMappings`](crate::client::fluent_builders::ListCustomRoutingPortMappings) for more information about the
    /// operation and its arguments.
    pub fn list_custom_routing_port_mappings(
        &self,
    ) -> fluent_builders::ListCustomRoutingPortMappings<C, M, R> {
        fluent_builders::ListCustomRoutingPortMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCustomRoutingPortMappingsByDestination` operation.
    ///
    /// See [`ListCustomRoutingPortMappingsByDestination`](crate::client::fluent_builders::ListCustomRoutingPortMappingsByDestination) for more information about the
    /// operation and its arguments.
    pub fn list_custom_routing_port_mappings_by_destination(
        &self,
    ) -> fluent_builders::ListCustomRoutingPortMappingsByDestination<C, M, R> {
        fluent_builders::ListCustomRoutingPortMappingsByDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEndpointGroups` operation.
    ///
    /// See [`ListEndpointGroups`](crate::client::fluent_builders::ListEndpointGroups) for more information about the
    /// operation and its arguments.
    pub fn list_endpoint_groups(&self) -> fluent_builders::ListEndpointGroups<C, M, R> {
        fluent_builders::ListEndpointGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListListeners` operation.
    ///
    /// See [`ListListeners`](crate::client::fluent_builders::ListListeners) for more information about the
    /// operation and its arguments.
    pub fn list_listeners(&self) -> fluent_builders::ListListeners<C, M, R> {
        fluent_builders::ListListeners::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ProvisionByoipCidr` operation.
    ///
    /// See [`ProvisionByoipCidr`](crate::client::fluent_builders::ProvisionByoipCidr) for more information about the
    /// operation and its arguments.
    pub fn provision_byoip_cidr(&self) -> fluent_builders::ProvisionByoipCidr<C, M, R> {
        fluent_builders::ProvisionByoipCidr::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveCustomRoutingEndpoints` operation.
    ///
    /// See [`RemoveCustomRoutingEndpoints`](crate::client::fluent_builders::RemoveCustomRoutingEndpoints) for more information about the
    /// operation and its arguments.
    pub fn remove_custom_routing_endpoints(
        &self,
    ) -> fluent_builders::RemoveCustomRoutingEndpoints<C, M, R> {
        fluent_builders::RemoveCustomRoutingEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccelerator` operation.
    ///
    /// See [`UpdateAccelerator`](crate::client::fluent_builders::UpdateAccelerator) for more information about the
    /// operation and its arguments.
    pub fn update_accelerator(&self) -> fluent_builders::UpdateAccelerator<C, M, R> {
        fluent_builders::UpdateAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAcceleratorAttributes` operation.
    ///
    /// See [`UpdateAcceleratorAttributes`](crate::client::fluent_builders::UpdateAcceleratorAttributes) for more information about the
    /// operation and its arguments.
    pub fn update_accelerator_attributes(
        &self,
    ) -> fluent_builders::UpdateAcceleratorAttributes<C, M, R> {
        fluent_builders::UpdateAcceleratorAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCustomRoutingAccelerator` operation.
    ///
    /// See [`UpdateCustomRoutingAccelerator`](crate::client::fluent_builders::UpdateCustomRoutingAccelerator) for more information about the
    /// operation and its arguments.
    pub fn update_custom_routing_accelerator(
        &self,
    ) -> fluent_builders::UpdateCustomRoutingAccelerator<C, M, R> {
        fluent_builders::UpdateCustomRoutingAccelerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCustomRoutingAcceleratorAttributes` operation.
    ///
    /// See [`UpdateCustomRoutingAcceleratorAttributes`](crate::client::fluent_builders::UpdateCustomRoutingAcceleratorAttributes) for more information about the
    /// operation and its arguments.
    pub fn update_custom_routing_accelerator_attributes(
        &self,
    ) -> fluent_builders::UpdateCustomRoutingAcceleratorAttributes<C, M, R> {
        fluent_builders::UpdateCustomRoutingAcceleratorAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCustomRoutingListener` operation.
    ///
    /// See [`UpdateCustomRoutingListener`](crate::client::fluent_builders::UpdateCustomRoutingListener) for more information about the
    /// operation and its arguments.
    pub fn update_custom_routing_listener(
        &self,
    ) -> fluent_builders::UpdateCustomRoutingListener<C, M, R> {
        fluent_builders::UpdateCustomRoutingListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEndpointGroup` operation.
    ///
    /// See [`UpdateEndpointGroup`](crate::client::fluent_builders::UpdateEndpointGroup) for more information about the
    /// operation and its arguments.
    pub fn update_endpoint_group(&self) -> fluent_builders::UpdateEndpointGroup<C, M, R> {
        fluent_builders::UpdateEndpointGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateListener` operation.
    ///
    /// See [`UpdateListener`](crate::client::fluent_builders::UpdateListener) for more information about the
    /// operation and its arguments.
    pub fn update_listener(&self) -> fluent_builders::UpdateListener<C, M, R> {
        fluent_builders::UpdateListener::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `WithdrawByoipCidr` operation.
    ///
    /// See [`WithdrawByoipCidr`](crate::client::fluent_builders::WithdrawByoipCidr) for more information about the
    /// operation and its arguments.
    pub fn withdraw_byoip_cidr(&self) -> fluent_builders::WithdrawByoipCidr<C, M, R> {
        fluent_builders::WithdrawByoipCidr::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddCustomRoutingEndpoints`.
    ///
    /// <p>Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.</p>
    /// <p>The listener port range must be large enough to support the number of IP addresses that can be
    /// specified in your subnet. The number of ports required is: subnet size times the number
    /// of ports per destination EC2 instances. For example, a subnet defined as /24 requires a listener
    /// port range of at least 255 ports. </p>
    /// <p>Note: You must have enough remaining listener ports available to
    /// map to the subnet ports, or the call will fail with a LimitExceededException.</p>
    /// <p>By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all
    /// destinations to receive traffic, or to specify individual port mappings that can receive
    /// traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
    /// AllowCustomRoutingTraffic</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddCustomRoutingEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_custom_routing_endpoints_input::Builder,
    }
    impl<C, M, R> AddCustomRoutingEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddCustomRoutingEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddCustomRoutingEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddCustomRoutingEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddCustomRoutingEndpointsInputOperationOutputAlias,
                crate::output::AddCustomRoutingEndpointsOutput,
                crate::error::AddCustomRoutingEndpointsError,
                crate::input::AddCustomRoutingEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EndpointConfigurations`.
        ///
        /// To override the contents of this collection use [`set_endpoint_configurations`](Self::set_endpoint_configurations).
        ///
        /// <p>The list of endpoint objects to add to a custom routing accelerator.</p>
        pub fn endpoint_configurations(
            mut self,
            inp: impl Into<crate::model::CustomRoutingEndpointConfiguration>,
        ) -> Self {
            self.inner = self.inner.endpoint_configurations(inp);
            self
        }
        /// <p>The list of endpoint objects to add to a custom routing accelerator.</p>
        pub fn set_endpoint_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CustomRoutingEndpointConfiguration>,
            >,
        ) -> Self {
            self.inner = self.inner.set_endpoint_configurations(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>
        pub fn endpoint_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AdvertiseByoipCidr`.
    ///
    /// <p>Advertises an IPv4 address range that is provisioned for use with your AWS resources
    /// through bring your own IP addresses (BYOIP). It can take a few minutes before traffic to
    /// the specified addresses starts routing to AWS because of propagation delays. </p>
    /// <p>To stop advertising the BYOIP address range, use <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">
    /// WithdrawByoipCidr</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
    /// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AdvertiseByoipCidr<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::advertise_byoip_cidr_input::Builder,
    }
    impl<C, M, R> AdvertiseByoipCidr<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AdvertiseByoipCidr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AdvertiseByoipCidrOutput,
            aws_smithy_http::result::SdkError<crate::error::AdvertiseByoipCidrError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AdvertiseByoipCidrInputOperationOutputAlias,
                crate::output::AdvertiseByoipCidrOutput,
                crate::error::AdvertiseByoipCidrError,
                crate::input::AdvertiseByoipCidrInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned.
        /// You can't advertise only a portion of the provisioned range.</p>
        pub fn cidr(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(inp);
            self
        }
        /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned.
        /// You can't advertise only a portion of the provisioned range.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AllowCustomRoutingTraffic`.
    ///
    /// <p>Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic
    /// for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a
    /// specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports
    /// outside of the range that you configured for the endpoint group.</p>
    /// <p>After you make changes, you can verify that the updates are complete by checking the status of your
    /// accelerator: the status changes from IN_PROGRESS to DEPLOYED.</p>
    #[derive(std::fmt::Debug)]
    pub struct AllowCustomRoutingTraffic<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::allow_custom_routing_traffic_input::Builder,
    }
    impl<C, M, R> AllowCustomRoutingTraffic<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AllowCustomRoutingTraffic`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllowCustomRoutingTrafficOutput,
            aws_smithy_http::result::SdkError<crate::error::AllowCustomRoutingTrafficError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AllowCustomRoutingTrafficInputOperationOutputAlias,
                crate::output::AllowCustomRoutingTrafficOutput,
                crate::error::AllowCustomRoutingTrafficError,
                crate::input::AllowCustomRoutingTrafficInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(inp);
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
        /// Appends an item to `DestinationAddresses`.
        ///
        /// To override the contents of this collection use [`set_destination_addresses`](Self::set_destination_addresses).
        ///
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive
        /// traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.</p>
        /// <p>
        /// <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or is
        /// not specified.</p>
        pub fn destination_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_addresses(inp);
            self
        }
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive
        /// traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.</p>
        /// <p>
        /// <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or is
        /// not specified.</p>
        pub fn set_destination_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_destination_addresses(input);
            self
        }
        /// Appends an item to `DestinationPorts`.
        ///
        /// To override the contents of this collection use [`set_destination_ports`](Self::set_destination_ports).
        ///
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.</p>
        pub fn destination_ports(mut self, inp: impl Into<i32>) -> Self {
            self.inner = self.inner.destination_ports(inp);
            self
        }
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.</p>
        pub fn set_destination_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.inner = self.inner.set_destination_ports(input);
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic
        /// from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note
        /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed
        /// to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
        /// the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn allow_all_traffic_to_endpoint(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_all_traffic_to_endpoint(inp);
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic
        /// from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note
        /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed
        /// to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
        /// the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn set_allow_all_traffic_to_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_allow_all_traffic_to_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccelerator`.
    ///
    /// <p>Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct traffic
    /// to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers. </p>  
    /// <important>
    /// <p>Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
    /// US West (Oregon) Region to create or update accelerators.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccelerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_accelerator_input::Builder,
    }
    impl<C, M, R> CreateAccelerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAcceleratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAcceleratorInputOperationOutputAlias,
                crate::output::CreateAcceleratorOutput,
                crate::error::CreateAcceleratorError,
                crate::input::CreateAcceleratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn ip_address_type(mut self, inp: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(inp);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// Appends an item to `IpAddresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
        /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
        /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
        /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
        /// accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
        /// accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
        /// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn ip_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_addresses(inp);
            self
        }
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
        /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
        /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
        /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
        /// accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
        /// accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
        /// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ip_addresses(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of an accelerator.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of an accelerator.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
        /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
        /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomRoutingAccelerator`.
    ///
    /// <p>Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands
    /// of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.</p>
    /// <p>Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive
    /// traffic. To enable all destinations to receive traffic, or to specify individual port
    /// mappings that can receive traffic, see the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
    /// AllowCustomRoutingTraffic</a> operation.</p>
    /// <important>
    /// <p>Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
    /// US West (Oregon) Region to create or update accelerators.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateCustomRoutingAccelerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_routing_accelerator_input::Builder,
    }
    impl<C, M, R> CreateCustomRoutingAccelerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomRoutingAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomRoutingAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomRoutingAcceleratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomRoutingAcceleratorInputOperationOutputAlias,
                crate::output::CreateCustomRoutingAcceleratorOutput,
                crate::error::CreateCustomRoutingAcceleratorError,
                crate::input::CreateCustomRoutingAcceleratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain
        /// only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain
        /// only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn ip_address_type(mut self, inp: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(inp);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// Appends an item to `IpAddresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
        /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
        /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
        /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
        /// accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
        /// accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring
        /// your own IP addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn ip_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_addresses(inp);
            self
        }
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
        /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
        /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
        /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
        /// accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
        /// accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring
        /// your own IP addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ip_addresses(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that
        /// is, the uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that
        /// is, the uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
        /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
        /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomRoutingEndpointGroup`.
    ///
    /// <p>Create an endpoint group for the specified listener for a custom routing accelerator.
    /// An endpoint group is a collection of endpoints in one AWS
    /// Region. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCustomRoutingEndpointGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_routing_endpoint_group_input::Builder,
    }
    impl<C, M, R> CreateCustomRoutingEndpointGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomRoutingEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomRoutingEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomRoutingEndpointGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomRoutingEndpointGroupInputOperationOutputAlias,
                crate::output::CreateCustomRoutingEndpointGroupOutput,
                crate::error::CreateCustomRoutingEndpointGroupError,
                crate::input::CreateCustomRoutingEndpointGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.</p>
        pub fn listener_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
        /// specific Region.</p>
        pub fn endpoint_group_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_region(inp);
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
        /// specific Region.</p>
        pub fn set_endpoint_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_region(input);
            self
        }
        /// Appends an item to `DestinationConfigurations`.
        ///
        /// To override the contents of this collection use [`set_destination_configurations`](Self::set_destination_configurations).
        ///
        /// <p>Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept
        /// client traffic on.</p>
        pub fn destination_configurations(
            mut self,
            inp: impl Into<crate::model::CustomRoutingDestinationConfiguration>,
        ) -> Self {
            self.inner = self.inner.destination_configurations(inp);
            self
        }
        /// <p>Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept
        /// client traffic on.</p>
        pub fn set_destination_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CustomRoutingDestinationConfiguration>,
            >,
        ) -> Self {
            self.inner = self.inner.set_destination_configurations(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomRoutingListener`.
    ///
    /// <p>Create a listener to process inbound connections from clients to a custom routing accelerator.
    /// Connections arrive to assigned static IP addresses on the port range that you specify. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCustomRoutingListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_routing_listener_input::Builder,
    }
    impl<C, M, R> CreateCustomRoutingListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomRoutingListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomRoutingListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomRoutingListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomRoutingListenerInputOperationOutputAlias,
                crate::output::CreateCustomRoutingListenerOutput,
                crate::error::CreateCustomRoutingListenerError,
                crate::input::CreateCustomRoutingListenerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// Appends an item to `PortRanges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The port range to support for connections from clients to your accelerator.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
        /// endpoints for custom routing accelerators</a>.</p>
        pub fn port_ranges(mut self, inp: impl Into<crate::model::PortRange>) -> Self {
            self.inner = self.inner.port_ranges(inp);
            self
        }
        /// <p>The port range to support for connections from clients to your accelerator.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
        /// endpoints for custom routing accelerators</a>.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.inner = self.inner.set_port_ranges(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEndpointGroup`.
    ///
    /// <p>Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one AWS
    /// Region. A resource must be valid and active when you add it as an endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEndpointGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_endpoint_group_input::Builder,
    }
    impl<C, M, R> CreateEndpointGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEndpointGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEndpointGroupInputOperationOutputAlias,
                crate::output::CreateEndpointGroupOutput,
                crate::error::CreateEndpointGroupError,
                crate::input::CreateEndpointGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
        /// specific Region.</p>
        pub fn endpoint_group_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_region(inp);
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
        /// specific Region.</p>
        pub fn set_endpoint_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_region(input);
            self
        }
        /// Appends an item to `EndpointConfigurations`.
        ///
        /// To override the contents of this collection use [`set_endpoint_configurations`](Self::set_endpoint_configurations).
        ///
        /// <p>The list of endpoint objects.</p>
        pub fn endpoint_configurations(
            mut self,
            inp: impl Into<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.inner = self.inner.endpoint_configurations(inp);
            self
        }
        /// <p>The list of endpoint objects.</p>
        pub fn set_endpoint_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_configurations(input);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
        /// this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
        /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn traffic_dial_percentage(mut self, inp: f32) -> Self {
            self.inner = self.inner.traffic_dial_percentage(inp);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
        /// this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
        /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn set_traffic_dial_percentage(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_traffic_dial_percentage(input);
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
        /// is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the
        /// first port in the list.</p>
        pub fn health_check_port(mut self, inp: i32) -> Self {
            self.inner = self.inner.health_check_port(inp);
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
        /// is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the
        /// first port in the list.</p>
        pub fn set_health_check_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_health_check_port(input);
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
        /// value is TCP.</p>
        pub fn health_check_protocol(mut self, inp: crate::model::HealthCheckProtocol) -> Self {
            self.inner = self.inner.health_check_protocol(inp);
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
        /// value is TCP.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::HealthCheckProtocol>,
        ) -> Self {
            self.inner = self.inner.set_health_check_protocol(input);
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
        /// default value is slash (/).</p>
        pub fn health_check_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_path(inp);
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
        /// default value is slash (/).</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_path(input);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn health_check_interval_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.health_check_interval_seconds(inp);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_health_check_interval_seconds(input);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
        /// unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn threshold_count(mut self, inp: i32) -> Self {
            self.inner = self.inner.threshold_count(inp);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
        /// unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn set_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_threshold_count(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// Appends an item to `PortOverrides`.
        ///
        /// To override the contents of this collection use [`set_port_overrides`](Self::set_port_overrides).
        ///
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
        /// For example, you can create a port override in which the listener
        /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
        /// and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
        /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn port_overrides(mut self, inp: impl Into<crate::model::PortOverride>) -> Self {
            self.inner = self.inner.port_overrides(inp);
            self
        }
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
        /// For example, you can create a port override in which the listener
        /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
        /// and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
        /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_port_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
        ) -> Self {
            self.inner = self.inner.set_port_overrides(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateListener`.
    ///
    /// <p>Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static
    /// IP addresses on a port, port range, or list of port ranges that you specify. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_listener_input::Builder,
    }
    impl<C, M, R> CreateListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateListenerInputOperationOutputAlias,
                crate::output::CreateListenerOutput,
                crate::error::CreateListenerError,
                crate::input::CreateListenerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of your accelerator.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of your accelerator.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// Appends an item to `PortRanges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The list of port ranges to support for connections from clients to your accelerator.</p>
        pub fn port_ranges(mut self, inp: impl Into<crate::model::PortRange>) -> Self {
            self.inner = self.inner.port_ranges(inp);
            self
        }
        /// <p>The list of port ranges to support for connections from clients to your accelerator.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.inner = self.inner.set_port_ranges(input);
            self
        }
        /// <p>The protocol for connections from clients to your accelerator.</p>
        pub fn protocol(mut self, inp: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocol(inp);
            self
        }
        /// <p>The protocol for connections from clients to your accelerator.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
        /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
        /// route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
        /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
        /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
        /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
        /// be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
        /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
        /// source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn client_affinity(mut self, inp: crate::model::ClientAffinity) -> Self {
            self.inner = self.inner.client_affinity(inp);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
        /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
        /// route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
        /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
        /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
        /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
        /// be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
        /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
        /// source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn set_client_affinity(
            mut self,
            input: std::option::Option<crate::model::ClientAffinity>,
        ) -> Self {
            self.inner = self.inner.set_client_affinity(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccelerator`.
    ///
    /// <p>Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources
    /// (listeners and endpoint groups). To disable the accelerator, update the accelerator to set <code>Enabled</code> to false.</p>
    /// <important>
    /// <p>When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
    /// Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses from those ranges.
    /// </p>
    /// <p>The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and
    /// it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the
    /// static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them.
    /// As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You
    /// can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information,
    /// see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control</a> in
    /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccelerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_accelerator_input::Builder,
    }
    impl<C, M, R> DeleteAccelerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAcceleratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAcceleratorInputOperationOutputAlias,
                crate::output::DeleteAcceleratorOutput,
                crate::error::DeleteAcceleratorError,
                crate::input::DeleteAcceleratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of an accelerator.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an accelerator.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomRoutingAccelerator`.
    ///
    /// <p>Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources
    /// (listeners and endpoint groups). To disable the accelerator, update the accelerator to set <code>Enabled</code> to false.</p>
    /// <important>
    /// <p>When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
    /// </p>
    /// <p>The IP
    /// addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and
    /// it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the
    /// static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them.
    /// As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You
    /// can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information,
    /// see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Authentication and Access Control</a> in
    /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCustomRoutingAccelerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_routing_accelerator_input::Builder,
    }
    impl<C, M, R> DeleteCustomRoutingAccelerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomRoutingAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomRoutingAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomRoutingAcceleratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomRoutingAcceleratorInputOperationOutputAlias,
                crate::output::DeleteCustomRoutingAcceleratorOutput,
                crate::error::DeleteCustomRoutingAcceleratorError,
                crate::input::DeleteCustomRoutingAcceleratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to delete.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to delete.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomRoutingEndpointGroup`.
    ///
    /// <p>Delete an endpoint group from a listener for a custom routing accelerator.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCustomRoutingEndpointGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_routing_endpoint_group_input::Builder,
    }
    impl<C, M, R> DeleteCustomRoutingEndpointGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomRoutingEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomRoutingEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomRoutingEndpointGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomRoutingEndpointGroupInputOperationOutputAlias,
                crate::output::DeleteCustomRoutingEndpointGroupOutput,
                crate::error::DeleteCustomRoutingEndpointGroupError,
                crate::input::DeleteCustomRoutingEndpointGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn endpoint_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomRoutingListener`.
    ///
    /// <p>Delete a listener for a custom routing accelerator.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCustomRoutingListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_routing_listener_input::Builder,
    }
    impl<C, M, R> DeleteCustomRoutingListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomRoutingListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomRoutingListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomRoutingListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomRoutingListenerInputOperationOutputAlias,
                crate::output::DeleteCustomRoutingListenerOutput,
                crate::error::DeleteCustomRoutingListenerError,
                crate::input::DeleteCustomRoutingListenerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to delete.</p>
        pub fn listener_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to delete.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpointGroup`.
    ///
    /// <p>Delete an endpoint group from a listener.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEndpointGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_endpoint_group_input::Builder,
    }
    impl<C, M, R> DeleteEndpointGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEndpointGroupInputOperationOutputAlias,
                crate::output::DeleteEndpointGroupOutput,
                crate::error::DeleteEndpointGroupError,
                crate::input::DeleteEndpointGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn endpoint_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteListener`.
    ///
    /// <p>Delete a listener from an accelerator.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_listener_input::Builder,
    }
    impl<C, M, R> DeleteListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteListenerInputOperationOutputAlias,
                crate::output::DeleteListenerOutput,
                crate::error::DeleteListenerError,
                crate::input::DeleteListenerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DenyCustomRoutingTraffic`.
    ///
    /// <p>Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic
    /// for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a
    /// specified list of destination IP addresses and ports. Note that you cannot specify IP addresses
    /// or ports outside of the range that you configured for the endpoint group.</p>
    /// <p>After you make changes, you can verify that the updates are complete by checking the status of your
    /// accelerator: the status changes from IN_PROGRESS to DEPLOYED.</p>
    #[derive(std::fmt::Debug)]
    pub struct DenyCustomRoutingTraffic<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deny_custom_routing_traffic_input::Builder,
    }
    impl<C, M, R> DenyCustomRoutingTraffic<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DenyCustomRoutingTraffic`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DenyCustomRoutingTrafficOutput,
            aws_smithy_http::result::SdkError<crate::error::DenyCustomRoutingTrafficError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DenyCustomRoutingTrafficInputOperationOutputAlias,
                crate::output::DenyCustomRoutingTrafficOutput,
                crate::error::DenyCustomRoutingTrafficError,
                crate::input::DenyCustomRoutingTrafficInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(inp);
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
        /// Appends an item to `DestinationAddresses`.
        ///
        /// To override the contents of this collection use [`set_destination_addresses`](Self::set_destination_addresses).
        ///
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving
        /// traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the
        /// endpoint group.</p>
        pub fn destination_addresses(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_addresses(inp);
            self
        }
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving
        /// traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the
        /// endpoint group.</p>
        pub fn set_destination_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_destination_addresses(input);
            self
        }
        /// Appends an item to `DestinationPorts`.
        ///
        /// To override the contents of this collection use [`set_destination_ports`](Self::set_destination_ports).
        ///
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from
        /// receiving traffic.</p>
        pub fn destination_ports(mut self, inp: impl Into<i32>) -> Self {
            self.inner = self.inner.destination_ports(inp);
            self
        }
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from
        /// receiving traffic.</p>
        pub fn set_destination_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.inner = self.inner.set_destination_ports(input);
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i>
        /// receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note
        /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot receive
        /// traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
        /// the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn deny_all_traffic_to_endpoint(mut self, inp: bool) -> Self {
            self.inner = self.inner.deny_all_traffic_to_endpoint(inp);
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i>
        /// receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note
        /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot receive
        /// traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
        /// the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn set_deny_all_traffic_to_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_deny_all_traffic_to_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeprovisionByoipCidr`.
    ///
    /// <p>Releases the specified address range that you provisioned to use with your AWS resources
    /// through bring your own IP addresses (BYOIP) and deletes the corresponding address pool. </p>
    /// <p>Before you can release an address range, you must stop advertising it by using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr</a> and you must not have
    /// any accelerators that are using static IP addresses allocated from its address range.
    /// </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
    /// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeprovisionByoipCidr<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deprovision_byoip_cidr_input::Builder,
    }
    impl<C, M, R> DeprovisionByoipCidr<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeprovisionByoipCidr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeprovisionByoipCidrOutput,
            aws_smithy_http::result::SdkError<crate::error::DeprovisionByoipCidrError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeprovisionByoipCidrInputOperationOutputAlias,
                crate::output::DeprovisionByoipCidrOutput,
                crate::error::DeprovisionByoipCidrError,
                crate::input::DeprovisionByoipCidrInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified
        /// when you provisioned the address range.</p>
        pub fn cidr(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(inp);
            self
        }
        /// <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified
        /// when you provisioned the address range.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccelerator`.
    ///
    /// <p>Describe an accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccelerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_accelerator_input::Builder,
    }
    impl<C, M, R> DescribeAccelerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAcceleratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAcceleratorInputOperationOutputAlias,
                crate::output::DescribeAcceleratorOutput,
                crate::error::DescribeAcceleratorError,
                crate::input::DescribeAcceleratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAcceleratorAttributes`.
    ///
    /// <p>Describe the attributes of an accelerator.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAcceleratorAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_accelerator_attributes_input::Builder,
    }
    impl<C, M, R> DescribeAcceleratorAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAcceleratorAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAcceleratorAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAcceleratorAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAcceleratorAttributesInputOperationOutputAlias,
                crate::output::DescribeAcceleratorAttributesOutput,
                crate::error::DescribeAcceleratorAttributesError,
                crate::input::DescribeAcceleratorAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator with the attributes that you want to describe.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator with the attributes that you want to describe.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomRoutingAccelerator`.
    ///
    /// <p>Describe a custom routing accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCustomRoutingAccelerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_custom_routing_accelerator_input::Builder,
    }
    impl<C, M, R> DescribeCustomRoutingAccelerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCustomRoutingAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomRoutingAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomRoutingAcceleratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCustomRoutingAcceleratorInputOperationOutputAlias,
                crate::output::DescribeCustomRoutingAcceleratorOutput,
                crate::error::DescribeCustomRoutingAcceleratorError,
                crate::input::DescribeCustomRoutingAcceleratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomRoutingAcceleratorAttributes`.
    ///
    /// <p>Describe the attributes of a custom routing accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCustomRoutingAcceleratorAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_custom_routing_accelerator_attributes_input::Builder,
    }
    impl<C, M, R> DescribeCustomRoutingAcceleratorAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCustomRoutingAcceleratorAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomRoutingAcceleratorAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeCustomRoutingAcceleratorAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCustomRoutingAcceleratorAttributesInputOperationOutputAlias,
                crate::output::DescribeCustomRoutingAcceleratorAttributesOutput,
                crate::error::DescribeCustomRoutingAcceleratorAttributesError,
                crate::input::DescribeCustomRoutingAcceleratorAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomRoutingEndpointGroup`.
    ///
    /// <p>Describe an endpoint group for a custom routing accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCustomRoutingEndpointGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_custom_routing_endpoint_group_input::Builder,
    }
    impl<C, M, R> DescribeCustomRoutingEndpointGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCustomRoutingEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomRoutingEndpointGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeCustomRoutingEndpointGroupError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCustomRoutingEndpointGroupInputOperationOutputAlias,
                crate::output::DescribeCustomRoutingEndpointGroupOutput,
                crate::error::DescribeCustomRoutingEndpointGroupError,
                crate::input::DescribeCustomRoutingEndpointGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn endpoint_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomRoutingListener`.
    ///
    /// <p>The description of a listener for a custom routing accelerator.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCustomRoutingListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_custom_routing_listener_input::Builder,
    }
    impl<C, M, R> DescribeCustomRoutingListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCustomRoutingListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomRoutingListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomRoutingListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCustomRoutingListenerInputOperationOutputAlias,
                crate::output::DescribeCustomRoutingListenerOutput,
                crate::error::DescribeCustomRoutingListenerError,
                crate::input::DescribeCustomRoutingListenerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn listener_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointGroup`.
    ///
    /// <p>Describe an endpoint group. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEndpointGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoint_group_input::Builder,
    }
    impl<C, M, R> DescribeEndpointGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointGroupInputOperationOutputAlias,
                crate::output::DescribeEndpointGroupOutput,
                crate::error::DescribeEndpointGroupError,
                crate::input::DescribeEndpointGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn endpoint_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeListener`.
    ///
    /// <p>Describe a listener. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_listener_input::Builder,
    }
    impl<C, M, R> DescribeListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeListenerInputOperationOutputAlias,
                crate::output::DescribeListenerOutput,
                crate::error::DescribeListenerError,
                crate::input::DescribeListenerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn listener_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccelerators`.
    ///
    /// <p>List the accelerators for an AWS account. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccelerators<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_accelerators_input::Builder,
    }
    impl<C, M, R> ListAccelerators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccelerators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAcceleratorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAcceleratorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAcceleratorsInputOperationOutputAlias,
                crate::output::ListAcceleratorsOutput,
                crate::error::ListAcceleratorsError,
                crate::input::ListAcceleratorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListByoipCidrs`.
    ///
    /// <p>Lists the IP address ranges that were specified in calls to <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>, including
    /// the current state and a history of state changes.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListByoipCidrs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_byoip_cidrs_input::Builder,
    }
    impl<C, M, R> ListByoipCidrs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListByoipCidrs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListByoipCidrsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListByoipCidrsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListByoipCidrsInputOperationOutputAlias,
                crate::output::ListByoipCidrsOutput,
                crate::error::ListByoipCidrsError,
                crate::input::ListByoipCidrsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make
        /// another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make
        /// another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomRoutingAccelerators`.
    ///
    /// <p>List the custom routing accelerators for an AWS account. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListCustomRoutingAccelerators<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_routing_accelerators_input::Builder,
    }
    impl<C, M, R> ListCustomRoutingAccelerators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomRoutingAccelerators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomRoutingAcceleratorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingAcceleratorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomRoutingAcceleratorsInputOperationOutputAlias,
                crate::output::ListCustomRoutingAcceleratorsOutput,
                crate::error::ListCustomRoutingAcceleratorsError,
                crate::input::ListCustomRoutingAcceleratorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomRoutingEndpointGroups`.
    ///
    /// <p>List the endpoint groups that are associated with a listener for a custom routing accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListCustomRoutingEndpointGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_routing_endpoint_groups_input::Builder,
    }
    impl<C, M, R> ListCustomRoutingEndpointGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomRoutingEndpointGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomRoutingEndpointGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingEndpointGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomRoutingEndpointGroupsInputOperationOutputAlias,
                crate::output::ListCustomRoutingEndpointGroupsOutput,
                crate::error::ListCustomRoutingEndpointGroupsError,
                crate::input::ListCustomRoutingEndpointGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to list endpoint groups for.</p>
        pub fn listener_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to list endpoint groups for.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomRoutingListeners`.
    ///
    /// <p>List the listeners for a custom routing accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListCustomRoutingListeners<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_routing_listeners_input::Builder,
    }
    impl<C, M, R> ListCustomRoutingListeners<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomRoutingListeners`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomRoutingListenersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingListenersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomRoutingListenersInputOperationOutputAlias,
                crate::output::ListCustomRoutingListenersOutput,
                crate::error::ListCustomRoutingListenersError,
                crate::input::ListCustomRoutingListenersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list listeners for.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list listeners for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomRoutingPortMappings`.
    ///
    /// <p>Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance
    /// IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator.
    /// For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
    /// mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers. </p>
    /// <p>If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add a subnet to
    /// your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If you add or remove EC2 instances
    /// in your subnet, the port mappings don't change, because the mappings are created when you add the subnet to Global Accelerator.</p>
    /// <p>The mappings also include a flag for each destination denoting which destination IP addresses and
    /// ports are allowed or denied traffic.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCustomRoutingPortMappings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_routing_port_mappings_input::Builder,
    }
    impl<C, M, R> ListCustomRoutingPortMappings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomRoutingPortMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomRoutingPortMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomRoutingPortMappingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomRoutingPortMappingsInputOperationOutputAlias,
                crate::output::ListCustomRoutingPortMappingsOutput,
                crate::error::ListCustomRoutingPortMappingsError,
                crate::input::ListCustomRoutingPortMappingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.</p>
        pub fn endpoint_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomRoutingPortMappingsByDestination`.
    ///
    /// <p>List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The
    /// response is the mappings for one destination IP address. This is useful when your subnet endpoint has mappings that
    /// span multiple custom routing accelerators in your account, or for scenarios where you only want to
    /// list the port mappings for a specific destination instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCustomRoutingPortMappingsByDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_routing_port_mappings_by_destination_input::Builder,
    }
    impl<C, M, R> ListCustomRoutingPortMappingsByDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomRoutingPortMappingsByDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomRoutingPortMappingsByDestinationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListCustomRoutingPortMappingsByDestinationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomRoutingPortMappingsByDestinationInputOperationOutputAlias,
                crate::output::ListCustomRoutingPortMappingsByDestinationOutput,
                crate::error::ListCustomRoutingPortMappingsByDestinationError,
                crate::input::ListCustomRoutingPortMappingsByDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
        pub fn endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_id(inp);
            self
        }
        /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_id(input);
            self
        }
        /// <p>The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port
        /// mappings.</p>
        pub fn destination_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_address(inp);
            self
        }
        /// <p>The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port
        /// mappings.</p>
        pub fn set_destination_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_address(input);
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEndpointGroups`.
    ///
    /// <p>List the endpoint groups that are associated with a listener. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListEndpointGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_endpoint_groups_input::Builder,
    }
    impl<C, M, R> ListEndpointGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEndpointGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEndpointGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEndpointGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEndpointGroupsInputOperationOutputAlias,
                crate::output::ListEndpointGroupsOutput,
                crate::error::ListEndpointGroupsError,
                crate::input::ListEndpointGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListListeners`.
    ///
    /// <p>List the listeners for an accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListListeners<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_listeners_input::Builder,
    }
    impl<C, M, R> ListListeners<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListListeners`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListListenersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListListenersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListListenersInputOperationOutputAlias,
                crate::output::ListListenersOutput,
                crate::error::ListListenersError,
                crate::input::ListListenersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List all tags for an accelerator. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
    /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN uniquely identifies an accelerator.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN uniquely identifies an accelerator.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ProvisionByoipCidr`.
    ///
    /// <p>Provisions an IP address range to use with your AWS resources through bring your own IP
    /// addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned,
    /// it is ready to be advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html">
    /// AdvertiseByoipCidr</a>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
    /// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ProvisionByoipCidr<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::provision_byoip_cidr_input::Builder,
    }
    impl<C, M, R> ProvisionByoipCidr<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ProvisionByoipCidr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ProvisionByoipCidrOutput,
            aws_smithy_http::result::SdkError<crate::error::ProvisionByoipCidrError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ProvisionByoipCidrInputOperationOutputAlias,
                crate::output::ProvisionByoipCidrOutput,
                crate::error::ProvisionByoipCidrError,
                crate::input::ProvisionByoipCidrInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can
        /// specify is /24. The address range cannot overlap with another address range that you've brought
        /// to this or another Region.</p>
        pub fn cidr(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(inp);
            self
        }
        /// <p>The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can
        /// specify is /24. The address range cannot overlap with another address range that you've brought
        /// to this or another Region.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
        /// <p>A signed document that proves that you are authorized to bring the specified IP address range to
        /// Amazon using BYOIP.
        /// </p>
        pub fn cidr_authorization_context(
            mut self,
            inp: crate::model::CidrAuthorizationContext,
        ) -> Self {
            self.inner = self.inner.cidr_authorization_context(inp);
            self
        }
        /// <p>A signed document that proves that you are authorized to bring the specified IP address range to
        /// Amazon using BYOIP.
        /// </p>
        pub fn set_cidr_authorization_context(
            mut self,
            input: std::option::Option<crate::model::CidrAuthorizationContext>,
        ) -> Self {
            self.inner = self.inner.set_cidr_authorization_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveCustomRoutingEndpoints`.
    ///
    /// <p>Remove endpoints from a custom routing accelerator.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveCustomRoutingEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_custom_routing_endpoints_input::Builder,
    }
    impl<C, M, R> RemoveCustomRoutingEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveCustomRoutingEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveCustomRoutingEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveCustomRoutingEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveCustomRoutingEndpointsInputOperationOutputAlias,
                crate::output::RemoveCustomRoutingEndpointsOutput,
                crate::error::RemoveCustomRoutingEndpointsError,
                crate::input::RemoveCustomRoutingEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `EndpointIds`.
        ///
        /// To override the contents of this collection use [`set_endpoint_ids`](Self::set_endpoint_ids).
        ///
        /// <p>The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC)
        /// subnet IDs. </p>
        pub fn endpoint_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_ids(inp);
            self
        }
        /// <p>The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC)
        /// subnet IDs. </p>
        pub fn set_endpoint_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_ids(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.</p>
        pub fn endpoint_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add tags to an accelerator resource. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
    /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to add tags to. An ARN uniquely identifies a resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to add tags to. An ARN uniquely identifies a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to a resource. A tag consists of a key and a value that you define.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to a resource. A tag consists of a key and a value that you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and its associated value.
    /// The operation succeeds even if you attempt to remove tags from an accelerator that was already removed.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
    /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to remove tags from. An ARN uniquely identifies a resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to remove tags from. An ARN uniquely identifies a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key pairs that you want to remove from the specified resources.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag key pairs that you want to remove from the specified resources.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccelerator`.
    ///
    /// <p>Update an accelerator. </p>
    ///
    /// <important>
    /// <p>Global Accelerator is a global service that supports endpoints in multiple AWS Regions but you must specify the
    /// US West (Oregon) Region to create or update accelerators.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccelerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_accelerator_input::Builder,
    }
    impl<C, M, R> UpdateAccelerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAcceleratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAcceleratorInputOperationOutputAlias,
                crate::output::UpdateAcceleratorOutput,
                crate::error::UpdateAcceleratorError,
                crate::input::UpdateAcceleratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The IP address type, which must be IPv4.</p>
        pub fn ip_address_type(mut self, inp: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(inp);
            self
        }
        /// <p>The IP address type, which must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAcceleratorAttributes`.
    ///
    /// <p>Update the attributes for an accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAcceleratorAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_accelerator_attributes_input::Builder,
    }
    impl<C, M, R> UpdateAcceleratorAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAcceleratorAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAcceleratorAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAcceleratorAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAcceleratorAttributesInputOperationOutputAlias,
                crate::output::UpdateAcceleratorAttributesOutput,
                crate::error::UpdateAcceleratorAttributesError,
                crate::input::UpdateAcceleratorAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator that you want to update.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator that you want to update.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn flow_logs_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.flow_logs_enabled(inp);
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_flow_logs_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_flow_logs_enabled(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn flow_logs_s3_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_logs_s3_bucket(inp);
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn set_flow_logs_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_logs_s3_bucket(input);
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
        pub fn flow_logs_s3_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_logs_s3_prefix(inp);
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
        pub fn set_flow_logs_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_logs_s3_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomRoutingAccelerator`.
    ///
    /// <p>Update a custom routing accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCustomRoutingAccelerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_custom_routing_accelerator_input::Builder,
    }
    impl<C, M, R> UpdateCustomRoutingAccelerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCustomRoutingAccelerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomRoutingAcceleratorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCustomRoutingAcceleratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCustomRoutingAcceleratorInputOperationOutputAlias,
                crate::output::UpdateCustomRoutingAcceleratorOutput,
                crate::error::UpdateCustomRoutingAcceleratorError,
                crate::input::UpdateCustomRoutingAcceleratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn ip_address_type(mut self, inp: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(inp);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomRoutingAcceleratorAttributes`.
    ///
    /// <p>Update the attributes for a custom routing accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCustomRoutingAcceleratorAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_custom_routing_accelerator_attributes_input::Builder,
    }
    impl<C, M, R> UpdateCustomRoutingAcceleratorAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCustomRoutingAcceleratorAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomRoutingAcceleratorAttributesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateCustomRoutingAcceleratorAttributesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCustomRoutingAcceleratorAttributesInputOperationOutputAlias,
                crate::output::UpdateCustomRoutingAcceleratorAttributesOutput,
                crate::error::UpdateCustomRoutingAcceleratorAttributesError,
                crate::input::UpdateCustomRoutingAcceleratorAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.</p>
        pub fn accelerator_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accelerator_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_accelerator_arn(input);
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn flow_logs_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.flow_logs_enabled(inp);
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_flow_logs_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_flow_logs_enabled(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn flow_logs_s3_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_logs_s3_bucket(inp);
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn set_flow_logs_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_logs_s3_bucket(input);
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
        pub fn flow_logs_s3_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_logs_s3_prefix(inp);
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
        pub fn set_flow_logs_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_logs_s3_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCustomRoutingListener`.
    ///
    /// <p>Update a listener for a custom routing accelerator. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCustomRoutingListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_custom_routing_listener_input::Builder,
    }
    impl<C, M, R> UpdateCustomRoutingListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCustomRoutingListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCustomRoutingListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCustomRoutingListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCustomRoutingListenerInputOperationOutputAlias,
                crate::output::UpdateCustomRoutingListenerOutput,
                crate::error::UpdateCustomRoutingListenerError,
                crate::input::UpdateCustomRoutingListenerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn listener_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `PortRanges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The updated port range to support for connections from clients to your accelerator. If you remove ports that are
        /// currently being used by a subnet endpoint, the call fails.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
        /// endpoints for custom routing accelerators</a>.</p>
        pub fn port_ranges(mut self, inp: impl Into<crate::model::PortRange>) -> Self {
            self.inner = self.inner.port_ranges(inp);
            self
        }
        /// <p>The updated port range to support for connections from clients to your accelerator. If you remove ports that are
        /// currently being used by a subnet endpoint, the call fails.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
        /// endpoints for custom routing accelerators</a>.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.inner = self.inner.set_port_ranges(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEndpointGroup`.
    ///
    /// <p>Update an endpoint group. A resource must be valid and active when you add it as an endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEndpointGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_endpoint_group_input::Builder,
    }
    impl<C, M, R> UpdateEndpointGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEndpointGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEndpointGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEndpointGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEndpointGroupInputOperationOutputAlias,
                crate::output::UpdateEndpointGroupOutput,
                crate::error::UpdateEndpointGroupError,
                crate::input::UpdateEndpointGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_group_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_group_arn(input);
            self
        }
        /// Appends an item to `EndpointConfigurations`.
        ///
        /// To override the contents of this collection use [`set_endpoint_configurations`](Self::set_endpoint_configurations).
        ///
        /// <p>The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.</p>
        pub fn endpoint_configurations(
            mut self,
            inp: impl Into<crate::model::EndpointConfiguration>,
        ) -> Self {
            self.inner = self.inner.endpoint_configurations(inp);
            self
        }
        /// <p>The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.</p>
        pub fn set_endpoint_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_configurations(input);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
        /// this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
        /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn traffic_dial_percentage(mut self, inp: f32) -> Self {
            self.inner = self.inner.traffic_dial_percentage(inp);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
        /// this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
        /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn set_traffic_dial_percentage(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_traffic_dial_percentage(input);
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
        /// is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses
        /// the first port in the list.</p>
        pub fn health_check_port(mut self, inp: i32) -> Self {
            self.inner = self.inner.health_check_port(inp);
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
        /// is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses
        /// the first port in the list.</p>
        pub fn set_health_check_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_health_check_port(input);
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
        /// value is TCP.</p>
        pub fn health_check_protocol(mut self, inp: crate::model::HealthCheckProtocol) -> Self {
            self.inner = self.inner.health_check_protocol(inp);
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
        /// value is TCP.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::HealthCheckProtocol>,
        ) -> Self {
            self.inner = self.inner.set_health_check_protocol(input);
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
        /// default value is slash (/).</p>
        pub fn health_check_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_path(inp);
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
        /// default value is slash (/).</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_path(input);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn health_check_interval_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.health_check_interval_seconds(inp);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_health_check_interval_seconds(input);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
        /// unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn threshold_count(mut self, inp: i32) -> Self {
            self.inner = self.inner.threshold_count(inp);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
        /// unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn set_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_threshold_count(input);
            self
        }
        /// Appends an item to `PortOverrides`.
        ///
        /// To override the contents of this collection use [`set_port_overrides`](Self::set_port_overrides).
        ///
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
        /// For example, you can create a port override in which the listener
        /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
        /// and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
        /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn port_overrides(mut self, inp: impl Into<crate::model::PortOverride>) -> Self {
            self.inner = self.inner.port_overrides(inp);
            self
        }
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
        /// For example, you can create a port override in which the listener
        /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
        /// and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
        /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_port_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
        ) -> Self {
            self.inner = self.inner.set_port_overrides(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateListener`.
    ///
    /// <p>Update a listener. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateListener<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_listener_input::Builder,
    }
    impl<C, M, R> UpdateListener<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateListener`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateListenerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateListenerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateListenerInputOperationOutputAlias,
                crate::output::UpdateListenerOutput,
                crate::error::UpdateListenerError,
                crate::input::UpdateListenerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn listener_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.listener_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_listener_arn(input);
            self
        }
        /// Appends an item to `PortRanges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The updated list of port ranges for the connections from clients to the accelerator.</p>
        pub fn port_ranges(mut self, inp: impl Into<crate::model::PortRange>) -> Self {
            self.inner = self.inner.port_ranges(inp);
            self
        }
        /// <p>The updated list of port ranges for the connections from clients to the accelerator.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.inner = self.inner.set_port_ranges(input);
            self
        }
        /// <p>The updated protocol for the connections from clients to the accelerator.</p>
        pub fn protocol(mut self, inp: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocol(inp);
            self
        }
        /// <p>The updated protocol for the connections from clients to the accelerator.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
        /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
        /// route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
        /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
        /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
        /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
        /// be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
        /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
        /// source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn client_affinity(mut self, inp: crate::model::ClientAffinity) -> Self {
            self.inner = self.inner.client_affinity(inp);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
        /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
        /// route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
        /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
        /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
        /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
        /// be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
        /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
        /// source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn set_client_affinity(
            mut self,
            input: std::option::Option<crate::model::ClientAffinity>,
        ) -> Self {
            self.inner = self.inner.set_client_affinity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `WithdrawByoipCidr`.
    ///
    /// <p>Stops advertising an address range that is provisioned as an address pool.
    /// You can perform this operation at most once every 10 seconds, even if you specify different address
    /// ranges each time.</p>
    /// <p>It can take a few minutes before traffic to the specified addresses stops routing to AWS because of
    /// propagation delays.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
    /// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct WithdrawByoipCidr<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::withdraw_byoip_cidr_input::Builder,
    }
    impl<C, M, R> WithdrawByoipCidr<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `WithdrawByoipCidr`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::WithdrawByoipCidrOutput,
            aws_smithy_http::result::SdkError<crate::error::WithdrawByoipCidrError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::WithdrawByoipCidrInputOperationOutputAlias,
                crate::output::WithdrawByoipCidrOutput,
                crate::error::WithdrawByoipCidrError,
                crate::input::WithdrawByoipCidrInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The address range, in CIDR notation.</p>
        pub fn cidr(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr(inp);
            self
        }
        /// <p>The address range, in CIDR notation.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidr(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
