// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about an IP address range that is provisioned for use with your AWS resources through
/// bring your own IP address (BYOIP).</p>
/// <p>The following describes each BYOIP <code>State</code> that your IP address range can be in.</p>
/// <ul>
/// <li>
/// <p>
/// <b>PENDING_PROVISIONING</b> —
/// You’ve submitted a request to provision an IP address range but it is not yet provisioned with
/// AWS Global Accelerator.</p>
/// </li>
/// <li>
/// <p>
/// <b>READY</b> — The address range is provisioned
/// with AWS Global Accelerator and can be advertised.</p>
/// </li>
/// <li>
/// <p>
/// <b>PENDING_ADVERTISING</b> — You’ve submitted a
/// request for AWS Global Accelerator to advertise an address range but it is not yet being advertised.</p>
/// </li>
/// <li>
/// <p>
/// <b>ADVERTISING</b> — The address range is
/// being advertised by AWS Global Accelerator.</p>
/// </li>
/// <li>
/// <p>
/// <b>PENDING_WITHDRAWING</b> — You’ve submitted
/// a request to withdraw an address range from being advertised but it is still being advertised
/// by AWS Global Accelerator.</p>
/// </li>
/// <li>
/// <p>
/// <b>PENDING_DEPROVISIONING</b> — You’ve submitted a
/// request to deprovision an address range from AWS Global Accelerator but it is still provisioned.</p>
/// </li>
/// <li>
/// <p>
/// <b>DEPROVISIONED</b> — The address range is deprovisioned
/// from AWS Global Accelerator.</p>
/// </li>
/// <li>
/// <p>
/// <b>FAILED_PROVISION </b> — The request to
/// provision the address range from AWS Global Accelerator was not successful. Please make sure that
/// you provide all of the correct information, and try again. If the request fails
/// a second time, contact AWS support.</p>
/// </li>
/// <li>
/// <p>
/// <b>FAILED_ADVERTISING</b> — The request for AWS Global Accelerator
/// to advertise the address range was not successful. Please make sure that
/// you provide all of the correct information, and try again. If the request fails
/// a second time, contact AWS support.</p>
/// </li>
/// <li>
/// <p>
/// <b>FAILED_WITHDRAW</b> — The request to withdraw
/// the address range from advertising by AWS Global Accelerator was not successful. Please make sure that
/// you provide all of the correct information, and try again. If the request fails
/// a second time, contact AWS support.</p>
/// </li>
/// <li>
/// <p>
/// <b>FAILED_DEPROVISION </b> — The request to
/// deprovision the address range from AWS Global Accelerator was not successful. Please make sure that
/// you provide all of the correct information, and try again. If the request fails
/// a second time, contact AWS support.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ByoipCidr {
    /// <p>The address range, in CIDR notation.</p>
    pub cidr: std::option::Option<std::string::String>,
    /// <p>The state of the address pool.</p>
    pub state: std::option::Option<crate::model::ByoipCidrState>,
    /// <p>A history of status changes for an IP address range that you bring to AWS Global Accelerator
    /// through bring your own IP address (BYOIP).</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::ByoipCidrEvent>>,
}
impl ByoipCidr {
    /// <p>The address range, in CIDR notation.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
    /// <p>The state of the address pool.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ByoipCidrState> {
        self.state.as_ref()
    }
    /// <p>A history of status changes for an IP address range that you bring to AWS Global Accelerator
    /// through bring your own IP address (BYOIP).</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::ByoipCidrEvent]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for ByoipCidr {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ByoipCidr");
        formatter.field("cidr", &self.cidr);
        formatter.field("state", &self.state);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`ByoipCidr`](crate::model::ByoipCidr)
pub mod byoip_cidr {
    /// A builder for [`ByoipCidr`](crate::model::ByoipCidr)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ByoipCidrState>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::ByoipCidrEvent>>,
    }
    impl Builder {
        /// <p>The address range, in CIDR notation.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The address range, in CIDR notation.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// <p>The state of the address pool.</p>
        pub fn state(mut self, input: crate::model::ByoipCidrState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the address pool.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ByoipCidrState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>A history of status changes for an IP address range that you bring to AWS Global Accelerator
        /// through bring your own IP address (BYOIP).</p>
        pub fn events(mut self, input: impl Into<crate::model::ByoipCidrEvent>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>A history of status changes for an IP address range that you bring to AWS Global Accelerator
        /// through bring your own IP address (BYOIP).</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ByoipCidrEvent>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`ByoipCidr`](crate::model::ByoipCidr)
        pub fn build(self) -> crate::model::ByoipCidr {
            crate::model::ByoipCidr {
                cidr: self.cidr,
                state: self.state,
                events: self.events,
            }
        }
    }
}
impl ByoipCidr {
    /// Creates a new builder-style object to manufacture [`ByoipCidr`](crate::model::ByoipCidr)
    pub fn builder() -> crate::model::byoip_cidr::Builder {
        crate::model::byoip_cidr::Builder::default()
    }
}

/// <p>A complex type that contains a <code>Message</code> and a <code>Timestamp</code> value for changes
/// that you make in the status an IP address range that you bring to AWS Global Accelerator through bring your own IP
/// address (BYOIP).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ByoipCidrEvent {
    /// <p>A string that contains an <code>Event</code> message describing changes that you make in the status
    /// of an IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>A timestamp when you make a status change for an IP address range that you bring to AWS Global Accelerator through
    /// bring your own IP address (BYOIP).</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl ByoipCidrEvent {
    /// <p>A string that contains an <code>Event</code> message describing changes that you make in the status
    /// of an IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>A timestamp when you make a status change for an IP address range that you bring to AWS Global Accelerator through
    /// bring your own IP address (BYOIP).</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
}
impl std::fmt::Debug for ByoipCidrEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ByoipCidrEvent");
        formatter.field("message", &self.message);
        formatter.field("timestamp", &self.timestamp);
        formatter.finish()
    }
}
/// See [`ByoipCidrEvent`](crate::model::ByoipCidrEvent)
pub mod byoip_cidr_event {
    /// A builder for [`ByoipCidrEvent`](crate::model::ByoipCidrEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A string that contains an <code>Event</code> message describing changes that you make in the status
        /// of an IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A string that contains an <code>Event</code> message describing changes that you make in the status
        /// of an IP address range that you bring to AWS Global Accelerator through bring your own IP address (BYOIP).</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>A timestamp when you make a status change for an IP address range that you bring to AWS Global Accelerator through
        /// bring your own IP address (BYOIP).</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>A timestamp when you make a status change for an IP address range that you bring to AWS Global Accelerator through
        /// bring your own IP address (BYOIP).</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ByoipCidrEvent`](crate::model::ByoipCidrEvent)
        pub fn build(self) -> crate::model::ByoipCidrEvent {
            crate::model::ByoipCidrEvent {
                message: self.message,
                timestamp: self.timestamp,
            }
        }
    }
}
impl ByoipCidrEvent {
    /// Creates a new builder-style object to manufacture [`ByoipCidrEvent`](crate::model::ByoipCidrEvent)
    pub fn builder() -> crate::model::byoip_cidr_event::Builder {
        crate::model::byoip_cidr_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ByoipCidrState {
    #[allow(missing_docs)] // documentation missing in model
    Advertising,
    #[allow(missing_docs)] // documentation missing in model
    Deprovisioned,
    #[allow(missing_docs)] // documentation missing in model
    FailedAdvertising,
    #[allow(missing_docs)] // documentation missing in model
    FailedDeprovision,
    #[allow(missing_docs)] // documentation missing in model
    FailedProvision,
    #[allow(missing_docs)] // documentation missing in model
    FailedWithdraw,
    #[allow(missing_docs)] // documentation missing in model
    PendingAdvertising,
    #[allow(missing_docs)] // documentation missing in model
    PendingDeprovisioning,
    #[allow(missing_docs)] // documentation missing in model
    PendingProvisioning,
    #[allow(missing_docs)] // documentation missing in model
    PendingWithdrawing,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ByoipCidrState {
    fn from(s: &str) -> Self {
        match s {
            "ADVERTISING" => ByoipCidrState::Advertising,
            "DEPROVISIONED" => ByoipCidrState::Deprovisioned,
            "FAILED_ADVERTISING" => ByoipCidrState::FailedAdvertising,
            "FAILED_DEPROVISION" => ByoipCidrState::FailedDeprovision,
            "FAILED_PROVISION" => ByoipCidrState::FailedProvision,
            "FAILED_WITHDRAW" => ByoipCidrState::FailedWithdraw,
            "PENDING_ADVERTISING" => ByoipCidrState::PendingAdvertising,
            "PENDING_DEPROVISIONING" => ByoipCidrState::PendingDeprovisioning,
            "PENDING_PROVISIONING" => ByoipCidrState::PendingProvisioning,
            "PENDING_WITHDRAWING" => ByoipCidrState::PendingWithdrawing,
            "READY" => ByoipCidrState::Ready,
            other => ByoipCidrState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ByoipCidrState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ByoipCidrState::from(s))
    }
}
impl ByoipCidrState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ByoipCidrState::Advertising => "ADVERTISING",
            ByoipCidrState::Deprovisioned => "DEPROVISIONED",
            ByoipCidrState::FailedAdvertising => "FAILED_ADVERTISING",
            ByoipCidrState::FailedDeprovision => "FAILED_DEPROVISION",
            ByoipCidrState::FailedProvision => "FAILED_PROVISION",
            ByoipCidrState::FailedWithdraw => "FAILED_WITHDRAW",
            ByoipCidrState::PendingAdvertising => "PENDING_ADVERTISING",
            ByoipCidrState::PendingDeprovisioning => "PENDING_DEPROVISIONING",
            ByoipCidrState::PendingProvisioning => "PENDING_PROVISIONING",
            ByoipCidrState::PendingWithdrawing => "PENDING_WITHDRAWING",
            ByoipCidrState::Ready => "READY",
            ByoipCidrState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADVERTISING",
            "DEPROVISIONED",
            "FAILED_ADVERTISING",
            "FAILED_DEPROVISION",
            "FAILED_PROVISION",
            "FAILED_WITHDRAW",
            "PENDING_ADVERTISING",
            "PENDING_DEPROVISIONING",
            "PENDING_PROVISIONING",
            "PENDING_WITHDRAWING",
            "READY",
        ]
    }
}
impl AsRef<str> for ByoipCidrState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type for a listener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Listener {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The list of port ranges for the connections from clients to the accelerator.</p>
    pub port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    /// <p>The protocol for the connections from clients to the accelerator.</p>
    pub protocol: std::option::Option<crate::model::Protocol>,
    /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
    /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
    /// route each client to the same specific endpoint.</p>
    /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
    /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
    /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
    /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
    /// be always routed to the same endpoint because the hash value changes. </p>
    /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
    /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
    /// source (client) IP address and destination IP address—to select the hash value.</p>
    /// <p>The default value is <code>NONE</code>.</p>
    pub client_affinity: std::option::Option<crate::model::ClientAffinity>,
}
impl Listener {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
    /// <p>The list of port ranges for the connections from clients to the accelerator.</p>
    pub fn port_ranges(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.port_ranges.as_deref()
    }
    /// <p>The protocol for the connections from clients to the accelerator.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::Protocol> {
        self.protocol.as_ref()
    }
    /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
    /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
    /// route each client to the same specific endpoint.</p>
    /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
    /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
    /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
    /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
    /// be always routed to the same endpoint because the hash value changes. </p>
    /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
    /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
    /// source (client) IP address and destination IP address—to select the hash value.</p>
    /// <p>The default value is <code>NONE</code>.</p>
    pub fn client_affinity(&self) -> std::option::Option<&crate::model::ClientAffinity> {
        self.client_affinity.as_ref()
    }
}
impl std::fmt::Debug for Listener {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Listener");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("port_ranges", &self.port_ranges);
        formatter.field("protocol", &self.protocol);
        formatter.field("client_affinity", &self.client_affinity);
        formatter.finish()
    }
}
/// See [`Listener`](crate::model::Listener)
pub mod listener {
    /// A builder for [`Listener`](crate::model::Listener)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) client_affinity: std::option::Option<crate::model::ClientAffinity>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Appends an item to `port_ranges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The list of port ranges for the connections from clients to the accelerator.</p>
        pub fn port_ranges(mut self, input: impl Into<crate::model::PortRange>) -> Self {
            let mut v = self.port_ranges.unwrap_or_default();
            v.push(input.into());
            self.port_ranges = Some(v);
            self
        }
        /// <p>The list of port ranges for the connections from clients to the accelerator.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.port_ranges = input;
            self
        }
        /// <p>The protocol for the connections from clients to the accelerator.</p>
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol for the connections from clients to the accelerator.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
        /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
        /// route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
        /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
        /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
        /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
        /// be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
        /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
        /// source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn client_affinity(mut self, input: crate::model::ClientAffinity) -> Self {
            self.client_affinity = Some(input);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
        /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
        /// route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
        /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
        /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
        /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
        /// be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
        /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
        /// source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn set_client_affinity(
            mut self,
            input: std::option::Option<crate::model::ClientAffinity>,
        ) -> Self {
            self.client_affinity = input;
            self
        }
        /// Consumes the builder and constructs a [`Listener`](crate::model::Listener)
        pub fn build(self) -> crate::model::Listener {
            crate::model::Listener {
                listener_arn: self.listener_arn,
                port_ranges: self.port_ranges,
                protocol: self.protocol,
                client_affinity: self.client_affinity,
            }
        }
    }
}
impl Listener {
    /// Creates a new builder-style object to manufacture [`Listener`](crate::model::Listener)
    pub fn builder() -> crate::model::listener::Builder {
        crate::model::listener::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClientAffinity {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    SourceIp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClientAffinity {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => ClientAffinity::None,
            "SOURCE_IP" => ClientAffinity::SourceIp,
            other => ClientAffinity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClientAffinity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClientAffinity::from(s))
    }
}
impl ClientAffinity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClientAffinity::None => "NONE",
            ClientAffinity::SourceIp => "SOURCE_IP",
            ClientAffinity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "SOURCE_IP"]
    }
}
impl AsRef<str> for ClientAffinity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Protocol {
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    #[allow(missing_docs)] // documentation missing in model
    Udp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Protocol {
    fn from(s: &str) -> Self {
        match s {
            "TCP" => Protocol::Tcp,
            "UDP" => Protocol::Udp,
            other => Protocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Protocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Protocol::from(s))
    }
}
impl Protocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Protocol::Tcp => "TCP",
            Protocol::Udp => "UDP",
            Protocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TCP", "UDP"]
    }
}
impl AsRef<str> for Protocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type for a range of ports for a listener.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortRange {
    /// <p>The first port in the range of ports, inclusive.</p>
    pub from_port: std::option::Option<i32>,
    /// <p>The last port in the range of ports, inclusive.</p>
    pub to_port: std::option::Option<i32>,
}
impl PortRange {
    /// <p>The first port in the range of ports, inclusive.</p>
    pub fn from_port(&self) -> std::option::Option<i32> {
        self.from_port
    }
    /// <p>The last port in the range of ports, inclusive.</p>
    pub fn to_port(&self) -> std::option::Option<i32> {
        self.to_port
    }
}
impl std::fmt::Debug for PortRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortRange");
        formatter.field("from_port", &self.from_port);
        formatter.field("to_port", &self.to_port);
        formatter.finish()
    }
}
/// See [`PortRange`](crate::model::PortRange)
pub mod port_range {
    /// A builder for [`PortRange`](crate::model::PortRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) to_port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The first port in the range of ports, inclusive.</p>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>The first port in the range of ports, inclusive.</p>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>The last port in the range of ports, inclusive.</p>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>The last port in the range of ports, inclusive.</p>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// Consumes the builder and constructs a [`PortRange`](crate::model::PortRange)
        pub fn build(self) -> crate::model::PortRange {
            crate::model::PortRange {
                from_port: self.from_port,
                to_port: self.to_port,
            }
        }
    }
}
impl PortRange {
    /// Creates a new builder-style object to manufacture [`PortRange`](crate::model::PortRange)
    pub fn builder() -> crate::model::port_range::Builder {
        crate::model::port_range::Builder::default()
    }
}

/// <p>A complex type for the endpoint group. An AWS Region can have only one endpoint group for a specific listener.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointGroup {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
    /// <p>The AWS Region where the endpoint group is located.</p>
    pub endpoint_group_region: std::option::Option<std::string::String>,
    /// <p>The list of endpoint objects.</p>
    pub endpoint_descriptions:
        std::option::Option<std::vec::Vec<crate::model::EndpointDescription>>,
    /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
    /// this listener. </p>
    /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
    /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
    /// <p>The default value is 100.</p>
    pub traffic_dial_percentage: std::option::Option<f32>,
    /// <p>The port that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. </p>
    ///
    /// <p>The default port is the port for the listener that this endpoint group is associated with. If the listener port is a
    /// list, Global Accelerator uses the first specified port in the list of ports.</p>
    pub health_check_port: std::option::Option<i32>,
    /// <p>The protocol that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. The default
    /// value is TCP.</p>
    pub health_check_protocol: std::option::Option<crate::model::HealthCheckProtocol>,
    /// <p>If the protocol is HTTP/S, then this value provides the ping path that Global Accelerator uses for the destination on the
    /// endpoints for health checks. The default is slash (/).</p>
    pub health_check_path: std::option::Option<std::string::String>,
    /// <p>The time—10 seconds or 30 seconds—between health checks for each endpoint. The default value is 30.</p>
    pub health_check_interval_seconds: std::option::Option<i32>,
    /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
    /// unhealthy endpoint to healthy. The default value is 3.</p>
    pub threshold_count: std::option::Option<i32>,
    /// <p>Allows you to override the destination ports used to route traffic to an endpoint.
    /// Using a port override lets you to map a list of external destination ports (that your
    /// users send traffic to) to a list of internal destination ports that you want an application
    /// endpoint to receive traffic on. </p>
    pub port_overrides: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
}
impl EndpointGroup {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
    /// <p>The AWS Region where the endpoint group is located.</p>
    pub fn endpoint_group_region(&self) -> std::option::Option<&str> {
        self.endpoint_group_region.as_deref()
    }
    /// <p>The list of endpoint objects.</p>
    pub fn endpoint_descriptions(
        &self,
    ) -> std::option::Option<&[crate::model::EndpointDescription]> {
        self.endpoint_descriptions.as_deref()
    }
    /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
    /// this listener. </p>
    /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
    /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
    /// <p>The default value is 100.</p>
    pub fn traffic_dial_percentage(&self) -> std::option::Option<f32> {
        self.traffic_dial_percentage
    }
    /// <p>The port that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. </p>
    ///
    /// <p>The default port is the port for the listener that this endpoint group is associated with. If the listener port is a
    /// list, Global Accelerator uses the first specified port in the list of ports.</p>
    pub fn health_check_port(&self) -> std::option::Option<i32> {
        self.health_check_port
    }
    /// <p>The protocol that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. The default
    /// value is TCP.</p>
    pub fn health_check_protocol(&self) -> std::option::Option<&crate::model::HealthCheckProtocol> {
        self.health_check_protocol.as_ref()
    }
    /// <p>If the protocol is HTTP/S, then this value provides the ping path that Global Accelerator uses for the destination on the
    /// endpoints for health checks. The default is slash (/).</p>
    pub fn health_check_path(&self) -> std::option::Option<&str> {
        self.health_check_path.as_deref()
    }
    /// <p>The time—10 seconds or 30 seconds—between health checks for each endpoint. The default value is 30.</p>
    pub fn health_check_interval_seconds(&self) -> std::option::Option<i32> {
        self.health_check_interval_seconds
    }
    /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
    /// unhealthy endpoint to healthy. The default value is 3.</p>
    pub fn threshold_count(&self) -> std::option::Option<i32> {
        self.threshold_count
    }
    /// <p>Allows you to override the destination ports used to route traffic to an endpoint.
    /// Using a port override lets you to map a list of external destination ports (that your
    /// users send traffic to) to a list of internal destination ports that you want an application
    /// endpoint to receive traffic on. </p>
    pub fn port_overrides(&self) -> std::option::Option<&[crate::model::PortOverride]> {
        self.port_overrides.as_deref()
    }
}
impl std::fmt::Debug for EndpointGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointGroup");
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.field("endpoint_group_region", &self.endpoint_group_region);
        formatter.field("endpoint_descriptions", &self.endpoint_descriptions);
        formatter.field("traffic_dial_percentage", &self.traffic_dial_percentage);
        formatter.field("health_check_port", &self.health_check_port);
        formatter.field("health_check_protocol", &self.health_check_protocol);
        formatter.field("health_check_path", &self.health_check_path);
        formatter.field(
            "health_check_interval_seconds",
            &self.health_check_interval_seconds,
        );
        formatter.field("threshold_count", &self.threshold_count);
        formatter.field("port_overrides", &self.port_overrides);
        formatter.finish()
    }
}
/// See [`EndpointGroup`](crate::model::EndpointGroup)
pub mod endpoint_group {
    /// A builder for [`EndpointGroup`](crate::model::EndpointGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_group_region: std::option::Option<std::string::String>,
        pub(crate) endpoint_descriptions:
            std::option::Option<std::vec::Vec<crate::model::EndpointDescription>>,
        pub(crate) traffic_dial_percentage: std::option::Option<f32>,
        pub(crate) health_check_port: std::option::Option<i32>,
        pub(crate) health_check_protocol: std::option::Option<crate::model::HealthCheckProtocol>,
        pub(crate) health_check_path: std::option::Option<std::string::String>,
        pub(crate) health_check_interval_seconds: std::option::Option<i32>,
        pub(crate) threshold_count: std::option::Option<i32>,
        pub(crate) port_overrides: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// <p>The AWS Region where the endpoint group is located.</p>
        pub fn endpoint_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_region = Some(input.into());
            self
        }
        /// <p>The AWS Region where the endpoint group is located.</p>
        pub fn set_endpoint_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_region = input;
            self
        }
        /// Appends an item to `endpoint_descriptions`.
        ///
        /// To override the contents of this collection use [`set_endpoint_descriptions`](Self::set_endpoint_descriptions).
        ///
        /// <p>The list of endpoint objects.</p>
        pub fn endpoint_descriptions(
            mut self,
            input: impl Into<crate::model::EndpointDescription>,
        ) -> Self {
            let mut v = self.endpoint_descriptions.unwrap_or_default();
            v.push(input.into());
            self.endpoint_descriptions = Some(v);
            self
        }
        /// <p>The list of endpoint objects.</p>
        pub fn set_endpoint_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointDescription>>,
        ) -> Self {
            self.endpoint_descriptions = input;
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
        /// this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
        /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn traffic_dial_percentage(mut self, input: f32) -> Self {
            self.traffic_dial_percentage = Some(input);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
        /// this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
        /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn set_traffic_dial_percentage(mut self, input: std::option::Option<f32>) -> Self {
            self.traffic_dial_percentage = input;
            self
        }
        /// <p>The port that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. </p>
        ///
        /// <p>The default port is the port for the listener that this endpoint group is associated with. If the listener port is a
        /// list, Global Accelerator uses the first specified port in the list of ports.</p>
        pub fn health_check_port(mut self, input: i32) -> Self {
            self.health_check_port = Some(input);
            self
        }
        /// <p>The port that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. </p>
        ///
        /// <p>The default port is the port for the listener that this endpoint group is associated with. If the listener port is a
        /// list, Global Accelerator uses the first specified port in the list of ports.</p>
        pub fn set_health_check_port(mut self, input: std::option::Option<i32>) -> Self {
            self.health_check_port = input;
            self
        }
        /// <p>The protocol that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. The default
        /// value is TCP.</p>
        pub fn health_check_protocol(mut self, input: crate::model::HealthCheckProtocol) -> Self {
            self.health_check_protocol = Some(input);
            self
        }
        /// <p>The protocol that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. The default
        /// value is TCP.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::HealthCheckProtocol>,
        ) -> Self {
            self.health_check_protocol = input;
            self
        }
        /// <p>If the protocol is HTTP/S, then this value provides the ping path that Global Accelerator uses for the destination on the
        /// endpoints for health checks. The default is slash (/).</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_path = Some(input.into());
            self
        }
        /// <p>If the protocol is HTTP/S, then this value provides the ping path that Global Accelerator uses for the destination on the
        /// endpoints for health checks. The default is slash (/).</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_path = input;
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between health checks for each endpoint. The default value is 30.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.health_check_interval_seconds = Some(input);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between health checks for each endpoint. The default value is 30.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.health_check_interval_seconds = input;
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
        /// unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn threshold_count(mut self, input: i32) -> Self {
            self.threshold_count = Some(input);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
        /// unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn set_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.threshold_count = input;
            self
        }
        /// Appends an item to `port_overrides`.
        ///
        /// To override the contents of this collection use [`set_port_overrides`](Self::set_port_overrides).
        ///
        /// <p>Allows you to override the destination ports used to route traffic to an endpoint.
        /// Using a port override lets you to map a list of external destination ports (that your
        /// users send traffic to) to a list of internal destination ports that you want an application
        /// endpoint to receive traffic on. </p>
        pub fn port_overrides(mut self, input: impl Into<crate::model::PortOverride>) -> Self {
            let mut v = self.port_overrides.unwrap_or_default();
            v.push(input.into());
            self.port_overrides = Some(v);
            self
        }
        /// <p>Allows you to override the destination ports used to route traffic to an endpoint.
        /// Using a port override lets you to map a list of external destination ports (that your
        /// users send traffic to) to a list of internal destination ports that you want an application
        /// endpoint to receive traffic on. </p>
        pub fn set_port_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
        ) -> Self {
            self.port_overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointGroup`](crate::model::EndpointGroup)
        pub fn build(self) -> crate::model::EndpointGroup {
            crate::model::EndpointGroup {
                endpoint_group_arn: self.endpoint_group_arn,
                endpoint_group_region: self.endpoint_group_region,
                endpoint_descriptions: self.endpoint_descriptions,
                traffic_dial_percentage: self.traffic_dial_percentage,
                health_check_port: self.health_check_port,
                health_check_protocol: self.health_check_protocol,
                health_check_path: self.health_check_path,
                health_check_interval_seconds: self.health_check_interval_seconds,
                threshold_count: self.threshold_count,
                port_overrides: self.port_overrides,
            }
        }
    }
}
impl EndpointGroup {
    /// Creates a new builder-style object to manufacture [`EndpointGroup`](crate::model::EndpointGroup)
    pub fn builder() -> crate::model::endpoint_group::Builder {
        crate::model::endpoint_group::Builder::default()
    }
}

/// <p>Override specific listener ports used to route traffic to endpoints that are part of an endpoint group.
/// For example, you can create a port override in which the listener
/// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
/// and 1443, respectively, on the endpoints.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
/// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortOverride {
    /// <p>The listener port that you want to map to a specific endpoint port. This is the port that user traffic
    /// arrives to the Global Accelerator on.</p>
    pub listener_port: std::option::Option<i32>,
    /// <p>The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint,
    /// such as the Application Load Balancer or Amazon EC2 instance.</p>
    pub endpoint_port: std::option::Option<i32>,
}
impl PortOverride {
    /// <p>The listener port that you want to map to a specific endpoint port. This is the port that user traffic
    /// arrives to the Global Accelerator on.</p>
    pub fn listener_port(&self) -> std::option::Option<i32> {
        self.listener_port
    }
    /// <p>The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint,
    /// such as the Application Load Balancer or Amazon EC2 instance.</p>
    pub fn endpoint_port(&self) -> std::option::Option<i32> {
        self.endpoint_port
    }
}
impl std::fmt::Debug for PortOverride {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortOverride");
        formatter.field("listener_port", &self.listener_port);
        formatter.field("endpoint_port", &self.endpoint_port);
        formatter.finish()
    }
}
/// See [`PortOverride`](crate::model::PortOverride)
pub mod port_override {
    /// A builder for [`PortOverride`](crate::model::PortOverride)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_port: std::option::Option<i32>,
        pub(crate) endpoint_port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The listener port that you want to map to a specific endpoint port. This is the port that user traffic
        /// arrives to the Global Accelerator on.</p>
        pub fn listener_port(mut self, input: i32) -> Self {
            self.listener_port = Some(input);
            self
        }
        /// <p>The listener port that you want to map to a specific endpoint port. This is the port that user traffic
        /// arrives to the Global Accelerator on.</p>
        pub fn set_listener_port(mut self, input: std::option::Option<i32>) -> Self {
            self.listener_port = input;
            self
        }
        /// <p>The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint,
        /// such as the Application Load Balancer or Amazon EC2 instance.</p>
        pub fn endpoint_port(mut self, input: i32) -> Self {
            self.endpoint_port = Some(input);
            self
        }
        /// <p>The endpoint port that you want a listener port to be mapped to. This is the port on the endpoint,
        /// such as the Application Load Balancer or Amazon EC2 instance.</p>
        pub fn set_endpoint_port(mut self, input: std::option::Option<i32>) -> Self {
            self.endpoint_port = input;
            self
        }
        /// Consumes the builder and constructs a [`PortOverride`](crate::model::PortOverride)
        pub fn build(self) -> crate::model::PortOverride {
            crate::model::PortOverride {
                listener_port: self.listener_port,
                endpoint_port: self.endpoint_port,
            }
        }
    }
}
impl PortOverride {
    /// Creates a new builder-style object to manufacture [`PortOverride`](crate::model::PortOverride)
    pub fn builder() -> crate::model::port_override::Builder {
        crate::model::port_override::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HealthCheckProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Https,
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HealthCheckProtocol {
    fn from(s: &str) -> Self {
        match s {
            "HTTP" => HealthCheckProtocol::Http,
            "HTTPS" => HealthCheckProtocol::Https,
            "TCP" => HealthCheckProtocol::Tcp,
            other => HealthCheckProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HealthCheckProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HealthCheckProtocol::from(s))
    }
}
impl HealthCheckProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HealthCheckProtocol::Http => "HTTP",
            HealthCheckProtocol::Https => "HTTPS",
            HealthCheckProtocol::Tcp => "TCP",
            HealthCheckProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP", "HTTPS", "TCP"]
    }
}
impl AsRef<str> for HealthCheckProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type for an endpoint. Each endpoint group can include one or more endpoints, such as load
/// balancers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointDescription {
    /// <p>An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
    /// Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
    /// allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. </p>
    /// <p>An Application Load Balancer can be either internal or internet-facing.</p>
    pub endpoint_id: std::option::Option<std::string::String>,
    /// <p>The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
    /// based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
    /// result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
    /// and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights</a> in the
    /// <i>AWS Global Accelerator Developer Guide</i>. </p>
    pub weight: std::option::Option<i32>,
    /// <p>The health status of the endpoint.</p>
    pub health_state: std::option::Option<crate::model::HealthState>,
    /// <p>Returns a null result.</p>
    pub health_reason: std::option::Option<std::string::String>,
    /// <p>Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
    /// The value is true or false. The default value is true for new accelerators. </p>
    /// <p>If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request header as
    /// traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-how-it-works-client-ip.html">
    /// Viewing Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub client_ip_preservation_enabled: std::option::Option<bool>,
}
impl EndpointDescription {
    /// <p>An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
    /// Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
    /// allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. </p>
    /// <p>An Application Load Balancer can be either internal or internet-facing.</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
    /// <p>The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
    /// based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
    /// result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
    /// and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights</a> in the
    /// <i>AWS Global Accelerator Developer Guide</i>. </p>
    pub fn weight(&self) -> std::option::Option<i32> {
        self.weight
    }
    /// <p>The health status of the endpoint.</p>
    pub fn health_state(&self) -> std::option::Option<&crate::model::HealthState> {
        self.health_state.as_ref()
    }
    /// <p>Returns a null result.</p>
    pub fn health_reason(&self) -> std::option::Option<&str> {
        self.health_reason.as_deref()
    }
    /// <p>Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
    /// The value is true or false. The default value is true for new accelerators. </p>
    /// <p>If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request header as
    /// traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-how-it-works-client-ip.html">
    /// Viewing Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn client_ip_preservation_enabled(&self) -> std::option::Option<bool> {
        self.client_ip_preservation_enabled
    }
}
impl std::fmt::Debug for EndpointDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointDescription");
        formatter.field("endpoint_id", &self.endpoint_id);
        formatter.field("weight", &self.weight);
        formatter.field("health_state", &self.health_state);
        formatter.field("health_reason", &self.health_reason);
        formatter.field(
            "client_ip_preservation_enabled",
            &self.client_ip_preservation_enabled,
        );
        formatter.finish()
    }
}
/// See [`EndpointDescription`](crate::model::EndpointDescription)
pub mod endpoint_description {
    /// A builder for [`EndpointDescription`](crate::model::EndpointDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) weight: std::option::Option<i32>,
        pub(crate) health_state: std::option::Option<crate::model::HealthState>,
        pub(crate) health_reason: std::option::Option<std::string::String>,
        pub(crate) client_ip_preservation_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
        /// Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
        /// allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. </p>
        /// <p>An Application Load Balancer can be either internal or internet-facing.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
        /// Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
        /// allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. </p>
        /// <p>An Application Load Balancer can be either internal or internet-facing.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// <p>The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
        /// based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
        /// result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
        /// and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights</a> in the
        /// <i>AWS Global Accelerator Developer Guide</i>. </p>
        pub fn weight(mut self, input: i32) -> Self {
            self.weight = Some(input);
            self
        }
        /// <p>The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
        /// based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
        /// result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
        /// and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights</a> in the
        /// <i>AWS Global Accelerator Developer Guide</i>. </p>
        pub fn set_weight(mut self, input: std::option::Option<i32>) -> Self {
            self.weight = input;
            self
        }
        /// <p>The health status of the endpoint.</p>
        pub fn health_state(mut self, input: crate::model::HealthState) -> Self {
            self.health_state = Some(input);
            self
        }
        /// <p>The health status of the endpoint.</p>
        pub fn set_health_state(
            mut self,
            input: std::option::Option<crate::model::HealthState>,
        ) -> Self {
            self.health_state = input;
            self
        }
        /// <p>Returns a null result.</p>
        pub fn health_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_reason = Some(input.into());
            self
        }
        /// <p>Returns a null result.</p>
        pub fn set_health_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_reason = input;
            self
        }
        /// <p>Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
        /// The value is true or false. The default value is true for new accelerators. </p>
        /// <p>If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request header as
        /// traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-how-it-works-client-ip.html">
        /// Viewing Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn client_ip_preservation_enabled(mut self, input: bool) -> Self {
            self.client_ip_preservation_enabled = Some(input);
            self
        }
        /// <p>Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
        /// The value is true or false. The default value is true for new accelerators. </p>
        /// <p>If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request header as
        /// traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-how-it-works-client-ip.html">
        /// Viewing Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_client_ip_preservation_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.client_ip_preservation_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointDescription`](crate::model::EndpointDescription)
        pub fn build(self) -> crate::model::EndpointDescription {
            crate::model::EndpointDescription {
                endpoint_id: self.endpoint_id,
                weight: self.weight,
                health_state: self.health_state,
                health_reason: self.health_reason,
                client_ip_preservation_enabled: self.client_ip_preservation_enabled,
            }
        }
    }
}
impl EndpointDescription {
    /// Creates a new builder-style object to manufacture [`EndpointDescription`](crate::model::EndpointDescription)
    pub fn builder() -> crate::model::endpoint_description::Builder {
        crate::model::endpoint_description::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HealthState {
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Initial,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HealthState {
    fn from(s: &str) -> Self {
        match s {
            "HEALTHY" => HealthState::Healthy,
            "INITIAL" => HealthState::Initial,
            "UNHEALTHY" => HealthState::Unhealthy,
            other => HealthState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HealthState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HealthState::from(s))
    }
}
impl HealthState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HealthState::Healthy => "HEALTHY",
            HealthState::Initial => "INITIAL",
            HealthState::Unhealthy => "UNHEALTHY",
            HealthState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEALTHY", "INITIAL", "UNHEALTHY"]
    }
}
impl AsRef<str> for HealthState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type for endpoints. A resource must be valid and active when you add it as an endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointConfiguration {
    /// <p>An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
    /// Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
    /// allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. A resource must be valid and active
    /// when you add it as an endpoint.</p>
    /// <p>An Application Load Balancer can be either internal or internet-facing.</p>
    pub endpoint_id: std::option::Option<std::string::String>,
    /// <p>The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
    /// based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
    /// result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
    /// and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights</a> in the
    /// <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub weight: std::option::Option<i32>,
    /// <p>Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
    /// The value is true or false. The default value is true for new accelerators. </p>
    /// <p>If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request header as
    /// traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html">
    /// Preserve Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub client_ip_preservation_enabled: std::option::Option<bool>,
}
impl EndpointConfiguration {
    /// <p>An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
    /// Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
    /// allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. A resource must be valid and active
    /// when you add it as an endpoint.</p>
    /// <p>An Application Load Balancer can be either internal or internet-facing.</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
    /// <p>The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
    /// based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
    /// result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
    /// and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights</a> in the
    /// <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn weight(&self) -> std::option::Option<i32> {
        self.weight
    }
    /// <p>Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
    /// The value is true or false. The default value is true for new accelerators. </p>
    /// <p>If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request header as
    /// traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html">
    /// Preserve Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn client_ip_preservation_enabled(&self) -> std::option::Option<bool> {
        self.client_ip_preservation_enabled
    }
}
impl std::fmt::Debug for EndpointConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointConfiguration");
        formatter.field("endpoint_id", &self.endpoint_id);
        formatter.field("weight", &self.weight);
        formatter.field(
            "client_ip_preservation_enabled",
            &self.client_ip_preservation_enabled,
        );
        formatter.finish()
    }
}
/// See [`EndpointConfiguration`](crate::model::EndpointConfiguration)
pub mod endpoint_configuration {
    /// A builder for [`EndpointConfiguration`](crate::model::EndpointConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) weight: std::option::Option<i32>,
        pub(crate) client_ip_preservation_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
        /// Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
        /// allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. A resource must be valid and active
        /// when you add it as an endpoint.</p>
        /// <p>An Application Load Balancer can be either internal or internet-facing.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
        /// Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
        /// allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. A resource must be valid and active
        /// when you add it as an endpoint.</p>
        /// <p>An Application Load Balancer can be either internal or internet-facing.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// <p>The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
        /// based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
        /// result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
        /// and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights</a> in the
        /// <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn weight(mut self, input: i32) -> Self {
            self.weight = Some(input);
            self
        }
        /// <p>The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
        /// based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
        /// result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
        /// and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights</a> in the
        /// <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_weight(mut self, input: std::option::Option<i32>) -> Self {
            self.weight = input;
            self
        }
        /// <p>Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
        /// The value is true or false. The default value is true for new accelerators. </p>
        /// <p>If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request header as
        /// traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html">
        /// Preserve Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn client_ip_preservation_enabled(mut self, input: bool) -> Self {
            self.client_ip_preservation_enabled = Some(input);
            self
        }
        /// <p>Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
        /// The value is true or false. The default value is true for new accelerators. </p>
        /// <p>If the value is set to true, the client's IP address is preserved in the <code>X-Forwarded-For</code> request header as
        /// traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html">
        /// Preserve Client IP Addresses in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_client_ip_preservation_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.client_ip_preservation_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointConfiguration`](crate::model::EndpointConfiguration)
        pub fn build(self) -> crate::model::EndpointConfiguration {
            crate::model::EndpointConfiguration {
                endpoint_id: self.endpoint_id,
                weight: self.weight,
                client_ip_preservation_enabled: self.client_ip_preservation_enabled,
            }
        }
    }
}
impl EndpointConfiguration {
    /// Creates a new builder-style object to manufacture [`EndpointConfiguration`](crate::model::EndpointConfiguration)
    pub fn builder() -> crate::model::endpoint_configuration::Builder {
        crate::model::endpoint_configuration::Builder::default()
    }
}

/// <p>A complex type for a listener for a custom routing accelerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomRoutingListener {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The port range to support for connections from clients to your accelerator.</p>
    /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
    /// endpoints for custom routing accelerators</a>.</p>
    pub port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
}
impl CustomRoutingListener {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
    /// <p>The port range to support for connections from clients to your accelerator.</p>
    /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
    /// endpoints for custom routing accelerators</a>.</p>
    pub fn port_ranges(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.port_ranges.as_deref()
    }
}
impl std::fmt::Debug for CustomRoutingListener {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomRoutingListener");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("port_ranges", &self.port_ranges);
        formatter.finish()
    }
}
/// See [`CustomRoutingListener`](crate::model::CustomRoutingListener)
pub mod custom_routing_listener {
    /// A builder for [`CustomRoutingListener`](crate::model::CustomRoutingListener)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Appends an item to `port_ranges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The port range to support for connections from clients to your accelerator.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
        /// endpoints for custom routing accelerators</a>.</p>
        pub fn port_ranges(mut self, input: impl Into<crate::model::PortRange>) -> Self {
            let mut v = self.port_ranges.unwrap_or_default();
            v.push(input.into());
            self.port_ranges = Some(v);
            self
        }
        /// <p>The port range to support for connections from clients to your accelerator.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
        /// endpoints for custom routing accelerators</a>.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.port_ranges = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomRoutingListener`](crate::model::CustomRoutingListener)
        pub fn build(self) -> crate::model::CustomRoutingListener {
            crate::model::CustomRoutingListener {
                listener_arn: self.listener_arn,
                port_ranges: self.port_ranges,
            }
        }
    }
}
impl CustomRoutingListener {
    /// Creates a new builder-style object to manufacture [`CustomRoutingListener`](crate::model::CustomRoutingListener)
    pub fn builder() -> crate::model::custom_routing_listener::Builder {
        crate::model::custom_routing_listener::Builder::default()
    }
}

/// <p>Attributes of a custom routing accelerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomRoutingAcceleratorAttributes {
    /// <p>Indicates whether flow logs are enabled. The default value is false. If the value is true,
    /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
    /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub flow_logs_enabled: std::option::Option<bool>,
    /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
    /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
    /// bucket.</p>
    pub flow_logs_s3_bucket: std::option::Option<std::string::String>,
    /// <p>The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
    /// <code>FlowLogsEnabled</code> is <code>true</code>.</p>
    /// <p>If you don’t specify a prefix, the flow logs are stored in the
    /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
    /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
    pub flow_logs_s3_prefix: std::option::Option<std::string::String>,
}
impl CustomRoutingAcceleratorAttributes {
    /// <p>Indicates whether flow logs are enabled. The default value is false. If the value is true,
    /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
    /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn flow_logs_enabled(&self) -> std::option::Option<bool> {
        self.flow_logs_enabled
    }
    /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
    /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
    /// bucket.</p>
    pub fn flow_logs_s3_bucket(&self) -> std::option::Option<&str> {
        self.flow_logs_s3_bucket.as_deref()
    }
    /// <p>The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
    /// <code>FlowLogsEnabled</code> is <code>true</code>.</p>
    /// <p>If you don’t specify a prefix, the flow logs are stored in the
    /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
    /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
    pub fn flow_logs_s3_prefix(&self) -> std::option::Option<&str> {
        self.flow_logs_s3_prefix.as_deref()
    }
}
impl std::fmt::Debug for CustomRoutingAcceleratorAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomRoutingAcceleratorAttributes");
        formatter.field("flow_logs_enabled", &self.flow_logs_enabled);
        formatter.field("flow_logs_s3_bucket", &self.flow_logs_s3_bucket);
        formatter.field("flow_logs_s3_prefix", &self.flow_logs_s3_prefix);
        formatter.finish()
    }
}
/// See [`CustomRoutingAcceleratorAttributes`](crate::model::CustomRoutingAcceleratorAttributes)
pub mod custom_routing_accelerator_attributes {
    /// A builder for [`CustomRoutingAcceleratorAttributes`](crate::model::CustomRoutingAcceleratorAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_logs_enabled: std::option::Option<bool>,
        pub(crate) flow_logs_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) flow_logs_s3_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn flow_logs_enabled(mut self, input: bool) -> Self {
            self.flow_logs_enabled = Some(input);
            self
        }
        /// <p>Indicates whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_flow_logs_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.flow_logs_enabled = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn flow_logs_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_logs_s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn set_flow_logs_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_logs_s3_bucket = input;
            self
        }
        /// <p>The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>.</p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
        pub fn flow_logs_s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_logs_s3_prefix = Some(input.into());
            self
        }
        /// <p>The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>.</p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
        pub fn set_flow_logs_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_logs_s3_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomRoutingAcceleratorAttributes`](crate::model::CustomRoutingAcceleratorAttributes)
        pub fn build(self) -> crate::model::CustomRoutingAcceleratorAttributes {
            crate::model::CustomRoutingAcceleratorAttributes {
                flow_logs_enabled: self.flow_logs_enabled,
                flow_logs_s3_bucket: self.flow_logs_s3_bucket,
                flow_logs_s3_prefix: self.flow_logs_s3_prefix,
            }
        }
    }
}
impl CustomRoutingAcceleratorAttributes {
    /// Creates a new builder-style object to manufacture [`CustomRoutingAcceleratorAttributes`](crate::model::CustomRoutingAcceleratorAttributes)
    pub fn builder() -> crate::model::custom_routing_accelerator_attributes::Builder {
        crate::model::custom_routing_accelerator_attributes::Builder::default()
    }
}

/// <p>Attributes of a custom routing accelerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomRoutingAccelerator {
    /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>The name of the accelerator. The name must contain only alphanumeric characters or
    /// hyphens (-), and must not begin or end with a hyphen.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value for the address type must be IPv4.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
    /// <p>Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The static IP addresses that Global Accelerator associates with the accelerator.</p>
    pub ip_sets: std::option::Option<std::vec::Vec<crate::model::IpSet>>,
    /// <p>The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses. </p>
    /// <p>The naming convention for the DNS name is the following: A lowercase letter a,
    /// followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example:
    /// a1234567890abcdef.awsglobalaccelerator.com.</p>
    /// <p>For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing">
    /// Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>Describes the deployment status of the accelerator.</p>
    pub status: std::option::Option<crate::model::CustomRoutingAcceleratorStatus>,
    /// <p>The date and time that the accelerator was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the accelerator was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl CustomRoutingAccelerator {
    /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>The name of the accelerator. The name must contain only alphanumeric characters or
    /// hyphens (-), and must not begin or end with a hyphen.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value for the address type must be IPv4.</p>
    pub fn ip_address_type(&self) -> std::option::Option<&crate::model::IpAddressType> {
        self.ip_address_type.as_ref()
    }
    /// <p>Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The static IP addresses that Global Accelerator associates with the accelerator.</p>
    pub fn ip_sets(&self) -> std::option::Option<&[crate::model::IpSet]> {
        self.ip_sets.as_deref()
    }
    /// <p>The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses. </p>
    /// <p>The naming convention for the DNS name is the following: A lowercase letter a,
    /// followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example:
    /// a1234567890abcdef.awsglobalaccelerator.com.</p>
    /// <p>For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing">
    /// Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>Describes the deployment status of the accelerator.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CustomRoutingAcceleratorStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time that the accelerator was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The date and time that the accelerator was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
}
impl std::fmt::Debug for CustomRoutingAccelerator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomRoutingAccelerator");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("name", &self.name);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.field("enabled", &self.enabled);
        formatter.field("ip_sets", &self.ip_sets);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`CustomRoutingAccelerator`](crate::model::CustomRoutingAccelerator)
pub mod custom_routing_accelerator {
    /// A builder for [`CustomRoutingAccelerator`](crate::model::CustomRoutingAccelerator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) ip_sets: std::option::Option<std::vec::Vec<crate::model::IpSet>>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CustomRoutingAcceleratorStatus>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// <p>The name of the accelerator. The name must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the accelerator. The name must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// <p>Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `ip_sets`.
        ///
        /// To override the contents of this collection use [`set_ip_sets`](Self::set_ip_sets).
        ///
        /// <p>The static IP addresses that Global Accelerator associates with the accelerator.</p>
        pub fn ip_sets(mut self, input: impl Into<crate::model::IpSet>) -> Self {
            let mut v = self.ip_sets.unwrap_or_default();
            v.push(input.into());
            self.ip_sets = Some(v);
            self
        }
        /// <p>The static IP addresses that Global Accelerator associates with the accelerator.</p>
        pub fn set_ip_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpSet>>,
        ) -> Self {
            self.ip_sets = input;
            self
        }
        /// <p>The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses. </p>
        /// <p>The naming convention for the DNS name is the following: A lowercase letter a,
        /// followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example:
        /// a1234567890abcdef.awsglobalaccelerator.com.</p>
        /// <p>For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing">
        /// Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses. </p>
        /// <p>The naming convention for the DNS name is the following: A lowercase letter a,
        /// followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example:
        /// a1234567890abcdef.awsglobalaccelerator.com.</p>
        /// <p>For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing">
        /// Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>Describes the deployment status of the accelerator.</p>
        pub fn status(mut self, input: crate::model::CustomRoutingAcceleratorStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Describes the deployment status of the accelerator.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CustomRoutingAcceleratorStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the accelerator was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that the accelerator was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time that the accelerator was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time that the accelerator was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomRoutingAccelerator`](crate::model::CustomRoutingAccelerator)
        pub fn build(self) -> crate::model::CustomRoutingAccelerator {
            crate::model::CustomRoutingAccelerator {
                accelerator_arn: self.accelerator_arn,
                name: self.name,
                ip_address_type: self.ip_address_type,
                enabled: self.enabled,
                ip_sets: self.ip_sets,
                dns_name: self.dns_name,
                status: self.status,
                created_time: self.created_time,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl CustomRoutingAccelerator {
    /// Creates a new builder-style object to manufacture [`CustomRoutingAccelerator`](crate::model::CustomRoutingAccelerator)
    pub fn builder() -> crate::model::custom_routing_accelerator::Builder {
        crate::model::custom_routing_accelerator::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomRoutingAcceleratorStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deployed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomRoutingAcceleratorStatus {
    fn from(s: &str) -> Self {
        match s {
            "DEPLOYED" => CustomRoutingAcceleratorStatus::Deployed,
            "IN_PROGRESS" => CustomRoutingAcceleratorStatus::InProgress,
            other => CustomRoutingAcceleratorStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomRoutingAcceleratorStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomRoutingAcceleratorStatus::from(s))
    }
}
impl CustomRoutingAcceleratorStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomRoutingAcceleratorStatus::Deployed => "DEPLOYED",
            CustomRoutingAcceleratorStatus::InProgress => "IN_PROGRESS",
            CustomRoutingAcceleratorStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPLOYED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for CustomRoutingAcceleratorStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type for the set of IP addresses for an accelerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpSet {
    /// <p>The types of IP addresses included in this IP set.</p>
    pub ip_family: std::option::Option<std::string::String>,
    /// <p>The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP addresses.</p>
    pub ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl IpSet {
    /// <p>The types of IP addresses included in this IP set.</p>
    pub fn ip_family(&self) -> std::option::Option<&str> {
        self.ip_family.as_deref()
    }
    /// <p>The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP addresses.</p>
    pub fn ip_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.ip_addresses.as_deref()
    }
}
impl std::fmt::Debug for IpSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpSet");
        formatter.field("ip_family", &self.ip_family);
        formatter.field("ip_addresses", &self.ip_addresses);
        formatter.finish()
    }
}
/// See [`IpSet`](crate::model::IpSet)
pub mod ip_set {
    /// A builder for [`IpSet`](crate::model::IpSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_family: std::option::Option<std::string::String>,
        pub(crate) ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The types of IP addresses included in this IP set.</p>
        pub fn ip_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_family = Some(input.into());
            self
        }
        /// <p>The types of IP addresses included in this IP set.</p>
        pub fn set_ip_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_family = input;
            self
        }
        /// Appends an item to `ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP addresses.</p>
        pub fn ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.ip_addresses = Some(v);
            self
        }
        /// <p>The array of IP addresses in the IP address set. An IP address set can have a maximum of two IP addresses.</p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`IpSet`](crate::model::IpSet)
        pub fn build(self) -> crate::model::IpSet {
            crate::model::IpSet {
                ip_family: self.ip_family,
                ip_addresses: self.ip_addresses,
            }
        }
    }
}
impl IpSet {
    /// Creates a new builder-style object to manufacture [`IpSet`](crate::model::IpSet)
    pub fn builder() -> crate::model::ip_set::Builder {
        crate::model::ip_set::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IpAddressType {
    #[allow(missing_docs)] // documentation missing in model
    Ipv4,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IpAddressType {
    fn from(s: &str) -> Self {
        match s {
            "IPV4" => IpAddressType::Ipv4,
            other => IpAddressType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IpAddressType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IpAddressType::from(s))
    }
}
impl IpAddressType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IpAddressType::Ipv4 => "IPV4",
            IpAddressType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IPV4"]
    }
}
impl AsRef<str> for IpAddressType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Attributes of an accelerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceleratorAttributes {
    /// <p>Indicates whether flow logs are enabled. The default value is false. If the value is true,
    /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
    /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub flow_logs_enabled: std::option::Option<bool>,
    /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
    /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
    /// bucket.</p>
    pub flow_logs_s3_bucket: std::option::Option<std::string::String>,
    /// <p>The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
    /// <code>FlowLogsEnabled</code> is <code>true</code>.</p>
    /// <p>If you don’t specify a prefix, the flow logs are stored in the
    /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
    /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
    pub flow_logs_s3_prefix: std::option::Option<std::string::String>,
}
impl AcceleratorAttributes {
    /// <p>Indicates whether flow logs are enabled. The default value is false. If the value is true,
    /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
    /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn flow_logs_enabled(&self) -> std::option::Option<bool> {
        self.flow_logs_enabled
    }
    /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
    /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
    /// bucket.</p>
    pub fn flow_logs_s3_bucket(&self) -> std::option::Option<&str> {
        self.flow_logs_s3_bucket.as_deref()
    }
    /// <p>The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
    /// <code>FlowLogsEnabled</code> is <code>true</code>.</p>
    /// <p>If you don’t specify a prefix, the flow logs are stored in the
    /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
    /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
    pub fn flow_logs_s3_prefix(&self) -> std::option::Option<&str> {
        self.flow_logs_s3_prefix.as_deref()
    }
}
impl std::fmt::Debug for AcceleratorAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceleratorAttributes");
        formatter.field("flow_logs_enabled", &self.flow_logs_enabled);
        formatter.field("flow_logs_s3_bucket", &self.flow_logs_s3_bucket);
        formatter.field("flow_logs_s3_prefix", &self.flow_logs_s3_prefix);
        formatter.finish()
    }
}
/// See [`AcceleratorAttributes`](crate::model::AcceleratorAttributes)
pub mod accelerator_attributes {
    /// A builder for [`AcceleratorAttributes`](crate::model::AcceleratorAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_logs_enabled: std::option::Option<bool>,
        pub(crate) flow_logs_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) flow_logs_s3_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn flow_logs_enabled(mut self, input: bool) -> Self {
            self.flow_logs_enabled = Some(input);
            self
        }
        /// <p>Indicates whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_flow_logs_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.flow_logs_enabled = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn flow_logs_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_logs_s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn set_flow_logs_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_logs_s3_bucket = input;
            self
        }
        /// <p>The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>.</p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
        pub fn flow_logs_s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_logs_s3_prefix = Some(input.into());
            self
        }
        /// <p>The prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>.</p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
        pub fn set_flow_logs_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_logs_s3_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceleratorAttributes`](crate::model::AcceleratorAttributes)
        pub fn build(self) -> crate::model::AcceleratorAttributes {
            crate::model::AcceleratorAttributes {
                flow_logs_enabled: self.flow_logs_enabled,
                flow_logs_s3_bucket: self.flow_logs_s3_bucket,
                flow_logs_s3_prefix: self.flow_logs_s3_prefix,
            }
        }
    }
}
impl AcceleratorAttributes {
    /// Creates a new builder-style object to manufacture [`AcceleratorAttributes`](crate::model::AcceleratorAttributes)
    pub fn builder() -> crate::model::accelerator_attributes::Builder {
        crate::model::accelerator_attributes::Builder::default()
    }
}

/// <p>An accelerator is a complex type that includes one or more listeners that process inbound connections and then direct
/// traffic to one or more endpoint groups, each of which includes endpoints, such as load balancers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Accelerator {
    /// <p>The Amazon Resource Name (ARN) of the accelerator.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>The name of the accelerator. The name must contain only alphanumeric characters or
    /// hyphens (-), and must not begin or end with a hyphen.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value for the address type must be IPv4.
    /// </p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
    /// <p>Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The static IP addresses that Global Accelerator associates with the accelerator.</p>
    pub ip_sets: std::option::Option<std::vec::Vec<crate::model::IpSet>>,
    /// <p>The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses. </p>
    /// <p>The naming convention for the DNS name is the following: A lowercase letter a,
    /// followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example:
    /// a1234567890abcdef.awsglobalaccelerator.com.</p>
    /// <p>For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing">
    /// Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>Describes the deployment status of the accelerator.</p>
    pub status: std::option::Option<crate::model::AcceleratorStatus>,
    /// <p>The date and time that the accelerator was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the accelerator was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Accelerator {
    /// <p>The Amazon Resource Name (ARN) of the accelerator.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>The name of the accelerator. The name must contain only alphanumeric characters or
    /// hyphens (-), and must not begin or end with a hyphen.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value for the address type must be IPv4.
    /// </p>
    pub fn ip_address_type(&self) -> std::option::Option<&crate::model::IpAddressType> {
        self.ip_address_type.as_ref()
    }
    /// <p>Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The static IP addresses that Global Accelerator associates with the accelerator.</p>
    pub fn ip_sets(&self) -> std::option::Option<&[crate::model::IpSet]> {
        self.ip_sets.as_deref()
    }
    /// <p>The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses. </p>
    /// <p>The naming convention for the DNS name is the following: A lowercase letter a,
    /// followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example:
    /// a1234567890abcdef.awsglobalaccelerator.com.</p>
    /// <p>For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing">
    /// Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>Describes the deployment status of the accelerator.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AcceleratorStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time that the accelerator was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The date and time that the accelerator was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified_time.as_ref()
    }
}
impl std::fmt::Debug for Accelerator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Accelerator");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("name", &self.name);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.field("enabled", &self.enabled);
        formatter.field("ip_sets", &self.ip_sets);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`Accelerator`](crate::model::Accelerator)
pub mod accelerator {
    /// A builder for [`Accelerator`](crate::model::Accelerator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) ip_sets: std::option::Option<std::vec::Vec<crate::model::IpSet>>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AcceleratorStatus>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// <p>The name of the accelerator. The name must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the accelerator. The name must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value for the address type must be IPv4.
        /// </p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The value for the address type must be IPv4.
        /// </p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// <p>Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether the accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `ip_sets`.
        ///
        /// To override the contents of this collection use [`set_ip_sets`](Self::set_ip_sets).
        ///
        /// <p>The static IP addresses that Global Accelerator associates with the accelerator.</p>
        pub fn ip_sets(mut self, input: impl Into<crate::model::IpSet>) -> Self {
            let mut v = self.ip_sets.unwrap_or_default();
            v.push(input.into());
            self.ip_sets = Some(v);
            self
        }
        /// <p>The static IP addresses that Global Accelerator associates with the accelerator.</p>
        pub fn set_ip_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpSet>>,
        ) -> Self {
            self.ip_sets = input;
            self
        }
        /// <p>The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses. </p>
        /// <p>The naming convention for the DNS name is the following: A lowercase letter a,
        /// followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example:
        /// a1234567890abcdef.awsglobalaccelerator.com.</p>
        /// <p>For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing">
        /// Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses. </p>
        /// <p>The naming convention for the DNS name is the following: A lowercase letter a,
        /// followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example:
        /// a1234567890abcdef.awsglobalaccelerator.com.</p>
        /// <p>For more information about the default DNS name, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing">
        /// Support for DNS Addressing in Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>Describes the deployment status of the accelerator.</p>
        pub fn status(mut self, input: crate::model::AcceleratorStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Describes the deployment status of the accelerator.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AcceleratorStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the accelerator was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time that the accelerator was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The date and time that the accelerator was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time that the accelerator was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Accelerator`](crate::model::Accelerator)
        pub fn build(self) -> crate::model::Accelerator {
            crate::model::Accelerator {
                accelerator_arn: self.accelerator_arn,
                name: self.name,
                ip_address_type: self.ip_address_type,
                enabled: self.enabled,
                ip_sets: self.ip_sets,
                dns_name: self.dns_name,
                status: self.status,
                created_time: self.created_time,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl Accelerator {
    /// Creates a new builder-style object to manufacture [`Accelerator`](crate::model::Accelerator)
    pub fn builder() -> crate::model::accelerator::Builder {
        crate::model::accelerator::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AcceleratorStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deployed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AcceleratorStatus {
    fn from(s: &str) -> Self {
        match s {
            "DEPLOYED" => AcceleratorStatus::Deployed,
            "IN_PROGRESS" => AcceleratorStatus::InProgress,
            other => AcceleratorStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AcceleratorStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AcceleratorStatus::from(s))
    }
}
impl AcceleratorStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AcceleratorStatus::Deployed => "DEPLOYED",
            AcceleratorStatus::InProgress => "IN_PROGRESS",
            AcceleratorStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPLOYED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for AcceleratorStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that contains a <code>Tag</code> key and <code>Tag</code> value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A string that contains a <code>Tag</code> key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A string that contains a <code>Tag</code> value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A string that contains a <code>Tag</code> key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A string that contains a <code>Tag</code> value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string that contains a <code>Tag</code> key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A string that contains a <code>Tag</code> key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A string that contains a <code>Tag</code> value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A string that contains a <code>Tag</code> value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Provides authorization for Amazon to bring a specific IP address range to a specific AWS
/// account using bring your own IP addresses (BYOIP). </p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
/// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CidrAuthorizationContext {
    /// <p>The plain-text authorization message for the prefix and account.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The signed authorization message for the prefix and account.</p>
    pub signature: std::option::Option<std::string::String>,
}
impl CidrAuthorizationContext {
    /// <p>The plain-text authorization message for the prefix and account.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The signed authorization message for the prefix and account.</p>
    pub fn signature(&self) -> std::option::Option<&str> {
        self.signature.as_deref()
    }
}
impl std::fmt::Debug for CidrAuthorizationContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CidrAuthorizationContext");
        formatter.field("message", &self.message);
        formatter.field("signature", &self.signature);
        formatter.finish()
    }
}
/// See [`CidrAuthorizationContext`](crate::model::CidrAuthorizationContext)
pub mod cidr_authorization_context {
    /// A builder for [`CidrAuthorizationContext`](crate::model::CidrAuthorizationContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) signature: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The plain-text authorization message for the prefix and account.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The plain-text authorization message for the prefix and account.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The signed authorization message for the prefix and account.</p>
        pub fn signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature = Some(input.into());
            self
        }
        /// <p>The signed authorization message for the prefix and account.</p>
        pub fn set_signature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signature = input;
            self
        }
        /// Consumes the builder and constructs a [`CidrAuthorizationContext`](crate::model::CidrAuthorizationContext)
        pub fn build(self) -> crate::model::CidrAuthorizationContext {
            crate::model::CidrAuthorizationContext {
                message: self.message,
                signature: self.signature,
            }
        }
    }
}
impl CidrAuthorizationContext {
    /// Creates a new builder-style object to manufacture [`CidrAuthorizationContext`](crate::model::CidrAuthorizationContext)
    pub fn builder() -> crate::model::cidr_authorization_context::Builder {
        crate::model::cidr_authorization_context::Builder::default()
    }
}

/// <p>The port mappings for a specified endpoint IP address (destination).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationPortMapping {
    /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator
    /// that you have port mappings for.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>The IP address/port combinations (sockets) that map to a given destination socket
    /// address.</p>
    pub accelerator_socket_addresses:
        std::option::Option<std::vec::Vec<crate::model::SocketAddress>>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
    /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
    pub endpoint_id: std::option::Option<std::string::String>,
    /// <p>The AWS Region for the endpoint group.</p>
    pub endpoint_group_region: std::option::Option<std::string::String>,
    /// <p>The endpoint IP address/port combination for traffic received on the accelerator socket address.</p>
    pub destination_socket_address: std::option::Option<crate::model::SocketAddress>,
    /// <p>The IP address type, which must be IPv4.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
    /// <p>Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
    /// traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.</p>
    pub destination_traffic_state:
        std::option::Option<crate::model::CustomRoutingDestinationTrafficState>,
}
impl DestinationPortMapping {
    /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator
    /// that you have port mappings for.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>The IP address/port combinations (sockets) that map to a given destination socket
    /// address.</p>
    pub fn accelerator_socket_addresses(
        &self,
    ) -> std::option::Option<&[crate::model::SocketAddress]> {
        self.accelerator_socket_addresses.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
    /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
    /// <p>The AWS Region for the endpoint group.</p>
    pub fn endpoint_group_region(&self) -> std::option::Option<&str> {
        self.endpoint_group_region.as_deref()
    }
    /// <p>The endpoint IP address/port combination for traffic received on the accelerator socket address.</p>
    pub fn destination_socket_address(&self) -> std::option::Option<&crate::model::SocketAddress> {
        self.destination_socket_address.as_ref()
    }
    /// <p>The IP address type, which must be IPv4.</p>
    pub fn ip_address_type(&self) -> std::option::Option<&crate::model::IpAddressType> {
        self.ip_address_type.as_ref()
    }
    /// <p>Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
    /// traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.</p>
    pub fn destination_traffic_state(
        &self,
    ) -> std::option::Option<&crate::model::CustomRoutingDestinationTrafficState> {
        self.destination_traffic_state.as_ref()
    }
}
impl std::fmt::Debug for DestinationPortMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationPortMapping");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field(
            "accelerator_socket_addresses",
            &self.accelerator_socket_addresses,
        );
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.field("endpoint_id", &self.endpoint_id);
        formatter.field("endpoint_group_region", &self.endpoint_group_region);
        formatter.field(
            "destination_socket_address",
            &self.destination_socket_address,
        );
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.field("destination_traffic_state", &self.destination_traffic_state);
        formatter.finish()
    }
}
/// See [`DestinationPortMapping`](crate::model::DestinationPortMapping)
pub mod destination_port_mapping {
    /// A builder for [`DestinationPortMapping`](crate::model::DestinationPortMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) accelerator_socket_addresses:
            std::option::Option<std::vec::Vec<crate::model::SocketAddress>>,
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_group_region: std::option::Option<std::string::String>,
        pub(crate) destination_socket_address: std::option::Option<crate::model::SocketAddress>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) destination_traffic_state:
            std::option::Option<crate::model::CustomRoutingDestinationTrafficState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator
        /// that you have port mappings for.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator
        /// that you have port mappings for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// Appends an item to `accelerator_socket_addresses`.
        ///
        /// To override the contents of this collection use [`set_accelerator_socket_addresses`](Self::set_accelerator_socket_addresses).
        ///
        /// <p>The IP address/port combinations (sockets) that map to a given destination socket
        /// address.</p>
        pub fn accelerator_socket_addresses(
            mut self,
            input: impl Into<crate::model::SocketAddress>,
        ) -> Self {
            let mut v = self.accelerator_socket_addresses.unwrap_or_default();
            v.push(input.into());
            self.accelerator_socket_addresses = Some(v);
            self
        }
        /// <p>The IP address/port combinations (sockets) that map to a given destination socket
        /// address.</p>
        pub fn set_accelerator_socket_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SocketAddress>>,
        ) -> Self {
            self.accelerator_socket_addresses = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// <p>The AWS Region for the endpoint group.</p>
        pub fn endpoint_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_region = Some(input.into());
            self
        }
        /// <p>The AWS Region for the endpoint group.</p>
        pub fn set_endpoint_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_region = input;
            self
        }
        /// <p>The endpoint IP address/port combination for traffic received on the accelerator socket address.</p>
        pub fn destination_socket_address(mut self, input: crate::model::SocketAddress) -> Self {
            self.destination_socket_address = Some(input);
            self
        }
        /// <p>The endpoint IP address/port combination for traffic received on the accelerator socket address.</p>
        pub fn set_destination_socket_address(
            mut self,
            input: std::option::Option<crate::model::SocketAddress>,
        ) -> Self {
            self.destination_socket_address = input;
            self
        }
        /// <p>The IP address type, which must be IPv4.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type, which must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// <p>Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
        /// traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.</p>
        pub fn destination_traffic_state(
            mut self,
            input: crate::model::CustomRoutingDestinationTrafficState,
        ) -> Self {
            self.destination_traffic_state = Some(input);
            self
        }
        /// <p>Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
        /// traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.</p>
        pub fn set_destination_traffic_state(
            mut self,
            input: std::option::Option<crate::model::CustomRoutingDestinationTrafficState>,
        ) -> Self {
            self.destination_traffic_state = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationPortMapping`](crate::model::DestinationPortMapping)
        pub fn build(self) -> crate::model::DestinationPortMapping {
            crate::model::DestinationPortMapping {
                accelerator_arn: self.accelerator_arn,
                accelerator_socket_addresses: self.accelerator_socket_addresses,
                endpoint_group_arn: self.endpoint_group_arn,
                endpoint_id: self.endpoint_id,
                endpoint_group_region: self.endpoint_group_region,
                destination_socket_address: self.destination_socket_address,
                ip_address_type: self.ip_address_type,
                destination_traffic_state: self.destination_traffic_state,
            }
        }
    }
}
impl DestinationPortMapping {
    /// Creates a new builder-style object to manufacture [`DestinationPortMapping`](crate::model::DestinationPortMapping)
    pub fn builder() -> crate::model::destination_port_mapping::Builder {
        crate::model::destination_port_mapping::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomRoutingDestinationTrafficState {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomRoutingDestinationTrafficState {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW" => CustomRoutingDestinationTrafficState::Allow,
            "DENY" => CustomRoutingDestinationTrafficState::Deny,
            other => CustomRoutingDestinationTrafficState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomRoutingDestinationTrafficState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomRoutingDestinationTrafficState::from(s))
    }
}
impl CustomRoutingDestinationTrafficState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomRoutingDestinationTrafficState::Allow => "ALLOW",
            CustomRoutingDestinationTrafficState::Deny => "DENY",
            CustomRoutingDestinationTrafficState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW", "DENY"]
    }
}
impl AsRef<str> for CustomRoutingDestinationTrafficState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An IP address/port combination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SocketAddress {
    /// <p>The IP address for the socket address.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The port for the socket address.</p>
    pub port: std::option::Option<i32>,
}
impl SocketAddress {
    /// <p>The IP address for the socket address.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The port for the socket address.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
}
impl std::fmt::Debug for SocketAddress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SocketAddress");
        formatter.field("ip_address", &self.ip_address);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`SocketAddress`](crate::model::SocketAddress)
pub mod socket_address {
    /// A builder for [`SocketAddress`](crate::model::SocketAddress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The IP address for the socket address.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address for the socket address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The port for the socket address.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port for the socket address.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`SocketAddress`](crate::model::SocketAddress)
        pub fn build(self) -> crate::model::SocketAddress {
            crate::model::SocketAddress {
                ip_address: self.ip_address,
                port: self.port,
            }
        }
    }
}
impl SocketAddress {
    /// Creates a new builder-style object to manufacture [`SocketAddress`](crate::model::SocketAddress)
    pub fn builder() -> crate::model::socket_address::Builder {
        crate::model::socket_address::Builder::default()
    }
}

/// <p>Returns the ports and associated IP addresses and ports of Amazon EC2 instances in your virtual
/// private cloud (VPC) subnets. Custom routing is a port mapping protocol in AWS Global Accelerator that
/// statically associates port ranges with VPC subnets, which allows Global Accelerator to route to
/// specific instances and ports within one or more subnets. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortMapping {
    /// <p>The accelerator port.</p>
    pub accelerator_port: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
    /// <p>The IP address of the VPC subnet (the subnet ID).</p>
    pub endpoint_id: std::option::Option<std::string::String>,
    /// <p>The EC2 instance IP address and port number in the virtual private cloud (VPC) subnet.</p>
    pub destination_socket_address: std::option::Option<crate::model::SocketAddress>,
    /// <p>The protocols supported by the endpoint group.</p>
    pub protocols: std::option::Option<std::vec::Vec<crate::model::CustomRoutingProtocol>>,
    /// <p>Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
    /// traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.</p>
    pub destination_traffic_state:
        std::option::Option<crate::model::CustomRoutingDestinationTrafficState>,
}
impl PortMapping {
    /// <p>The accelerator port.</p>
    pub fn accelerator_port(&self) -> std::option::Option<i32> {
        self.accelerator_port
    }
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
    /// <p>The IP address of the VPC subnet (the subnet ID).</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
    /// <p>The EC2 instance IP address and port number in the virtual private cloud (VPC) subnet.</p>
    pub fn destination_socket_address(&self) -> std::option::Option<&crate::model::SocketAddress> {
        self.destination_socket_address.as_ref()
    }
    /// <p>The protocols supported by the endpoint group.</p>
    pub fn protocols(&self) -> std::option::Option<&[crate::model::CustomRoutingProtocol]> {
        self.protocols.as_deref()
    }
    /// <p>Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
    /// traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.</p>
    pub fn destination_traffic_state(
        &self,
    ) -> std::option::Option<&crate::model::CustomRoutingDestinationTrafficState> {
        self.destination_traffic_state.as_ref()
    }
}
impl std::fmt::Debug for PortMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortMapping");
        formatter.field("accelerator_port", &self.accelerator_port);
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.field("endpoint_id", &self.endpoint_id);
        formatter.field(
            "destination_socket_address",
            &self.destination_socket_address,
        );
        formatter.field("protocols", &self.protocols);
        formatter.field("destination_traffic_state", &self.destination_traffic_state);
        formatter.finish()
    }
}
/// See [`PortMapping`](crate::model::PortMapping)
pub mod port_mapping {
    /// A builder for [`PortMapping`](crate::model::PortMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_port: std::option::Option<i32>,
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) destination_socket_address: std::option::Option<crate::model::SocketAddress>,
        pub(crate) protocols:
            std::option::Option<std::vec::Vec<crate::model::CustomRoutingProtocol>>,
        pub(crate) destination_traffic_state:
            std::option::Option<crate::model::CustomRoutingDestinationTrafficState>,
    }
    impl Builder {
        /// <p>The accelerator port.</p>
        pub fn accelerator_port(mut self, input: i32) -> Self {
            self.accelerator_port = Some(input);
            self
        }
        /// <p>The accelerator port.</p>
        pub fn set_accelerator_port(mut self, input: std::option::Option<i32>) -> Self {
            self.accelerator_port = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// <p>The IP address of the VPC subnet (the subnet ID).</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The IP address of the VPC subnet (the subnet ID).</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// <p>The EC2 instance IP address and port number in the virtual private cloud (VPC) subnet.</p>
        pub fn destination_socket_address(mut self, input: crate::model::SocketAddress) -> Self {
            self.destination_socket_address = Some(input);
            self
        }
        /// <p>The EC2 instance IP address and port number in the virtual private cloud (VPC) subnet.</p>
        pub fn set_destination_socket_address(
            mut self,
            input: std::option::Option<crate::model::SocketAddress>,
        ) -> Self {
            self.destination_socket_address = input;
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocols supported by the endpoint group.</p>
        pub fn protocols(mut self, input: impl Into<crate::model::CustomRoutingProtocol>) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input.into());
            self.protocols = Some(v);
            self
        }
        /// <p>The protocols supported by the endpoint group.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomRoutingProtocol>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// <p>Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
        /// traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.</p>
        pub fn destination_traffic_state(
            mut self,
            input: crate::model::CustomRoutingDestinationTrafficState,
        ) -> Self {
            self.destination_traffic_state = Some(input);
            self
        }
        /// <p>Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if
        /// traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.</p>
        pub fn set_destination_traffic_state(
            mut self,
            input: std::option::Option<crate::model::CustomRoutingDestinationTrafficState>,
        ) -> Self {
            self.destination_traffic_state = input;
            self
        }
        /// Consumes the builder and constructs a [`PortMapping`](crate::model::PortMapping)
        pub fn build(self) -> crate::model::PortMapping {
            crate::model::PortMapping {
                accelerator_port: self.accelerator_port,
                endpoint_group_arn: self.endpoint_group_arn,
                endpoint_id: self.endpoint_id,
                destination_socket_address: self.destination_socket_address,
                protocols: self.protocols,
                destination_traffic_state: self.destination_traffic_state,
            }
        }
    }
}
impl PortMapping {
    /// Creates a new builder-style object to manufacture [`PortMapping`](crate::model::PortMapping)
    pub fn builder() -> crate::model::port_mapping::Builder {
        crate::model::port_mapping::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomRoutingProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    #[allow(missing_docs)] // documentation missing in model
    Udp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomRoutingProtocol {
    fn from(s: &str) -> Self {
        match s {
            "TCP" => CustomRoutingProtocol::Tcp,
            "UDP" => CustomRoutingProtocol::Udp,
            other => CustomRoutingProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomRoutingProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomRoutingProtocol::from(s))
    }
}
impl CustomRoutingProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomRoutingProtocol::Tcp => "TCP",
            CustomRoutingProtocol::Udp => "UDP",
            CustomRoutingProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TCP", "UDP"]
    }
}
impl AsRef<str> for CustomRoutingProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type for the endpoint group for a custom routing accelerator. An AWS Region can have only one endpoint group for a specific listener.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomRoutingEndpointGroup {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
    /// <p>The AWS Region where the endpoint group is located.</p>
    pub endpoint_group_region: std::option::Option<std::string::String>,
    /// <p>For a custom routing accelerator, describes the port range and protocol for all endpoints
    /// (virtual private cloud subnets) in an endpoint group to accept client traffic on.</p>
    pub destination_descriptions:
        std::option::Option<std::vec::Vec<crate::model::CustomRoutingDestinationDescription>>,
    /// <p>For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an
    /// endpoint group to accept client traffic on.</p>
    pub endpoint_descriptions:
        std::option::Option<std::vec::Vec<crate::model::CustomRoutingEndpointDescription>>,
}
impl CustomRoutingEndpointGroup {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
    /// <p>The AWS Region where the endpoint group is located.</p>
    pub fn endpoint_group_region(&self) -> std::option::Option<&str> {
        self.endpoint_group_region.as_deref()
    }
    /// <p>For a custom routing accelerator, describes the port range and protocol for all endpoints
    /// (virtual private cloud subnets) in an endpoint group to accept client traffic on.</p>
    pub fn destination_descriptions(
        &self,
    ) -> std::option::Option<&[crate::model::CustomRoutingDestinationDescription]> {
        self.destination_descriptions.as_deref()
    }
    /// <p>For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an
    /// endpoint group to accept client traffic on.</p>
    pub fn endpoint_descriptions(
        &self,
    ) -> std::option::Option<&[crate::model::CustomRoutingEndpointDescription]> {
        self.endpoint_descriptions.as_deref()
    }
}
impl std::fmt::Debug for CustomRoutingEndpointGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomRoutingEndpointGroup");
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.field("endpoint_group_region", &self.endpoint_group_region);
        formatter.field("destination_descriptions", &self.destination_descriptions);
        formatter.field("endpoint_descriptions", &self.endpoint_descriptions);
        formatter.finish()
    }
}
/// See [`CustomRoutingEndpointGroup`](crate::model::CustomRoutingEndpointGroup)
pub mod custom_routing_endpoint_group {
    /// A builder for [`CustomRoutingEndpointGroup`](crate::model::CustomRoutingEndpointGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_group_region: std::option::Option<std::string::String>,
        pub(crate) destination_descriptions:
            std::option::Option<std::vec::Vec<crate::model::CustomRoutingDestinationDescription>>,
        pub(crate) endpoint_descriptions:
            std::option::Option<std::vec::Vec<crate::model::CustomRoutingEndpointDescription>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// <p>The AWS Region where the endpoint group is located.</p>
        pub fn endpoint_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_region = Some(input.into());
            self
        }
        /// <p>The AWS Region where the endpoint group is located.</p>
        pub fn set_endpoint_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_region = input;
            self
        }
        /// Appends an item to `destination_descriptions`.
        ///
        /// To override the contents of this collection use [`set_destination_descriptions`](Self::set_destination_descriptions).
        ///
        /// <p>For a custom routing accelerator, describes the port range and protocol for all endpoints
        /// (virtual private cloud subnets) in an endpoint group to accept client traffic on.</p>
        pub fn destination_descriptions(
            mut self,
            input: impl Into<crate::model::CustomRoutingDestinationDescription>,
        ) -> Self {
            let mut v = self.destination_descriptions.unwrap_or_default();
            v.push(input.into());
            self.destination_descriptions = Some(v);
            self
        }
        /// <p>For a custom routing accelerator, describes the port range and protocol for all endpoints
        /// (virtual private cloud subnets) in an endpoint group to accept client traffic on.</p>
        pub fn set_destination_descriptions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CustomRoutingDestinationDescription>,
            >,
        ) -> Self {
            self.destination_descriptions = input;
            self
        }
        /// Appends an item to `endpoint_descriptions`.
        ///
        /// To override the contents of this collection use [`set_endpoint_descriptions`](Self::set_endpoint_descriptions).
        ///
        /// <p>For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an
        /// endpoint group to accept client traffic on.</p>
        pub fn endpoint_descriptions(
            mut self,
            input: impl Into<crate::model::CustomRoutingEndpointDescription>,
        ) -> Self {
            let mut v = self.endpoint_descriptions.unwrap_or_default();
            v.push(input.into());
            self.endpoint_descriptions = Some(v);
            self
        }
        /// <p>For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an
        /// endpoint group to accept client traffic on.</p>
        pub fn set_endpoint_descriptions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CustomRoutingEndpointDescription>,
            >,
        ) -> Self {
            self.endpoint_descriptions = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomRoutingEndpointGroup`](crate::model::CustomRoutingEndpointGroup)
        pub fn build(self) -> crate::model::CustomRoutingEndpointGroup {
            crate::model::CustomRoutingEndpointGroup {
                endpoint_group_arn: self.endpoint_group_arn,
                endpoint_group_region: self.endpoint_group_region,
                destination_descriptions: self.destination_descriptions,
                endpoint_descriptions: self.endpoint_descriptions,
            }
        }
    }
}
impl CustomRoutingEndpointGroup {
    /// Creates a new builder-style object to manufacture [`CustomRoutingEndpointGroup`](crate::model::CustomRoutingEndpointGroup)
    pub fn builder() -> crate::model::custom_routing_endpoint_group::Builder {
        crate::model::custom_routing_endpoint_group::Builder::default()
    }
}

/// <p>A complex type for an endpoint for a custom routing accelerator. Each endpoint group can include one or more endpoints,
/// which are virtual private cloud (VPC) subnets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomRoutingEndpointDescription {
    /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
    /// subnet ID. </p>
    pub endpoint_id: std::option::Option<std::string::String>,
}
impl CustomRoutingEndpointDescription {
    /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
    /// subnet ID. </p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
}
impl std::fmt::Debug for CustomRoutingEndpointDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomRoutingEndpointDescription");
        formatter.field("endpoint_id", &self.endpoint_id);
        formatter.finish()
    }
}
/// See [`CustomRoutingEndpointDescription`](crate::model::CustomRoutingEndpointDescription)
pub mod custom_routing_endpoint_description {
    /// A builder for [`CustomRoutingEndpointDescription`](crate::model::CustomRoutingEndpointDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
        /// subnet ID. </p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
        /// subnet ID. </p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomRoutingEndpointDescription`](crate::model::CustomRoutingEndpointDescription)
        pub fn build(self) -> crate::model::CustomRoutingEndpointDescription {
            crate::model::CustomRoutingEndpointDescription {
                endpoint_id: self.endpoint_id,
            }
        }
    }
}
impl CustomRoutingEndpointDescription {
    /// Creates a new builder-style object to manufacture [`CustomRoutingEndpointDescription`](crate::model::CustomRoutingEndpointDescription)
    pub fn builder() -> crate::model::custom_routing_endpoint_description::Builder {
        crate::model::custom_routing_endpoint_description::Builder::default()
    }
}

/// <p>For a custom routing accelerator, describes the port range and protocol for all endpoints
/// (virtual private cloud subnets) in an endpoint group to accept client traffic on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomRoutingDestinationDescription {
    /// <p>The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
    pub from_port: std::option::Option<i32>,
    /// <p>The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
    pub to_port: std::option::Option<i32>,
    /// <p>The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either TCP or UDP.</p>
    pub protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
}
impl CustomRoutingDestinationDescription {
    /// <p>The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
    pub fn from_port(&self) -> std::option::Option<i32> {
        self.from_port
    }
    /// <p>The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
    pub fn to_port(&self) -> std::option::Option<i32> {
        self.to_port
    }
    /// <p>The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either TCP or UDP.</p>
    pub fn protocols(&self) -> std::option::Option<&[crate::model::Protocol]> {
        self.protocols.as_deref()
    }
}
impl std::fmt::Debug for CustomRoutingDestinationDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomRoutingDestinationDescription");
        formatter.field("from_port", &self.from_port);
        formatter.field("to_port", &self.to_port);
        formatter.field("protocols", &self.protocols);
        formatter.finish()
    }
}
/// See [`CustomRoutingDestinationDescription`](crate::model::CustomRoutingDestinationDescription)
pub mod custom_routing_destination_description {
    /// A builder for [`CustomRoutingDestinationDescription`](crate::model::CustomRoutingDestinationDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) to_port: std::option::Option<i32>,
        pub(crate) protocols: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
    }
    impl Builder {
        /// <p>The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either TCP or UDP.</p>
        pub fn protocols(mut self, input: impl Into<crate::model::Protocol>) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input.into());
            self.protocols = Some(v);
            self
        }
        /// <p>The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either TCP or UDP.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Protocol>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomRoutingDestinationDescription`](crate::model::CustomRoutingDestinationDescription)
        pub fn build(self) -> crate::model::CustomRoutingDestinationDescription {
            crate::model::CustomRoutingDestinationDescription {
                from_port: self.from_port,
                to_port: self.to_port,
                protocols: self.protocols,
            }
        }
    }
}
impl CustomRoutingDestinationDescription {
    /// Creates a new builder-style object to manufacture [`CustomRoutingDestinationDescription`](crate::model::CustomRoutingDestinationDescription)
    pub fn builder() -> crate::model::custom_routing_destination_description::Builder {
        crate::model::custom_routing_destination_description::Builder::default()
    }
}

/// <p>For a custom routing accelerator, sets the port range and protocol for all endpoints (virtual
/// private cloud subnets) in an endpoint group to accept client traffic on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomRoutingDestinationConfiguration {
    /// <p>The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
    pub from_port: std::option::Option<i32>,
    /// <p>The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
    pub to_port: std::option::Option<i32>,
    /// <p>The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either TCP or UDP.</p>
    pub protocols: std::option::Option<std::vec::Vec<crate::model::CustomRoutingProtocol>>,
}
impl CustomRoutingDestinationConfiguration {
    /// <p>The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
    pub fn from_port(&self) -> std::option::Option<i32> {
        self.from_port
    }
    /// <p>The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
    pub fn to_port(&self) -> std::option::Option<i32> {
        self.to_port
    }
    /// <p>The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either TCP or UDP.</p>
    pub fn protocols(&self) -> std::option::Option<&[crate::model::CustomRoutingProtocol]> {
        self.protocols.as_deref()
    }
}
impl std::fmt::Debug for CustomRoutingDestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomRoutingDestinationConfiguration");
        formatter.field("from_port", &self.from_port);
        formatter.field("to_port", &self.to_port);
        formatter.field("protocols", &self.protocols);
        formatter.finish()
    }
}
/// See [`CustomRoutingDestinationConfiguration`](crate::model::CustomRoutingDestinationConfiguration)
pub mod custom_routing_destination_configuration {
    /// A builder for [`CustomRoutingDestinationConfiguration`](crate::model::CustomRoutingDestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) to_port: std::option::Option<i32>,
        pub(crate) protocols:
            std::option::Option<std::vec::Vec<crate::model::CustomRoutingProtocol>>,
    }
    impl Builder {
        /// <p>The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>The first port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>The last port, inclusive, in the range of ports for the endpoint group that is associated with a custom routing accelerator.</p>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either TCP or UDP.</p>
        pub fn protocols(mut self, input: impl Into<crate::model::CustomRoutingProtocol>) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input.into());
            self.protocols = Some(v);
            self
        }
        /// <p>The protocol for the endpoint group that is associated with a custom routing accelerator. The protocol can be either TCP or UDP.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomRoutingProtocol>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomRoutingDestinationConfiguration`](crate::model::CustomRoutingDestinationConfiguration)
        pub fn build(self) -> crate::model::CustomRoutingDestinationConfiguration {
            crate::model::CustomRoutingDestinationConfiguration {
                from_port: self.from_port,
                to_port: self.to_port,
                protocols: self.protocols,
            }
        }
    }
}
impl CustomRoutingDestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`CustomRoutingDestinationConfiguration`](crate::model::CustomRoutingDestinationConfiguration)
    pub fn builder() -> crate::model::custom_routing_destination_configuration::Builder {
        crate::model::custom_routing_destination_configuration::Builder::default()
    }
}

/// <p>The list of endpoint objects. For custom routing, this is a list of virtual private cloud (VPC) subnet IDs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomRoutingEndpointConfiguration {
    /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
    /// subnet ID. </p>
    pub endpoint_id: std::option::Option<std::string::String>,
}
impl CustomRoutingEndpointConfiguration {
    /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
    /// subnet ID. </p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
}
impl std::fmt::Debug for CustomRoutingEndpointConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomRoutingEndpointConfiguration");
        formatter.field("endpoint_id", &self.endpoint_id);
        formatter.finish()
    }
}
/// See [`CustomRoutingEndpointConfiguration`](crate::model::CustomRoutingEndpointConfiguration)
pub mod custom_routing_endpoint_configuration {
    /// A builder for [`CustomRoutingEndpointConfiguration`](crate::model::CustomRoutingEndpointConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
        /// subnet ID. </p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
        /// subnet ID. </p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomRoutingEndpointConfiguration`](crate::model::CustomRoutingEndpointConfiguration)
        pub fn build(self) -> crate::model::CustomRoutingEndpointConfiguration {
            crate::model::CustomRoutingEndpointConfiguration {
                endpoint_id: self.endpoint_id,
            }
        }
    }
}
impl CustomRoutingEndpointConfiguration {
    /// Creates a new builder-style object to manufacture [`CustomRoutingEndpointConfiguration`](crate::model::CustomRoutingEndpointConfiguration)
    pub fn builder() -> crate::model::custom_routing_endpoint_configuration::Builder {
        crate::model::custom_routing_endpoint_configuration::Builder::default()
    }
}
