// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddCustomRoutingEndpointsInput`](crate::input::AddCustomRoutingEndpointsInput)
pub mod add_custom_routing_endpoints_input {
    /// A builder for [`AddCustomRoutingEndpointsInput`](crate::input::AddCustomRoutingEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_configurations:
            std::option::Option<std::vec::Vec<crate::model::CustomRoutingEndpointConfiguration>>,
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `endpoint_configurations`.
        ///
        /// To override the contents of this collection use [`set_endpoint_configurations`](Self::set_endpoint_configurations).
        ///
        /// <p>The list of endpoint objects to add to a custom routing accelerator.</p>
        pub fn endpoint_configurations(
            mut self,
            input: impl Into<crate::model::CustomRoutingEndpointConfiguration>,
        ) -> Self {
            let mut v = self.endpoint_configurations.unwrap_or_default();
            v.push(input.into());
            self.endpoint_configurations = Some(v);
            self
        }
        /// <p>The list of endpoint objects to add to a custom routing accelerator.</p>
        pub fn set_endpoint_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CustomRoutingEndpointConfiguration>,
            >,
        ) -> Self {
            self.endpoint_configurations = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AddCustomRoutingEndpointsInput`](crate::input::AddCustomRoutingEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddCustomRoutingEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddCustomRoutingEndpointsInput {
                endpoint_configurations: self.endpoint_configurations,
                endpoint_group_arn: self.endpoint_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AddCustomRoutingEndpointsInputOperationOutputAlias =
    crate::operation::AddCustomRoutingEndpoints;
#[doc(hidden)]
pub type AddCustomRoutingEndpointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddCustomRoutingEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`AddCustomRoutingEndpoints`](crate::operation::AddCustomRoutingEndpoints)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddCustomRoutingEndpoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddCustomRoutingEndpointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddCustomRoutingEndpointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddCustomRoutingEndpointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.AddCustomRoutingEndpoints",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_custom_routing_endpoints(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddCustomRoutingEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddCustomRoutingEndpoints",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddCustomRoutingEndpointsInput`](crate::input::AddCustomRoutingEndpointsInput)
    pub fn builder() -> crate::input::add_custom_routing_endpoints_input::Builder {
        crate::input::add_custom_routing_endpoints_input::Builder::default()
    }
}

/// See [`AdvertiseByoipCidrInput`](crate::input::AdvertiseByoipCidrInput)
pub mod advertise_byoip_cidr_input {
    /// A builder for [`AdvertiseByoipCidrInput`](crate::input::AdvertiseByoipCidrInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned.
        /// You can't advertise only a portion of the provisioned range.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned.
        /// You can't advertise only a portion of the provisioned range.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`AdvertiseByoipCidrInput`](crate::input::AdvertiseByoipCidrInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AdvertiseByoipCidrInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AdvertiseByoipCidrInput { cidr: self.cidr })
        }
    }
}
#[doc(hidden)]
pub type AdvertiseByoipCidrInputOperationOutputAlias = crate::operation::AdvertiseByoipCidr;
#[doc(hidden)]
pub type AdvertiseByoipCidrInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AdvertiseByoipCidrInput {
    /// Consumes the builder and constructs an Operation<[`AdvertiseByoipCidr`](crate::operation::AdvertiseByoipCidr)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AdvertiseByoipCidr,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AdvertiseByoipCidrInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AdvertiseByoipCidrInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AdvertiseByoipCidrInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.AdvertiseByoipCidr",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_advertise_byoip_cidr(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AdvertiseByoipCidr::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AdvertiseByoipCidr",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AdvertiseByoipCidrInput`](crate::input::AdvertiseByoipCidrInput)
    pub fn builder() -> crate::input::advertise_byoip_cidr_input::Builder {
        crate::input::advertise_byoip_cidr_input::Builder::default()
    }
}

/// See [`AllowCustomRoutingTrafficInput`](crate::input::AllowCustomRoutingTrafficInput)
pub mod allow_custom_routing_traffic_input {
    /// A builder for [`AllowCustomRoutingTrafficInput`](crate::input::AllowCustomRoutingTrafficInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) destination_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destination_ports: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) allow_all_traffic_to_endpoint: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// Appends an item to `destination_addresses`.
        ///
        /// To override the contents of this collection use [`set_destination_addresses`](Self::set_destination_addresses).
        ///
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive
        /// traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.</p>
        /// <p>
        /// <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or is
        /// not specified.</p>
        pub fn destination_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.destination_addresses.unwrap_or_default();
            v.push(input.into());
            self.destination_addresses = Some(v);
            self
        }
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive
        /// traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.</p>
        /// <p>
        /// <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or is
        /// not specified.</p>
        pub fn set_destination_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.destination_addresses = input;
            self
        }
        /// Appends an item to `destination_ports`.
        ///
        /// To override the contents of this collection use [`set_destination_ports`](Self::set_destination_ports).
        ///
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.</p>
        pub fn destination_ports(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.destination_ports.unwrap_or_default();
            v.push(input.into());
            self.destination_ports = Some(v);
            self
        }
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.</p>
        pub fn set_destination_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.destination_ports = input;
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic
        /// from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note
        /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed
        /// to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
        /// the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn allow_all_traffic_to_endpoint(mut self, input: bool) -> Self {
            self.allow_all_traffic_to_endpoint = Some(input);
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic
        /// from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note
        /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed
        /// to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
        /// the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn set_allow_all_traffic_to_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_all_traffic_to_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`AllowCustomRoutingTrafficInput`](crate::input::AllowCustomRoutingTrafficInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AllowCustomRoutingTrafficInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AllowCustomRoutingTrafficInput {
                endpoint_group_arn: self.endpoint_group_arn,
                endpoint_id: self.endpoint_id,
                destination_addresses: self.destination_addresses,
                destination_ports: self.destination_ports,
                allow_all_traffic_to_endpoint: self.allow_all_traffic_to_endpoint,
            })
        }
    }
}
#[doc(hidden)]
pub type AllowCustomRoutingTrafficInputOperationOutputAlias =
    crate::operation::AllowCustomRoutingTraffic;
#[doc(hidden)]
pub type AllowCustomRoutingTrafficInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AllowCustomRoutingTrafficInput {
    /// Consumes the builder and constructs an Operation<[`AllowCustomRoutingTraffic`](crate::operation::AllowCustomRoutingTraffic)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AllowCustomRoutingTraffic,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AllowCustomRoutingTrafficInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AllowCustomRoutingTrafficInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AllowCustomRoutingTrafficInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.AllowCustomRoutingTraffic",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_allow_custom_routing_traffic(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AllowCustomRoutingTraffic::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AllowCustomRoutingTraffic",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AllowCustomRoutingTrafficInput`](crate::input::AllowCustomRoutingTrafficInput)
    pub fn builder() -> crate::input::allow_custom_routing_traffic_input::Builder {
        crate::input::allow_custom_routing_traffic_input::Builder::default()
    }
}

/// See [`CreateAcceleratorInput`](crate::input::CreateAcceleratorInput)
pub mod create_accelerator_input {
    /// A builder for [`CreateAcceleratorInput`](crate::input::CreateAcceleratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Appends an item to `ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
        /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
        /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
        /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
        /// accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
        /// accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
        /// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.ip_addresses = Some(v);
            self
        }
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
        /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
        /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
        /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
        /// accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
        /// accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
        /// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_addresses = input;
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of an accelerator.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of an accelerator.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
        /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
        /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAcceleratorInput`](crate::input::CreateAcceleratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAcceleratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAcceleratorInput {
                name: self.name,
                ip_address_type: self.ip_address_type,
                ip_addresses: self.ip_addresses,
                enabled: self.enabled,
                idempotency_token: self.idempotency_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAcceleratorInputOperationOutputAlias = crate::operation::CreateAccelerator;
#[doc(hidden)]
pub type CreateAcceleratorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAcceleratorInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccelerator`](crate::operation::CreateAccelerator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccelerator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAcceleratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAcceleratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAcceleratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.CreateAccelerator",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_accelerator(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccelerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccelerator",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAcceleratorInput`](crate::input::CreateAcceleratorInput)
    pub fn builder() -> crate::input::create_accelerator_input::Builder {
        crate::input::create_accelerator_input::Builder::default()
    }
}

/// See [`CreateCustomRoutingAcceleratorInput`](crate::input::CreateCustomRoutingAcceleratorInput)
pub mod create_custom_routing_accelerator_input {
    /// A builder for [`CreateCustomRoutingAcceleratorInput`](crate::input::CreateCustomRoutingAcceleratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain
        /// only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain
        /// only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Appends an item to `ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
        /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
        /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
        /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
        /// accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
        /// accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring
        /// your own IP addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn ip_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.ip_addresses = Some(v);
            self
        }
        /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
        /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
        /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
        /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
        /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
        /// accelerator from the AWS IP address pool.</p>
        /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
        /// accelerator with the new addresses.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring
        /// your own IP addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ip_addresses = input;
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that
        /// is, the uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that
        /// is, the uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
        /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Create tags for an accelerator.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
        /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomRoutingAcceleratorInput`](crate::input::CreateCustomRoutingAcceleratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomRoutingAcceleratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomRoutingAcceleratorInput {
                name: self.name,
                ip_address_type: self.ip_address_type,
                ip_addresses: self.ip_addresses,
                enabled: self.enabled,
                idempotency_token: self.idempotency_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomRoutingAcceleratorInputOperationOutputAlias =
    crate::operation::CreateCustomRoutingAccelerator;
#[doc(hidden)]
pub type CreateCustomRoutingAcceleratorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCustomRoutingAcceleratorInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomRoutingAccelerator`](crate::operation::CreateCustomRoutingAccelerator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomRoutingAccelerator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCustomRoutingAcceleratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCustomRoutingAcceleratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCustomRoutingAcceleratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.CreateCustomRoutingAccelerator",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_custom_routing_accelerator(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomRoutingAccelerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomRoutingAccelerator",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomRoutingAcceleratorInput`](crate::input::CreateCustomRoutingAcceleratorInput)
    pub fn builder() -> crate::input::create_custom_routing_accelerator_input::Builder {
        crate::input::create_custom_routing_accelerator_input::Builder::default()
    }
}

/// See [`CreateCustomRoutingEndpointGroupInput`](crate::input::CreateCustomRoutingEndpointGroupInput)
pub mod create_custom_routing_endpoint_group_input {
    /// A builder for [`CreateCustomRoutingEndpointGroupInput`](crate::input::CreateCustomRoutingEndpointGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_group_region: std::option::Option<std::string::String>,
        pub(crate) destination_configurations:
            std::option::Option<std::vec::Vec<crate::model::CustomRoutingDestinationConfiguration>>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
        /// specific Region.</p>
        pub fn endpoint_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_region = Some(input.into());
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
        /// specific Region.</p>
        pub fn set_endpoint_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_region = input;
            self
        }
        /// Appends an item to `destination_configurations`.
        ///
        /// To override the contents of this collection use [`set_destination_configurations`](Self::set_destination_configurations).
        ///
        /// <p>Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept
        /// client traffic on.</p>
        pub fn destination_configurations(
            mut self,
            input: impl Into<crate::model::CustomRoutingDestinationConfiguration>,
        ) -> Self {
            let mut v = self.destination_configurations.unwrap_or_default();
            v.push(input.into());
            self.destination_configurations = Some(v);
            self
        }
        /// <p>Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept
        /// client traffic on.</p>
        pub fn set_destination_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CustomRoutingDestinationConfiguration>,
            >,
        ) -> Self {
            self.destination_configurations = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomRoutingEndpointGroupInput`](crate::input::CreateCustomRoutingEndpointGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomRoutingEndpointGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomRoutingEndpointGroupInput {
                listener_arn: self.listener_arn,
                endpoint_group_region: self.endpoint_group_region,
                destination_configurations: self.destination_configurations,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomRoutingEndpointGroupInputOperationOutputAlias =
    crate::operation::CreateCustomRoutingEndpointGroup;
#[doc(hidden)]
pub type CreateCustomRoutingEndpointGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCustomRoutingEndpointGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomRoutingEndpointGroup`](crate::operation::CreateCustomRoutingEndpointGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomRoutingEndpointGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCustomRoutingEndpointGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCustomRoutingEndpointGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCustomRoutingEndpointGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.CreateCustomRoutingEndpointGroup",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_custom_routing_endpoint_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomRoutingEndpointGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomRoutingEndpointGroup",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomRoutingEndpointGroupInput`](crate::input::CreateCustomRoutingEndpointGroupInput)
    pub fn builder() -> crate::input::create_custom_routing_endpoint_group_input::Builder {
        crate::input::create_custom_routing_endpoint_group_input::Builder::default()
    }
}

/// See [`CreateCustomRoutingListenerInput`](crate::input::CreateCustomRoutingListenerInput)
pub mod create_custom_routing_listener_input {
    /// A builder for [`CreateCustomRoutingListenerInput`](crate::input::CreateCustomRoutingListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// Appends an item to `port_ranges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The port range to support for connections from clients to your accelerator.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
        /// endpoints for custom routing accelerators</a>.</p>
        pub fn port_ranges(mut self, input: impl Into<crate::model::PortRange>) -> Self {
            let mut v = self.port_ranges.unwrap_or_default();
            v.push(input.into());
            self.port_ranges = Some(v);
            self
        }
        /// <p>The port range to support for connections from clients to your accelerator.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
        /// endpoints for custom routing accelerators</a>.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.port_ranges = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomRoutingListenerInput`](crate::input::CreateCustomRoutingListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomRoutingListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomRoutingListenerInput {
                accelerator_arn: self.accelerator_arn,
                port_ranges: self.port_ranges,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomRoutingListenerInputOperationOutputAlias =
    crate::operation::CreateCustomRoutingListener;
#[doc(hidden)]
pub type CreateCustomRoutingListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCustomRoutingListenerInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomRoutingListener`](crate::operation::CreateCustomRoutingListener)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomRoutingListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCustomRoutingListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCustomRoutingListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCustomRoutingListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.CreateCustomRoutingListener",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_custom_routing_listener(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomRoutingListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomRoutingListener",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomRoutingListenerInput`](crate::input::CreateCustomRoutingListenerInput)
    pub fn builder() -> crate::input::create_custom_routing_listener_input::Builder {
        crate::input::create_custom_routing_listener_input::Builder::default()
    }
}

/// See [`CreateEndpointGroupInput`](crate::input::CreateEndpointGroupInput)
pub mod create_endpoint_group_input {
    /// A builder for [`CreateEndpointGroupInput`](crate::input::CreateEndpointGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_group_region: std::option::Option<std::string::String>,
        pub(crate) endpoint_configurations:
            std::option::Option<std::vec::Vec<crate::model::EndpointConfiguration>>,
        pub(crate) traffic_dial_percentage: std::option::Option<f32>,
        pub(crate) health_check_port: std::option::Option<i32>,
        pub(crate) health_check_protocol: std::option::Option<crate::model::HealthCheckProtocol>,
        pub(crate) health_check_path: std::option::Option<std::string::String>,
        pub(crate) health_check_interval_seconds: std::option::Option<i32>,
        pub(crate) threshold_count: std::option::Option<i32>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
        pub(crate) port_overrides: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
        /// specific Region.</p>
        pub fn endpoint_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_region = Some(input.into());
            self
        }
        /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
        /// specific Region.</p>
        pub fn set_endpoint_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_region = input;
            self
        }
        /// Appends an item to `endpoint_configurations`.
        ///
        /// To override the contents of this collection use [`set_endpoint_configurations`](Self::set_endpoint_configurations).
        ///
        /// <p>The list of endpoint objects.</p>
        pub fn endpoint_configurations(
            mut self,
            input: impl Into<crate::model::EndpointConfiguration>,
        ) -> Self {
            let mut v = self.endpoint_configurations.unwrap_or_default();
            v.push(input.into());
            self.endpoint_configurations = Some(v);
            self
        }
        /// <p>The list of endpoint objects.</p>
        pub fn set_endpoint_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointConfiguration>>,
        ) -> Self {
            self.endpoint_configurations = input;
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
        /// this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
        /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn traffic_dial_percentage(mut self, input: f32) -> Self {
            self.traffic_dial_percentage = Some(input);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
        /// this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
        /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn set_traffic_dial_percentage(mut self, input: std::option::Option<f32>) -> Self {
            self.traffic_dial_percentage = input;
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
        /// is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the
        /// first port in the list.</p>
        pub fn health_check_port(mut self, input: i32) -> Self {
            self.health_check_port = Some(input);
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
        /// is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the
        /// first port in the list.</p>
        pub fn set_health_check_port(mut self, input: std::option::Option<i32>) -> Self {
            self.health_check_port = input;
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
        /// value is TCP.</p>
        pub fn health_check_protocol(mut self, input: crate::model::HealthCheckProtocol) -> Self {
            self.health_check_protocol = Some(input);
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
        /// value is TCP.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::HealthCheckProtocol>,
        ) -> Self {
            self.health_check_protocol = input;
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
        /// default value is slash (/).</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_path = Some(input.into());
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
        /// default value is slash (/).</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_path = input;
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.health_check_interval_seconds = Some(input);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.health_check_interval_seconds = input;
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
        /// unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn threshold_count(mut self, input: i32) -> Self {
            self.threshold_count = Some(input);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
        /// unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn set_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.threshold_count = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Appends an item to `port_overrides`.
        ///
        /// To override the contents of this collection use [`set_port_overrides`](Self::set_port_overrides).
        ///
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
        /// For example, you can create a port override in which the listener
        /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
        /// and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
        /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn port_overrides(mut self, input: impl Into<crate::model::PortOverride>) -> Self {
            let mut v = self.port_overrides.unwrap_or_default();
            v.push(input.into());
            self.port_overrides = Some(v);
            self
        }
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
        /// For example, you can create a port override in which the listener
        /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
        /// and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
        /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_port_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
        ) -> Self {
            self.port_overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEndpointGroupInput`](crate::input::CreateEndpointGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEndpointGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEndpointGroupInput {
                listener_arn: self.listener_arn,
                endpoint_group_region: self.endpoint_group_region,
                endpoint_configurations: self.endpoint_configurations,
                traffic_dial_percentage: self.traffic_dial_percentage,
                health_check_port: self.health_check_port,
                health_check_protocol: self.health_check_protocol,
                health_check_path: self.health_check_path,
                health_check_interval_seconds: self.health_check_interval_seconds,
                threshold_count: self.threshold_count,
                idempotency_token: self.idempotency_token,
                port_overrides: self.port_overrides,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEndpointGroupInputOperationOutputAlias = crate::operation::CreateEndpointGroup;
#[doc(hidden)]
pub type CreateEndpointGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEndpointGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateEndpointGroup`](crate::operation::CreateEndpointGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEndpointGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEndpointGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEndpointGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEndpointGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.CreateEndpointGroup",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_endpoint_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEndpointGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEndpointGroup",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEndpointGroupInput`](crate::input::CreateEndpointGroupInput)
    pub fn builder() -> crate::input::create_endpoint_group_input::Builder {
        crate::input::create_endpoint_group_input::Builder::default()
    }
}

/// See [`CreateListenerInput`](crate::input::CreateListenerInput)
pub mod create_listener_input {
    /// A builder for [`CreateListenerInput`](crate::input::CreateListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) client_affinity: std::option::Option<crate::model::ClientAffinity>,
        pub(crate) idempotency_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of your accelerator.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of your accelerator.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// Appends an item to `port_ranges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The list of port ranges to support for connections from clients to your accelerator.</p>
        pub fn port_ranges(mut self, input: impl Into<crate::model::PortRange>) -> Self {
            let mut v = self.port_ranges.unwrap_or_default();
            v.push(input.into());
            self.port_ranges = Some(v);
            self
        }
        /// <p>The list of port ranges to support for connections from clients to your accelerator.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.port_ranges = input;
            self
        }
        /// <p>The protocol for connections from clients to your accelerator.</p>
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol for connections from clients to your accelerator.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
        /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
        /// route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
        /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
        /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
        /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
        /// be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
        /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
        /// source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn client_affinity(mut self, input: crate::model::ClientAffinity) -> Self {
            self.client_affinity = Some(input);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
        /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
        /// route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
        /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
        /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
        /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
        /// be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
        /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
        /// source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn set_client_affinity(
            mut self,
            input: std::option::Option<crate::model::ClientAffinity>,
        ) -> Self {
            self.client_affinity = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.idempotency_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
        /// uniqueness—of the request.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idempotency_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateListenerInput`](crate::input::CreateListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateListenerInput {
                accelerator_arn: self.accelerator_arn,
                port_ranges: self.port_ranges,
                protocol: self.protocol,
                client_affinity: self.client_affinity,
                idempotency_token: self.idempotency_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateListenerInputOperationOutputAlias = crate::operation::CreateListener;
#[doc(hidden)]
pub type CreateListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateListenerInput {
    /// Consumes the builder and constructs an Operation<[`CreateListener`](crate::operation::CreateListener)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.CreateListener",
            );
            Ok(builder)
        }
        if self.idempotency_token.is_none() {
            self.idempotency_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_listener(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateListener",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateListenerInput`](crate::input::CreateListenerInput)
    pub fn builder() -> crate::input::create_listener_input::Builder {
        crate::input::create_listener_input::Builder::default()
    }
}

/// See [`DeleteAcceleratorInput`](crate::input::DeleteAcceleratorInput)
pub mod delete_accelerator_input {
    /// A builder for [`DeleteAcceleratorInput`](crate::input::DeleteAcceleratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an accelerator.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an accelerator.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAcceleratorInput`](crate::input::DeleteAcceleratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAcceleratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAcceleratorInput {
                accelerator_arn: self.accelerator_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAcceleratorInputOperationOutputAlias = crate::operation::DeleteAccelerator;
#[doc(hidden)]
pub type DeleteAcceleratorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAcceleratorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccelerator`](crate::operation::DeleteAccelerator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccelerator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAcceleratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAcceleratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAcceleratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DeleteAccelerator",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_accelerator(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccelerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccelerator",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAcceleratorInput`](crate::input::DeleteAcceleratorInput)
    pub fn builder() -> crate::input::delete_accelerator_input::Builder {
        crate::input::delete_accelerator_input::Builder::default()
    }
}

/// See [`DeleteCustomRoutingAcceleratorInput`](crate::input::DeleteCustomRoutingAcceleratorInput)
pub mod delete_custom_routing_accelerator_input {
    /// A builder for [`DeleteCustomRoutingAcceleratorInput`](crate::input::DeleteCustomRoutingAcceleratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to delete.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to delete.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomRoutingAcceleratorInput`](crate::input::DeleteCustomRoutingAcceleratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomRoutingAcceleratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomRoutingAcceleratorInput {
                accelerator_arn: self.accelerator_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomRoutingAcceleratorInputOperationOutputAlias =
    crate::operation::DeleteCustomRoutingAccelerator;
#[doc(hidden)]
pub type DeleteCustomRoutingAcceleratorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCustomRoutingAcceleratorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomRoutingAccelerator`](crate::operation::DeleteCustomRoutingAccelerator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomRoutingAccelerator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCustomRoutingAcceleratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCustomRoutingAcceleratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCustomRoutingAcceleratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DeleteCustomRoutingAccelerator",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_custom_routing_accelerator(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomRoutingAccelerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomRoutingAccelerator",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomRoutingAcceleratorInput`](crate::input::DeleteCustomRoutingAcceleratorInput)
    pub fn builder() -> crate::input::delete_custom_routing_accelerator_input::Builder {
        crate::input::delete_custom_routing_accelerator_input::Builder::default()
    }
}

/// See [`DeleteCustomRoutingEndpointGroupInput`](crate::input::DeleteCustomRoutingEndpointGroupInput)
pub mod delete_custom_routing_endpoint_group_input {
    /// A builder for [`DeleteCustomRoutingEndpointGroupInput`](crate::input::DeleteCustomRoutingEndpointGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomRoutingEndpointGroupInput`](crate::input::DeleteCustomRoutingEndpointGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomRoutingEndpointGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomRoutingEndpointGroupInput {
                endpoint_group_arn: self.endpoint_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomRoutingEndpointGroupInputOperationOutputAlias =
    crate::operation::DeleteCustomRoutingEndpointGroup;
#[doc(hidden)]
pub type DeleteCustomRoutingEndpointGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCustomRoutingEndpointGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomRoutingEndpointGroup`](crate::operation::DeleteCustomRoutingEndpointGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomRoutingEndpointGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCustomRoutingEndpointGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCustomRoutingEndpointGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCustomRoutingEndpointGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DeleteCustomRoutingEndpointGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_custom_routing_endpoint_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomRoutingEndpointGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomRoutingEndpointGroup",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomRoutingEndpointGroupInput`](crate::input::DeleteCustomRoutingEndpointGroupInput)
    pub fn builder() -> crate::input::delete_custom_routing_endpoint_group_input::Builder {
        crate::input::delete_custom_routing_endpoint_group_input::Builder::default()
    }
}

/// See [`DeleteCustomRoutingListenerInput`](crate::input::DeleteCustomRoutingListenerInput)
pub mod delete_custom_routing_listener_input {
    /// A builder for [`DeleteCustomRoutingListenerInput`](crate::input::DeleteCustomRoutingListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener to delete.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to delete.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomRoutingListenerInput`](crate::input::DeleteCustomRoutingListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomRoutingListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomRoutingListenerInput {
                listener_arn: self.listener_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomRoutingListenerInputOperationOutputAlias =
    crate::operation::DeleteCustomRoutingListener;
#[doc(hidden)]
pub type DeleteCustomRoutingListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCustomRoutingListenerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomRoutingListener`](crate::operation::DeleteCustomRoutingListener)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomRoutingListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCustomRoutingListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCustomRoutingListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCustomRoutingListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DeleteCustomRoutingListener",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_custom_routing_listener(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomRoutingListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomRoutingListener",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomRoutingListenerInput`](crate::input::DeleteCustomRoutingListenerInput)
    pub fn builder() -> crate::input::delete_custom_routing_listener_input::Builder {
        crate::input::delete_custom_routing_listener_input::Builder::default()
    }
}

/// See [`DeleteEndpointGroupInput`](crate::input::DeleteEndpointGroupInput)
pub mod delete_endpoint_group_input {
    /// A builder for [`DeleteEndpointGroupInput`](crate::input::DeleteEndpointGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEndpointGroupInput`](crate::input::DeleteEndpointGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEndpointGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEndpointGroupInput {
                endpoint_group_arn: self.endpoint_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEndpointGroupInputOperationOutputAlias = crate::operation::DeleteEndpointGroup;
#[doc(hidden)]
pub type DeleteEndpointGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEndpointGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEndpointGroup`](crate::operation::DeleteEndpointGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEndpointGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEndpointGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEndpointGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEndpointGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DeleteEndpointGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_endpoint_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEndpointGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEndpointGroup",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEndpointGroupInput`](crate::input::DeleteEndpointGroupInput)
    pub fn builder() -> crate::input::delete_endpoint_group_input::Builder {
        crate::input::delete_endpoint_group_input::Builder::default()
    }
}

/// See [`DeleteListenerInput`](crate::input::DeleteListenerInput)
pub mod delete_listener_input {
    /// A builder for [`DeleteListenerInput`](crate::input::DeleteListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteListenerInput`](crate::input::DeleteListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteListenerInput {
                listener_arn: self.listener_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteListenerInputOperationOutputAlias = crate::operation::DeleteListener;
#[doc(hidden)]
pub type DeleteListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteListenerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteListener`](crate::operation::DeleteListener)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DeleteListener",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_listener(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteListener",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteListenerInput`](crate::input::DeleteListenerInput)
    pub fn builder() -> crate::input::delete_listener_input::Builder {
        crate::input::delete_listener_input::Builder::default()
    }
}

/// See [`DenyCustomRoutingTrafficInput`](crate::input::DenyCustomRoutingTrafficInput)
pub mod deny_custom_routing_traffic_input {
    /// A builder for [`DenyCustomRoutingTrafficInput`](crate::input::DenyCustomRoutingTrafficInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) destination_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destination_ports: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) deny_all_traffic_to_endpoint: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// Appends an item to `destination_addresses`.
        ///
        /// To override the contents of this collection use [`set_destination_addresses`](Self::set_destination_addresses).
        ///
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving
        /// traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the
        /// endpoint group.</p>
        pub fn destination_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.destination_addresses.unwrap_or_default();
            v.push(input.into());
            self.destination_addresses = Some(v);
            self
        }
        /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving
        /// traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the
        /// endpoint group.</p>
        pub fn set_destination_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.destination_addresses = input;
            self
        }
        /// Appends an item to `destination_ports`.
        ///
        /// To override the contents of this collection use [`set_destination_ports`](Self::set_destination_ports).
        ///
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from
        /// receiving traffic.</p>
        pub fn destination_ports(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.destination_ports.unwrap_or_default();
            v.push(input.into());
            self.destination_ports = Some(v);
            self
        }
        /// <p>A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from
        /// receiving traffic.</p>
        pub fn set_destination_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.destination_ports = input;
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i>
        /// receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note
        /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot receive
        /// traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
        /// the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn deny_all_traffic_to_endpoint(mut self, input: bool) -> Self {
            self.deny_all_traffic_to_endpoint = Some(input);
            self
        }
        /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i>
        /// receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
        /// <p>When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note
        /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
        /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot receive
        /// traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
        /// the same as the ports configured for the endpoint group.</p>
        /// <p>The default value is FALSE.</p>
        pub fn set_deny_all_traffic_to_endpoint(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.deny_all_traffic_to_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`DenyCustomRoutingTrafficInput`](crate::input::DenyCustomRoutingTrafficInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DenyCustomRoutingTrafficInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DenyCustomRoutingTrafficInput {
                endpoint_group_arn: self.endpoint_group_arn,
                endpoint_id: self.endpoint_id,
                destination_addresses: self.destination_addresses,
                destination_ports: self.destination_ports,
                deny_all_traffic_to_endpoint: self.deny_all_traffic_to_endpoint,
            })
        }
    }
}
#[doc(hidden)]
pub type DenyCustomRoutingTrafficInputOperationOutputAlias =
    crate::operation::DenyCustomRoutingTraffic;
#[doc(hidden)]
pub type DenyCustomRoutingTrafficInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DenyCustomRoutingTrafficInput {
    /// Consumes the builder and constructs an Operation<[`DenyCustomRoutingTraffic`](crate::operation::DenyCustomRoutingTraffic)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DenyCustomRoutingTraffic,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DenyCustomRoutingTrafficInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DenyCustomRoutingTrafficInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DenyCustomRoutingTrafficInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DenyCustomRoutingTraffic",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deny_custom_routing_traffic(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DenyCustomRoutingTraffic::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DenyCustomRoutingTraffic",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DenyCustomRoutingTrafficInput`](crate::input::DenyCustomRoutingTrafficInput)
    pub fn builder() -> crate::input::deny_custom_routing_traffic_input::Builder {
        crate::input::deny_custom_routing_traffic_input::Builder::default()
    }
}

/// See [`DeprovisionByoipCidrInput`](crate::input::DeprovisionByoipCidrInput)
pub mod deprovision_byoip_cidr_input {
    /// A builder for [`DeprovisionByoipCidrInput`](crate::input::DeprovisionByoipCidrInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified
        /// when you provisioned the address range.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified
        /// when you provisioned the address range.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`DeprovisionByoipCidrInput`](crate::input::DeprovisionByoipCidrInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeprovisionByoipCidrInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeprovisionByoipCidrInput { cidr: self.cidr })
        }
    }
}
#[doc(hidden)]
pub type DeprovisionByoipCidrInputOperationOutputAlias = crate::operation::DeprovisionByoipCidr;
#[doc(hidden)]
pub type DeprovisionByoipCidrInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeprovisionByoipCidrInput {
    /// Consumes the builder and constructs an Operation<[`DeprovisionByoipCidr`](crate::operation::DeprovisionByoipCidr)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeprovisionByoipCidr,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeprovisionByoipCidrInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeprovisionByoipCidrInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeprovisionByoipCidrInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DeprovisionByoipCidr",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deprovision_byoip_cidr(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeprovisionByoipCidr::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeprovisionByoipCidr",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeprovisionByoipCidrInput`](crate::input::DeprovisionByoipCidrInput)
    pub fn builder() -> crate::input::deprovision_byoip_cidr_input::Builder {
        crate::input::deprovision_byoip_cidr_input::Builder::default()
    }
}

/// See [`DescribeAcceleratorInput`](crate::input::DescribeAcceleratorInput)
pub mod describe_accelerator_input {
    /// A builder for [`DescribeAcceleratorInput`](crate::input::DescribeAcceleratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAcceleratorInput`](crate::input::DescribeAcceleratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAcceleratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAcceleratorInput {
                accelerator_arn: self.accelerator_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAcceleratorInputOperationOutputAlias = crate::operation::DescribeAccelerator;
#[doc(hidden)]
pub type DescribeAcceleratorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAcceleratorInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccelerator`](crate::operation::DescribeAccelerator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccelerator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAcceleratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAcceleratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAcceleratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DescribeAccelerator",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_accelerator(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccelerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccelerator",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAcceleratorInput`](crate::input::DescribeAcceleratorInput)
    pub fn builder() -> crate::input::describe_accelerator_input::Builder {
        crate::input::describe_accelerator_input::Builder::default()
    }
}

/// See [`DescribeAcceleratorAttributesInput`](crate::input::DescribeAcceleratorAttributesInput)
pub mod describe_accelerator_attributes_input {
    /// A builder for [`DescribeAcceleratorAttributesInput`](crate::input::DescribeAcceleratorAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator with the attributes that you want to describe.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator with the attributes that you want to describe.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAcceleratorAttributesInput`](crate::input::DescribeAcceleratorAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAcceleratorAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAcceleratorAttributesInput {
                accelerator_arn: self.accelerator_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAcceleratorAttributesInputOperationOutputAlias =
    crate::operation::DescribeAcceleratorAttributes;
#[doc(hidden)]
pub type DescribeAcceleratorAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAcceleratorAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAcceleratorAttributes`](crate::operation::DescribeAcceleratorAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAcceleratorAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAcceleratorAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAcceleratorAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAcceleratorAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DescribeAcceleratorAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_accelerator_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAcceleratorAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAcceleratorAttributes",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAcceleratorAttributesInput`](crate::input::DescribeAcceleratorAttributesInput)
    pub fn builder() -> crate::input::describe_accelerator_attributes_input::Builder {
        crate::input::describe_accelerator_attributes_input::Builder::default()
    }
}

/// See [`DescribeCustomRoutingAcceleratorInput`](crate::input::DescribeCustomRoutingAcceleratorInput)
pub mod describe_custom_routing_accelerator_input {
    /// A builder for [`DescribeCustomRoutingAcceleratorInput`](crate::input::DescribeCustomRoutingAcceleratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomRoutingAcceleratorInput`](crate::input::DescribeCustomRoutingAcceleratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCustomRoutingAcceleratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCustomRoutingAcceleratorInput {
                accelerator_arn: self.accelerator_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCustomRoutingAcceleratorInputOperationOutputAlias =
    crate::operation::DescribeCustomRoutingAccelerator;
#[doc(hidden)]
pub type DescribeCustomRoutingAcceleratorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCustomRoutingAcceleratorInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCustomRoutingAccelerator`](crate::operation::DescribeCustomRoutingAccelerator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCustomRoutingAccelerator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCustomRoutingAcceleratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCustomRoutingAcceleratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCustomRoutingAcceleratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DescribeCustomRoutingAccelerator",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_custom_routing_accelerator(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCustomRoutingAccelerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCustomRoutingAccelerator",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCustomRoutingAcceleratorInput`](crate::input::DescribeCustomRoutingAcceleratorInput)
    pub fn builder() -> crate::input::describe_custom_routing_accelerator_input::Builder {
        crate::input::describe_custom_routing_accelerator_input::Builder::default()
    }
}

/// See [`DescribeCustomRoutingAcceleratorAttributesInput`](crate::input::DescribeCustomRoutingAcceleratorAttributesInput)
pub mod describe_custom_routing_accelerator_attributes_input {
    /// A builder for [`DescribeCustomRoutingAcceleratorAttributesInput`](crate::input::DescribeCustomRoutingAcceleratorAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomRoutingAcceleratorAttributesInput`](crate::input::DescribeCustomRoutingAcceleratorAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCustomRoutingAcceleratorAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeCustomRoutingAcceleratorAttributesInput {
                    accelerator_arn: self.accelerator_arn,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeCustomRoutingAcceleratorAttributesInputOperationOutputAlias =
    crate::operation::DescribeCustomRoutingAcceleratorAttributes;
#[doc(hidden)]
pub type DescribeCustomRoutingAcceleratorAttributesInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeCustomRoutingAcceleratorAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCustomRoutingAcceleratorAttributes`](crate::operation::DescribeCustomRoutingAcceleratorAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCustomRoutingAcceleratorAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCustomRoutingAcceleratorAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCustomRoutingAcceleratorAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCustomRoutingAcceleratorAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DescribeCustomRoutingAcceleratorAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_custom_routing_accelerator_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCustomRoutingAcceleratorAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCustomRoutingAcceleratorAttributes",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCustomRoutingAcceleratorAttributesInput`](crate::input::DescribeCustomRoutingAcceleratorAttributesInput)
    pub fn builder() -> crate::input::describe_custom_routing_accelerator_attributes_input::Builder
    {
        crate::input::describe_custom_routing_accelerator_attributes_input::Builder::default()
    }
}

/// See [`DescribeCustomRoutingEndpointGroupInput`](crate::input::DescribeCustomRoutingEndpointGroupInput)
pub mod describe_custom_routing_endpoint_group_input {
    /// A builder for [`DescribeCustomRoutingEndpointGroupInput`](crate::input::DescribeCustomRoutingEndpointGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomRoutingEndpointGroupInput`](crate::input::DescribeCustomRoutingEndpointGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCustomRoutingEndpointGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCustomRoutingEndpointGroupInput {
                endpoint_group_arn: self.endpoint_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCustomRoutingEndpointGroupInputOperationOutputAlias =
    crate::operation::DescribeCustomRoutingEndpointGroup;
#[doc(hidden)]
pub type DescribeCustomRoutingEndpointGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCustomRoutingEndpointGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCustomRoutingEndpointGroup`](crate::operation::DescribeCustomRoutingEndpointGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCustomRoutingEndpointGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCustomRoutingEndpointGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCustomRoutingEndpointGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCustomRoutingEndpointGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DescribeCustomRoutingEndpointGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_custom_routing_endpoint_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCustomRoutingEndpointGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCustomRoutingEndpointGroup",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCustomRoutingEndpointGroupInput`](crate::input::DescribeCustomRoutingEndpointGroupInput)
    pub fn builder() -> crate::input::describe_custom_routing_endpoint_group_input::Builder {
        crate::input::describe_custom_routing_endpoint_group_input::Builder::default()
    }
}

/// See [`DescribeCustomRoutingListenerInput`](crate::input::DescribeCustomRoutingListenerInput)
pub mod describe_custom_routing_listener_input {
    /// A builder for [`DescribeCustomRoutingListenerInput`](crate::input::DescribeCustomRoutingListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomRoutingListenerInput`](crate::input::DescribeCustomRoutingListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCustomRoutingListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCustomRoutingListenerInput {
                listener_arn: self.listener_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCustomRoutingListenerInputOperationOutputAlias =
    crate::operation::DescribeCustomRoutingListener;
#[doc(hidden)]
pub type DescribeCustomRoutingListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCustomRoutingListenerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCustomRoutingListener`](crate::operation::DescribeCustomRoutingListener)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCustomRoutingListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCustomRoutingListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCustomRoutingListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCustomRoutingListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DescribeCustomRoutingListener",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_custom_routing_listener(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCustomRoutingListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCustomRoutingListener",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCustomRoutingListenerInput`](crate::input::DescribeCustomRoutingListenerInput)
    pub fn builder() -> crate::input::describe_custom_routing_listener_input::Builder {
        crate::input::describe_custom_routing_listener_input::Builder::default()
    }
}

/// See [`DescribeEndpointGroupInput`](crate::input::DescribeEndpointGroupInput)
pub mod describe_endpoint_group_input {
    /// A builder for [`DescribeEndpointGroupInput`](crate::input::DescribeEndpointGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointGroupInput`](crate::input::DescribeEndpointGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointGroupInput {
                endpoint_group_arn: self.endpoint_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointGroupInputOperationOutputAlias = crate::operation::DescribeEndpointGroup;
#[doc(hidden)]
pub type DescribeEndpointGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEndpointGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpointGroup`](crate::operation::DescribeEndpointGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpointGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEndpointGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEndpointGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEndpointGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DescribeEndpointGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_endpoint_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpointGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpointGroup",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEndpointGroupInput`](crate::input::DescribeEndpointGroupInput)
    pub fn builder() -> crate::input::describe_endpoint_group_input::Builder {
        crate::input::describe_endpoint_group_input::Builder::default()
    }
}

/// See [`DescribeListenerInput`](crate::input::DescribeListenerInput)
pub mod describe_listener_input {
    /// A builder for [`DescribeListenerInput`](crate::input::DescribeListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeListenerInput`](crate::input::DescribeListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeListenerInput {
                listener_arn: self.listener_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeListenerInputOperationOutputAlias = crate::operation::DescribeListener;
#[doc(hidden)]
pub type DescribeListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeListenerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeListener`](crate::operation::DescribeListener)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.DescribeListener",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_listener(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeListener",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeListenerInput`](crate::input::DescribeListenerInput)
    pub fn builder() -> crate::input::describe_listener_input::Builder {
        crate::input::describe_listener_input::Builder::default()
    }
}

/// See [`ListAcceleratorsInput`](crate::input::ListAcceleratorsInput)
pub mod list_accelerators_input {
    /// A builder for [`ListAcceleratorsInput`](crate::input::ListAcceleratorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAcceleratorsInput`](crate::input::ListAcceleratorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAcceleratorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAcceleratorsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAcceleratorsInputOperationOutputAlias = crate::operation::ListAccelerators;
#[doc(hidden)]
pub type ListAcceleratorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAcceleratorsInput {
    /// Consumes the builder and constructs an Operation<[`ListAccelerators`](crate::operation::ListAccelerators)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccelerators,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAcceleratorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAcceleratorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAcceleratorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ListAccelerators",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_accelerators(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccelerators::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccelerators",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAcceleratorsInput`](crate::input::ListAcceleratorsInput)
    pub fn builder() -> crate::input::list_accelerators_input::Builder {
        crate::input::list_accelerators_input::Builder::default()
    }
}

/// See [`ListByoipCidrsInput`](crate::input::ListByoipCidrsInput)
pub mod list_byoip_cidrs_input {
    /// A builder for [`ListByoipCidrsInput`](crate::input::ListByoipCidrsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make
        /// another call with the returned <code>nextToken</code> value.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make
        /// another call with the returned <code>nextToken</code> value.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListByoipCidrsInput`](crate::input::ListByoipCidrsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListByoipCidrsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListByoipCidrsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListByoipCidrsInputOperationOutputAlias = crate::operation::ListByoipCidrs;
#[doc(hidden)]
pub type ListByoipCidrsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListByoipCidrsInput {
    /// Consumes the builder and constructs an Operation<[`ListByoipCidrs`](crate::operation::ListByoipCidrs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListByoipCidrs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListByoipCidrsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListByoipCidrsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListByoipCidrsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ListByoipCidrs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_byoip_cidrs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListByoipCidrs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListByoipCidrs",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListByoipCidrsInput`](crate::input::ListByoipCidrsInput)
    pub fn builder() -> crate::input::list_byoip_cidrs_input::Builder {
        crate::input::list_byoip_cidrs_input::Builder::default()
    }
}

/// See [`ListCustomRoutingAcceleratorsInput`](crate::input::ListCustomRoutingAcceleratorsInput)
pub mod list_custom_routing_accelerators_input {
    /// A builder for [`ListCustomRoutingAcceleratorsInput`](crate::input::ListCustomRoutingAcceleratorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomRoutingAcceleratorsInput`](crate::input::ListCustomRoutingAcceleratorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCustomRoutingAcceleratorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCustomRoutingAcceleratorsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCustomRoutingAcceleratorsInputOperationOutputAlias =
    crate::operation::ListCustomRoutingAccelerators;
#[doc(hidden)]
pub type ListCustomRoutingAcceleratorsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCustomRoutingAcceleratorsInput {
    /// Consumes the builder and constructs an Operation<[`ListCustomRoutingAccelerators`](crate::operation::ListCustomRoutingAccelerators)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCustomRoutingAccelerators,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCustomRoutingAcceleratorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCustomRoutingAcceleratorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCustomRoutingAcceleratorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ListCustomRoutingAccelerators",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_custom_routing_accelerators(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCustomRoutingAccelerators::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCustomRoutingAccelerators",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCustomRoutingAcceleratorsInput`](crate::input::ListCustomRoutingAcceleratorsInput)
    pub fn builder() -> crate::input::list_custom_routing_accelerators_input::Builder {
        crate::input::list_custom_routing_accelerators_input::Builder::default()
    }
}

/// See [`ListCustomRoutingEndpointGroupsInput`](crate::input::ListCustomRoutingEndpointGroupsInput)
pub mod list_custom_routing_endpoint_groups_input {
    /// A builder for [`ListCustomRoutingEndpointGroupsInput`](crate::input::ListCustomRoutingEndpointGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener to list endpoint groups for.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to list endpoint groups for.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomRoutingEndpointGroupsInput`](crate::input::ListCustomRoutingEndpointGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCustomRoutingEndpointGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCustomRoutingEndpointGroupsInput {
                listener_arn: self.listener_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCustomRoutingEndpointGroupsInputOperationOutputAlias =
    crate::operation::ListCustomRoutingEndpointGroups;
#[doc(hidden)]
pub type ListCustomRoutingEndpointGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCustomRoutingEndpointGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListCustomRoutingEndpointGroups`](crate::operation::ListCustomRoutingEndpointGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCustomRoutingEndpointGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCustomRoutingEndpointGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCustomRoutingEndpointGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCustomRoutingEndpointGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ListCustomRoutingEndpointGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_custom_routing_endpoint_groups(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCustomRoutingEndpointGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCustomRoutingEndpointGroups",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCustomRoutingEndpointGroupsInput`](crate::input::ListCustomRoutingEndpointGroupsInput)
    pub fn builder() -> crate::input::list_custom_routing_endpoint_groups_input::Builder {
        crate::input::list_custom_routing_endpoint_groups_input::Builder::default()
    }
}

/// See [`ListCustomRoutingListenersInput`](crate::input::ListCustomRoutingListenersInput)
pub mod list_custom_routing_listeners_input {
    /// A builder for [`ListCustomRoutingListenersInput`](crate::input::ListCustomRoutingListenersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list listeners for.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list listeners for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomRoutingListenersInput`](crate::input::ListCustomRoutingListenersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCustomRoutingListenersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCustomRoutingListenersInput {
                accelerator_arn: self.accelerator_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCustomRoutingListenersInputOperationOutputAlias =
    crate::operation::ListCustomRoutingListeners;
#[doc(hidden)]
pub type ListCustomRoutingListenersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCustomRoutingListenersInput {
    /// Consumes the builder and constructs an Operation<[`ListCustomRoutingListeners`](crate::operation::ListCustomRoutingListeners)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCustomRoutingListeners,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCustomRoutingListenersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCustomRoutingListenersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCustomRoutingListenersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ListCustomRoutingListeners",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_custom_routing_listeners(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCustomRoutingListeners::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCustomRoutingListeners",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCustomRoutingListenersInput`](crate::input::ListCustomRoutingListenersInput)
    pub fn builder() -> crate::input::list_custom_routing_listeners_input::Builder {
        crate::input::list_custom_routing_listeners_input::Builder::default()
    }
}

/// See [`ListCustomRoutingPortMappingsInput`](crate::input::ListCustomRoutingPortMappingsInput)
pub mod list_custom_routing_port_mappings_input {
    /// A builder for [`ListCustomRoutingPortMappingsInput`](crate::input::ListCustomRoutingPortMappingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomRoutingPortMappingsInput`](crate::input::ListCustomRoutingPortMappingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCustomRoutingPortMappingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCustomRoutingPortMappingsInput {
                accelerator_arn: self.accelerator_arn,
                endpoint_group_arn: self.endpoint_group_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCustomRoutingPortMappingsInputOperationOutputAlias =
    crate::operation::ListCustomRoutingPortMappings;
#[doc(hidden)]
pub type ListCustomRoutingPortMappingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCustomRoutingPortMappingsInput {
    /// Consumes the builder and constructs an Operation<[`ListCustomRoutingPortMappings`](crate::operation::ListCustomRoutingPortMappings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCustomRoutingPortMappings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCustomRoutingPortMappingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCustomRoutingPortMappingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCustomRoutingPortMappingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ListCustomRoutingPortMappings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_custom_routing_port_mappings(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCustomRoutingPortMappings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCustomRoutingPortMappings",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCustomRoutingPortMappingsInput`](crate::input::ListCustomRoutingPortMappingsInput)
    pub fn builder() -> crate::input::list_custom_routing_port_mappings_input::Builder {
        crate::input::list_custom_routing_port_mappings_input::Builder::default()
    }
}

/// See [`ListCustomRoutingPortMappingsByDestinationInput`](crate::input::ListCustomRoutingPortMappingsByDestinationInput)
pub mod list_custom_routing_port_mappings_by_destination_input {
    /// A builder for [`ListCustomRoutingPortMappingsByDestinationInput`](crate::input::ListCustomRoutingPortMappingsByDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_id: std::option::Option<std::string::String>,
        pub(crate) destination_address: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
        pub fn endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
        pub fn set_endpoint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_id = input;
            self
        }
        /// <p>The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port
        /// mappings.</p>
        pub fn destination_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_address = Some(input.into());
            self
        }
        /// <p>The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port
        /// mappings.</p>
        pub fn set_destination_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_address = input;
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomRoutingPortMappingsByDestinationInput`](crate::input::ListCustomRoutingPortMappingsByDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCustomRoutingPortMappingsByDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListCustomRoutingPortMappingsByDestinationInput {
                    endpoint_id: self.endpoint_id,
                    destination_address: self.destination_address,
                    max_results: self.max_results,
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListCustomRoutingPortMappingsByDestinationInputOperationOutputAlias =
    crate::operation::ListCustomRoutingPortMappingsByDestination;
#[doc(hidden)]
pub type ListCustomRoutingPortMappingsByDestinationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ListCustomRoutingPortMappingsByDestinationInput {
    /// Consumes the builder and constructs an Operation<[`ListCustomRoutingPortMappingsByDestination`](crate::operation::ListCustomRoutingPortMappingsByDestination)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCustomRoutingPortMappingsByDestination,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCustomRoutingPortMappingsByDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCustomRoutingPortMappingsByDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCustomRoutingPortMappingsByDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ListCustomRoutingPortMappingsByDestination",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_custom_routing_port_mappings_by_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCustomRoutingPortMappingsByDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCustomRoutingPortMappingsByDestination",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCustomRoutingPortMappingsByDestinationInput`](crate::input::ListCustomRoutingPortMappingsByDestinationInput)
    pub fn builder() -> crate::input::list_custom_routing_port_mappings_by_destination_input::Builder
    {
        crate::input::list_custom_routing_port_mappings_by_destination_input::Builder::default()
    }
}

/// See [`ListEndpointGroupsInput`](crate::input::ListEndpointGroupsInput)
pub mod list_endpoint_groups_input {
    /// A builder for [`ListEndpointGroupsInput`](crate::input::ListEndpointGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEndpointGroupsInput`](crate::input::ListEndpointGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEndpointGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEndpointGroupsInput {
                listener_arn: self.listener_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEndpointGroupsInputOperationOutputAlias = crate::operation::ListEndpointGroups;
#[doc(hidden)]
pub type ListEndpointGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEndpointGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListEndpointGroups`](crate::operation::ListEndpointGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEndpointGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEndpointGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEndpointGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEndpointGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ListEndpointGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_endpoint_groups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEndpointGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEndpointGroups",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEndpointGroupsInput`](crate::input::ListEndpointGroupsInput)
    pub fn builder() -> crate::input::list_endpoint_groups_input::Builder {
        crate::input::list_endpoint_groups_input::Builder::default()
    }
}

/// See [`ListListenersInput`](crate::input::ListListenersInput)
pub mod list_listeners_input {
    /// A builder for [`ListListenersInput`](crate::input::ListListenersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. You receive this token from a previous call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListListenersInput`](crate::input::ListListenersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListListenersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListListenersInput {
                accelerator_arn: self.accelerator_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListListenersInputOperationOutputAlias = crate::operation::ListListeners;
#[doc(hidden)]
pub type ListListenersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListListenersInput {
    /// Consumes the builder and constructs an Operation<[`ListListeners`](crate::operation::ListListeners)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListListeners,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListListenersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListListenersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListListenersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ListListeners",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_listeners(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListListeners::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListListeners",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListListenersInput`](crate::input::ListListenersInput)
    pub fn builder() -> crate::input::list_listeners_input::Builder {
        crate::input::list_listeners_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN uniquely identifies an accelerator.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN uniquely identifies an accelerator.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ProvisionByoipCidrInput`](crate::input::ProvisionByoipCidrInput)
pub mod provision_byoip_cidr_input {
    /// A builder for [`ProvisionByoipCidrInput`](crate::input::ProvisionByoipCidrInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
        pub(crate) cidr_authorization_context:
            std::option::Option<crate::model::CidrAuthorizationContext>,
    }
    impl Builder {
        /// <p>The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can
        /// specify is /24. The address range cannot overlap with another address range that you've brought
        /// to this or another Region.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can
        /// specify is /24. The address range cannot overlap with another address range that you've brought
        /// to this or another Region.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// <p>A signed document that proves that you are authorized to bring the specified IP address range to
        /// Amazon using BYOIP.
        /// </p>
        pub fn cidr_authorization_context(
            mut self,
            input: crate::model::CidrAuthorizationContext,
        ) -> Self {
            self.cidr_authorization_context = Some(input);
            self
        }
        /// <p>A signed document that proves that you are authorized to bring the specified IP address range to
        /// Amazon using BYOIP.
        /// </p>
        pub fn set_cidr_authorization_context(
            mut self,
            input: std::option::Option<crate::model::CidrAuthorizationContext>,
        ) -> Self {
            self.cidr_authorization_context = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionByoipCidrInput`](crate::input::ProvisionByoipCidrInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ProvisionByoipCidrInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ProvisionByoipCidrInput {
                cidr: self.cidr,
                cidr_authorization_context: self.cidr_authorization_context,
            })
        }
    }
}
#[doc(hidden)]
pub type ProvisionByoipCidrInputOperationOutputAlias = crate::operation::ProvisionByoipCidr;
#[doc(hidden)]
pub type ProvisionByoipCidrInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ProvisionByoipCidrInput {
    /// Consumes the builder and constructs an Operation<[`ProvisionByoipCidr`](crate::operation::ProvisionByoipCidr)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ProvisionByoipCidr,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ProvisionByoipCidrInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ProvisionByoipCidrInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ProvisionByoipCidrInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.ProvisionByoipCidr",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_provision_byoip_cidr(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ProvisionByoipCidr::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ProvisionByoipCidr",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ProvisionByoipCidrInput`](crate::input::ProvisionByoipCidrInput)
    pub fn builder() -> crate::input::provision_byoip_cidr_input::Builder {
        crate::input::provision_byoip_cidr_input::Builder::default()
    }
}

/// See [`RemoveCustomRoutingEndpointsInput`](crate::input::RemoveCustomRoutingEndpointsInput)
pub mod remove_custom_routing_endpoints_input {
    /// A builder for [`RemoveCustomRoutingEndpointsInput`](crate::input::RemoveCustomRoutingEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `endpoint_ids`.
        ///
        /// To override the contents of this collection use [`set_endpoint_ids`](Self::set_endpoint_ids).
        ///
        /// <p>The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC)
        /// subnet IDs. </p>
        pub fn endpoint_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.endpoint_ids.unwrap_or_default();
            v.push(input.into());
            self.endpoint_ids = Some(v);
            self
        }
        /// <p>The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC)
        /// subnet IDs. </p>
        pub fn set_endpoint_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.endpoint_ids = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveCustomRoutingEndpointsInput`](crate::input::RemoveCustomRoutingEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveCustomRoutingEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveCustomRoutingEndpointsInput {
                endpoint_ids: self.endpoint_ids,
                endpoint_group_arn: self.endpoint_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveCustomRoutingEndpointsInputOperationOutputAlias =
    crate::operation::RemoveCustomRoutingEndpoints;
#[doc(hidden)]
pub type RemoveCustomRoutingEndpointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveCustomRoutingEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveCustomRoutingEndpoints`](crate::operation::RemoveCustomRoutingEndpoints)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveCustomRoutingEndpoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveCustomRoutingEndpointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveCustomRoutingEndpointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveCustomRoutingEndpointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.RemoveCustomRoutingEndpoints",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_custom_routing_endpoints(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveCustomRoutingEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveCustomRoutingEndpoints",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveCustomRoutingEndpointsInput`](crate::input::RemoveCustomRoutingEndpointsInput)
    pub fn builder() -> crate::input::remove_custom_routing_endpoints_input::Builder {
        crate::input::remove_custom_routing_endpoints_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to add tags to. An ARN uniquely identifies a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to add tags to. An ARN uniquely identifies a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to a resource. A tag consists of a key and a value that you define.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to a resource. A tag consists of a key and a value that you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to remove tags from. An ARN uniquely identifies a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to remove tags from. An ARN uniquely identifies a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key pairs that you want to remove from the specified resources.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag key pairs that you want to remove from the specified resources.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAcceleratorInput`](crate::input::UpdateAcceleratorInput)
pub mod update_accelerator_input {
    /// A builder for [`UpdateAcceleratorInput`](crate::input::UpdateAcceleratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The IP address type, which must be IPv4.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type, which must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAcceleratorInput`](crate::input::UpdateAcceleratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAcceleratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAcceleratorInput {
                accelerator_arn: self.accelerator_arn,
                name: self.name,
                ip_address_type: self.ip_address_type,
                enabled: self.enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAcceleratorInputOperationOutputAlias = crate::operation::UpdateAccelerator;
#[doc(hidden)]
pub type UpdateAcceleratorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAcceleratorInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAccelerator`](crate::operation::UpdateAccelerator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAccelerator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAcceleratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAcceleratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAcceleratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.UpdateAccelerator",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_accelerator(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAccelerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAccelerator",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAcceleratorInput`](crate::input::UpdateAcceleratorInput)
    pub fn builder() -> crate::input::update_accelerator_input::Builder {
        crate::input::update_accelerator_input::Builder::default()
    }
}

/// See [`UpdateAcceleratorAttributesInput`](crate::input::UpdateAcceleratorAttributesInput)
pub mod update_accelerator_attributes_input {
    /// A builder for [`UpdateAcceleratorAttributesInput`](crate::input::UpdateAcceleratorAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) flow_logs_enabled: std::option::Option<bool>,
        pub(crate) flow_logs_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) flow_logs_s3_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator that you want to update.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator that you want to update.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn flow_logs_enabled(mut self, input: bool) -> Self {
            self.flow_logs_enabled = Some(input);
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_flow_logs_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.flow_logs_enabled = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn flow_logs_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_logs_s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn set_flow_logs_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_logs_s3_bucket = input;
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
        pub fn flow_logs_s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_logs_s3_prefix = Some(input.into());
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
        pub fn set_flow_logs_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_logs_s3_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAcceleratorAttributesInput`](crate::input::UpdateAcceleratorAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAcceleratorAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAcceleratorAttributesInput {
                accelerator_arn: self.accelerator_arn,
                flow_logs_enabled: self.flow_logs_enabled,
                flow_logs_s3_bucket: self.flow_logs_s3_bucket,
                flow_logs_s3_prefix: self.flow_logs_s3_prefix,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAcceleratorAttributesInputOperationOutputAlias =
    crate::operation::UpdateAcceleratorAttributes;
#[doc(hidden)]
pub type UpdateAcceleratorAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAcceleratorAttributesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAcceleratorAttributes`](crate::operation::UpdateAcceleratorAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAcceleratorAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAcceleratorAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAcceleratorAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAcceleratorAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.UpdateAcceleratorAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_accelerator_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAcceleratorAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAcceleratorAttributes",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAcceleratorAttributesInput`](crate::input::UpdateAcceleratorAttributesInput)
    pub fn builder() -> crate::input::update_accelerator_attributes_input::Builder {
        crate::input::update_accelerator_attributes_input::Builder::default()
    }
}

/// See [`UpdateCustomRoutingAcceleratorInput`](crate::input::UpdateCustomRoutingAcceleratorInput)
pub mod update_custom_routing_accelerator_input {
    /// A builder for [`UpdateCustomRoutingAcceleratorInput`](crate::input::UpdateCustomRoutingAcceleratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
        /// hyphens (-), and must not begin or end with a hyphen.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The value for the address type must be IPv4.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
        /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomRoutingAcceleratorInput`](crate::input::UpdateCustomRoutingAcceleratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCustomRoutingAcceleratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCustomRoutingAcceleratorInput {
                accelerator_arn: self.accelerator_arn,
                name: self.name,
                ip_address_type: self.ip_address_type,
                enabled: self.enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCustomRoutingAcceleratorInputOperationOutputAlias =
    crate::operation::UpdateCustomRoutingAccelerator;
#[doc(hidden)]
pub type UpdateCustomRoutingAcceleratorInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateCustomRoutingAcceleratorInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCustomRoutingAccelerator`](crate::operation::UpdateCustomRoutingAccelerator)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCustomRoutingAccelerator,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCustomRoutingAcceleratorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCustomRoutingAcceleratorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCustomRoutingAcceleratorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.UpdateCustomRoutingAccelerator",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_custom_routing_accelerator(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCustomRoutingAccelerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCustomRoutingAccelerator",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCustomRoutingAcceleratorInput`](crate::input::UpdateCustomRoutingAcceleratorInput)
    pub fn builder() -> crate::input::update_custom_routing_accelerator_input::Builder {
        crate::input::update_custom_routing_accelerator_input::Builder::default()
    }
}

/// See [`UpdateCustomRoutingAcceleratorAttributesInput`](crate::input::UpdateCustomRoutingAcceleratorAttributesInput)
pub mod update_custom_routing_accelerator_attributes_input {
    /// A builder for [`UpdateCustomRoutingAcceleratorAttributesInput`](crate::input::UpdateCustomRoutingAcceleratorAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accelerator_arn: std::option::Option<std::string::String>,
        pub(crate) flow_logs_enabled: std::option::Option<bool>,
        pub(crate) flow_logs_s3_bucket: std::option::Option<std::string::String>,
        pub(crate) flow_logs_s3_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.</p>
        pub fn accelerator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.accelerator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.</p>
        pub fn set_accelerator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accelerator_arn = input;
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn flow_logs_enabled(mut self, input: bool) -> Self {
            self.flow_logs_enabled = Some(input);
            self
        }
        /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
        /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
        /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_flow_logs_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.flow_logs_enabled = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn flow_logs_s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_logs_s3_bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
        /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
        /// bucket.</p>
        pub fn set_flow_logs_s3_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_logs_s3_bucket = input;
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
        pub fn flow_logs_s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_logs_s3_prefix = Some(input.into());
            self
        }
        /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
        /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
        /// <p>If you don’t specify a prefix, the flow logs are stored in the
        /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
        /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
        pub fn set_flow_logs_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_logs_s3_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomRoutingAcceleratorAttributesInput`](crate::input::UpdateCustomRoutingAcceleratorAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCustomRoutingAcceleratorAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::UpdateCustomRoutingAcceleratorAttributesInput {
                    accelerator_arn: self.accelerator_arn,
                    flow_logs_enabled: self.flow_logs_enabled,
                    flow_logs_s3_bucket: self.flow_logs_s3_bucket,
                    flow_logs_s3_prefix: self.flow_logs_s3_prefix,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type UpdateCustomRoutingAcceleratorAttributesInputOperationOutputAlias =
    crate::operation::UpdateCustomRoutingAcceleratorAttributes;
#[doc(hidden)]
pub type UpdateCustomRoutingAcceleratorAttributesInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl UpdateCustomRoutingAcceleratorAttributesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCustomRoutingAcceleratorAttributes`](crate::operation::UpdateCustomRoutingAcceleratorAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCustomRoutingAcceleratorAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCustomRoutingAcceleratorAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCustomRoutingAcceleratorAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCustomRoutingAcceleratorAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.UpdateCustomRoutingAcceleratorAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_custom_routing_accelerator_attributes(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCustomRoutingAcceleratorAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCustomRoutingAcceleratorAttributes",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCustomRoutingAcceleratorAttributesInput`](crate::input::UpdateCustomRoutingAcceleratorAttributesInput)
    pub fn builder() -> crate::input::update_custom_routing_accelerator_attributes_input::Builder {
        crate::input::update_custom_routing_accelerator_attributes_input::Builder::default()
    }
}

/// See [`UpdateCustomRoutingListenerInput`](crate::input::UpdateCustomRoutingListenerInput)
pub mod update_custom_routing_listener_input {
    /// A builder for [`UpdateCustomRoutingListenerInput`](crate::input::UpdateCustomRoutingListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Appends an item to `port_ranges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The updated port range to support for connections from clients to your accelerator. If you remove ports that are
        /// currently being used by a subnet endpoint, the call fails.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
        /// endpoints for custom routing accelerators</a>.</p>
        pub fn port_ranges(mut self, input: impl Into<crate::model::PortRange>) -> Self {
            let mut v = self.port_ranges.unwrap_or_default();
            v.push(input.into());
            self.port_ranges = Some(v);
            self
        }
        /// <p>The updated port range to support for connections from clients to your accelerator. If you remove ports that are
        /// currently being used by a subnet endpoint, the call fails.</p>
        /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
        /// endpoints for custom routing accelerators</a>.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.port_ranges = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCustomRoutingListenerInput`](crate::input::UpdateCustomRoutingListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCustomRoutingListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCustomRoutingListenerInput {
                listener_arn: self.listener_arn,
                port_ranges: self.port_ranges,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCustomRoutingListenerInputOperationOutputAlias =
    crate::operation::UpdateCustomRoutingListener;
#[doc(hidden)]
pub type UpdateCustomRoutingListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateCustomRoutingListenerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCustomRoutingListener`](crate::operation::UpdateCustomRoutingListener)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCustomRoutingListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCustomRoutingListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCustomRoutingListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCustomRoutingListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.UpdateCustomRoutingListener",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_custom_routing_listener(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCustomRoutingListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCustomRoutingListener",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCustomRoutingListenerInput`](crate::input::UpdateCustomRoutingListenerInput)
    pub fn builder() -> crate::input::update_custom_routing_listener_input::Builder {
        crate::input::update_custom_routing_listener_input::Builder::default()
    }
}

/// See [`UpdateEndpointGroupInput`](crate::input::UpdateEndpointGroupInput)
pub mod update_endpoint_group_input {
    /// A builder for [`UpdateEndpointGroupInput`](crate::input::UpdateEndpointGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_group_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_configurations:
            std::option::Option<std::vec::Vec<crate::model::EndpointConfiguration>>,
        pub(crate) traffic_dial_percentage: std::option::Option<f32>,
        pub(crate) health_check_port: std::option::Option<i32>,
        pub(crate) health_check_protocol: std::option::Option<crate::model::HealthCheckProtocol>,
        pub(crate) health_check_path: std::option::Option<std::string::String>,
        pub(crate) health_check_interval_seconds: std::option::Option<i32>,
        pub(crate) threshold_count: std::option::Option<i32>,
        pub(crate) port_overrides: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn endpoint_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
        pub fn set_endpoint_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_group_arn = input;
            self
        }
        /// Appends an item to `endpoint_configurations`.
        ///
        /// To override the contents of this collection use [`set_endpoint_configurations`](Self::set_endpoint_configurations).
        ///
        /// <p>The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.</p>
        pub fn endpoint_configurations(
            mut self,
            input: impl Into<crate::model::EndpointConfiguration>,
        ) -> Self {
            let mut v = self.endpoint_configurations.unwrap_or_default();
            v.push(input.into());
            self.endpoint_configurations = Some(v);
            self
        }
        /// <p>The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.</p>
        pub fn set_endpoint_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointConfiguration>>,
        ) -> Self {
            self.endpoint_configurations = input;
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
        /// this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
        /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn traffic_dial_percentage(mut self, input: f32) -> Self {
            self.traffic_dial_percentage = Some(input);
            self
        }
        /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
        /// this listener. </p>
        /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
        /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
        /// <p>The default value is 100.</p>
        pub fn set_traffic_dial_percentage(mut self, input: std::option::Option<f32>) -> Self {
            self.traffic_dial_percentage = input;
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
        /// is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses
        /// the first port in the list.</p>
        pub fn health_check_port(mut self, input: i32) -> Self {
            self.health_check_port = Some(input);
            self
        }
        /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
        /// is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses
        /// the first port in the list.</p>
        pub fn set_health_check_port(mut self, input: std::option::Option<i32>) -> Self {
            self.health_check_port = input;
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
        /// value is TCP.</p>
        pub fn health_check_protocol(mut self, input: crate::model::HealthCheckProtocol) -> Self {
            self.health_check_protocol = Some(input);
            self
        }
        /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
        /// value is TCP.</p>
        pub fn set_health_check_protocol(
            mut self,
            input: std::option::Option<crate::model::HealthCheckProtocol>,
        ) -> Self {
            self.health_check_protocol = input;
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
        /// default value is slash (/).</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_path = Some(input.into());
            self
        }
        /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
        /// default value is slash (/).</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_path = input;
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn health_check_interval_seconds(mut self, input: i32) -> Self {
            self.health_check_interval_seconds = Some(input);
            self
        }
        /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
        pub fn set_health_check_interval_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.health_check_interval_seconds = input;
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
        /// unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn threshold_count(mut self, input: i32) -> Self {
            self.threshold_count = Some(input);
            self
        }
        /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
        /// unhealthy endpoint to healthy. The default value is 3.</p>
        pub fn set_threshold_count(mut self, input: std::option::Option<i32>) -> Self {
            self.threshold_count = input;
            self
        }
        /// Appends an item to `port_overrides`.
        ///
        /// To override the contents of this collection use [`set_port_overrides`](Self::set_port_overrides).
        ///
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
        /// For example, you can create a port override in which the listener
        /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
        /// and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
        /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn port_overrides(mut self, input: impl Into<crate::model::PortOverride>) -> Self {
            let mut v = self.port_overrides.unwrap_or_default();
            v.push(input.into());
            self.port_overrides = Some(v);
            self
        }
        /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
        /// For example, you can create a port override in which the listener
        /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
        /// and 1443, respectively, on the endpoints.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
        /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
        pub fn set_port_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
        ) -> Self {
            self.port_overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEndpointGroupInput`](crate::input::UpdateEndpointGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEndpointGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEndpointGroupInput {
                endpoint_group_arn: self.endpoint_group_arn,
                endpoint_configurations: self.endpoint_configurations,
                traffic_dial_percentage: self.traffic_dial_percentage,
                health_check_port: self.health_check_port,
                health_check_protocol: self.health_check_protocol,
                health_check_path: self.health_check_path,
                health_check_interval_seconds: self.health_check_interval_seconds,
                threshold_count: self.threshold_count,
                port_overrides: self.port_overrides,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEndpointGroupInputOperationOutputAlias = crate::operation::UpdateEndpointGroup;
#[doc(hidden)]
pub type UpdateEndpointGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateEndpointGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEndpointGroup`](crate::operation::UpdateEndpointGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEndpointGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEndpointGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEndpointGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEndpointGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.UpdateEndpointGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_endpoint_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEndpointGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEndpointGroup",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEndpointGroupInput`](crate::input::UpdateEndpointGroupInput)
    pub fn builder() -> crate::input::update_endpoint_group_input::Builder {
        crate::input::update_endpoint_group_input::Builder::default()
    }
}

/// See [`UpdateListenerInput`](crate::input::UpdateListenerInput)
pub mod update_listener_input {
    /// A builder for [`UpdateListenerInput`](crate::input::UpdateListenerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) listener_arn: std::option::Option<std::string::String>,
        pub(crate) port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) client_affinity: std::option::Option<crate::model::ClientAffinity>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn listener_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
        pub fn set_listener_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.listener_arn = input;
            self
        }
        /// Appends an item to `port_ranges`.
        ///
        /// To override the contents of this collection use [`set_port_ranges`](Self::set_port_ranges).
        ///
        /// <p>The updated list of port ranges for the connections from clients to the accelerator.</p>
        pub fn port_ranges(mut self, input: impl Into<crate::model::PortRange>) -> Self {
            let mut v = self.port_ranges.unwrap_or_default();
            v.push(input.into());
            self.port_ranges = Some(v);
            self
        }
        /// <p>The updated list of port ranges for the connections from clients to the accelerator.</p>
        pub fn set_port_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
        ) -> Self {
            self.port_ranges = input;
            self
        }
        /// <p>The updated protocol for the connections from clients to the accelerator.</p>
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The updated protocol for the connections from clients to the accelerator.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
        /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
        /// route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
        /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
        /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
        /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
        /// be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
        /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
        /// source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn client_affinity(mut self, input: crate::model::ClientAffinity) -> Self {
            self.client_affinity = Some(input);
            self
        }
        /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
        /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
        /// route each client to the same specific endpoint.</p>
        /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
        /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
        /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
        /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
        /// be always routed to the same endpoint because the hash value changes. </p>
        /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
        /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
        /// source (client) IP address and destination IP address—to select the hash value.</p>
        /// <p>The default value is <code>NONE</code>.</p>
        pub fn set_client_affinity(
            mut self,
            input: std::option::Option<crate::model::ClientAffinity>,
        ) -> Self {
            self.client_affinity = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateListenerInput`](crate::input::UpdateListenerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateListenerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateListenerInput {
                listener_arn: self.listener_arn,
                port_ranges: self.port_ranges,
                protocol: self.protocol,
                client_affinity: self.client_affinity,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateListenerInputOperationOutputAlias = crate::operation::UpdateListener;
#[doc(hidden)]
pub type UpdateListenerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateListenerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateListener`](crate::operation::UpdateListener)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateListener,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateListenerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateListenerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateListenerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.UpdateListener",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_listener(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateListener::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateListener",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateListenerInput`](crate::input::UpdateListenerInput)
    pub fn builder() -> crate::input::update_listener_input::Builder {
        crate::input::update_listener_input::Builder::default()
    }
}

/// See [`WithdrawByoipCidrInput`](crate::input::WithdrawByoipCidrInput)
pub mod withdraw_byoip_cidr_input {
    /// A builder for [`WithdrawByoipCidrInput`](crate::input::WithdrawByoipCidrInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The address range, in CIDR notation.</p>
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// <p>The address range, in CIDR notation.</p>
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`WithdrawByoipCidrInput`](crate::input::WithdrawByoipCidrInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::WithdrawByoipCidrInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::WithdrawByoipCidrInput { cidr: self.cidr })
        }
    }
}
#[doc(hidden)]
pub type WithdrawByoipCidrInputOperationOutputAlias = crate::operation::WithdrawByoipCidr;
#[doc(hidden)]
pub type WithdrawByoipCidrInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl WithdrawByoipCidrInput {
    /// Consumes the builder and constructs an Operation<[`WithdrawByoipCidr`](crate::operation::WithdrawByoipCidr)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::WithdrawByoipCidr,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::WithdrawByoipCidrInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::WithdrawByoipCidrInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::WithdrawByoipCidrInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "GlobalAccelerator_V20180706.WithdrawByoipCidr",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_withdraw_byoip_cidr(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::WithdrawByoipCidr::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "WithdrawByoipCidr",
            "globalaccelerator",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`WithdrawByoipCidrInput`](crate::input::WithdrawByoipCidrInput)
    pub fn builder() -> crate::input::withdraw_byoip_cidr_input::Builder {
        crate::input::withdraw_byoip_cidr_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WithdrawByoipCidrInput {
    /// <p>The address range, in CIDR notation.</p>
    pub cidr: std::option::Option<std::string::String>,
}
impl WithdrawByoipCidrInput {
    /// <p>The address range, in CIDR notation.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
}
impl std::fmt::Debug for WithdrawByoipCidrInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WithdrawByoipCidrInput");
        formatter.field("cidr", &self.cidr);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The updated list of port ranges for the connections from clients to the accelerator.</p>
    pub port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    /// <p>The updated protocol for the connections from clients to the accelerator.</p>
    pub protocol: std::option::Option<crate::model::Protocol>,
    /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
    /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
    /// route each client to the same specific endpoint.</p>
    /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
    /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
    /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
    /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
    /// be always routed to the same endpoint because the hash value changes. </p>
    /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
    /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
    /// source (client) IP address and destination IP address—to select the hash value.</p>
    /// <p>The default value is <code>NONE</code>.</p>
    pub client_affinity: std::option::Option<crate::model::ClientAffinity>,
}
impl UpdateListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
    /// <p>The updated list of port ranges for the connections from clients to the accelerator.</p>
    pub fn port_ranges(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.port_ranges.as_deref()
    }
    /// <p>The updated protocol for the connections from clients to the accelerator.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::Protocol> {
        self.protocol.as_ref()
    }
    /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
    /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
    /// route each client to the same specific endpoint.</p>
    /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
    /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
    /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
    /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
    /// be always routed to the same endpoint because the hash value changes. </p>
    /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
    /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
    /// source (client) IP address and destination IP address—to select the hash value.</p>
    /// <p>The default value is <code>NONE</code>.</p>
    pub fn client_affinity(&self) -> std::option::Option<&crate::model::ClientAffinity> {
        self.client_affinity.as_ref()
    }
}
impl std::fmt::Debug for UpdateListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateListenerInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("port_ranges", &self.port_ranges);
        formatter.field("protocol", &self.protocol);
        formatter.field("client_affinity", &self.client_affinity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
    /// <p>The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.</p>
    pub endpoint_configurations:
        std::option::Option<std::vec::Vec<crate::model::EndpointConfiguration>>,
    /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
    /// this listener. </p>
    /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
    /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
    /// <p>The default value is 100.</p>
    pub traffic_dial_percentage: std::option::Option<f32>,
    /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
    /// is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses
    /// the first port in the list.</p>
    pub health_check_port: std::option::Option<i32>,
    /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
    /// value is TCP.</p>
    pub health_check_protocol: std::option::Option<crate::model::HealthCheckProtocol>,
    /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
    /// default value is slash (/).</p>
    pub health_check_path: std::option::Option<std::string::String>,
    /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
    pub health_check_interval_seconds: std::option::Option<i32>,
    /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
    /// unhealthy endpoint to healthy. The default value is 3.</p>
    pub threshold_count: std::option::Option<i32>,
    /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
    /// For example, you can create a port override in which the listener
    /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
    /// and 1443, respectively, on the endpoints.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
    /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub port_overrides: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
}
impl UpdateEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
    /// <p>The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.</p>
    pub fn endpoint_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::EndpointConfiguration]> {
        self.endpoint_configurations.as_deref()
    }
    /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
    /// this listener. </p>
    /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
    /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
    /// <p>The default value is 100.</p>
    pub fn traffic_dial_percentage(&self) -> std::option::Option<f32> {
        self.traffic_dial_percentage
    }
    /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
    /// is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses
    /// the first port in the list.</p>
    pub fn health_check_port(&self) -> std::option::Option<i32> {
        self.health_check_port
    }
    /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
    /// value is TCP.</p>
    pub fn health_check_protocol(&self) -> std::option::Option<&crate::model::HealthCheckProtocol> {
        self.health_check_protocol.as_ref()
    }
    /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
    /// default value is slash (/).</p>
    pub fn health_check_path(&self) -> std::option::Option<&str> {
        self.health_check_path.as_deref()
    }
    /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
    pub fn health_check_interval_seconds(&self) -> std::option::Option<i32> {
        self.health_check_interval_seconds
    }
    /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
    /// unhealthy endpoint to healthy. The default value is 3.</p>
    pub fn threshold_count(&self) -> std::option::Option<i32> {
        self.threshold_count
    }
    /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
    /// For example, you can create a port override in which the listener
    /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
    /// and 1443, respectively, on the endpoints.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
    /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn port_overrides(&self) -> std::option::Option<&[crate::model::PortOverride]> {
        self.port_overrides.as_deref()
    }
}
impl std::fmt::Debug for UpdateEndpointGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEndpointGroupInput");
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.field("endpoint_configurations", &self.endpoint_configurations);
        formatter.field("traffic_dial_percentage", &self.traffic_dial_percentage);
        formatter.field("health_check_port", &self.health_check_port);
        formatter.field("health_check_protocol", &self.health_check_protocol);
        formatter.field("health_check_path", &self.health_check_path);
        formatter.field(
            "health_check_interval_seconds",
            &self.health_check_interval_seconds,
        );
        formatter.field("threshold_count", &self.threshold_count);
        formatter.field("port_overrides", &self.port_overrides);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomRoutingListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The updated port range to support for connections from clients to your accelerator. If you remove ports that are
    /// currently being used by a subnet endpoint, the call fails.</p>
    /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
    /// endpoints for custom routing accelerators</a>.</p>
    pub port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
}
impl UpdateCustomRoutingListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to update.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
    /// <p>The updated port range to support for connections from clients to your accelerator. If you remove ports that are
    /// currently being used by a subnet endpoint, the call fails.</p>
    /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
    /// endpoints for custom routing accelerators</a>.</p>
    pub fn port_ranges(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.port_ranges.as_deref()
    }
}
impl std::fmt::Debug for UpdateCustomRoutingListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomRoutingListenerInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("port_ranges", &self.port_ranges);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomRoutingAcceleratorAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
    /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
    /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub flow_logs_enabled: std::option::Option<bool>,
    /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
    /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
    /// bucket.</p>
    pub flow_logs_s3_bucket: std::option::Option<std::string::String>,
    /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
    /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
    /// <p>If you don’t specify a prefix, the flow logs are stored in the
    /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
    /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
    pub flow_logs_s3_prefix: std::option::Option<std::string::String>,
}
impl UpdateCustomRoutingAcceleratorAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
    /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
    /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn flow_logs_enabled(&self) -> std::option::Option<bool> {
        self.flow_logs_enabled
    }
    /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
    /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
    /// bucket.</p>
    pub fn flow_logs_s3_bucket(&self) -> std::option::Option<&str> {
        self.flow_logs_s3_bucket.as_deref()
    }
    /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
    /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
    /// <p>If you don’t specify a prefix, the flow logs are stored in the
    /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
    /// <p>DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id</p>
    pub fn flow_logs_s3_prefix(&self) -> std::option::Option<&str> {
        self.flow_logs_s3_prefix.as_deref()
    }
}
impl std::fmt::Debug for UpdateCustomRoutingAcceleratorAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomRoutingAcceleratorAttributesInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("flow_logs_enabled", &self.flow_logs_enabled);
        formatter.field("flow_logs_s3_bucket", &self.flow_logs_s3_bucket);
        formatter.field("flow_logs_s3_prefix", &self.flow_logs_s3_prefix);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCustomRoutingAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
    /// hyphens (-), and must not begin or end with a hyphen.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value for the address type must be IPv4.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
    /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    pub enabled: std::option::Option<bool>,
}
impl UpdateCustomRoutingAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
    /// hyphens (-), and must not begin or end with a hyphen.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value for the address type must be IPv4.</p>
    pub fn ip_address_type(&self) -> std::option::Option<&crate::model::IpAddressType> {
        self.ip_address_type.as_ref()
    }
    /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for UpdateCustomRoutingAcceleratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomRoutingAcceleratorInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("name", &self.name);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAcceleratorAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator that you want to update.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
    /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
    /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub flow_logs_enabled: std::option::Option<bool>,
    /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
    /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
    /// bucket.</p>
    pub flow_logs_s3_bucket: std::option::Option<std::string::String>,
    /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
    /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
    /// <p>If you don’t specify a prefix, the flow logs are stored in the
    /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
    /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
    pub flow_logs_s3_prefix: std::option::Option<std::string::String>,
}
impl UpdateAcceleratorAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator that you want to update.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>Update whether flow logs are enabled. The default value is false. If the value is true,
    /// <code>FlowLogsS3Bucket</code> and <code>FlowLogsS3Prefix</code> must be specified.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html">Flow Logs</a> in
    /// the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn flow_logs_enabled(&self) -> std::option::Option<bool> {
        self.flow_logs_enabled
    }
    /// <p>The name of the Amazon S3 bucket for the flow logs. Attribute is required if <code>FlowLogsEnabled</code> is
    /// <code>true</code>. The bucket must exist and have a bucket policy that grants AWS Global Accelerator permission to write to the
    /// bucket.</p>
    pub fn flow_logs_s3_bucket(&self) -> std::option::Option<&str> {
        self.flow_logs_s3_bucket.as_deref()
    }
    /// <p>Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if
    /// <code>FlowLogsEnabled</code> is <code>true</code>. </p>
    /// <p>If you don’t specify a prefix, the flow logs are stored in the
    /// root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:</p>
    /// <p>s3-bucket_name//AWSLogs/aws_account_id</p>
    pub fn flow_logs_s3_prefix(&self) -> std::option::Option<&str> {
        self.flow_logs_s3_prefix.as_deref()
    }
}
impl std::fmt::Debug for UpdateAcceleratorAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAcceleratorAttributesInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("flow_logs_enabled", &self.flow_logs_enabled);
        formatter.field("flow_logs_s3_bucket", &self.flow_logs_s3_bucket);
        formatter.field("flow_logs_s3_prefix", &self.flow_logs_s3_prefix);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
    /// hyphens (-), and must not begin or end with a hyphen.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The IP address type, which must be IPv4.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
    /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    pub enabled: std::option::Option<bool>,
}
impl UpdateAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to update.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>The name of the accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
    /// hyphens (-), and must not begin or end with a hyphen.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The IP address type, which must be IPv4.</p>
    pub fn ip_address_type(&self) -> std::option::Option<&crate::model::IpAddressType> {
        self.ip_address_type.as_ref()
    }
    /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, the accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for UpdateAcceleratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAcceleratorInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("name", &self.name);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to remove tags from. An ARN uniquely identifies a resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag key pairs that you want to remove from the specified resources.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to remove tags from. An ARN uniquely identifies a resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag key pairs that you want to remove from the specified resources.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to add tags to. An ARN uniquely identifies a resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to a resource. A tag consists of a key and a value that you define.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the Global Accelerator resource to add tags to. An ARN uniquely identifies a resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to add to a resource. A tag consists of a key and a value that you define.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveCustomRoutingEndpointsInput {
    /// <p>The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC)
    /// subnet IDs. </p>
    pub endpoint_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
}
impl RemoveCustomRoutingEndpointsInput {
    /// <p>The IDs for the endpoints. For custom routing accelerators, endpoint IDs are the virtual private cloud (VPC)
    /// subnet IDs. </p>
    pub fn endpoint_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.endpoint_ids.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to remove endpoints from.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
}
impl std::fmt::Debug for RemoveCustomRoutingEndpointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveCustomRoutingEndpointsInput");
        formatter.field("endpoint_ids", &self.endpoint_ids);
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionByoipCidrInput {
    /// <p>The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can
    /// specify is /24. The address range cannot overlap with another address range that you've brought
    /// to this or another Region.</p>
    pub cidr: std::option::Option<std::string::String>,
    /// <p>A signed document that proves that you are authorized to bring the specified IP address range to
    /// Amazon using BYOIP.
    /// </p>
    pub cidr_authorization_context: std::option::Option<crate::model::CidrAuthorizationContext>,
}
impl ProvisionByoipCidrInput {
    /// <p>The public IPv4 address range, in CIDR notation. The most specific IP prefix that you can
    /// specify is /24. The address range cannot overlap with another address range that you've brought
    /// to this or another Region.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
    /// <p>A signed document that proves that you are authorized to bring the specified IP address range to
    /// Amazon using BYOIP.
    /// </p>
    pub fn cidr_authorization_context(
        &self,
    ) -> std::option::Option<&crate::model::CidrAuthorizationContext> {
        self.cidr_authorization_context.as_ref()
    }
}
impl std::fmt::Debug for ProvisionByoipCidrInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionByoipCidrInput");
        formatter.field("cidr", &self.cidr);
        formatter.field(
            "cidr_authorization_context",
            &self.cidr_authorization_context,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN uniquely identifies an accelerator.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to list tags for. An ARN uniquely identifies an accelerator.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListListenersInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListListenersInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator for which you want to list listener objects.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListListenersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListListenersInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEndpointGroupsInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEndpointGroupsInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
    /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEndpointGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEndpointGroupsInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomRoutingPortMappingsByDestinationInput {
    /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
    pub endpoint_id: std::option::Option<std::string::String>,
    /// <p>The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port
    /// mappings.</p>
    pub destination_address: std::option::Option<std::string::String>,
    /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCustomRoutingPortMappingsByDestinationInput {
    /// <p>The ID for the virtual private cloud (VPC) subnet.</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
    /// <p>The endpoint IP address in a virtual private cloud (VPC) subnet for which you want to receive back port
    /// mappings.</p>
    pub fn destination_address(&self) -> std::option::Option<&str> {
        self.destination_address.as_deref()
    }
    /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCustomRoutingPortMappingsByDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomRoutingPortMappingsByDestinationInput");
        formatter.field("endpoint_id", &self.endpoint_id);
        formatter.field("destination_address", &self.destination_address);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomRoutingPortMappingsInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
    /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCustomRoutingPortMappingsInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to list the custom routing port mappings for.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to list the custom routing port mappings for.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
    /// <p>The number of destination port mappings that you want to return with this call. The default value is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCustomRoutingPortMappingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomRoutingPortMappingsInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomRoutingListenersInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to list listeners for.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCustomRoutingListenersInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to list listeners for.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>The number of listener objects that you want to return with this call. The default value is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCustomRoutingListenersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomRoutingListenersInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomRoutingEndpointGroupsInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to list endpoint groups for.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCustomRoutingEndpointGroupsInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to list endpoint groups for.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
    /// <p>The number of endpoint group objects that you want to return with this call. The default value is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCustomRoutingEndpointGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomRoutingEndpointGroupsInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomRoutingAcceleratorsInput {
    /// <p>The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCustomRoutingAcceleratorsInput {
    /// <p>The number of custom routing Global Accelerator objects that you want to return with this call. The default value is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCustomRoutingAcceleratorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomRoutingAcceleratorsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListByoipCidrsInput {
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make
    /// another call with the returned <code>nextToken</code> value.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListByoipCidrsInput {
    /// <p>The maximum number of results to return with a single call. To retrieve the remaining results, make
    /// another call with the returned <code>nextToken</code> value.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListByoipCidrsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListByoipCidrsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAcceleratorsInput {
    /// <p>The number of Global Accelerator objects that you want to return with this call. The default value is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAcceleratorsInput {
    /// <p>The number of Global Accelerator objects that you want to return with this call. The default value is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token for the next set of results. You receive this token from a previous call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAcceleratorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAcceleratorsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
    pub listener_arn: std::option::Option<std::string::String>,
}
impl DescribeListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeListenerInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
}
impl DescribeEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeEndpointGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointGroupInput");
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomRoutingListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
    pub listener_arn: std::option::Option<std::string::String>,
}
impl DescribeCustomRoutingListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to describe.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeCustomRoutingListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomRoutingListenerInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomRoutingEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
}
impl DescribeCustomRoutingEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to describe.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeCustomRoutingEndpointGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomRoutingEndpointGroupInput");
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomRoutingAcceleratorAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
}
impl DescribeCustomRoutingAcceleratorAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to describe the attributes for.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeCustomRoutingAcceleratorAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomRoutingAcceleratorAttributesInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomRoutingAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
}
impl DescribeCustomRoutingAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeCustomRoutingAcceleratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomRoutingAcceleratorInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAcceleratorAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator with the attributes that you want to describe.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
}
impl DescribeAcceleratorAttributesInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator with the attributes that you want to describe.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeAcceleratorAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAcceleratorAttributesInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
}
impl DescribeAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator to describe.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeAcceleratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAcceleratorInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeprovisionByoipCidrInput {
    /// <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified
    /// when you provisioned the address range.</p>
    pub cidr: std::option::Option<std::string::String>,
}
impl DeprovisionByoipCidrInput {
    /// <p>The address range, in CIDR notation. The prefix must be the same prefix that you specified
    /// when you provisioned the address range.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
}
impl std::fmt::Debug for DeprovisionByoipCidrInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeprovisionByoipCidrInput");
        formatter.field("cidr", &self.cidr);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DenyCustomRoutingTrafficInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
    /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
    pub endpoint_id: std::option::Option<std::string::String>,
    /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving
    /// traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the
    /// endpoint group.</p>
    pub destination_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from
    /// receiving traffic.</p>
    pub destination_ports: std::option::Option<std::vec::Vec<i32>>,
    /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i>
    /// receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
    /// <p>When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note
    /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
    /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot receive
    /// traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
    /// the same as the ports configured for the endpoint group.</p>
    /// <p>The default value is FALSE.</p>
    pub deny_all_traffic_to_endpoint: std::option::Option<bool>,
}
impl DenyCustomRoutingTrafficInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
    /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
    /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to prevent from receiving
    /// traffic. The IP addresses must be a subset of the IP addresses allowed for the VPC subnet associated with the
    /// endpoint group.</p>
    pub fn destination_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.destination_addresses.as_deref()
    }
    /// <p>A list of specific Amazon EC2 instance ports (destination ports) in a subnet endpoint that you want to prevent from
    /// receiving traffic.</p>
    pub fn destination_ports(&self) -> std::option::Option<&[i32]> {
        self.destination_ports.as_deref()
    }
    /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint <i>cannot</i>
    /// receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
    /// <p>When set to TRUE, <i>no</i> destinations in the custom routing VPC subnet can receive traffic. Note
    /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
    /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that cannot receive
    /// traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
    /// the same as the ports configured for the endpoint group.</p>
    /// <p>The default value is FALSE.</p>
    pub fn deny_all_traffic_to_endpoint(&self) -> std::option::Option<bool> {
        self.deny_all_traffic_to_endpoint
    }
}
impl std::fmt::Debug for DenyCustomRoutingTrafficInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DenyCustomRoutingTrafficInput");
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.field("endpoint_id", &self.endpoint_id);
        formatter.field("destination_addresses", &self.destination_addresses);
        formatter.field("destination_ports", &self.destination_ports);
        formatter.field(
            "deny_all_traffic_to_endpoint",
            &self.deny_all_traffic_to_endpoint,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
}
impl DeleteListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteListenerInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
}
impl DeleteEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteEndpointGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEndpointGroupInput");
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomRoutingListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to delete.</p>
    pub listener_arn: std::option::Option<std::string::String>,
}
impl DeleteCustomRoutingListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the listener to delete.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteCustomRoutingListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomRoutingListenerInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomRoutingEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
}
impl DeleteCustomRoutingEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group to delete.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteCustomRoutingEndpointGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomRoutingEndpointGroupInput");
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomRoutingAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to delete.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
}
impl DeleteCustomRoutingAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of the custom routing accelerator to delete.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteCustomRoutingAcceleratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomRoutingAcceleratorInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of an accelerator.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
}
impl DeleteAcceleratorInput {
    /// <p>The Amazon Resource Name (ARN) of an accelerator.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAcceleratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAcceleratorInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateListenerInput {
    /// <p>The Amazon Resource Name (ARN) of your accelerator.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>The list of port ranges to support for connections from clients to your accelerator.</p>
    pub port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    /// <p>The protocol for connections from clients to your accelerator.</p>
    pub protocol: std::option::Option<crate::model::Protocol>,
    /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
    /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
    /// route each client to the same specific endpoint.</p>
    /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
    /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
    /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
    /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
    /// be always routed to the same endpoint because the hash value changes. </p>
    /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
    /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
    /// source (client) IP address and destination IP address—to select the hash value.</p>
    /// <p>The default value is <code>NONE</code>.</p>
    pub client_affinity: std::option::Option<crate::model::ClientAffinity>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
    /// uniqueness—of the request.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl CreateListenerInput {
    /// <p>The Amazon Resource Name (ARN) of your accelerator.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>The list of port ranges to support for connections from clients to your accelerator.</p>
    pub fn port_ranges(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.port_ranges.as_deref()
    }
    /// <p>The protocol for connections from clients to your accelerator.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::Protocol> {
        self.protocol.as_ref()
    }
    /// <p>Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
    /// regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
    /// route each client to the same specific endpoint.</p>
    /// <p>AWS Global Accelerator uses a consistent-flow hashing algorithm to choose the optimal endpoint for a connection. If client
    /// affinity is <code>NONE</code>, Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP address, source port,
    /// destination IP address, destination port, and protocol—to select the hash value, and then chooses the best
    /// endpoint. However, with this setting, if someone uses different ports to connect to Global Accelerator, their connections might not
    /// be always routed to the same endpoint because the hash value changes. </p>
    /// <p>If you want a given client to always be routed to the same endpoint, set client affinity to <code>SOURCE_IP</code>
    /// instead. When you use the <code>SOURCE_IP</code> setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
    /// source (client) IP address and destination IP address—to select the hash value.</p>
    /// <p>The default value is <code>NONE</code>.</p>
    pub fn client_affinity(&self) -> std::option::Option<&crate::model::ClientAffinity> {
        self.client_affinity.as_ref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
    /// uniqueness—of the request.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for CreateListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateListenerInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("port_ranges", &self.port_ranges);
        formatter.field("protocol", &self.protocol);
        formatter.field("client_affinity", &self.client_affinity);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
    /// specific Region.</p>
    pub endpoint_group_region: std::option::Option<std::string::String>,
    /// <p>The list of endpoint objects.</p>
    pub endpoint_configurations:
        std::option::Option<std::vec::Vec<crate::model::EndpointConfiguration>>,
    /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
    /// this listener. </p>
    /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
    /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
    /// <p>The default value is 100.</p>
    pub traffic_dial_percentage: std::option::Option<f32>,
    /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
    /// is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the
    /// first port in the list.</p>
    pub health_check_port: std::option::Option<i32>,
    /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
    /// value is TCP.</p>
    pub health_check_protocol: std::option::Option<crate::model::HealthCheckProtocol>,
    /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
    /// default value is slash (/).</p>
    pub health_check_path: std::option::Option<std::string::String>,
    /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
    pub health_check_interval_seconds: std::option::Option<i32>,
    /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
    /// unhealthy endpoint to healthy. The default value is 3.</p>
    pub threshold_count: std::option::Option<i32>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
    /// uniqueness—of the request.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
    /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
    /// For example, you can create a port override in which the listener
    /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
    /// and 1443, respectively, on the endpoints.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
    /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub port_overrides: std::option::Option<std::vec::Vec<crate::model::PortOverride>>,
}
impl CreateEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the listener.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
    /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
    /// specific Region.</p>
    pub fn endpoint_group_region(&self) -> std::option::Option<&str> {
        self.endpoint_group_region.as_deref()
    }
    /// <p>The list of endpoint objects.</p>
    pub fn endpoint_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::EndpointConfiguration]> {
        self.endpoint_configurations.as_deref()
    }
    /// <p>The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
    /// this listener. </p>
    /// <p>Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
    /// applied to the traffic that would otherwise have been routed to the Region based on optimal routing.</p>
    /// <p>The default value is 100.</p>
    pub fn traffic_dial_percentage(&self) -> std::option::Option<f32> {
        self.traffic_dial_percentage
    }
    /// <p>The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port
    /// is the listener port that this endpoint group is associated with. If listener port is a list of ports, Global Accelerator uses the
    /// first port in the list.</p>
    pub fn health_check_port(&self) -> std::option::Option<i32> {
        self.health_check_port
    }
    /// <p>The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default
    /// value is TCP.</p>
    pub fn health_check_protocol(&self) -> std::option::Option<&crate::model::HealthCheckProtocol> {
        self.health_check_protocol.as_ref()
    }
    /// <p>If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
    /// default value is slash (/).</p>
    pub fn health_check_path(&self) -> std::option::Option<&str> {
        self.health_check_path.as_deref()
    }
    /// <p>The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.</p>
    pub fn health_check_interval_seconds(&self) -> std::option::Option<i32> {
        self.health_check_interval_seconds
    }
    /// <p>The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
    /// unhealthy endpoint to healthy. The default value is 3.</p>
    pub fn threshold_count(&self) -> std::option::Option<i32> {
        self.threshold_count
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
    /// uniqueness—of the request.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
    /// <p>Override specific listener ports used to route traffic to endpoints that are part of this endpoint group.
    /// For example, you can create a port override in which the listener
    /// receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080
    /// and 1443, respectively, on the endpoints.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html">
    /// Port overrides</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn port_overrides(&self) -> std::option::Option<&[crate::model::PortOverride]> {
        self.port_overrides.as_deref()
    }
}
impl std::fmt::Debug for CreateEndpointGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEndpointGroupInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("endpoint_group_region", &self.endpoint_group_region);
        formatter.field("endpoint_configurations", &self.endpoint_configurations);
        formatter.field("traffic_dial_percentage", &self.traffic_dial_percentage);
        formatter.field("health_check_port", &self.health_check_port);
        formatter.field("health_check_protocol", &self.health_check_protocol);
        formatter.field("health_check_path", &self.health_check_path);
        formatter.field(
            "health_check_interval_seconds",
            &self.health_check_interval_seconds,
        );
        formatter.field("threshold_count", &self.threshold_count);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.field("port_overrides", &self.port_overrides);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomRoutingListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.</p>
    pub accelerator_arn: std::option::Option<std::string::String>,
    /// <p>The port range to support for connections from clients to your accelerator.</p>
    /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
    /// endpoints for custom routing accelerators</a>.</p>
    pub port_ranges: std::option::Option<std::vec::Vec<crate::model::PortRange>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
    /// uniqueness—of the request.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl CreateCustomRoutingListenerInput {
    /// <p>The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.</p>
    pub fn accelerator_arn(&self) -> std::option::Option<&str> {
        self.accelerator_arn.as_deref()
    }
    /// <p>The port range to support for connections from clients to your accelerator.</p>
    /// <p>Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
    /// endpoints for custom routing accelerators</a>.</p>
    pub fn port_ranges(&self) -> std::option::Option<&[crate::model::PortRange]> {
        self.port_ranges.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
    /// uniqueness—of the request.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomRoutingListenerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomRoutingListenerInput");
        formatter.field("accelerator_arn", &self.accelerator_arn);
        formatter.field("port_ranges", &self.port_ranges);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomRoutingEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.</p>
    pub listener_arn: std::option::Option<std::string::String>,
    /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
    /// specific Region.</p>
    pub endpoint_group_region: std::option::Option<std::string::String>,
    /// <p>Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept
    /// client traffic on.</p>
    pub destination_configurations:
        std::option::Option<std::vec::Vec<crate::model::CustomRoutingDestinationConfiguration>>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
    /// uniqueness—of the request.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
}
impl CreateCustomRoutingEndpointGroupInput {
    /// <p>The Amazon Resource Name (ARN) of the listener for a custom routing endpoint.</p>
    pub fn listener_arn(&self) -> std::option::Option<&str> {
        self.listener_arn.as_deref()
    }
    /// <p>The AWS Region where the endpoint group is located. A listener can have only one endpoint group in a
    /// specific Region.</p>
    pub fn endpoint_group_region(&self) -> std::option::Option<&str> {
        self.endpoint_group_region.as_deref()
    }
    /// <p>Sets the port range and protocol for all endpoints (virtual private cloud subnets) in a custom routing endpoint group to accept
    /// client traffic on.</p>
    pub fn destination_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::CustomRoutingDestinationConfiguration]> {
        self.destination_configurations.as_deref()
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
    /// uniqueness—of the request.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomRoutingEndpointGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomRoutingEndpointGroupInput");
        formatter.field("listener_arn", &self.listener_arn);
        formatter.field("endpoint_group_region", &self.endpoint_group_region);
        formatter.field(
            "destination_configurations",
            &self.destination_configurations,
        );
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomRoutingAcceleratorInput {
    /// <p>The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain
    /// only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value for the address type must be IPv4.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
    /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
    /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
    /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
    /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
    /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
    /// accelerator from the AWS IP address pool.</p>
    /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
    /// accelerator with the new addresses.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring
    /// your own IP addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that
    /// is, the uniqueness—of the request.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
    /// <p>Create tags for an accelerator.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
    /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateCustomRoutingAcceleratorInput {
    /// <p>The name of a custom routing accelerator. The name can have a maximum of 64 characters, must contain
    /// only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value for the address type must be IPv4.</p>
    pub fn ip_address_type(&self) -> std::option::Option<&crate::model::IpAddressType> {
        self.ip_address_type.as_ref()
    }
    /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
    /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
    /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
    /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
    /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
    /// accelerator from the AWS IP address pool.</p>
    /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
    /// accelerator with the new addresses.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring
    /// your own IP addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn ip_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.ip_addresses.as_deref()
    }
    /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that
    /// is, the uniqueness—of the request.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
    /// <p>Create tags for an accelerator.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
    /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomRoutingAcceleratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomRoutingAcceleratorInput");
        formatter.field("name", &self.name);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.field("ip_addresses", &self.ip_addresses);
        formatter.field("enabled", &self.enabled);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAcceleratorInput {
    /// <p>The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
    /// hyphens (-), and must not begin or end with a hyphen.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value for the address type must be IPv4.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
    /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
    /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
    /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
    /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
    /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
    /// accelerator from the AWS IP address pool.</p>
    /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
    /// accelerator with the new addresses.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
    /// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub ip_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
    /// uniqueness—of an accelerator.</p>
    pub idempotency_token: std::option::Option<std::string::String>,
    /// <p>Create tags for an accelerator.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
    /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateAcceleratorInput {
    /// <p>The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric characters or
    /// hyphens (-), and must not begin or end with a hyphen.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value for the address type must be IPv4.</p>
    pub fn ip_address_type(&self) -> std::option::Option<&crate::model::IpAddressType> {
        self.ip_address_type.as_ref()
    }
    /// <p>Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
    /// from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
    /// specify one or two addresses, separated by a space. Do not include the /32 suffix.</p>
    /// <p>Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
    /// one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
    /// accelerator from the AWS IP address pool.</p>
    /// <p>Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
    /// accelerator with the new addresses.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own
    /// IP Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn ip_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.ip_addresses.as_deref()
    }
    /// <p>Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
    /// <p>If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
    /// uniqueness—of an accelerator.</p>
    pub fn idempotency_token(&self) -> std::option::Option<&str> {
        self.idempotency_token.as_deref()
    }
    /// <p>Create tags for an accelerator.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging
    /// in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateAcceleratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAcceleratorInput");
        formatter.field("name", &self.name);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.field("ip_addresses", &self.ip_addresses);
        formatter.field("enabled", &self.enabled);
        formatter.field("idempotency_token", &self.idempotency_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AllowCustomRoutingTrafficInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
    /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
    pub endpoint_id: std::option::Option<std::string::String>,
    /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive
    /// traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.</p>
    /// <p>
    /// <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or is
    /// not specified.</p>
    pub destination_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.</p>
    pub destination_ports: std::option::Option<std::vec::Vec<i32>>,
    /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic
    /// from a custom routing accelerator. The value is TRUE or FALSE. </p>
    /// <p>When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note
    /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
    /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed
    /// to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
    /// the same as the ports configured for the endpoint group.</p>
    /// <p>The default value is FALSE.</p>
    pub allow_all_traffic_to_endpoint: std::option::Option<bool>,
}
impl AllowCustomRoutingTrafficInput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint group.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
    /// <p>An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.</p>
    pub fn endpoint_id(&self) -> std::option::Option<&str> {
        self.endpoint_id.as_deref()
    }
    /// <p>A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to receive
    /// traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.</p>
    /// <p>
    /// <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or is
    /// not specified.</p>
    pub fn destination_addresses(&self) -> std::option::Option<&[std::string::String]> {
        self.destination_addresses.as_deref()
    }
    /// <p>A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.</p>
    pub fn destination_ports(&self) -> std::option::Option<&[i32]> {
        self.destination_ports.as_deref()
    }
    /// <p>Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic
    /// from a custom routing accelerator. The value is TRUE or FALSE. </p>
    /// <p>When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note
    /// that you cannot specify destination IP addresses and ports when the value is set to TRUE.</p>
    /// <p>When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed
    /// to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept traffic is
    /// the same as the ports configured for the endpoint group.</p>
    /// <p>The default value is FALSE.</p>
    pub fn allow_all_traffic_to_endpoint(&self) -> std::option::Option<bool> {
        self.allow_all_traffic_to_endpoint
    }
}
impl std::fmt::Debug for AllowCustomRoutingTrafficInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AllowCustomRoutingTrafficInput");
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.field("endpoint_id", &self.endpoint_id);
        formatter.field("destination_addresses", &self.destination_addresses);
        formatter.field("destination_ports", &self.destination_ports);
        formatter.field(
            "allow_all_traffic_to_endpoint",
            &self.allow_all_traffic_to_endpoint,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdvertiseByoipCidrInput {
    /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned.
    /// You can't advertise only a portion of the provisioned range.</p>
    pub cidr: std::option::Option<std::string::String>,
}
impl AdvertiseByoipCidrInput {
    /// <p>The address range, in CIDR notation. This must be the exact range that you provisioned.
    /// You can't advertise only a portion of the provisioned range.</p>
    pub fn cidr(&self) -> std::option::Option<&str> {
        self.cidr.as_deref()
    }
}
impl std::fmt::Debug for AdvertiseByoipCidrInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdvertiseByoipCidrInput");
        formatter.field("cidr", &self.cidr);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddCustomRoutingEndpointsInput {
    /// <p>The list of endpoint objects to add to a custom routing accelerator.</p>
    pub endpoint_configurations:
        std::option::Option<std::vec::Vec<crate::model::CustomRoutingEndpointConfiguration>>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>
    pub endpoint_group_arn: std::option::Option<std::string::String>,
}
impl AddCustomRoutingEndpointsInput {
    /// <p>The list of endpoint objects to add to a custom routing accelerator.</p>
    pub fn endpoint_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::CustomRoutingEndpointConfiguration]> {
        self.endpoint_configurations.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the endpoint group for the custom routing endpoint.</p>
    pub fn endpoint_group_arn(&self) -> std::option::Option<&str> {
        self.endpoint_group_arn.as_deref()
    }
}
impl std::fmt::Debug for AddCustomRoutingEndpointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddCustomRoutingEndpointsInput");
        formatter.field("endpoint_configurations", &self.endpoint_configurations);
        formatter.field("endpoint_group_arn", &self.endpoint_group_arn);
        formatter.finish()
    }
}
